import{s as Yl,n as Nl,o as El}from"../chunks/scheduler.bdbef820.js";import{S as Fl,i as Hl,g as M,s as a,r as c,A as zl,h as o,f as e,c as n,j as Ql,u as p,x as i,k as Bl,y as $l,a as t,v as r,d as y,t as m,w as U}from"../chunks/index.33f81d56.js";import{C as d}from"../chunks/CodeBlock.3bad7fc9.js";import{D as xl}from"../chunks/DocNotebookDropdown.339158fb.js";import{H as Sl,E as ql}from"../chunks/index.e01163b6.js";function Dl(hl){let J,x,z,S,j,q,b,D,w,fl='지식 증류(Knowledge distillation)는 더 크고 복잡한 모델(교사)에서 더 작고 간단한 모델(학생)로 지식을 전달하는 기술입니다. 한 모델에서 다른 모델로 지식을 증류하기 위해, 특정 작업(이 경우 이미지 분류)에 대해 학습된 사전 훈련된 교사 모델을 사용하고, 랜덤으로 초기화된 학생 모델을 이미지 분류 작업에 대해 학습합니다. 그다음, 학생 모델이 교사 모델의 출력을 모방하여 두 모델의 출력 차이를 최소화하도록 훈련합니다. 이 기법은 Hinton 등 연구진의 <a href="https://arxiv.org/abs/1503.02531" rel="nofollow">Distilling the Knowledge in a Neural Network</a>에서 처음 소개되었습니다. 이 가이드에서는 특정 작업에 맞춘 지식 증류를 수행할 것입니다. 이번에는 <a href="https://huggingface.co/datasets/beans" rel="nofollow">beans dataset</a>을 사용할 것입니다.',L,T,Cl='이 가이드는 <a href="https://huggingface.co/merve/vit-mobilenet-beans-224" rel="nofollow">미세 조정된 ViT 모델</a> (교사 모델)을 <a href="https://huggingface.co/google/mobilenet_v2_1.4_224" rel="nofollow">MobileNet</a> (학생 모델)으로 증류하는 방법을 🤗 Transformers의 <a href="https://huggingface.co/docs/transformers/en/main_classes/trainer#trainer" rel="nofollow">Trainer API</a> 를 사용하여 보여줍니다.',O,u,gl="증류와 과정 평가를 위해 필요한 라이브러리를 설치해 봅시다.",K,h,P,f,Zl="이 예제에서는 <code>merve/beans-vit-224</code> 모델을 교사 모델로 사용하고 있습니다. 이 모델은 beans 데이터셋에서 파인 튜닝된 <code>google/vit-base-patch16-224-in21k</code> 기반의 이미지 분류 모델입니다. 이 모델을 무작위로 초기화된 MobileNetV2로 증류해볼 것입니다.",ll,C,Il="이제 데이터셋을 로드하겠습니다.",sl,g,el,Z,Rl="이 경우 두 모델의 이미지 프로세서가 동일한 해상도로 동일한 출력을 반환하기 때문에, 두가지를 모두 사용할 수 있습니다. 데이터셋의 모든 분할마다 전처리를 적용하기 위해 <code>dataset</code>의 <code>map()</code> 메소드를 사용할 것 입니다.",tl,I,al,R,_l="학생 모델(무작위로 초기화된 MobileNet)이 교사 모델(파인 튜닝된 비전 트랜스포머)을 모방하도록 할 것 입니다. 이를 위해 먼저 교사와 학생 모델의 로짓 출력값을 구합니다. 그런 다음 각 출력값을 매개변수 <code>temperature</code> 값으로 나누는데, 이 매개변수는 각 소프트 타겟의 중요도를 조절하는 역할을 합니다. 매개변수 <code>lambda</code> 는 증류 손실의 중요도에 가중치를 줍니다. 이 예제에서는 <code>temperature=5</code>와 <code>lambda=0.5</code>를 사용할 것입니다. 학생과 교사 간의 발산을 계산하기 위해 Kullback-Leibler Divergence 손실을 사용합니다. 두 데이터 P와 Q가 주어졌을 때, KL Divergence는 Q를 사용하여 P를 표현하는 데 얼만큼의 추가 정보가 필요한지를 말해줍니다. 두 데이터가 동일하다면, KL Divergence는 0이며, Q로 P를 설명하는 데 추가 정보가 필요하지 않음을 의미합니다. 따라서 지식 증류의 맥락에서 KL Divergence는 유용합니다.",nl,_,Ml,V,Vl="이제 Hugging Face Hub에 로그인하여 <code>Trainer</code>를 통해 Hugging Face Hub에 모델을 푸시할 수 있도록 하겠습니다.",ol,W,il,k,Wl="이제 <code>TrainingArguments</code>, 교사 모델과 학생 모델을 설정하겠습니다.",cl,G,pl,X,kl="<code>compute_metrics</code> 함수를 사용하여 테스트 세트에서 모델을 평가할 수 있습니다. 이 함수는 훈련 과정에서 모델의 <code>accuracy</code>와 <code>f1</code>을 계산하는 데 사용됩니다.",rl,A,yl,v,Gl="정의한 훈련 인수로 <code>Trainer</code>를 초기화해봅시다. 또한 데이터 콜레이터(data collator)를 초기화하겠습니다.",ml,Q,Ul,B,Xl="이제 모델을 훈련할 수 있습니다.",dl,Y,Jl,N,Al="모델을 테스트 세트에서 평가할 수 있습니다.",jl,E,bl,F,vl='테스트 세트에서 모델의 정확도는 72%에 도달했습니다. 증류의 효율성을 검증하기 위해 동일한 하이퍼파라미터로 beans 데이터셋에서 MobileNet을 처음부터 훈련하였고, 테스트 세트에서의 정확도는 63% 였습니다. 다양한 사전 훈련된 교사 모델, 학생 구조, 증류 매개변수를 시도해보시고 결과를 보고하기를 권장합니다. 증류된 모델의 훈련 로그와 체크포인트는 <a href="https://huggingface.co/merve/vit-mobilenet-beans-224" rel="nofollow">이 저장소</a>에서 찾을 수 있으며, 처음부터 훈련된 MobileNetV2는 이 <a href="https://huggingface.co/merve/resnet-mobilenet-beans-5" rel="nofollow">저장소</a>에서 찾을 수 있습니다.',wl,H,Tl,$,ul;return j=new Sl({props:{title:"컴퓨터 비전을 위한 지식 증류",local:"Knowledge-Distillation-for-Computer-Vision",headingTag:"h1"}}),b=new xl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/knowledge_distillation_for_image_classification.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/knowledge_distillation_for_image_classification.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/knowledge_distillation_for_image_classification.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/knowledge_distillation_for_image_classification.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/knowledge_distillation_for_image_classification.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/knowledge_distillation_for_image_classification.ipynb"}]}}),h=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwYWNjZWxlcmF0ZSUyMHRlbnNvcmJvYXJkJTIwZXZhbHVhdGUlMjAtLXVwZ3JhZGU=",highlighted:"pip install transformers datasets accelerate tensorboard evaluate --upgrade",wrap:!1}}),g=new d({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJiZWFucyUyMik=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;beans&quot;</span>)`,wrap:!1}}),I=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQXRlYWNoZXJfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtZXJ2ZSUyRmJlYW5zLXZpdC0yMjQlMjIpJTBBJTBBZGVmJTIwcHJvY2VzcyhleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjBwcm9jZXNzZWRfaW5wdXRzJTIwJTNEJTIwdGVhY2hlcl9wcm9jZXNzb3IoZXhhbXBsZXMlNUIlMjJpbWFnZSUyMiU1RCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBwcm9jZXNzZWRfaW5wdXRzJTBBJTBBcHJvY2Vzc2VkX2RhdGFzZXRzJTIwJTNEJTIwZGF0YXNldC5tYXAocHJvY2VzcyUyQyUyMGJhdGNoZWQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor
teacher_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;merve/beans-vit-224&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">process</span>(<span class="hljs-params">examples</span>):
    processed_inputs = teacher_processor(examples[<span class="hljs-string">&quot;image&quot;</span>])
    <span class="hljs-keyword">return</span> processed_inputs

processed_datasets = dataset.<span class="hljs-built_in">map</span>(process, batched=<span class="hljs-literal">True</span>)`,wrap:!1}}),_=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ImageDistilTrainer</span>(<span class="hljs-title class_ inherited__">Trainer</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, teacher_model=<span class="hljs-literal">None</span>, student_model=<span class="hljs-literal">None</span>, temperature=<span class="hljs-literal">None</span>, lambda_param=<span class="hljs-literal">None</span>,  *args, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(model=student_model, *args, **kwargs)
        self.teacher = teacher_model
        self.student = student_model
        self.loss_function = nn.KLDivLoss(reduction=<span class="hljs-string">&quot;batchmean&quot;</span>)
        device = torch.device(<span class="hljs-string">&#x27;cuda&#x27;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;cpu&#x27;</span>)
        self.teacher.to(device)
        self.teacher.<span class="hljs-built_in">eval</span>()
        self.temperature = temperature
        self.lambda_param = lambda_param

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_loss</span>(<span class="hljs-params">self, student, inputs, return_outputs=<span class="hljs-literal">False</span></span>):
        student_output = self.student(**inputs)

        <span class="hljs-keyword">with</span> torch.no_grad():
          teacher_output = self.teacher(**inputs)

        <span class="hljs-comment">#  교사와 학생의 소프트 타겟(soft targets) 계산</span>

        soft_teacher = F.softmax(teacher_output.logits / self.temperature, dim=-<span class="hljs-number">1</span>)
        soft_student = F.log_softmax(student_output.logits / self.temperature, dim=-<span class="hljs-number">1</span>)

        <span class="hljs-comment"># 손실(loss) 계산</span>
        distillation_loss = self.loss_function(soft_student, soft_teacher) * (self.temperature ** <span class="hljs-number">2</span>)

        <span class="hljs-comment"># 실제 레이블 손실 계산</span>
        student_target_loss = student_output.loss

        <span class="hljs-comment"># 최종 손실 계산</span>
        loss = (<span class="hljs-number">1.</span> - self.lambda_param) * student_target_loss + self.lambda_param * distillation_loss
        <span class="hljs-keyword">return</span> (loss, student_output) <span class="hljs-keyword">if</span> return_outputs <span class="hljs-keyword">else</span> loss`,wrap:!1}}),W=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),G=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMkMlMjBNb2JpbGVOZXRWMkNvbmZpZyUyQyUyME1vYmlsZU5ldFYyRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEJTIybXktYXdlc29tZS1tb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0QzMCUyQyUwQSUyMCUyMCUyMCUyMGZwMTYlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19kaXIlM0RmJTIyJTdCcmVwb19uYW1lJTdEJTJGbG9ncyUyMiUyQyUwQSUyMCUyMCUyMCUyMGxvZ2dpbmdfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfYmVzdF9tb2RlbF9hdF9lbmQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbWV0cmljX2Zvcl9iZXN0X21vZGVsJTNEJTIyYWNjdXJhY3klMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvcnRfdG8lM0QlMjJ0ZW5zb3Jib2FyZCUyMiUyQyUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGh1Yl9zdHJhdGVneSUzRCUyMmV2ZXJ5X3NhdmUlMjIlMkMlMEElMjAlMjAlMjAlMjBodWJfbW9kZWxfaWQlM0RyZXBvX25hbWUlMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBbnVtX2xhYmVscyUyMCUzRCUyMGxlbihwcm9jZXNzZWRfZGF0YXNldHMlNUIlMjJ0cmFpbiUyMiU1RC5mZWF0dXJlcyU1QiUyMmxhYmVscyUyMiU1RC5uYW1lcyklMEElMEElMjMlMjAlRUIlQUElQTglRUIlOEQlQjglMjAlRUMlQjQlODglRUElQjglQjAlRUQlOTklOTQlMEF0ZWFjaGVyX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWVydmUlMkZiZWFucy12aXQtMjI0JTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMlMkMlMEElMjAlMjAlMjAlMjBpZ25vcmVfbWlzbWF0Y2hlZF9zaXplcyUzRFRydWUlMEEpJTBBJTBBJTIzJTIwTW9iaWxlTmV0VjIlMjAlRUIlQjAlOTElRUIlQjAlOTQlRUIlOEIlQTUlRUIlQjYlODAlRUQlODQlQjAlMjAlRUQlOTUlOTklRUMlOEElQjUlMEFzdHVkZW50X2NvbmZpZyUyMCUzRCUyME1vYmlsZU5ldFYyQ29uZmlnKCklMEFzdHVkZW50X2NvbmZpZy5udW1fbGFiZWxzJTIwJTNEJTIwbnVtX2xhYmVscyUwQXN0dWRlbnRfbW9kZWwlMjAlM0QlMjBNb2JpbGVOZXRWMkZvckltYWdlQ2xhc3NpZmljYXRpb24oc3R1ZGVudF9jb25maWcp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification, MobileNetV2Config, MobileNetV2ForImageClassification

training_args = TrainingArguments(
    output_dir=<span class="hljs-string">&quot;my-awesome-model&quot;</span>,
    num_train_epochs=<span class="hljs-number">30</span>,
    fp16=<span class="hljs-literal">True</span>,
    logging_dir=<span class="hljs-string">f&quot;<span class="hljs-subst">{repo_name}</span>/logs&quot;</span>,
    logging_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    metric_for_best_model=<span class="hljs-string">&quot;accuracy&quot;</span>,
    report_to=<span class="hljs-string">&quot;tensorboard&quot;</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
    hub_strategy=<span class="hljs-string">&quot;every_save&quot;</span>,
    hub_model_id=repo_name,
    )

num_labels = <span class="hljs-built_in">len</span>(processed_datasets[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;labels&quot;</span>].names)

<span class="hljs-comment"># 모델 초기화</span>
teacher_model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;merve/beans-vit-224&quot;</span>,
    num_labels=num_labels,
    ignore_mismatched_sizes=<span class="hljs-literal">True</span>
)

<span class="hljs-comment"># MobileNetV2 밑바닥부터 학습</span>
student_config = MobileNetV2Config()
student_config.num_labels = num_labels
student_model = MobileNetV2ForImageClassification(student_config)`,wrap:!1}}),A=new d({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEElMEFhY2N1cmFjeSUyMCUzRCUyMGV2YWx1YXRlLmxvYWQoJTIyYWNjdXJhY3klMjIpJTBBJTBBZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyQyUyMGxhYmVscyUyMCUzRCUyMGV2YWxfcHJlZCUwQSUyMCUyMCUyMCUyMGFjYyUyMCUzRCUyMGFjY3VyYWN5LmNvbXB1dGUocmVmZXJlbmNlcyUzRGxhYmVscyUyQyUyMHByZWRpY3Rpb25zJTNEbnAuYXJnbWF4KHByZWRpY3Rpb25zJTJDJTIwYXhpcyUzRDEpKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmFjY3VyYWN5JTIyJTNBJTIwYWNjJTVCJTIyYWNjdXJhY3klMjIlNUQlN0Q=",highlighted:`<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

accuracy = evaluate.load(<span class="hljs-string">&quot;accuracy&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions, labels = eval_pred
    acc = accuracy.compute(references=labels, predictions=np.argmax(predictions, axis=<span class="hljs-number">1</span>))
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;accuracy&quot;</span>: acc[<span class="hljs-string">&quot;accuracy&quot;</span>]}`,wrap:!1}}),Q=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlZmF1bHREYXRhQ29sbGF0b3IlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGVmYXVsdERhdGFDb2xsYXRvcigpJTBBdHJhaW5lciUyMCUzRCUyMEltYWdlRGlzdGlsVHJhaW5lciglMEElMjAlMjAlMjAlMjBzdHVkZW50X21vZGVsJTNEc3R1ZGVudF9tb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRlYWNoZXJfbW9kZWwlM0R0ZWFjaGVyX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5pbmdfYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEcHJvY2Vzc2VkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0Rwcm9jZXNzZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0ZWFjaGVyX3Byb2Nlc3NvciUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSUyMCUyMCUyMCUyMHRlbXBlcmF0dXJlJTNENSUyQyUwQSUyMCUyMCUyMCUyMGxhbWJkYV9wYXJhbSUzRDAuNSUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DefaultDataCollator

data_collator = DefaultDataCollator()
trainer = ImageDistilTrainer(
    student_model=student_model,
    teacher_model=teacher_model,
    training_args=training_args,
    train_dataset=processed_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=processed_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    tokenizer=teacher_processor,
    compute_metrics=compute_metrics,
    temperature=<span class="hljs-number">5</span>,
    lambda_param=<span class="hljs-number">0.5</span>
)`,wrap:!1}}),Y=new d({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),E=new d({props:{code:"dHJhaW5lci5ldmFsdWF0ZShwcm9jZXNzZWRfZGF0YXNldHMlNUIlMjJ0ZXN0JTIyJTVEKQ==",highlighted:'trainer.evaluate(processed_datasets[<span class="hljs-string">&quot;test&quot;</span>])',wrap:!1}}),H=new ql({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ko/tasks/knowledge_distillation_for_image_classification.md"}}),{c(){J=M("meta"),x=a(),z=M("p"),S=a(),c(j.$$.fragment),q=a(),c(b.$$.fragment),D=a(),w=M("p"),w.innerHTML=fl,L=a(),T=M("p"),T.innerHTML=Cl,O=a(),u=M("p"),u.textContent=gl,K=a(),c(h.$$.fragment),P=a(),f=M("p"),f.innerHTML=Zl,ll=a(),C=M("p"),C.textContent=Il,sl=a(),c(g.$$.fragment),el=a(),Z=M("p"),Z.innerHTML=Rl,tl=a(),c(I.$$.fragment),al=a(),R=M("p"),R.innerHTML=_l,nl=a(),c(_.$$.fragment),Ml=a(),V=M("p"),V.innerHTML=Vl,ol=a(),c(W.$$.fragment),il=a(),k=M("p"),k.innerHTML=Wl,cl=a(),c(G.$$.fragment),pl=a(),X=M("p"),X.innerHTML=kl,rl=a(),c(A.$$.fragment),yl=a(),v=M("p"),v.innerHTML=Gl,ml=a(),c(Q.$$.fragment),Ul=a(),B=M("p"),B.textContent=Xl,dl=a(),c(Y.$$.fragment),Jl=a(),N=M("p"),N.textContent=Al,jl=a(),c(E.$$.fragment),bl=a(),F=M("p"),F.innerHTML=vl,wl=a(),c(H.$$.fragment),Tl=a(),$=M("p"),this.h()},l(l){const s=zl("svelte-u9bgzb",document.head);J=o(s,"META",{name:!0,content:!0}),s.forEach(e),x=n(l),z=o(l,"P",{}),Ql(z).forEach(e),S=n(l),p(j.$$.fragment,l),q=n(l),p(b.$$.fragment,l),D=n(l),w=o(l,"P",{"data-svelte-h":!0}),i(w)!=="svelte-kxtn0m"&&(w.innerHTML=fl),L=n(l),T=o(l,"P",{"data-svelte-h":!0}),i(T)!=="svelte-lfi6hh"&&(T.innerHTML=Cl),O=n(l),u=o(l,"P",{"data-svelte-h":!0}),i(u)!=="svelte-ygk0g8"&&(u.textContent=gl),K=n(l),p(h.$$.fragment,l),P=n(l),f=o(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-1qprelr"&&(f.innerHTML=Zl),ll=n(l),C=o(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-14y69rq"&&(C.textContent=Il),sl=n(l),p(g.$$.fragment,l),el=n(l),Z=o(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-2p2vew"&&(Z.innerHTML=Rl),tl=n(l),p(I.$$.fragment,l),al=n(l),R=o(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-19evrte"&&(R.innerHTML=_l),nl=n(l),p(_.$$.fragment,l),Ml=n(l),V=o(l,"P",{"data-svelte-h":!0}),i(V)!=="svelte-oa95y1"&&(V.innerHTML=Vl),ol=n(l),p(W.$$.fragment,l),il=n(l),k=o(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-kjqxln"&&(k.innerHTML=Wl),cl=n(l),p(G.$$.fragment,l),pl=n(l),X=o(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-r2y3qw"&&(X.innerHTML=kl),rl=n(l),p(A.$$.fragment,l),yl=n(l),v=o(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-14xlufw"&&(v.innerHTML=Gl),ml=n(l),p(Q.$$.fragment,l),Ul=n(l),B=o(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1h17qip"&&(B.textContent=Xl),dl=n(l),p(Y.$$.fragment,l),Jl=n(l),N=o(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-j0rcws"&&(N.textContent=Al),jl=n(l),p(E.$$.fragment,l),bl=n(l),F=o(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-ujiqpr"&&(F.innerHTML=vl),wl=n(l),p(H.$$.fragment,l),Tl=n(l),$=o(l,"P",{}),Ql($).forEach(e),this.h()},h(){Bl(J,"name","hf:doc:metadata"),Bl(J,"content",Ll)},m(l,s){$l(document.head,J),t(l,x,s),t(l,z,s),t(l,S,s),r(j,l,s),t(l,q,s),r(b,l,s),t(l,D,s),t(l,w,s),t(l,L,s),t(l,T,s),t(l,O,s),t(l,u,s),t(l,K,s),r(h,l,s),t(l,P,s),t(l,f,s),t(l,ll,s),t(l,C,s),t(l,sl,s),r(g,l,s),t(l,el,s),t(l,Z,s),t(l,tl,s),r(I,l,s),t(l,al,s),t(l,R,s),t(l,nl,s),r(_,l,s),t(l,Ml,s),t(l,V,s),t(l,ol,s),r(W,l,s),t(l,il,s),t(l,k,s),t(l,cl,s),r(G,l,s),t(l,pl,s),t(l,X,s),t(l,rl,s),r(A,l,s),t(l,yl,s),t(l,v,s),t(l,ml,s),r(Q,l,s),t(l,Ul,s),t(l,B,s),t(l,dl,s),r(Y,l,s),t(l,Jl,s),t(l,N,s),t(l,jl,s),r(E,l,s),t(l,bl,s),t(l,F,s),t(l,wl,s),r(H,l,s),t(l,Tl,s),t(l,$,s),ul=!0},p:Nl,i(l){ul||(y(j.$$.fragment,l),y(b.$$.fragment,l),y(h.$$.fragment,l),y(g.$$.fragment,l),y(I.$$.fragment,l),y(_.$$.fragment,l),y(W.$$.fragment,l),y(G.$$.fragment,l),y(A.$$.fragment,l),y(Q.$$.fragment,l),y(Y.$$.fragment,l),y(E.$$.fragment,l),y(H.$$.fragment,l),ul=!0)},o(l){m(j.$$.fragment,l),m(b.$$.fragment,l),m(h.$$.fragment,l),m(g.$$.fragment,l),m(I.$$.fragment,l),m(_.$$.fragment,l),m(W.$$.fragment,l),m(G.$$.fragment,l),m(A.$$.fragment,l),m(Q.$$.fragment,l),m(Y.$$.fragment,l),m(E.$$.fragment,l),m(H.$$.fragment,l),ul=!1},d(l){l&&(e(x),e(z),e(S),e(q),e(D),e(w),e(L),e(T),e(O),e(u),e(K),e(P),e(f),e(ll),e(C),e(sl),e(el),e(Z),e(tl),e(al),e(R),e(nl),e(Ml),e(V),e(ol),e(il),e(k),e(cl),e(pl),e(X),e(rl),e(yl),e(v),e(ml),e(Ul),e(B),e(dl),e(Jl),e(N),e(jl),e(bl),e(F),e(wl),e(Tl),e($)),e(J),U(j,l),U(b,l),U(h,l),U(g,l),U(I,l),U(_,l),U(W,l),U(G,l),U(A,l),U(Q,l),U(Y,l),U(E,l),U(H,l)}}}const Ll='{"title":"컴퓨터 비전을 위한 지식 증류","local":"Knowledge-Distillation-for-Computer-Vision","sections":[],"depth":1}';function Ol(hl){return El(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ts extends Fl{constructor(J){super(),Hl(this,J,Ol,Dl,Yl,{})}}export{ts as component};
