import{s as Ut,n as Zt,o as Ct}from"../chunks/scheduler.defa9a21.js";import{S as kt,i as Xt,g as s,s as a,r as d,A as zt,h as o,f as l,c as i,j as jt,u as m,x as p,k as Gt,y as xt,a as n,v as r,d as u,t as f,w as c}from"../chunks/index.fe795e71.js";import{C as b}from"../chunks/CodeBlock.42404125.js";import{H as g,E as Rt}from"../chunks/EditOnGithub.0f575778.js";function qt(tt){let h,de,oe,me,w,re,M,ue,y,lt="Accelerate brings <code>bitsandbytes</code> quantization to your model. You can now load any pytorch model in 8-bit or 4-bit with a few lines of code.",fe,$,nt='If you want to use Transformers models with <code>bitsandbytes</code>, you should follow this <a href="https://huggingface.co/docs/transformers/main_classes/quantization" rel="nofollow">documentation</a>.',ce,T,at='To learn more about how the <code>bitsandbytes</code> quantization works, check out the blog posts on <a href="https://huggingface.co/blog/hf-bitsandbytes-integration" rel="nofollow">8-bit quantization</a> and <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">4-bit quantization</a>.',be,_,he,J,it="You will need to install the following requirements:",ge,v,st="<li>Install <code>bitsandbytes</code> library</li>",we,j,Me,G,ot="<li>Install latest <code>accelerate</code> from source</li>",ye,U,$e,Z,pt="<li>Install <code>minGPT</code> and <code>huggingface_hub</code> to run examples</li>",Te,C,_e,k,Je,X,dt='First, we need to initialize our model. To save memory, we can initialize an empty model using the context manager <a href="/docs/accelerate/v1.0.0/en/package_reference/big_modeling#accelerate.init_empty_weights">init_empty_weights()</a>.',ve,z,mt="Let’s take the GPT2 model from minGPT library.",je,x,Ge,R,rt="Then, we need to get the path to the weights of your model. The path can be the state_dict file (e.g. “pytorch_model.bin”) or a folder containing the sharded checkpoints.",Ue,q,Ze,W,ut='Finally, you need to set your quantization configuration with <a href="/docs/accelerate/v1.0.0/en/package_reference/utilities#accelerate.utils.BnbQuantizationConfig">BnbQuantizationConfig</a>.',Ce,B,ft="Here’s an example for 8-bit quantization:",ke,H,Xe,Y,ct="Here’s an example for 4-bit quantization:",ze,F,xe,I,bt='To quantize your empty model with the selected configuration, you need to use <a href="/docs/accelerate/v1.0.0/en/package_reference/utilities#accelerate.utils.load_and_quantize_model">load_and_quantize_model()</a>.',Re,P,qe,V,We,L,ht='You can save your 8-bit model with accelerate using <a href="/docs/accelerate/v1.0.0/en/package_reference/accelerator#accelerate.Accelerator.save_model">save_model()</a>.',Be,Q,He,N,gt="Note that 4-bit model serialization is currently not supported.",Ye,A,Fe,E,wt=`You can offload some modules to cpu/disk if you don’t have enough space on the GPU to store the entire model on your GPUs.
This uses big model inference under the hood. Check this <a href="https://huggingface.co/docs/accelerate/usage_guides/big_modeling" rel="nofollow">documentation</a> for more details.`,Ie,S,Mt="For 8-bit quantization, the selected modules will be converted to 8-bit precision.",Pe,D,yt="For 4-bit quantization, the selected modules will be kept in <code>torch_dtype</code> that the user passed in <code>BnbQuantizationConfig</code>.  We will add support to convert these offloaded modules in 4-bit when 4-bit serialization will be possible.",Ve,K,$t="You just need to pass a custom <code>device_map</code> in order to offload modules on cpu/disk. The offload modules will be dispatched on the GPU when needed. Here’s an example :",Le,O,Qe,ee,Ne,te,Tt='It is not possible to perform pure 8bit or 4bit training on these models. However, you can train these models by leveraging parameter efficient fine tuning methods (PEFT) and train for example adapters on top of them. Please have a look at <a href="https://github.com/huggingface/peft" rel="nofollow">peft</a> library for more details.',Ae,le,_t='Currently, you can’t add adapters on top of any quantized model. However, with the official support of adapters with Transformers models, you can fine-tune quantized models. If you want to finetune a Transformers model , follow this <a href="https://huggingface.co/docs/transformers/main_classes/quantization" rel="nofollow">documentation</a> instead. Check out this <a href="https://colab.research.google.com/drive/1VoYNfYDKcKRQRor98Zbf2-9VQTtGJ24k?usp=sharing" rel="nofollow">demo</a> on how to fine-tune a 4-bit Transformers model.',Ee,ne,Jt="Note that you don’t need to pass <code>device_map</code> when loading the model for training. It will automatically load your model on your GPU. Please note that <code>device_map=auto</code> should be used for inference only.",Se,ae,De,ie,vt='Check out the Google Colab <a href="https://colab.research.google.com/drive/1T1pOgewAWVpR9gKpaEWw4orOrzPFb3yM?usp=sharing" rel="nofollow">demo</a> for running quantized models on a GTP2 model. The GPT2-1.5B model checkpoint is in FP32 which uses 6GB of memory. After quantization, it uses 1.6GB with 8-bit modules and 1.2GB with 4-bit modules.',Ke,se,Oe,pe,et;return w=new g({props:{title:"Model quantization",local:"model-quantization",headingTag:"h1"}}),M=new g({props:{title:"bitsandbytes Integration",local:"bitsandbytes-integration",headingTag:"h2"}}),_=new g({props:{title:"Pre-Requisites",local:"pre-requisites",headingTag:"h3"}}),j=new b({props:{code:"cGlwJTIwaW5zdGFsbCUyMGJpdHNhbmRieXRlcw==",highlighted:"pip install bitsandbytes",wrap:!1}}),U=new b({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGYWNjZWxlcmF0ZS5naXQ=",highlighted:"pip install git+https://github.com/huggingface/accelerate.git",wrap:!1}}),C=new b({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZrYXJwYXRoeSUyRm1pbkdQVC5naXQlMEFwaXAlMjBpbnN0YWxsJTIwbWluR1BUJTJGJTBBcGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlX2h1Yg==",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/karpathy/minGPT.git
pip install minGPT/
pip install huggingface_hub`,wrap:!1}}),k=new g({props:{title:"How it works",local:"how-it-works",headingTag:"h3"}}),x=new b({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbml0X2VtcHR5X3dlaWdodHMlMEFmcm9tJTIwbWluZ3B0Lm1vZGVsJTIwaW1wb3J0JTIwR1BUJTBBJTBBbW9kZWxfY29uZmlnJTIwJTNEJTIwR1BULmdldF9kZWZhdWx0X2NvbmZpZygpJTBBbW9kZWxfY29uZmlnLm1vZGVsX3R5cGUlMjAlM0QlMjAnZ3B0Mi14bCclMEFtb2RlbF9jb25maWcudm9jYWJfc2l6ZSUyMCUzRCUyMDUwMjU3JTBBbW9kZWxfY29uZmlnLmJsb2NrX3NpemUlMjAlM0QlMjAxMDI0JTBBJTBBd2l0aCUyMGluaXRfZW1wdHlfd2VpZ2h0cygpJTNBJTBBJTIwJTIwJTIwJTIwZW1wdHlfbW9kZWwlMjAlM0QlMjBHUFQobW9kZWxfY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights
<span class="hljs-keyword">from</span> mingpt.model <span class="hljs-keyword">import</span> GPT

model_config = GPT.get_default_config()
model_config.model_type = <span class="hljs-string">&#x27;gpt2-xl&#x27;</span>
model_config.vocab_size = <span class="hljs-number">50257</span>
model_config.block_size = <span class="hljs-number">1024</span>

<span class="hljs-keyword">with</span> init_empty_weights():
    empty_model = GPT(model_config)`,wrap:!1}}),q=new b({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBd2VpZ2h0c19sb2NhdGlvbiUyMCUzRCUyMHNuYXBzaG90X2Rvd25sb2FkKHJlcG9faWQlM0QlMjJtYXJjc3VuMTMlMkZncHQyLXhsLWxpbmVhci1zaGFyZGVkJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
weights_location = snapshot_download(repo_id=<span class="hljs-string">&quot;marcsun13/gpt2-xl-linear-sharded&quot;</span>)`,wrap:!1}}),H=new b({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjBCbmJRdWFudGl6YXRpb25Db25maWclMEFibmJfcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJuYlF1YW50aXphdGlvbkNvbmZpZyhsb2FkX2luXzhiaXQlM0RUcnVlJTJDJTIwbGxtX2ludDhfdGhyZXNob2xkJTIwJTNEJTIwNik=",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> BnbQuantizationConfig
bnb_quantization_config = BnbQuantizationConfig(load_in_8bit=<span class="hljs-literal">True</span>, llm_int8_threshold = <span class="hljs-number">6</span>)`,wrap:!1}}),F=new b({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjBCbmJRdWFudGl6YXRpb25Db25maWclMEFibmJfcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJuYlF1YW50aXphdGlvbkNvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> BnbQuantizationConfig
bnb_quantization_config = BnbQuantizationConfig(load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_compute_dtype=torch.bfloat16, bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>, bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>)`,wrap:!1}}),P=new b({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2FuZF9xdWFudGl6ZV9tb2RlbCUwQXF1YW50aXplZF9tb2RlbCUyMCUzRCUyMGxvYWRfYW5kX3F1YW50aXplX21vZGVsKGVtcHR5X21vZGVsJTJDJTIwd2VpZ2h0c19sb2NhdGlvbiUzRHdlaWdodHNfbG9jYXRpb24lMkMlMjBibmJfcXVhbnRpemF0aW9uX2NvbmZpZyUzRGJuYl9xdWFudGl6YXRpb25fY29uZmlnJTJDJTIwZGV2aWNlX21hcCUyMCUzRCUyMCUyMmF1dG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> load_and_quantize_model
quantized_model = load_and_quantize_model(empty_model, weights_location=weights_location, bnb_quantization_config=bnb_quantization_config, device_map = <span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),V=new g({props:{title:"Saving and loading 8-bit model",local:"saving-and-loading-8-bit-model",headingTag:"h3"}}),Q=new b({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWFjY2VsZXJhdGUlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBbmV3X3dlaWdodHNfbG9jYXRpb24lMjAlM0QlMjAlMjJwYXRoJTJGdG8lMkZzYXZlX2RpcmVjdG9yeSUyMiUwQWFjY2VsZXJhdGUuc2F2ZV9tb2RlbChxdWFudGl6ZWRfbW9kZWwlMkMlMjBuZXdfd2VpZ2h0c19sb2NhdGlvbiklMEElMEFxdWFudGl6ZWRfbW9kZWxfZnJvbV9zYXZlZCUyMCUzRCUyMGxvYWRfYW5kX3F1YW50aXplX21vZGVsKGVtcHR5X21vZGVsJTJDJTIwd2VpZ2h0c19sb2NhdGlvbiUzRG5ld193ZWlnaHRzX2xvY2F0aW9uJTJDJTIwYm5iX3F1YW50aXphdGlvbl9jb25maWclM0RibmJfcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUyMGRldmljZV9tYXAlMjAlM0QlMjAlMjJhdXRvJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
accelerate = Accelerator()
new_weights_location = <span class="hljs-string">&quot;path/to/save_directory&quot;</span>
accelerate.save_model(quantized_model, new_weights_location)

quantized_model_from_saved = load_and_quantize_model(empty_model, weights_location=new_weights_location, bnb_quantization_config=bnb_quantization_config, device_map = <span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),A=new g({props:{title:"Offload modules to cpu and disk",local:"offload-modules-to-cpu-and-disk",headingTag:"h3"}}),O=new b({props:{code:"ZGV2aWNlX21hcCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVyLnd0ZSUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lci53cGUlMjIlM0ElMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNmb3JtZXIuZHJvcCUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lci5oJTIyJTNBJTIwJTIyY3B1JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNmb3JtZXIubG5fZiUyMiUzQSUyMCUyMmRpc2slMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJsbV9oZWFkJTIyJTNBJTIwJTIyZGlzayUyMiUyQyUwQSU3RA==",highlighted:`device_map = {
    <span class="hljs-string">&quot;transformer.wte&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;transformer.wpe&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;transformer.drop&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;transformer.h&quot;</span>: <span class="hljs-string">&quot;cpu&quot;</span>,
    <span class="hljs-string">&quot;transformer.ln_f&quot;</span>: <span class="hljs-string">&quot;disk&quot;</span>,
    <span class="hljs-string">&quot;lm_head&quot;</span>: <span class="hljs-string">&quot;disk&quot;</span>,
}`,wrap:!1}}),ee=new g({props:{title:"Fine-tune a quantized model",local:"fine-tune-a-quantized-model",headingTag:"h3"}}),ae=new g({props:{title:"Example demo - running GPT2 1.5b on a Google Colab",local:"example-demo---running-gpt2-15b-on-a-google-colab",headingTag:"h3"}}),se=new Rt({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/usage_guides/quantization.md"}}),{c(){h=s("meta"),de=a(),oe=s("p"),me=a(),d(w.$$.fragment),re=a(),d(M.$$.fragment),ue=a(),y=s("p"),y.innerHTML=lt,fe=a(),$=s("p"),$.innerHTML=nt,ce=a(),T=s("p"),T.innerHTML=at,be=a(),d(_.$$.fragment),he=a(),J=s("p"),J.textContent=it,ge=a(),v=s("ul"),v.innerHTML=st,we=a(),d(j.$$.fragment),Me=a(),G=s("ul"),G.innerHTML=ot,ye=a(),d(U.$$.fragment),$e=a(),Z=s("ul"),Z.innerHTML=pt,Te=a(),d(C.$$.fragment),_e=a(),d(k.$$.fragment),Je=a(),X=s("p"),X.innerHTML=dt,ve=a(),z=s("p"),z.textContent=mt,je=a(),d(x.$$.fragment),Ge=a(),R=s("p"),R.textContent=rt,Ue=a(),d(q.$$.fragment),Ze=a(),W=s("p"),W.innerHTML=ut,Ce=a(),B=s("p"),B.textContent=ft,ke=a(),d(H.$$.fragment),Xe=a(),Y=s("p"),Y.textContent=ct,ze=a(),d(F.$$.fragment),xe=a(),I=s("p"),I.innerHTML=bt,Re=a(),d(P.$$.fragment),qe=a(),d(V.$$.fragment),We=a(),L=s("p"),L.innerHTML=ht,Be=a(),d(Q.$$.fragment),He=a(),N=s("p"),N.textContent=gt,Ye=a(),d(A.$$.fragment),Fe=a(),E=s("p"),E.innerHTML=wt,Ie=a(),S=s("p"),S.textContent=Mt,Pe=a(),D=s("p"),D.innerHTML=yt,Ve=a(),K=s("p"),K.innerHTML=$t,Le=a(),d(O.$$.fragment),Qe=a(),d(ee.$$.fragment),Ne=a(),te=s("p"),te.innerHTML=Tt,Ae=a(),le=s("p"),le.innerHTML=_t,Ee=a(),ne=s("p"),ne.innerHTML=Jt,Se=a(),d(ae.$$.fragment),De=a(),ie=s("p"),ie.innerHTML=vt,Ke=a(),d(se.$$.fragment),Oe=a(),pe=s("p"),this.h()},l(e){const t=zt("svelte-u9bgzb",document.head);h=o(t,"META",{name:!0,content:!0}),t.forEach(l),de=i(e),oe=o(e,"P",{}),jt(oe).forEach(l),me=i(e),m(w.$$.fragment,e),re=i(e),m(M.$$.fragment,e),ue=i(e),y=o(e,"P",{"data-svelte-h":!0}),p(y)!=="svelte-1uk3wou"&&(y.innerHTML=lt),fe=i(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1p54xze"&&($.innerHTML=nt),ce=i(e),T=o(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-hrid2v"&&(T.innerHTML=at),be=i(e),m(_.$$.fragment,e),he=i(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-50fa4n"&&(J.textContent=it),ge=i(e),v=o(e,"UL",{"data-svelte-h":!0}),p(v)!=="svelte-t2geh8"&&(v.innerHTML=st),we=i(e),m(j.$$.fragment,e),Me=i(e),G=o(e,"UL",{"data-svelte-h":!0}),p(G)!=="svelte-l0cm28"&&(G.innerHTML=ot),ye=i(e),m(U.$$.fragment,e),$e=i(e),Z=o(e,"UL",{"data-svelte-h":!0}),p(Z)!=="svelte-1c2t6dx"&&(Z.innerHTML=pt),Te=i(e),m(C.$$.fragment,e),_e=i(e),m(k.$$.fragment,e),Je=i(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-ns14vh"&&(X.innerHTML=dt),ve=i(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1fwkss5"&&(z.textContent=mt),je=i(e),m(x.$$.fragment,e),Ge=i(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-bbyjp5"&&(R.textContent=rt),Ue=i(e),m(q.$$.fragment,e),Ze=i(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-yrfoqx"&&(W.innerHTML=ut),Ce=i(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-4hyyr7"&&(B.textContent=ft),ke=i(e),m(H.$$.fragment,e),Xe=i(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1qtcdkv"&&(Y.textContent=ct),ze=i(e),m(F.$$.fragment,e),xe=i(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-8207od"&&(I.innerHTML=bt),Re=i(e),m(P.$$.fragment,e),qe=i(e),m(V.$$.fragment,e),We=i(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-15m9osb"&&(L.innerHTML=ht),Be=i(e),m(Q.$$.fragment,e),He=i(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1x0s82b"&&(N.textContent=gt),Ye=i(e),m(A.$$.fragment,e),Fe=i(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1vy35js"&&(E.innerHTML=wt),Ie=i(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-11qxtld"&&(S.textContent=Mt),Pe=i(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-qaw7ck"&&(D.innerHTML=yt),Ve=i(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-gyjts5"&&(K.innerHTML=$t),Le=i(e),m(O.$$.fragment,e),Qe=i(e),m(ee.$$.fragment,e),Ne=i(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-rtwtrf"&&(te.innerHTML=Tt),Ae=i(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-phiimi"&&(le.innerHTML=_t),Ee=i(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1n8dj9v"&&(ne.innerHTML=Jt),Se=i(e),m(ae.$$.fragment,e),De=i(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-10ut0yg"&&(ie.innerHTML=vt),Ke=i(e),m(se.$$.fragment,e),Oe=i(e),pe=o(e,"P",{}),jt(pe).forEach(l),this.h()},h(){Gt(h,"name","hf:doc:metadata"),Gt(h,"content",Wt)},m(e,t){xt(document.head,h),n(e,de,t),n(e,oe,t),n(e,me,t),r(w,e,t),n(e,re,t),r(M,e,t),n(e,ue,t),n(e,y,t),n(e,fe,t),n(e,$,t),n(e,ce,t),n(e,T,t),n(e,be,t),r(_,e,t),n(e,he,t),n(e,J,t),n(e,ge,t),n(e,v,t),n(e,we,t),r(j,e,t),n(e,Me,t),n(e,G,t),n(e,ye,t),r(U,e,t),n(e,$e,t),n(e,Z,t),n(e,Te,t),r(C,e,t),n(e,_e,t),r(k,e,t),n(e,Je,t),n(e,X,t),n(e,ve,t),n(e,z,t),n(e,je,t),r(x,e,t),n(e,Ge,t),n(e,R,t),n(e,Ue,t),r(q,e,t),n(e,Ze,t),n(e,W,t),n(e,Ce,t),n(e,B,t),n(e,ke,t),r(H,e,t),n(e,Xe,t),n(e,Y,t),n(e,ze,t),r(F,e,t),n(e,xe,t),n(e,I,t),n(e,Re,t),r(P,e,t),n(e,qe,t),r(V,e,t),n(e,We,t),n(e,L,t),n(e,Be,t),r(Q,e,t),n(e,He,t),n(e,N,t),n(e,Ye,t),r(A,e,t),n(e,Fe,t),n(e,E,t),n(e,Ie,t),n(e,S,t),n(e,Pe,t),n(e,D,t),n(e,Ve,t),n(e,K,t),n(e,Le,t),r(O,e,t),n(e,Qe,t),r(ee,e,t),n(e,Ne,t),n(e,te,t),n(e,Ae,t),n(e,le,t),n(e,Ee,t),n(e,ne,t),n(e,Se,t),r(ae,e,t),n(e,De,t),n(e,ie,t),n(e,Ke,t),r(se,e,t),n(e,Oe,t),n(e,pe,t),et=!0},p:Zt,i(e){et||(u(w.$$.fragment,e),u(M.$$.fragment,e),u(_.$$.fragment,e),u(j.$$.fragment,e),u(U.$$.fragment,e),u(C.$$.fragment,e),u(k.$$.fragment,e),u(x.$$.fragment,e),u(q.$$.fragment,e),u(H.$$.fragment,e),u(F.$$.fragment,e),u(P.$$.fragment,e),u(V.$$.fragment,e),u(Q.$$.fragment,e),u(A.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(ae.$$.fragment,e),u(se.$$.fragment,e),et=!0)},o(e){f(w.$$.fragment,e),f(M.$$.fragment,e),f(_.$$.fragment,e),f(j.$$.fragment,e),f(U.$$.fragment,e),f(C.$$.fragment,e),f(k.$$.fragment,e),f(x.$$.fragment,e),f(q.$$.fragment,e),f(H.$$.fragment,e),f(F.$$.fragment,e),f(P.$$.fragment,e),f(V.$$.fragment,e),f(Q.$$.fragment,e),f(A.$$.fragment,e),f(O.$$.fragment,e),f(ee.$$.fragment,e),f(ae.$$.fragment,e),f(se.$$.fragment,e),et=!1},d(e){e&&(l(de),l(oe),l(me),l(re),l(ue),l(y),l(fe),l($),l(ce),l(T),l(be),l(he),l(J),l(ge),l(v),l(we),l(Me),l(G),l(ye),l($e),l(Z),l(Te),l(_e),l(Je),l(X),l(ve),l(z),l(je),l(Ge),l(R),l(Ue),l(Ze),l(W),l(Ce),l(B),l(ke),l(Xe),l(Y),l(ze),l(xe),l(I),l(Re),l(qe),l(We),l(L),l(Be),l(He),l(N),l(Ye),l(Fe),l(E),l(Ie),l(S),l(Pe),l(D),l(Ve),l(K),l(Le),l(Qe),l(Ne),l(te),l(Ae),l(le),l(Ee),l(ne),l(Se),l(De),l(ie),l(Ke),l(Oe),l(pe)),l(h),c(w,e),c(M,e),c(_,e),c(j,e),c(U,e),c(C,e),c(k,e),c(x,e),c(q,e),c(H,e),c(F,e),c(P,e),c(V,e),c(Q,e),c(A,e),c(O,e),c(ee,e),c(ae,e),c(se,e)}}}const Wt='{"title":"Model quantization","local":"model-quantization","sections":[{"title":"bitsandbytes Integration","local":"bitsandbytes-integration","sections":[{"title":"Pre-Requisites","local":"pre-requisites","sections":[],"depth":3},{"title":"How it works","local":"how-it-works","sections":[],"depth":3},{"title":"Saving and loading 8-bit model","local":"saving-and-loading-8-bit-model","sections":[],"depth":3},{"title":"Offload modules to cpu and disk","local":"offload-modules-to-cpu-and-disk","sections":[],"depth":3},{"title":"Fine-tune a quantized model","local":"fine-tune-a-quantized-model","sections":[],"depth":3},{"title":"Example demo - running GPT2 1.5b on a Google Colab","local":"example-demo---running-gpt2-15b-on-a-google-colab","sections":[],"depth":3}],"depth":2}],"depth":1}';function Bt(tt){return Ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pt extends kt{constructor(h){super(),Xt(this,h,Bt,qt,Ut,{})}}export{Pt as component};
