import{s as Pt,n as Xt,o as Nt}from"../chunks/scheduler.b9285784.js";import{S as Yt,i as Ht,e as i,s,c as p,h as It,a as r,d as a,b as n,f as At,g as c,j as o,k as Ft,l as Wt,m as l,n as m,t as h,o as f,p as d}from"../chunks/index.26bc89a1.js";import{C as Gt,H as M,E as zt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.69b6a109.js";import{C as g}from"../chunks/CodeBlock.969d3a54.js";function Lt(nt){let u,me,pe,he,y,fe,w,de,b,it='Accelerate provides integrations to train on lower precision methods using specified supported hardware through the <code>TransformersEngine</code>, <code>MS-AMP</code>, and <code>torchao</code> packages. This documentation will help guide you through what hardware is supported, how to configure your <a href="/docs/accelerate/v1.11.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> to leverage the low precision methods, and what you can expect when training.',ue,T,Me,j,rt='To explore more of the nitty-gritty in training in FP8 with PyTorch and Accelerate, check out the <a href="../concept_guides/low_precision_training">concept_guide</a> on why this can be difficult. But essentially rather than training in BF16, some (or all) aspects of training a model can be performed using 8 bits instead of 16. The challenge is doing so without degrading final performance.',ge,U,ot="This is only enabled on specific NVIDIA hardware, namely:",ye,J,pt="<li>Anything after the 3000 series consumer graphics cards (such as the 4090)</li> <li>Hopper-based GPU architectures (such as the <code>H100</code> and <code>H200</code>)</li>",we,$,ct="What this will result in is some reduction in the memory used (as we’ve cut the needed memory in half for some parts of training) and an increase in throughput <em>should</em> be seen as well for larger models that can replace certain layers with FP8-enabled ones.",be,v,Te,C,mt="Currently three different backends for FP8 are supported (<code>TransformersEngine</code>, <code>torchao</code>, and <code>MS-AMP</code>), each with different capabilities and configurations.",je,_,ht='To use either, the same core API is used. Just pass <code>mixed_precision=&quot;fp8&quot;</code> to either the <a href="/docs/accelerate/v1.11.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a>, during <code>accelerate config</code> when prompted about mixed precision, or as part of your <code>config.yaml</code> file in the <code>mixed_precision</code> key:',Ue,B,Je,Z,ft="By default, if <code>MS-AMP</code> is available in your environment, Accelerate will automatically utilize it as a backend. To specify it yourself (and customize other parts of the FP8 mixed precision setup), you can utilize one of the <code>RecipeKwargs</code> dataclasses such as <code>utils.AORecipeKwargs</code>, <code>utils.TERecipeKwargs</code>, or <code>utils.MSAMPRecipeKwargs</code>; you can also clarify it in your config <code>yaml</code>/during <code>accelerate launch</code>:",$e,x,ve,k,Ce,A,_e,F,dt="Of the two, <code>MS-AMP</code> is traditionally the easier one to configure as there is only a single argument: the optimization level.",Be,P,ut="Currently two levels of optimization are supported in the Accelerate integration, <code>&quot;O1&quot;</code> and <code>&quot;O2&quot;</code> (using the letter ‘o’, not zero).",Ze,X,Mt="<li><code>&quot;O1&quot;</code> will cast the weight gradients and <code>all_reduce</code> communications to happen in 8-bit, while the rest are done in 16 bit. This reduces the general GPU memory usage and speeds up communication bandwidths.</li> <li><code>&quot;O2&quot;</code> will also cast first-order optimizer states into 8 bit, while the second order states are in FP16. (Currently just the <code>Adam</code> optimizer is supported). This tries its best to minimize final accuracy degradation and will save the highest potential memory.</li>",xe,N,gt="To specify an optimization level, pass it to the <code>FP8KwargsHandler</code> by setting the <code>optimization_level</code> argument:",ke,Y,Ae,H,yt="Or during <code>accelerate launch</code> via <code>--fp8_backend=msamp --fp8_opt_level=O2</code>",Fe,I,wt="Similarly this can be set in your <code>config.yaml</code>:",Pe,W,Xe,G,Ne,z,bt='TransformersEngine has many options for customizing how and what FP8 calculations are performed. A full list of supported arguments and what they mean are available in <a href="https://docs.nvidia.com/deeplearning/transformer-engine/user-guide/api/common.html" rel="nofollow">NVIDIA’s documentation</a>, however they are restated as part of <code>FP8KwargsHandler</code>’s docstring for your convenience.',Ye,L,Tt="Accelerate tries to set sensible defaults, but exploring and tweaking the various parameters yourself can lead to better performance potentially.",He,S,jt="To use it, specify <code>backend=&quot;te&quot;</code> and modify any of the arguments you want as part of your kwarg handler:",Ie,V,We,R,Ut="Or during <code>accelerate launch</code> via <code>--fp8_backend=te ...</code>. Use <code>accelerate launch --fp8_backend=te -h</code> to see relevent arguments.",Ge,E,Jt="Similarly this can be set in your <code>config.yaml</code>:",ze,Q,Le,q,Se,K,$t='<code>torchao</code> is a <a href="https://github.com/pytorch/ao/tree/main/torchao/float8" rel="nofollow">PyTorch-driven</a> hackable FP8 backend, aiming to be more approchable than the prior two engines. One of the core differences with <code>ao</code> compared to the prior two is that for numerical stability, it’s found to be generally better off keeping the first <em>and</em> last layers in the model at the regular precision (be it FP32 or BF16), and then the other layers quantized down to FP8. As a result, a config for <code>ao</code> looks a bit differently:',Ve,O,vt="<p>Note: this API is experimental and is subject to change</p>",Re,D,Ee,ee,Ct="To learn more about the specific parameters to be used, please see the official <code>torchao</code> repo.",Qe,te,qe,ae,_t=`We have examples showcasing training with FP8 both with accelerate and its underlying implementation available in the accelerate repo.
Currently we support scripts showcasing:`,Ke,le,Bt="<li>Single GPU</li> <li>Distributed Data Parallelism (Multi-GPU)</li> <li>Fully Sharded Data Parallelism</li> <li>DeepSpeed ZeRO 1 through 3</li>",Oe,se,Zt='Find out more <a href="https://github.com/huggingface/accelerate/tree/main/benchmarks/fp8" rel="nofollow">here</a>',De,ne,et,ie,xt="To learn more about training in FP8 please check out the following resources:",tt,re,kt='<li><a href="../concept_guides/low_precision_training">Our concept guide</a> detailing into more about both TransformersEngine and MS-AMP</li> <li><a href="https://docs.nvidia.com/deeplearning/transformer-engine/user-guide/api/common.html" rel="nofollow">The <code>transformers-engine</code> documentation</a></li> <li><a href="https://azure.github.io/MS-AMP/docs/" rel="nofollow">The <code>MS-AMP</code> documentation</a></li> <li><a href="https://github.com/pytorch/ao/tree/main/torchao/float8" rel="nofollow">The <code>torchao</code> documentation</a></li>',at,oe,lt,ce,st;return y=new Gt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new M({props:{title:"Low Precision Training Methods",local:"low-precision-training-methods",headingTag:"h1"}}),T=new M({props:{title:"What training on FP8 means",local:"what-training-on-fp8-means",headingTag:"h2"}}),v=new M({props:{title:"Configuring the Accelerator",local:"configuring-the-accelerator",headingTag:"h2"}}),B=new g({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IobWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnA4JTIyKQ==",highlighted:`from accelerate import Accelerator
<span class="hljs-attribute">accelerator</span> <span class="hljs-operator">=</span> Accelerator(mixed_precision<span class="hljs-operator">=</span><span class="hljs-string">&quot;fp8&quot;</span>)`,wrap:!1}}),x=new g({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjBhY2NlbGVyYXRlLnV0aWxzJTIwaW1wb3J0JTIwTVNBTVBSZWNpcGVLd2FyZ3MlMEFrd2FyZ3MlMjAlM0QlMjAlNUJNU0FNUFJlY2lwZUt3YXJncygpJTVEJTBBJTIzJTIwT3IlMjB0byUyMHNwZWNpZnklMjB0aGUlMjBiYWNrZW5kJTIwYXMlMjAlNjBUcmFuc2Zvcm1lcnNFbmdpbmUlNjAlMjBldmVuJTIwaWYlMjBNUy1BTVAlMjBpcyUyMGluc3RhbGxlZCUwQSUyMyUyMGt3YXJncyUyMCUzRCUyMCU1QlRFUmVjaXBlS3dhcmdzKCklNUQlMEElMjMlMjBPciUyMHRvJTIwdXNlJTIwdG9yY2hhbyUwQSUyMyUyMGt3YXJncyUyMCUzRCUyMCU1QkFPUmVjaXBlS3dhcmdzKCklNUQlMEFhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKG1peGVkX3ByZWNpc2lvbiUzRCUyMmZwOCUyMiUyQyUyMGt3YXJnX2hhbmRsZXJzJTNEa3dhcmdzKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate import Accelerator
<span class="hljs-keyword">from</span> accelerate.utils import MSAMPRecipeKwargs
kwargs = [MSAMPRecipeKwargs()]
<span class="hljs-comment"># Or to specify the backend as \`TransformersEngine\` even if MS-AMP is installed</span>
<span class="hljs-comment"># kwargs = [TERecipeKwargs()]</span>
<span class="hljs-comment"># Or to use torchao</span>
<span class="hljs-comment"># kwargs = [AORecipeKwargs()]</span>
accelerator = Accelerator(<span class="hljs-attribute">mixed_precision</span>=<span class="hljs-string">&quot;fp8&quot;</span>, <span class="hljs-attribute">kwarg_handlers</span>=kwargs)`,wrap:!1}}),k=new g({props:{code:"bWl4ZWRfcHJlY2lzaW9uJTNBJTIwZnA4JTBBZnA4X2NvbmZpZyUzQSUwQSUyMCUyMGFtYXhfY29tcHV0ZV9hbGdvJTNBJTIwbWF4JTBBJTIwJTIwYW1heF9oaXN0b3J5X2xlbiUzQSUyMDEwMjQlMEElMjAlMjBiYWNrZW5kJTNBJTIwVEUlMEElMjAlMjBmcDhfZm9ybWF0JTNBJTIwSFlCUklEJTBBJTIwJTIwaW50ZXJ2YWwlM0ElMjAxJTBBJTIwJTIwbWFyZ2luJTNBJTIwMCUwQSUyMCUyMG92ZXJyaWRlX2xpbmVhcl9wcmVjaXNpb24lM0ElMjAoZmFsc2UlMkMlMjBmYWxzZSUyQyUyMGZhbHNlKSUwQSUyMCUyMHVzZV9hdXRvY2FzdF9kdXJpbmdfZXZhbCUzQSUyMGZhbHNl",highlighted:`<span class="hljs-attr">mixed_precision:</span> <span class="hljs-string">fp8</span>
<span class="hljs-attr">fp8_config:</span>
  <span class="hljs-attr">amax_compute_algo:</span> <span class="hljs-string">max</span>
  <span class="hljs-attr">amax_history_len:</span> <span class="hljs-number">1024</span>
  <span class="hljs-attr">backend:</span> <span class="hljs-string">TE</span>
  <span class="hljs-attr">fp8_format:</span> <span class="hljs-string">HYBRID</span>
  <span class="hljs-attr">interval:</span> <span class="hljs-number">1</span>
  <span class="hljs-attr">margin:</span> <span class="hljs-number">0</span>
  <span class="hljs-attr">override_linear_precision:</span> <span class="hljs-string">(false,</span> <span class="hljs-literal">false</span><span class="hljs-string">,</span> <span class="hljs-literal">false</span><span class="hljs-string">)</span>
  <span class="hljs-attr">use_autocast_during_eval:</span> <span class="hljs-literal">false</span>`,wrap:!1}}),A=new M({props:{title:"Configuring MS-AMP",local:"configuring-ms-amp",headingTag:"h2"}}),Y=new g({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjBhY2NlbGVyYXRlLnV0aWxzJTIwaW1wb3J0JTIwRlA4UmVjaXBlS3dhcmdzJTBBa3dhcmdzJTIwJTNEJTIwJTVCRlA4UmVjaXBlS3dhcmdzKGJhY2tlbmQlM0QlMjJtc2FtcCUyMiUyQyUyMG9wdGltaXphdGlvbl9sZXZlbCUzRCUyMk8yJTIyKSU1RCUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IobWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnA4JTIyJTJDJTIwa3dhcmdfaGFuZGxlcnMlM0Rrd2FyZ3Mp",highlighted:`<span class="hljs-keyword">from</span> accelerate import Accelerator
<span class="hljs-keyword">from</span> accelerate.utils import FP8RecipeKwargs
kwargs = [FP8RecipeKwargs(<span class="hljs-attribute">backend</span>=<span class="hljs-string">&quot;msamp&quot;</span>, <span class="hljs-attribute">optimization_level</span>=<span class="hljs-string">&quot;O2&quot;</span>)]
accelerator = Accelerator(<span class="hljs-attribute">mixed_precision</span>=<span class="hljs-string">&quot;fp8&quot;</span>, <span class="hljs-attribute">kwarg_handlers</span>=kwargs)`,wrap:!1}}),W=new g({props:{code:"bWl4ZWRfcHJlY2lzaW9uJTNBJTIwZnA4JTBBZnA4X2NvbmZpZyUzQSUwQSUyMCUyMCUyMCUyMGJhY2tlbmQlM0ElMjBNU0FNUCUwQSUyMCUyMCUyMCUyMG9wdF9sZXZlbCUzQSUyME8y",highlighted:`<span class="hljs-symbol">mixed_precision:</span> fp8
<span class="hljs-symbol">fp8_config:</span>
<span class="hljs-symbol">    backend:</span> MSAMP
<span class="hljs-symbol">    opt_level:</span> O2`,wrap:!1}}),G=new M({props:{title:"Configuring TransformersEngine",local:"configuring-transformersengine",headingTag:"h2"}}),V=new g({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjBhY2NlbGVyYXRlLnV0aWxzJTIwaW1wb3J0JTIwRlA4UmVjaXBlS3dhcmdzJTBBa3dhcmdzJTIwJTNEJTIwJTVCRlA4UmVjaXBlS3dhcmdzKGJhY2tlbmQlM0QlMjJ0ZSUyMiUyQyUyMC4uLiklNUQlMEFhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKG1peGVkX3ByZWNpc2lvbiUzRCUyMmZwOCUyMiUyQyUyMGt3YXJnX2hhbmRsZXJzJTNEa3dhcmdzKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate import Accelerator
<span class="hljs-keyword">from</span> accelerate.utils import FP8RecipeKwargs
kwargs = [FP8RecipeKwargs(<span class="hljs-attribute">backend</span>=<span class="hljs-string">&quot;te&quot;</span>, <span class="hljs-built_in">..</span>.)]
accelerator = Accelerator(<span class="hljs-attribute">mixed_precision</span>=<span class="hljs-string">&quot;fp8&quot;</span>, <span class="hljs-attribute">kwarg_handlers</span>=kwargs)`,wrap:!1}}),Q=new g({props:{code:"bWl4ZWRfcHJlY2lzaW9uJTNBJTIwZnA4JTBBZnA4X2NvbmZpZyUzQSUwQSUyMCUyMCUyMCUyMGFtYXhfY29tcHV0ZV9hbGdvJTNBJTIwbWF4JTBBJTIwJTIwJTIwJTIwYW1heF9oaXN0b3J5X2xlbiUzQSUyMDEwMjQlMEElMjAlMjAlMjAlMjBiYWNrZW5kJTNBJTIwVEUlMEElMjAlMjAlMjAlMjBmcDhfZm9ybWF0JTNBJTIwSFlCUklEJTBBJTIwJTIwJTIwJTIwaW50ZXJ2YWwlM0ElMjAxJTBBJTIwJTIwJTIwJTIwbWFyZ2luJTNBJTIwMCUwQSUyMCUyMCUyMCUyMG92ZXJyaWRlX2xpbmVhcl9wcmVjaXNpb24lM0ElMjAoZmFsc2UlMkMlMjBmYWxzZSUyQyUyMGZhbHNlKSUwQSUyMCUyMCUyMCUyMHVzZV9hdXRvY2FzdF9kdXJpbmdfZXZhbCUzQSUyMGZhbHNl",highlighted:`<span class="hljs-attr">mixed_precision:</span> <span class="hljs-string">fp8</span>
<span class="hljs-attr">fp8_config:</span>
    <span class="hljs-attr">amax_compute_algo:</span> <span class="hljs-string">max</span>
    <span class="hljs-attr">amax_history_len:</span> <span class="hljs-number">1024</span>
    <span class="hljs-attr">backend:</span> <span class="hljs-string">TE</span>
    <span class="hljs-attr">fp8_format:</span> <span class="hljs-string">HYBRID</span>
    <span class="hljs-attr">interval:</span> <span class="hljs-number">1</span>
    <span class="hljs-attr">margin:</span> <span class="hljs-number">0</span>
    <span class="hljs-attr">override_linear_precision:</span> <span class="hljs-string">(false,</span> <span class="hljs-literal">false</span><span class="hljs-string">,</span> <span class="hljs-literal">false</span><span class="hljs-string">)</span>
    <span class="hljs-attr">use_autocast_during_eval:</span> <span class="hljs-literal">false</span>`,wrap:!1}}),q=new M({props:{title:"Configuring torchao",local:"configuring-torchao",headingTag:"h2"}}),D=new g({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjBhY2NlbGVyYXRlLnV0aWxzJTIwaW1wb3J0JTIwQU9SZWNpcGVLd2FyZ3MlMEFrd2FyZ3MlMjAlM0QlMjAlNUJBT1JlY2lwZUt3YXJncygpJTVEJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihtaXhlZF9wcmVjaXNpb24lM0QlMjJmcDglMjIlMkMlMjBrd2FyZ19oYW5kbGVycyUzRGt3YXJncyk=",highlighted:`<span class="hljs-keyword">from</span> accelerate import Accelerator
<span class="hljs-keyword">from</span> accelerate.utils import AORecipeKwargs
kwargs = [AORecipeKwargs()]
accelerator = Accelerator(<span class="hljs-attribute">mixed_precision</span>=<span class="hljs-string">&quot;fp8&quot;</span>, <span class="hljs-attribute">kwarg_handlers</span>=kwargs)`,wrap:!1}}),te=new M({props:{title:"Example Zoo",local:"example-zoo",headingTag:"h2"}}),ne=new M({props:{title:"Further Reading",local:"further-reading",headingTag:"h2"}}),oe=new zt({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/usage_guides/low_precision_training.md"}}),{c(){u=i("meta"),me=s(),pe=i("p"),he=s(),p(y.$$.fragment),fe=s(),p(w.$$.fragment),de=s(),b=i("p"),b.innerHTML=it,ue=s(),p(T.$$.fragment),Me=s(),j=i("p"),j.innerHTML=rt,ge=s(),U=i("p"),U.textContent=ot,ye=s(),J=i("ul"),J.innerHTML=pt,we=s(),$=i("p"),$.innerHTML=ct,be=s(),p(v.$$.fragment),Te=s(),C=i("p"),C.innerHTML=mt,je=s(),_=i("p"),_.innerHTML=ht,Ue=s(),p(B.$$.fragment),Je=s(),Z=i("p"),Z.innerHTML=ft,$e=s(),p(x.$$.fragment),ve=s(),p(k.$$.fragment),Ce=s(),p(A.$$.fragment),_e=s(),F=i("p"),F.innerHTML=dt,Be=s(),P=i("p"),P.innerHTML=ut,Ze=s(),X=i("ul"),X.innerHTML=Mt,xe=s(),N=i("p"),N.innerHTML=gt,ke=s(),p(Y.$$.fragment),Ae=s(),H=i("p"),H.innerHTML=yt,Fe=s(),I=i("p"),I.innerHTML=wt,Pe=s(),p(W.$$.fragment),Xe=s(),p(G.$$.fragment),Ne=s(),z=i("p"),z.innerHTML=bt,Ye=s(),L=i("p"),L.textContent=Tt,He=s(),S=i("p"),S.innerHTML=jt,Ie=s(),p(V.$$.fragment),We=s(),R=i("p"),R.innerHTML=Ut,Ge=s(),E=i("p"),E.innerHTML=Jt,ze=s(),p(Q.$$.fragment),Le=s(),p(q.$$.fragment),Se=s(),K=i("p"),K.innerHTML=$t,Ve=s(),O=i("blockquote"),O.innerHTML=vt,Re=s(),p(D.$$.fragment),Ee=s(),ee=i("p"),ee.innerHTML=Ct,Qe=s(),p(te.$$.fragment),qe=s(),ae=i("p"),ae.textContent=_t,Ke=s(),le=i("ul"),le.innerHTML=Bt,Oe=s(),se=i("p"),se.innerHTML=Zt,De=s(),p(ne.$$.fragment),et=s(),ie=i("p"),ie.textContent=xt,tt=s(),re=i("ul"),re.innerHTML=kt,at=s(),p(oe.$$.fragment),lt=s(),ce=i("p"),this.h()},l(e){const t=It("svelte-u9bgzb",document.head);u=r(t,"META",{name:!0,content:!0}),t.forEach(a),me=n(e),pe=r(e,"P",{}),At(pe).forEach(a),he=n(e),c(y.$$.fragment,e),fe=n(e),c(w.$$.fragment,e),de=n(e),b=r(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1m2h9tu"&&(b.innerHTML=it),ue=n(e),c(T.$$.fragment,e),Me=n(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-wuhpuo"&&(j.innerHTML=rt),ge=n(e),U=r(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-10cwb11"&&(U.textContent=ot),ye=n(e),J=r(e,"UL",{"data-svelte-h":!0}),o(J)!=="svelte-5d1df8"&&(J.innerHTML=pt),we=n(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-149dy0g"&&($.innerHTML=ct),be=n(e),c(v.$$.fragment,e),Te=n(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1ytxd1j"&&(C.innerHTML=mt),je=n(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-jqslbs"&&(_.innerHTML=ht),Ue=n(e),c(B.$$.fragment,e),Je=n(e),Z=r(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-hoblda"&&(Z.innerHTML=ft),$e=n(e),c(x.$$.fragment,e),ve=n(e),c(k.$$.fragment,e),Ce=n(e),c(A.$$.fragment,e),_e=n(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-13jlsqr"&&(F.innerHTML=dt),Be=n(e),P=r(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-11bftkh"&&(P.innerHTML=ut),Ze=n(e),X=r(e,"UL",{"data-svelte-h":!0}),o(X)!=="svelte-ha185h"&&(X.innerHTML=Mt),xe=n(e),N=r(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-wx6vs8"&&(N.innerHTML=gt),ke=n(e),c(Y.$$.fragment,e),Ae=n(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-vo4vij"&&(H.innerHTML=yt),Fe=n(e),I=r(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1n0fir7"&&(I.innerHTML=wt),Pe=n(e),c(W.$$.fragment,e),Xe=n(e),c(G.$$.fragment,e),Ne=n(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1tlihxp"&&(z.innerHTML=bt),Ye=n(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-wvn4fr"&&(L.textContent=Tt),He=n(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-8khoko"&&(S.innerHTML=jt),Ie=n(e),c(V.$$.fragment,e),We=n(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-99qxte"&&(R.innerHTML=Ut),Ge=n(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1n0fir7"&&(E.innerHTML=Jt),ze=n(e),c(Q.$$.fragment,e),Le=n(e),c(q.$$.fragment,e),Se=n(e),K=r(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-13u4x7b"&&(K.innerHTML=$t),Ve=n(e),O=r(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(O)!=="svelte-rg03zf"&&(O.innerHTML=vt),Re=n(e),c(D.$$.fragment,e),Ee=n(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1qqyqot"&&(ee.innerHTML=Ct),Qe=n(e),c(te.$$.fragment,e),qe=n(e),ae=r(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1ay0trc"&&(ae.textContent=_t),Ke=n(e),le=r(e,"UL",{"data-svelte-h":!0}),o(le)!=="svelte-1affbo7"&&(le.innerHTML=Bt),Oe=n(e),se=r(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-sau342"&&(se.innerHTML=Zt),De=n(e),c(ne.$$.fragment,e),et=n(e),ie=r(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-t5s4ol"&&(ie.textContent=xt),tt=n(e),re=r(e,"UL",{"data-svelte-h":!0}),o(re)!=="svelte-1gt16sy"&&(re.innerHTML=kt),at=n(e),c(oe.$$.fragment,e),lt=n(e),ce=r(e,"P",{}),At(ce).forEach(a),this.h()},h(){Ft(u,"name","hf:doc:metadata"),Ft(u,"content",St)},m(e,t){Wt(document.head,u),l(e,me,t),l(e,pe,t),l(e,he,t),m(y,e,t),l(e,fe,t),m(w,e,t),l(e,de,t),l(e,b,t),l(e,ue,t),m(T,e,t),l(e,Me,t),l(e,j,t),l(e,ge,t),l(e,U,t),l(e,ye,t),l(e,J,t),l(e,we,t),l(e,$,t),l(e,be,t),m(v,e,t),l(e,Te,t),l(e,C,t),l(e,je,t),l(e,_,t),l(e,Ue,t),m(B,e,t),l(e,Je,t),l(e,Z,t),l(e,$e,t),m(x,e,t),l(e,ve,t),m(k,e,t),l(e,Ce,t),m(A,e,t),l(e,_e,t),l(e,F,t),l(e,Be,t),l(e,P,t),l(e,Ze,t),l(e,X,t),l(e,xe,t),l(e,N,t),l(e,ke,t),m(Y,e,t),l(e,Ae,t),l(e,H,t),l(e,Fe,t),l(e,I,t),l(e,Pe,t),m(W,e,t),l(e,Xe,t),m(G,e,t),l(e,Ne,t),l(e,z,t),l(e,Ye,t),l(e,L,t),l(e,He,t),l(e,S,t),l(e,Ie,t),m(V,e,t),l(e,We,t),l(e,R,t),l(e,Ge,t),l(e,E,t),l(e,ze,t),m(Q,e,t),l(e,Le,t),m(q,e,t),l(e,Se,t),l(e,K,t),l(e,Ve,t),l(e,O,t),l(e,Re,t),m(D,e,t),l(e,Ee,t),l(e,ee,t),l(e,Qe,t),m(te,e,t),l(e,qe,t),l(e,ae,t),l(e,Ke,t),l(e,le,t),l(e,Oe,t),l(e,se,t),l(e,De,t),m(ne,e,t),l(e,et,t),l(e,ie,t),l(e,tt,t),l(e,re,t),l(e,at,t),m(oe,e,t),l(e,lt,t),l(e,ce,t),st=!0},p:Xt,i(e){st||(h(y.$$.fragment,e),h(w.$$.fragment,e),h(T.$$.fragment,e),h(v.$$.fragment,e),h(B.$$.fragment,e),h(x.$$.fragment,e),h(k.$$.fragment,e),h(A.$$.fragment,e),h(Y.$$.fragment,e),h(W.$$.fragment,e),h(G.$$.fragment,e),h(V.$$.fragment,e),h(Q.$$.fragment,e),h(q.$$.fragment,e),h(D.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),st=!0)},o(e){f(y.$$.fragment,e),f(w.$$.fragment,e),f(T.$$.fragment,e),f(v.$$.fragment,e),f(B.$$.fragment,e),f(x.$$.fragment,e),f(k.$$.fragment,e),f(A.$$.fragment,e),f(Y.$$.fragment,e),f(W.$$.fragment,e),f(G.$$.fragment,e),f(V.$$.fragment,e),f(Q.$$.fragment,e),f(q.$$.fragment,e),f(D.$$.fragment,e),f(te.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),st=!1},d(e){e&&(a(me),a(pe),a(he),a(fe),a(de),a(b),a(ue),a(Me),a(j),a(ge),a(U),a(ye),a(J),a(we),a($),a(be),a(Te),a(C),a(je),a(_),a(Ue),a(Je),a(Z),a($e),a(ve),a(Ce),a(_e),a(F),a(Be),a(P),a(Ze),a(X),a(xe),a(N),a(ke),a(Ae),a(H),a(Fe),a(I),a(Pe),a(Xe),a(Ne),a(z),a(Ye),a(L),a(He),a(S),a(Ie),a(We),a(R),a(Ge),a(E),a(ze),a(Le),a(Se),a(K),a(Ve),a(O),a(Re),a(Ee),a(ee),a(Qe),a(qe),a(ae),a(Ke),a(le),a(Oe),a(se),a(De),a(et),a(ie),a(tt),a(re),a(at),a(lt),a(ce)),a(u),d(y,e),d(w,e),d(T,e),d(v,e),d(B,e),d(x,e),d(k,e),d(A,e),d(Y,e),d(W,e),d(G,e),d(V,e),d(Q,e),d(q,e),d(D,e),d(te,e),d(ne,e),d(oe,e)}}}const St='{"title":"Low Precision Training Methods","local":"low-precision-training-methods","sections":[{"title":"What training on FP8 means","local":"what-training-on-fp8-means","sections":[],"depth":2},{"title":"Configuring the Accelerator","local":"configuring-the-accelerator","sections":[],"depth":2},{"title":"Configuring MS-AMP","local":"configuring-ms-amp","sections":[],"depth":2},{"title":"Configuring TransformersEngine","local":"configuring-transformersengine","sections":[],"depth":2},{"title":"Configuring torchao","local":"configuring-torchao","sections":[],"depth":2},{"title":"Example Zoo","local":"example-zoo","sections":[],"depth":2},{"title":"Further Reading","local":"further-reading","sections":[],"depth":2}],"depth":1}';function Vt(nt){return Nt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kt extends Yt{constructor(u){super(),Ht(this,u,Vt,Lt,Pt,{})}}export{Kt as component};
