# Experiment Trackers

## GeneralTracker[[accelerate.tracking.GeneralTracker]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class accelerate.tracking.GeneralTracker</name><anchor>accelerate.tracking.GeneralTracker</anchor><source>https://github.com/huggingface/accelerate/blob/v1.11.0/src/accelerate/tracking.py#L101</source><parameters>[{"name": "_blank", "val": " = False"}]</parameters></docstring>

A base Tracker class to be used for all logging integration implementations.

Each function should take in `**kwargs` that will automatically be passed in from a base dictionary provided to
[Accelerator](/docs/accelerate/v1.11.0/en/package_reference/accelerator#accelerate.Accelerator).

Should implement `name`, `requires_logging_directory`, and `tracker` properties such that:

`name` (`str`): String representation of the tracker class name, such as "TensorBoard" `requires_logging_directory`
(`bool`): Whether the logger requires a directory to store their logs. `tracker` (`object`): Should return internal
tracking mechanism used by a tracker class (such as the `run` for wandb)

Implementations can also include a `main_process_only` (`bool`) attribute to toggle if relevant logging, init, and
other functions should occur on the main process or across all processes (by default will use `True`)



<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>finish</name><anchor>accelerate.tracking.GeneralTracker.finish</anchor><source>https://github.com/huggingface/accelerate/blob/v1.11.0/src/accelerate/tracking.py#L174</source><parameters>[]</parameters></docstring>

Should run any finalizing functions within the tracking API. If the API should not have one, just don't
overwrite that method.


</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>log</name><anchor>accelerate.tracking.GeneralTracker.log</anchor><source>https://github.com/huggingface/accelerate/blob/v1.11.0/src/accelerate/tracking.py#L161</source><parameters>[{"name": "values", "val": ": dict"}, {"name": "step", "val": ": typing.Optional[int]"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **values** (Dictionary `str` to `str`, `float`, or `int`) --
  Values to be logged as key-value pairs. The values need to have type `str`, `float`, or `int`.
- **step** (`int`, *optional*) --
  The run step. If included, the log will be affiliated with this step.</paramsdesc><paramgroups>0</paramgroups></docstring>

Logs `values` to the current run. Base `log` implementations of a tracking API should go in here, along with
special behavior for the `step parameter.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>start</name><anchor>accelerate.tracking.GeneralTracker.start</anchor><source>https://github.com/huggingface/accelerate/blob/v1.11.0/src/accelerate/tracking.py#L142</source><parameters>[]</parameters></docstring>

Lazy initialization of the tracker inside Accelerator to avoid initializing PartialState before
InitProcessGroupKwargs.


</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>store_init_configuration</name><anchor>accelerate.tracking.GeneralTracker.store_init_configuration</anchor><source>https://github.com/huggingface/accelerate/blob/v1.11.0/src/accelerate/tracking.py#L149</source><parameters>[{"name": "values", "val": ": dict"}]</parameters><paramsdesc>- **values** (Dictionary `str` to `bool`, `str`, `float` or `int`) --
  Values to be stored as initial hyperparameters as key-value pairs. The values need to have type `bool`,
  `str`, `float`, `int`, or `None`.</paramsdesc><paramgroups>0</paramgroups></docstring>

Logs `values` as hyperparameters for the run. Implementations should use the experiment configuration
functionality of a tracking API.




</div></div>

## TensorBoardTracker[[accelerate.tracking.TensorBoardTracker]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class accelerate.tracking.TensorBoardTracker</name><anchor>accelerate.tracking.TensorBoardTracker</anchor><source>https://github.com/huggingface/accelerate/blob/v1.11.0/src/accelerate/tracking.py#L182</source><parameters>[{"name": "run_name", "val": ": str"}, {"name": "logging_dir", "val": ": typing.Union[str, os.PathLike]"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **run_name** (`str`) --
  The name of the experiment run
- **logging_dir** (`str`, `os.PathLike`) --
  Location for TensorBoard logs to be stored.
- ****kwargs** (additional keyword arguments, *optional*) --
  Additional key word arguments passed along to the `tensorboard.SummaryWriter.__init__` method.</paramsdesc><paramgroups>0</paramgroups></docstring>

A `Tracker` class that supports `tensorboard`. Should be initialized at the start of your script.





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>__init__</name><anchor>accelerate.tracking.TensorBoardTracker.__init__</anchor><source>https://github.com/huggingface/accelerate/blob/v1.11.0/src/accelerate/tracking.py#L198</source><parameters>[{"name": "run_name", "val": ": str"}, {"name": "logging_dir", "val": ": typing.Union[str, os.PathLike]"}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div></div>

## WandBTracker[[accelerate.tracking.WandBTracker]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class accelerate.tracking.WandBTracker</name><anchor>accelerate.tracking.WandBTracker</anchor><source>https://github.com/huggingface/accelerate/blob/v1.11.0/src/accelerate/tracking.py#L297</source><parameters>[{"name": "run_name", "val": ": str"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **run_name** (`str`) --
  The name of the experiment run.
- ****kwargs** (additional keyword arguments, *optional*) --
  Additional key word arguments passed along to the `wandb.init` method.</paramsdesc><paramgroups>0</paramgroups></docstring>

A `Tracker` class that supports `wandb`. Should be initialized at the start of your script.





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>__init__</name><anchor>accelerate.tracking.WandBTracker.__init__</anchor><source>https://github.com/huggingface/accelerate/blob/v1.11.0/src/accelerate/tracking.py#L312</source><parameters>[{"name": "run_name", "val": ": str"}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div></div>

## Trackio[[accelerate.tracking.TrackioTracker]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class accelerate.tracking.TrackioTracker</name><anchor>accelerate.tracking.TrackioTracker</anchor><source>https://github.com/huggingface/accelerate/blob/v1.11.0/src/accelerate/tracking.py#L431</source><parameters>[{"name": "run_name", "val": ": str"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **run_name** (`str`) --
  The name of the experiment run. Will be used as the `project` name when instantiating trackio.
- ****kwargs** (additional keyword arguments, *optional*) --
  Additional key word arguments passed along to the `trackio.init` method. Refer to this
  [init](https://github.com/gradio-app/trackio/blob/814809552310468b13f84f33764f1369b4e5136c/trackio/__init__.py#L22)
  to see all supported key word arguments.</paramsdesc><paramgroups>0</paramgroups></docstring>

A `Tracker` class that supports `trackio`. Should be initialized at the start of your script.





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>__init__</name><anchor>accelerate.tracking.TrackioTracker.__init__</anchor><source>https://github.com/huggingface/accelerate/blob/v1.11.0/src/accelerate/tracking.py#L448</source><parameters>[{"name": "run_name", "val": ": str"}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div></div>

## CometMLTracker[[accelerate.tracking.CometMLTracker]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class accelerate.tracking.CometMLTracker</name><anchor>accelerate.tracking.CometMLTracker</anchor><source>https://github.com/huggingface/accelerate/blob/v1.11.0/src/accelerate/tracking.py#L508</source><parameters>[{"name": "run_name", "val": ": str"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **run_name** (`str`) --
  The name of the experiment run.
- ****kwargs** (additional keyword arguments, *optional*) --
  Additional key word arguments passed along to the `comet_ml.start` method:
  https://www.comet.com/docs/v2/api-and-sdk/python-sdk/reference/start/</paramsdesc><paramgroups>0</paramgroups></docstring>

A `Tracker` class that supports `comet_ml`. Should be initialized at the start of your script.

API keys must be stored in a Comet config file.

Note:
For `comet_ml` versions < 3.41.0, additional keyword arguments are passed to `comet_ml.Experiment` instead:
https://www.comet.com/docs/v2/api-and-sdk/python-sdk/reference/Experiment/#comet_ml.Experiment.__init__





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>__init__</name><anchor>accelerate.tracking.CometMLTracker.__init__</anchor><source>https://github.com/huggingface/accelerate/blob/v1.11.0/src/accelerate/tracking.py#L529</source><parameters>[{"name": "run_name", "val": ": str"}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div></div>

## AimTracker[[accelerate.tracking.AimTracker]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class accelerate.tracking.AimTracker</name><anchor>accelerate.tracking.AimTracker</anchor><source>https://github.com/huggingface/accelerate/blob/v1.11.0/src/accelerate/tracking.py#L602</source><parameters>[{"name": "run_name", "val": ": str"}, {"name": "logging_dir", "val": ": typing.Union[str, os.PathLike, NoneType] = '.'"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **run_name** (`str`) --
  The name of the experiment run.
- ****kwargs** (additional keyword arguments, *optional*) --
  Additional key word arguments passed along to the `Run.__init__` method.</paramsdesc><paramgroups>0</paramgroups></docstring>

A `Tracker` class that supports `aim`. Should be initialized at the start of your script.





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>__init__</name><anchor>accelerate.tracking.AimTracker.__init__</anchor><source>https://github.com/huggingface/accelerate/blob/v1.11.0/src/accelerate/tracking.py#L616</source><parameters>[{"name": "run_name", "val": ": str"}, {"name": "logging_dir", "val": ": typing.Union[str, os.PathLike, NoneType] = '.'"}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div></div>

## MLflowTracker[[accelerate.tracking.MLflowTracker]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class accelerate.tracking.MLflowTracker</name><anchor>accelerate.tracking.MLflowTracker</anchor><source>https://github.com/huggingface/accelerate/blob/v1.11.0/src/accelerate/tracking.py#L705</source><parameters>[{"name": "experiment_name", "val": ": typing.Optional[str] = None"}, {"name": "logging_dir", "val": ": typing.Union[str, os.PathLike, NoneType] = None"}, {"name": "run_id", "val": ": typing.Optional[str] = None"}, {"name": "tags", "val": ": typing.Union[dict[str, typing.Any], str, NoneType] = None"}, {"name": "nested_run", "val": ": typing.Optional[bool] = False"}, {"name": "run_name", "val": ": typing.Optional[str] = None"}, {"name": "description", "val": ": typing.Optional[str] = None"}]</parameters><paramsdesc>- **experiment_name** (`str`, *optional*) --
  Name of the experiment. Environment variable MLFLOW_EXPERIMENT_NAME has priority over this argument.
- **logging_dir** (`str` or `os.PathLike`, defaults to `"."`) --
  Location for mlflow logs to be stored.
- **run_id** (`str`, *optional*) --
  If specified, get the run with the specified UUID and log parameters and metrics under that run. The run’s
  end time is unset and its status is set to running, but the run’s other attributes (source_version,
  source_type, etc.) are not changed. Environment variable MLFLOW_RUN_ID has priority over this argument.
- **tags** (`Dict[str, str]`, *optional*) --
  An optional `dict` of `str` keys and values, or a `str` dump from a `dict`, to set as tags on the run. If a
  run is being resumed, these tags are set on the resumed run. If a new run is being created, these tags are
  set on the new run. Environment variable MLFLOW_TAGS has priority over this argument.
- **nested_run** (`bool`, *optional*, defaults to `False`) --
  Controls whether run is nested in parent run. True creates a nested run. Environment variable
  MLFLOW_NESTED_RUN has priority over this argument.
- **run_name** (`str`, *optional*) --
  Name of new run (stored as a mlflow.runName tag). Used only when `run_id` is unspecified.
- **description** (`str`, *optional*) --
  An optional string that populates the description box of the run. If a run is being resumed, the
  description is set on the resumed run. If a new run is being created, the description is set on the new
  run.</paramsdesc><paramgroups>0</paramgroups></docstring>

A `Tracker` class that supports `mlflow`. Should be initialized at the start of your script.





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>__init__</name><anchor>accelerate.tracking.MLflowTracker.__init__</anchor><source>https://github.com/huggingface/accelerate/blob/v1.11.0/src/accelerate/tracking.py#L736</source><parameters>[{"name": "experiment_name", "val": ": typing.Optional[str] = None"}, {"name": "logging_dir", "val": ": typing.Union[str, os.PathLike, NoneType] = None"}, {"name": "run_id", "val": ": typing.Optional[str] = None"}, {"name": "tags", "val": ": typing.Union[dict[str, typing.Any], str, NoneType] = None"}, {"name": "nested_run", "val": ": typing.Optional[bool] = False"}, {"name": "run_name", "val": ": typing.Optional[str] = None"}, {"name": "description", "val": ": typing.Optional[str] = None"}]</parameters></docstring>


</div></div>

## ClearMLTracker[[accelerate.tracking.ClearMLTracker]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class accelerate.tracking.ClearMLTracker</name><anchor>accelerate.tracking.ClearMLTracker</anchor><source>https://github.com/huggingface/accelerate/blob/v1.11.0/src/accelerate/tracking.py#L912</source><parameters>[{"name": "run_name", "val": ": typing.Optional[str] = None"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **run_name** (`str`, *optional*) --
  Name of the experiment. Environment variables `CLEARML_PROJECT` and `CLEARML_TASK` have priority over this
  argument.
- ****kwargs** (additional keyword arguments, *optional*) --
  Kwargs passed along to the `Task.__init__` method.</paramsdesc><paramgroups>0</paramgroups></docstring>

A `Tracker` class that supports `clearml`. Should be initialized at the start of your script.





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>__init__</name><anchor>accelerate.tracking.ClearMLTracker.__init__</anchor><source>https://github.com/huggingface/accelerate/blob/v1.11.0/src/accelerate/tracking.py#L927</source><parameters>[{"name": "run_name", "val": ": typing.Optional[str] = None"}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div></div>

## SwanLabTracker[[accelerate.tracking.SwanLabTracker]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class accelerate.tracking.SwanLabTracker</name><anchor>accelerate.tracking.SwanLabTracker</anchor><source>https://github.com/huggingface/accelerate/blob/v1.11.0/src/accelerate/tracking.py#L1158</source><parameters>[{"name": "run_name", "val": ": str"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **run_name** (`str`) --
  The name of the experiment run.
- ****kwargs** (additional keyword arguments, *optional*) --
  Additional key word arguments passed along to the `swanlab.init` method.</paramsdesc><paramgroups>0</paramgroups></docstring>

A `Tracker` class that supports `swanlab`. Should be initialized at the start of your script.





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>__init__</name><anchor>accelerate.tracking.SwanLabTracker.__init__</anchor><source>https://github.com/huggingface/accelerate/blob/v1.11.0/src/accelerate/tracking.py#L1173</source><parameters>[{"name": "run_name", "val": ": str"}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div></div>

<EditOnGithub source="https://github.com/huggingface/accelerate/blob/main/docs/source/package_reference/tracking.md" />