import{s as ai,n as oi,o as ri}from"../chunks/scheduler.008aaf19.js";import{S as pi,i as ui,e as a,s as n,c as p,h as Mi,a as o,d as l,b as i,f as ke,g as u,j as r,k as he,l as w,m as s,n as M,t as m,o as d,p as y}from"../chunks/index.7c7f75b2.js";import{Y as ii}from"../chunks/Youtube.79476af5.js";import{C as h}from"../chunks/CodeBlock.027569b9.js";import{H as T,E as mi}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.4f0ca956.js";function di(zs){let J,_e,Ae,He,v,Ze,b,Le,x,Ns="It’s your first week at CodeCraft Studios, and you’re witnessing something that makes every developer cringe. The team’s pull requests look like this:",Re,A,Ys="<li>“stuff”</li> <li>“more changes”</li> <li>“fix”</li> <li>“update things”</li>",Ge,B,Xs="Meanwhile, the code review backlog is growing because reviewers can’t understand what changed or why. Sarah from the backend team spent 30 minutes trying to figure out what “various improvements” actually meant, while Mike from frontend had to dig through 47 files to understand a “small fix.”",We,k,Es="The team knows they need better PR descriptions, but everyone’s too busy shipping features to write detailed explanations. They need a solution that helps without slowing them down.",Pe,_,Ss="<strong>Your mission</strong>: Build an intelligent PR Agent that analyzes code changes and suggests helpful descriptions automatically.",Ve,H,ze,Z,Ne,L,Qs="<strong>What You’ll See</strong>: A real PR at CodeCraft Studios titled “various improvements” and the description simply says “Fixed some stuff and made updates”. Classic, right?",Ye,R,qs="<strong>The Confusion</strong>: Watch as teammates struggle:",Xe,G,Fs="<li><strong>Sarah</strong> (3 hours ago): “What was fixed? I see changes to the User model but can’t tell if this is addressing a bug or adding features”</li> <li><strong>Jamie</strong> (3 hours ago): “There are 8 files across 4 services… are these changes related? What should I focus on during review?”</li>",Ee,W,Os="<strong>The Pain Point</strong>: The screencast shows the actual diff—8 files scattered across multiple services with zero context. Reviewers have to piece together the story themselves, wasting precious time and possibly missing critical issues.",Se,P,Ds="<strong>Why This Matters</strong>: This is exactly the PR chaos your MCP server will solve! By the end of this module, you’ll turn these cryptic PRs into clear, actionable descriptions that make everyone’s life easier.",Qe,V,qe,z,Ks="In this first module, you’ll create the foundation of CodeCraft Studios’ automation system: an MCP server that transforms how the team writes pull requests. This module focuses on core MCP concepts that you’ll build upon in Modules 2 and 3.",Fe,N,Oe,Y,De,X,tn="<strong>The Solution in Action</strong>: Watch how your MCP server will transform PR chaos into clarity:",Ke,E,en="<li><strong><code>analyze_file_changes</code></strong> - Grabs all the changes (453 lines across 8 files!)</li> <li><strong><code>get_pr_templates</code></strong> - Shows Claude the 7 templates to choose from</li> <li><strong><code>suggest_template</code></strong> - Claude picks “Feature” (smart choice!)</li>",tl,S,ln="<strong>What You’ll See</strong>: Claude doesn’t just pick a template—it:",el,Q,sn="<li>Writes a clear summary of what actually changed</li> <li>Spots security issues (yikes, unhashed passwords!)</li> <li>Creates a nice to-do list for follow-up work</li> <li>Even prioritizes what needs fixing first</li>",ll,q,nn="<strong>The “Wow” Moment</strong> ✨: In just seconds, your MCP server helps Claude transform the same branch into a PR that actually explains what’s going on. No more confused reviewers, no more “what does this do?” comments.",sl,F,an="<strong>This is what you’ll build</strong>: A tool that turns PR dread into PR delight—let’s get started!",nl,O,il,D,on="In this foundational module, you’ll master:",al,K,rn="<li><strong>How to create a basic MCP server using FastMCP</strong> - The building blocks for Modules 2 and 3</li> <li><strong>Implementing MCP Tools for data retrieval and analysis</strong> - The core primitive you’ll use throughout Unit 3</li> <li><strong>Letting Claude make intelligent decisions based on raw data</strong> - A key principle for all MCP development</li> <li><strong>Testing and validating your MCP server</strong> - Essential skills for building reliable tools</li>",ol,tt,rl,et,pn="Your PR Agent will solve CodeCraft Studios’ problem using a key principle of MCP development: instead of hard-coding rigid rules about what makes a good PR, you’ll provide Claude with raw git data and let it intelligently suggest appropriate descriptions.",pl,lt,un="This approach works because:",ul,st,Mn="<li><strong>Flexible analysis</strong>: Claude can understand context that simple rules miss</li> <li><strong>Natural language</strong>: Suggestions feel human, not robotic</li> <li><strong>Adaptable</strong>: Works for any codebase or coding style</li>",Ml,nt,mn="You’ll implement three essential tools that establish patterns for the entire automation system:",ml,it,dn="<li><strong>analyze_file_changes</strong> - Retrieves git diff information and changed files (data collection)</li> <li><strong>get_pr_templates</strong> - Lists available PR templates (resource management)</li> <li><strong>suggest_template</strong> - Allows Claude to recommend the most appropriate template (intelligent decision-making)</li>",dl,at,yl,ot,Tl,rt,yn='<li>Python 3.10 or higher</li> <li>Git installed and a git repository to test with</li> <li>uv package manager (<a href="https://docs.astral.sh/uv/getting-started/installation/" rel="nofollow">installation guide</a>)</li>',wl,pt,fl,ut,Tn="Clone the starter code repository:",cl,Mt,hl,mt,wn="Navigate to the starter code directory:",Jl,dt,gl,yt,fn="Install dependencies:",Cl,g,Je,cn="You might want to create a virtual environment for this project:",_s,Tt,jl,wt,Il,ft,Ul,ct,hn="This is your first hands-on MCP development experience! Open <code>server.py</code> and implement the three tools following the TODO comments. The starter code provides the basic structure - you need to:",$l,ht,Jn="<li><strong>Implement <code>analyze_file_changes</code></strong> to run git commands and return diff data<ul><li>⚠️ <strong>Important</strong>: You’ll likely hit a token limit error (25,000 tokens max per response)</li> <li>This is a real-world constraint that teaches proper output management</li> <li>See the “Handling Large Outputs” section below for the solution</li> <li>⚠️ <strong>Note</strong>: Git commands will run in the MCP server’s directory by default. See “Working Directory Considerations” below for details</li></ul></li> <li><strong>Implement <code>get_pr_templates</code></strong> to manage and return PR templates</li> <li><strong>Implement <code>suggest_template</code></strong> to map change types to templates</li>",vl,Jt,gn="Don’t worry about making everything perfect - you’ll refine these skills as you progress through the unit.",bl,gt,xl,Ct,Cn="Unlike traditional systems that categorize changes based on file extensions or rigid patterns, your implementation should:",Al,jt,jn="<li>Provide Claude with raw git data (diffs, file lists, statistics)</li> <li>Let Claude analyze the actual code changes</li> <li>Allow Claude to make intelligent template suggestions</li> <li>Keep the logic simple - Claude handles the complexity</li>",Bl,j,In="<p><strong>MCP Philosophy</strong>: Instead of building complex logic into your tools, provide Claude with rich data and let its intelligence make the decisions. This makes your code simpler and more flexible than traditional rule-based systems.</p>",kl,It,_l,Ut,Hl,$t,Un="Run the validation script to check your implementation:",Zl,vt,Ll,bt,Rl,xt,$n="Test your implementation with the provided test suite:",Gl,At,Wl,Bt,Pl,kt,vn="Configure your server directly in Claude Code:",Vl,_t,zl,Ht,bn="Then:",Nl,Zt,xn="<li>Make some changes in a git repository</li> <li>Ask Claude: “Can you analyze my changes and suggest a PR template?”</li> <li>Watch Claude use your tools to provide intelligent suggestions</li>",Yl,I,An="<p><strong>Common first error</strong>: If you get “MCP tool response exceeds maximum allowed tokens (25000)”, this is expected! Large repositories can generate massive diffs. This is a valuable learning moment - see the “Handling Large Outputs” section for the solution.</p>",Xl,Lt,El,Rt,Sl,Gt,Ql,Wt,ql,Pt,Bn="Always handle potential errors gracefully:",Fl,Vt,Ol,U,kn="<p><strong>Error Handling</strong>: Always return valid JSON from your tools, even for errors. Claude needs structured data to understand what went wrong and provide helpful responses to users.</p>",Dl,zt,Kl,$,_n="<p><strong>Real-world constraint</strong>: MCP tools have a token limit of 25,000 tokens per response. Large git diffs can easily exceed this limit 10x or more! This is a critical lesson for production MCP development.</p>",ts,Nt,Hn="When implementing <code>analyze_file_changes</code>, you’ll likely encounter this error:",es,Yt,ls,Xt,Zn="<strong>Why this happens:</strong>",ss,Et,Ln="<li>A single file change can be thousands of lines</li> <li>Enterprise repositories often have massive refactorings</li> <li>Git diffs include full context by default</li> <li>JSON encoding adds overhead</li>",ns,St,Rn="This teaches us an important principle: <strong>Always design tools with output limits in mind</strong>. Here’s the solution:",is,Qt,as,qt,Gn="<strong>Best practices for large outputs:</strong>",os,Ft,Wn="<li><strong>Implement pagination</strong>: Break large results into pages</li> <li><strong>Add filtering options</strong>: Let users request specific files or directories</li> <li><strong>Provide summaries first</strong>: Return statistics before full content</li> <li><strong>Use progressive disclosure</strong>: Start with high-level info, allow drilling down</li> <li><strong>Set sensible defaults</strong>: Default to reasonable limits that work for most cases</li>",rs,Ot,ps,Dt,Pn="By default, MCP servers run commands in their installation directory, not in Claude’s current working directory. This means your git commands might analyze the wrong repository!",us,Kt,Vn='To solve this, MCP provides <a href="https://modelcontextprotocol.io/docs/concepts/roots" rel="nofollow">roots</a> - a way for clients to inform servers about relevant directories. Claude Code automatically provides its working directory as a root.',Ms,te,zn="Here’s how to access it in your tool:",ms,ee,ds,le,Nn="This ensures your tools operate on the repository Claude is actually working with, not the MCP server’s installation location.",ys,se,Ts,f,ge,Yn="<p><strong>Import errors</strong>: Ensure you’ve run <code>uv sync</code></p>",Hs,Ce,Xn="<p><strong>Git errors</strong>: Make sure you’re in a git repository</p>",Zs,je,En="<p><strong>No output</strong>: MCP servers communicate via stdio - test with Claude Desktop</p>",Ls,Ie,Sn="<p><strong>JSON errors</strong>: All tools must return valid JSON strings</p>",Rs,Ue,Qn="<p><strong>Token limit exceeded</strong>: This is expected with large diffs! Implement output limiting as shown above</p>",Gs,$e,qn="<p><strong>“Response too large” errors</strong>: Add <code>max_diff_lines</code> parameter or set <code>include_diff=false</code></p>",Ws,C,ve,Fn='<strong>Git commands run in wrong directory</strong>: MCP servers run in their installation directory by default, not Claude’s working directory. To fix this, use <a href="https://modelcontextprotocol.io/docs/concepts/roots" rel="nofollow">MCP roots</a> to access Claude’s current directory:',Ps,ne,Vs,be,On="Claude Code automatically provides its working directory as a root, allowing your MCP server to operate in the correct location.",ws,ie,fs,ae,Dn="Congratulations! You’ve built your first MCP server with Tools - the foundation for everything that follows in Unit 3.",cs,oe,hs,re,Kn="<li><strong>Created MCP Tools</strong> that provide Claude with structured data</li> <li><strong>Implemented the core MCP philosophy</strong> - let Claude make intelligent decisions from raw data</li> <li><strong>Built a practical PR Agent</strong> that can analyze code changes and suggest templates</li> <li><strong>Learned about real-world constraints</strong> - the 25,000 token limit and how to handle it</li> <li><strong>Established testing patterns</strong> with validation scripts and unit tests</li>",Js,pe,gs,ue,ti="<li><strong>Data collection tools</strong> that gather information from external sources</li> <li><strong>Intelligent analysis</strong> where Claude processes raw data to make decisions</li> <li><strong>Output management</strong> - truncating large responses while preserving usefulness</li> <li><strong>Error handling</strong> that returns structured JSON responses</li> <li><strong>Testing strategies</strong> for MCP server development</li>",Cs,Me,js,me,ei="<li><strong>Review the solution</strong> in <code>/projects/unit3/build-mcp-server/solution/</code> to see different implementation approaches</li> <li><strong>Compare your implementation</strong> with the provided solution - there’s no single “right” way to solve the problem</li> <li><strong>Test your tools thoroughly</strong> - try them with different types of code changes to see how Claude adapts</li> <li><strong>Move on to Module 2</strong> where you’ll add real-time webhook capabilities and learn about MCP Prompts for workflow standardization</li>",Is,de,li="Module 2 will build directly on the server you created here, adding dynamic event handling to complement your static file analysis tools!",Us,ye,$s,Te,si="With your PR Agent working, CodeCraft Studios developers are already writing better pull requests. But next week, you’ll face a new challenge: critical CI/CD failures are slipping through unnoticed. Module 2 will add real-time monitoring to catch these issues before they reach production.",vs,we,bs,fe,ni='<li><a href="https://modelcontextprotocol.io/" rel="nofollow">MCP Documentation</a></li> <li><a href="https://modelcontextprotocol.io/quickstart/server" rel="nofollow">FastMCP Guide</a></li> <li>Solution walkthrough: <code>unit3/build-mcp-server-solution-walkthrough.md</code></li>',xs,ce,As,Be,Bs;return v=new T({props:{title:"Module 1: Build MCP Server",local:"module-1-build-mcp-server",headingTag:"h1"}}),b=new T({props:{title:"The PR Chaos at CodeCraft Studios",local:"the-pr-chaos-at-codecraft-studios",headingTag:"h2"}}),H=new T({props:{title:"Screencast: The PR Problem in Action 😬",local:"screencast-the-pr-problem-in-action-",headingTag:"h3"}}),Z=new ii({props:{id:"tskAUPWFPP0"}}),V=new T({props:{title:"What You’ll Build",local:"what-youll-build",headingTag:"h2"}}),N=new T({props:{title:"Screencast: Your PR Agent Saves the Day! 🚀",local:"screencast-your-pr-agent-saves-the-day-",headingTag:"h3"}}),Y=new ii({props:{id:"OaAWJLvnlqc"}}),O=new T({props:{title:"What You Will Learn",local:"what-you-will-learn",headingTag:"h2"}}),tt=new T({props:{title:"Overview",local:"overview",headingTag:"h2"}}),at=new T({props:{title:"Getting Started",local:"getting-started",headingTag:"h2"}}),ot=new T({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h3"}}),pt=new T({props:{title:"Starter Code",local:"starter-code",headingTag:"h3"}}),Mt=new h({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRm1jcC1jb3Vyc2UuZ2l0",highlighted:'git <span class="hljs-built_in">clone</span> https://github.com/huggingface/mcp-course.git',wrap:!1}}),dt=new h({props:{code:"Y2QlMjBtY3AtY291cnNlJTJGcHJvamVjdHMlMkZ1bml0MyUyRmJ1aWxkLW1jcC1zZXJ2ZXIlMkZzdGFydGVy",highlighted:'<span class="hljs-built_in">cd</span> mcp-course/projects/unit3/build-mcp-server/starter',wrap:!1}}),Tt=new h({props:{code:"dXYlMjB2ZW52JTIwLnZlbnYlMEFzb3VyY2UlMjAudmVudiUyRmJpbiUyRmFjdGl2YXRlJTIwJTIzJTIwT24lMjBXaW5kb3dzJTIwdXNlJTNBJTIwLnZlbnYlNUNTY3JpcHRzJTVDYWN0aXZhdGU=",highlighted:`uv venv .venv
<span class="hljs-built_in">source</span> .venv/bin/activate <span class="hljs-comment"># On Windows use: .venv\\Scripts\\activate</span>`,wrap:!1}}),wt=new h({props:{code:"dXYlMjBzeW5jJTIwLS1hbGwtZXh0cmFz",highlighted:'uv <span class="hljs-built_in">sync</span> --all-extras',wrap:!1}}),ft=new T({props:{title:"Your Task",local:"your-task",headingTag:"h3"}}),gt=new T({props:{title:"Design Philosophy",local:"design-philosophy",headingTag:"h3"}}),It=new T({props:{title:"Testing Your Implementation",local:"testing-your-implementation",headingTag:"h2"}}),Ut=new T({props:{title:"1. Validate Your Code",local:"1-validate-your-code",headingTag:"h3"}}),vt=new h({props:{code:"dXYlMjBydW4lMjBweXRob24lMjB2YWxpZGF0ZV9zdGFydGVyLnB5",highlighted:"uv run python validate_starter.py",wrap:!1}}),bt=new T({props:{title:"2. Run Unit Tests",local:"2-run-unit-tests",headingTag:"h3"}}),At=new h({props:{code:"dXYlMjBydW4lMjBweXRlc3QlMjB0ZXN0X3NlcnZlci5weSUyMC12",highlighted:"uv run pytest test_server.py -v",wrap:!1}}),Bt=new T({props:{title:"3. Test with Claude Code",local:"3-test-with-claude-code",headingTag:"h3"}}),_t=new h({props:{code:"JTIzJTIwQWRkJTIwdGhlJTIwTUNQJTIwc2VydmVyJTIwdG8lMjBDbGF1ZGUlMjBDb2RlJTBBY2xhdWRlJTIwbWNwJTIwYWRkJTIwcHItYWdlbnQlMjAtLSUyMHV2JTIwLS1kaXJlY3RvcnklMjAlMkZhYnNvbHV0ZSUyRnBhdGglMkZ0byUyRnN0YXJ0ZXIlMjBydW4lMjBzZXJ2ZXIucHklMEElMEElMjMlMjBWZXJpZnklMjB0aGUlMjBzZXJ2ZXIlMjBpcyUyMGNvbmZpZ3VyZWQlMEFjbGF1ZGUlMjBtY3AlMjBsaXN0",highlighted:`<span class="hljs-comment"># Add the MCP server to Claude Code</span>
claude mcp add pr-agent -- uv --directory /absolute/path/to/starter run server.py

<span class="hljs-comment"># Verify the server is configured</span>
claude mcp list`,wrap:!1}}),Lt=new T({props:{title:"Common Patterns",local:"common-patterns",headingTag:"h2"}}),Rt=new T({props:{title:"Tool Implementation Pattern",local:"tool-implementation-pattern",headingTag:"h3"}}),Gt=new h({props:{code:"JTQwbWNwLnRvb2woKSUwQWFzeW5jJTIwZGVmJTIwdG9vbF9uYW1lKHBhcmFtMSUzQSUyMHN0ciUyQyUyMHBhcmFtMiUzQSUyMGJvb2wlMjAlM0QlMjBUcnVlKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJUb29sJTIwZGVzY3JpcHRpb24lMjBmb3IlMjBDbGF1ZGUuJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwQXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhcmFtMSUzQSUyMERlc2NyaXB0aW9uJTIwb2YlMjBwYXJhbWV0ZXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYXJhbTIlM0ElMjBPcHRpb25hbCUyMHBhcmFtZXRlciUyMHdpdGglMjBkZWZhdWx0JTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIzJTIwWW91ciUyMGltcGxlbWVudGF0aW9uJTBBJTIwJTIwJTIwJTIwcmVzdWx0JTIwJTNEJTIwJTdCJTIya2V5JTIyJTNBJTIwJTIydmFsdWUlMjIlN0QlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBqc29uLmR1bXBzKHJlc3VsdCk=",highlighted:`<span class="hljs-meta">@mcp.tool()</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">tool_name</span>(<span class="hljs-params">param1: <span class="hljs-built_in">str</span>, param2: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">True</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Tool description for Claude.
    
    Args:
        param1: Description of parameter
        param2: Optional parameter with default
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Your implementation</span>
    result = {<span class="hljs-string">&quot;key&quot;</span>: <span class="hljs-string">&quot;value&quot;</span>}
    <span class="hljs-keyword">return</span> json.dumps(result)`,wrap:!1}}),Wt=new T({props:{title:"Error Handling",local:"error-handling",headingTag:"h3"}}),Vt=new h({props:{code:"dHJ5JTNBJTBBJTIwJTIwJTIwJTIwcmVzdWx0JTIwJTNEJTIwc3VicHJvY2Vzcy5ydW4oJTVCJTIyZ2l0JTIyJTJDJTIwJTIyZGlmZiUyMiU1RCUyQyUyMGNhcHR1cmVfb3V0cHV0JTNEVHJ1ZSUyQyUyMHRleHQlM0RUcnVlKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGpzb24uZHVtcHMoJTdCJTIyb3V0cHV0JTIyJTNBJTIwcmVzdWx0LnN0ZG91dCU3RCklMEFleGNlcHQlMjBFeGNlcHRpb24lMjBhcyUyMGUlM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBqc29uLmR1bXBzKCU3QiUyMmVycm9yJTIyJTNBJTIwc3RyKGUpJTdEKQ==",highlighted:`<span class="hljs-keyword">try</span>:
    result = subprocess.run([<span class="hljs-string">&quot;git&quot;</span>, <span class="hljs-string">&quot;diff&quot;</span>], capture_output=<span class="hljs-literal">True</span>, text=<span class="hljs-literal">True</span>)
    <span class="hljs-keyword">return</span> json.dumps({<span class="hljs-string">&quot;output&quot;</span>: result.stdout})
<span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
    <span class="hljs-keyword">return</span> json.dumps({<span class="hljs-string">&quot;error&quot;</span>: <span class="hljs-built_in">str</span>(e)})`,wrap:!1}}),zt=new T({props:{title:"Handling Large Outputs (Critical Learning Moment!)",local:"handling-large-outputs-critical-learning-moment",headingTag:"h3"}}),Yt=new h({props:{code:"RXJyb3IlM0ElMjBNQ1AlMjB0b29sJTIwcmVzcG9uc2UlMjAoMjYyNTIxJTIwdG9rZW5zKSUyMGV4Y2VlZHMlMjBtYXhpbXVtJTIwYWxsb3dlZCUyMHRva2VucyUyMCgyNTAwMCk=",highlighted:'<span class="hljs-keyword">Error: </span>MCP tool response (262521 tokens) exceeds maximum allowed tokens (25000)',wrap:!1}}),Qt=new h({props:{code:"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",highlighted:`<span class="hljs-meta">@mcp.tool()</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">analyze_file_changes</span>(<span class="hljs-params">base_branch: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;main&quot;</span>, 
                              include_diff: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">True</span>,
                              max_diff_lines: <span class="hljs-built_in">int</span> = <span class="hljs-number">500</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Analyze file changes with smart output limiting.
    
    Args:
        base_branch: Branch to compare against
        include_diff: Whether to include the actual diff
        max_diff_lines: Maximum diff lines to include (default 500)
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Get the diff</span>
        result = subprocess.run(
            [<span class="hljs-string">&quot;git&quot;</span>, <span class="hljs-string">&quot;diff&quot;</span>, <span class="hljs-string">f&quot;<span class="hljs-subst">{base_branch}</span>...HEAD&quot;</span>],
            capture_output=<span class="hljs-literal">True</span>, 
            text=<span class="hljs-literal">True</span>
        )
        
        diff_output = result.stdout
        diff_lines = diff_output.split(<span class="hljs-string">&#x27;\\n&#x27;</span>)
        
        <span class="hljs-comment"># Smart truncation if needed</span>
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(diff_lines) &gt; max_diff_lines:
            truncated_diff = <span class="hljs-string">&#x27;\\n&#x27;</span>.join(diff_lines[:max_diff_lines])
            truncated_diff += <span class="hljs-string">f&quot;\\n\\n... Output truncated. Showing <span class="hljs-subst">{max_diff_lines}</span> of <span class="hljs-subst">{<span class="hljs-built_in">len</span>(diff_lines)}</span> lines ...&quot;</span>
            diff_output = truncated_diff
        
        <span class="hljs-comment"># Get summary statistics</span>
        stats_result = subprocess.run(
            [<span class="hljs-string">&quot;git&quot;</span>, <span class="hljs-string">&quot;diff&quot;</span>, <span class="hljs-string">&quot;--stat&quot;</span>, <span class="hljs-string">f&quot;<span class="hljs-subst">{base_branch}</span>...HEAD&quot;</span>],
            capture_output=<span class="hljs-literal">True</span>,
            text=<span class="hljs-literal">True</span>
        )
        
        <span class="hljs-keyword">return</span> json.dumps({
            <span class="hljs-string">&quot;stats&quot;</span>: stats_result.stdout,
            <span class="hljs-string">&quot;total_lines&quot;</span>: <span class="hljs-built_in">len</span>(diff_lines),
            <span class="hljs-string">&quot;diff&quot;</span>: diff_output <span class="hljs-keyword">if</span> include_diff <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;Use include_diff=true to see diff&quot;</span>,
            <span class="hljs-string">&quot;files_changed&quot;</span>: self._get_changed_files(base_branch)
        })
        
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> json.dumps({<span class="hljs-string">&quot;error&quot;</span>: <span class="hljs-built_in">str</span>(e)})`,wrap:!1}}),Ot=new T({props:{title:"Working Directory Considerations",local:"working-directory-considerations",headingTag:"h2"}}),ee=new h({props:{code:"JTQwbWNwLnRvb2woKSUwQWFzeW5jJTIwZGVmJTIwYW5hbHl6ZV9maWxlX2NoYW5nZXMoLi4uKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEdldCUyMENsYXVkZSdzJTIwd29ya2luZyUyMGRpcmVjdG9yeSUyMGZyb20lMjByb290cyUwQSUyMCUyMCUyMCUyMGNvbnRleHQlMjAlM0QlMjBtY3AuZ2V0X2NvbnRleHQoKSUwQSUyMCUyMCUyMCUyMHJvb3RzX3Jlc3VsdCUyMCUzRCUyMGF3YWl0JTIwY29udGV4dC5zZXNzaW9uLmxpc3Rfcm9vdHMoKSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMEV4dHJhY3QlMjB0aGUlMjBwYXRoJTIwZnJvbSUyMHRoZSUyMEZpbGVVcmwlMjBvYmplY3QlMEElMjAlMjAlMjAlMjB3b3JraW5nX2RpciUyMCUzRCUyMHJvb3RzX3Jlc3VsdC5yb290cyU1QjAlNUQudXJpLnBhdGglMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBVc2UlMjBpdCUyMGZvciUyMGFsbCUyMGdpdCUyMGNvbW1hbmRzJTBBJTIwJTIwJTIwJTIwcmVzdWx0JTIwJTNEJTIwc3VicHJvY2Vzcy5ydW4oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTIyZ2l0JTIyJTJDJTIwJTIyZGlmZiUyMiUyQyUyMCUyMi0tbmFtZS1zdGF0dXMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYXB0dXJlX291dHB1dCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0ZXh0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGN3ZCUzRHdvcmtpbmdfZGlyJTIwJTIwJTIzJTIwUnVuJTIwaW4lMjBDbGF1ZGUncyUyMGRpcmVjdG9yeSElMEElMjAlMjAlMjAlMjAp",highlighted:`<span class="hljs-meta">@mcp.tool()</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">analyze_file_changes</span>(<span class="hljs-params">...</span>):
    <span class="hljs-comment"># Get Claude&#x27;s working directory from roots</span>
    context = mcp.get_context()
    roots_result = <span class="hljs-keyword">await</span> context.session.list_roots()
    
    <span class="hljs-comment"># Extract the path from the FileUrl object</span>
    working_dir = roots_result.roots[<span class="hljs-number">0</span>].uri.path
    
    <span class="hljs-comment"># Use it for all git commands</span>
    result = subprocess.run(
        [<span class="hljs-string">&quot;git&quot;</span>, <span class="hljs-string">&quot;diff&quot;</span>, <span class="hljs-string">&quot;--name-status&quot;</span>],
        capture_output=<span class="hljs-literal">True</span>,
        text=<span class="hljs-literal">True</span>,
        cwd=working_dir  <span class="hljs-comment"># Run in Claude&#x27;s directory!</span>
    )`,wrap:!1}}),se=new T({props:{title:"Troubleshooting",local:"troubleshooting",headingTag:"h2"}}),ne=new h({props:{code:"JTIzJTIwR2V0JTIwQ2xhdWRlJ3MlMjB3b3JraW5nJTIwZGlyZWN0b3J5JTIwZnJvbSUyMHJvb3RzJTBBY29udGV4dCUyMCUzRCUyMG1jcC5nZXRfY29udGV4dCgpJTBBcm9vdHNfcmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBjb250ZXh0LnNlc3Npb24ubGlzdF9yb290cygpJTBBd29ya2luZ19kaXIlMjAlM0QlMjByb290c19yZXN1bHQucm9vdHMlNUIwJTVELnVyaS5wYXRoJTIwJTIwJTIzJTIwRmlsZVVybCUyMG9iamVjdCUyMGhhcyUyMC5wYXRoJTIwcHJvcGVydHklMEElMEElMjMlMjBVc2UlMjBpdCUyMGluJTIwc3VicHJvY2VzcyUyMGNhbGxzJTBBc3VicHJvY2Vzcy5ydW4oJTVCJTIyZ2l0JTIyJTJDJTIwJTIyZGlmZiUyMiU1RCUyQyUyMGN3ZCUzRHdvcmtpbmdfZGlyKQ==",highlighted:`<span class="hljs-comment"># Get Claude&#x27;s working directory from roots</span>
context = mcp.get_context()
roots_result = <span class="hljs-keyword">await</span> context.session.list_roots()
working_dir = roots_result.roots[<span class="hljs-number">0</span>].uri.path  <span class="hljs-comment"># FileUrl object has .path property</span>

<span class="hljs-comment"># Use it in subprocess calls</span>
subprocess.run([<span class="hljs-string">&quot;git&quot;</span>, <span class="hljs-string">&quot;diff&quot;</span>], cwd=working_dir)`,wrap:!1}}),ie=new T({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),oe=new T({props:{title:"What you’ve accomplished in Module 1:",local:"what-youve-accomplished-in-module-1",headingTag:"h3"}}),pe=new T({props:{title:"Key patterns you can reuse:",local:"key-patterns-you-can-reuse",headingTag:"h3"}}),Me=new T({props:{title:"What to do next:",local:"what-to-do-next",headingTag:"h3"}}),ye=new T({props:{title:"The story continues…",local:"the-story-continues",headingTag:"h3"}}),we=new T({props:{title:"Additional Resources",local:"additional-resources",headingTag:"h2"}}),ce=new mi({props:{source:"https://github.com/huggingface/mcp-course/blob/main/units/en/unit3/build-mcp-server.mdx"}}),{c(){J=a("meta"),_e=n(),Ae=a("p"),He=n(),p(v.$$.fragment),Ze=n(),p(b.$$.fragment),Le=n(),x=a("p"),x.textContent=Ns,Re=n(),A=a("ul"),A.innerHTML=Ys,Ge=n(),B=a("p"),B.textContent=Xs,We=n(),k=a("p"),k.textContent=Es,Pe=n(),_=a("p"),_.innerHTML=Ss,Ve=n(),p(H.$$.fragment),ze=n(),p(Z.$$.fragment),Ne=n(),L=a("p"),L.innerHTML=Qs,Ye=n(),R=a("p"),R.innerHTML=qs,Xe=n(),G=a("ul"),G.innerHTML=Fs,Ee=n(),W=a("p"),W.innerHTML=Os,Se=n(),P=a("p"),P.innerHTML=Ds,Qe=n(),p(V.$$.fragment),qe=n(),z=a("p"),z.textContent=Ks,Fe=n(),p(N.$$.fragment),Oe=n(),p(Y.$$.fragment),De=n(),X=a("p"),X.innerHTML=tn,Ke=n(),E=a("ol"),E.innerHTML=en,tl=n(),S=a("p"),S.innerHTML=ln,el=n(),Q=a("ul"),Q.innerHTML=sn,ll=n(),q=a("p"),q.innerHTML=nn,sl=n(),F=a("p"),F.innerHTML=an,nl=n(),p(O.$$.fragment),il=n(),D=a("p"),D.textContent=on,al=n(),K=a("ul"),K.innerHTML=rn,ol=n(),p(tt.$$.fragment),rl=n(),et=a("p"),et.textContent=pn,pl=n(),lt=a("p"),lt.textContent=un,ul=n(),st=a("ul"),st.innerHTML=Mn,Ml=n(),nt=a("p"),nt.textContent=mn,ml=n(),it=a("ol"),it.innerHTML=dn,dl=n(),p(at.$$.fragment),yl=n(),p(ot.$$.fragment),Tl=n(),rt=a("ul"),rt.innerHTML=yn,wl=n(),p(pt.$$.fragment),fl=n(),ut=a("p"),ut.textContent=Tn,cl=n(),p(Mt.$$.fragment),hl=n(),mt=a("p"),mt.textContent=wn,Jl=n(),p(dt.$$.fragment),gl=n(),yt=a("p"),yt.textContent=fn,Cl=n(),g=a("blockquote"),Je=a("p"),Je.textContent=cn,_s=n(),p(Tt.$$.fragment),jl=n(),p(wt.$$.fragment),Il=n(),p(ft.$$.fragment),Ul=n(),ct=a("p"),ct.innerHTML=hn,$l=n(),ht=a("ol"),ht.innerHTML=Jn,vl=n(),Jt=a("p"),Jt.textContent=gn,bl=n(),p(gt.$$.fragment),xl=n(),Ct=a("p"),Ct.textContent=Cn,Al=n(),jt=a("ul"),jt.innerHTML=jn,Bl=n(),j=a("blockquote"),j.innerHTML=In,kl=n(),p(It.$$.fragment),_l=n(),p(Ut.$$.fragment),Hl=n(),$t=a("p"),$t.textContent=Un,Zl=n(),p(vt.$$.fragment),Ll=n(),p(bt.$$.fragment),Rl=n(),xt=a("p"),xt.textContent=$n,Gl=n(),p(At.$$.fragment),Wl=n(),p(Bt.$$.fragment),Pl=n(),kt=a("p"),kt.textContent=vn,Vl=n(),p(_t.$$.fragment),zl=n(),Ht=a("p"),Ht.textContent=bn,Nl=n(),Zt=a("ol"),Zt.innerHTML=xn,Yl=n(),I=a("blockquote"),I.innerHTML=An,Xl=n(),p(Lt.$$.fragment),El=n(),p(Rt.$$.fragment),Sl=n(),p(Gt.$$.fragment),Ql=n(),p(Wt.$$.fragment),ql=n(),Pt=a("p"),Pt.textContent=Bn,Fl=n(),p(Vt.$$.fragment),Ol=n(),U=a("blockquote"),U.innerHTML=kn,Dl=n(),p(zt.$$.fragment),Kl=n(),$=a("blockquote"),$.innerHTML=_n,ts=n(),Nt=a("p"),Nt.innerHTML=Hn,es=n(),p(Yt.$$.fragment),ls=n(),Xt=a("p"),Xt.innerHTML=Zn,ss=n(),Et=a("ul"),Et.innerHTML=Ln,ns=n(),St=a("p"),St.innerHTML=Rn,is=n(),p(Qt.$$.fragment),as=n(),qt=a("p"),qt.innerHTML=Gn,os=n(),Ft=a("ol"),Ft.innerHTML=Wn,rs=n(),p(Ot.$$.fragment),ps=n(),Dt=a("p"),Dt.textContent=Pn,us=n(),Kt=a("p"),Kt.innerHTML=Vn,Ms=n(),te=a("p"),te.textContent=zn,ms=n(),p(ee.$$.fragment),ds=n(),le=a("p"),le.textContent=Nn,ys=n(),p(se.$$.fragment),Ts=n(),f=a("ul"),ge=a("li"),ge.innerHTML=Yn,Hs=n(),Ce=a("li"),Ce.innerHTML=Xn,Zs=n(),je=a("li"),je.innerHTML=En,Ls=n(),Ie=a("li"),Ie.innerHTML=Sn,Rs=n(),Ue=a("li"),Ue.innerHTML=Qn,Gs=n(),$e=a("li"),$e.innerHTML=qn,Ws=n(),C=a("li"),ve=a("p"),ve.innerHTML=Fn,Ps=n(),p(ne.$$.fragment),Vs=n(),be=a("p"),be.textContent=On,ws=n(),p(ie.$$.fragment),fs=n(),ae=a("p"),ae.textContent=Dn,cs=n(),p(oe.$$.fragment),hs=n(),re=a("ul"),re.innerHTML=Kn,Js=n(),p(pe.$$.fragment),gs=n(),ue=a("ul"),ue.innerHTML=ti,Cs=n(),p(Me.$$.fragment),js=n(),me=a("ol"),me.innerHTML=ei,Is=n(),de=a("p"),de.textContent=li,Us=n(),p(ye.$$.fragment),$s=n(),Te=a("p"),Te.textContent=si,vs=n(),p(we.$$.fragment),bs=n(),fe=a("ul"),fe.innerHTML=ni,xs=n(),p(ce.$$.fragment),As=n(),Be=a("p"),this.h()},l(t){const e=Mi("svelte-u9bgzb",document.head);J=o(e,"META",{name:!0,content:!0}),e.forEach(l),_e=i(t),Ae=o(t,"P",{}),ke(Ae).forEach(l),He=i(t),u(v.$$.fragment,t),Ze=i(t),u(b.$$.fragment,t),Le=i(t),x=o(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-vhvp5g"&&(x.textContent=Ns),Re=i(t),A=o(t,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-13obdtv"&&(A.innerHTML=Ys),Ge=i(t),B=o(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1v10x2v"&&(B.textContent=Xs),We=i(t),k=o(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1kkfu2p"&&(k.textContent=Es),Pe=i(t),_=o(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-7pysu3"&&(_.innerHTML=Ss),Ve=i(t),u(H.$$.fragment,t),ze=i(t),u(Z.$$.fragment,t),Ne=i(t),L=o(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1klyf0j"&&(L.innerHTML=Qs),Ye=i(t),R=o(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-2255bx"&&(R.innerHTML=qs),Xe=i(t),G=o(t,"UL",{"data-svelte-h":!0}),r(G)!=="svelte-1h2xz45"&&(G.innerHTML=Fs),Ee=i(t),W=o(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1ct9gw"&&(W.innerHTML=Os),Se=i(t),P=o(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1v7m9ik"&&(P.innerHTML=Ds),Qe=i(t),u(V.$$.fragment,t),qe=i(t),z=o(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-clscq0"&&(z.textContent=Ks),Fe=i(t),u(N.$$.fragment,t),Oe=i(t),u(Y.$$.fragment,t),De=i(t),X=o(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-ssd8mn"&&(X.innerHTML=tn),Ke=i(t),E=o(t,"OL",{"data-svelte-h":!0}),r(E)!=="svelte-1i9xxww"&&(E.innerHTML=en),tl=i(t),S=o(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-per4uh"&&(S.innerHTML=ln),el=i(t),Q=o(t,"UL",{"data-svelte-h":!0}),r(Q)!=="svelte-z8n065"&&(Q.innerHTML=sn),ll=i(t),q=o(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-mhdfdo"&&(q.innerHTML=nn),sl=i(t),F=o(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-5rig2x"&&(F.innerHTML=an),nl=i(t),u(O.$$.fragment,t),il=i(t),D=o(t,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1ezp5zb"&&(D.textContent=on),al=i(t),K=o(t,"UL",{"data-svelte-h":!0}),r(K)!=="svelte-hmpvco"&&(K.innerHTML=rn),ol=i(t),u(tt.$$.fragment,t),rl=i(t),et=o(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-qdg2am"&&(et.textContent=pn),pl=i(t),lt=o(t,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-40ml58"&&(lt.textContent=un),ul=i(t),st=o(t,"UL",{"data-svelte-h":!0}),r(st)!=="svelte-4k3c7t"&&(st.innerHTML=Mn),Ml=i(t),nt=o(t,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1gozgls"&&(nt.textContent=mn),ml=i(t),it=o(t,"OL",{"data-svelte-h":!0}),r(it)!=="svelte-4k69gc"&&(it.innerHTML=dn),dl=i(t),u(at.$$.fragment,t),yl=i(t),u(ot.$$.fragment,t),Tl=i(t),rt=o(t,"UL",{"data-svelte-h":!0}),r(rt)!=="svelte-10oe0jt"&&(rt.innerHTML=yn),wl=i(t),u(pt.$$.fragment,t),fl=i(t),ut=o(t,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-1tl2u60"&&(ut.textContent=Tn),cl=i(t),u(Mt.$$.fragment,t),hl=i(t),mt=o(t,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-1vldaic"&&(mt.textContent=wn),Jl=i(t),u(dt.$$.fragment,t),gl=i(t),yt=o(t,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-axv5aq"&&(yt.textContent=fn),Cl=i(t),g=o(t,"BLOCKQUOTE",{class:!0});var ks=ke(g);Je=o(ks,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-zufirq"&&(Je.textContent=cn),_s=i(ks),u(Tt.$$.fragment,ks),ks.forEach(l),jl=i(t),u(wt.$$.fragment,t),Il=i(t),u(ft.$$.fragment,t),Ul=i(t),ct=o(t,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-1nnkssk"&&(ct.innerHTML=hn),$l=i(t),ht=o(t,"OL",{"data-svelte-h":!0}),r(ht)!=="svelte-1gs54fj"&&(ht.innerHTML=Jn),vl=i(t),Jt=o(t,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-17rpxqu"&&(Jt.textContent=gn),bl=i(t),u(gt.$$.fragment,t),xl=i(t),Ct=o(t,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-1tw0l7d"&&(Ct.textContent=Cn),Al=i(t),jt=o(t,"UL",{"data-svelte-h":!0}),r(jt)!=="svelte-1b4xw97"&&(jt.innerHTML=jn),Bl=i(t),j=o(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-v2ujqc"&&(j.innerHTML=In),kl=i(t),u(It.$$.fragment,t),_l=i(t),u(Ut.$$.fragment,t),Hl=i(t),$t=o(t,"P",{"data-svelte-h":!0}),r($t)!=="svelte-1bketfo"&&($t.textContent=Un),Zl=i(t),u(vt.$$.fragment,t),Ll=i(t),u(bt.$$.fragment,t),Rl=i(t),xt=o(t,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-6lvml"&&(xt.textContent=$n),Gl=i(t),u(At.$$.fragment,t),Wl=i(t),u(Bt.$$.fragment,t),Pl=i(t),kt=o(t,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-tb5xyy"&&(kt.textContent=vn),Vl=i(t),u(_t.$$.fragment,t),zl=i(t),Ht=o(t,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-1hbokgz"&&(Ht.textContent=bn),Nl=i(t),Zt=o(t,"OL",{"data-svelte-h":!0}),r(Zt)!=="svelte-1jsg5ih"&&(Zt.innerHTML=xn),Yl=i(t),I=o(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(I)!=="svelte-2segiz"&&(I.innerHTML=An),Xl=i(t),u(Lt.$$.fragment,t),El=i(t),u(Rt.$$.fragment,t),Sl=i(t),u(Gt.$$.fragment,t),Ql=i(t),u(Wt.$$.fragment,t),ql=i(t),Pt=o(t,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-1ovpou0"&&(Pt.textContent=Bn),Fl=i(t),u(Vt.$$.fragment,t),Ol=i(t),U=o(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(U)!=="svelte-y2wi52"&&(U.innerHTML=kn),Dl=i(t),u(zt.$$.fragment,t),Kl=i(t),$=o(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r($)!=="svelte-lyp3lr"&&($.innerHTML=_n),ts=i(t),Nt=o(t,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-15y2i0k"&&(Nt.innerHTML=Hn),es=i(t),u(Yt.$$.fragment,t),ls=i(t),Xt=o(t,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-w5rrym"&&(Xt.innerHTML=Zn),ss=i(t),Et=o(t,"UL",{"data-svelte-h":!0}),r(Et)!=="svelte-1ty0vuc"&&(Et.innerHTML=Ln),ns=i(t),St=o(t,"P",{"data-svelte-h":!0}),r(St)!=="svelte-fteq2z"&&(St.innerHTML=Rn),is=i(t),u(Qt.$$.fragment,t),as=i(t),qt=o(t,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-xxa07t"&&(qt.innerHTML=Gn),os=i(t),Ft=o(t,"OL",{"data-svelte-h":!0}),r(Ft)!=="svelte-72ex4k"&&(Ft.innerHTML=Wn),rs=i(t),u(Ot.$$.fragment,t),ps=i(t),Dt=o(t,"P",{"data-svelte-h":!0}),r(Dt)!=="svelte-1a0w1mv"&&(Dt.textContent=Pn),us=i(t),Kt=o(t,"P",{"data-svelte-h":!0}),r(Kt)!=="svelte-vlvnr3"&&(Kt.innerHTML=Vn),Ms=i(t),te=o(t,"P",{"data-svelte-h":!0}),r(te)!=="svelte-t6726k"&&(te.textContent=zn),ms=i(t),u(ee.$$.fragment,t),ds=i(t),le=o(t,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1a0xdvr"&&(le.textContent=Nn),ys=i(t),u(se.$$.fragment,t),Ts=i(t),f=o(t,"UL",{});var c=ke(f);ge=o(c,"LI",{"data-svelte-h":!0}),r(ge)!=="svelte-zj1iz3"&&(ge.innerHTML=Yn),Hs=i(c),Ce=o(c,"LI",{"data-svelte-h":!0}),r(Ce)!=="svelte-1alfdrz"&&(Ce.innerHTML=Xn),Zs=i(c),je=o(c,"LI",{"data-svelte-h":!0}),r(je)!=="svelte-je2hsd"&&(je.innerHTML=En),Ls=i(c),Ie=o(c,"LI",{"data-svelte-h":!0}),r(Ie)!=="svelte-i3wuk"&&(Ie.innerHTML=Sn),Rs=i(c),Ue=o(c,"LI",{"data-svelte-h":!0}),r(Ue)!=="svelte-v3vwzi"&&(Ue.innerHTML=Qn),Gs=i(c),$e=o(c,"LI",{"data-svelte-h":!0}),r($e)!=="svelte-15niooh"&&($e.innerHTML=qn),Ws=i(c),C=o(c,"LI",{});var xe=ke(C);ve=o(xe,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1qcqsui"&&(ve.innerHTML=Fn),Ps=i(xe),u(ne.$$.fragment,xe),Vs=i(xe),be=o(xe,"P",{"data-svelte-h":!0}),r(be)!=="svelte-kkjxh4"&&(be.textContent=On),xe.forEach(l),c.forEach(l),ws=i(t),u(ie.$$.fragment,t),fs=i(t),ae=o(t,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1uc8s16"&&(ae.textContent=Dn),cs=i(t),u(oe.$$.fragment,t),hs=i(t),re=o(t,"UL",{"data-svelte-h":!0}),r(re)!=="svelte-1t32by"&&(re.innerHTML=Kn),Js=i(t),u(pe.$$.fragment,t),gs=i(t),ue=o(t,"UL",{"data-svelte-h":!0}),r(ue)!=="svelte-y4867"&&(ue.innerHTML=ti),Cs=i(t),u(Me.$$.fragment,t),js=i(t),me=o(t,"OL",{"data-svelte-h":!0}),r(me)!=="svelte-vf50f7"&&(me.innerHTML=ei),Is=i(t),de=o(t,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1fpup7x"&&(de.textContent=li),Us=i(t),u(ye.$$.fragment,t),$s=i(t),Te=o(t,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-dsb8kb"&&(Te.textContent=si),vs=i(t),u(we.$$.fragment,t),bs=i(t),fe=o(t,"UL",{"data-svelte-h":!0}),r(fe)!=="svelte-4hc9qh"&&(fe.innerHTML=ni),xs=i(t),u(ce.$$.fragment,t),As=i(t),Be=o(t,"P",{}),ke(Be).forEach(l),this.h()},h(){he(J,"name","hf:doc:metadata"),he(J,"content",yi),he(g,"class","tip"),he(j,"class","tip"),he(I,"class","warning"),he(U,"class","warning"),he($,"class","warning")},m(t,e){w(document.head,J),s(t,_e,e),s(t,Ae,e),s(t,He,e),M(v,t,e),s(t,Ze,e),M(b,t,e),s(t,Le,e),s(t,x,e),s(t,Re,e),s(t,A,e),s(t,Ge,e),s(t,B,e),s(t,We,e),s(t,k,e),s(t,Pe,e),s(t,_,e),s(t,Ve,e),M(H,t,e),s(t,ze,e),M(Z,t,e),s(t,Ne,e),s(t,L,e),s(t,Ye,e),s(t,R,e),s(t,Xe,e),s(t,G,e),s(t,Ee,e),s(t,W,e),s(t,Se,e),s(t,P,e),s(t,Qe,e),M(V,t,e),s(t,qe,e),s(t,z,e),s(t,Fe,e),M(N,t,e),s(t,Oe,e),M(Y,t,e),s(t,De,e),s(t,X,e),s(t,Ke,e),s(t,E,e),s(t,tl,e),s(t,S,e),s(t,el,e),s(t,Q,e),s(t,ll,e),s(t,q,e),s(t,sl,e),s(t,F,e),s(t,nl,e),M(O,t,e),s(t,il,e),s(t,D,e),s(t,al,e),s(t,K,e),s(t,ol,e),M(tt,t,e),s(t,rl,e),s(t,et,e),s(t,pl,e),s(t,lt,e),s(t,ul,e),s(t,st,e),s(t,Ml,e),s(t,nt,e),s(t,ml,e),s(t,it,e),s(t,dl,e),M(at,t,e),s(t,yl,e),M(ot,t,e),s(t,Tl,e),s(t,rt,e),s(t,wl,e),M(pt,t,e),s(t,fl,e),s(t,ut,e),s(t,cl,e),M(Mt,t,e),s(t,hl,e),s(t,mt,e),s(t,Jl,e),M(dt,t,e),s(t,gl,e),s(t,yt,e),s(t,Cl,e),s(t,g,e),w(g,Je),w(g,_s),M(Tt,g,null),s(t,jl,e),M(wt,t,e),s(t,Il,e),M(ft,t,e),s(t,Ul,e),s(t,ct,e),s(t,$l,e),s(t,ht,e),s(t,vl,e),s(t,Jt,e),s(t,bl,e),M(gt,t,e),s(t,xl,e),s(t,Ct,e),s(t,Al,e),s(t,jt,e),s(t,Bl,e),s(t,j,e),s(t,kl,e),M(It,t,e),s(t,_l,e),M(Ut,t,e),s(t,Hl,e),s(t,$t,e),s(t,Zl,e),M(vt,t,e),s(t,Ll,e),M(bt,t,e),s(t,Rl,e),s(t,xt,e),s(t,Gl,e),M(At,t,e),s(t,Wl,e),M(Bt,t,e),s(t,Pl,e),s(t,kt,e),s(t,Vl,e),M(_t,t,e),s(t,zl,e),s(t,Ht,e),s(t,Nl,e),s(t,Zt,e),s(t,Yl,e),s(t,I,e),s(t,Xl,e),M(Lt,t,e),s(t,El,e),M(Rt,t,e),s(t,Sl,e),M(Gt,t,e),s(t,Ql,e),M(Wt,t,e),s(t,ql,e),s(t,Pt,e),s(t,Fl,e),M(Vt,t,e),s(t,Ol,e),s(t,U,e),s(t,Dl,e),M(zt,t,e),s(t,Kl,e),s(t,$,e),s(t,ts,e),s(t,Nt,e),s(t,es,e),M(Yt,t,e),s(t,ls,e),s(t,Xt,e),s(t,ss,e),s(t,Et,e),s(t,ns,e),s(t,St,e),s(t,is,e),M(Qt,t,e),s(t,as,e),s(t,qt,e),s(t,os,e),s(t,Ft,e),s(t,rs,e),M(Ot,t,e),s(t,ps,e),s(t,Dt,e),s(t,us,e),s(t,Kt,e),s(t,Ms,e),s(t,te,e),s(t,ms,e),M(ee,t,e),s(t,ds,e),s(t,le,e),s(t,ys,e),M(se,t,e),s(t,Ts,e),s(t,f,e),w(f,ge),w(f,Hs),w(f,Ce),w(f,Zs),w(f,je),w(f,Ls),w(f,Ie),w(f,Rs),w(f,Ue),w(f,Gs),w(f,$e),w(f,Ws),w(f,C),w(C,ve),w(C,Ps),M(ne,C,null),w(C,Vs),w(C,be),s(t,ws,e),M(ie,t,e),s(t,fs,e),s(t,ae,e),s(t,cs,e),M(oe,t,e),s(t,hs,e),s(t,re,e),s(t,Js,e),M(pe,t,e),s(t,gs,e),s(t,ue,e),s(t,Cs,e),M(Me,t,e),s(t,js,e),s(t,me,e),s(t,Is,e),s(t,de,e),s(t,Us,e),M(ye,t,e),s(t,$s,e),s(t,Te,e),s(t,vs,e),M(we,t,e),s(t,bs,e),s(t,fe,e),s(t,xs,e),M(ce,t,e),s(t,As,e),s(t,Be,e),Bs=!0},p:oi,i(t){Bs||(m(v.$$.fragment,t),m(b.$$.fragment,t),m(H.$$.fragment,t),m(Z.$$.fragment,t),m(V.$$.fragment,t),m(N.$$.fragment,t),m(Y.$$.fragment,t),m(O.$$.fragment,t),m(tt.$$.fragment,t),m(at.$$.fragment,t),m(ot.$$.fragment,t),m(pt.$$.fragment,t),m(Mt.$$.fragment,t),m(dt.$$.fragment,t),m(Tt.$$.fragment,t),m(wt.$$.fragment,t),m(ft.$$.fragment,t),m(gt.$$.fragment,t),m(It.$$.fragment,t),m(Ut.$$.fragment,t),m(vt.$$.fragment,t),m(bt.$$.fragment,t),m(At.$$.fragment,t),m(Bt.$$.fragment,t),m(_t.$$.fragment,t),m(Lt.$$.fragment,t),m(Rt.$$.fragment,t),m(Gt.$$.fragment,t),m(Wt.$$.fragment,t),m(Vt.$$.fragment,t),m(zt.$$.fragment,t),m(Yt.$$.fragment,t),m(Qt.$$.fragment,t),m(Ot.$$.fragment,t),m(ee.$$.fragment,t),m(se.$$.fragment,t),m(ne.$$.fragment,t),m(ie.$$.fragment,t),m(oe.$$.fragment,t),m(pe.$$.fragment,t),m(Me.$$.fragment,t),m(ye.$$.fragment,t),m(we.$$.fragment,t),m(ce.$$.fragment,t),Bs=!0)},o(t){d(v.$$.fragment,t),d(b.$$.fragment,t),d(H.$$.fragment,t),d(Z.$$.fragment,t),d(V.$$.fragment,t),d(N.$$.fragment,t),d(Y.$$.fragment,t),d(O.$$.fragment,t),d(tt.$$.fragment,t),d(at.$$.fragment,t),d(ot.$$.fragment,t),d(pt.$$.fragment,t),d(Mt.$$.fragment,t),d(dt.$$.fragment,t),d(Tt.$$.fragment,t),d(wt.$$.fragment,t),d(ft.$$.fragment,t),d(gt.$$.fragment,t),d(It.$$.fragment,t),d(Ut.$$.fragment,t),d(vt.$$.fragment,t),d(bt.$$.fragment,t),d(At.$$.fragment,t),d(Bt.$$.fragment,t),d(_t.$$.fragment,t),d(Lt.$$.fragment,t),d(Rt.$$.fragment,t),d(Gt.$$.fragment,t),d(Wt.$$.fragment,t),d(Vt.$$.fragment,t),d(zt.$$.fragment,t),d(Yt.$$.fragment,t),d(Qt.$$.fragment,t),d(Ot.$$.fragment,t),d(ee.$$.fragment,t),d(se.$$.fragment,t),d(ne.$$.fragment,t),d(ie.$$.fragment,t),d(oe.$$.fragment,t),d(pe.$$.fragment,t),d(Me.$$.fragment,t),d(ye.$$.fragment,t),d(we.$$.fragment,t),d(ce.$$.fragment,t),Bs=!1},d(t){t&&(l(_e),l(Ae),l(He),l(Ze),l(Le),l(x),l(Re),l(A),l(Ge),l(B),l(We),l(k),l(Pe),l(_),l(Ve),l(ze),l(Ne),l(L),l(Ye),l(R),l(Xe),l(G),l(Ee),l(W),l(Se),l(P),l(Qe),l(qe),l(z),l(Fe),l(Oe),l(De),l(X),l(Ke),l(E),l(tl),l(S),l(el),l(Q),l(ll),l(q),l(sl),l(F),l(nl),l(il),l(D),l(al),l(K),l(ol),l(rl),l(et),l(pl),l(lt),l(ul),l(st),l(Ml),l(nt),l(ml),l(it),l(dl),l(yl),l(Tl),l(rt),l(wl),l(fl),l(ut),l(cl),l(hl),l(mt),l(Jl),l(gl),l(yt),l(Cl),l(g),l(jl),l(Il),l(Ul),l(ct),l($l),l(ht),l(vl),l(Jt),l(bl),l(xl),l(Ct),l(Al),l(jt),l(Bl),l(j),l(kl),l(_l),l(Hl),l($t),l(Zl),l(Ll),l(Rl),l(xt),l(Gl),l(Wl),l(Pl),l(kt),l(Vl),l(zl),l(Ht),l(Nl),l(Zt),l(Yl),l(I),l(Xl),l(El),l(Sl),l(Ql),l(ql),l(Pt),l(Fl),l(Ol),l(U),l(Dl),l(Kl),l($),l(ts),l(Nt),l(es),l(ls),l(Xt),l(ss),l(Et),l(ns),l(St),l(is),l(as),l(qt),l(os),l(Ft),l(rs),l(ps),l(Dt),l(us),l(Kt),l(Ms),l(te),l(ms),l(ds),l(le),l(ys),l(Ts),l(f),l(ws),l(fs),l(ae),l(cs),l(hs),l(re),l(Js),l(gs),l(ue),l(Cs),l(js),l(me),l(Is),l(de),l(Us),l($s),l(Te),l(vs),l(bs),l(fe),l(xs),l(As),l(Be)),l(J),y(v,t),y(b,t),y(H,t),y(Z,t),y(V,t),y(N,t),y(Y,t),y(O,t),y(tt,t),y(at,t),y(ot,t),y(pt,t),y(Mt,t),y(dt,t),y(Tt),y(wt,t),y(ft,t),y(gt,t),y(It,t),y(Ut,t),y(vt,t),y(bt,t),y(At,t),y(Bt,t),y(_t,t),y(Lt,t),y(Rt,t),y(Gt,t),y(Wt,t),y(Vt,t),y(zt,t),y(Yt,t),y(Qt,t),y(Ot,t),y(ee,t),y(se,t),y(ne),y(ie,t),y(oe,t),y(pe,t),y(Me,t),y(ye,t),y(we,t),y(ce,t)}}}const yi='{"title":"Module 1: Build MCP Server","local":"module-1-build-mcp-server","sections":[{"title":"The PR Chaos at CodeCraft Studios","local":"the-pr-chaos-at-codecraft-studios","sections":[{"title":"Screencast: The PR Problem in Action 😬","local":"screencast-the-pr-problem-in-action-","sections":[],"depth":3}],"depth":2},{"title":"What You’ll Build","local":"what-youll-build","sections":[{"title":"Screencast: Your PR Agent Saves the Day! 🚀","local":"screencast-your-pr-agent-saves-the-day-","sections":[],"depth":3}],"depth":2},{"title":"What You Will Learn","local":"what-you-will-learn","sections":[],"depth":2},{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Getting Started","local":"getting-started","sections":[{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":3},{"title":"Starter Code","local":"starter-code","sections":[],"depth":3},{"title":"Your Task","local":"your-task","sections":[],"depth":3},{"title":"Design Philosophy","local":"design-philosophy","sections":[],"depth":3}],"depth":2},{"title":"Testing Your Implementation","local":"testing-your-implementation","sections":[{"title":"1. Validate Your Code","local":"1-validate-your-code","sections":[],"depth":3},{"title":"2. Run Unit Tests","local":"2-run-unit-tests","sections":[],"depth":3},{"title":"3. Test with Claude Code","local":"3-test-with-claude-code","sections":[],"depth":3}],"depth":2},{"title":"Common Patterns","local":"common-patterns","sections":[{"title":"Tool Implementation Pattern","local":"tool-implementation-pattern","sections":[],"depth":3},{"title":"Error Handling","local":"error-handling","sections":[],"depth":3},{"title":"Handling Large Outputs (Critical Learning Moment!)","local":"handling-large-outputs-critical-learning-moment","sections":[],"depth":3}],"depth":2},{"title":"Working Directory Considerations","local":"working-directory-considerations","sections":[],"depth":2},{"title":"Troubleshooting","local":"troubleshooting","sections":[],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[{"title":"What you’ve accomplished in Module 1:","local":"what-youve-accomplished-in-module-1","sections":[],"depth":3},{"title":"Key patterns you can reuse:","local":"key-patterns-you-can-reuse","sections":[],"depth":3},{"title":"What to do next:","local":"what-to-do-next","sections":[],"depth":3},{"title":"The story continues…","local":"the-story-continues","sections":[],"depth":3}],"depth":2},{"title":"Additional Resources","local":"additional-resources","sections":[],"depth":2}],"depth":1}';function Ti(zs){return ri(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gi extends pi{constructor(J){super(),ui(this,J,Ti,di,ai,{})}}export{gi as component};
