# Quiz 1: MCP Server Implementation

Test your knowledge of MCP server concepts and implementation for the Pull Request Agent.

### Q1: What is the primary role of an MCP Server in the Pull Request Agent architecture?

<Question
  choices={[
    {
      text: "To host the user interface for the application",
      explain: "The MCP Server provides backend capabilities, not the user interface."
    },
    {
      text: "To expose tools and resources that the AI agent can use to interact with GitHub",
      explain: "Close, but this project focuses on the Hugging Face Hub, not GitHub."
    },
    {
      text: "To expose tools for reading and updating model repository tags on the Hugging Face Hub",
      explain: "Correct! The MCP Server provides get_current_tags and add_new_tag tools for Hub interactions.",
      correct: true
    },
    {
      text: "To train the AI model on pull request data",
      explain: "MCP Servers provide runtime capabilities, not model training functionality."
    }
  ]}
/>

### Q2: In the FastMCP implementation, why must all MCP tool functions return strings instead of Python objects?

<Question
  choices={[
    {
      text: "To improve performance by reducing memory usage",
      explain: "While strings might be more memory efficient, this is not the primary reason."
    },
    {
      text: "To ensure reliable data exchange between the MCP server and client",
      explain: "Correct! MCP protocol requires string responses, so we use json.dumps() to serialize data.",
      correct: true
    },
    {
      text: "To make the code easier to debug",
      explain: "While JSON strings are readable, this is not the primary technical requirement."
    },
    {
      text: "To comply with Hugging Face Hub API requirements",
      explain: "This is an MCP protocol requirement, not specific to the Hub API."
    }
  ]}
/>

### Q3: When implementing the `add_new_tag` tool, what is the purpose of checking if a tag already exists before creating a pull request?

<Question
  choices={[
    {
      text: "To reduce API calls and improve performance",
      explain: "While this helps performance, it's not the primary reason for the check."
    },
    {
      text: "To prevent creating duplicate pull requests and provide better user feedback",
      explain: "Correct! This validation prevents unnecessary PRs and returns meaningful status messages.",
      correct: true
    },
    {
      text: "To comply with Hugging Face Hub rate limits",
      explain: "While avoiding unnecessary calls helps with rate limits, this is not the primary purpose."
    },
    {
      text: "To ensure the tag format is valid",
      explain: "Tag validation is separate from checking if it already exists."
    }
  ]}
/>

### Q4: In the MCP server implementation, what happens when a model repository doesn't have an existing README.md file?

<Question
  choices={[
    {
      text: "The add_new_tag tool will fail with an error",
      explain: "The implementation handles this case gracefully."
    },
    {
      text: "The tool creates a new ModelCard with ModelCardData and proceeds with the tag addition",
      explain: "Correct! The code handles HfHubHTTPError and creates a new model card when none exists.",
      correct: true
    },
    {
      text: "The tool skips adding the tag and returns a warning",
      explain: "The tool doesn't skip the operation - it creates what's needed."
    },
    {
      text: "The tool automatically creates a default README with placeholder content",
      explain: "It creates a minimal model card structure, not placeholder content."
    }
  ]}
/>

### Q5: What is the significance of using `create_pr=True` in the `hf_api.create_commit()` function call?

<Question
  choices={[
    {
      text: "It makes the commit directly to the main branch",
      explain: "Setting create_pr=True creates a pull request, not a direct commit to main."
    },
    {
      text: "It automatically creates a pull request instead of committing directly to the main branch",
      explain: "Correct! This enables the review workflow and follows repository governance practices.",
      correct: true
    },
    {
      text: "It creates a private branch that only the repository owner can see",
      explain: "Pull requests are visible to repository collaborators and can be public."
    },
    {
      text: "It validates the commit before creating it",
      explain: "Validation happens regardless of the create_pr parameter."
    }
  ]}
/>

### Q6: Why does the MCP server implementation use extensive logging with emojis throughout the code?

<Question
  choices={[
    {
      text: "To make the code more fun and engaging for developers",
      explain: "While emojis are visually appealing, there's a more practical reason."
    },
    {
      text: "To help with debugging and monitoring when the server runs autonomously in response to Hub events",
      explain: "Correct! Since the agent responds to webhooks automatically, detailed logs are crucial for troubleshooting.",
      correct: true
    },
    {
      text: "To comply with FastMCP logging requirements",
      explain: "FastMCP doesn't require specific logging formats or emojis."
    },
    {
      text: "To reduce the amount of text in log files",
      explain: "Emojis don't significantly reduce log file size and this isn't the primary goal."
    }
  ]}
/>

Congrats on finishing this Quiz 🥳! If you need to review any elements, take the time to revisit the chapter to reinforce your knowledge. 

<EditOnGithub source="https://github.com/huggingface/mcp-course/blob/main/units/en/unit3_1/quiz1.mdx" />