import{s as qa,f as x,o as Aa,n as Gn}from"../chunks/scheduler.9039eef2.js";import{S as Da,i as Pa,g as i,s as n,r as m,A as Ka,h as p,f as t,c as a,j as La,u as o,x as d,k as y,y as Oa,a as s,v as r,d as u,t as c,w as M}from"../chunks/index.cdcc3d35.js";import{T as In}from"../chunks/Tip.6f74db41.js";import{C as b}from"../chunks/CodeBlock.e3ac94d9.js";import{H as J}from"../chunks/Heading.96ce3702.js";function ei(_){let h,T="To apply optimized compute of Unet’s attention score, please configure your environment variable with <code>export NEURON_FUSE_SOFTMAX=1</code>.",w,g,j='Besides, don’t hesitate to tweak the compilation configuration to find the best tradeoff between performance v.s accuracy in your use case. By default, we suggest casting FP32 matrix multiplication operations to BF16 which offers good performance with moderate sacrifice of the accuracy. Check out the guide from <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/general/appnotes/neuronx-cc/neuronx-cc-training-mixed-precision.html#neuronx-cc-training-mixed-precision" rel="nofollow">AWS Neuron documentation</a> to better understand the options for your compilation.';return{c(){h=i("p"),h.innerHTML=T,w=n(),g=i("p"),g.innerHTML=j},l(f){h=p(f,"P",{"data-svelte-h":!0}),d(h)!=="svelte-6bhicj"&&(h.innerHTML=T),w=a(f),g=p(f,"P",{"data-svelte-h":!0}),d(g)!=="svelte-1dh7n4s"&&(g.innerHTML=j)},m(f,U){s(f,h,U),s(f,w,U),s(f,g,U)},p:Gn,d(f){f&&(t(h),t(w),t(g))}}}function li(_){let h,T="To avoid Neuron device out of memory, it’s suggested to finish all base inference and release the device memory before running the refiner.";return{c(){h=i("p"),h.textContent=T},l(w){h=p(w,"P",{"data-svelte-h":!0}),d(h)!=="svelte-1323ut2"&&(h.textContent=T)},m(w,g){s(w,h,g)},p:Gn,d(w){w&&t(h)}}}function ti(_){let h,T="Inf2 instances contain one or more Neuron devices, and each Neuron device includes 2 NeuronCore-v2. By default, we load the whole pipeline of LCM to both Neuron cores. It means that when the batch size is divisible by 2, you can fully leverage the compute power of both cores.";return{c(){h=i("p"),h.textContent=T},l(w){h=p(w,"P",{"data-svelte-h":!0}),d(h)!=="svelte-3zwean"&&(h.textContent=T)},m(w,g){s(w,h,g)},p:Gn,d(w){w&&t(h)}}}function si(_){let h,T,w,g,j,f,U,Ol,R,Xn='<em>There is a notebook version of that tutorial <a href="https://github.com/huggingface/optimum-neuron/blob/main/notebooks/stable-diffusion/stable-diffusion-txt2img.ipynb" rel="nofollow">here</a></em>.',et,k,Bn="🤗 <code>Optimum</code> extends <code>Diffusers</code> to support inference on the second generation of Neuron devices(powering Trainium and Inferentia 2). It aims at inheriting the ease of Diffusers on Neuron.",lt,S,Cn='To get started, make sure you have <a href="../installation">configured your inf2 / trn1 instance</a>, and installed optimum:',tt,Y,st,Q,nt,E,Vn="To deploy models, you will need to compile them to TorchScript optimized for AWS Neuron. In the case of Stable Diffusion, there are four components which need to be exported to the <code>.neuron</code> format to boost the performance:",at,F,_n="<li>Text encoder</li> <li>U-Net</li> <li>VAE encoder</li> <li>VAE decoder</li>",it,H,vn="You can either compile and export a Stable Diffusion Checkpoint via CLI or <code>NeuronStableDiffusionPipeline</code> class.",pt,z,Nn="<strong><em>Export via CLI</em></strong>",mt,L,$n="Here is an example of exporting stable diffusion components with <code>Optimum</code> CLI:",ot,q,rt,A,xn="We recommend using a <code>inf2.8xlarge</code> or a larger instance for the model compilation. You will also be able to compile the model with the Optimum CLI on a CPU-only instance (needs ~35 GB memory), and then run the pre-compiled model on <code>inf2.xlarge</code> to reduce the expenses. In this case, don’t forget to disable validation of inference by adding the <code>--disable-validation</code> argument.",ut,D,Rn="<strong><em>Export via Python API</em></strong>",ct,P,kn="Here is an example of exporting stable diffusion components with <code>NeuronStableDiffusionPipeline</code>:",Mt,v,dt,K,yt,O,ht,ee,Sn="<code>NeuronStableDiffusionPipeline</code> class allows you to generate images from a text prompt on neuron devices similar to the experience with <code>Diffusers</code>.",Jt,le,Yn="With pre-compiled Stable Diffusion models, now generate an image with a prompt on Neuron:",bt,te,wt,Z,Qn,gt,se,ft,ne,En="With the <code>NeuronStableDiffusionImg2ImgPipeline</code> class, you can generate a new image conditioned on a text prompt and an initial image.",Tt,ae,Ut,ie,Fn='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>prompt</code></th> <th align="center">output</th> <th align="right"></th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/03-sd-img2img-init.png" alt="landscape photo" width="256" height="256"/></td> <td align="center"><strong><em>ghibli style, a fantasy landscape with snowcapped mountains, trees, lake with detailed reflection. warm colors, 8K</em></strong></td> <td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/04-sd-img2img.png" alt="drawing" width="250"/></td> <td align="right"></td></tr></tbody>',jt,pe,Zt,me,Hn="With the <code>NeuronStableDiffusionInpaintPipeline</code> class, you can edit specific parts of an image by providing a mask and a text prompt.",Wt,oe,It,re,zn='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>mask_image</code></th> <th align="center"><code>prompt</code></th> <th align="right">output</th></tr></thead> <tbody><tr><td align="center"><img src="https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png" alt="drawing" width="250"/></td> <td align="center"><img src="https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png" alt="drawing" width="250"/></td> <td align="center"><strong><em>Face of a yellow cat, high resolution, sitting on a park bench</em></strong></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/05-sd-inpaint.png" alt="drawing" width="250"/></td></tr></tbody>',Gt,ue,Xt,ce,Ln="With the <code>NeuronStableDiffusionInstructPix2PixPipeline</code> class, you can apply instruction-based image editing using both text guidance and image guidance.",Bt,Me,Ct,de,qn='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>prompt</code></th> <th align="right">output</th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/diffusers/diffusers-images-docs/resolve/main/mountain.png" alt="drawing" width="250"/></td> <td align="center"><strong><em>Add a beautiful sunset</em></strong></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/11-sd-ip2p.png" alt="drawing" width="250"/></td></tr></tbody>',Vt,ye,_t,he,An='<em>There is a notebook version of that tutorial <a href="https://github.com/huggingface/optimum-neuron/blob/main/notebooks/stable-diffusion/stable-diffusion-xl-txt2img.ipynb" rel="nofollow">here</a></em>.',vt,Je,Dn="Stable Diffusion XL (SDXL) is a latent diffusion model for text-to-image. Compared to the previous versions of Stable Diffusion models, it improves the quality of generated images with a times larger UNet.",Nt,be,$t,we,Pn="To deploy SDXL models, we will also start by compiling the models. We support the export of following components in the pipeline to boost the speed:",xt,ge,Kn="<li>Text encoder</li> <li>Second text encoder</li> <li>U-Net (a three times larger UNet than the one in Stable Diffusion pipeline)</li> <li>VAE encoder</li> <li>VAE decoder</li>",Rt,fe,On="<strong><em>Export via CLI</em></strong>",kt,Te,ea="Here is an example of exporting SDXL components with <code>Optimum</code> CLI:",St,Ue,Yt,je,la="We recommend using a <code>inf2.8xlarge</code> or a larger instance for the model compilation. You will also be able to compile the model with Optimum CLI on a CPU-only instance (needs ~92 GB memory), and then run the pre-compiled models on <code>inf2.xlarge</code> to reduce the expenses. In this case, don’t forget to disable validation of inference by adding the <code>--disable-validation</code> argument.",Qt,Ze,ta="<strong><em>Export via Python API</em></strong>",Et,We,sa="Here is an example of exporting stable diffusion components with <code>NeuronStableDiffusionXLPipeline</code>:",Ft,Ie,Ht,Ge,zt,Xe,na="With pre-compiled SDXL models, now generate an image with a text prompt on Neuron:",Lt,Be,qt,W,aa,At,Ce,Dt,Ve,ia="With <code>NeuronStableDiffusionXLImg2ImgPipeline</code>, you can pass an initial image, and a text prompt to condition generated images:",Pt,_e,Kt,ve,pa='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>prompt</code></th> <th align="center">output</th> <th align="right"></th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/castle_friedrich.png" alt="castle photo" width="256" height="256"/></td> <td align="center"><strong><em>a dog running, lake, moat</em></strong></td> <td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/06-sdxl-img2img.png" alt="castle with dog" width="250"/></td> <td align="right"></td></tr></tbody>',Ot,Ne,es,$e,ma="With <code>NeuronStableDiffusionXLInpaintPipeline</code>, pass the original image and a mask of what you want to replace in the original image. Then replace the masked area with content described in a prompt.",ls,xe,ts,Re,oa='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>mask_image</code></th> <th align="center"><code>prompt</code></th> <th align="right">output</th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png" alt="drawing" width="250"/></td> <td align="center"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-inpaint-mask.png" alt="drawing" width="250"/></td> <td align="center"><strong><em>A deep sea diver floating</em></strong></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/07-sdxl-inpaint.png" alt="drawing" width="250"/></td></tr></tbody>',ss,ke,ns,Se,ra='SDXL includes a <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-refiner-1.0" rel="nofollow">refiner model</a> to denoise low-noise stage images generated from the base model. There are two ways to use the refiner:',as,Ye,ua="<li>use the base and refiner model together to produce a refined image.</li> <li>use the base model to produce an image, and subsequently use the refiner model to add more details to the image.</li>",is,Qe,ps,Ee,ms,I,ca,os,Fe,rs,He,us,ze,Ma='<thead><tr><th align="center"><code>Base Image</code></th> <th align="right">Refined Image</th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/09-sdxl-base-full.png" alt="drawing" width="250"/></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/010-sdxl-refiner-detailed.png" alt="drawing" width="250"/></td></tr></tbody>',cs,N,Ms,Le,ds,qe,da='Latent Consistency Models (LCMs) were proposed in <a href="https://huggingface.co/papers/2310.04378" rel="nofollow">Latent Consistency Models: Synthesizing High-Resolution Images with Few-Step Inference by Simian Luo, Yiqin Tan, Longbo Huang, Jian Li, and Hang Zhao</a>. LCMs enable inference with fewer steps on any pre-trained LDMs, including Stable Diffusion and SDXL.',ys,Ae,ya="In <code>optimum-neuron</code>, you can:",hs,De,ha="<li>Use the class <code>NeuronLatentConsistencyModelPipeline</code> to compile and run inference of LCMs distilled from Stable Diffusion (SD) models.</li> <li>And continue to use the class <code>NeuronStableDiffusionXLPipeline</code> for LCMs distilled from SDXL models.</li>",Js,Pe,Ja='Here are examples to compile the LCMs of Stable Diffusion ( <a href="https://huggingface.co/SimianLuo/LCM_Dreamshaper_v7" rel="nofollow">SimianLuo/LCM_Dreamshaper_v7</a> ) and Stable Diffusion XL( <a href="https://huggingface.co/latent-consistency/lcm-sdxl" rel="nofollow">latent-consistency/lcm-sdxl</a> ), and then run inference on AWS Inferentia 2 :',bs,Ke,ws,Oe,ba="<strong><em>LCM of Stable Diffusion</em></strong>",gs,el,fs,ll,wa="<strong><em>LCM of Stable Diffusion XL</em></strong>",Ts,tl,Us,sl,js,nl,ga="Now we can generate images from text prompts on Inf2 using the pre-compiled model:",Zs,al,fa="<strong><em>LCM of Stable Diffusion</em></strong>",Ws,il,Is,pl,Ta="<strong><em>LCM of Stable Diffusion XL</em></strong>",Gs,ml,Xs,ol,Bs,rl,Ua='SDXL Turbo is an adversarial time-distilled Stable Diffusion XL (SDXL) model capable of running inference in as little as 1 step (<a href="https://huggingface.co/docs/diffusers/using-diffusers/sdxl_turbo" rel="nofollow">check <code>🤗diffusers</code> for more details</a>).',Cs,ul,ja="In <code>optimum-neuron</code>, you can:",Vs,cl,Za="<li>Use the class <code>NeuronStableDiffusionXLPipeline</code> to compile and run inference.</li>",_s,Ml,Wa='Here we will compile the <a href="https://huggingface.co/stabilityai/sdxl-turbo" rel="nofollow"><code>stabilityai/sdxl-turbo</code></a> model with Optimum CLI.',vs,dl,Ns,yl,$s,hl,xs,Jl,Ia="Now we can generate images from text prompts on Inf2 using the pre-compiled model:",Rs,bl,ks,$,Ss,wl,Ys,gl,Qs,fl,Ga="Low-Rank Adaptation is fast way to Stable Diffusion to adapt styles of generated images. In Optimum Neuron, we support using one or multiple LoRA adapters by fusing their parameters into the original parameters of the text encoder(s) and the unet during the compilation. Here below is an example of compiling stable diffusion models with LoRA adapters of your choice and using the compiled artifacts to generate styled images:",Es,Tl,Fs,G,Xa,Hs,Ul,zs,jl,Ba="ControlNet conditions the stable diffusion model with an additional input image. In Optimum Neuron, we support the compilation of one or multiple ControlNet(s) along with the stable diffusion checkpoint. The you can use the compiled artifacts to generate styled images.",Ls,Zl,qs,Wl,Ca="We can either compile one or multiple ControlNet via the Optimum CLI or programatically via the <code>NeuronStableDiffusionControlNetPipeline</code> class by passing the <code>controlnet_ids</code>.",As,Il,Va="<li>Export via the Optimum CLI</li>",Ds,Gl,Ps,Xl,_a="<li>Export via Python API</li>",Ks,Bl,Os,Cl,en,Vl,va="For text-to-image, we can specify an additional conditioning input.",ln,_l,Na="Here is an example with a canny image, a white outline of an image on a black background. The ControlNet will use the canny image as a control to guide the model to generate an image with the same outline.",tn,vl,sn,X,$a,nn,Nl,an,$l,xa="With Optimum Neuron, you can also compose multiple ControlNet conditionings from different image inputs:",pn,xl,Ra="<li>Compile multiple ControlNet for SD1.5</li>",mn,Rl,on,kl,ka="<li>Run SD1.5 with OpenPose and Depth conditionings:</li>",rn,Sl,un,B,Sa,cn,Yl,Mn,Ql,dn,El,yn,Fl,hn,Hl,Jn,C,Ya,bn,zl,wn,Ll,gn,ql,fn,Al,Tn,Dl,Un,V,Qa,jn,Pl,Ea='Are there any other stable diffusion features that you want us to support in 🤗<code>Optimum-neuron</code>? Please file an issue to <a href="https://github.com/huggingface/optimum-neuron" rel="nofollow"><code>Optimum-neuron</code> Github repo</a> or discuss with us on <a href="https://discuss.huggingface.co/c/optimum/" rel="nofollow">HuggingFace’s community forum</a>, cheers 🤗 !',Zn,Kl,Wn;return j=new J({props:{title:"Generate images with Stable Diffusion models on AWS Inferentia",local:"generate-images-with-stable-diffusion-models-on-aws-inferentia",headingTag:"h1"}}),U=new J({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),Y=new b({props:{code:"cGlwJTIwaW5zdGFsbCUyMG9wdGltdW0tbmV1cm9uJTVCbmV1cm9ueCU1RCUyMGRpZmZ1c2Vycw==",highlighted:"pip install optimum-neuron[neuronx] diffusers",wrap:!1}}),Q=new J({props:{title:"Compile Stable Diffusion",local:"compile-stable-diffusion",headingTag:"h3"}}),q=new b({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMS1iYXNlJTIwJTVDJTBBJTIwJTIwLS1iYXRjaF9zaXplJTIwMSUyMCU1QyUwQSUyMCUyMC0taGVpZ2h0JTIwNTEyJTIwJTYwJTIzJTIwaGVpZ2h0JTIwaW4lMjBwaXhlbHMlMjBvZiUyMGdlbmVyYXRlZCUyMGltYWdlJTJDJTIwZWcuJTIwNTEyJTJDJTIwNzY4JTYwJTIwJTVDJTBBJTIwJTIwLS13aWR0aCUyMDUxMiUyMCU2MCUyMyUyMHdpZHRoJTIwaW4lMjBwaXhlbHMlMjBvZiUyMGdlbmVyYXRlZCUyMGltYWdlJTJDJTIwZWcuJTIwNTEyJTJDJTIwNzY4JTYwJTIwJTVDJTBBJTIwJTIwLS1udW1faW1hZ2VzX3Blcl9wcm9tcHQlMjAxJTIwJTYwJTIzJTIwbnVtYmVyJTIwb2YlMjBpbWFnZXMlMjB0byUyMGdlbmVyYXRlJTIwcGVyJTIwcHJvbXB0JTJDJTIwZGVmYXVsdHMlMjB0byUyMDElNjAlMjAlNUMlMEElMjAlMjAtLWF1dG9fY2FzdCUyMG1hdG11bCUyMCU2MCUyMyUyMGNhc3QlMjBvbmx5JTIwbWF0cml4JTIwbXVsdGlwbGljYXRpb24lMjBvcGVyYXRpb25zJTYwJTIwJTVDJTBBJTIwJTIwLS1hdXRvX2Nhc3RfdHlwZSUyMGJmMTYlMjAlNjAlMjMlMjBjYXN0JTIwb3BlcmF0aW9ucyUyMGZyb20lMjBGUDMyJTIwdG8lMjBCRjE2JTYwJTIwJTVDJTBBJTIwJTIwc2RfbmV1cm9uJTJG",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model stabilityai/stable-diffusion-2-1-base \\\n  --batch_size 1 \\\n  --height 512 `<span class="hljs-comment"># height in pixels of generated image, eg. 512, 768` \\</span>\n  --width 512 `<span class="hljs-comment"># width in pixels of generated image, eg. 512, 768` \\</span>\n  --num_images_per_prompt 1 `<span class="hljs-comment"># number of images to generate per prompt, defaults to 1` \\</span>\n  --auto_cast matmul `<span class="hljs-comment"># cast only matrix multiplication operations` \\</span>\n  --auto_cast_type bf16 `<span class="hljs-comment"># cast operations from FP32 to BF16` \\</span>\n  sd_neuron/',wrap:!1}}),v=new In({props:{$$slots:{default:[ei]},$$scope:{ctx:_}}}),K=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMmF1dG9fY2FzdCUyMiUzQSUyMCUyMm1hdG11bCUyMiUyQyUyMCUyMmF1dG9fY2FzdF90eXBlJTIyJTNBJTIwJTIyYmYxNiUyMiU3RCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwNTEyJTJDJTIwJTIyd2lkdGglMjIlM0ElMjA1MTIlN0QlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMCoqY29tcGlsZXJfYXJncyUyQyUyMCoqaW5wdXRfc2hhcGVzKSUwQSUwQXNhdmVfZGlyZWN0b3J5JTIwJTNEJTIwJTIyc2RfbmV1cm9uJTJGJTIyJTBBc3RhYmxlX2RpZmZ1c2lvbi5zYXZlX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBc3RhYmxlX2RpZmZ1c2lvbi5wdXNoX3RvX2h1YiglMEElMjAlMjAlMjAlMjBzYXZlX2RpcmVjdG9yeSUyQyUyMHJlcG9zaXRvcnlfaWQlM0QlMjJteS1uZXVyb24tcmVwbyUyMiUyQyUyMHVzZV9hdXRoX3Rva2VuJTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion = NeuronStableDiffusionPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes)

<span class="hljs-comment"># Save locally or upload to the HuggingFace Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_directory = <span class="hljs-string">&quot;sd_neuron/&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion.save_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion.push_to_hub(
<span class="hljs-meta">... </span>    save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),O=new J({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),te=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbiUyRiUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBaW1hZ2UlMjAlM0QlMjBzdGFibGVfZGlmZnVzaW9uKHByb21wdCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion = NeuronStableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron/&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = stable_diffusion(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),se=new J({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),ae=new b({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBJTIzJTIwY29tcGlsZSUyMCUyNiUyMHNhdmUlMEFtb2RlbF9pZCUyMCUzRCUyMCUyMm5pdHJvc29ja2UlMkZHaGlibGktRGlmZnVzaW9uJTIyJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA1MTIlMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDUxMiU3RCUwQXBpcGVsaW5lJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmlucHV0X3NoYXBlcyklMEFwaXBlbGluZS5zYXZlX3ByZXRyYWluZWQoJTIyc2RfaW1nMmltZyUyRiUyMiklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbiUyRm1haW4lMkZhc3NldHMlMkZzdGFibGUtc2FtcGxlcyUyRmltZzJpbWclMkZza2V0Y2gtbW91bnRhaW5zLWlucHV0LmpwZyUyMiUwQSUwQXJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEFpbml0X2ltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFpbml0X2ltYWdlJTIwJTNEJTIwaW5pdF9pbWFnZS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyZ2hpYmxpJTIwc3R5bGUlMkMlMjBhJTIwZmFudGFzeSUyMGxhbmRzY2FwZSUyMHdpdGglMjBzbm93Y2FwcGVkJTIwbW91bnRhaW5zJTJDJTIwdHJlZXMlMkMlMjBsYWtlJTIwd2l0aCUyMGRldGFpbGVkJTIwcmVmbGVjdGlvbi4lMjBzdW5saWdodCUyMGFuZCUyMGNsb3VkJTIwaW4lMjB0aGUlMjBza3klMkMlMjB3YXJtJTIwY29sb3JzJTJDJTIwOEslMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC43NSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENy41KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJmYW50YXN5X2xhbmRzY2FwZS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionImg2ImgPipeline

<span class="hljs-comment"># compile &amp; save</span>
model_id = <span class="hljs-string">&quot;nitrosocke/Ghibli-Diffusion&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}
pipeline = NeuronStableDiffusionImg2ImgPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **input_shapes)
pipeline.save_pretrained(<span class="hljs-string">&quot;sd_img2img/&quot;</span>)

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

response = requests.get(url)
init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
init_image = init_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;ghibli style, a fantasy landscape with snowcapped mountains, trees, lake with detailed reflection. sunlight and cloud in the sky, warm colors, 8K&quot;</span>

image = pipeline(prompt=prompt, image=init_image, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">7.5</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;fantasy_landscape.png&quot;</span>)`,wrap:!1}}),pe=new J({props:{title:"Inpaint",local:"inpaint",headingTag:"h3"}}),oe=new b({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW5wYWludFBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwNTEyJTJDJTIwJTIyd2lkdGglMjIlM0ElMjA1MTIlN0QlMEFwaXBlbGluZSUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlJTJDJTIwKippbnB1dF9zaGFwZXMpJTBBcGlwZWxpbmUuc2F2ZV9wcmV0cmFpbmVkKCUyMnNkX2lucGFpbnQlMkYlMjIpJTBBJTBBZGVmJTIwZG93bmxvYWRfaW1hZ2UodXJsKSUzQSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1by5wbmclMjIlMEFtYXNrX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvX21hc2sucG5nJTIyJTBBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGRvd25sb2FkX2ltYWdlKGltZ191cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEFtYXNrX2ltYWdlJTIwJTNEJTIwZG93bmxvYWRfaW1hZ2UobWFza191cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJGYWNlJTIwb2YlMjBhJTIweWVsbG93JTIwY2F0JTJDJTIwaGlnaCUyMHJlc29sdXRpb24lMkMlMjBzaXR0aW5nJTIwb24lMjBhJTIwcGFyayUyMGJlbmNoJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyY2F0X29uX2JlbmNoLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionInpaintPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}
pipeline = NeuronStableDiffusionInpaintPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **input_shapes)
pipeline.save_pretrained(<span class="hljs-string">&quot;sd_inpaint/&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
    response = requests.get(url)
    <span class="hljs-keyword">return</span> Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = download_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat_on_bench.png&quot;</span>)`,wrap:!1}}),ue=new J({props:{title:"InstructPix2Pix",local:"instructpix2pix",headingTag:"h3"}}),Me=new b({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjBQSUwlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW5zdHJ1Y3RQaXgyUGl4UGlwZWxpbmUlMEElMEFkZWYlMjBkb3dubG9hZF9pbWFnZSh1cmwpJTNBJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMFBJTC5JbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIydGltYnJvb2tzJTJGaW5zdHJ1Y3QtcGl4MnBpeCUyMiUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwNTEyJTJDJTIwJTIyd2lkdGglMjIlM0ElMjA1MTIlN0QlMEElMEFwaXBlJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW5zdHJ1Y3RQaXgyUGl4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMG1vZGVsX2lkJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMGR5bmFtaWNfYmF0Y2hfc2l6ZSUzRFRydWUlMkMlMjAqKmlucHV0X3NoYXBlcyUyQyUwQSklMEFwaXBlLnNhdmVfcHJldHJhaW5lZCglMjJzZF9pcDJwJTJGJTIyKSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZkaWZmdXNlcnMlMkZkaWZmdXNlcnMtaW1hZ2VzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRm1vdW50YWluLnBuZyUyMiUwQWluaXRfaW1hZ2UlMjAlM0QlMjBkb3dubG9hZF9pbWFnZShpbWdfdXJsKS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQWRkJTIwYSUyMGJlYXV0aWZ1bCUyMHN1bnNldCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMnN1bnNldF9tb3VudGFpbi5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> PIL
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionInstructPix2PixPipeline

<span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
    response = requests.get(url)
    <span class="hljs-keyword">return</span> PIL.Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

model_id = <span class="hljs-string">&quot;timbrooks/instruct-pix2pix&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}

pipe = NeuronStableDiffusionInstructPix2PixPipeline.from_pretrained(
  model_id, export=<span class="hljs-literal">True</span>, dynamic_batch_size=<span class="hljs-literal">True</span>, **input_shapes,
)
pipe.save_pretrained(<span class="hljs-string">&quot;sd_ip2p/&quot;</span>)

img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/diffusers-images-docs/resolve/main/mountain.png&quot;</span>
init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;Add a beautiful sunset&quot;</span>
image = pipe(prompt=prompt, image=init_image).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;sunset_mountain.png&quot;</span>)`,wrap:!1}}),ye=new J({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),be=new J({props:{title:"Compile Stable Diffusion XL",local:"compile-stable-diffusion-xl",headingTag:"h3"}}),Ue=new b({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIwJTVDJTBBJTIwJTIwLS1iYXRjaF9zaXplJTIwMSUyMCU1QyUwQSUyMCUyMC0taGVpZ2h0JTIwMTAyNCUyMCU2MCUyMyUyMGhlaWdodCUyMGluJTIwcGl4ZWxzJTIwb2YlMjBnZW5lcmF0ZWQlMjBpbWFnZSUyQyUyMGVnLiUyMDc2OCUyQyUyMDEwMjQlNjAlMjAlNUMlMEElMjAlMjAtLXdpZHRoJTIwMTAyNCUyMCU2MCUyMyUyMHdpZHRoJTIwaW4lMjBwaXhlbHMlMjBvZiUyMGdlbmVyYXRlZCUyMGltYWdlJTJDJTIwZWcuJTIwNzY4JTJDJTIwMTAyNCU2MCUyMCU1QyUwQSUyMCUyMC0tbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwMSUyMCU2MCUyMyUyMG51bWJlciUyMG9mJTIwaW1hZ2VzJTIwdG8lMjBnZW5lcmF0ZSUyMHBlciUyMHByb21wdCUyQyUyMGRlZmF1bHRzJTIwdG8lMjAxJTYwJTIwJTVDJTBBJTIwJTIwLS1hdXRvX2Nhc3QlMjBtYXRtdWwlMjAlNjAlMjMlMjBjYXN0JTIwb25seSUyMG1hdHJpeCUyMG11bHRpcGxpY2F0aW9uJTIwb3BlcmF0aW9ucyU2MCUyMCU1QyUwQSUyMCUyMC0tYXV0b19jYXN0X3R5cGUlMjBiZjE2JTIwJTYwJTIzJTIwY2FzdCUyMG9wZXJhdGlvbnMlMjBmcm9tJTIwRlAzMiUyMHRvJTIwQkYxNiU2MCUyMCU1QyUwQSUyMCUyMHNkX25ldXJvbl94bCUyRg==",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model stabilityai/stable-diffusion-xl-base-1.0 \\\n  --batch_size 1 \\\n  --height 1024 `<span class="hljs-comment"># height in pixels of generated image, eg. 768, 1024` \\</span>\n  --width 1024 `<span class="hljs-comment"># width in pixels of generated image, eg. 768, 1024` \\</span>\n  --num_images_per_prompt 1 `<span class="hljs-comment"># number of images to generate per prompt, defaults to 1` \\</span>\n  --auto_cast matmul `<span class="hljs-comment"># cast only matrix multiplication operations` \\</span>\n  --auto_cast_type bf16 `<span class="hljs-comment"># cast operations from FP32 to BF16` \\</span>\n  sd_neuron_xl/',wrap:!1}}),Ie=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMmF1dG9fY2FzdCUyMiUzQSUyMCUyMm1hdG11bCUyMiUyQyUyMCUyMmF1dG9fY2FzdF90eXBlJTIyJTNBJTIwJTIyYmYxNiUyMiU3RCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCU3RCUwQSUwQXN0YWJsZV9kaWZmdXNpb25feGwlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyklMEElMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMnNkX25ldXJvbl94bCUyRiUyMiUwQXN0YWJsZV9kaWZmdXNpb25feGwuc2F2ZV9wcmV0cmFpbmVkKHNhdmVfZGlyZWN0b3J5KSUwQXN0YWJsZV9kaWZmdXNpb25feGwucHVzaF90b19odWIoJTBBJTIwJTIwJTIwJTIwc2F2ZV9kaXJlY3RvcnklMkMlMjByZXBvc2l0b3J5X2lkJTNEJTIybXktbmV1cm9uLXJlcG8lMjIlMkMlMjB1c2VfYXV0aF90b2tlbiUzRFRydWUlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl = NeuronStableDiffusionXLPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes)

<span class="hljs-comment"># Save locally or upload to the HuggingFace Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_directory = <span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl.save_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl.push_to_hub(
<span class="hljs-meta">... </span>    save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),Ge=new J({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),Be=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXN0YWJsZV9kaWZmdXNpb25feGwlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwc3RhYmxlX2RpZmZ1c2lvbl94bChwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = stable_diffusion_xl(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Ce=new J({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),_e=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBkb2clMjBydW5uaW5nJTJDJTIwbGFrZSUyQyUyMG1vYXQlMjIlMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZvcHRpbXVtJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmludGVsJTJGb3BlbnZpbm8lMkZzZF94bCUyRmNhc3RsZV9mcmllZHJpY2gucG5nJTIyJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UodXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFwaXBlJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbl94bCUyRiUyMiklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLImg2ImgPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

prompt = <span class="hljs-string">&quot;a dog running, lake, moat&quot;</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/castle_friedrich.png&quot;</span>
init_image = load_image(url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

pipe = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = pipe(prompt=prompt, image=init_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Ne=new J({props:{title:"Inpaint",local:"inpaint",headingTag:"h3"}}),xe=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbnBhaW50UGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZzZHhsLXRleHQyaW1nLnBuZyUyMiUwQW1hc2tfdXJsJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRnNkeGwtaW5wYWludC1tYXNrLnBuZyUyMiUwQSklMEElMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShpbWdfdXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShtYXNrX3VybCkuY29udmVydCglMjJSR0IlMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGRlZXAlMjBzZWElMjBkaXZlciUyMGZsb2F0aW5nJTIyJTBBJTBBcGlwZSUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW5wYWludFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTIwc3RyZW5ndGglM0QwLjg1JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxMi41KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLInpaintPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png&quot;</span>
mask_url = (
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-inpaint-mask.png&quot;</span>
)

init_image = load_image(img_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(mask_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
prompt = <span class="hljs-string">&quot;A deep sea diver floating&quot;</span>

pipe = NeuronStableDiffusionXLInpaintPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = pipe(prompt=prompt, image=init_image, mask_image=mask_image, strength=<span class="hljs-number">0.85</span>, guidance_scale=<span class="hljs-number">12.5</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ke=new J({props:{title:"Refine Image Quality",local:"refine-image-quality",headingTag:"h3"}}),Qe=new J({props:{title:"Base + refiner model",local:"base--refiner-model",headingTag:"h4"}}),Ee=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUyQyUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMG1hamVzdGljJTIwbGlvbiUyMGp1bXBpbmclMjBmcm9tJTIwYSUyMGJpZyUyMHN0b25lJTIwYXQlMjBuaWdodCUyMiUwQWJhc2UlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBaW1hZ2UlMjAlM0QlMjBiYXNlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q0MCUyQyUwQSUyMCUyMCUyMCUyMGRlbm9pc2luZ19lbmQlM0QwLjglMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRfdHlwZSUzRCUyMmxhdGVudCUyMiUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWRlbCUyMGJhc2UlMjAlMjAlMjMlMjBUbyUyMGF2b2lkJTIwbmV1cm9uJTIwZGV2aWNlJTIwT09NJTBBJTBBcmVmaW5lciUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGxfcmVmaW5lciUyRiUyMiklMEFpbWFnZSUyMCUzRCUyMHJlZmluZXIoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQwJTJDJTBBJTIwJTIwJTIwJTIwZGVub2lzaW5nX3N0YXJ0JTNEMC44JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline, NeuronStableDiffusionXLImg2ImgPipeline

prompt = <span class="hljs-string">&quot;A majestic lion jumping from a big stone at night&quot;</span>
base = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = base(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">40</span>,
    denoising_end=<span class="hljs-number">0.8</span>,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).images[<span class="hljs-number">0</span>]
<span class="hljs-keyword">del</span> base  <span class="hljs-comment"># To avoid neuron device OOM</span>

refiner = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl_refiner/&quot;</span>)
image = refiner(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">40</span>,
    denoising_start=<span class="hljs-number">0.8</span>,
    image=image,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Fe=new J({props:{title:"Base to refiner model",local:"base-to-refiner-model",headingTag:"h4"}}),He=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUyQyUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMG1hamVzdGljJTIwbGlvbiUyMGp1bXBpbmclMjBmcm9tJTIwYSUyMGJpZyUyMHN0b25lJTIwYXQlMjBuaWdodCUyMiUwQWJhc2UlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBaW1hZ2UlMjAlM0QlMjBiYXNlKHByb21wdCUzRHByb21wdCUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlNUIwJTVEJTBBZGVsJTIwYmFzZSUyMCUyMCUyMyUyMFRvJTIwYXZvaWQlMjBuZXVyb24lMjBkZXZpY2UlMjBPT00lMEElMEFyZWZpbmVyJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbl94bF9yZWZpbmVyJTJGJTIyKSUwQWltYWdlJTIwJTNEJTIwcmVmaW5lcihwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlJTVCTm9uZSUyQyUyMCUzQSU1RCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline, NeuronStableDiffusionXLImg2ImgPipeline

prompt = <span class="hljs-string">&quot;A majestic lion jumping from a big stone at night&quot;</span>
base = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = base(prompt=prompt, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-keyword">del</span> base  <span class="hljs-comment"># To avoid neuron device OOM</span>

refiner = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl_refiner/&quot;</span>)
image = refiner(prompt=prompt, image=image[<span class="hljs-literal">None</span>, :]).images[<span class="hljs-number">0</span>]`,wrap:!1}}),N=new In({props:{$$slots:{default:[li]},$$scope:{ctx:_}}}),Le=new J({props:{title:"Latent Consistency Models",local:"latent-consistency-models",headingTag:"h2"}}),Ke=new J({props:{title:"Compile LCM",local:"compile-lcm",headingTag:"h3"}}),el=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTGF0ZW50Q29uc2lzdGVuY3lNb2RlbFBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJTaW1pYW5MdW8lMkZMQ01fRHJlYW1zaGFwZXJfdjclMjIlMEFudW1faW1hZ2VzX3Blcl9wcm9tcHQlMjAlM0QlMjAxJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA3NjglMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDc2OCUyQyUyMCUyMm51bV9pbWFnZXNfcGVyX3Byb21wdCUyMiUzQSUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCU3RCUwQWNvbXBpbGVyX2FyZ3MlMjAlM0QlMjAlN0IlMjJhdXRvX2Nhc3QlMjIlM0ElMjAlMjJtYXRtdWwlMjIlMkMlMjAlMjJhdXRvX2Nhc3RfdHlwZSUyMiUzQSUyMCUyMmJmMTYlMjIlN0QlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uTGF0ZW50Q29uc2lzdGVuY3lNb2RlbFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyUwQSklMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMmxjbV9zZF9uZXVyb24lMkYlMjIlMEFzdGFibGVfZGlmZnVzaW9uLnNhdmVfcHJldHJhaW5lZChzYXZlX2RpcmVjdG9yeSklMEElMEElMjMlMjBQdXNoJTIwdG8lMjBodWIlMEFzdGFibGVfZGlmZnVzaW9uLnB1c2hfdG9faHViKHNhdmVfZGlyZWN0b3J5JTJDJTIwcmVwb3NpdG9yeV9pZCUzRCUyMm15LW5ldXJvbi1yZXBvJTIyJTJDJTIwdXNlX2F1dGhfdG9rZW4lM0RUcnVlKSUyMCUyMCUyMyUyMFJlcGxhY2UlMjB3aXRoJTIweW91ciUyMHJlcG8lMjBpZCUyQyUyMGVnLiUyMCUyMkppbmd5YSUyRkxDTV9EcmVhbXNoYXBlcl92N19uZXVyb254JTIy",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronLatentConsistencyModelPipeline

model_id = <span class="hljs-string">&quot;SimianLuo/LCM_Dreamshaper_v7&quot;</span>
num_images_per_prompt = <span class="hljs-number">1</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">768</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">768</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: num_images_per_prompt}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}

stable_diffusion = NeuronLatentConsistencyModelPipeline.from_pretrained(
    model_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes
)
save_directory = <span class="hljs-string">&quot;lcm_sd_neuron/&quot;</span>
stable_diffusion.save_pretrained(save_directory)

<span class="hljs-comment"># Push to hub</span>
stable_diffusion.push_to_hub(save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)  <span class="hljs-comment"># Replace with your repo id, eg. &quot;Jingya/LCM_Dreamshaper_v7_neuronx&quot;</span>`,wrap:!1}}),tl=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBdW5ldF9pZCUyMCUzRCUyMCUyMmxhdGVudC1jb25zaXN0ZW5jeSUyRmxjbS1zZHhsJTIyJTBBbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwJTNEJTIwMSUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCUyQyUyMCUyMm51bV9pbWFnZXNfcGVyX3Byb21wdCUyMiUzQSUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCU3RCUwQWNvbXBpbGVyX2FyZ3MlMjAlM0QlMjAlN0IlMjJhdXRvX2Nhc3QlMjIlM0ElMjAlMjJtYXRtdWwlMjIlMkMlMjAlMjJhdXRvX2Nhc3RfdHlwZSUyMiUzQSUyMCUyMmJmMTYlMjIlN0QlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjB1bmV0X2lkJTNEdW5ldF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyUwQSklMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMmxjbV9zZHhsX25ldXJvbiUyRiUyMiUwQXN0YWJsZV9kaWZmdXNpb24uc2F2ZV9wcmV0cmFpbmVkKHNhdmVfZGlyZWN0b3J5KSUwQSUwQSUyMyUyMFB1c2glMjB0byUyMGh1YiUwQXN0YWJsZV9kaWZmdXNpb24ucHVzaF90b19odWIoc2F2ZV9kaXJlY3RvcnklMkMlMjByZXBvc2l0b3J5X2lkJTNEJTIybXktbmV1cm9uLXJlcG8lMjIlMkMlMjB1c2VfYXV0aF90b2tlbiUzRFRydWUpJTIwJTIwJTIwJTIzJTIwUmVwbGFjZSUyMHdpdGglMjB5b3VyJTIwcmVwbyUyMGlkJTJDJTIwZWcuJTIwJTIySmluZ3lhJTJGbGNtLXNkeGwtbmV1cm9ueCUyMg==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
unet_id = <span class="hljs-string">&quot;latent-consistency/lcm-sdxl&quot;</span>
num_images_per_prompt = <span class="hljs-number">1</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: num_images_per_prompt}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}

stable_diffusion = NeuronStableDiffusionXLPipeline.from_pretrained(
    model_id, unet_id=unet_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes
)
save_directory = <span class="hljs-string">&quot;lcm_sdxl_neuron/&quot;</span>
stable_diffusion.save_pretrained(save_directory)

<span class="hljs-comment"># Push to hub</span>
stable_diffusion.push_to_hub(save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)   <span class="hljs-comment"># Replace with your repo id, eg. &quot;Jingya/lcm-sdxl-neuronx&quot;</span>`,wrap:!1}}),sl=new J({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),il=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTGF0ZW50Q29uc2lzdGVuY3lNb2RlbFBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyME5ldXJvbkxhdGVudENvbnNpc3RlbmN5TW9kZWxQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIySmluZ3lhJTJGTENNX0RyZWFtc2hhcGVyX3Y3X25ldXJvbnglMjIpJTBBcHJvbXB0cyUyMCUzRCUyMCU1QiUyMlNlbGYtcG9ydHJhaXQlMjBvaWwlMjBwYWludGluZyUyQyUyMGElMjBiZWF1dGlmdWwlMjBjeWJvcmclMjB3aXRoJTIwZ29sZGVuJTIwaGFpciUyQyUyMDhrJTIyJTVEJTIwKiUyMDIlMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdHMlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronLatentConsistencyModelPipeline

pipe = NeuronLatentConsistencyModelPipeline.from_pretrained(<span class="hljs-string">&quot;Jingya/LCM_Dreamshaper_v7_neuronx&quot;</span>)
prompts = [<span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>] * <span class="hljs-number">2</span>

images = pipe(prompt=prompts, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">8.0</span>).images`,wrap:!1}}),ml=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJKaW5neWElMkZsY20tc2R4bC1uZXVyb254JTIyKSUwQXByb21wdHMlMjAlM0QlMjAlNUIlMjJhJTIwY2xvc2UtdXAlMjBwaWN0dXJlJTIwb2YlMjBhbiUyMG9sZCUyMG1hbiUyMHN0YW5kaW5nJTIwaW4lMjB0aGUlMjByYWluJTIyJTVEJTIwKiUyMDIlMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdHMlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

pipe = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;Jingya/lcm-sdxl-neuronx&quot;</span>)
prompts = [<span class="hljs-string">&quot;a close-up picture of an old man standing in the rain&quot;</span>] * <span class="hljs-number">2</span>

images = pipe(prompt=prompts, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">8.0</span>).images`,wrap:!1}}),ol=new J({props:{title:"Stable Diffusion XL Turbo",local:"stable-diffusion-xl-turbo",headingTag:"h2"}}),dl=new J({props:{title:"Compile SDXL Turbo",local:"compile-sdxl-turbo",headingTag:"h3"}}),yl=new b({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwc3RhYmlsaXR5YWklMkZzZHhsLXR1cmJvJTIwLS1iYXRjaF9zaXplJTIwMSUyMC0taGVpZ2h0JTIwNTEyJTIwLS13aWR0aCUyMDUxMiUyMC0tYXV0b19jYXN0JTIwbWF0bXVsJTIwLS1hdXRvX2Nhc3RfdHlwZSUyMGJmMTYlMjBzZHhsX3R1cmJvX25ldXJvbiUyRg==",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model stabilityai/sdxl-turbo --batch_size 1 --height 512 --width 512 --auto_cast matmul --auto_cast_type bf16 sdxl_turbo_neuron/',wrap:!1}}),hl=new J({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),bl=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZHhsX3R1cmJvX25ldXJvbiUyRiUyMiUyQyUyMGRhdGFfcGFyYWxsZWxfbW9kZSUzRCUyMmFsbCUyMiklMEFwcm9tcHQlMjAlM0QlMjAlNUIlMjJTZWxmLXBvcnRyYWl0JTIwb2lsJTIwcGFpbnRpbmclMkMlMjBhJTIwYmVhdXRpZnVsJTIwY3lib3JnJTIwd2l0aCUyMGdvbGRlbiUyMGhhaXIlMkMlMjA4ayUyMiU1RCUyMColMjAyJTBBJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDAuMCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QxKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

pipe = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sdxl_turbo_neuron/&quot;</span>, data_parallel_mode=<span class="hljs-string">&quot;all&quot;</span>)
prompt = [<span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>] * <span class="hljs-number">2</span>

images = pipe(prompt=prompt, guidance_scale=<span class="hljs-number">0.0</span>, num_inference_steps=<span class="hljs-number">1</span>).images`,wrap:!1}}),$=new In({props:{$$slots:{default:[ti]},$$scope:{ctx:_}}}),wl=new J({props:{title:"Load adapters",local:"load-adapters",headingTag:"h2"}}),gl=new J({props:{title:"LoRA",local:"lora",headingTag:"h3"}}),Tl=new b({props:{code:"JTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMExDTVNjaGVkdWxlciUwQWZyb20lMjBvcHRpbXVtLm5ldXJvbiUyMGltcG9ydCUyME5ldXJvblN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJMeWtvbiUyRmRyZWFtc2hhcGVyLTclMjIlMEFhZGFwdGVyX2lkJTIwJTNEJTIwJTIybGF0ZW50LWNvbnNpc3RlbmN5JTJGbGNtLWxvcmEtc2R2MS01JTIyJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA1MTIlMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDUxMiUyQyUyMCUyMm51bV9pbWFnZXNfcGVyX3Byb21wdCUyMiUzQSUyMDElN0QlMEFjb21waWxlcl9hcmdzJTIwJTNEJTIwJTdCJTIyYXV0b19jYXN0JTIyJTNBJTIwJTIybWF0bXVsJTIyJTJDJTIwJTIyYXV0b19jYXN0X3R5cGUlMjIlM0ElMjAlMjJiZjE2JTIyJTdEJTBBJTBBJTIzJTIwQ29tcGlsZSUwQXBpcGUlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBleHBvcnQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwaW5saW5lX3dlaWdodHNfdG9fbmVmZiUzRFRydWUlMkMlMjAlMjAlMjMlMjBjYXZlYXQlM0ElMjBwZXJmb3JtYW5jZSUyMGRyb3AlMjBpZiUyMG5lZmYlMkZ3ZWlnaHRzJTIwc2VwYXJhdGVkJTJDJTIwd2lsbCUyMGJlJTIwaW1wcm92ZWQlMjBieSUyMGElMjBmdXR1cmUlMjBOZXVyb24lMjBzZGslMjByZWxlYXNlLiUwQSUyMCUyMCUyMCUyMGxvcmFfbW9kZWxfaWRzJTNEYWRhcHRlcl9pZCUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfd2VpZ2h0X25hbWVzJTNEJTIycHl0b3JjaF9sb3JhX3dlaWdodHMuc2FmZXRlbnNvcnMlMjIlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FkYXB0ZXJfbmFtZXMlM0QlMjJsY20lMjIlMkMlMEElMjAlMjAlMjAlMjAqKmlucHV0X3NoYXBlcyUyQyUwQSUyMCUyMCUyMCUyMCoqY29tcGlsZXJfYXJncyUyQyUwQSklMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMExDTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBJTBBJTIzJTIwU2F2ZSUyMGxvY2FsbHklMjBvciUyMHVwbG9hZCUyMHRvJTIwdGhlJTIwSHVnZ2luZ0ZhY2UlMjBIdWIlMEFwaXBlLnNhdmVfcHJldHJhaW5lZCglMjJkcmVhbXNoYXBlcl83X2xjbV9sb3JhX25ldXJvbiUyRiUyMiklMEElMEElMEElMjMlMjBJbmZlcmVuY2UlMEFwcm9tcHQlMjAlM0QlMjAlMjJTZWxmLXBvcnRyYWl0JTIwb2lsJTIwcGFpbnRpbmclMkMlMjBhJTIwYmVhdXRpZnVsJTIwY3lib3JnJTIwd2l0aCUyMGdvbGRlbiUyMGhhaXIlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LCMScheduler
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionPipeline


model_id = <span class="hljs-string">&quot;Lykon/dreamshaper-7&quot;</span>
adapter_id = <span class="hljs-string">&quot;latent-consistency/lcm-lora-sdv1-5&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: <span class="hljs-number">1</span>}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}

<span class="hljs-comment"># Compile</span>
pipe = NeuronStableDiffusionPipeline.from_pretrained(
    model_id,
    export=<span class="hljs-literal">True</span>,
    inline_weights_to_neff=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># caveat: performance drop if neff/weights separated, will be improved by a future Neuron sdk release.</span>
    lora_model_ids=adapter_id,
    lora_weight_names=<span class="hljs-string">&quot;pytorch_lora_weights.safetensors&quot;</span>,
    lora_adapter_names=<span class="hljs-string">&quot;lcm&quot;</span>,
    **input_shapes,
    **compiler_args,
)
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

<span class="hljs-comment"># Save locally or upload to the HuggingFace Hub</span>
pipe.save_pretrained(<span class="hljs-string">&quot;dreamshaper_7_lcm_lora_neuron/&quot;</span>)


<span class="hljs-comment"># Inference</span>
prompt = <span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">0</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Ul=new J({props:{title:"ControlNet",local:"controlnet",headingTag:"h2"}}),Zl=new J({props:{title:"Compile ControlNet",local:"compile-controlnet",headingTag:"h3"}}),Gl=new b({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtbSUyMHJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIwLS1iYXRjaF9zaXplJTIwMSUyMC0taGVpZ2h0JTIwNTEyJTIwLS13aWR0aCUyMDUxMiUyMC0tY29udHJvbG5ldF9pZHMlMjBsbGx5YXN2aWVsJTJGc2QtY29udHJvbG5ldC1jYW5ueSUyMC0tbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwMSUyMHNkX25ldXJvbl9jb250cm9sbmV0JTJG",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron -m runwayml/stable-diffusion-v1-5 --batch_size 1 --height 512 --width 512 --controlnet_ids lllyasviel/sd-controlnet-canny --num_images_per_prompt 1 sd_neuron_controlnet/',wrap:!1}}),Bl=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQWNvbnRyb2xuZXRfaWQlMjAlM0QlMjAlMjJsbGx5YXN2aWVsJTJGc2QtY29udHJvbG5ldC1jYW5ueSUyMiUwQSUwQSUyMyUyMCU1Qk5ldXJvbiU1RCUyMHBpcGVsaW5lJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA1MTIlMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDUxMiUyQyUyMCUyMm51bV9pbWFnZXNfcGVyX3Byb21wdCUyMiUzQSUyMDElN0QlMEFjb21waWxlcl9hcmdzJTIwJTNEJTIwJTdCJTIyYXV0b19jYXN0JTIyJTNBJTIwJTIybWF0bXVsJTIyJTJDJTIwJTIyYXV0b19jYXN0X3R5cGUlMjIlM0ElMjAlMjJiZjE2JTIyJTdEJTBBcGlwZSUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sbmV0X2lkcyUzRGNvbnRyb2xuZXRfaWQlMkMlMEElMjAlMjAlMjAlMjBleHBvcnQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwKippbnB1dF9zaGFwZXMlMkMlMEElMjAlMjAlMjAlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMEEpJTBBcGlwZS5zYXZlX3ByZXRyYWluZWQoJTIyc2RfbmV1cm9uX2NvbnRyb2xuZXQlMjIp",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionControlNetPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
controlnet_id = <span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>

<span class="hljs-comment"># [Neuron] pipeline</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: <span class="hljs-number">1</span>}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}
pipe = NeuronStableDiffusionControlNetPipeline.from_pretrained(
    model_id,
    controlnet_ids=controlnet_id,
    export=<span class="hljs-literal">True</span>,
    **input_shapes,
    **compiler_args,
)
pipe.save_pretrained(<span class="hljs-string">&quot;sd_neuron_controlnet&quot;</span>)`,wrap:!1}}),Cl=new J({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),vl=new b({props:{code:"aW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEElMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25TdGFibGVEaWZmdXNpb25Db250cm9sTmV0UGlwZWxpbmUlMEElMEElMEElMjMlMjBwcmVwYXJlJTIwY2FubnklMjBpbWFnZSUwQW9yaWdpbmFsX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmhmLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbnB1dF9pbWFnZV92ZXJtZWVyLnBuZyUyMiUwQSklMEElMEFpbWFnZSUyMCUzRCUyMG5wLmFycmF5KG9yaWdpbmFsX2ltYWdlKSUwQSUwQWxvd190aHJlc2hvbGQlMjAlM0QlMjAxMDAlMEFoaWdoX3RocmVzaG9sZCUyMCUzRCUyMDIwMCUwQSUwQWltYWdlJTIwJTNEJTIwY3YyLkNhbm55KGltYWdlJTJDJTIwbG93X3RocmVzaG9sZCUyQyUyMGhpZ2hfdGhyZXNob2xkKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UlNUIlM0ElMkMlMjAlM0ElMkMlMjBOb25lJTVEJTBBaW1hZ2UlMjAlM0QlMjBucC5jb25jYXRlbmF0ZSglNUJpbWFnZSUyQyUyMGltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjBheGlzJTNEMiklMEFjYW5ueV9pbWFnZSUyMCUzRCUyMEltYWdlLmZyb21hcnJheShpbWFnZSklMEElMEElMjMlMjBsb2FkJTIwcHJlLWNvbXBpbGVkJTIwbmV1cm9uJTIwbW9kZWwlMEFwaXBlJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25fY29udHJvbG5ldCUyMiklMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEElMEElMjMlMjBpbmZlcmVuY2UlMEFvdXRwdXQlMjAlM0QlMjBwaXBlKCUyMnRoZSUyMG1vbmElMjBsaXNhJTIyJTJDJTIwaW1hZ2UlM0RjYW5ueV9pbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQWNvbXBhcmUlMjAlM0QlMjBtYWtlX2ltYWdlX2dyaWQoJTVCb3JpZ2luYWxfaW1hZ2UlMkMlMjBjYW5ueV9pbWFnZSUyQyUyMG91dHB1dCU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMpJTBBY29tcGFyZS5zYXZlKCUyMmNvbXBhcmUucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniPCMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionControlNetPipeline


<span class="hljs-comment"># prepare canny image</span>
original_image = load_image(
    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png&quot;</span>
)

image = np.array(original_image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)

<span class="hljs-comment"># load pre-compiled neuron model</span>
pipe = NeuronStableDiffusionControlNetPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_controlnet&quot;</span>)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)

<span class="hljs-comment"># inference</span>
output = pipe(<span class="hljs-string">&quot;the mona lisa&quot;</span>, image=canny_image).images[<span class="hljs-number">0</span>]
compare = make_image_grid([original_image, canny_image, output], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)
compare.save(<span class="hljs-string">&quot;compare.png&quot;</span>)`,wrap:!1}}),Nl=new J({props:{title:"MultiControlNet",local:"multicontrolnet",headingTag:"h3"}}),Rl=new b({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLWlubGluZS13ZWlnaHRzLW5lZmYlMjAtLW1vZGVsJTIwanlvdW5nMTA1JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIwLS10YXNrJTIwc3RhYmxlLWRpZmZ1c2lvbiUyMC0tYXV0b19jYXN0JTIwbWF0bXVsJTIwLS1hdXRvX2Nhc3RfdHlwZSUyMGJmMTYlMjAtLWJhdGNoX3NpemUlMjAxJTIwLS1udW1faW1hZ2VzX3Blcl9wcm9tcHQlMjAxJTIwLS1jb250cm9sbmV0X2lkcyUyMGxsbHlhc3ZpZWwlMkZjb250cm9sX3YxMXBfc2QxNV9vcGVucG9zZSUyMGxsbHlhc3ZpZWwlMkZjb250cm9sX3YxMWYxcF9zZDE1X2RlcHRoJTIwLS1oZWlnaHQlMjA1MTIlMjAtLXdpZHRoJTIwNTEyJTIwc2QxNS01MTJ4NTEyLWJmMTYtb3BlbnBvc2UtZGVwdGg=",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --inline-weights-neff --model jyoung105/stable-diffusion-v1-5 --task stable-diffusion --auto_cast matmul --auto_cast_type bf16 --batch_size 1 --num_images_per_prompt 1 --controlnet_ids lllyasviel/control_v11p_sd15_openpose lllyasviel/control_v11f1p_sd15_depth --height 512 --width 512 sd15-512x512-bf16-openpose-depth',wrap:!1}}),Sl=new b({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> controlnet_aux <span class="hljs-keyword">import</span> OpenposeDetector
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UniPCMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionControlNetPipeline


<span class="hljs-comment"># OpenPose+Depth ControlNet</span>
model_id = <span class="hljs-string">&quot;sd15-512x512-bf16-openpose-depth&quot;</span>

<span class="hljs-comment"># Load ControlNet images</span>

<span class="hljs-comment"># 1. openpose</span>
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/lllyasviel/control_v11p_sd15_openpose/resolve/main/images/input.png&quot;</span>)
processor = OpenposeDetector.from_pretrained(<span class="hljs-string">&#x27;lllyasviel/ControlNet&#x27;</span>)
openpose_image = processor(image)

<span class="hljs-comment"># 2. depth</span>
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/lllyasviel/control_v11p_sd15_depth/resolve/main/images/input.png&quot;</span>)
depth_estimator = pipeline(<span class="hljs-string">&#x27;depth-estimation&#x27;</span>)
image = depth_estimator(image)[<span class="hljs-string">&#x27;depth&#x27;</span>]
image = np.array(image)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
depth_image = Image.fromarray(image)

images = [openpose_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>)), depth_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))]

<span class="hljs-comment"># 3. inference</span>
pipe = NeuronStableDiffusionControlNetPipeline.from_pretrained(model_id)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
prompt = <span class="hljs-string">&quot;a giant in a fantasy landscape, best quality&quot;</span>
negative_prompt = <span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>

image = pipe(prompt=prompt, image=images).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&#x27;out.png&#x27;</span>)`,wrap:!1}}),Yl=new J({props:{title:"ControlNet with Stable Diffusion XL",local:"controlnet-with-stable-diffusion-xl",headingTag:"h2"}}),Ql=new J({props:{title:"Compile",local:"compile",headingTag:"h3"}}),El=new b({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtbSUyMHN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMC0tdGFzayUyMHN0YWJsZS1kaWZmdXNpb24teGwlMjAtLWJhdGNoX3NpemUlMjAxJTIwLS1oZWlnaHQlMjAxMDI0JTIwLS13aWR0aCUyMDEwMjQlMjAtLWNvbnRyb2xuZXRfaWRzJTIwZGlmZnVzZXJzJTJGY29udHJvbG5ldC1jYW5ueS1zZHhsLTEuMC1zbWFsbCUyMC0tbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwMSUyMHNkeGxfbmV1cm9uX2NvbnRyb2xuZXQlMkY=",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron -m stabilityai/stable-diffusion-xl-base-1.0 --task stable-diffusion-xl --batch_size 1 --height 1024 --width 1024 --controlnet_ids diffusers/controlnet-canny-sdxl-1.0-small --num_images_per_prompt 1 sdxl_neuron_controlnet/',wrap:!1}}),Fl=new J({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),Hl=new b({props:{code:"aW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTENvbnRyb2xOZXRQaXBlbGluZSUwQSUwQSUyMyUyMElucHV0cyUwQXByb21wdCUyMCUzRCUyMCUyMmFlcmlhbCUyMHZpZXclMkMlMjBhJTIwZnV0dXJpc3RpYyUyMHJlc2VhcmNoJTIwY29tcGxleCUyMGluJTIwYSUyMGJyaWdodCUyMGZvZ2d5JTIwanVuZ2xlJTJDJTIwaGFyZCUyMGxpZ2h0aW5nJTIyJTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIybG93JTIwcXVhbGl0eSUyQyUyMGJhZCUyMHF1YWxpdHklMkMlMjBza2V0Y2hlcyUyMiUwQSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGc2RfY29udHJvbG5ldCUyRmhmLWxvZ28ucG5nJTIyJTBBKSUwQWltYWdlJTIwJTNEJTIwbnAuYXJyYXkoaW1hZ2UpJTBBaW1hZ2UlMjAlM0QlMjBjdjIuQ2FubnkoaW1hZ2UlMkMlMjAxMDAlMkMlMjAyMDApJTBBaW1hZ2UlMjAlM0QlMjBpbWFnZSU1QiUzQSUyQyUyMCUzQSUyQyUyME5vbmUlNUQlMEFpbWFnZSUyMCUzRCUyMG5wLmNvbmNhdGVuYXRlKCU1QmltYWdlJTJDJTIwaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMGF4aXMlM0QyKSUwQWltYWdlJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KGltYWdlKSUwQSUwQWNvbnRyb2xuZXRfY29uZGl0aW9uaW5nX3NjYWxlJTIwJTNEJTIwMC41JTIwJTIwJTIzJTIwcmVjb21tZW5kZWQlMjBmb3IlMjBnb29kJTIwZ2VuZXJhbGl6YXRpb24lMEElMEFwaXBlJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExDb250cm9sTmV0UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkeGxfbmV1cm9uX2NvbnRyb2xuZXQlMjIpJTBBJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGltYWdlJTJDJTBBJTIwJTIwJTIwJTIwY29udHJvbG5ldF9jb25kaXRpb25pbmdfc2NhbGUlM0Rjb250cm9sbmV0X2NvbmRpdGlvbmluZ19zY2FsZSUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RC5zYXZlKCUyMmh1Z19sYWIucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLControlNetPipeline

<span class="hljs-comment"># Inputs</span>
prompt = <span class="hljs-string">&quot;aerial view, a futuristic research complex in a bright foggy jungle, hard lighting&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, bad quality, sketches&quot;</span>

image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd_controlnet/hf-logo.png&quot;</span>
)
image = np.array(image)
image = cv2.Canny(image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
image = Image.fromarray(image)

controlnet_conditioning_scale = <span class="hljs-number">0.5</span>  <span class="hljs-comment"># recommended for good generalization</span>

pipe = NeuronStableDiffusionXLControlNetPipeline.from_pretrained(<span class="hljs-string">&quot;sdxl_neuron_controlnet&quot;</span>)

images = pipe(
    prompt,
    negative_prompt=negative_prompt,
    image=image,
    controlnet_conditioning_scale=controlnet_conditioning_scale,
).images
images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;hug_lab.png&quot;</span>)`,wrap:!1}}),zl=new J({props:{title:"PixArt-α",local:"pixart-α",headingTag:"h2"}}),Ll=new J({props:{title:"Compile",local:"compile",headingTag:"h3"}}),ql=new b({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwUGl4QXJ0LWFscGhhJTJGUGl4QXJ0LVhMLTItNTEyeDUxMiUyMC0tYmF0Y2hfc2l6ZSUyMDElMjAtLWhlaWdodCUyMDUxMiUyMC0td2lkdGglMjA1MTIlMjAtLW51bV9pbWFnZXNfcGVyX3Byb21wdCUyMDElMjAtLXRvcmNoX2R0eXBlJTIwYmZsb2F0MTYlMjAtLXNlcXVlbmNlX2xlbmd0aCUyMDEyMCUyMHBpeGFydF9hbHBoYV9uZXVyb25fNTEyJTJG",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model PixArt-alpha/PixArt-XL-2-512x512 --batch_size 1 --height 512 --width 512 --num_images_per_prompt 1 --torch_dtype bfloat16 --sequence_length 120 pixart_alpha_neuron_512/',wrap:!1}}),Al=new J({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),Dl=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uUGl4QXJ0QWxwaGFQaXBlbGluZSUwQSUwQW5ldXJvbl9tb2RlbCUyMCUzRCUyME5ldXJvblBpeEFydEFscGhhUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnBpeGFydF9hbHBoYV9uZXVyb25fNTEyJTJGJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMk9wcGVuaGVpbWVyJTIwc2l0cyUyMG9uJTIwdGhlJTIwYmVhY2glMjBvbiUyMGElMjBjaGFpciUyQyUyMHdhdGNoaW5nJTIwYSUyMG51Y2xlYXIlMjBleHBvc2l0aW9uJTIwd2l0aCUyMGElMjBodWdlJTIwbXVzaHJvb20lMjBjbG91ZCUyQyUyMDEyMG1tLiUyMiUwQWltYWdlJTIwJTNEJTIwbmV1cm9uX21vZGVsKHByb21wdCUzRHByb21wdCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronPixArtAlphaPipeline

neuron_model = NeuronPixArtAlphaPipeline.from_pretrained(<span class="hljs-string">&quot;pixart_alpha_neuron_512/&quot;</span>)
prompt = <span class="hljs-string">&quot;Oppenheimer sits on the beach on a chair, watching a nuclear exposition with a huge mushroom cloud, 120mm.&quot;</span>
image = neuron_model(prompt=prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){h=i("meta"),T=n(),w=i("p"),g=n(),m(j.$$.fragment),f=n(),m(U.$$.fragment),Ol=n(),R=i("p"),R.innerHTML=Xn,et=n(),k=i("p"),k.innerHTML=Bn,lt=n(),S=i("p"),S.innerHTML=Cn,tt=n(),m(Y.$$.fragment),st=n(),m(Q.$$.fragment),nt=n(),E=i("p"),E.innerHTML=Vn,at=n(),F=i("ul"),F.innerHTML=_n,it=n(),H=i("p"),H.innerHTML=vn,pt=n(),z=i("p"),z.innerHTML=Nn,mt=n(),L=i("p"),L.innerHTML=$n,ot=n(),m(q.$$.fragment),rt=n(),A=i("p"),A.innerHTML=xn,ut=n(),D=i("p"),D.innerHTML=Rn,ct=n(),P=i("p"),P.innerHTML=kn,Mt=n(),m(v.$$.fragment),dt=n(),m(K.$$.fragment),yt=n(),m(O.$$.fragment),ht=n(),ee=i("p"),ee.innerHTML=Sn,Jt=n(),le=i("p"),le.textContent=Yn,bt=n(),m(te.$$.fragment),wt=n(),Z=i("img"),gt=n(),m(se.$$.fragment),ft=n(),ne=i("p"),ne.innerHTML=En,Tt=n(),m(ae.$$.fragment),Ut=n(),ie=i("table"),ie.innerHTML=Fn,jt=n(),m(pe.$$.fragment),Zt=n(),me=i("p"),me.innerHTML=Hn,Wt=n(),m(oe.$$.fragment),It=n(),re=i("table"),re.innerHTML=zn,Gt=n(),m(ue.$$.fragment),Xt=n(),ce=i("p"),ce.innerHTML=Ln,Bt=n(),m(Me.$$.fragment),Ct=n(),de=i("table"),de.innerHTML=qn,Vt=n(),m(ye.$$.fragment),_t=n(),he=i("p"),he.innerHTML=An,vt=n(),Je=i("p"),Je.textContent=Dn,Nt=n(),m(be.$$.fragment),$t=n(),we=i("p"),we.textContent=Pn,xt=n(),ge=i("ul"),ge.innerHTML=Kn,Rt=n(),fe=i("p"),fe.innerHTML=On,kt=n(),Te=i("p"),Te.innerHTML=ea,St=n(),m(Ue.$$.fragment),Yt=n(),je=i("p"),je.innerHTML=la,Qt=n(),Ze=i("p"),Ze.innerHTML=ta,Et=n(),We=i("p"),We.innerHTML=sa,Ft=n(),m(Ie.$$.fragment),Ht=n(),m(Ge.$$.fragment),zt=n(),Xe=i("p"),Xe.textContent=na,Lt=n(),m(Be.$$.fragment),qt=n(),W=i("img"),At=n(),m(Ce.$$.fragment),Dt=n(),Ve=i("p"),Ve.innerHTML=ia,Pt=n(),m(_e.$$.fragment),Kt=n(),ve=i("table"),ve.innerHTML=pa,Ot=n(),m(Ne.$$.fragment),es=n(),$e=i("p"),$e.innerHTML=ma,ls=n(),m(xe.$$.fragment),ts=n(),Re=i("table"),Re.innerHTML=oa,ss=n(),m(ke.$$.fragment),ns=n(),Se=i("p"),Se.innerHTML=ra,as=n(),Ye=i("ol"),Ye.innerHTML=ua,is=n(),m(Qe.$$.fragment),ps=n(),m(Ee.$$.fragment),ms=n(),I=i("img"),os=n(),m(Fe.$$.fragment),rs=n(),m(He.$$.fragment),us=n(),ze=i("table"),ze.innerHTML=Ma,cs=n(),m(N.$$.fragment),Ms=n(),m(Le.$$.fragment),ds=n(),qe=i("p"),qe.innerHTML=da,ys=n(),Ae=i("p"),Ae.innerHTML=ya,hs=n(),De=i("ul"),De.innerHTML=ha,Js=n(),Pe=i("p"),Pe.innerHTML=Ja,bs=n(),m(Ke.$$.fragment),ws=n(),Oe=i("p"),Oe.innerHTML=ba,gs=n(),m(el.$$.fragment),fs=n(),ll=i("p"),ll.innerHTML=wa,Ts=n(),m(tl.$$.fragment),Us=n(),m(sl.$$.fragment),js=n(),nl=i("p"),nl.textContent=ga,Zs=n(),al=i("p"),al.innerHTML=fa,Ws=n(),m(il.$$.fragment),Is=n(),pl=i("p"),pl.innerHTML=Ta,Gs=n(),m(ml.$$.fragment),Xs=n(),m(ol.$$.fragment),Bs=n(),rl=i("p"),rl.innerHTML=Ua,Cs=n(),ul=i("p"),ul.innerHTML=ja,Vs=n(),cl=i("ul"),cl.innerHTML=Za,_s=n(),Ml=i("p"),Ml.innerHTML=Wa,vs=n(),m(dl.$$.fragment),Ns=n(),m(yl.$$.fragment),$s=n(),m(hl.$$.fragment),xs=n(),Jl=i("p"),Jl.textContent=Ia,Rs=n(),m(bl.$$.fragment),ks=n(),m($.$$.fragment),Ss=n(),m(wl.$$.fragment),Ys=n(),m(gl.$$.fragment),Qs=n(),fl=i("p"),fl.textContent=Ga,Es=n(),m(Tl.$$.fragment),Fs=n(),G=i("img"),Hs=n(),m(Ul.$$.fragment),zs=n(),jl=i("p"),jl.textContent=Ba,Ls=n(),m(Zl.$$.fragment),qs=n(),Wl=i("p"),Wl.innerHTML=Ca,As=n(),Il=i("ul"),Il.innerHTML=Va,Ds=n(),m(Gl.$$.fragment),Ps=n(),Xl=i("ul"),Xl.innerHTML=_a,Ks=n(),m(Bl.$$.fragment),Os=n(),m(Cl.$$.fragment),en=n(),Vl=i("p"),Vl.textContent=va,ln=n(),_l=i("p"),_l.textContent=Na,tn=n(),m(vl.$$.fragment),sn=n(),X=i("img"),nn=n(),m(Nl.$$.fragment),an=n(),$l=i("p"),$l.textContent=xa,pn=n(),xl=i("ul"),xl.innerHTML=Ra,mn=n(),m(Rl.$$.fragment),on=n(),kl=i("ul"),kl.innerHTML=ka,rn=n(),m(Sl.$$.fragment),un=n(),B=i("img"),cn=n(),m(Yl.$$.fragment),Mn=n(),m(Ql.$$.fragment),dn=n(),m(El.$$.fragment),yn=n(),m(Fl.$$.fragment),hn=n(),m(Hl.$$.fragment),Jn=n(),C=i("img"),bn=n(),m(zl.$$.fragment),wn=n(),m(Ll.$$.fragment),gn=n(),m(ql.$$.fragment),fn=n(),m(Al.$$.fragment),Tn=n(),m(Dl.$$.fragment),Un=n(),V=i("img"),jn=n(),Pl=i("p"),Pl.innerHTML=Ea,Zn=n(),Kl=i("p"),this.h()},l(e){const l=Ka("svelte-u9bgzb",document.head);h=p(l,"META",{name:!0,content:!0}),l.forEach(t),T=a(e),w=p(e,"P",{}),La(w).forEach(t),g=a(e),o(j.$$.fragment,e),f=a(e),o(U.$$.fragment,e),Ol=a(e),R=p(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-140c11v"&&(R.innerHTML=Xn),et=a(e),k=p(e,"P",{"data-svelte-h":!0}),d(k)!=="svelte-1g87d8z"&&(k.innerHTML=Bn),lt=a(e),S=p(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-1u4t7n7"&&(S.innerHTML=Cn),tt=a(e),o(Y.$$.fragment,e),st=a(e),o(Q.$$.fragment,e),nt=a(e),E=p(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-3qllio"&&(E.innerHTML=Vn),at=a(e),F=p(e,"UL",{"data-svelte-h":!0}),d(F)!=="svelte-1c1t3y0"&&(F.innerHTML=_n),it=a(e),H=p(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-15y00oa"&&(H.innerHTML=vn),pt=a(e),z=p(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-1a2m8iq"&&(z.innerHTML=Nn),mt=a(e),L=p(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-ktaj8q"&&(L.innerHTML=$n),ot=a(e),o(q.$$.fragment,e),rt=a(e),A=p(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-jz092x"&&(A.innerHTML=xn),ut=a(e),D=p(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-kxhd34"&&(D.innerHTML=Rn),ct=a(e),P=p(e,"P",{"data-svelte-h":!0}),d(P)!=="svelte-1bahy14"&&(P.innerHTML=kn),Mt=a(e),o(v.$$.fragment,e),dt=a(e),o(K.$$.fragment,e),yt=a(e),o(O.$$.fragment,e),ht=a(e),ee=p(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1r61oa5"&&(ee.innerHTML=Sn),Jt=a(e),le=p(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-1q8fgqb"&&(le.textContent=Yn),bt=a(e),o(te.$$.fragment,e),wt=a(e),Z=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),gt=a(e),o(se.$$.fragment,e),ft=a(e),ne=p(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-kqnotf"&&(ne.innerHTML=En),Tt=a(e),o(ae.$$.fragment,e),Ut=a(e),ie=p(e,"TABLE",{"data-svelte-h":!0}),d(ie)!=="svelte-i6e2ex"&&(ie.innerHTML=Fn),jt=a(e),o(pe.$$.fragment,e),Zt=a(e),me=p(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-vhijyl"&&(me.innerHTML=Hn),Wt=a(e),o(oe.$$.fragment,e),It=a(e),re=p(e,"TABLE",{"data-svelte-h":!0}),d(re)!=="svelte-v8z5s8"&&(re.innerHTML=zn),Gt=a(e),o(ue.$$.fragment,e),Xt=a(e),ce=p(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-1836mxv"&&(ce.innerHTML=Ln),Bt=a(e),o(Me.$$.fragment,e),Ct=a(e),de=p(e,"TABLE",{"data-svelte-h":!0}),d(de)!=="svelte-w6yzym"&&(de.innerHTML=qn),Vt=a(e),o(ye.$$.fragment,e),_t=a(e),he=p(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-1q6nuso"&&(he.innerHTML=An),vt=a(e),Je=p(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-7xctqf"&&(Je.textContent=Dn),Nt=a(e),o(be.$$.fragment,e),$t=a(e),we=p(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-u4wwem"&&(we.textContent=Pn),xt=a(e),ge=p(e,"UL",{"data-svelte-h":!0}),d(ge)!=="svelte-17e9k9s"&&(ge.innerHTML=Kn),Rt=a(e),fe=p(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-1a2m8iq"&&(fe.innerHTML=On),kt=a(e),Te=p(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-9niqj3"&&(Te.innerHTML=ea),St=a(e),o(Ue.$$.fragment,e),Yt=a(e),je=p(e,"P",{"data-svelte-h":!0}),d(je)!=="svelte-eias7g"&&(je.innerHTML=la),Qt=a(e),Ze=p(e,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-kxhd34"&&(Ze.innerHTML=ta),Et=a(e),We=p(e,"P",{"data-svelte-h":!0}),d(We)!=="svelte-17tzr0c"&&(We.innerHTML=sa),Ft=a(e),o(Ie.$$.fragment,e),Ht=a(e),o(Ge.$$.fragment,e),zt=a(e),Xe=p(e,"P",{"data-svelte-h":!0}),d(Xe)!=="svelte-8q3qyn"&&(Xe.textContent=na),Lt=a(e),o(Be.$$.fragment,e),qt=a(e),W=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),At=a(e),o(Ce.$$.fragment,e),Dt=a(e),Ve=p(e,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-luub4o"&&(Ve.innerHTML=ia),Pt=a(e),o(_e.$$.fragment,e),Kt=a(e),ve=p(e,"TABLE",{"data-svelte-h":!0}),d(ve)!=="svelte-1s0d0pv"&&(ve.innerHTML=pa),Ot=a(e),o(Ne.$$.fragment,e),es=a(e),$e=p(e,"P",{"data-svelte-h":!0}),d($e)!=="svelte-11fbw00"&&($e.innerHTML=ma),ls=a(e),o(xe.$$.fragment,e),ts=a(e),Re=p(e,"TABLE",{"data-svelte-h":!0}),d(Re)!=="svelte-18741xe"&&(Re.innerHTML=oa),ss=a(e),o(ke.$$.fragment,e),ns=a(e),Se=p(e,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-1usq821"&&(Se.innerHTML=ra),as=a(e),Ye=p(e,"OL",{"data-svelte-h":!0}),d(Ye)!=="svelte-6p4eqi"&&(Ye.innerHTML=ua),is=a(e),o(Qe.$$.fragment,e),ps=a(e),o(Ee.$$.fragment,e),ms=a(e),I=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),os=a(e),o(Fe.$$.fragment,e),rs=a(e),o(He.$$.fragment,e),us=a(e),ze=p(e,"TABLE",{"data-svelte-h":!0}),d(ze)!=="svelte-1s7g03c"&&(ze.innerHTML=Ma),cs=a(e),o(N.$$.fragment,e),Ms=a(e),o(Le.$$.fragment,e),ds=a(e),qe=p(e,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-1ud6a8q"&&(qe.innerHTML=da),ys=a(e),Ae=p(e,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-1ayizu6"&&(Ae.innerHTML=ya),hs=a(e),De=p(e,"UL",{"data-svelte-h":!0}),d(De)!=="svelte-r4tdj0"&&(De.innerHTML=ha),Js=a(e),Pe=p(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-c4lhmw"&&(Pe.innerHTML=Ja),bs=a(e),o(Ke.$$.fragment,e),ws=a(e),Oe=p(e,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-1s0vvjb"&&(Oe.innerHTML=ba),gs=a(e),o(el.$$.fragment,e),fs=a(e),ll=p(e,"P",{"data-svelte-h":!0}),d(ll)!=="svelte-51zp7x"&&(ll.innerHTML=wa),Ts=a(e),o(tl.$$.fragment,e),Us=a(e),o(sl.$$.fragment,e),js=a(e),nl=p(e,"P",{"data-svelte-h":!0}),d(nl)!=="svelte-1ebkvay"&&(nl.textContent=ga),Zs=a(e),al=p(e,"P",{"data-svelte-h":!0}),d(al)!=="svelte-1s0vvjb"&&(al.innerHTML=fa),Ws=a(e),o(il.$$.fragment,e),Is=a(e),pl=p(e,"P",{"data-svelte-h":!0}),d(pl)!=="svelte-51zp7x"&&(pl.innerHTML=Ta),Gs=a(e),o(ml.$$.fragment,e),Xs=a(e),o(ol.$$.fragment,e),Bs=a(e),rl=p(e,"P",{"data-svelte-h":!0}),d(rl)!=="svelte-10h80ju"&&(rl.innerHTML=Ua),Cs=a(e),ul=p(e,"P",{"data-svelte-h":!0}),d(ul)!=="svelte-1ayizu6"&&(ul.innerHTML=ja),Vs=a(e),cl=p(e,"UL",{"data-svelte-h":!0}),d(cl)!=="svelte-t7g18i"&&(cl.innerHTML=Za),_s=a(e),Ml=p(e,"P",{"data-svelte-h":!0}),d(Ml)!=="svelte-ohwj0a"&&(Ml.innerHTML=Wa),vs=a(e),o(dl.$$.fragment,e),Ns=a(e),o(yl.$$.fragment,e),$s=a(e),o(hl.$$.fragment,e),xs=a(e),Jl=p(e,"P",{"data-svelte-h":!0}),d(Jl)!=="svelte-1ebkvay"&&(Jl.textContent=Ia),Rs=a(e),o(bl.$$.fragment,e),ks=a(e),o($.$$.fragment,e),Ss=a(e),o(wl.$$.fragment,e),Ys=a(e),o(gl.$$.fragment,e),Qs=a(e),fl=p(e,"P",{"data-svelte-h":!0}),d(fl)!=="svelte-k1lsm0"&&(fl.textContent=Ga),Es=a(e),o(Tl.$$.fragment,e),Fs=a(e),G=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),Hs=a(e),o(Ul.$$.fragment,e),zs=a(e),jl=p(e,"P",{"data-svelte-h":!0}),d(jl)!=="svelte-15r2htw"&&(jl.textContent=Ba),Ls=a(e),o(Zl.$$.fragment,e),qs=a(e),Wl=p(e,"P",{"data-svelte-h":!0}),d(Wl)!=="svelte-clsbw5"&&(Wl.innerHTML=Ca),As=a(e),Il=p(e,"UL",{"data-svelte-h":!0}),d(Il)!=="svelte-127fndl"&&(Il.innerHTML=Va),Ds=a(e),o(Gl.$$.fragment,e),Ps=a(e),Xl=p(e,"UL",{"data-svelte-h":!0}),d(Xl)!=="svelte-zxjvv9"&&(Xl.innerHTML=_a),Ks=a(e),o(Bl.$$.fragment,e),Os=a(e),o(Cl.$$.fragment,e),en=a(e),Vl=p(e,"P",{"data-svelte-h":!0}),d(Vl)!=="svelte-s2jfwm"&&(Vl.textContent=va),ln=a(e),_l=p(e,"P",{"data-svelte-h":!0}),d(_l)!=="svelte-e5xot3"&&(_l.textContent=Na),tn=a(e),o(vl.$$.fragment,e),sn=a(e),X=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),nn=a(e),o(Nl.$$.fragment,e),an=a(e),$l=p(e,"P",{"data-svelte-h":!0}),d($l)!=="svelte-ve8s8f"&&($l.textContent=xa),pn=a(e),xl=p(e,"UL",{"data-svelte-h":!0}),d(xl)!=="svelte-16kkb80"&&(xl.innerHTML=Ra),mn=a(e),o(Rl.$$.fragment,e),on=a(e),kl=p(e,"UL",{"data-svelte-h":!0}),d(kl)!=="svelte-1pbmybe"&&(kl.innerHTML=ka),rn=a(e),o(Sl.$$.fragment,e),un=a(e),B=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),cn=a(e),o(Yl.$$.fragment,e),Mn=a(e),o(Ql.$$.fragment,e),dn=a(e),o(El.$$.fragment,e),yn=a(e),o(Fl.$$.fragment,e),hn=a(e),o(Hl.$$.fragment,e),Jn=a(e),C=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),bn=a(e),o(zl.$$.fragment,e),wn=a(e),o(Ll.$$.fragment,e),gn=a(e),o(ql.$$.fragment,e),fn=a(e),o(Al.$$.fragment,e),Tn=a(e),o(Dl.$$.fragment,e),Un=a(e),V=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),jn=a(e),Pl=p(e,"P",{"data-svelte-h":!0}),d(Pl)!=="svelte-xbi604"&&(Pl.innerHTML=Ea),Zn=a(e),Kl=p(e,"P",{}),La(Kl).forEach(t),this.h()},h(){y(h,"name","hf:doc:metadata"),y(h,"content",ni),x(Z.src,Qn="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/models/01-sd-image.png")||y(Z,"src",Qn),y(Z,"width","256"),y(Z,"height","256"),y(Z,"alt","stable diffusion generated image"),x(W.src,aa="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/models/02-sdxl-image.jpeg")||y(W,"src",aa),y(W,"width","256"),y(W,"height","256"),y(W,"alt","sdxl generated image"),x(I.src,ca="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/08-sdxl-base-refine.png")||y(I,"src",ca),y(I,"width","256"),y(I,"height","256"),y(I,"alt","sdxl base + refiner"),x(G.src,Xa="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/models/03-sd-lora.png")||y(G,"src",Xa),y(G,"width","256"),y(G,"height","256"),y(G,"alt","stable diffusion generated image with LoRA adapter."),x(X.src,$a="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/10-sd-text2img-controlnet.png?download=true")||y(X,"src",$a),y(X,"width","768"),y(X,"height","256"),y(X,"alt","stable diffusion 1.5 generated image with controlnet."),x(B.src,Sa="https://huggingface.co/datasets/Jingya/document_images/resolve/main/optimum/neuron/multicontrolnet.png")||y(B,"src",Sa),y(B,"width","768"),y(B,"height","256"),y(B,"alt","stable diffusion 1.5 generated image with OpenPose and Depth controlnet."),x(C.src,Ya="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/12-sdxl-text2img-controlnet.png?download=true")||y(C,"src",Ya),y(C,"width","768"),y(C,"height","256"),y(C,"alt","stable diffusion xl generated image with controlnet."),x(V.src,Qa="https://huggingface.co/datasets/Jingya/document_images/resolve/main/optimum/neuron/pixart-alpha-oppenheimer.png")||y(V,"src",Qa),y(V,"width","256"),y(V,"height","256"),y(V,"alt","PixArt-α generated image.")},m(e,l){Oa(document.head,h),s(e,T,l),s(e,w,l),s(e,g,l),r(j,e,l),s(e,f,l),r(U,e,l),s(e,Ol,l),s(e,R,l),s(e,et,l),s(e,k,l),s(e,lt,l),s(e,S,l),s(e,tt,l),r(Y,e,l),s(e,st,l),r(Q,e,l),s(e,nt,l),s(e,E,l),s(e,at,l),s(e,F,l),s(e,it,l),s(e,H,l),s(e,pt,l),s(e,z,l),s(e,mt,l),s(e,L,l),s(e,ot,l),r(q,e,l),s(e,rt,l),s(e,A,l),s(e,ut,l),s(e,D,l),s(e,ct,l),s(e,P,l),s(e,Mt,l),r(v,e,l),s(e,dt,l),r(K,e,l),s(e,yt,l),r(O,e,l),s(e,ht,l),s(e,ee,l),s(e,Jt,l),s(e,le,l),s(e,bt,l),r(te,e,l),s(e,wt,l),s(e,Z,l),s(e,gt,l),r(se,e,l),s(e,ft,l),s(e,ne,l),s(e,Tt,l),r(ae,e,l),s(e,Ut,l),s(e,ie,l),s(e,jt,l),r(pe,e,l),s(e,Zt,l),s(e,me,l),s(e,Wt,l),r(oe,e,l),s(e,It,l),s(e,re,l),s(e,Gt,l),r(ue,e,l),s(e,Xt,l),s(e,ce,l),s(e,Bt,l),r(Me,e,l),s(e,Ct,l),s(e,de,l),s(e,Vt,l),r(ye,e,l),s(e,_t,l),s(e,he,l),s(e,vt,l),s(e,Je,l),s(e,Nt,l),r(be,e,l),s(e,$t,l),s(e,we,l),s(e,xt,l),s(e,ge,l),s(e,Rt,l),s(e,fe,l),s(e,kt,l),s(e,Te,l),s(e,St,l),r(Ue,e,l),s(e,Yt,l),s(e,je,l),s(e,Qt,l),s(e,Ze,l),s(e,Et,l),s(e,We,l),s(e,Ft,l),r(Ie,e,l),s(e,Ht,l),r(Ge,e,l),s(e,zt,l),s(e,Xe,l),s(e,Lt,l),r(Be,e,l),s(e,qt,l),s(e,W,l),s(e,At,l),r(Ce,e,l),s(e,Dt,l),s(e,Ve,l),s(e,Pt,l),r(_e,e,l),s(e,Kt,l),s(e,ve,l),s(e,Ot,l),r(Ne,e,l),s(e,es,l),s(e,$e,l),s(e,ls,l),r(xe,e,l),s(e,ts,l),s(e,Re,l),s(e,ss,l),r(ke,e,l),s(e,ns,l),s(e,Se,l),s(e,as,l),s(e,Ye,l),s(e,is,l),r(Qe,e,l),s(e,ps,l),r(Ee,e,l),s(e,ms,l),s(e,I,l),s(e,os,l),r(Fe,e,l),s(e,rs,l),r(He,e,l),s(e,us,l),s(e,ze,l),s(e,cs,l),r(N,e,l),s(e,Ms,l),r(Le,e,l),s(e,ds,l),s(e,qe,l),s(e,ys,l),s(e,Ae,l),s(e,hs,l),s(e,De,l),s(e,Js,l),s(e,Pe,l),s(e,bs,l),r(Ke,e,l),s(e,ws,l),s(e,Oe,l),s(e,gs,l),r(el,e,l),s(e,fs,l),s(e,ll,l),s(e,Ts,l),r(tl,e,l),s(e,Us,l),r(sl,e,l),s(e,js,l),s(e,nl,l),s(e,Zs,l),s(e,al,l),s(e,Ws,l),r(il,e,l),s(e,Is,l),s(e,pl,l),s(e,Gs,l),r(ml,e,l),s(e,Xs,l),r(ol,e,l),s(e,Bs,l),s(e,rl,l),s(e,Cs,l),s(e,ul,l),s(e,Vs,l),s(e,cl,l),s(e,_s,l),s(e,Ml,l),s(e,vs,l),r(dl,e,l),s(e,Ns,l),r(yl,e,l),s(e,$s,l),r(hl,e,l),s(e,xs,l),s(e,Jl,l),s(e,Rs,l),r(bl,e,l),s(e,ks,l),r($,e,l),s(e,Ss,l),r(wl,e,l),s(e,Ys,l),r(gl,e,l),s(e,Qs,l),s(e,fl,l),s(e,Es,l),r(Tl,e,l),s(e,Fs,l),s(e,G,l),s(e,Hs,l),r(Ul,e,l),s(e,zs,l),s(e,jl,l),s(e,Ls,l),r(Zl,e,l),s(e,qs,l),s(e,Wl,l),s(e,As,l),s(e,Il,l),s(e,Ds,l),r(Gl,e,l),s(e,Ps,l),s(e,Xl,l),s(e,Ks,l),r(Bl,e,l),s(e,Os,l),r(Cl,e,l),s(e,en,l),s(e,Vl,l),s(e,ln,l),s(e,_l,l),s(e,tn,l),r(vl,e,l),s(e,sn,l),s(e,X,l),s(e,nn,l),r(Nl,e,l),s(e,an,l),s(e,$l,l),s(e,pn,l),s(e,xl,l),s(e,mn,l),r(Rl,e,l),s(e,on,l),s(e,kl,l),s(e,rn,l),r(Sl,e,l),s(e,un,l),s(e,B,l),s(e,cn,l),r(Yl,e,l),s(e,Mn,l),r(Ql,e,l),s(e,dn,l),r(El,e,l),s(e,yn,l),r(Fl,e,l),s(e,hn,l),r(Hl,e,l),s(e,Jn,l),s(e,C,l),s(e,bn,l),r(zl,e,l),s(e,wn,l),r(Ll,e,l),s(e,gn,l),r(ql,e,l),s(e,fn,l),r(Al,e,l),s(e,Tn,l),r(Dl,e,l),s(e,Un,l),s(e,V,l),s(e,jn,l),s(e,Pl,l),s(e,Zn,l),s(e,Kl,l),Wn=!0},p(e,[l]){const Fa={};l&2&&(Fa.$$scope={dirty:l,ctx:e}),v.$set(Fa);const Ha={};l&2&&(Ha.$$scope={dirty:l,ctx:e}),N.$set(Ha);const za={};l&2&&(za.$$scope={dirty:l,ctx:e}),$.$set(za)},i(e){Wn||(u(j.$$.fragment,e),u(U.$$.fragment,e),u(Y.$$.fragment,e),u(Q.$$.fragment,e),u(q.$$.fragment,e),u(v.$$.fragment,e),u(K.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),u(pe.$$.fragment,e),u(oe.$$.fragment,e),u(ue.$$.fragment,e),u(Me.$$.fragment,e),u(ye.$$.fragment,e),u(be.$$.fragment,e),u(Ue.$$.fragment,e),u(Ie.$$.fragment,e),u(Ge.$$.fragment,e),u(Be.$$.fragment,e),u(Ce.$$.fragment,e),u(_e.$$.fragment,e),u(Ne.$$.fragment,e),u(xe.$$.fragment,e),u(ke.$$.fragment,e),u(Qe.$$.fragment,e),u(Ee.$$.fragment,e),u(Fe.$$.fragment,e),u(He.$$.fragment,e),u(N.$$.fragment,e),u(Le.$$.fragment,e),u(Ke.$$.fragment,e),u(el.$$.fragment,e),u(tl.$$.fragment,e),u(sl.$$.fragment,e),u(il.$$.fragment,e),u(ml.$$.fragment,e),u(ol.$$.fragment,e),u(dl.$$.fragment,e),u(yl.$$.fragment,e),u(hl.$$.fragment,e),u(bl.$$.fragment,e),u($.$$.fragment,e),u(wl.$$.fragment,e),u(gl.$$.fragment,e),u(Tl.$$.fragment,e),u(Ul.$$.fragment,e),u(Zl.$$.fragment,e),u(Gl.$$.fragment,e),u(Bl.$$.fragment,e),u(Cl.$$.fragment,e),u(vl.$$.fragment,e),u(Nl.$$.fragment,e),u(Rl.$$.fragment,e),u(Sl.$$.fragment,e),u(Yl.$$.fragment,e),u(Ql.$$.fragment,e),u(El.$$.fragment,e),u(Fl.$$.fragment,e),u(Hl.$$.fragment,e),u(zl.$$.fragment,e),u(Ll.$$.fragment,e),u(ql.$$.fragment,e),u(Al.$$.fragment,e),u(Dl.$$.fragment,e),Wn=!0)},o(e){c(j.$$.fragment,e),c(U.$$.fragment,e),c(Y.$$.fragment,e),c(Q.$$.fragment,e),c(q.$$.fragment,e),c(v.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(se.$$.fragment,e),c(ae.$$.fragment,e),c(pe.$$.fragment,e),c(oe.$$.fragment,e),c(ue.$$.fragment,e),c(Me.$$.fragment,e),c(ye.$$.fragment,e),c(be.$$.fragment,e),c(Ue.$$.fragment,e),c(Ie.$$.fragment,e),c(Ge.$$.fragment,e),c(Be.$$.fragment,e),c(Ce.$$.fragment,e),c(_e.$$.fragment,e),c(Ne.$$.fragment,e),c(xe.$$.fragment,e),c(ke.$$.fragment,e),c(Qe.$$.fragment,e),c(Ee.$$.fragment,e),c(Fe.$$.fragment,e),c(He.$$.fragment,e),c(N.$$.fragment,e),c(Le.$$.fragment,e),c(Ke.$$.fragment,e),c(el.$$.fragment,e),c(tl.$$.fragment,e),c(sl.$$.fragment,e),c(il.$$.fragment,e),c(ml.$$.fragment,e),c(ol.$$.fragment,e),c(dl.$$.fragment,e),c(yl.$$.fragment,e),c(hl.$$.fragment,e),c(bl.$$.fragment,e),c($.$$.fragment,e),c(wl.$$.fragment,e),c(gl.$$.fragment,e),c(Tl.$$.fragment,e),c(Ul.$$.fragment,e),c(Zl.$$.fragment,e),c(Gl.$$.fragment,e),c(Bl.$$.fragment,e),c(Cl.$$.fragment,e),c(vl.$$.fragment,e),c(Nl.$$.fragment,e),c(Rl.$$.fragment,e),c(Sl.$$.fragment,e),c(Yl.$$.fragment,e),c(Ql.$$.fragment,e),c(El.$$.fragment,e),c(Fl.$$.fragment,e),c(Hl.$$.fragment,e),c(zl.$$.fragment,e),c(Ll.$$.fragment,e),c(ql.$$.fragment,e),c(Al.$$.fragment,e),c(Dl.$$.fragment,e),Wn=!1},d(e){e&&(t(T),t(w),t(g),t(f),t(Ol),t(R),t(et),t(k),t(lt),t(S),t(tt),t(st),t(nt),t(E),t(at),t(F),t(it),t(H),t(pt),t(z),t(mt),t(L),t(ot),t(rt),t(A),t(ut),t(D),t(ct),t(P),t(Mt),t(dt),t(yt),t(ht),t(ee),t(Jt),t(le),t(bt),t(wt),t(Z),t(gt),t(ft),t(ne),t(Tt),t(Ut),t(ie),t(jt),t(Zt),t(me),t(Wt),t(It),t(re),t(Gt),t(Xt),t(ce),t(Bt),t(Ct),t(de),t(Vt),t(_t),t(he),t(vt),t(Je),t(Nt),t($t),t(we),t(xt),t(ge),t(Rt),t(fe),t(kt),t(Te),t(St),t(Yt),t(je),t(Qt),t(Ze),t(Et),t(We),t(Ft),t(Ht),t(zt),t(Xe),t(Lt),t(qt),t(W),t(At),t(Dt),t(Ve),t(Pt),t(Kt),t(ve),t(Ot),t(es),t($e),t(ls),t(ts),t(Re),t(ss),t(ns),t(Se),t(as),t(Ye),t(is),t(ps),t(ms),t(I),t(os),t(rs),t(us),t(ze),t(cs),t(Ms),t(ds),t(qe),t(ys),t(Ae),t(hs),t(De),t(Js),t(Pe),t(bs),t(ws),t(Oe),t(gs),t(fs),t(ll),t(Ts),t(Us),t(js),t(nl),t(Zs),t(al),t(Ws),t(Is),t(pl),t(Gs),t(Xs),t(Bs),t(rl),t(Cs),t(ul),t(Vs),t(cl),t(_s),t(Ml),t(vs),t(Ns),t($s),t(xs),t(Jl),t(Rs),t(ks),t(Ss),t(Ys),t(Qs),t(fl),t(Es),t(Fs),t(G),t(Hs),t(zs),t(jl),t(Ls),t(qs),t(Wl),t(As),t(Il),t(Ds),t(Ps),t(Xl),t(Ks),t(Os),t(en),t(Vl),t(ln),t(_l),t(tn),t(sn),t(X),t(nn),t(an),t($l),t(pn),t(xl),t(mn),t(on),t(kl),t(rn),t(un),t(B),t(cn),t(Mn),t(dn),t(yn),t(hn),t(Jn),t(C),t(bn),t(wn),t(gn),t(fn),t(Tn),t(Un),t(V),t(jn),t(Pl),t(Zn),t(Kl)),t(h),M(j,e),M(U,e),M(Y,e),M(Q,e),M(q,e),M(v,e),M(K,e),M(O,e),M(te,e),M(se,e),M(ae,e),M(pe,e),M(oe,e),M(ue,e),M(Me,e),M(ye,e),M(be,e),M(Ue,e),M(Ie,e),M(Ge,e),M(Be,e),M(Ce,e),M(_e,e),M(Ne,e),M(xe,e),M(ke,e),M(Qe,e),M(Ee,e),M(Fe,e),M(He,e),M(N,e),M(Le,e),M(Ke,e),M(el,e),M(tl,e),M(sl,e),M(il,e),M(ml,e),M(ol,e),M(dl,e),M(yl,e),M(hl,e),M(bl,e),M($,e),M(wl,e),M(gl,e),M(Tl,e),M(Ul,e),M(Zl,e),M(Gl,e),M(Bl,e),M(Cl,e),M(vl,e),M(Nl,e),M(Rl,e),M(Sl,e),M(Yl,e),M(Ql,e),M(El,e),M(Fl,e),M(Hl,e),M(zl,e),M(Ll,e),M(ql,e),M(Al,e),M(Dl,e)}}}const ni='{"title":"Generate images with Stable Diffusion models on AWS Inferentia","local":"generate-images-with-stable-diffusion-models-on-aws-inferentia","sections":[{"title":"Stable Diffusion","local":"stable-diffusion","sections":[{"title":"Compile Stable Diffusion","local":"compile-stable-diffusion","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3},{"title":"Inpaint","local":"inpaint","sections":[],"depth":3},{"title":"InstructPix2Pix","local":"instructpix2pix","sections":[],"depth":3}],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[{"title":"Compile Stable Diffusion XL","local":"compile-stable-diffusion-xl","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3},{"title":"Inpaint","local":"inpaint","sections":[],"depth":3},{"title":"Refine Image Quality","local":"refine-image-quality","sections":[{"title":"Base + refiner model","local":"base--refiner-model","sections":[],"depth":4},{"title":"Base to refiner model","local":"base-to-refiner-model","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Latent Consistency Models","local":"latent-consistency-models","sections":[{"title":"Compile LCM","local":"compile-lcm","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3}],"depth":2},{"title":"Stable Diffusion XL Turbo","local":"stable-diffusion-xl-turbo","sections":[{"title":"Compile SDXL Turbo","local":"compile-sdxl-turbo","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3}],"depth":2},{"title":"Load adapters","local":"load-adapters","sections":[{"title":"LoRA","local":"lora","sections":[],"depth":3}],"depth":2},{"title":"ControlNet","local":"controlnet","sections":[{"title":"Compile ControlNet","local":"compile-controlnet","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"MultiControlNet","local":"multicontrolnet","sections":[],"depth":3}],"depth":2},{"title":"ControlNet with Stable Diffusion XL","local":"controlnet-with-stable-diffusion-xl","sections":[{"title":"Compile","local":"compile","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3}],"depth":2},{"title":"PixArt-α","local":"pixart-α","sections":[{"title":"Compile","local":"compile","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3}],"depth":2}],"depth":1}';function ai(_){return Aa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ui extends Da{constructor(h){super(),Pa(this,h,ai,si,qa,{})}}export{ui as component};
