import{s as Ie,o as Be,n as ae}from"../chunks/scheduler.5f3e6389.js";import{S as Xe,i as We,e as i,s as l,c,h as Re,a as p,d as n,b as a,f as Ee,g as u,j as r,k as Ne,l as Ge,m as s,n as M,t as h,o as d,p as f}from"../chunks/index.373ab25c.js";import{T as le}from"../chunks/Tip.3e202241.js";import{C as He,H as ut}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.e5d47ca1.js";import{C as x}from"../chunks/CodeBlock.3e485a20.js";function Ve(T){let o,j=`A good way to implement a custom ONNX configuration is to look at the existing configuration implementations in the
<code>optimum/exporters/onnx/model_configs.py</code> file.`,m,y,w=`Also, if the architecture you are trying to add is (very) similar to an architecture that is already supported
(for instance adding support for ALBERT when BERT is already supported), trying to simply inheriting from this class
might work.`;return{c(){o=i("p"),o.innerHTML=j,m=l(),y=i("p"),y.textContent=w},l(g){o=p(g,"P",{"data-svelte-h":!0}),r(o)!=="svelte-sqy8xm"&&(o.innerHTML=j),m=a(g),y=p(g,"P",{"data-svelte-h":!0}),r(y)!=="svelte-179x1bi"&&(y.textContent=w)},m(g,b){s(g,o,b),s(g,m,b),s(g,y,b)},p:ae,d(g){g&&(n(o),n(m),n(y))}}}function Le(T){let o,j="Check out <code>BartOnnxConfig</code> for an advanced example.";return{c(){o=i("p"),o.innerHTML=j},l(m){o=p(m,"P",{"data-svelte-h":!0}),r(o)!=="svelte-1lu1znn"&&(o.innerHTML=j)},m(m,y){s(m,o,y)},p:ae,d(m){m&&n(o)}}}function Fe(T){let o,j=`If your model is larger than 2GB, you will see that many additional files are created during the export. This is
<em>expected</em> because ONNX uses <a href="https://developers.google.com/protocol-buffers/" rel="nofollow">Protocol Buffers</a> to store the model
and these have a size limit of 2GB. See the <a href="https://github.com/onnx/onnx/blob/master/docs/ExternalData.md" rel="nofollow">ONNX documentation</a>
for instructions on how to load models with external data.`;return{c(){o=i("p"),o.innerHTML=j},l(m){o=p(m,"P",{"data-svelte-h":!0}),r(o)!=="svelte-iixhlv"&&(o.innerHTML=j)},m(m,y){s(m,o,y)},p:ae,d(m){m&&n(o)}}}function Oe(T){let o,j,m,y,w,g,b,ht,$,oe="If you wish to export a model whose architecture is not already supported by the library, these are the main steps to follow:",dt,_,ie="<li>Implement a custom ONNX configuration.</li> <li>Register the ONNX configuration in the <code>~optimum.exporters.TasksManager</code>.</li> <li>Export the model to ONNX.</li> <li>Validate the outputs of the original and exported models.</li>",ft,v,pe="In this section, we’ll look at how BERT was implemented to show what’s involved with each step.",yt,A,gt,k,re=`Let’s start with the ONNX configuration object. We provide a 3-level <a href="/exporters/onnx/package_reference/configuration">class hierarchy</a>,
and to add support for a model, inheriting from the right middle-end class will be the way to go most of the time. You might have to
implement a middle-end class yourself if you are adding an architecture handling a modality and/or case never seen before.`,jt,U,bt,Z,me=`When inheriting from a middle-end class, look for the one handling the same modality / category of models as the one you
are trying to support.`,wt,E,xt,N,ce=`Since BERT is an encoder-based model for text, its configuration inherits from the middle-end class <a href="/docs/optimum/main/en/onnx/package_reference/configuration#optimum.exporters.onnx.TextEncoderOnnxConfig">TextEncoderOnnxConfig</a>.
In <code>optimum/exporters/onnx/model_configs.py</code>:`,Tt,I,Ut,B,ue=`First let’s explain what <code>TextEncoderOnnxConfig</code> is all about. While most of the features are already implemented in <code>OnnxConfig</code>,
this class is modality-agnostic, meaning that it does not know what kind of inputs it should handle. The way input generation is
handled is via the <code>DUMMY_INPUT_GENERATOR_CLASSES</code> attribute, which is a tuple of <code>DummyInputGenerator</code>s.
Here we are making a modality-aware configuration inheriting from <code>OnnxConfig</code> by specifying
<code>DUMMY_INPUT_GENERATOR_CLASSES = (DummyTextInputGenerator,)</code>.`,Jt,X,Me="Then comes the model-specific class, <code>BertOnnxConfig</code>. Two class attributes are specified here:",Ct,W,he=`<li><code>NORMALIZED_CONFIG_CLASS</code>: this must be a <code>NormalizedConfig</code>, it basically allows
the input generator to access the model config attributes in a generic way.</li> <li><code>ATOL_FOR_VALIDATION</code>: it is used when validating the exported model against the original one, this is the absolute
acceptable tolerance for the output values difference.</li>`,$t,R,de=`Every configuration object must implement the <a href="/docs/optimum/main/en/onnx/package_reference/configuration#optimum.exporters.onnx.OnnxConfig.inputs">inputs</a> property and return a mapping, where each key corresponds to an
input name, and each value indicates the axes in that input that are dynamic.
For BERT, we can see that three inputs are required: <code>input_ids</code>, <code>attention_mask</code> and <code>token_type_ids</code>.
These inputs have the same shape of <code>(batch_size, sequence_length)</code> (except for the <code>multiple-choice</code> task) which is
why we see the same axes used in the configuration.`,_t,G,fe="Once you have implemented an ONNX configuration, you can instantiate it by providing the base model’s configuration as follows:",vt,H,At,V,ye=`The resulting object has several useful properties. For example, you can view the ONNX
operator set that will be used during the export:`,kt,L,Zt,F,ge="You can also view the outputs associated with the model as follows:",Et,O,Nt,Q,je=`Notice that the outputs property follows the same structure as the inputs; it returns an
<code>OrderedDict</code> of named outputs and their shapes. The output structure is linked to the
choice of task that the configuration is initialised with. By default, the ONNX
configuration is initialized with the <code>default</code> task that corresponds to exporting a
model loaded with the <code>AutoModel</code> class. If you want to export a model for another task,
just provide a different task to the <code>task</code> argument when you initialize the ONNX
configuration. For example, if we wished to export BERT with a sequence
classification head, we could use:`,It,z,Bt,J,Xt,S,Wt,q,be=`The <code>TasksManager</code> is the main entry-point to load a model given a name and a task,
and to get the proper configuration for a given (architecture, backend) couple. When adding support for the export to ONNX,
registering the configuration to the <code>TasksManager</code> will make the export available in the command line tool.`,Rt,Y,we="To do that, add an entry in the <code>_SUPPORTED_MODEL_TYPE</code> attribute:",Gt,P,xe=`<li>If the model is already supported for other backends than ONNX, it will already have an entry, so you will only need to
add an <code>onnx</code> key specifying the name of the configuration class.</li> <li>Otherwise, you will have to add the whole entry.</li>`,Ht,D,Te="For BERT, it looks as follows:",Vt,K,Lt,tt,Ft,et,Ue=`Once you have implemented the ONNX configuration, the next step is to export the model.
Here we can use the <code>export()</code> function provided by the <code>optimum.exporters.onnx</code> package.
This function expects the ONNX configuration, along with the base model, and the path to save the exported file:`,Ot,nt,Qt,st,Je=`The <code>onnx_inputs</code> and <code>onnx_outputs</code> returned by the <code>export()</code> function are lists of the keys defined in the <a href="/docs/optimum/main/en/onnx/package_reference/configuration#optimum.exporters.onnx.OnnxConfig.inputs">inputs</a>
and <a href="/docs/optimum/main/en/onnx/package_reference/configuration#optimum.exporters.onnx.OnnxConfig.inputs">inputs</a> properties of the configuration. Once the model is exported, you can test that the model is well formed as follows:`,zt,lt,St,C,qt,at,Yt,ot,Ce=`The final step is to validate that the outputs from the base and exported model agree within some absolute tolerance.
Here we can use the <code>validate_model_outputs()</code> function provided by the <code>optimum.exporters.onnx</code> package:`,Pt,it,Dt,pt,Kt,rt,$e="Now that the support for the architectures has been implemented, and validated, there are two things left:",te,mt,_e='<li>Add your model architecture to the tests in <code>tests/exporters/test_onnx_export.py</code></li> <li>Create a PR on the <a href="https://github.com/huggingface/optimum" rel="nofollow"><code>optimum</code> repo</a></li>',ee,ct,ve="Thanks for you contribution!",ne,Mt,se;return w=new He({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),b=new ut({props:{title:"Adding support for an unsupported architecture",local:"adding-support-for-an-unsupported-architecture",headingTag:"h1"}}),A=new ut({props:{title:"Implementing a custom ONNX configuration",local:"implementing-a-custom-onnx-configuration",headingTag:"h2"}}),U=new le({props:{$$slots:{default:[Ve]},$$scope:{ctx:T}}}),E=new ut({props:{title:"Example: Adding support for BERT",local:"example-adding-support-for-bert",headingTag:"h3"}}),I=new x({props:{code:"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",highlighted:`<span class="hljs-comment"># This class is actually in optimum/exporters/onnx/config.py</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TextEncoderOnnxConfig</span>(<span class="hljs-title class_ inherited__">OnnxConfig</span>):
    <span class="hljs-comment"># Describes how to generate the dummy inputs.</span>
    DUMMY_INPUT_GENERATOR_CLASSES = (DummyTextInputGenerator,)

<span class="hljs-keyword">class</span> <span class="hljs-title class_">BertOnnxConfig</span>(<span class="hljs-title class_ inherited__">TextEncoderOnnxConfig</span>):
    <span class="hljs-comment"># Specifies how to normalize the BertConfig, this is needed to access common attributes</span>
    <span class="hljs-comment"># during dummy input generation.</span>
    NORMALIZED_CONFIG_CLASS = NormalizedTextConfig
    <span class="hljs-comment"># Sets the absolute tolerance to when validating the exported ONNX model against the</span>
    <span class="hljs-comment"># reference model.</span>
    ATOL_FOR_VALIDATION = <span class="hljs-number">1e-4</span>

<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">inputs</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Dict</span>[<span class="hljs-built_in">int</span>, <span class="hljs-built_in">str</span>]]:
        <span class="hljs-keyword">if</span> self.task == <span class="hljs-string">&quot;multiple-choice&quot;</span>:
            dynamic_axis = {<span class="hljs-number">0</span>: <span class="hljs-string">&quot;batch_size&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;num_choices&quot;</span>, <span class="hljs-number">2</span>: <span class="hljs-string">&quot;sequence_length&quot;</span>}
        <span class="hljs-keyword">else</span>:
            dynamic_axis = {<span class="hljs-number">0</span>: <span class="hljs-string">&quot;batch_size&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;sequence_length&quot;</span>}
        <span class="hljs-keyword">return</span> {
            <span class="hljs-string">&quot;input_ids&quot;</span>: dynamic_axis,
            <span class="hljs-string">&quot;attention_mask&quot;</span>: dynamic_axis,
            <span class="hljs-string">&quot;token_type_ids&quot;</span>: dynamic_axis,
        }`,wrap:!1}}),H=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMEFmcm9tJTIwb3B0aW11bS5leHBvcnRlcnMub25ueC5tb2RlbF9jb25maWdzJTIwaW1wb3J0JTIwQmVydE9ubnhDb25maWclMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEFvbm54X2NvbmZpZyUyMCUzRCUyMEJlcnRPbm54Q29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.exporters.onnx.model_configs <span class="hljs-keyword">import</span> BertOnnxConfig
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_config = BertOnnxConfig(config)`,wrap:!1}}),L=new x({props:{code:"cHJpbnQob25ueF9jb25maWcuREVGQVVMVF9PTk5YX09QU0VUKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(onnx_config.DEFAULT_ONNX_OPSET)
<span class="hljs-number">11</span>`,wrap:!1}}),O=new x({props:{code:"cHJpbnQob25ueF9jb25maWcub3V0cHV0cyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(onnx_config.outputs)
OrderedDict([(<span class="hljs-string">&#x27;last_hidden_state&#x27;</span>, {<span class="hljs-number">0</span>: <span class="hljs-string">&#x27;batch_size&#x27;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&#x27;sequence_length&#x27;</span>})])`,wrap:!1}}),z=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMEElMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEFvbm54X2NvbmZpZ19mb3Jfc2VxX2NsZiUyMCUzRCUyMEJlcnRPbm54Q29uZmlnKGNvbmZpZyUyQyUyMHRhc2slM0QlMjJ0ZXh0LWNsYXNzaWZpY2F0aW9uJTIyKSUwQXByaW50KG9ubnhfY29uZmlnX2Zvcl9zZXFfY2xmLm91dHB1dHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_config_for_seq_clf = BertOnnxConfig(config, task=<span class="hljs-string">&quot;text-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(onnx_config_for_seq_clf.outputs)
OrderedDict([(<span class="hljs-string">&#x27;logits&#x27;</span>, {<span class="hljs-number">0</span>: <span class="hljs-string">&#x27;batch_size&#x27;</span>})])`,wrap:!1}}),J=new le({props:{$$slots:{default:[Le]},$$scope:{ctx:T}}}),S=new ut({props:{title:"Registering the ONNX configuration in the TasksManager",local:"registering-the-onnx-configuration-in-the-tasksmanager",headingTag:"h2"}}),K=new x({props:{code:"JTIwJTIwJTIwJTIwJTIyYmVydCUyMiUzQSUyMHN1cHBvcnRlZF90YXNrc19tYXBwaW5nKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlZmF1bHQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJmaWxsLW1hc2slMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0ZXh0LWNsYXNzaWZpY2F0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybXVsdGlwbGUtY2hvaWNlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydG9rZW4tY2xhc3NpZmljYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJxdWVzdGlvbi1hbnN3ZXJpbmclMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvbm54JTNEJTIyQmVydE9ubnhDb25maWclMjIlMkMlMEElMjAlMjAlMjAlMjAp",highlighted:`    <span class="hljs-string">&quot;bert&quot;</span>: supported_tasks_mapping(
        <span class="hljs-string">&quot;default&quot;</span>,
        <span class="hljs-string">&quot;fill-mask&quot;</span>,
        <span class="hljs-string">&quot;text-generation&quot;</span>,
        <span class="hljs-string">&quot;text-classification&quot;</span>,
        <span class="hljs-string">&quot;multiple-choice&quot;</span>,
        <span class="hljs-string">&quot;token-classification&quot;</span>,
        <span class="hljs-string">&quot;question-answering&quot;</span>,
        onnx=<span class="hljs-string">&quot;BertOnnxConfig&quot;</span>,
    )`,wrap:!1}}),tt=new ut({props:{title:"Exporting the model",local:"exporting-the-model",headingTag:"h2"}}),nt=new x({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMG9wdGltdW0uZXhwb3J0ZXJzLnRhc2tzJTIwaW1wb3J0JTIwVGFza3NNYW5hZ2VyJTBBZnJvbSUyMG9wdGltdW0uZXhwb3J0ZXJzLm9ubnglMjBpbXBvcnQlMjBleHBvcnQlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTBBJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBJTBBb25ueF9wYXRoJTIwJTNEJTIwUGF0aCglMjJtb2RlbC5vbm54JTIyKSUwQW9ubnhfY29uZmlnX2NvbnN0cnVjdG9yJTIwJTNEJTIwVGFza3NNYW5hZ2VyLmdldF9leHBvcnRlcl9jb25maWdfY29uc3RydWN0b3IoJTIyb25ueCUyMiUyQyUyMGJhc2VfbW9kZWwpJTBBb25ueF9jb25maWclMjAlM0QlMjBvbm54X2NvbmZpZ19jb25zdHJ1Y3RvcihiYXNlX21vZGVsLmNvbmZpZyklMEElMEFvbm54X2lucHV0cyUyQyUyMG9ubnhfb3V0cHV0cyUyMCUzRCUyMGV4cG9ydChiYXNlX21vZGVsJTJDJTIwb25ueF9jb25maWclMkMlMjBvbm54X3BhdGglMkMlMjBvbm54X2NvbmZpZy5ERUZBVUxUX09OTlhfT1BTRVQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.exporters.tasks <span class="hljs-keyword">import</span> TasksManager
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.exporters.onnx <span class="hljs-keyword">import</span> export
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span>base_model = AutoModel.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_path = Path(<span class="hljs-string">&quot;model.onnx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_config_constructor = TasksManager.get_exporter_config_constructor(<span class="hljs-string">&quot;onnx&quot;</span>, base_model)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_config = onnx_config_constructor(base_model.config)

<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_inputs, onnx_outputs = export(base_model, onnx_config, onnx_path, onnx_config.DEFAULT_ONNX_OPSET)`,wrap:!1}}),lt=new x({props:{code:"aW1wb3J0JTIwb25ueCUwQSUwQW9ubnhfbW9kZWwlMjAlM0QlMjBvbm54LmxvYWQoJTIybW9kZWwub25ueCUyMiklMEFvbm54LmNoZWNrZXIuY2hlY2tfbW9kZWwob25ueF9tb2RlbCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> onnx

<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_model = onnx.load(<span class="hljs-string">&quot;model.onnx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx.checker.check_model(onnx_model)`,wrap:!1}}),C=new le({props:{$$slots:{default:[Fe]},$$scope:{ctx:T}}}),at=new ut({props:{title:"Validating the model outputs",local:"validating-the-model-outputs",headingTag:"h2"}}),it=new x({props:{code:"ZnJvbSUyMG9wdGltdW0uZXhwb3J0ZXJzLm9ubnglMjBpbXBvcnQlMjB2YWxpZGF0ZV9tb2RlbF9vdXRwdXRzJTBBJTBBdmFsaWRhdGVfbW9kZWxfb3V0cHV0cyglMEElMjAlMjAlMjAlMjBvbm54X2NvbmZpZyUyQyUyMGJhc2VfbW9kZWwlMkMlMjBvbm54X3BhdGglMkMlMjBvbm54X291dHB1dHMlMkMlMjBvbm54X2NvbmZpZy5BVE9MX0ZPUl9WQUxJREFUSU9OJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.exporters.onnx <span class="hljs-keyword">import</span> validate_model_outputs

<span class="hljs-meta">&gt;&gt;&gt; </span>validate_model_outputs(
<span class="hljs-meta">... </span>    onnx_config, base_model, onnx_path, onnx_outputs, onnx_config.ATOL_FOR_VALIDATION
<span class="hljs-meta">... </span>)`,wrap:!1}}),pt=new ut({props:{title:"Contributing the new configuration to 🤗 Optimum",local:"contributing-the-new-configuration-to--optimum",headingTag:"h2"}}),{c(){o=i("meta"),j=l(),m=i("p"),y=l(),c(w.$$.fragment),g=l(),c(b.$$.fragment),ht=l(),$=i("p"),$.textContent=oe,dt=l(),_=i("ol"),_.innerHTML=ie,ft=l(),v=i("p"),v.textContent=pe,yt=l(),c(A.$$.fragment),gt=l(),k=i("p"),k.innerHTML=re,jt=l(),c(U.$$.fragment),bt=l(),Z=i("p"),Z.textContent=me,wt=l(),c(E.$$.fragment),xt=l(),N=i("p"),N.innerHTML=ce,Tt=l(),c(I.$$.fragment),Ut=l(),B=i("p"),B.innerHTML=ue,Jt=l(),X=i("p"),X.innerHTML=Me,Ct=l(),W=i("ul"),W.innerHTML=he,$t=l(),R=i("p"),R.innerHTML=de,_t=l(),G=i("p"),G.textContent=fe,vt=l(),c(H.$$.fragment),At=l(),V=i("p"),V.textContent=ye,kt=l(),c(L.$$.fragment),Zt=l(),F=i("p"),F.textContent=ge,Et=l(),c(O.$$.fragment),Nt=l(),Q=i("p"),Q.innerHTML=je,It=l(),c(z.$$.fragment),Bt=l(),c(J.$$.fragment),Xt=l(),c(S.$$.fragment),Wt=l(),q=i("p"),q.innerHTML=be,Rt=l(),Y=i("p"),Y.innerHTML=we,Gt=l(),P=i("ul"),P.innerHTML=xe,Ht=l(),D=i("p"),D.textContent=Te,Vt=l(),c(K.$$.fragment),Lt=l(),c(tt.$$.fragment),Ft=l(),et=i("p"),et.innerHTML=Ue,Ot=l(),c(nt.$$.fragment),Qt=l(),st=i("p"),st.innerHTML=Je,zt=l(),c(lt.$$.fragment),St=l(),c(C.$$.fragment),qt=l(),c(at.$$.fragment),Yt=l(),ot=i("p"),ot.innerHTML=Ce,Pt=l(),c(it.$$.fragment),Dt=l(),c(pt.$$.fragment),Kt=l(),rt=i("p"),rt.textContent=$e,te=l(),mt=i("ol"),mt.innerHTML=_e,ee=l(),ct=i("p"),ct.textContent=ve,ne=l(),Mt=i("p"),this.h()},l(t){const e=Re("svelte-u9bgzb",document.head);o=p(e,"META",{name:!0,content:!0}),e.forEach(n),j=a(t),m=p(t,"P",{}),Ee(m).forEach(n),y=a(t),u(w.$$.fragment,t),g=a(t),u(b.$$.fragment,t),ht=a(t),$=p(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-wyfgyh"&&($.textContent=oe),dt=a(t),_=p(t,"OL",{"data-svelte-h":!0}),r(_)!=="svelte-1i70n0q"&&(_.innerHTML=ie),ft=a(t),v=p(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1faxzt5"&&(v.textContent=pe),yt=a(t),u(A.$$.fragment,t),gt=a(t),k=p(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-h5ikbh"&&(k.innerHTML=re),jt=a(t),u(U.$$.fragment,t),bt=a(t),Z=p(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1aazjya"&&(Z.textContent=me),wt=a(t),u(E.$$.fragment,t),xt=a(t),N=p(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-g0z0fk"&&(N.innerHTML=ce),Tt=a(t),u(I.$$.fragment,t),Ut=a(t),B=p(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1goyjkt"&&(B.innerHTML=ue),Jt=a(t),X=p(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-jfkvll"&&(X.innerHTML=Me),Ct=a(t),W=p(t,"UL",{"data-svelte-h":!0}),r(W)!=="svelte-1lb8len"&&(W.innerHTML=he),$t=a(t),R=p(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-y4yu4v"&&(R.innerHTML=de),_t=a(t),G=p(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1hidcfs"&&(G.textContent=fe),vt=a(t),u(H.$$.fragment,t),At=a(t),V=p(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-de93a2"&&(V.textContent=ye),kt=a(t),u(L.$$.fragment,t),Zt=a(t),F=p(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1wxissk"&&(F.textContent=ge),Et=a(t),u(O.$$.fragment,t),Nt=a(t),Q=p(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-e8rha9"&&(Q.innerHTML=je),It=a(t),u(z.$$.fragment,t),Bt=a(t),u(J.$$.fragment,t),Xt=a(t),u(S.$$.fragment,t),Wt=a(t),q=p(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-k2wk0s"&&(q.innerHTML=be),Rt=a(t),Y=p(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1sb1s64"&&(Y.innerHTML=we),Gt=a(t),P=p(t,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-glrx48"&&(P.innerHTML=xe),Ht=a(t),D=p(t,"P",{"data-svelte-h":!0}),r(D)!=="svelte-17sq7il"&&(D.textContent=Te),Vt=a(t),u(K.$$.fragment,t),Lt=a(t),u(tt.$$.fragment,t),Ft=a(t),et=p(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-dpvtiu"&&(et.innerHTML=Ue),Ot=a(t),u(nt.$$.fragment,t),Qt=a(t),st=p(t,"P",{"data-svelte-h":!0}),r(st)!=="svelte-9oo7cv"&&(st.innerHTML=Je),zt=a(t),u(lt.$$.fragment,t),St=a(t),u(C.$$.fragment,t),qt=a(t),u(at.$$.fragment,t),Yt=a(t),ot=p(t,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-je0ksn"&&(ot.innerHTML=Ce),Pt=a(t),u(it.$$.fragment,t),Dt=a(t),u(pt.$$.fragment,t),Kt=a(t),rt=p(t,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-m5s9fa"&&(rt.textContent=$e),te=a(t),mt=p(t,"OL",{"data-svelte-h":!0}),r(mt)!=="svelte-1eec8bu"&&(mt.innerHTML=_e),ee=a(t),ct=p(t,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-zwsyvs"&&(ct.textContent=ve),ne=a(t),Mt=p(t,"P",{}),Ee(Mt).forEach(n),this.h()},h(){Ne(o,"name","hf:doc:metadata"),Ne(o,"content",Qe)},m(t,e){Ge(document.head,o),s(t,j,e),s(t,m,e),s(t,y,e),M(w,t,e),s(t,g,e),M(b,t,e),s(t,ht,e),s(t,$,e),s(t,dt,e),s(t,_,e),s(t,ft,e),s(t,v,e),s(t,yt,e),M(A,t,e),s(t,gt,e),s(t,k,e),s(t,jt,e),M(U,t,e),s(t,bt,e),s(t,Z,e),s(t,wt,e),M(E,t,e),s(t,xt,e),s(t,N,e),s(t,Tt,e),M(I,t,e),s(t,Ut,e),s(t,B,e),s(t,Jt,e),s(t,X,e),s(t,Ct,e),s(t,W,e),s(t,$t,e),s(t,R,e),s(t,_t,e),s(t,G,e),s(t,vt,e),M(H,t,e),s(t,At,e),s(t,V,e),s(t,kt,e),M(L,t,e),s(t,Zt,e),s(t,F,e),s(t,Et,e),M(O,t,e),s(t,Nt,e),s(t,Q,e),s(t,It,e),M(z,t,e),s(t,Bt,e),M(J,t,e),s(t,Xt,e),M(S,t,e),s(t,Wt,e),s(t,q,e),s(t,Rt,e),s(t,Y,e),s(t,Gt,e),s(t,P,e),s(t,Ht,e),s(t,D,e),s(t,Vt,e),M(K,t,e),s(t,Lt,e),M(tt,t,e),s(t,Ft,e),s(t,et,e),s(t,Ot,e),M(nt,t,e),s(t,Qt,e),s(t,st,e),s(t,zt,e),M(lt,t,e),s(t,St,e),M(C,t,e),s(t,qt,e),M(at,t,e),s(t,Yt,e),s(t,ot,e),s(t,Pt,e),M(it,t,e),s(t,Dt,e),M(pt,t,e),s(t,Kt,e),s(t,rt,e),s(t,te,e),s(t,mt,e),s(t,ee,e),s(t,ct,e),s(t,ne,e),s(t,Mt,e),se=!0},p(t,[e]){const Ae={};e&2&&(Ae.$$scope={dirty:e,ctx:t}),U.$set(Ae);const ke={};e&2&&(ke.$$scope={dirty:e,ctx:t}),J.$set(ke);const Ze={};e&2&&(Ze.$$scope={dirty:e,ctx:t}),C.$set(Ze)},i(t){se||(h(w.$$.fragment,t),h(b.$$.fragment,t),h(A.$$.fragment,t),h(U.$$.fragment,t),h(E.$$.fragment,t),h(I.$$.fragment,t),h(H.$$.fragment,t),h(L.$$.fragment,t),h(O.$$.fragment,t),h(z.$$.fragment,t),h(J.$$.fragment,t),h(S.$$.fragment,t),h(K.$$.fragment,t),h(tt.$$.fragment,t),h(nt.$$.fragment,t),h(lt.$$.fragment,t),h(C.$$.fragment,t),h(at.$$.fragment,t),h(it.$$.fragment,t),h(pt.$$.fragment,t),se=!0)},o(t){d(w.$$.fragment,t),d(b.$$.fragment,t),d(A.$$.fragment,t),d(U.$$.fragment,t),d(E.$$.fragment,t),d(I.$$.fragment,t),d(H.$$.fragment,t),d(L.$$.fragment,t),d(O.$$.fragment,t),d(z.$$.fragment,t),d(J.$$.fragment,t),d(S.$$.fragment,t),d(K.$$.fragment,t),d(tt.$$.fragment,t),d(nt.$$.fragment,t),d(lt.$$.fragment,t),d(C.$$.fragment,t),d(at.$$.fragment,t),d(it.$$.fragment,t),d(pt.$$.fragment,t),se=!1},d(t){t&&(n(j),n(m),n(y),n(g),n(ht),n($),n(dt),n(_),n(ft),n(v),n(yt),n(gt),n(k),n(jt),n(bt),n(Z),n(wt),n(xt),n(N),n(Tt),n(Ut),n(B),n(Jt),n(X),n(Ct),n(W),n($t),n(R),n(_t),n(G),n(vt),n(At),n(V),n(kt),n(Zt),n(F),n(Et),n(Nt),n(Q),n(It),n(Bt),n(Xt),n(Wt),n(q),n(Rt),n(Y),n(Gt),n(P),n(Ht),n(D),n(Vt),n(Lt),n(Ft),n(et),n(Ot),n(Qt),n(st),n(zt),n(St),n(qt),n(Yt),n(ot),n(Pt),n(Dt),n(Kt),n(rt),n(te),n(mt),n(ee),n(ct),n(ne),n(Mt)),n(o),f(w,t),f(b,t),f(A,t),f(U,t),f(E,t),f(I,t),f(H,t),f(L,t),f(O,t),f(z,t),f(J,t),f(S,t),f(K,t),f(tt,t),f(nt,t),f(lt,t),f(C,t),f(at,t),f(it,t),f(pt,t)}}}const Qe='{"title":"Adding support for an unsupported architecture","local":"adding-support-for-an-unsupported-architecture","sections":[{"title":"Implementing a custom ONNX configuration","local":"implementing-a-custom-onnx-configuration","sections":[{"title":"Example: Adding support for BERT","local":"example-adding-support-for-bert","sections":[],"depth":3}],"depth":2},{"title":"Registering the ONNX configuration in the TasksManager","local":"registering-the-onnx-configuration-in-the-tasksmanager","sections":[],"depth":2},{"title":"Exporting the model","local":"exporting-the-model","sections":[],"depth":2},{"title":"Validating the model outputs","local":"validating-the-model-outputs","sections":[],"depth":2},{"title":"Contributing the new configuration to 🤗 Optimum","local":"contributing-the-new-configuration-to--optimum","sections":[],"depth":2}],"depth":1}';function ze(T){return Be(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ke extends Xe{constructor(o){super(),We(this,o,ze,Oe,Ie,{})}}export{Ke as component};
