import{s as Gt,n as Xt,o as Wt}from"../chunks/scheduler.5f3e6389.js";import{S as Tt,i as vt,e as p,s as l,c,h as Rt,a as i,d as e,b as n,f as Jt,g as r,j as o,k as Zt,l as zt,m as s,n as d,t as M,o as h,p as b}from"../chunks/index.373ab25c.js";import{C as kt,H as Bt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.315d5a08.js";import{C as _}from"../chunks/CodeBlock.fbe06bf8.js";function Ct(ct){let m,I,V,x,u,Q,y,H,j,rt="At its core, 🤗 Optimum uses <em>configuration objects</em> to define parameters for optimization on different accelerators. These objects are then used to instantiate dedicated <em>optimizers</em>, <em>quantizers</em>, and <em>pruners</em>.",$,g,dt="Before applying quantization or optimization, we first need to export our model to the ONNX format.",E,f,q,w,Mt="Let’s see now how we can apply dynamic quantization with ONNX Runtime:",S,U,A,J,ht="In this example, we’ve quantized a model from the Hugging Face Hub, but it could also be a path to a local model directory. The result from applying the <code>quantize()</code> method is a <code>model_quantized.onnx</code> file that can be used to run inference. Here’s an example of how to load an ONNX Runtime model and generate predictions with it:",L,Z,P,G,bt="Similarly, you can apply static quantization by simply setting <code>is_static</code> to <code>True</code> when instantiating the <code>QuantizationConfig</code> object:",O,X,D,W,ut='Static quantization relies on feeding batches of data through the model to estimate the activation quantization parameters ahead of inference time. To support this, 🤗 Optimum allows you to provide a <em>calibration dataset</em>. The calibration dataset can be a simple <code>Dataset</code> object from the 🤗 Datasets library, or any dataset that’s hosted on the Hugging Face Hub. For this example, we’ll pick the <a href="https://huggingface.co/datasets/glue/viewer/sst2/test" rel="nofollow"><code>sst2</code></a> dataset that the model was originally trained on:',K,T,tt,v,yt="As a final example, let’s take a look at applying <em>graph optimizations</em> techniques such as operator fusion and constant folding. As before, we load a configuration object, but this time by setting the optimization level instead of the quantization approach:",at,R,et,z,jt="Next, we load an <em>optimizer</em> to apply these optimisations to our model:",st,k,lt,B,gt="And that’s it - the model is now optimized and ready for inference! As you can see, the process is similar in each case:",nt,C,ft="<li>Define the optimization / quantization strategies via an <code>OptimizationConfig</code> / <code>QuantizationConfig</code> object</li> <li>Instantiate a <code>ORTQuantizer</code> or <code>ORTOptimizer</code> class</li> <li>Apply the <code>quantize()</code> or <code>optimize()</code> method</li> <li>Run inference</li>",pt,N,wt='Check out the <a href="https://github.com/huggingface/optimum/tree/main/examples" rel="nofollow"><code>examples</code></a> directory for more sophisticated usage.',it,Y,Ut="Happy optimising 🤗!",ot,F,mt;return u=new kt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),y=new Bt({props:{title:"Quickstart",local:"quickstart",headingTag:"h1"}}),f=new _({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsX2NoZWNrcG9pbnQlMjAlM0QlMjAlMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCUyMiUwQXNhdmVfZGlyZWN0b3J5JTIwJTNEJTIwJTIydG1wJTJGb25ueCUyRiUyMiUwQSUyMyUyMExvYWQlMjBhJTIwbW9kZWwlMjBmcm9tJTIwdHJhbnNmb3JtZXJzJTIwYW5kJTIwZXhwb3J0JTIwaXQlMjB0byUyME9OTlglMEFvcnRfbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2NoZWNrcG9pbnQlMkMlMjBleHBvcnQlM0RUcnVlKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2NoZWNrcG9pbnQpJTBBJTIzJTIwU2F2ZSUyMHRoZSUyMG9ubnglMjBtb2RlbCUyMGFuZCUyMHRva2VuaXplciUwQW9ydF9tb2RlbC5zYXZlX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBdG9rZW5pemVyLnNhdmVfcHJldHJhaW5lZChzYXZlX2RpcmVjdG9yeSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_directory = <span class="hljs-string">&quot;tmp/onnx/&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load a model from transformers and export it to ONNX</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(model_checkpoint, export=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Save the onnx model and tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model.save_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.save_pretrained(save_directory)`,wrap:!1}}),U=new _({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUuY29uZmlndXJhdGlvbiUyMGltcG9ydCUyMEF1dG9RdWFudGl6YXRpb25Db25maWclMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVFF1YW50aXplciUwQSUyMyUyMERlZmluZSUyMHRoZSUyMHF1YW50aXphdGlvbiUyMG1ldGhvZG9sb2d5JTBBcWNvbmZpZyUyMCUzRCUyMEF1dG9RdWFudGl6YXRpb25Db25maWcuYXJtNjQoaXNfc3RhdGljJTNERmFsc2UlMkMlMjBwZXJfY2hhbm5lbCUzREZhbHNlKSUwQXF1YW50aXplciUyMCUzRCUyME9SVFF1YW50aXplci5mcm9tX3ByZXRyYWluZWQob3J0X21vZGVsKSUwQSUyMyUyMEFwcGx5JTIwZHluYW1pYyUyMHF1YW50aXphdGlvbiUyMG9uJTIwdGhlJTIwbW9kZWwlMEFxdWFudGl6ZXIucXVhbnRpemUoc2F2ZV9kaXIlM0RzYXZlX2RpcmVjdG9yeSUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RxY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime.configuration <span class="hljs-keyword">import</span> AutoQuantizationConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTQuantizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Define the quantization methodology</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>qconfig = AutoQuantizationConfig.arm64(is_static=<span class="hljs-literal">False</span>, per_channel=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer = ORTQuantizer.from_pretrained(ort_model)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Apply dynamic quantization on the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer.quantize(save_dir=save_directory, quantization_config=qconfig)`,wrap:!1}}),Z=new _({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMkMlMjBBdXRvVG9rZW5pemVyJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKHNhdmVfZGlyZWN0b3J5JTJDJTIwZmlsZV9uYW1lJTNEJTIybW9kZWxfcXVhbnRpemVkLm9ubnglMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBY2xzX3BpcGVsaW5lJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBcmVzdWx0cyUyMCUzRCUyMGNsc19waXBlbGluZSglMjJJJTIwbG92ZSUyMGJ1cnJpdG9zISUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline, AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(save_directory, file_name=<span class="hljs-string">&quot;model_quantized.onnx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>cls_pipeline = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=model, tokenizer=tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>results = cls_pipeline(<span class="hljs-string">&quot;I love burritos!&quot;</span>)`,wrap:!1}}),X=new _({props:{code:"cWNvbmZpZyUyMCUzRCUyMEF1dG9RdWFudGl6YXRpb25Db25maWcuYXJtNjQoaXNfc3RhdGljJTNEVHJ1ZSUyQyUyMHBlcl9jaGFubmVsJTNERmFsc2Up",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>qconfig = AutoQuantizationConfig.arm64(is_static=<span class="hljs-literal">True</span>, per_channel=<span class="hljs-literal">False</span>)',wrap:!1}}),T=new _({props:{code:"ZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZS5jb25maWd1cmF0aW9uJTIwaW1wb3J0JTIwQXV0b0NhbGlicmF0aW9uQ29uZmlnJTBBJTBBZGVmJTIwcHJlcHJvY2Vzc19mbihleCUyQyUyMHRva2VuaXplciklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0b2tlbml6ZXIoZXglNUIlMjJzZW50ZW5jZSUyMiU1RCklMEElMEElMjMlMjBDcmVhdGUlMjB0aGUlMjBjYWxpYnJhdGlvbiUyMGRhdGFzZXQlMEFjYWxpYnJhdGlvbl9kYXRhc2V0JTIwJTNEJTIwcXVhbnRpemVyLmdldF9jYWxpYnJhdGlvbl9kYXRhc2V0KCUwQSUyMCUyMCUyMCUyMCUyMmdsdWUlMjIlMkMlMEElMjAlMjAlMjAlMjBkYXRhc2V0X2NvbmZpZ19uYW1lJTNEJTIyc3N0MiUyMiUyQyUwQSUyMCUyMCUyMCUyMHByZXByb2Nlc3NfZnVuY3Rpb24lM0RwYXJ0aWFsKHByZXByb2Nlc3NfZm4lMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3NhbXBsZXMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUwQSklMEElMjMlMjBDcmVhdGUlMjB0aGUlMjBjYWxpYnJhdGlvbiUyMGNvbmZpZ3VyYXRpb24lMjBjb250YWluaW5nJTIwdGhlJTIwcGFyYW1ldGVycyUyMHJlbGF0ZWQlMjB0byUyMGNhbGlicmF0aW9uLiUwQWNhbGlicmF0aW9uX2NvbmZpZyUyMCUzRCUyMEF1dG9DYWxpYnJhdGlvbkNvbmZpZy5taW5tYXgoY2FsaWJyYXRpb25fZGF0YXNldCklMEElMjMlMjBQZXJmb3JtJTIwdGhlJTIwY2FsaWJyYXRpb24lMjBzdGVwJTNBJTIwY29tcHV0ZXMlMjB0aGUlMjBhY3RpdmF0aW9ucyUyMHF1YW50aXphdGlvbiUyMHJhbmdlcyUwQXJhbmdlcyUyMCUzRCUyMHF1YW50aXplci5maXQoJTBBJTIwJTIwJTIwJTIwZGF0YXNldCUzRGNhbGlicmF0aW9uX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBjYWxpYnJhdGlvbl9jb25maWclM0RjYWxpYnJhdGlvbl9jb25maWclMkMlMEElMjAlMjAlMjAlMjBvcGVyYXRvcnNfdG9fcXVhbnRpemUlM0RxY29uZmlnLm9wZXJhdG9yc190b19xdWFudGl6ZSUyQyUwQSklMEElMjMlMjBBcHBseSUyMHN0YXRpYyUyMHF1YW50aXphdGlvbiUyMG9uJTIwdGhlJTIwbW9kZWwlMEFxdWFudGl6ZXIucXVhbnRpemUoJTBBJTIwJTIwJTIwJTIwc2F2ZV9kaXIlM0RzYXZlX2RpcmVjdG9yeSUyQyUwQSUyMCUyMCUyMCUyMGNhbGlicmF0aW9uX3RlbnNvcnNfcmFuZ2UlM0RyYW5nZXMlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcWNvbmZpZyUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime.configuration <span class="hljs-keyword">import</span> AutoCalibrationConfig

<span class="hljs-comment"># Define the processing function to apply to each example after loading the dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_fn</span>(<span class="hljs-params">ex, tokenizer</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer(ex[<span class="hljs-string">&quot;sentence&quot;</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create the calibration dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>calibration_dataset = quantizer.get_calibration_dataset(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;glue&quot;</span>,
<span class="hljs-meta">... </span>    dataset_config_name=<span class="hljs-string">&quot;sst2&quot;</span>,
<span class="hljs-meta">... </span>    preprocess_function=partial(preprocess_fn, tokenizer=tokenizer),
<span class="hljs-meta">... </span>    num_samples=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    dataset_split=<span class="hljs-string">&quot;train&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create the calibration configuration containing the parameters related to calibration.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>calibration_config = AutoCalibrationConfig.minmax(calibration_dataset)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Perform the calibration step: computes the activations quantization ranges</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ranges = quantizer.fit(
<span class="hljs-meta">... </span>    dataset=calibration_dataset,
<span class="hljs-meta">... </span>    calibration_config=calibration_config,
<span class="hljs-meta">... </span>    operators_to_quantize=qconfig.operators_to_quantize,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Apply static quantization on the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer.quantize(
<span class="hljs-meta">... </span>    save_dir=save_directory,
<span class="hljs-meta">... </span>    calibration_tensors_range=ranges,
<span class="hljs-meta">... </span>    quantization_config=qconfig,
<span class="hljs-meta">... </span>)`,wrap:!1}}),R=new _({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUuY29uZmlndXJhdGlvbiUyMGltcG9ydCUyME9wdGltaXphdGlvbkNvbmZpZyUwQSUwQSUyMyUyMEhlcmUlMjB0aGUlMjBvcHRpbWl6YXRpb24lMjBsZXZlbCUyMGlzJTIwc2VsZWN0ZWQlMjB0byUyMGJlJTIwMSUyQyUyMGVuYWJsaW5nJTIwYmFzaWMlMjBvcHRpbWl6YXRpb25zJTIwc3VjaCUyMGFzJTIwcmVkdW5kYW50JTIwbm9kZSUyMGVsaW1pbmF0aW9ucyUyMGFuZCUyMGNvbnN0YW50JTIwZm9sZGluZy4lMjBIaWdoZXIlMjBvcHRpbWl6YXRpb24lMjBsZXZlbCUyMHdpbGwlMjByZXN1bHQlMjBpbiUyMGElMjBoYXJkd2FyZSUyMGRlcGVuZGVudCUyMG9wdGltaXplZCUyMGdyYXBoLiUwQW9wdGltaXphdGlvbl9jb25maWclMjAlM0QlMjBPcHRpbWl6YXRpb25Db25maWcob3B0aW1pemF0aW9uX2xldmVsJTNEMSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime.configuration <span class="hljs-keyword">import</span> OptimizationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Here the optimization level is selected to be 1, enabling basic optimizations such as redundant node eliminations and constant folding. Higher optimization level will result in a hardware dependent optimized graph.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>optimization_config = OptimizationConfig(optimization_level=<span class="hljs-number">1</span>)`,wrap:!1}}),k=new _({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRPcHRpbWl6ZXIlMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjBPUlRPcHRpbWl6ZXIuZnJvbV9wcmV0cmFpbmVkKG9ydF9tb2RlbCklMEElMEElMjMlMjBPcHRpbWl6ZSUyMHRoZSUyMG1vZGVsJTBBb3B0aW1pemVyLm9wdGltaXplKHNhdmVfZGlyJTNEc2F2ZV9kaXJlY3RvcnklMkMlMjBvcHRpbWl6YXRpb25fY29uZmlnJTNEb3B0aW1pemF0aW9uX2NvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTOptimizer

<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = ORTOptimizer.from_pretrained(ort_model)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Optimize the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer.optimize(save_dir=save_directory, optimization_config=optimization_config)`,wrap:!1}}),{c(){m=p("meta"),I=l(),V=p("p"),x=l(),c(u.$$.fragment),Q=l(),c(y.$$.fragment),H=l(),j=p("p"),j.innerHTML=rt,$=l(),g=p("p"),g.textContent=dt,E=l(),c(f.$$.fragment),q=l(),w=p("p"),w.textContent=Mt,S=l(),c(U.$$.fragment),A=l(),J=p("p"),J.innerHTML=ht,L=l(),c(Z.$$.fragment),P=l(),G=p("p"),G.innerHTML=bt,O=l(),c(X.$$.fragment),D=l(),W=p("p"),W.innerHTML=ut,K=l(),c(T.$$.fragment),tt=l(),v=p("p"),v.innerHTML=yt,at=l(),c(R.$$.fragment),et=l(),z=p("p"),z.innerHTML=jt,st=l(),c(k.$$.fragment),lt=l(),B=p("p"),B.textContent=gt,nt=l(),C=p("ol"),C.innerHTML=ft,pt=l(),N=p("p"),N.innerHTML=wt,it=l(),Y=p("p"),Y.textContent=Ut,ot=l(),F=p("p"),this.h()},l(t){const a=Rt("svelte-u9bgzb",document.head);m=i(a,"META",{name:!0,content:!0}),a.forEach(e),I=n(t),V=i(t,"P",{}),Jt(V).forEach(e),x=n(t),r(u.$$.fragment,t),Q=n(t),r(y.$$.fragment,t),H=n(t),j=i(t,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1vlvz9n"&&(j.innerHTML=rt),$=n(t),g=i(t,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1kzojza"&&(g.textContent=dt),E=n(t),r(f.$$.fragment,t),q=n(t),w=i(t,"P",{"data-svelte-h":!0}),o(w)!=="svelte-e7rpqh"&&(w.textContent=Mt),S=n(t),r(U.$$.fragment,t),A=n(t),J=i(t,"P",{"data-svelte-h":!0}),o(J)!=="svelte-o28jdo"&&(J.innerHTML=ht),L=n(t),r(Z.$$.fragment,t),P=n(t),G=i(t,"P",{"data-svelte-h":!0}),o(G)!=="svelte-o27pzy"&&(G.innerHTML=bt),O=n(t),r(X.$$.fragment,t),D=n(t),W=i(t,"P",{"data-svelte-h":!0}),o(W)!=="svelte-sm0oyj"&&(W.innerHTML=ut),K=n(t),r(T.$$.fragment,t),tt=n(t),v=i(t,"P",{"data-svelte-h":!0}),o(v)!=="svelte-9hlkfw"&&(v.innerHTML=yt),at=n(t),r(R.$$.fragment,t),et=n(t),z=i(t,"P",{"data-svelte-h":!0}),o(z)!=="svelte-xtipap"&&(z.innerHTML=jt),st=n(t),r(k.$$.fragment,t),lt=n(t),B=i(t,"P",{"data-svelte-h":!0}),o(B)!=="svelte-8fcqft"&&(B.textContent=gt),nt=n(t),C=i(t,"OL",{"data-svelte-h":!0}),o(C)!=="svelte-114qv5k"&&(C.innerHTML=ft),pt=n(t),N=i(t,"P",{"data-svelte-h":!0}),o(N)!=="svelte-ka9cob"&&(N.innerHTML=wt),it=n(t),Y=i(t,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1u3x3lz"&&(Y.textContent=Ut),ot=n(t),F=i(t,"P",{}),Jt(F).forEach(e),this.h()},h(){Zt(m,"name","hf:doc:metadata"),Zt(m,"content",Nt)},m(t,a){zt(document.head,m),s(t,I,a),s(t,V,a),s(t,x,a),d(u,t,a),s(t,Q,a),d(y,t,a),s(t,H,a),s(t,j,a),s(t,$,a),s(t,g,a),s(t,E,a),d(f,t,a),s(t,q,a),s(t,w,a),s(t,S,a),d(U,t,a),s(t,A,a),s(t,J,a),s(t,L,a),d(Z,t,a),s(t,P,a),s(t,G,a),s(t,O,a),d(X,t,a),s(t,D,a),s(t,W,a),s(t,K,a),d(T,t,a),s(t,tt,a),s(t,v,a),s(t,at,a),d(R,t,a),s(t,et,a),s(t,z,a),s(t,st,a),d(k,t,a),s(t,lt,a),s(t,B,a),s(t,nt,a),s(t,C,a),s(t,pt,a),s(t,N,a),s(t,it,a),s(t,Y,a),s(t,ot,a),s(t,F,a),mt=!0},p:Xt,i(t){mt||(M(u.$$.fragment,t),M(y.$$.fragment,t),M(f.$$.fragment,t),M(U.$$.fragment,t),M(Z.$$.fragment,t),M(X.$$.fragment,t),M(T.$$.fragment,t),M(R.$$.fragment,t),M(k.$$.fragment,t),mt=!0)},o(t){h(u.$$.fragment,t),h(y.$$.fragment,t),h(f.$$.fragment,t),h(U.$$.fragment,t),h(Z.$$.fragment,t),h(X.$$.fragment,t),h(T.$$.fragment,t),h(R.$$.fragment,t),h(k.$$.fragment,t),mt=!1},d(t){t&&(e(I),e(V),e(x),e(Q),e(H),e(j),e($),e(g),e(E),e(q),e(w),e(S),e(A),e(J),e(L),e(P),e(G),e(O),e(D),e(W),e(K),e(tt),e(v),e(at),e(et),e(z),e(st),e(lt),e(B),e(nt),e(C),e(pt),e(N),e(it),e(Y),e(ot),e(F)),e(m),b(u,t),b(y,t),b(f,t),b(U,t),b(Z,t),b(X,t),b(T,t),b(R,t),b(k,t)}}}const Nt='{"title":"Quickstart","local":"quickstart","sections":[],"depth":1}';function Yt(ct){return Wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xt extends Tt{constructor(m){super(),vt(this,m,Yt,Ct,Gt,{})}}export{xt as component};
