# Configuration classes for ONNX exports

Exporting a model to ONNX involves specifying:
1. The input names.
2. The output names.
3. The dynamic axes. These refer to the input dimensions can be changed dynamically at runtime (e.g. a batch size or sequence length).
All other axes will be treated as static, and hence fixed at runtime.
4. Dummy inputs to trace the model. This is needed in PyTorch to record the computational graph and convert it to ONNX.

Since this data depends on the choice of model and task, we represent it in terms of _configuration classes_. Each configuration class is associated with
a specific model architecture, and follows the naming convention `ArchitectureNameOnnxConfig`. For instance, the configuration which specifies the ONNX
export of BERT models is `BertOnnxConfig`.

Since many architectures share similar properties for their ONNX configuration, 🤗 Optimum adopts a 3-level class hierarchy:
1. Abstract and generic base classes. These handle all the fundamental features, while being agnostic to the modality (text, image, audio, etc).
2. Middle-end classes. These are aware of the modality, but multiple can exist for the same modality depending on the inputs they support.
They specify which input generators should be used for the dummy inputs, but remain model-agnostic.
3. Model-specific classes like the `BertOnnxConfig` mentioned above. These are the ones actually used to export models.


## Base classes[[optimum.exporters.onnx.OnnxConfig]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.exporters.onnx.OnnxConfig</name><anchor>optimum.exporters.onnx.OnnxConfig</anchor><source>https://github.com/huggingface/optimum-onnx/blob/v0.0.2/optimum/exporters/onnx/base.py#L92</source><parameters>[{"name": "config", "val": ": PretrainedConfig"}, {"name": "task", "val": ": str = 'feature-extraction'"}, {"name": "preprocessors", "val": ": list[Any] | None = None"}, {"name": "int_dtype", "val": ": str = 'int64'"}, {"name": "float_dtype", "val": ": str = 'fp32'"}]</parameters></docstring>



<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>inputs</name><anchor>optimum.exporters.onnx.OnnxConfig.inputs</anchor><source>https://github.com/huggingface/optimum-onnx/blob/v0.0.2/optimum/exporters/base.py#L164</source><parameters>[]</parameters><rettype>`Dict[str, Dict[int, str]]`</rettype><retdesc>A mapping of each input name to a mapping of axis position to the axes symbolic name.</retdesc></docstring>

Dict containing the axis definition of the input tensors to provide to the model.






</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>outputs</name><anchor>optimum.exporters.onnx.OnnxConfig.outputs</anchor><source>https://github.com/huggingface/optimum-onnx/blob/v0.0.2/optimum/exporters/base.py#L175</source><parameters>[]</parameters><rettype>`Dict[str, Dict[int, str]]`</rettype><retdesc>A mapping of each output name to a mapping of axis position to the axes symbolic name.</retdesc></docstring>

Dict containing the axis definition of the output tensors to provide to the model.






</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>generate_dummy_inputs</name><anchor>optimum.exporters.onnx.OnnxConfig.generate_dummy_inputs</anchor><source>https://github.com/huggingface/optimum-onnx/blob/v0.0.2/optimum/exporters/base.py#L223</source><parameters>[{"name": "framework", "val": ": str = 'pt'"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **framework** (`str`, defaults to `"pt"`) --
  The framework for which to create the dummy inputs.
- **batch_size** (`int`, defaults to 2) --
  The batch size to use in the dummy inputs.
- **sequence_length** (`int`, defaults to 16) --
  The sequence length to use in the dummy inputs.
- **num_choices** (`int`, defaults to 4) --
  The number of candidate answers provided for multiple choice task.
- **image_width** (`int`, defaults to 64) --
  The width to use in the dummy inputs for vision tasks.
- **image_height** (`int`, defaults to 64) --
  The height to use in the dummy inputs for vision tasks.
- **num_channels** (`int`, defaults to 3) --
  The number of channels to use in the dummpy inputs for vision tasks.
- **feature_size** (`int`, defaults to 80) --
  The number of features to use in the dummpy inputs for audio tasks in case it is not raw audio.
  This is for example the number of STFT bins or MEL bins.
- **nb_max_frames** (`int`, defaults to 3000) --
  The number of frames to use in the dummpy inputs for audio tasks in case the input is not raw audio.
- **audio_sequence_length** (`int`, defaults to 16000) --
  The number of frames to use in the dummpy inputs for audio tasks in case the input is raw audio.</paramsdesc><paramgroups>0</paramgroups><rettype>`Dict[str, [tf.Tensor, torch.Tensor]]`</rettype><retdesc>A dictionary mapping the input names to dummy tensors in the proper framework format.</retdesc></docstring>

Generates the dummy inputs necessary for tracing the model. If not explicitly specified, default input shapes are used.








</div></div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.exporters.onnx.OnnxConfigWithPast</name><anchor>optimum.exporters.onnx.OnnxConfigWithPast</anchor><source>https://github.com/huggingface/optimum-onnx/blob/v0.0.2/optimum/exporters/onnx/base.py#L426</source><parameters>[{"name": "config", "val": ": PretrainedConfig"}, {"name": "task", "val": ": str = 'feature-extraction'"}, {"name": "int_dtype", "val": ": str = 'int64'"}, {"name": "float_dtype", "val": ": str = 'fp32'"}, {"name": "use_past", "val": ": bool = False"}, {"name": "use_past_in_inputs", "val": ": bool = False"}, {"name": "preprocessors", "val": ": list[Any] | None = None"}]</parameters></docstring>
Inherits from [OnnxConfig](/docs/optimum/v0.0.2/en/onnx/package_reference/configuration#optimum.exporters.onnx.OnnxConfig). A base class to handle the ONNX configuration of decoder-only models.


<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>add_past_key_values</name><anchor>optimum.exporters.onnx.OnnxConfigWithPast.add_past_key_values</anchor><source>https://github.com/huggingface/optimum-onnx/blob/v0.0.2/optimum/exporters/onnx/base.py#L551</source><parameters>[{"name": "inputs_or_outputs", "val": ": dict[str, dict[int, str]]"}, {"name": "direction", "val": ": str"}]</parameters><paramsdesc>- **inputs_or_outputs** (`Dict[str, Dict[int, str]]`) --
  The mapping to fill.
- **direction** (`str`) --
  either "inputs" or "outputs", it specifies whether `input_or_outputs` is the input mapping or the
  output mapping, this is important for axes naming.</paramsdesc><paramgroups>0</paramgroups></docstring>
Fills `input_or_outputs` mapping with past_key_values dynamic axes considering the direction.




</div></div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.exporters.onnx.OnnxSeq2SeqConfigWithPast</name><anchor>optimum.exporters.onnx.OnnxSeq2SeqConfigWithPast</anchor><source>https://github.com/huggingface/optimum-onnx/blob/v0.0.2/optimum/exporters/onnx/base.py#L623</source><parameters>[{"name": "config", "val": ": PretrainedConfig"}, {"name": "task", "val": ": str = 'feature-extraction'"}, {"name": "int_dtype", "val": ": str = 'int64'"}, {"name": "float_dtype", "val": ": str = 'fp32'"}, {"name": "use_past", "val": ": bool = False"}, {"name": "use_past_in_inputs", "val": ": bool = False"}, {"name": "behavior", "val": ": ConfigBehavior = <ConfigBehavior.MONOLITH: 'monolith'>"}, {"name": "preprocessors", "val": ": list[Any] | None = None"}]</parameters></docstring>
Inherits from [OnnxConfigWithPast](/docs/optimum/v0.0.2/en/onnx/package_reference/configuration#optimum.exporters.onnx.OnnxConfigWithPast). A base class to handle the ONNX configuration of encoder-decoder models.


<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>with_behavior</name><anchor>optimum.exporters.onnx.OnnxSeq2SeqConfigWithPast.with_behavior</anchor><source>https://github.com/huggingface/optimum-onnx/blob/v0.0.2/optimum/exporters/onnx/base.py#L655</source><parameters>[{"name": "behavior", "val": ": str | ConfigBehavior"}, {"name": "use_past", "val": ": bool = False"}, {"name": "use_past_in_inputs", "val": ": bool = False"}]</parameters><paramsdesc>- **behavior** (`ConfigBehavior`) --
  The behavior to use for the new instance.
- **use_past** (`bool`, defaults to `False`) --
  Whether or not the ONNX config to instantiate is for a model using KV cache.
- **use_past_in_inputs** (`bool`, defaults to `False`) --
  Whether the KV cache is to be passed as an input to the ONNX.</paramsdesc><paramgroups>0</paramgroups><rettype>`OnnxSeq2SeqConfigWithPast`</rettype></docstring>
Creates a copy of the current OnnxConfig but with a different `ConfigBehavior` and `use_past` value.








</div></div>

## Middle-end classes

### Text[[optimum.exporters.onnx.TextEncoderOnnxConfig]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.exporters.onnx.TextEncoderOnnxConfig</name><anchor>optimum.exporters.onnx.TextEncoderOnnxConfig</anchor><source>https://github.com/huggingface/optimum-onnx/blob/v0.0.2/optimum/exporters/onnx/config.py#L47</source><parameters>[{"name": "config", "val": ": PretrainedConfig"}, {"name": "task", "val": ": str = 'feature-extraction'"}, {"name": "preprocessors", "val": ": list[Any] | None = None"}, {"name": "int_dtype", "val": ": str = 'int64'"}, {"name": "float_dtype", "val": ": str = 'fp32'"}]</parameters></docstring>
Handles encoder-based text architectures.

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.exporters.onnx.TextDecoderOnnxConfig</name><anchor>optimum.exporters.onnx.TextDecoderOnnxConfig</anchor><source>https://github.com/huggingface/optimum-onnx/blob/v0.0.2/optimum/exporters/onnx/config.py#L53</source><parameters>[{"name": "config", "val": ": PretrainedConfig"}, {"name": "task", "val": ": str = 'feature-extraction'"}, {"name": "int_dtype", "val": ": str = 'int64'"}, {"name": "float_dtype", "val": ": str = 'fp32'"}, {"name": "use_past", "val": ": bool = False"}, {"name": "use_past_in_inputs", "val": ": bool = False"}, {"name": "preprocessors", "val": ": list[Any] | None = None"}]</parameters></docstring>
Handles decoder-based text architectures.

</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.exporters.onnx.TextSeq2SeqOnnxConfig</name><anchor>optimum.exporters.onnx.TextSeq2SeqOnnxConfig</anchor><source>https://github.com/huggingface/optimum-onnx/blob/v0.0.2/optimum/exporters/onnx/config.py#L157</source><parameters>[{"name": "config", "val": ": PretrainedConfig"}, {"name": "task", "val": ": str = 'feature-extraction'"}, {"name": "int_dtype", "val": ": str = 'int64'"}, {"name": "float_dtype", "val": ": str = 'fp32'"}, {"name": "use_past", "val": ": bool = False"}, {"name": "use_past_in_inputs", "val": ": bool = False"}, {"name": "behavior", "val": ": ConfigBehavior = <ConfigBehavior.MONOLITH: 'monolith'>"}, {"name": "preprocessors", "val": ": list[Any] | None = None"}]</parameters></docstring>
Handles encoder-decoder-based text architectures.

</div>

### Vision[[optimum.exporters.onnx.config.VisionOnnxConfig]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.exporters.onnx.config.VisionOnnxConfig</name><anchor>optimum.exporters.onnx.config.VisionOnnxConfig</anchor><source>https://github.com/huggingface/optimum-onnx/blob/v0.0.2/optimum/exporters/onnx/config.py#L206</source><parameters>[{"name": "config", "val": ": PretrainedConfig"}, {"name": "task", "val": ": str = 'feature-extraction'"}, {"name": "preprocessors", "val": ": list[Any] | None = None"}, {"name": "int_dtype", "val": ": str = 'int64'"}, {"name": "float_dtype", "val": ": str = 'fp32'"}]</parameters></docstring>
Handles vision architectures.

</div>

### Multi-modal[[optimum.exporters.onnx.config.TextAndVisionOnnxConfig]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.exporters.onnx.config.TextAndVisionOnnxConfig</name><anchor>optimum.exporters.onnx.config.TextAndVisionOnnxConfig</anchor><source>https://github.com/huggingface/optimum-onnx/blob/v0.0.2/optimum/exporters/onnx/config.py#L212</source><parameters>[{"name": "config", "val": ": PretrainedConfig"}, {"name": "task", "val": ": str = 'feature-extraction'"}, {"name": "preprocessors", "val": ": list[Any] | None = None"}, {"name": "int_dtype", "val": ": str = 'int64'"}, {"name": "float_dtype", "val": ": str = 'fp32'"}]</parameters></docstring>
Handles multi-modal text and vision architectures.

</div>