import{s as tt,n as at,o as lt}from"../chunks/scheduler.d627b047.js";import{S as st,i as nt,g as r,s,r as p,A as rt,h as o,f as a,c as n,j as et,u as d,x as i,k as Be,y as ot,a as l,v as f,d as m,t as u,w as c}from"../chunks/index.d48c4817.js";import{C as h}from"../chunks/CodeBlock.5da89496.js";import{H as Fe}from"../chunks/Heading.47e562a9.js";function it(xe){let M,D,S,K,w,O,T,He='PEFT’s practical benefits extends to other Hugging Face libraries like <a href="https://hf.co/docs/diffusers" rel="nofollow">Diffusers</a> and <a href="https://hf.co/docs/transformers" rel="nofollow">Transformers</a>. One of the main benefits of PEFT is that an adapter file generated by a PEFT method is a lot smaller than the original model, which makes it super easy to manage and use multiple adapters. You can use one pretrained base model for multiple tasks by simply loading a new adapter finetuned for the task you’re solving. Or you can combine multiple adapters with a text-to-image diffusion model to create new effects.',ee,g,Le="This tutorial will show you how PEFT can help you manage adapters in Diffusers and Transformers.",te,J,ae,Z,Re="Diffusers is a generative AI library for creating images and videos from text or images with diffusion models. LoRA is an especially popular training method for diffusion models because you can very quickly train and share diffusion models to generate images in new styles. To make it easier to use and try multiple LoRA models, Diffusers uses the PEFT library to help manage different adapters for inference.",le,_,Ee='For example, load a base model and then load the <a href="https://huggingface.co/artificialguybr/3DRedmond-V1" rel="nofollow">artificialguybr/3DRedmond-V1</a> adapter for inference with the <a href="https://huggingface.co/docs/diffusers/v0.24.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights" rel="nofollow"><code>load_lora_weights</code></a> method. The <code>adapter_name</code> argument in the loading method is enabled by PEFT and allows you to set a name for the adapter so it is easier to reference.',se,j,ne,y,Ge='<img src="https://huggingface.co/datasets/ybelkada/documentation-images/resolve/main/test-lora-diffusers.png"/>',re,$,Ie='Now let’s try another cool LoRA model, <a href="https://huggingface.co/ostris/super-cereal-sdxl-lora" rel="nofollow">ostris/super-cereal-sdxl-lora</a>. All you need to do is load and name this new adapter with <code>adapter_name</code>, and use the <a href="https://huggingface.co/docs/diffusers/api/loaders/unet#diffusers.loaders.UNet2DConditionLoadersMixin.set_adapters" rel="nofollow"><code>set_adapters</code></a> method to set it as the currently active adapter.',oe,k,ie,b,Xe='<img src="https://huggingface.co/datasets/ybelkada/documentation-images/resolve/main/test-lora-diffusers-2.png"/>',pe,v,Ye='Finally, you can call the <a href="https://huggingface.co/docs/diffusers/api/loaders/unet#diffusers.loaders.UNet2DConditionLoadersMixin.disable_lora" rel="nofollow"><code>disable_lora</code></a> method to restore the base model.',de,W,fe,U,Ne='Learn more about how PEFT supports Diffusers in the <a href="https://huggingface.co/docs/diffusers/tutorials/using_peft_for_inference" rel="nofollow">Inference with PEFT</a> tutorial.',me,C,ue,B,Ae="Transformers is a collection of pretrained models for all types of tasks in all modalities. You can load these models for training or inference. Many of the models are large language models (LLMs), so it makes sense to integrate PEFT with Transformers to manage and train adapters.",ce,F,Ve="Load a base pretrained model to train.",he,x,Me,H,qe='Next, add an adapter configuration to specify how to adapt the model parameters. Call the <a href="/docs/peft/v0.8.1/en/package_reference/peft_model#peft.PeftModel.add_adapter">add_adapter()</a> method to add the configuration to the base model.',ye,L,be,R,Pe='Now you can train the model with Transformer’s <a href="https://huggingface.co/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> class or whichever training framework you prefer.',we,E,ze='To use the newly trained model for inference, the <a href="https://huggingface.co/docs/transformers/v4.37.2/en/model_doc/auto#transformers.AutoModel" rel="nofollow">AutoModel</a> class uses PEFT on the backend to load the adapter weights and configuration file into a base pretrained model.',Te,G,ge,I,Se='If you’re interested in comparing or using more than one adapter, you can also call the <a href="/docs/peft/v0.8.1/en/package_reference/peft_model#peft.PeftModel.add_adapter">add_adapter()</a> method to add the adapter configuration to the base model. The only requirement is the adapter type must be the same (you can’t mix a LoRA and LoHa adapter).',Je,X,Ze,Y,Qe='Call <a href="/docs/peft/v0.8.1/en/package_reference/peft_model#peft.PeftModel.add_adapter">add_adapter()</a> again to attach a new adapter to the base model.',_e,N,je,A,De='Then you can use <a href="/docs/peft/v0.8.1/en/package_reference/peft_model#peft.PeftModel.set_adapter">set_adapter()</a> to set the currently active adapter.',$e,V,ke,q,Ke='To disable the adapter, call the <a href="/docs/peft/v0.8.1/en/package_reference/peft_model#peft.PeftModel.disable_adapter">disable_adapter()</a> method.',ve,P,We,z,Oe='If you’re curious, check out the <a href="https://huggingface.co/docs/transformers/main/peft" rel="nofollow">Load and train adapters with PEFT</a> tutorial to learn more.',Ue,Q,Ce;return w=new Fe({props:{title:"PEFT integrations",local:"peft-integrations",headingTag:"h1"}}),J=new Fe({props:{title:"Diffusers",local:"diffusers",headingTag:"h2"}}),j=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUubG9hZF9sb3JhX3dlaWdodHMoJTBBJTIwJTIwJTIwJTIwJTIycGVmdC1pbnRlcm5hbC10ZXN0aW5nJTJGYXJ0aWZpY2lhbGd1eWJyX18zRFJlZG1vbmQtVjElMjIlMkMlMjAlMEElMjAlMjAlMjAlMjB3ZWlnaHRfbmFtZSUzRCUyMjNEUmVkbW9uZC0zRFJlbmRlclN0eWxlLTNEUmVuZGVyQUYuc2FmZXRlbnNvcnMlMjIlMkMlMjAlMEElMjAlMjAlMjAlMjBhZGFwdGVyX25hbWUlM0QlMjIzZCUyMiUwQSklMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnN1c2hpJTIwcm9sbHMlMjBzaGFwZWQlMjBsaWtlJTIwa2F3YWlpJTIwY2F0JTIwZmFjZXMlMjIpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_lora_weights(
    <span class="hljs-string">&quot;peft-internal-testing/artificialguybr__3DRedmond-V1&quot;</span>, 
    weight_name=<span class="hljs-string">&quot;3DRedmond-3DRenderStyle-3DRenderAF.safetensors&quot;</span>, 
    adapter_name=<span class="hljs-string">&quot;3d&quot;</span>
)
image = pipeline(<span class="hljs-string">&quot;sushi rolls shaped like kawaii cat faces&quot;</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),k=new h({props:{code:"cGlwZWxpbmUubG9hZF9sb3JhX3dlaWdodHMoJTBBJTIwJTIwJTIwJTIwJTIyb3N0cmlzJTJGc3VwZXItY2VyZWFsLXNkeGwtbG9yYSUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMHdlaWdodF9uYW1lJTNEJTIyY2VyZWFsX2JveF9zZHhsX3YxLnNhZmV0ZW5zb3JzJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwYWRhcHRlcl9uYW1lJTNEJTIyY2VyZWFsJTIyJTBBKSUwQXBpcGVsaW5lLnNldF9hZGFwdGVycyglMjJjZXJlYWwlMjIpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMjJzdXNoaSUyMHJvbGxzJTIwc2hhcGVkJTIwbGlrZSUyMGthd2FpaSUyMGNhdCUyMGZhY2VzJTIyKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`pipeline.load_lora_weights(
    <span class="hljs-string">&quot;ostris/super-cereal-sdxl-lora&quot;</span>, 
    weight_name=<span class="hljs-string">&quot;cereal_box_sdxl_v1.safetensors&quot;</span>, 
    adapter_name=<span class="hljs-string">&quot;cereal&quot;</span>
)
pipeline.set_adapters(<span class="hljs-string">&quot;cereal&quot;</span>)
image = pipeline(<span class="hljs-string">&quot;sushi rolls shaped like kawaii cat faces&quot;</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),W=new h({props:{code:"cGlwZWxpbmUuZGlzYWJsZV9sb3JhKCk=",highlighted:"pipeline.disable_lora()",wrap:!1}}),C=new Fe({props:{title:"Transformers",local:"transformers",headingTag:"h2"}}),x=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)`,wrap:!1}}),L=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjElMkMlMEElMjAlMjAlMjAlMjByJTNENjQlMkMlMEElMjAlMjAlMjAlMjBiaWFzJTNEJTIybm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUwQSklMEFtb2RlbC5hZGRfYWRhcHRlcihwZWZ0X2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.1</span>,
    r=<span class="hljs-number">64</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)
model.add_adapter(peft_config)`,wrap:!1}}),G=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyeWJlbGthZGElMkZvcHQtMzUwbS1sb3JhJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;ybelkada/opt-350m-lora&quot;</span>)`,wrap:!1}}),X=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEFtb2RlbC5hZGRfYWRhcHRlcihsb3JhX2NvbmZpZ18xJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlcl8xJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
model.add_adapter(lora_config_1, adapter_name=<span class="hljs-string">&quot;adapter_1&quot;</span>)`,wrap:!1}}),N=new h({props:{code:"bW9kZWwuYWRkX2FkYXB0ZXIobG9yYV9jb25maWdfMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmFkYXB0ZXJfMiUyMik=",highlighted:'model.add_adapter(lora_config_2, adapter_name=<span class="hljs-string">&quot;adapter_2&quot;</span>)',wrap:!1}}),V=new h({props:{code:"bW9kZWwuc2V0X2FkYXB0ZXIoJTIyYWRhcHRlcl8xJTIyKSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0X2Rpc2FibGVkJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`model.set_adapter(<span class="hljs-string">&quot;adapter_1&quot;</span>)
output = model.generate(**inputs)
<span class="hljs-built_in">print</span>(tokenizer.decode(output_disabled[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),P=new h({props:{code:"bW9kZWwuZGlzYWJsZV9hZGFwdGVyKCk=",highlighted:"model.disable_adapter()",wrap:!1}}),{c(){M=r("meta"),D=s(),S=r("p"),K=s(),p(w.$$.fragment),O=s(),T=r("p"),T.innerHTML=He,ee=s(),g=r("p"),g.textContent=Le,te=s(),p(J.$$.fragment),ae=s(),Z=r("p"),Z.textContent=Re,le=s(),_=r("p"),_.innerHTML=Ee,se=s(),p(j.$$.fragment),ne=s(),y=r("div"),y.innerHTML=Ge,re=s(),$=r("p"),$.innerHTML=Ie,oe=s(),p(k.$$.fragment),ie=s(),b=r("div"),b.innerHTML=Xe,pe=s(),v=r("p"),v.innerHTML=Ye,de=s(),p(W.$$.fragment),fe=s(),U=r("p"),U.innerHTML=Ne,me=s(),p(C.$$.fragment),ue=s(),B=r("p"),B.textContent=Ae,ce=s(),F=r("p"),F.textContent=Ve,he=s(),p(x.$$.fragment),Me=s(),H=r("p"),H.innerHTML=qe,ye=s(),p(L.$$.fragment),be=s(),R=r("p"),R.innerHTML=Pe,we=s(),E=r("p"),E.innerHTML=ze,Te=s(),p(G.$$.fragment),ge=s(),I=r("p"),I.innerHTML=Se,Je=s(),p(X.$$.fragment),Ze=s(),Y=r("p"),Y.innerHTML=Qe,_e=s(),p(N.$$.fragment),je=s(),A=r("p"),A.innerHTML=De,$e=s(),p(V.$$.fragment),ke=s(),q=r("p"),q.innerHTML=Ke,ve=s(),p(P.$$.fragment),We=s(),z=r("p"),z.innerHTML=Oe,Ue=s(),Q=r("p"),this.h()},l(e){const t=rt("svelte-u9bgzb",document.head);M=o(t,"META",{name:!0,content:!0}),t.forEach(a),D=n(e),S=o(e,"P",{}),et(S).forEach(a),K=n(e),d(w.$$.fragment,e),O=n(e),T=o(e,"P",{"data-svelte-h":!0}),i(T)!=="svelte-a6a8i"&&(T.innerHTML=He),ee=n(e),g=o(e,"P",{"data-svelte-h":!0}),i(g)!=="svelte-4mutq9"&&(g.textContent=Le),te=n(e),d(J.$$.fragment,e),ae=n(e),Z=o(e,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-d4l0h1"&&(Z.textContent=Re),le=n(e),_=o(e,"P",{"data-svelte-h":!0}),i(_)!=="svelte-rcmzt6"&&(_.innerHTML=Ee),se=n(e),d(j.$$.fragment,e),ne=n(e),y=o(e,"DIV",{class:!0,"data-svelte-h":!0}),i(y)!=="svelte-1cw2tql"&&(y.innerHTML=Ge),re=n(e),$=o(e,"P",{"data-svelte-h":!0}),i($)!=="svelte-4vggr3"&&($.innerHTML=Ie),oe=n(e),d(k.$$.fragment,e),ie=n(e),b=o(e,"DIV",{class:!0,"data-svelte-h":!0}),i(b)!=="svelte-pvy16"&&(b.innerHTML=Xe),pe=n(e),v=o(e,"P",{"data-svelte-h":!0}),i(v)!=="svelte-dtlzi"&&(v.innerHTML=Ye),de=n(e),d(W.$$.fragment,e),fe=n(e),U=o(e,"P",{"data-svelte-h":!0}),i(U)!=="svelte-1nfye23"&&(U.innerHTML=Ne),me=n(e),d(C.$$.fragment,e),ue=n(e),B=o(e,"P",{"data-svelte-h":!0}),i(B)!=="svelte-11ygjnz"&&(B.textContent=Ae),ce=n(e),F=o(e,"P",{"data-svelte-h":!0}),i(F)!=="svelte-luca6i"&&(F.textContent=Ve),he=n(e),d(x.$$.fragment,e),Me=n(e),H=o(e,"P",{"data-svelte-h":!0}),i(H)!=="svelte-khlt4l"&&(H.innerHTML=qe),ye=n(e),d(L.$$.fragment,e),be=n(e),R=o(e,"P",{"data-svelte-h":!0}),i(R)!=="svelte-u2boun"&&(R.innerHTML=Pe),we=n(e),E=o(e,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1g1gpg8"&&(E.innerHTML=ze),Te=n(e),d(G.$$.fragment,e),ge=n(e),I=o(e,"P",{"data-svelte-h":!0}),i(I)!=="svelte-oonvuy"&&(I.innerHTML=Se),Je=n(e),d(X.$$.fragment,e),Ze=n(e),Y=o(e,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-jk1vbp"&&(Y.innerHTML=Qe),_e=n(e),d(N.$$.fragment,e),je=n(e),A=o(e,"P",{"data-svelte-h":!0}),i(A)!=="svelte-ivcwu7"&&(A.innerHTML=De),$e=n(e),d(V.$$.fragment,e),ke=n(e),q=o(e,"P",{"data-svelte-h":!0}),i(q)!=="svelte-1kpmkbc"&&(q.innerHTML=Ke),ve=n(e),d(P.$$.fragment,e),We=n(e),z=o(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1o6emrm"&&(z.innerHTML=Oe),Ue=n(e),Q=o(e,"P",{}),et(Q).forEach(a),this.h()},h(){Be(M,"name","hf:doc:metadata"),Be(M,"content",pt),Be(y,"class","flex justify-center"),Be(b,"class","flex justify-center")},m(e,t){ot(document.head,M),l(e,D,t),l(e,S,t),l(e,K,t),f(w,e,t),l(e,O,t),l(e,T,t),l(e,ee,t),l(e,g,t),l(e,te,t),f(J,e,t),l(e,ae,t),l(e,Z,t),l(e,le,t),l(e,_,t),l(e,se,t),f(j,e,t),l(e,ne,t),l(e,y,t),l(e,re,t),l(e,$,t),l(e,oe,t),f(k,e,t),l(e,ie,t),l(e,b,t),l(e,pe,t),l(e,v,t),l(e,de,t),f(W,e,t),l(e,fe,t),l(e,U,t),l(e,me,t),f(C,e,t),l(e,ue,t),l(e,B,t),l(e,ce,t),l(e,F,t),l(e,he,t),f(x,e,t),l(e,Me,t),l(e,H,t),l(e,ye,t),f(L,e,t),l(e,be,t),l(e,R,t),l(e,we,t),l(e,E,t),l(e,Te,t),f(G,e,t),l(e,ge,t),l(e,I,t),l(e,Je,t),f(X,e,t),l(e,Ze,t),l(e,Y,t),l(e,_e,t),f(N,e,t),l(e,je,t),l(e,A,t),l(e,$e,t),f(V,e,t),l(e,ke,t),l(e,q,t),l(e,ve,t),f(P,e,t),l(e,We,t),l(e,z,t),l(e,Ue,t),l(e,Q,t),Ce=!0},p:at,i(e){Ce||(m(w.$$.fragment,e),m(J.$$.fragment,e),m(j.$$.fragment,e),m(k.$$.fragment,e),m(W.$$.fragment,e),m(C.$$.fragment,e),m(x.$$.fragment,e),m(L.$$.fragment,e),m(G.$$.fragment,e),m(X.$$.fragment,e),m(N.$$.fragment,e),m(V.$$.fragment,e),m(P.$$.fragment,e),Ce=!0)},o(e){u(w.$$.fragment,e),u(J.$$.fragment,e),u(j.$$.fragment,e),u(k.$$.fragment,e),u(W.$$.fragment,e),u(C.$$.fragment,e),u(x.$$.fragment,e),u(L.$$.fragment,e),u(G.$$.fragment,e),u(X.$$.fragment,e),u(N.$$.fragment,e),u(V.$$.fragment,e),u(P.$$.fragment,e),Ce=!1},d(e){e&&(a(D),a(S),a(K),a(O),a(T),a(ee),a(g),a(te),a(ae),a(Z),a(le),a(_),a(se),a(ne),a(y),a(re),a($),a(oe),a(ie),a(b),a(pe),a(v),a(de),a(fe),a(U),a(me),a(ue),a(B),a(ce),a(F),a(he),a(Me),a(H),a(ye),a(be),a(R),a(we),a(E),a(Te),a(ge),a(I),a(Je),a(Ze),a(Y),a(_e),a(je),a(A),a($e),a(ke),a(q),a(ve),a(We),a(z),a(Ue),a(Q)),a(M),c(w,e),c(J,e),c(j,e),c(k,e),c(W,e),c(C,e),c(x,e),c(L,e),c(G,e),c(X,e),c(N,e),c(V,e),c(P,e)}}}const pt='{"title":"PEFT integrations","local":"peft-integrations","sections":[{"title":"Diffusers","local":"diffusers","sections":[],"depth":2},{"title":"Transformers","local":"transformers","sections":[],"depth":2}],"depth":1}';function dt(xe){return lt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ht extends st{constructor(M){super(),nt(this,M,dt,it,tt,{})}}export{ht as component};
