import{s as Mt,o as wt,n as yt}from"../chunks/scheduler.d627b047.js";import{S as bt,i as Tt,g as h,s,r as i,A as gt,h as u,f as a,c as n,j as ht,u as r,x as c,k as ut,y as Jt,a as l,v as p,d,t as m,w as f}from"../chunks/index.d48c4817.js";import{T as ct}from"../chunks/Tip.9bd3babf.js";import{C as M}from"../chunks/CodeBlock.5da89496.js";import{H as ne}from"../chunks/Heading.47e562a9.js";function Zt(oe){let o,w='Learn more about how PEFT works with quantization in the <a href="quantization">Quantization</a> guide.';return{c(){o=h("p"),o.innerHTML=w},l(y){o=u(y,"P",{"data-svelte-h":!0}),c(o)!=="svelte-1nbpolx"&&(o.innerHTML=w)},m(y,b){l(y,o,b)},p:yt,d(y){y&&a(o)}}}function $t(oe){let o,w='There are several supported methods for <code>combination_type</code>. Refer to the <a href="../package_reference/lora#peft.LoraModel.add_weighted_adapter">documentation</a> for more details. Note that “svd” as the <code>combination_type</code> is not supported when using <code>torch.float16</code> or <code>torch.bfloat16</code> as the datatype.';return{c(){o=h("p"),o.innerHTML=w},l(y){o=u(y,"P",{"data-svelte-h":!0}),c(o)!=="svelte-19y7vpj"&&(o.innerHTML=w)},m(y,b){l(y,o,b)},p:yt,d(y){y&&a(o)}}}function _t(oe){let o,w,y,b,J,re,Z,Ae='LoRA is low-rank decomposition method to reduce the number of trainable parameters which speeds up finetuning large models and uses less memory. In PEFT, using LoRA is as easy as setting up a <a href="/docs/peft/v0.8.1/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> and wrapping it with <a href="/docs/peft/v0.8.1/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> to create a trainable <a href="/docs/peft/v0.8.1/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',pe,$,Se="This guide explores in more detail other options and features for using LoRA.",de,_,me,U,Pe='The initialization of LoRA weights is controlled by the parameter <code>init_lora_weights</code> in <a href="/docs/peft/v0.8.1/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. By default, PEFT initializes LoRA weights with Kaiming-uniform for weight A and zeros for weight B resulting in an identity transform (same as the reference <a href="https://github.com/microsoft/LoRA" rel="nofollow">implementation</a>).',fe,k,Ke='It is also possible to pass <code>init_lora_weights=&quot;gaussian&quot;</code>. As the name suggests, this initializes weight A with a Gaussian distribution and zeros for weight B (this is how <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">Diffusers</a> initializes LoRA weights).',he,v,ue,j,De="There is also an option to set <code>init_lora_weights=False</code> which is useful for debugging and testing. This should be the only time you use this option. When choosing this option, the LoRA weights are initialized such that they do <em>not</em> result in an identity transform.",ce,W,ye,B,Me,R,Oe='When quantizing the base model for QLoRA training, consider using the <a href="https://arxiv.org/abs/2310.08659" rel="nofollow">LoftQ initialization</a>, which has been shown to improve performance when training quantized models. The idea is that the LoRA weights are initialized such that the quantization error is minimized. If you’re using LoftQ, <em>do not</em> quantize the base model. You should set up a <code>LoftQConfig</code> instead:',we,C,be,T,Te,G,ge,L,et='Another way to initialize <a href="/docs/peft/v0.8.1/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> is with the <a href="https://huggingface.co/papers/2312.03732" rel="nofollow">rank-stabilized LoRA (rsLoRA)</a> method. The LoRA architecture scales each adapter during every forward pass by a fixed scalar which is set at initialization and depends on the rank <code>r</code>. The scalar is given by <code>lora_alpha/r</code> in the original implementation, but rsLoRA uses <code>lora_alpha/math.sqrt(r)</code> which stabilizes the adapters and increases the performance potential from using a higher <code>r</code>.',Je,I,Ze,V,$e,Q,tt='While LoRA is significantly smaller and faster to train, you may encounter latency issues during inference due to separately loading the base model and the LoRA adapter. To eliminate latency, use the <a href="/docs/peft/v0.8.1/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function to merge the adapter weights with the base model. This allows you to use the newly merged model as a standalone model. The <a href="/docs/peft/v0.8.1/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function doesn’t keep the adapter weights in memory.',_e,F,Ue,X,at='If you need to keep a copy of the weights so you can unmerge the adapter later or delete and load different ones, you should use the <a href="/docs/peft/v0.8.1/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_adapter">merge_adapter()</a> function instead. Now you have the option to use <a href="/docs/peft/v0.8.1/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.unmerge_adapter">unmerge_adapter()</a> to return the base model.',ke,z,ve,H,lt='The <a href="/docs/peft/v0.8.1/en/package_reference/lora#peft.LoraModel.add_weighted_adapter">add_weighted_adapter()</a> function is useful for merging multiple LoRAs into a new adapter based on a user provided weighting scheme in the <code>weights</code> parameter. Below is an end-to-end example.',je,Y,st="First load the base model:",We,E,Be,q,nt="Then we load the first adapter:",Re,N,Ce,x,ot="Then load a different adapter and merge it with the first one:",Ge,A,Le,g,Ie,S,it="Now, perform inference:",Ve,P,Qe,K,Fe,D,rt='Adapters can be loaded onto a pretrained model with <a href="/docs/peft/v0.8.1/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>, which is useful for trying out different adapters whose weights aren’t merged. Set the active adapter weights with the <a href="/docs/peft/v0.8.1/en/package_reference/lora#peft.LoraModel.set_adapter">set_adapter()</a> function.',Xe,O,ze,ee,pt='To return the base model, you could use <a href="/docs/peft/v0.8.1/en/package_reference/lora#peft.LoraModel.unload">unload()</a> to unload all of the LoRA modules or <a href="/docs/peft/v0.8.1/en/package_reference/lora#peft.LoraModel.delete_adapter">delete_adapter()</a> to delete the adapter entirely.',He,te,Ye,ae,Ee,le,dt='The default LoRA settings in 🤗PEFT follow the <a href="https://hf.co/papers/2106.09685" rel="nofollow">original paper</a> and add trainable weights to the query and value layers of each attention block. However, in <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a>, it was found that adding trainable weights to all the linear layers of a transformer model is beneficial to match full-finetuning performance. Since the list of modules to add will vary depending on the architecture, we provided a convenient shorthand : simple specify <code>target_modules=&#39;all-linear&#39;</code> and let 🤗PEFT handle the rest:',qe,se,Ne,ie,xe;return J=new ne({props:{title:"LoRA",local:"lora",headingTag:"h1"}}),_=new ne({props:{title:"Initialization",local:"initialization",headingTag:"h2"}}),v=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMmdhdXNzaWFuJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;gaussian&quot;</span>, ...)`,wrap:!1}}),W=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzREZhbHNlJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-literal">False</span>, ...)`,wrap:!1}}),B=new ne({props:{title:"LoftQ",local:"loftq",headingTag:"h3"}}),C=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb2Z0UUNvbmZpZyUyQyUyMExvcmFDb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoLi4uKSUyMCUyMCUyMyUyMGRvbid0JTIwcXVhbnRpemUlMjBoZXJlJTBBbG9mdHFfY29uZmlnJTIwJTNEJTIwTG9mdFFDb25maWcobG9mdHFfYml0cyUzRDQlMkMlMjAuLi4pJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwc2V0JTIwNGJpdCUyMHF1YW50aXphdGlvbiUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyguLi4lMkMlMjBpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMmxvZnRxJTIyJTJDJTIwbG9mdHFfY29uZmlnJTNEbG9mdHFfY29uZmlnKSUwQXBlZnRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChiYXNlX21vZGVsJTJDJTIwbG9yYV9jb25maWcp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoftQConfig, LoraConfig, get_peft_model

base_model = AutoModelForCausalLM.from_pretrained(...)  <span class="hljs-comment"># don&#x27;t quantize here</span>
loftq_config = LoftQConfig(loftq_bits=<span class="hljs-number">4</span>, ...)           <span class="hljs-comment"># set 4bit quantization</span>
lora_config = LoraConfig(..., init_lora_weights=<span class="hljs-string">&quot;loftq&quot;</span>, loftq_config=loftq_config)
peft_model = get_peft_model(base_model, lora_config)`,wrap:!1}}),T=new ct({props:{$$slots:{default:[Zt]},$$scope:{ctx:oe}}}),G=new ne({props:{title:"Rank-stabilized LoRA",local:"rank-stabilized-lora",headingTag:"h3"}}),I=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfcnNsb3JhJTNEVHJ1ZSUyQyUyMC4uLik=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_rslora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),V=new ne({props:{title:"Merge adapters",local:"merge-adapters",headingTag:"h2"}}),F=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FuZF91bmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_and_unload()`,wrap:!1}}),z=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FkYXB0ZXIoKSUwQSUwQSUyMyUyMHVubWVyZ2UlMjB0aGUlMjBMb1JBJTIwbGF5ZXJzJTIwZnJvbSUyMHRoZSUyMGJhc2UlMjBtb2RlbCUwQW1vZGVsLnVubWVyZ2VfYWRhcHRlcigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_adapter()

<span class="hljs-comment"># unmerge the LoRA layers from the base model</span>
model.unmerge_adapter()`,wrap:!1}}),E=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-keyword">import</span> torch

base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),N=new M({props:{code:"cGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1zZnQtbG9yYSUyMiUwQW1vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnNmdCUyMik=",highlighted:`peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id, adapter_name=<span class="hljs-string">&quot;sft&quot;</span>)`,wrap:!1}}),A=new M({props:{code:"bW9kZWwubG9hZF9hZGFwdGVyKCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1kcG8tbG9yYSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmRwbyUyMiklMEFtb2RlbC5hZGRfd2VpZ2h0ZWRfYWRhcHRlciglMEElMjAlMjAlMjAlMjBhZGFwdGVycyUzRCU1QiUyMnNmdCUyMiUyQyUyMCUyMmRwbyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHdlaWdodHMlM0QlNUIwLjclMkMlMjAwLjMlNUQlMkMlMEElMjAlMjAlMjAlMjBhZGFwdGVyX25hbWUlM0QlMjJzZnQtZHBvJTIyJTJDJTBBJTIwJTIwJTIwJTIwY29tYmluYXRpb25fdHlwZSUzRCUyMmxpbmVhciUyMiUwQSk=",highlighted:`model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)
model.add_weighted_adapter(
    adapters=[<span class="hljs-string">&quot;sft&quot;</span>, <span class="hljs-string">&quot;dpo&quot;</span>],
    weights=[<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>],
    adapter_name=<span class="hljs-string">&quot;sft-dpo&quot;</span>,
    combination_type=<span class="hljs-string">&quot;linear&quot;</span>
)`,wrap:!1}}),g=new ct({props:{$$slots:{default:[$t]},$$scope:{ctx:oe}}}),P=new M({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8oJTIyY3VkYSUyMiklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBb3V0cHV0cyUyMCUzRCUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RCUwQXByaW50KG91dHB1dHMp",highlighted:`tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)

prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}

<span class="hljs-keyword">with</span> torch.no_grad():
    generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">30</span>)
outputs = tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(outputs)`,wrap:!1}}),K=new ne({props:{title:"Load adapters",local:"load-adapters",headingTag:"h2"}}),O=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQSUwQSUyMyUyMGxvYWQlMjBkaWZmZXJlbnQlMjBhZGFwdGVyJTBBbW9kZWwubG9hZF9hZGFwdGVyKCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1kcG8tbG9yYSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmRwbyUyMiklMEElMEElMjMlMjBzZXQlMjBhZGFwdGVyJTIwYXMlMjBhY3RpdmUlMEFtb2RlbC5zZXRfYWRhcHRlciglMjJkcG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)

<span class="hljs-comment"># load different adapter</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)

<span class="hljs-comment"># set adapter as active</span>
model.set_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),te=new M({props:{code:"JTIzJTIwdW5sb2FkJTIwYWRhcHRlciUwQW1vZGVsLnVubG9hZCgpJTBBJTBBJTIzJTIwZGVsZXRlJTIwYWRhcHRlciUwQW1vZGVsLmRlbGV0ZV9hZGFwdGVyKCUyMmRwbyUyMik=",highlighted:`<span class="hljs-comment"># unload adapter</span>
model.unload()

<span class="hljs-comment"># delete adapter</span>
model.delete_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),ae=new ne({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h2"}}),se=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4pJTIwJTIzJTIwYWRkcyUyMExvUkElMjB0byUyMGFsbCUyMGxpbmVhciUyMGxheWVycyUyMGxpa2UlMjBpbiUyMFFMb1JB",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...) <span class="hljs-comment"># adds LoRA to all linear layers like in QLoRA</span>',wrap:!1}}),{c(){o=h("meta"),w=s(),y=h("p"),b=s(),i(J.$$.fragment),re=s(),Z=h("p"),Z.innerHTML=Ae,pe=s(),$=h("p"),$.textContent=Se,de=s(),i(_.$$.fragment),me=s(),U=h("p"),U.innerHTML=Pe,fe=s(),k=h("p"),k.innerHTML=Ke,he=s(),i(v.$$.fragment),ue=s(),j=h("p"),j.innerHTML=De,ce=s(),i(W.$$.fragment),ye=s(),i(B.$$.fragment),Me=s(),R=h("p"),R.innerHTML=Oe,we=s(),i(C.$$.fragment),be=s(),i(T.$$.fragment),Te=s(),i(G.$$.fragment),ge=s(),L=h("p"),L.innerHTML=et,Je=s(),i(I.$$.fragment),Ze=s(),i(V.$$.fragment),$e=s(),Q=h("p"),Q.innerHTML=tt,_e=s(),i(F.$$.fragment),Ue=s(),X=h("p"),X.innerHTML=at,ke=s(),i(z.$$.fragment),ve=s(),H=h("p"),H.innerHTML=lt,je=s(),Y=h("p"),Y.textContent=st,We=s(),i(E.$$.fragment),Be=s(),q=h("p"),q.textContent=nt,Re=s(),i(N.$$.fragment),Ce=s(),x=h("p"),x.textContent=ot,Ge=s(),i(A.$$.fragment),Le=s(),i(g.$$.fragment),Ie=s(),S=h("p"),S.textContent=it,Ve=s(),i(P.$$.fragment),Qe=s(),i(K.$$.fragment),Fe=s(),D=h("p"),D.innerHTML=rt,Xe=s(),i(O.$$.fragment),ze=s(),ee=h("p"),ee.innerHTML=pt,He=s(),i(te.$$.fragment),Ye=s(),i(ae.$$.fragment),Ee=s(),le=h("p"),le.innerHTML=dt,qe=s(),i(se.$$.fragment),Ne=s(),ie=h("p"),this.h()},l(e){const t=gt("svelte-u9bgzb",document.head);o=u(t,"META",{name:!0,content:!0}),t.forEach(a),w=n(e),y=u(e,"P",{}),ht(y).forEach(a),b=n(e),r(J.$$.fragment,e),re=n(e),Z=u(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-1i907r6"&&(Z.innerHTML=Ae),pe=n(e),$=u(e,"P",{"data-svelte-h":!0}),c($)!=="svelte-ovsn32"&&($.textContent=Se),de=n(e),r(_.$$.fragment,e),me=n(e),U=u(e,"P",{"data-svelte-h":!0}),c(U)!=="svelte-1dmggpv"&&(U.innerHTML=Pe),fe=n(e),k=u(e,"P",{"data-svelte-h":!0}),c(k)!=="svelte-1fujb7a"&&(k.innerHTML=Ke),he=n(e),r(v.$$.fragment,e),ue=n(e),j=u(e,"P",{"data-svelte-h":!0}),c(j)!=="svelte-mwvui1"&&(j.innerHTML=De),ce=n(e),r(W.$$.fragment,e),ye=n(e),r(B.$$.fragment,e),Me=n(e),R=u(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1khsfzg"&&(R.innerHTML=Oe),we=n(e),r(C.$$.fragment,e),be=n(e),r(T.$$.fragment,e),Te=n(e),r(G.$$.fragment,e),ge=n(e),L=u(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-1shd22b"&&(L.innerHTML=et),Je=n(e),r(I.$$.fragment,e),Ze=n(e),r(V.$$.fragment,e),$e=n(e),Q=u(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-1qn46r6"&&(Q.innerHTML=tt),_e=n(e),r(F.$$.fragment,e),Ue=n(e),X=u(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-ucl81b"&&(X.innerHTML=at),ke=n(e),r(z.$$.fragment,e),ve=n(e),H=u(e,"P",{"data-svelte-h":!0}),c(H)!=="svelte-1oy68n1"&&(H.innerHTML=lt),je=n(e),Y=u(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-1mwdwt1"&&(Y.textContent=st),We=n(e),r(E.$$.fragment,e),Be=n(e),q=u(e,"P",{"data-svelte-h":!0}),c(q)!=="svelte-nuhu05"&&(q.textContent=nt),Re=n(e),r(N.$$.fragment,e),Ce=n(e),x=u(e,"P",{"data-svelte-h":!0}),c(x)!=="svelte-1n53hd9"&&(x.textContent=ot),Ge=n(e),r(A.$$.fragment,e),Le=n(e),r(g.$$.fragment,e),Ie=n(e),S=u(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-qwbdkg"&&(S.textContent=it),Ve=n(e),r(P.$$.fragment,e),Qe=n(e),r(K.$$.fragment,e),Fe=n(e),D=u(e,"P",{"data-svelte-h":!0}),c(D)!=="svelte-rppsxi"&&(D.innerHTML=rt),Xe=n(e),r(O.$$.fragment,e),ze=n(e),ee=u(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-pz21ga"&&(ee.innerHTML=pt),He=n(e),r(te.$$.fragment,e),Ye=n(e),r(ae.$$.fragment,e),Ee=n(e),le=u(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-i4ss13"&&(le.innerHTML=dt),qe=n(e),r(se.$$.fragment,e),Ne=n(e),ie=u(e,"P",{}),ht(ie).forEach(a),this.h()},h(){ut(o,"name","hf:doc:metadata"),ut(o,"content",Ut)},m(e,t){Jt(document.head,o),l(e,w,t),l(e,y,t),l(e,b,t),p(J,e,t),l(e,re,t),l(e,Z,t),l(e,pe,t),l(e,$,t),l(e,de,t),p(_,e,t),l(e,me,t),l(e,U,t),l(e,fe,t),l(e,k,t),l(e,he,t),p(v,e,t),l(e,ue,t),l(e,j,t),l(e,ce,t),p(W,e,t),l(e,ye,t),p(B,e,t),l(e,Me,t),l(e,R,t),l(e,we,t),p(C,e,t),l(e,be,t),p(T,e,t),l(e,Te,t),p(G,e,t),l(e,ge,t),l(e,L,t),l(e,Je,t),p(I,e,t),l(e,Ze,t),p(V,e,t),l(e,$e,t),l(e,Q,t),l(e,_e,t),p(F,e,t),l(e,Ue,t),l(e,X,t),l(e,ke,t),p(z,e,t),l(e,ve,t),l(e,H,t),l(e,je,t),l(e,Y,t),l(e,We,t),p(E,e,t),l(e,Be,t),l(e,q,t),l(e,Re,t),p(N,e,t),l(e,Ce,t),l(e,x,t),l(e,Ge,t),p(A,e,t),l(e,Le,t),p(g,e,t),l(e,Ie,t),l(e,S,t),l(e,Ve,t),p(P,e,t),l(e,Qe,t),p(K,e,t),l(e,Fe,t),l(e,D,t),l(e,Xe,t),p(O,e,t),l(e,ze,t),l(e,ee,t),l(e,He,t),p(te,e,t),l(e,Ye,t),p(ae,e,t),l(e,Ee,t),l(e,le,t),l(e,qe,t),p(se,e,t),l(e,Ne,t),l(e,ie,t),xe=!0},p(e,[t]){const mt={};t&2&&(mt.$$scope={dirty:t,ctx:e}),T.$set(mt);const ft={};t&2&&(ft.$$scope={dirty:t,ctx:e}),g.$set(ft)},i(e){xe||(d(J.$$.fragment,e),d(_.$$.fragment,e),d(v.$$.fragment,e),d(W.$$.fragment,e),d(B.$$.fragment,e),d(C.$$.fragment,e),d(T.$$.fragment,e),d(G.$$.fragment,e),d(I.$$.fragment,e),d(V.$$.fragment,e),d(F.$$.fragment,e),d(z.$$.fragment,e),d(E.$$.fragment,e),d(N.$$.fragment,e),d(A.$$.fragment,e),d(g.$$.fragment,e),d(P.$$.fragment,e),d(K.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(ae.$$.fragment,e),d(se.$$.fragment,e),xe=!0)},o(e){m(J.$$.fragment,e),m(_.$$.fragment,e),m(v.$$.fragment,e),m(W.$$.fragment,e),m(B.$$.fragment,e),m(C.$$.fragment,e),m(T.$$.fragment,e),m(G.$$.fragment,e),m(I.$$.fragment,e),m(V.$$.fragment,e),m(F.$$.fragment,e),m(z.$$.fragment,e),m(E.$$.fragment,e),m(N.$$.fragment,e),m(A.$$.fragment,e),m(g.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(ae.$$.fragment,e),m(se.$$.fragment,e),xe=!1},d(e){e&&(a(w),a(y),a(b),a(re),a(Z),a(pe),a($),a(de),a(me),a(U),a(fe),a(k),a(he),a(ue),a(j),a(ce),a(ye),a(Me),a(R),a(we),a(be),a(Te),a(ge),a(L),a(Je),a(Ze),a($e),a(Q),a(_e),a(Ue),a(X),a(ke),a(ve),a(H),a(je),a(Y),a(We),a(Be),a(q),a(Re),a(Ce),a(x),a(Ge),a(Le),a(Ie),a(S),a(Ve),a(Qe),a(Fe),a(D),a(Xe),a(ze),a(ee),a(He),a(Ye),a(Ee),a(le),a(qe),a(Ne),a(ie)),a(o),f(J,e),f(_,e),f(v,e),f(W,e),f(B,e),f(C,e),f(T,e),f(G,e),f(I,e),f(V,e),f(F,e),f(z,e),f(E,e),f(N,e),f(A,e),f(g,e),f(P,e),f(K,e),f(O,e),f(te,e),f(ae,e),f(se,e)}}}const Ut='{"title":"LoRA","local":"lora","sections":[{"title":"Initialization","local":"initialization","sections":[{"title":"LoftQ","local":"loftq","sections":[],"depth":3},{"title":"Rank-stabilized LoRA","local":"rank-stabilized-lora","sections":[],"depth":3}],"depth":2},{"title":"Merge adapters","local":"merge-adapters","sections":[],"depth":2},{"title":"Load adapters","local":"load-adapters","sections":[],"depth":2},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":2}],"depth":1}';function kt(oe){return wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ct extends bt{constructor(o){super(),Tt(this,o,kt,_t,Mt,{})}}export{Ct as component};
