import{s as ps,n as rs,o as cs}from"../chunks/scheduler.65852ee5.js";import{S as hs,i as ms,g as i,s as a,r,A as Ms,h as o,f as s,c as n,j as is,u as c,x as p,k as os,y as ys,a as l,v as h,d as m,t as M,w as y}from"../chunks/index.aa74147d.js";import{D as us,C as j}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as u,E as js}from"../chunks/EditOnGithub.4eda6a96.js";function Ts(vt){let T,Ue,we,fe,J,Ie,d,Ce,w,qt='<em>Authored by: <a href="https://github.com/leemthompo" rel="nofollow">Liam Thompson</a></em>',be,g,At='<a href="https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/elasticsearch-semantic-reranking.ipynb" rel="nofollow"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a>',ve,U,$t="In this notebook we will learn how to implement semantic reranking in Elasticsearch by uploading a model from Hugging Face into an Elasticsearch cluster. We’ll use the <code>retriever</code> abstraction, a simpler Elasticsearch syntax for crafting queries and combining different search operations.",qe,f,kt="You will:",Ae,I,xt='<li>Choose a cross-encoder model from Hugging Face to perform semantic reranking</li> <li>Upload the model to your Elasticsearch deployment using <a href="https://www.elastic.co/guide/en/elasticsearch/client/eland/current/machine-learning.html" rel="nofollow">Eland</a>— a Python client for machine learning with Elasticsearch</li> <li>Create an inference endpoint to manage your <code>rerank</code> task</li> <li>Query your data using the <code>text_similarity_rerank</code> retriever</li>',$e,C,ke,b,Et="For this example, you will need:",xe,v,Bt='<li>An Elastic deployment on version 8.15.0 or above (for non-serverless deployments)<ul><li>We’ll be using Elastic Cloud for this example (available with a <a href="https://cloud.elastic.co/registration" rel="nofollow">free trial</a>).</li> <li>See our other <a href="https://www.elastic.co/guide/en/elasticsearch/reference/current/elasticsearch-intro.html#elasticsearch-intro-deploy" rel="nofollow">deployment options</a></li></ul></li> <li>You’ll need to find your deployment’s Cloud ID and create an API key. <a href="https://www.elastic.co/search-labs/tutorials/install-elasticsearch/elastic-cloud#finding-your-cloud-id" rel="nofollow">Learn more</a>.</li>',Ee,q,Be,A,Gt="ℹ️ The <code>eland</code> installation will take a couple of minutes.",Ge,$,Ne,k,Ze,x,Nt="First you need to connect to your Elasticsearch instance.",Qe,E,_e,B,Zt=`Elastic Cloud ID: ··········
Elastic Api Key: ··········
`,Se,G,We,N,Qt="Confirm that the Python client has connected to your Elasticsearch instance with this test.",Re,Z,Xe,Q,_t="This examples uses a small dataset of movies.",Ve,_,Le,S,St="Done indexing documents into `movies` index!\n",ze,W,Fe,R,Wt="Now we’ll use Eland’s <code>eland_import_hub_model</code> command to upload the model to Elasticsearch. For this example we’ve chosen the <code>cross-encoder/ms-marco-MiniLM-L-6-v2</code> text similarity model.",He,X,Pe,V,Rt=`2024-08-13 17:04:12,386 INFO : Establishing connection to Elasticsearch
2024-08-13 17:04:12,567 INFO : Connected to serverless cluster 'bd8c004c050e4654ad32fb86ab159889'
2024-08-13 17:04:12,568 INFO : Loading HuggingFace transformer tokenizer and model 'cross-encoder/ms-marco-MiniLM-L-6-v2'
/usr/local/lib/python3.10/dist-packages/huggingface_hub/file_download.py:1132: FutureWarning: \`resume_download\` is deprecated and will be removed in version 1.0.0. Downloads always resume when possible. If you want to force a new download, use \`force_download=True\`.
  warnings.warn(
tokenizer_config.json: 100% 316/316 [00:00<00:00, 1.81MB/s]
config.json: 100% 794/794 [00:00<00:00, 4.09MB/s]
vocab.txt: 100% 232k/232k [00:00<00:00, 2.37MB/s]
special_tokens_map.json: 100% 112/112 [00:00<00:00, 549kB/s]
pytorch_model.bin: 100% 90.9M/90.9M [00:00<00:00, 135MB/s]
STAGE:2024-08-13 17:04:15 1454:1454 ActivityProfilerController.cpp:312] Completed Stage: Warm Up
STAGE:2024-08-13 17:04:15 1454:1454 ActivityProfilerController.cpp:318] Completed Stage: Collection
STAGE:2024-08-13 17:04:15 1454:1454 ActivityProfilerController.cpp:322] Completed Stage: Post Processing
2024-08-13 17:04:18,789 INFO : Creating model with id 'cross-encoder__ms-marco-minilm-l-6-v2'
2024-08-13 17:04:21,123 INFO : Uploading model definition
100% 87/87 [00:55<00:00,  1.57 parts/s]
2024-08-13 17:05:16,416 INFO : Uploading model vocabulary
2024-08-13 17:05:16,987 INFO : Starting model deployment
2024-08-13 17:05:18,238 INFO : Model successfully imported with id 'cross-encoder__ms-marco-minilm-l-6-v2'
`,Ye,L,De,z,Xt="Next we’ll create an inference endpoint for the <code>rerank</code> task to deploy and manage our model and, if necessary, spin up the necessary ML resources behind the scenes.",Ke,F,Oe,H,Vt="Run the following command to confirm your inference endpoint is deployed.",et,P,tt,Y,Lt=`⚠️ When you deploy your model, you might need to sync your ML saved objects in the Kibana (or Serverless) UI.
Go to <strong>Trained Models</strong> and select <strong>Synchronize saved objects</strong>.`,st,D,lt,K,zt="First let’s use a <code>standard</code> retriever to test out some lexical (or full-text) searches and then we’ll compare the improvements when we layer in semantic reranking.",at,O,nt,ee,Ft="Let’s say we vaguely remember that there is a famous movie about a killer who eats his victims. For the sake of argument, pretend we’ve momentarily forgotten the word “cannibal”.",it,te,Ht='Let’s perform a <a href="https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl-query-string-query.html" rel="nofollow"><code>query_string</code> query</a> to find the phrase “flesh-eating bad guy” in the <code>plot</code> fields of our Elasticsearch documents.',ot,se,pt,le,Pt=`No search results found
`,rt,ae,Yt="No results! Unfortunately we don’t have any near exact matches for “flesh-eating bad guy”. Because we don’t have any more specific information about the exact phrasing in the Elasticsearch data, we’ll need to cast our search net wider.",ct,ne,ht,ie,Dt="This lexical query performs a standard keyword search for the term “crime” within the “plot” and “genre” fields of our Elasticsearch documents.",mt,oe,Mt,pe,Kt=`Title: The Godfather
Plot: An organized crime dynasty's aging patriarch transfers control of his clandestine empire to his reluctant son.

Title: Goodfellas
Plot: The story of Henry Hill and his life in the mob, covering his relationship with his wife Karen Hill and his mob partners Jimmy Conway and Tommy DeVito in the Italian-American crime syndicate.

Title: The Silence of the Lambs
Plot: A young F.B.I. cadet must receive the help of an incarcerated and manipulative cannibal killer to help catch another serial killer, a madman who skins his victims.

Title: Pulp Fiction
Plot: The lives of two mob hitmen, a boxer, a gangster and his wife, and a pair of diner bandits intertwine in four tales of violence and redemption.

Title: Se7en
Plot: Two detectives, a rookie and a veteran, hunt a serial killer who uses the seven deadly sins as his motives.

Title: The Departed
Plot: An undercover cop and a mole in the police attempt to identify each other while infiltrating an Irish gang in South Boston.

Title: The Usual Suspects
Plot: A sole survivor tells of the twisty events leading up to a horrific gun battle on a boat, which began when five criminals met at a seemingly random police lineup.

Title: The Dark Knight
Plot: When the menace known as the Joker wreaks havoc and chaos on the people of Gotham, Batman must accept one of the greatest psychological and physical tests of his ability to fight injustice.
`,yt,re,Ot="That’s better! At least we’ve got some results now. We broadened our search criteria to increase the chances of finding relevant results.",ut,ce,es="But these results aren’t very precise in the context of our original query “flesh-eating bad guy”. We can see that “The Silence of the Lambs” is returned in the middle of the results set with this generic <code>match</code> query. Let’s see if we can use our semantic reranking model to get closer to the searcher’s original intent.",jt,he,Tt,me,ts="In the following <code>retriever</code> syntax, we wrap our standard query retriever in a <code>text_similarity_reranker</code>. This allows us to leverage the NLP model we deployed to Elasticsearch to rerank the results based on the phrase “flesh-eating bad guy”.",Jt,Me,dt,ye,ss=`Title: The Silence of the Lambs
Plot: A young F.B.I. cadet must receive the help of an incarcerated and manipulative cannibal killer to help catch another serial killer, a madman who skins his victims.

Title: Pulp Fiction
Plot: The lives of two mob hitmen, a boxer, a gangster and his wife, and a pair of diner bandits intertwine in four tales of violence and redemption.

Title: Se7en
Plot: Two detectives, a rookie and a veteran, hunt a serial killer who uses the seven deadly sins as his motives.

Title: Goodfellas
Plot: The story of Henry Hill and his life in the mob, covering his relationship with his wife Karen Hill and his mob partners Jimmy Conway and Tommy DeVito in the Italian-American crime syndicate.

Title: The Dark Knight
Plot: When the menace known as the Joker wreaks havoc and chaos on the people of Gotham, Batman must accept one of the greatest psychological and physical tests of his ability to fight injustice.

Title: The Godfather
Plot: An organized crime dynasty's aging patriarch transfers control of his clandestine empire to his reluctant son.

Title: The Departed
Plot: An undercover cop and a mole in the police attempt to identify each other while infiltrating an Irish gang in South Boston.

Title: The Usual Suspects
Plot: A sole survivor tells of the twisty events leading up to a horrific gun battle on a boat, which began when five criminals met at a seemingly random police lineup.
`,wt,ue,ls="Success! “The Silence of the Lambs” is our top result. Semantic reranking helped us find the most relevant result by parsing a natural language query, overcoming the limitations of lexical search which relies more on exact matching.",gt,je,as="Semantic reranking enables semantic search in a few steps, without the need for generating and storing embeddings. Being able to use open source models hosted on Hugging Face natively in your Elasticsearch cluster is great for prototyping, testing, and building search experiences.",Ut,Te,ft,Je,ns='<li>For this example we’ve chosen the <a href="https://huggingface.co/cross-encoder/ms-marco-MiniLM-L-6-v2" rel="nofollow"><code>cross-encoder/ms-marco-MiniLM-L-6-v2</code></a> text similarity model. Refer to <a href="https://www.elastic.co/guide/en/machine-learning/8.15/ml-nlp-model-ref.html#ml-nlp-model-ref-text-similarity" rel="nofollow">the Elastic NLP model reference</a> for a list of third-party text similarity models supported by Elasticsearch.</li> <li>Learn more about <a href="https://www.elastic.co/search-labs/integrations/hugging-face" rel="nofollow">integrating Hugging Face</a> with Elasticsearch.</li> <li>Check out Elastic’s catalogue of Python notebooks in the <a href="https://github.com/elastic/elasticsearch-labs/tree/main/notebooks" rel="nofollow"><code>elasticsearch-labs</code> repo</a>.</li> <li>Learn more about <a href="https://www.elastic.co/guide/en/elasticsearch/reference/current/retrievers-reranking-overview.html" rel="nofollow">retrievers and reranking in Elasticsearch</a></li>',It,de,Ct,ge,bt;return J=new us({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/semantic_reranking_elasticsearch.ipynb"}]}}),d=new u({props:{title:"Semantic reranking with Elasticsearch and Hugging Face",local:"semantic-reranking-with-elasticsearch-and-hugging-face",headingTag:"h1"}}),C=new u({props:{title:"🧰 Requirements",local:"-requirements",headingTag:"h2"}}),q=new u({props:{title:"Install and import packages",local:"install-and-import-packages",headingTag:"h2"}}),$=new j({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcVUlMjBlbGFzdGljc2VhcmNoJTBBIXBpcCUyMGluc3RhbGwlMjBlbGFuZCU1QnB5dG9yY2glNUQlMEFmcm9tJTIwZWxhc3RpY3NlYXJjaCUyMGltcG9ydCUyMEVsYXN0aWNzZWFyY2glMkMlMjBoZWxwZXJz",highlighted:`!pip install -qU elasticsearch
!pip install eland[pytorch]
<span class="hljs-keyword">from</span> elasticsearch <span class="hljs-keyword">import</span> Elasticsearch, helpers`,wrap:!1}}),k=new u({props:{title:"Initialize Elasticsearch Python client",local:"initialize-elasticsearch-python-client",headingTag:"h2"}}),E=new j({props:{code:"ZnJvbSUyMGdldHBhc3MlMjBpbXBvcnQlMjBnZXRwYXNzJTBBJTBBJTIzJTIwaHR0cHMlM0ElMkYlMkZ3d3cuZWxhc3RpYy5jbyUyRnNlYXJjaC1sYWJzJTJGdHV0b3JpYWxzJTJGaW5zdGFsbC1lbGFzdGljc2VhcmNoJTJGZWxhc3RpYy1jbG91ZCUyM2ZpbmRpbmcteW91ci1jbG91ZC1pZCUwQUVMQVNUSUNfQ0xPVURfSUQlMjAlM0QlMjBnZXRwYXNzKCUyMkVsYXN0aWMlMjBDbG91ZCUyMElEJTNBJTIwJTIyKSUwQSUwQSUyMyUyMGh0dHBzJTNBJTJGJTJGd3d3LmVsYXN0aWMuY28lMkZzZWFyY2gtbGFicyUyRnR1dG9yaWFscyUyRmluc3RhbGwtZWxhc3RpY3NlYXJjaCUyRmVsYXN0aWMtY2xvdWQlMjNjcmVhdGluZy1hbi1hcGkta2V5JTBBRUxBU1RJQ19BUElfS0VZJTIwJTNEJTIwZ2V0cGFzcyglMjJFbGFzdGljJTIwQXBpJTIwS2V5JTNBJTIwJTIyKSUwQSUwQSUyMyUyMENyZWF0ZSUyMHRoZSUyMGNsaWVudCUyMGluc3RhbmNlJTBBY2xpZW50JTIwJTNEJTIwRWxhc3RpY3NlYXJjaCglMEElMjAlMjAlMjAlMjAlMjMlMjBGb3IlMjBsb2NhbCUyMGRldmVsb3BtZW50JTBBJTIwJTIwJTIwJTIwJTIzJTIwaG9zdHMlM0QlNUIlMjJodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBOTIwMCUyMiU1RCUwQSUyMCUyMCUyMCUyMGNsb3VkX2lkJTNERUxBU1RJQ19DTE9VRF9JRCUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0RFTEFTVElDX0FQSV9LRVklMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> getpass <span class="hljs-keyword">import</span> getpass

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># https://www.elastic.co/search-labs/tutorials/install-elasticsearch/elastic-cloud#finding-your-cloud-id</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ELASTIC_CLOUD_ID = getpass(<span class="hljs-string">&quot;Elastic Cloud ID: &quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># https://www.elastic.co/search-labs/tutorials/install-elasticsearch/elastic-cloud#creating-an-api-key</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ELASTIC_API_KEY = getpass(<span class="hljs-string">&quot;Elastic Api Key: &quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Create the client instance</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = Elasticsearch(
<span class="hljs-meta">... </span>    <span class="hljs-comment"># For local development</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># hosts=[&quot;http://localhost:9200&quot;]</span>
<span class="hljs-meta">... </span>    cloud_id=ELASTIC_CLOUD_ID,
<span class="hljs-meta">... </span>    api_key=ELASTIC_API_KEY,
<span class="hljs-meta">... </span>)`,wrap:!1}}),G=new u({props:{title:"Test connection",local:"test-connection",headingTag:"h2"}}),Z=new j({props:{code:"cHJpbnQoY2xpZW50LmluZm8oKSk=",highlighted:'<span class="hljs-built_in">print</span>(client.info())',wrap:!1}}),_=new j({props:{code:"ZnJvbSUyMHVybGxpYi5yZXF1ZXN0JTIwaW1wb3J0JTIwdXJsb3BlbiUwQWltcG9ydCUyMGpzb24lMEFpbXBvcnQlMjB0aW1lJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGbGVlbXRob21wbyUyRnNtYWxsLW1vdmllcyUyRnJhdyUyRm1haW4lMkZzbWFsbC1tb3ZpZXMuanNvbiUyMiUwQXJlc3BvbnNlJTIwJTNEJTIwdXJsb3Blbih1cmwpJTBBJTBBJTIzJTIwTG9hZCUyMHRoZSUyMHJlc3BvbnNlJTIwZGF0YSUyMGludG8lMjBhJTIwSlNPTiUyMG9iamVjdCUwQWRhdGFfanNvbiUyMCUzRCUyMGpzb24ubG9hZHMocmVzcG9uc2UucmVhZCgpKSUwQSUwQSUyMyUyMFByZXBhcmUlMjB0aGUlMjBkb2N1bWVudHMlMjB0byUyMGJlJTIwaW5kZXhlZCUwQWRvY3VtZW50cyUyMCUzRCUyMCU1QiU1RCUwQWZvciUyMGRvYyUyMGluJTIwZGF0YV9qc29uJTNBJTBBJTIwJTIwJTIwJTIwZG9jdW1lbnRzLmFwcGVuZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJfaW5kZXglMjIlM0ElMjAlMjJtb3ZpZXMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJfc291cmNlJTIyJTNBJTIwZG9jJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUyMyUyMFVzZSUyMGhlbHBlcnMuYnVsayUyMHRvJTIwaW5kZXglMEFoZWxwZXJzLmJ1bGsoY2xpZW50JTJDJTIwZG9jdW1lbnRzKSUwQSUwQXByaW50KCUyMkRvbmUlMjBpbmRleGluZyUyMGRvY3VtZW50cyUyMGludG8lMjAlNjBtb3ZpZXMlNjAlMjBpbmRleCElMjIpJTBBdGltZS5zbGVlcCgzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> urllib.request <span class="hljs-keyword">import</span> urlopen
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> json
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> time

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/leemthompo/small-movies/raw/main/small-movies.json&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>response = urlopen(url)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the response data into a JSON object</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>data_json = json.loads(response.read())

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare the documents to be indexed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>documents = []
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> data_json:
<span class="hljs-meta">... </span>    documents.append(
<span class="hljs-meta">... </span>        {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;_index&quot;</span>: <span class="hljs-string">&quot;movies&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;_source&quot;</span>: doc,
<span class="hljs-meta">... </span>        }
<span class="hljs-meta">... </span>    )

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Use helpers.bulk to index</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>helpers.bulk(client, documents)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Done indexing documents into \`movies\` index!&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>time.sleep(<span class="hljs-number">3</span>)`,wrap:!1}}),W=new u({props:{title:"Upload Hugging Face model using Eland",local:"upload-hugging-face-model-using-eland",headingTag:"h2"}}),X=new j({props:{code:"IWVsYW5kX2ltcG9ydF9odWJfbW9kZWwlMjAlNUMlMEElMjAlMjAtLWNsb3VkLWlkJTIwJTI0RUxBU1RJQ19DTE9VRF9JRCUyMCU1QyUwQSUyMCUyMC0tZXMtYXBpLWtleSUyMCUyNEVMQVNUSUNfQVBJX0tFWSUyMCU1QyUwQSUyMCUyMC0taHViLW1vZGVsLWlkJTIwY3Jvc3MtZW5jb2RlciUyRm1zLW1hcmNvLU1pbmlMTS1MLTYtdjIlMjAlNUMlMEElMjAlMjAtLXRhc2stdHlwZSUyMHRleHRfc2ltaWxhcml0eSUyMCU1QyUwQSUyMCUyMC0tY2xlYXItcHJldmlvdXMlMjAlNUMlMEElMjAlMjAtLXN0YXJ0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>!eland_import_hub_model \\
<span class="hljs-meta">... </span>  --cloud-<span class="hljs-built_in">id</span> $ELASTIC_CLOUD_ID \\
<span class="hljs-meta">... </span>  --es-api-key $ELASTIC_API_KEY \\
<span class="hljs-meta">... </span>  --hub-model-<span class="hljs-built_in">id</span> cross-encoder/ms-marco-MiniLM-L-<span class="hljs-number">6</span>-v2 \\
<span class="hljs-meta">... </span>  --task-<span class="hljs-built_in">type</span> text_similarity \\
<span class="hljs-meta">... </span>  --clear-previous \\
<span class="hljs-meta">... </span>  --start`,wrap:!1}}),L=new u({props:{title:"Create inference endpoint",local:"create-inference-endpoint",headingTag:"h2"}}),F=new j({props:{code:"Y2xpZW50LmluZmVyZW5jZS5wdXQoJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIycmVyYW5rJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW5mZXJlbmNlX2lkJTNEJTIybXktbXNtYXJjby1taW5pbG0tbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjBpbmZlcmVuY2VfY29uZmlnJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2VydmljZSUyMiUzQSUyMCUyMmVsYXN0aWNzZWFyY2glMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzZXJ2aWNlX3NldHRpbmdzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybW9kZWxfaWQlMjIlM0ElMjAlMjJjcm9zcy1lbmNvZGVyX19tcy1tYXJjby1taW5pbG0tbC02LXYyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybnVtX2FsbG9jYXRpb25zJTIyJTNBJTIwMSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm51bV90aHJlYWRzJTIyJTNBJTIwMSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSk=",highlighted:`client.inference.put(
    task_type=<span class="hljs-string">&quot;rerank&quot;</span>,
    inference_id=<span class="hljs-string">&quot;my-msmarco-minilm-model&quot;</span>,
    inference_config={
        <span class="hljs-string">&quot;service&quot;</span>: <span class="hljs-string">&quot;elasticsearch&quot;</span>,
        <span class="hljs-string">&quot;service_settings&quot;</span>: {
            <span class="hljs-string">&quot;model_id&quot;</span>: <span class="hljs-string">&quot;cross-encoder__ms-marco-minilm-l-6-v2&quot;</span>,
            <span class="hljs-string">&quot;num_allocations&quot;</span>: <span class="hljs-number">1</span>,
            <span class="hljs-string">&quot;num_threads&quot;</span>: <span class="hljs-number">1</span>,
        },
    },
)`,wrap:!1}}),P=new j({props:{code:"Y2xpZW50LmluZmVyZW5jZS5nZXQoKQ==",highlighted:"client.inference.get()",wrap:!1}}),D=new u({props:{title:"Lexical queries",local:"lexical-queries",headingTag:"h2"}}),O=new u({props:{title:"Lexical match with query_string query",local:"lexical-match-with-querystring-query",headingTag:"h3"}}),se=new j({props:{code:"cmVzcCUyMCUzRCUyMGNsaWVudC5zZWFyY2goJTBBJTIwJTIwJTIwJTIwaW5kZXglM0QlMjJtb3ZpZXMlMjIlMkMlMEElMjAlMjAlMjAlMjByZXRyaWV2ZXIlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGFuZGFyZCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnF1ZXJ5JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycXVlcnlfc3RyaW5nJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycXVlcnklMjIlM0ElMjAlMjJmbGVzaC1lYXRpbmclMjBiYWQlMjBndXklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkZWZhdWx0X2ZpZWxkJTIyJTNBJTIwJTIycGxvdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSklMEElMEFpZiUyMHJlc3AlNUIlMjJoaXRzJTIyJTVEJTVCJTIyaGl0cyUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGhpdCUyMGluJTIwcmVzcCU1QiUyMmhpdHMlMjIlNUQlNUIlMjJoaXRzJTIyJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlMjAlM0QlMjBoaXQlNUIlMjJfc291cmNlJTIyJTVEJTVCJTIydGl0bGUlMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwbG90JTIwJTNEJTIwaGl0JTVCJTIyX3NvdXJjZSUyMiU1RCU1QiUyMnBsb3QlMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyVGl0bGUlM0ElMjAlN0J0aXRsZSU3RCU1Q25QbG90JTNBJTIwJTdCcGxvdCU3RCU1Q24lMjIpJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMk5vJTIwc2VhcmNoJTIwcmVzdWx0cyUyMGZvdW5kJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>resp = client.search(
<span class="hljs-meta">... </span>    index=<span class="hljs-string">&quot;movies&quot;</span>,
<span class="hljs-meta">... </span>    retriever={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;standard&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;query&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;query_string&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;query&quot;</span>: <span class="hljs-string">&quot;flesh-eating bad guy&quot;</span>,
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;default_field&quot;</span>: <span class="hljs-string">&quot;plot&quot;</span>,
<span class="hljs-meta">... </span>                }
<span class="hljs-meta">... </span>            }
<span class="hljs-meta">... </span>        }
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> resp[<span class="hljs-string">&quot;hits&quot;</span>][<span class="hljs-string">&quot;hits&quot;</span>]:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> hit <span class="hljs-keyword">in</span> resp[<span class="hljs-string">&quot;hits&quot;</span>][<span class="hljs-string">&quot;hits&quot;</span>]:
<span class="hljs-meta">... </span>        title = hit[<span class="hljs-string">&quot;_source&quot;</span>][<span class="hljs-string">&quot;title&quot;</span>]
<span class="hljs-meta">... </span>        plot = hit[<span class="hljs-string">&quot;_source&quot;</span>][<span class="hljs-string">&quot;plot&quot;</span>]
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Title: <span class="hljs-subst">{title}</span>\\nPlot: <span class="hljs-subst">{plot}</span>\\n&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;No search results found&quot;</span>)`,wrap:!1}}),ne=new u({props:{title:"Simple multi_match query",local:"simple-multimatch-query",headingTag:"h3"}}),oe=new j({props:{code:"cmVzcCUyMCUzRCUyMGNsaWVudC5zZWFyY2goJTBBJTIwJTIwJTIwJTIwaW5kZXglM0QlMjJtb3ZpZXMlMjIlMkMlMEElMjAlMjAlMjAlMjByZXRyaWV2ZXIlM0QlN0IlMjJzdGFuZGFyZCUyMiUzQSUyMCU3QiUyMnF1ZXJ5JTIyJTNBJTIwJTdCJTIybXVsdGlfbWF0Y2glMjIlM0ElMjAlN0IlMjJxdWVyeSUyMiUzQSUyMCUyMmNyaW1lJTIyJTJDJTIwJTIyZmllbGRzJTIyJTNBJTIwJTVCJTIycGxvdCUyMiUyQyUyMCUyMmdlbnJlJTIyJTVEJTdEJTdEJTdEJTdEJTJDJTBBKSUwQSUwQWZvciUyMGhpdCUyMGluJTIwcmVzcCU1QiUyMmhpdHMlMjIlNUQlNUIlMjJoaXRzJTIyJTVEJTNBJTBBJTIwJTIwJTIwJTIwdGl0bGUlMjAlM0QlMjBoaXQlNUIlMjJfc291cmNlJTIyJTVEJTVCJTIydGl0bGUlMjIlNUQlMEElMjAlMjAlMjAlMjBwbG90JTIwJTNEJTIwaGl0JTVCJTIyX3NvdXJjZSUyMiU1RCU1QiUyMnBsb3QlMjIlNUQlMEElMjAlMjAlMjAlMjBwcmludChmJTIyVGl0bGUlM0ElMjAlN0J0aXRsZSU3RCU1Q25QbG90JTNBJTIwJTdCcGxvdCU3RCU1Q24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>resp = client.search(
<span class="hljs-meta">... </span>    index=<span class="hljs-string">&quot;movies&quot;</span>,
<span class="hljs-meta">... </span>    retriever={<span class="hljs-string">&quot;standard&quot;</span>: {<span class="hljs-string">&quot;query&quot;</span>: {<span class="hljs-string">&quot;multi_match&quot;</span>: {<span class="hljs-string">&quot;query&quot;</span>: <span class="hljs-string">&quot;crime&quot;</span>, <span class="hljs-string">&quot;fields&quot;</span>: [<span class="hljs-string">&quot;plot&quot;</span>, <span class="hljs-string">&quot;genre&quot;</span>]}}}},
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> hit <span class="hljs-keyword">in</span> resp[<span class="hljs-string">&quot;hits&quot;</span>][<span class="hljs-string">&quot;hits&quot;</span>]:
<span class="hljs-meta">... </span>    title = hit[<span class="hljs-string">&quot;_source&quot;</span>][<span class="hljs-string">&quot;title&quot;</span>]
<span class="hljs-meta">... </span>    plot = hit[<span class="hljs-string">&quot;_source&quot;</span>][<span class="hljs-string">&quot;plot&quot;</span>]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Title: <span class="hljs-subst">{title}</span>\\nPlot: <span class="hljs-subst">{plot}</span>\\n&quot;</span>)`,wrap:!1}}),he=new u({props:{title:"Semantic reranker",local:"semantic-reranker",headingTag:"h2"}}),Me=new j({props:{code:"cmVzcCUyMCUzRCUyMGNsaWVudC5zZWFyY2goJTBBJTIwJTIwJTIwJTIwaW5kZXglM0QlMjJtb3ZpZXMlMjIlMkMlMEElMjAlMjAlMjAlMjByZXRyaWV2ZXIlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0ZXh0X3NpbWlsYXJpdHlfcmVyYW5rZXIlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyZXRyaWV2ZXIlMjIlM0ElMjAlN0IlMjJzdGFuZGFyZCUyMiUzQSUyMCU3QiUyMnF1ZXJ5JTIyJTNBJTIwJTdCJTIybXVsdGlfbWF0Y2glMjIlM0ElMjAlN0IlMjJxdWVyeSUyMiUzQSUyMCUyMmNyaW1lJTIyJTJDJTIwJTIyZmllbGRzJTIyJTNBJTIwJTVCJTIycGxvdCUyMiUyQyUyMCUyMmdlbnJlJTIyJTVEJTdEJTdEJTdEJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZmllbGQlMjIlM0ElMjAlMjJwbG90JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW5mZXJlbmNlX2lkJTIyJTNBJTIwJTIybXktbXNtYXJjby1taW5pbG0tbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbmZlcmVuY2VfdGV4dCUyMiUzQSUyMCUyMmZsZXNoLWVhdGluZyUyMGJhZCUyMGd1eSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSklMEElMEFmb3IlMjBoaXQlMjBpbiUyMHJlc3AlNUIlMjJoaXRzJTIyJTVEJTVCJTIyaGl0cyUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMHRpdGxlJTIwJTNEJTIwaGl0JTVCJTIyX3NvdXJjZSUyMiU1RCU1QiUyMnRpdGxlJTIyJTVEJTBBJTIwJTIwJTIwJTIwcGxvdCUyMCUzRCUyMGhpdCU1QiUyMl9zb3VyY2UlMjIlNUQlNUIlMjJwbG90JTIyJTVEJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlRpdGxlJTNBJTIwJTdCdGl0bGUlN0QlNUNuUGxvdCUzQSUyMCU3QnBsb3QlN0QlNUNuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>resp = client.search(
<span class="hljs-meta">... </span>    index=<span class="hljs-string">&quot;movies&quot;</span>,
<span class="hljs-meta">... </span>    retriever={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;text_similarity_reranker&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;retriever&quot;</span>: {<span class="hljs-string">&quot;standard&quot;</span>: {<span class="hljs-string">&quot;query&quot;</span>: {<span class="hljs-string">&quot;multi_match&quot;</span>: {<span class="hljs-string">&quot;query&quot;</span>: <span class="hljs-string">&quot;crime&quot;</span>, <span class="hljs-string">&quot;fields&quot;</span>: [<span class="hljs-string">&quot;plot&quot;</span>, <span class="hljs-string">&quot;genre&quot;</span>]}}}},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;field&quot;</span>: <span class="hljs-string">&quot;plot&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;inference_id&quot;</span>: <span class="hljs-string">&quot;my-msmarco-minilm-model&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;inference_text&quot;</span>: <span class="hljs-string">&quot;flesh-eating bad guy&quot;</span>,
<span class="hljs-meta">... </span>        }
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> hit <span class="hljs-keyword">in</span> resp[<span class="hljs-string">&quot;hits&quot;</span>][<span class="hljs-string">&quot;hits&quot;</span>]:
<span class="hljs-meta">... </span>    title = hit[<span class="hljs-string">&quot;_source&quot;</span>][<span class="hljs-string">&quot;title&quot;</span>]
<span class="hljs-meta">... </span>    plot = hit[<span class="hljs-string">&quot;_source&quot;</span>][<span class="hljs-string">&quot;plot&quot;</span>]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Title: <span class="hljs-subst">{title}</span>\\nPlot: <span class="hljs-subst">{plot}</span>\\n&quot;</span>)`,wrap:!1}}),Te=new u({props:{title:"Learn more",local:"learn-more",headingTag:"h2"}}),de=new js({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/semantic_reranking_elasticsearch.md"}}),{c(){T=i("meta"),Ue=a(),we=i("p"),fe=a(),r(J.$$.fragment),Ie=a(),r(d.$$.fragment),Ce=a(),w=i("p"),w.innerHTML=qt,be=a(),g=i("p"),g.innerHTML=At,ve=a(),U=i("p"),U.innerHTML=$t,qe=a(),f=i("p"),f.textContent=kt,Ae=a(),I=i("ul"),I.innerHTML=xt,$e=a(),r(C.$$.fragment),ke=a(),b=i("p"),b.textContent=Et,xe=a(),v=i("ul"),v.innerHTML=Bt,Ee=a(),r(q.$$.fragment),Be=a(),A=i("p"),A.innerHTML=Gt,Ge=a(),r($.$$.fragment),Ne=a(),r(k.$$.fragment),Ze=a(),x=i("p"),x.textContent=Nt,Qe=a(),r(E.$$.fragment),_e=a(),B=i("pre"),B.textContent=Zt,Se=a(),r(G.$$.fragment),We=a(),N=i("p"),N.textContent=Qt,Re=a(),r(Z.$$.fragment),Xe=a(),Q=i("p"),Q.textContent=_t,Ve=a(),r(_.$$.fragment),Le=a(),S=i("pre"),S.textContent=St,ze=a(),r(W.$$.fragment),Fe=a(),R=i("p"),R.innerHTML=Wt,He=a(),r(X.$$.fragment),Pe=a(),V=i("pre"),V.textContent=Rt,Ye=a(),r(L.$$.fragment),De=a(),z=i("p"),z.innerHTML=Xt,Ke=a(),r(F.$$.fragment),Oe=a(),H=i("p"),H.textContent=Vt,et=a(),r(P.$$.fragment),tt=a(),Y=i("p"),Y.innerHTML=Lt,st=a(),r(D.$$.fragment),lt=a(),K=i("p"),K.innerHTML=zt,at=a(),r(O.$$.fragment),nt=a(),ee=i("p"),ee.textContent=Ft,it=a(),te=i("p"),te.innerHTML=Ht,ot=a(),r(se.$$.fragment),pt=a(),le=i("pre"),le.textContent=Pt,rt=a(),ae=i("p"),ae.textContent=Yt,ct=a(),r(ne.$$.fragment),ht=a(),ie=i("p"),ie.textContent=Dt,mt=a(),r(oe.$$.fragment),Mt=a(),pe=i("pre"),pe.textContent=Kt,yt=a(),re=i("p"),re.textContent=Ot,ut=a(),ce=i("p"),ce.innerHTML=es,jt=a(),r(he.$$.fragment),Tt=a(),me=i("p"),me.innerHTML=ts,Jt=a(),r(Me.$$.fragment),dt=a(),ye=i("pre"),ye.textContent=ss,wt=a(),ue=i("p"),ue.textContent=ls,gt=a(),je=i("p"),je.textContent=as,Ut=a(),r(Te.$$.fragment),ft=a(),Je=i("ul"),Je.innerHTML=ns,It=a(),r(de.$$.fragment),Ct=a(),ge=i("p"),this.h()},l(e){const t=Ms("svelte-u9bgzb",document.head);T=o(t,"META",{name:!0,content:!0}),t.forEach(s),Ue=n(e),we=o(e,"P",{}),is(we).forEach(s),fe=n(e),c(J.$$.fragment,e),Ie=n(e),c(d.$$.fragment,e),Ce=n(e),w=o(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-15h9vzq"&&(w.innerHTML=qt),be=n(e),g=o(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-ghp8j6"&&(g.innerHTML=At),ve=n(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1sgmmyr"&&(U.innerHTML=$t),qe=n(e),f=o(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-1xbnm7h"&&(f.textContent=kt),Ae=n(e),I=o(e,"UL",{"data-svelte-h":!0}),p(I)!=="svelte-s2bfhc"&&(I.innerHTML=xt),$e=n(e),c(C.$$.fragment,e),ke=n(e),b=o(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-3aq2ds"&&(b.textContent=Et),xe=n(e),v=o(e,"UL",{"data-svelte-h":!0}),p(v)!=="svelte-pk6dgn"&&(v.innerHTML=Bt),Ee=n(e),c(q.$$.fragment,e),Be=n(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-c1ile"&&(A.innerHTML=Gt),Ge=n(e),c($.$$.fragment,e),Ne=n(e),c(k.$$.fragment,e),Ze=n(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1mu35i"&&(x.textContent=Nt),Qe=n(e),c(E.$$.fragment,e),_e=n(e),B=o(e,"PRE",{"data-svelte-h":!0}),p(B)!=="svelte-1x47hmf"&&(B.textContent=Zt),Se=n(e),c(G.$$.fragment,e),We=n(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-7uwvg8"&&(N.textContent=Qt),Re=n(e),c(Z.$$.fragment,e),Xe=n(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-18d4ymf"&&(Q.textContent=_t),Ve=n(e),c(_.$$.fragment,e),Le=n(e),S=o(e,"PRE",{"data-svelte-h":!0}),p(S)!=="svelte-1m77zdm"&&(S.textContent=St),ze=n(e),c(W.$$.fragment,e),Fe=n(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1ca2x37"&&(R.innerHTML=Wt),He=n(e),c(X.$$.fragment,e),Pe=n(e),V=o(e,"PRE",{"data-svelte-h":!0}),p(V)!=="svelte-1o6q6qn"&&(V.textContent=Rt),Ye=n(e),c(L.$$.fragment,e),De=n(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-it6ukr"&&(z.innerHTML=Xt),Ke=n(e),c(F.$$.fragment,e),Oe=n(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-ovxxa0"&&(H.textContent=Vt),et=n(e),c(P.$$.fragment,e),tt=n(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-qyxqyq"&&(Y.innerHTML=Lt),st=n(e),c(D.$$.fragment,e),lt=n(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1lhom78"&&(K.innerHTML=zt),at=n(e),c(O.$$.fragment,e),nt=n(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-17srll"&&(ee.textContent=Ft),it=n(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-h70xlg"&&(te.innerHTML=Ht),ot=n(e),c(se.$$.fragment,e),pt=n(e),le=o(e,"PRE",{"data-svelte-h":!0}),p(le)!=="svelte-k5qxm1"&&(le.textContent=Pt),rt=n(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1ednygn"&&(ae.textContent=Yt),ct=n(e),c(ne.$$.fragment,e),ht=n(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-wglz1c"&&(ie.textContent=Dt),mt=n(e),c(oe.$$.fragment,e),Mt=n(e),pe=o(e,"PRE",{"data-svelte-h":!0}),p(pe)!=="svelte-t0ny4t"&&(pe.textContent=Kt),yt=n(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-7lrowr"&&(re.textContent=Ot),ut=n(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1rxzbcx"&&(ce.innerHTML=es),jt=n(e),c(he.$$.fragment,e),Tt=n(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-1644ogc"&&(me.innerHTML=ts),Jt=n(e),c(Me.$$.fragment,e),dt=n(e),ye=o(e,"PRE",{"data-svelte-h":!0}),p(ye)!=="svelte-vpj64j"&&(ye.textContent=ss),wt=n(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-xlaql4"&&(ue.textContent=ls),gt=n(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1ekzpnb"&&(je.textContent=as),Ut=n(e),c(Te.$$.fragment,e),ft=n(e),Je=o(e,"UL",{"data-svelte-h":!0}),p(Je)!=="svelte-gd4z7i"&&(Je.innerHTML=ns),It=n(e),c(de.$$.fragment,e),Ct=n(e),ge=o(e,"P",{}),is(ge).forEach(s),this.h()},h(){os(T,"name","hf:doc:metadata"),os(T,"content",Js)},m(e,t){ys(document.head,T),l(e,Ue,t),l(e,we,t),l(e,fe,t),h(J,e,t),l(e,Ie,t),h(d,e,t),l(e,Ce,t),l(e,w,t),l(e,be,t),l(e,g,t),l(e,ve,t),l(e,U,t),l(e,qe,t),l(e,f,t),l(e,Ae,t),l(e,I,t),l(e,$e,t),h(C,e,t),l(e,ke,t),l(e,b,t),l(e,xe,t),l(e,v,t),l(e,Ee,t),h(q,e,t),l(e,Be,t),l(e,A,t),l(e,Ge,t),h($,e,t),l(e,Ne,t),h(k,e,t),l(e,Ze,t),l(e,x,t),l(e,Qe,t),h(E,e,t),l(e,_e,t),l(e,B,t),l(e,Se,t),h(G,e,t),l(e,We,t),l(e,N,t),l(e,Re,t),h(Z,e,t),l(e,Xe,t),l(e,Q,t),l(e,Ve,t),h(_,e,t),l(e,Le,t),l(e,S,t),l(e,ze,t),h(W,e,t),l(e,Fe,t),l(e,R,t),l(e,He,t),h(X,e,t),l(e,Pe,t),l(e,V,t),l(e,Ye,t),h(L,e,t),l(e,De,t),l(e,z,t),l(e,Ke,t),h(F,e,t),l(e,Oe,t),l(e,H,t),l(e,et,t),h(P,e,t),l(e,tt,t),l(e,Y,t),l(e,st,t),h(D,e,t),l(e,lt,t),l(e,K,t),l(e,at,t),h(O,e,t),l(e,nt,t),l(e,ee,t),l(e,it,t),l(e,te,t),l(e,ot,t),h(se,e,t),l(e,pt,t),l(e,le,t),l(e,rt,t),l(e,ae,t),l(e,ct,t),h(ne,e,t),l(e,ht,t),l(e,ie,t),l(e,mt,t),h(oe,e,t),l(e,Mt,t),l(e,pe,t),l(e,yt,t),l(e,re,t),l(e,ut,t),l(e,ce,t),l(e,jt,t),h(he,e,t),l(e,Tt,t),l(e,me,t),l(e,Jt,t),h(Me,e,t),l(e,dt,t),l(e,ye,t),l(e,wt,t),l(e,ue,t),l(e,gt,t),l(e,je,t),l(e,Ut,t),h(Te,e,t),l(e,ft,t),l(e,Je,t),l(e,It,t),h(de,e,t),l(e,Ct,t),l(e,ge,t),bt=!0},p:rs,i(e){bt||(m(J.$$.fragment,e),m(d.$$.fragment,e),m(C.$$.fragment,e),m(q.$$.fragment,e),m($.$$.fragment,e),m(k.$$.fragment,e),m(E.$$.fragment,e),m(G.$$.fragment,e),m(Z.$$.fragment,e),m(_.$$.fragment,e),m(W.$$.fragment,e),m(X.$$.fragment,e),m(L.$$.fragment,e),m(F.$$.fragment,e),m(P.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(se.$$.fragment,e),m(ne.$$.fragment,e),m(oe.$$.fragment,e),m(he.$$.fragment,e),m(Me.$$.fragment,e),m(Te.$$.fragment,e),m(de.$$.fragment,e),bt=!0)},o(e){M(J.$$.fragment,e),M(d.$$.fragment,e),M(C.$$.fragment,e),M(q.$$.fragment,e),M($.$$.fragment,e),M(k.$$.fragment,e),M(E.$$.fragment,e),M(G.$$.fragment,e),M(Z.$$.fragment,e),M(_.$$.fragment,e),M(W.$$.fragment,e),M(X.$$.fragment,e),M(L.$$.fragment,e),M(F.$$.fragment,e),M(P.$$.fragment,e),M(D.$$.fragment,e),M(O.$$.fragment,e),M(se.$$.fragment,e),M(ne.$$.fragment,e),M(oe.$$.fragment,e),M(he.$$.fragment,e),M(Me.$$.fragment,e),M(Te.$$.fragment,e),M(de.$$.fragment,e),bt=!1},d(e){e&&(s(Ue),s(we),s(fe),s(Ie),s(Ce),s(w),s(be),s(g),s(ve),s(U),s(qe),s(f),s(Ae),s(I),s($e),s(ke),s(b),s(xe),s(v),s(Ee),s(Be),s(A),s(Ge),s(Ne),s(Ze),s(x),s(Qe),s(_e),s(B),s(Se),s(We),s(N),s(Re),s(Xe),s(Q),s(Ve),s(Le),s(S),s(ze),s(Fe),s(R),s(He),s(Pe),s(V),s(Ye),s(De),s(z),s(Ke),s(Oe),s(H),s(et),s(tt),s(Y),s(st),s(lt),s(K),s(at),s(nt),s(ee),s(it),s(te),s(ot),s(pt),s(le),s(rt),s(ae),s(ct),s(ht),s(ie),s(mt),s(Mt),s(pe),s(yt),s(re),s(ut),s(ce),s(jt),s(Tt),s(me),s(Jt),s(dt),s(ye),s(wt),s(ue),s(gt),s(je),s(Ut),s(ft),s(Je),s(It),s(Ct),s(ge)),s(T),y(J,e),y(d,e),y(C,e),y(q,e),y($,e),y(k,e),y(E,e),y(G,e),y(Z,e),y(_,e),y(W,e),y(X,e),y(L,e),y(F,e),y(P,e),y(D,e),y(O,e),y(se,e),y(ne,e),y(oe,e),y(he,e),y(Me,e),y(Te,e),y(de,e)}}}const Js='{"title":"Semantic reranking with Elasticsearch and Hugging Face","local":"semantic-reranking-with-elasticsearch-and-hugging-face","sections":[{"title":"🧰 Requirements","local":"-requirements","sections":[],"depth":2},{"title":"Install and import packages","local":"install-and-import-packages","sections":[],"depth":2},{"title":"Initialize Elasticsearch Python client","local":"initialize-elasticsearch-python-client","sections":[],"depth":2},{"title":"Test connection","local":"test-connection","sections":[],"depth":2},{"title":"Upload Hugging Face model using Eland","local":"upload-hugging-face-model-using-eland","sections":[],"depth":2},{"title":"Create inference endpoint","local":"create-inference-endpoint","sections":[],"depth":2},{"title":"Lexical queries","local":"lexical-queries","sections":[{"title":"Lexical match with query_string query","local":"lexical-match-with-querystring-query","sections":[],"depth":3},{"title":"Simple multi_match query","local":"simple-multimatch-query","sections":[],"depth":3}],"depth":2},{"title":"Semantic reranker","local":"semantic-reranker","sections":[],"depth":2},{"title":"Learn more","local":"learn-more","sections":[],"depth":2}],"depth":1}';function ds(vt){return cs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Is extends hs{constructor(T){super(),ms(this,T,ds,Ts,ps,{})}}export{Is as component};
