import{s as xp,f as g,n as kp,o as Gp}from"../chunks/scheduler.37c15a92.js";import{S as Rp,i as Yp,g as i,s,r as p,A as Ep,h as o,f as l,c as a,j as Hp,u as m,x as r,k as c,y as Xp,a as n,v as u,d as M,t as h,w as d}from"../chunks/index.7cb9c9b8.js";import{C as f}from"../chunks/CodeBlock.a6d3f852.js";import{C as Vp}from"../chunks/CourseFloatingBanner.36c274d0.js";import{H as y}from"../chunks/Heading.d3928e2a.js";function Sp(Di){let b,ln,en,nn,U,sn,J,an,C,qi=`Now that you’ve studied the bases of Reinforcement Learning, you’re ready to train your first agent and share it with the community through the Hub 🔥:
A Lunar Lander agent that will learn to land correctly on the Moon 🌕`,on,I,Oi,rn,$,Ki="And finally, you’ll <strong>upload this trained agent to the Hugging Face Hub 🤗, a free, open platform where people can share ML models, datasets, and demos.</strong>",pn,Z,eo='Thanks to our <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard">leaderboard</a>, you’ll be able to compare your results with other classmates and exchange the best practices to improve your agent’s scores. Who will win the challenge for Unit 1 🏆?',mn,_,to='To validate this hands-on for the <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">certification process</a>, you need to push your trained model to the Hub and <strong>get a result of &gt;= 200</strong>.',un,B,lo='To find your result, go to the <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">leaderboard</a> and find your model, <strong>the result = mean_reward - std of reward</strong>',Mn,W,no="<strong>If you don’t find your model, go to the bottom of the page and click on the refresh button.</strong>",hn,L,so='For more information about the certification process, check this section 👉 <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process</a>',dn,H,ao='And you can check your progress here 👉 <a href="https://huggingface.co/spaces/ThomasSimonini/Check-my-progress-Deep-RL-Course" rel="nofollow">https://huggingface.co/spaces/ThomasSimonini/Check-my-progress-Deep-RL-Course</a>',cn,x,io="So let’s get started! 🚀",yn,k,oo="<strong>To start the hands-on click on Open In Colab button</strong> 👇 :",fn,G,ro='<a href="https://colab.research.google.com/github/huggingface/deep-rl-class/blob/master/notebooks/unit1/unit1.ipynb" rel="nofollow"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a>',gn,R,po="We strongly <strong>recommend students use Google Colab for the hands-on exercises</strong> instead of running them on their personal computers.",bn,Y,mo="By using Google Colab, <strong>you can focus on learning and experimenting without worrying about the technical aspects</strong> of setting up your environments.",wn,E,Tn,w,uo,vn,X,Mo='In this notebook, you’ll train your <strong>first Deep Reinforcement Learning agent</strong> a Lunar Lander agent that will learn to <strong>land correctly on the Moon 🌕</strong>. Using <a href="https://stable-baselines3.readthedocs.io/en/master/" rel="nofollow">Stable-Baselines3</a> a Deep Reinforcement Learning library, share them with the community, and experiment with different configurations',jn,V,Un,S,ho='<li><a href="https://gymnasium.farama.org/environments/box2d/lunar_lander/" rel="nofollow">LunarLander-v2</a></li>',Jn,F,Cn,Q,co='<li><a href="https://stable-baselines3.readthedocs.io/en/master/" rel="nofollow">Stable-Baselines3</a></li>',In,z,yo='We’re constantly trying to improve our tutorials, so <strong>if you find some issues in this notebook</strong>, please <a href="https://github.com/huggingface/deep-rl-class/issues" rel="nofollow">open an issue on the Github Repo</a>.',$n,P,Zn,A,fo="At the end of the notebook, you will:",_n,N,go="<li>Be able to use <strong>Gymnasium</strong>, the environment library.</li> <li>Be able to use <strong>Stable-Baselines3</strong>, the deep reinforcement learning library.</li> <li>Be able to <strong>push your trained agent to the Hub</strong> with a nice video replay and an evaluation score 🔥.</li>",Bn,D,Wn,q,bo,Ln,O,wo="In this free course, you will:",Hn,K,To="<li>📖 Study Deep Reinforcement Learning in <strong>theory and practice</strong>.</li> <li>🧑‍💻 Learn to <strong>use famous Deep RL libraries</strong> such as Stable Baselines3, RL Baselines3 Zoo, CleanRL and Sample Factory 2.0.</li> <li>🤖 Train <strong>agents in unique environments</strong></li> <li>🎓 <strong>Earn a certificate of completion</strong> by completing 80% of the assignments.</li>",xn,ee,vo="And more!",kn,te,jo='Check 📚 the syllabus 👉 <a href="https://simoninithomas.github.io/deep-rl-course" rel="nofollow">https://simoninithomas.github.io/deep-rl-course</a>',Gn,le,Uo='Don’t forget to <strong><a href="http://eepurl.com/ic5ZUD">sign up to the course</a></strong> (we are collecting your email to be able to <strong>send you the links when each Unit is published and give you information about the challenges and updates).</strong>',Rn,ne,Jo='The best way to keep in touch and ask questions is <strong>to join our discord server</strong> to exchange with the community and with us 👉🏻 <a href="https://discord.gg/ydHrjt3WP5" rel="nofollow">https://discord.gg/ydHrjt3WP5</a>',Yn,se,En,ae,Co="Before diving into the notebook, you need to:",Xn,ie,Io='🔲 📝 <strong><a href="https://huggingface.co/deep-rl-course/unit0/introduction" rel="nofollow">Read Unit 0</a></strong> that gives you all the <strong>information about the course and helps you to onboard</strong> 🤗',Vn,oe,$o='🔲 📚 <strong>Develop an understanding of the foundations of Reinforcement learning</strong> (MC, TD, Rewards hypothesis…) by <a href="https://huggingface.co/deep-rl-course/unit1/introduction" rel="nofollow">reading Unit 1</a>.',Sn,re,Fn,T,Zo,Qn,pe,_o="Let’s do a small recap on what we learned in the first Unit:",zn,me,Bo="<li><p>Reinforcement Learning is a <strong>computational approach to learning from actions</strong>. We build an agent that learns from the environment by <strong>interacting with it through trial and error</strong> and receiving rewards (negative or positive) as feedback.</p></li> <li><p>The goal of any RL agent is to <strong>maximize its expected cumulative reward</strong> (also called expected return) because RL is based on the <em>reward hypothesis</em>, which is that all goals can be described as the maximization of an expected cumulative reward.</p></li> <li><p>The RL process is a <strong>loop that outputs a sequence of state, action, reward, and next state</strong>.</p></li> <li><p>To calculate the expected cumulative reward (expected return), <strong>we discount the rewards</strong>: the rewards that come sooner (at the beginning of the game) are more probable to happen since they are more predictable than the long-term future reward.</p></li> <li><p>To solve an RL problem, you want to <strong>find an optimal policy</strong>; the policy is the “brain” of your AI that will tell us what action to take given a state. The optimal one is the one that gives you the actions that max the expected return.</p></li>",Pn,ue,Wo="There are <strong>two</strong> ways to find your optimal policy:",An,Me,Lo="<li><p>By <strong>training your policy directly</strong>: policy-based methods.</p></li> <li><p>By <strong>training a value function</strong> that tells us the expected return the agent will get at each state and use this function to define our policy: value-based methods.</p></li> <li><p>Finally, we spoke about Deep RL because <strong>we introduce deep neural networks to estimate the action to take (policy-based) or to estimate the value of a state (value-based) hence the name “deep.”</strong></p></li>",Nn,he,Dn,de,qn,ce,Ho='To validate this hands-on for the <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">certification process</a>, you need to push your trained model to the Hub and <strong>get a result of &gt;= 200</strong>.',On,ye,xo='To find your result, go to the <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">leaderboard</a> and find your model, <strong>the result = mean_reward - std of reward</strong>',Kn,fe,ko='For more information about the certification process, check this section 👉 <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process</a>',es,ge,ts,be,Go="<li>To <strong>accelerate the agent’s training, we’ll use a GPU</strong>. To do that, go to <code>Runtime &gt; Change Runtime type</code></li>",ls,we,Ro,ns,Te,Yo="<li><code>Hardware Accelerator &gt; GPU</code></li>",ss,ve,Eo,as,je,is,Ue,Xo="The first step is to install the dependencies, we’ll install multiple ones.",os,Je,Vo="<li><code>gymnasium[box2d]</code>: Contains the LunarLander-v2 environment 🌛</li> <li><code>stable-baselines3[extra]</code>: The deep reinforcement learning library.</li> <li><code>huggingface_sb3</code>: Additional code for Stable-baselines3 to load and upload models from the Hugging Face 🤗 Hub.</li>",rs,Ce,So="To make things easier, we created a script to install all these dependencies.",ps,Ie,ms,$e,us,Ze,Fo="During the notebook, we’ll need to generate a replay video. To do so, with colab, <strong>we need to have a virtual screen to be able to render the environment</strong> (and thus record the frames).",Ms,_e,Qo="Hence the following cell will install virtual screen libraries and create and run a virtual screen 🖥",hs,Be,ds,We,zo="To make sure the new installed libraries are used, <strong>sometimes it’s required to restart the notebook runtime</strong>. The next cell will force the <strong>runtime to crash, so you’ll need to connect again and run the code starting from here</strong>. Thanks to this trick, <strong>we will be able to run our virtual screen.</strong>",cs,Le,ys,He,fs,xe,gs,ke,Po="One additional library we import is huggingface_hub <strong>to be able to upload and download trained models from the hub</strong>.",bs,Ge,Ao="The Hugging Face Hub 🤗 works as a central place where anyone can share and explore models and datasets. It has versioning, metrics, visualizations and other features that will allow you to easily collaborate with others.",ws,Re,No='You can see here all the Deep reinforcement Learning models available here👉 <a href="https://huggingface.co/models?pipeline_tag=reinforcement-learning&amp;sort=downloads" rel="nofollow">https://huggingface.co/models?pipeline_tag=reinforcement-learning&amp;sort=downloads</a>',Ts,Ye,vs,Ee,js,Xe,Do=`🏋 The library containing our environment is called Gymnasium.
<strong>You’ll use Gymnasium a lot in Deep Reinforcement Learning.</strong>`,Us,Ve,qo='Gymnasium is the <strong>new version of Gym library</strong> <a href="https://farama.org/" rel="nofollow">maintained by the Farama Foundation</a>.',Js,Se,Oo="The Gymnasium library provides two things:",Cs,Fe,Ko="<li>An interface that allows you to <strong>create RL environments</strong>.</li> <li>A <strong>collection of environments</strong> (gym-control, atari, box2D…).</li>",Is,Qe,er="Let’s look at an example, but first let’s recall the RL loop.",$s,v,tr,Zs,ze,lr="At each step:",_s,Pe,nr="<li>Our Agent receives a <strong>state (S0)</strong> from the <strong>Environment</strong> — we receive the first frame of our game (Environment).</li> <li>Based on that <strong>state (S0),</strong> the Agent takes an <strong>action (A0)</strong> — our Agent will move to the right.</li> <li>The environment transitions to a <strong>new</strong> <strong>state (S1)</strong> — new frame.</li> <li>The environment gives some <strong>reward (R1)</strong> to the Agent — we’re not dead <em>(Positive Reward +1)</em>.</li>",Bs,Ae,sr="With Gymnasium:",Ws,Ne,ar="1️⃣ We create our environment using <code>gymnasium.make()</code>",Ls,De,ir="2️⃣ We reset the environment to its initial state with <code>observation = env.reset()</code>",Hs,qe,or="At each step:",xs,Oe,rr="3️⃣ Get an action using our model (in our example we take a random action)",ks,Ke,pr="4️⃣ Using <code>env.step(action)</code>, we perform this action in the environment and get",Gs,et,mr="<li><code>observation</code>: The new state (st+1)</li> <li><code>reward</code>: The reward we get after executing the action</li> <li><code>terminated</code>: Indicates if the episode terminated (agent reach the terminal state)</li> <li><code>truncated</code>: Introduced with this new version, it indicates a timelimit or if an agent go out of bounds of the environment for instance.</li> <li><code>info</code>: A dictionary that provides additional information (depends on the environment).</li>",Rs,tt,ur='For more explanations check this 👉 <a href="https://gymnasium.farama.org/api/env/#gymnasium.Env.step" rel="nofollow">https://gymnasium.farama.org/api/env/#gymnasium.Env.step</a>',Ys,lt,Mr="If the episode is terminated:",Es,nt,hr="<li>We reset the environment to its initial state with <code>observation = env.reset()</code></li>",Xs,st,dr="<strong>Let’s look at an example!</strong> Make sure to read the code",Vs,at,Ss,it,Fs,ot,Qs,rt,cr='In this first tutorial, we’re going to train our agent, a <a href="https://gymnasium.farama.org/environments/box2d/lunar_lander/" rel="nofollow">Lunar Lander</a>, <strong>to land correctly on the moon</strong>. To do that, the agent needs to learn <strong>to adapt its speed and position (horizontal, vertical, and angular) to land correctly.</strong>',zs,Ps,As,pt,yr="💡 A good habit when you start to use an environment is to check its documentation",Ns,mt,fr='👉 <a href="https://gymnasium.farama.org/environments/box2d/lunar_lander/" rel="nofollow">https://gymnasium.farama.org/environments/box2d/lunar_lander/</a>',Ds,qs,Os,ut,gr="Let’s see what the Environment looks like:",Ks,Mt,ea,ht,br="We see with <code>Observation Space Shape (8,)</code> that the observation is a vector of size 8, where each value contains different information about the lander:",ta,dt,wr="<li>Horizontal pad coordinate (x)</li> <li>Vertical pad coordinate (y)</li> <li>Horizontal speed (x)</li> <li>Vertical speed (y)</li> <li>Angle</li> <li>Angular speed</li> <li>If the left leg contact point has touched the land (boolean)</li> <li>If the right leg contact point has touched the land (boolean)</li>",la,ct,na,yt,Tr="The action space (the set of possible actions the agent can take) is discrete with 4 actions available 🎮:",sa,ft,vr="<li>Action 0: Do nothing,</li> <li>Action 1: Fire left orientation engine,</li> <li>Action 2: Fire the main engine,</li> <li>Action 3: Fire right orientation engine.</li>",aa,gt,jr="Reward function (the function that will gives a reward at each timestep) 💰:",ia,bt,Ur="After every step a reward is granted. The total reward of an episode is the <strong>sum of the rewards for all the steps within that episode</strong>.",oa,wt,Jr="For each step, the reward:",ra,Tt,Cr="<li>Is increased/decreased the closer/further the lander is to the landing pad.</li> <li>Is increased/decreased the slower/faster the lander is moving.</li> <li>Is decreased the more the lander is tilted (angle not horizontal).</li> <li>Is increased by 10 points for each leg that is in contact with the ground.</li> <li>Is decreased by 0.03 points each frame a side engine is firing.</li> <li>Is decreased by 0.3 points each frame the main engine is firing.</li>",pa,vt,Ir="The episode receive an <strong>additional reward of -100 or +100 points for crashing or landing safely respectively.</strong>",ma,jt,$r="An episode is <strong>considered a solution if it scores at least 200 points.</strong>",ua,Ut,Ma,Jt,Zr="<li>We create a vectorized environment (a method for stacking multiple independent environments into a single environment) of 16 environments, this way, <strong>we’ll have more diverse experiences during the training.</strong></li>",ha,Ct,da,It,ca,$t,_r='<li><p>We have studied our environment and we understood the problem: <strong>being able to land the Lunar Lander to the Landing Pad correctly by controlling left, right and main orientation engine</strong>. Now let’s build the algorithm we’re going to use to solve this Problem 🚀.</p></li> <li><p>To do so, we’re going to use our first Deep RL library, <a href="https://stable-baselines3.readthedocs.io/en/master/" rel="nofollow">Stable Baselines3 (SB3)</a>.</p></li> <li><p>SB3 is a set of <strong>reliable implementations of reinforcement learning algorithms in PyTorch</strong>.</p></li>',ya,fa,ga,Zt,Br='💡 A good habit when using a new library is to dive first on the documentation: <a href="https://stable-baselines3.readthedocs.io/en/master/" rel="nofollow">https://stable-baselines3.readthedocs.io/en/master/</a> and then try some tutorials.',ba,wa,Ta,_t,Wr,va,Bt,Lr='To solve this problem, we’re going to use SB3 <strong>PPO</strong>. <a href="https://stable-baselines3.readthedocs.io/en/master/modules/ppo.html#example%5D" rel="nofollow">PPO (aka Proximal Policy Optimization) is one of the SOTA (state of the art) Deep Reinforcement Learning algorithms that you’ll study during this course</a>.',ja,Wt,Hr="PPO is a combination of:",Ua,Lt,xr="<li><em>Value-based reinforcement learning method</em>: learning an action-value function that will tell us the <strong>most valuable action to take given a state and action</strong>.</li> <li><em>Policy-based reinforcement learning method</em>: learning a policy that will <strong>give us a probability distribution over actions</strong>.</li>",Ja,Ht,kr="Stable-Baselines3 is easy to set up:",Ca,xt,Gr="1️⃣ You <strong>create your environment</strong> (in our case it was done above)",Ia,kt,Rr="2️⃣ You define the <strong>model you want to use and instantiate this model</strong> <code>model = PPO(&quot;MlpPolicy&quot;)</code>",$a,Gt,Yr="3️⃣ You <strong>train the agent</strong> with <code>model.learn</code> and define the number of training timesteps",Za,Rt,_a,Yt,Ba,Et,Wa,Xt,La,Vt,Ha,St,Er="<li>Let’s train our agent for 1,000,000 timesteps, don’t forget to use GPU on Colab. It will take approximately ~20min, but you can use fewer timesteps if you just want to try it out.</li> <li>During the training, take a ☕ break you deserved it 🤗</li>",xa,Ft,ka,Qt,Ga,zt,Ra,Pt,Ya,At,Xr='<li>Remember to wrap the environment in a <a href="https://stable-baselines3.readthedocs.io/en/master/common/monitor.html" rel="nofollow">Monitor</a>.</li> <li>Now that our Lunar Lander agent is trained 🚀, we need to <strong>check its performance</strong>.</li> <li>Stable-Baselines3 provides a method to do that: <code>evaluate_policy</code>.</li> <li>To fill that part you need to <a href="https://stable-baselines3.readthedocs.io/en/master/guide/examples.html#basic-usage-training-saving-loading" rel="nofollow">check the documentation</a></li> <li>In the next step,  we’ll see <strong>how to automatically evaluate and share your agent to compete in a leaderboard, but for now let’s do it ourselves</strong></li>',Ea,Nt,Vr="💡 When you evaluate your agent, you should not use your training environment but create an evaluation environment.",Xa,Dt,Va,qt,Sa,Ot,Fa,Kt,Sr="<li>In my case, I got a mean reward is <code>200.20 +/- 20.80</code> after training for 1 million steps, which means that our lunar lander agent is ready to land on the moon 🌛🥳.</li>",Qa,el,za,tl,Fr="Now that we saw we got good results after the training, we can publish our trained model on the hub 🤗 with one line of code.",Pa,ll,Qr='📚 The libraries documentation 👉 <a href="https://github.com/huggingface/huggingface_sb3/tree/main#hugging-face--x-stable-baselines3-v20" rel="nofollow">https://github.com/huggingface/huggingface_sb3/tree/main#hugging-face—x-stable-baselines3-v20</a>',Aa,nl,zr="Here’s an example of a Model Card (with Space Invaders):",Na,sl,Pr="By using <code>package_to_hub</code> <strong>you evaluate, record a replay, generate a model card of your agent and push it to the hub</strong>.",Da,al,Ar="This way:",qa,il,Nr='<li>You can <strong>showcase our work</strong> 🔥</li> <li>You can <strong>visualize your agent playing</strong> 👀</li> <li>You can <strong>share with the community an agent that others can use</strong> 💾</li> <li>You can <strong>access a leaderboard 🏆 to see how well your agent is performing compared to your classmates</strong> 👉 <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard</a></li>',Oa,ol,Dr="To be able to share your model with the community there are three more steps to follow:",Ka,rl,qr='1️⃣ (If it’s not already done) create an account on Hugging Face ➡ <a href="https://huggingface.co/join" rel="nofollow">https://huggingface.co/join</a>',ei,pl,Or="2️⃣ Sign in and then, you need to store your authentication token from the Hugging Face website.",ti,ml,Kr='<li>Create a new token (<a href="https://huggingface.co/settings/tokens" rel="nofollow">https://huggingface.co/settings/tokens</a>) <strong>with write role</strong></li>',li,ul,ep,ni,Ml,tp="<li>Copy the token</li> <li>Run the cell below and paste the token</li>",si,hl,ai,dl,lp="If you don’t want to use a Google Colab or a Jupyter Notebook, you need to use this command instead: <code>huggingface-cli login</code>",ii,cl,np="3️⃣ We’re now ready to push our trained agent to the 🤗 Hub 🔥 using <code>package_to_hub()</code> function",oi,yl,sp="Let’s fill the <code>package_to_hub</code> function:",ri,fl,ap="<li><code>model</code>: our trained model.</li> <li><code>model_name</code>: the name of the trained model that we defined in <code>model_save</code></li> <li><code>model_architecture</code>: the model architecture we used, in our case PPO</li> <li><code>env_id</code>: the name of the environment, in our case <code>LunarLander-v2</code></li> <li><code>eval_env</code>: the evaluation environment defined in eval_env</li> <li><code>repo_id</code>: the name of the Hugging Face Hub Repository that will be created/updated <code>(repo_id = {username}/{repo_name})</code></li>",pi,gl,ip="💡 <strong>A good name is <code>{username}/{model_architecture}-{env_id}</code></strong>",mi,bl,op="<li><code>commit_message</code>: message of the commit</li>",ui,wl,Mi,Tl,hi,vl,di,jl,rp='Congrats 🥳 you’ve just trained and uploaded your first Deep Reinforcement Learning agent. The script above should have displayed a link to a model repository such as <a href="https://huggingface.co/osanseviero/test_sb3" rel="nofollow">https://huggingface.co/osanseviero/test_sb3</a>. When you go to this link, you can:',ci,Ul,pp="<li>See a video preview of your agent at the right.</li> <li>Click “Files and versions” to see all the files in the repository.</li> <li>Click “Use in stable-baselines3” to get a code snippet that shows how to load the model.</li> <li>A model card (<code>README.md</code> file) which gives a description of the model</li>",yi,Jl,mp="Under the hood, the Hub uses git-based repositories (don’t worry if you don’t know what git is), which means you can update the model with new versions as you experiment and improve your agent.",fi,Cl,up='Compare the results of your LunarLander-v2 with your classmates using the leaderboard 🏆 👉 <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard</a>',gi,Il,bi,$l,Mp='Thanks to <a href="https://github.com/ironbar" rel="nofollow">ironbar</a> for the contribution.',wi,Zl,hp="Loading a saved model from the Hub is really easy.",Ti,_l,dp='You go to <a href="https://huggingface.co/models?library=stable-baselines3" rel="nofollow">https://huggingface.co/models?library=stable-baselines3</a> to see the list of all the Stable-baselines3 saved models.',vi,Bl,cp="<li>You select one and copy its repo_id</li>",ji,Wl,yp,Ui,j,fp="<li>Then we just need to use load_from_hub with:</li>",Ji,Ll,gp="<li>The repo_id</li> <li>The filename: the saved model inside the repo and its extension (*.zip)</li>",Ci,Hl,bp="Because the model I download from the Hub was trained with Gym (the former version of Gymnasium) we need to install shimmy a API conversion tool that will help us to run the environment correctly.",Ii,xl,wp='Shimmy Documentation: <a href="https://github.com/Farama-Foundation/Shimmy" rel="nofollow">https://github.com/Farama-Foundation/Shimmy</a>',$i,kl,Zi,Gl,_i,Rl,Tp="Let’s evaluate this agent:",Bi,Yl,Wi,El,Li,Xl,vp="The best way to learn <strong>is to try things by your own</strong>! As you saw, the current agent is not doing great. As a first suggestion, you can train for more steps. With 1,000,000 steps, we saw some great results!",Hi,Vl,jp='In the <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">Leaderboard</a> you will find your agents. Can you get to the top?',xi,Sl,Up="Here are some ideas to achieve so:",ki,Fl,Jp='<li>Train more steps</li> <li>Try different hyperparameters for <code>PPO</code>. You can see them at <a href="https://stable-baselines3.readthedocs.io/en/master/modules/ppo.html#parameters" rel="nofollow">https://stable-baselines3.readthedocs.io/en/master/modules/ppo.html#parameters</a>.</li> <li>Check the <a href="https://stable-baselines3.readthedocs.io/en/master/modules/dqn.html" rel="nofollow">Stable-Baselines3 documentation</a> and try another model such as DQN.</li> <li><strong>Push your new trained model</strong> on the Hub 🔥</li>',Gi,Ql,Cp='<strong>Compare the results of your LunarLander-v2 with your classmates</strong> using the <a href="https://huggingface.co/spaces/huggingface-projects/Deep-Reinforcement-Learning-Leaderboard" rel="nofollow">leaderboard</a> 🏆',Ri,zl,Ip='Is moon landing too boring for you? Try to <strong>change the environment</strong>, why not use MountainCar-v0, CartPole-v1 or CarRacing-v0? Check how they work <a href="https://www.gymlibrary.dev/" rel="nofollow">using the gym documentation</a> and have fun 🎉.',Yi,Ei,Xi,Pl,$p="Congrats on finishing this chapter! That was the biggest one, <strong>and there was a lot of information.</strong>",Vi,Al,Zp="If you’re still feel confused with all these elements…it’s totally normal! <strong>This was the same for me and for all people who studied RL.</strong>",Si,Nl,_p="Take time to really <strong>grasp the material before continuing and try the additional challenges</strong>. It’s important to master these elements and have a solid foundations.",Fi,Dl,Bp="Naturally, during the course, we’re going to dive deeper into these concepts but <strong>it’s better to have a good understanding of them now before diving into the next chapters.</strong>",Qi,ql,Wp="Next time, in the bonus unit 1, you’ll train Huggy the Dog to fetch the stick.",zi,Ol,Lp,Pi,Kl,Ai,tn,Ni;return U=new y({props:{title:"Train your first Deep Reinforcement Learning Agent 🤖",local:"hands-on",headingTag:"h1"}}),J=new Vp({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/deep-rl-class/blob/master/notebooks/unit1/unit1.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),E=new y({props:{title:"Unit 1: Train your first Deep Reinforcement Learning Agent 🤖",local:"unit-1-train-your-first-deep-reinforcement-learning-agent-",headingTag:"h1"}}),V=new y({props:{title:"The environment 🎮",local:"the-environment-",headingTag:"h3"}}),F=new y({props:{title:"The library used 📚",local:"the-library-used-",headingTag:"h3"}}),P=new y({props:{title:"Objectives of this notebook 🏆",local:"objectives-of-this-notebook-",headingTag:"h2"}}),D=new y({props:{title:"This notebook is from Deep Reinforcement Learning Course",local:"this-notebook-is-from-deep-reinforcement-learning-course",headingTag:"h2"}}),se=new y({props:{title:"Prerequisites 🏗️",local:"prerequisites-",headingTag:"h2"}}),re=new y({props:{title:"A small recap of Deep Reinforcement Learning 📚",local:"a-small-recap-of-deep-reinforcement-learning-",headingTag:"h2"}}),he=new y({props:{title:"Let’s train our first Deep Reinforcement Learning agent and upload it to the Hub 🚀",local:"lets-train-our-first-deep-reinforcement-learning-agent-and-upload-it-to-the-hub-",headingTag:"h1"}}),de=new y({props:{title:"Get a certificate 🎓",local:"get-a-certificate-",headingTag:"h2"}}),ge=new y({props:{title:"Set the GPU 💪",local:"set-the-gpu-",headingTag:"h2"}}),je=new y({props:{title:"Install dependencies and create a virtual screen 🔽",local:"install-dependencies-and-create-a-virtual-screen-",headingTag:"h2"}}),Ie=new f({props:{code:"YXB0JTIwaW5zdGFsbCUyMHN3aWclMjBjbWFrZQ==",highlighted:"apt install swig cmake",wrap:!1}}),$e=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1yJTIwaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGaHVnZ2luZ2ZhY2UlMkZkZWVwLXJsLWNsYXNzJTJGbWFpbiUyRm5vdGVib29rcyUyRnVuaXQxJTJGcmVxdWlyZW1lbnRzLXVuaXQxLnR4dA==",highlighted:"pip install -r https://raw.githubusercontent.com/huggingface/deep-rl-class/main/notebooks/unit1/requirements-unit1.txt",wrap:!1}}),Be=new f({props:{code:"c3VkbyUyMGFwdC1nZXQlMjB1cGRhdGUlMEFhcHQlMjBpbnN0YWxsJTIwcHl0aG9uLW9wZW5nbCUwQWFwdCUyMGluc3RhbGwlMjBmZm1wZWclMEFhcHQlMjBpbnN0YWxsJTIweHZmYiUwQXBpcDMlMjBpbnN0YWxsJTIwcHl2aXJ0dWFsZGlzcGxheQ==",highlighted:`sudo apt-get update
apt install python-opengl
apt install ffmpeg
apt install xvfb
pip3 install pyvirtualdisplay`,wrap:!1}}),Le=new f({props:{code:"aW1wb3J0JTIwb3MlMEElMEFvcy5raWxsKG9zLmdldHBpZCgpJTJDJTIwOSk=",highlighted:`<span class="hljs-keyword">import</span> os

os.kill(os.getpid(), <span class="hljs-number">9</span>)`,wrap:!1}}),He=new f({props:{code:"JTIzJTIwVmlydHVhbCUyMGRpc3BsYXklMEFmcm9tJTIwcHl2aXJ0dWFsZGlzcGxheSUyMGltcG9ydCUyMERpc3BsYXklMEElMEF2aXJ0dWFsX2Rpc3BsYXklMjAlM0QlMjBEaXNwbGF5KHZpc2libGUlM0QwJTJDJTIwc2l6ZSUzRCgxNDAwJTJDJTIwOTAwKSklMEF2aXJ0dWFsX2Rpc3BsYXkuc3RhcnQoKQ==",highlighted:`<span class="hljs-comment"># Virtual display</span>
<span class="hljs-keyword">from</span> pyvirtualdisplay <span class="hljs-keyword">import</span> Display

virtual_display = Display(visible=<span class="hljs-number">0</span>, size=(<span class="hljs-number">1400</span>, <span class="hljs-number">900</span>))
virtual_display.start()`,wrap:!1}}),xe=new y({props:{title:"Import the packages 📦",local:"import-the-packages-",headingTag:"h2"}}),Ye=new f({props:{code:"aW1wb3J0JTIwZ3ltbmFzaXVtJTBBJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX3NiMyUyMGltcG9ydCUyMGxvYWRfZnJvbV9odWIlMkMlMjBwYWNrYWdlX3RvX2h1YiUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwbm90ZWJvb2tfbG9naW4lMkMlMEEpJTIwJTIwJTIzJTIwVG8lMjBsb2clMjB0byUyMG91ciUyMEh1Z2dpbmclMjBGYWNlJTIwYWNjb3VudCUyMHRvJTIwYmUlMjBhYmxlJTIwdG8lMjB1cGxvYWQlMjBtb2RlbHMlMjB0byUyMHRoZSUyMEh1Yi4lMEElMEFmcm9tJTIwc3RhYmxlX2Jhc2VsaW5lczMlMjBpbXBvcnQlMjBQUE8lMEFmcm9tJTIwc3RhYmxlX2Jhc2VsaW5lczMuY29tbW9uLmVudl91dGlsJTIwaW1wb3J0JTIwbWFrZV92ZWNfZW52JTBBZnJvbSUyMHN0YWJsZV9iYXNlbGluZXMzLmNvbW1vbi5ldmFsdWF0aW9uJTIwaW1wb3J0JTIwZXZhbHVhdGVfcG9saWN5JTBBZnJvbSUyMHN0YWJsZV9iYXNlbGluZXMzLmNvbW1vbi5tb25pdG9yJTIwaW1wb3J0JTIwTW9uaXRvcg==",highlighted:`<span class="hljs-keyword">import</span> gymnasium

<span class="hljs-keyword">from</span> huggingface_sb3 <span class="hljs-keyword">import</span> load_from_hub, package_to_hub
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> (
    notebook_login,
)  <span class="hljs-comment"># To log to our Hugging Face account to be able to upload models to the Hub.</span>

<span class="hljs-keyword">from</span> stable_baselines3 <span class="hljs-keyword">import</span> PPO
<span class="hljs-keyword">from</span> stable_baselines3.common.env_util <span class="hljs-keyword">import</span> make_vec_env
<span class="hljs-keyword">from</span> stable_baselines3.common.evaluation <span class="hljs-keyword">import</span> evaluate_policy
<span class="hljs-keyword">from</span> stable_baselines3.common.monitor <span class="hljs-keyword">import</span> Monitor`,wrap:!1}}),Ee=new y({props:{title:"Understand Gymnasium and how it works 🤖",local:"understand-gymnasium-and-how-it-works-",headingTag:"h2"}}),at=new f({props:{code:"aW1wb3J0JTIwZ3ltbmFzaXVtJTIwYXMlMjBneW0lMEElMEElMjMlMjBGaXJzdCUyQyUyMHdlJTIwY3JlYXRlJTIwb3VyJTIwZW52aXJvbm1lbnQlMjBjYWxsZWQlMjBMdW5hckxhbmRlci12MiUwQWVudiUyMCUzRCUyMGd5bS5tYWtlKCUyMkx1bmFyTGFuZGVyLXYyJTIyKSUwQSUwQSUyMyUyMFRoZW4lMjB3ZSUyMHJlc2V0JTIwdGhpcyUyMGVudmlyb25tZW50JTBBb2JzZXJ2YXRpb24lMkMlMjBpbmZvJTIwJTNEJTIwZW52LnJlc2V0KCklMEElMEFmb3IlMjBfJTIwaW4lMjByYW5nZSgyMCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBUYWtlJTIwYSUyMHJhbmRvbSUyMGFjdGlvbiUwQSUyMCUyMCUyMCUyMGFjdGlvbiUyMCUzRCUyMGVudi5hY3Rpb25fc3BhY2Uuc2FtcGxlKCklMEElMjAlMjAlMjAlMjBwcmludCglMjJBY3Rpb24lMjB0YWtlbiUzQSUyMiUyQyUyMGFjdGlvbiklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBEbyUyMHRoaXMlMjBhY3Rpb24lMjBpbiUyMHRoZSUyMGVudmlyb25tZW50JTIwYW5kJTIwZ2V0JTBBJTIwJTIwJTIwJTIwJTIzJTIwbmV4dF9zdGF0ZSUyQyUyMHJld2FyZCUyQyUyMHRlcm1pbmF0ZWQlMkMlMjB0cnVuY2F0ZWQlMjBhbmQlMjBpbmZvJTBBJTIwJTIwJTIwJTIwb2JzZXJ2YXRpb24lMkMlMjByZXdhcmQlMkMlMjB0ZXJtaW5hdGVkJTJDJTIwdHJ1bmNhdGVkJTJDJTIwaW5mbyUyMCUzRCUyMGVudi5zdGVwKGFjdGlvbiklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBJZiUyMHRoZSUyMGdhbWUlMjBpcyUyMHRlcm1pbmF0ZWQlMjAoaW4lMjBvdXIlMjBjYXNlJTIwd2UlMjBsYW5kJTJDJTIwY3Jhc2hlZCklMjBvciUyMHRydW5jYXRlZCUyMCh0aW1lb3V0KSUwQSUyMCUyMCUyMCUyMGlmJTIwdGVybWluYXRlZCUyMG9yJTIwdHJ1bmNhdGVkJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwUmVzZXQlMjB0aGUlMjBlbnZpcm9ubWVudCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCUyMkVudmlyb25tZW50JTIwaXMlMjByZXNldCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvYnNlcnZhdGlvbiUyQyUyMGluZm8lMjAlM0QlMjBlbnYucmVzZXQoKSUwQSUwQWVudi5jbG9zZSgp",highlighted:`<span class="hljs-keyword">import</span> gymnasium <span class="hljs-keyword">as</span> gym

<span class="hljs-comment"># First, we create our environment called LunarLander-v2</span>
env = gym.make(<span class="hljs-string">&quot;LunarLander-v2&quot;</span>)

<span class="hljs-comment"># Then we reset this environment</span>
observation, info = env.reset()

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">20</span>):
    <span class="hljs-comment"># Take a random action</span>
    action = env.action_space.sample()
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Action taken:&quot;</span>, action)

    <span class="hljs-comment"># Do this action in the environment and get</span>
    <span class="hljs-comment"># next_state, reward, terminated, truncated and info</span>
    observation, reward, terminated, truncated, info = env.step(action)

    <span class="hljs-comment"># If the game is terminated (in our case we land, crashed) or truncated (timeout)</span>
    <span class="hljs-keyword">if</span> terminated <span class="hljs-keyword">or</span> truncated:
        <span class="hljs-comment"># Reset the environment</span>
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Environment is reset&quot;</span>)
        observation, info = env.reset()

env.close()`,wrap:!1}}),it=new y({props:{title:"Create the LunarLander environment 🌛 and understand how it works",local:"create-the-lunarlander-environment--and-understand-how-it-works",headingTag:"h2"}}),ot=new y({props:{title:"The environment 🎮",local:"the-environment-",headingTag:"h3"}}),Mt=new f({props:{code:"JTIzJTIwV2UlMjBjcmVhdGUlMjBvdXIlMjBlbnZpcm9ubWVudCUyMHdpdGglMjBneW0ubWFrZSglMjIlM0NuYW1lX29mX3RoZV9lbnZpcm9ubWVudCUzRSUyMiklMEFlbnYlMjAlM0QlMjBneW0ubWFrZSglMjJMdW5hckxhbmRlci12MiUyMiklMEFlbnYucmVzZXQoKSUwQXByaW50KCUyMl9fX19fT0JTRVJWQVRJT04lMjBTUEFDRV9fX19fJTIwJTVDbiUyMiklMEFwcmludCglMjJPYnNlcnZhdGlvbiUyMFNwYWNlJTIwU2hhcGUlMjIlMkMlMjBlbnYub2JzZXJ2YXRpb25fc3BhY2Uuc2hhcGUpJTBBcHJpbnQoJTIyU2FtcGxlJTIwb2JzZXJ2YXRpb24lMjIlMkMlMjBlbnYub2JzZXJ2YXRpb25fc3BhY2Uuc2FtcGxlKCkpJTIwJTIwJTIzJTIwR2V0JTIwYSUyMHJhbmRvbSUyMG9ic2VydmF0aW9u",highlighted:`<span class="hljs-comment"># We create our environment with gym.make(&quot;&lt;name_of_the_environment&gt;&quot;)</span>
env = gym.make(<span class="hljs-string">&quot;LunarLander-v2&quot;</span>)
env.reset()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;_____OBSERVATION SPACE_____ \\n&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Observation Space Shape&quot;</span>, env.observation_space.shape)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Sample observation&quot;</span>, env.observation_space.sample())  <span class="hljs-comment"># Get a random observation</span>`,wrap:!1}}),ct=new f({props:{code:"cHJpbnQoJTIyJTVDbiUyMF9fX19fQUNUSU9OJTIwU1BBQ0VfX19fXyUyMCU1Q24lMjIpJTBBcHJpbnQoJTIyQWN0aW9uJTIwU3BhY2UlMjBTaGFwZSUyMiUyQyUyMGVudi5hY3Rpb25fc3BhY2UubiklMEFwcmludCglMjJBY3Rpb24lMjBTcGFjZSUyMFNhbXBsZSUyMiUyQyUyMGVudi5hY3Rpb25fc3BhY2Uuc2FtcGxlKCkpJTIwJTIwJTIzJTIwVGFrZSUyMGElMjByYW5kb20lMjBhY3Rpb24=",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n _____ACTION SPACE_____ \\n&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Action Space Shape&quot;</span>, env.action_space.n)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Action Space Sample&quot;</span>, env.action_space.sample())  <span class="hljs-comment"># Take a random action</span>`,wrap:!1}}),Ut=new y({props:{title:"Vectorized Environment",local:"vectorized-environment",headingTag:"h4"}}),Ct=new f({props:{code:"JTIzJTIwQ3JlYXRlJTIwdGhlJTIwZW52aXJvbm1lbnQlMEFlbnYlMjAlM0QlMjBtYWtlX3ZlY19lbnYoJTIyTHVuYXJMYW5kZXItdjIlMjIlMkMlMjBuX2VudnMlM0QxNik=",highlighted:`<span class="hljs-comment"># Create the environment</span>
env = make_vec_env(<span class="hljs-string">&quot;LunarLander-v2&quot;</span>, n_envs=<span class="hljs-number">16</span>)`,wrap:!1}}),It=new y({props:{title:"Create the Model 🤖",local:"create-the-model-",headingTag:"h2"}}),Rt=new f({props:{code:"JTIzJTIwQ3JlYXRlJTIwZW52aXJvbm1lbnQlMEFlbnYlMjAlM0QlMjBneW0ubWFrZSgnTHVuYXJMYW5kZXItdjInKSUwQSUwQSUyMyUyMEluc3RhbnRpYXRlJTIwdGhlJTIwYWdlbnQlMEFtb2RlbCUyMCUzRCUyMFBQTygnTWxwUG9saWN5JyUyQyUyMGVudiUyQyUyMHZlcmJvc2UlM0QxKSUwQSUyMyUyMFRyYWluJTIwdGhlJTIwYWdlbnQlMEFtb2RlbC5sZWFybih0b3RhbF90aW1lc3RlcHMlM0RpbnQoMmU1KSk=",highlighted:`<span class="hljs-comment"># Create environment</span>
env = gym.make(<span class="hljs-string">&#x27;LunarLander-v2&#x27;</span>)

<span class="hljs-comment"># Instantiate the agent</span>
model = PPO(<span class="hljs-string">&#x27;MlpPolicy&#x27;</span>, env, <span class="hljs-attribute">verbose</span>=1)
<span class="hljs-comment"># Train the agent</span>
model.learn(<span class="hljs-attribute">total_timesteps</span>=int(2e5))`,wrap:!1}}),Yt=new f({props:{code:"JTIzJTIwVE9ETyUzQSUyMERlZmluZSUyMGElMjBQUE8lMjBNbHBQb2xpY3klMjBhcmNoaXRlY3R1cmUlMEElMjMlMjBXZSUyMHVzZSUyME11bHRpTGF5ZXJQZXJjZXB0cm9uJTIwKE1MUFBvbGljeSklMjBiZWNhdXNlJTIwdGhlJTIwaW5wdXQlMjBpcyUyMGElMjB2ZWN0b3IlMkMlMEElMjMlMjBpZiUyMHdlJTIwaGFkJTIwZnJhbWVzJTIwYXMlMjBpbnB1dCUyMHdlJTIwd291bGQlMjB1c2UlMjBDbm5Qb2xpY3klMEFtb2RlbCUyMCUzRA==",highlighted:`<span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Define a PPO MlpPolicy architecture</span>
<span class="hljs-comment"># We use MultiLayerPerceptron (MLPPolicy) because the input is a vector,</span>
<span class="hljs-comment"># if we had frames as input we would use CnnPolicy</span>
model =`,wrap:!1}}),Et=new y({props:{title:"Solution",local:"solution",headingTag:"h4"}}),Xt=new f({props:{code:"JTIzJTIwU09MVVRJT04lMEElMjMlMjBXZSUyMGFkZGVkJTIwc29tZSUyMHBhcmFtZXRlcnMlMjB0byUyMGFjY2VsZXJhdGUlMjB0aGUlMjB0cmFpbmluZyUwQW1vZGVsJTIwJTNEJTIwUFBPKCUwQSUyMCUyMCUyMCUyMHBvbGljeSUzRCUyMk1scFBvbGljeSUyMiUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRGVudiUyQyUwQSUyMCUyMCUyMCUyMG5fc3RlcHMlM0QxMDI0JTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzRDY0JTJDJTBBJTIwJTIwJTIwJTIwbl9lcG9jaHMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwZ2FtbWElM0QwLjk5OSUyQyUwQSUyMCUyMCUyMCUyMGdhZV9sYW1iZGElM0QwLjk4JTJDJTBBJTIwJTIwJTIwJTIwZW50X2NvZWYlM0QwLjAxJTJDJTBBJTIwJTIwJTIwJTIwdmVyYm9zZSUzRDElMkMlMEEp",highlighted:`<span class="hljs-comment"># SOLUTION</span>
<span class="hljs-comment"># We added some parameters to accelerate the training</span>
model = PPO(
    policy=<span class="hljs-string">&quot;MlpPolicy&quot;</span>,
    env=env,
    n_steps=<span class="hljs-number">1024</span>,
    batch_size=<span class="hljs-number">64</span>,
    n_epochs=<span class="hljs-number">4</span>,
    gamma=<span class="hljs-number">0.999</span>,
    gae_lambda=<span class="hljs-number">0.98</span>,
    ent_coef=<span class="hljs-number">0.01</span>,
    verbose=<span class="hljs-number">1</span>,
)`,wrap:!1}}),Vt=new y({props:{title:"Train the PPO agent 🏃",local:"train-the-ppo-agent-",headingTag:"h2"}}),Ft=new f({props:{code:"JTIzJTIwVE9ETyUzQSUyMFRyYWluJTIwaXQlMjBmb3IlMjAxJTJDMDAwJTJDMDAwJTIwdGltZXN0ZXBzJTBBJTBBJTIzJTIwVE9ETyUzQSUyMFNwZWNpZnklMjBmaWxlJTIwbmFtZSUyMGZvciUyMG1vZGVsJTIwYW5kJTIwc2F2ZSUyMHRoZSUyMG1vZGVsJTIwdG8lMjBmaWxlJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMiUyMg==",highlighted:`<span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Train it for 1,000,000 timesteps</span>

<span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Specify file name for model and save the model to file</span>
model_name = <span class="hljs-string">&quot;&quot;</span>`,wrap:!1}}),Qt=new y({props:{title:"Solution",local:"solution",headingTag:"h4"}}),zt=new f({props:{code:"JTIzJTIwU09MVVRJT04lMEElMjMlMjBUcmFpbiUyMGl0JTIwZm9yJTIwMSUyQzAwMCUyQzAwMCUyMHRpbWVzdGVwcyUwQW1vZGVsLmxlYXJuKHRvdGFsX3RpbWVzdGVwcyUzRDEwMDAwMDApJTBBJTIzJTIwU2F2ZSUyMHRoZSUyMG1vZGVsJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMnBwby1MdW5hckxhbmRlci12MiUyMiUwQW1vZGVsLnNhdmUobW9kZWxfbmFtZSk=",highlighted:`<span class="hljs-comment"># SOLUTION</span>
<span class="hljs-comment"># Train it for 1,000,000 timesteps</span>
model.learn(total_timesteps=<span class="hljs-number">1000000</span>)
<span class="hljs-comment"># Save the model</span>
model_name = <span class="hljs-string">&quot;ppo-LunarLander-v2&quot;</span>
model.save(model_name)`,wrap:!1}}),Pt=new y({props:{title:"Evaluate the agent 📈",local:"evaluate-the-agent-",headingTag:"h2"}}),Dt=new f({props:{code:"JTIzJTIwVE9ETyUzQSUyMEV2YWx1YXRlJTIwdGhlJTIwYWdlbnQlMEElMjMlMjBDcmVhdGUlMjBhJTIwbmV3JTIwZW52aXJvbm1lbnQlMjBmb3IlMjBldmFsdWF0aW9uJTBBZXZhbF9lbnYlMjAlM0QlMEElMEElMjMlMjBFdmFsdWF0ZSUyMHRoZSUyMG1vZGVsJTIwd2l0aCUyMDEwJTIwZXZhbHVhdGlvbiUyMGVwaXNvZGVzJTIwYW5kJTIwZGV0ZXJtaW5pc3RpYyUzRFRydWUlMEFtZWFuX3Jld2FyZCUyQyUyMHN0ZF9yZXdhcmQlMjAlM0QlMjAlMEElMEElMjMlMjBQcmludCUyMHRoZSUyMHJlc3VsdHM=",highlighted:`<span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Evaluate the agent</span>
<span class="hljs-comment"># Create a new environment for evaluation</span>
eval_env =

<span class="hljs-comment"># Evaluate the model with 10 evaluation episodes and deterministic=True</span>
mean_reward, std_reward = 

<span class="hljs-comment"># Print the results</span>`,wrap:!1}}),qt=new y({props:{title:"Solution",local:"solution",headingTag:"h4"}}),Ot=new f({props:{code:"JTIzJTIwJTQwdGl0bGUlMEFldmFsX2VudiUyMCUzRCUyME1vbml0b3IoZ3ltLm1ha2UoJTIyTHVuYXJMYW5kZXItdjIlMjIpKSUwQW1lYW5fcmV3YXJkJTJDJTIwc3RkX3Jld2FyZCUyMCUzRCUyMGV2YWx1YXRlX3BvbGljeShtb2RlbCUyQyUyMGV2YWxfZW52JTJDJTIwbl9ldmFsX2VwaXNvZGVzJTNEMTAlMkMlMjBkZXRlcm1pbmlzdGljJTNEVHJ1ZSklMEFwcmludChmJTIybWVhbl9yZXdhcmQlM0QlN0JtZWFuX3Jld2FyZCUzQS4yZiU3RCUyMCUyQiUyRi0lMjAlN0JzdGRfcmV3YXJkJTdEJTIyKQ==",highlighted:`<span class="hljs-comment"># @title</span>
eval_env = Monitor(gym.make(<span class="hljs-string">&quot;LunarLander-v2&quot;</span>))
mean_reward, std_reward = evaluate_policy(model, eval_env, n_eval_episodes=<span class="hljs-number">10</span>, deterministic=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;mean_reward=<span class="hljs-subst">{mean_reward:<span class="hljs-number">.2</span>f}</span> +/- <span class="hljs-subst">{std_reward}</span>&quot;</span>)`,wrap:!1}}),el=new y({props:{title:"Publish our trained model on the Hub 🔥",local:"publish-our-trained-model-on-the-hub-",headingTag:"h2"}}),hl=new f({props:{code:"bm90ZWJvb2tfbG9naW4oKSUwQSFnaXQlMjBjb25maWclMjAtLWdsb2JhbCUyMGNyZWRlbnRpYWwuaGVscGVyJTIwc3RvcmU=",highlighted:`notebook_login()
!git config --<span class="hljs-keyword">global</span> credential.helper store`,wrap:!1}}),wl=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> gymnasium <span class="hljs-keyword">as</span> gym
<span class="hljs-keyword">from</span> stable_baselines3.common.vec_env <span class="hljs-keyword">import</span> DummyVecEnv
<span class="hljs-keyword">from</span> stable_baselines3.common.env_util <span class="hljs-keyword">import</span> make_vec_env

<span class="hljs-keyword">from</span> huggingface_sb3 <span class="hljs-keyword">import</span> package_to_hub

<span class="hljs-comment">## <span class="hljs-doctag">TODO:</span> Define a repo_id</span>
<span class="hljs-comment">## repo_id is the id of the model repository from the Hugging Face Hub (repo_id = {organization}/{repo_name} for instance ThomasSimonini/ppo-LunarLander-v2</span>
repo_id = 

<span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Define the name of the environment</span>
env_id = 

<span class="hljs-comment"># Create the evaluation env and set the render_mode=&quot;rgb_array&quot;</span>
eval_env = DummyVecEnv([<span class="hljs-keyword">lambda</span>: gym.make(env_id, render_mode=<span class="hljs-string">&quot;rgb_array&quot;</span>)])


<span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Define the model architecture we used</span>
model_architecture = <span class="hljs-string">&quot;&quot;</span>

<span class="hljs-comment">## <span class="hljs-doctag">TODO:</span> Define the commit message</span>
commit_message = <span class="hljs-string">&quot;&quot;</span>

<span class="hljs-comment"># method save, evaluate, generate a model card and record a replay video of your agent before pushing the repo to the hub</span>
package_to_hub(model=model, <span class="hljs-comment"># Our trained model</span>
               model_name=model_name, <span class="hljs-comment"># The name of our trained model </span>
               model_architecture=model_architecture, <span class="hljs-comment"># The model architecture we used: in our case PPO</span>
               env_id=env_id, <span class="hljs-comment"># Name of the environment</span>
               eval_env=eval_env, <span class="hljs-comment"># Evaluation Environment</span>
               repo_id=repo_id, <span class="hljs-comment"># id of the model repository from the Hugging Face Hub (repo_id = {organization}/{repo_name} for instance ThomasSimonini/ppo-LunarLander-v2</span>
               commit_message=commit_message)`,wrap:!1}}),Tl=new y({props:{title:"Solution",local:"solution",headingTag:"h4"}}),vl=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> gymnasium <span class="hljs-keyword">as</span> gym

<span class="hljs-keyword">from</span> stable_baselines3 <span class="hljs-keyword">import</span> PPO
<span class="hljs-keyword">from</span> stable_baselines3.common.vec_env <span class="hljs-keyword">import</span> DummyVecEnv
<span class="hljs-keyword">from</span> stable_baselines3.common.env_util <span class="hljs-keyword">import</span> make_vec_env

<span class="hljs-keyword">from</span> huggingface_sb3 <span class="hljs-keyword">import</span> package_to_hub

<span class="hljs-comment"># PLACE the variables you&#x27;ve just defined two cells above</span>
<span class="hljs-comment"># Define the name of the environment</span>
env_id = <span class="hljs-string">&quot;LunarLander-v2&quot;</span>

<span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> Define the model architecture we used</span>
model_architecture = <span class="hljs-string">&quot;PPO&quot;</span>

<span class="hljs-comment">## Define a repo_id</span>
<span class="hljs-comment">## repo_id is the id of the model repository from the Hugging Face Hub (repo_id = {organization}/{repo_name} for instance ThomasSimonini/ppo-LunarLander-v2</span>
<span class="hljs-comment">## CHANGE WITH YOUR REPO ID</span>
repo_id = <span class="hljs-string">&quot;ThomasSimonini/ppo-LunarLander-v2&quot;</span>  <span class="hljs-comment"># Change with your repo id, you can&#x27;t push with mine 😄</span>

<span class="hljs-comment">## Define the commit message</span>
commit_message = <span class="hljs-string">&quot;Upload PPO LunarLander-v2 trained agent&quot;</span>

<span class="hljs-comment"># Create the evaluation env and set the render_mode=&quot;rgb_array&quot;</span>
eval_env = DummyVecEnv([<span class="hljs-keyword">lambda</span>: Monitor(gym.make(env_id, render_mode=<span class="hljs-string">&quot;rgb_array&quot;</span>))])

<span class="hljs-comment"># PLACE the package_to_hub function you&#x27;ve just filled here</span>
package_to_hub(
    model=model,  <span class="hljs-comment"># Our trained model</span>
    model_name=model_name,  <span class="hljs-comment"># The name of our trained model</span>
    model_architecture=model_architecture,  <span class="hljs-comment"># The model architecture we used: in our case PPO</span>
    env_id=env_id,  <span class="hljs-comment"># Name of the environment</span>
    eval_env=eval_env,  <span class="hljs-comment"># Evaluation Environment</span>
    repo_id=repo_id,  <span class="hljs-comment"># id of the model repository from the Hugging Face Hub (repo_id = {organization}/{repo_name} for instance ThomasSimonini/ppo-LunarLander-v2</span>
    commit_message=commit_message,
)`,wrap:!1}}),Il=new y({props:{title:"Load a saved LunarLander model from the Hub 🤗",local:"load-a-saved-lunarlander-model-from-the-hub-",headingTag:"h2"}}),kl=new f({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzaGltbXk=",highlighted:"!pip install shimmy",wrap:!1}}),Gl=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX3NiMyUyMGltcG9ydCUyMGxvYWRfZnJvbV9odWIlMEElMEFyZXBvX2lkJTIwJTNEJTIwJTIyQ2xhc3Nyb29tLXdvcmtzaG9wJTJGYXNzaWdubWVudDItb21hciUyMiUyMCUyMCUyMyUyMFRoZSUyMHJlcG9faWQlMEFmaWxlbmFtZSUyMCUzRCUyMCUyMnBwby1MdW5hckxhbmRlci12Mi56aXAlMjIlMjAlMjAlMjMlMjBUaGUlMjBtb2RlbCUyMGZpbGVuYW1lLnppcCUwQSUwQSUyMyUyMFdoZW4lMjB0aGUlMjBtb2RlbCUyMHdhcyUyMHRyYWluZWQlMjBvbiUyMFB5dGhvbiUyMDMuOCUyMHRoZSUyMHBpY2tsZSUyMHByb3RvY29sJTIwaXMlMjA1JTBBJTIzJTIwQnV0JTIwUHl0aG9uJTIwMy42JTJDJTIwMy43JTIwdXNlJTIwcHJvdG9jb2wlMjA0JTBBJTIzJTIwSW4lMjBvcmRlciUyMHRvJTIwZ2V0JTIwY29tcGF0aWJpbGl0eSUyMHdlJTIwbmVlZCUyMHRvJTNBJTBBJTIzJTIwMS4lMjBJbnN0YWxsJTIwcGlja2xlNSUyMCh3ZSUyMGRvbmUlMjBpdCUyMGF0JTIwdGhlJTIwYmVnaW5uaW5nJTIwb2YlMjB0aGUlMjBjb2xhYiklMEElMjMlMjAyLiUyMENyZWF0ZSUyMGElMjBjdXN0b20lMjBlbXB0eSUyMG9iamVjdCUyMHdlJTIwcGFzcyUyMGFzJTIwcGFyYW1ldGVyJTIwdG8lMjBQUE8ubG9hZCgpJTBBY3VzdG9tX29iamVjdHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJsZWFybmluZ19yYXRlJTIyJTNBJTIwMC4wJTJDJTBBJTIwJTIwJTIwJTIwJTIybHJfc2NoZWR1bGUlMjIlM0ElMjBsYW1iZGElMjBfJTNBJTIwMC4wJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2xpcF9yYW5nZSUyMiUzQSUyMGxhbWJkYSUyMF8lM0ElMjAwLjAlMkMlMEElN0QlMEElMEFjaGVja3BvaW50JTIwJTNEJTIwbG9hZF9mcm9tX2h1YihyZXBvX2lkJTJDJTIwZmlsZW5hbWUpJTBBbW9kZWwlMjAlM0QlMjBQUE8ubG9hZChjaGVja3BvaW50JTJDJTIwY3VzdG9tX29iamVjdHMlM0RjdXN0b21fb2JqZWN0cyUyQyUyMHByaW50X3N5c3RlbV9pbmZvJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_sb3 <span class="hljs-keyword">import</span> load_from_hub

repo_id = <span class="hljs-string">&quot;Classroom-workshop/assignment2-omar&quot;</span>  <span class="hljs-comment"># The repo_id</span>
filename = <span class="hljs-string">&quot;ppo-LunarLander-v2.zip&quot;</span>  <span class="hljs-comment"># The model filename.zip</span>

<span class="hljs-comment"># When the model was trained on Python 3.8 the pickle protocol is 5</span>
<span class="hljs-comment"># But Python 3.6, 3.7 use protocol 4</span>
<span class="hljs-comment"># In order to get compatibility we need to:</span>
<span class="hljs-comment"># 1. Install pickle5 (we done it at the beginning of the colab)</span>
<span class="hljs-comment"># 2. Create a custom empty object we pass as parameter to PPO.load()</span>
custom_objects = {
    <span class="hljs-string">&quot;learning_rate&quot;</span>: <span class="hljs-number">0.0</span>,
    <span class="hljs-string">&quot;lr_schedule&quot;</span>: <span class="hljs-keyword">lambda</span> _: <span class="hljs-number">0.0</span>,
    <span class="hljs-string">&quot;clip_range&quot;</span>: <span class="hljs-keyword">lambda</span> _: <span class="hljs-number">0.0</span>,
}

checkpoint = load_from_hub(repo_id, filename)
model = PPO.load(checkpoint, custom_objects=custom_objects, print_system_info=<span class="hljs-literal">True</span>)`,wrap:!1}}),Yl=new f({props:{code:"JTIzJTIwJTQwdGl0bGUlMEFldmFsX2VudiUyMCUzRCUyME1vbml0b3IoZ3ltLm1ha2UoJTIyTHVuYXJMYW5kZXItdjIlMjIpKSUwQW1lYW5fcmV3YXJkJTJDJTIwc3RkX3Jld2FyZCUyMCUzRCUyMGV2YWx1YXRlX3BvbGljeShtb2RlbCUyQyUyMGV2YWxfZW52JTJDJTIwbl9ldmFsX2VwaXNvZGVzJTNEMTAlMkMlMjBkZXRlcm1pbmlzdGljJTNEVHJ1ZSklMEFwcmludChmJTIybWVhbl9yZXdhcmQlM0QlN0JtZWFuX3Jld2FyZCUzQS4yZiU3RCUyMCUyQiUyRi0lMjAlN0JzdGRfcmV3YXJkJTdEJTIyKQ==",highlighted:`<span class="hljs-comment"># @title</span>
eval_env = Monitor(gym.make(<span class="hljs-string">&quot;LunarLander-v2&quot;</span>))
mean_reward, std_reward = evaluate_policy(model, eval_env, n_eval_episodes=<span class="hljs-number">10</span>, deterministic=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;mean_reward=<span class="hljs-subst">{mean_reward:<span class="hljs-number">.2</span>f}</span> +/- <span class="hljs-subst">{std_reward}</span>&quot;</span>)`,wrap:!1}}),El=new y({props:{title:"Some additional challenges 🏆",local:"some-additional-challenges-",headingTag:"h2"}}),Kl=new y({props:{title:"Keep learning, stay awesome 🤗",local:"keep-learning-stay-awesome-",headingTag:"h2"}}),{c(){b=i("meta"),ln=s(),en=i("p"),nn=s(),p(U.$$.fragment),sn=s(),p(J.$$.fragment),an=s(),C=i("p"),C.textContent=qi,on=s(),I=i("img"),rn=s(),$=i("p"),$.innerHTML=Ki,pn=s(),Z=i("p"),Z.innerHTML=eo,mn=s(),_=i("p"),_.innerHTML=to,un=s(),B=i("p"),B.innerHTML=lo,Mn=s(),W=i("p"),W.innerHTML=no,hn=s(),L=i("p"),L.innerHTML=so,dn=s(),H=i("p"),H.innerHTML=ao,cn=s(),x=i("p"),x.textContent=io,yn=s(),k=i("p"),k.innerHTML=oo,fn=s(),G=i("p"),G.innerHTML=ro,gn=s(),R=i("p"),R.innerHTML=po,bn=s(),Y=i("p"),Y.innerHTML=mo,wn=s(),p(E.$$.fragment),Tn=s(),w=i("img"),vn=s(),X=i("p"),X.innerHTML=Mo,jn=s(),p(V.$$.fragment),Un=s(),S=i("ul"),S.innerHTML=ho,Jn=s(),p(F.$$.fragment),Cn=s(),Q=i("ul"),Q.innerHTML=co,In=s(),z=i("p"),z.innerHTML=yo,$n=s(),p(P.$$.fragment),Zn=s(),A=i("p"),A.textContent=fo,_n=s(),N=i("ul"),N.innerHTML=go,Bn=s(),p(D.$$.fragment),Wn=s(),q=i("img"),Ln=s(),O=i("p"),O.textContent=wo,Hn=s(),K=i("ul"),K.innerHTML=To,xn=s(),ee=i("p"),ee.textContent=vo,kn=s(),te=i("p"),te.innerHTML=jo,Gn=s(),le=i("p"),le.innerHTML=Uo,Rn=s(),ne=i("p"),ne.innerHTML=Jo,Yn=s(),p(se.$$.fragment),En=s(),ae=i("p"),ae.textContent=Co,Xn=s(),ie=i("p"),ie.innerHTML=Io,Vn=s(),oe=i("p"),oe.innerHTML=$o,Sn=s(),p(re.$$.fragment),Fn=s(),T=i("img"),Qn=s(),pe=i("p"),pe.textContent=_o,zn=s(),me=i("ul"),me.innerHTML=Bo,Pn=s(),ue=i("p"),ue.innerHTML=Wo,An=s(),Me=i("ul"),Me.innerHTML=Lo,Nn=s(),p(he.$$.fragment),Dn=s(),p(de.$$.fragment),qn=s(),ce=i("p"),ce.innerHTML=Ho,On=s(),ye=i("p"),ye.innerHTML=xo,Kn=s(),fe=i("p"),fe.innerHTML=ko,es=s(),p(ge.$$.fragment),ts=s(),be=i("ul"),be.innerHTML=Go,ls=s(),we=i("img"),ns=s(),Te=i("ul"),Te.innerHTML=Yo,ss=s(),ve=i("img"),as=s(),p(je.$$.fragment),is=s(),Ue=i("p"),Ue.textContent=Xo,os=s(),Je=i("ul"),Je.innerHTML=Vo,rs=s(),Ce=i("p"),Ce.textContent=So,ps=s(),p(Ie.$$.fragment),ms=s(),p($e.$$.fragment),us=s(),Ze=i("p"),Ze.innerHTML=Fo,Ms=s(),_e=i("p"),_e.textContent=Qo,hs=s(),p(Be.$$.fragment),ds=s(),We=i("p"),We.innerHTML=zo,cs=s(),p(Le.$$.fragment),ys=s(),p(He.$$.fragment),fs=s(),p(xe.$$.fragment),gs=s(),ke=i("p"),ke.innerHTML=Po,bs=s(),Ge=i("p"),Ge.textContent=Ao,ws=s(),Re=i("p"),Re.innerHTML=No,Ts=s(),p(Ye.$$.fragment),vs=s(),p(Ee.$$.fragment),js=s(),Xe=i("p"),Xe.innerHTML=Do,Us=s(),Ve=i("p"),Ve.innerHTML=qo,Js=s(),Se=i("p"),Se.textContent=Oo,Cs=s(),Fe=i("ul"),Fe.innerHTML=Ko,Is=s(),Qe=i("p"),Qe.textContent=er,$s=s(),v=i("img"),Zs=s(),ze=i("p"),ze.textContent=lr,_s=s(),Pe=i("ul"),Pe.innerHTML=nr,Bs=s(),Ae=i("p"),Ae.textContent=sr,Ws=s(),Ne=i("p"),Ne.innerHTML=ar,Ls=s(),De=i("p"),De.innerHTML=ir,Hs=s(),qe=i("p"),qe.textContent=or,xs=s(),Oe=i("p"),Oe.textContent=rr,ks=s(),Ke=i("p"),Ke.innerHTML=pr,Gs=s(),et=i("ul"),et.innerHTML=mr,Rs=s(),tt=i("p"),tt.innerHTML=ur,Ys=s(),lt=i("p"),lt.textContent=Mr,Es=s(),nt=i("ul"),nt.innerHTML=hr,Xs=s(),st=i("p"),st.innerHTML=dr,Vs=s(),p(at.$$.fragment),Ss=s(),p(it.$$.fragment),Fs=s(),p(ot.$$.fragment),Qs=s(),rt=i("p"),rt.innerHTML=cr,zs=s(),Ps=i("hr"),As=s(),pt=i("p"),pt.textContent=yr,Ns=s(),mt=i("p"),mt.innerHTML=fr,Ds=s(),qs=i("hr"),Os=s(),ut=i("p"),ut.textContent=gr,Ks=s(),p(Mt.$$.fragment),ea=s(),ht=i("p"),ht.innerHTML=br,ta=s(),dt=i("ul"),dt.innerHTML=wr,la=s(),p(ct.$$.fragment),na=s(),yt=i("p"),yt.textContent=Tr,sa=s(),ft=i("ul"),ft.innerHTML=vr,aa=s(),gt=i("p"),gt.textContent=jr,ia=s(),bt=i("p"),bt.innerHTML=Ur,oa=s(),wt=i("p"),wt.textContent=Jr,ra=s(),Tt=i("ul"),Tt.innerHTML=Cr,pa=s(),vt=i("p"),vt.innerHTML=Ir,ma=s(),jt=i("p"),jt.innerHTML=$r,ua=s(),p(Ut.$$.fragment),Ma=s(),Jt=i("ul"),Jt.innerHTML=Zr,ha=s(),p(Ct.$$.fragment),da=s(),p(It.$$.fragment),ca=s(),$t=i("ul"),$t.innerHTML=_r,ya=s(),fa=i("hr"),ga=s(),Zt=i("p"),Zt.innerHTML=Br,ba=s(),wa=i("hr"),Ta=s(),_t=i("img"),va=s(),Bt=i("p"),Bt.innerHTML=Lr,ja=s(),Wt=i("p"),Wt.textContent=Hr,Ua=s(),Lt=i("ul"),Lt.innerHTML=xr,Ja=s(),Ht=i("p"),Ht.textContent=kr,Ca=s(),xt=i("p"),xt.innerHTML=Gr,Ia=s(),kt=i("p"),kt.innerHTML=Rr,$a=s(),Gt=i("p"),Gt.innerHTML=Yr,Za=s(),p(Rt.$$.fragment),_a=s(),p(Yt.$$.fragment),Ba=s(),p(Et.$$.fragment),Wa=s(),p(Xt.$$.fragment),La=s(),p(Vt.$$.fragment),Ha=s(),St=i("ul"),St.innerHTML=Er,xa=s(),p(Ft.$$.fragment),ka=s(),p(Qt.$$.fragment),Ga=s(),p(zt.$$.fragment),Ra=s(),p(Pt.$$.fragment),Ya=s(),At=i("ul"),At.innerHTML=Xr,Ea=s(),Nt=i("p"),Nt.textContent=Vr,Xa=s(),p(Dt.$$.fragment),Va=s(),p(qt.$$.fragment),Sa=s(),p(Ot.$$.fragment),Fa=s(),Kt=i("ul"),Kt.innerHTML=Sr,Qa=s(),p(el.$$.fragment),za=s(),tl=i("p"),tl.textContent=Fr,Pa=s(),ll=i("p"),ll.innerHTML=Qr,Aa=s(),nl=i("p"),nl.textContent=zr,Na=s(),sl=i("p"),sl.innerHTML=Pr,Da=s(),al=i("p"),al.textContent=Ar,qa=s(),il=i("ul"),il.innerHTML=Nr,Oa=s(),ol=i("p"),ol.textContent=Dr,Ka=s(),rl=i("p"),rl.innerHTML=qr,ei=s(),pl=i("p"),pl.textContent=Or,ti=s(),ml=i("ul"),ml.innerHTML=Kr,li=s(),ul=i("img"),ni=s(),Ml=i("ul"),Ml.innerHTML=tp,si=s(),p(hl.$$.fragment),ai=s(),dl=i("p"),dl.innerHTML=lp,ii=s(),cl=i("p"),cl.innerHTML=np,oi=s(),yl=i("p"),yl.innerHTML=sp,ri=s(),fl=i("ul"),fl.innerHTML=ap,pi=s(),gl=i("p"),gl.innerHTML=ip,mi=s(),bl=i("ul"),bl.innerHTML=op,ui=s(),p(wl.$$.fragment),Mi=s(),p(Tl.$$.fragment),hi=s(),p(vl.$$.fragment),di=s(),jl=i("p"),jl.innerHTML=rp,ci=s(),Ul=i("ul"),Ul.innerHTML=pp,yi=s(),Jl=i("p"),Jl.textContent=mp,fi=s(),Cl=i("p"),Cl.innerHTML=up,gi=s(),p(Il.$$.fragment),bi=s(),$l=i("p"),$l.innerHTML=Mp,wi=s(),Zl=i("p"),Zl.textContent=hp,Ti=s(),_l=i("p"),_l.innerHTML=dp,vi=s(),Bl=i("ol"),Bl.innerHTML=cp,ji=s(),Wl=i("img"),Ui=s(),j=i("ol"),j.innerHTML=fp,Ji=s(),Ll=i("ul"),Ll.innerHTML=gp,Ci=s(),Hl=i("p"),Hl.textContent=bp,Ii=s(),xl=i("p"),xl.innerHTML=wp,$i=s(),p(kl.$$.fragment),Zi=s(),p(Gl.$$.fragment),_i=s(),Rl=i("p"),Rl.textContent=Tp,Bi=s(),p(Yl.$$.fragment),Wi=s(),p(El.$$.fragment),Li=s(),Xl=i("p"),Xl.innerHTML=vp,Hi=s(),Vl=i("p"),Vl.innerHTML=jp,xi=s(),Sl=i("p"),Sl.textContent=Up,ki=s(),Fl=i("ul"),Fl.innerHTML=Jp,Gi=s(),Ql=i("p"),Ql.innerHTML=Cp,Ri=s(),zl=i("p"),zl.innerHTML=Ip,Yi=s(),Ei=i("hr"),Xi=s(),Pl=i("p"),Pl.innerHTML=$p,Vi=s(),Al=i("p"),Al.innerHTML=Zp,Si=s(),Nl=i("p"),Nl.innerHTML=_p,Fi=s(),Dl=i("p"),Dl.innerHTML=Bp,Qi=s(),ql=i("p"),ql.textContent=Wp,zi=s(),Ol=i("img"),Pi=s(),p(Kl.$$.fragment),Ai=s(),tn=i("p"),this.h()},l(e){const t=Ep("svelte-u9bgzb",document.head);b=o(t,"META",{name:!0,content:!0}),t.forEach(l),ln=a(e),en=o(e,"P",{}),Hp(en).forEach(l),nn=a(e),m(U.$$.fragment,e),sn=a(e),m(J.$$.fragment,e),an=a(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1fyqzqg"&&(C.textContent=qi),on=a(e),I=o(e,"IMG",{src:!0,alt:!0}),rn=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-qeetmg"&&($.innerHTML=Ki),pn=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-6a5et3"&&(Z.innerHTML=eo),mn=a(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1yw7b9f"&&(_.innerHTML=to),un=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-lt0dbq"&&(B.innerHTML=lo),Mn=a(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1c0nyzi"&&(W.innerHTML=no),hn=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1qkxyrx"&&(L.innerHTML=so),dn=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-znarat"&&(H.innerHTML=ao),cn=a(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-vkoquy"&&(x.textContent=io),yn=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-10pdw2g"&&(k.innerHTML=oo),fn=a(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-ur7x3v"&&(G.innerHTML=ro),gn=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-uilrpw"&&(R.innerHTML=po),bn=a(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-p9mrd0"&&(Y.innerHTML=mo),wn=a(e),m(E.$$.fragment,e),Tn=a(e),w=o(e,"IMG",{src:!0,alt:!0,width:!0}),vn=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-gtyyy1"&&(X.innerHTML=Mo),jn=a(e),m(V.$$.fragment,e),Un=a(e),S=o(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-1i75yc"&&(S.innerHTML=ho),Jn=a(e),m(F.$$.fragment,e),Cn=a(e),Q=o(e,"UL",{"data-svelte-h":!0}),r(Q)!=="svelte-1lt8xht"&&(Q.innerHTML=co),In=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1nezll8"&&(z.innerHTML=yo),$n=a(e),m(P.$$.fragment,e),Zn=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-nsjs09"&&(A.textContent=fo),_n=a(e),N=o(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-rzgp9v"&&(N.innerHTML=go),Bn=a(e),m(D.$$.fragment,e),Wn=a(e),q=o(e,"IMG",{src:!0,alt:!0}),Ln=a(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-6wur6d"&&(O.textContent=wo),Hn=a(e),K=o(e,"UL",{"data-svelte-h":!0}),r(K)!=="svelte-1uvcz43"&&(K.innerHTML=To),xn=a(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-l0ox3l"&&(ee.textContent=vo),kn=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-df6xsg"&&(te.innerHTML=jo),Gn=a(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-i91mrq"&&(le.innerHTML=Uo),Rn=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1sstckl"&&(ne.innerHTML=Jo),Yn=a(e),m(se.$$.fragment,e),En=a(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1v25wk6"&&(ae.textContent=Co),Xn=a(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1ex8j5d"&&(ie.innerHTML=Io),Vn=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-fgg92r"&&(oe.innerHTML=$o),Sn=a(e),m(re.$$.fragment,e),Fn=a(e),T=o(e,"IMG",{src:!0,alt:!0,width:!0}),Qn=a(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-7aaye9"&&(pe.textContent=_o),zn=a(e),me=o(e,"UL",{"data-svelte-h":!0}),r(me)!=="svelte-1q6p5tv"&&(me.innerHTML=Bo),Pn=a(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-vmzi2g"&&(ue.innerHTML=Wo),An=a(e),Me=o(e,"UL",{"data-svelte-h":!0}),r(Me)!=="svelte-15oilwj"&&(Me.innerHTML=Lo),Nn=a(e),m(he.$$.fragment,e),Dn=a(e),m(de.$$.fragment,e),qn=a(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1yw7b9f"&&(ce.innerHTML=Ho),On=a(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-lt0dbq"&&(ye.innerHTML=xo),Kn=a(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1qkxyrx"&&(fe.innerHTML=ko),es=a(e),m(ge.$$.fragment,e),ts=a(e),be=o(e,"UL",{"data-svelte-h":!0}),r(be)!=="svelte-1funvfi"&&(be.innerHTML=Go),ls=a(e),we=o(e,"IMG",{src:!0,alt:!0}),ns=a(e),Te=o(e,"UL",{"data-svelte-h":!0}),r(Te)!=="svelte-1cge6gn"&&(Te.innerHTML=Yo),ss=a(e),ve=o(e,"IMG",{src:!0,alt:!0}),as=a(e),m(je.$$.fragment,e),is=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-240n94"&&(Ue.textContent=Xo),os=a(e),Je=o(e,"UL",{"data-svelte-h":!0}),r(Je)!=="svelte-176sd9d"&&(Je.innerHTML=Vo),rs=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-yvi6vy"&&(Ce.textContent=So),ps=a(e),m(Ie.$$.fragment,e),ms=a(e),m($e.$$.fragment,e),us=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1t10iqv"&&(Ze.innerHTML=Fo),Ms=a(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-xvjq2n"&&(_e.textContent=Qo),hs=a(e),m(Be.$$.fragment,e),ds=a(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-bx852m"&&(We.innerHTML=zo),cs=a(e),m(Le.$$.fragment,e),ys=a(e),m(He.$$.fragment,e),fs=a(e),m(xe.$$.fragment,e),gs=a(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1a8ukem"&&(ke.innerHTML=Po),bs=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1ub567"&&(Ge.textContent=Ao),ws=a(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-179moh"&&(Re.innerHTML=No),Ts=a(e),m(Ye.$$.fragment,e),vs=a(e),m(Ee.$$.fragment,e),js=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-18clawh"&&(Xe.innerHTML=Do),Us=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-4pwxen"&&(Ve.innerHTML=qo),Js=a(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1omhoff"&&(Se.textContent=Oo),Cs=a(e),Fe=o(e,"UL",{"data-svelte-h":!0}),r(Fe)!=="svelte-1gr0wpr"&&(Fe.innerHTML=Ko),Is=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1d4ybay"&&(Qe.textContent=er),$s=a(e),v=o(e,"IMG",{src:!0,alt:!0,width:!0}),Zs=a(e),ze=o(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-1buylsu"&&(ze.textContent=lr),_s=a(e),Pe=o(e,"UL",{"data-svelte-h":!0}),r(Pe)!=="svelte-18q8eyd"&&(Pe.innerHTML=nr),Bs=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1vqqw6i"&&(Ae.textContent=sr),Ws=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-13b9y4a"&&(Ne.innerHTML=ar),Ls=a(e),De=o(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-1bdnzh6"&&(De.innerHTML=ir),Hs=a(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1buylsu"&&(qe.textContent=or),xs=a(e),Oe=o(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-5kldyy"&&(Oe.textContent=rr),ks=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-55e9cg"&&(Ke.innerHTML=pr),Gs=a(e),et=o(e,"UL",{"data-svelte-h":!0}),r(et)!=="svelte-xz0jlk"&&(et.innerHTML=mr),Rs=a(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1w6llkl"&&(tt.innerHTML=ur),Ys=a(e),lt=o(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-4sv61e"&&(lt.textContent=Mr),Es=a(e),nt=o(e,"UL",{"data-svelte-h":!0}),r(nt)!=="svelte-14fsfpn"&&(nt.innerHTML=hr),Xs=a(e),st=o(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1gwp7j4"&&(st.innerHTML=dr),Vs=a(e),m(at.$$.fragment,e),Ss=a(e),m(it.$$.fragment,e),Fs=a(e),m(ot.$$.fragment,e),Qs=a(e),rt=o(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-2un6m0"&&(rt.innerHTML=cr),zs=a(e),Ps=o(e,"HR",{}),As=a(e),pt=o(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-15dw51a"&&(pt.textContent=yr),Ns=a(e),mt=o(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-jnu6xx"&&(mt.innerHTML=fr),Ds=a(e),qs=o(e,"HR",{}),Os=a(e),ut=o(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-mlxrgb"&&(ut.textContent=gr),Ks=a(e),m(Mt.$$.fragment,e),ea=a(e),ht=o(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-1dc7m7j"&&(ht.innerHTML=br),ta=a(e),dt=o(e,"UL",{"data-svelte-h":!0}),r(dt)!=="svelte-gm5axf"&&(dt.innerHTML=wr),la=a(e),m(ct.$$.fragment,e),na=a(e),yt=o(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-l9gcgq"&&(yt.textContent=Tr),sa=a(e),ft=o(e,"UL",{"data-svelte-h":!0}),r(ft)!=="svelte-1gafu9z"&&(ft.innerHTML=vr),aa=a(e),gt=o(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-pqdpyc"&&(gt.textContent=jr),ia=a(e),bt=o(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-163y6uv"&&(bt.innerHTML=Ur),oa=a(e),wt=o(e,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-1er0mm6"&&(wt.textContent=Jr),ra=a(e),Tt=o(e,"UL",{"data-svelte-h":!0}),r(Tt)!=="svelte-1yozgp2"&&(Tt.innerHTML=Cr),pa=a(e),vt=o(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-b6qau5"&&(vt.innerHTML=Ir),ma=a(e),jt=o(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-ta04ov"&&(jt.innerHTML=$r),ua=a(e),m(Ut.$$.fragment,e),Ma=a(e),Jt=o(e,"UL",{"data-svelte-h":!0}),r(Jt)!=="svelte-8jx2x9"&&(Jt.innerHTML=Zr),ha=a(e),m(Ct.$$.fragment,e),da=a(e),m(It.$$.fragment,e),ca=a(e),$t=o(e,"UL",{"data-svelte-h":!0}),r($t)!=="svelte-1zi2xo"&&($t.innerHTML=_r),ya=a(e),fa=o(e,"HR",{}),ga=a(e),Zt=o(e,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-157uj5u"&&(Zt.innerHTML=Br),ba=a(e),wa=o(e,"HR",{}),Ta=a(e),_t=o(e,"IMG",{src:!0,alt:!0}),va=a(e),Bt=o(e,"P",{"data-svelte-h":!0}),r(Bt)!=="svelte-1blqo6u"&&(Bt.innerHTML=Lr),ja=a(e),Wt=o(e,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-1j8t0lq"&&(Wt.textContent=Hr),Ua=a(e),Lt=o(e,"UL",{"data-svelte-h":!0}),r(Lt)!=="svelte-hdfg8e"&&(Lt.innerHTML=xr),Ja=a(e),Ht=o(e,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-80yx2p"&&(Ht.textContent=kr),Ca=a(e),xt=o(e,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-1b4vrh6"&&(xt.innerHTML=Gr),Ia=a(e),kt=o(e,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-122u5fk"&&(kt.innerHTML=Rr),$a=a(e),Gt=o(e,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-12b0l2y"&&(Gt.innerHTML=Yr),Za=a(e),m(Rt.$$.fragment,e),_a=a(e),m(Yt.$$.fragment,e),Ba=a(e),m(Et.$$.fragment,e),Wa=a(e),m(Xt.$$.fragment,e),La=a(e),m(Vt.$$.fragment,e),Ha=a(e),St=o(e,"UL",{"data-svelte-h":!0}),r(St)!=="svelte-1kussd2"&&(St.innerHTML=Er),xa=a(e),m(Ft.$$.fragment,e),ka=a(e),m(Qt.$$.fragment,e),Ga=a(e),m(zt.$$.fragment,e),Ra=a(e),m(Pt.$$.fragment,e),Ya=a(e),At=o(e,"UL",{"data-svelte-h":!0}),r(At)!=="svelte-dmghau"&&(At.innerHTML=Xr),Ea=a(e),Nt=o(e,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-11gty83"&&(Nt.textContent=Vr),Xa=a(e),m(Dt.$$.fragment,e),Va=a(e),m(qt.$$.fragment,e),Sa=a(e),m(Ot.$$.fragment,e),Fa=a(e),Kt=o(e,"UL",{"data-svelte-h":!0}),r(Kt)!=="svelte-oku03u"&&(Kt.innerHTML=Sr),Qa=a(e),m(el.$$.fragment,e),za=a(e),tl=o(e,"P",{"data-svelte-h":!0}),r(tl)!=="svelte-13d1cnp"&&(tl.textContent=Fr),Pa=a(e),ll=o(e,"P",{"data-svelte-h":!0}),r(ll)!=="svelte-1vcevn6"&&(ll.innerHTML=Qr),Aa=a(e),nl=o(e,"P",{"data-svelte-h":!0}),r(nl)!=="svelte-w1lcgd"&&(nl.textContent=zr),Na=a(e),sl=o(e,"P",{"data-svelte-h":!0}),r(sl)!=="svelte-1r6eiir"&&(sl.innerHTML=Pr),Da=a(e),al=o(e,"P",{"data-svelte-h":!0}),r(al)!=="svelte-vgzxi7"&&(al.textContent=Ar),qa=a(e),il=o(e,"UL",{"data-svelte-h":!0}),r(il)!=="svelte-19ddql5"&&(il.innerHTML=Nr),Oa=a(e),ol=o(e,"P",{"data-svelte-h":!0}),r(ol)!=="svelte-6k9qpu"&&(ol.textContent=Dr),Ka=a(e),rl=o(e,"P",{"data-svelte-h":!0}),r(rl)!=="svelte-7v2fwq"&&(rl.innerHTML=qr),ei=a(e),pl=o(e,"P",{"data-svelte-h":!0}),r(pl)!=="svelte-1cn3tld"&&(pl.textContent=Or),ti=a(e),ml=o(e,"UL",{"data-svelte-h":!0}),r(ml)!=="svelte-19b5tev"&&(ml.innerHTML=Kr),li=a(e),ul=o(e,"IMG",{src:!0,alt:!0}),ni=a(e),Ml=o(e,"UL",{"data-svelte-h":!0}),r(Ml)!=="svelte-ricdz6"&&(Ml.innerHTML=tp),si=a(e),m(hl.$$.fragment,e),ai=a(e),dl=o(e,"P",{"data-svelte-h":!0}),r(dl)!=="svelte-1g9v6di"&&(dl.innerHTML=lp),ii=a(e),cl=o(e,"P",{"data-svelte-h":!0}),r(cl)!=="svelte-1enm9m5"&&(cl.innerHTML=np),oi=a(e),yl=o(e,"P",{"data-svelte-h":!0}),r(yl)!=="svelte-1bz1l0q"&&(yl.innerHTML=sp),ri=a(e),fl=o(e,"UL",{"data-svelte-h":!0}),r(fl)!=="svelte-1lm8teg"&&(fl.innerHTML=ap),pi=a(e),gl=o(e,"P",{"data-svelte-h":!0}),r(gl)!=="svelte-11ha3rd"&&(gl.innerHTML=ip),mi=a(e),bl=o(e,"UL",{"data-svelte-h":!0}),r(bl)!=="svelte-10dry3f"&&(bl.innerHTML=op),ui=a(e),m(wl.$$.fragment,e),Mi=a(e),m(Tl.$$.fragment,e),hi=a(e),m(vl.$$.fragment,e),di=a(e),jl=o(e,"P",{"data-svelte-h":!0}),r(jl)!=="svelte-hp3w20"&&(jl.innerHTML=rp),ci=a(e),Ul=o(e,"UL",{"data-svelte-h":!0}),r(Ul)!=="svelte-123gpq9"&&(Ul.innerHTML=pp),yi=a(e),Jl=o(e,"P",{"data-svelte-h":!0}),r(Jl)!=="svelte-1pr3qlz"&&(Jl.textContent=mp),fi=a(e),Cl=o(e,"P",{"data-svelte-h":!0}),r(Cl)!=="svelte-1ekdy5l"&&(Cl.innerHTML=up),gi=a(e),m(Il.$$.fragment,e),bi=a(e),$l=o(e,"P",{"data-svelte-h":!0}),r($l)!=="svelte-1xob9fr"&&($l.innerHTML=Mp),wi=a(e),Zl=o(e,"P",{"data-svelte-h":!0}),r(Zl)!=="svelte-j6e6xs"&&(Zl.textContent=hp),Ti=a(e),_l=o(e,"P",{"data-svelte-h":!0}),r(_l)!=="svelte-1u6nkgv"&&(_l.innerHTML=dp),vi=a(e),Bl=o(e,"OL",{"data-svelte-h":!0}),r(Bl)!=="svelte-prvn3y"&&(Bl.innerHTML=cp),ji=a(e),Wl=o(e,"IMG",{src:!0,alt:!0}),Ui=a(e),j=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(j)!=="svelte-w87ej2"&&(j.innerHTML=fp),Ji=a(e),Ll=o(e,"UL",{"data-svelte-h":!0}),r(Ll)!=="svelte-uec4xf"&&(Ll.innerHTML=gp),Ci=a(e),Hl=o(e,"P",{"data-svelte-h":!0}),r(Hl)!=="svelte-13gqrjl"&&(Hl.textContent=bp),Ii=a(e),xl=o(e,"P",{"data-svelte-h":!0}),r(xl)!=="svelte-ytxq9m"&&(xl.innerHTML=wp),$i=a(e),m(kl.$$.fragment,e),Zi=a(e),m(Gl.$$.fragment,e),_i=a(e),Rl=o(e,"P",{"data-svelte-h":!0}),r(Rl)!=="svelte-1nd8fiz"&&(Rl.textContent=Tp),Bi=a(e),m(Yl.$$.fragment,e),Wi=a(e),m(El.$$.fragment,e),Li=a(e),Xl=o(e,"P",{"data-svelte-h":!0}),r(Xl)!=="svelte-6x0xu6"&&(Xl.innerHTML=vp),Hi=a(e),Vl=o(e,"P",{"data-svelte-h":!0}),r(Vl)!=="svelte-131ixzr"&&(Vl.innerHTML=jp),xi=a(e),Sl=o(e,"P",{"data-svelte-h":!0}),r(Sl)!=="svelte-qrxvcm"&&(Sl.textContent=Up),ki=a(e),Fl=o(e,"UL",{"data-svelte-h":!0}),r(Fl)!=="svelte-11s3zll"&&(Fl.innerHTML=Jp),Gi=a(e),Ql=o(e,"P",{"data-svelte-h":!0}),r(Ql)!=="svelte-1dyozfn"&&(Ql.innerHTML=Cp),Ri=a(e),zl=o(e,"P",{"data-svelte-h":!0}),r(zl)!=="svelte-otwf19"&&(zl.innerHTML=Ip),Yi=a(e),Ei=o(e,"HR",{}),Xi=a(e),Pl=o(e,"P",{"data-svelte-h":!0}),r(Pl)!=="svelte-4ab4sp"&&(Pl.innerHTML=$p),Vi=a(e),Al=o(e,"P",{"data-svelte-h":!0}),r(Al)!=="svelte-zyppti"&&(Al.innerHTML=Zp),Si=a(e),Nl=o(e,"P",{"data-svelte-h":!0}),r(Nl)!=="svelte-6h5jhw"&&(Nl.innerHTML=_p),Fi=a(e),Dl=o(e,"P",{"data-svelte-h":!0}),r(Dl)!=="svelte-7f0plk"&&(Dl.innerHTML=Bp),Qi=a(e),ql=o(e,"P",{"data-svelte-h":!0}),r(ql)!=="svelte-6b51l9"&&(ql.textContent=Wp),zi=a(e),Ol=o(e,"IMG",{src:!0,alt:!0}),Pi=a(e),m(Kl.$$.fragment,e),Ai=a(e),tn=o(e,"P",{}),Hp(tn).forEach(l),this.h()},h(){c(b,"name","hf:doc:metadata"),c(b,"content",Fp),g(I.src,Oi="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit1/lunarLander.gif")||c(I,"src",Oi),c(I,"alt","LunarLander"),g(w.src,uo="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit1/thumbnail.jpg")||c(w,"src",uo),c(w,"alt","Unit 1 thumbnail"),c(w,"width","100%"),g(q.src,bo="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/deep-rl-course-illustration.jpg")||c(q,"src",bo),c(q,"alt","Deep RL Course illustration"),g(T.src,Zo="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit1/RL_process_game.jpg")||c(T,"src",Zo),c(T,"alt","The RL process"),c(T,"width","100%"),g(we.src,Ro="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/gpu-step1.jpg")||c(we,"src",Ro),c(we,"alt","GPU Step 1"),g(ve.src,Eo="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/gpu-step2.jpg")||c(ve,"src",Eo),c(ve,"alt","GPU Step 2"),g(v.src,tr="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit1/RL_process_game.jpg")||c(v,"src",tr),c(v,"alt","The RL process"),c(v,"width","100%"),g(_t.src,Wr="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit1/sb3.png")||c(_t,"src",Wr),c(_t,"alt","Stable Baselines3"),g(ul.src,ep="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/create-token.jpg")||c(ul,"src",ep),c(ul,"alt","Create HF Token"),g(Wl.src,yp="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/unit1/copy-id.png")||c(Wl,"src",yp),c(Wl,"alt","Copy-id"),c(j,"start","2"),g(Ol.src,Lp="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/unit1/huggy.jpg")||c(Ol,"src",Lp),c(Ol,"alt","Huggy")},m(e,t){Xp(document.head,b),n(e,ln,t),n(e,en,t),n(e,nn,t),u(U,e,t),n(e,sn,t),u(J,e,t),n(e,an,t),n(e,C,t),n(e,on,t),n(e,I,t),n(e,rn,t),n(e,$,t),n(e,pn,t),n(e,Z,t),n(e,mn,t),n(e,_,t),n(e,un,t),n(e,B,t),n(e,Mn,t),n(e,W,t),n(e,hn,t),n(e,L,t),n(e,dn,t),n(e,H,t),n(e,cn,t),n(e,x,t),n(e,yn,t),n(e,k,t),n(e,fn,t),n(e,G,t),n(e,gn,t),n(e,R,t),n(e,bn,t),n(e,Y,t),n(e,wn,t),u(E,e,t),n(e,Tn,t),n(e,w,t),n(e,vn,t),n(e,X,t),n(e,jn,t),u(V,e,t),n(e,Un,t),n(e,S,t),n(e,Jn,t),u(F,e,t),n(e,Cn,t),n(e,Q,t),n(e,In,t),n(e,z,t),n(e,$n,t),u(P,e,t),n(e,Zn,t),n(e,A,t),n(e,_n,t),n(e,N,t),n(e,Bn,t),u(D,e,t),n(e,Wn,t),n(e,q,t),n(e,Ln,t),n(e,O,t),n(e,Hn,t),n(e,K,t),n(e,xn,t),n(e,ee,t),n(e,kn,t),n(e,te,t),n(e,Gn,t),n(e,le,t),n(e,Rn,t),n(e,ne,t),n(e,Yn,t),u(se,e,t),n(e,En,t),n(e,ae,t),n(e,Xn,t),n(e,ie,t),n(e,Vn,t),n(e,oe,t),n(e,Sn,t),u(re,e,t),n(e,Fn,t),n(e,T,t),n(e,Qn,t),n(e,pe,t),n(e,zn,t),n(e,me,t),n(e,Pn,t),n(e,ue,t),n(e,An,t),n(e,Me,t),n(e,Nn,t),u(he,e,t),n(e,Dn,t),u(de,e,t),n(e,qn,t),n(e,ce,t),n(e,On,t),n(e,ye,t),n(e,Kn,t),n(e,fe,t),n(e,es,t),u(ge,e,t),n(e,ts,t),n(e,be,t),n(e,ls,t),n(e,we,t),n(e,ns,t),n(e,Te,t),n(e,ss,t),n(e,ve,t),n(e,as,t),u(je,e,t),n(e,is,t),n(e,Ue,t),n(e,os,t),n(e,Je,t),n(e,rs,t),n(e,Ce,t),n(e,ps,t),u(Ie,e,t),n(e,ms,t),u($e,e,t),n(e,us,t),n(e,Ze,t),n(e,Ms,t),n(e,_e,t),n(e,hs,t),u(Be,e,t),n(e,ds,t),n(e,We,t),n(e,cs,t),u(Le,e,t),n(e,ys,t),u(He,e,t),n(e,fs,t),u(xe,e,t),n(e,gs,t),n(e,ke,t),n(e,bs,t),n(e,Ge,t),n(e,ws,t),n(e,Re,t),n(e,Ts,t),u(Ye,e,t),n(e,vs,t),u(Ee,e,t),n(e,js,t),n(e,Xe,t),n(e,Us,t),n(e,Ve,t),n(e,Js,t),n(e,Se,t),n(e,Cs,t),n(e,Fe,t),n(e,Is,t),n(e,Qe,t),n(e,$s,t),n(e,v,t),n(e,Zs,t),n(e,ze,t),n(e,_s,t),n(e,Pe,t),n(e,Bs,t),n(e,Ae,t),n(e,Ws,t),n(e,Ne,t),n(e,Ls,t),n(e,De,t),n(e,Hs,t),n(e,qe,t),n(e,xs,t),n(e,Oe,t),n(e,ks,t),n(e,Ke,t),n(e,Gs,t),n(e,et,t),n(e,Rs,t),n(e,tt,t),n(e,Ys,t),n(e,lt,t),n(e,Es,t),n(e,nt,t),n(e,Xs,t),n(e,st,t),n(e,Vs,t),u(at,e,t),n(e,Ss,t),u(it,e,t),n(e,Fs,t),u(ot,e,t),n(e,Qs,t),n(e,rt,t),n(e,zs,t),n(e,Ps,t),n(e,As,t),n(e,pt,t),n(e,Ns,t),n(e,mt,t),n(e,Ds,t),n(e,qs,t),n(e,Os,t),n(e,ut,t),n(e,Ks,t),u(Mt,e,t),n(e,ea,t),n(e,ht,t),n(e,ta,t),n(e,dt,t),n(e,la,t),u(ct,e,t),n(e,na,t),n(e,yt,t),n(e,sa,t),n(e,ft,t),n(e,aa,t),n(e,gt,t),n(e,ia,t),n(e,bt,t),n(e,oa,t),n(e,wt,t),n(e,ra,t),n(e,Tt,t),n(e,pa,t),n(e,vt,t),n(e,ma,t),n(e,jt,t),n(e,ua,t),u(Ut,e,t),n(e,Ma,t),n(e,Jt,t),n(e,ha,t),u(Ct,e,t),n(e,da,t),u(It,e,t),n(e,ca,t),n(e,$t,t),n(e,ya,t),n(e,fa,t),n(e,ga,t),n(e,Zt,t),n(e,ba,t),n(e,wa,t),n(e,Ta,t),n(e,_t,t),n(e,va,t),n(e,Bt,t),n(e,ja,t),n(e,Wt,t),n(e,Ua,t),n(e,Lt,t),n(e,Ja,t),n(e,Ht,t),n(e,Ca,t),n(e,xt,t),n(e,Ia,t),n(e,kt,t),n(e,$a,t),n(e,Gt,t),n(e,Za,t),u(Rt,e,t),n(e,_a,t),u(Yt,e,t),n(e,Ba,t),u(Et,e,t),n(e,Wa,t),u(Xt,e,t),n(e,La,t),u(Vt,e,t),n(e,Ha,t),n(e,St,t),n(e,xa,t),u(Ft,e,t),n(e,ka,t),u(Qt,e,t),n(e,Ga,t),u(zt,e,t),n(e,Ra,t),u(Pt,e,t),n(e,Ya,t),n(e,At,t),n(e,Ea,t),n(e,Nt,t),n(e,Xa,t),u(Dt,e,t),n(e,Va,t),u(qt,e,t),n(e,Sa,t),u(Ot,e,t),n(e,Fa,t),n(e,Kt,t),n(e,Qa,t),u(el,e,t),n(e,za,t),n(e,tl,t),n(e,Pa,t),n(e,ll,t),n(e,Aa,t),n(e,nl,t),n(e,Na,t),n(e,sl,t),n(e,Da,t),n(e,al,t),n(e,qa,t),n(e,il,t),n(e,Oa,t),n(e,ol,t),n(e,Ka,t),n(e,rl,t),n(e,ei,t),n(e,pl,t),n(e,ti,t),n(e,ml,t),n(e,li,t),n(e,ul,t),n(e,ni,t),n(e,Ml,t),n(e,si,t),u(hl,e,t),n(e,ai,t),n(e,dl,t),n(e,ii,t),n(e,cl,t),n(e,oi,t),n(e,yl,t),n(e,ri,t),n(e,fl,t),n(e,pi,t),n(e,gl,t),n(e,mi,t),n(e,bl,t),n(e,ui,t),u(wl,e,t),n(e,Mi,t),u(Tl,e,t),n(e,hi,t),u(vl,e,t),n(e,di,t),n(e,jl,t),n(e,ci,t),n(e,Ul,t),n(e,yi,t),n(e,Jl,t),n(e,fi,t),n(e,Cl,t),n(e,gi,t),u(Il,e,t),n(e,bi,t),n(e,$l,t),n(e,wi,t),n(e,Zl,t),n(e,Ti,t),n(e,_l,t),n(e,vi,t),n(e,Bl,t),n(e,ji,t),n(e,Wl,t),n(e,Ui,t),n(e,j,t),n(e,Ji,t),n(e,Ll,t),n(e,Ci,t),n(e,Hl,t),n(e,Ii,t),n(e,xl,t),n(e,$i,t),u(kl,e,t),n(e,Zi,t),u(Gl,e,t),n(e,_i,t),n(e,Rl,t),n(e,Bi,t),u(Yl,e,t),n(e,Wi,t),u(El,e,t),n(e,Li,t),n(e,Xl,t),n(e,Hi,t),n(e,Vl,t),n(e,xi,t),n(e,Sl,t),n(e,ki,t),n(e,Fl,t),n(e,Gi,t),n(e,Ql,t),n(e,Ri,t),n(e,zl,t),n(e,Yi,t),n(e,Ei,t),n(e,Xi,t),n(e,Pl,t),n(e,Vi,t),n(e,Al,t),n(e,Si,t),n(e,Nl,t),n(e,Fi,t),n(e,Dl,t),n(e,Qi,t),n(e,ql,t),n(e,zi,t),n(e,Ol,t),n(e,Pi,t),u(Kl,e,t),n(e,Ai,t),n(e,tn,t),Ni=!0},p:kp,i(e){Ni||(M(U.$$.fragment,e),M(J.$$.fragment,e),M(E.$$.fragment,e),M(V.$$.fragment,e),M(F.$$.fragment,e),M(P.$$.fragment,e),M(D.$$.fragment,e),M(se.$$.fragment,e),M(re.$$.fragment,e),M(he.$$.fragment,e),M(de.$$.fragment,e),M(ge.$$.fragment,e),M(je.$$.fragment,e),M(Ie.$$.fragment,e),M($e.$$.fragment,e),M(Be.$$.fragment,e),M(Le.$$.fragment,e),M(He.$$.fragment,e),M(xe.$$.fragment,e),M(Ye.$$.fragment,e),M(Ee.$$.fragment,e),M(at.$$.fragment,e),M(it.$$.fragment,e),M(ot.$$.fragment,e),M(Mt.$$.fragment,e),M(ct.$$.fragment,e),M(Ut.$$.fragment,e),M(Ct.$$.fragment,e),M(It.$$.fragment,e),M(Rt.$$.fragment,e),M(Yt.$$.fragment,e),M(Et.$$.fragment,e),M(Xt.$$.fragment,e),M(Vt.$$.fragment,e),M(Ft.$$.fragment,e),M(Qt.$$.fragment,e),M(zt.$$.fragment,e),M(Pt.$$.fragment,e),M(Dt.$$.fragment,e),M(qt.$$.fragment,e),M(Ot.$$.fragment,e),M(el.$$.fragment,e),M(hl.$$.fragment,e),M(wl.$$.fragment,e),M(Tl.$$.fragment,e),M(vl.$$.fragment,e),M(Il.$$.fragment,e),M(kl.$$.fragment,e),M(Gl.$$.fragment,e),M(Yl.$$.fragment,e),M(El.$$.fragment,e),M(Kl.$$.fragment,e),Ni=!0)},o(e){h(U.$$.fragment,e),h(J.$$.fragment,e),h(E.$$.fragment,e),h(V.$$.fragment,e),h(F.$$.fragment,e),h(P.$$.fragment,e),h(D.$$.fragment,e),h(se.$$.fragment,e),h(re.$$.fragment,e),h(he.$$.fragment,e),h(de.$$.fragment,e),h(ge.$$.fragment,e),h(je.$$.fragment,e),h(Ie.$$.fragment,e),h($e.$$.fragment,e),h(Be.$$.fragment,e),h(Le.$$.fragment,e),h(He.$$.fragment,e),h(xe.$$.fragment,e),h(Ye.$$.fragment,e),h(Ee.$$.fragment,e),h(at.$$.fragment,e),h(it.$$.fragment,e),h(ot.$$.fragment,e),h(Mt.$$.fragment,e),h(ct.$$.fragment,e),h(Ut.$$.fragment,e),h(Ct.$$.fragment,e),h(It.$$.fragment,e),h(Rt.$$.fragment,e),h(Yt.$$.fragment,e),h(Et.$$.fragment,e),h(Xt.$$.fragment,e),h(Vt.$$.fragment,e),h(Ft.$$.fragment,e),h(Qt.$$.fragment,e),h(zt.$$.fragment,e),h(Pt.$$.fragment,e),h(Dt.$$.fragment,e),h(qt.$$.fragment,e),h(Ot.$$.fragment,e),h(el.$$.fragment,e),h(hl.$$.fragment,e),h(wl.$$.fragment,e),h(Tl.$$.fragment,e),h(vl.$$.fragment,e),h(Il.$$.fragment,e),h(kl.$$.fragment,e),h(Gl.$$.fragment,e),h(Yl.$$.fragment,e),h(El.$$.fragment,e),h(Kl.$$.fragment,e),Ni=!1},d(e){e&&(l(ln),l(en),l(nn),l(sn),l(an),l(C),l(on),l(I),l(rn),l($),l(pn),l(Z),l(mn),l(_),l(un),l(B),l(Mn),l(W),l(hn),l(L),l(dn),l(H),l(cn),l(x),l(yn),l(k),l(fn),l(G),l(gn),l(R),l(bn),l(Y),l(wn),l(Tn),l(w),l(vn),l(X),l(jn),l(Un),l(S),l(Jn),l(Cn),l(Q),l(In),l(z),l($n),l(Zn),l(A),l(_n),l(N),l(Bn),l(Wn),l(q),l(Ln),l(O),l(Hn),l(K),l(xn),l(ee),l(kn),l(te),l(Gn),l(le),l(Rn),l(ne),l(Yn),l(En),l(ae),l(Xn),l(ie),l(Vn),l(oe),l(Sn),l(Fn),l(T),l(Qn),l(pe),l(zn),l(me),l(Pn),l(ue),l(An),l(Me),l(Nn),l(Dn),l(qn),l(ce),l(On),l(ye),l(Kn),l(fe),l(es),l(ts),l(be),l(ls),l(we),l(ns),l(Te),l(ss),l(ve),l(as),l(is),l(Ue),l(os),l(Je),l(rs),l(Ce),l(ps),l(ms),l(us),l(Ze),l(Ms),l(_e),l(hs),l(ds),l(We),l(cs),l(ys),l(fs),l(gs),l(ke),l(bs),l(Ge),l(ws),l(Re),l(Ts),l(vs),l(js),l(Xe),l(Us),l(Ve),l(Js),l(Se),l(Cs),l(Fe),l(Is),l(Qe),l($s),l(v),l(Zs),l(ze),l(_s),l(Pe),l(Bs),l(Ae),l(Ws),l(Ne),l(Ls),l(De),l(Hs),l(qe),l(xs),l(Oe),l(ks),l(Ke),l(Gs),l(et),l(Rs),l(tt),l(Ys),l(lt),l(Es),l(nt),l(Xs),l(st),l(Vs),l(Ss),l(Fs),l(Qs),l(rt),l(zs),l(Ps),l(As),l(pt),l(Ns),l(mt),l(Ds),l(qs),l(Os),l(ut),l(Ks),l(ea),l(ht),l(ta),l(dt),l(la),l(na),l(yt),l(sa),l(ft),l(aa),l(gt),l(ia),l(bt),l(oa),l(wt),l(ra),l(Tt),l(pa),l(vt),l(ma),l(jt),l(ua),l(Ma),l(Jt),l(ha),l(da),l(ca),l($t),l(ya),l(fa),l(ga),l(Zt),l(ba),l(wa),l(Ta),l(_t),l(va),l(Bt),l(ja),l(Wt),l(Ua),l(Lt),l(Ja),l(Ht),l(Ca),l(xt),l(Ia),l(kt),l($a),l(Gt),l(Za),l(_a),l(Ba),l(Wa),l(La),l(Ha),l(St),l(xa),l(ka),l(Ga),l(Ra),l(Ya),l(At),l(Ea),l(Nt),l(Xa),l(Va),l(Sa),l(Fa),l(Kt),l(Qa),l(za),l(tl),l(Pa),l(ll),l(Aa),l(nl),l(Na),l(sl),l(Da),l(al),l(qa),l(il),l(Oa),l(ol),l(Ka),l(rl),l(ei),l(pl),l(ti),l(ml),l(li),l(ul),l(ni),l(Ml),l(si),l(ai),l(dl),l(ii),l(cl),l(oi),l(yl),l(ri),l(fl),l(pi),l(gl),l(mi),l(bl),l(ui),l(Mi),l(hi),l(di),l(jl),l(ci),l(Ul),l(yi),l(Jl),l(fi),l(Cl),l(gi),l(bi),l($l),l(wi),l(Zl),l(Ti),l(_l),l(vi),l(Bl),l(ji),l(Wl),l(Ui),l(j),l(Ji),l(Ll),l(Ci),l(Hl),l(Ii),l(xl),l($i),l(Zi),l(_i),l(Rl),l(Bi),l(Wi),l(Li),l(Xl),l(Hi),l(Vl),l(xi),l(Sl),l(ki),l(Fl),l(Gi),l(Ql),l(Ri),l(zl),l(Yi),l(Ei),l(Xi),l(Pl),l(Vi),l(Al),l(Si),l(Nl),l(Fi),l(Dl),l(Qi),l(ql),l(zi),l(Ol),l(Pi),l(Ai),l(tn)),l(b),d(U,e),d(J,e),d(E,e),d(V,e),d(F,e),d(P,e),d(D,e),d(se,e),d(re,e),d(he,e),d(de,e),d(ge,e),d(je,e),d(Ie,e),d($e,e),d(Be,e),d(Le,e),d(He,e),d(xe,e),d(Ye,e),d(Ee,e),d(at,e),d(it,e),d(ot,e),d(Mt,e),d(ct,e),d(Ut,e),d(Ct,e),d(It,e),d(Rt,e),d(Yt,e),d(Et,e),d(Xt,e),d(Vt,e),d(Ft,e),d(Qt,e),d(zt,e),d(Pt,e),d(Dt,e),d(qt,e),d(Ot,e),d(el,e),d(hl,e),d(wl,e),d(Tl,e),d(vl,e),d(Il,e),d(kl,e),d(Gl,e),d(Yl,e),d(El,e),d(Kl,e)}}}const Fp='{"title":"Train your first Deep Reinforcement Learning Agent 🤖","local":"hands-on","sections":[],"depth":1}';function Qp(Di){return Gp(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qp extends Rp{constructor(b){super(),Yp(this,b,Qp,Sp,xp,{})}}export{qp as component};
