import{s as vi,f as p,n as xi,o as di}from"../chunks/scheduler.37c15a92.js";import{S as wi,i as Ti,g as s,s as l,r as mt,m as _i,A as yi,h as r,f as i,c as a,j as ci,u as ft,x as o,n as Li,k as u,y as bi,a as n,v as ct,d as vt,t as xt,w as dt}from"../chunks/index.7cb9c9b8.js";import{H as wt}from"../chunks/Heading.d3928e2a.js";function Ci(Tt){let g,he,pe,me,m,fe,f,_t="We learned that Deep Q-Learning <strong>uses a deep neural network to approximate the different Q-values for each possible action at a state</strong> (value-function estimation).",ce,c,yt="The difference is that, during the training phase, instead of updating the Q-value of a state-action pair directly as we have done with Q-Learning:",ve,v,Lt,xe,x,bt="in Deep Q-Learning, we create a <strong>loss function that compares our Q-value prediction and the Q-target and uses gradient descent to update the weights of our Deep Q-Network to approximate our Q-values better</strong>.",de,d,Ct,we,w,Mt="The Deep Q-Learning training algorithm has <em>two phases</em>:",Te,T,Qt="<li><strong>Sampling</strong>: we perform actions and <strong>store the observed experience tuples in a replay memory</strong>.</li> <li><strong>Training</strong>: Select a <strong>small batch of tuples randomly and learn from this batch using a gradient descent update step</strong>.</li>",_e,_,Ht,ye,y,Dt="This is not the only difference compared with Q-Learning. Deep Q-Learning training <strong>might suffer from instability</strong>, mainly because of combining a non-linear Q-value function (Neural Network) and bootstrapping (when we update targets with existing estimates and not an actual complete return).",Le,L,Pt="To help us stabilize the training, we implement three different solutions:",be,b,kt="<li><em>Experience Replay</em> to make more <strong>efficient use of experiences</strong>.</li> <li><em>Fixed Q-Target</em> <strong>to stabilize the training</strong>.</li> <li><em>Double Deep Q-Learning</em>, to <strong>handle the problem of the overestimation of Q-values</strong>.</li>",Ce,C,$t="Let’s go through them!",Me,M,Qe,Q,qt="Why do we create a replay memory?",He,H,jt="Experience Replay in Deep Q-Learning has two functions:",De,D,It=`<li><strong>Make more efficient use of the experiences during the training</strong>.
Usually, in online reinforcement learning, the agent interacts with the environment, gets experiences (state, action, reward, and next state), learns from them (updates the neural network), and discards them. This is not efficient.</li>`,Pe,P,zt="Experience replay helps by <strong>using the experiences of the training more efficiently</strong>. We use a replay buffer that saves experience samples <strong>that we can reuse during the training.</strong>",ke,k,Et,$e,$,Gt="⇒ This allows the agent to <strong>learn from the same experiences multiple times</strong>.",qe,h,Nt="<li><strong>Avoid forgetting previous experiences and reduce the correlation between experiences</strong>.</li>",je,q,Ut="<li>The problem we get if we give sequential samples of experiences to our neural network is that it tends to forget <strong>the previous experiences as it gets new experiences.</strong> For instance, if the agent is in the first level and then in the second, which is different, it can forget how to behave and play in the first level.</li>",Ie,j,Wt="The solution is to create a Replay Buffer that stores experience tuples while interacting with the environment and then sample a small batch of tuples. This prevents <strong>the network from only learning about what it has done immediately before.</strong>",ze,I,Rt="Experience replay also has other benefits. By randomly sampling the experiences, we remove correlation in the observation sequences and avoid <strong>action values from oscillating or diverging catastrophically.</strong>",Ee,z,St="In the Deep Q-Learning pseudocode, we <strong>initialize a replay memory buffer D with capacity N</strong> (N is a hyperparameter that you can define). We then store experiences in the memory and sample a batch of experiences to feed the Deep Q-Network during the training phase.",Ge,E,At,Ne,G,Ue,N,Ft="When we want to calculate the TD error (aka the loss), we calculate the <strong>difference between the TD target (Q-Target) and the current Q-value (estimation of Q)</strong>.",We,U,Bt="But we <strong>don’t have any idea of the real TD target</strong>. We need to estimate it. Using the Bellman equation, we saw that the TD target is just the reward of taking that action at that state plus the discounted highest Q value for the next state.",Re,W,Ot,Se,R,Yt="However, the problem is that we are using the same parameters (weights) for estimating the TD target <strong>and</strong> the Q-value. Consequently, there is a significant correlation between the TD target and the parameters we are changing.",Ae,S,Jt="Therefore, at every step of training, <strong>both our Q-values and the target values shift.</strong> We’re getting closer to our target, but the target is also moving. It’s like chasing a moving target! This can lead to significant oscillation in training.",Fe,A,Kt="It’s like if you were a cowboy (the Q estimation) and you wanted to catch a cow (the Q-target). Your goal is to get closer (reduce the error).",Be,F,Vt,Oe,B,Xt="At each time step, you’re trying to approach the cow, which also moves at each time step (because you use the same parameters).",Ye,O,Zt,Je,Y,ei,Ke,J,ti,Ve,K,ii="Instead, what we see in the pseudo-code is that we:",Xe,V,ni="<li>Use a <strong>separate network with fixed parameters</strong> for estimating the TD Target</li> <li><strong>Copy the parameters from our Deep Q-Network every C steps</strong> to update the target network.</li>",Ze,X,li,et,Z,tt,ee,ai='Double DQNs, or Double Deep Q-Learning neural networks, were introduced <a href="https://papers.nips.cc/paper/3964-double-q-learning" rel="nofollow">by Hado van Hasselt</a>. This method <strong>handles the problem of the overestimation of Q-values.</strong>',it,te,si="To understand this problem, remember how we calculate the TD Target:",nt,ie,ri,lt,ne,oi="We face a simple problem by calculating the TD target: how are we sure that <strong>the best action for the next state is the action with the highest Q-value?</strong>",at,le,ui="We know that the accuracy of Q-values depends on what action we tried <strong>and</strong> what neighboring states we explored.",st,ae,pi="Consequently, we don’t have enough information about the best action to take at the beginning of the training. Therefore, taking the maximum Q-value (which is noisy) as the best action to take can lead to false positives. If non-optimal actions are regularly <strong>given a higher Q value than the optimal best action, the learning will be complicated.</strong>",rt,se,gi="The solution is: when we compute the Q target, we use two networks to decouple the action selection from the target Q-value generation. We:",ot,re,hi="<li>Use our <strong>DQN network</strong> to select the best action to take for the next state (the action with the highest Q-value).</li> <li>Use our <strong>Target network</strong> to calculate the target Q-value of taking that action at the next state.</li>",ut,oe,mi="Therefore, Double DQN helps us reduce the overestimation of Q-values and, as a consequence, helps us train faster and with more stable learning.",pt,ue,fi="Since these three improvements in Deep Q-Learning, many more have been added, such as Prioritized Experience Replay and Dueling Deep Q-Learning. They’re out of the scope of this course but if you’re interested, check the links we put in the reading list.",gt,ge,ht;return m=new wt({props:{title:"The Deep Q-Learning Algorithm",local:"deep-q-algorithm",headingTag:"h1"}}),M=new wt({props:{title:"Experience Replay to make more efficient use of experiences",local:"exp-replay",headingTag:"h2"}}),G=new wt({props:{title:"Fixed Q-Target to stabilize the training",local:"fixed-q",headingTag:"h2"}}),Z=new wt({props:{title:"Double DQN",local:"double-dqn",headingTag:"h2"}}),{c(){g=s("meta"),he=l(),pe=s("p"),me=l(),mt(m.$$.fragment),fe=l(),f=s("p"),f.innerHTML=_t,ce=l(),c=s("p"),c.textContent=yt,ve=l(),v=s("img"),xe=l(),x=s("p"),x.innerHTML=bt,de=l(),d=s("img"),we=l(),w=s("p"),w.innerHTML=Mt,Te=l(),T=s("ul"),T.innerHTML=Qt,_e=l(),_=s("img"),ye=l(),y=s("p"),y.innerHTML=Dt,Le=l(),L=s("p"),L.textContent=Pt,be=l(),b=s("ol"),b.innerHTML=kt,Ce=l(),C=s("p"),C.textContent=$t,Me=l(),mt(M.$$.fragment),Qe=l(),Q=s("p"),Q.textContent=qt,He=l(),H=s("p"),H.textContent=jt,De=l(),D=s("ol"),D.innerHTML=It,Pe=l(),P=s("p"),P.innerHTML=zt,ke=l(),k=s("img"),$e=l(),$=s("p"),$.innerHTML=Gt,qe=l(),h=s("ol"),h.innerHTML=Nt,je=l(),q=s("ul"),q.innerHTML=Ut,Ie=l(),j=s("p"),j.innerHTML=Wt,ze=l(),I=s("p"),I.innerHTML=Rt,Ee=l(),z=s("p"),z.innerHTML=St,Ge=l(),E=s("img"),Ne=l(),mt(G.$$.fragment),Ue=l(),N=s("p"),N.innerHTML=Ft,We=l(),U=s("p"),U.innerHTML=Bt,Re=l(),W=s("img"),Se=l(),R=s("p"),R.innerHTML=Yt,Ae=l(),S=s("p"),S.innerHTML=Jt,Fe=l(),A=s("p"),A.textContent=Kt,Be=l(),F=s("img"),Oe=l(),B=s("p"),B.textContent=Xt,Ye=l(),O=s("img"),Je=l(),Y=s("img"),Ke=_i(`
This leads to a bizarre path of chasing (a significant oscillation in training).
`),J=s("img"),Ve=l(),K=s("p"),K.textContent=ii,Xe=l(),V=s("ul"),V.innerHTML=ni,Ze=l(),X=s("img"),et=l(),mt(Z.$$.fragment),tt=l(),ee=s("p"),ee.innerHTML=ai,it=l(),te=s("p"),te.textContent=si,nt=l(),ie=s("img"),lt=l(),ne=s("p"),ne.innerHTML=oi,at=l(),le=s("p"),le.innerHTML=ui,st=l(),ae=s("p"),ae.innerHTML=pi,rt=l(),se=s("p"),se.textContent=gi,ot=l(),re=s("ul"),re.innerHTML=hi,ut=l(),oe=s("p"),oe.textContent=mi,pt=l(),ue=s("p"),ue.textContent=fi,gt=l(),ge=s("p"),this.h()},l(e){const t=yi("svelte-u9bgzb",document.head);g=r(t,"META",{name:!0,content:!0}),t.forEach(i),he=a(e),pe=r(e,"P",{}),ci(pe).forEach(i),me=a(e),ft(m.$$.fragment,e),fe=a(e),f=r(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-2darfk"&&(f.innerHTML=_t),ce=a(e),c=r(e,"P",{"data-svelte-h":!0}),o(c)!=="svelte-aqeyqh"&&(c.textContent=yt),ve=a(e),v=r(e,"IMG",{src:!0,alt:!0}),xe=a(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-wxd69j"&&(x.innerHTML=bt),de=a(e),d=r(e,"IMG",{src:!0,alt:!0}),we=a(e),w=r(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1nx7xst"&&(w.innerHTML=Mt),Te=a(e),T=r(e,"UL",{"data-svelte-h":!0}),o(T)!=="svelte-135yn8g"&&(T.innerHTML=Qt),_e=a(e),_=r(e,"IMG",{src:!0,alt:!0}),ye=a(e),y=r(e,"P",{"data-svelte-h":!0}),o(y)!=="svelte-dwkp6y"&&(y.innerHTML=Dt),Le=a(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-168l68m"&&(L.textContent=Pt),be=a(e),b=r(e,"OL",{"data-svelte-h":!0}),o(b)!=="svelte-1fsutq2"&&(b.innerHTML=kt),Ce=a(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-ijc3yb"&&(C.textContent=$t),Me=a(e),ft(M.$$.fragment,e),Qe=a(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-m5ziun"&&(Q.textContent=qt),He=a(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-efg87n"&&(H.textContent=jt),De=a(e),D=r(e,"OL",{"data-svelte-h":!0}),o(D)!=="svelte-lze6up"&&(D.innerHTML=It),Pe=a(e),P=r(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1boiln"&&(P.innerHTML=zt),ke=a(e),k=r(e,"IMG",{src:!0,alt:!0}),$e=a(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1iykz66"&&($.innerHTML=Gt),qe=a(e),h=r(e,"OL",{start:!0,"data-svelte-h":!0}),o(h)!=="svelte-o513qq"&&(h.innerHTML=Nt),je=a(e),q=r(e,"UL",{"data-svelte-h":!0}),o(q)!=="svelte-1lyl7a"&&(q.innerHTML=Ut),Ie=a(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-v2m03u"&&(j.innerHTML=Wt),ze=a(e),I=r(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-15bupmd"&&(I.innerHTML=Rt),Ee=a(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-19w4qy4"&&(z.innerHTML=St),Ge=a(e),E=r(e,"IMG",{src:!0,alt:!0}),Ne=a(e),ft(G.$$.fragment,e),Ue=a(e),N=r(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1pyo3h3"&&(N.innerHTML=Ft),We=a(e),U=r(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-5ny7iq"&&(U.innerHTML=Bt),Re=a(e),W=r(e,"IMG",{src:!0,alt:!0}),Se=a(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1a7m8gh"&&(R.innerHTML=Yt),Ae=a(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1l4wjbi"&&(S.innerHTML=Jt),Fe=a(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-qy5b5o"&&(A.textContent=Kt),Be=a(e),F=r(e,"IMG",{src:!0,alt:!0}),Oe=a(e),B=r(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-26uv4h"&&(B.textContent=Xt),Ye=a(e),O=r(e,"IMG",{src:!0,alt:!0}),Je=a(e),Y=r(e,"IMG",{src:!0,alt:!0}),Ke=Li(e,`
This leads to a bizarre path of chasing (a significant oscillation in training).
`),J=r(e,"IMG",{src:!0,alt:!0}),Ve=a(e),K=r(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-xhazyu"&&(K.textContent=ii),Xe=a(e),V=r(e,"UL",{"data-svelte-h":!0}),o(V)!=="svelte-14v84bo"&&(V.innerHTML=ni),Ze=a(e),X=r(e,"IMG",{src:!0,alt:!0}),et=a(e),ft(Z.$$.fragment,e),tt=a(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-13jg576"&&(ee.innerHTML=ai),it=a(e),te=r(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-1w4c5v3"&&(te.textContent=si),nt=a(e),ie=r(e,"IMG",{src:!0,alt:!0}),lt=a(e),ne=r(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1yh7u49"&&(ne.innerHTML=oi),at=a(e),le=r(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1etwyrk"&&(le.innerHTML=ui),st=a(e),ae=r(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-15vgpr4"&&(ae.innerHTML=pi),rt=a(e),se=r(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-jl0qei"&&(se.textContent=gi),ot=a(e),re=r(e,"UL",{"data-svelte-h":!0}),o(re)!=="svelte-18ewups"&&(re.innerHTML=hi),ut=a(e),oe=r(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-15cyi06"&&(oe.textContent=mi),pt=a(e),ue=r(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-1t46uko"&&(ue.textContent=fi),gt=a(e),ge=r(e,"P",{}),ci(ge).forEach(i),this.h()},h(){u(g,"name","hf:doc:metadata"),u(g,"content",Mi),p(v.src,Lt="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/q-ex-5.jpg")||u(v,"src",Lt),u(v,"alt","Q Loss"),p(d.src,Ct="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit4/Q-target.jpg")||u(d,"src",Ct),u(d,"alt","Q-target"),p(_.src,Ht="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit4/sampling-training.jpg")||u(_,"src",Ht),u(_,"alt","Sampling Training"),p(k.src,Et="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit4/experience-replay.jpg")||u(k,"src",Et),u(k,"alt","Experience Replay"),u(h,"start","2"),p(E.src,At="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit4/experience-replay-pseudocode.jpg")||u(E,"src",At),u(E,"alt","Experience Replay Pseudocode"),p(W.src,Ot="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit4/Q-target.jpg")||u(W,"src",Ot),u(W,"alt","Q-target"),p(F.src,Vt="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit4/qtarget-1.jpg")||u(F,"src",Vt),u(F,"alt","Q-target"),p(O.src,Zt="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit4/qtarget-2.jpg")||u(O,"src",Zt),u(O,"alt","Q-target"),p(Y.src,ei="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit4/qtarget-3.jpg")||u(Y,"src",ei),u(Y,"alt","Q-target"),p(J.src,ti="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit4/qtarget-4.jpg")||u(J,"src",ti),u(J,"alt","Q-target"),p(X.src,li="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit4/fixed-q-target-pseudocode.jpg")||u(X,"src",li),u(X,"alt","Fixed Q-target Pseudocode"),p(ie.src,ri="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit3/TD-1.jpg")||u(ie,"src",ri),u(ie,"alt","TD target")},m(e,t){bi(document.head,g),n(e,he,t),n(e,pe,t),n(e,me,t),ct(m,e,t),n(e,fe,t),n(e,f,t),n(e,ce,t),n(e,c,t),n(e,ve,t),n(e,v,t),n(e,xe,t),n(e,x,t),n(e,de,t),n(e,d,t),n(e,we,t),n(e,w,t),n(e,Te,t),n(e,T,t),n(e,_e,t),n(e,_,t),n(e,ye,t),n(e,y,t),n(e,Le,t),n(e,L,t),n(e,be,t),n(e,b,t),n(e,Ce,t),n(e,C,t),n(e,Me,t),ct(M,e,t),n(e,Qe,t),n(e,Q,t),n(e,He,t),n(e,H,t),n(e,De,t),n(e,D,t),n(e,Pe,t),n(e,P,t),n(e,ke,t),n(e,k,t),n(e,$e,t),n(e,$,t),n(e,qe,t),n(e,h,t),n(e,je,t),n(e,q,t),n(e,Ie,t),n(e,j,t),n(e,ze,t),n(e,I,t),n(e,Ee,t),n(e,z,t),n(e,Ge,t),n(e,E,t),n(e,Ne,t),ct(G,e,t),n(e,Ue,t),n(e,N,t),n(e,We,t),n(e,U,t),n(e,Re,t),n(e,W,t),n(e,Se,t),n(e,R,t),n(e,Ae,t),n(e,S,t),n(e,Fe,t),n(e,A,t),n(e,Be,t),n(e,F,t),n(e,Oe,t),n(e,B,t),n(e,Ye,t),n(e,O,t),n(e,Je,t),n(e,Y,t),n(e,Ke,t),n(e,J,t),n(e,Ve,t),n(e,K,t),n(e,Xe,t),n(e,V,t),n(e,Ze,t),n(e,X,t),n(e,et,t),ct(Z,e,t),n(e,tt,t),n(e,ee,t),n(e,it,t),n(e,te,t),n(e,nt,t),n(e,ie,t),n(e,lt,t),n(e,ne,t),n(e,at,t),n(e,le,t),n(e,st,t),n(e,ae,t),n(e,rt,t),n(e,se,t),n(e,ot,t),n(e,re,t),n(e,ut,t),n(e,oe,t),n(e,pt,t),n(e,ue,t),n(e,gt,t),n(e,ge,t),ht=!0},p:xi,i(e){ht||(vt(m.$$.fragment,e),vt(M.$$.fragment,e),vt(G.$$.fragment,e),vt(Z.$$.fragment,e),ht=!0)},o(e){xt(m.$$.fragment,e),xt(M.$$.fragment,e),xt(G.$$.fragment,e),xt(Z.$$.fragment,e),ht=!1},d(e){e&&(i(he),i(pe),i(me),i(fe),i(f),i(ce),i(c),i(ve),i(v),i(xe),i(x),i(de),i(d),i(we),i(w),i(Te),i(T),i(_e),i(_),i(ye),i(y),i(Le),i(L),i(be),i(b),i(Ce),i(C),i(Me),i(Qe),i(Q),i(He),i(H),i(De),i(D),i(Pe),i(P),i(ke),i(k),i($e),i($),i(qe),i(h),i(je),i(q),i(Ie),i(j),i(ze),i(I),i(Ee),i(z),i(Ge),i(E),i(Ne),i(Ue),i(N),i(We),i(U),i(Re),i(W),i(Se),i(R),i(Ae),i(S),i(Fe),i(A),i(Be),i(F),i(Oe),i(B),i(Ye),i(O),i(Je),i(Y),i(Ke),i(J),i(Ve),i(K),i(Xe),i(V),i(Ze),i(X),i(et),i(tt),i(ee),i(it),i(te),i(nt),i(ie),i(lt),i(ne),i(at),i(le),i(st),i(ae),i(rt),i(se),i(ot),i(re),i(ut),i(oe),i(pt),i(ue),i(gt),i(ge)),i(g),dt(m,e),dt(M,e),dt(G,e),dt(Z,e)}}}const Mi='{"title":"The Deep Q-Learning Algorithm","local":"deep-q-algorithm","sections":[{"title":"Experience Replay to make more efficient use of experiences","local":"exp-replay","sections":[],"depth":2},{"title":"Fixed Q-Target to stabilize the training","local":"fixed-q","sections":[],"depth":2},{"title":"Double DQN","local":"double-dqn","sections":[],"depth":2}],"depth":1}';function Qi(Tt){return di(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ki extends wi{constructor(g){super(),Ti(this,g,Qi,Ci,vi,{})}}export{ki as component};
