import{s as Ys,n as zs,o as Fs}from"../chunks/scheduler.39a43cde.js";import{S as Ls,i as Ps,g as p,s as n,r as i,A as Ds,h as M,f as s,c as a,j as Xs,u as j,x as u,k as qs,y as Ks,a as e,v as m,d,t as o,w as c}from"../chunks/index.23ec2204.js";import{D as Os,C as y}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as T}from"../chunks/Heading.c42e7061.js";function le(Ms){let r,Vl,Nl,_l,U,Sl,h,xl,w,is='<em>作者: <a href="https://huggingface.co/derek-thomas" rel="nofollow">Derek Thomas</a></em>',Hl,J,Xl,b,js="我有一个数据集，我想为其嵌入语义搜索（或问答，或 RAG），我希望以最简单的方式嵌入这个数据集并将其放入一个新的数据集中。",ql,g,Yl,f,ms='我将使用我最喜欢的 subreddit <a href="https://www.reddit.com/r/bestofredditorupdates/" rel="nofollow">r/bestofredditorupdates</a> 中的数据集。因为它有很长的条目，同时使用新的 <a href="https://huggingface.co/jinaai/jina-embeddings-v2-base-en" rel="nofollow">jinaai/jina-embeddings-v2-base-en</a> 嵌入模型，因为它有 8k 的上下文长度。还将使用 <a href="https://huggingface.co/inference-endpoints" rel="nofollow">推理端点</a> 部署这个，以节省时间和金钱。要跟随这个教程，你需要<strong>已经添加了支付方式</strong>。如果你还没有添加，可以在 <a href="https://huggingface.co/docs/hub/billing#billing" rel="nofollow">账单</a> 中添加。为了使操作更加简单，我将完全基于 API 进行操作。',zl,I,ds='为了使这个过程更快，我将使用 <a href="https://github.com/huggingface/text-embeddings-inference" rel="nofollow">Text Embeddings Inference</a> 镜像。这有许多好处，比如：',Fl,$,os="<li>无需模型图编译步骤</li> <li>Docker 镜像小，启动时间快。真正的无服务器！</li> <li>基于 token 的动态批处理</li> <li>使用 Flash 注意力机制、Candle 和 cuBLASLt 优化的 transformers 代码进行推理</li> <li>Safetensors 权重加载</li> <li>生产就绪（使用 Open Telemetry 进行分布式跟踪，Prometheus 指标）</li>",Ll,A,cs='<img src="https://media.githubusercontent.com/media/huggingface/text-embeddings-inference/main/assets/bs1-tp.png" alt="img"/>',Pl,C,Dl,B,Kl,Z,Ol,W,lt,R,tt,k,us=`<code>DATASET_IN</code> 你文本数据的位置
<code>DATASET_OUT</code> 你的嵌入储存的位置`,st,G,ys="注意：我将 <code>MAX_WORKERS</code> 设置为 5，因为 <code>jina-embeddings-v2</code> 对内存的需求较大。",et,E,nt,Q,Ts="Hugging Face 在推理端点中提供了多种 GPU 供选择。下面以表格形式呈现：",at,N,rs="<thead><tr><th>GPU</th> <th>实例类型</th> <th>实例大小</th> <th>vRAM</th></tr></thead> <tbody><tr><td>1x Nvidia Tesla T4</td> <td>g4dn.xlarge</td> <td>small</td> <td>16GB</td></tr> <tr><td>4x Nvidia Tesla T4</td> <td>g4dn.12xlarge</td> <td>large</td> <td>64GB</td></tr> <tr><td>1x Nvidia A10G</td> <td>g5.2xlarge</td> <td>medium</td> <td>24GB</td></tr> <tr><td>4x Nvidia A10G</td> <td>g5.12xlarge</td> <td>xxlarge</td> <td>96GB</td></tr> <tr><td>1x Nvidia A100*</td> <td>p4de</td> <td>xlarge</td> <td>80GB</td></tr> <tr><td>2x Nvidia A100*</td> <td>p4de</td> <td>2xlarge</td> <td>160GB</td></tr></tbody>",pt,v,Us="*注意，对于 A100 的机型你需要发邮件给我们来获取权限。",Mt,V,it,_,jt,S,hs="有些用户可能会在组织中注册支付信息。这肯能会使你的支付方式链接组织。",mt,x,ws="如果你想使用你自己的用户名，请将其留空。",dt,H,ot,X,Js=`What is your Hugging Face 🤗 username or organization? (with an added payment method) ········
`,ct,q,ut,Y,yt,z,Tt,F,rt,L,Ut,P,bs='我们将使用 <a href="https://huggingface.co/docs/inference-endpoints/api_reference" rel="nofollow">API</a> 来创建一个 <a href="https://huggingface.co/inference-endpoints" rel="nofollow">推理端点</a>。主要有以下几个好处：',ht,D,gs="<li>方便（无需点击）</li> <li>可重复（我们有代码可以轻松运行它）</li> <li>更便宜（无需花费时间等待加载，并且可以自动关闭）</li>",wt,K,Jt,O,fs="这里有几个设计选择：",bt,ll,Is='<li>像之前所说，我们使用 <code>jinaai/jina-embeddings-v2-base-en</code> 作为我们的模型。<ul><li>为了可复现性，我们将它固定到一个特定的修订版本。</li></ul></li> <li>如果你对更多模型感兴趣，可以查看支持<a href="https://huggingface.co/docs/text-embeddings-inference/supported_models" rel="nofollow">列表</a>。<ul><li>请注意，大多数嵌入模型都是基于 BERT 架构的。</li></ul></li> <li><code>MAX_BATCH_TOKENS</code> 是根据我们的工作数量和嵌入模型的上下文窗口来选择的。</li> <li><code>type=&quot;protected&quot;</code> 利用的是推理端点详细说明的安全功能。</li> <li>我使用 <strong>1x Nvidia A10</strong>，因为 <code>jina-embeddings-v2</code> 对内存的需求很大（记住 8k 的上下文长度）。</li> <li>如果你有高工作负载的需求，你应该考虑进一步调整 <code>MAX_BATCH_TOKENS</code> 和 <code>MAX_CONCURRENT_REQUESTS</code>。</li>',gt,tl,ft,sl,It,el,$s=`CPU times: user 48.1 ms, sys: 15.7 ms, total: 63.8 ms
Wall time: 52.6 s
`,$t,nl,As="当我们使用 <code>endpoint.client.post</code> 时，我们得到一个字节字符串。这有点繁琐，因为我们需要将这个字节字符串转换为一个 <code>np.array</code>，但这只是 Python 中的几行快速代码。",At,al,Ct,pl,Cs="你可能遇到超过上下文长度的输入。在这种情况下，需要你来处理它们。在我的情况下，我更愿意截断而不是出现错误。让我们测试一下这是否有效。",Bt,Ml,Zt,il,Bs=`The length of the embedding_input is: 300000
`,Wt,jl,Rt,ml,Zs="在这里，我发送一个文档，用嵌入更新它，然后返回它。这是与 <code>MAX_WORKERS</code> 并行的发生的。",kt,dl,Gt,ol,Et,cl,Ws=`Embeddings = 100 documents = 100
0 min 21.33 sec
`,Qt,ul,Nt,yl,Rs="现在我们已经完成了嵌入，让我们暂停端点，以免产生任何额外费用，同时这也允许我们分析成本。",vt,Tl,Vt,rl,ks=`Endpoint Status: paused
`,_t,Ul,St,hl,Gs="现在我们的文档已经更新了我们想要的嵌入。首先我们需要将其转换回 <code>Dataset</code> 格式。我发现从字典列表 -&gt; <code>pd.DataFrame</code> -&gt; <code>Dataset</code> 这条路径最为简单。",xt,wl,Ht,Jl,Es="我默认将其上传到用户的账户（而不是上传到组织），但你可以通过在 <code>repo_id</code> 中设置用户或在配置中通过设置 <code>DATASET_OUT</code> 来自由推送到任何你想要的地方。",Xt,bl,qt,gl,Yt,fl,Qs=`Dataset is at https://huggingface.co/datasets/derek-thomas/processed-subset-bestofredditorupdates
`,zt,Il,Ft,$l,Ns="<li>前往下面打印的 <code>dashboard_url</code></li> <li>点击使用与成本 (Usage &amp; Cost) 标签</li> <li>查看你已经花费了多少</li>",Lt,Al,Pt,Cl,vs=`https://ui.endpoints.huggingface.co/HF-test-lab/endpoints/boru-jina-embeddings-demo-ie
`,Dt,Bl,Kt,Zl,Vs=`Hit enter to continue with the notebook
`,Ot,Wl,_s="我们可以看到只花了 <code>$0.04</code> !",ls,Rl,ts,kl,Ss="现在我们已经完成了，不再需要我们的端点了。我们可以以编程方式删除端点。",ss,Gl,xs='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/automatic_embedding_tei_inference_endpoints.png" alt="Cost"/>',es,El,ns,Ql,Hs=`Endpoint deleted successfully
`,as,vl,ps;return U=new Os({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/automatic_embedding_tei_inference_endpoints.ipynb"}]}}),h=new T({props:{title:"怎么使用推理端点去嵌入文档",local:"怎么使用推理端点去嵌入文档",headingTag:"h1"}}),J=new T({props:{title:"目标",local:"目标",headingTag:"h2"}}),g=new T({props:{title:"方法",local:"方法",headingTag:"h2"}}),C=new T({props:{title:"环境(Requirements)",local:"环境requirements",headingTag:"h2"}}),B=new y({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGFpb2h0dHAlM0QlM0QzLjguMyUyMGRhdGFzZXRzJTNEJTNEMi4xNC42JTIwcGFuZGFzJTNEJTNEMS41LjMlMjByZXF1ZXN0cyUzRCUzRDIuMzEuMCUyMHRxZG0lM0QlM0Q0LjY2LjElMjBodWdnaW5nZmFjZS1odWIlM0UlM0QwLjIw",highlighted:'!pip install -q aiohttp==<span class="hljs-number">3.8</span><span class="hljs-number">.3</span> datasets==<span class="hljs-number">2.14</span><span class="hljs-number">.6</span> pandas==<span class="hljs-number">1.5</span><span class="hljs-number">.3</span> requests==<span class="hljs-number">2.31</span><span class="hljs-number">.0</span> tqdm==<span class="hljs-number">4.66</span><span class="hljs-number">.1</span> huggingface-hub&gt;=<span class="hljs-number">0.20</span>',wrap:!1}}),Z=new T({props:{title:"导入包",local:"导入包",headingTag:"h2"}}),W=new y({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQWZyb20lMjBnZXRwYXNzJTIwaW1wb3J0JTIwZ2V0cGFzcyUwQWltcG9ydCUyMGpzb24lMEFmcm9tJTIwcGF0aGxpYiUyMGltcG9ydCUyMFBhdGglMEFpbXBvcnQlMjB0aW1lJTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyME9wdGlvbmFsJTBBJTBBZnJvbSUyMGFpb2h0dHAlMjBpbXBvcnQlMjBDbGllbnRTZXNzaW9uJTJDJTIwQ2xpZW50VGltZW91dCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUyQyUyMERhdGFzZXQlMkMlMjBEYXRhc2V0RGljdCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBub3RlYm9va19sb2dpbiUyQyUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQlMkMlMjBsaXN0X2luZmVyZW5jZV9lbmRwb2ludHMlMkMlMjB3aG9hbWklMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFpbXBvcnQlMjBwYW5kYXMlMjBhcyUyMHBkJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHFkbS5hdXRvJTIwaW1wb3J0JTIwdHFkbQ==",highlighted:`<span class="hljs-keyword">import</span> asyncio
<span class="hljs-keyword">from</span> getpass <span class="hljs-keyword">import</span> getpass
<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>

<span class="hljs-keyword">from</span> aiohttp <span class="hljs-keyword">import</span> ClientSession, ClientTimeout
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Dataset, DatasetDict
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login, create_inference_endpoint, list_inference_endpoints, whoami
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm`,wrap:!1}}),R=new T({props:{title:"设置(Config)",local:"设置config",headingTag:"h2"}}),E=new y({props:{code:"REFUQVNFVF9JTiUyMCUzRCUyMCUyMmRlcmVrLXRob21hcyUyRmRhdGFzZXQtY3JlYXRvci1yZWRkaXQtYmVzdG9mcmVkZGl0b3J1cGRhdGVzJTIyJTBBREFUQVNFVF9PVVQlMjAlM0QlMjAlMjJwcm9jZXNzZWQtc3Vic2V0LWJlc3RvZnJlZGRpdG9ydXBkYXRlcyUyMiUwQUVORFBPSU5UX05BTUUlMjAlM0QlMjAlMjJib3J1LWppbmEtZW1iZWRkaW5ncy1kZW1vLWllJTIyJTBBJTBBTUFYX1dPUktFUlMlMjAlM0QlMjA1JTIwJTIwJTIzJTIwVGhpcyUyMGlzJTIwZm9yJTIwaG93JTIwbWFueSUyMGFzeW5jJTIwd29ya2VycyUyMHlvdSUyMHdhbnQuJTIwQ2hvb3NlJTIwYmFzZWQlMjBvbiUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwaGFyZHdhcmUlMEFST1dfQ09VTlQlMjAlM0QlMjAxMDAlMjAlMjAlMjMlMjBDaG9vc2UlMjBOb25lJTIwdG8lMjB1c2UlMjBhbGwlMjByb3dzJTJDJTIwSW0lMjB1c2luZyUyMDEwMCUyMGp1c3QlMjBmb3IlMjBhJTIwZGVtbw==",highlighted:`DATASET_IN = <span class="hljs-string">&quot;derek-thomas/dataset-creator-reddit-bestofredditorupdates&quot;</span>
DATASET_OUT = <span class="hljs-string">&quot;processed-subset-bestofredditorupdates&quot;</span>
ENDPOINT_NAME = <span class="hljs-string">&quot;boru-jina-embeddings-demo-ie&quot;</span>

MAX_WORKERS = <span class="hljs-number">5</span>  <span class="hljs-comment"># This is for how many async workers you want. Choose based on the model and hardware</span>
ROW_COUNT = <span class="hljs-number">100</span>  <span class="hljs-comment"># Choose None to use all rows, Im using 100 just for a demo</span>`,wrap:!1}}),V=new y({props:{code:"JTIzJTIwR1BVJTIwQ2hvaWNlJTBBVkVORE9SJTIwJTNEJTIwJTIyYXdzJTIyJTBBUkVHSU9OJTIwJTNEJTIwJTIydXMtZWFzdC0xJTIyJTBBSU5TVEFOQ0VfU0laRSUyMCUzRCUyMCUyMm1lZGl1bSUyMiUwQUlOU1RBTkNFX1RZUEUlMjAlM0QlMjAlMjJnNS4yeGxhcmdlJTIy",highlighted:`<span class="hljs-comment"># GPU Choice</span>
VENDOR = <span class="hljs-string">&quot;aws&quot;</span>
REGION = <span class="hljs-string">&quot;us-east-1&quot;</span>
INSTANCE_SIZE = <span class="hljs-string">&quot;medium&quot;</span>
INSTANCE_TYPE = <span class="hljs-string">&quot;g5.2xlarge&quot;</span>`,wrap:!1}}),_=new y({props:{code:"bm90ZWJvb2tfbG9naW4oKQ==",highlighted:"notebook_login()",wrap:!1}}),H=new y({props:{code:"d2hvJTIwJTNEJTIwd2hvYW1pKCklMEFvcmdhbml6YXRpb24lMjAlM0QlMjBnZXRwYXNzKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMldoYXQlMjBpcyUyMHlvdXIlMjBIdWdnaW5nJTIwRmFjZSUyMCVGMCU5RiVBNCU5NyUyMHVzZXJuYW1lJTIwb3IlMjBvcmdhbml6YXRpb24lM0YlMjAod2l0aCUyMGFuJTIwYWRkZWQlMjBwYXltZW50JTIwbWV0aG9kKSUyMiUwQSklMEElMEFuYW1lc3BhY2UlMjAlM0QlMjBvcmdhbml6YXRpb24lMjBvciUyMHdobyU1QiUyMm5hbWUlMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>who = whoami()
<span class="hljs-meta">&gt;&gt;&gt; </span>organization = getpass(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;What is your Hugging Face 🤗 username or organization? (with an added payment method)&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>namespace = organization <span class="hljs-keyword">or</span> who[<span class="hljs-string">&quot;name&quot;</span>]`,wrap:!1}}),q=new T({props:{title:"获取数据",local:"获取数据",headingTag:"h2"}}),Y=new y({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldChEQVRBU0VUX0lOKSUwQWRhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RA==",highlighted:`dataset = load_dataset(DATASET_IN)
dataset[<span class="hljs-string">&quot;train&quot;</span>]`,wrap:!1}}),z=new y({props:{code:"ZG9jdW1lbnRzJTIwJTNEJTIwZGF0YXNldCU1QiUyMnRyYWluJTIyJTVELnRvX3BhbmRhcygpLnRvX2RpY3QoJTIycmVjb3JkcyUyMiklNUIlM0FST1dfQ09VTlQlNUQlMEFsZW4oZG9jdW1lbnRzKSUyQyUyMGRvY3VtZW50cyU1QjAlNUQ=",highlighted:`documents = dataset[<span class="hljs-string">&quot;train&quot;</span>].to_pandas().to_dict(<span class="hljs-string">&quot;records&quot;</span>)[:ROW_COUNT]
<span class="hljs-built_in">len</span>(documents), documents[<span class="hljs-number">0</span>]`,wrap:!1}}),F=new T({props:{title:"推理端点",local:"推理端点",headingTag:"h1"}}),L=new T({props:{title:"创建推理端点",local:"创建推理端点",headingTag:"h2"}}),K=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">try</span>:
    endpoint = create_inference_endpoint(
        ENDPOINT_NAME,
        repository=<span class="hljs-string">&quot;jinaai/jina-embeddings-v2-base-en&quot;</span>,
        revision=<span class="hljs-string">&quot;7302ac470bed880590f9344bfeee32ff8722d0e5&quot;</span>,
        task=<span class="hljs-string">&quot;sentence-embeddings&quot;</span>,
        framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
        accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
        instance_size=INSTANCE_SIZE,
        instance_type=INSTANCE_TYPE,
        region=REGION,
        vendor=VENDOR,
        namespace=namespace,
        custom_image={
            <span class="hljs-string">&quot;health_route&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
            <span class="hljs-string">&quot;env&quot;</span>: {
                <span class="hljs-string">&quot;MAX_BATCH_TOKENS&quot;</span>: <span class="hljs-built_in">str</span>(MAX_WORKERS * <span class="hljs-number">2048</span>),
                <span class="hljs-string">&quot;MAX_CONCURRENT_REQUESTS&quot;</span>: <span class="hljs-string">&quot;512&quot;</span>,
                <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;/repository&quot;</span>,
            },
            <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;ghcr.io/huggingface/text-embeddings-inference:0.5.0&quot;</span>,
        },
        <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
    )
<span class="hljs-keyword">except</span>:
    endpoint = [ie <span class="hljs-keyword">for</span> ie <span class="hljs-keyword">in</span> list_inference_endpoints(namespace=namespace) <span class="hljs-keyword">if</span> ie.name == ENDPOINT_NAME][<span class="hljs-number">0</span>]
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Loaded endpoint&quot;</span>)`,wrap:!1}}),tl=new T({props:{title:"等待直到它运行起来",local:"等待直到它运行起来",headingTag:"h2"}}),sl=new y({props:{code:"JTI1JTI1dGltZSUwQWVuZHBvaW50LndhaXQoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>%%time
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait()`,wrap:!1}}),al=new y({props:{code:"cmVzcG9uc2UlMjAlM0QlMjBlbmRwb2ludC5jbGllbnQucG9zdCglMEElMjAlMjAlMjAlMjBqc29uJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzZW5lcnklMjBpbiUyMHlvdXIlMjBtaW5kJTIwc28lMjB3ZWxsJTIwSSUyMHdvdWxkJTIwcmVjb21lbmQlMjBpdCUyMGV2ZW4lMjB0byUyMHBlb3BsZSUyMHdobyUyMGhhdGUlMjB2aWQuJTIwZ2FtZSUyMG11c2ljISUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRydW5jYXRlJTIyJTNBJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMEEpJTBBcmVzcG9uc2UlMjAlM0QlMjBucC5hcnJheShqc29uLmxvYWRzKHJlc3BvbnNlLmRlY29kZSgpKSklMEFyZXNwb25zZSU1QjAlNUQlNUIlM0EyMCU1RA==",highlighted:`response = endpoint.client.post(
    json={
        <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;This sound track was beautiful! It paints the senery in your mind so well I would recomend it even to people who hate vid. game music!&quot;</span>,
        <span class="hljs-string">&quot;truncate&quot;</span>: <span class="hljs-literal">True</span>,
    },
    task=<span class="hljs-string">&quot;feature-extraction&quot;</span>,
)
response = np.array(json.loads(response.decode()))
response[<span class="hljs-number">0</span>][:<span class="hljs-number">20</span>]`,wrap:!1}}),Ml=new y({props:{code:"ZW1iZWRkaW5nX2lucHV0JTIwJTNEJTIwJTIyVGhpcyUyMGlucHV0JTIwd2lsbCUyMGdldCUyMG11bHRpcGxpZWQlMjIlMjAqJTIwMTAwMDAlMEFwcmludChmJTIyVGhlJTIwbGVuZ3RoJTIwb2YlMjB0aGUlMjBlbWJlZGRpbmdfaW5wdXQlMjBpcyUzQSUyMCU3QmxlbihlbWJlZGRpbmdfaW5wdXQpJTdEJTIyKSUwQXJlc3BvbnNlJTIwJTNEJTIwZW5kcG9pbnQuY2xpZW50LnBvc3QoanNvbiUzRCU3QiUyMmlucHV0cyUyMiUzQSUyMGVtYmVkZGluZ19pbnB1dCUyQyUyMCUyMnRydW5jYXRlJTIyJTNBJTIwVHJ1ZSU3RCUyQyUyMHRhc2slM0QlMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIpJTBBcmVzcG9uc2UlMjAlM0QlMjBucC5hcnJheShqc29uLmxvYWRzKHJlc3BvbnNlLmRlY29kZSgpKSklMEFyZXNwb25zZSU1QjAlNUQlNUIlM0EyMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>embedding_input = <span class="hljs-string">&quot;This input will get multiplied&quot;</span> * <span class="hljs-number">10000</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;The length of the embedding_input is: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(embedding_input)}</span>&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response = endpoint.client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: embedding_input, <span class="hljs-string">&quot;truncate&quot;</span>: <span class="hljs-literal">True</span>}, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response = np.array(json.loads(response.decode()))
<span class="hljs-meta">&gt;&gt;&gt; </span>response[<span class="hljs-number">0</span>][:<span class="hljs-number">20</span>]`,wrap:!1}}),jl=new T({props:{title:"获取嵌入",local:"获取嵌入",headingTag:"h1"}}),dl=new y({props:{code:"YXN5bmMlMjBkZWYlMjByZXF1ZXN0KGRvY3VtZW50JTJDJTIwc2VtYXBob3JlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFNlbWFwaG9yZSUyMGd1YXJkJTBBJTIwJTIwJTIwJTIwYXN5bmMlMjB3aXRoJTIwc2VtYXBob3JlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBlbmRwb2ludC5hc3luY19jbGllbnQucG9zdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBqc29uJTNEJTdCJTIyaW5wdXRzJTIyJTNBJTIwZG9jdW1lbnQlNUIlMjJjb250ZW50JTIyJTVEJTJDJTIwJTIydHJ1bmNhdGUlMjIlM0ElMjBUcnVlJTdEJTJDJTIwdGFzayUzRCUyMmZlYXR1cmUtZXh0cmFjdGlvbiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXN1bHQlMjAlM0QlMjBucC5hcnJheShqc29uLmxvYWRzKHJlc3VsdC5kZWNvZGUoKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG9jdW1lbnQlNUIlMjJlbWJlZGRpbmclMjIlNUQlMjAlM0QlMjByZXN1bHQlNUIwJTVEJTIwJTIwJTIzJTIwQXNzdW1pbmclMjB0aGUlMjBBUEkncyUyMG91dHB1dCUyMGNhbiUyMGJlJTIwZGlyZWN0bHklMjBhc3NpZ25lZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGRvY3VtZW50JTBBJTBBJTBBYXN5bmMlMjBkZWYlMjBtYWluKGRvY3VtZW50cyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBTZW1hcGhvcmUlMjB0byUyMGxpbWl0JTIwY29uY3VycmVudCUyMHJlcXVlc3RzLiUyMEFkanVzdCUyMHRoZSUyMG51bWJlciUyMGFzJTIwbmVlZGVkLiUwQSUyMCUyMCUyMCUyMHNlbWFwaG9yZSUyMCUzRCUyMGFzeW5jaW8uQm91bmRlZFNlbWFwaG9yZShNQVhfV09SS0VSUyklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBDcmVhdGluZyUyMGElMjBsaXN0JTIwb2YlMjB0YXNrcyUwQSUyMCUyMCUyMCUyMHRhc2tzJTIwJTNEJTIwJTVCcmVxdWVzdChkb2N1bWVudCUyQyUyMHNlbWFwaG9yZSklMjBmb3IlMjBkb2N1bWVudCUyMGluJTIwZG9jdW1lbnRzJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVXNpbmclMjB0cWRtJTIwdG8lMjBzaG93JTIwcHJvZ3Jlc3MuJTIwSXQncyUyMGJlZW4lMjBpbnRlZ3JhdGVkJTIwaW50byUyMHRoZSUyMGFzeW5jJTIwbG9vcC4lMEElMjAlMjAlMjAlMjBmb3IlMjBmJTIwaW4lMjB0cWRtKGFzeW5jaW8uYXNfY29tcGxldGVkKHRhc2tzKSUyQyUyMHRvdGFsJTNEbGVuKGRvY3VtZW50cykpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXdhaXQlMjBm",highlighted:`<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">request</span>(<span class="hljs-params">document, semaphore</span>):
    <span class="hljs-comment"># Semaphore guard</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">with</span> semaphore:
        result = <span class="hljs-keyword">await</span> endpoint.async_client.post(
            json={<span class="hljs-string">&quot;inputs&quot;</span>: document[<span class="hljs-string">&quot;content&quot;</span>], <span class="hljs-string">&quot;truncate&quot;</span>: <span class="hljs-literal">True</span>}, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>
        )
        result = np.array(json.loads(result.decode()))
        document[<span class="hljs-string">&quot;embedding&quot;</span>] = result[<span class="hljs-number">0</span>]  <span class="hljs-comment"># Assuming the API&#x27;s output can be directly assigned</span>
        <span class="hljs-keyword">return</span> document


<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>(<span class="hljs-params">documents</span>):
    <span class="hljs-comment"># Semaphore to limit concurrent requests. Adjust the number as needed.</span>
    semaphore = asyncio.BoundedSemaphore(MAX_WORKERS)

    <span class="hljs-comment"># Creating a list of tasks</span>
    tasks = [request(document, semaphore) <span class="hljs-keyword">for</span> document <span class="hljs-keyword">in</span> documents]

    <span class="hljs-comment"># Using tqdm to show progress. It&#x27;s been integrated into the async loop.</span>
    <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> tqdm(asyncio.as_completed(tasks), total=<span class="hljs-built_in">len</span>(documents)):
        <span class="hljs-keyword">await</span> f`,wrap:!1}}),ol=new y({props:{code:"c3RhcnQlMjAlM0QlMjB0aW1lLnBlcmZfY291bnRlcigpJTBBJTBBJTIzJTIwR2V0JTIwZW1iZWRkaW5ncyUwQWF3YWl0JTIwbWFpbihkb2N1bWVudHMpJTBBJTBBJTIzJTIwTWFrZSUyMHN1cmUlMjB3ZSUyMGdvdCUyMGl0JTIwYWxsJTBBY291bnQlMjAlM0QlMjAwJTBBZm9yJTIwZG9jdW1lbnQlMjBpbiUyMGRvY3VtZW50cyUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwJTIyZW1iZWRkaW5nJTIyJTIwaW4lMjBkb2N1bWVudC5rZXlzKCklMjBhbmQlMjBsZW4oZG9jdW1lbnQlNUIlMjJlbWJlZGRpbmclMjIlNUQpJTIwJTNEJTNEJTIwNzY4JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY291bnQlMjAlMkIlM0QlMjAxJTBBcHJpbnQoZiUyMkVtYmVkZGluZ3MlMjAlM0QlMjAlN0Jjb3VudCU3RCUyMGRvY3VtZW50cyUyMCUzRCUyMCU3Qmxlbihkb2N1bWVudHMpJTdEJTIyKSUwQSUwQSUwQSUyMyUyMFByaW50JTIwZWxhcHNlZCUyMHRpbWUlMEFlbGFwc2VkX3RpbWUlMjAlM0QlMjB0aW1lLnBlcmZfY291bnRlcigpJTIwLSUyMHN0YXJ0JTBBbWludXRlcyUyQyUyMHNlY29uZHMlMjAlM0QlMjBkaXZtb2QoZWxhcHNlZF90aW1lJTJDJTIwNjApJTBBcHJpbnQoZiUyMiU3QmludChtaW51dGVzKSU3RCUyMG1pbiUyMCU3QnNlY29uZHMlM0EuMmYlN0QlMjBzZWMlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>start = time.perf_counter()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get embeddings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> main(documents)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Make sure we got it all</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>count = <span class="hljs-number">0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> document <span class="hljs-keyword">in</span> documents:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;embedding&quot;</span> <span class="hljs-keyword">in</span> document.keys() <span class="hljs-keyword">and</span> <span class="hljs-built_in">len</span>(document[<span class="hljs-string">&quot;embedding&quot;</span>]) == <span class="hljs-number">768</span>:
<span class="hljs-meta">... </span>        count += <span class="hljs-number">1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Embeddings = <span class="hljs-subst">{count}</span> documents = <span class="hljs-subst">{<span class="hljs-built_in">len</span>(documents)}</span>&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print elapsed time</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>elapsed_time = time.perf_counter() - start
<span class="hljs-meta">&gt;&gt;&gt; </span>minutes, seconds = <span class="hljs-built_in">divmod</span>(elapsed_time, <span class="hljs-number">60</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">int</span>(minutes)}</span> min <span class="hljs-subst">{seconds:<span class="hljs-number">.2</span>f}</span> sec&quot;</span>)`,wrap:!1}}),ul=new T({props:{title:"暂停推理端点",local:"暂停推理端点",headingTag:"h2"}}),Tl=new y({props:{code:"ZW5kcG9pbnQlMjAlM0QlMjBlbmRwb2ludC5wYXVzZSgpJTBBJTBBcHJpbnQoZiUyMkVuZHBvaW50JTIwU3RhdHVzJTNBJTIwJTdCZW5kcG9pbnQuc3RhdHVzJTdEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = endpoint.pause()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Endpoint Status: <span class="hljs-subst">{endpoint.status}</span>&quot;</span>)`,wrap:!1}}),Ul=new T({props:{title:"将更新后的数据集推送到 Hub",local:"将更新后的数据集推送到-hub",headingTag:"h1"}}),wl=new y({props:{code:"ZGYlMjAlM0QlMjBwZC5EYXRhRnJhbWUoZG9jdW1lbnRzKSUwQWRkJTIwJTNEJTIwRGF0YXNldERpY3QoJTdCJTIydHJhaW4lMjIlM0ElMjBEYXRhc2V0LmZyb21fcGFuZGFzKGRmKSU3RCk=",highlighted:`df = pd.DataFrame(documents)
dd = DatasetDict({<span class="hljs-string">&quot;train&quot;</span>: Dataset.from_pandas(df)})`,wrap:!1}}),bl=new y({props:{code:"ZGQucHVzaF90b19odWIocmVwb19pZCUzRERBVEFTRVRfT1VUKQ==",highlighted:"dd.push_to_hub(repo_id=DATASET_OUT)",wrap:!1}}),gl=new y({props:{code:"cHJpbnQoZidEYXRhc2V0JTIwaXMlMjBhdCUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRiU3QndobyU1QiUyMm5hbWUlMjIlNUQlN0QlMkYlN0JEQVRBU0VUX09VVCU3RCcp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Dataset is at https://huggingface.co/datasets/<span class="hljs-subst">{who[<span class="hljs-string">&quot;name&quot;</span>]}</span>/<span class="hljs-subst">{DATASET_OUT}</span>&#x27;</span>)',wrap:!1}}),Il=new T({props:{title:"分析使用情况",local:"分析使用情况",headingTag:"h1"}}),Al=new y({props:{code:"ZGFzaGJvYXJkX3VybCUyMCUzRCUyMGYlMjJodHRwcyUzQSUyRiUyRnVpLmVuZHBvaW50cy5odWdnaW5nZmFjZS5jbyUyRiU3Qm5hbWVzcGFjZSU3RCUyRmVuZHBvaW50cyUyRiU3QkVORFBPSU5UX05BTUUlN0QlMjIlMEFwcmludChkYXNoYm9hcmRfdXJsKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dashboard_url = <span class="hljs-string">f&quot;https://ui.endpoints.huggingface.co/<span class="hljs-subst">{namespace}</span>/endpoints/<span class="hljs-subst">{ENDPOINT_NAME}</span>&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(dashboard_url)`,wrap:!1}}),Bl=new y({props:{code:"aW5wdXQoJTIySGl0JTIwZW50ZXIlMjB0byUyMGNvbnRpbnVlJTIwd2l0aCUyMHRoZSUyMG5vdGVib29rJTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">input</span>(<span class="hljs-string">&quot;Hit enter to continue with the notebook&quot;</span>)',wrap:!1}}),Rl=new T({props:{title:"删除端点",local:"删除端点",headingTag:"h1"}}),El=new y({props:{code:"ZW5kcG9pbnQlMjAlM0QlMjBlbmRwb2ludC5kZWxldGUoKSUwQSUwQWlmJTIwbm90JTIwZW5kcG9pbnQlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJFbmRwb2ludCUyMGRlbGV0ZWQlMjBzdWNjZXNzZnVsbHklMjIpJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkRlbGV0ZSUyMEVuZHBvaW50JTIwaW4lMjBtYW51YWxseSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = endpoint.delete()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> endpoint:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Endpoint deleted successfully&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Delete Endpoint in manually&quot;</span>)`,wrap:!1}}),{c(){r=p("meta"),Vl=n(),Nl=p("p"),_l=n(),i(U.$$.fragment),Sl=n(),i(h.$$.fragment),xl=n(),w=p("p"),w.innerHTML=is,Hl=n(),i(J.$$.fragment),Xl=n(),b=p("p"),b.textContent=js,ql=n(),i(g.$$.fragment),Yl=n(),f=p("p"),f.innerHTML=ms,zl=n(),I=p("p"),I.innerHTML=ds,Fl=n(),$=p("ul"),$.innerHTML=os,Ll=n(),A=p("p"),A.innerHTML=cs,Pl=n(),i(C.$$.fragment),Dl=n(),i(B.$$.fragment),Kl=n(),i(Z.$$.fragment),Ol=n(),i(W.$$.fragment),lt=n(),i(R.$$.fragment),tt=n(),k=p("p"),k.innerHTML=us,st=n(),G=p("p"),G.innerHTML=ys,et=n(),i(E.$$.fragment),nt=n(),Q=p("p"),Q.textContent=Ts,at=n(),N=p("table"),N.innerHTML=rs,pt=n(),v=p("p"),v.textContent=Us,Mt=n(),i(V.$$.fragment),it=n(),i(_.$$.fragment),jt=n(),S=p("p"),S.textContent=hs,mt=n(),x=p("p"),x.textContent=ws,dt=n(),i(H.$$.fragment),ot=n(),X=p("pre"),X.textContent=Js,ct=n(),i(q.$$.fragment),ut=n(),i(Y.$$.fragment),yt=n(),i(z.$$.fragment),Tt=n(),i(F.$$.fragment),rt=n(),i(L.$$.fragment),Ut=n(),P=p("p"),P.innerHTML=bs,ht=n(),D=p("ul"),D.innerHTML=gs,wt=n(),i(K.$$.fragment),Jt=n(),O=p("p"),O.textContent=fs,bt=n(),ll=p("ul"),ll.innerHTML=Is,gt=n(),i(tl.$$.fragment),ft=n(),i(sl.$$.fragment),It=n(),el=p("pre"),el.textContent=$s,$t=n(),nl=p("p"),nl.innerHTML=As,At=n(),i(al.$$.fragment),Ct=n(),pl=p("p"),pl.textContent=Cs,Bt=n(),i(Ml.$$.fragment),Zt=n(),il=p("pre"),il.textContent=Bs,Wt=n(),i(jl.$$.fragment),Rt=n(),ml=p("p"),ml.innerHTML=Zs,kt=n(),i(dl.$$.fragment),Gt=n(),i(ol.$$.fragment),Et=n(),cl=p("pre"),cl.textContent=Ws,Qt=n(),i(ul.$$.fragment),Nt=n(),yl=p("p"),yl.textContent=Rs,vt=n(),i(Tl.$$.fragment),Vt=n(),rl=p("pre"),rl.textContent=ks,_t=n(),i(Ul.$$.fragment),St=n(),hl=p("p"),hl.innerHTML=Gs,xt=n(),i(wl.$$.fragment),Ht=n(),Jl=p("p"),Jl.innerHTML=Es,Xt=n(),i(bl.$$.fragment),qt=n(),i(gl.$$.fragment),Yt=n(),fl=p("pre"),fl.textContent=Qs,zt=n(),i(Il.$$.fragment),Ft=n(),$l=p("ol"),$l.innerHTML=Ns,Lt=n(),i(Al.$$.fragment),Pt=n(),Cl=p("pre"),Cl.textContent=vs,Dt=n(),i(Bl.$$.fragment),Kt=n(),Zl=p("pre"),Zl.textContent=Vs,Ot=n(),Wl=p("p"),Wl.innerHTML=_s,ls=n(),i(Rl.$$.fragment),ts=n(),kl=p("p"),kl.textContent=Ss,ss=n(),Gl=p("p"),Gl.innerHTML=xs,es=n(),i(El.$$.fragment),ns=n(),Ql=p("pre"),Ql.textContent=Hs,as=n(),vl=p("p"),this.h()},l(l){const t=Ds("svelte-u9bgzb",document.head);r=M(t,"META",{name:!0,content:!0}),t.forEach(s),Vl=a(l),Nl=M(l,"P",{}),Xs(Nl).forEach(s),_l=a(l),j(U.$$.fragment,l),Sl=a(l),j(h.$$.fragment,l),xl=a(l),w=M(l,"P",{"data-svelte-h":!0}),u(w)!=="svelte-1w9xzi"&&(w.innerHTML=is),Hl=a(l),j(J.$$.fragment,l),Xl=a(l),b=M(l,"P",{"data-svelte-h":!0}),u(b)!=="svelte-11ferzq"&&(b.textContent=js),ql=a(l),j(g.$$.fragment,l),Yl=a(l),f=M(l,"P",{"data-svelte-h":!0}),u(f)!=="svelte-1bfbx2r"&&(f.innerHTML=ms),zl=a(l),I=M(l,"P",{"data-svelte-h":!0}),u(I)!=="svelte-1dh13d5"&&(I.innerHTML=ds),Fl=a(l),$=M(l,"UL",{"data-svelte-h":!0}),u($)!=="svelte-32bf82"&&($.innerHTML=os),Ll=a(l),A=M(l,"P",{"data-svelte-h":!0}),u(A)!=="svelte-12ly3c2"&&(A.innerHTML=cs),Pl=a(l),j(C.$$.fragment,l),Dl=a(l),j(B.$$.fragment,l),Kl=a(l),j(Z.$$.fragment,l),Ol=a(l),j(W.$$.fragment,l),lt=a(l),j(R.$$.fragment,l),tt=a(l),k=M(l,"P",{"data-svelte-h":!0}),u(k)!=="svelte-1s6k4ux"&&(k.innerHTML=us),st=a(l),G=M(l,"P",{"data-svelte-h":!0}),u(G)!=="svelte-zys9gx"&&(G.innerHTML=ys),et=a(l),j(E.$$.fragment,l),nt=a(l),Q=M(l,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-gdta8b"&&(Q.textContent=Ts),at=a(l),N=M(l,"TABLE",{"data-svelte-h":!0}),u(N)!=="svelte-17os0b1"&&(N.innerHTML=rs),pt=a(l),v=M(l,"P",{"data-svelte-h":!0}),u(v)!=="svelte-1fw5clw"&&(v.textContent=Us),Mt=a(l),j(V.$$.fragment,l),it=a(l),j(_.$$.fragment,l),jt=a(l),S=M(l,"P",{"data-svelte-h":!0}),u(S)!=="svelte-1b5lb69"&&(S.textContent=hs),mt=a(l),x=M(l,"P",{"data-svelte-h":!0}),u(x)!=="svelte-1qjkre5"&&(x.textContent=ws),dt=a(l),j(H.$$.fragment,l),ot=a(l),X=M(l,"PRE",{"data-svelte-h":!0}),u(X)!=="svelte-19lh5zm"&&(X.textContent=Js),ct=a(l),j(q.$$.fragment,l),ut=a(l),j(Y.$$.fragment,l),yt=a(l),j(z.$$.fragment,l),Tt=a(l),j(F.$$.fragment,l),rt=a(l),j(L.$$.fragment,l),Ut=a(l),P=M(l,"P",{"data-svelte-h":!0}),u(P)!=="svelte-hku60d"&&(P.innerHTML=bs),ht=a(l),D=M(l,"UL",{"data-svelte-h":!0}),u(D)!=="svelte-1wudrob"&&(D.innerHTML=gs),wt=a(l),j(K.$$.fragment,l),Jt=a(l),O=M(l,"P",{"data-svelte-h":!0}),u(O)!=="svelte-1ul0qyr"&&(O.textContent=fs),bt=a(l),ll=M(l,"UL",{"data-svelte-h":!0}),u(ll)!=="svelte-9ob4d1"&&(ll.innerHTML=Is),gt=a(l),j(tl.$$.fragment,l),ft=a(l),j(sl.$$.fragment,l),It=a(l),el=M(l,"PRE",{"data-svelte-h":!0}),u(el)!=="svelte-19liytu"&&(el.textContent=$s),$t=a(l),nl=M(l,"P",{"data-svelte-h":!0}),u(nl)!=="svelte-12l6vzi"&&(nl.innerHTML=As),At=a(l),j(al.$$.fragment,l),Ct=a(l),pl=M(l,"P",{"data-svelte-h":!0}),u(pl)!=="svelte-x6ui04"&&(pl.textContent=Cs),Bt=a(l),j(Ml.$$.fragment,l),Zt=a(l),il=M(l,"PRE",{"data-svelte-h":!0}),u(il)!=="svelte-11ebe9s"&&(il.textContent=Bs),Wt=a(l),j(jl.$$.fragment,l),Rt=a(l),ml=M(l,"P",{"data-svelte-h":!0}),u(ml)!=="svelte-yr8pow"&&(ml.innerHTML=Zs),kt=a(l),j(dl.$$.fragment,l),Gt=a(l),j(ol.$$.fragment,l),Et=a(l),cl=M(l,"PRE",{"data-svelte-h":!0}),u(cl)!=="svelte-ff4u6w"&&(cl.textContent=Ws),Qt=a(l),j(ul.$$.fragment,l),Nt=a(l),yl=M(l,"P",{"data-svelte-h":!0}),u(yl)!=="svelte-5f3lhv"&&(yl.textContent=Rs),vt=a(l),j(Tl.$$.fragment,l),Vt=a(l),rl=M(l,"PRE",{"data-svelte-h":!0}),u(rl)!=="svelte-v5xolv"&&(rl.textContent=ks),_t=a(l),j(Ul.$$.fragment,l),St=a(l),hl=M(l,"P",{"data-svelte-h":!0}),u(hl)!=="svelte-6kwgar"&&(hl.innerHTML=Gs),xt=a(l),j(wl.$$.fragment,l),Ht=a(l),Jl=M(l,"P",{"data-svelte-h":!0}),u(Jl)!=="svelte-1uolelw"&&(Jl.innerHTML=Es),Xt=a(l),j(bl.$$.fragment,l),qt=a(l),j(gl.$$.fragment,l),Yt=a(l),fl=M(l,"PRE",{"data-svelte-h":!0}),u(fl)!=="svelte-dj57zs"&&(fl.textContent=Qs),zt=a(l),j(Il.$$.fragment,l),Ft=a(l),$l=M(l,"OL",{"data-svelte-h":!0}),u($l)!=="svelte-gpezbg"&&($l.innerHTML=Ns),Lt=a(l),j(Al.$$.fragment,l),Pt=a(l),Cl=M(l,"PRE",{"data-svelte-h":!0}),u(Cl)!=="svelte-109618w"&&(Cl.textContent=vs),Dt=a(l),j(Bl.$$.fragment,l),Kt=a(l),Zl=M(l,"PRE",{"data-svelte-h":!0}),u(Zl)!=="svelte-1gk9phr"&&(Zl.textContent=Vs),Ot=a(l),Wl=M(l,"P",{"data-svelte-h":!0}),u(Wl)!=="svelte-f3ucyx"&&(Wl.innerHTML=_s),ls=a(l),j(Rl.$$.fragment,l),ts=a(l),kl=M(l,"P",{"data-svelte-h":!0}),u(kl)!=="svelte-1tw7uc3"&&(kl.textContent=Ss),ss=a(l),Gl=M(l,"P",{"data-svelte-h":!0}),u(Gl)!=="svelte-1124toy"&&(Gl.innerHTML=xs),es=a(l),j(El.$$.fragment,l),ns=a(l),Ql=M(l,"PRE",{"data-svelte-h":!0}),u(Ql)!=="svelte-ulyp9n"&&(Ql.textContent=Hs),as=a(l),vl=M(l,"P",{}),Xs(vl).forEach(s),this.h()},h(){qs(r,"name","hf:doc:metadata"),qs(r,"content",te)},m(l,t){Ks(document.head,r),e(l,Vl,t),e(l,Nl,t),e(l,_l,t),m(U,l,t),e(l,Sl,t),m(h,l,t),e(l,xl,t),e(l,w,t),e(l,Hl,t),m(J,l,t),e(l,Xl,t),e(l,b,t),e(l,ql,t),m(g,l,t),e(l,Yl,t),e(l,f,t),e(l,zl,t),e(l,I,t),e(l,Fl,t),e(l,$,t),e(l,Ll,t),e(l,A,t),e(l,Pl,t),m(C,l,t),e(l,Dl,t),m(B,l,t),e(l,Kl,t),m(Z,l,t),e(l,Ol,t),m(W,l,t),e(l,lt,t),m(R,l,t),e(l,tt,t),e(l,k,t),e(l,st,t),e(l,G,t),e(l,et,t),m(E,l,t),e(l,nt,t),e(l,Q,t),e(l,at,t),e(l,N,t),e(l,pt,t),e(l,v,t),e(l,Mt,t),m(V,l,t),e(l,it,t),m(_,l,t),e(l,jt,t),e(l,S,t),e(l,mt,t),e(l,x,t),e(l,dt,t),m(H,l,t),e(l,ot,t),e(l,X,t),e(l,ct,t),m(q,l,t),e(l,ut,t),m(Y,l,t),e(l,yt,t),m(z,l,t),e(l,Tt,t),m(F,l,t),e(l,rt,t),m(L,l,t),e(l,Ut,t),e(l,P,t),e(l,ht,t),e(l,D,t),e(l,wt,t),m(K,l,t),e(l,Jt,t),e(l,O,t),e(l,bt,t),e(l,ll,t),e(l,gt,t),m(tl,l,t),e(l,ft,t),m(sl,l,t),e(l,It,t),e(l,el,t),e(l,$t,t),e(l,nl,t),e(l,At,t),m(al,l,t),e(l,Ct,t),e(l,pl,t),e(l,Bt,t),m(Ml,l,t),e(l,Zt,t),e(l,il,t),e(l,Wt,t),m(jl,l,t),e(l,Rt,t),e(l,ml,t),e(l,kt,t),m(dl,l,t),e(l,Gt,t),m(ol,l,t),e(l,Et,t),e(l,cl,t),e(l,Qt,t),m(ul,l,t),e(l,Nt,t),e(l,yl,t),e(l,vt,t),m(Tl,l,t),e(l,Vt,t),e(l,rl,t),e(l,_t,t),m(Ul,l,t),e(l,St,t),e(l,hl,t),e(l,xt,t),m(wl,l,t),e(l,Ht,t),e(l,Jl,t),e(l,Xt,t),m(bl,l,t),e(l,qt,t),m(gl,l,t),e(l,Yt,t),e(l,fl,t),e(l,zt,t),m(Il,l,t),e(l,Ft,t),e(l,$l,t),e(l,Lt,t),m(Al,l,t),e(l,Pt,t),e(l,Cl,t),e(l,Dt,t),m(Bl,l,t),e(l,Kt,t),e(l,Zl,t),e(l,Ot,t),e(l,Wl,t),e(l,ls,t),m(Rl,l,t),e(l,ts,t),e(l,kl,t),e(l,ss,t),e(l,Gl,t),e(l,es,t),m(El,l,t),e(l,ns,t),e(l,Ql,t),e(l,as,t),e(l,vl,t),ps=!0},p:zs,i(l){ps||(d(U.$$.fragment,l),d(h.$$.fragment,l),d(J.$$.fragment,l),d(g.$$.fragment,l),d(C.$$.fragment,l),d(B.$$.fragment,l),d(Z.$$.fragment,l),d(W.$$.fragment,l),d(R.$$.fragment,l),d(E.$$.fragment,l),d(V.$$.fragment,l),d(_.$$.fragment,l),d(H.$$.fragment,l),d(q.$$.fragment,l),d(Y.$$.fragment,l),d(z.$$.fragment,l),d(F.$$.fragment,l),d(L.$$.fragment,l),d(K.$$.fragment,l),d(tl.$$.fragment,l),d(sl.$$.fragment,l),d(al.$$.fragment,l),d(Ml.$$.fragment,l),d(jl.$$.fragment,l),d(dl.$$.fragment,l),d(ol.$$.fragment,l),d(ul.$$.fragment,l),d(Tl.$$.fragment,l),d(Ul.$$.fragment,l),d(wl.$$.fragment,l),d(bl.$$.fragment,l),d(gl.$$.fragment,l),d(Il.$$.fragment,l),d(Al.$$.fragment,l),d(Bl.$$.fragment,l),d(Rl.$$.fragment,l),d(El.$$.fragment,l),ps=!0)},o(l){o(U.$$.fragment,l),o(h.$$.fragment,l),o(J.$$.fragment,l),o(g.$$.fragment,l),o(C.$$.fragment,l),o(B.$$.fragment,l),o(Z.$$.fragment,l),o(W.$$.fragment,l),o(R.$$.fragment,l),o(E.$$.fragment,l),o(V.$$.fragment,l),o(_.$$.fragment,l),o(H.$$.fragment,l),o(q.$$.fragment,l),o(Y.$$.fragment,l),o(z.$$.fragment,l),o(F.$$.fragment,l),o(L.$$.fragment,l),o(K.$$.fragment,l),o(tl.$$.fragment,l),o(sl.$$.fragment,l),o(al.$$.fragment,l),o(Ml.$$.fragment,l),o(jl.$$.fragment,l),o(dl.$$.fragment,l),o(ol.$$.fragment,l),o(ul.$$.fragment,l),o(Tl.$$.fragment,l),o(Ul.$$.fragment,l),o(wl.$$.fragment,l),o(bl.$$.fragment,l),o(gl.$$.fragment,l),o(Il.$$.fragment,l),o(Al.$$.fragment,l),o(Bl.$$.fragment,l),o(Rl.$$.fragment,l),o(El.$$.fragment,l),ps=!1},d(l){l&&(s(Vl),s(Nl),s(_l),s(Sl),s(xl),s(w),s(Hl),s(Xl),s(b),s(ql),s(Yl),s(f),s(zl),s(I),s(Fl),s($),s(Ll),s(A),s(Pl),s(Dl),s(Kl),s(Ol),s(lt),s(tt),s(k),s(st),s(G),s(et),s(nt),s(Q),s(at),s(N),s(pt),s(v),s(Mt),s(it),s(jt),s(S),s(mt),s(x),s(dt),s(ot),s(X),s(ct),s(ut),s(yt),s(Tt),s(rt),s(Ut),s(P),s(ht),s(D),s(wt),s(Jt),s(O),s(bt),s(ll),s(gt),s(ft),s(It),s(el),s($t),s(nl),s(At),s(Ct),s(pl),s(Bt),s(Zt),s(il),s(Wt),s(Rt),s(ml),s(kt),s(Gt),s(Et),s(cl),s(Qt),s(Nt),s(yl),s(vt),s(Vt),s(rl),s(_t),s(St),s(hl),s(xt),s(Ht),s(Jl),s(Xt),s(qt),s(Yt),s(fl),s(zt),s(Ft),s($l),s(Lt),s(Pt),s(Cl),s(Dt),s(Kt),s(Zl),s(Ot),s(Wl),s(ls),s(ts),s(kl),s(ss),s(Gl),s(es),s(ns),s(Ql),s(as),s(vl)),s(r),c(U,l),c(h,l),c(J,l),c(g,l),c(C,l),c(B,l),c(Z,l),c(W,l),c(R,l),c(E,l),c(V,l),c(_,l),c(H,l),c(q,l),c(Y,l),c(z,l),c(F,l),c(L,l),c(K,l),c(tl,l),c(sl,l),c(al,l),c(Ml,l),c(jl,l),c(dl,l),c(ol,l),c(ul,l),c(Tl,l),c(Ul,l),c(wl,l),c(bl,l),c(gl,l),c(Il,l),c(Al,l),c(Bl,l),c(Rl,l),c(El,l)}}}const te='{"title":"怎么使用推理端点去嵌入文档","local":"怎么使用推理端点去嵌入文档","sections":[{"title":"目标","local":"目标","sections":[],"depth":2},{"title":"方法","local":"方法","sections":[],"depth":2},{"title":"环境(Requirements)","local":"环境requirements","sections":[],"depth":2},{"title":"导入包","local":"导入包","sections":[],"depth":2},{"title":"设置(Config)","local":"设置config","sections":[],"depth":2},{"title":"获取数据","local":"获取数据","sections":[],"depth":2}],"depth":1}';function se(Ms){return Fs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Me extends Ls{constructor(r){super(),Ps(this,r,se,le,Ys,{})}}export{Me as component};
