import{s as me,a as Nt,n as he,o as de}from"../chunks/scheduler.505acc25.js";import{S as Me,i as Te,e as p,s as n,c as r,h as ce,a as i,d as s,b as a,f as ue,g as y,j as o,k as T,l as Je,m as l,n as u,t as m,o as h,p as d}from"../chunks/index.fbb49fb4.js";import{C as ge}from"../chunks/CopyLLMTxtMenu.564b44fd.js";import{C as O}from"../chunks/CodeBlock.7f0851b7.js";import{H as tt}from"../chunks/Heading.511e0027.js";import{E as Ue}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8c19e80e.js";function we(Vt){let M,lt,et,nt,J,at,g,pt,U,Qt="To build applications with LangGraph, you need to understand its core components. Let’s explore the fundamental building blocks that make up a LangGraph application.",it,c,Wt,ot,w,Yt="An application in LangGraph starts from an <strong>entrypoint</strong>, and depending on the execution, the flow may go to one function or another until it reaches the END.",rt,f,zt,yt,I,ut,j,Kt="<strong>State</strong> is the central concept in LangGraph. It represents all the information that flows through your application.",mt,$,ht,b,At="The state is <strong>User defined</strong>, hence the fields should carefully be crafted to contain all data needed for decision-making process!",dt,C,Ft="<p>💡 <strong>Tip:</strong> Think carefully about what information your application needs to track between steps.</p>",Mt,k,Tt,B,Pt="<strong>Nodes</strong> are python functions. Each node:",ct,_,Dt="<li>Takes the state as input</li> <li>Performs some operation</li> <li>Returns updates to the state</li>",Jt,G,gt,Z,Ot="For example, Nodes can contain:",Ut,x,te="<li><strong>LLM calls</strong>: Generate text or make decisions</li> <li><strong>Tool calls</strong>: Interact with external systems</li> <li><strong>Conditional logic</strong>: Determine next steps</li> <li><strong>Human intervention</strong>: Get input from users</li>",wt,S,ee="<p>💡 <strong>Info:</strong> Some nodes necessary for the whole workflow like START and END exist from langGraph directly.</p>",ft,v,It,R,se="<strong>Edges</strong> connect nodes and define the possible paths through your graph:",jt,L,$t,H,le="Edges can be:",bt,X,ne="<li><strong>Direct</strong>: Always go from node A to node B</li> <li><strong>Conditional</strong>: Choose the next node based on the current state</li>",Ct,q,kt,E,ae="The <strong>StateGraph</strong> is the container that holds your entire agent workflow:",Bt,N,_t,V,pe="Which can then be visualized!",Gt,Q,Zt,W,ie,xt,Y,oe="But most importantly, invoked:",St,z,vt,K,re="output :",Rt,A,Lt,F,Ht,P,ye="In the next section, we’ll put these concepts into practice by building our first graph. This graph lets Alfred take in your e-mails, classify them, and craft a preliminary answer if they are genuine.",Xt,D,qt,st,Et;return J=new ge({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),g=new tt({props:{title:"Building Blocks of LangGraph",local:"building-blocks-of-langgraph",headingTag:"h1"}}),I=new tt({props:{title:"1. State",local:"1-state",headingTag:"h2"}}),$=new O({props:{code:"ZnJvbSUyMHR5cGluZ19leHRlbnNpb25zJTIwaW1wb3J0JTIwVHlwZWREaWN0JTBBJTBBY2xhc3MlMjBTdGF0ZShUeXBlZERpY3QpJTNBJTBBJTIwJTIwJTIwJTIwZ3JhcGhfc3RhdGUlM0ElMjBzdHI=",highlighted:`<span class="hljs-keyword">from</span> typing_extensions <span class="hljs-keyword">import</span> TypedDict

<span class="hljs-keyword">class</span> <span class="hljs-title class_">State</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    graph_state: <span class="hljs-built_in">str</span>`,wrap:!1}}),k=new tt({props:{title:"2. Nodes",local:"2-nodes",headingTag:"h2"}}),G=new O({props:{code:"ZGVmJTIwbm9kZV8xKHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMi0tLU5vZGUlMjAxLS0tJTIyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmdyYXBoX3N0YXRlJTIyJTNBJTIwc3RhdGUlNUInZ3JhcGhfc3RhdGUnJTVEJTIwJTJCJTIyJTIwSSUyMGFtJTIyJTdEJTBBJTBBZGVmJTIwbm9kZV8yKHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMi0tLU5vZGUlMjAyLS0tJTIyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmdyYXBoX3N0YXRlJTIyJTNBJTIwc3RhdGUlNUInZ3JhcGhfc3RhdGUnJTVEJTIwJTJCJTIyJTIwaGFwcHkhJTIyJTdEJTBBJTBBZGVmJTIwbm9kZV8zKHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMi0tLU5vZGUlMjAzLS0tJTIyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmdyYXBoX3N0YXRlJTIyJTNBJTIwc3RhdGUlNUInZ3JhcGhfc3RhdGUnJTVEJTIwJTJCJTIyJTIwc2FkISUyMiU3RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">node_1</span>(<span class="hljs-params">state</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;---Node 1---&quot;</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;graph_state&quot;</span>: state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] +<span class="hljs-string">&quot; I am&quot;</span>}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">node_2</span>(<span class="hljs-params">state</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;---Node 2---&quot;</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;graph_state&quot;</span>: state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] +<span class="hljs-string">&quot; happy!&quot;</span>}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">node_3</span>(<span class="hljs-params">state</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;---Node 3---&quot;</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;graph_state&quot;</span>: state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] +<span class="hljs-string">&quot; sad!&quot;</span>}`,wrap:!1}}),v=new tt({props:{title:"3. Edges",local:"3-edges",headingTag:"h2"}}),L=new O({props:{code:"aW1wb3J0JTIwcmFuZG9tJTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMExpdGVyYWwlMEElMEFkZWYlMjBkZWNpZGVfbW9vZChzdGF0ZSklMjAtJTNFJTIwTGl0ZXJhbCU1QiUyMm5vZGVfMiUyMiUyQyUyMCUyMm5vZGVfMyUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyME9mdGVuJTJDJTIwd2UlMjB3aWxsJTIwdXNlJTIwc3RhdGUlMjB0byUyMGRlY2lkZSUyMG9uJTIwdGhlJTIwbmV4dCUyMG5vZGUlMjB0byUyMHZpc2l0JTBBJTIwJTIwJTIwJTIwdXNlcl9pbnB1dCUyMCUzRCUyMHN0YXRlJTVCJ2dyYXBoX3N0YXRlJyU1RCUyMCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMEhlcmUlMkMlMjBsZXQncyUyMGp1c3QlMjBkbyUyMGElMjA1MCUyMCUyRiUyMDUwJTIwc3BsaXQlMjBiZXR3ZWVuJTIwbm9kZXMlMjAyJTJDJTIwMyUwQSUyMCUyMCUyMCUyMGlmJTIwcmFuZG9tLnJhbmRvbSgpJTIwJTNDJTIwMC41JTNBJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwNTAlMjUlMjBvZiUyMHRoZSUyMHRpbWUlMkMlMjB3ZSUyMHJldHVybiUyME5vZGUlMjAyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIybm9kZV8yJTIyJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwNTAlMjUlMjBvZiUyMHRoZSUyMHRpbWUlMkMlMjB3ZSUyMHJldHVybiUyME5vZGUlMjAzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIybm9kZV8zJTIy",highlighted:`<span class="hljs-keyword">import</span> random
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Literal</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">decide_mood</span>(<span class="hljs-params">state</span>) -&gt; <span class="hljs-type">Literal</span>[<span class="hljs-string">&quot;node_2&quot;</span>, <span class="hljs-string">&quot;node_3&quot;</span>]:
    
    <span class="hljs-comment"># Often, we will use state to decide on the next node to visit</span>
    user_input = state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] 
    
    <span class="hljs-comment"># Here, let&#x27;s just do a 50 / 50 split between nodes 2, 3</span>
    <span class="hljs-keyword">if</span> random.random() &lt; <span class="hljs-number">0.5</span>:

        <span class="hljs-comment"># 50% of the time, we return Node 2</span>
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;node_2&quot;</span>
    
    <span class="hljs-comment"># 50% of the time, we return Node 3</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;node_3&quot;</span>`,wrap:!1}}),q=new tt({props:{title:"4. StateGraph",local:"4-stategraph",headingTag:"h2"}}),N=new O({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEltYWdlJTJDJTIwZGlzcGxheSUwQWZyb20lMjBsYW5nZ3JhcGguZ3JhcGglMjBpbXBvcnQlMjBTdGF0ZUdyYXBoJTJDJTIwU1RBUlQlMkMlMjBFTkQlMEElMEElMjMlMjBCdWlsZCUyMGdyYXBoJTBBYnVpbGRlciUyMCUzRCUyMFN0YXRlR3JhcGgoU3RhdGUpJTBBYnVpbGRlci5hZGRfbm9kZSglMjJub2RlXzElMjIlMkMlMjBub2RlXzEpJTBBYnVpbGRlci5hZGRfbm9kZSglMjJub2RlXzIlMjIlMkMlMjBub2RlXzIpJTBBYnVpbGRlci5hZGRfbm9kZSglMjJub2RlXzMlMjIlMkMlMjBub2RlXzMpJTBBJTBBJTIzJTIwTG9naWMlMEFidWlsZGVyLmFkZF9lZGdlKFNUQVJUJTJDJTIwJTIybm9kZV8xJTIyKSUwQWJ1aWxkZXIuYWRkX2NvbmRpdGlvbmFsX2VkZ2VzKCUyMm5vZGVfMSUyMiUyQyUyMGRlY2lkZV9tb29kKSUwQWJ1aWxkZXIuYWRkX2VkZ2UoJTIybm9kZV8yJTIyJTJDJTIwRU5EKSUwQWJ1aWxkZXIuYWRkX2VkZ2UoJTIybm9kZV8zJTIyJTJDJTIwRU5EKSUwQSUwQSUyMyUyMEFkZCUwQWdyYXBoJTIwJTNEJTIwYnVpbGRlci5jb21waWxlKCk=",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Image, display
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> StateGraph, START, END

<span class="hljs-comment"># Build graph</span>
builder = StateGraph(State)
builder.add_node(<span class="hljs-string">&quot;node_1&quot;</span>, node_1)
builder.add_node(<span class="hljs-string">&quot;node_2&quot;</span>, node_2)
builder.add_node(<span class="hljs-string">&quot;node_3&quot;</span>, node_3)

<span class="hljs-comment"># Logic</span>
builder.add_edge(START, <span class="hljs-string">&quot;node_1&quot;</span>)
builder.add_conditional_edges(<span class="hljs-string">&quot;node_1&quot;</span>, decide_mood)
builder.add_edge(<span class="hljs-string">&quot;node_2&quot;</span>, END)
builder.add_edge(<span class="hljs-string">&quot;node_3&quot;</span>, END)

<span class="hljs-comment"># Add</span>
graph = builder.<span class="hljs-built_in">compile</span>()`,wrap:!1}}),Q=new O({props:{code:"JTIzJTIwVmlldyUwQWRpc3BsYXkoSW1hZ2UoZ3JhcGguZ2V0X2dyYXBoKCkuZHJhd19tZXJtYWlkX3BuZygpKSk=",highlighted:`<span class="hljs-comment"># View</span>
display(Image(graph.get_graph().draw_mermaid_png()))`,wrap:!1}}),z=new O({props:{code:"Z3JhcGguaW52b2tlKCU3QiUyMmdyYXBoX3N0YXRlJTIyJTIwJTNBJTIwJTIySGklMkMlMjB0aGlzJTIwaXMlMjBMYW5jZS4lMjIlN0Qp",highlighted:'graph.invoke({<span class="hljs-string">&quot;graph_state&quot;</span> : <span class="hljs-string">&quot;Hi, this is Lance.&quot;</span>})',wrap:!1}}),A=new O({props:{code:"LS0tTm9kZSUyMDEtLS0lMEEtLS1Ob2RlJTIwMy0tLSUwQSU3QidncmFwaF9zdGF0ZSclM0ElMjAnSGklMkMlMjB0aGlzJTIwaXMlMjBMYW5jZS4lMjBJJTIwYW0lMjBzYWQhJyU3RA==",highlighted:`---<span class="hljs-keyword">Node</span> <span class="hljs-title">1---</span>
---<span class="hljs-keyword">Node</span> <span class="hljs-title">3---</span>
{&#x27;graph_state&#x27;: &#x27;Hi, this is Lance. I am sad!&#x27;}`,wrap:!1}}),F=new tt({props:{title:"What’s Next?",local:"whats-next",headingTag:"h2"}}),D=new Ue({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/langgraph/building_blocks.mdx"}}),{c(){M=p("meta"),lt=n(),et=p("p"),nt=n(),r(J.$$.fragment),at=n(),r(g.$$.fragment),pt=n(),U=p("p"),U.textContent=Qt,it=n(),c=p("img"),ot=n(),w=p("p"),w.innerHTML=Yt,rt=n(),f=p("img"),yt=n(),r(I.$$.fragment),ut=n(),j=p("p"),j.innerHTML=Kt,mt=n(),r($.$$.fragment),ht=n(),b=p("p"),b.innerHTML=At,dt=n(),C=p("blockquote"),C.innerHTML=Ft,Mt=n(),r(k.$$.fragment),Tt=n(),B=p("p"),B.innerHTML=Pt,ct=n(),_=p("ul"),_.innerHTML=Dt,Jt=n(),r(G.$$.fragment),gt=n(),Z=p("p"),Z.textContent=Ot,Ut=n(),x=p("ul"),x.innerHTML=te,wt=n(),S=p("blockquote"),S.innerHTML=ee,ft=n(),r(v.$$.fragment),It=n(),R=p("p"),R.innerHTML=se,jt=n(),r(L.$$.fragment),$t=n(),H=p("p"),H.textContent=le,bt=n(),X=p("ul"),X.innerHTML=ne,Ct=n(),r(q.$$.fragment),kt=n(),E=p("p"),E.innerHTML=ae,Bt=n(),r(N.$$.fragment),_t=n(),V=p("p"),V.textContent=pe,Gt=n(),r(Q.$$.fragment),Zt=n(),W=p("img"),xt=n(),Y=p("p"),Y.textContent=oe,St=n(),r(z.$$.fragment),vt=n(),K=p("p"),K.textContent=re,Rt=n(),r(A.$$.fragment),Lt=n(),r(F.$$.fragment),Ht=n(),P=p("p"),P.textContent=ye,Xt=n(),r(D.$$.fragment),qt=n(),st=p("p"),this.h()},l(t){const e=ce("svelte-u9bgzb",document.head);M=i(e,"META",{name:!0,content:!0}),e.forEach(s),lt=a(t),et=i(t,"P",{}),ue(et).forEach(s),nt=a(t),y(J.$$.fragment,t),at=a(t),y(g.$$.fragment,t),pt=a(t),U=i(t,"P",{"data-svelte-h":!0}),o(U)!=="svelte-s50h74"&&(U.textContent=Qt),it=a(t),c=i(t,"IMG",{src:!0,alt:!0,width:!0}),ot=a(t),w=i(t,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1n29p4d"&&(w.innerHTML=Yt),rt=a(t),f=i(t,"IMG",{src:!0,alt:!0}),yt=a(t),y(I.$$.fragment,t),ut=a(t),j=i(t,"P",{"data-svelte-h":!0}),o(j)!=="svelte-13mfgi9"&&(j.innerHTML=Kt),mt=a(t),y($.$$.fragment,t),ht=a(t),b=i(t,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1nv9oba"&&(b.innerHTML=At),dt=a(t),C=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),o(C)!=="svelte-7zvkss"&&(C.innerHTML=Ft),Mt=a(t),y(k.$$.fragment,t),Tt=a(t),B=i(t,"P",{"data-svelte-h":!0}),o(B)!=="svelte-bl6xu8"&&(B.innerHTML=Pt),ct=a(t),_=i(t,"UL",{"data-svelte-h":!0}),o(_)!=="svelte-1ojc0n6"&&(_.innerHTML=Dt),Jt=a(t),y(G.$$.fragment,t),gt=a(t),Z=i(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-16qrzia"&&(Z.textContent=Ot),Ut=a(t),x=i(t,"UL",{"data-svelte-h":!0}),o(x)!=="svelte-opt97h"&&(x.innerHTML=te),wt=a(t),S=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),o(S)!=="svelte-15fspvc"&&(S.innerHTML=ee),ft=a(t),y(v.$$.fragment,t),It=a(t),R=i(t,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1da8kr2"&&(R.innerHTML=se),jt=a(t),y(L.$$.fragment,t),$t=a(t),H=i(t,"P",{"data-svelte-h":!0}),o(H)!=="svelte-edfl2t"&&(H.textContent=le),bt=a(t),X=i(t,"UL",{"data-svelte-h":!0}),o(X)!=="svelte-1q9eq0"&&(X.innerHTML=ne),Ct=a(t),y(q.$$.fragment,t),kt=a(t),E=i(t,"P",{"data-svelte-h":!0}),o(E)!=="svelte-g73ioo"&&(E.innerHTML=ae),Bt=a(t),y(N.$$.fragment,t),_t=a(t),V=i(t,"P",{"data-svelte-h":!0}),o(V)!=="svelte-147pt7a"&&(V.textContent=pe),Gt=a(t),y(Q.$$.fragment,t),Zt=a(t),W=i(t,"IMG",{src:!0,alt:!0}),xt=a(t),Y=i(t,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-12bcwpz"&&(Y.textContent=oe),St=a(t),y(z.$$.fragment,t),vt=a(t),K=i(t,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1wdnc59"&&(K.textContent=re),Rt=a(t),y(A.$$.fragment,t),Lt=a(t),y(F.$$.fragment,t),Ht=a(t),P=i(t,"P",{"data-svelte-h":!0}),o(P)!=="svelte-p74a0p"&&(P.textContent=ye),Xt=a(t),y(D.$$.fragment,t),qt=a(t),st=i(t,"P",{}),ue(st).forEach(s),this.h()},h(){T(M,"name","hf:doc:metadata"),T(M,"content",fe),Nt(c.src,Wt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/Building_blocks.png")||T(c,"src",Wt),T(c,"alt","Building Blocks"),T(c,"width","70%"),Nt(f.src,zt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/application.png")||T(f,"src",zt),T(f,"alt","Application"),Nt(W.src,ie="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/basic_graph.jpeg")||T(W,"src",ie),T(W,"alt","Graph Visualization")},m(t,e){Je(document.head,M),l(t,lt,e),l(t,et,e),l(t,nt,e),u(J,t,e),l(t,at,e),u(g,t,e),l(t,pt,e),l(t,U,e),l(t,it,e),l(t,c,e),l(t,ot,e),l(t,w,e),l(t,rt,e),l(t,f,e),l(t,yt,e),u(I,t,e),l(t,ut,e),l(t,j,e),l(t,mt,e),u($,t,e),l(t,ht,e),l(t,b,e),l(t,dt,e),l(t,C,e),l(t,Mt,e),u(k,t,e),l(t,Tt,e),l(t,B,e),l(t,ct,e),l(t,_,e),l(t,Jt,e),u(G,t,e),l(t,gt,e),l(t,Z,e),l(t,Ut,e),l(t,x,e),l(t,wt,e),l(t,S,e),l(t,ft,e),u(v,t,e),l(t,It,e),l(t,R,e),l(t,jt,e),u(L,t,e),l(t,$t,e),l(t,H,e),l(t,bt,e),l(t,X,e),l(t,Ct,e),u(q,t,e),l(t,kt,e),l(t,E,e),l(t,Bt,e),u(N,t,e),l(t,_t,e),l(t,V,e),l(t,Gt,e),u(Q,t,e),l(t,Zt,e),l(t,W,e),l(t,xt,e),l(t,Y,e),l(t,St,e),u(z,t,e),l(t,vt,e),l(t,K,e),l(t,Rt,e),u(A,t,e),l(t,Lt,e),u(F,t,e),l(t,Ht,e),l(t,P,e),l(t,Xt,e),u(D,t,e),l(t,qt,e),l(t,st,e),Et=!0},p:he,i(t){Et||(m(J.$$.fragment,t),m(g.$$.fragment,t),m(I.$$.fragment,t),m($.$$.fragment,t),m(k.$$.fragment,t),m(G.$$.fragment,t),m(v.$$.fragment,t),m(L.$$.fragment,t),m(q.$$.fragment,t),m(N.$$.fragment,t),m(Q.$$.fragment,t),m(z.$$.fragment,t),m(A.$$.fragment,t),m(F.$$.fragment,t),m(D.$$.fragment,t),Et=!0)},o(t){h(J.$$.fragment,t),h(g.$$.fragment,t),h(I.$$.fragment,t),h($.$$.fragment,t),h(k.$$.fragment,t),h(G.$$.fragment,t),h(v.$$.fragment,t),h(L.$$.fragment,t),h(q.$$.fragment,t),h(N.$$.fragment,t),h(Q.$$.fragment,t),h(z.$$.fragment,t),h(A.$$.fragment,t),h(F.$$.fragment,t),h(D.$$.fragment,t),Et=!1},d(t){t&&(s(lt),s(et),s(nt),s(at),s(pt),s(U),s(it),s(c),s(ot),s(w),s(rt),s(f),s(yt),s(ut),s(j),s(mt),s(ht),s(b),s(dt),s(C),s(Mt),s(Tt),s(B),s(ct),s(_),s(Jt),s(gt),s(Z),s(Ut),s(x),s(wt),s(S),s(ft),s(It),s(R),s(jt),s($t),s(H),s(bt),s(X),s(Ct),s(kt),s(E),s(Bt),s(_t),s(V),s(Gt),s(Zt),s(W),s(xt),s(Y),s(St),s(vt),s(K),s(Rt),s(Lt),s(Ht),s(P),s(Xt),s(qt),s(st)),s(M),d(J,t),d(g,t),d(I,t),d($,t),d(k,t),d(G,t),d(v,t),d(L,t),d(q,t),d(N,t),d(Q,t),d(z,t),d(A,t),d(F,t),d(D,t)}}}const fe='{"title":"Building Blocks of LangGraph","local":"building-blocks-of-langgraph","sections":[{"title":"1. State","local":"1-state","sections":[],"depth":2},{"title":"2. Nodes","local":"2-nodes","sections":[],"depth":2},{"title":"3. Edges","local":"3-edges","sections":[],"depth":2},{"title":"4. StateGraph","local":"4-stategraph","sections":[],"depth":2},{"title":"What’s Next?","local":"whats-next","sections":[],"depth":2}],"depth":1}';function Ie(Vt){return de(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _e extends Me{constructor(M){super(),Te(this,M,Ie,we,me,{})}}export{_e as component};
