import{s as tt,n as lt,o as st}from"../chunks/scheduler.505acc25.js";import{S as nt,i as at,e as i,s as n,c as M,h as it,a as o,d as l,b as a,f as Oe,g as c,j as r,k as Ge,l as ot,m as s,n as p,t as y,o as u,p as J}from"../chunks/index.fbb49fb4.js";import{C as rt}from"../chunks/CopyLLMTxtMenu.564b44fd.js";import{C as et}from"../chunks/CodeBlock.7f0851b7.js";import{C as Mt}from"../chunks/CourseFloatingBanner.742f9db5.js";import{H as L}from"../chunks/Heading.511e0027.js";import{E as ct}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8c19e80e.js";function pt(ke){let T,D,$,P,w,K,d,O,h,ee,m,Re='<p>You can follow the code in <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/retrieval_agents.ipynb" target="_blank">this notebook</a> that you can run using Google Colab.</p>',te,I,Ve="Retrieval Augmented Generation (RAG) systems combine the capabilities of data retrieval and generation models to provide context-aware responses. For example, a user’s query is passed to a search engine, and the retrieved results are given to the model along with the query. The model then generates a response based on the query and retrieved information.",le,j,We="Agentic RAG (Retrieval-Augmented Generation) extends traditional RAG systems by <strong>combining autonomous agents with dynamic knowledge retrieval</strong>.",se,U,qe="While traditional RAG systems use an LLM to answer queries based on retrieved data, agentic RAG <strong>enables intelligent control of both retrieval and generation processes</strong>, improving efficiency and accuracy.",ne,g,Ae="Traditional RAG systems face key limitations, such as <strong>relying on a single retrieval step</strong> and focusing on direct semantic similarity with the user’s query, which may overlook relevant information.",ae,b,Ee="Agentic RAG addresses these issues by allowing the agent to autonomously formulate search queries, critique retrieved results, and conduct multiple retrieval steps for a more tailored and comprehensive output.",ie,f,oe,C,xe="Let’s build a simple agent that can search the web using DuckDuckGo. This agent will retrieve information and synthesize responses to answer queries. With Agentic RAG, Alfred’s agent can:",re,B,Xe="<li>Search for latest superhero party trends</li> <li>Refine results to include luxury elements</li> <li>Synthesize information into a complete plan</li>",Me,v,Ne="Here’s how Alfred’s agent can achieve this:",ce,Z,pe,G,Se="The agent follows this process:",ye,k,_e="<li><strong>Analyzes the Request:</strong> Alfred’s agent identifies the key elements of the query—luxury superhero-themed party planning, with focus on decor, entertainment, and catering.</li> <li><strong>Performs Retrieval:</strong>  The agent leverages DuckDuckGo to search for the most relevant and up-to-date information, ensuring it aligns with Alfred’s refined preferences for a luxurious event.</li> <li><strong>Synthesizes Information:</strong> After gathering the results, the agent processes them into a cohesive, actionable plan for Alfred, covering all aspects of the party.</li> <li><strong>Stores for Future Reference:</strong> The agent stores the retrieved information for easy access when planning future events, optimizing efficiency in subsequent tasks.</li>",ue,R,Je,V,Ye="For specialized tasks, a custom knowledge base can be invaluable. Let’s create a tool that queries a vector database of technical documentation or specialized knowledge. Using semantic search, the agent can find the most relevant information for Alfred’s needs.",Te,W,ze="A vector database stores numerical representations (embeddings) of text or other data, created by machine learning models. It enables semantic search by identifying similar meanings in high-dimensional space.",me,q,Qe="This approach combines predefined knowledge with semantic search to provide context-aware solutions for event planning. With specialized knowledge access, Alfred can perfect every detail of the party.",we,A,He="In this example, we’ll create a tool that retrieves party planning ideas from a custom knowledge base. We’ll use a BM25 retriever to search the knowledge base and return the top results, and <code>RecursiveCharacterTextSplitter</code> to split the documents into smaller chunks for more efficient search.",de,E,he,x,$e="This enhanced agent can:",Ie,X,Fe="<li>First check the documentation for relevant information</li> <li>Combine insights from the knowledge base</li> <li>Maintain conversation context in memory</li>",je,N,Ue,S,Le="When building agentic RAG systems, the agent can employ sophisticated strategies like:",ge,_,De="<li><strong>Query Reformulation:</strong> Instead of using the raw user query, the agent can craft optimized search terms that better match the target documents</li> <li><strong>Query Decomposition:</strong> Instead of using the user query directly, if it contains multiple pieces of information to query, it can be decomposed to multiple queries</li> <li><strong>Query Expansion:</strong> Somehow similar to Query Reformulation but done multiple times to put the query in multiple wordings to query them all</li> <li><strong>Reranking:</strong> Using Cross-Encoders to assign more comprehensive and semantic relevance scores between retrieved documents and search query</li> <li><strong>Multi-Step Retrieval:</strong> The agent can perform multiple searches, using initial results to inform subsequent queries</li> <li><strong>Source Integration:</strong> Information can be combined from multiple sources like web search and local documentation</li> <li><strong>Result Validation:</strong> Retrieved content can be analyzed for relevance and accuracy before being included in responses</li>",be,Y,Pe="Effective agentic RAG systems require careful consideration of several key aspects. The agent <strong>should select between available tools based on the query type and context</strong>. Memory systems help maintain conversation history and avoid repetitive retrievals. Having fallback strategies ensures the system can still provide value even when primary retrieval methods fail. Additionally, implementing validation steps helps ensure the accuracy and relevance of retrieved information.",fe,z,Ce,Q,Ke='<li><a href="https://huggingface.co/learn/cookbook/agent_rag" rel="nofollow">Agentic RAG: turbocharge your RAG with query reformulation and self-query! 🚀</a> - Recipe for developing an Agentic RAG system using smolagents.</li>',Be,H,ve,F,Ze;return w=new Mt({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/retrieval_agents.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),d=new rt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),h=new L({props:{title:"Building Agentic RAG Systems",local:"building-agentic-rag-systems",headingTag:"h1"}}),f=new L({props:{title:"Basic Retrieval with DuckDuckGo",local:"basic-retrieval-with-duckduckgo",headingTag:"h2"}}),Z=new et({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEluZmVyZW5jZUNsaWVudE1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6ZSUyMHRoZSUyMHNlYXJjaCUyMHRvb2wlMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEElMEElMjMlMjBJbml0aWFsaXplJTIwdGhlJTIwbW9kZWwlMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKCklMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJzZWFyY2hfdG9vbCU1RCUyQyUwQSklMEElMEElMjMlMjBFeGFtcGxlJTIwdXNhZ2UlMEFyZXNwb25zZSUyMCUzRCUyMGFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjJTZWFyY2glMjBmb3IlMjBsdXh1cnklMjBzdXBlcmhlcm8tdGhlbWVkJTIwcGFydHklMjBpZGVhcyUyQyUyMGluY2x1ZGluZyUyMGRlY29yYXRpb25zJTJDJTIwZW50ZXJ0YWlubWVudCUyQyUyMGFuZCUyMGNhdGVyaW5nLiUyMiUwQSklMEFwcmludChyZXNwb25zZSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, InferenceClientModel

<span class="hljs-comment"># Initialize the search tool</span>
search_tool = DuckDuckGoSearchTool()

<span class="hljs-comment"># Initialize the model</span>
model = InferenceClientModel()

agent = CodeAgent(
    model=model,
    tools=[search_tool],
)

<span class="hljs-comment"># Example usage</span>
response = agent.run(
    <span class="hljs-string">&quot;Search for luxury superhero-themed party ideas, including decorations, entertainment, and catering.&quot;</span>
)
<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),R=new L({props:{title:"Custom Knowledge Base Tool",local:"custom-knowledge-base-tool",headingTag:"h2"}}),E=new et({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> langchain_community.retrievers <span class="hljs-keyword">import</span> BM25Retriever
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PartyPlanningRetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;party_planning_retriever&quot;</span>
    description = <span class="hljs-string">&quot;Uses semantic search to retrieve relevant party planning ideas for Alfred’s superhero-themed party at Wayne Manor.&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be a query related to party planning or superhero themes.&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, docs, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.retriever = BM25Retriever.from_documents(
            docs, k=<span class="hljs-number">5</span>  <span class="hljs-comment"># Retrieve the top 5 documents</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>

        docs = self.retriever.invoke(
            query,
        )
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\nRetrieved ideas:\\n&quot;</span> + <span class="hljs-string">&quot;&quot;</span>.join(
            [
                <span class="hljs-string">f&quot;\\n\\n===== Idea <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span> =====\\n&quot;</span> + doc.page_content
                <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(docs)
            ]
        )

<span class="hljs-comment"># Simulate a knowledge base about party planning</span>
party_ideas = [
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;A superhero-themed masquerade ball with luxury decor, including gold accents and velvet curtains.&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Party Ideas 1&quot;</span>},
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Hire a professional DJ who can play themed music for superheroes like Batman and Wonder Woman.&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Entertainment Ideas&quot;</span>},
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;For catering, serve dishes named after superheroes, like &#x27;The Hulk&#x27;s Green Smoothie&#x27; and &#x27;Iron Man&#x27;s Power Steak.&#x27;&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Catering Ideas&quot;</span>},
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Decorate with iconic superhero logos and projections of Gotham and other superhero cities around the venue.&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Decoration Ideas&quot;</span>},
    {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Interactive experiences with VR where guests can engage in superhero simulations or compete in themed games.&quot;</span>, <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;Entertainment Ideas&quot;</span>}
]

source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>]})
    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> party_ideas
]

<span class="hljs-comment"># Split the documents into smaller chunks for more efficient search</span>
text_splitter = RecursiveCharacterTextSplitter(
    chunk_size=<span class="hljs-number">500</span>,
    chunk_overlap=<span class="hljs-number">50</span>,
    add_start_index=<span class="hljs-literal">True</span>,
    strip_whitespace=<span class="hljs-literal">True</span>,
    separators=[<span class="hljs-string">&quot;\\n\\n&quot;</span>, <span class="hljs-string">&quot;\\n&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-string">&quot; &quot;</span>, <span class="hljs-string">&quot;&quot;</span>],
)
docs_processed = text_splitter.split_documents(source_docs)

<span class="hljs-comment"># Create the retriever tool</span>
party_planning_retriever = PartyPlanningRetrieverTool(docs_processed)

<span class="hljs-comment"># Initialize the agent</span>
agent = CodeAgent(tools=[party_planning_retriever], model=InferenceClientModel())

<span class="hljs-comment"># Example usage</span>
response = agent.run(
    <span class="hljs-string">&quot;Find ideas for a luxury superhero-themed party, including entertainment, catering, and decoration options.&quot;</span>
)

<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),N=new L({props:{title:"Enhanced Retrieval Capabilities",local:"enhanced-retrieval-capabilities",headingTag:"h2"}}),z=new L({props:{title:"Resources",local:"resources",headingTag:"h2"}}),H=new ct({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/smolagents/retrieval_agents.mdx"}}),{c(){T=i("meta"),D=n(),$=i("p"),P=n(),M(w.$$.fragment),K=n(),M(d.$$.fragment),O=n(),M(h.$$.fragment),ee=n(),m=i("blockquote"),m.innerHTML=Re,te=n(),I=i("p"),I.textContent=Ve,le=n(),j=i("p"),j.innerHTML=We,se=n(),U=i("p"),U.innerHTML=qe,ne=n(),g=i("p"),g.innerHTML=Ae,ae=n(),b=i("p"),b.textContent=Ee,ie=n(),M(f.$$.fragment),oe=n(),C=i("p"),C.textContent=xe,re=n(),B=i("ul"),B.innerHTML=Xe,Me=n(),v=i("p"),v.textContent=Ne,ce=n(),M(Z.$$.fragment),pe=n(),G=i("p"),G.textContent=Se,ye=n(),k=i("ol"),k.innerHTML=_e,ue=n(),M(R.$$.fragment),Je=n(),V=i("p"),V.textContent=Ye,Te=n(),W=i("p"),W.textContent=ze,me=n(),q=i("p"),q.textContent=Qe,we=n(),A=i("p"),A.innerHTML=He,de=n(),M(E.$$.fragment),he=n(),x=i("p"),x.textContent=$e,Ie=n(),X=i("ol"),X.innerHTML=Fe,je=n(),M(N.$$.fragment),Ue=n(),S=i("p"),S.textContent=Le,ge=n(),_=i("ol"),_.innerHTML=De,be=n(),Y=i("p"),Y.innerHTML=Pe,fe=n(),M(z.$$.fragment),Ce=n(),Q=i("ul"),Q.innerHTML=Ke,Be=n(),M(H.$$.fragment),ve=n(),F=i("p"),this.h()},l(e){const t=it("svelte-u9bgzb",document.head);T=o(t,"META",{name:!0,content:!0}),t.forEach(l),D=a(e),$=o(e,"P",{}),Oe($).forEach(l),P=a(e),c(w.$$.fragment,e),K=a(e),c(d.$$.fragment,e),O=a(e),c(h.$$.fragment,e),ee=a(e),m=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(m)!=="svelte-s5lv3w"&&(m.innerHTML=Re),te=a(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-33rmtz"&&(I.textContent=Ve),le=a(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-113063o"&&(j.innerHTML=We),se=a(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1xlo8ey"&&(U.innerHTML=qe),ne=a(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-124380o"&&(g.innerHTML=Ae),ae=a(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1lb37r2"&&(b.textContent=Ee),ie=a(e),c(f.$$.fragment,e),oe=a(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1uinlt6"&&(C.textContent=xe),re=a(e),B=o(e,"UL",{"data-svelte-h":!0}),r(B)!=="svelte-4vqfph"&&(B.innerHTML=Xe),Me=a(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-jm6fh2"&&(v.textContent=Ne),ce=a(e),c(Z.$$.fragment,e),pe=a(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-21wqo5"&&(G.textContent=Se),ye=a(e),k=o(e,"OL",{"data-svelte-h":!0}),r(k)!=="svelte-sf2q8s"&&(k.innerHTML=_e),ue=a(e),c(R.$$.fragment,e),Je=a(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1jei959"&&(V.textContent=Ye),Te=a(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-9ytw8z"&&(W.textContent=ze),me=a(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-10x3i2g"&&(q.textContent=Qe),we=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-drawum"&&(A.innerHTML=He),de=a(e),c(E.$$.fragment,e),he=a(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-17lgk8z"&&(x.textContent=$e),Ie=a(e),X=o(e,"OL",{"data-svelte-h":!0}),r(X)!=="svelte-12vtib7"&&(X.innerHTML=Fe),je=a(e),c(N.$$.fragment,e),Ue=a(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-gryz7r"&&(S.textContent=Le),ge=a(e),_=o(e,"OL",{"data-svelte-h":!0}),r(_)!=="svelte-1h39gqd"&&(_.innerHTML=De),be=a(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-qnv9nq"&&(Y.innerHTML=Pe),fe=a(e),c(z.$$.fragment,e),Ce=a(e),Q=o(e,"UL",{"data-svelte-h":!0}),r(Q)!=="svelte-1myvltt"&&(Q.innerHTML=Ke),Be=a(e),c(H.$$.fragment,e),ve=a(e),F=o(e,"P",{}),Oe(F).forEach(l),this.h()},h(){Ge(T,"name","hf:doc:metadata"),Ge(T,"content",yt),Ge(m,"class","tip")},m(e,t){ot(document.head,T),s(e,D,t),s(e,$,t),s(e,P,t),p(w,e,t),s(e,K,t),p(d,e,t),s(e,O,t),p(h,e,t),s(e,ee,t),s(e,m,t),s(e,te,t),s(e,I,t),s(e,le,t),s(e,j,t),s(e,se,t),s(e,U,t),s(e,ne,t),s(e,g,t),s(e,ae,t),s(e,b,t),s(e,ie,t),p(f,e,t),s(e,oe,t),s(e,C,t),s(e,re,t),s(e,B,t),s(e,Me,t),s(e,v,t),s(e,ce,t),p(Z,e,t),s(e,pe,t),s(e,G,t),s(e,ye,t),s(e,k,t),s(e,ue,t),p(R,e,t),s(e,Je,t),s(e,V,t),s(e,Te,t),s(e,W,t),s(e,me,t),s(e,q,t),s(e,we,t),s(e,A,t),s(e,de,t),p(E,e,t),s(e,he,t),s(e,x,t),s(e,Ie,t),s(e,X,t),s(e,je,t),p(N,e,t),s(e,Ue,t),s(e,S,t),s(e,ge,t),s(e,_,t),s(e,be,t),s(e,Y,t),s(e,fe,t),p(z,e,t),s(e,Ce,t),s(e,Q,t),s(e,Be,t),p(H,e,t),s(e,ve,t),s(e,F,t),Ze=!0},p:lt,i(e){Ze||(y(w.$$.fragment,e),y(d.$$.fragment,e),y(h.$$.fragment,e),y(f.$$.fragment,e),y(Z.$$.fragment,e),y(R.$$.fragment,e),y(E.$$.fragment,e),y(N.$$.fragment,e),y(z.$$.fragment,e),y(H.$$.fragment,e),Ze=!0)},o(e){u(w.$$.fragment,e),u(d.$$.fragment,e),u(h.$$.fragment,e),u(f.$$.fragment,e),u(Z.$$.fragment,e),u(R.$$.fragment,e),u(E.$$.fragment,e),u(N.$$.fragment,e),u(z.$$.fragment,e),u(H.$$.fragment,e),Ze=!1},d(e){e&&(l(D),l($),l(P),l(K),l(O),l(ee),l(m),l(te),l(I),l(le),l(j),l(se),l(U),l(ne),l(g),l(ae),l(b),l(ie),l(oe),l(C),l(re),l(B),l(Me),l(v),l(ce),l(pe),l(G),l(ye),l(k),l(ue),l(Je),l(V),l(Te),l(W),l(me),l(q),l(we),l(A),l(de),l(he),l(x),l(Ie),l(X),l(je),l(Ue),l(S),l(ge),l(_),l(be),l(Y),l(fe),l(Ce),l(Q),l(Be),l(ve),l(F)),l(T),J(w,e),J(d,e),J(h,e),J(f,e),J(Z,e),J(R,e),J(E,e),J(N,e),J(z,e),J(H,e)}}}const yt='{"title":"Building Agentic RAG Systems","local":"building-agentic-rag-systems","sections":[{"title":"Basic Retrieval with DuckDuckGo","local":"basic-retrieval-with-duckduckgo","sections":[],"depth":2},{"title":"Custom Knowledge Base Tool","local":"custom-knowledge-base-tool","sections":[],"depth":2},{"title":"Enhanced Retrieval Capabilities","local":"enhanced-retrieval-capabilities","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function ut(ke){return st(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jt extends nt{constructor(T){super(),at(this,T,ut,pt,tt,{})}}export{jt as component};
