import{s as fn,n as Cn,o as In}from"../chunks/scheduler.505acc25.js";import{S as vn,i as Zn,e as i,s as n,c as p,h as Bn,a as o,d as l,b as a,f as gn,g as r,j as M,k as ps,l as kn,m as s,n as u,t as m,o as c,p as y}from"../chunks/index.fbb49fb4.js";import{C as Gn}from"../chunks/CopyLLMTxtMenu.564b44fd.js";import{C as T}from"../chunks/CodeBlock.7f0851b7.js";import{C as Wn}from"../chunks/CourseFloatingBanner.742f9db5.js";import{H as w}from"../chunks/Heading.511e0027.js";import{E as $n}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8c19e80e.js";function An(rs){let j,ct,ut,yt,J,wt,h,Tt,U,jt,d,us='<p>You can follow the code in <a href="https://colab.research.google.com/#fileId=https%3A//huggingface.co/agents-course/notebooks/blob/main/bonus-unit2/monitoring-and-evaluating-agents.ipynb" target="_blank">this notebook</a> that you can run using Google Colab.</p>',dt,b,ms="In this notebook, we will learn how to <strong>monitor the internal steps (traces) of our AI agent</strong> and <strong>evaluate its performance</strong> using open-source observability tools.",Jt,g,cs="The ability to observe and evaluate an agent’s behavior is essential for:",ht,f,ys="<li>Debugging issues when tasks fail or produce suboptimal results</li> <li>Monitoring costs and performance in real-time</li> <li>Improving reliability and safety through continuous feedback</li>",Ut,C,bt,I,ws="Before running this notebook, please be sure you have:",gt,v,Ts='🔲 📚  <strong>Studied</strong> <a href="https://huggingface.co/learn/agents-course/unit1/introduction" rel="nofollow">Introduction to Agents</a>',ft,Z,js='🔲 📚  <strong>Studied</strong> <a href="https://huggingface.co/learn/agents-course/unit2/smolagents/introduction" rel="nofollow">The smolagents framework</a>',Ct,B,It,k,ds="We will need a few libraries that allow us to run, monitor, and evaluate our agents:",vt,G,Zt,W,Bt,$,Js='In this notebook, we will use <a href="https://langfuse.com/" rel="nofollow">Langfuse</a> as our observability tool, but you can use <strong>any other OpenTelemetry-compatible service</strong>. The code below shows how to set environment variables for Langfuse (or any OTel endpoint) and how to instrument your smolagent.',kt,A,hs='<strong>Note:</strong> If you are using LlamaIndex or LangGraph, you can find documentation on instrumenting them <a href="https://langfuse.com/docs/integrations/llama-index/workflows" rel="nofollow">here</a> and <a href="https://langfuse.com/docs/integrations/langchain/example-python-langgraph" rel="nofollow">here</a>.',Gt,x,Us='First, let’s set up the Langfuse credentials as environment variables. Get your Langfuse API keys by signing up for <a href="https://cloud.langfuse.com" rel="nofollow">Langfuse Cloud</a> or <a href="https://langfuse.com/self-hosting" rel="nofollow">self-hosting Langfuse</a>.',Wt,R,$t,E,bs="We also need to configure our Hugging Face token for inference calls.",At,V,xt,H,gs="With the environment variables set, we can now initialize the Langfuse client. <code>get_client()</code> initializes the Langfuse client using the credentials provided in the environment variables.",Rt,Y,Et,L,fs="Next, we can set up the <code>SmolagentsInstrumentor()</code> to instrument our smolagent and send traces to Langfuse.",Vt,Q,Ht,S,Yt,N,Cs="Here is a simple CodeAgent from smolagents that calculates <code>1+1</code>. We run it to confirm that the instrumentation is working correctly. If everything is set up correctly, you will see logs/spans in your observability dashboard.",Lt,_,Qt,X,Is='Check your <a href="https://cloud.langfuse.com" rel="nofollow">Langfuse Traces Dashboard</a> (or your chosen observability tool) to confirm that the spans and logs have been recorded.',St,z,vs="Example screenshot from Langfuse:",Nt,F,Zs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/first-example-trace.png" alt="Example trace in Langfuse"/>',_t,q,Bs='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1b94d6888258e0998329cdb72a371155?timestamp=2025-03-10T11%3A59%3A41.743Z" rel="nofollow">Link to the trace</a></em>',Xt,D,zt,P,ks="Now that you have confirmed your instrumentation works, let’s try a more complex query so we can see how advanced metrics (token usage, latency, costs, etc.) are tracked.",Ft,K,qt,O,Dt,ee,Gs="Most observability tools record a <strong>trace</strong> that contains <strong>spans</strong>, which represent each step of your agent’s logic. Here, the trace contains the overall agent run and sub-spans for:",Pt,te,Ws="<li>The tool calls (DuckDuckGoSearchTool)</li> <li>The LLM calls (InferenceClientModel)</li>",Kt,le,$s="You can inspect these to see precisely where time is spent, how many tokens are used, and so on:",Ot,se,As='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/trace-tree.png" alt="Trace tree in Langfuse"/>',el,ne,xs='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">Link to the trace</a></em>',tl,ae,ll,ie,Rs="In the previous section, we learned about the difference between online and offline evaluation. Now, we will see how to monitor your agent in production and evaluate it live.",sl,oe,nl,Me,Es="<li><strong>Costs</strong> — The smolagents instrumentation captures token usage, which you can transform into approximate costs by assigning a price per token.</li> <li><strong>Latency</strong> — Observe the time it takes to complete each step, or the entire run.</li> <li><strong>User Feedback</strong> — Users can provide direct feedback (thumbs up/down) to help refine or correct the agent.</li> <li><strong>LLM-as-a-Judge</strong> — Use a separate LLM to evaluate your agent’s output in near real-time (e.g., checking for toxicity or correctness).</li>",al,pe,Vs="Below, we show examples of these metrics.",il,re,ol,ue,Hs="Below is a screenshot showing usage for <code>Qwen2.5-Coder-32B-Instruct</code> calls. This is useful to see costly steps and optimize your agent.",Ml,me,Ys='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-costs.png" alt="Costs"/>',pl,ce,Ls='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">Link to the trace</a></em>',rl,ye,ul,we,Qs="We can also see how long it took to complete each step. In the example below, the entire conversation took 32 seconds, which you can break down by step. This helps you identify bottlenecks and optimize your agent.",ml,Te,Ss='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-latency.png" alt="Latency"/>',cl,je,Ns='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">Link to the trace</a></em>',yl,de,wl,Je,_s="You may also pass additional attributes to your spans. These can include <code>user_id</code>, <code>tags</code>, <code>session_id</code>, and custom metadata. Enriching traces with these details is important for analysis, debugging, and monitoring of your application’s behavior across different users or sessions.",Tl,he,jl,Ue,Xs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-attributes.png" alt="Enhancing agent runs with additional metrics"/>',dl,be,Jl,ge,zs='If your agent is embedded into a user interface, you can record direct user feedback (like a thumbs-up/down in a chat UI). Below is an example using <a href="https://gradio.app/" rel="nofollow">Gradio</a> to embed a chat with a simple feedback mechanism.',hl,fe,Fs="In the code snippet below, when a user sends a chat message, we capture the trace in Langfuse. If the user likes/dislikes the last answer, we attach a score to the trace.",Ul,Ce,bl,Ie,qs="User feedback is then captured in your observability tool:",gl,ve,Ds='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/user-feedback-gradio.png" alt="User feedback is being captured in Langfuse"/>',fl,Ze,Cl,Be,Ps="LLM-as-a-Judge is another way to automatically evaluate your agent’s output. You can set up a separate LLM call to gauge the output’s correctness, toxicity, style, or any other criteria you care about.",Il,ke,Ks="<strong>Workflow</strong>:",vl,Ge,Os="<li>You define an <strong>Evaluation Template</strong>, e.g., “Check if the text is toxic.”</li> <li>Each time your agent generates output, you pass that output to your “judge” LLM with the template.</li> <li>The judge LLM responds with a rating or label that you log to your observability tool.</li>",Zl,We,en="Example from Langfuse:",Bl,$e,tn='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/evaluator-template.png" alt="LLM-as-a-Judge Evaluation Template"/> <img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/evaluator.png" alt="LLM-as-a-Judge Evaluator"/>',kl,Ae,Gl,xe,ln="You can see that the answer of this example is judged as “not toxic”.",Wl,Re,sn='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/llm-as-a-judge-score.png" alt="LLM-as-a-Judge Evaluation Score"/>',$l,Ee,Al,Ve,nn="All of these metrics can be visualized together in dashboards. This enables you to quickly see how your agent performs across many sessions and helps you to track quality metrics over time.",xl,He,an='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/langfuse-dashboard.png" alt="Observability metrics overview"/>',Rl,Ye,El,Le,on="Online evaluation is essential for live feedback, but you also need <strong>offline evaluation</strong>—systematic checks before or during development. This helps maintain quality and reliability before rolling changes into production.",Vl,Qe,Hl,Se,Mn="In offline evaluation, you typically:",Yl,Ne,pn="<li>Have a benchmark dataset (with prompt and expected output pairs)</li> <li>Run your agent on that dataset</li> <li>Compare outputs to the expected results or use an additional scoring mechanism</li>",Ll,_e,rn='Below, we demonstrate this approach with the <a href="https://huggingface.co/datasets/openai/gsm8k" rel="nofollow">GSM8K dataset</a>, which contains math questions and solutions.',Ql,Xe,Sl,ze,un="Next, we create a dataset entity in Langfuse to track the runs. Then, we add each item from the dataset to the system. (If you’re not using Langfuse, you might simply store these in your own database or local file for analysis.)",Nl,Fe,_l,qe,Xl,De,mn='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/example-dataset.png" alt="Dataset items in Langfuse"/>',zl,Pe,Fl,Ke,cn="We define a helper function <code>run_smolagent()</code> that:",ql,Oe,yn="<li>Starts a Langfuse span</li> <li>Runs our agent on the prompt</li> <li>Records the trace ID in Langfuse</li>",Dl,et,wn="Then, we loop over each dataset item, run the agent, and link the trace to the dataset item. We can also attach a quick evaluation score if desired.",Pl,tt,Kl,lt,Tn="You can repeat this process with different:",Ol,st,jn="<li>Models (OpenAI GPT, local LLM, etc.)</li> <li>Tools (search vs. no search)</li> <li>Prompts (different system messages)</li>",es,nt,dn="Then compare them side-by-side in your observability tool:",ts,at,Jn='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/dataset_runs.png" alt="Dataset run overview"/> <img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/dataset-run-comparison.png" alt="Dataset run comparison"/>',ls,it,ss,ot,hn="In this notebook, we covered how to:",ns,Mt,Un="<li><strong>Set up Observability</strong> using smolagents + OpenTelemetry exporters</li> <li><strong>Check Instrumentation</strong> by running a simple agent</li> <li><strong>Capture Detailed Metrics</strong> (cost, latency, etc.) through an observability tools</li> <li><strong>Collect User Feedback</strong> via a Gradio interface</li> <li><strong>Use LLM-as-a-Judge</strong> to automatically evaluate outputs</li> <li><strong>Perform Offline Evaluation</strong> with a benchmark dataset</li>",as,pt,bn="🤗 Happy coding!",is,rt,os,mt,Ms;return J=new Wn({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https%3A//huggingface.co/agents-course/notebooks/blob/main/bonus-unit2/monitoring-and-evaluating-agents.ipynb"}]}}),h=new Gn({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new w({props:{title:"Bonus Unit 2: Observability and Evaluation of Agents",local:"bonus-unit-2-observability-and-evaluation-of-agents",headingTag:"h1"}}),C=new w({props:{title:"Exercise Prerequisites 🏗️",local:"exercise-prerequisites-",headingTag:"h2"}}),B=new w({props:{title:"Step 0: Install the Required Libraries",local:"step-0-install-the-required-libraries",headingTag:"h2"}}),G=new T({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdmdXNlJTIwJ3Ntb2xhZ2VudHMlNUJ0ZWxlbWV0cnklNUQnJTIwb3BlbmluZmVyZW5jZS1pbnN0cnVtZW50YXRpb24tc21vbGFnZW50cyUyMGRhdGFzZXRzJTIwJ3Ntb2xhZ2VudHMlNUJncmFkaW8lNUQnJTIwZ3JhZGlvJTIwLS11cGdyYWRl",highlighted:'%pip install langfuse <span class="hljs-string">&#x27;smolagents[telemetry]&#x27;</span> openinference-instrumentation-smolagents datasets <span class="hljs-string">&#x27;smolagents[gradio]&#x27;</span> gradio --upgrade',wrap:!1}}),W=new w({props:{title:"Step 1: Instrument Your Agent",local:"step-1-instrument-your-agent",headingTag:"h2"}}),R=new T({props:{code:"aW1wb3J0JTIwb3MlMEElMjMlMjBHZXQlMjBrZXlzJTIwZm9yJTIweW91ciUyMHByb2plY3QlMjBmcm9tJTIwdGhlJTIwcHJvamVjdCUyMHNldHRpbmdzJTIwcGFnZSUzQSUyMGh0dHBzJTNBJTJGJTJGY2xvdWQubGFuZ2Z1c2UuY29tJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX1BVQkxJQ19LRVklMjIlNUQlMjAlM0QlMjAlMjJway1sZi0uLi4lMjIlMjAlMEFvcy5lbnZpcm9uJTVCJTIyTEFOR0ZVU0VfU0VDUkVUX0tFWSUyMiU1RCUyMCUzRCUyMCUyMnNrLWxmLS4uLiUyMiUyMCUwQW9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZjbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQUElRjAlOUYlODclQkElMjBFVSUyMHJlZ2lvbiUwQSUyMyUyMG9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ1cy5jbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQkElRjAlOUYlODclQjglMjBVUyUyMHJlZ2lvbg==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-comment"># Get keys for your project from the project settings page: https://cloud.langfuse.com</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_PUBLIC_KEY&quot;</span>] = <span class="hljs-string">&quot;pk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_SECRET_KEY&quot;</span>] = <span class="hljs-string">&quot;sk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>] = <span class="hljs-string">&quot;https://cloud.langfuse.com&quot;</span> <span class="hljs-comment"># 🇪🇺 EU region</span>
<span class="hljs-comment"># os.environ[&quot;LANGFUSE_HOST&quot;] = &quot;https://us.cloud.langfuse.com&quot; # 🇺🇸 US region</span>`,wrap:!1}}),V=new T({props:{code:"JTIzJTIwU2V0JTIweW91ciUyMEh1Z2dpbmclMjBGYWNlJTIwYW5kJTIwb3RoZXIlMjB0b2tlbnMlMkZzZWNyZXRzJTIwYXMlMjBlbnZpcm9ubWVudCUyMHZhcmlhYmxlJTBBb3MuZW52aXJvbiU1QiUyMkhGX1RPS0VOJTIyJTVEJTIwJTNEJTIwJTIyaGZfLi4uJTIyJTIw",highlighted:`<span class="hljs-comment"># Set your Hugging Face and other tokens/secrets as environment variable</span>
os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>] = <span class="hljs-string">&quot;hf_...&quot;</span> `,wrap:!1}}),Y=new T({props:{code:"ZnJvbSUyMGxhbmdmdXNlJTIwaW1wb3J0JTIwZ2V0X2NsaWVudCUwQSUyMCUwQWxhbmdmdXNlJTIwJTNEJTIwZ2V0X2NsaWVudCgpJTBBJTIwJTBBJTIzJTIwVmVyaWZ5JTIwY29ubmVjdGlvbiUwQWlmJTIwbGFuZ2Z1c2UuYXV0aF9jaGVjaygpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyTGFuZ2Z1c2UlMjBjbGllbnQlMjBpcyUyMGF1dGhlbnRpY2F0ZWQlMjBhbmQlMjByZWFkeSElMjIpJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkF1dGhlbnRpY2F0aW9uJTIwZmFpbGVkLiUyMFBsZWFzZSUyMGNoZWNrJTIweW91ciUyMGNyZWRlbnRpYWxzJTIwYW5kJTIwaG9zdC4lMjIp",highlighted:`<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> get_client
 
langfuse = get_client()
 
<span class="hljs-comment"># Verify connection</span>
<span class="hljs-keyword">if</span> langfuse.auth_check():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Langfuse client is authenticated and ready!&quot;</span>)
<span class="hljs-keyword">else</span>:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Authentication failed. Please check your credentials and host.&quot;</span>)`,wrap:!1}}),Q=new T({props:{code:"ZnJvbSUyMG9wZW5pbmZlcmVuY2UuaW5zdHJ1bWVudGF0aW9uLnNtb2xhZ2VudHMlMjBpbXBvcnQlMjBTbW9sYWdlbnRzSW5zdHJ1bWVudG9yJTBBJTIwJTBBU21vbGFnZW50c0luc3RydW1lbnRvcigpLmluc3RydW1lbnQoKQ==",highlighted:`<span class="hljs-keyword">from</span> openinference.instrumentation.smolagents <span class="hljs-keyword">import</span> SmolagentsInstrumentor
 
SmolagentsInstrumentor().instrument()`,wrap:!1}}),S=new w({props:{title:"Step 2: Test Your Instrumentation",local:"step-2-test-your-instrumentation",headingTag:"h2"}}),_=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQSUyMyUyMENyZWF0ZSUyMGElMjBzaW1wbGUlMjBhZ2VudCUyMHRvJTIwdGVzdCUyMGluc3RydW1lbnRhdGlvbiUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTBBKSUwQSUwQWFnZW50LnJ1biglMjIxJTJCMSUzRCUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-comment"># Create a simple agent to test instrumentation</span>
agent = CodeAgent(
    tools=[],
    model=InferenceClientModel()
)

agent.run(<span class="hljs-string">&quot;1+1=&quot;</span>)`,wrap:!1}}),D=new w({props:{title:"Step 3: Observe and Evaluate a More Complex Agent",local:"step-3-observe-and-evaluate-a-more-complex-agent",headingTag:"h2"}}),K=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCklMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QnNlYXJjaF90b29sJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpKSUwQSUwQWFnZW50LnJ1biglMjJIb3clMjBtYW55JTIwUnViaWsncyUyMEN1YmVzJTIwY291bGQlMjB5b3UlMjBmaXQlMjBpbnNpZGUlMjB0aGUlMjBOb3RyZSUyMERhbWUlMjBDYXRoZWRyYWwlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(tools=[search_tool], model=InferenceClientModel())

agent.run(<span class="hljs-string">&quot;How many Rubik&#x27;s Cubes could you fit inside the Notre Dame Cathedral?&quot;</span>)`,wrap:!1}}),O=new w({props:{title:"Trace Structure",local:"trace-structure",headingTag:"h3"}}),ae=new w({props:{title:"Online Evaluation",local:"online-evaluation",headingTag:"h2"}}),oe=new w({props:{title:"Common Metrics to Track in Production",local:"common-metrics-to-track-in-production",headingTag:"h3"}}),re=new w({props:{title:"1. Costs",local:"1-costs",headingTag:"h4"}}),ye=new w({props:{title:"2. Latency",local:"2-latency",headingTag:"h4"}}),de=new w({props:{title:"3. Additional Attributes",local:"3-additional-attributes",headingTag:"h4"}}),he=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCklMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QnNlYXJjaF90b29sJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTBBKSUwQSUwQXdpdGglMjBsYW5nZnVzZS5zdGFydF9hc19jdXJyZW50X3NwYW4oJTBBJTIwJTIwJTIwJTIwbmFtZSUzRCUyMlNtb2xhZ2VudC1UcmFjZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCklMjBhcyUyMHNwYW4lM0ElMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBSdW4lMjB5b3VyJTIwYXBwbGljYXRpb24lMjBoZXJlJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBhZ2VudC5ydW4oJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwR2VybWFueSUzRiUyMiklMEElMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBQYXNzJTIwYWRkaXRpb25hbCUyMGF0dHJpYnV0ZXMlMjB0byUyMHRoZSUyMHNwYW4lMEElMjAlMjAlMjAlMjBzcGFuLnVwZGF0ZV90cmFjZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dCUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGNhcGl0YWwlMjBvZiUyMEdlcm1hbnklM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXQlM0RyZXNwb25zZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHVzZXJfaWQlM0QlMjJzbW9sYWdlbnQtdXNlci0xMjMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZXNzaW9uX2lkJTNEJTIyc21vbGFnZW50LXNlc3Npb24tMTIzNDU2Nzg5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGFncyUzRCU1QiUyMmNpdHktcXVlc3Rpb24lMjIlMkMlMjAlMjJ0ZXN0aW5nLWFnZW50cyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1ldGFkYXRhJTNEJTdCJTIyZW1haWwlMjIlM0ElMjAlMjJ1c2VyJTQwbGFuZ2Z1c2UuY29tJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUwQSUyMyUyMEZsdXNoJTIwZXZlbnRzJTIwaW4lMjBzaG9ydC1saXZlZCUyMGFwcGxpY2F0aW9ucyUwQWxhbmdmdXNlLmZsdXNoKCk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(
    tools=[search_tool],
    model=InferenceClientModel()
)

<span class="hljs-keyword">with</span> langfuse.start_as_current_span(
    name=<span class="hljs-string">&quot;Smolagent-Trace&quot;</span>,
    ) <span class="hljs-keyword">as</span> span:
    
    <span class="hljs-comment"># Run your application here</span>
    response = agent.run(<span class="hljs-string">&quot;What is the capital of Germany?&quot;</span>)
 
    <span class="hljs-comment"># Pass additional attributes to the span</span>
    span.update_trace(
        <span class="hljs-built_in">input</span>=<span class="hljs-string">&quot;What is the capital of Germany?&quot;</span>,
        output=response,
        user_id=<span class="hljs-string">&quot;smolagent-user-123&quot;</span>,
        session_id=<span class="hljs-string">&quot;smolagent-session-123456789&quot;</span>,
        tags=[<span class="hljs-string">&quot;city-question&quot;</span>, <span class="hljs-string">&quot;testing-agents&quot;</span>],
        metadata={<span class="hljs-string">&quot;email&quot;</span>: <span class="hljs-string">&quot;user@langfuse.com&quot;</span>},
        )
 
<span class="hljs-comment"># Flush events in short-lived applications</span>
langfuse.flush()`,wrap:!1}}),be=new w({props:{title:"4. User Feedback",local:"4-user-feedback",headingTag:"h4"}}),Ce=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, InferenceClientModel)
<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> get_client

langfuse = get_client()

model = InferenceClientModel()
agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)

trace_id = <span class="hljs-literal">None</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">respond</span>(<span class="hljs-params">prompt, history</span>):
    <span class="hljs-keyword">with</span> langfuse.start_as_current_span(
        name=<span class="hljs-string">&quot;Smolagent-Trace&quot;</span>):
        
        <span class="hljs-comment"># Run your application here</span>
        output = agent.run(prompt)

        <span class="hljs-keyword">global</span> trace_id
        trace_id = langfuse.get_current_trace_id()

    history.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-built_in">str</span>(output)})
    <span class="hljs-keyword">return</span> history

<span class="hljs-keyword">def</span> <span class="hljs-title function_">handle_like</span>(<span class="hljs-params">data: gr.LikeData</span>):
    <span class="hljs-comment"># For demonstration, we map user feedback to a 1 (like) or 0 (dislike)</span>
    <span class="hljs-keyword">if</span> data.liked:
        langfuse.create_score(
            value=<span class="hljs-number">1</span>,
            name=<span class="hljs-string">&quot;user-feedback&quot;</span>,
            trace_id=trace_id
        )
    <span class="hljs-keyword">else</span>:
        langfuse.create_score(
            value=<span class="hljs-number">0</span>,
            name=<span class="hljs-string">&quot;user-feedback&quot;</span>,
            trace_id=trace_id
        )

<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    chatbot = gr.Chatbot(label=<span class="hljs-string">&quot;Chat&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>)
    prompt_box = gr.Textbox(placeholder=<span class="hljs-string">&quot;Type your message...&quot;</span>, label=<span class="hljs-string">&quot;Your message&quot;</span>)

    <span class="hljs-comment"># When the user presses &#x27;Enter&#x27; on the prompt, we run &#x27;respond&#x27;</span>
    prompt_box.submit(
        fn=respond,
        inputs=[prompt_box, chatbot],
        outputs=chatbot
    )

    <span class="hljs-comment"># When the user clicks a &#x27;like&#x27; button on a message, we run &#x27;handle_like&#x27;</span>
    chatbot.like(handle_like, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>)

demo.launch()`,wrap:!1}}),Ze=new w({props:{title:"5. LLM-as-a-Judge",local:"5-llm-as-a-judge",headingTag:"h4"}}),Ae=new T({props:{code:"JTIzJTIwRXhhbXBsZSUzQSUyMENoZWNraW5nJTIwaWYlMjB0aGUlMjBhZ2VudCVFMiU4MCU5OXMlMjBvdXRwdXQlMjBpcyUyMHRveGljJTIwb3IlMjBub3QuJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCklMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QnNlYXJjaF90b29sJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpKSUwQSUwQWFnZW50LnJ1biglMjJDYW4lMjBlYXRpbmclMjBjYXJyb3RzJTIwaW1wcm92ZSUyMHlvdXIlMjB2aXNpb24lM0YlMjIp",highlighted:`<span class="hljs-comment"># Example: Checking if the agent’s output is toxic or not.</span>
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(tools=[search_tool], model=InferenceClientModel())

agent.run(<span class="hljs-string">&quot;Can eating carrots improve your vision?&quot;</span>)`,wrap:!1}}),Ee=new w({props:{title:"6. Observability Metrics Overview",local:"6-observability-metrics-overview",headingTag:"h4"}}),Ye=new w({props:{title:"Offline Evaluation",local:"offline-evaluation",headingTag:"h2"}}),Qe=new w({props:{title:"Dataset Evaluation",local:"dataset-evaluation",headingTag:"h3"}}),Xe=new T({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQSUyMyUyMEZldGNoJTIwR1NNOEslMjBmcm9tJTIwSHVnZ2luZyUyMEZhY2UlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMm9wZW5haSUyRmdzbThrJTIyJTJDJTIwJ21haW4nJTJDJTIwc3BsaXQlM0QndHJhaW4nKSUwQWRmJTIwJTNEJTIwcGQuRGF0YUZyYW1lKGRhdGFzZXQpJTBBcHJpbnQoJTIyRmlyc3QlMjBmZXclMjByb3dzJTIwb2YlMjBHU004SyUyMGRhdGFzZXQlM0ElMjIpJTBBcHJpbnQoZGYuaGVhZCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Fetch GSM8K from Hugging Face</span>
dataset = load_dataset(<span class="hljs-string">&quot;openai/gsm8k&quot;</span>, <span class="hljs-string">&#x27;main&#x27;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>)
df = pd.DataFrame(dataset)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;First few rows of GSM8K dataset:&quot;</span>)
<span class="hljs-built_in">print</span>(df.head())`,wrap:!1}}),Fe=new T({props:{code:"ZnJvbSUyMGxhbmdmdXNlJTIwaW1wb3J0JTIwZ2V0X2NsaWVudCUwQWxhbmdmdXNlJTIwJTNEJTIwZ2V0X2NsaWVudCgpJTBBJTBBbGFuZ2Z1c2VfZGF0YXNldF9uYW1lJTIwJTNEJTIwJTIyZ3NtOGtfZGF0YXNldF9odWdnaW5nZmFjZSUyMiUwQSUwQSUyMyUyMENyZWF0ZSUyMGElMjBkYXRhc2V0JTIwaW4lMjBMYW5nZnVzZSUwQWxhbmdmdXNlLmNyZWF0ZV9kYXRhc2V0KCUwQSUyMCUyMCUyMCUyMG5hbWUlM0RsYW5nZnVzZV9kYXRhc2V0X25hbWUlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMkdTTThLJTIwYmVuY2htYXJrJTIwZGF0YXNldCUyMHVwbG9hZGVkJTIwZnJvbSUyMEh1Z2dpbmdmYWNlJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWV0YWRhdGElM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkYXRlJTIyJTNBJTIwJTIyMjAyNS0wMy0xMCUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJiZW5jaG1hcmslMjIlMEElMjAlMjAlMjAlMjAlN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> get_client
langfuse = get_client()

langfuse_dataset_name = <span class="hljs-string">&quot;gsm8k_dataset_huggingface&quot;</span>

<span class="hljs-comment"># Create a dataset in Langfuse</span>
langfuse.create_dataset(
    name=langfuse_dataset_name,
    description=<span class="hljs-string">&quot;GSM8K benchmark dataset uploaded from Huggingface&quot;</span>,
    metadata={
        <span class="hljs-string">&quot;date&quot;</span>: <span class="hljs-string">&quot;2025-03-10&quot;</span>, 
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;benchmark&quot;</span>
    }
)`,wrap:!1}}),qe=new T({props:{code:"Zm9yJTIwaWR4JTJDJTIwcm93JTIwaW4lMjBkZi5pdGVycm93cygpJTNBJTBBJTIwJTIwJTIwJTIwbGFuZ2Z1c2UuY3JlYXRlX2RhdGFzZXRfaXRlbSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhc2V0X25hbWUlM0RsYW5nZnVzZV9kYXRhc2V0X25hbWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dCUzRCU3QiUyMnRleHQlMjIlM0ElMjByb3clNUIlMjJxdWVzdGlvbiUyMiU1RCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4cGVjdGVkX291dHB1dCUzRCU3QiUyMnRleHQlMjIlM0ElMjByb3clNUIlMjJhbnN3ZXIlMjIlNUQlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZV9pbmRleCUyMiUzQSUyMGlkeCU3RCUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBpZiUyMGlkeCUyMCUzRSUzRCUyMDklM0ElMjAlMjMlMjBVcGxvYWQlMjBvbmx5JTIwdGhlJTIwZmlyc3QlMjAxMCUyMGl0ZW1zJTIwZm9yJTIwZGVtb25zdHJhdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-keyword">for</span> idx, row <span class="hljs-keyword">in</span> df.iterrows():
    langfuse.create_dataset_item(
        dataset_name=langfuse_dataset_name,
        <span class="hljs-built_in">input</span>={<span class="hljs-string">&quot;text&quot;</span>: row[<span class="hljs-string">&quot;question&quot;</span>]},
        expected_output={<span class="hljs-string">&quot;text&quot;</span>: row[<span class="hljs-string">&quot;answer&quot;</span>]},
        metadata={<span class="hljs-string">&quot;source_index&quot;</span>: idx}
    )
    <span class="hljs-keyword">if</span> idx &gt;= <span class="hljs-number">9</span>: <span class="hljs-comment"># Upload only the first 10 items for demonstration</span>
        <span class="hljs-keyword">break</span>`,wrap:!1}}),Pe=new w({props:{title:"Running the Agent on the Dataset",local:"running-the-agent-on-the-dataset",headingTag:"h4"}}),tt=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> opentelemetry.trace <span class="hljs-keyword">import</span> format_trace_id
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, InferenceClientModel, LiteLLMModel)
<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> get_client
 
langfuse = get_client()


<span class="hljs-comment"># Example: using InferenceClientModel or LiteLLMModel to access openai, anthropic, gemini, etc. models:</span>
model = InferenceClientModel()

agent = CodeAgent(
    tools=[],
    model=model,
    add_base_tools=<span class="hljs-literal">True</span>
)

dataset_name = <span class="hljs-string">&quot;gsm8k_dataset_huggingface&quot;</span>
current_run_name = <span class="hljs-string">&quot;smolagent-notebook-run-01&quot;</span> <span class="hljs-comment"># Identifies this specific evaluation run</span>
 
<span class="hljs-comment"># Assume &#x27;run_smolagent&#x27; is your instrumented application function</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_smolagent</span>(<span class="hljs-params">question</span>):
    <span class="hljs-keyword">with</span> langfuse.start_as_current_generation(name=<span class="hljs-string">&quot;qna-llm-call&quot;</span>) <span class="hljs-keyword">as</span> generation:
        <span class="hljs-comment"># Simulate LLM call</span>
        result = agent.run(question)
 
        <span class="hljs-comment"># Update the trace with the input and output</span>
        generation.update_trace(
            <span class="hljs-built_in">input</span>= question,
            output=result,
        )
 
        <span class="hljs-keyword">return</span> result
 
dataset = langfuse.get_dataset(name=dataset_name) <span class="hljs-comment"># Fetch your pre-populated dataset</span>
 
<span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> dataset.items:
 
    <span class="hljs-comment"># Use the item.run() context manager</span>
    <span class="hljs-keyword">with</span> item.run(
        run_name=current_run_name,
        run_metadata={<span class="hljs-string">&quot;model_provider&quot;</span>: <span class="hljs-string">&quot;Hugging Face&quot;</span>, <span class="hljs-string">&quot;temperature_setting&quot;</span>: <span class="hljs-number">0.7</span>},
        run_description=<span class="hljs-string">&quot;Evaluation run for GSM8K dataset&quot;</span>
    ) <span class="hljs-keyword">as</span> root_span: <span class="hljs-comment"># root_span is the root span of the new trace for this item and run.</span>
        <span class="hljs-comment"># All subsequent langfuse operations within this block are part of this trace.</span>
 
        <span class="hljs-comment"># Call your application logic</span>
        generated_answer = run_smolagent(question=item.<span class="hljs-built_in">input</span>[<span class="hljs-string">&quot;text&quot;</span>])
 
        <span class="hljs-built_in">print</span>(item.<span class="hljs-built_in">input</span>)`,wrap:!1}}),it=new w({props:{title:"Final Thoughts",local:"final-thoughts",headingTag:"h2"}}),rt=new $n({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/bonus-unit2/monitoring-and-evaluating-agents-notebook.mdx"}}),{c(){j=i("meta"),ct=n(),ut=i("p"),yt=n(),p(J.$$.fragment),wt=n(),p(h.$$.fragment),Tt=n(),p(U.$$.fragment),jt=n(),d=i("blockquote"),d.innerHTML=us,dt=n(),b=i("p"),b.innerHTML=ms,Jt=n(),g=i("p"),g.textContent=cs,ht=n(),f=i("ul"),f.innerHTML=ys,Ut=n(),p(C.$$.fragment),bt=n(),I=i("p"),I.textContent=ws,gt=n(),v=i("p"),v.innerHTML=Ts,ft=n(),Z=i("p"),Z.innerHTML=js,Ct=n(),p(B.$$.fragment),It=n(),k=i("p"),k.textContent=ds,vt=n(),p(G.$$.fragment),Zt=n(),p(W.$$.fragment),Bt=n(),$=i("p"),$.innerHTML=Js,kt=n(),A=i("p"),A.innerHTML=hs,Gt=n(),x=i("p"),x.innerHTML=Us,Wt=n(),p(R.$$.fragment),$t=n(),E=i("p"),E.textContent=bs,At=n(),p(V.$$.fragment),xt=n(),H=i("p"),H.innerHTML=gs,Rt=n(),p(Y.$$.fragment),Et=n(),L=i("p"),L.innerHTML=fs,Vt=n(),p(Q.$$.fragment),Ht=n(),p(S.$$.fragment),Yt=n(),N=i("p"),N.innerHTML=Cs,Lt=n(),p(_.$$.fragment),Qt=n(),X=i("p"),X.innerHTML=Is,St=n(),z=i("p"),z.textContent=vs,Nt=n(),F=i("p"),F.innerHTML=Zs,_t=n(),q=i("p"),q.innerHTML=Bs,Xt=n(),p(D.$$.fragment),zt=n(),P=i("p"),P.textContent=ks,Ft=n(),p(K.$$.fragment),qt=n(),p(O.$$.fragment),Dt=n(),ee=i("p"),ee.innerHTML=Gs,Pt=n(),te=i("ul"),te.innerHTML=Ws,Kt=n(),le=i("p"),le.textContent=$s,Ot=n(),se=i("p"),se.innerHTML=As,el=n(),ne=i("p"),ne.innerHTML=xs,tl=n(),p(ae.$$.fragment),ll=n(),ie=i("p"),ie.textContent=Rs,sl=n(),p(oe.$$.fragment),nl=n(),Me=i("ol"),Me.innerHTML=Es,al=n(),pe=i("p"),pe.textContent=Vs,il=n(),p(re.$$.fragment),ol=n(),ue=i("p"),ue.innerHTML=Hs,Ml=n(),me=i("p"),me.innerHTML=Ys,pl=n(),ce=i("p"),ce.innerHTML=Ls,rl=n(),p(ye.$$.fragment),ul=n(),we=i("p"),we.textContent=Qs,ml=n(),Te=i("p"),Te.innerHTML=Ss,cl=n(),je=i("p"),je.innerHTML=Ns,yl=n(),p(de.$$.fragment),wl=n(),Je=i("p"),Je.innerHTML=_s,Tl=n(),p(he.$$.fragment),jl=n(),Ue=i("p"),Ue.innerHTML=Xs,dl=n(),p(be.$$.fragment),Jl=n(),ge=i("p"),ge.innerHTML=zs,hl=n(),fe=i("p"),fe.textContent=Fs,Ul=n(),p(Ce.$$.fragment),bl=n(),Ie=i("p"),Ie.textContent=qs,gl=n(),ve=i("p"),ve.innerHTML=Ds,fl=n(),p(Ze.$$.fragment),Cl=n(),Be=i("p"),Be.textContent=Ps,Il=n(),ke=i("p"),ke.innerHTML=Ks,vl=n(),Ge=i("ol"),Ge.innerHTML=Os,Zl=n(),We=i("p"),We.textContent=en,Bl=n(),$e=i("p"),$e.innerHTML=tn,kl=n(),p(Ae.$$.fragment),Gl=n(),xe=i("p"),xe.textContent=ln,Wl=n(),Re=i("p"),Re.innerHTML=sn,$l=n(),p(Ee.$$.fragment),Al=n(),Ve=i("p"),Ve.textContent=nn,xl=n(),He=i("p"),He.innerHTML=an,Rl=n(),p(Ye.$$.fragment),El=n(),Le=i("p"),Le.innerHTML=on,Vl=n(),p(Qe.$$.fragment),Hl=n(),Se=i("p"),Se.textContent=Mn,Yl=n(),Ne=i("ol"),Ne.innerHTML=pn,Ll=n(),_e=i("p"),_e.innerHTML=rn,Ql=n(),p(Xe.$$.fragment),Sl=n(),ze=i("p"),ze.textContent=un,Nl=n(),p(Fe.$$.fragment),_l=n(),p(qe.$$.fragment),Xl=n(),De=i("p"),De.innerHTML=mn,zl=n(),p(Pe.$$.fragment),Fl=n(),Ke=i("p"),Ke.innerHTML=cn,ql=n(),Oe=i("ol"),Oe.innerHTML=yn,Dl=n(),et=i("p"),et.textContent=wn,Pl=n(),p(tt.$$.fragment),Kl=n(),lt=i("p"),lt.textContent=Tn,Ol=n(),st=i("ul"),st.innerHTML=jn,es=n(),nt=i("p"),nt.textContent=dn,ts=n(),at=i("p"),at.innerHTML=Jn,ls=n(),p(it.$$.fragment),ss=n(),ot=i("p"),ot.textContent=hn,ns=n(),Mt=i("ol"),Mt.innerHTML=Un,as=n(),pt=i("p"),pt.textContent=bn,is=n(),p(rt.$$.fragment),os=n(),mt=i("p"),this.h()},l(e){const t=Bn("svelte-u9bgzb",document.head);j=o(t,"META",{name:!0,content:!0}),t.forEach(l),ct=a(e),ut=o(e,"P",{}),gn(ut).forEach(l),yt=a(e),r(J.$$.fragment,e),wt=a(e),r(h.$$.fragment,e),Tt=a(e),r(U.$$.fragment,e),jt=a(e),d=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),M(d)!=="svelte-1ill3vv"&&(d.innerHTML=us),dt=a(e),b=o(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1hjcrzt"&&(b.innerHTML=ms),Jt=a(e),g=o(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-foopw1"&&(g.textContent=cs),ht=a(e),f=o(e,"UL",{"data-svelte-h":!0}),M(f)!=="svelte-owrpod"&&(f.innerHTML=ys),Ut=a(e),r(C.$$.fragment,e),bt=a(e),I=o(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-5cu48y"&&(I.textContent=ws),gt=a(e),v=o(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-tid2rn"&&(v.innerHTML=Ts),ft=a(e),Z=o(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-11ima5v"&&(Z.innerHTML=js),Ct=a(e),r(B.$$.fragment,e),It=a(e),k=o(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-13k1zsa"&&(k.textContent=ds),vt=a(e),r(G.$$.fragment,e),Zt=a(e),r(W.$$.fragment,e),Bt=a(e),$=o(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-1om0xhg"&&($.innerHTML=Js),kt=a(e),A=o(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-10zlua1"&&(A.innerHTML=hs),Gt=a(e),x=o(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-1kbyizu"&&(x.innerHTML=Us),Wt=a(e),r(R.$$.fragment,e),$t=a(e),E=o(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-188d5j6"&&(E.textContent=bs),At=a(e),r(V.$$.fragment,e),xt=a(e),H=o(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-wfv4z0"&&(H.innerHTML=gs),Rt=a(e),r(Y.$$.fragment,e),Et=a(e),L=o(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-1uenr7t"&&(L.innerHTML=fs),Vt=a(e),r(Q.$$.fragment,e),Ht=a(e),r(S.$$.fragment,e),Yt=a(e),N=o(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-18gebex"&&(N.innerHTML=Cs),Lt=a(e),r(_.$$.fragment,e),Qt=a(e),X=o(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-vzfgml"&&(X.innerHTML=Is),St=a(e),z=o(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-17kovw7"&&(z.textContent=vs),Nt=a(e),F=o(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-1cb993n"&&(F.innerHTML=Zs),_t=a(e),q=o(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-3d3s8c"&&(q.innerHTML=Bs),Xt=a(e),r(D.$$.fragment,e),zt=a(e),P=o(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-vj8duz"&&(P.textContent=ks),Ft=a(e),r(K.$$.fragment,e),qt=a(e),r(O.$$.fragment,e),Dt=a(e),ee=o(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-11qm5kf"&&(ee.innerHTML=Gs),Pt=a(e),te=o(e,"UL",{"data-svelte-h":!0}),M(te)!=="svelte-1pzu7di"&&(te.innerHTML=Ws),Kt=a(e),le=o(e,"P",{"data-svelte-h":!0}),M(le)!=="svelte-5g8r1i"&&(le.textContent=$s),Ot=a(e),se=o(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-yhkq5w"&&(se.innerHTML=As),el=a(e),ne=o(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-19v4344"&&(ne.innerHTML=xs),tl=a(e),r(ae.$$.fragment,e),ll=a(e),ie=o(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-1m3q9s4"&&(ie.textContent=Rs),sl=a(e),r(oe.$$.fragment,e),nl=a(e),Me=o(e,"OL",{"data-svelte-h":!0}),M(Me)!=="svelte-it9cbz"&&(Me.innerHTML=Es),al=a(e),pe=o(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-1gkbldi"&&(pe.textContent=Vs),il=a(e),r(re.$$.fragment,e),ol=a(e),ue=o(e,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-zy3zhh"&&(ue.innerHTML=Hs),Ml=a(e),me=o(e,"P",{"data-svelte-h":!0}),M(me)!=="svelte-dard47"&&(me.innerHTML=Ys),pl=a(e),ce=o(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-19v4344"&&(ce.innerHTML=Ls),rl=a(e),r(ye.$$.fragment,e),ul=a(e),we=o(e,"P",{"data-svelte-h":!0}),M(we)!=="svelte-v1au4h"&&(we.textContent=Qs),ml=a(e),Te=o(e,"P",{"data-svelte-h":!0}),M(Te)!=="svelte-1org4pj"&&(Te.innerHTML=Ss),cl=a(e),je=o(e,"P",{"data-svelte-h":!0}),M(je)!=="svelte-19v4344"&&(je.innerHTML=Ns),yl=a(e),r(de.$$.fragment,e),wl=a(e),Je=o(e,"P",{"data-svelte-h":!0}),M(Je)!=="svelte-ut7yv4"&&(Je.innerHTML=_s),Tl=a(e),r(he.$$.fragment,e),jl=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),M(Ue)!=="svelte-1gx91hu"&&(Ue.innerHTML=Xs),dl=a(e),r(be.$$.fragment,e),Jl=a(e),ge=o(e,"P",{"data-svelte-h":!0}),M(ge)!=="svelte-1t6vqwk"&&(ge.innerHTML=zs),hl=a(e),fe=o(e,"P",{"data-svelte-h":!0}),M(fe)!=="svelte-1rxqxjo"&&(fe.textContent=Fs),Ul=a(e),r(Ce.$$.fragment,e),bl=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),M(Ie)!=="svelte-qczj9m"&&(Ie.textContent=qs),gl=a(e),ve=o(e,"P",{"data-svelte-h":!0}),M(ve)!=="svelte-e6ive4"&&(ve.innerHTML=Ds),fl=a(e),r(Ze.$$.fragment,e),Cl=a(e),Be=o(e,"P",{"data-svelte-h":!0}),M(Be)!=="svelte-1guzmu1"&&(Be.textContent=Ps),Il=a(e),ke=o(e,"P",{"data-svelte-h":!0}),M(ke)!=="svelte-13jor3c"&&(ke.innerHTML=Ks),vl=a(e),Ge=o(e,"OL",{"data-svelte-h":!0}),M(Ge)!=="svelte-8y9f4i"&&(Ge.innerHTML=Os),Zl=a(e),We=o(e,"P",{"data-svelte-h":!0}),M(We)!=="svelte-6rieqh"&&(We.textContent=en),Bl=a(e),$e=o(e,"P",{"data-svelte-h":!0}),M($e)!=="svelte-1uar592"&&($e.innerHTML=tn),kl=a(e),r(Ae.$$.fragment,e),Gl=a(e),xe=o(e,"P",{"data-svelte-h":!0}),M(xe)!=="svelte-3xsjjj"&&(xe.textContent=ln),Wl=a(e),Re=o(e,"P",{"data-svelte-h":!0}),M(Re)!=="svelte-zj9pt2"&&(Re.innerHTML=sn),$l=a(e),r(Ee.$$.fragment,e),Al=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),M(Ve)!=="svelte-1053it2"&&(Ve.textContent=nn),xl=a(e),He=o(e,"P",{"data-svelte-h":!0}),M(He)!=="svelte-1jemoxg"&&(He.innerHTML=an),Rl=a(e),r(Ye.$$.fragment,e),El=a(e),Le=o(e,"P",{"data-svelte-h":!0}),M(Le)!=="svelte-12emzh2"&&(Le.innerHTML=on),Vl=a(e),r(Qe.$$.fragment,e),Hl=a(e),Se=o(e,"P",{"data-svelte-h":!0}),M(Se)!=="svelte-nxef74"&&(Se.textContent=Mn),Yl=a(e),Ne=o(e,"OL",{"data-svelte-h":!0}),M(Ne)!=="svelte-1ys56q5"&&(Ne.innerHTML=pn),Ll=a(e),_e=o(e,"P",{"data-svelte-h":!0}),M(_e)!=="svelte-ijt5m6"&&(_e.innerHTML=rn),Ql=a(e),r(Xe.$$.fragment,e),Sl=a(e),ze=o(e,"P",{"data-svelte-h":!0}),M(ze)!=="svelte-14neeab"&&(ze.textContent=un),Nl=a(e),r(Fe.$$.fragment,e),_l=a(e),r(qe.$$.fragment,e),Xl=a(e),De=o(e,"P",{"data-svelte-h":!0}),M(De)!=="svelte-giwu4e"&&(De.innerHTML=mn),zl=a(e),r(Pe.$$.fragment,e),Fl=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),M(Ke)!=="svelte-y12uij"&&(Ke.innerHTML=cn),ql=a(e),Oe=o(e,"OL",{"data-svelte-h":!0}),M(Oe)!=="svelte-1lfvsus"&&(Oe.innerHTML=yn),Dl=a(e),et=o(e,"P",{"data-svelte-h":!0}),M(et)!=="svelte-1ew78oh"&&(et.textContent=wn),Pl=a(e),r(tt.$$.fragment,e),Kl=a(e),lt=o(e,"P",{"data-svelte-h":!0}),M(lt)!=="svelte-1ebq4ig"&&(lt.textContent=Tn),Ol=a(e),st=o(e,"UL",{"data-svelte-h":!0}),M(st)!=="svelte-1lunl6l"&&(st.innerHTML=jn),es=a(e),nt=o(e,"P",{"data-svelte-h":!0}),M(nt)!=="svelte-gt2dc"&&(nt.textContent=dn),ts=a(e),at=o(e,"P",{"data-svelte-h":!0}),M(at)!=="svelte-ukc2vx"&&(at.innerHTML=Jn),ls=a(e),r(it.$$.fragment,e),ss=a(e),ot=o(e,"P",{"data-svelte-h":!0}),M(ot)!=="svelte-1xbvrw5"&&(ot.textContent=hn),ns=a(e),Mt=o(e,"OL",{"data-svelte-h":!0}),M(Mt)!=="svelte-1u9pd9c"&&(Mt.innerHTML=Un),as=a(e),pt=o(e,"P",{"data-svelte-h":!0}),M(pt)!=="svelte-3bxv5s"&&(pt.textContent=bn),is=a(e),r(rt.$$.fragment,e),os=a(e),mt=o(e,"P",{}),gn(mt).forEach(l),this.h()},h(){ps(j,"name","hf:doc:metadata"),ps(j,"content",xn),ps(d,"class","tip")},m(e,t){kn(document.head,j),s(e,ct,t),s(e,ut,t),s(e,yt,t),u(J,e,t),s(e,wt,t),u(h,e,t),s(e,Tt,t),u(U,e,t),s(e,jt,t),s(e,d,t),s(e,dt,t),s(e,b,t),s(e,Jt,t),s(e,g,t),s(e,ht,t),s(e,f,t),s(e,Ut,t),u(C,e,t),s(e,bt,t),s(e,I,t),s(e,gt,t),s(e,v,t),s(e,ft,t),s(e,Z,t),s(e,Ct,t),u(B,e,t),s(e,It,t),s(e,k,t),s(e,vt,t),u(G,e,t),s(e,Zt,t),u(W,e,t),s(e,Bt,t),s(e,$,t),s(e,kt,t),s(e,A,t),s(e,Gt,t),s(e,x,t),s(e,Wt,t),u(R,e,t),s(e,$t,t),s(e,E,t),s(e,At,t),u(V,e,t),s(e,xt,t),s(e,H,t),s(e,Rt,t),u(Y,e,t),s(e,Et,t),s(e,L,t),s(e,Vt,t),u(Q,e,t),s(e,Ht,t),u(S,e,t),s(e,Yt,t),s(e,N,t),s(e,Lt,t),u(_,e,t),s(e,Qt,t),s(e,X,t),s(e,St,t),s(e,z,t),s(e,Nt,t),s(e,F,t),s(e,_t,t),s(e,q,t),s(e,Xt,t),u(D,e,t),s(e,zt,t),s(e,P,t),s(e,Ft,t),u(K,e,t),s(e,qt,t),u(O,e,t),s(e,Dt,t),s(e,ee,t),s(e,Pt,t),s(e,te,t),s(e,Kt,t),s(e,le,t),s(e,Ot,t),s(e,se,t),s(e,el,t),s(e,ne,t),s(e,tl,t),u(ae,e,t),s(e,ll,t),s(e,ie,t),s(e,sl,t),u(oe,e,t),s(e,nl,t),s(e,Me,t),s(e,al,t),s(e,pe,t),s(e,il,t),u(re,e,t),s(e,ol,t),s(e,ue,t),s(e,Ml,t),s(e,me,t),s(e,pl,t),s(e,ce,t),s(e,rl,t),u(ye,e,t),s(e,ul,t),s(e,we,t),s(e,ml,t),s(e,Te,t),s(e,cl,t),s(e,je,t),s(e,yl,t),u(de,e,t),s(e,wl,t),s(e,Je,t),s(e,Tl,t),u(he,e,t),s(e,jl,t),s(e,Ue,t),s(e,dl,t),u(be,e,t),s(e,Jl,t),s(e,ge,t),s(e,hl,t),s(e,fe,t),s(e,Ul,t),u(Ce,e,t),s(e,bl,t),s(e,Ie,t),s(e,gl,t),s(e,ve,t),s(e,fl,t),u(Ze,e,t),s(e,Cl,t),s(e,Be,t),s(e,Il,t),s(e,ke,t),s(e,vl,t),s(e,Ge,t),s(e,Zl,t),s(e,We,t),s(e,Bl,t),s(e,$e,t),s(e,kl,t),u(Ae,e,t),s(e,Gl,t),s(e,xe,t),s(e,Wl,t),s(e,Re,t),s(e,$l,t),u(Ee,e,t),s(e,Al,t),s(e,Ve,t),s(e,xl,t),s(e,He,t),s(e,Rl,t),u(Ye,e,t),s(e,El,t),s(e,Le,t),s(e,Vl,t),u(Qe,e,t),s(e,Hl,t),s(e,Se,t),s(e,Yl,t),s(e,Ne,t),s(e,Ll,t),s(e,_e,t),s(e,Ql,t),u(Xe,e,t),s(e,Sl,t),s(e,ze,t),s(e,Nl,t),u(Fe,e,t),s(e,_l,t),u(qe,e,t),s(e,Xl,t),s(e,De,t),s(e,zl,t),u(Pe,e,t),s(e,Fl,t),s(e,Ke,t),s(e,ql,t),s(e,Oe,t),s(e,Dl,t),s(e,et,t),s(e,Pl,t),u(tt,e,t),s(e,Kl,t),s(e,lt,t),s(e,Ol,t),s(e,st,t),s(e,es,t),s(e,nt,t),s(e,ts,t),s(e,at,t),s(e,ls,t),u(it,e,t),s(e,ss,t),s(e,ot,t),s(e,ns,t),s(e,Mt,t),s(e,as,t),s(e,pt,t),s(e,is,t),u(rt,e,t),s(e,os,t),s(e,mt,t),Ms=!0},p:Cn,i(e){Ms||(m(J.$$.fragment,e),m(h.$$.fragment,e),m(U.$$.fragment,e),m(C.$$.fragment,e),m(B.$$.fragment,e),m(G.$$.fragment,e),m(W.$$.fragment,e),m(R.$$.fragment,e),m(V.$$.fragment,e),m(Y.$$.fragment,e),m(Q.$$.fragment,e),m(S.$$.fragment,e),m(_.$$.fragment,e),m(D.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),m(ae.$$.fragment,e),m(oe.$$.fragment,e),m(re.$$.fragment,e),m(ye.$$.fragment,e),m(de.$$.fragment,e),m(he.$$.fragment,e),m(be.$$.fragment,e),m(Ce.$$.fragment,e),m(Ze.$$.fragment,e),m(Ae.$$.fragment,e),m(Ee.$$.fragment,e),m(Ye.$$.fragment,e),m(Qe.$$.fragment,e),m(Xe.$$.fragment,e),m(Fe.$$.fragment,e),m(qe.$$.fragment,e),m(Pe.$$.fragment,e),m(tt.$$.fragment,e),m(it.$$.fragment,e),m(rt.$$.fragment,e),Ms=!0)},o(e){c(J.$$.fragment,e),c(h.$$.fragment,e),c(U.$$.fragment,e),c(C.$$.fragment,e),c(B.$$.fragment,e),c(G.$$.fragment,e),c(W.$$.fragment,e),c(R.$$.fragment,e),c(V.$$.fragment,e),c(Y.$$.fragment,e),c(Q.$$.fragment,e),c(S.$$.fragment,e),c(_.$$.fragment,e),c(D.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(ae.$$.fragment,e),c(oe.$$.fragment,e),c(re.$$.fragment,e),c(ye.$$.fragment,e),c(de.$$.fragment,e),c(he.$$.fragment,e),c(be.$$.fragment,e),c(Ce.$$.fragment,e),c(Ze.$$.fragment,e),c(Ae.$$.fragment,e),c(Ee.$$.fragment,e),c(Ye.$$.fragment,e),c(Qe.$$.fragment,e),c(Xe.$$.fragment,e),c(Fe.$$.fragment,e),c(qe.$$.fragment,e),c(Pe.$$.fragment,e),c(tt.$$.fragment,e),c(it.$$.fragment,e),c(rt.$$.fragment,e),Ms=!1},d(e){e&&(l(ct),l(ut),l(yt),l(wt),l(Tt),l(jt),l(d),l(dt),l(b),l(Jt),l(g),l(ht),l(f),l(Ut),l(bt),l(I),l(gt),l(v),l(ft),l(Z),l(Ct),l(It),l(k),l(vt),l(Zt),l(Bt),l($),l(kt),l(A),l(Gt),l(x),l(Wt),l($t),l(E),l(At),l(xt),l(H),l(Rt),l(Et),l(L),l(Vt),l(Ht),l(Yt),l(N),l(Lt),l(Qt),l(X),l(St),l(z),l(Nt),l(F),l(_t),l(q),l(Xt),l(zt),l(P),l(Ft),l(qt),l(Dt),l(ee),l(Pt),l(te),l(Kt),l(le),l(Ot),l(se),l(el),l(ne),l(tl),l(ll),l(ie),l(sl),l(nl),l(Me),l(al),l(pe),l(il),l(ol),l(ue),l(Ml),l(me),l(pl),l(ce),l(rl),l(ul),l(we),l(ml),l(Te),l(cl),l(je),l(yl),l(wl),l(Je),l(Tl),l(jl),l(Ue),l(dl),l(Jl),l(ge),l(hl),l(fe),l(Ul),l(bl),l(Ie),l(gl),l(ve),l(fl),l(Cl),l(Be),l(Il),l(ke),l(vl),l(Ge),l(Zl),l(We),l(Bl),l($e),l(kl),l(Gl),l(xe),l(Wl),l(Re),l($l),l(Al),l(Ve),l(xl),l(He),l(Rl),l(El),l(Le),l(Vl),l(Hl),l(Se),l(Yl),l(Ne),l(Ll),l(_e),l(Ql),l(Sl),l(ze),l(Nl),l(_l),l(Xl),l(De),l(zl),l(Fl),l(Ke),l(ql),l(Oe),l(Dl),l(et),l(Pl),l(Kl),l(lt),l(Ol),l(st),l(es),l(nt),l(ts),l(at),l(ls),l(ss),l(ot),l(ns),l(Mt),l(as),l(pt),l(is),l(os),l(mt)),l(j),y(J,e),y(h,e),y(U,e),y(C,e),y(B,e),y(G,e),y(W,e),y(R,e),y(V,e),y(Y,e),y(Q,e),y(S,e),y(_,e),y(D,e),y(K,e),y(O,e),y(ae,e),y(oe,e),y(re,e),y(ye,e),y(de,e),y(he,e),y(be,e),y(Ce,e),y(Ze,e),y(Ae,e),y(Ee,e),y(Ye,e),y(Qe,e),y(Xe,e),y(Fe,e),y(qe,e),y(Pe,e),y(tt,e),y(it,e),y(rt,e)}}}const xn='{"title":"Bonus Unit 2: Observability and Evaluation of Agents","local":"bonus-unit-2-observability-and-evaluation-of-agents","sections":[{"title":"Exercise Prerequisites 🏗️","local":"exercise-prerequisites-","sections":[],"depth":2},{"title":"Step 0: Install the Required Libraries","local":"step-0-install-the-required-libraries","sections":[],"depth":2},{"title":"Step 1: Instrument Your Agent","local":"step-1-instrument-your-agent","sections":[],"depth":2},{"title":"Step 2: Test Your Instrumentation","local":"step-2-test-your-instrumentation","sections":[],"depth":2},{"title":"Step 3: Observe and Evaluate a More Complex Agent","local":"step-3-observe-and-evaluate-a-more-complex-agent","sections":[{"title":"Trace Structure","local":"trace-structure","sections":[],"depth":3}],"depth":2},{"title":"Online Evaluation","local":"online-evaluation","sections":[{"title":"Common Metrics to Track in Production","local":"common-metrics-to-track-in-production","sections":[{"title":"1. Costs","local":"1-costs","sections":[],"depth":4},{"title":"2. Latency","local":"2-latency","sections":[],"depth":4},{"title":"3. Additional Attributes","local":"3-additional-attributes","sections":[],"depth":4},{"title":"4. User Feedback","local":"4-user-feedback","sections":[],"depth":4},{"title":"5. LLM-as-a-Judge","local":"5-llm-as-a-judge","sections":[],"depth":4},{"title":"6. Observability Metrics Overview","local":"6-observability-metrics-overview","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Offline Evaluation","local":"offline-evaluation","sections":[{"title":"Dataset Evaluation","local":"dataset-evaluation","sections":[{"title":"Running the Agent on the Dataset","local":"running-the-agent-on-the-dataset","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Final Thoughts","local":"final-thoughts","sections":[],"depth":2}],"depth":1}';function Rn(rs){return In(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nn extends vn{constructor(j){super(),Zn(this,j,Rn,An,fn,{})}}export{Nn as component};
