# AI Agent Observability & Evaluation

![Bonus Unit 2 Thumbnail](https://langfuse.com/images/cookbook/huggingface-agent-course/agent-observability-and-evaluation.png)

Welcome to **Bonus Unit 2**! In this chapter, you'll explore advanced strategies for observing, evaluating, and ultimately improving the performance of your agents.

---

## 📚 When Should I Do This Bonus Unit?

This bonus unit is perfect if you:
- **Develop and Deploy AI Agents:** You want to ensure that your agents are performing reliably in production.
- **Need Detailed Insights:** You're looking to diagnose issues, optimize performance, or understand the inner workings of your agent.
- **Aim to Reduce Operational Overhead:** By monitoring agent costs, latency, and execution details, you can efficiently manage resources.
- **Seek Continuous Improvement:** You’re interested in integrating both real-time user feedback and automated evaluation into your AI applications.

In short, for everyone who wants to bring their agents in front of users!

---

## 🤓 What You’ll Learn

In this unit, you'll learn:
- **Instrument Your Agent:** Learn how to integrate observability tools via OpenTelemetry with the *smolagents* framework.
- **Monitor Metrics:** Track performance indicators such as token usage (costs), latency, and error traces.
- **Evaluate in Real-Time:** Understand techniques for live evaluation, including gathering user feedback and leveraging an LLM-as-a-judge.
- **Offline Analysis:** Use benchmark datasets (e.g., GSM8K) to test and compare agent performance.

---

## 🚀 Ready to Get Started?

In the next section, you'll learn the basics of Agent Observability and Evaluation. After that, its time to see it in action!

<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/en/bonus-unit2/introduction.mdx" />