# From LLMs to AI Agents

We learned in the [first unit](https://huggingface.co/learn/agents-course/unit1/introduction) of the course that AI Agents are able to plan and make decisions.  
And while LLMs have enabled more natural interactions with NPCs, Agentic AI takes it a step further by allowing characters to make decisions, plan actions, and adapt to changing environments.

To illustrate the difference, think of a classic RPG NPC:

- With an LLM: the NPC might respond to your questions in a more natural, varied way. It's great for dialogue, but the NPC remains static, it won’t act unless you do something first.
- With Agentic AI: the NPC can decide to go look for help, set a trap, or avoid you completely, even if you’re not interacting with it directly.

This small shift changes everything. We're moving from scripted responders to autonomous actors within the game world.

This shift means NPCs can now directly interact with their environment through goal-directed behaviors, ultimately leading to more dynamic and unpredictable gameplay.

Agentic AI empowers NPCs with:

- **Autonomy**: Making independent decisions based on the game state.
- **Adaptability**: Adjusting strategies in response to player actions.
- **Persistence**: Remembering past interactions to inform future behavior.

This transforms NPCs from reactive entities (reacting to your inputs) into proactive participants in the game world, opening the door for innovative gameplay.


## The big limitation of Agents: **it’s slow** (for now)

However, let’s not be too optimistic just yet. Despite its potential, Agentic AI currently faces challenges in real-time applications. 

The reasoning and planning processes can introduce latency, making it less suitable for fast-paced games like *Doom* or *Super Mario Bros.*

Take the example of [_Claude Plays Pokémon_](https://www.twitch.tv/claudeplayspokemon). If you consider the number of tokens needed to **think**, plus the tokens needed to **act**, it becomes clear that we'd need entirely different decoding strategies to make real-time play feasible.

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit3/claude-plays-pokemon.png" alt="Claude plays Pokémon"/>

Most games need to run at around 30 FPS, which means a real-time AI agent would need to act 30 times per second, not currently feasible with today's agentic LLMs.

However, turn-based games like *Pokémon* are ideal candidates, as they allow the AI enough time to deliberate and make strategic decisions.

That’s why in the next section, you’ll build your very own AI Agent to battle in Pokémon-style turn-based combat, and even challenge it yourself. Let’s get into it!


<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/en/bonus-unit3/from-llm-to-agents.mdx" />