# Introduction to `LangGraph`

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/LangGraph.png" alt="Unit 2.3 Thumbnail"/>

Welcome to this next part of our journey, where you'll learn **how to build applications** using the [`LangGraph`](https://github.com/langchain-ai/langgraph) framework designed to help you structure and orchestrate complex LLM workflows.

`LangGraph` is a framework that allows you to build **production-ready** applications by giving you **control** tools over the flow of your agent.

## Module Overview

In this unit, you'll discover:

### 1️⃣ [What is LangGraph, and when to use it?](./when_to_use_langgraph)
### 2️⃣ [Building Blocks of LangGraph](./building_blocks)
### 3️⃣ [Alfred, the mail sorting butler](./first_graph)
### 4️⃣ [Alfred, the document Analyst agent](./document_analysis_agent)
### 5️⃣ [Quiz](./quizz1)

> [!WARNING]
> The examples in this section require access to a powerful LLM/VLM model. We ran them using the GPT-4o API because it has the best compatibility with langGraph.

By the end of this unit, you'll be equipped to build robust, organized and production ready applications ! 

That being said, this section is an introduction to LangGraph and more advanced topics can be discovered in the free LangChain academy course : [Introduction to LangGraph](https://academy.langchain.com/courses/intro-to-langgraph)

Let's get started!

## Resources

- [LangGraph Agents](https://langchain-ai.github.io/langgraph/) - Examples of LangGraph agent
- [LangChain academy](https://academy.langchain.com/courses/intro-to-langgraph) - Full course on LangGraph from LangChain


<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/en/unit2/langgraph/introduction.mdx" />