import{s as xa,a as Tt,n as Ea,o as _a}from"../chunks/scheduler.505acc25.js";import{S as Ga,i as qa,e as M,s,c as o,h as La,a as i,d as t,b as n,f as Ct,g as p,j as r,k as y,l as It,m as a,n as u,t as m,o as c,p as j}from"../chunks/index.fbb49fb4.js";import{C as Ha}from"../chunks/CopyLLMTxtMenu.38c593c4.js";import{C as U}from"../chunks/CodeBlock.2ead06c8.js";import{H as ze}from"../chunks/Heading.511e0027.js";import{E as Za}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.9ca82795.js";function Sa(At){let d,Ve,Qe,Ne,T,Re,w,Xe,C,bt,Fe,I,ht="Un aspecto crucial de los Agentes de IA es su capacidad para realizar <strong>acciones</strong>. Como vimos, esto sucede a través del uso de <strong>Herramientas</strong>.",Pe,A,ft="En esta sección, aprenderemos qué son las Herramientas, cómo diseñarlas de manera efectiva y cómo integrarlas en tu Agente a través del Mensaje del Sistema.",Ke,b,vt="Al proporcionar a tu Agente las Herramientas adecuadas —y describir claramente cómo funcionan esas Herramientas— puedes aumentar dramáticamente lo que tu IA puede lograr. ¡Vamos a profundizar!",De,h,Oe,f,Bt="Una <strong>Herramienta es una función proporcionada al LLM</strong>. Esta función debe cumplir un <strong>objetivo claro</strong>.",el,v,gt="Aquí hay algunas herramientas comúnmente utilizadas en agentes de IA:",ll,B,xt="<thead><tr><th>Herramienta</th> <th>Descripción</th></tr></thead> <tbody><tr><td>Búsqueda Web</td> <td>Permite al agente obtener información actualizada de internet.</td></tr> <tr><td>Generación de Imágenes</td> <td>Crea imágenes basadas en descripciones textuales.</td></tr> <tr><td>Recuperación</td> <td>Recupera información de una fuente externa.</td></tr> <tr><td>Interfaz de API</td> <td>Interactúa con una API externa (GitHub, YouTube, Spotify, etc.).</td></tr></tbody>",tl,g,Et="¡Esos son solo ejemplos, ya que de hecho puedes crear una herramienta para cualquier caso de uso!",al,x,_t="Una buena herramienta debería ser algo que <strong>complemente el poder de un LLM</strong>.",sl,E,Gt="Por ejemplo, si necesitas realizar operaciones aritméticas, proporcionar una <strong>herramienta de calculadora</strong> a tu LLM proporcionará mejores resultados que confiar en las capacidades nativas del modelo.",nl,_,qt="Además, <strong>los LLMs predicen la finalización de un prompt basándose en sus datos de entrenamiento</strong>, lo que significa que su conocimiento interno solo incluye eventos anteriores a su entrenamiento. Por lo tanto, si tu agente necesita datos actualizados, debes proporcionarlos a través de alguna herramienta.",Ml,G,Lt="Por ejemplo, si le preguntas directamente a un LLM (sin una herramienta de búsqueda) sobre el clima de hoy, el LLM potencialmente alucinará un clima aleatorio.",il,q,Ht,rl,L,Zt="<li><p>Una Herramienta debe contener:</p> <ul><li>Una <strong>descripción textual de lo que hace la función</strong>.</li> <li>Un <em>Callable</em> (algo para realizar una acción).</li> <li><em>Argumentos</em> con tipos.</li> <li>(Opcional) Salidas con tipos.</li></ul></li>",ol,H,pl,Z,St="Los LLMs, como vimos, solo pueden recibir entradas de texto y generar salidas de texto. No tienen forma de llamar a herramientas por sí mismos. Lo que queremos decir cuando hablamos de <em>proporcionar herramientas a un Agente</em>, es que <strong>enseñamos</strong> al LLM sobre la existencia de herramientas, y pedimos al modelo que genere texto que invocará herramientas cuando las necesite. Por ejemplo, si proporcionamos una herramienta para verificar el clima en una ubicación desde Internet, y luego preguntamos al LLM sobre el clima en París, el LLM reconocerá esa pregunta como una oportunidad relevante para usar la herramienta “clima” que le enseñamos. El LLM generará <em>texto</em>, en forma de código, para invocar esa herramienta. Es responsabilidad del <strong>Agente</strong> analizar la salida del LLM, reconocer que se requiere una llamada a una herramienta e invocar la herramienta en nombre del LLM. La salida de la herramienta luego se enviará de vuelta al LLM, que compondrá su respuesta final para el usuario.",ul,S,$t="La salida de una llamada a una herramienta es otro tipo de mensaje en la conversación. Los pasos de llamada a herramientas típicamente no se muestran al usuario: el Agente recupera la conversación, llama a la(s) herramienta(s), obtiene las salidas, las agrega como un nuevo mensaje de conversación y envía la conversación actualizada al LLM nuevamente. Desde el punto de vista del usuario, es como si el LLM hubiera usado la herramienta, pero de hecho fue nuestro código de aplicación (el <strong>Agente</strong>) quien lo hizo.",ml,$,Wt="Hablaremos mucho más sobre este proceso en sesiones futuras.",cl,W,jl,Y,Yt="La respuesta completa puede parecer abrumadora, pero esencialmente usamos el prompt del sistema para proporcionar descripciones textuales de las herramientas disponibles al modelo:",yl,z,zt,dl,Q,Qt="Para que esto funcione, tenemos que ser muy precisos y exactos sobre:",Ul,k,kt="<li><strong>Lo que hace la herramienta</strong></li> <li><strong>Qué entradas exactas espera</strong></li>",Jl,V,Vt="Esta es la razón por la que las descripciones de herramientas generalmente se proporcionan utilizando estructuras expresivas pero precisas, como lenguajes de computadora o JSON. No es <em>necesario</em> hacerlo así, cualquier formato preciso y coherente funcionaría.",Tl,N,Nt="Si esto parece demasiado teórico, vamos a entenderlo a través de un ejemplo concreto.",wl,R,Rt="Implementaremos una herramienta <strong>calculadora</strong> simplificada que solo multiplicará dos enteros. Esta podría ser nuestra implementación en Python:",Cl,X,Il,F,Xt="Así que nuestra herramienta se llama <code>calculadora</code>, <strong>multiplica dos enteros</strong>, y requiere las siguientes entradas:",Al,P,Ft="<li><strong><code>a</code></strong> (<em>int</em>): Un entero.</li> <li><strong><code>b</code></strong> (<em>int</em>): Un entero.</li>",bl,K,Pt="La salida de la herramienta es otro número entero que podemos describir así:",hl,D,Kt="<li>(<em>int</em>): El producto de <code>a</code> y <code>b</code>.</li>",fl,O,Dt="Todos estos detalles son importantes. Vamos a juntarlos en una cadena de texto que describe nuestra herramienta para que el LLM la entienda.",vl,ee,Bl,le,Ot="<p><strong>Recordatorio:</strong> Esta descripción textual es <em>lo que queremos que el LLM sepa sobre la herramienta</em>.</p>",gl,te,ea="Cuando pasamos la cadena anterior como parte de la entrada al LLM, el modelo la reconocerá como una herramienta, y sabrá qué necesita pasar como entradas y qué esperar de la salida.",xl,ae,la="Si queremos proporcionar herramientas adicionales, debemos ser consistentes y siempre usar el mismo formato. Este proceso puede ser frágil, y podríamos pasar por alto accidentalmente algunos detalles.",El,se,ta="¿Hay una mejor manera?",_l,ne,Gl,Me,aa="Nuestra herramienta fue escrita en Python, y la implementación ya proporciona todo lo que necesitamos:",ql,ie,sa="<li>Un nombre descriptivo de lo que hace: <code>calculadora</code></li> <li>Una descripción más larga, proporcionada por el comentario docstring de la función: <code>Multiplica dos enteros.</code></li> <li>Las entradas y su tipo: la función claramente espera dos <code>int</code>s.</li> <li>El tipo de la salida.</li>",Ll,re,na="Hay una razón por la que la gente usa lenguajes de programación: son expresivos, concisos y precisos.",Hl,oe,Ma="Podríamos proporcionar el código fuente de Python como la <em>especificación</em> de la herramienta para el LLM, pero la forma en que se implementa la herramienta no importa. Todo lo que importa es su nombre, lo que hace, las entradas que espera y la salida que proporciona.",Zl,pe,ia="Aprovecharemos las características de introspección de Python para aprovechar el código fuente y construir una descripción de herramienta automáticamente para nosotros. Todo lo que necesitamos es que la implementación de la herramienta use sugerencias de tipo, docstrings y nombres de función sensatos. Escribiremos algo de código para extraer las partes relevantes del código fuente.",Sl,ue,ra="Después de terminar, solo necesitaremos usar un decorador de Python para indicar que la función <code>calculadora</code> es una herramienta:",$l,me,Wl,ce,oa="Nota el decorador <code>@tool</code> antes de la definición de la función.",Yl,je,pa="Con la implementación que veremos a continuación, podremos recuperar el siguiente texto automáticamente del código fuente a través de la función <code>to_string()</code> proporcionada por el decorador:",zl,ye,Ql,de,ua="Como puedes ver, ¡es lo mismo que escribimos manualmente antes!",kl,Ue,Vl,Je,ma="Creamos una clase genérica <code>Tool</code> que podemos reutilizar siempre que necesitemos usar una herramienta.",Nl,Te,ca="<p><strong>Descargo de responsabilidad:</strong> Esta implementación de ejemplo es ficticia pero se parece mucho a implementaciones reales en la mayoría de las bibliotecas.</p>",Rl,we,Xl,Ce,ja="Puede parecer complicado, pero si lo recorremos lentamente podemos ver lo que hace. Definimos una clase <strong><code>Tool</code></strong> que incluye:",Fl,Ie,ya="<li><strong><code>name</code></strong> (<em>str</em>): El nombre de la herramienta.</li> <li><strong><code>description</code></strong> (<em>str</em>): Una breve descripción de lo que hace la herramienta.</li> <li><strong><code>function</code></strong> (<em>callable</em>): La función que ejecuta la herramienta.</li> <li><strong><code>arguments</code></strong> (<em>list</em>): Los parámetros de entrada esperados.</li> <li><strong><code>outputs</code></strong> (<em>str</em> o <em>list</em>): Las salidas esperadas de la herramienta.</li> <li><strong><code>__call__()</code></strong>: Llama a la función cuando se invoca la instancia de la herramienta.</li> <li><strong><code>to_string()</code></strong>: Convierte los atributos de la herramienta en una representación textual.</li>",Pl,Ae,da="Podríamos crear una Herramienta con esta clase usando código como el siguiente:",Kl,be,Dl,he,Ua="¡Pero también podemos usar el módulo <code>inspect</code> de Python para recuperar toda la información por nosotros! Esto es lo que hace el decorador <code>@tool</code>.",Ol,fe,Ja="<p>Si estás interesado, puedes revelar la siguiente sección para ver la implementación del decorador.</p>",et,J,Ye,Ta="código del decorador",wt,ve,lt,Be,wa="Solo para reiterar, con este decorador en su lugar podemos implementar nuestra herramienta así:",tt,ge,at,xe,Ca="Y podemos usar el método <code>to_string</code> de la <code>Tool</code> para recuperar automáticamente un texto adecuado para ser utilizado como descripción de herramienta para un LLM:",st,Ee,nt,_e,Ia="La descripción se <strong>inyecta</strong> en el prompt del sistema. Tomando el ejemplo con el que comenzamos esta sección, así es como se vería después de reemplazar el <code>tools_description</code>:",Mt,Ge,Aa,it,qe,ba='En la sección <a href="actions.mdx">Acciones</a>, aprenderemos más sobre cómo un Agente puede <strong>Llamar</strong> a esta herramienta que acabamos de crear.',rt,ot,pt,Le,ha="Las herramientas juegan un papel crucial en la mejora de las capacidades de los agentes de IA.",ut,He,fa="Para resumir, aprendimos:",mt,Ze,va="<li><p><em>Qué son las Herramientas</em>: Funciones que dan a los LLMs capacidades adicionales, como realizar cálculos o acceder a datos externos.</p></li> <li><p><em>Cómo Definir una Herramienta</em>: Proporcionando una descripción textual clara, entradas, salidas y una función invocable.</p></li> <li><p><em>Por qué las Herramientas son Esenciales</em>: Permiten a los Agentes superar las limitaciones del entrenamiento estático del modelo, manejar tareas en tiempo real y realizar acciones especializadas.</p></li>",ct,Se,Ba='Ahora, podemos pasar al <a href="agent-steps-and-structure.mdx">Flujo de Trabajo del Agente</a> donde verás cómo un Agente observa, piensa y actúa. Esto <strong>reúne todo lo que hemos cubierto hasta ahora</strong> y prepara el escenario para crear tu propio Agente de IA completamente funcional.',jt,$e,ga="Pero primero, ¡es hora de otro cuestionario corto!",yt,We,dt,ke,Ut;return T=new Ha({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new ze({props:{title:"¿Qué son las Herramientas?",local:"qué-son-las-herramientas",headingTag:"h1"}}),h=new ze({props:{title:"¿Qué son las Herramientas de IA?",local:"qué-son-las-herramientas-de-ia",headingTag:"h2"}}),H=new ze({props:{title:"¿Cómo funcionan las herramientas?",local:"cómo-funcionan-las-herramientas",headingTag:"h2"}}),W=new ze({props:{title:"¿Cómo proporcionamos herramientas a un LLM?",local:"cómo-proporcionamos-herramientas-a-un-llm",headingTag:"h2"}}),X=new U({props:{code:"ZGVmJTIwY2FsY3VsYWRvcmEoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMk11bHRpcGxpY2ElMjBkb3MlMjBlbnRlcm9zLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGElMjAqJTIwYg==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculadora</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiplica dos enteros.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b`,wrap:!1}}),ee=new U({props:{code:"Tm9tYnJlJTIwZGUlMjBIZXJyYW1pZW50YSUzQSUyMGNhbGN1bGFkb3JhJTJDJTIwRGVzY3JpcGNpJUMzJUIzbiUzQSUyME11bHRpcGxpY2ElMjBkb3MlMjBlbnRlcm9zLiUyQyUyMEFyZ3VtZW50b3MlM0ElMjBhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCUyQyUyMFNhbGlkYXMlM0ElMjBpbnQ=",highlighted:"Nombre de Herramienta: calculadora, Descripción: Multiplica dos enteros., Argumentos: a: int, b: int, Salidas: int",wrap:!1}}),ne=new ze({props:{title:"Auto-formateo de secciones de Herramientas",local:"auto-formateo-de-secciones-de-herramientas",headingTag:"h3"}}),me=new U({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGFkb3JhKGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50KSUyMC0lM0UlMjBpbnQlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJNdWx0aXBsaWNhJTIwZG9zJTIwZW50ZXJvcy4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBhJTIwKiUyMGIlMEElMEFwcmludChjYWxjdWxhZG9yYS50b19zdHJpbmcoKSk=",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculadora</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiplica dos enteros.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculadora.to_string())`,wrap:!1}}),ye=new U({props:{code:"Tm9tYnJlJTIwZGUlMjBIZXJyYW1pZW50YSUzQSUyMGNhbGN1bGFkb3JhJTJDJTIwRGVzY3JpcGNpJUMzJUIzbiUzQSUyME11bHRpcGxpY2ElMjBkb3MlMjBlbnRlcm9zLiUyQyUyMEFyZ3VtZW50b3MlM0ElMjBhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCUyQyUyMFNhbGlkYXMlM0ElMjBpbnQ=",highlighted:"Nombre de Herramienta: calculadora, Descripción: Multiplica dos enteros., Argumentos: a: int, b: int, Salidas: int",wrap:!1}}),Ue=new ze({props:{title:"Implementación genérica de Herramienta",local:"implementación-genérica-de-herramienta",headingTag:"h3"}}),we=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Tool</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Una clase que representa un fragmento de código reutilizable (Herramienta).
    
    Atributos:
        name (str): Nombre de la herramienta.
        description (str): Una descripción textual de lo que hace la herramienta.
        func (callable): La función que esta herramienta envuelve.
        arguments (list): Una lista de argumentos.
        outputs (str or list): El tipo(s) de retorno de la función envuelta.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, 
                 name: <span class="hljs-built_in">str</span>, 
                 description: <span class="hljs-built_in">str</span>, 
                 func: <span class="hljs-built_in">callable</span>, 
                 arguments: <span class="hljs-built_in">list</span>,
                 outputs: <span class="hljs-built_in">str</span></span>):
        self.name = name
        self.description = description
        self.func = func
        self.arguments = arguments
        self.outputs = outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">to_string</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;
        Devuelve una representación en cadena de la herramienta, 
        incluyendo su nombre, descripción, argumentos y salidas.
        &quot;&quot;&quot;</span>
        args_str = <span class="hljs-string">&quot;, &quot;</span>.join([
            <span class="hljs-string">f&quot;<span class="hljs-subst">{arg_name}</span>: <span class="hljs-subst">{arg_type}</span>&quot;</span> <span class="hljs-keyword">for</span> arg_name, arg_type <span class="hljs-keyword">in</span> self.arguments
        ])
        
        <span class="hljs-keyword">return</span> (
            <span class="hljs-string">f&quot;Nombre de Herramienta: <span class="hljs-subst">{self.name}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Descripción: <span class="hljs-subst">{self.description}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Argumentos: <span class="hljs-subst">{args_str}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Salidas: <span class="hljs-subst">{self.outputs}</span>&quot;</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, *args, **kwargs</span>):
        <span class="hljs-string">&quot;&quot;&quot;
        Invoca la función subyacente (callable) con los argumentos proporcionados.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> self.func(*args, **kwargs)`,wrap:!1}}),be=new U({props:{code:"Y2FsY3VsYWRvcmFfdG9vbCUyMCUzRCUyMFRvb2woJTBBJTIwJTIwJTIwJTIwJTIyY2FsY3VsYWRvcmElMjIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBub21icmUlMEElMjAlMjAlMjAlMjAlMjJNdWx0aXBsaWNhJTIwZG9zJTIwZW50ZXJvcy4lMjIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBkZXNjcmlwY2klQzMlQjNuJTBBJTIwJTIwJTIwJTIwY2FsY3VsYWRvcmElMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBmdW5jaSVDMyVCM24lMjBhJTIwbGxhbWFyJTBBJTIwJTIwJTIwJTIwJTVCKCUyMmElMjIlMkMlMjAlMjJpbnQlMjIpJTJDJTIwKCUyMmIlMjIlMkMlMjAlMjJpbnQlMjIpJTVEJTJDJTIwJTIwJTIwJTIzJTIwZW50cmFkYXMlMjAobm9tYnJlcyUyMHklMjB0aXBvcyklMEElMjAlMjAlMjAlMjAlMjJpbnQlMjIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBzYWxpZGElMEEp",highlighted:`calculadora_tool = Tool(
    <span class="hljs-string">&quot;calculadora&quot;</span>,                   <span class="hljs-comment"># nombre</span>
    <span class="hljs-string">&quot;Multiplica dos enteros.&quot;</span>,       <span class="hljs-comment"># descripción</span>
    calculadora,                     <span class="hljs-comment"># función a llamar</span>
    [(<span class="hljs-string">&quot;a&quot;</span>, <span class="hljs-string">&quot;int&quot;</span>), (<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;int&quot;</span>)],   <span class="hljs-comment"># entradas (nombres y tipos)</span>
    <span class="hljs-string">&quot;int&quot;</span>,                          <span class="hljs-comment"># salida</span>
)`,wrap:!1}}),ve=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tool</span>(<span class="hljs-params">func</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Un decorador que crea una instancia de Tool a partir de la función dada.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Obtener la firma de la función</span>
    signature = inspect.signature(func)
    
    <span class="hljs-comment"># Extraer pares (param_name, param_annotation) para entradas</span>
    arguments = []
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> signature.parameters.values():
        annotation_name = (
            param.annotation.__name__ 
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(param.annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>) 
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(param.annotation)
        )
        arguments.append((param.name, annotation_name))
    
    <span class="hljs-comment"># Determinar la anotación de retorno</span>
    return_annotation = signature.return_annotation
    <span class="hljs-keyword">if</span> return_annotation <span class="hljs-keyword">is</span> inspect._empty:
        outputs = <span class="hljs-string">&quot;Sin anotación de retorno&quot;</span>
    <span class="hljs-keyword">else</span>:
        outputs = (
            return_annotation.__name__ 
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(return_annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>) 
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(return_annotation)
        )
    
    <span class="hljs-comment"># Usar el docstring de la función como descripción (por defecto si es None)</span>
    description = func.__doc__ <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;No se proporcionó descripción.&quot;</span>
    
    <span class="hljs-comment"># El nombre de la función se convierte en el nombre de la Herramienta</span>
    name = func.__name__
    
    <span class="hljs-comment"># Devolver una nueva instancia de Tool</span>
    <span class="hljs-keyword">return</span> Tool(
        name=name, 
        description=description, 
        func=func, 
        arguments=arguments, 
        outputs=outputs
    )`,wrap:!1}}),ge=new U({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGFkb3JhKGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50KSUyMC0lM0UlMjBpbnQlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJNdWx0aXBsaWNhJTIwZG9zJTIwZW50ZXJvcy4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBhJTIwKiUyMGIlMEElMEFwcmludChjYWxjdWxhZG9yYS50b19zdHJpbmcoKSk=",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculadora</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiplica dos enteros.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculadora.to_string())`,wrap:!1}}),Ee=new U({props:{code:"Tm9tYnJlJTIwZGUlMjBIZXJyYW1pZW50YSUzQSUyMGNhbGN1bGFkb3JhJTJDJTIwRGVzY3JpcGNpJUMzJUIzbiUzQSUyME11bHRpcGxpY2ElMjBkb3MlMjBlbnRlcm9zLiUyQyUyMEFyZ3VtZW50b3MlM0ElMjBhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCUyQyUyMFNhbGlkYXMlM0ElMjBpbnQ=",highlighted:"Nombre de Herramienta: calculadora, Descripción: Multiplica dos enteros., Argumentos: a: int, b: int, Salidas: int",wrap:!1}}),We=new Za({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/es/unit1/tools.mdx"}}),{c(){d=M("meta"),Ve=s(),Qe=M("p"),Ne=s(),o(T.$$.fragment),Re=s(),o(w.$$.fragment),Xe=s(),C=M("img"),Fe=s(),I=M("p"),I.innerHTML=ht,Pe=s(),A=M("p"),A.textContent=ft,Ke=s(),b=M("p"),b.textContent=vt,De=s(),o(h.$$.fragment),Oe=s(),f=M("p"),f.innerHTML=Bt,el=s(),v=M("p"),v.textContent=gt,ll=s(),B=M("table"),B.innerHTML=xt,tl=s(),g=M("p"),g.textContent=Et,al=s(),x=M("p"),x.innerHTML=_t,sl=s(),E=M("p"),E.innerHTML=Gt,nl=s(),_=M("p"),_.innerHTML=qt,Ml=s(),G=M("p"),G.textContent=Lt,il=s(),q=M("img"),rl=s(),L=M("ul"),L.innerHTML=Zt,ol=s(),o(H.$$.fragment),pl=s(),Z=M("p"),Z.innerHTML=St,ul=s(),S=M("p"),S.innerHTML=$t,ml=s(),$=M("p"),$.textContent=Wt,cl=s(),o(W.$$.fragment),jl=s(),Y=M("p"),Y.textContent=Yt,yl=s(),z=M("img"),dl=s(),Q=M("p"),Q.textContent=Qt,Ul=s(),k=M("ol"),k.innerHTML=kt,Jl=s(),V=M("p"),V.innerHTML=Vt,Tl=s(),N=M("p"),N.textContent=Nt,wl=s(),R=M("p"),R.innerHTML=Rt,Cl=s(),o(X.$$.fragment),Il=s(),F=M("p"),F.innerHTML=Xt,Al=s(),P=M("ul"),P.innerHTML=Ft,bl=s(),K=M("p"),K.textContent=Pt,hl=s(),D=M("ul"),D.innerHTML=Kt,fl=s(),O=M("p"),O.textContent=Dt,vl=s(),o(ee.$$.fragment),Bl=s(),le=M("blockquote"),le.innerHTML=Ot,gl=s(),te=M("p"),te.textContent=ea,xl=s(),ae=M("p"),ae.textContent=la,El=s(),se=M("p"),se.textContent=ta,_l=s(),o(ne.$$.fragment),Gl=s(),Me=M("p"),Me.textContent=aa,ql=s(),ie=M("ul"),ie.innerHTML=sa,Ll=s(),re=M("p"),re.textContent=na,Hl=s(),oe=M("p"),oe.innerHTML=Ma,Zl=s(),pe=M("p"),pe.textContent=ia,Sl=s(),ue=M("p"),ue.innerHTML=ra,$l=s(),o(me.$$.fragment),Wl=s(),ce=M("p"),ce.innerHTML=oa,Yl=s(),je=M("p"),je.innerHTML=pa,zl=s(),o(ye.$$.fragment),Ql=s(),de=M("p"),de.textContent=ua,kl=s(),o(Ue.$$.fragment),Vl=s(),Je=M("p"),Je.innerHTML=ma,Nl=s(),Te=M("blockquote"),Te.innerHTML=ca,Rl=s(),o(we.$$.fragment),Xl=s(),Ce=M("p"),Ce.innerHTML=ja,Fl=s(),Ie=M("ul"),Ie.innerHTML=ya,Pl=s(),Ae=M("p"),Ae.textContent=da,Kl=s(),o(be.$$.fragment),Dl=s(),he=M("p"),he.innerHTML=Ua,Ol=s(),fe=M("blockquote"),fe.innerHTML=Ja,et=s(),J=M("details"),Ye=M("summary"),Ye.textContent=Ta,wt=s(),o(ve.$$.fragment),lt=s(),Be=M("p"),Be.textContent=wa,tt=s(),o(ge.$$.fragment),at=s(),xe=M("p"),xe.innerHTML=Ca,st=s(),o(Ee.$$.fragment),nt=s(),_e=M("p"),_e.innerHTML=Ia,Mt=s(),Ge=M("img"),it=s(),qe=M("p"),qe.innerHTML=ba,rt=s(),ot=M("hr"),pt=s(),Le=M("p"),Le.textContent=ha,ut=s(),He=M("p"),He.textContent=fa,mt=s(),Ze=M("ul"),Ze.innerHTML=va,ct=s(),Se=M("p"),Se.innerHTML=Ba,jt=s(),$e=M("p"),$e.textContent=ga,yt=s(),o(We.$$.fragment),dt=s(),ke=M("p"),this.h()},l(e){const l=La("svelte-u9bgzb",document.head);d=i(l,"META",{name:!0,content:!0}),l.forEach(t),Ve=n(e),Qe=i(e,"P",{}),Ct(Qe).forEach(t),Ne=n(e),p(T.$$.fragment,e),Re=n(e),p(w.$$.fragment,e),Xe=n(e),C=i(e,"IMG",{src:!0,alt:!0}),Fe=n(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-11v5lbd"&&(I.innerHTML=ht),Pe=n(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-yzryio"&&(A.textContent=ft),Ke=n(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-ldqc23"&&(b.textContent=vt),De=n(e),p(h.$$.fragment,e),Oe=n(e),f=i(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-3spete"&&(f.innerHTML=Bt),el=n(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-19u4e87"&&(v.textContent=gt),ll=n(e),B=i(e,"TABLE",{"data-svelte-h":!0}),r(B)!=="svelte-x2anqg"&&(B.innerHTML=xt),tl=n(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1rhr6un"&&(g.textContent=Et),al=n(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1f5lua9"&&(x.innerHTML=_t),sl=n(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-axh2sd"&&(E.innerHTML=Gt),nl=n(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-uajc2b"&&(_.innerHTML=qt),Ml=n(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-qgie3k"&&(G.textContent=Lt),il=n(e),q=i(e,"IMG",{src:!0,alt:!0}),rl=n(e),L=i(e,"UL",{"data-svelte-h":!0}),r(L)!=="svelte-nvr74z"&&(L.innerHTML=Zt),ol=n(e),p(H.$$.fragment,e),pl=n(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1vf9x86"&&(Z.innerHTML=St),ul=n(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1jfsjsz"&&(S.innerHTML=$t),ml=n(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-w3s9nu"&&($.textContent=Wt),cl=n(e),p(W.$$.fragment,e),jl=n(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1iuucst"&&(Y.textContent=Yt),yl=n(e),z=i(e,"IMG",{src:!0,alt:!0}),dl=n(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1auxopn"&&(Q.textContent=Qt),Ul=n(e),k=i(e,"OL",{"data-svelte-h":!0}),r(k)!=="svelte-nxsu3i"&&(k.innerHTML=kt),Jl=n(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-14ua9gl"&&(V.innerHTML=Vt),Tl=n(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1ruj9h1"&&(N.textContent=Nt),wl=n(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-50x2n7"&&(R.innerHTML=Rt),Cl=n(e),p(X.$$.fragment,e),Il=n(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1t933sx"&&(F.innerHTML=Xt),Al=n(e),P=i(e,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-1hgz7n1"&&(P.innerHTML=Ft),bl=n(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1p1ymq5"&&(K.textContent=Pt),hl=n(e),D=i(e,"UL",{"data-svelte-h":!0}),r(D)!=="svelte-x64alw"&&(D.innerHTML=Kt),fl=n(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-ogtujw"&&(O.textContent=Dt),vl=n(e),p(ee.$$.fragment,e),Bl=n(e),le=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(le)!=="svelte-jgxyv0"&&(le.innerHTML=Ot),gl=n(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1simtbd"&&(te.textContent=ea),xl=n(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1f18wsz"&&(ae.textContent=la),El=n(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1aeb213"&&(se.textContent=ta),_l=n(e),p(ne.$$.fragment,e),Gl=n(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-umx0z8"&&(Me.textContent=aa),ql=n(e),ie=i(e,"UL",{"data-svelte-h":!0}),r(ie)!=="svelte-4mn1a5"&&(ie.innerHTML=sa),Ll=n(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1vcqfuv"&&(re.textContent=na),Hl=n(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-14fd26j"&&(oe.innerHTML=Ma),Zl=n(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-d1jwkz"&&(pe.textContent=ia),Sl=n(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-12rpj5d"&&(ue.innerHTML=ra),$l=n(e),p(me.$$.fragment,e),Wl=n(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-sc3whw"&&(ce.innerHTML=oa),Yl=n(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-zq1sjc"&&(je.innerHTML=pa),zl=n(e),p(ye.$$.fragment,e),Ql=n(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1nnyzya"&&(de.textContent=ua),kl=n(e),p(Ue.$$.fragment,e),Vl=n(e),Je=i(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1ggdx7a"&&(Je.innerHTML=ma),Nl=n(e),Te=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(Te)!=="svelte-zpb818"&&(Te.innerHTML=ca),Rl=n(e),p(we.$$.fragment,e),Xl=n(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1pqprji"&&(Ce.innerHTML=ja),Fl=n(e),Ie=i(e,"UL",{"data-svelte-h":!0}),r(Ie)!=="svelte-ndkw87"&&(Ie.innerHTML=ya),Pl=n(e),Ae=i(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1342fh5"&&(Ae.textContent=da),Kl=n(e),p(be.$$.fragment,e),Dl=n(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-n2m443"&&(he.innerHTML=Ua),Ol=n(e),fe=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(fe)!=="svelte-uzxbeb"&&(fe.innerHTML=Ja),et=n(e),J=i(e,"DETAILS",{});var Jt=Ct(J);Ye=i(Jt,"SUMMARY",{"data-svelte-h":!0}),r(Ye)!=="svelte-1u34veb"&&(Ye.textContent=Ta),wt=n(Jt),p(ve.$$.fragment,Jt),Jt.forEach(t),lt=n(e),Be=i(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-i0tl7x"&&(Be.textContent=wa),tt=n(e),p(ge.$$.fragment,e),at=n(e),xe=i(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-ovqblh"&&(xe.innerHTML=Ca),st=n(e),p(Ee.$$.fragment,e),nt=n(e),_e=i(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-gdec90"&&(_e.innerHTML=Ia),Mt=n(e),Ge=i(e,"IMG",{src:!0,alt:!0}),it=n(e),qe=i(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1n9jyyn"&&(qe.innerHTML=ba),rt=n(e),ot=i(e,"HR",{}),pt=n(e),Le=i(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1ezmtbd"&&(Le.textContent=ha),ut=n(e),He=i(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-2xuet7"&&(He.textContent=fa),mt=n(e),Ze=i(e,"UL",{"data-svelte-h":!0}),r(Ze)!=="svelte-1m3sl14"&&(Ze.innerHTML=va),ct=n(e),Se=i(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1rb6wl2"&&(Se.innerHTML=Ba),jt=n(e),$e=i(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1u8pkw1"&&($e.textContent=ga),yt=n(e),p(We.$$.fragment,e),dt=n(e),ke=i(e,"P",{}),Ct(ke).forEach(t),this.h()},h(){y(d,"name","hf:doc:metadata"),y(d,"content",$a),Tt(C.src,bt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/whiteboard-check-2.jpg")||y(C,"src",bt),y(C,"alt","Planificación de la Unidad 1"),Tt(q.src,Ht="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/weather.jpg")||y(q,"src",Ht),y(q,"alt","Clima"),Tt(z.src,zt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt.png")||y(z,"src",zt),y(z,"alt","Prompt del sistema para herramientas"),Tt(Ge.src,Aa="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt_tools.png")||y(Ge,"src",Aa),y(Ge,"alt","Prompt del sistema para herramientas")},m(e,l){It(document.head,d),a(e,Ve,l),a(e,Qe,l),a(e,Ne,l),u(T,e,l),a(e,Re,l),u(w,e,l),a(e,Xe,l),a(e,C,l),a(e,Fe,l),a(e,I,l),a(e,Pe,l),a(e,A,l),a(e,Ke,l),a(e,b,l),a(e,De,l),u(h,e,l),a(e,Oe,l),a(e,f,l),a(e,el,l),a(e,v,l),a(e,ll,l),a(e,B,l),a(e,tl,l),a(e,g,l),a(e,al,l),a(e,x,l),a(e,sl,l),a(e,E,l),a(e,nl,l),a(e,_,l),a(e,Ml,l),a(e,G,l),a(e,il,l),a(e,q,l),a(e,rl,l),a(e,L,l),a(e,ol,l),u(H,e,l),a(e,pl,l),a(e,Z,l),a(e,ul,l),a(e,S,l),a(e,ml,l),a(e,$,l),a(e,cl,l),u(W,e,l),a(e,jl,l),a(e,Y,l),a(e,yl,l),a(e,z,l),a(e,dl,l),a(e,Q,l),a(e,Ul,l),a(e,k,l),a(e,Jl,l),a(e,V,l),a(e,Tl,l),a(e,N,l),a(e,wl,l),a(e,R,l),a(e,Cl,l),u(X,e,l),a(e,Il,l),a(e,F,l),a(e,Al,l),a(e,P,l),a(e,bl,l),a(e,K,l),a(e,hl,l),a(e,D,l),a(e,fl,l),a(e,O,l),a(e,vl,l),u(ee,e,l),a(e,Bl,l),a(e,le,l),a(e,gl,l),a(e,te,l),a(e,xl,l),a(e,ae,l),a(e,El,l),a(e,se,l),a(e,_l,l),u(ne,e,l),a(e,Gl,l),a(e,Me,l),a(e,ql,l),a(e,ie,l),a(e,Ll,l),a(e,re,l),a(e,Hl,l),a(e,oe,l),a(e,Zl,l),a(e,pe,l),a(e,Sl,l),a(e,ue,l),a(e,$l,l),u(me,e,l),a(e,Wl,l),a(e,ce,l),a(e,Yl,l),a(e,je,l),a(e,zl,l),u(ye,e,l),a(e,Ql,l),a(e,de,l),a(e,kl,l),u(Ue,e,l),a(e,Vl,l),a(e,Je,l),a(e,Nl,l),a(e,Te,l),a(e,Rl,l),u(we,e,l),a(e,Xl,l),a(e,Ce,l),a(e,Fl,l),a(e,Ie,l),a(e,Pl,l),a(e,Ae,l),a(e,Kl,l),u(be,e,l),a(e,Dl,l),a(e,he,l),a(e,Ol,l),a(e,fe,l),a(e,et,l),a(e,J,l),It(J,Ye),It(J,wt),u(ve,J,null),a(e,lt,l),a(e,Be,l),a(e,tt,l),u(ge,e,l),a(e,at,l),a(e,xe,l),a(e,st,l),u(Ee,e,l),a(e,nt,l),a(e,_e,l),a(e,Mt,l),a(e,Ge,l),a(e,it,l),a(e,qe,l),a(e,rt,l),a(e,ot,l),a(e,pt,l),a(e,Le,l),a(e,ut,l),a(e,He,l),a(e,mt,l),a(e,Ze,l),a(e,ct,l),a(e,Se,l),a(e,jt,l),a(e,$e,l),a(e,yt,l),u(We,e,l),a(e,dt,l),a(e,ke,l),Ut=!0},p:Ea,i(e){Ut||(m(T.$$.fragment,e),m(w.$$.fragment,e),m(h.$$.fragment,e),m(H.$$.fragment,e),m(W.$$.fragment,e),m(X.$$.fragment,e),m(ee.$$.fragment,e),m(ne.$$.fragment,e),m(me.$$.fragment,e),m(ye.$$.fragment,e),m(Ue.$$.fragment,e),m(we.$$.fragment,e),m(be.$$.fragment,e),m(ve.$$.fragment,e),m(ge.$$.fragment,e),m(Ee.$$.fragment,e),m(We.$$.fragment,e),Ut=!0)},o(e){c(T.$$.fragment,e),c(w.$$.fragment,e),c(h.$$.fragment,e),c(H.$$.fragment,e),c(W.$$.fragment,e),c(X.$$.fragment,e),c(ee.$$.fragment,e),c(ne.$$.fragment,e),c(me.$$.fragment,e),c(ye.$$.fragment,e),c(Ue.$$.fragment,e),c(we.$$.fragment,e),c(be.$$.fragment,e),c(ve.$$.fragment,e),c(ge.$$.fragment,e),c(Ee.$$.fragment,e),c(We.$$.fragment,e),Ut=!1},d(e){e&&(t(Ve),t(Qe),t(Ne),t(Re),t(Xe),t(C),t(Fe),t(I),t(Pe),t(A),t(Ke),t(b),t(De),t(Oe),t(f),t(el),t(v),t(ll),t(B),t(tl),t(g),t(al),t(x),t(sl),t(E),t(nl),t(_),t(Ml),t(G),t(il),t(q),t(rl),t(L),t(ol),t(pl),t(Z),t(ul),t(S),t(ml),t($),t(cl),t(jl),t(Y),t(yl),t(z),t(dl),t(Q),t(Ul),t(k),t(Jl),t(V),t(Tl),t(N),t(wl),t(R),t(Cl),t(Il),t(F),t(Al),t(P),t(bl),t(K),t(hl),t(D),t(fl),t(O),t(vl),t(Bl),t(le),t(gl),t(te),t(xl),t(ae),t(El),t(se),t(_l),t(Gl),t(Me),t(ql),t(ie),t(Ll),t(re),t(Hl),t(oe),t(Zl),t(pe),t(Sl),t(ue),t($l),t(Wl),t(ce),t(Yl),t(je),t(zl),t(Ql),t(de),t(kl),t(Vl),t(Je),t(Nl),t(Te),t(Rl),t(Xl),t(Ce),t(Fl),t(Ie),t(Pl),t(Ae),t(Kl),t(Dl),t(he),t(Ol),t(fe),t(et),t(J),t(lt),t(Be),t(tt),t(at),t(xe),t(st),t(nt),t(_e),t(Mt),t(Ge),t(it),t(qe),t(rt),t(ot),t(pt),t(Le),t(ut),t(He),t(mt),t(Ze),t(ct),t(Se),t(jt),t($e),t(yt),t(dt),t(ke)),t(d),j(T,e),j(w,e),j(h,e),j(H,e),j(W,e),j(X,e),j(ee,e),j(ne,e),j(me,e),j(ye,e),j(Ue,e),j(we,e),j(be,e),j(ve),j(ge,e),j(Ee,e),j(We,e)}}}const $a='{"title":"¿Qué son las Herramientas?","local":"qué-son-las-herramientas","sections":[{"title":"¿Qué son las Herramientas de IA?","local":"qué-son-las-herramientas-de-ia","sections":[],"depth":2},{"title":"¿Cómo funcionan las herramientas?","local":"cómo-funcionan-las-herramientas","sections":[],"depth":2},{"title":"¿Cómo proporcionamos herramientas a un LLM?","local":"cómo-proporcionamos-herramientas-a-un-llm","sections":[{"title":"Auto-formateo de secciones de Herramientas","local":"auto-formateo-de-secciones-de-herramientas","sections":[],"depth":3},{"title":"Implementación genérica de Herramienta","local":"implementación-genérica-de-herramienta","sections":[],"depth":3}],"depth":2}],"depth":1}';function Wa(At){return _a(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ra extends Ga{constructor(d){super(),qa(this,d,Wa,Sa,xa,{})}}export{Ra as component};
