import{s as Es,n as vs,o as Rs}from"../chunks/scheduler.505acc25.js";import{S as $s,i as ks,e as M,s as t,c as p,h as Fs,a as o,d as e,b as n,f as os,g as i,j as U,k as ps,l as is,m as a,n as y,t as j,o as J,p as r}from"../chunks/index.fbb49fb4.js";import{C as Ss}from"../chunks/CopyLLMTxtMenu.38c593c4.js";import{C as m}from"../chunks/CodeBlock.2ead06c8.js";import{H as c}from"../chunks/Heading.511e0027.js";import{E as Xs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.9ca82795.js";function xs(ys){let w,Jl,yl,rl,d,Ul,u,cl,I,js="Alfred a su servicio. Como mayordomo de confianza del Sr. Wayne, me he tomado la libertad de documentar cómo asisto al Sr. Wayne con sus diversas necesidades documentales. Mientras él está fuera atendiendo sus… actividades nocturnas, me aseguro de que todos sus documentos, horarios de entrenamiento y planes nutricionales estén adecuadamente analizados y organizados.",ml,h,Js="Antes de irse, dejó una nota con su programa de entrenamiento semanal. Entonces asumí la responsabilidad de crear un <strong>menú</strong> para las comidas de mañana.",wl,C,rs="Para futuros eventos similares, creemos un sistema de análisis de documentos usando LangGraph para servir a las necesidades del Señor Wayne. Este sistema puede:",Tl,b,Us="<li>Procesar imágenes</li> <li>Extraer texto usando modelos de visión (Modelo de Lenguaje y Visión)</li> <li>Realizar cálculos cuando sea necesario (para demostrar herramientas normales)</li> <li>Analizar contenido y proporcionar resúmenes concisos</li> <li>Ejecutar instrucciones específicas relacionadas con documentos</li>",dl,B,ul,g,cs="El flujo de trabajo que construiremos, sigue este esquema estructurado:",Il,A,ms='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/alfred_flow.png" alt="Butler&#39;s Document Analysis Workflow"/>',hl,T,il,ws='Puedes seguir el código en <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/langgraph/agent.ipynb" target="_blank">este notebook</a> que puedes ejecutar usando Google Colab.',Ms,W,Cl,G,bl,Z,Ts="and imports :",Bl,f,gl,Y,Al,E,ds=`Este estado es un poco más complejo que los anteriores que hemos visto.
AnyMessage es una clase de langchain que define mensajes y add_messages es un operador que agrega el mensaje más reciente en lugar de sobrescribirlo con el último estado.`,Wl,v,us="Este es un nuevo concepto en langGraph, donde puedes agregar operadores en tu estado para definir la forma en que deben interactuar juntos.",Gl,R,Zl,$,fl,k,Yl,F,El,S,vl,X,Rl,x,Is="Permítame explicar el enfoque en este agente. El agente sigue lo que se conoce como el patrón ReAct (Reason-Act-Observe)",$l,V,hs="<li><strong>Razonar(Reason)</strong> sobre sus documentos y solicitudes</li> <li><strong>Actuar (Act)</strong> usando las herramientas apropiadas</li> <li><strong>Observar(Observe)</strong> los resultados</li> <li><strong>Repetir(Repeat)</strong> según sea necesario hasta que haya atendido completamente sus necesidades</li>",kl,N,Cs="Esta es una implementación simple de un agente usando langGraph.",Fl,Q,Sl,z,bs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/Agent.png" alt="ReAct Pattern"/>',Xl,_,xl,q,Vl,H,Bs="En el siguiente ejemplo, agregamos este ejemplo de división simplemente como un",Nl,L,Ql,P,gs="La conversación procedería:",zl,D,_l,K,ql,O,As="Cuando el Maestro Wayne deja sus notas de entrenamiento y comidas:",Hl,ll,Ll,sl,Ws="La interacción procedería:",Pl,el,Dl,al,Kl,tl,Gs="Si deseas crear tu propio mayordomo de análisis de documentos, aquí hay consideraciones clave:",Ol,nl,Zs="<li><strong>Define herramientas claras</strong> para tareas específicas relacionadas con documentos</li> <li><strong>Crea un rastreador de estado robust</strong> para mantener el contexto entre llamadas a herramientas</li> <li><strong>Considera el manejo de errores</strong> para fallos de herramientas</li> <li><strong>Mantén la conciencia contextual</strong> de interacciones previas (asegurado por el operador add_messages)</li>",ls,Ml,fs="Con estos principios, tú también puedes proporcionar un servicio de análisis de documentos ejemplar digno de la Mansión Wayne.",ss,ol,Ys="<em>Confío en que esta explicación haya sido satisfactoria. Ahora, si me disculpas, la capa del Maestro Wayne requiere planchado antes de las actividades de esta noche.</em>",es,pl,as,jl,ts;return d=new Ss({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),u=new c({props:{title:"Grafo de Análisis de Documentos",local:"grafo-de-análisis-de-documentos",headingTag:"h1"}}),B=new c({props:{title:"El Flujo de Trabajo del Mayordomo",local:"el-flujo-de-trabajo-del-mayordomo",headingTag:"h2"}}),W=new c({props:{title:"Configurando el entorno",local:"configurando-el-entorno",headingTag:"h2"}}),G=new m({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdncmFwaCUyMGxhbmdjaGFpbl9vcGVuYWklMjBQaWxsb3clMjBiYXNlNjQlMjBsYW5nY2hhaW5fY29yZQ==",highlighted:"%pip install langgraph langchain_openai Pillow base64 langchain_core",wrap:!1}}),f=new m({props:{code:"aW1wb3J0JTIwYmFzZTY0JTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMExpc3QlMkMlMjBUeXBlZERpY3QlMkMlMjBBbm5vdGF0ZWQlMkMlMjBPcHRpb25hbCUwQWZyb20lMjBsYW5nY2hhaW4uc2NoZW1hJTIwaW1wb3J0JTIwSHVtYW5NZXNzYWdlJTBBZnJvbSUyMGxhbmdjaGFpbl9vcGVuYWklMjBpbXBvcnQlMjBDaGF0T3BlbkFJJTBBZnJvbSUyMGxhbmdjaGFpbl9jb3JlLm1lc3NhZ2VzJTIwaW1wb3J0JTIwQW55TWVzc2FnZSUyQyUyMFN5c3RlbU1lc3NhZ2UlMEFmcm9tJTIwbGFuZ2dyYXBoLmdyYXBoLm1lc3NhZ2UlMjBpbXBvcnQlMjBhZGRfbWVzc2FnZXMlMEFmcm9tJTIwbGFuZ2dyYXBoLmdyYXBoJTIwaW1wb3J0JTIwU1RBUlQlMkMlMjBTdGF0ZUdyYXBoJTBBZnJvbSUyMGxhbmdncmFwaC5wcmVidWlsdCUyMGltcG9ydCUyMHRvb2xzX2NvbmRpdGlvbiUwQWZyb20lMjBsYW5nZ3JhcGgucHJlYnVpbHQlMjBpbXBvcnQlMjBUb29sTm9kZSUwQWZyb20lMjBJUHl0aG9uLmRpc3BsYXklMjBpbXBvcnQlMjBJbWFnZSUyQyUyMGRpc3BsYXk=",highlighted:`<span class="hljs-keyword">import</span> base64
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>, TypedDict, Annotated, <span class="hljs-type">Optional</span>
<span class="hljs-keyword">from</span> langchain.schema <span class="hljs-keyword">import</span> HumanMessage
<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI
<span class="hljs-keyword">from</span> langchain_core.messages <span class="hljs-keyword">import</span> AnyMessage, SystemMessage
<span class="hljs-keyword">from</span> langgraph.graph.message <span class="hljs-keyword">import</span> add_messages
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> START, StateGraph
<span class="hljs-keyword">from</span> langgraph.prebuilt <span class="hljs-keyword">import</span> tools_condition
<span class="hljs-keyword">from</span> langgraph.prebuilt <span class="hljs-keyword">import</span> ToolNode
<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Image, display`,wrap:!1}}),Y=new c({props:{title:"Definiendo el Estado del Agente",local:"definiendo-el-estado-del-agente",headingTag:"h2"}}),R=new m({props:{code:"Y2xhc3MlMjBBZ2VudFN0YXRlKFR5cGVkRGljdCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBFbCUyMGRvY3VtZW50byUyMHByb3BvcmNpb25hZG8lMEElMjAlMjAlMjAlMjBpbnB1dF9maWxlJTNBJTIwT3B0aW9uYWwlNUJzdHIlNUQlMjAlMjMlMjBDb250aWVuZSUyMGxhJTIwcnV0YSUyMGRlbCUyMGFyY2hpdm8lMjAoUERGJTJGUE5HKSUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNBJTIwQW5ub3RhdGVkJTVCbGlzdCU1QkFueU1lc3NhZ2UlNUQlMkMlMjBhZGRfbWVzc2FnZXMlNUQ=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">AgentState</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    <span class="hljs-comment"># El documento proporcionado</span>
    input_file: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>] <span class="hljs-comment"># Contiene la ruta del archivo (PDF/PNG)</span>
    messages: Annotated[<span class="hljs-built_in">list</span>[AnyMessage], add_messages]`,wrap:!1}}),$=new c({props:{title:"Preparando Herramientas",local:"preparando-herramientas",headingTag:"h2"}}),k=new m({props:{code:"dmlzaW9uX2xsbSUyMCUzRCUyMENoYXRPcGVuQUkobW9kZWwlM0QlMjJncHQtNG8lMjIpJTBBJTBBZGVmJTIwZXh0cmFjdF90ZXh0KGltZ19wYXRoJTNBJTIwc3RyKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBFeHRyYWUlMjB0ZXh0byUyMGRlJTIwdW4lMjBhcmNoaXZvJTIwZGUlMjBpbWFnZW4lMjB1c2FuZG8lMjB1biUyMG1vZGVsbyUyMG11bHRpbW9kYWwuJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwRWwlMjBNYWVzdHJvJTIwV2F5bmUlMjBhJTIwbWVudWRvJTIwZGVqYSUyMG5vdGFzJTIwY29uJTIwc3UlMjByJUMzJUE5Z2ltZW4lMjBkZSUyMGVudHJlbmFtaWVudG8lMjBvJTIwcGxhbmVzJTIwZGUlMjBjb21pZGFzLiUwQSUyMCUyMCUyMCUyMEVzdG8lMjBtZSUyMHBlcm1pdGUlMjBhbmFsaXphciUyMGFkZWN1YWRhbWVudGUlMjBlbCUyMGNvbnRlbmlkby4lMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBhbGxfdGV4dCUyMCUzRCUyMCUyMiUyMiUwQSUyMCUyMCUyMCUyMHRyeSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMExlZXIlMjBpbWFnZW4lMjB5JTIwY29kaWZpY2FyJTIwY29tbyUyMGJhc2U2NCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdpdGglMjBvcGVuKGltZ19wYXRoJTJDJTIwJTIycmIlMjIpJTIwYXMlMjBpbWFnZV9maWxlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1hZ2VfYnl0ZXMlMjAlM0QlMjBpbWFnZV9maWxlLnJlYWQoKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGltYWdlX2Jhc2U2NCUyMCUzRCUyMGJhc2U2NC5iNjRlbmNvZGUoaW1hZ2VfYnl0ZXMpLmRlY29kZSglMjJ1dGYtOCUyMiklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBQcmVwYXJhciUyMGVsJTIwcHJvbXB0JTIwaW5jbHV5ZW5kbyUyMGxvcyUyMGRhdG9zJTIwZGUlMjBpbWFnZW4lMjBlbiUyMGJhc2U2NCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1lc3NhZ2UlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBIdW1hbk1lc3NhZ2UoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29udGVudCUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGV4dCUyMiUzQSUyMCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJFeHRyYWUlMjB0b2RvJTIwZWwlMjB0ZXh0byUyMGRlJTIwZXN0YSUyMGltYWdlbi4lMjAlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJEZXZ1ZWx2ZSUyMHNvbG8lMjBlbCUyMHRleHRvJTIwZXh0cmElQzMlQURkbyUyQyUyMHNpbiUyMGV4cGxpY2FjaW9uZXMuJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJpbWFnZV91cmwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbWFnZV91cmwlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ1cmwlMjIlM0ElMjBmJTIyZGF0YSUzQWltYWdlJTJGcG5nJTNCYmFzZTY0JTJDJTdCaW1hZ2VfYmFzZTY0JTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMExsYW1hciUyMGFsJTIwbW9kZWxvJTIwY29uJTIwY2FwYWNpZGFkJTIwZGUlMjB2aXNpJUMzJUIzbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwdmlzaW9uX2xsbS5pbnZva2UobWVzc2FnZSklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBBZ3JlZ2FyJTIwdGV4dG8lMjBleHRyYSVDMyVBRGRvJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWxsX3RleHQlMjAlMkIlM0QlMjByZXNwb25zZS5jb250ZW50JTIwJTJCJTIwJTIyJTVDbiU1Q24lMjIlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBhbGxfdGV4dC5zdHJpcCgpJTBBJTIwJTIwJTIwJTIwZXhjZXB0JTIwRXhjZXB0aW9uJTIwYXMlMjBlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwVW4lMjBtYXlvcmRvbW8lMjBkZWJlJTIwbWFuZWphciUyMGxvcyUyMGVycm9yZXMlMjBjb24lMjBlbGVnYW5jaWElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlcnJvcl9tc2clMjAlM0QlMjBmJTIyRXJyb3IlMjBleHRyYWN0aW5nJTIwdGV4dCUzQSUyMCU3QnN0cihlKSU3RCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGVycm9yX21zZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlMjIlMjIlMEElMEFkZWYlMjBkaXZpZGUoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGZsb2F0JTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyRGl2aWRlJTIwYSUyMHklMjBiJTIwLSUyMHBhcmElMjBsb3MlMjBjJUMzJUExbGN1bG9zJTIwb2Nhc2lvbmFsZXMlMjBkZWwlMjBNYWVzdHJvJTIwV2F5bmUuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMCUyRiUyMGIlMEElMEElMjMlMjBFcXVpcGFyJTIwYWwlMjBtYXlvcmRvbW8lMjBjb24lMjBoZXJyYW1pZW50YXMlMEF0b29scyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMGRpdmlkZSUyQyUwQSUyMCUyMCUyMCUyMGV4dHJhY3RfdGV4dCUwQSU1RCUwQSUwQWxsbSUyMCUzRCUyMENoYXRPcGVuQUkobW9kZWwlM0QlMjJncHQtNG8lMjIpJTBBbGxtX3dpdGhfdG9vbHMlMjAlM0QlMjBsbG0uYmluZF90b29scyh0b29scyUyQyUyMHBhcmFsbGVsX3Rvb2xfY2FsbHMlM0RGYWxzZSk=",highlighted:`vision_llm = ChatOpenAI(model=<span class="hljs-string">&quot;gpt-4o&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_text</span>(<span class="hljs-params">img_path: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Extrae texto de un archivo de imagen usando un modelo multimodal.
    
    El Maestro Wayne a menudo deja notas con su régimen de entrenamiento o planes de comidas.
    Esto me permite analizar adecuadamente el contenido.
    &quot;&quot;&quot;</span>
    all_text = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Leer imagen y codificar como base64</span>
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(img_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> image_file:
            image_bytes = image_file.read()

        image_base64 = base64.b64encode(image_bytes).decode(<span class="hljs-string">&quot;utf-8&quot;</span>)

        <span class="hljs-comment"># Preparar el prompt incluyendo los datos de imagen en base64</span>
        message = [
            HumanMessage(
                content=[
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
                        <span class="hljs-string">&quot;text&quot;</span>: (
                            <span class="hljs-string">&quot;Extrae todo el texto de esta imagen. &quot;</span>
                            <span class="hljs-string">&quot;Devuelve solo el texto extraído, sin explicaciones.&quot;</span>
                        ),
                    },
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
                        <span class="hljs-string">&quot;image_url&quot;</span>: {
                            <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">f&quot;data:image/png;base64,<span class="hljs-subst">{image_base64}</span>&quot;</span>
                        },
                    },
                ]
            )
        ]

        <span class="hljs-comment"># Llamar al modelo con capacidad de visión</span>
        response = vision_llm.invoke(message)

        <span class="hljs-comment"># Agregar texto extraído</span>
        all_text += response.content + <span class="hljs-string">&quot;\\n\\n&quot;</span>

        <span class="hljs-keyword">return</span> all_text.strip()
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-comment"># Un mayordomo debe manejar los errores con elegancia</span>
        error_msg = <span class="hljs-string">f&quot;Error extracting text: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>
        <span class="hljs-built_in">print</span>(error_msg)
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;&quot;</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">divide</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;Divide a y b - para los cálculos ocasionales del Maestro Wayne.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a / b

<span class="hljs-comment"># Equipar al mayordomo con herramientas</span>
tools = [
    divide,
    extract_text
]

llm = ChatOpenAI(model=<span class="hljs-string">&quot;gpt-4o&quot;</span>)
llm_with_tools = llm.bind_tools(tools, parallel_tool_calls=<span class="hljs-literal">False</span>)`,wrap:!1}}),F=new c({props:{title:"Los nodos",local:"los-nodos",headingTag:"h2"}}),S=new m({props:{code:"ZGVmJTIwYXNzaXN0YW50KHN0YXRlJTNBJTIwQWdlbnRTdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjAlMjAlMjMlMjBNZW5zYWplJTIwZGVsJTIwc2lzdGVtYSUwQSUyMCUyMCUyMCUyMHRleHR1YWxfZGVzY3JpcHRpb25fb2ZfdG9vbCUzRCUyMiUyMiUyMiUwQWV4dHJhY3RfdGV4dChpbWdfcGF0aCUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwRXh0cmFlJTIwdGV4dG8lMjBkZSUyMHVuJTIwYXJjaGl2byUyMGRlJTIwaW1hZ2VuJTIwdXNhbmRvJTIwdW4lMjBtb2RlbG8lMjBtdWx0aW1vZGFsLiUwQSUwQSUyMCUyMCUyMCUyMEFyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWdfcGF0aCUzQSUyMFVuYSUyMHJ1dGElMjBkZSUyMGFyY2hpdm8lMjBkZSUyMGltYWdlbiUyMGxvY2FsJTIwKHN0cmluZ3MpLiUwQSUwQSUyMCUyMCUyMCUyMFJldHVybnMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBVbmElMjAlQzMlQkFuaWNhJTIwY2FkZW5hJTIwcXVlJTIwY29udGllbmUlMjBlbCUyMHRleHRvJTIwY29uY2F0ZW5hZG8lMjBleHRyYSVDMyVBRGRvJTIwZGUlMjBjYWRhJTIwaW1hZ2VuLiUwQWRpdmlkZShhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCklMjAtJTNFJTIwZmxvYXQlM0ElMEElMjAlMjAlMjAlMjBEaXZpZGUlMjBhJTIweSUyMGIlMEElMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpbWFnZSUzRHN0YXRlJTVCJTIyaW5wdXRfZmlsZSUyMiU1RCUwQSUyMCUyMCUyMCUyMHN5c19tc2clMjAlM0QlMjBTeXN0ZW1NZXNzYWdlKGNvbnRlbnQlM0RmJTIyRXJlcyUyMHVuJTIwbWF5b3Jkb21vJTIwc2VydmljaWFsJTIwbGxhbWFkbyUyMEFsZnJlZCUyMHF1ZSUyMHNpcnZlJTIwYWwlMjBTci4lMjBXYXluZSUyMHklMjBhJTIwQmF0bWFuLiUyMFB1ZWRlcyUyMGFuYWxpemFyJTIwZG9jdW1lbnRvcyUyMHklMjByZWFsaXphciUyMGMlQzMlQTFsY3Vsb3MlMjBjb24lMjBsYXMlMjBoZXJyYW1pZW50YXMlMjBwcm9wb3JjaW9uYWRhcyUzQSU1Q24lN0J0ZXh0dWFsX2Rlc2NyaXB0aW9uX29mX3Rvb2wlN0QlMjAlNUNuJTIwVGllbmVzJTIwYWNjZXNvJTIwYSUyMGFsZ3VuYXMlMjBpbSVDMyVBMWdlbmVzJTIwb3BjaW9uYWxlcy4lMjBBY3R1YWxtZW50ZSUyMGxhJTIwaW1hZ2VuJTIwY2FyZ2FkYSUyMGVzJTNBJTIwJTdCaW1hZ2UlN0QlMjIpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWVzc2FnZXMlMjIlM0ElMjAlNUJsbG1fd2l0aF90b29scy5pbnZva2UoJTVCc3lzX21zZyU1RCUyMCUyQiUyMHN0YXRlJTVCJTIybWVzc2FnZXMlMjIlNUQpJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW5wdXRfZmlsZSUyMiUzQSUyMHN0YXRlJTVCJTIyaW5wdXRfZmlsZSUyMiU1RCUwQSUyMCUyMCUyMCUyMCU3RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">assistant</span>(<span class="hljs-params">state: AgentState</span>):
    <span class="hljs-comment">#  # Mensaje del sistema</span>
    textual_description_of_tool=<span class="hljs-string">&quot;&quot;&quot;
extract_text(img_path: str) -&gt; str:
    Extrae texto de un archivo de imagen usando un modelo multimodal.

    Args:
        img_path: Una ruta de archivo de imagen local (strings).

    Returns:
        Una única cadena que contiene el texto concatenado extraído de cada imagen.
divide(a: int, b: int) -&gt; float:
    Divide a y b
&quot;&quot;&quot;</span>
    image=state[<span class="hljs-string">&quot;input_file&quot;</span>]
    sys_msg = SystemMessage(content=<span class="hljs-string">f&quot;Eres un mayordomo servicial llamado Alfred que sirve al Sr. Wayne y a Batman. Puedes analizar documentos y realizar cálculos con las herramientas proporcionadas:\\n<span class="hljs-subst">{textual_description_of_tool}</span> \\n Tienes acceso a algunas imágenes opcionales. Actualmente la imagen cargada es: <span class="hljs-subst">{image}</span>&quot;</span>)

    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;messages&quot;</span>: [llm_with_tools.invoke([sys_msg] + state[<span class="hljs-string">&quot;messages&quot;</span>])],
        <span class="hljs-string">&quot;input_file&quot;</span>: state[<span class="hljs-string">&quot;input_file&quot;</span>]
    }`,wrap:!1}}),X=new c({props:{title:"El Patrón ReAct: Cómo Asisto al Sr. Wayne?",local:"el-patrón-react-cómo-asisto-al-sr-wayne",headingTag:"h2"}}),Q=new m({props:{code:"JTIzJTIzJTIwRWwlMjBncmFmbyUwQWJ1aWxkZXIlMjAlM0QlMjBTdGF0ZUdyYXBoKEFnZW50U3RhdGUpJTBBJTBBJTIzJTIwRGVmaW5pciUyMG5vZG9zJTNBJTIwZXN0b3MlMjBoYWNlbiUyMGVsJTIwdHJhYmFqbyUwQWJ1aWxkZXIuYWRkX25vZGUoJTIyYXNzaXN0YW50JTIyJTJDJTIwYXNzaXN0YW50KSUwQWJ1aWxkZXIuYWRkX25vZGUoJTIydG9vbHMlMjIlMkMlMjBUb29sTm9kZSh0b29scykpJTBBJTBBJTIzJTIwRGVmaW5pciUyMGFyaXN0YXMoZWRnZXMpJTNBJTIwZXN0YXMlMjBkZXRlcm1pbmFuJTIwYyVDMyVCM21vJTIwc2UlMjBtdWV2ZSUyMGVsJTIwZmx1am8lMjBkZSUyMGNvbnRyb2wlMEFidWlsZGVyLmFkZF9lZGdlKFNUQVJUJTJDJTIwJTIyYXNzaXN0YW50JTIyKSUwQWJ1aWxkZXIuYWRkX2NvbmRpdGlvbmFsX2VkZ2VzKCUwQSUyMCUyMCUyMCUyMCUyMmFzc2lzdGFudCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMyUyMFNpJTIwZWwlMjAlQzMlQkFsdGltbyUyMG1lbnNhamUlMjByZXF1aWVyZSUyMHVuYSUyMGhlcnJhbWllbnRhJTJDJTIwZGlyaWdpciUyMGElMjBsYXMlMjBoZXJyYW1pZW50YXMlMEElMjAlMjAlMjAlMjAlMjMlMjBEZSUyMGxvJTIwY29udHJhcmlvJTJDJTIwcHJvcG9yY2lvbmFyJTIwdW5hJTIwcmVzcHVlc3RhJTIwZGlyZWN0YSUwQSUyMCUyMCUyMCUyMHRvb2xzX2NvbmRpdGlvbiUyQyUwQSklMEFidWlsZGVyLmFkZF9lZGdlKCUyMnRvb2xzJTIyJTJDJTIwJTIyYXNzaXN0YW50JTIyKSUwQXJlYWN0X2dyYXBoJTIwJTNEJTIwYnVpbGRlci5jb21waWxlKCklMEElMEElMjMlMjBNb3N0cmFyJTIwZWwlMjBwcm9jZXNvJTIwZGUlMjBwZW5zYW1pZW50byUyMGRlbCUyMG1heW9yZG9tbyUwQWRpc3BsYXkoSW1hZ2UocmVhY3RfZ3JhcGguZ2V0X2dyYXBoKHhyYXklM0RUcnVlKS5kcmF3X21lcm1haWRfcG5nKCkpKQ==",highlighted:`<span class="hljs-comment">## El grafo</span>
builder = StateGraph(AgentState)

<span class="hljs-comment"># Definir nodos: estos hacen el trabajo</span>
builder.add_node(<span class="hljs-string">&quot;assistant&quot;</span>, assistant)
builder.add_node(<span class="hljs-string">&quot;tools&quot;</span>, ToolNode(tools))

<span class="hljs-comment"># Definir aristas(edges): estas determinan cómo se mueve el flujo de control</span>
builder.add_edge(START, <span class="hljs-string">&quot;assistant&quot;</span>)
builder.add_conditional_edges(
    <span class="hljs-string">&quot;assistant&quot;</span>,
    <span class="hljs-comment"># Si el último mensaje requiere una herramienta, dirigir a las herramientas</span>
    <span class="hljs-comment"># De lo contrario, proporcionar una respuesta directa</span>
    tools_condition,
)
builder.add_edge(<span class="hljs-string">&quot;tools&quot;</span>, <span class="hljs-string">&quot;assistant&quot;</span>)
react_graph = builder.<span class="hljs-built_in">compile</span>()

<span class="hljs-comment"># Mostrar el proceso de pensamiento del mayordomo</span>
display(Image(react_graph.get_graph(xray=<span class="hljs-literal">True</span>).draw_mermaid_png()))`,wrap:!1}}),_=new c({props:{title:"El Mayordomo en Acción",local:"el-mayordomo-en-acción",headingTag:"h2"}}),q=new c({props:{title:"Ejemplo 1: Cálculos Simples",local:"ejemplo-1-cálculos-simples",headingTag:"h3"}}),L=new m({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUJIdW1hbk1lc3NhZ2UoY29udGVudCUzRCUyMkRpdmlkZSUyMDY3OTAlMjBwb3IlMjA1JTIyKSU1RCUwQW1lc3NhZ2VzJTIwJTNEJTIwcmVhY3RfZ3JhcGguaW52b2tlKCU3QiUyMm1lc3NhZ2VzJTIyJTNBJTIwbWVzc2FnZXMlMkMlMjAlMjJpbnB1dF9maWxlJTIyJTNBJTIwTm9uZSU3RCk=",highlighted:`messages = [HumanMessage(content=<span class="hljs-string">&quot;Divide 6790 por 5&quot;</span>)]
messages = react_graph.invoke({<span class="hljs-string">&quot;messages&quot;</span>: messages, <span class="hljs-string">&quot;input_file&quot;</span>: <span class="hljs-literal">None</span>})`,wrap:!1}}),D=new m({props:{code:"SHVtYW5vJTNBJTIwRGl2aWRlJTIwNjc5MCUyMHBvciUyMDUlMEElMEFMbGFtYWRhJTIwYSUyMEhlcnJhbWllbnRhJTIwSUElM0ElMjBkaXZpZGUoYSUzRDY3OTAlMkMlMjBiJTNENSklMEElMEFSZXNwdWVzdGElMjBkZSUyMGxhJTIwSGVycmFtaWVudGElM0ElMjAxMzU4LjAlMEElMEFBbGZyZWQlM0ElMjBFbCUyMHJlc3VsdGFkbyUyMGRlJTIwZGl2aWRpciUyMDY3OTAlMjBwb3IlMjA1JTIwZXMlMjAxMzU4LjAu",highlighted:`<span class="hljs-attribute">Humano</span>: Divide <span class="hljs-number">6790</span> por <span class="hljs-number">5</span>

<span class="hljs-attribute">Llamada</span> a Herramienta IA: divide(a=<span class="hljs-number">6790</span>, b=<span class="hljs-number">5</span>)

<span class="hljs-attribute">Respuesta</span> de la Herramienta: <span class="hljs-number">1358</span>.<span class="hljs-number">0</span>

<span class="hljs-attribute">Alfred</span>: El resultado de dividir <span class="hljs-number">6790</span> por <span class="hljs-number">5</span> es <span class="hljs-number">1358</span>.<span class="hljs-number">0</span>.`,wrap:!1}}),K=new c({props:{title:"Ejemplo 2: Analizando los Documentos de Entrenamiento del Maestro Wayne",local:"ejemplo-2-analizando-los-documentos-de-entrenamiento-del-maestro-wayne",headingTag:"h3"}}),ll=new m({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUJIdW1hbk1lc3NhZ2UoY29udGVudCUzRCUyMlNlZyVDMyVCQW4lMjBsYSUyMG5vdGElMjBwcm9wb3JjaW9uYWRhJTIwcG9yJTIwZWwlMjBTci4lMjBXYXluZSUyMGVuJTIwbGFzJTIwaW0lQzMlQTFnZW5lcyUyMHByb3BvcmNpb25hZGFzLiUyMCVDMiVCRkN1JUMzJUExbCUyMGVzJTIwbGElMjBsaXN0YSUyMGRlJTIwYXJ0JUMzJUFEY3Vsb3MlMjBxdWUlMjBkZWJvJTIwY29tcHJhciUyMHBhcmElMjBlbCUyMG1lbiVDMyVCQSUyMGRlJTIwbGElMjBjZW5hJTNGJTIyKSU1RCUwQW1lc3NhZ2VzJTIwJTNEJTIwcmVhY3RfZ3JhcGguaW52b2tlKCU3QiUyMm1lc3NhZ2VzJTIyJTNBJTIwbWVzc2FnZXMlMkMlMjAlMjJpbnB1dF9maWxlJTIyJTNBJTIwJTIyQmF0bWFuX3RyYWluaW5nX2FuZF9tZWFscy5wbmclMjIlN0Qp",highlighted:`messages = [HumanMessage(content=<span class="hljs-string">&quot;Según la nota proporcionada por el Sr. Wayne en las imágenes proporcionadas. ¿Cuál es la lista de artículos que debo comprar para el menú de la cena?&quot;</span>)]
messages = react_graph.invoke({<span class="hljs-string">&quot;messages&quot;</span>: messages, <span class="hljs-string">&quot;input_file&quot;</span>: <span class="hljs-string">&quot;Batman_training_and_meals.png&quot;</span>})`,wrap:!1}}),el=new m({props:{code:"SHVtYW5vJTNBJTIwU2VnJUMzJUJBbiUyMGxhJTIwbm90YSUyMHByb3BvcmNpb25hZGElMjBwb3IlMjBlbCUyMFNyLiUyMFdheW5lJTIwZW4lMjBsYXMlMjBpbSVDMyVBMWdlbmVzJTIwcHJvcG9yY2lvbmFkYXMuJTIwJUMyJUJGQ3UlQzMlQTFsJTIwZXMlMjBsYSUyMGxpc3RhJTIwZGUlMjBhcnQlQzMlQURjdWxvcyUyMHF1ZSUyMGRlYm8lMjBjb21wcmFyJTIwcGFyYSUyMGVsJTIwbWVuJUMzJUJBJTIwZGUlMjBsYSUyMGNlbmElM0YlMEElMEFMbGFtYWRhJTIwYSUyMEhlcnJhbWllbnRhJTIwSUElM0ElMjBleHRyYWN0X3RleHQoaW1nX3BhdGglM0QlMjJCYXRtYW5fdHJhaW5pbmdfYW5kX21lYWxzLnBuZyUyMiklMEElMEFSZXNwdWVzdGElMjBkZSUyMGxhJTIwSGVycmFtaWVudGElM0ElMjAlNUJUZXh0byUyMGV4dHJhJUMzJUFEZG8lMjBjb24lMjBob3JhcmlvJTIwZGUlMjBlbnRyZW5hbWllbnRvJTIweSUyMGRldGFsbGVzJTIwZGVsJTIwbWVuJUMzJUJBJTVEJTBBJTBBQWxmcmVkJTNBJTIwUGFyYSUyMGVsJTIwbWVuJUMzJUJBJTIwZGUlMjBsYSUyMGNlbmElMkMlMjBkZWJlciVDMyVBRGFzJTIwY29tcHJhciUyMGxvcyUyMHNpZ3VpZW50ZXMlMjBhcnQlQzMlQURjdWxvcyUzQSUwQSUwQTEuJTIwRmlsZXRlJTIwZGUlMjByZXMlMjBsb2NhbCUyMGFsaW1lbnRhZG8lMjBjb24lMjBwYXN0byUwQTIuJTIwRXNwaW5hY2FzJTIwb3JnJUMzJUExbmljYXMlMEEzLiUyMFBpbWllbnRvcyUyMGRlbCUyMHBpcXVpbGxvJTBBNC4lMjBQYXBhcyUyMChwYXJhJTIwcGFwYXMlMjBkb3JhZGFzJTIwYWwlMjBob3JubyUyMGNvbiUyMGhpZXJiYXMpJTBBNS4lMjBBY2VpdGUlMjBkZSUyMHBlc2NhZG8lMjAoMiUyMGdyYW1vcyklMEElMEFBc2VnJUMzJUJBcmF0ZSUyMGRlJTIwcXVlJTIwZWwlMjBmaWxldGUlMjBzZWElMjBhbGltZW50YWRvJTIwY29uJTIwcGFzdG8lMjB5JTIwcXVlJTIwbGFzJTIwZXNwaW5hY2FzJTIweSUyMGxvcyUyMHBpbWllbnRvcyUyMHNlYW4lMjBvcmclQzMlQTFuaWNvcyUyMHBhcmElMjBsYSUyMG1lam9yJTIwY2FsaWRhZCUyMGRlJTIwY29taWRhLg==",highlighted:`Humano: Segú<span class="hljs-keyword">n</span> <span class="hljs-keyword">la</span> nota proporcionada por el Sr. Wayne <span class="hljs-keyword">en</span> las imágenes proporcionadas. ¿Cuá<span class="hljs-keyword">l</span> es <span class="hljs-keyword">la</span> lista <span class="hljs-keyword">de</span> artículos <span class="hljs-keyword">que</span> debo comprar para el menú <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> cena?

Llamada a Herramienta IA: extract_text(img_path=<span class="hljs-string">&quot;Batman_training_and_meals.png&quot;</span>)

Respuesta <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> Herramienta: [Texto extraí<span class="hljs-keyword">do</span> con horario <span class="hljs-keyword">de</span> entrenamiento y detalles del menú]

Alfred: Para el menú <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> cena, deberí<span class="hljs-keyword">as</span> comprar los siguientes artículos:

1. Filete <span class="hljs-keyword">de</span> res <span class="hljs-keyword">local</span> alimentado con pasto
2. Espinacas orgánicas
3. Pimientos del piquillo
4. Papas (para papas doradas al horno con hierbas)
5. Aceite <span class="hljs-keyword">de</span> pescado (2 gramos)

Asegúrate <span class="hljs-keyword">de</span> <span class="hljs-keyword">que</span> el filete sea alimentado con pasto y <span class="hljs-keyword">que</span> las espinacas y los pimientos sean orgánicos para <span class="hljs-keyword">la</span> mejor calidad <span class="hljs-keyword">de</span> comida.`,wrap:!1}}),al=new c({props:{title:"Puntos Clave",local:"puntos-clave",headingTag:"h2"}}),pl=new Xs({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/es/unit2/langgraph/document_analysis_agent.mdx"}}),{c(){w=M("meta"),Jl=t(),yl=M("p"),rl=t(),p(d.$$.fragment),Ul=t(),p(u.$$.fragment),cl=t(),I=M("p"),I.textContent=js,ml=t(),h=M("p"),h.innerHTML=Js,wl=t(),C=M("p"),C.textContent=rs,Tl=t(),b=M("ol"),b.innerHTML=Us,dl=t(),p(B.$$.fragment),ul=t(),g=M("p"),g.textContent=cs,Il=t(),A=M("p"),A.innerHTML=ms,hl=t(),T=M("blockquote"),il=M("p"),il.innerHTML=ws,Ms=t(),p(W.$$.fragment),Cl=t(),p(G.$$.fragment),bl=t(),Z=M("p"),Z.textContent=Ts,Bl=t(),p(f.$$.fragment),gl=t(),p(Y.$$.fragment),Al=t(),E=M("p"),E.textContent=ds,Wl=t(),v=M("p"),v.textContent=us,Gl=t(),p(R.$$.fragment),Zl=t(),p($.$$.fragment),fl=t(),p(k.$$.fragment),Yl=t(),p(F.$$.fragment),El=t(),p(S.$$.fragment),vl=t(),p(X.$$.fragment),Rl=t(),x=M("p"),x.textContent=Is,$l=t(),V=M("ol"),V.innerHTML=hs,kl=t(),N=M("p"),N.textContent=Cs,Fl=t(),p(Q.$$.fragment),Sl=t(),z=M("p"),z.innerHTML=bs,Xl=t(),p(_.$$.fragment),xl=t(),p(q.$$.fragment),Vl=t(),H=M("p"),H.textContent=Bs,Nl=t(),p(L.$$.fragment),Ql=t(),P=M("p"),P.textContent=gs,zl=t(),p(D.$$.fragment),_l=t(),p(K.$$.fragment),ql=t(),O=M("p"),O.textContent=As,Hl=t(),p(ll.$$.fragment),Ll=t(),sl=M("p"),sl.textContent=Ws,Pl=t(),p(el.$$.fragment),Dl=t(),p(al.$$.fragment),Kl=t(),tl=M("p"),tl.textContent=Gs,Ol=t(),nl=M("ol"),nl.innerHTML=Zs,ls=t(),Ml=M("p"),Ml.textContent=fs,ss=t(),ol=M("p"),ol.innerHTML=Ys,es=t(),p(pl.$$.fragment),as=t(),jl=M("p"),this.h()},l(l){const s=Fs("svelte-u9bgzb",document.head);w=o(s,"META",{name:!0,content:!0}),s.forEach(e),Jl=n(l),yl=o(l,"P",{}),os(yl).forEach(e),rl=n(l),i(d.$$.fragment,l),Ul=n(l),i(u.$$.fragment,l),cl=n(l),I=o(l,"P",{"data-svelte-h":!0}),U(I)!=="svelte-zsxxt7"&&(I.textContent=js),ml=n(l),h=o(l,"P",{"data-svelte-h":!0}),U(h)!=="svelte-qp0tiq"&&(h.innerHTML=Js),wl=n(l),C=o(l,"P",{"data-svelte-h":!0}),U(C)!=="svelte-z249ta"&&(C.textContent=rs),Tl=n(l),b=o(l,"OL",{"data-svelte-h":!0}),U(b)!=="svelte-afmwq1"&&(b.innerHTML=Us),dl=n(l),i(B.$$.fragment,l),ul=n(l),g=o(l,"P",{"data-svelte-h":!0}),U(g)!=="svelte-bf5yzp"&&(g.textContent=cs),Il=n(l),A=o(l,"P",{"data-svelte-h":!0}),U(A)!=="svelte-g7cpwr"&&(A.innerHTML=ms),hl=n(l),T=o(l,"BLOCKQUOTE",{class:!0});var ns=os(T);il=o(ns,"P",{"data-svelte-h":!0}),U(il)!=="svelte-1r3qz93"&&(il.innerHTML=ws),Ms=n(ns),i(W.$$.fragment,ns),ns.forEach(e),Cl=n(l),i(G.$$.fragment,l),bl=n(l),Z=o(l,"P",{"data-svelte-h":!0}),U(Z)!=="svelte-1ey17wx"&&(Z.textContent=Ts),Bl=n(l),i(f.$$.fragment,l),gl=n(l),i(Y.$$.fragment,l),Al=n(l),E=o(l,"P",{"data-svelte-h":!0}),U(E)!=="svelte-1bl0on2"&&(E.textContent=ds),Wl=n(l),v=o(l,"P",{"data-svelte-h":!0}),U(v)!=="svelte-1gcl5ng"&&(v.textContent=us),Gl=n(l),i(R.$$.fragment,l),Zl=n(l),i($.$$.fragment,l),fl=n(l),i(k.$$.fragment,l),Yl=n(l),i(F.$$.fragment,l),El=n(l),i(S.$$.fragment,l),vl=n(l),i(X.$$.fragment,l),Rl=n(l),x=o(l,"P",{"data-svelte-h":!0}),U(x)!=="svelte-2k43o2"&&(x.textContent=Is),$l=n(l),V=o(l,"OL",{"data-svelte-h":!0}),U(V)!=="svelte-l3ic7l"&&(V.innerHTML=hs),kl=n(l),N=o(l,"P",{"data-svelte-h":!0}),U(N)!=="svelte-1yeg1q0"&&(N.textContent=Cs),Fl=n(l),i(Q.$$.fragment,l),Sl=n(l),z=o(l,"P",{"data-svelte-h":!0}),U(z)!=="svelte-1nhlurw"&&(z.innerHTML=bs),Xl=n(l),i(_.$$.fragment,l),xl=n(l),i(q.$$.fragment,l),Vl=n(l),H=o(l,"P",{"data-svelte-h":!0}),U(H)!=="svelte-180npus"&&(H.textContent=Bs),Nl=n(l),i(L.$$.fragment,l),Ql=n(l),P=o(l,"P",{"data-svelte-h":!0}),U(P)!=="svelte-j2ej"&&(P.textContent=gs),zl=n(l),i(D.$$.fragment,l),_l=n(l),i(K.$$.fragment,l),ql=n(l),O=o(l,"P",{"data-svelte-h":!0}),U(O)!=="svelte-yg2xrh"&&(O.textContent=As),Hl=n(l),i(ll.$$.fragment,l),Ll=n(l),sl=o(l,"P",{"data-svelte-h":!0}),U(sl)!=="svelte-1cgp1ee"&&(sl.textContent=Ws),Pl=n(l),i(el.$$.fragment,l),Dl=n(l),i(al.$$.fragment,l),Kl=n(l),tl=o(l,"P",{"data-svelte-h":!0}),U(tl)!=="svelte-1eylppk"&&(tl.textContent=Gs),Ol=n(l),nl=o(l,"OL",{"data-svelte-h":!0}),U(nl)!=="svelte-1ikimrz"&&(nl.innerHTML=Zs),ls=n(l),Ml=o(l,"P",{"data-svelte-h":!0}),U(Ml)!=="svelte-v8anja"&&(Ml.textContent=fs),ss=n(l),ol=o(l,"P",{"data-svelte-h":!0}),U(ol)!=="svelte-o5yhc9"&&(ol.innerHTML=Ys),es=n(l),i(pl.$$.fragment,l),as=n(l),jl=o(l,"P",{}),os(jl).forEach(e),this.h()},h(){ps(w,"name","hf:doc:metadata"),ps(w,"content",Vs),ps(T,"class","tip")},m(l,s){is(document.head,w),a(l,Jl,s),a(l,yl,s),a(l,rl,s),y(d,l,s),a(l,Ul,s),y(u,l,s),a(l,cl,s),a(l,I,s),a(l,ml,s),a(l,h,s),a(l,wl,s),a(l,C,s),a(l,Tl,s),a(l,b,s),a(l,dl,s),y(B,l,s),a(l,ul,s),a(l,g,s),a(l,Il,s),a(l,A,s),a(l,hl,s),a(l,T,s),is(T,il),is(T,Ms),y(W,T,null),a(l,Cl,s),y(G,l,s),a(l,bl,s),a(l,Z,s),a(l,Bl,s),y(f,l,s),a(l,gl,s),y(Y,l,s),a(l,Al,s),a(l,E,s),a(l,Wl,s),a(l,v,s),a(l,Gl,s),y(R,l,s),a(l,Zl,s),y($,l,s),a(l,fl,s),y(k,l,s),a(l,Yl,s),y(F,l,s),a(l,El,s),y(S,l,s),a(l,vl,s),y(X,l,s),a(l,Rl,s),a(l,x,s),a(l,$l,s),a(l,V,s),a(l,kl,s),a(l,N,s),a(l,Fl,s),y(Q,l,s),a(l,Sl,s),a(l,z,s),a(l,Xl,s),y(_,l,s),a(l,xl,s),y(q,l,s),a(l,Vl,s),a(l,H,s),a(l,Nl,s),y(L,l,s),a(l,Ql,s),a(l,P,s),a(l,zl,s),y(D,l,s),a(l,_l,s),y(K,l,s),a(l,ql,s),a(l,O,s),a(l,Hl,s),y(ll,l,s),a(l,Ll,s),a(l,sl,s),a(l,Pl,s),y(el,l,s),a(l,Dl,s),y(al,l,s),a(l,Kl,s),a(l,tl,s),a(l,Ol,s),a(l,nl,s),a(l,ls,s),a(l,Ml,s),a(l,ss,s),a(l,ol,s),a(l,es,s),y(pl,l,s),a(l,as,s),a(l,jl,s),ts=!0},p:vs,i(l){ts||(j(d.$$.fragment,l),j(u.$$.fragment,l),j(B.$$.fragment,l),j(W.$$.fragment,l),j(G.$$.fragment,l),j(f.$$.fragment,l),j(Y.$$.fragment,l),j(R.$$.fragment,l),j($.$$.fragment,l),j(k.$$.fragment,l),j(F.$$.fragment,l),j(S.$$.fragment,l),j(X.$$.fragment,l),j(Q.$$.fragment,l),j(_.$$.fragment,l),j(q.$$.fragment,l),j(L.$$.fragment,l),j(D.$$.fragment,l),j(K.$$.fragment,l),j(ll.$$.fragment,l),j(el.$$.fragment,l),j(al.$$.fragment,l),j(pl.$$.fragment,l),ts=!0)},o(l){J(d.$$.fragment,l),J(u.$$.fragment,l),J(B.$$.fragment,l),J(W.$$.fragment,l),J(G.$$.fragment,l),J(f.$$.fragment,l),J(Y.$$.fragment,l),J(R.$$.fragment,l),J($.$$.fragment,l),J(k.$$.fragment,l),J(F.$$.fragment,l),J(S.$$.fragment,l),J(X.$$.fragment,l),J(Q.$$.fragment,l),J(_.$$.fragment,l),J(q.$$.fragment,l),J(L.$$.fragment,l),J(D.$$.fragment,l),J(K.$$.fragment,l),J(ll.$$.fragment,l),J(el.$$.fragment,l),J(al.$$.fragment,l),J(pl.$$.fragment,l),ts=!1},d(l){l&&(e(Jl),e(yl),e(rl),e(Ul),e(cl),e(I),e(ml),e(h),e(wl),e(C),e(Tl),e(b),e(dl),e(ul),e(g),e(Il),e(A),e(hl),e(T),e(Cl),e(bl),e(Z),e(Bl),e(gl),e(Al),e(E),e(Wl),e(v),e(Gl),e(Zl),e(fl),e(Yl),e(El),e(vl),e(Rl),e(x),e($l),e(V),e(kl),e(N),e(Fl),e(Sl),e(z),e(Xl),e(xl),e(Vl),e(H),e(Nl),e(Ql),e(P),e(zl),e(_l),e(ql),e(O),e(Hl),e(Ll),e(sl),e(Pl),e(Dl),e(Kl),e(tl),e(Ol),e(nl),e(ls),e(Ml),e(ss),e(ol),e(es),e(as),e(jl)),e(w),r(d,l),r(u,l),r(B,l),r(W),r(G,l),r(f,l),r(Y,l),r(R,l),r($,l),r(k,l),r(F,l),r(S,l),r(X,l),r(Q,l),r(_,l),r(q,l),r(L,l),r(D,l),r(K,l),r(ll,l),r(el,l),r(al,l),r(pl,l)}}}const Vs='{"title":"Grafo de Análisis de Documentos","local":"grafo-de-análisis-de-documentos","sections":[{"title":"El Flujo de Trabajo del Mayordomo","local":"el-flujo-de-trabajo-del-mayordomo","sections":[],"depth":2},{"title":"Configurando el entorno","local":"configurando-el-entorno","sections":[],"depth":2},{"title":"Definiendo el Estado del Agente","local":"definiendo-el-estado-del-agente","sections":[],"depth":2},{"title":"Preparando Herramientas","local":"preparando-herramientas","sections":[],"depth":2},{"title":"Los nodos","local":"los-nodos","sections":[],"depth":2},{"title":"El Patrón ReAct: Cómo Asisto al Sr. Wayne?","local":"el-patrón-react-cómo-asisto-al-sr-wayne","sections":[],"depth":2},{"title":"El Mayordomo en Acción","local":"el-mayordomo-en-acción","sections":[{"title":"Ejemplo 1: Cálculos Simples","local":"ejemplo-1-cálculos-simples","sections":[],"depth":3},{"title":"Ejemplo 2: Analizando los Documentos de Entrenamiento del Maestro Wayne","local":"ejemplo-2-analizando-los-documentos-de-entrenamiento-del-maestro-wayne","sections":[],"depth":3}],"depth":2},{"title":"Puntos Clave","local":"puntos-clave","sections":[],"depth":2}],"depth":1}';function Ns(ys){return Rs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ps extends $s{constructor(w){super(),ks(this,w,Ns,xs,Es,{})}}export{Ps as component};
