import{s as _l,a as Hl,n as $l,o as ql}from"../chunks/scheduler.505acc25.js";import{S as Ll,i as Kl,e as I,s as U,c as t,h as Pl,a as y,d as l,b as w,f as zl,g as a,j as e,k as Tl,D as JM,l as TM,m as M,n as s,t as n,o as j,p as C}from"../chunks/index.fbb49fb4.js";import{C as lM}from"../chunks/CopyLLMTxtMenu.38c593c4.js";import{C as i}from"../chunks/CodeBlock.2ead06c8.js";import{C as MM}from"../chunks/CourseFloatingBanner.742f9db5.js";import{H as GJ}from"../chunks/Heading.511e0027.js";import{E as UM}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.9ca82795.js";function wM(ll){let o,fJ,xJ,VJ,p,DJ,r,WJ,g,vJ,d,Ml="Los sistemas multi-agente permiten que <strong>agentes especializados colaboren en tareas complejas</strong>, mejorando la modularidad, escalabilidad y robustez. En lugar de depender de un solo agente, las tareas se distribuyen entre agentes con capacidades distintas.",SJ,c,Ul="En <strong>smolagents</strong>, diferentes agentes pueden combinarse para generar código Python, llamar a herramientas externas, realizar búsquedas web y más. Al orquestar estos agentes, podemos crear flujos de trabajo potentes.",NJ,m,wl="Una configuración típica podría incluir:",YJ,u,Il="<li>Un <strong>Agente Gestor</strong> para la delegación de tareas</li> <li>Un <strong>Agente Intérprete de Código</strong> para la ejecución de código</li> <li>Un <strong>Agente de Búsqueda Web</strong> para la recuperación de información</li>",FJ,k,yl="El diagrama a continuación ilustra una arquitectura multi-agente simple donde un <strong>Agente Gestor</strong> coordina una <strong>Herramienta Intérprete de Código</strong> y un <strong>Agente de Búsqueda Web</strong>, que a su vez utiliza herramientas como <code>DuckDuckGoSearchTool</code> y <code>VisitWebpageTool</code> para recopilar información relevante.",XJ,b,el,zJ,h,_J,B,tl="Un sistema multi-agente consiste en múltiples agentes especializados trabajando juntos bajo la coordinación de un <strong>Agente Orquestador</strong>. Este enfoque permite flujos de trabajo complejos distribuyendo tareas entre agentes con roles distintos.",HJ,Q,al="Por ejemplo, un <strong>sistema RAG Multi-Agente</strong> puede integrar:",$J,R,sl="<li>Un <strong>Agente Web</strong> para navegar por internet.</li> <li>Un <strong>Agente Recuperador</strong> para obtener información de bases de conocimiento.</li> <li>Un <strong>Agente de Generación de Imágenes</strong> para producir elementos visuales.</li>",qJ,O,nl="Todos estos agentes operan bajo un orquestador que gestiona la delegación de tareas y la interacción.",LJ,E,KJ,A,jl='<p>Puedes seguir el código en <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/multiagent_notebook.ipynb" target="_blank">este notebook</a> que puedes ejecutar usando Google Colab.</p>',PJ,G,Cl="¡La recepción se acerca! Con tu ayuda, Alfred ya casi ha terminado con los preparativos.",JT,x,il="Pero ahora hay un problema: el Batmóvil ha desaparecido. Alfred necesita encontrar un reemplazo, y encontrarlo rápidamente.",TT,Z,ol="Afortunadamente, se han realizado algunas biografías cinematográficas sobre la vida de Bruce Wayne, así que tal vez Alfred podría conseguir un automóvil abandonado en uno de los sets de filmación y rediseñarlo según los estándares modernos, lo que ciertamente incluiría una opción de conducción autónoma completa.",lT,f,Al="Pero esto podría estar en cualquier lugar de las locaciones de filmación alrededor del mundo, que podrían ser numerosas.",MT,V,pl="Así que Alfred quiere tu ayuda. ¿Podrías construir un agente capaz de resolver esta tarea?",UT,D,rl="<p>👉 Encuentra todas las locaciones de filmación de Batman en el mundo, calcula el tiempo de transferencia en avión de carga hasta allí, y represéntalas en un mapa, con un color que varíe según el tiempo de transferencia en avión. También representa algunas fábricas de superdeportivos con el mismo tiempo de transferencia en avión.</p>",wT,W,gl="¡Vamos a construir esto!",IT,v,dl="Este ejemplo necesita algunos paquetes adicionales, así que vamos a instalarlos primero:",yT,S,eT,N,tT,Y,aT,F,sT,X,cl='Para el proveedor de modelos, usamos Together AI, ¡uno de los nuevos <a href="https://huggingface.co/blog/inference-providers" rel="nofollow">proveedores de inferencia en el Hub</a>!',nT,z,ml='La herramienta GoogleSearchTool usa la <a href="https://serper.dev" rel="nofollow">API de Serper</a> para buscar en la web, por lo que requiere haber configurado la variable de entorno <code>SERPAPI_API_KEY</code> y pasar <code>provider=&quot;serpapi&quot;</code> o tener <code>SERPER_API_KEY</code> y pasar <code>provider=serper</code>.',jT,_,ul="Si no tienes ningún proveedor de Serp API configurado, puedes usar <code>DuckDuckGoSearchTool</code> pero ten en cuenta que tiene un límite de tasa.",CT,H,iT,$,kl="Podemos empezar creando un agente simple como base para darnos un informe simple.",oT,q,AT,L,pT,K,rT,P,gT,JJ,bl="En nuestro caso, genera este output:",dT,TJ,cT,lJ,hl="Podríamos mejorar esto un poco agregando algunos pasos de planificación y más instrucciones.",mT,MJ,Bl="Los pasos de planificación permiten al agente pensar con anticipación y planificar sus próximos pasos, lo que puede ser útil para tareas más complejas.",uT,UJ,kT,wJ,bT,IJ,Ql="En nuestro caso, genera este output:",hT,yJ,BT,eJ,Rl="Gracias a estos cambios rápidos, obtuvimos un informe mucho más conciso proporcionando simplemente una instrucción detallada a nuestro agente y dándole capacidades de planificación.",QT,tJ,Ol="El contexto de la ventana del modelo se está llenando rápidamente. Así que <strong>si le pedimos a nuestro agente que combine los resultados de una búsqueda detallada con otra, será más lento y rápidamente aumentará los tokens y los costos</strong>.",RT,aJ,El="➡️ Necesitamos mejorar la estructura de nuestro sistema.",OT,sJ,ET,nJ,Gl="Las estructuras multi-agente permiten separar memorias entre diferentes sub-tareas, con dos grandes beneficios:",GT,jJ,xl="<li>Cada agente está más enfocado en su tarea principal, por lo que es más performante</li> <li>Separar memorias reduce la cantidad de tokens de entrada en cada paso, reduciendo la latencia y el costo.</li>",xT,CJ,Zl="Vamos a crear un equipo con un agente de búsqueda web dedicado, gestionado por otro agente.",ZT,iJ,fl="El agente gestor debe tener capacidades de trazado para escribir su informe final: así que vamos a darle acceso a importaciones adicionales, incluyendo <code>matplotlib</code>, y <code>geopandas</code> + <code>shapely</code> para trazado espacial.",fT,oJ,VT,AJ,Vl="El agente gestor necesitará hacer algo de trabajo mental pesado.",DT,pJ,Dl='Así que le damos el modelo más fuerte <a href="https://huggingface.co/deepseek-ai/DeepSeek-R1" rel="nofollow">DeepSeek-R1</a>, y agregamos un <code>planning_interval</code> a la mezcla.',WT,rJ,vT,gJ,Wl="Vamos a inspeccionar qué se ve este equipo:",ST,dJ,NT,cJ,vl="Esto generará algo como esto, ayudándonos a entender la estructura y la relación entre agentes y herramientas utilizadas:",YT,mJ,FT,uJ,XT,kJ,Sl="No sé cómo salió en tu ejecución, pero en la mía, el agente gestor dividió hábilmente las tareas dadas al agente web en <code>1. Buscar locaciones de filmación de Batman</code>, luego <code>2. Encontrar fábricas de superdeportivos</code>, antes de agregar las listas y trazar el mapa.",zT,bJ,Nl="Vamos a ver qué se ve el mapa inspeccionándolo directamente desde el estado del agente:",_T,hJ,HT,BJ,Yl="Esto generará el mapa:",$T,QJ,Fl='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/output_map.png" alt="Multiagent system example output map"/>',qT,RJ,LT,OJ,Xl='<li><a href="https://huggingface.co/docs/smolagents/main/en/examples/multiagents" rel="nofollow">Sistemas Multi-Agente</a> – Visión general de los sistemas multi-agente.</li> <li><a href="https://weaviate.io/blog/what-is-agentic-rag" rel="nofollow">¿Qué es Agentic RAG?</a> – Introducción a Agentic RAG.</li> <li><a href="https://huggingface.co/learn/cookbook/multiagent_rag_system" rel="nofollow">Sistema RAG Multi-Agente 🤖🤝🤖 Receta</a> – Guía paso a paso para construir un sistema RAG multi-agente.</li>',KT,EJ,PT,ZJ,Jl;return p=new MM({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/multiagent_notebook.ipynb"}]}}),r=new lM({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),g=new GJ({props:{title:"Sistemas Multi-Agente",local:"sistemas-multi-agente",headingTag:"h1"}}),h=new GJ({props:{title:"Sistemas Multi-Agente en Acción",local:"sistemas-multi-agente-en-acción",headingTag:"h2"}}),E=new GJ({props:{title:"Resolviendo una tarea compleja con una jerarquía multi-agente",local:"resolviendo-una-tarea-compleja-con-una-jerarquía-multi-agente",headingTag:"h2"}}),S=new i({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCbGl0ZWxsbSU1RCclMjBtYXRwbG90bGliJTIwZ2VvcGFuZGFzJTIwc2hhcGVseSUyMGthbGVpZG8lMjAtcQ==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[litellm]&#x27;</span> matplotlib geopandas shapely kaleido -q',wrap:!1}}),N=new GJ({props:{title:"Primero creamos una herramienta para obtener el tiempo de transferencia del avión de carga.",local:"primero-creamos-una-herramienta-para-obtener-el-tiempo-de-transferencia-del-avión-de-carga",headingTag:"h3"}}),Y=new i({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> math
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>, <span class="hljs-type">Tuple</span>

<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculate_cargo_travel_time</span>(<span class="hljs-params">
    origin_coords: <span class="hljs-type">Tuple</span>[<span class="hljs-built_in">float</span>, <span class="hljs-built_in">float</span>],
    destination_coords: <span class="hljs-type">Tuple</span>[<span class="hljs-built_in">float</span>, <span class="hljs-built_in">float</span>],
    cruising_speed_kmh: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">float</span>] = <span class="hljs-number">750.0</span>,  <span class="hljs-comment"># Average speed for cargo planes</span>
</span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Calculate the travel time for a cargo plane between two points on Earth using great-circle distance.

    Args:
        origin_coords: Tuple of (latitude, longitude) for the starting point
        destination_coords: Tuple of (latitude, longitude) for the destination
        cruising_speed_kmh: Optional cruising speed in km/h (defaults to 750 km/h for typical cargo planes)

    Returns:
        float: The estimated travel time in hours

    Example:
        &gt;&gt;&gt; # Chicago (41.8781° N, 87.6298° W) to Sydney (33.8688° S, 151.2093° E)
        &gt;&gt;&gt; result = calculate_cargo_travel_time((41.8781, -87.6298), (-33.8688, 151.2093))
    &quot;&quot;&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">to_radians</span>(<span class="hljs-params">degrees: <span class="hljs-built_in">float</span></span>) -&gt; <span class="hljs-built_in">float</span>:
        <span class="hljs-keyword">return</span> degrees * (math.pi / <span class="hljs-number">180</span>)

    <span class="hljs-comment"># Extract coordinates</span>
    lat1, lon1 = <span class="hljs-built_in">map</span>(to_radians, origin_coords)
    lat2, lon2 = <span class="hljs-built_in">map</span>(to_radians, destination_coords)

    <span class="hljs-comment"># Earth&#x27;s radius in kilometers</span>
    EARTH_RADIUS_KM = <span class="hljs-number">6371.0</span>

    <span class="hljs-comment"># Calculate great-circle distance using the haversine formula</span>
    dlon = lon2 - lon1
    dlat = lat2 - lat1

    a = (
        math.sin(dlat / <span class="hljs-number">2</span>) ** <span class="hljs-number">2</span>
        + math.cos(lat1) * math.cos(lat2) * math.sin(dlon / <span class="hljs-number">2</span>) ** <span class="hljs-number">2</span>
    )
    c = <span class="hljs-number">2</span> * math.asin(math.sqrt(a))
    distance = EARTH_RADIUS_KM * c

    <span class="hljs-comment"># Add 10% to account for non-direct routes and air traffic controls</span>
    actual_distance = distance * <span class="hljs-number">1.1</span>

    <span class="hljs-comment"># Calculate flight time</span>
    <span class="hljs-comment"># Add 1 hour for takeoff and landing procedures</span>
    flight_time = (actual_distance / cruising_speed_kmh) + <span class="hljs-number">1.0</span>

    <span class="hljs-comment"># Format the results</span>
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">round</span>(flight_time, <span class="hljs-number">2</span>)


<span class="hljs-built_in">print</span>(calculate_cargo_travel_time((<span class="hljs-number">41.8781</span>, -<span class="hljs-number">87.6298</span>), (-<span class="hljs-number">33.8688</span>, <span class="hljs-number">151.2093</span>)))`,wrap:!1}}),F=new GJ({props:{title:"Configurando el agente",local:"configurando-el-agente",headingTag:"h3"}}),H=new i({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMENvZGVBZ2VudCUyQyUyMEdvb2dsZVNlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMFZpc2l0V2VicGFnZVRvb2wlMEElMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKG1vZGVsX2lkJTNEJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyJTJDJTIwcHJvdmlkZXIlM0QlMjJ0b2dldGhlciUyMik=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, GoogleSearchTool, InferenceClientModel, VisitWebpageTool

model = InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>, provider=<span class="hljs-string">&quot;together&quot;</span>)`,wrap:!1}}),q=new i({props:{code:"dGFzayUyMCUzRCUyMCUyMiUyMiUyMkVuY3VlbnRyYSUyMHRvZGFzJTIwbGFzJTIwbG9jYWNpb25lcyUyMGRlJTIwZmlsbWFjaSVDMyVCM24lMjBkZSUyMEJhdG1hbiUyMGVuJTIwZWwlMjBtdW5kbyUyQyUyMGNhbGN1bGElMjBlbCUyMHRpZW1wbyUyMGRlJTIwdHJhbnNmZXJlbmNpYSUyMGVuJTIwYXZpJUMzJUIzbiUyMGRlJTIwY2FyZ2ElMjBoYXN0YSUyMGFxdSVDMyVBRCUyMChlc3RhbW9zJTIwZW4lMjBHb3RoYW0lMkMlMjA0MC43MTI4JUMyJUIwJTIwTiUyQyUyMDc0LjAwNjAlQzIlQjAlMjBXKSUyQyUyMHklMjBkZXZ1JUMzJUE5bHZlbGFzJTIwYSUyMG0lQzMlQUQlMjBjb21vJTIwdW4lMjBkYXRhZnJhbWUlMjBkZSUyMHBhbmRhcy4lMEFUYW1iaSVDMyVBOW4lMjBkYW1lJTIwYWxndW5hcyUyMGYlQzMlQTFicmljYXMlMjBkZSUyMHN1cGVyZGVwb3J0aXZvcyUyMGNvbiUyMGVsJTIwbWlzbW8lMjB0aWVtcG8lMjBkZSUyMHRyYW5zZmVyZW5jaWElMjBlbiUyMGF2aSVDMyVCM24uJTIyJTIyJTIy",highlighted:`task = <span class="hljs-string">&quot;&quot;&quot;Encuentra todas las locaciones de filmación de Batman en el mundo, calcula el tiempo de transferencia en avión de carga hasta aquí (estamos en Gotham, 40.7128° N, 74.0060° W), y devuélvelas a mí como un dataframe de pandas.
También dame algunas fábricas de superdeportivos con el mismo tiempo de transferencia en avión.&quot;&quot;&quot;</span>`,wrap:!1}}),L=new i({props:{code:"YWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCR29vZ2xlU2VhcmNoVG9vbCglMjJzZXJwZXIlMjIpJTJDJTIwVmlzaXRXZWJwYWdlVG9vbCgpJTJDJTIwY2FsY3VsYXRlX2NhcmdvX3RyYXZlbF90aW1lJTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRkaXRpb25hbF9hdXRob3JpemVkX2ltcG9ydHMlM0QlNUIlMjJwYW5kYXMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0QyMCUyQyUwQSk=",highlighted:`agent = CodeAgent(
    model=model,
    tools=[GoogleSearchTool(<span class="hljs-string">&quot;serper&quot;</span>), VisitWebpageTool(), calculate_cargo_travel_time],
    additional_authorized_imports=[<span class="hljs-string">&quot;pandas&quot;</span>],
    max_steps=<span class="hljs-number">20</span>,
)`,wrap:!1}}),K=new i({props:{code:"cmVzdWx0JTIwJTNEJTIwYWdlbnQucnVuKHRhc2sp",highlighted:"result = agent.run(task)",wrap:!1}}),P=new i({props:{code:"cmVzdWx0",highlighted:"result",wrap:!1}}),TJ=new i({props:{code:"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",highlighted:`|  | Location                                             | Travel Time to Gotham (hours) |
|--|------------------------------------------------------|------------------------------|
| <span class="hljs-number">0</span>  | Necropolis Cemetery, Glasgow, Scotland, UK         | <span class="hljs-number">8.60</span>                         |
| <span class="hljs-number">1</span>  | St. George<span class="hljs-string">&#x27;s Hall, Liverpool, England, UK         | 8.81                         |
| 2  | Two Temple Place, London, England, UK             | 9.17                         |
| 3  | Wollaton Hall, Nottingham, England, UK           | 9.00                         |
| 4  | Knebworth House, Knebworth, Hertfordshire, UK    | 9.15                         |
| 5  | Acton Lane Power Station, Acton Lane, Acton, UK  | 9.16                         |
| 6  | Queensboro Bridge, New York City, USA            | 1.01                         |
| 7  | Wall Street, New York City, USA                  | 1.00                         |
| 8  | Mehrangarh Fort, Jodhpur, Rajasthan, India       | 18.34                        |
| 9  | Turda Gorge, Turda, Romania                      | 11.89                        |
| 10 | Chicago, USA                                     | 2.68                         |
| 11 | Hong Kong, China                                 | 19.99                        |
| 12 | Cardington Studios, Northamptonshire, UK        | 9.10                         |
| 13 | Warner Bros. Leavesden Studios, Hertfordshire, UK | 9.13                         |
| 14 | Westwood, Los Angeles, CA, USA                  | 6.79                         |
| 15 | Woking, UK (McLaren)                             | 9.13                         |</span>`,wrap:!1}}),UJ=new i({props:{code:"YWdlbnQucGxhbm5pbmdfaW50ZXJ2YWwlMjAlM0QlMjA0JTBBJTBBZGV0YWlsZWRfcmVwb3J0JTIwJTNEJTIwYWdlbnQucnVuKGYlMjIlMjIlMjIlMEFFcmVzJTIwdW4lMjBhbmFsaXN0YSUyMGV4cGVydG8uJTIwQ3JlYXMlMjBpbmZvcm1lcyUyMGV4aGF1c3Rpdm9zJTIwZGVzcHUlQzMlQTlzJTIwZGUlMjB2aXNpdGFyJTIwbXVjaG9zJTIwc2l0aW9zJTIwd2ViLiUwQU5vJTIwZHVkZXMlMjBlbiUyMGJ1c2NhciUyMG11Y2hhcyUyMGNvbnN1bHRhcyUyMGElMjBsYSUyMHZleiUyMGVuJTIwdW4lMjBidWNsZSUyMGZvci4lMEFQYXJhJTIwY2FkYSUyMGRhdG8lMjBxdWUlMjBlbmN1ZW50cmVzJTJDJTIwdmlzaXRhJTIwbGElMjBVUkwlMjBkZSUyMG9yaWdlbiUyMHBhcmElMjBjb25maXJtYXIlMjBsb3MlMjBuJUMzJUJBbWVyb3MuJTBBJTBBJTdCdGFzayU3RCUwQSUyMiUyMiUyMiklMEElMEFwcmludChkZXRhaWxlZF9yZXBvcnQp",highlighted:`agent.planning_interval = <span class="hljs-number">4</span>

detailed_report = agent.run(<span class="hljs-string">f&quot;&quot;&quot;
Eres un analista experto. Creas informes exhaustivos después de visitar muchos sitios web.
No dudes en buscar muchas consultas a la vez en un bucle for.
Para cada dato que encuentres, visita la URL de origen para confirmar los números.

<span class="hljs-subst">{task}</span>
&quot;&quot;&quot;</span>)

<span class="hljs-built_in">print</span>(detailed_report)`,wrap:!1}}),wJ=new i({props:{code:"ZGV0YWlsZWRfcmVwb3J0",highlighted:"detailed_report",wrap:!1}}),yJ=new i({props:{code:"JTdDJTIwJTIwJTdDJTIwTG9jYXRpb24lMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjBUcmF2ZWwlMjBUaW1lJTIwKGhvdXJzKSUyMCU3QyUwQSU3Qy0tJTdDLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0lN0MtLS0tLS0tLS0tLS0tLS0tLS0tLS0lN0MlMEElN0MlMjAwJTIwJTIwJTdDJTIwQnJpZGdlJTIwb2YlMjBTaWdocyUyQyUyMEdsYXNnb3clMjBOZWNyb3BvbGlzJTJDJTIwR2xhc2dvdyUyQyUyMFVLJTIwJTdDJTIwOC42JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTBBJTdDJTIwMSUyMCUyMCU3QyUyMFdpc2hhcnQlMjBTdHJlZXQlMkMlMjBHbGFzZ293JTJDJTIwU2NvdGxhbmQlMkMlMjBVSyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMDguNiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3Qw==",highlighted:`|  | Location                                         | Travel Time (hours) |
|--|--------------------------------------------------|---------------------|
| <span class="hljs-number">0</span>  | Bridge of Sighs, Glasgow Necropolis, Glasgow, UK | <span class="hljs-number">8.6</span>                 |
| <span class="hljs-number">1</span>  | Wishart Street, Glasgow, Scotland, UK         | <span class="hljs-number">8.6</span>                 |`,wrap:!1}}),sJ=new GJ({props:{title:"✌️ Dividiendo la tarea entre dos agentes",local:"-dividiendo-la-tarea-entre-dos-agentes",headingTag:"h3"}}),oJ=new i({props:{code:"bW9kZWwlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCglMEElMjAlMjAlMjAlMjAlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIlMkMlMjBwcm92aWRlciUzRCUyMnRvZ2V0aGVyJTIyJTJDJTIwbWF4X3Rva2VucyUzRDgwOTYlMEEpJTBBJTBBd2ViX2FnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEdvb2dsZVNlYXJjaFRvb2wocHJvdmlkZXIlM0QlMjJzZXJwZXIlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVmlzaXRXZWJwYWdlVG9vbCgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FsY3VsYXRlX2NhcmdvX3RyYXZlbF90aW1lJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwbmFtZSUzRCUyMndlYl9hZ2VudCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIyTmF2ZWdhJTIwcG9yJTIwbGElMjB3ZWIlMjBwYXJhJTIwZW5jb250cmFyJTIwaW5mb3JtYWNpJUMzJUIzbiUyMiUyQyUwQSUyMCUyMCUyMCUyMHZlcmJvc2l0eV9sZXZlbCUzRDAlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0QxMCUyQyUwQSk=",highlighted:`model = InferenceClientModel(
    <span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>, provider=<span class="hljs-string">&quot;together&quot;</span>, max_tokens=<span class="hljs-number">8096</span>
)

web_agent = CodeAgent(
    model=model,
    tools=[
        GoogleSearchTool(provider=<span class="hljs-string">&quot;serper&quot;</span>),
        VisitWebpageTool(),
        calculate_cargo_travel_time,
    ],
    name=<span class="hljs-string">&quot;web_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Navega por la web para encontrar información&quot;</span>,
    verbosity_level=<span class="hljs-number">0</span>,
    max_steps=<span class="hljs-number">10</span>,
)`,wrap:!1}}),rJ=new i({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents.utils <span class="hljs-keyword">import</span> encode_image_base64, make_image_url
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> OpenAIServerModel


<span class="hljs-keyword">def</span> <span class="hljs-title function_">check_reasoning_and_plot</span>(<span class="hljs-params">final_answer, agent_memory</span>):
    final_answer
    multimodal_model = OpenAIServerModel(<span class="hljs-string">&quot;gpt-4o&quot;</span>, max_tokens=<span class="hljs-number">8096</span>)
    filepath = <span class="hljs-string">&quot;saved_map.png&quot;</span>
    <span class="hljs-keyword">assert</span> os.path.exists(filepath), <span class="hljs-string">&quot;Asegúrate de guardar el trazado bajo saved_map.png!&quot;</span>
    image = Image.<span class="hljs-built_in">open</span>(filepath)
    prompt = (
        <span class="hljs-string">f&quot;Aquí está una tarea dada por el usuario y los pasos del agente: <span class="hljs-subst">{agent_memory.get_succinct_steps()}</span>. Ahora aquí está el trazado que se hizo.&quot;</span>
        <span class="hljs-string">&quot;Por favor, verifica que el proceso de razonamiento y el trazado sean correctos: ¿responden correctamente a la tarea dada?&quot;</span>
        <span class="hljs-string">&quot;Primero enumera razones por las que sí/no, luego escribe tu decisión final: PASS en mayúsculas si es satisfactorio, FAIL si no lo es.&quot;</span>
        <span class="hljs-string">&quot;No seas duro: si el trazado resuelve en gran medida la tarea, debe pasar.&quot;</span>
        <span class="hljs-string">&quot;Para pasar, un trazado debe hacerse usando px.scatter_map y no cualquier otro método (scatter_map se ve mejor).&quot;</span>
    )
    messages = [
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: [
                {
                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
                    <span class="hljs-string">&quot;text&quot;</span>: prompt,
                },
                {
                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
                    <span class="hljs-string">&quot;image_url&quot;</span>: {<span class="hljs-string">&quot;url&quot;</span>: make_image_url(encode_image_base64(image))},
                },
            ],
        }
    ]
    output = multimodal_model(messages).content
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Retroalimentación: &quot;</span>, output)
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;FAIL&quot;</span> <span class="hljs-keyword">in</span> output:
        <span class="hljs-keyword">raise</span> Exception(output)
    <span class="hljs-keyword">return</span> <span class="hljs-literal">True</span>


manager_agent = CodeAgent(
    model=InferenceClientModel(<span class="hljs-string">&quot;deepseek-ai/DeepSeek-R1&quot;</span>, provider=<span class="hljs-string">&quot;together&quot;</span>, max_tokens=<span class="hljs-number">8096</span>),
    tools=[calculate_cargo_travel_time],
    managed_agents=[web_agent],
    additional_authorized_imports=[
        <span class="hljs-string">&quot;geopandas&quot;</span>,
        <span class="hljs-string">&quot;plotly&quot;</span>,
        <span class="hljs-string">&quot;shapely&quot;</span>,
        <span class="hljs-string">&quot;json&quot;</span>,
        <span class="hljs-string">&quot;pandas&quot;</span>,
        <span class="hljs-string">&quot;numpy&quot;</span>,
    ],
    planning_interval=<span class="hljs-number">5</span>,
    verbosity_level=<span class="hljs-number">2</span>,
    final_answer_checks=[check_reasoning_and_plot],
    max_steps=<span class="hljs-number">15</span>,
)`,wrap:!1}}),dJ=new i({props:{code:"bWFuYWdlcl9hZ2VudC52aXN1YWxpemUoKQ==",highlighted:"manager_agent.visualize()",wrap:!1}}),mJ=new i({props:{code:"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",highlighted:`CodeAgent | deepseek-ai/DeepSeek-R1
├── ✅ Authorized imports: [<span class="hljs-string">&#x27;geopandas&#x27;</span>, <span class="hljs-string">&#x27;plotly&#x27;</span>, <span class="hljs-string">&#x27;shapely&#x27;</span>, <span class="hljs-string">&#x27;json&#x27;</span>, <span class="hljs-string">&#x27;pandas&#x27;</span>, <span class="hljs-string">&#x27;numpy&#x27;</span>]
├── 🛠️ Tools:
│   ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
│   ┃ Name                        ┃ Description                           ┃ Arguments                             ┃
│   ┡━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┩
│   │ calculate_cargo_travel_time │ Calculate the travel time <span class="hljs-keyword">for</span> a cargo │ origin_coords (\`array\`): <span class="hljs-type">Tuple</span> of     │
│   │                             │ plane between two points on Earth     │ (latitude, longitude) <span class="hljs-keyword">for</span> the         │
│   │                             │ using great-circle distance.          │ starting point                        │
│   │                             │                                       │ destination_coords (\`array\`): <span class="hljs-type">Tuple</span>   │
│   │                             │                                       │ of (latitude, longitude) <span class="hljs-keyword">for</span> the      │
│   │                             │                                       │ destination                           │
│   │                             │                                       │ cruising_speed_kmh (\`number\`):        │
│   │                             │                                       │ <span class="hljs-type">Optional</span> cruising speed <span class="hljs-keyword">in</span> km/h       │
│   │                             │                                       │ (defaults to <span class="hljs-number">750</span> km/h <span class="hljs-keyword">for</span> typical     │
│   │                             │                                       │ cargo planes)                         │
│   │ final_answer                │ Provides a final answer to the given  │ answer (\`<span class="hljs-built_in">any</span>\`): The final answer to   │
│   │                             │ problem.                              │ the problem                           │
│   └─────────────────────────────┴───────────────────────────────────────┴───────────────────────────────────────┘
└── 🤖 Managed agents:
    └── web_agent | CodeAgent | Qwen/Qwen2<span class="hljs-number">.5</span>-Coder-32B-Instruct
        ├── ✅ Authorizar imports: []
        ├── 📝 Description: Navega por la web para encontrar información
        └── 🛠️ Tools:
            ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
            ┃ Name                        ┃ Description                       ┃ Arguments                         ┃
            ┡━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┩
            │ web_search                  │ Performs a google web search <span class="hljs-keyword">for</span>  │ query (\`string\`): The search      │
            │                             │ your query then returns a string  │ query to perform.                 │
            │                             │ of the top search results.        │ filter_year (\`integer\`):          │
            │                             │                                   │ Optionally restrict results to a  │
            │                             │                                   │ certain year                      │
            │ visit_webpage               │ Visits a webpage at the given url │ url (\`string\`): The url of the    │
            │                             │ <span class="hljs-keyword">and</span> reads its content <span class="hljs-keyword">as</span> a        │ webpage to visit.                 │
            │                             │ markdown string. Use this to      │                                   │
            │                             │ browse webpages.                  │                                   │
            │ calculate_cargo_travel_time │ Calculate the travel time <span class="hljs-keyword">for</span> a   │ origin_coords (\`array\`): <span class="hljs-type">Tuple</span> of │
            │                             │ cargo plane between two points on │ (latitude, longitude) <span class="hljs-keyword">for</span> the     │
            │                             │ Earth using great-circle          │ starting point                    │
            │                             │ distance.                         │ destination_coords (\`array\`):     │
            │                             │                                   │ <span class="hljs-type">Tuple</span> of (latitude, longitude)    │
            │                             │                                   │ <span class="hljs-keyword">for</span> the destination               │
            │                             │                                   │ cruising_speed_kmh (\`number\`):    │
            │                             │                                   │ <span class="hljs-type">Optional</span> cruising speed <span class="hljs-keyword">in</span> km/h   │
            │                             │                                   │ (defaults to <span class="hljs-number">750</span> km/h <span class="hljs-keyword">for</span> typical │
            │                             │                                   │ cargo planes)                     │
            │ final_answer                │ Provides a final answer to the    │ answer (\`<span class="hljs-built_in">any</span>\`): The final answer  │
            │                             │ given problem.                    │ to the problem                    │
            └─────────────────────────────┴───────────────────────────────────┴───────────────────────────────────┘`,wrap:!1}}),uJ=new i({props:{code:"bWFuYWdlcl9hZ2VudC5ydW4oJTIyJTIyJTIyJTBBRW5jdWVudHJhJTIwdG9kYXMlMjBsYXMlMjBsb2NhY2lvbmVzJTIwZGUlMjBmaWxtYWNpJUMzJUIzbiUyMGRlJTIwQmF0bWFuJTIwZW4lMjBlbCUyMG11bmRvJTJDJTIwY2FsY3VsYSUyMGVsJTIwdGllbXBvJTIwZGUlMjB0cmFuc2ZlcmVuY2lhJTIwZW4lMjBhdmklQzMlQjNuJTIwZGUlMjBjYXJnYSUyMGhhc3RhJTIwYXF1JUMzJUFEJTIwKGVzdGFtb3MlMjBlbiUyMEdvdGhhbSUyQyUyMDQwLjcxMjglQzIlQjAlMjBOJTJDJTIwNzQuMDA2MCVDMiVCMCUyMFcpLiUwQVRhbWJpJUMzJUE5biUyMGRhbWUlMjBhbGd1bmFzJTIwZiVDMyVBMWJyaWNhcyUyMGRlJTIwc3VwZXJkZXBvcnRpdm9zJTIwY29uJTIwZWwlMjBtaXNtbyUyMHRpZW1wbyUyMGRlJTIwdHJhbnNmZXJlbmNpYSUyMGVuJTIwYXZpJUMzJUIzbi4lMEFOZWNlc2l0byUyMGFsJTIwbWVub3MlMjA2JTIwcHVudG9zJTIwZW4lMjB0b3RhbC4lMEFSZXByZXNlbnRhJTIwZXN0byUyMGNvbW8lMjB1biUyMG1hcGElMjBlc3BhY2lhbCUyMGRlbCUyMG11bmRvJTJDJTIwY29uJTIwbGFzJTIwbG9jYWNpb25lcyUyMHJlcHJlc2VudGFkYXMlMjBjb21vJTIwcHVudG9zJTIwZGUlMjBkaXNwZXJzaSVDMyVCM24lMjBjb24lMjB1biUyMGNvbG9yJTIwcXVlJTIwZGVwZW5kZSUyMGRlbCUyMHRpZW1wbyUyMGRlJTIwdHJhbnNmZXJlbmNpYSUyQyUyMHklMjBndSVDMyVBMXJkYWxvJTIwZW4lMjBzYXZlZF9tYXAucG5nISUwQSUwQUFxdSVDMyVBRCUyMGhheSUyMHVuJTIwZWplbXBsbyUyMGRlJTIwYyVDMyVCM21vJTIwdHJhemFyJTIweSUyMGRldm9sdmVyJTIwdW4lMjBtYXBhJTNBJTBBaW1wb3J0JTIwcGxvdGx5LmV4cHJlc3MlMjBhcyUyMHB4JTBBZGYlMjAlM0QlMjBweC5kYXRhLmNhcnNoYXJlKCklMEFmaWclMjAlM0QlMjBweC5zY2F0dGVyX21hcChkZiUyQyUyMGxhdCUzRCUyMmNlbnRyb2lkX2xhdCUyMiUyQyUyMGxvbiUzRCUyMmNlbnRyb2lkX2xvbiUyMiUyQyUyMHRleHQlM0QlMjJuYW1lJTIyJTJDJTIwY29sb3IlM0QlMjJwZWFrX2hvdXIlMjIlMkMlMjBzaXplJTNEMTAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwY29sb3JfY29udGludW91c19zY2FsZSUzRHB4LmNvbG9ycy5zZXF1ZW50aWFsLk1hZ21hJTJDJTIwc2l6ZV9tYXglM0QxNSUyQyUyMHpvb20lM0QxKSUwQWZpZy5zaG93KCklMEFmaWcud3JpdGVfaW1hZ2UoJTIyc2F2ZWRfaW1hZ2UucG5nJTIyKSUwQWZpbmFsX2Fuc3dlcihmaWcpJTBBJTBBTnVuY2ElMjBpbnRlbnRlcyUyMHByb2Nlc2FyJTIwY2FkZW5hcyUyMHVzYW5kbyUyMGMlQzMlQjNkaWdvJTNBJTIwY3VhbmRvJTIwdGVuZ2FzJTIwdW5hJTIwY2FkZW5hJTIwcGFyYSUyMGxlZXIlMkMlMjBzaW1wbGVtZW50ZSUyMGltcHIlQzMlQURtZWxhJTIweSUyMGxhJTIwdmVyJUMzJUExcy4lMEElMjIlMjIlMjIp",highlighted:`manager_agent.run(<span class="hljs-string">&quot;&quot;&quot;
Encuentra todas las locaciones de filmación de Batman en el mundo, calcula el tiempo de transferencia en avión de carga hasta aquí (estamos en Gotham, 40.7128° N, 74.0060° W).
También dame algunas fábricas de superdeportivos con el mismo tiempo de transferencia en avión.
Necesito al menos 6 puntos en total.
Representa esto como un mapa espacial del mundo, con las locaciones representadas como puntos de dispersión con un color que depende del tiempo de transferencia, y guárdalo en saved_map.png!

Aquí hay un ejemplo de cómo trazar y devolver un mapa:
import plotly.express as px
df = px.data.carshare()
fig = px.scatter_map(df, lat=&quot;centroid_lat&quot;, lon=&quot;centroid_lon&quot;, text=&quot;name&quot;, color=&quot;peak_hour&quot;, size=100,
     color_continuous_scale=px.colors.sequential.Magma, size_max=15, zoom=1)
fig.show()
fig.write_image(&quot;saved_image.png&quot;)
final_answer(fig)

Nunca intentes procesar cadenas usando código: cuando tengas una cadena para leer, simplemente imprímela y la verás.
&quot;&quot;&quot;</span>)`,wrap:!1}}),hJ=new i({props:{code:"bWFuYWdlcl9hZ2VudC5weXRob25fZXhlY3V0b3Iuc3RhdGUlNUIlMjJmaWclMjIlNUQ=",highlighted:'manager_agent.python_executor.state[<span class="hljs-string">&quot;fig&quot;</span>]',wrap:!1}}),RJ=new GJ({props:{title:"Recursos",local:"recursos",headingTag:"h2"}}),EJ=new UM({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/es/unit2/smolagents/multi_agent_systems.mdx"}}),{c(){o=I("meta"),fJ=U(),xJ=I("p"),VJ=U(),t(p.$$.fragment),DJ=U(),t(r.$$.fragment),WJ=U(),t(g.$$.fragment),vJ=U(),d=I("p"),d.innerHTML=Ml,SJ=U(),c=I("p"),c.innerHTML=Ul,NJ=U(),m=I("p"),m.textContent=wl,YJ=U(),u=I("ul"),u.innerHTML=Il,FJ=U(),k=I("p"),k.innerHTML=yl,XJ=U(),b=I("img"),zJ=U(),t(h.$$.fragment),_J=U(),B=I("p"),B.innerHTML=tl,HJ=U(),Q=I("p"),Q.innerHTML=al,$J=U(),R=I("ul"),R.innerHTML=sl,qJ=U(),O=I("p"),O.textContent=nl,LJ=U(),t(E.$$.fragment),KJ=U(),A=I("blockquote"),A.innerHTML=jl,PJ=U(),G=I("p"),G.textContent=Cl,JT=U(),x=I("p"),x.textContent=il,TT=U(),Z=I("p"),Z.textContent=ol,lT=U(),f=I("p"),f.textContent=Al,MT=U(),V=I("p"),V.textContent=pl,UT=U(),D=I("blockquote"),D.innerHTML=rl,wT=U(),W=I("p"),W.textContent=gl,IT=U(),v=I("p"),v.textContent=dl,yT=U(),t(S.$$.fragment),eT=U(),t(N.$$.fragment),tT=U(),t(Y.$$.fragment),aT=U(),t(F.$$.fragment),sT=U(),X=I("p"),X.innerHTML=cl,nT=U(),z=I("p"),z.innerHTML=ml,jT=U(),_=I("p"),_.innerHTML=ul,CT=U(),t(H.$$.fragment),iT=U(),$=I("p"),$.textContent=kl,oT=U(),t(q.$$.fragment),AT=U(),t(L.$$.fragment),pT=U(),t(K.$$.fragment),rT=U(),t(P.$$.fragment),gT=U(),JJ=I("p"),JJ.textContent=bl,dT=U(),t(TJ.$$.fragment),cT=U(),lJ=I("p"),lJ.textContent=hl,mT=U(),MJ=I("p"),MJ.textContent=Bl,uT=U(),t(UJ.$$.fragment),kT=U(),t(wJ.$$.fragment),bT=U(),IJ=I("p"),IJ.textContent=Ql,hT=U(),t(yJ.$$.fragment),BT=U(),eJ=I("p"),eJ.textContent=Rl,QT=U(),tJ=I("p"),tJ.innerHTML=Ol,RT=U(),aJ=I("p"),aJ.textContent=El,OT=U(),t(sJ.$$.fragment),ET=U(),nJ=I("p"),nJ.textContent=Gl,GT=U(),jJ=I("ul"),jJ.innerHTML=xl,xT=U(),CJ=I("p"),CJ.textContent=Zl,ZT=U(),iJ=I("p"),iJ.innerHTML=fl,fT=U(),t(oJ.$$.fragment),VT=U(),AJ=I("p"),AJ.textContent=Vl,DT=U(),pJ=I("p"),pJ.innerHTML=Dl,WT=U(),t(rJ.$$.fragment),vT=U(),gJ=I("p"),gJ.textContent=Wl,ST=U(),t(dJ.$$.fragment),NT=U(),cJ=I("p"),cJ.textContent=vl,YT=U(),t(mJ.$$.fragment),FT=U(),t(uJ.$$.fragment),XT=U(),kJ=I("p"),kJ.innerHTML=Sl,zT=U(),bJ=I("p"),bJ.textContent=Nl,_T=U(),t(hJ.$$.fragment),HT=U(),BJ=I("p"),BJ.textContent=Yl,$T=U(),QJ=I("p"),QJ.innerHTML=Fl,qT=U(),t(RJ.$$.fragment),LT=U(),OJ=I("ul"),OJ.innerHTML=Xl,KT=U(),t(EJ.$$.fragment),PT=U(),ZJ=I("p"),this.h()},l(J){const T=Pl("svelte-u9bgzb",document.head);o=y(T,"META",{name:!0,content:!0}),T.forEach(l),fJ=w(J),xJ=y(J,"P",{}),zl(xJ).forEach(l),VJ=w(J),a(p.$$.fragment,J),DJ=w(J),a(r.$$.fragment,J),WJ=w(J),a(g.$$.fragment,J),vJ=w(J),d=y(J,"P",{"data-svelte-h":!0}),e(d)!=="svelte-fmwqrq"&&(d.innerHTML=Ml),SJ=w(J),c=y(J,"P",{"data-svelte-h":!0}),e(c)!=="svelte-rtqme"&&(c.innerHTML=Ul),NJ=w(J),m=y(J,"P",{"data-svelte-h":!0}),e(m)!=="svelte-1aikdpk"&&(m.textContent=wl),YJ=w(J),u=y(J,"UL",{"data-svelte-h":!0}),e(u)!=="svelte-q90avd"&&(u.innerHTML=Il),FJ=w(J),k=y(J,"P",{"data-svelte-h":!0}),e(k)!=="svelte-rilfzs"&&(k.innerHTML=yl),XJ=w(J),b=y(J,"IMG",{src:!0,style:!0}),zJ=w(J),a(h.$$.fragment,J),_J=w(J),B=y(J,"P",{"data-svelte-h":!0}),e(B)!=="svelte-gazwo6"&&(B.innerHTML=tl),HJ=w(J),Q=y(J,"P",{"data-svelte-h":!0}),e(Q)!=="svelte-6zterm"&&(Q.innerHTML=al),$J=w(J),R=y(J,"UL",{"data-svelte-h":!0}),e(R)!=="svelte-6a1kbm"&&(R.innerHTML=sl),qJ=w(J),O=y(J,"P",{"data-svelte-h":!0}),e(O)!=="svelte-1jeelbo"&&(O.textContent=nl),LJ=w(J),a(E.$$.fragment,J),KJ=w(J),A=y(J,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),e(A)!=="svelte-1blqlkc"&&(A.innerHTML=jl),PJ=w(J),G=y(J,"P",{"data-svelte-h":!0}),e(G)!=="svelte-1pghdy9"&&(G.textContent=Cl),JT=w(J),x=y(J,"P",{"data-svelte-h":!0}),e(x)!=="svelte-ebg2aq"&&(x.textContent=il),TT=w(J),Z=y(J,"P",{"data-svelte-h":!0}),e(Z)!=="svelte-1o2ah4c"&&(Z.textContent=ol),lT=w(J),f=y(J,"P",{"data-svelte-h":!0}),e(f)!=="svelte-dyejq3"&&(f.textContent=Al),MT=w(J),V=y(J,"P",{"data-svelte-h":!0}),e(V)!=="svelte-1nsx5n0"&&(V.textContent=pl),UT=w(J),D=y(J,"BLOCKQUOTE",{"data-svelte-h":!0}),e(D)!=="svelte-1yhfnkw"&&(D.innerHTML=rl),wT=w(J),W=y(J,"P",{"data-svelte-h":!0}),e(W)!=="svelte-hh44nj"&&(W.textContent=gl),IT=w(J),v=y(J,"P",{"data-svelte-h":!0}),e(v)!=="svelte-1aru903"&&(v.textContent=dl),yT=w(J),a(S.$$.fragment,J),eT=w(J),a(N.$$.fragment,J),tT=w(J),a(Y.$$.fragment,J),aT=w(J),a(F.$$.fragment,J),sT=w(J),X=y(J,"P",{"data-svelte-h":!0}),e(X)!=="svelte-12t06ua"&&(X.innerHTML=cl),nT=w(J),z=y(J,"P",{"data-svelte-h":!0}),e(z)!=="svelte-f3ikqm"&&(z.innerHTML=ml),jT=w(J),_=y(J,"P",{"data-svelte-h":!0}),e(_)!=="svelte-1ly8acu"&&(_.innerHTML=ul),CT=w(J),a(H.$$.fragment,J),iT=w(J),$=y(J,"P",{"data-svelte-h":!0}),e($)!=="svelte-1jq1h6r"&&($.textContent=kl),oT=w(J),a(q.$$.fragment,J),AT=w(J),a(L.$$.fragment,J),pT=w(J),a(K.$$.fragment,J),rT=w(J),a(P.$$.fragment,J),gT=w(J),JJ=y(J,"P",{"data-svelte-h":!0}),e(JJ)!=="svelte-132b781"&&(JJ.textContent=bl),dT=w(J),a(TJ.$$.fragment,J),cT=w(J),lJ=y(J,"P",{"data-svelte-h":!0}),e(lJ)!=="svelte-18u1xwq"&&(lJ.textContent=hl),mT=w(J),MJ=y(J,"P",{"data-svelte-h":!0}),e(MJ)!=="svelte-1iwmhbi"&&(MJ.textContent=Bl),uT=w(J),a(UJ.$$.fragment,J),kT=w(J),a(wJ.$$.fragment,J),bT=w(J),IJ=y(J,"P",{"data-svelte-h":!0}),e(IJ)!=="svelte-132b781"&&(IJ.textContent=Ql),hT=w(J),a(yJ.$$.fragment,J),BT=w(J),eJ=y(J,"P",{"data-svelte-h":!0}),e(eJ)!=="svelte-30ratm"&&(eJ.textContent=Rl),QT=w(J),tJ=y(J,"P",{"data-svelte-h":!0}),e(tJ)!=="svelte-13r8n48"&&(tJ.innerHTML=Ol),RT=w(J),aJ=y(J,"P",{"data-svelte-h":!0}),e(aJ)!=="svelte-1q1e765"&&(aJ.textContent=El),OT=w(J),a(sJ.$$.fragment,J),ET=w(J),nJ=y(J,"P",{"data-svelte-h":!0}),e(nJ)!=="svelte-km5dzv"&&(nJ.textContent=Gl),GT=w(J),jJ=y(J,"UL",{"data-svelte-h":!0}),e(jJ)!=="svelte-1ps36yh"&&(jJ.innerHTML=xl),xT=w(J),CJ=y(J,"P",{"data-svelte-h":!0}),e(CJ)!=="svelte-1iroo8u"&&(CJ.textContent=Zl),ZT=w(J),iJ=y(J,"P",{"data-svelte-h":!0}),e(iJ)!=="svelte-ujf8rp"&&(iJ.innerHTML=fl),fT=w(J),a(oJ.$$.fragment,J),VT=w(J),AJ=y(J,"P",{"data-svelte-h":!0}),e(AJ)!=="svelte-1ua8v3b"&&(AJ.textContent=Vl),DT=w(J),pJ=y(J,"P",{"data-svelte-h":!0}),e(pJ)!=="svelte-1uf8d85"&&(pJ.innerHTML=Dl),WT=w(J),a(rJ.$$.fragment,J),vT=w(J),gJ=y(J,"P",{"data-svelte-h":!0}),e(gJ)!=="svelte-32twah"&&(gJ.textContent=Wl),ST=w(J),a(dJ.$$.fragment,J),NT=w(J),cJ=y(J,"P",{"data-svelte-h":!0}),e(cJ)!=="svelte-kgu306"&&(cJ.textContent=vl),YT=w(J),a(mJ.$$.fragment,J),FT=w(J),a(uJ.$$.fragment,J),XT=w(J),kJ=y(J,"P",{"data-svelte-h":!0}),e(kJ)!=="svelte-18623z8"&&(kJ.innerHTML=Sl),zT=w(J),bJ=y(J,"P",{"data-svelte-h":!0}),e(bJ)!=="svelte-yx3hha"&&(bJ.textContent=Nl),_T=w(J),a(hJ.$$.fragment,J),HT=w(J),BJ=y(J,"P",{"data-svelte-h":!0}),e(BJ)!=="svelte-1ret7u2"&&(BJ.textContent=Yl),$T=w(J),QJ=y(J,"P",{"data-svelte-h":!0}),e(QJ)!=="svelte-z627a9"&&(QJ.innerHTML=Fl),qT=w(J),a(RJ.$$.fragment,J),LT=w(J),OJ=y(J,"UL",{"data-svelte-h":!0}),e(OJ)!=="svelte-xersmj"&&(OJ.innerHTML=Xl),KT=w(J),a(EJ.$$.fragment,J),PT=w(J),ZJ=y(J,"P",{}),zl(ZJ).forEach(l),this.h()},h(){Tl(o,"name","hf:doc:metadata"),Tl(o,"content",IM),Hl(b.src,el="https://mermaid.ink/img/pako:eNp1kc1qhTAQRl9FUiQb8wIpdNO76eKubrmFks1oRg3VSYgjpYjv3lFL_2hnMWQOJwn5sqgmelRWleUSKLAtFs09jqhtoWuYUFfFAa6QA9QDTnpzamheuhxn8pt40-6l13UtS0ddhtQXj6dbR4XUGQg6zEYasTF393KjeSDGnDJKNxzj8I_7hLW5IOSmP9CH9hv_NL-d94d4DVNg84p1EnK4qlIj5hGClySWbadT-6OdsrL02MI8sFOOVkciw8zx8kaNspxnrJQE0fXKtjBMMs3JA-MpgOQwftIE9Bzj14w-cMznI_39E9Z3p0uFoA?type=png")||Tl(b,"src",el),JM(b,"background","white"),Tl(A,"class","tip")},m(J,T){TM(document.head,o),M(J,fJ,T),M(J,xJ,T),M(J,VJ,T),s(p,J,T),M(J,DJ,T),s(r,J,T),M(J,WJ,T),s(g,J,T),M(J,vJ,T),M(J,d,T),M(J,SJ,T),M(J,c,T),M(J,NJ,T),M(J,m,T),M(J,YJ,T),M(J,u,T),M(J,FJ,T),M(J,k,T),M(J,XJ,T),M(J,b,T),M(J,zJ,T),s(h,J,T),M(J,_J,T),M(J,B,T),M(J,HJ,T),M(J,Q,T),M(J,$J,T),M(J,R,T),M(J,qJ,T),M(J,O,T),M(J,LJ,T),s(E,J,T),M(J,KJ,T),M(J,A,T),M(J,PJ,T),M(J,G,T),M(J,JT,T),M(J,x,T),M(J,TT,T),M(J,Z,T),M(J,lT,T),M(J,f,T),M(J,MT,T),M(J,V,T),M(J,UT,T),M(J,D,T),M(J,wT,T),M(J,W,T),M(J,IT,T),M(J,v,T),M(J,yT,T),s(S,J,T),M(J,eT,T),s(N,J,T),M(J,tT,T),s(Y,J,T),M(J,aT,T),s(F,J,T),M(J,sT,T),M(J,X,T),M(J,nT,T),M(J,z,T),M(J,jT,T),M(J,_,T),M(J,CT,T),s(H,J,T),M(J,iT,T),M(J,$,T),M(J,oT,T),s(q,J,T),M(J,AT,T),s(L,J,T),M(J,pT,T),s(K,J,T),M(J,rT,T),s(P,J,T),M(J,gT,T),M(J,JJ,T),M(J,dT,T),s(TJ,J,T),M(J,cT,T),M(J,lJ,T),M(J,mT,T),M(J,MJ,T),M(J,uT,T),s(UJ,J,T),M(J,kT,T),s(wJ,J,T),M(J,bT,T),M(J,IJ,T),M(J,hT,T),s(yJ,J,T),M(J,BT,T),M(J,eJ,T),M(J,QT,T),M(J,tJ,T),M(J,RT,T),M(J,aJ,T),M(J,OT,T),s(sJ,J,T),M(J,ET,T),M(J,nJ,T),M(J,GT,T),M(J,jJ,T),M(J,xT,T),M(J,CJ,T),M(J,ZT,T),M(J,iJ,T),M(J,fT,T),s(oJ,J,T),M(J,VT,T),M(J,AJ,T),M(J,DT,T),M(J,pJ,T),M(J,WT,T),s(rJ,J,T),M(J,vT,T),M(J,gJ,T),M(J,ST,T),s(dJ,J,T),M(J,NT,T),M(J,cJ,T),M(J,YT,T),s(mJ,J,T),M(J,FT,T),s(uJ,J,T),M(J,XT,T),M(J,kJ,T),M(J,zT,T),M(J,bJ,T),M(J,_T,T),s(hJ,J,T),M(J,HT,T),M(J,BJ,T),M(J,$T,T),M(J,QJ,T),M(J,qT,T),s(RJ,J,T),M(J,LT,T),M(J,OJ,T),M(J,KT,T),s(EJ,J,T),M(J,PT,T),M(J,ZJ,T),Jl=!0},p:$l,i(J){Jl||(n(p.$$.fragment,J),n(r.$$.fragment,J),n(g.$$.fragment,J),n(h.$$.fragment,J),n(E.$$.fragment,J),n(S.$$.fragment,J),n(N.$$.fragment,J),n(Y.$$.fragment,J),n(F.$$.fragment,J),n(H.$$.fragment,J),n(q.$$.fragment,J),n(L.$$.fragment,J),n(K.$$.fragment,J),n(P.$$.fragment,J),n(TJ.$$.fragment,J),n(UJ.$$.fragment,J),n(wJ.$$.fragment,J),n(yJ.$$.fragment,J),n(sJ.$$.fragment,J),n(oJ.$$.fragment,J),n(rJ.$$.fragment,J),n(dJ.$$.fragment,J),n(mJ.$$.fragment,J),n(uJ.$$.fragment,J),n(hJ.$$.fragment,J),n(RJ.$$.fragment,J),n(EJ.$$.fragment,J),Jl=!0)},o(J){j(p.$$.fragment,J),j(r.$$.fragment,J),j(g.$$.fragment,J),j(h.$$.fragment,J),j(E.$$.fragment,J),j(S.$$.fragment,J),j(N.$$.fragment,J),j(Y.$$.fragment,J),j(F.$$.fragment,J),j(H.$$.fragment,J),j(q.$$.fragment,J),j(L.$$.fragment,J),j(K.$$.fragment,J),j(P.$$.fragment,J),j(TJ.$$.fragment,J),j(UJ.$$.fragment,J),j(wJ.$$.fragment,J),j(yJ.$$.fragment,J),j(sJ.$$.fragment,J),j(oJ.$$.fragment,J),j(rJ.$$.fragment,J),j(dJ.$$.fragment,J),j(mJ.$$.fragment,J),j(uJ.$$.fragment,J),j(hJ.$$.fragment,J),j(RJ.$$.fragment,J),j(EJ.$$.fragment,J),Jl=!1},d(J){J&&(l(fJ),l(xJ),l(VJ),l(DJ),l(WJ),l(vJ),l(d),l(SJ),l(c),l(NJ),l(m),l(YJ),l(u),l(FJ),l(k),l(XJ),l(b),l(zJ),l(_J),l(B),l(HJ),l(Q),l($J),l(R),l(qJ),l(O),l(LJ),l(KJ),l(A),l(PJ),l(G),l(JT),l(x),l(TT),l(Z),l(lT),l(f),l(MT),l(V),l(UT),l(D),l(wT),l(W),l(IT),l(v),l(yT),l(eT),l(tT),l(aT),l(sT),l(X),l(nT),l(z),l(jT),l(_),l(CT),l(iT),l($),l(oT),l(AT),l(pT),l(rT),l(gT),l(JJ),l(dT),l(cT),l(lJ),l(mT),l(MJ),l(uT),l(kT),l(bT),l(IJ),l(hT),l(BT),l(eJ),l(QT),l(tJ),l(RT),l(aJ),l(OT),l(ET),l(nJ),l(GT),l(jJ),l(xT),l(CJ),l(ZT),l(iJ),l(fT),l(VT),l(AJ),l(DT),l(pJ),l(WT),l(vT),l(gJ),l(ST),l(NT),l(cJ),l(YT),l(FT),l(XT),l(kJ),l(zT),l(bJ),l(_T),l(HT),l(BJ),l($T),l(QJ),l(qT),l(LT),l(OJ),l(KT),l(PT),l(ZJ)),l(o),C(p,J),C(r,J),C(g,J),C(h,J),C(E,J),C(S,J),C(N,J),C(Y,J),C(F,J),C(H,J),C(q,J),C(L,J),C(K,J),C(P,J),C(TJ,J),C(UJ,J),C(wJ,J),C(yJ,J),C(sJ,J),C(oJ,J),C(rJ,J),C(dJ,J),C(mJ,J),C(uJ,J),C(hJ,J),C(RJ,J),C(EJ,J)}}}const IM='{"title":"Sistemas Multi-Agente","local":"sistemas-multi-agente","sections":[{"title":"Sistemas Multi-Agente en Acción","local":"sistemas-multi-agente-en-acción","sections":[],"depth":2},{"title":"Resolviendo una tarea compleja con una jerarquía multi-agente","local":"resolviendo-una-tarea-compleja-con-una-jerarquía-multi-agente","sections":[{"title":"Primero creamos una herramienta para obtener el tiempo de transferencia del avión de carga.","local":"primero-creamos-una-herramienta-para-obtener-el-tiempo-de-transferencia-del-avión-de-carga","sections":[],"depth":3},{"title":"Configurando el agente","local":"configurando-el-agente","sections":[],"depth":3},{"title":"✌️ Dividiendo la tarea entre dos agentes","local":"-dividiendo-la-tarea-entre-dos-agentes","sections":[],"depth":3}],"depth":2},{"title":"Recursos","local":"recursos","sections":[],"depth":2}],"depth":1}';function yM(ll){return ql(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class iM extends Ll{constructor(o){super(),Kl(this,o,yM,wM,_l,{})}}export{iM as component};
