import{s as Rt,a as Nt,n as Qt,o as zt}from"../chunks/scheduler.505acc25.js";import{S as St,i as _t,e as i,s as n,c as d,h as Yt,a as r,d as t,b as s,f as Ht,g as M,j as o,k as We,l as qt,m as l,n as c,t as p,o as m,p as u}from"../chunks/index.fbb49fb4.js";import{C as kt}from"../chunks/CopyLLMTxtMenu.38c593c4.js";import{C as Be}from"../chunks/CodeBlock.2ead06c8.js";import{C as Xt}from"../chunks/CourseFloatingBanner.742f9db5.js";import{H as y}from"../chunks/Heading.511e0027.js";import{E as At}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.9ca82795.js";function Ft(Xa){let U,Ve,Ge,$e,J,Ee,h,xe,b,He,j,Aa='Como exploramos en la <a href="https://huggingface.co/learn/agents-course/unit1/tools" rel="nofollow">unidad 1</a>, los agentes utilizan herramientas para realizar diversas acciones. En <code>smolagents</code>, las herramientas son tratadas como <strong>funciones que un LLM puede llamar dentro de un sistema de agentes</strong>.',Re,f,Fa="Para interactuar con una herramienta, el LLM necesita una <strong>descripción de la interfaz</strong> con estos componentes clave:",Ne,g,La="<li><strong>Nombre</strong>: Cómo se llama la herramienta</li> <li><strong>Descripción de la herramienta</strong>: Qué hace la herramienta</li> <li><strong>Tipos de entrada y descripciones</strong>: Qué argumentos acepta la herramienta</li> <li><strong>Tipo de salida</strong>: Qué devuelve la herramienta</li>",Qe,C,Pa="Por ejemplo, mientras prepara una fiesta en la Mansión Wayne, Alfred necesita varias herramientas para recopilar información - desde buscar servicios de catering hasta encontrar ideas para temas de fiesta. Así es como podría verse la interfaz de una herramienta de búsqueda simple:",ze,w,Da="<li><strong>Nombre:</strong> <code>web_search</code></li> <li><strong>Descripción de la herramienta:</strong> Busca en la web consultas específicas</li> <li><strong>Entrada:</strong> <code>query</code> (cadena) - El término de búsqueda a consultar</li> <li><strong>Salida:</strong> Cadena que contiene los resultados de la búsqueda</li>",Se,v,Ka="Al utilizar estas herramientas, Alfred puede tomar decisiones informadas y recopilar toda la información necesaria para planificar la fiesta perfecta.",_e,I,Oa="A continuación, puedes ver una animación que ilustra cómo se gestiona una llamada a una herramienta:",Ye,B,et='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/Agent_ManimCE.gif" alt="Pipeline de agente de https://huggingface.co/docs/smolagents/conceptual_guides/react"/>',qe,G,ke,Z,at="En <code>smolagents</code>, las herramientas pueden definirse de dos maneras:",Xe,W,tt="<li><strong>Usando el decorador <code>@tool</code></strong> para herramientas simples basadas en funciones</li> <li><strong>Creando una subclase de <code>Tool</code></strong> para funcionalidades más complejas</li>",Ae,V,Fe,$,lt="El decorador <code>@tool</code> es <strong>la forma recomendada para definir herramientas simples</strong>. Internamente, smolagents analizará la información básica sobre la función desde Python. Por lo tanto, si nombras tu función claramente y escribes un buen docstring, será más fácil para el LLM utilizarla.",Le,E,nt="Usando este enfoque, definimos una función con:",Pe,x,st="<li><strong>Un nombre de función claro y descriptivo</strong> que ayuda al LLM a entender su propósito.</li> <li><strong>Anotaciones de tipo tanto para entradas como para salidas</strong> para garantizar un uso adecuado.</li> <li><strong>Una descripción detallada</strong>, que incluye una sección <code>Args:</code> donde cada argumento se describe explícitamente. Estas descripciones proporcionan un contexto valioso para el LLM, por lo que es importante escribirlas cuidadosamente.</li>",De,H,Ke,R,it,Oe,T,rt='<p>Puedes seguir el código en <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/tools.ipynb" target="_blank">este notebook</a> que puedes ejecutar usando Google Colab.</p>',ea,N,ot="Imaginemos que Alfred ya ha decidido el menú para la fiesta, pero ahora necesita ayuda para preparar comida para un número tan grande de invitados. Para hacerlo, le gustaría contratar un servicio de catering y necesita identificar las opciones mejor valoradas disponibles. Alfred puede aprovechar una herramienta para buscar los mejores servicios de catering en su área.",aa,Q,dt="A continuación se muestra un ejemplo de cómo Alfred puede usar el decorador <code>@tool</code> para lograrlo:",ta,z,la,S,na,_,Mt='Este enfoque implica crear una subclase de <a href="https://huggingface.co/docs/smolagents/v1.8.1/en/reference/tools#smolagents.Tool" rel="nofollow"><code>Tool</code></a>. Para herramientas complejas, podemos implementar una clase en lugar de una función de Python. La clase envuelve la función con metadatos que ayudan al LLM a entender cómo usarla de manera efectiva. En esta clase, definimos:',sa,Y,ct="<li><code>name</code>: El nombre de la herramienta.</li> <li><code>description</code>: Una descripción utilizada para completar el prompt del sistema del agente.</li> <li><code>inputs</code>: Un diccionario con claves <code>type</code> y <code>description</code>, proporcionando información para ayudar al intérprete de Python a procesar las entradas.</li> <li><code>output_type</code>: Especifica el tipo de salida esperado.</li> <li><code>forward</code>: El método que contiene la lógica de inferencia a ejecutar.</li>",ia,q,pt="A continuación, podemos ver un ejemplo de una herramienta construida usando <code>Tool</code> y cómo integrarla dentro de un <code>CodeAgent</code>.",ra,k,oa,X,mt="La fiesta de Alfred en la mansión es un <strong>evento temático de superhéroes</strong>, pero necesita algunas ideas creativas para hacerla verdaderamente especial. Como anfitrión fantástico, quiere sorprender a los invitados con un tema único.",da,A,ut="Para hacer esto, puede usar un agente que genere ideas de fiestas temáticas de superhéroes basadas en una categoría dada. De esta manera, Alfred puede encontrar el tema de fiesta perfecto para impresionar a sus invitados.",Ma,F,ca,L,yt="Con esta herramienta, ¡Alfred será el mejor anfitrión, impresionando a sus invitados con una fiesta temática de superhéroes que no olvidarán! 🦸‍♂️🦸‍♀️",pa,P,ma,D,Ut='<code>smolagents</code> viene con un conjunto de herramientas preintegradas que pueden inyectarse directamente en tu agente. La <a href="https://huggingface.co/docs/smolagents/guided_tour?build-a-tool=Decorate+a+function+with+%40tool#default-toolbox" rel="nofollow">caja de herramientas predeterminada</a> incluye:',ua,K,Tt="<li><strong>PythonInterpreterTool</strong></li> <li><strong>FinalAnswerTool</strong></li> <li><strong>UserInputTool</strong></li> <li><strong>DuckDuckGoSearchTool</strong></li> <li><strong>GoogleSearchTool</strong></li> <li><strong>VisitWebpageTool</strong></li>",ya,O,Jt="Alfred podría usar varias herramientas para asegurar una fiesta impecable en la Mansión Wayne:",Ua,ee,ht="<li><p>Primero, podría usar la <code>DuckDuckGoSearchTool</code> para encontrar ideas creativas para fiestas temáticas de superhéroes.</p></li> <li><p>Para el catering, confiaría en la <code>GoogleSearchTool</code> para encontrar los servicios mejor valorados en Gotham.</p></li> <li><p>Para gestionar la distribución de asientos, Alfred podría realizar cálculos con la <code>PythonInterpreterTool</code>.</p></li> <li><p>Una vez recopilado todo, compilaría el plan usando la <code>FinalAnswerTool</code>.</p></li>",Ta,ae,bt="Con estas herramientas, Alfred garantiza que la fiesta sea excepcional e impecable. 🦇💡",Ja,te,ha,le,jt="Una de las características más poderosas de <strong>smolagents</strong> es su capacidad para compartir herramientas personalizadas en el Hub e integrar perfectamente herramientas creadas por la comunidad. Esto incluye la conexión con <strong>HF Spaces</strong> y <strong>herramientas de LangChain</strong>, mejorando significativamente la capacidad de Alfred para organizar una fiesta inolvidable en la Mansión Wayne. 🎭",ba,ne,ft="Con estas integraciones, Alfred puede aprovechar herramientas avanzadas de planificación de eventos, ya sea ajustar la iluminación para el ambiente perfecto, seleccionar la lista de reproducción ideal para la fiesta, o coordinar con los mejores servicios de catering de Gotham.",ja,se,gt="Aquí hay ejemplos que muestran cómo estas funcionalidades pueden elevar la experiencia de la fiesta:",fa,ie,ga,re,Ct="¡Compartir tu herramienta personalizada con la comunidad es fácil! Simplemente súbela a tu cuenta de Hugging Face usando el método <code>push_to_hub()</code>.",Ca,oe,wt="Por ejemplo, Alfred puede compartir su <code>party_theme_tool</code> para ayudar a otros a encontrar los mejores servicios de catering en Gotham. Así es cómo hacerlo:",wa,de,va,Me,Ia,ce,vt="Puedes importar fácilmente herramientas creadas por otros usuarios usando la función <code>load_tool()</code>. Por ejemplo, Alfred podría querer generar una imagen promocional para la fiesta usando IA. En lugar de construir una herramienta desde cero, puede aprovechar una predefinida de la comunidad:",Ba,pe,Ga,me,Za,ue,It="También puedes importar un HF Space como herramienta usando <code>Tool.from_space()</code>. Esto abre posibilidades para integrar miles de spaces de la comunidad para tareas desde generación de imágenes hasta análisis de datos.",Wa,ye,Bt="La herramienta se conectará con el backend Gradio del space usando <code>gradio_client</code>, así que asegúrate de instalarlo via <code>pip</code> si aún no lo tienes.",Va,Ue,Gt="Para la fiesta, Alfred puede usar un HF Space existente para la generación de la imagen generada por IA que se usará en el anuncio (en lugar de la herramienta preintegrada que mencionamos antes). ¡Vamos a construirla!",$a,Te,Ea,Je,xa,he,Zt="Discutiremos el framework <code>LangChain</code> en las próximas secciones. Por ahora, solo notamos que ¡podemos reutilizar herramientas de LangChain en tu flujo de trabajo de smolagents!",Ha,be,Wt="Puedes cargar fácilmente herramientas de LangChain usando el método <code>Tool.from_langchain()</code>. Alfred, siempre perfeccionista, está preparando una espectacular noche de superhéroes en la Mansión Wayne mientras los Wayne están fuera. Para asegurarse de que cada detalle supere las expectativas, aprovecha las herramientas de LangChain para encontrar ideas de entretenimiento de primera categoría.",Ra,je,Vt="Al usar <code>Tool.from_langchain()</code>, Alfred añade sin esfuerzo funcionalidades de búsqueda avanzadas a su smolagent, permitiéndole descubrir ideas y servicios exclusivos para fiestas con solo unos pocos comandos.",Na,fe,$t="Así es como lo hace:",Qa,ge,za,Ce,Et="Con esta configuración, Alfred puede descubrir rápidamente opciones de entretenimiento lujosas, asegurando que los invitados de élite de Gotham tengan una experiencia inolvidable. ¡Esta herramienta le ayuda a organizar el evento temático de superhéroes perfecto para la Mansión Wayne! 🎉",Sa,we,_a,ve,xt='<li><a href="https://huggingface.co/docs/smolagents/tutorials/tools" rel="nofollow">Tutorial de Herramientas</a> - Explora este tutorial para aprender a trabajar efectivamente con herramientas.</li> <li><a href="https://huggingface.co/docs/smolagents/v1.8.1/en/reference/tools" rel="nofollow">Documentación de Herramientas</a> - Documentación de referencia completa sobre herramientas.</li> <li><a href="https://huggingface.co/docs/smolagents/v1.8.1/en/guided_tour#tools" rel="nofollow">Tour Guiado de Herramientas</a> - Un tour guiado paso a paso para ayudarte a construir y utilizar herramientas eficientemente.</li> <li><a href="https://huggingface.co/docs/smolagents/tutorials/building_good_agents" rel="nofollow">Construyendo Agentes Efectivos</a> - Una guía detallada sobre mejores prácticas para desarrollar agentes de función personalizados fiables y de alto rendimiento.</li>',Ya,Ie,qa,Ze,ka;return J=new Xt({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/tools.ipynb"}]}}),h=new kt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),b=new y({props:{title:"Herramientas",local:"herramientas",headingTag:"h1"}}),G=new y({props:{title:"Métodos de Creación de Herramientas",local:"métodos-de-creación-de-herramientas",headingTag:"h2"}}),V=new y({props:{title:"El Decorador @tool",local:"el-decorador-tool",headingTag:"h3"}}),H=new y({props:{title:"Generando una herramienta que recupera el servicio de catering mejor valorado",local:"generando-una-herramienta-que-recupera-el-servicio-de-catering-mejor-valorado",headingTag:"h4"}}),z=new Be({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel, tool

<span class="hljs-comment"># Imaginemos que tenemos una función que obtiene los servicios de catering mejor valorados.</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">catering_service_tool</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Esta herramienta devuelve el servicio de catering mejor valorado en Ciudad Gótica.
    
    Args:
        query: Un término de búsqueda para encontrar servicios de catering.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Lista de ejemplo de servicios de catering y sus calificaciones</span>
    services = {
        <span class="hljs-string">&quot;Gotham Catering Co.&quot;</span>: <span class="hljs-number">4.9</span>,
        <span class="hljs-string">&quot;Wayne Manor Catering&quot;</span>: <span class="hljs-number">4.8</span>,
        <span class="hljs-string">&quot;Gotham City Events&quot;</span>: <span class="hljs-number">4.7</span>,
    }
    
    <span class="hljs-comment"># Encuentra el servicio de catering mejor valorado (simulando el filtrado de consultas de búsqueda)</span>
    best_service = <span class="hljs-built_in">max</span>(services, key=services.get)
    
    <span class="hljs-keyword">return</span> best_service


agent = CodeAgent(tools=[catering_service_tool], model=InferenceClientModel())

<span class="hljs-comment"># Ejecuta el agente para encontrar el mejor servicio de catering</span>
result = agent.run(
    <span class="hljs-string">&quot;¿Puedes darme el nombre del servicio de catering mejor valorado en Ciudad Gótica?&quot;</span>
)

<span class="hljs-built_in">print</span>(result)   <span class="hljs-comment"># Salida: Gotham Catering Co.</span>`,wrap:!1}}),S=new y({props:{title:"Definiendo una Herramienta como una Clase de Python",local:"definiendo-una-herramienta-como-una-clase-de-python",headingTag:"h3"}}),k=new y({props:{title:"Generando una herramienta para generar ideas sobre la fiesta temática de superhéroes",local:"generando-una-herramienta-para-generar-ideas-sobre-la-fiesta-temática-de-superhéroes",headingTag:"h4"}}),F=new Be({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool, CodeAgent, InferenceClientModel

<span class="hljs-keyword">class</span> <span class="hljs-title class_">SuperheroPartyThemeTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;superhero_party_theme_generator&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    Esta herramienta sugiere ideas creativas para fiestas temáticas de superhéroes basadas en una categoría.
    Devuelve una idea única de tema para la fiesta.&quot;&quot;&quot;</span>
    
    inputs = {
        <span class="hljs-string">&quot;category&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;El tipo de fiesta de superhéroes (por ejemplo, &#x27;héroes clásicos&#x27;, &#x27;mascarada de villanos&#x27;, &#x27;Gotham futurista&#x27;).&quot;</span>,
        }
    }
    
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, category: <span class="hljs-built_in">str</span></span>):
        themes = {
            <span class="hljs-string">&quot;classic heroes&quot;</span>: <span class="hljs-string">&quot;Gala de la Liga de la Justicia: Los invitados vienen vestidos como sus héroes favoritos de DC con cócteles temáticos como &#x27;El Ponche de Kryptonita&#x27;.&quot;</span>,
            <span class="hljs-string">&quot;villain masquerade&quot;</span>: <span class="hljs-string">&quot;Baile de los Pícaros de Gotham: Una mascarada misteriosa donde los invitados se visten como villanos clásicos de Batman.&quot;</span>,
            <span class="hljs-string">&quot;futuristic Gotham&quot;</span>: <span class="hljs-string">&quot;Noche Neo-Gotham: Una fiesta de estilo cyberpunk inspirada en Batman Beyond, con decoraciones de neón y gadgets futuristas.&quot;</span>
        }
        
        <span class="hljs-keyword">return</span> themes.get(category.lower(), <span class="hljs-string">&quot;Idea de fiesta temática no encontrada. Prueba con &#x27;héroes clásicos&#x27;, &#x27;mascarada de villanos&#x27; o &#x27;Gotham futurista&#x27;.&quot;</span>)

<span class="hljs-comment"># Instancia la herramienta</span>
party_theme_tool = SuperheroPartyThemeTool()
agent = CodeAgent(tools=[party_theme_tool], model=InferenceClientModel())

<span class="hljs-comment"># Ejecuta el agente para generar una idea de tema para la fiesta</span>
result = agent.run(
    <span class="hljs-string">&quot;¿Cuál sería una buena idea para una fiesta de superhéroes con el tema &#x27;mascarada de villanos&#x27;?&quot;</span>
)

<span class="hljs-built_in">print</span>(result)  <span class="hljs-comment"># Salida: &quot;Baile de los Pícaros de Gotham: Una mascarada misteriosa donde los invitados se visten como villanos clásicos de Batman.&quot;</span>`,wrap:!1}}),P=new y({props:{title:"Caja de Herramientas Predeterminada",local:"caja-de-herramientas-predeterminada",headingTag:"h2"}}),te=new y({props:{title:"Compartir e Importar Herramientas",local:"compartir-e-importar-herramientas",headingTag:"h2"}}),ie=new y({props:{title:"Compartir una Herramienta en el Hub",local:"compartir-una-herramienta-en-el-hub",headingTag:"h3"}}),de=new Be({props:{code:"cGFydHlfdGhlbWVfdG9vbC5wdXNoX3RvX2h1YiglMjIlN0J0dV9ub21icmVfZGVfdXN1YXJpbyU3RCUyRnBhcnR5X3RoZW1lX3Rvb2wlMjIlMkMlMjB0b2tlbiUzRCUyMiUzQ1RVX1RPS0VOX0FQSV9IVUdHSU5HRkFDRUhVQiUzRSUyMik=",highlighted:'party_theme_tool.push_to_hub(<span class="hljs-string">&quot;{tu_nombre_de_usuario}/party_theme_tool&quot;</span>, token=<span class="hljs-string">&quot;&lt;TU_TOKEN_API_HUGGINGFACEHUB&gt;&quot;</span>)',wrap:!1}}),Me=new y({props:{title:"Importar una Herramienta desde el Hub",local:"importar-una-herramienta-desde-el-hub",headingTag:"h3"}}),pe=new Be({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQWltYWdlX2dlbmVyYXRpb25fdG9vbCUyMCUzRCUyMGxvYWRfdG9vbCglMEElMjAlMjAlMjAlMjAlMjJtLXJpYyUyRnRleHQtdG8taW1hZ2UlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzREluZmVyZW5jZUNsaWVudE1vZGVsKCklMEEpJTBBJTBBYWdlbnQucnVuKCUyMkdlbmVyYSUyMHVuYSUyMGltYWdlbiUyMGRlJTIwdW5hJTIwbHVqb3NhJTIwZmllc3RhJTIwdGVtJUMzJUExdGljYSUyMGRlJTIwc3VwZXJoJUMzJUE5cm9lcyUyMGVuJTIwbGElMjBNYW5zaSVDMyVCM24lMjBXYXluZSUyMGNvbiUyMHN1cGVyaCVDMyVBOXJvZXMlMjBpbnZlbnRhZG9zLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent, InferenceClientModel

image_generation_tool = load_tool(
    <span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)

agent = CodeAgent(
    tools=[image_generation_tool],
    model=InferenceClientModel()
)

agent.run(<span class="hljs-string">&quot;Genera una imagen de una lujosa fiesta temática de superhéroes en la Mansión Wayne con superhéroes inventados.&quot;</span>)`,wrap:!1}}),me=new y({props:{title:"Importar un Hugging Face Space como Herramienta",local:"importar-un-hugging-face-space-como-herramienta",headingTag:"h3"}}),Te=new Be({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMFRvb2wlMEElMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fc3BhY2UoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5hbWUlM0QlMjJpbWFnZV9nZW5lcmF0b3IlMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMkdlbmVyYXIlMjB1bmElMjBpbWFnZW4lMjBhJTIwcGFydGlyJTIwZGUlMjB1biUyMHByb21wdCUyMiUwQSklMEElMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiklMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QmltYWdlX2dlbmVyYXRpb25fdG9vbCU1RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBJTBBYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMk1lam9yYSUyMGVzdGUlMjBwcm9tcHQlMkMlMjBsdWVnbyUyMGdlbmVyYSUyMHVuYSUyMGltYWdlbiUyMGRlbCUyMG1pc21vLiUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMGFkZGl0aW9uYWxfYXJncyUzRCU3Qid1c2VyX3Byb21wdCclM0ElMjAnVW5hJTIwZ3JhbiUyMGZpZXN0YSUyMHRlbSVDMyVBMXRpY2ElMjBkZSUyMHN1cGVyaCVDMyVBOXJvZXMlMjBlbiUyMGxhJTIwTWFuc2klQzMlQjNuJTIwV2F5bmUlMkMlMjBjb24lMjBBbGZyZWQlMjBzdXBlcnZpc2FuZG8lMjB1bmElMjBsdWpvc2ElMjBnYWxhJyU3RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel, Tool

image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generar una imagen a partir de un prompt&quot;</span>
)

model = InferenceClientModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Mejora este prompt, luego genera una imagen del mismo.&quot;</span>, 
    additional_args={<span class="hljs-string">&#x27;user_prompt&#x27;</span>: <span class="hljs-string">&#x27;Una gran fiesta temática de superhéroes en la Mansión Wayne, con Alfred supervisando una lujosa gala&#x27;</span>}
)`,wrap:!1}}),Je=new y({props:{title:"Importar una Herramienta de LangChain",local:"importar-una-herramienta-de-langchain",headingTag:"h3"}}),ge=new Be({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMFRvb2wlMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMFRvb2wuZnJvbV9sYW5nY2hhaW4obG9hZF90b29scyglNUIlMjJzZXJwYXBpJTIyJTVEKSU1QjAlNUQpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUJzZWFyY2hfdG9vbCU1RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBJTBBYWdlbnQucnVuKCUyMkJ1c2NhJTIwaWRlYXMlMjBkZSUyMGVudHJldGVuaW1pZW50byUyMGRlJTIwbHVqbyUyMHBhcmElMjB1biUyMGV2ZW50byUyMHRlbSVDMyVBMXRpY28lMjBkZSUyMHN1cGVyaCVDMyVBOXJvZXMlMkMlMjBjb21vJTIwYWN0dWFjaW9uZXMlMjBlbiUyMHZpdm8lMjB5JTIwZXhwZXJpZW5jaWFzJTIwaW50ZXJhY3RpdmFzLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel, Tool

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;Busca ideas de entretenimiento de lujo para un evento temático de superhéroes, como actuaciones en vivo y experiencias interactivas.&quot;</span>)`,wrap:!1}}),we=new y({props:{title:"Recursos",local:"recursos",headingTag:"h2"}}),Ie=new At({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/es/unit2/smolagents/tools.mdx"}}),{c(){U=i("meta"),Ve=n(),Ge=i("p"),$e=n(),d(J.$$.fragment),Ee=n(),d(h.$$.fragment),xe=n(),d(b.$$.fragment),He=n(),j=i("p"),j.innerHTML=Aa,Re=n(),f=i("p"),f.innerHTML=Fa,Ne=n(),g=i("ul"),g.innerHTML=La,Qe=n(),C=i("p"),C.textContent=Pa,ze=n(),w=i("ul"),w.innerHTML=Da,Se=n(),v=i("p"),v.textContent=Ka,_e=n(),I=i("p"),I.textContent=Oa,Ye=n(),B=i("p"),B.innerHTML=et,qe=n(),d(G.$$.fragment),ke=n(),Z=i("p"),Z.innerHTML=at,Xe=n(),W=i("ol"),W.innerHTML=tt,Ae=n(),d(V.$$.fragment),Fe=n(),$=i("p"),$.innerHTML=lt,Le=n(),E=i("p"),E.textContent=nt,Pe=n(),x=i("ul"),x.innerHTML=st,De=n(),d(H.$$.fragment),Ke=n(),R=i("img"),Oe=n(),T=i("blockquote"),T.innerHTML=rt,ea=n(),N=i("p"),N.textContent=ot,aa=n(),Q=i("p"),Q.innerHTML=dt,ta=n(),d(z.$$.fragment),la=n(),d(S.$$.fragment),na=n(),_=i("p"),_.innerHTML=Mt,sa=n(),Y=i("ul"),Y.innerHTML=ct,ia=n(),q=i("p"),q.innerHTML=pt,ra=n(),d(k.$$.fragment),oa=n(),X=i("p"),X.innerHTML=mt,da=n(),A=i("p"),A.textContent=ut,Ma=n(),d(F.$$.fragment),ca=n(),L=i("p"),L.textContent=yt,pa=n(),d(P.$$.fragment),ma=n(),D=i("p"),D.innerHTML=Ut,ua=n(),K=i("ul"),K.innerHTML=Tt,ya=n(),O=i("p"),O.textContent=Jt,Ua=n(),ee=i("ul"),ee.innerHTML=ht,Ta=n(),ae=i("p"),ae.textContent=bt,Ja=n(),d(te.$$.fragment),ha=n(),le=i("p"),le.innerHTML=jt,ba=n(),ne=i("p"),ne.textContent=ft,ja=n(),se=i("p"),se.textContent=gt,fa=n(),d(ie.$$.fragment),ga=n(),re=i("p"),re.innerHTML=Ct,Ca=n(),oe=i("p"),oe.innerHTML=wt,wa=n(),d(de.$$.fragment),va=n(),d(Me.$$.fragment),Ia=n(),ce=i("p"),ce.innerHTML=vt,Ba=n(),d(pe.$$.fragment),Ga=n(),d(me.$$.fragment),Za=n(),ue=i("p"),ue.innerHTML=It,Wa=n(),ye=i("p"),ye.innerHTML=Bt,Va=n(),Ue=i("p"),Ue.textContent=Gt,$a=n(),d(Te.$$.fragment),Ea=n(),d(Je.$$.fragment),xa=n(),he=i("p"),he.innerHTML=Zt,Ha=n(),be=i("p"),be.innerHTML=Wt,Ra=n(),je=i("p"),je.innerHTML=Vt,Na=n(),fe=i("p"),fe.textContent=$t,Qa=n(),d(ge.$$.fragment),za=n(),Ce=i("p"),Ce.textContent=Et,Sa=n(),d(we.$$.fragment),_a=n(),ve=i("ul"),ve.innerHTML=xt,Ya=n(),d(Ie.$$.fragment),qa=n(),Ze=i("p"),this.h()},l(e){const a=Yt("svelte-u9bgzb",document.head);U=r(a,"META",{name:!0,content:!0}),a.forEach(t),Ve=s(e),Ge=r(e,"P",{}),Ht(Ge).forEach(t),$e=s(e),M(J.$$.fragment,e),Ee=s(e),M(h.$$.fragment,e),xe=s(e),M(b.$$.fragment,e),He=s(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1vquyog"&&(j.innerHTML=Aa),Re=s(e),f=r(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1ffc0qb"&&(f.innerHTML=Fa),Ne=s(e),g=r(e,"UL",{"data-svelte-h":!0}),o(g)!=="svelte-1u9qy3e"&&(g.innerHTML=La),Qe=s(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1jdcqjs"&&(C.textContent=Pa),ze=s(e),w=r(e,"UL",{"data-svelte-h":!0}),o(w)!=="svelte-g5pzg5"&&(w.innerHTML=Da),Se=s(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-14cn6bt"&&(v.textContent=Ka),_e=s(e),I=r(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1d4gp29"&&(I.textContent=Oa),Ye=s(e),B=r(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-14iql5d"&&(B.innerHTML=et),qe=s(e),M(G.$$.fragment,e),ke=s(e),Z=r(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-losady"&&(Z.innerHTML=at),Xe=s(e),W=r(e,"OL",{"data-svelte-h":!0}),o(W)!=="svelte-1gwgfyv"&&(W.innerHTML=tt),Ae=s(e),M(V.$$.fragment,e),Fe=s(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-11jmxz0"&&($.innerHTML=lt),Le=s(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-19e8n6w"&&(E.textContent=nt),Pe=s(e),x=r(e,"UL",{"data-svelte-h":!0}),o(x)!=="svelte-is9j1j"&&(x.innerHTML=st),De=s(e),M(H.$$.fragment,e),Ke=s(e),R=r(e,"IMG",{src:!0,alt:!0}),Oe=s(e),T=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(T)!=="svelte-nyegvz"&&(T.innerHTML=rt),ea=s(e),N=r(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1phj33a"&&(N.textContent=ot),aa=s(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-o6ahqz"&&(Q.innerHTML=dt),ta=s(e),M(z.$$.fragment,e),la=s(e),M(S.$$.fragment,e),na=s(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1uchfjq"&&(_.innerHTML=Mt),sa=s(e),Y=r(e,"UL",{"data-svelte-h":!0}),o(Y)!=="svelte-1pxkday"&&(Y.innerHTML=ct),ia=s(e),q=r(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1r3qbe3"&&(q.innerHTML=pt),ra=s(e),M(k.$$.fragment,e),oa=s(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1miih4m"&&(X.innerHTML=mt),da=s(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-rvosa0"&&(A.textContent=ut),Ma=s(e),M(F.$$.fragment,e),ca=s(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1e33jkv"&&(L.textContent=yt),pa=s(e),M(P.$$.fragment,e),ma=s(e),D=r(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-5vnj9j"&&(D.innerHTML=Ut),ua=s(e),K=r(e,"UL",{"data-svelte-h":!0}),o(K)!=="svelte-1pasg00"&&(K.innerHTML=Tt),ya=s(e),O=r(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-2s1u84"&&(O.textContent=Jt),Ua=s(e),ee=r(e,"UL",{"data-svelte-h":!0}),o(ee)!=="svelte-euiqhi"&&(ee.innerHTML=ht),Ta=s(e),ae=r(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1f9wu4y"&&(ae.textContent=bt),Ja=s(e),M(te.$$.fragment,e),ha=s(e),le=r(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-wvbuk7"&&(le.innerHTML=jt),ba=s(e),ne=r(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1iy53su"&&(ne.textContent=ft),ja=s(e),se=r(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1ku4hoy"&&(se.textContent=gt),fa=s(e),M(ie.$$.fragment,e),ga=s(e),re=r(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-1uocugf"&&(re.innerHTML=Ct),Ca=s(e),oe=r(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-136gg4"&&(oe.innerHTML=wt),wa=s(e),M(de.$$.fragment,e),va=s(e),M(Me.$$.fragment,e),Ia=s(e),ce=r(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-pf0yzb"&&(ce.innerHTML=vt),Ba=s(e),M(pe.$$.fragment,e),Ga=s(e),M(me.$$.fragment,e),Za=s(e),ue=r(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-1raf2m8"&&(ue.innerHTML=It),Wa=s(e),ye=r(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-lhbhy7"&&(ye.innerHTML=Bt),Va=s(e),Ue=r(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-1dcwgd5"&&(Ue.textContent=Gt),$a=s(e),M(Te.$$.fragment,e),Ea=s(e),M(Je.$$.fragment,e),xa=s(e),he=r(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-2qkpbc"&&(he.innerHTML=Zt),Ha=s(e),be=r(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-62kksu"&&(be.innerHTML=Wt),Ra=s(e),je=r(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-xn5d7w"&&(je.innerHTML=Vt),Na=s(e),fe=r(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-cwvvl3"&&(fe.textContent=$t),Qa=s(e),M(ge.$$.fragment,e),za=s(e),Ce=r(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-1r4npw6"&&(Ce.textContent=Et),Sa=s(e),M(we.$$.fragment,e),_a=s(e),ve=r(e,"UL",{"data-svelte-h":!0}),o(ve)!=="svelte-1c3sd2l"&&(ve.innerHTML=xt),Ya=s(e),M(Ie.$$.fragment,e),qa=s(e),Ze=r(e,"P",{}),Ht(Ze).forEach(t),this.h()},h(){We(U,"name","hf:doc:metadata"),We(U,"content",Lt),Nt(R.src,it="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/alfred-catering.jpg")||We(R,"src",it),We(R,"alt","Alfred Catering"),We(T,"class","tip")},m(e,a){qt(document.head,U),l(e,Ve,a),l(e,Ge,a),l(e,$e,a),c(J,e,a),l(e,Ee,a),c(h,e,a),l(e,xe,a),c(b,e,a),l(e,He,a),l(e,j,a),l(e,Re,a),l(e,f,a),l(e,Ne,a),l(e,g,a),l(e,Qe,a),l(e,C,a),l(e,ze,a),l(e,w,a),l(e,Se,a),l(e,v,a),l(e,_e,a),l(e,I,a),l(e,Ye,a),l(e,B,a),l(e,qe,a),c(G,e,a),l(e,ke,a),l(e,Z,a),l(e,Xe,a),l(e,W,a),l(e,Ae,a),c(V,e,a),l(e,Fe,a),l(e,$,a),l(e,Le,a),l(e,E,a),l(e,Pe,a),l(e,x,a),l(e,De,a),c(H,e,a),l(e,Ke,a),l(e,R,a),l(e,Oe,a),l(e,T,a),l(e,ea,a),l(e,N,a),l(e,aa,a),l(e,Q,a),l(e,ta,a),c(z,e,a),l(e,la,a),c(S,e,a),l(e,na,a),l(e,_,a),l(e,sa,a),l(e,Y,a),l(e,ia,a),l(e,q,a),l(e,ra,a),c(k,e,a),l(e,oa,a),l(e,X,a),l(e,da,a),l(e,A,a),l(e,Ma,a),c(F,e,a),l(e,ca,a),l(e,L,a),l(e,pa,a),c(P,e,a),l(e,ma,a),l(e,D,a),l(e,ua,a),l(e,K,a),l(e,ya,a),l(e,O,a),l(e,Ua,a),l(e,ee,a),l(e,Ta,a),l(e,ae,a),l(e,Ja,a),c(te,e,a),l(e,ha,a),l(e,le,a),l(e,ba,a),l(e,ne,a),l(e,ja,a),l(e,se,a),l(e,fa,a),c(ie,e,a),l(e,ga,a),l(e,re,a),l(e,Ca,a),l(e,oe,a),l(e,wa,a),c(de,e,a),l(e,va,a),c(Me,e,a),l(e,Ia,a),l(e,ce,a),l(e,Ba,a),c(pe,e,a),l(e,Ga,a),c(me,e,a),l(e,Za,a),l(e,ue,a),l(e,Wa,a),l(e,ye,a),l(e,Va,a),l(e,Ue,a),l(e,$a,a),c(Te,e,a),l(e,Ea,a),c(Je,e,a),l(e,xa,a),l(e,he,a),l(e,Ha,a),l(e,be,a),l(e,Ra,a),l(e,je,a),l(e,Na,a),l(e,fe,a),l(e,Qa,a),c(ge,e,a),l(e,za,a),l(e,Ce,a),l(e,Sa,a),c(we,e,a),l(e,_a,a),l(e,ve,a),l(e,Ya,a),c(Ie,e,a),l(e,qa,a),l(e,Ze,a),ka=!0},p:Qt,i(e){ka||(p(J.$$.fragment,e),p(h.$$.fragment,e),p(b.$$.fragment,e),p(G.$$.fragment,e),p(V.$$.fragment,e),p(H.$$.fragment,e),p(z.$$.fragment,e),p(S.$$.fragment,e),p(k.$$.fragment,e),p(F.$$.fragment,e),p(P.$$.fragment,e),p(te.$$.fragment,e),p(ie.$$.fragment,e),p(de.$$.fragment,e),p(Me.$$.fragment,e),p(pe.$$.fragment,e),p(me.$$.fragment,e),p(Te.$$.fragment,e),p(Je.$$.fragment,e),p(ge.$$.fragment,e),p(we.$$.fragment,e),p(Ie.$$.fragment,e),ka=!0)},o(e){m(J.$$.fragment,e),m(h.$$.fragment,e),m(b.$$.fragment,e),m(G.$$.fragment,e),m(V.$$.fragment,e),m(H.$$.fragment,e),m(z.$$.fragment,e),m(S.$$.fragment,e),m(k.$$.fragment,e),m(F.$$.fragment,e),m(P.$$.fragment,e),m(te.$$.fragment,e),m(ie.$$.fragment,e),m(de.$$.fragment,e),m(Me.$$.fragment,e),m(pe.$$.fragment,e),m(me.$$.fragment,e),m(Te.$$.fragment,e),m(Je.$$.fragment,e),m(ge.$$.fragment,e),m(we.$$.fragment,e),m(Ie.$$.fragment,e),ka=!1},d(e){e&&(t(Ve),t(Ge),t($e),t(Ee),t(xe),t(He),t(j),t(Re),t(f),t(Ne),t(g),t(Qe),t(C),t(ze),t(w),t(Se),t(v),t(_e),t(I),t(Ye),t(B),t(qe),t(ke),t(Z),t(Xe),t(W),t(Ae),t(Fe),t($),t(Le),t(E),t(Pe),t(x),t(De),t(Ke),t(R),t(Oe),t(T),t(ea),t(N),t(aa),t(Q),t(ta),t(la),t(na),t(_),t(sa),t(Y),t(ia),t(q),t(ra),t(oa),t(X),t(da),t(A),t(Ma),t(ca),t(L),t(pa),t(ma),t(D),t(ua),t(K),t(ya),t(O),t(Ua),t(ee),t(Ta),t(ae),t(Ja),t(ha),t(le),t(ba),t(ne),t(ja),t(se),t(fa),t(ga),t(re),t(Ca),t(oe),t(wa),t(va),t(Ia),t(ce),t(Ba),t(Ga),t(Za),t(ue),t(Wa),t(ye),t(Va),t(Ue),t($a),t(Ea),t(xa),t(he),t(Ha),t(be),t(Ra),t(je),t(Na),t(fe),t(Qa),t(za),t(Ce),t(Sa),t(_a),t(ve),t(Ya),t(qa),t(Ze)),t(U),u(J,e),u(h,e),u(b,e),u(G,e),u(V,e),u(H,e),u(z,e),u(S,e),u(k,e),u(F,e),u(P,e),u(te,e),u(ie,e),u(de,e),u(Me,e),u(pe,e),u(me,e),u(Te,e),u(Je,e),u(ge,e),u(we,e),u(Ie,e)}}}const Lt='{"title":"Herramientas","local":"herramientas","sections":[{"title":"Métodos de Creación de Herramientas","local":"métodos-de-creación-de-herramientas","sections":[{"title":"El Decorador @tool","local":"el-decorador-tool","sections":[{"title":"Generando una herramienta que recupera el servicio de catering mejor valorado","local":"generando-una-herramienta-que-recupera-el-servicio-de-catering-mejor-valorado","sections":[],"depth":4}],"depth":3},{"title":"Definiendo una Herramienta como una Clase de Python","local":"definiendo-una-herramienta-como-una-clase-de-python","sections":[{"title":"Generando una herramienta para generar ideas sobre la fiesta temática de superhéroes","local":"generando-una-herramienta-para-generar-ideas-sobre-la-fiesta-temática-de-superhéroes","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Caja de Herramientas Predeterminada","local":"caja-de-herramientas-predeterminada","sections":[],"depth":2},{"title":"Compartir e Importar Herramientas","local":"compartir-e-importar-herramientas","sections":[{"title":"Compartir una Herramienta en el Hub","local":"compartir-una-herramienta-en-el-hub","sections":[],"depth":3},{"title":"Importar una Herramienta desde el Hub","local":"importar-una-herramienta-desde-el-hub","sections":[],"depth":3},{"title":"Importar un Hugging Face Space como Herramienta","local":"importar-un-hugging-face-space-como-herramienta","sections":[],"depth":3},{"title":"Importar una Herramienta de LangChain","local":"importar-una-herramienta-de-langchain","sections":[],"depth":3}],"depth":2},{"title":"Recursos","local":"recursos","sections":[],"depth":2}],"depth":1}';function Pt(Xa){return zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nl extends St{constructor(U){super(),_t(this,U,Pt,Ft,Rt,{})}}export{nl as component};
