import{s as bs,n as ws,o as Cs}from"../chunks/scheduler.505acc25.js";import{S as fs,i as gs,e as i,s,c as M,h as hs,a as o,d as l,b as n,f as Ts,g as p,j as r,k as oa,l as Is,m as a,n as u,t as c,o as m,p as d}from"../chunks/index.fbb49fb4.js";import{C as Zs}from"../chunks/CopyLLMTxtMenu.38c593c4.js";import{C as j}from"../chunks/CodeBlock.2ead06c8.js";import{C as vs}from"../chunks/CourseFloatingBanner.742f9db5.js";import{H as y}from"../chunks/Heading.511e0027.js";import{E as Vs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.9ca82795.js";function Ws(ra){let U,ct,pt,mt,T,dt,b,yt,w,jt,J,Ma='<p>Puedes seguir el código en <a href="https://huggingface.co/agents-course/notebooks/blob/main/bonus-unit2/monitoring-and-evaluating-agents-notebook.ipynb" target="_blank">este notebook</a> que puedes ejecutar usando Google Colab.</p>',Ut,C,pa="En este notebook, aprenderemos cómo <strong>monitorear los pasos internos (trazos) de nuestro agente de IA</strong> y <strong>evaluar su rendimiento</strong> utilizando herramientas de observabilidad de código abierto.",Jt,f,ua="La capacidad de observar y evaluar el comportamiento de un agente es esencial para:",Tt,g,ca="<li>Depurar problemas cuando las tareas fallan o producen resultados subóptimos</li> <li>Monitorear costos y rendimiento en tiempo real</li> <li>Mejorar la fiabilidad y seguridad a través de retroalimentación continua</li>",bt,h,wt,I,ma="Antes de ejecutar este notebook, asegúrate de que has:",Ct,Z,da='🔲 📚  <strong>Estudiado</strong> <a href="https://huggingface.co/learn/agents-course/unit1/introduction" rel="nofollow">Introducción a los Agentes</a>',ft,v,ya='🔲 📚  <strong>Estudiado</strong> <a href="https://huggingface.co/learn/agents-course/unit2/smolagents/introduction" rel="nofollow">El framework smolagents</a>',gt,V,ht,W,ja="Necesitaremos algunas librerías que nos permitan ejecutar, monitorear y evaluar nuestros agentes:",It,B,Zt,E,vt,G,Ua='En este notebook, utilizaremos <a href="https://langfuse.com/" rel="nofollow">Langfuse</a> como nuestra herramienta de observabilidad, pero puedes usar <strong>cualquier otro servicio compatible con OpenTelemetry</strong>. El código a continuación muestra cómo configurar variables de entorno para Langfuse (o cualquier endpoint OTel) y cómo instrumentar tu smolagent.',Vt,R,Ja='<strong>Nota:</strong> Si estás utilizando LlamaIndex o LangGraph, puedes encontrar documentación sobre cómo instrumentarlos <a href="https://langfuse.com/docs/integrations/llama-index/workflows" rel="nofollow">aquí</a> y <a href="https://langfuse.com/docs/integrations/langchain/example-python-langgraph" rel="nofollow">aquí</a>.',Wt,k,Ta="Primero, vamos a configurar la variable de entorno correcta para establecer la conexión con el endpoint OpenTelemetry de Langfuse.",Bt,$,Et,N,ba="También necesitamos configurar nuestro token de Hugging Face para las llamadas de inferencia.",Gt,x,Rt,A,wa="A continuación, podemos configurar un proveedor de trazoss para nuestro OpenTelemetry configurado.",kt,Y,$t,Q,Nt,_,Ca="Aquí hay un simple CodeAgent de smolagents que calcula <code>1+1</code>. Lo ejecutamos para confirmar que la instrumentación está funcionando correctamente. Si todo está configurado correctamente, verás registros/spans en tu panel de observabilidad.",xt,H,At,X,fa='Revisa tu <a href="https://cloud.langfuse.com/traces" rel="nofollow">Panel de rastros de Langfuse</a> (o tu herramienta de observabilidad elegida) para confirmar que los spans y registros han sido grabados.',Yt,L,ga="Captura de pantalla de ejemplo de Langfuse:",Qt,S,ha='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/first-example-trace.png" alt="Ejemplo de rastros en Langfuse"/>',_t,F,Ia='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1b94d6888258e0998329cdb72a371155?timestamp=2025-03-10T11%3A59%3A41.743Z" rel="nofollow">Enlace a  los rastros</a></em>',Ht,z,Xt,q,Za="Ahora que has confirmado que tu instrumentación funciona, probemos una consulta más compleja para ver cómo se rastrean las métricas avanzadas (uso de tokens, latencia, costos, etc.).",Lt,P,St,D,Ft,K,va="La mayoría de las herramientas de observabilidad registran una <strong>rastro</strong> que contiene <strong>spans</strong>, que representan cada paso de la lógica de tu agente. Aquí, el rastro contiene la ejecución general del agente y sub-spans para:",zt,O,Va="<li>Las llamadas a herramientas (DuckDuckGoSearchTool)</li> <li>Las llamadas al LLM (InferenceClientModel)</li>",qt,ee,Wa="Puedes inspeccionarlos para ver precisamente dónde se gasta el tiempo, cuántos tokens se utilizan, etc.:",Pt,te,Ba='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/trace-tree.png" alt="Árbol de rastros en Langfuse"/>',Dt,le,Ea='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">Enlace a los rastros</a></em>',Kt,ae,Ot,se,Ga="En la sección anterior, aprendimos sobre la diferencia entre evaluación en línea y fuera de línea. Ahora, veremos cómo monitorear tu agente en producción y evaluarlo en vivo.",el,ne,tl,ie,Ra="<li><strong>Costos</strong> — La instrumentación de smolagents captura el uso de tokens, que puedes transformar en costos aproximados asignando un precio por token.</li> <li><strong>Latencia</strong> — Observa el tiempo que toma completar cada paso, o la ejecución completa.</li> <li><strong>Retroalimentación del Usuario</strong> — Los usuarios pueden proporcionar retroalimentación directa (pulgar arriba/abajo) para ayudar a refinar o corregir el agente.</li> <li><strong>LLM-como-Juez</strong> — Utiliza un LLM separado para evaluar la salida de tu agente en tiempo casi real (por ejemplo, verificando toxicidad o corrección).</li>",ll,oe,ka="A continuación, mostramos ejemplos de estas métricas.",al,re,sl,Me,$a="A continuación se muestra una captura de pantalla que muestra el uso para llamadas a <code>Qwen2.5-Coder-32B-Instruct</code>. Esto es útil para ver pasos costosos y optimizar tu agente.",nl,pe,Na='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-costs.png" alt="Costos"/>',il,ue,xa='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">Enlace a los rastros</a></em>',ol,ce,rl,me,Aa="También podemos ver cuánto tiempo tomó completar cada paso. En el ejemplo a continuación, toda la conversación tomó 32 segundos, que puedes desglosar por paso. Esto te ayuda a identificar cuellos de botella y optimizar tu agente.",Ml,de,Ya='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-latency.png" alt="Latencia"/>',pl,ye,Qa='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">Enlace a los rastros</a></em>',ul,je,cl,Ue,_a="También puedes pasar atributos adicionales, como IDs de usuario, IDs de sesión o etiquetas, configurándolos en los spans. Por ejemplo, la instrumentación de smolagents utiliza OpenTelemetry para adjuntar atributos como <code>langfuse.user.id</code> o etiquetas personalizadas.",ml,Je,dl,Te,Ha='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-attributes.png" alt="Mejorando las ejecuciones de agentes con métricas adicionales"/>',yl,be,jl,we,Xa='Si tu agente está integrado en una interfaz de usuario, puedes registrar la retroalimentación directa del usuario (como un pulgar arriba/abajo en una interfaz de chat). A continuación se muestra un ejemplo utilizando <a href="https://gradio.app/" rel="nofollow">Gradio</a> para integrar un chat con un mecanismo de retroalimentación simple.',Ul,Ce,La="En el fragmento de código a continuación, cuando un usuario envía un mensaje de chat, capturamos el ID de traza de OpenTelemetry. Si al usuario le gusta/no le gusta la última respuesta, adjuntamos una puntuación a la traza.",Jl,fe,Tl,ge,Sa="La retroalimentación del usuario se captura entonces en tu herramienta de observabilidad:",bl,he,Fa='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/user-feedback-gradio.png" alt="La retroalimentación del usuario se captura en Langfuse"/>',wl,Ie,Cl,Ze,za="LLM-como-Juez es otra forma de evaluar automáticamente la salida de tu agente. Puedes configurar una llamada LLM separada para medir la corrección, toxicidad, estilo o cualquier otro criterio que te importe.",fl,ve,qa="<strong>Flujo de trabajo</strong>:",gl,Ve,Pa="<li>Defines una <strong>Plantilla de Evaluación</strong>, por ejemplo, “Verifica si el texto es tóxico”.</li> <li>Cada vez que tu agente genera una salida, pasas esa salida a tu LLM “juez” con la plantilla.</li> <li>El LLM juez responde con una calificación o etiqueta que registras en tu herramienta de observabilidad.</li>",hl,We,Da="Ejemplo de Langfuse:",Il,Be,Ka='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/evaluator-template.png" alt="Plantilla de Evaluación LLM-como-Juez"/> <img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/evaluator.png" alt="Evaluador LLM-como-Juez"/>',Zl,Ee,vl,Ge,Oa="Puedes ver que la respuesta de este ejemplo se juzga como “no tóxica”.",Vl,Re,es='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/llm-as-a-judge-score.png" alt="Puntuación de Evaluación LLM-como-Juez"/>',Wl,ke,Bl,$e,ts="Todas estas métricas pueden visualizarse juntas en paneles. Esto te permite ver rápidamente cómo se desempeña tu agente a través de muchas sesiones y te ayuda a seguir las métricas de calidad a lo largo del tiempo.",El,Ne,ls='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/langfuse-dashboard.png" alt="Resumen de métricas de observabilidad"/>',Gl,xe,Rl,Ae,as="La evaluación en línea es esencial para la retroalimentación en vivo, pero también necesitas <strong>evaluación fuera de línea</strong>—verificaciones sistemáticas antes o durante el desarrollo. Esto ayuda a mantener la calidad y fiabilidad antes de implementar cambios en producción.",kl,Ye,$l,Qe,ss="En la evaluación fuera de línea, típicamente:",Nl,_e,ns="<li>Tienes un conjunto de datos de referencia (con pares de prompt y salida esperada)</li> <li>Ejecutas tu agente en ese conjunto de datos</li> <li>Comparas las salidas con los resultados esperados o utilizas un mecanismo de puntuación adicional</li>",xl,He,is='A continuación, demostramos este enfoque con el <a href="https://huggingface.co/datasets/gsm8k" rel="nofollow">conjunto de datos GSM8K</a>, que contiene preguntas matemáticas y soluciones.',Al,Xe,Yl,Le,os="A continuación, creamos una entidad de conjunto de datos en Langfuse para rastrear las ejecuciones. Luego, agregamos cada elemento del conjunto de datos al sistema. (Si no estás utilizando Langfuse, podrías simplemente almacenar estos en tu propia base de datos o archivo local para análisis).",Ql,Se,_l,Fe,Hl,ze,rs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/example-dataset.png" alt="Elementos del conjunto de datos en Langfuse"/>',Xl,qe,Ll,Pe,Ms="Definimos una función auxiliar <code>run_smolagent()</code> que:",Sl,De,ps="<li>Inicia un span de OpenTelemetry</li> <li>Ejecuta nuestro agente en el prompt</li> <li>Registra el ID de traza en Langfuse</li>",Fl,Ke,us="Luego, recorremos cada elemento del conjunto de datos, ejecutamos el agente y vinculamos el rastro al elemento del conjunto de datos. También podemos adjuntar una puntuación de evaluación rápida si lo deseamos.",zl,Oe,ql,et,Pl,tt,cs="Puedes repetir este proceso con diferentes:",Dl,lt,ms="<li>Modelos (OpenAI GPT, LLM local, etc.)</li> <li>Herramientas (búsqueda vs. sin búsqueda)</li> <li>Prompts (diferentes mensajes de sistema)</li>",Kl,at,ds="Luego compararlos lado a lado en tu herramienta de observabilidad:",Ol,st,ys='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/dataset_runs.png" alt="Resumen de ejecución del conjunto de datos"/> <img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/dataset-run-comparison.png" alt="Comparación de ejecución del conjunto de datos"/>',ea,nt,ta,it,js="En este notebook, cubrimos cómo:",la,ot,Us="<li><strong>Configurar la Observabilidad</strong> usando smolagents + exportadores OpenTelemetry</li> <li><strong>Verificar la Instrumentación</strong> ejecutando un agente simple</li> <li><strong>Capturar Métricas Detalladas</strong> (costo, latencia, etc.) a través de herramientas de observabilidad</li> <li><strong>Recopilar Retroalimentación del Usuario</strong> a través de una interfaz Gradio</li> <li><strong>Usar LLM-como-Juez</strong> para evaluar automáticamente las salidas</li> <li><strong>Realizar Evaluación Fuera de Línea</strong> con un conjunto de datos de referencia</li>",aa,rt,Js="🤗 ¡Feliz programación!",sa,Mt,na,ut,ia;return T=new vs({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https://huggingface.co/agents-course/notebooks/blob/main/bonus-unit2/monitoring-and-evaluating-agents.ipynb"}]}}),b=new Zs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new y({props:{title:"Unidad Extra 2: Observabilidad y Evaluación de Agentes",local:"unidad-extra-2-observabilidad-y-evaluación-de-agentes",headingTag:"h1"}}),h=new y({props:{title:"Requisitos del Ejercicio 🏗️",local:"requisitos-del-ejercicio-",headingTag:"h2"}}),V=new y({props:{title:"Paso 0: Instalar las Librerías Necesarias",local:"paso-0-instalar-las-librerías-necesarias",headingTag:"h2"}}),B=new j({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCdGVsZW1ldHJ5JTVEJyUwQSUyNXBpcCUyMGluc3RhbGwlMjBvcGVudGVsZW1ldHJ5LXNkayUyMG9wZW50ZWxlbWV0cnktZXhwb3J0ZXItb3RscCUyMG9wZW5pbmZlcmVuY2UtaW5zdHJ1bWVudGF0aW9uLXNtb2xhZ2VudHMlMEElMjVwaXAlMjBpbnN0YWxsJTIwbGFuZ2Z1c2UlMjBkYXRhc2V0cyUyMCdzbW9sYWdlbnRzJTVCZ3JhZGlvJTVEJw==",highlighted:`%pip install <span class="hljs-string">&#x27;smolagents[telemetry]&#x27;</span>
%pip install opentelemetry-sdk opentelemetry-exporter-otlp openinference-instrumentation-smolagents
%pip install langfuse datasets <span class="hljs-string">&#x27;smolagents[gradio]&#x27;</span>`,wrap:!1}}),E=new y({props:{title:"Paso 1: Instrumentar tu Agente",local:"paso-1-instrumentar-tu-agente",headingTag:"h2"}}),$=new j({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjBiYXNlNjQlMEElMEElMjMlMjBPYnQlQzMlQTluJTIwdHVzJTIwcHJvcGlhcyUyMGNsYXZlcyUyMGRlc2RlJTIwaHR0cHMlM0ElMkYlMkZjbG91ZC5sYW5nZnVzZS5jb20lMEFMQU5HRlVTRV9QVUJMSUNfS0VZJTIwJTNEJTIwJTNEJTIwJTIycGstbGYtLi4uJTIyJTIwJTBBTEFOR0ZVU0VfU0VDUkVUX0tFWSUyMCUzRCUyMCUyMnNrLWxmLS4uLiUyMiUyMCUwQW9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9QVUJMSUNfS0VZJTIyJTVEJTIwJTNEJTIwTEFOR0ZVU0VfUFVCTElDX0tFWSUwQW9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9TRUNSRVRfS0VZJTIyJTVEJTIwJTNEJTIwTEFOR0ZVU0VfU0VDUkVUX0tFWSUwQW9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZjbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjAlMjMlMjAlRjAlOUYlODclQUElRjAlOUYlODclQkElMjBlamVtcGxvJTIwZGUlMjByZWdpJUMzJUIzbiUyMEVVJTBBJTIzJTIwb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX0hPU1QlMjIlNUQlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnVzLmNsb3VkLmxhbmdmdXNlLmNvbSUyMiUyMCUyMCUyMyUyMCVGMCU5RiU4NyVCQSVGMCU5RiU4NyVCOCUyMGVqZW1wbG8lMjBkZSUyMHJlZ2klQzMlQjNuJTIwVVMlMEElMEFMQU5HRlVTRV9BVVRIJTIwJTNEJTIwYmFzZTY0LmI2NGVuY29kZSglMEElMjAlMjAlMjAlMjBmJTIyJTdCTEFOR0ZVU0VfUFVCTElDX0tFWSU3RCUzQSU3QkxBTkdGVVNFX1NFQ1JFVF9LRVklN0QlMjIuZW5jb2RlKCklMEEpLmRlY29kZSgpJTBBJTBBb3MuZW52aXJvbiU1QiUyMk9URUxfRVhQT1JURVJfT1RMUF9FTkRQT0lOVCUyMiU1RCUyMCUzRCUyMG9zLmVudmlyb24uZ2V0KCUyMkxBTkdGVVNFX0hPU1QlMjIpJTIwJTJCJTIwJTIyJTJGYXBpJTJGcHVibGljJTJGb3RlbCUyMiUwQW9zLmVudmlyb24lNUIlMjJPVEVMX0VYUE9SVEVSX09UTFBfSEVBREVSUyUyMiU1RCUyMCUzRCUyMGYlMjJBdXRob3JpemF0aW9uJTNEQmFzaWMlMjAlN0JMQU5HRlVTRV9BVVRIJTdEJTIy",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> base64

<span class="hljs-comment"># Obtén tus propias claves desde https://cloud.langfuse.com</span>
LANGFUSE_PUBLIC_KEY = = <span class="hljs-string">&quot;pk-lf-...&quot;</span> 
LANGFUSE_SECRET_KEY = <span class="hljs-string">&quot;sk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_PUBLIC_KEY&quot;</span>] = LANGFUSE_PUBLIC_KEY
os.environ[<span class="hljs-string">&quot;LANGFUSE_SECRET_KEY&quot;</span>] = LANGFUSE_SECRET_KEY
os.environ[<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>] = <span class="hljs-string">&quot;https://cloud.langfuse.com&quot;</span>  <span class="hljs-comment"># 🇪🇺 ejemplo de región EU</span>
<span class="hljs-comment"># os.environ[&quot;LANGFUSE_HOST&quot;] = &quot;https://us.cloud.langfuse.com&quot;  # 🇺🇸 ejemplo de región US</span>

LANGFUSE_AUTH = base64.b64encode(
    <span class="hljs-string">f&quot;<span class="hljs-subst">{LANGFUSE_PUBLIC_KEY}</span>:<span class="hljs-subst">{LANGFUSE_SECRET_KEY}</span>&quot;</span>.encode()
).decode()

os.environ[<span class="hljs-string">&quot;OTEL_EXPORTER_OTLP_ENDPOINT&quot;</span>] = os.environ.get(<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>) + <span class="hljs-string">&quot;/api/public/otel&quot;</span>
os.environ[<span class="hljs-string">&quot;OTEL_EXPORTER_OTLP_HEADERS&quot;</span>] = <span class="hljs-string">f&quot;Authorization=Basic <span class="hljs-subst">{LANGFUSE_AUTH}</span>&quot;</span>`,wrap:!1}}),x=new j({props:{code:"JTIzJTIwQ29uZmlndXJhJTIwdHUlMjB0b2tlbiUyMGRlJTIwSHVnZ2luZyUyMEZhY2UlMjB5JTIwb3Ryb3MlMjB0b2tlbnMlMkZzZWNyZXRvcyUyMGNvbW8lMjB2YXJpYWJsZXMlMjBkZSUyMGVudG9ybm8lMEFvcy5lbnZpcm9uJTVCJTIySEZfVE9LRU4lMjIlNUQlMjAlM0QlMjAlMjJoZl8uLi4lMjIlMjA=",highlighted:`<span class="hljs-comment"># Configura tu token de Hugging Face y otros tokens/secretos como variables de entorno</span>
os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>] = <span class="hljs-string">&quot;hf_...&quot;</span> `,wrap:!1}}),Y=new j({props:{code:"ZnJvbSUyMG9wZW50ZWxlbWV0cnkuc2RrLnRyYWNlJTIwaW1wb3J0JTIwVHJhY2VyUHJvdmlkZXIlMEFmcm9tJTIwb3BlbmluZmVyZW5jZS5pbnN0cnVtZW50YXRpb24uc21vbGFnZW50cyUyMGltcG9ydCUyMFNtb2xhZ2VudHNJbnN0cnVtZW50b3IlMEFmcm9tJTIwb3BlbnRlbGVtZXRyeS5leHBvcnRlci5vdGxwLnByb3RvLmh0dHAudHJhY2VfZXhwb3J0ZXIlMjBpbXBvcnQlMjBPVExQU3BhbkV4cG9ydGVyJTBBZnJvbSUyMG9wZW50ZWxlbWV0cnkuc2RrLnRyYWNlLmV4cG9ydCUyMGltcG9ydCUyMFNpbXBsZVNwYW5Qcm9jZXNzb3IlMEElMjAlMEElMjMlMjBDcmVhciUyMHVuJTIwVHJhY2VyUHJvdmlkZXIlMjBwYXJhJTIwT3BlblRlbGVtZXRyeSUwQXRyYWNlX3Byb3ZpZGVyJTIwJTNEJTIwVHJhY2VyUHJvdmlkZXIoKSUwQSUwQSUyMyUyMEElQzMlQjFhZGlyJTIwdW4lMjBTaW1wbGVTcGFuUHJvY2Vzc29yJTIwY29uJTIwZWwlMjBPVExQU3BhbkV4cG9ydGVyJTIwcGFyYSUyMGVudmlhciUyMHRyYXpvc3MlMEF0cmFjZV9wcm92aWRlci5hZGRfc3Bhbl9wcm9jZXNzb3IoU2ltcGxlU3BhblByb2Nlc3NvcihPVExQU3BhbkV4cG9ydGVyKCkpKSUwQSUwQSUyMyUyMEVzdGFibGVjZXIlMjBlbCUyMHByb3ZlZWRvciUyMGRlJTIwdHJhemFzJTIwcHJlZGV0ZXJtaW5hZG8lMjBnbG9iYWwlMEFmcm9tJTIwb3BlbnRlbGVtZXRyeSUyMGltcG9ydCUyMHRyYWNlJTBBdHJhY2Uuc2V0X3RyYWNlcl9wcm92aWRlcih0cmFjZV9wcm92aWRlciklMEF0cmFjZXIlMjAlM0QlMjB0cmFjZS5nZXRfdHJhY2VyKF9fbmFtZV9fKSUwQSUwQSUyMyUyMEluc3RydW1lbnRhciUyMHNtb2xhZ2VudHMlMjBjb24lMjBlbCUyMHByb3ZlZWRvciUyMGNvbmZpZ3VyYWRvJTBBU21vbGFnZW50c0luc3RydW1lbnRvcigpLmluc3RydW1lbnQodHJhY2VyX3Byb3ZpZGVyJTNEdHJhY2VfcHJvdmlkZXIp",highlighted:`<span class="hljs-keyword">from</span> opentelemetry.sdk.trace <span class="hljs-keyword">import</span> TracerProvider
<span class="hljs-keyword">from</span> openinference.instrumentation.smolagents <span class="hljs-keyword">import</span> SmolagentsInstrumentor
<span class="hljs-keyword">from</span> opentelemetry.exporter.otlp.proto.http.trace_exporter <span class="hljs-keyword">import</span> OTLPSpanExporter
<span class="hljs-keyword">from</span> opentelemetry.sdk.trace.export <span class="hljs-keyword">import</span> SimpleSpanProcessor
 
<span class="hljs-comment"># Crear un TracerProvider para OpenTelemetry</span>
trace_provider = TracerProvider()

<span class="hljs-comment"># Añadir un SimpleSpanProcessor con el OTLPSpanExporter para enviar trazoss</span>
trace_provider.add_span_processor(SimpleSpanProcessor(OTLPSpanExporter()))

<span class="hljs-comment"># Establecer el proveedor de trazas predeterminado global</span>
<span class="hljs-keyword">from</span> opentelemetry <span class="hljs-keyword">import</span> trace
trace.set_tracer_provider(trace_provider)
tracer = trace.get_tracer(__name__)

<span class="hljs-comment"># Instrumentar smolagents con el proveedor configurado</span>
SmolagentsInstrumentor().instrument(tracer_provider=trace_provider)`,wrap:!1}}),Q=new y({props:{title:"Paso 2: Probar tu Instrumentación",local:"paso-2-probar-tu-instrumentación",headingTag:"h2"}}),H=new j({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQSUyMyUyMENyZWFyJTIwdW4lMjBhZ2VudGUlMjBzaW1wbGUlMjBwYXJhJTIwcHJvYmFyJTIwbGElMjBpbnN0cnVtZW50YWNpJUMzJUIzbiUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTBBKSUwQSUwQWFnZW50LnJ1biglMjIxJTJCMSUzRCUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-comment"># Crear un agente simple para probar la instrumentación</span>
agent = CodeAgent(
    tools=[],
    model=InferenceClientModel()
)

agent.run(<span class="hljs-string">&quot;1+1=&quot;</span>)`,wrap:!1}}),z=new y({props:{title:"Paso 3: Observar y Evaluar un Agente Más Complejo",local:"paso-3-observar-y-evaluar-un-agente-más-complejo",headingTag:"h2"}}),P=new j({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCklMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QnNlYXJjaF90b29sJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpKSUwQSUwQWFnZW50LnJ1biglMjIlQzIlQkZDdSVDMyVBMW50b3MlMjBjdWJvcyUyMGRlJTIwUnViaWslMjBwb2RyJUMzJUFEYXMlMjBtZXRlciUyMGRlbnRybyUyMGRlJTIwbGElMjBDYXRlZHJhbCUyMGRlJTIwTm90cmUlMjBEYW1lJTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(tools=[search_tool], model=InferenceClientModel())

agent.run(<span class="hljs-string">&quot;¿Cuántos cubos de Rubik podrías meter dentro de la Catedral de Notre Dame?&quot;</span>)`,wrap:!1}}),D=new y({props:{title:"Estructura de Rastros",local:"estructura-de-rastros",headingTag:"h3"}}),ae=new y({props:{title:"Evaluación en Línea",local:"evaluación-en-línea",headingTag:"h2"}}),ne=new y({props:{title:"Métricas Comunes para Seguir en Producción",local:"métricas-comunes-para-seguir-en-producción",headingTag:"h3"}}),re=new y({props:{title:"1. Costos",local:"1-costos",headingTag:"h4"}}),ce=new y({props:{title:"2. Latencia",local:"2-latencia",headingTag:"h4"}}),je=new y({props:{title:"3. Atributos Adicionales",local:"3-atributos-adicionales",headingTag:"h4"}}),Je=new j({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCklMEFmcm9tJTIwb3BlbnRlbGVtZXRyeSUyMGltcG9ydCUyMHRyYWNlJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCgpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJzZWFyY2hfdG9vbCU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUwQSklMEElMEF3aXRoJTIwdHJhY2VyLnN0YXJ0X2FzX2N1cnJlbnRfc3BhbiglMjJTbW9sYWdlbnQtVHJhY2UlMjIpJTIwYXMlMjBzcGFuJTNBJTBBJTIwJTIwJTIwJTIwc3Bhbi5zZXRfYXR0cmlidXRlKCUyMmxhbmdmdXNlLnVzZXIuaWQlMjIlMkMlMjAlMjJzbW9sYWdlbnQtdXNlci0xMjMlMjIpJTBBJTIwJTIwJTIwJTIwc3Bhbi5zZXRfYXR0cmlidXRlKCUyMmxhbmdmdXNlLnNlc3Npb24uaWQlMjIlMkMlMjAlMjJzbW9sYWdlbnQtc2Vzc2lvbi0xMjM0NTY3ODklMjIpJTBBJTIwJTIwJTIwJTIwc3Bhbi5zZXRfYXR0cmlidXRlKCUyMmxhbmdmdXNlLnRhZ3MlMjIlMkMlMjAlNUIlMjJjaXR5LXF1ZXN0aW9uJTIyJTJDJTIwJTIydGVzdGluZy1hZ2VudHMlMjIlNUQpJTBBJTBBJTIwJTIwJTIwJTIwYWdlbnQucnVuKCUyMiVDMiVCRkN1JUMzJUExbCUyMGVzJTIwbGElMjBjYXBpdGFsJTIwZGUlMjBBbGVtYW5pYSUzRiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)
<span class="hljs-keyword">from</span> opentelemetry <span class="hljs-keyword">import</span> trace

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(
    tools=[search_tool],
    model=InferenceClientModel()
)

<span class="hljs-keyword">with</span> tracer.start_as_current_span(<span class="hljs-string">&quot;Smolagent-Trace&quot;</span>) <span class="hljs-keyword">as</span> span:
    span.set_attribute(<span class="hljs-string">&quot;langfuse.user.id&quot;</span>, <span class="hljs-string">&quot;smolagent-user-123&quot;</span>)
    span.set_attribute(<span class="hljs-string">&quot;langfuse.session.id&quot;</span>, <span class="hljs-string">&quot;smolagent-session-123456789&quot;</span>)
    span.set_attribute(<span class="hljs-string">&quot;langfuse.tags&quot;</span>, [<span class="hljs-string">&quot;city-question&quot;</span>, <span class="hljs-string">&quot;testing-agents&quot;</span>])

    agent.run(<span class="hljs-string">&quot;¿Cuál es la capital de Alemania?&quot;</span>)`,wrap:!1}}),be=new y({props:{title:"4. Retroalimentación del Usuario",local:"4-retroalimentación-del-usuario",headingTag:"h4"}}),fe=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> opentelemetry.trace <span class="hljs-keyword">import</span> format_trace_id
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, InferenceClientModel)
<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> Langfuse

langfuse = Langfuse()
model = InferenceClientModel()
agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)

formatted_trace_id = <span class="hljs-literal">None</span>  <span class="hljs-comment"># Almacenaremos el trace_id actual globalmente para demostración</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">respond</span>(<span class="hljs-params">prompt, history</span>):
    <span class="hljs-keyword">with</span> trace.get_tracer(__name__).start_as_current_span(<span class="hljs-string">&quot;Smolagent-Trace&quot;</span>) <span class="hljs-keyword">as</span> span:
        output = agent.run(prompt)

        current_span = trace.get_current_span()
        span_context = current_span.get_span_context()
        trace_id = span_context.trace_id
        <span class="hljs-keyword">global</span> formatted_trace_id
        formatted_trace_id = <span class="hljs-built_in">str</span>(format_trace_id(trace_id))
        langfuse.trace(<span class="hljs-built_in">id</span>=formatted_trace_id, <span class="hljs-built_in">input</span>=prompt, output=output)

    history.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-built_in">str</span>(output)})
    <span class="hljs-keyword">return</span> history

<span class="hljs-keyword">def</span> <span class="hljs-title function_">handle_like</span>(<span class="hljs-params">data: gr.LikeData</span>):
    <span class="hljs-comment"># Para demostración, mapeamos la retroalimentación del usuario a un 1 (me gusta) o 0 (no me gusta)</span>
    <span class="hljs-keyword">if</span> data.liked:
        langfuse.score(
            value=<span class="hljs-number">1</span>,
            name=<span class="hljs-string">&quot;user-feedback&quot;</span>,
            trace_id=formatted_trace_id
        )
    <span class="hljs-keyword">else</span>:
        langfuse.score(
            value=<span class="hljs-number">0</span>,
            name=<span class="hljs-string">&quot;user-feedback&quot;</span>,
            trace_id=formatted_trace_id
        )

<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    chatbot = gr.Chatbot(label=<span class="hljs-string">&quot;Chat&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>)
    prompt_box = gr.Textbox(placeholder=<span class="hljs-string">&quot;Escribe tu mensaje...&quot;</span>, label=<span class="hljs-string">&quot;Tu mensaje&quot;</span>)

    <span class="hljs-comment"># Cuando el usuario presiona &#x27;Enter&#x27; en el prompt, ejecutamos &#x27;respond&#x27;</span>
    prompt_box.submit(
        fn=respond,
        inputs=[prompt_box, chatbot],
        outputs=chatbot
    )

    <span class="hljs-comment"># Cuando el usuario hace clic en un botón de &#x27;me gusta&#x27; en un mensaje, ejecutamos &#x27;handle_like&#x27;</span>
    chatbot.like(handle_like, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>)

demo.launch()
`,wrap:!1}}),Ie=new y({props:{title:"5. LLM-como-Juez",local:"5-llm-como-juez",headingTag:"h4"}}),Ee=new j({props:{code:"JTIzJTIwRWplbXBsbyUzQSUyMFZlcmlmaWNhciUyMHNpJTIwbGElMjBzYWxpZGElMjBkZWwlMjBhZ2VudGUlMjBlcyUyMHQlQzMlQjN4aWNhJTIwbyUyMG5vLiUwQWZyb20lMjBzbW9sYWdlbnRzJTIwaW1wb3J0JTIwKENvZGVBZ2VudCUyQyUyMER1Y2tEdWNrR29TZWFyY2hUb29sJTJDJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwpJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCgpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUJzZWFyY2hfdG9vbCU1RCUyQyUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoKSklMEElMEFhZ2VudC5ydW4oJTIyJUMyJUJGUHVlZGUlMjBjb21lciUyMHphbmFob3JpYXMlMjBtZWpvcmFyJTIwdHUlMjB2aXNpJUMzJUIzbiUzRiUyMik=",highlighted:`<span class="hljs-comment"># Ejemplo: Verificar si la salida del agente es tóxica o no.</span>
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(tools=[search_tool], model=InferenceClientModel())

agent.run(<span class="hljs-string">&quot;¿Puede comer zanahorias mejorar tu visión?&quot;</span>)`,wrap:!1}}),ke=new y({props:{title:"6. Resumen de Métricas de Observabilidad",local:"6-resumen-de-métricas-de-observabilidad",headingTag:"h4"}}),xe=new y({props:{title:"Evaluación fuera de línea",local:"evaluación-fuera-de-línea",headingTag:"h2"}}),Ye=new y({props:{title:"Evaluación con Conjuntos de Datos",local:"evaluación-con-conjuntos-de-datos",headingTag:"h3"}}),Xe=new j({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQSUyMyUyME9idGVuZXIlMjBHU004SyUyMGRlc2RlJTIwSHVnZ2luZyUyMEZhY2UlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMm9wZW5haSUyRmdzbThrJTIyJTJDJTIwJ21haW4nJTJDJTIwc3BsaXQlM0QndHJhaW4nKSUwQWRmJTIwJTNEJTIwcGQuRGF0YUZyYW1lKGRhdGFzZXQpJTBBcHJpbnQoJTIyUHJpbWVyYXMlMjBmaWxhcyUyMGRlbCUyMGNvbmp1bnRvJTIwZGUlMjBkYXRvcyUyMEdTTThLJTNBJTIyKSUwQXByaW50KGRmLmhlYWQoKSk=",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Obtener GSM8K desde Hugging Face</span>
dataset = load_dataset(<span class="hljs-string">&quot;openai/gsm8k&quot;</span>, <span class="hljs-string">&#x27;main&#x27;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>)
df = pd.DataFrame(dataset)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Primeras filas del conjunto de datos GSM8K:&quot;</span>)
<span class="hljs-built_in">print</span>(df.head())`,wrap:!1}}),Se=new j({props:{code:"ZnJvbSUyMGxhbmdmdXNlJTIwaW1wb3J0JTIwTGFuZ2Z1c2UlMEFsYW5nZnVzZSUyMCUzRCUyMExhbmdmdXNlKCklMEElMEFsYW5nZnVzZV9kYXRhc2V0X25hbWUlMjAlM0QlMjAlMjJnc204a19kYXRhc2V0X2h1Z2dpbmdmYWNlJTIyJTBBJTBBJTIzJTIwQ3JlYXIlMjB1biUyMGNvbmp1bnRvJTIwZGUlMjBkYXRvcyUyMGVuJTIwTGFuZ2Z1c2UlMEFsYW5nZnVzZS5jcmVhdGVfZGF0YXNldCglMEElMjAlMjAlMjAlMjBuYW1lJTNEbGFuZ2Z1c2VfZGF0YXNldF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJDb25qdW50byUyMGRlJTIwZGF0b3MlMjBkZSUyMHJlZmVyZW5jaWElMjBHU004SyUyMGNhcmdhZG8lMjBkZXNkZSUyMEh1Z2dpbmdmYWNlJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWV0YWRhdGElM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkYXRlJTIyJTNBJTIwJTIyMjAyNS0wMy0xMCUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJiZW5jaG1hcmslMjIlMEElMjAlMjAlMjAlMjAlN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> Langfuse
langfuse = Langfuse()

langfuse_dataset_name = <span class="hljs-string">&quot;gsm8k_dataset_huggingface&quot;</span>

<span class="hljs-comment"># Crear un conjunto de datos en Langfuse</span>
langfuse.create_dataset(
    name=langfuse_dataset_name,
    description=<span class="hljs-string">&quot;Conjunto de datos de referencia GSM8K cargado desde Huggingface&quot;</span>,
    metadata={
        <span class="hljs-string">&quot;date&quot;</span>: <span class="hljs-string">&quot;2025-03-10&quot;</span>, 
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;benchmark&quot;</span>
    }
)`,wrap:!1}}),Fe=new j({props:{code:"Zm9yJTIwaWR4JTJDJTIwcm93JTIwaW4lMjBkZi5pdGVycm93cygpJTNBJTBBJTIwJTIwJTIwJTIwbGFuZ2Z1c2UuY3JlYXRlX2RhdGFzZXRfaXRlbSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhc2V0X25hbWUlM0RsYW5nZnVzZV9kYXRhc2V0X25hbWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dCUzRCU3QiUyMnRleHQlMjIlM0ElMjByb3clNUIlMjJxdWVzdGlvbiUyMiU1RCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4cGVjdGVkX291dHB1dCUzRCU3QiUyMnRleHQlMjIlM0ElMjByb3clNUIlMjJhbnN3ZXIlMjIlNUQlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZV9pbmRleCUyMiUzQSUyMGlkeCU3RCUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBpZiUyMGlkeCUyMCUzRSUzRCUyMDklM0ElMjAlMjMlMjBDYXJnYXIlMjBzb2xvJTIwbG9zJTIwcHJpbWVyb3MlMjAxMCUyMGVsZW1lbnRvcyUyMHBhcmElMjBkZW1vc3RyYWNpJUMzJUIzbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-keyword">for</span> idx, row <span class="hljs-keyword">in</span> df.iterrows():
    langfuse.create_dataset_item(
        dataset_name=langfuse_dataset_name,
        <span class="hljs-built_in">input</span>={<span class="hljs-string">&quot;text&quot;</span>: row[<span class="hljs-string">&quot;question&quot;</span>]},
        expected_output={<span class="hljs-string">&quot;text&quot;</span>: row[<span class="hljs-string">&quot;answer&quot;</span>]},
        metadata={<span class="hljs-string">&quot;source_index&quot;</span>: idx}
    )
    <span class="hljs-keyword">if</span> idx &gt;= <span class="hljs-number">9</span>: <span class="hljs-comment"># Cargar solo los primeros 10 elementos para demostración</span>
        <span class="hljs-keyword">break</span>`,wrap:!1}}),qe=new y({props:{title:"Ejecutando el Agente en el Conjunto de Datos",local:"ejecutando-el-agente-en-el-conjunto-de-datos",headingTag:"h4"}}),Oe=new j({props:{code:"ZnJvbSUyMG9wZW50ZWxlbWV0cnkudHJhY2UlMjBpbXBvcnQlMjBmb3JtYXRfdHJhY2VfaWQlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMChDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMExpdGVMTE1Nb2RlbCklMEElMEElMjMlMjBFamVtcGxvJTNBJTIwdXNhbmRvJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwlMjBvJTIwTGl0ZUxMTU1vZGVsJTIwcGFyYSUyMGFjY2VkZXIlMjBhJTIwbW9kZWxvcyUyMGRlJTIwb3BlbmFpJTJDJTIwYW50aHJvcGljJTJDJTIwZ2VtaW5pJTJDJTIwZXRjLiUzQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSUwQSklMEElMEFkZWYlMjBydW5fc21vbGFnZW50KHF1ZXN0aW9uKSUzQSUwQSUyMCUyMCUyMCUyMHdpdGglMjB0cmFjZXIuc3RhcnRfYXNfY3VycmVudF9zcGFuKCUyMlNtb2xhZ2VudC1UcmFjZSUyMiklMjBhcyUyMHNwYW4lM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGFuLnNldF9hdHRyaWJ1dGUoJTIybGFuZ2Z1c2UudGFnJTIyJTJDJTIwJTIyZGF0YXNldC1ydW4lMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwYWdlbnQucnVuKHF1ZXN0aW9uKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGN1cnJlbnRfc3BhbiUyMCUzRCUyMHRyYWNlLmdldF9jdXJyZW50X3NwYW4oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwYW5fY29udGV4dCUyMCUzRCUyMGN1cnJlbnRfc3Bhbi5nZXRfc3Bhbl9jb250ZXh0KCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFjZV9pZCUyMCUzRCUyMHNwYW5fY29udGV4dC50cmFjZV9pZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvcm1hdHRlZF90cmFjZV9pZCUyMCUzRCUyMGZvcm1hdF90cmFjZV9pZCh0cmFjZV9pZCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYW5nZnVzZV90cmFjZSUyMCUzRCUyMGxhbmdmdXNlLnRyYWNlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlkJTNEZm9ybWF0dGVkX3RyYWNlX2lkJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXQlM0RxdWVzdGlvbiUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dCUzRG91dHB1dCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBsYW5nZnVzZV90cmFjZSUyQyUyMG91dHB1dA==",highlighted:`<span class="hljs-keyword">from</span> opentelemetry.trace <span class="hljs-keyword">import</span> format_trace_id
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, InferenceClientModel, LiteLLMModel)

<span class="hljs-comment"># Ejemplo: usando InferenceClientModel o LiteLLMModel para acceder a modelos de openai, anthropic, gemini, etc.:</span>
model = InferenceClientModel()

agent = CodeAgent(
    tools=[],
    model=model,
    add_base_tools=<span class="hljs-literal">True</span>
)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_smolagent</span>(<span class="hljs-params">question</span>):
    <span class="hljs-keyword">with</span> tracer.start_as_current_span(<span class="hljs-string">&quot;Smolagent-Trace&quot;</span>) <span class="hljs-keyword">as</span> span:
        span.set_attribute(<span class="hljs-string">&quot;langfuse.tag&quot;</span>, <span class="hljs-string">&quot;dataset-run&quot;</span>)
        output = agent.run(question)

        current_span = trace.get_current_span()
        span_context = current_span.get_span_context()
        trace_id = span_context.trace_id
        formatted_trace_id = format_trace_id(trace_id)

        langfuse_trace = langfuse.trace(
            <span class="hljs-built_in">id</span>=formatted_trace_id, 
            <span class="hljs-built_in">input</span>=question, 
            output=output
        )
    <span class="hljs-keyword">return</span> langfuse_trace, output`,wrap:!1}}),et=new j({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxhbmdmdXNlLmdldF9kYXRhc2V0KGxhbmdmdXNlX2RhdGFzZXRfbmFtZSklMEElMEElMjMlMjBFamVjdXRhciUyMG51ZXN0cm8lMjBhZ2VudGUlMjBjb250cmElMjBjYWRhJTIwZWxlbWVudG8lMjBkZWwlMjBjb25qdW50byUyMGRlJTIwZGF0b3MlMjAobGltaXRhZG8lMjBhJTIwbG9zJTIwcHJpbWVyb3MlMjAxMCUyMGFycmliYSklMEFmb3IlMjBpdGVtJTIwaW4lMjBkYXRhc2V0Lml0ZW1zJTNBJTBBJTIwJTIwJTIwJTIwbGFuZ2Z1c2VfdHJhY2UlMkMlMjBvdXRwdXQlMjAlM0QlMjBydW5fc21vbGFnZW50KGl0ZW0uaW5wdXQlNUIlMjJ0ZXh0JTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFZpbmN1bGFyJTIwbGElMjB0cmF6YSUyMGFsJTIwZWxlbWVudG8lMjBkZWwlMjBjb25qdW50byUyMGRlJTIwZGF0b3MlMjBwYXJhJTIwYW4lQzMlQTFsaXNpcyUwQSUyMCUyMCUyMCUyMGl0ZW0ubGluayglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYW5nZnVzZV90cmFjZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJ1bl9uYW1lJTNEJTIyc21vbGFnZW50LW5vdGVib29rLXJ1bi0wMSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJ1bl9tZXRhZGF0YSUzRCU3QiUyMCUyMm1vZGVsJTIyJTNBJTIwbW9kZWwubW9kZWxfaWQlMjAlN0QlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwT3BjaW9uYWxtZW50ZSUyQyUyMGFsbWFjZW5hciUyMHVuYSUyMHB1bnR1YWNpJUMzJUIzbiUyMGRlJTIwZXZhbHVhY2klQzMlQjNuJTIwciVDMyVBMXBpZGElMjBwYXJhJTIwZGVtb3N0cmFjaSVDMyVCM24lMEElMjAlMjAlMjAlMjBsYW5nZnVzZV90cmFjZS5zY29yZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNEJTIyJTNDZXhhbXBsZV9ldmFsJTNFJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmFsdWUlM0QxJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29tbWVudCUzRCUyMkVzdGUlMjBlcyUyMHVuJTIwY29tZW50YXJpbyUyMiUwQSUyMCUyMCUyMCUyMCklMEElMEElMjMlMjBWYWNpYXIlMjBkYXRvcyUyMHBhcmElMjBhc2VndXJhciUyMHF1ZSUyMHRvZGElMjBsYSUyMHRlbGVtZXRyJUMzJUFEYSUyMHNlYSUyMGVudmlhZGElMEFsYW5nZnVzZS5mbHVzaCgp",highlighted:`dataset = langfuse.get_dataset(langfuse_dataset_name)

<span class="hljs-comment"># Ejecutar nuestro agente contra cada elemento del conjunto de datos (limitado a los primeros 10 arriba)</span>
<span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> dataset.items:
    langfuse_trace, output = run_smolagent(item.<span class="hljs-built_in">input</span>[<span class="hljs-string">&quot;text&quot;</span>])

    <span class="hljs-comment"># Vincular la traza al elemento del conjunto de datos para análisis</span>
    item.link(
        langfuse_trace,
        run_name=<span class="hljs-string">&quot;smolagent-notebook-run-01&quot;</span>,
        run_metadata={ <span class="hljs-string">&quot;model&quot;</span>: model.model_id }
    )

    <span class="hljs-comment"># Opcionalmente, almacenar una puntuación de evaluación rápida para demostración</span>
    langfuse_trace.score(
        name=<span class="hljs-string">&quot;&lt;example_eval&gt;&quot;</span>,
        value=<span class="hljs-number">1</span>,
        comment=<span class="hljs-string">&quot;Este es un comentario&quot;</span>
    )

<span class="hljs-comment"># Vaciar datos para asegurar que toda la telemetría sea enviada</span>
langfuse.flush()`,wrap:!1}}),nt=new y({props:{title:"Consideraciones Finales",local:"consideraciones-finales",headingTag:"h2"}}),Mt=new Vs({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/es/bonus-unit2/monitoring-and-evaluating-agents-notebook.mdx"}}),{c(){U=i("meta"),ct=s(),pt=i("p"),mt=s(),M(T.$$.fragment),dt=s(),M(b.$$.fragment),yt=s(),M(w.$$.fragment),jt=s(),J=i("blockquote"),J.innerHTML=Ma,Ut=s(),C=i("p"),C.innerHTML=pa,Jt=s(),f=i("p"),f.textContent=ua,Tt=s(),g=i("ul"),g.innerHTML=ca,bt=s(),M(h.$$.fragment),wt=s(),I=i("p"),I.textContent=ma,Ct=s(),Z=i("p"),Z.innerHTML=da,ft=s(),v=i("p"),v.innerHTML=ya,gt=s(),M(V.$$.fragment),ht=s(),W=i("p"),W.textContent=ja,It=s(),M(B.$$.fragment),Zt=s(),M(E.$$.fragment),vt=s(),G=i("p"),G.innerHTML=Ua,Vt=s(),R=i("p"),R.innerHTML=Ja,Wt=s(),k=i("p"),k.textContent=Ta,Bt=s(),M($.$$.fragment),Et=s(),N=i("p"),N.textContent=ba,Gt=s(),M(x.$$.fragment),Rt=s(),A=i("p"),A.textContent=wa,kt=s(),M(Y.$$.fragment),$t=s(),M(Q.$$.fragment),Nt=s(),_=i("p"),_.innerHTML=Ca,xt=s(),M(H.$$.fragment),At=s(),X=i("p"),X.innerHTML=fa,Yt=s(),L=i("p"),L.textContent=ga,Qt=s(),S=i("p"),S.innerHTML=ha,_t=s(),F=i("p"),F.innerHTML=Ia,Ht=s(),M(z.$$.fragment),Xt=s(),q=i("p"),q.textContent=Za,Lt=s(),M(P.$$.fragment),St=s(),M(D.$$.fragment),Ft=s(),K=i("p"),K.innerHTML=va,zt=s(),O=i("ul"),O.innerHTML=Va,qt=s(),ee=i("p"),ee.textContent=Wa,Pt=s(),te=i("p"),te.innerHTML=Ba,Dt=s(),le=i("p"),le.innerHTML=Ea,Kt=s(),M(ae.$$.fragment),Ot=s(),se=i("p"),se.textContent=Ga,el=s(),M(ne.$$.fragment),tl=s(),ie=i("ol"),ie.innerHTML=Ra,ll=s(),oe=i("p"),oe.textContent=ka,al=s(),M(re.$$.fragment),sl=s(),Me=i("p"),Me.innerHTML=$a,nl=s(),pe=i("p"),pe.innerHTML=Na,il=s(),ue=i("p"),ue.innerHTML=xa,ol=s(),M(ce.$$.fragment),rl=s(),me=i("p"),me.textContent=Aa,Ml=s(),de=i("p"),de.innerHTML=Ya,pl=s(),ye=i("p"),ye.innerHTML=Qa,ul=s(),M(je.$$.fragment),cl=s(),Ue=i("p"),Ue.innerHTML=_a,ml=s(),M(Je.$$.fragment),dl=s(),Te=i("p"),Te.innerHTML=Ha,yl=s(),M(be.$$.fragment),jl=s(),we=i("p"),we.innerHTML=Xa,Ul=s(),Ce=i("p"),Ce.textContent=La,Jl=s(),M(fe.$$.fragment),Tl=s(),ge=i("p"),ge.textContent=Sa,bl=s(),he=i("p"),he.innerHTML=Fa,wl=s(),M(Ie.$$.fragment),Cl=s(),Ze=i("p"),Ze.textContent=za,fl=s(),ve=i("p"),ve.innerHTML=qa,gl=s(),Ve=i("ol"),Ve.innerHTML=Pa,hl=s(),We=i("p"),We.textContent=Da,Il=s(),Be=i("p"),Be.innerHTML=Ka,Zl=s(),M(Ee.$$.fragment),vl=s(),Ge=i("p"),Ge.textContent=Oa,Vl=s(),Re=i("p"),Re.innerHTML=es,Wl=s(),M(ke.$$.fragment),Bl=s(),$e=i("p"),$e.textContent=ts,El=s(),Ne=i("p"),Ne.innerHTML=ls,Gl=s(),M(xe.$$.fragment),Rl=s(),Ae=i("p"),Ae.innerHTML=as,kl=s(),M(Ye.$$.fragment),$l=s(),Qe=i("p"),Qe.textContent=ss,Nl=s(),_e=i("ol"),_e.innerHTML=ns,xl=s(),He=i("p"),He.innerHTML=is,Al=s(),M(Xe.$$.fragment),Yl=s(),Le=i("p"),Le.textContent=os,Ql=s(),M(Se.$$.fragment),_l=s(),M(Fe.$$.fragment),Hl=s(),ze=i("p"),ze.innerHTML=rs,Xl=s(),M(qe.$$.fragment),Ll=s(),Pe=i("p"),Pe.innerHTML=Ms,Sl=s(),De=i("ol"),De.innerHTML=ps,Fl=s(),Ke=i("p"),Ke.textContent=us,zl=s(),M(Oe.$$.fragment),ql=s(),M(et.$$.fragment),Pl=s(),tt=i("p"),tt.textContent=cs,Dl=s(),lt=i("ul"),lt.innerHTML=ms,Kl=s(),at=i("p"),at.textContent=ds,Ol=s(),st=i("p"),st.innerHTML=ys,ea=s(),M(nt.$$.fragment),ta=s(),it=i("p"),it.textContent=js,la=s(),ot=i("ol"),ot.innerHTML=Us,aa=s(),rt=i("p"),rt.textContent=Js,sa=s(),M(Mt.$$.fragment),na=s(),ut=i("p"),this.h()},l(e){const t=hs("svelte-u9bgzb",document.head);U=o(t,"META",{name:!0,content:!0}),t.forEach(l),ct=n(e),pt=o(e,"P",{}),Ts(pt).forEach(l),mt=n(e),p(T.$$.fragment,e),dt=n(e),p(b.$$.fragment,e),yt=n(e),p(w.$$.fragment,e),jt=n(e),J=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-1kd3o88"&&(J.innerHTML=Ma),Ut=n(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-udjbaf"&&(C.innerHTML=pa),Jt=n(e),f=o(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-g6j46l"&&(f.textContent=ua),Tt=n(e),g=o(e,"UL",{"data-svelte-h":!0}),r(g)!=="svelte-1x3sj8f"&&(g.innerHTML=ca),bt=n(e),p(h.$$.fragment,e),wt=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-177txu9"&&(I.textContent=ma),Ct=n(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1t3gp2v"&&(Z.innerHTML=da),ft=n(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-7if8bz"&&(v.innerHTML=ya),gt=n(e),p(V.$$.fragment,e),ht=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-ir9osj"&&(W.textContent=ja),It=n(e),p(B.$$.fragment,e),Zt=n(e),p(E.$$.fragment,e),vt=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1kzuma7"&&(G.innerHTML=Ua),Vt=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-xmw502"&&(R.innerHTML=Ja),Wt=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1wrmoiy"&&(k.textContent=Ta),Bt=n(e),p($.$$.fragment,e),Et=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-hqvkfd"&&(N.textContent=ba),Gt=n(e),p(x.$$.fragment,e),Rt=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1uh5xe8"&&(A.textContent=wa),kt=n(e),p(Y.$$.fragment,e),$t=n(e),p(Q.$$.fragment,e),Nt=n(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1ttfubs"&&(_.innerHTML=Ca),xt=n(e),p(H.$$.fragment,e),At=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-kb9mpv"&&(X.innerHTML=fa),Yt=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-92grbp"&&(L.textContent=ga),Qt=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-opeu5l"&&(S.innerHTML=ha),_t=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1cgbonm"&&(F.innerHTML=Ia),Ht=n(e),p(z.$$.fragment,e),Xt=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1dl64zz"&&(q.textContent=Za),Lt=n(e),p(P.$$.fragment,e),St=n(e),p(D.$$.fragment,e),Ft=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-i6j7qc"&&(K.innerHTML=va),zt=n(e),O=o(e,"UL",{"data-svelte-h":!0}),r(O)!=="svelte-13uhxnr"&&(O.innerHTML=Va),qt=n(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1g7qson"&&(ee.textContent=Wa),Pt=n(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1fch75q"&&(te.innerHTML=Ba),Dt=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-12lduh0"&&(le.innerHTML=Ea),Kt=n(e),p(ae.$$.fragment,e),Ot=n(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-oaz0jq"&&(se.textContent=Ga),el=n(e),p(ne.$$.fragment,e),tl=n(e),ie=o(e,"OL",{"data-svelte-h":!0}),r(ie)!=="svelte-1439457"&&(ie.innerHTML=Ra),ll=n(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-103zbnc"&&(oe.textContent=ka),al=n(e),p(re.$$.fragment,e),sl=n(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1v993j1"&&(Me.innerHTML=$a),nl=n(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-36dk7q"&&(pe.innerHTML=Na),il=n(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-12lduh0"&&(ue.innerHTML=xa),ol=n(e),p(ce.$$.fragment,e),rl=n(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-we2rt6"&&(me.textContent=Aa),Ml=n(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-nhz3gc"&&(de.innerHTML=Ya),pl=n(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-12lduh0"&&(ye.innerHTML=Qa),ul=n(e),p(je.$$.fragment,e),cl=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1emttgu"&&(Ue.innerHTML=_a),ml=n(e),p(Je.$$.fragment,e),dl=n(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-ihgll6"&&(Te.innerHTML=Ha),yl=n(e),p(be.$$.fragment,e),jl=n(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-10sp8fd"&&(we.innerHTML=Xa),Ul=n(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-jf76gk"&&(Ce.textContent=La),Jl=n(e),p(fe.$$.fragment,e),Tl=n(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-zsstgn"&&(ge.textContent=Sa),bl=n(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-ta5ta1"&&(he.innerHTML=Fa),wl=n(e),p(Ie.$$.fragment,e),Cl=n(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1cjte1i"&&(Ze.textContent=za),fl=n(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1lgmmid"&&(ve.innerHTML=qa),gl=n(e),Ve=o(e,"OL",{"data-svelte-h":!0}),r(Ve)!=="svelte-1rbh0nf"&&(Ve.innerHTML=Pa),hl=n(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-aqwlqk"&&(We.textContent=Da),Il=n(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-15ug6nt"&&(Be.innerHTML=Ka),Zl=n(e),p(Ee.$$.fragment,e),vl=n(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1wwhvdi"&&(Ge.textContent=Oa),Vl=n(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1fi06xz"&&(Re.innerHTML=es),Wl=n(e),p(ke.$$.fragment,e),Bl=n(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1o474o1"&&($e.textContent=ts),El=n(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-18bjtnr"&&(Ne.innerHTML=ls),Gl=n(e),p(xe.$$.fragment,e),Rl=n(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-k35our"&&(Ae.innerHTML=as),kl=n(e),p(Ye.$$.fragment,e),$l=n(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1gktbt3"&&(Qe.textContent=ss),Nl=n(e),_e=o(e,"OL",{"data-svelte-h":!0}),r(_e)!=="svelte-14rstmo"&&(_e.innerHTML=ns),xl=n(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-sj9u9y"&&(He.innerHTML=is),Al=n(e),p(Xe.$$.fragment,e),Yl=n(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-xji3kb"&&(Le.textContent=os),Ql=n(e),p(Se.$$.fragment,e),_l=n(e),p(Fe.$$.fragment,e),Hl=n(e),ze=o(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-11f0115"&&(ze.innerHTML=rs),Xl=n(e),p(qe.$$.fragment,e),Ll=n(e),Pe=o(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-9ctqha"&&(Pe.innerHTML=Ms),Sl=n(e),De=o(e,"OL",{"data-svelte-h":!0}),r(De)!=="svelte-13wgpt6"&&(De.innerHTML=ps),Fl=n(e),Ke=o(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-90ofcd"&&(Ke.textContent=us),zl=n(e),p(Oe.$$.fragment,e),ql=n(e),p(et.$$.fragment,e),Pl=n(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-14t08r2"&&(tt.textContent=cs),Dl=n(e),lt=o(e,"UL",{"data-svelte-h":!0}),r(lt)!=="svelte-cdo50l"&&(lt.innerHTML=ms),Kl=n(e),at=o(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-ul4a9c"&&(at.textContent=ds),Ol=n(e),st=o(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1yiuof6"&&(st.innerHTML=ys),ea=n(e),p(nt.$$.fragment,e),ta=n(e),it=o(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-rq6osp"&&(it.textContent=js),la=n(e),ot=o(e,"OL",{"data-svelte-h":!0}),r(ot)!=="svelte-vs0ox2"&&(ot.innerHTML=Us),aa=n(e),rt=o(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-1rhdw2l"&&(rt.textContent=Js),sa=n(e),p(Mt.$$.fragment,e),na=n(e),ut=o(e,"P",{}),Ts(ut).forEach(l),this.h()},h(){oa(U,"name","hf:doc:metadata"),oa(U,"content",Bs),oa(J,"class","tip")},m(e,t){Is(document.head,U),a(e,ct,t),a(e,pt,t),a(e,mt,t),u(T,e,t),a(e,dt,t),u(b,e,t),a(e,yt,t),u(w,e,t),a(e,jt,t),a(e,J,t),a(e,Ut,t),a(e,C,t),a(e,Jt,t),a(e,f,t),a(e,Tt,t),a(e,g,t),a(e,bt,t),u(h,e,t),a(e,wt,t),a(e,I,t),a(e,Ct,t),a(e,Z,t),a(e,ft,t),a(e,v,t),a(e,gt,t),u(V,e,t),a(e,ht,t),a(e,W,t),a(e,It,t),u(B,e,t),a(e,Zt,t),u(E,e,t),a(e,vt,t),a(e,G,t),a(e,Vt,t),a(e,R,t),a(e,Wt,t),a(e,k,t),a(e,Bt,t),u($,e,t),a(e,Et,t),a(e,N,t),a(e,Gt,t),u(x,e,t),a(e,Rt,t),a(e,A,t),a(e,kt,t),u(Y,e,t),a(e,$t,t),u(Q,e,t),a(e,Nt,t),a(e,_,t),a(e,xt,t),u(H,e,t),a(e,At,t),a(e,X,t),a(e,Yt,t),a(e,L,t),a(e,Qt,t),a(e,S,t),a(e,_t,t),a(e,F,t),a(e,Ht,t),u(z,e,t),a(e,Xt,t),a(e,q,t),a(e,Lt,t),u(P,e,t),a(e,St,t),u(D,e,t),a(e,Ft,t),a(e,K,t),a(e,zt,t),a(e,O,t),a(e,qt,t),a(e,ee,t),a(e,Pt,t),a(e,te,t),a(e,Dt,t),a(e,le,t),a(e,Kt,t),u(ae,e,t),a(e,Ot,t),a(e,se,t),a(e,el,t),u(ne,e,t),a(e,tl,t),a(e,ie,t),a(e,ll,t),a(e,oe,t),a(e,al,t),u(re,e,t),a(e,sl,t),a(e,Me,t),a(e,nl,t),a(e,pe,t),a(e,il,t),a(e,ue,t),a(e,ol,t),u(ce,e,t),a(e,rl,t),a(e,me,t),a(e,Ml,t),a(e,de,t),a(e,pl,t),a(e,ye,t),a(e,ul,t),u(je,e,t),a(e,cl,t),a(e,Ue,t),a(e,ml,t),u(Je,e,t),a(e,dl,t),a(e,Te,t),a(e,yl,t),u(be,e,t),a(e,jl,t),a(e,we,t),a(e,Ul,t),a(e,Ce,t),a(e,Jl,t),u(fe,e,t),a(e,Tl,t),a(e,ge,t),a(e,bl,t),a(e,he,t),a(e,wl,t),u(Ie,e,t),a(e,Cl,t),a(e,Ze,t),a(e,fl,t),a(e,ve,t),a(e,gl,t),a(e,Ve,t),a(e,hl,t),a(e,We,t),a(e,Il,t),a(e,Be,t),a(e,Zl,t),u(Ee,e,t),a(e,vl,t),a(e,Ge,t),a(e,Vl,t),a(e,Re,t),a(e,Wl,t),u(ke,e,t),a(e,Bl,t),a(e,$e,t),a(e,El,t),a(e,Ne,t),a(e,Gl,t),u(xe,e,t),a(e,Rl,t),a(e,Ae,t),a(e,kl,t),u(Ye,e,t),a(e,$l,t),a(e,Qe,t),a(e,Nl,t),a(e,_e,t),a(e,xl,t),a(e,He,t),a(e,Al,t),u(Xe,e,t),a(e,Yl,t),a(e,Le,t),a(e,Ql,t),u(Se,e,t),a(e,_l,t),u(Fe,e,t),a(e,Hl,t),a(e,ze,t),a(e,Xl,t),u(qe,e,t),a(e,Ll,t),a(e,Pe,t),a(e,Sl,t),a(e,De,t),a(e,Fl,t),a(e,Ke,t),a(e,zl,t),u(Oe,e,t),a(e,ql,t),u(et,e,t),a(e,Pl,t),a(e,tt,t),a(e,Dl,t),a(e,lt,t),a(e,Kl,t),a(e,at,t),a(e,Ol,t),a(e,st,t),a(e,ea,t),u(nt,e,t),a(e,ta,t),a(e,it,t),a(e,la,t),a(e,ot,t),a(e,aa,t),a(e,rt,t),a(e,sa,t),u(Mt,e,t),a(e,na,t),a(e,ut,t),ia=!0},p:ws,i(e){ia||(c(T.$$.fragment,e),c(b.$$.fragment,e),c(w.$$.fragment,e),c(h.$$.fragment,e),c(V.$$.fragment,e),c(B.$$.fragment,e),c(E.$$.fragment,e),c($.$$.fragment,e),c(x.$$.fragment,e),c(Y.$$.fragment,e),c(Q.$$.fragment,e),c(H.$$.fragment,e),c(z.$$.fragment,e),c(P.$$.fragment,e),c(D.$$.fragment,e),c(ae.$$.fragment,e),c(ne.$$.fragment,e),c(re.$$.fragment,e),c(ce.$$.fragment,e),c(je.$$.fragment,e),c(Je.$$.fragment,e),c(be.$$.fragment,e),c(fe.$$.fragment,e),c(Ie.$$.fragment,e),c(Ee.$$.fragment,e),c(ke.$$.fragment,e),c(xe.$$.fragment,e),c(Ye.$$.fragment,e),c(Xe.$$.fragment,e),c(Se.$$.fragment,e),c(Fe.$$.fragment,e),c(qe.$$.fragment,e),c(Oe.$$.fragment,e),c(et.$$.fragment,e),c(nt.$$.fragment,e),c(Mt.$$.fragment,e),ia=!0)},o(e){m(T.$$.fragment,e),m(b.$$.fragment,e),m(w.$$.fragment,e),m(h.$$.fragment,e),m(V.$$.fragment,e),m(B.$$.fragment,e),m(E.$$.fragment,e),m($.$$.fragment,e),m(x.$$.fragment,e),m(Y.$$.fragment,e),m(Q.$$.fragment,e),m(H.$$.fragment,e),m(z.$$.fragment,e),m(P.$$.fragment,e),m(D.$$.fragment,e),m(ae.$$.fragment,e),m(ne.$$.fragment,e),m(re.$$.fragment,e),m(ce.$$.fragment,e),m(je.$$.fragment,e),m(Je.$$.fragment,e),m(be.$$.fragment,e),m(fe.$$.fragment,e),m(Ie.$$.fragment,e),m(Ee.$$.fragment,e),m(ke.$$.fragment,e),m(xe.$$.fragment,e),m(Ye.$$.fragment,e),m(Xe.$$.fragment,e),m(Se.$$.fragment,e),m(Fe.$$.fragment,e),m(qe.$$.fragment,e),m(Oe.$$.fragment,e),m(et.$$.fragment,e),m(nt.$$.fragment,e),m(Mt.$$.fragment,e),ia=!1},d(e){e&&(l(ct),l(pt),l(mt),l(dt),l(yt),l(jt),l(J),l(Ut),l(C),l(Jt),l(f),l(Tt),l(g),l(bt),l(wt),l(I),l(Ct),l(Z),l(ft),l(v),l(gt),l(ht),l(W),l(It),l(Zt),l(vt),l(G),l(Vt),l(R),l(Wt),l(k),l(Bt),l(Et),l(N),l(Gt),l(Rt),l(A),l(kt),l($t),l(Nt),l(_),l(xt),l(At),l(X),l(Yt),l(L),l(Qt),l(S),l(_t),l(F),l(Ht),l(Xt),l(q),l(Lt),l(St),l(Ft),l(K),l(zt),l(O),l(qt),l(ee),l(Pt),l(te),l(Dt),l(le),l(Kt),l(Ot),l(se),l(el),l(tl),l(ie),l(ll),l(oe),l(al),l(sl),l(Me),l(nl),l(pe),l(il),l(ue),l(ol),l(rl),l(me),l(Ml),l(de),l(pl),l(ye),l(ul),l(cl),l(Ue),l(ml),l(dl),l(Te),l(yl),l(jl),l(we),l(Ul),l(Ce),l(Jl),l(Tl),l(ge),l(bl),l(he),l(wl),l(Cl),l(Ze),l(fl),l(ve),l(gl),l(Ve),l(hl),l(We),l(Il),l(Be),l(Zl),l(vl),l(Ge),l(Vl),l(Re),l(Wl),l(Bl),l($e),l(El),l(Ne),l(Gl),l(Rl),l(Ae),l(kl),l($l),l(Qe),l(Nl),l(_e),l(xl),l(He),l(Al),l(Yl),l(Le),l(Ql),l(_l),l(Hl),l(ze),l(Xl),l(Ll),l(Pe),l(Sl),l(De),l(Fl),l(Ke),l(zl),l(ql),l(Pl),l(tt),l(Dl),l(lt),l(Kl),l(at),l(Ol),l(st),l(ea),l(ta),l(it),l(la),l(ot),l(aa),l(rt),l(sa),l(na),l(ut)),l(U),d(T,e),d(b,e),d(w,e),d(h,e),d(V,e),d(B,e),d(E,e),d($,e),d(x,e),d(Y,e),d(Q,e),d(H,e),d(z,e),d(P,e),d(D,e),d(ae,e),d(ne,e),d(re,e),d(ce,e),d(je,e),d(Je,e),d(be,e),d(fe,e),d(Ie,e),d(Ee,e),d(ke,e),d(xe,e),d(Ye,e),d(Xe,e),d(Se,e),d(Fe,e),d(qe,e),d(Oe,e),d(et,e),d(nt,e),d(Mt,e)}}}const Bs='{"title":"Unidad Extra 2: Observabilidad y Evaluación de Agentes","local":"unidad-extra-2-observabilidad-y-evaluación-de-agentes","sections":[{"title":"Requisitos del Ejercicio 🏗️","local":"requisitos-del-ejercicio-","sections":[],"depth":2},{"title":"Paso 0: Instalar las Librerías Necesarias","local":"paso-0-instalar-las-librerías-necesarias","sections":[],"depth":2},{"title":"Paso 1: Instrumentar tu Agente","local":"paso-1-instrumentar-tu-agente","sections":[],"depth":2},{"title":"Paso 2: Probar tu Instrumentación","local":"paso-2-probar-tu-instrumentación","sections":[],"depth":2},{"title":"Paso 3: Observar y Evaluar un Agente Más Complejo","local":"paso-3-observar-y-evaluar-un-agente-más-complejo","sections":[{"title":"Estructura de Rastros","local":"estructura-de-rastros","sections":[],"depth":3}],"depth":2},{"title":"Evaluación en Línea","local":"evaluación-en-línea","sections":[{"title":"Métricas Comunes para Seguir en Producción","local":"métricas-comunes-para-seguir-en-producción","sections":[{"title":"1. Costos","local":"1-costos","sections":[],"depth":4},{"title":"2. Latencia","local":"2-latencia","sections":[],"depth":4},{"title":"3. Atributos Adicionales","local":"3-atributos-adicionales","sections":[],"depth":4},{"title":"4. Retroalimentación del Usuario","local":"4-retroalimentación-del-usuario","sections":[],"depth":4},{"title":"5. LLM-como-Juez","local":"5-llm-como-juez","sections":[],"depth":4},{"title":"6. Resumen de Métricas de Observabilidad","local":"6-resumen-de-métricas-de-observabilidad","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Evaluación fuera de línea","local":"evaluación-fuera-de-línea","sections":[{"title":"Evaluación con Conjuntos de Datos","local":"evaluación-con-conjuntos-de-datos","sections":[{"title":"Ejecutando el Agente en el Conjunto de Datos","local":"ejecutando-el-agente-en-el-conjunto-de-datos","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Consideraciones Finales","local":"consideraciones-finales","sections":[],"depth":2}],"depth":1}';function Es(ra){return Cs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ys extends fs{constructor(U){super(),gs(this,U,Es,Ws,bs,{})}}export{Ys as component};
