import{s as Fe,n as _e,o as qe}from"../chunks/scheduler.505acc25.js";import{S as He,i as Le,e as M,s as n,c as y,h as De,a as i,d as s,b as a,f as Re,g as o,j as p,k as je,l as Pe,m as t,n as J,t as r,o as U,p as u}from"../chunks/index.b1175496.js";import{C as Ke,H as j}from"../chunks/Heading.988e52fa.js";import{C as T}from"../chunks/CodeBlock.ed64aebc.js";import{E as Oe}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.3d47a398.js";function ls(Te){let w,Tl,ul,wl,c,dl,m,cl,I,we="Alfred à votre service. En tant que majordome de confiance de M. Wayne, j’ai pris la liberté de documenter comment j’aide M. Wayne avec ses divers besoins documentaires. Pendant qu’il s’occupe de ses… activités nocturnes, je m’assure que tous ses papiers, programmes d’entraînement et plans nutritionnels sont correctement analysés et organisés.",ml,C,de="Avant de partir, il a laissé une note avec son programme d’entraînement de la semaine. J’ai alors pris la responsabilité de proposer un <strong>menu</strong> pour les repas de demain.",Il,b,ce="Pour de futurs événements similaires, créons un système d’analyse de documents utilisant LangGraph pour servir les besoins de M. Wayne. Ce système peut :",Cl,h,me="<li>Traiter des documents sous forme d’image</li> <li>Extraire du texte en utilisant des modèles de vision (<em>Vision Language Model</em>)</li> <li>Effectuer des calculs quand nécessaire (pour démontrer l’utilisation d’outils normaux)</li> <li>Analyser le contenu et fournir des résumés concis</li> <li>Exécuter des instructions spécifiques liées aux documents</li>",bl,B,hl,g,Ie="Le <em>workflow</em> que nous allons construire suit ce schéma structuré :",Bl,Z,Ce='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/alfred_flow.png" alt="Butler&#39;s Document Analysis Workflow"/>',gl,d,be='<p>Vous pouvez suivre le code dans <a href="https://huggingface.co/agents-course/notebooks/blob/main/fr/unit2/langgraph/agent.ipynb" target="_blank">ce <i>notebook</i></a> que vous pouvez exécuter avec Google Colab.</p>',Zl,A,Al,G,Gl,f,he="et les imports :",fl,W,Wl,V,Vl,x,Be=`Cet état est un peu plus complexe que les précédents que nous avons vus.
<code>AnyMessage</code> est une classe de LangChain qui définit les messages, et <code>add_messages</code> est un opérateur qui ajoute le dernier message plutôt que de l’écraser avec le dernier état.`,xl,v,ge="C’est un nouveau concept dans LangGraph, où vous pouvez ajouter des opérateurs dans votre état pour définir la façon dont ils doivent interagir ensemble.",vl,X,Xl,$,$l,k,kl,z,zl,E,El,Y,Yl,Q,Ze="Permettez-moi d’expliquer l’approche dans cet agent. L’agent suit ce qu’on appelle le modèle <em>ReAct</em> (<em>Reason-Act-Observe</em>)",Ql,S,Ae="<li><strong>Réfléchir</strong> sur ses documents et demandes</li> <li><strong>Agir</strong> en utilisant les outils appropriés</li> <li><strong>Observer</strong> les résultats</li> <li><strong>Répéter</strong> si nécessaire jusqu’à ce que j’aie pleinement répondu à ses besoins</li>",Sl,N,Ge="C’est une implémentation simple d’un agent utilisant LangGraph.",Nl,R,Rl,F,fe=`Nous définissons un nœud <code>tools</code> avec notre liste d’outils. Le nœud <code>assistant</code> est juste notre modèle avec les outils liés.
Nous créons un graphe avec les nœuds <code>assistant</code> et <code>tools</code>.`,Fl,_,We="Nous ajoutons une arête <code>tools_condition</code>, qui route vers <code>End</code> ou vers <code>tools</code> selon que l’<code>assistant</code> appelle un outil.",_l,q,Ve="Maintenant, nous ajoutons une nouvelle étape :",ql,H,xe="Nous connectons le nœud <code>tools</code> de retour à l’<code>assistant</code>, formant une boucle.",Hl,L,ve="<li>Après l’exécution du nœud <code>assistant</code>, <code>tools_condition</code> vérifie si la sortie du modèle est un appel d’outil.</li> <li>Si c’est un appel d’outil, le flux est dirigé vers le nœud <code>tools</code>.</li> <li>Le nœud <code>tools</code> se reconnecte à <code>assistant</code>.</li> <li>Cette boucle continue tant que le modèle décide d’appeler des outils.</li> <li>Si la réponse du modèle n’est pas un appel d’outil, le flux est dirigé vers <em>END</em>, terminant le processus.</li>",Ll,D,Xe='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/Agent.png" alt="ReAct Pattern"/>',Dl,P,Pl,K,Kl,O,$e="Voici un exemple pour montrer un cas d’usage simple d’un agent utilisant un outil dans LangGraph.",Ol,ll,le,el,ke="La conversation se déroulerait :",ee,sl,se,tl,te,nl,ze="Quand Maître Wayne laisse ses notes d’entraînement et de repas :",ne,al,ae,Ml,Ee="L’interaction se déroulerait :",Me,il,ie,pl,pe,yl,Ye="Si vous souhaitez créer votre propre majordome d’analyse de documents, voici les considérations clés :",ye,ol,Qe="<li><strong>Définir des outils clairs</strong> pour des tâches spécifiques liées aux documents</li> <li><strong>Créer un suivi d’état robuste</strong> pour maintenir le contexte entre les appels d’outils</li> <li><strong>Considérer la gestion d’erreurs</strong> pour les échecs d’outils</li> <li><strong>Maintenir la conscience contextuelle</strong> des interactions précédentes (assurée par l’opérateur <code>add_messages</code>)</li>",oe,Jl,Se="Avec ces principes, vous pouvez vous aussi fournir un service d’analyse de documents exemplaire digne du manoir Wayne.",Je,rl,Ne="<em>J’espère que cette explication a été satisfaisante. Maintenant, si vous voulez bien m’excuser, la cape de Maître Wayne nécessite un repassage avant les activités de ce soir.</em>",re,Ul,Ue,jl,ue;return c=new Ke({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),m=new j({props:{title:"Graphe d’analyse de documents",local:"graphe-danalyse-de-documents",headingTag:"h1"}}),B=new j({props:{title:"Le workflow du majordome",local:"le-workflow-du-majordome",headingTag:"h2"}}),A=new j({props:{title:"Configuration de l’environnement",local:"configuration-de-lenvironnement",headingTag:"h2"}}),G=new T({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdncmFwaCUyMGxhbmdjaGFpbl9vcGVuYWklMjBsYW5nY2hhaW5fY29yZQ==",highlighted:"%pip install langgraph langchain_openai langchain_core",wrap:!1}}),W=new T({props:{code:"aW1wb3J0JTIwYmFzZTY0JTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMExpc3QlMkMlMjBUeXBlZERpY3QlMkMlMjBBbm5vdGF0ZWQlMkMlMjBPcHRpb25hbCUwQWZyb20lMjBsYW5nY2hhaW5fb3BlbmFpJTIwaW1wb3J0JTIwQ2hhdE9wZW5BSSUwQWZyb20lMjBsYW5nY2hhaW5fY29yZS5tZXNzYWdlcyUyMGltcG9ydCUyMEFueU1lc3NhZ2UlMkMlMjBTeXN0ZW1NZXNzYWdlJTJDJTIwSHVtYW5NZXNzYWdlJTBBZnJvbSUyMGxhbmdncmFwaC5ncmFwaC5tZXNzYWdlJTIwaW1wb3J0JTIwYWRkX21lc3NhZ2VzJTBBZnJvbSUyMGxhbmdncmFwaC5ncmFwaCUyMGltcG9ydCUyMFNUQVJUJTJDJTIwU3RhdGVHcmFwaCUwQWZyb20lMjBsYW5nZ3JhcGgucHJlYnVpbHQlMjBpbXBvcnQlMjBUb29sTm9kZSUyQyUyMHRvb2xzX2NvbmRpdGlvbiUwQWZyb20lMjBJUHl0aG9uLmRpc3BsYXklMjBpbXBvcnQlMjBJbWFnZSUyQyUyMGRpc3BsYXk=",highlighted:`<span class="hljs-keyword">import</span> base64
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>, TypedDict, Annotated, <span class="hljs-type">Optional</span>
<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI
<span class="hljs-keyword">from</span> langchain_core.messages <span class="hljs-keyword">import</span> AnyMessage, SystemMessage, HumanMessage
<span class="hljs-keyword">from</span> langgraph.graph.message <span class="hljs-keyword">import</span> add_messages
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> START, StateGraph
<span class="hljs-keyword">from</span> langgraph.prebuilt <span class="hljs-keyword">import</span> ToolNode, tools_condition
<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Image, display`,wrap:!1}}),V=new j({props:{title:"Définir l’état de l’agent",local:"définir-létat-de-lagent",headingTag:"h2"}}),X=new T({props:{code:"Y2xhc3MlMjBBZ2VudFN0YXRlKFR5cGVkRGljdCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBMZSUyMGRvY3VtZW50JTIwZm91cm5pJTBBJTIwJTIwJTIwJTIwaW5wdXRfZmlsZSUzQSUyME9wdGlvbmFsJTVCc3RyJTVEJTIwJTIwJTIzJTIwQ29udGllbnQlMjBsZSUyMGNoZW1pbiUyMGR1JTIwZmljaGllciUyMChQREYlMkZQTkcpJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0ElMjBBbm5vdGF0ZWQlNUJsaXN0JTVCQW55TWVzc2FnZSU1RCUyQyUyMGFkZF9tZXNzYWdlcyU1RA==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">AgentState</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    <span class="hljs-comment"># Le document fourni</span>
    input_file: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]  <span class="hljs-comment"># Contient le chemin du fichier (PDF/PNG)</span>
    messages: Annotated[<span class="hljs-built_in">list</span>[AnyMessage], add_messages]`,wrap:!1}}),$=new j({props:{title:"Préparer les outils",local:"préparer-les-outils",headingTag:"h2"}}),k=new T({props:{code:"dmlzaW9uX2xsbSUyMCUzRCUyMENoYXRPcGVuQUkobW9kZWwlM0QlMjJncHQtNG8lMjIpJTBBJTBBZGVmJTIwZXh0cmFjdF90ZXh0KGltZ19wYXRoJTNBJTIwc3RyKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBFeHRyYWlyZSUyMGxlJTIwdGV4dGUlMjBkJ3VuJTIwZmljaGllciUyMGltYWdlJTIwZW4lMjB1dGlsaXNhbnQlMjB1biUyMG1vZCVDMyVBOGxlJTIwbXVsdGltb2RhbC4lMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBNYSVDMyVBRXRyZSUyMFdheW5lJTIwbGFpc3NlJTIwc291dmVudCUyMGRlcyUyMG5vdGVzJTIwYXZlYyUyMHNvbiUyMHIlQzMlQTlnaW1lJTIwZCdlbnRyYSVDMyVBRW5lbWVudCUyMG91JTIwc2VzJTIwcGxhbnMlMjBkZSUyMHJlcGFzLiUwQSUyMCUyMCUyMCUyMENlbGElMjBtZSUyMHBlcm1ldCUyMGQnYW5hbHlzZXIlMjBjb3JyZWN0ZW1lbnQlMjBsZSUyMGNvbnRlbnUuJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwYWxsX3RleHQlMjAlM0QlMjAlMjIlMjIlMEElMjAlMjAlMjAlMjB0cnklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBMaXJlJTIwbCdpbWFnZSUyMGV0JTIwZW5jb2RlciUyMGVuJTIwYmFzZTY0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2l0aCUyMG9wZW4oaW1nX3BhdGglMkMlMjAlMjJyYiUyMiklMjBhcyUyMGltYWdlX2ZpbGUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZV9ieXRlcyUyMCUzRCUyMGltYWdlX2ZpbGUucmVhZCgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1hZ2VfYmFzZTY0JTIwJTNEJTIwYmFzZTY0LmI2NGVuY29kZShpbWFnZV9ieXRlcykuZGVjb2RlKCUyMnV0Zi04JTIyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFByJUMzJUE5cGFyZXIlMjBsZSUyMHByb21wdCUyMGluY2x1YW50JTIwbGVzJTIwZG9ubiVDMyVBOWVzJTIwZCdpbWFnZSUyMGJhc2U2NCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1lc3NhZ2UlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBIdW1hbk1lc3NhZ2UoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29udGVudCUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGV4dCUyMiUzQSUyMCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJFeHRyYXlleiUyMHRvdXQlMjBsZSUyMHRleHRlJTIwZGUlMjBjZXR0ZSUyMGltYWdlLiUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlJldG91cm5leiUyMHNldWxlbWVudCUyMGxlJTIwdGV4dGUlMjBleHRyYWl0JTJDJTIwc2FucyUyMGV4cGxpY2F0aW9ucy4lMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmltYWdlX3VybCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmltYWdlX3VybCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVybCUyMiUzQSUyMGYlMjJkYXRhJTNBaW1hZ2UlMkZwbmclM0JiYXNlNjQlMkMlN0JpbWFnZV9iYXNlNjQlN0QlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwQXBwZWxlciUyMGxlJTIwVkxNJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjB2aXNpb25fbGxtLmludm9rZShtZXNzYWdlKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEFqb3V0ZXIlMjBsZSUyMHRleHRlJTIwZXh0cmFpdCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFsbF90ZXh0JTIwJTJCJTNEJTIwcmVzcG9uc2UuY29udGVudCUyMCUyQiUyMCUyMiU1Q24lNUNuJTIyJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwYWxsX3RleHQuc3RyaXAoKSUwQSUyMCUyMCUyMCUyMGV4Y2VwdCUyMEV4Y2VwdGlvbiUyMGFzJTIwZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFVuJTIwbWFqb3Jkb21lJTIwZG9pdCUyMGclQzMlQTlyZXIlMjBsZXMlMjBlcnJldXJzJTIwYXZlYyUyMCVDMyVBOWwlQzMlQTlnYW5jZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVycm9yX21zZyUyMCUzRCUyMGYlMjJFcnJldXIlMjBsb3JzJTIwZGUlMjBsJ2V4dHJhY3Rpb24lMjBkdSUyMHRleHRlJTIwJTNBJTIwJTdCc3RyKGUpJTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZXJyb3JfbXNnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMiUyMiUwQSUwQWRlZiUyMGRpdmlkZShhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCklMjAtJTNFJTIwZmxvYXQlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJEaXZpc2VyJTIwYSUyMGV0JTIwYiUyMC0lMjBwb3VyJTIwbGVzJTIwY2FsY3VscyUyMG9jY2FzaW9ubmVscyUyMGRlJTIwTWElQzMlQUV0cmUlMjBXYXluZS4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBhJTIwJTJGJTIwYiUwQSUwQSUyMyUyMCVDMyU4OXF1aXBlciUyMGxlJTIwbWFqb3Jkb21lJTIwYXZlYyUyMGRlcyUyMG91dGlscyUwQXRvb2xzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwZGl2aWRlJTJDJTBBJTIwJTIwJTIwJTIwZXh0cmFjdF90ZXh0JTBBJTVEJTBBJTBBbGxtJTIwJTNEJTIwQ2hhdE9wZW5BSShtb2RlbCUzRCUyMmdwdC00byUyMiklMEFsbG1fd2l0aF90b29scyUyMCUzRCUyMGxsbS5iaW5kX3Rvb2xzKHRvb2xzJTJDJTIwcGFyYWxsZWxfdG9vbF9jYWxscyUzREZhbHNlKQ==",highlighted:`vision_llm = ChatOpenAI(model=<span class="hljs-string">&quot;gpt-4o&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_text</span>(<span class="hljs-params">img_path: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Extraire le texte d&#x27;un fichier image en utilisant un modèle multimodal.
    
    Maître Wayne laisse souvent des notes avec son régime d&#x27;entraînement ou ses plans de repas.
    Cela me permet d&#x27;analyser correctement le contenu.
    &quot;&quot;&quot;</span>
    all_text = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Lire l&#x27;image et encoder en base64</span>
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(img_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> image_file:
            image_bytes = image_file.read()

        image_base64 = base64.b64encode(image_bytes).decode(<span class="hljs-string">&quot;utf-8&quot;</span>)

        <span class="hljs-comment"># Préparer le prompt incluant les données d&#x27;image base64</span>
        message = [
            HumanMessage(
                content=[
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
                        <span class="hljs-string">&quot;text&quot;</span>: (
                            <span class="hljs-string">&quot;Extrayez tout le texte de cette image. &quot;</span>
                            <span class="hljs-string">&quot;Retournez seulement le texte extrait, sans explications.&quot;</span>
                        ),
                    },
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
                        <span class="hljs-string">&quot;image_url&quot;</span>: {
                            <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">f&quot;data:image/png;base64,<span class="hljs-subst">{image_base64}</span>&quot;</span>
                        },
                    },
                ]
            )
        ]

        <span class="hljs-comment"># Appeler le VLM</span>
        response = vision_llm.invoke(message)

        <span class="hljs-comment"># Ajouter le texte extrait</span>
        all_text += response.content + <span class="hljs-string">&quot;\\n\\n&quot;</span>

        <span class="hljs-keyword">return</span> all_text.strip()
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-comment"># Un majordome doit gérer les erreurs avec élégance</span>
        error_msg = <span class="hljs-string">f&quot;Erreur lors de l&#x27;extraction du texte : <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>
        <span class="hljs-built_in">print</span>(error_msg)
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;&quot;</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">divide</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;Diviser a et b - pour les calculs occasionnels de Maître Wayne.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a / b

<span class="hljs-comment"># Équiper le majordome avec des outils</span>
tools = [
    divide,
    extract_text
]

llm = ChatOpenAI(model=<span class="hljs-string">&quot;gpt-4o&quot;</span>)
llm_with_tools = llm.bind_tools(tools, parallel_tool_calls=<span class="hljs-literal">False</span>)`,wrap:!1}}),z=new j({props:{title:"Les nœuds",local:"les-nœuds",headingTag:"h2"}}),E=new T({props:{code:"ZGVmJTIwYXNzaXN0YW50KHN0YXRlJTNBJTIwQWdlbnRTdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBNZXNzYWdlJTIwc3lzdCVDMyVBOG1lJTBBJTIwJTIwJTIwJTIwdGV4dHVhbF9kZXNjcmlwdGlvbl9vZl90b29sJTNEJTIyJTIyJTIyJTBBZXh0cmFjdF90ZXh0KGltZ19wYXRoJTNBJTIwc3RyKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjBFeHRyYWlyZSUyMGxlJTIwdGV4dGUlMjBkJ3VuJTIwZmljaGllciUyMGltYWdlJTIwZW4lMjB1dGlsaXNhbnQlMjB1biUyMG1vZCVDMyVBOGxlJTIwbXVsdGltb2RhbC4lMEElMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1nX3BhdGglM0ElMjBVbiUyMGNoZW1pbiUyMGRlJTIwZmljaGllciUyMGltYWdlJTIwbG9jYWwlMjAoY2hhJUMzJUFFbmVzKS4lMEElMEElMjAlMjAlMjAlMjBSZXR1cm5zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVW5lJTIwY2hhJUMzJUFFbmUlMjB1bmlxdWUlMjBjb250ZW5hbnQlMjBsZSUyMHRleHRlJTIwY29uY2F0JUMzJUE5biVDMyVBOSUyMGV4dHJhaXQlMjBkZSUyMGNoYXF1ZSUyMGltYWdlLiUwQWRpdmlkZShhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCklMjAtJTNFJTIwZmxvYXQlM0ElMEElMjAlMjAlMjAlMjBEaXZpc2VyJTIwYSUyMGV0JTIwYiUwQSUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGltYWdlJTNEc3RhdGUlNUIlMjJpbnB1dF9maWxlJTIyJTVEJTBBJTIwJTIwJTIwJTIwc3lzX21zZyUyMCUzRCUyMFN5c3RlbU1lc3NhZ2UoY29udGVudCUzRGYlMjJWb3VzJTIwJUMzJUFBdGVzJTIwdW4lMjBtYWpvcmRvbWUlMjBzZXJ2aWFibGUlMjBub21tJUMzJUE5JTIwQWxmcmVkJTIwcXVpJTIwc2VydCUyME0uJTIwV2F5bmUlMjBldCUyMEJhdG1hbi4lMjBWb3VzJTIwcG91dmV6JTIwYW5hbHlzZXIlMjBkZXMlMjBkb2N1bWVudHMlMjBldCUyMGVmZmVjdHVlciUyMGRlcyUyMGNhbGN1bHMlMjBhdmVjJTIwbGVzJTIwb3V0aWxzJTIwZm91cm5pcyUyMCUzQSU1Q24lN0J0ZXh0dWFsX2Rlc2NyaXB0aW9uX29mX3Rvb2wlN0QlMjAlNUNuJTIwVm91cyUyMGF2ZXolMjBhY2MlQzMlQThzJTIwJUMzJUEwJTIwcXVlbHF1ZXMlMjBpbWFnZXMlMjBvcHRpb25uZWxsZXMuJTIwQWN0dWVsbGVtZW50JTIwbCdpbWFnZSUyMGNoYXJnJUMzJUE5ZSUyMGVzdCUyMCUzQSUyMCU3QmltYWdlJTdEJTIyKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1lc3NhZ2VzJTIyJTNBJTIwJTVCbGxtX3dpdGhfdG9vbHMuaW52b2tlKCU1QnN5c19tc2clNUQlMjAlMkIlMjBzdGF0ZSU1QiUyMm1lc3NhZ2VzJTIyJTVEKSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmlucHV0X2ZpbGUlMjIlM0ElMjBzdGF0ZSU1QiUyMmlucHV0X2ZpbGUlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0Q=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">assistant</span>(<span class="hljs-params">state: AgentState</span>):
    <span class="hljs-comment"># Message système</span>
    textual_description_of_tool=<span class="hljs-string">&quot;&quot;&quot;
extract_text(img_path: str) -&gt; str:
    Extraire le texte d&#x27;un fichier image en utilisant un modèle multimodal.

    Args:
        img_path: Un chemin de fichier image local (chaînes).

    Returns:
        Une chaîne unique contenant le texte concaténé extrait de chaque image.
divide(a: int, b: int) -&gt; float:
    Diviser a et b
&quot;&quot;&quot;</span>
    image=state[<span class="hljs-string">&quot;input_file&quot;</span>]
    sys_msg = SystemMessage(content=<span class="hljs-string">f&quot;Vous êtes un majordome serviable nommé Alfred qui sert M. Wayne et Batman. Vous pouvez analyser des documents et effectuer des calculs avec les outils fournis :\\n<span class="hljs-subst">{textual_description_of_tool}</span> \\n Vous avez accès à quelques images optionnelles. Actuellement l&#x27;image chargée est : <span class="hljs-subst">{image}</span>&quot;</span>)

    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;messages&quot;</span>: [llm_with_tools.invoke([sys_msg] + state[<span class="hljs-string">&quot;messages&quot;</span>])],
        <span class="hljs-string">&quot;input_file&quot;</span>: state[<span class="hljs-string">&quot;input_file&quot;</span>]
    }`,wrap:!1}}),Y=new j({props:{title:"Le modèle ReAct : Comment j’aide M. Wayne",local:"le-modèle-react--comment-jaide-m-wayne",headingTag:"h2"}}),R=new T({props:{code:"JTIzJTIwTGUlMjBncmFwaGUlMEFidWlsZGVyJTIwJTNEJTIwU3RhdGVHcmFwaChBZ2VudFN0YXRlKSUwQSUwQSUyMyUyMEQlQzMlQTlmaW5pciUyMGxlcyUyMG4lQzUlOTN1ZHMlMjAlM0ElMjBjZXV4LWNpJTIwZm9udCUyMGxlJTIwdHJhdmFpbCUwQWJ1aWxkZXIuYWRkX25vZGUoJTIyYXNzaXN0YW50JTIyJTJDJTIwYXNzaXN0YW50KSUwQWJ1aWxkZXIuYWRkX25vZGUoJTIydG9vbHMlMjIlMkMlMjBUb29sTm9kZSh0b29scykpJTBBJTBBJTIzJTIwRCVDMyVBOWZpbmlyJTIwbGVzJTIwYXIlQzMlQUF0ZXMlMjAlM0ElMjBjZWxsZXMtY2klMjBkJUMzJUE5dGVybWluZW50JTIwY29tbWVudCUyMGxlJTIwZmx1eCUyMGRlJTIwY29udHIlQzMlQjRsZSUyMHNlJTIwZCVDMyVBOXBsYWNlJTBBYnVpbGRlci5hZGRfZWRnZShTVEFSVCUyQyUyMCUyMmFzc2lzdGFudCUyMiklMEFidWlsZGVyLmFkZF9jb25kaXRpb25hbF9lZGdlcyglMEElMjAlMjAlMjAlMjAlMjJhc3Npc3RhbnQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjMlMjBTaSUyMGxlJTIwZGVybmllciUyMG1lc3NhZ2UlMjBuJUMzJUE5Y2Vzc2l0ZSUyMHVuJTIwb3V0aWwlMkMlMjByb3V0ZXIlMjB2ZXJzJTIwbGVzJTIwb3V0aWxzJTBBJTIwJTIwJTIwJTIwJTIzJTIwU2lub24lMkMlMjBmb3VybmlyJTIwdW5lJTIwciVDMyVBOXBvbnNlJTIwZGlyZWN0ZSUwQSUyMCUyMCUyMCUyMHRvb2xzX2NvbmRpdGlvbiUyQyUwQSklMEFidWlsZGVyLmFkZF9lZGdlKCUyMnRvb2xzJTIyJTJDJTIwJTIyYXNzaXN0YW50JTIyKSUwQXJlYWN0X2dyYXBoJTIwJTNEJTIwYnVpbGRlci5jb21waWxlKCklMEElMEElMjMlMjBNb250cmVyJTIwbGUlMjBwcm9jZXNzdXMlMjBkZSUyMHIlQzMlQTlmbGV4aW9uJTIwZHUlMjBtYWpvcmRvbWUlMEFkaXNwbGF5KEltYWdlKHJlYWN0X2dyYXBoLmdldF9ncmFwaCh4cmF5JTNEVHJ1ZSkuZHJhd19tZXJtYWlkX3BuZygpKSk=",highlighted:`<span class="hljs-comment"># Le graphe</span>
builder = StateGraph(AgentState)

<span class="hljs-comment"># Définir les nœuds : ceux-ci font le travail</span>
builder.add_node(<span class="hljs-string">&quot;assistant&quot;</span>, assistant)
builder.add_node(<span class="hljs-string">&quot;tools&quot;</span>, ToolNode(tools))

<span class="hljs-comment"># Définir les arêtes : celles-ci déterminent comment le flux de contrôle se déplace</span>
builder.add_edge(START, <span class="hljs-string">&quot;assistant&quot;</span>)
builder.add_conditional_edges(
    <span class="hljs-string">&quot;assistant&quot;</span>,
    <span class="hljs-comment"># Si le dernier message nécessite un outil, router vers les outils</span>
    <span class="hljs-comment"># Sinon, fournir une réponse directe</span>
    tools_condition,
)
builder.add_edge(<span class="hljs-string">&quot;tools&quot;</span>, <span class="hljs-string">&quot;assistant&quot;</span>)
react_graph = builder.<span class="hljs-built_in">compile</span>()

<span class="hljs-comment"># Montrer le processus de réflexion du majordome</span>
display(Image(react_graph.get_graph(xray=<span class="hljs-literal">True</span>).draw_mermaid_png()))`,wrap:!1}}),P=new j({props:{title:"Le majordome en action",local:"le-majordome-en-action",headingTag:"h2"}}),K=new j({props:{title:"Exemple 1 : Calculs simples",local:"exemple-1--calculs-simples",headingTag:"h3"}}),ll=new T({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUJIdW1hbk1lc3NhZ2UoY29udGVudCUzRCUyMkRpdmlzZXolMjA2NzkwJTIwcGFyJTIwNSUyMiklNUQlMEFtZXNzYWdlcyUyMCUzRCUyMHJlYWN0X2dyYXBoLmludm9rZSglN0IlMjJtZXNzYWdlcyUyMiUzQSUyMG1lc3NhZ2VzJTJDJTIwJTIyaW5wdXRfZmlsZSUyMiUzQSUyME5vbmUlN0QpJTBBJTBBJTIzJTIwTW9udHJlciUyMGxlcyUyMG1lc3NhZ2VzJTBBZm9yJTIwbSUyMGluJTIwbWVzc2FnZXMlNUInbWVzc2FnZXMnJTVEJTNBJTBBJTIwJTIwJTIwJTIwbS5wcmV0dHlfcHJpbnQoKQ==",highlighted:`messages = [HumanMessage(content=<span class="hljs-string">&quot;Divisez 6790 par 5&quot;</span>)]
messages = react_graph.invoke({<span class="hljs-string">&quot;messages&quot;</span>: messages, <span class="hljs-string">&quot;input_file&quot;</span>: <span class="hljs-literal">None</span>})

<span class="hljs-comment"># Montrer les messages</span>
<span class="hljs-keyword">for</span> m <span class="hljs-keyword">in</span> messages[<span class="hljs-string">&#x27;messages&#x27;</span>]:
    m.pretty_print()`,wrap:!1}}),sl=new T({props:{code:"SHVtYWluJTIwJTNBJTIwRGl2aXNleiUyMDY3OTAlMjBwYXIlMjA1JTBBJTBBQXBwZWwlMjBkJ3VuJTIwb3V0aWwlMjAlM0ElMjBkaXZpZGUoYSUzRDY3OTAlMkMlMjBiJTNENSklMEElMEFSJUMzJUE5cG9uc2UlMjBkZSUyMGwnb3V0aWwlMjAlM0ElMjAxMzU4LjAlMEElMEFBbGZyZWQlMjAlM0ElMjBMZSUyMHIlQzMlQTlzdWx0YXQlMjBkZSUyMGxhJTIwZGl2aXNpb24lMjBkZSUyMDY3OTAlMjBwYXIlMjA1JTIwZXN0JTIwMTM1OC4wLg==",highlighted:`<span class="hljs-attribute">Humain</span> : Divisez <span class="hljs-number">6790</span> par <span class="hljs-number">5</span>

<span class="hljs-attribute">Appel</span> d&#x27;un outil : divide(a=<span class="hljs-number">6790</span>, b=<span class="hljs-number">5</span>)

<span class="hljs-attribute">R</span>éponse de l&#x27;outil : <span class="hljs-number">1358</span>.<span class="hljs-number">0</span>

<span class="hljs-attribute">Alfred</span> : Le résultat de la division de <span class="hljs-number">6790</span> par <span class="hljs-number">5</span> est <span class="hljs-number">1358</span>.<span class="hljs-number">0</span>.`,wrap:!1}}),tl=new j({props:{title:"Exemple 2 : Analyser les documents d’entraînement de Maître Wayne",local:"exemple-2--analyser-les-documents-dentraînement-de-maître-wayne",headingTag:"h3"}}),al=new T({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUJIdW1hbk1lc3NhZ2UoY29udGVudCUzRCUyMlNlbG9uJTIwbGElMjBub3RlJTIwZm91cm5pZSUyMHBhciUyME0uJTIwV2F5bmUlMjBkYW5zJTIwbGVzJTIwaW1hZ2VzJTIwZm91cm5pZXMuJTIwUXVlbGxlJTIwZXN0JTIwbGElMjBsaXN0ZSUyMGRlcyUyMGFydGljbGVzJTIwcXVlJTIwamUlMjBkb2lzJTIwYWNoZXRlciUyMHBvdXIlMjBsZSUyMG1lbnUlMjBkdSUyMGQlQzMlQUVuZXIlMjAlM0YlMjIpJTVEJTBBbWVzc2FnZXMlMjAlM0QlMjByZWFjdF9ncmFwaC5pbnZva2UoJTdCJTIybWVzc2FnZXMlMjIlM0ElMjBtZXNzYWdlcyUyQyUyMCUyMmlucHV0X2ZpbGUlMjIlM0ElMjAlMjJCYXRtYW5fdHJhaW5pbmdfYW5kX21lYWxzLnBuZyUyMiU3RCk=",highlighted:`messages = [HumanMessage(content=<span class="hljs-string">&quot;Selon la note fournie par M. Wayne dans les images fournies. Quelle est la liste des articles que je dois acheter pour le menu du dîner ?&quot;</span>)]
messages = react_graph.invoke({<span class="hljs-string">&quot;messages&quot;</span>: messages, <span class="hljs-string">&quot;input_file&quot;</span>: <span class="hljs-string">&quot;Batman_training_and_meals.png&quot;</span>})`,wrap:!1}}),il=new T({props:{code:"SHVtYWluJTIwJTNBJTIwU2Vsb24lMjBsYSUyMG5vdGUlMjBmb3VybmllJTIwcGFyJTIwTS4lMjBXYXluZSUyMGRhbnMlMjBsZXMlMjBpbWFnZXMlMjBmb3Vybmllcy4lMjBRdWVsbGUlMjBlc3QlMjBsYSUyMGxpc3RlJTIwZGVzJTIwYXJ0aWNsZXMlMjBxdWUlMjBqZSUyMGRvaXMlMjBhY2hldGVyJTIwcG91ciUyMGxlJTIwbWVudSUyMGR1JTIwZCVDMyVBRW5lciUyMCUzRiUwQSUwQUFwcGVsJTIwZCd1biUyMG91dGlsJTIwJTNBJTIwZXh0cmFjdF90ZXh0KGltZ19wYXRoJTNEJTIyQmF0bWFuX3RyYWluaW5nX2FuZF9tZWFscy5wbmclMjIpJTBBJTBBUiVDMyVBOXBvbnNlJTIwZGUlMjBsJ291dGlsJTIwJTNBJTIwJTVCVGV4dGUlMjBleHRyYWl0JTIwYXZlYyUyMGxlJTIwcHJvZ3JhbW1lJTIwZCdlbnRyYSVDMyVBRW5lbWVudCUyMGV0JTIwbGVzJTIwZCVDMyVBOXRhaWxzJTIwZHUlMjBtZW51JTVEJTBBJTBBQWxmcmVkJTIwJTNBJTIwUG91ciUyMGxlJTIwbWVudSUyMGR1JTIwZCVDMyVBRW5lciUyQyUyMHZvdXMlMjBkZXZyaWV6JTIwYWNoZXRlciUyMGxlcyUyMGFydGljbGVzJTIwc3VpdmFudHMlMjAlM0ElMEElMEExLiUyMFN0ZWFrJTIwZGUlMjBzdXJsb25nZSUyMGxvY2FsJTIwbm91cnJpJTIwJUMzJUEwJTIwbCdoZXJiZSUwQTIuJTIwJUMzJTg5cGluYXJkcyUyMGJpb2xvZ2lxdWVzJTBBMy4lMjBQb2l2cm9ucyUyMCpwaXF1aWxsbyolMEE0LiUyMFBvbW1lcyUyMGRlJTIwdGVycmUlMjAocG91ciUyMHBvbW1lcyUyMGRlJTIwdGVycmUlMjBhdXglMjBoZXJiZXMlMjBkb3IlQzMlQTllcyUyMGF1JTIwZm91ciklMEE1LiUyMEh1aWxlJTIwZGUlMjBwb2lzc29uJTIwKDIlMjBncmFtbWVzKSUwQSUwQUFzc3VyZXotdm91cyUyMHF1ZSUyMGxlJTIwc3RlYWslMjBzb2l0JTIwbm91cnJpJTIwJUMzJUEwJTIwbCdoZXJiZSUyMGV0JTIwcXVlJTIwbGVzJTIwJUMzJUE5cGluYXJkcyUyMGV0JTIwcG9pdnJvbnMlMjBzb2llbnQlMjBiaW9sb2dpcXVlcyUyMHBvdXIlMjB1biUyMHJlcGFzJTIwZGUlMjBsYSUyMG1laWxsZXVyZSUyMHF1YWxpdCVDMyVBOS4=",highlighted:`Humain : Selon <span class="hljs-keyword">la</span> <span class="hljs-keyword">note</span> fournie par <span class="hljs-keyword">M</span>. Wayne dans les images fournies. Quelle <span class="hljs-keyword">est</span> <span class="hljs-keyword">la</span> liste <span class="hljs-keyword">des</span> articles <span class="hljs-keyword">que</span> je dois acheter pour le menu du <span class="hljs-keyword">d</span>îner ?

Appel <span class="hljs-keyword">d</span>&#x27;un outil : extract_text(img_path=<span class="hljs-string">&quot;Batman_training_and_meals.png&quot;</span>)

Réponse <span class="hljs-keyword">de</span> <span class="hljs-keyword">l</span>&#x27;outil : [Texte extrait avec le programme <span class="hljs-keyword">d</span>&#x27;entraînement et les <span class="hljs-keyword">d</span>étails du menu]

Alfred : Pour le menu du <span class="hljs-keyword">d</span>îner, vous devriez acheter les articles suivants :

1. Steak <span class="hljs-keyword">de</span> surlonge <span class="hljs-keyword">local</span> nourri à <span class="hljs-keyword">l</span>&#x27;herbe
2. Épinards biologiques
3. Poivrons *piquillo*
4. Pommes <span class="hljs-keyword">de</span> terre (pour pommes <span class="hljs-keyword">de</span> terre aux herbes dorées au four)
5. Huile <span class="hljs-keyword">de</span> <span class="hljs-keyword">poisson</span> (2 grammes)

Assurez-vous <span class="hljs-keyword">que</span> le steak soit nourri à <span class="hljs-keyword">l</span>&#x27;herbe et <span class="hljs-keyword">que</span> les épinards et poivrons soient biologiques pour un repas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> meilleure qualité.`,wrap:!1}}),pl=new j({props:{title:"Points clés à retenir",local:"points-clés-à-retenir",headingTag:"h2"}}),Ul=new Oe({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit2/langgraph/document_analysis_agent.mdx"}}),{c(){w=M("meta"),Tl=n(),ul=M("p"),wl=n(),y(c.$$.fragment),dl=n(),y(m.$$.fragment),cl=n(),I=M("p"),I.textContent=we,ml=n(),C=M("p"),C.innerHTML=de,Il=n(),b=M("p"),b.textContent=ce,Cl=n(),h=M("ol"),h.innerHTML=me,bl=n(),y(B.$$.fragment),hl=n(),g=M("p"),g.innerHTML=Ie,Bl=n(),Z=M("p"),Z.innerHTML=Ce,gl=n(),d=M("blockquote"),d.innerHTML=be,Zl=n(),y(A.$$.fragment),Al=n(),y(G.$$.fragment),Gl=n(),f=M("p"),f.textContent=he,fl=n(),y(W.$$.fragment),Wl=n(),y(V.$$.fragment),Vl=n(),x=M("p"),x.innerHTML=Be,xl=n(),v=M("p"),v.textContent=ge,vl=n(),y(X.$$.fragment),Xl=n(),y($.$$.fragment),$l=n(),y(k.$$.fragment),kl=n(),y(z.$$.fragment),zl=n(),y(E.$$.fragment),El=n(),y(Y.$$.fragment),Yl=n(),Q=M("p"),Q.innerHTML=Ze,Ql=n(),S=M("ol"),S.innerHTML=Ae,Sl=n(),N=M("p"),N.textContent=Ge,Nl=n(),y(R.$$.fragment),Rl=n(),F=M("p"),F.innerHTML=fe,Fl=n(),_=M("p"),_.innerHTML=We,_l=n(),q=M("p"),q.textContent=Ve,ql=n(),H=M("p"),H.innerHTML=xe,Hl=n(),L=M("ul"),L.innerHTML=ve,Ll=n(),D=M("p"),D.innerHTML=Xe,Dl=n(),y(P.$$.fragment),Pl=n(),y(K.$$.fragment),Kl=n(),O=M("p"),O.textContent=$e,Ol=n(),y(ll.$$.fragment),le=n(),el=M("p"),el.textContent=ke,ee=n(),y(sl.$$.fragment),se=n(),y(tl.$$.fragment),te=n(),nl=M("p"),nl.textContent=ze,ne=n(),y(al.$$.fragment),ae=n(),Ml=M("p"),Ml.textContent=Ee,Me=n(),y(il.$$.fragment),ie=n(),y(pl.$$.fragment),pe=n(),yl=M("p"),yl.textContent=Ye,ye=n(),ol=M("ol"),ol.innerHTML=Qe,oe=n(),Jl=M("p"),Jl.textContent=Se,Je=n(),rl=M("p"),rl.innerHTML=Ne,re=n(),y(Ul.$$.fragment),Ue=n(),jl=M("p"),this.h()},l(l){const e=De("svelte-u9bgzb",document.head);w=i(e,"META",{name:!0,content:!0}),e.forEach(s),Tl=a(l),ul=i(l,"P",{}),Re(ul).forEach(s),wl=a(l),o(c.$$.fragment,l),dl=a(l),o(m.$$.fragment,l),cl=a(l),I=i(l,"P",{"data-svelte-h":!0}),p(I)!=="svelte-gt557y"&&(I.textContent=we),ml=a(l),C=i(l,"P",{"data-svelte-h":!0}),p(C)!=="svelte-4j0gl0"&&(C.innerHTML=de),Il=a(l),b=i(l,"P",{"data-svelte-h":!0}),p(b)!=="svelte-10fnikl"&&(b.textContent=ce),Cl=a(l),h=i(l,"OL",{"data-svelte-h":!0}),p(h)!=="svelte-1hsq04l"&&(h.innerHTML=me),bl=a(l),o(B.$$.fragment,l),hl=a(l),g=i(l,"P",{"data-svelte-h":!0}),p(g)!=="svelte-3lt4u7"&&(g.innerHTML=Ie),Bl=a(l),Z=i(l,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-g7cpwr"&&(Z.innerHTML=Ce),gl=a(l),d=i(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(d)!=="svelte-1gbygqo"&&(d.innerHTML=be),Zl=a(l),o(A.$$.fragment,l),Al=a(l),o(G.$$.fragment,l),Gl=a(l),f=i(l,"P",{"data-svelte-h":!0}),p(f)!=="svelte-x7jdgr"&&(f.textContent=he),fl=a(l),o(W.$$.fragment,l),Wl=a(l),o(V.$$.fragment,l),Vl=a(l),x=i(l,"P",{"data-svelte-h":!0}),p(x)!=="svelte-19o7soi"&&(x.innerHTML=Be),xl=a(l),v=i(l,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1eaw1cp"&&(v.textContent=ge),vl=a(l),o(X.$$.fragment,l),Xl=a(l),o($.$$.fragment,l),$l=a(l),o(k.$$.fragment,l),kl=a(l),o(z.$$.fragment,l),zl=a(l),o(E.$$.fragment,l),El=a(l),o(Y.$$.fragment,l),Yl=a(l),Q=i(l,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-jejazg"&&(Q.innerHTML=Ze),Ql=a(l),S=i(l,"OL",{"data-svelte-h":!0}),p(S)!=="svelte-svdcrr"&&(S.innerHTML=Ae),Sl=a(l),N=i(l,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1h6mv9k"&&(N.textContent=Ge),Nl=a(l),o(R.$$.fragment,l),Rl=a(l),F=i(l,"P",{"data-svelte-h":!0}),p(F)!=="svelte-kp6yb5"&&(F.innerHTML=fe),Fl=a(l),_=i(l,"P",{"data-svelte-h":!0}),p(_)!=="svelte-g1y7jt"&&(_.innerHTML=We),_l=a(l),q=i(l,"P",{"data-svelte-h":!0}),p(q)!=="svelte-llapac"&&(q.textContent=Ve),ql=a(l),H=i(l,"P",{"data-svelte-h":!0}),p(H)!=="svelte-rl19lj"&&(H.innerHTML=xe),Hl=a(l),L=i(l,"UL",{"data-svelte-h":!0}),p(L)!=="svelte-ronwmj"&&(L.innerHTML=ve),Ll=a(l),D=i(l,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1nhlurw"&&(D.innerHTML=Xe),Dl=a(l),o(P.$$.fragment,l),Pl=a(l),o(K.$$.fragment,l),Kl=a(l),O=i(l,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1521eea"&&(O.textContent=$e),Ol=a(l),o(ll.$$.fragment,l),le=a(l),el=i(l,"P",{"data-svelte-h":!0}),p(el)!=="svelte-528ko8"&&(el.textContent=ke),ee=a(l),o(sl.$$.fragment,l),se=a(l),o(tl.$$.fragment,l),te=a(l),nl=i(l,"P",{"data-svelte-h":!0}),p(nl)!=="svelte-1xfwie6"&&(nl.textContent=ze),ne=a(l),o(al.$$.fragment,l),ae=a(l),Ml=i(l,"P",{"data-svelte-h":!0}),p(Ml)!=="svelte-1wf0zlb"&&(Ml.textContent=Ee),Me=a(l),o(il.$$.fragment,l),ie=a(l),o(pl.$$.fragment,l),pe=a(l),yl=i(l,"P",{"data-svelte-h":!0}),p(yl)!=="svelte-1fpv4nj"&&(yl.textContent=Ye),ye=a(l),ol=i(l,"OL",{"data-svelte-h":!0}),p(ol)!=="svelte-frrqyp"&&(ol.innerHTML=Qe),oe=a(l),Jl=i(l,"P",{"data-svelte-h":!0}),p(Jl)!=="svelte-1gn4t6x"&&(Jl.textContent=Se),Je=a(l),rl=i(l,"P",{"data-svelte-h":!0}),p(rl)!=="svelte-1fvnwmy"&&(rl.innerHTML=Ne),re=a(l),o(Ul.$$.fragment,l),Ue=a(l),jl=i(l,"P",{}),Re(jl).forEach(s),this.h()},h(){je(w,"name","hf:doc:metadata"),je(w,"content",es),je(d,"class","tip")},m(l,e){Pe(document.head,w),t(l,Tl,e),t(l,ul,e),t(l,wl,e),J(c,l,e),t(l,dl,e),J(m,l,e),t(l,cl,e),t(l,I,e),t(l,ml,e),t(l,C,e),t(l,Il,e),t(l,b,e),t(l,Cl,e),t(l,h,e),t(l,bl,e),J(B,l,e),t(l,hl,e),t(l,g,e),t(l,Bl,e),t(l,Z,e),t(l,gl,e),t(l,d,e),t(l,Zl,e),J(A,l,e),t(l,Al,e),J(G,l,e),t(l,Gl,e),t(l,f,e),t(l,fl,e),J(W,l,e),t(l,Wl,e),J(V,l,e),t(l,Vl,e),t(l,x,e),t(l,xl,e),t(l,v,e),t(l,vl,e),J(X,l,e),t(l,Xl,e),J($,l,e),t(l,$l,e),J(k,l,e),t(l,kl,e),J(z,l,e),t(l,zl,e),J(E,l,e),t(l,El,e),J(Y,l,e),t(l,Yl,e),t(l,Q,e),t(l,Ql,e),t(l,S,e),t(l,Sl,e),t(l,N,e),t(l,Nl,e),J(R,l,e),t(l,Rl,e),t(l,F,e),t(l,Fl,e),t(l,_,e),t(l,_l,e),t(l,q,e),t(l,ql,e),t(l,H,e),t(l,Hl,e),t(l,L,e),t(l,Ll,e),t(l,D,e),t(l,Dl,e),J(P,l,e),t(l,Pl,e),J(K,l,e),t(l,Kl,e),t(l,O,e),t(l,Ol,e),J(ll,l,e),t(l,le,e),t(l,el,e),t(l,ee,e),J(sl,l,e),t(l,se,e),J(tl,l,e),t(l,te,e),t(l,nl,e),t(l,ne,e),J(al,l,e),t(l,ae,e),t(l,Ml,e),t(l,Me,e),J(il,l,e),t(l,ie,e),J(pl,l,e),t(l,pe,e),t(l,yl,e),t(l,ye,e),t(l,ol,e),t(l,oe,e),t(l,Jl,e),t(l,Je,e),t(l,rl,e),t(l,re,e),J(Ul,l,e),t(l,Ue,e),t(l,jl,e),ue=!0},p:_e,i(l){ue||(r(c.$$.fragment,l),r(m.$$.fragment,l),r(B.$$.fragment,l),r(A.$$.fragment,l),r(G.$$.fragment,l),r(W.$$.fragment,l),r(V.$$.fragment,l),r(X.$$.fragment,l),r($.$$.fragment,l),r(k.$$.fragment,l),r(z.$$.fragment,l),r(E.$$.fragment,l),r(Y.$$.fragment,l),r(R.$$.fragment,l),r(P.$$.fragment,l),r(K.$$.fragment,l),r(ll.$$.fragment,l),r(sl.$$.fragment,l),r(tl.$$.fragment,l),r(al.$$.fragment,l),r(il.$$.fragment,l),r(pl.$$.fragment,l),r(Ul.$$.fragment,l),ue=!0)},o(l){U(c.$$.fragment,l),U(m.$$.fragment,l),U(B.$$.fragment,l),U(A.$$.fragment,l),U(G.$$.fragment,l),U(W.$$.fragment,l),U(V.$$.fragment,l),U(X.$$.fragment,l),U($.$$.fragment,l),U(k.$$.fragment,l),U(z.$$.fragment,l),U(E.$$.fragment,l),U(Y.$$.fragment,l),U(R.$$.fragment,l),U(P.$$.fragment,l),U(K.$$.fragment,l),U(ll.$$.fragment,l),U(sl.$$.fragment,l),U(tl.$$.fragment,l),U(al.$$.fragment,l),U(il.$$.fragment,l),U(pl.$$.fragment,l),U(Ul.$$.fragment,l),ue=!1},d(l){l&&(s(Tl),s(ul),s(wl),s(dl),s(cl),s(I),s(ml),s(C),s(Il),s(b),s(Cl),s(h),s(bl),s(hl),s(g),s(Bl),s(Z),s(gl),s(d),s(Zl),s(Al),s(Gl),s(f),s(fl),s(Wl),s(Vl),s(x),s(xl),s(v),s(vl),s(Xl),s($l),s(kl),s(zl),s(El),s(Yl),s(Q),s(Ql),s(S),s(Sl),s(N),s(Nl),s(Rl),s(F),s(Fl),s(_),s(_l),s(q),s(ql),s(H),s(Hl),s(L),s(Ll),s(D),s(Dl),s(Pl),s(Kl),s(O),s(Ol),s(le),s(el),s(ee),s(se),s(te),s(nl),s(ne),s(ae),s(Ml),s(Me),s(ie),s(pe),s(yl),s(ye),s(ol),s(oe),s(Jl),s(Je),s(rl),s(re),s(Ue),s(jl)),s(w),u(c,l),u(m,l),u(B,l),u(A,l),u(G,l),u(W,l),u(V,l),u(X,l),u($,l),u(k,l),u(z,l),u(E,l),u(Y,l),u(R,l),u(P,l),u(K,l),u(ll,l),u(sl,l),u(tl,l),u(al,l),u(il,l),u(pl,l),u(Ul,l)}}}const es='{"title":"Graphe d’analyse de documents","local":"graphe-danalyse-de-documents","sections":[{"title":"Le workflow du majordome","local":"le-workflow-du-majordome","sections":[],"depth":2},{"title":"Configuration de l’environnement","local":"configuration-de-lenvironnement","sections":[],"depth":2},{"title":"Définir l’état de l’agent","local":"définir-létat-de-lagent","sections":[],"depth":2},{"title":"Préparer les outils","local":"préparer-les-outils","sections":[],"depth":2},{"title":"Les nœuds","local":"les-nœuds","sections":[],"depth":2},{"title":"Le modèle ReAct : Comment j’aide M. Wayne","local":"le-modèle-react--comment-jaide-m-wayne","sections":[],"depth":2},{"title":"Le majordome en action","local":"le-majordome-en-action","sections":[{"title":"Exemple 1 : Calculs simples","local":"exemple-1--calculs-simples","sections":[],"depth":3},{"title":"Exemple 2 : Analyser les documents d’entraînement de Maître Wayne","local":"exemple-2--analyser-les-documents-dentraînement-de-maître-wayne","sections":[],"depth":3}],"depth":2},{"title":"Points clés à retenir","local":"points-clés-à-retenir","sections":[],"depth":2}],"depth":1}';function ss(Te){return qe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ps extends He{constructor(w){super(),Le(this,w,ss,ls,Fe,{})}}export{ps as component};
