import{s as Yn,n as Fn,o as An}from"../chunks/scheduler.505acc25.js";import{S as Nn,i as zn,e as a,s as l,c as u,h as Pn,a as o,d as n,b as i,f as St,g as p,j as r,k as Z,l as M,m as s,n as m,t as d,o as c,p as v}from"../chunks/index.b1175496.js";import{C as Qn,H as Le}from"../chunks/Heading.988e52fa.js";import{C as T}from"../chunks/CodeBlock.ed64aebc.js";import{E as On}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.3d47a398.js";function Dn(Qt){let g,qe,We,Ve,C,ke,j,Ee,I,Ot=`Vous vous souvenez d’Alfred, notre agent majordome serviable de l’Unité 1 ?
Pour nous aider efficacement, Alfred doit comprendre nos demandes et <strong>préparer, trouver et utiliser les informations pertinentes pour aider à accomplir les tâches.</strong>
C’est là que les <em>components</em> de LlamaIndex entrent en jeu.`,Be,_,Dt=`Bien que LlamaIndex ait de nombreux <em>components</em>, <strong>nous nous concentrerons spécifiquement sur le <em>component</em> <code>QueryEngine</code>.</strong>
Pourquoi ? Parce qu’il peut être utilisé comme un outil de <em>Retrieval-Augmented Generation</em> (RAG) pour un agent.`,Re,$,Kt=`Alors, qu’est-ce que le RAG ? Les LLM sont entraînés sur d’énormes corpus de données pour apprendre les connaissances générales.
Cependant, ils peuvent ne pas être entraînés sur des données pertinentes et à jour.
Le RAG résout ce problème en trouvant et récupérant des informations pertinentes de vos données et en les donnant au LLM.`,Xe,G,en='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/rag.png" alt="RAG"/>',Se,W,tn="Maintenant, pensez à comment Alfred fonctionne :",Ye,H,nn="<li>Vous demandez à Alfred d’aider à planifier un dîner</li> <li>Alfred doit vérifier votre calendrier, vos préférences alimentaires et les menus précédents réussis</li> <li>Le <code>QueryEngine</code> aide Alfred à trouver ces informations et à les utiliser pour planifier le dîner</li>",Fe,q,sn=`Cela fait du <code>QueryEngine</code> <strong>un <em>component</em> clé pour construire des <em>workflows</em> de RAG agentiques</strong> dans LlamaIndex.
Tout comme Alfred a besoin de rechercher dans les informations de votre maison pour être utile, tout agent a besoin d’un moyen de trouver et comprendre des données pertinentes.
Le <code>QueryEngine</code> fournit exactement cette capacité.`,Ae,V,ln="Maintenant, approfondissons un peu les <em>components</em> et voyons comment vous pouvez <strong>combiner les <em>components</em> pour créer un pipeline de RAG.</strong>",Ne,k,ze,h,an='<p>Vous pouvez suivre le code dans <a href="https://huggingface.co/agents-course/notebooks/blob/main/fr/unit2/llama-index/components.ipynb" target="_blank">ce <i>notebook</i></a> que vous pouvez exécuter avec Google Colab.</p>',Pe,E,on="Il y a cinq étapes clés dans le RAG, qui feront partie de la plupart des applications plus ambitieuses que vous construirez. A savoir :",Qe,B,rn="<li><strong>Chargement</strong> : cela se réfère à obtenir vos données d’où elles vivent (qu’il s’agisse de fichiers texte, de PDF, d’un autre site web, d’une base de données, ou d’une API) dans votre <em>workflow</em>. <em>LlamaHub</em> fournit des centaines d’intégrations parmi lesquelles choisir.</li> <li><strong>Indexation</strong> : cela signifie créer une structure de données qui permet d’interroger les données. Pour les LLM, cela signifie presque toujours créer des <em>embeddings</em> vectoriels. Ce sont des représentations numériques de la signification des données. L’indexation peut également se référer à de nombreuses autres stratégies de métadonnées pour faciliter la recherche de données contextuellement pertinentes basées sur les propriétés.</li> <li><strong>Stockage</strong> : une fois vos données indexées, vous voudrez stocker votre index, ainsi que d’autres métadonnées, pour éviter de devoir ré-indexer à chaque utilisation.</li> <li><strong>Requête</strong> : pour toute stratégie d’indexation donnée, il y a de nombreuses façons d’utiliser les LLM et les structures de données LlamaIndex pour faire des requêtes, incluant des sous-requêtes, des requêtes multi-étapes et des stratégies hybrides.</li> <li><strong>Évaluation</strong> : une étape critique dans tout flux est de vérifier son efficacité par rapport à d’autres stratégies, ou lorsque vous apportez des modifications. L’évaluation fournit des mesures objectives de la précision, de la fidélité et de la rapidité de vos réponses aux requêtes.</li>",Oe,R,un="Ensuite, voyons comment nous pouvons reproduire ces étapes en utilisant des <em>components</em>.",De,X,Ke,S,pn=`Comme mentionné précédemment, LlamaIndex peut fonctionner au-dessus de vos propres données, cependant, <strong>avant d’accéder aux données, nous devons les charger.</strong>
Il y a trois façons principales de charger des données dans LlamaIndex :`,et,Y,mn="<li><code>SimpleDirectoryReader</code> : Un chargeur de données intégré pour divers types de fichiers d’un répertoire local.</li> <li><code>LlamaParse</code> : L’outil officiel de LlamaIndex pour l’analyse de PDF, disponible comme une API gérée.</li> <li><code>LlamaHub</code> : Un registre de centaines de bibliothèques de chargement de données pour ingérer des données de n’importe quelle source.</li>",tt,x,dn='<p>Familiarisez-vous avec les chargeurs de données <a href="https://docs.llamaindex.ai/en/stable/module_guides/loading/connector/">LlamaHub</a> et le <i>parser</i> <a href="https://github.com/run-llama/llama_cloud_services/blob/main/parse.md">LlamaParse</a> pour des sources de données plus complexes.</p>',nt,F,cn=`<strong>La façon la plus simple de charger des données est avec <code>SimpleDirectoryReader</code>.</strong>
Ce <em>component</em> polyvalent peut charger divers types de fichiers d’un dossier et les convertir en objets <code>Document</code> avec lesquels LlamaIndex peut travailler.
Voyons comment nous pouvons utiliser <code>SimpleDirectoryReader</code> pour charger des données d’un dossier.`,st,A,lt,N,vn=`Après avoir chargé nos documents, nous devons les diviser en plus petites parties appelées objets <code>Node</code>.
Un <code>Node</code> est juste un morceau de texte du document original qui est plus facile à traiter pour l’IA, tout en conservant des références à l’objet <code>Document</code> original.`,it,z,fn="L’<code>IngestionPipeline</code> nous aide à créer ces <em>nodes</em> grâce à deux transformations clés.",at,P,Mn="<li><code>SentenceSplitter</code> divise les documents en morceaux aux niveaux des phrases.</li> <li><code>HuggingFaceEmbedding</code> convertit chaque morceau en <em>embeddings</em> numériques.</li>",ot,Q,bn="Ce processus nous aide à organiser nos documents d’une manière qui est plus utile pour la recherche et l’analyse.",rt,O,ut,D,pt,K,yn="Après avoir créé nos objets <code>Node</code>, nous devons les indexer pour les rendre recherchables, mais avant de pouvoir le faire, nous avons besoin d’un endroit pour stocker nos données.",mt,ee,gn=`Puisque nous utilisons un pipeline d’ingestion, nous pouvons directement attacher un <em>vector store</em> au pipeline pour le remplir.
Dans ce cas, nous utiliserons <code>Chroma</code> pour stocker nos documents.`,dt,b,Ze,Tn="Installer ChromaDB",Yt,Ce,hn='Comme introduit dans la <a href="./llama-hub">section sur le LlamaHub</a>, nous pouvons installer le <em>vector store</em> ChromaDB avec la commande suivante :',Ft,te,ct,ne,vt,U,xn='<p>Un aperçu des différents <i>vector stores</i> peut être trouvé dans la <a href="https://docs.llamaindex.ai/en/stable/module_guides/storing/vector_stores/">documentation de LlamaIndex</a>.</p>',ft,se,Un=`C’est là que les <em>embeddings</em> vectoriels entrent en jeu. En enchassant à la fois la requête et les <em>nodes</em> dans le même espace vectoriel, nous pouvons trouver des correspondances pertinentes.
Le <code>VectorStoreIndex</code> s’occupe de cela pour nous, en utilisant le même modèle d’<em>embedding</em> que nous avons utilisé pendant l’ingestion pour assurer la cohérence.`,Mt,le,Jn="Voyons comment créer cet index à partir de notre <em>vector store</em> et des <em>embeddings</em> :",bt,ie,yt,ae,wn="Toutes les informations sont automatiquement persistées dans l’objet <code>ChromaVectorStore</code> et le chemin du répertoire passé.",gt,oe,Ln="Parfait ! Maintenant que nous pouvons sauvegarder et charger notre index facilement, explorons comment l’interroger de différentes manières.",Tt,re,ht,ue,Zn="Avant de pouvoir interroger notre index, nous devons le convertir en interface de requête. Les options de conversion les plus courantes sont :",xt,pe,Cn="<li><code>as_retriever</code> : Pour la récupération basique de documents, retournant une liste d’objets <code>NodeWithScore</code> avec des scores de similarité</li> <li><code>as_query_engine</code> : Pour les interactions question-réponse simples, retournant une réponse écrite</li> <li><code>as_chat_engine</code> : Pour les interactions conversationnelles qui maintiennent la mémoire à travers plusieurs messages, retournant une réponse écrite utilisant l’historique de chat et le contexte indexé</li>",Ut,me,jn=`Nous nous concentrerons sur le <em>query engine</em> car il est plus commun pour les interactions de type agent.
Nous passons également un LLM au <em>query engine</em> à utiliser pour la réponse.`,Jt,de,wt,ce,Lt,ve,In=`Sous le capot, le <em>query engine</em> n’utilise pas seulement le LLM pour répondre à la question mais utilise également un <code>ResponseSynthesizer</code> comme stratégie pour traiter la réponse.
Encore une fois, c’est entièrement personnalisable mais il y a trois stratégies principales qui fonctionnent bien prêtes à l’emploi :`,Zt,fe,_n="<li><code>refine</code> : créer et affiner une réponse en parcourant séquentiellement chaque morceau de texte récupéré. Cela fait un appel au LLM séparé pour chaque <em>Node</em>/morceau récupéré.</li> <li><code>compact</code> (par défaut) : similaire à l’affinement mais concaténant les morceaux au préalable, résultant en moins d’appels au LLM.</li> <li><code>tree_summarize</code> : créer une réponse détaillée en parcourant chaque morceau de texte récupéré et créant une structure d’arbre de la réponse.</li>",Ct,J,$n='<p>Prenez un contrôle fin de vos <i>workflows</i> de requête avec l’<a href="https://docs.llamaindex.ai/en/stable/module_guides/deploying/query_engine/usage_pattern/#low-level-composition-api">API de composition de bas niveau</a>. Cette API vous permet de personnaliser et de finetuner chaque étape du processus de requête pour correspondre à vos besoins exacts, ce qui se marie également très bien avec les <a href="https://docs.llamaindex.ai/en/stable/module_guides/workflow/"><i>Workflows</i></a>.</p>',jt,Me,Gn="Le modèle de langage ne performera pas toujours de manière prévisible, donc nous ne pouvons pas être sûrs que la réponse que nous obtenons soit toujours correcte. Nous pouvons gérer cela en <strong>évaluant la qualité de la réponse</strong>.",It,be,_t,ye,Wn=`LlamaIndex fournit <strong>des outils d’évaluation intégrés pour évaluer la qualité des réponses.</strong>
Ces évaluateurs exploitent les LLM pour analyser les réponses à travers différentes dimensions.
Regardons les trois évaluateurs principaux disponibles :`,$t,ge,Hn="<li><code>FaithfulnessEvaluator</code> : Évalue la fidélité de la réponse en vérifiant si la réponse est supportée par le contexte.</li> <li><code>AnswerRelevancyEvaluator</code> : Évalue la pertinence de la réponse en vérifiant si la réponse est pertinente par rapport à la question.</li> <li><code>CorrectnessEvaluator</code> : Évalue la correction de la réponse en vérifiant si la réponse est correcte.</li>",Gt,w,qn='<p>Vous voulez en savoir plus sur l’observabilité et l’évaluation des agents ? Suivez l’<a href="https://huggingface.co/learn/agents-course/fr/bonus-unit2/introduction">Unité Bonus 2</a>.</p>',Wt,Te,Ht,he,Vn=`Même sans évaluation directe, nous pouvons <strong>obtenir des informations sur la performance de notre système grâce à l’observabilité.</strong>
Ceci est particulièrement utile quand nous construisons des <em>workflows</em> plus complexes et que nous voulons comprendre comment chaque <em>component</em> performe.`,qt,f,je,kn="Installer LlamaTrace",At,Ie,En='Comme introduit dans la <a href="./llama-hub">section sur le LlamaHub</a>, nous pouvons installer le <em>callback</em> LlamaTrace d’Arize Phoenix avec la commande suivante :',Nt,xe,zt,_e,Bn="De plus, nous devons définir la variable d’environnement <code>PHOENIX_API_KEY</code> avec notre clé API LlamaTrace. Nous pouvons l’obtenir en :",Pt,$e,Rn='<li>Créant un compte sur <a href="https://llamatrace.com/login" rel="nofollow">LlamaTrace</a></li> <li>Générant une clé API dans les paramètres de votre compte</li> <li>Utilisant la clé API dans le code ci-dessous pour activer le <em>tracking</em></li>',Vt,Ue,kt,L,Xn='<p>Vous voulez en savoir plus sur les <i>components</i> et comment les utiliser ? Continuez votre parcours avec les <a href="https://docs.llamaindex.ai/en/stable/module_guides/"><i>Guides</i> des <i>components</i></a> ou le <a href="https://docs.llamaindex.ai/en/stable/understanding/rag/"><i>Guide</i> sur le RAG</a>.</p>',Et,Je,Sn="Nous avons vu comment utiliser les <em>components</em> pour créer un <code>QueryEngine</code>. Maintenant, voyons comment nous pouvons <strong>utiliser le <code>QueryEngine</code> comme un outil pour un agent !</strong>",Bt,we,Rt,He,Xt;return C=new Qn({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new Le({props:{title:"Que sont les components dans LlamaIndex ?",local:"que-sont-les-components-dans-llamaindex-",headingTag:"h1"}}),k=new Le({props:{title:"Créer un pipeline de RAG en utilisant des components",local:"créer-un-pipeline-de-rag-en-utilisant-des-components",headingTag:"h2"}}),X=new Le({props:{title:"Chargement et intégration des documents",local:"chargement-et-intégration-des-documents",headingTag:"h3"}}),A=new T({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBTaW1wbGVEaXJlY3RvcnlSZWFkZXIlMEElMEFyZWFkZXIlMjAlM0QlMjBTaW1wbGVEaXJlY3RvcnlSZWFkZXIoaW5wdXRfZGlyJTNEJTIycGF0aCUyRnRvJTJGZGlyZWN0b3J5JTIyKSUwQWRvY3VtZW50cyUyMCUzRCUyMHJlYWRlci5sb2FkX2RhdGEoKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> SimpleDirectoryReader

reader = SimpleDirectoryReader(input_dir=<span class="hljs-string">&quot;path/to/directory&quot;</span>)
documents = reader.load_data()`,wrap:!1}}),O=new T({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBEb2N1bWVudCUwQWZyb20lMjBsbGFtYV9pbmRleC5lbWJlZGRpbmdzLmh1Z2dpbmdmYWNlJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmclMEFmcm9tJTIwbGxhbWFfaW5kZXguY29yZS5ub2RlX3BhcnNlciUyMGltcG9ydCUyMFNlbnRlbmNlU3BsaXR0ZXIlMEFmcm9tJTIwbGxhbWFfaW5kZXguY29yZS5pbmdlc3Rpb24lMjBpbXBvcnQlMjBJbmdlc3Rpb25QaXBlbGluZSUwQSUwQSUyMyUyMGNyJUMzJUE5ZXIlMjBsZSUyMHBpcGVsaW5lJTIwYXZlYyUyMGxlcyUyMHRyYW5zZm9ybWF0aW9ucyUwQXBpcGVsaW5lJTIwJTNEJTIwSW5nZXN0aW9uUGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtYXRpb25zJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwU2VudGVuY2VTcGxpdHRlcihjaHVua19vdmVybGFwJTNEMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBIdWdnaW5nRmFjZUVtYmVkZGluZyhtb2RlbF9uYW1lJTNEJTIyQkFBSSUyRmJnZS1zbWFsbC1lbi12MS41JTIyKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSklMEElMEFub2RlcyUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUuYXJ1bihkb2N1bWVudHMlM0QlNUJEb2N1bWVudC5leGFtcGxlKCklNUQp",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> llama_index.embeddings.huggingface <span class="hljs-keyword">import</span> HuggingFaceEmbedding
<span class="hljs-keyword">from</span> llama_index.core.node_parser <span class="hljs-keyword">import</span> SentenceSplitter
<span class="hljs-keyword">from</span> llama_index.core.ingestion <span class="hljs-keyword">import</span> IngestionPipeline

<span class="hljs-comment"># créer le pipeline avec les transformations</span>
pipeline = IngestionPipeline(
    transformations=[
        SentenceSplitter(chunk_overlap=<span class="hljs-number">0</span>),
        HuggingFaceEmbedding(model_name=<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>),
    ]
)

nodes = <span class="hljs-keyword">await</span> pipeline.arun(documents=[Document.example()])`,wrap:!1}}),D=new Le({props:{title:"Stockage et indexation des documents",local:"stockage-et-indexation-des-documents",headingTag:"h3"}}),te=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxsYW1hLWluZGV4LXZlY3Rvci1zdG9yZXMtY2hyb21h",highlighted:"pip install llama-index-vector-stores-chroma",wrap:!1}}),ne=new T({props:{code:"aW1wb3J0JTIwY2hyb21hZGIlMEFmcm9tJTIwbGxhbWFfaW5kZXgudmVjdG9yX3N0b3Jlcy5jaHJvbWElMjBpbXBvcnQlMjBDaHJvbWFWZWN0b3JTdG9yZSUwQSUwQWRiJTIwJTNEJTIwY2hyb21hZGIuUGVyc2lzdGVudENsaWVudChwYXRoJTNEJTIyLiUyRmFsZnJlZF9jaHJvbWFfZGIlMjIpJTBBY2hyb21hX2NvbGxlY3Rpb24lMjAlM0QlMjBkYi5nZXRfb3JfY3JlYXRlX2NvbGxlY3Rpb24oJTIyYWxmcmVkJTIyKSUwQXZlY3Rvcl9zdG9yZSUyMCUzRCUyMENocm9tYVZlY3RvclN0b3JlKGNocm9tYV9jb2xsZWN0aW9uJTNEY2hyb21hX2NvbGxlY3Rpb24pJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBJbmdlc3Rpb25QaXBlbGluZSglMEElMjAlMjAlMjAlMjB0cmFuc2Zvcm1hdGlvbnMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTZW50ZW5jZVNwbGl0dGVyKGNodW5rX3NpemUlM0QyNSUyQyUyMGNodW5rX292ZXJsYXAlM0QwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEh1Z2dpbmdGYWNlRW1iZWRkaW5nKG1vZGVsX25hbWUlM0QlMjJCQUFJJTJGYmdlLXNtYWxsLWVuLXYxLjUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwdmVjdG9yX3N0b3JlJTNEdmVjdG9yX3N0b3JlJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> chromadb
<span class="hljs-keyword">from</span> llama_index.vector_stores.chroma <span class="hljs-keyword">import</span> ChromaVectorStore

db = chromadb.PersistentClient(path=<span class="hljs-string">&quot;./alfred_chroma_db&quot;</span>)
chroma_collection = db.get_or_create_collection(<span class="hljs-string">&quot;alfred&quot;</span>)
vector_store = ChromaVectorStore(chroma_collection=chroma_collection)

pipeline = IngestionPipeline(
    transformations=[
        SentenceSplitter(chunk_size=<span class="hljs-number">25</span>, chunk_overlap=<span class="hljs-number">0</span>),
        HuggingFaceEmbedding(model_name=<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>),
    ],
    vector_store=vector_store,
)`,wrap:!1}}),ie=new T({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBWZWN0b3JTdG9yZUluZGV4JTBBZnJvbSUyMGxsYW1hX2luZGV4LmVtYmVkZGluZ3MuaHVnZ2luZ2ZhY2UlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUVtYmVkZGluZyUwQSUwQWVtYmVkX21vZGVsJTIwJTNEJTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmcobW9kZWxfbmFtZSUzRCUyMkJBQUklMkZiZ2Utc21hbGwtZW4tdjEuNSUyMiklMEFpbmRleCUyMCUzRCUyMFZlY3RvclN0b3JlSW5kZXguZnJvbV92ZWN0b3Jfc3RvcmUodmVjdG9yX3N0b3JlJTJDJTIwZW1iZWRfbW9kZWwlM0RlbWJlZF9tb2RlbCk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> VectorStoreIndex
<span class="hljs-keyword">from</span> llama_index.embeddings.huggingface <span class="hljs-keyword">import</span> HuggingFaceEmbedding

embed_model = HuggingFaceEmbedding(model_name=<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>)
index = VectorStoreIndex.from_vector_store(vector_store, embed_model=embed_model)`,wrap:!1}}),re=new Le({props:{title:"Interroger un VectorStoreIndex avec des prompts et des LLM",local:"interroger-un-vectorstoreindex-avec-des-prompts-et-des-llm",headingTag:"h3"}}),de=new T({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmxsbXMuaHVnZ2luZ2ZhY2VfYXBpJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VJbmZlcmVuY2VBUEklMEElMEFsbG0lMjAlM0QlMjBIdWdnaW5nRmFjZUluZmVyZW5jZUFQSShtb2RlbF9uYW1lJTNEJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyKSUwQXF1ZXJ5X2VuZ2luZSUyMCUzRCUyMGluZGV4LmFzX3F1ZXJ5X2VuZ2luZSglMEElMjAlMjAlMjAlMjBsbG0lM0RsbG0lMkMlMEElMjAlMjAlMjAlMjByZXNwb25zZV9tb2RlJTNEJTIydHJlZV9zdW1tYXJpemUlMjIlMkMlMEEpJTBBcXVlcnlfZW5naW5lLnF1ZXJ5KCUyMldoYXQlMjBpcyUyMHRoZSUyMG1lYW5pbmclMjBvZiUyMGxpZmUlM0YlMjIpJTBBJTIzJTIwTGUlMjBzZW5zJTIwZGUlMjBsYSUyMHZpZSUyMGVzdCUyMDQy",highlighted:`<span class="hljs-keyword">from</span> llama_index.llms.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI

llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)
query_engine = index.as_query_engine(
    llm=llm,
    response_mode=<span class="hljs-string">&quot;tree_summarize&quot;</span>,
)
query_engine.query(<span class="hljs-string">&quot;What is the meaning of life?&quot;</span>)
<span class="hljs-comment"># Le sens de la vie est 42</span>`,wrap:!1}}),ce=new Le({props:{title:"Traitement des réponses",local:"traitement-des-réponses",headingTag:"h3"}}),be=new Le({props:{title:"Évaluation et observabilité",local:"évaluation-et-observabilité",headingTag:"h3"}}),Te=new T({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUuZXZhbHVhdGlvbiUyMGltcG9ydCUyMEZhaXRoZnVsbmVzc0V2YWx1YXRvciUwQSUwQXF1ZXJ5X2VuZ2luZSUyMCUzRCUyMCUyMyUyMGRlJTIwbGElMjBzZWN0aW9uJTIwcHIlQzMlQTljJUMzJUE5ZGVudGUlMEFsbG0lMjAlM0QlMjAlMjMlMjBkZSUyMGxhJTIwc2VjdGlvbiUyMHByJUMzJUE5YyVDMyVBOWRlbnRlJTBBJTBBJTIzJTIwaW5kZXglMjBkZXMlMjByZXF1JUMzJUFBdGVzJTBBZXZhbHVhdG9yJTIwJTNEJTIwRmFpdGhmdWxuZXNzRXZhbHVhdG9yKGxsbSUzRGxsbSklMEFyZXNwb25zZSUyMCUzRCUyMHF1ZXJ5X2VuZ2luZS5xdWVyeSglMEElMjAlMjAlMjAlMjAlMjJXaGF0JTIwYmF0dGxlcyUyMHRvb2slMjBwbGFjZSUyMGluJTIwTmV3JTIwWW9yayUyMENpdHklMjBpbiUyMHRoZSUyMEFtZXJpY2FuJTIwUmV2b2x1dGlvbiUzRiUyMiUwQSklMEFldmFsX3Jlc3VsdCUyMCUzRCUyMGV2YWx1YXRvci5ldmFsdWF0ZV9yZXNwb25zZShyZXNwb25zZSUzRHJlc3BvbnNlKSUwQWV2YWxfcmVzdWx0LnBhc3Npbmc=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.evaluation <span class="hljs-keyword">import</span> FaithfulnessEvaluator

query_engine = <span class="hljs-comment"># de la section précédente</span>
llm = <span class="hljs-comment"># de la section précédente</span>

<span class="hljs-comment"># index des requêtes</span>
evaluator = FaithfulnessEvaluator(llm=llm)
response = query_engine.query(
    <span class="hljs-string">&quot;What battles took place in New York City in the American Revolution?&quot;</span>
)
eval_result = evaluator.evaluate_response(response=response)
eval_result.passing`,wrap:!1}}),xe=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwbGxhbWEtaW5kZXgtY2FsbGJhY2tzLWFyaXplLXBob2VuaXg=",highlighted:"pip install -U llama-index-callbacks-arize-phoenix",wrap:!1}}),Ue=new T({props:{code:"aW1wb3J0JTIwbGxhbWFfaW5kZXglMEFpbXBvcnQlMjBvcyUwQSUwQVBIT0VOSVhfQVBJX0tFWSUyMCUzRCUyMCUyMiUzQ1BIT0VOSVhfQVBJX0tFWSUzRSUyMiUwQW9zLmVudmlyb24lNUIlMjJPVEVMX0VYUE9SVEVSX09UTFBfSEVBREVSUyUyMiU1RCUyMCUzRCUyMGYlMjJhcGlfa2V5JTNEJTdCUEhPRU5JWF9BUElfS0VZJTdEJTIyJTBBbGxhbWFfaW5kZXguY29yZS5zZXRfZ2xvYmFsX2hhbmRsZXIoJTBBJTIwJTIwJTIwJTIwJTIyYXJpemVfcGhvZW5peCUyMiUyQyUwQSUyMCUyMCUyMCUyMGVuZHBvaW50JTNEJTIyaHR0cHMlM0ElMkYlMkZsbGFtYXRyYWNlLmNvbSUyRnYxJTJGdHJhY2VzJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> llama_index
<span class="hljs-keyword">import</span> os

PHOENIX_API_KEY = <span class="hljs-string">&quot;&lt;PHOENIX_API_KEY&gt;&quot;</span>
os.environ[<span class="hljs-string">&quot;OTEL_EXPORTER_OTLP_HEADERS&quot;</span>] = <span class="hljs-string">f&quot;api_key=<span class="hljs-subst">{PHOENIX_API_KEY}</span>&quot;</span>
llama_index.core.set_global_handler(
    <span class="hljs-string">&quot;arize_phoenix&quot;</span>,
    endpoint=<span class="hljs-string">&quot;https://llamatrace.com/v1/traces&quot;</span>
)`,wrap:!1}}),we=new On({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit2/llama-index/components.mdx"}}),{c(){g=a("meta"),qe=l(),We=a("p"),Ve=l(),u(C.$$.fragment),ke=l(),u(j.$$.fragment),Ee=l(),I=a("p"),I.innerHTML=Ot,Be=l(),_=a("p"),_.innerHTML=Dt,Re=l(),$=a("p"),$.textContent=Kt,Xe=l(),G=a("p"),G.innerHTML=en,Se=l(),W=a("p"),W.textContent=tn,Ye=l(),H=a("ol"),H.innerHTML=nn,Fe=l(),q=a("p"),q.innerHTML=sn,Ae=l(),V=a("p"),V.innerHTML=ln,Ne=l(),u(k.$$.fragment),ze=l(),h=a("blockquote"),h.innerHTML=an,Pe=l(),E=a("p"),E.textContent=on,Qe=l(),B=a("ol"),B.innerHTML=rn,Oe=l(),R=a("p"),R.innerHTML=un,De=l(),u(X.$$.fragment),Ke=l(),S=a("p"),S.innerHTML=pn,et=l(),Y=a("ol"),Y.innerHTML=mn,tt=l(),x=a("blockquote"),x.innerHTML=dn,nt=l(),F=a("p"),F.innerHTML=cn,st=l(),u(A.$$.fragment),lt=l(),N=a("p"),N.innerHTML=vn,it=l(),z=a("p"),z.innerHTML=fn,at=l(),P=a("ol"),P.innerHTML=Mn,ot=l(),Q=a("p"),Q.textContent=bn,rt=l(),u(O.$$.fragment),ut=l(),u(D.$$.fragment),pt=l(),K=a("p"),K.innerHTML=yn,mt=l(),ee=a("p"),ee.innerHTML=gn,dt=l(),b=a("details"),Ze=a("summary"),Ze.textContent=Tn,Yt=l(),Ce=a("p"),Ce.innerHTML=hn,Ft=l(),u(te.$$.fragment),ct=l(),u(ne.$$.fragment),vt=l(),U=a("blockquote"),U.innerHTML=xn,ft=l(),se=a("p"),se.innerHTML=Un,Mt=l(),le=a("p"),le.innerHTML=Jn,bt=l(),u(ie.$$.fragment),yt=l(),ae=a("p"),ae.innerHTML=wn,gt=l(),oe=a("p"),oe.textContent=Ln,Tt=l(),u(re.$$.fragment),ht=l(),ue=a("p"),ue.textContent=Zn,xt=l(),pe=a("ul"),pe.innerHTML=Cn,Ut=l(),me=a("p"),me.innerHTML=jn,Jt=l(),u(de.$$.fragment),wt=l(),u(ce.$$.fragment),Lt=l(),ve=a("p"),ve.innerHTML=In,Zt=l(),fe=a("ul"),fe.innerHTML=_n,Ct=l(),J=a("blockquote"),J.innerHTML=$n,jt=l(),Me=a("p"),Me.innerHTML=Gn,It=l(),u(be.$$.fragment),_t=l(),ye=a("p"),ye.innerHTML=Wn,$t=l(),ge=a("ul"),ge.innerHTML=Hn,Gt=l(),w=a("blockquote"),w.innerHTML=qn,Wt=l(),u(Te.$$.fragment),Ht=l(),he=a("p"),he.innerHTML=Vn,qt=l(),f=a("details"),je=a("summary"),je.textContent=kn,At=l(),Ie=a("p"),Ie.innerHTML=En,Nt=l(),u(xe.$$.fragment),zt=l(),_e=a("p"),_e.innerHTML=Bn,Pt=l(),$e=a("ul"),$e.innerHTML=Rn,Vt=l(),u(Ue.$$.fragment),kt=l(),L=a("blockquote"),L.innerHTML=Xn,Et=l(),Je=a("p"),Je.innerHTML=Sn,Bt=l(),u(we.$$.fragment),Rt=l(),He=a("p"),this.h()},l(e){const t=Pn("svelte-u9bgzb",document.head);g=o(t,"META",{name:!0,content:!0}),t.forEach(n),qe=i(e),We=o(e,"P",{}),St(We).forEach(n),Ve=i(e),p(C.$$.fragment,e),ke=i(e),p(j.$$.fragment,e),Ee=i(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-pxwiak"&&(I.innerHTML=Ot),Be=i(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1xo4nsz"&&(_.innerHTML=Dt),Re=i(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-7uim2k"&&($.textContent=Kt),Xe=i(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-kysd50"&&(G.innerHTML=en),Se=i(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-44evoa"&&(W.textContent=tn),Ye=i(e),H=o(e,"OL",{"data-svelte-h":!0}),r(H)!=="svelte-jkh73n"&&(H.innerHTML=nn),Fe=i(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-nuxhg2"&&(q.innerHTML=sn),Ae=i(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-jft2l3"&&(V.innerHTML=ln),Ne=i(e),p(k.$$.fragment,e),ze=i(e),h=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-sfmym1"&&(h.innerHTML=an),Pe=i(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-fdg7ob"&&(E.textContent=on),Qe=i(e),B=o(e,"OL",{"data-svelte-h":!0}),r(B)!=="svelte-4vyxcq"&&(B.innerHTML=rn),Oe=i(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-r4hmjs"&&(R.innerHTML=un),De=i(e),p(X.$$.fragment,e),Ke=i(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1o5em1g"&&(S.innerHTML=pn),et=i(e),Y=o(e,"OL",{"data-svelte-h":!0}),r(Y)!=="svelte-15w64er"&&(Y.innerHTML=mn),tt=i(e),x=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(x)!=="svelte-t1xalt"&&(x.innerHTML=dn),nt=i(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1irm16k"&&(F.innerHTML=cn),st=i(e),p(A.$$.fragment,e),lt=i(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-ve0pqg"&&(N.innerHTML=vn),it=i(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-3a0x3m"&&(z.innerHTML=fn),at=i(e),P=o(e,"OL",{"data-svelte-h":!0}),r(P)!=="svelte-7go41n"&&(P.innerHTML=Mn),ot=i(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-12r0ioj"&&(Q.textContent=bn),rt=i(e),p(O.$$.fragment,e),ut=i(e),p(D.$$.fragment,e),pt=i(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1csphb"&&(K.innerHTML=yn),mt=i(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-198q9k7"&&(ee.innerHTML=gn),dt=i(e),b=o(e,"DETAILS",{});var Ge=St(b);Ze=o(Ge,"SUMMARY",{"data-svelte-h":!0}),r(Ze)!=="svelte-dldaxg"&&(Ze.textContent=Tn),Yt=i(Ge),Ce=o(Ge,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-p36gdx"&&(Ce.innerHTML=hn),Ft=i(Ge),p(te.$$.fragment,Ge),Ge.forEach(n),ct=i(e),p(ne.$$.fragment,e),vt=i(e),U=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(U)!=="svelte-vxu781"&&(U.innerHTML=xn),ft=i(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-wtcah1"&&(se.innerHTML=Un),Mt=i(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-fxvav0"&&(le.innerHTML=Jn),bt=i(e),p(ie.$$.fragment,e),yt=i(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1oy733j"&&(ae.innerHTML=wn),gt=i(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-t85ub1"&&(oe.textContent=Ln),Tt=i(e),p(re.$$.fragment,e),ht=i(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-v2d4vt"&&(ue.textContent=Zn),xt=i(e),pe=o(e,"UL",{"data-svelte-h":!0}),r(pe)!=="svelte-1d3fy2c"&&(pe.innerHTML=Cn),Ut=i(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-uizvd5"&&(me.innerHTML=jn),Jt=i(e),p(de.$$.fragment,e),wt=i(e),p(ce.$$.fragment,e),Lt=i(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1p7e1ed"&&(ve.innerHTML=In),Zt=i(e),fe=o(e,"UL",{"data-svelte-h":!0}),r(fe)!=="svelte-p8ghcu"&&(fe.innerHTML=_n),Ct=i(e),J=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-6r9frr"&&(J.innerHTML=$n),jt=i(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1gwo2kv"&&(Me.innerHTML=Gn),It=i(e),p(be.$$.fragment,e),_t=i(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1wjs2oa"&&(ye.innerHTML=Wn),$t=i(e),ge=o(e,"UL",{"data-svelte-h":!0}),r(ge)!=="svelte-m4seyd"&&(ge.innerHTML=Hn),Gt=i(e),w=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-1qwth2n"&&(w.innerHTML=qn),Wt=i(e),p(Te.$$.fragment,e),Ht=i(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1q5v3v8"&&(he.innerHTML=Vn),qt=i(e),f=o(e,"DETAILS",{});var y=St(f);je=o(y,"SUMMARY",{"data-svelte-h":!0}),r(je)!=="svelte-5rgs26"&&(je.textContent=kn),At=i(y),Ie=o(y,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-ytox17"&&(Ie.innerHTML=En),Nt=i(y),p(xe.$$.fragment,y),zt=i(y),_e=o(y,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1v3b2z0"&&(_e.innerHTML=Bn),Pt=i(y),$e=o(y,"UL",{"data-svelte-h":!0}),r($e)!=="svelte-c4es9c"&&($e.innerHTML=Rn),y.forEach(n),Vt=i(e),p(Ue.$$.fragment,e),kt=i(e),L=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(L)!=="svelte-1poxk2t"&&(L.innerHTML=Xn),Et=i(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-q0glse"&&(Je.innerHTML=Sn),Bt=i(e),p(we.$$.fragment,e),Rt=i(e),He=o(e,"P",{}),St(He).forEach(n),this.h()},h(){Z(g,"name","hf:doc:metadata"),Z(g,"content",Kn),Z(h,"class","tip"),Z(x,"class","tip"),Z(U,"class","tip"),Z(J,"class","tip"),Z(w,"class","tip"),Z(L,"class","tip")},m(e,t){M(document.head,g),s(e,qe,t),s(e,We,t),s(e,Ve,t),m(C,e,t),s(e,ke,t),m(j,e,t),s(e,Ee,t),s(e,I,t),s(e,Be,t),s(e,_,t),s(e,Re,t),s(e,$,t),s(e,Xe,t),s(e,G,t),s(e,Se,t),s(e,W,t),s(e,Ye,t),s(e,H,t),s(e,Fe,t),s(e,q,t),s(e,Ae,t),s(e,V,t),s(e,Ne,t),m(k,e,t),s(e,ze,t),s(e,h,t),s(e,Pe,t),s(e,E,t),s(e,Qe,t),s(e,B,t),s(e,Oe,t),s(e,R,t),s(e,De,t),m(X,e,t),s(e,Ke,t),s(e,S,t),s(e,et,t),s(e,Y,t),s(e,tt,t),s(e,x,t),s(e,nt,t),s(e,F,t),s(e,st,t),m(A,e,t),s(e,lt,t),s(e,N,t),s(e,it,t),s(e,z,t),s(e,at,t),s(e,P,t),s(e,ot,t),s(e,Q,t),s(e,rt,t),m(O,e,t),s(e,ut,t),m(D,e,t),s(e,pt,t),s(e,K,t),s(e,mt,t),s(e,ee,t),s(e,dt,t),s(e,b,t),M(b,Ze),M(b,Yt),M(b,Ce),M(b,Ft),m(te,b,null),s(e,ct,t),m(ne,e,t),s(e,vt,t),s(e,U,t),s(e,ft,t),s(e,se,t),s(e,Mt,t),s(e,le,t),s(e,bt,t),m(ie,e,t),s(e,yt,t),s(e,ae,t),s(e,gt,t),s(e,oe,t),s(e,Tt,t),m(re,e,t),s(e,ht,t),s(e,ue,t),s(e,xt,t),s(e,pe,t),s(e,Ut,t),s(e,me,t),s(e,Jt,t),m(de,e,t),s(e,wt,t),m(ce,e,t),s(e,Lt,t),s(e,ve,t),s(e,Zt,t),s(e,fe,t),s(e,Ct,t),s(e,J,t),s(e,jt,t),s(e,Me,t),s(e,It,t),m(be,e,t),s(e,_t,t),s(e,ye,t),s(e,$t,t),s(e,ge,t),s(e,Gt,t),s(e,w,t),s(e,Wt,t),m(Te,e,t),s(e,Ht,t),s(e,he,t),s(e,qt,t),s(e,f,t),M(f,je),M(f,At),M(f,Ie),M(f,Nt),m(xe,f,null),M(f,zt),M(f,_e),M(f,Pt),M(f,$e),s(e,Vt,t),m(Ue,e,t),s(e,kt,t),s(e,L,t),s(e,Et,t),s(e,Je,t),s(e,Bt,t),m(we,e,t),s(e,Rt,t),s(e,He,t),Xt=!0},p:Fn,i(e){Xt||(d(C.$$.fragment,e),d(j.$$.fragment,e),d(k.$$.fragment,e),d(X.$$.fragment,e),d(A.$$.fragment,e),d(O.$$.fragment,e),d(D.$$.fragment,e),d(te.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(re.$$.fragment,e),d(de.$$.fragment,e),d(ce.$$.fragment,e),d(be.$$.fragment,e),d(Te.$$.fragment,e),d(xe.$$.fragment,e),d(Ue.$$.fragment,e),d(we.$$.fragment,e),Xt=!0)},o(e){c(C.$$.fragment,e),c(j.$$.fragment,e),c(k.$$.fragment,e),c(X.$$.fragment,e),c(A.$$.fragment,e),c(O.$$.fragment,e),c(D.$$.fragment,e),c(te.$$.fragment,e),c(ne.$$.fragment,e),c(ie.$$.fragment,e),c(re.$$.fragment,e),c(de.$$.fragment,e),c(ce.$$.fragment,e),c(be.$$.fragment,e),c(Te.$$.fragment,e),c(xe.$$.fragment,e),c(Ue.$$.fragment,e),c(we.$$.fragment,e),Xt=!1},d(e){e&&(n(qe),n(We),n(Ve),n(ke),n(Ee),n(I),n(Be),n(_),n(Re),n($),n(Xe),n(G),n(Se),n(W),n(Ye),n(H),n(Fe),n(q),n(Ae),n(V),n(Ne),n(ze),n(h),n(Pe),n(E),n(Qe),n(B),n(Oe),n(R),n(De),n(Ke),n(S),n(et),n(Y),n(tt),n(x),n(nt),n(F),n(st),n(lt),n(N),n(it),n(z),n(at),n(P),n(ot),n(Q),n(rt),n(ut),n(pt),n(K),n(mt),n(ee),n(dt),n(b),n(ct),n(vt),n(U),n(ft),n(se),n(Mt),n(le),n(bt),n(yt),n(ae),n(gt),n(oe),n(Tt),n(ht),n(ue),n(xt),n(pe),n(Ut),n(me),n(Jt),n(wt),n(Lt),n(ve),n(Zt),n(fe),n(Ct),n(J),n(jt),n(Me),n(It),n(_t),n(ye),n($t),n(ge),n(Gt),n(w),n(Wt),n(Ht),n(he),n(qt),n(f),n(Vt),n(kt),n(L),n(Et),n(Je),n(Bt),n(Rt),n(He)),n(g),v(C,e),v(j,e),v(k,e),v(X,e),v(A,e),v(O,e),v(D,e),v(te),v(ne,e),v(ie,e),v(re,e),v(de,e),v(ce,e),v(be,e),v(Te,e),v(xe),v(Ue,e),v(we,e)}}}const Kn='{"title":"Que sont les components dans LlamaIndex ?","local":"que-sont-les-components-dans-llamaindex-","sections":[{"title":"Créer un pipeline de RAG en utilisant des components","local":"créer-un-pipeline-de-rag-en-utilisant-des-components","sections":[{"title":"Chargement et intégration des documents","local":"chargement-et-intégration-des-documents","sections":[],"depth":3},{"title":"Stockage et indexation des documents","local":"stockage-et-indexation-des-documents","sections":[],"depth":3},{"title":"Interroger un VectorStoreIndex avec des prompts et des LLM","local":"interroger-un-vectorstoreindex-avec-des-prompts-et-des-llm","sections":[],"depth":3},{"title":"Traitement des réponses","local":"traitement-des-réponses","sections":[],"depth":3},{"title":"Évaluation et observabilité","local":"évaluation-et-observabilité","sections":[],"depth":3}],"depth":2}],"depth":1}';function es(Qt){return An(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class as extends Nn{constructor(g){super(),zn(this,g,es,Dn,Yn,{})}}export{as as component};
