import{s as Al,a as kl,n as Sl,o as El}from"../chunks/scheduler.505acc25.js";import{S as _l,i as Nl,e as M,s as n,c as o,h as Hl,a as i,d as s,b as a,f as Ml,g as u,j as r,k as U,l as Rl,m as t,n as p,t as c,o as y,p as d}from"../chunks/index.b1175496.js";import{C as Yl,H as al}from"../chunks/Heading.988e52fa.js";import{C as j}from"../chunks/CodeBlock.ed64aebc.js";import{C as ql}from"../chunks/CourseFloatingBanner.79ef6243.js";import{E as $l}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.3d47a398.js";function Fl(il){let J,pe,oe,ce,I,ye,C,de,v,me,w,rl=`<p>Les exemples de cette section nécessitent l’accès à un modèle VLM puissant. Nous les avons testés en utilisant l’API GPT-4o.
Cependant, <a href="./why_use_smolagents">Pourquoi utiliser smolagents</a> discute des solutions alternatives supportées par smolagents et Hugging Face. Si vous souhaitez explorer d’autres options, assurez-vous de consulter cette section.</p>`,Ue,g,ol="Doter les agents de capacités visuelles est crucial pour résoudre des tâches qui vont au-delà du traitement de texte. De nombreux défis du monde réel, comme la navigation web ou la compréhension de documents, nécessitent d’analyser un contenu visuel riche. Heureusement, <code>smolagents</code> fournit un support intégré pour les modèles de vision-langage (VLM), permettant aux agents de traiter et d’interpréter efficacement les images.",Je,h,ul="Dans cet exemple, imaginez qu’Alfred soit chargé de vérifier les identités des invités assistant à la fête. Comme vous pouvez l’imaginer, Alfred pourrait ne pas être familier avec tout le monde. Pour l’aider, nous pouvons utiliser un agent qui vérifie leur identité en recherchant des informations visuelles sur leur apparence en utilisant un VLM. Cela permettra à Alfred de prendre des décisions éclairées sur qui peut entrer. Construisons cet exemple !",je,B,we,T,pl='<p>Vous pouvez suivre le code dans <a href="https://huggingface.co/agents-course/notebooks/blob/main/fr/unit2/smolagents/vision_agents.ipynb" target="_blank">ce <i>notebook</i></a> que vous pouvez exécuter avec Google Colab.</p>',Te,Z,cl="Dans cette approche, les images sont transmises à l’agent au début et stockées comme <code>task_images</code> avec le <em>prompt</em> de tâche. L’agent traite ensuite ces images tout au long de son exécution.",be,f,yl="Considérez le cas où Alfred veut vérifier les identités des super-héros assistant à la fête. Il a déjà un jeu de données d’images de fêtes précédentes avec les noms des invités. Étant donné l’image d’un nouveau visiteur, l’agent peut la comparer avec le jeu de données existant et prendre une décision sur leur entrée.",Ie,V,dl="Dans ce cas, un invité essaie d’entrer, et Alfred soupçonne que ce visiteur pourrait être le Joker se faisant passer pour Wonder Woman. Alfred doit vérifier les identités pour empêcher quiconque d’indésirable d’entrer.",Ce,G,ml="Construisons l’exemple. D’abord, les images sont chargées. Dans ce cas, nous utilisons des images de Wikipédia pour garder l’exemple minimaliste, mais imaginez les cas d’usage possibles !",ve,W,ge,x,Ul="Maintenant que nous avons les images, l’agent nous dira si un invité est vraiment un super-héros (Wonder Woman) ou un méchant (le Joker).",he,z,Be,Q,Jl="Dans le cas de mon exécution, la sortie est la suivante, bien qu’elle puisse varier dans votre cas, comme nous l’avons déjà discuté :",Ze,X,fe,A,jl="Dans ce cas, la sortie révèle que la personne se fait passer pour quelqu’un d’autre, donc nous pouvons empêcher le Joker d’entrer à la fête !",Ve,k,Ge,b,wl='<p>Vous pouvez suivre le code dans <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/vision_web_browser.py" target="_blank">ce fichier Python</a></p>',We,S,Tl="L’approche précédente est précieuse et a de nombreux cas d’usage potentiels. Cependant, dans des situations où l’invité n’est pas dans la base de données, nous devons explorer d’autres façons de les identifier. Une solution possible est de récupérer dynamiquement des images et des informations à partir de sources externes, comme naviguer sur le web pour des détails.",xe,E,bl="Dans cette approche, les images sont ajoutées dynamiquement à la mémoire de l’agent pendant l’exécution. Comme nous le savons, les agents dans <code>smolagents</code> sont basés sur la classe <code>MultiStepAgent</code>, qui est une abstraction du <em>framework ReAct</em>. Cette classe opère dans un cycle structuré où diverses variables et connaissances sont enregistrées à différentes étapes :",ze,_,Il="<li><strong>SystemPromptStep :</strong> Stocke le <em>prompt</em> système.</li> <li><strong>TaskStep :</strong> Enregistre la requête utilisateur et toute entrée fournie.</li> <li><strong>ActionStep :</strong> Capture les logs des actions de l’agent et les résultats.</li>",Qe,N,Cl="Cette approche structurée permet aux agents d’incorporer des informations visuelles dynamiquement et de répondre de manière adaptative aux tâches évolutives. Ci-dessous se trouve le diagramme que nous avons déjà vu, illustrant le processus de flux de travail dynamique et comment différentes étapes s’intègrent dans le cycle de vie de l’agent. Lors de la navigation, l’agent peut prendre des captures d’écran et les sauvegarder comme <code>observation_images</code> dans l’<code>ActionStep</code>.",Xe,H,vl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/smolagents-can-see/diagram_adding_vlms_smolagents.png" alt="Récupération d&#39;images dynamique"/>',Ae,R,gl="Maintenant que nous comprenons le besoin, construisons notre exemple complet. Dans ce cas, Alfred veut un contrôle total sur le processus de vérification des invités, donc naviguer pour des détails devient une solution viable. Pour compléter cet exemple, nous avons besoin d’un nouvel ensemble d’outils pour l’agent. De plus, nous utiliserons Selenium et Helium, qui sont des outils d’automatisation de navigateur. Cela nous permettra de construire un agent qui explore le web, recherchant des détails sur un invité potentiel et récupérant des informations de vérification. Installons les outils nécessaires :",ke,Y,Se,q,hl="Nous aurons besoin d’un ensemble d’outils d’agent spécifiquement conçus pour la navigation, tels que <code>search_item_ctrl_f</code>, <code>go_back</code> et <code>close_popups</code>. Ces outils permettent à l’agent d’agir comme une personne naviguant sur le web.",Ee,$,_e,F,Bl="Nous avons également besoin de fonctionnalités pour sauvegarder des captures d’écran, car ce sera une partie essentielle de ce que notre agent <em>VLM</em> utilise pour accomplir la tâche. Cette fonctionnalité prend la capture d’écran et la sauvegarde dans <code>step_log.observations_images = [image.copy()]</code>, permettant à l’agent de stocker et traiter les images dynamiquement pendant qu’il navigue.",Ne,L,He,D,Zl="Cette fonction est passée à l’agent comme <code>step_callback</code>, car elle est déclenchée à la fin de chaque étape pendant l’exécution de l’agent. Cela permet à l’agent de capturer et stocker dynamiquement des captures d’écran tout au long de son processus.",Re,P,fl="Maintenant, nous pouvons générer notre agent de vision pour naviguer sur le web, en lui fournissant les outils que nous avons créés, avec le <code>DuckDuckGoSearchTool</code> pour explorer le web. Cet outil aidera l’agent à récupérer les informations nécessaires pour vérifier les identités des invités basées sur des indices visuels.",Ye,K,qe,O,Vl="Avec cela, Alfred est prêt à vérifier les identités des invités et prendre des décisions éclairées sur s’il faut les laisser entrer ou non à la fête :",$e,ee,Fe,le,Gl="Vous pouvez voir que nous incluons <code>helium_instructions</code> dans le cadre de la tâche. Ce <em>prompt</em> spécial vise à contrôler la navigation de l’agent, s’assurant qu’il suit les bonnes étapes lors de la navigation web.",Le,se,Wl="Voyons comment cela fonctionne dans la vidéo ci-dessous :",De,m,xl,Pe,te,zl="C’est la sortie finale :",Ke,ne,Oe,ae,Ql="Avec tout cela, nous avons créé avec succès notre vérificateur d’identité pour la fête ! Alfred a maintenant les outils nécessaires pour s’assurer que seuls les bons invités franchissent la porte. Tout est prêt pour passer du bon temps au manoir Wayne !",el,Me,ll,ie,Xl='<li><a href="https://huggingface.co/blog/smolagents-can-see" rel="nofollow">Nous venons de donner la vue à smolagents</a> - Blog décrivant la fonctionnalité d’agent visuel.</li> <li><a href="https://huggingface.co/docs/smolagents/examples/web_browser" rel="nofollow">Automatisation de navigateur web avec agents 🤖🌐</a> - Exemple pour la navigation web utilisant un agent visuel.</li> <li><a href="https://github.com/huggingface/smolagents/blob/main/src/smolagents/vision_web_browser.py" rel="nofollow">Exemple d’agent visuel pour navigateur web</a> - Exemple pour la navigation web utilisant un agent visuel.</li>',sl,re,tl,ue,nl;return I=new ql({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https://huggingface.co/agents-course/notebooks/blob/main/fr/unit2/smolagents/vision_agents.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),C=new Yl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),v=new al({props:{title:"Agents visuel avec smolagents",local:"agents-visuel-avec-smolagents",headingTag:"h1"}}),B=new al({props:{title:"Fournir des images au début de l’exécution de l’agent",local:"fournir-des-images-au-début-de-lexécution-de-lagent",headingTag:"h2"}}),W=new j({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBJTBBaW1hZ2VfdXJscyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGZSUyRmU4JTJGVGhlX0pva2VyX2F0X1dheF9NdXNldW1fUGx1cy5qcGclMjIlMkMlMjAlMjMlMjBJbWFnZSUyMGR1JTIwSm9rZXIlMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGZW4lMkY5JTJGOTglMkZKb2tlcl8lMjUyOERDX0NvbWljc19jaGFyYWN0ZXIlMjUyOS5qcGclMjIlMjAlMjMlMjBJbWFnZSUyMGR1JTIwSm9rZXIlMEElNUQlMEElMEFpbWFnZXMlMjAlM0QlMjAlNUIlNUQlMEFmb3IlMjB1cmwlMjBpbiUyMGltYWdlX3VybHMlM0ElMEElMjAlMjAlMjAlMjBoZWFkZXJzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyVXNlci1BZ2VudCUyMiUzQSUyMCUyMk1vemlsbGElMkY1LjAlMjAoV2luZG93cyUyME5UJTIwMTAuMCUzQiUyMFdpbjY0JTNCJTIweDY0KSUyMEFwcGxlV2ViS2l0JTJGNTM3LjM2JTIwKEtIVE1MJTJDJTIwbGlrZSUyMEdlY2tvKSUyMENocm9tZSUyRjExNC4wLjAuMCUyMFNhZmFyaSUyRjUzNy4zNiUyMiUyMCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCUyQ2hlYWRlcnMlM0RoZWFkZXJzKSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMjAlMjAlMjAlMjBpbWFnZXMuYXBwZW5kKGltYWdlKQ==",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

image_urls = [
    <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/e/e8/The_Joker_at_Wax_Museum_Plus.jpg&quot;</span>, <span class="hljs-comment"># Image du Joker</span>
    <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/en/9/98/Joker_%28DC_Comics_character%29.jpg&quot;</span> <span class="hljs-comment"># Image du Joker</span>
]

images = []
<span class="hljs-keyword">for</span> url <span class="hljs-keyword">in</span> image_urls:
    headers = {
        <span class="hljs-string">&quot;User-Agent&quot;</span>: <span class="hljs-string">&quot;Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36&quot;</span> 
    }
    response = requests.get(url,headers=headers)
    image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
    images.append(image)`,wrap:!1}}),z=new j({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBPcGVuQUlTZXJ2ZXJNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwT3BlbkFJU2VydmVyTW9kZWwobW9kZWxfaWQlM0QlMjJncHQtNG8lMjIpJTBBJTBBJTIzJTIwSW5zdGFuY2llciUyMGwnYWdlbnQlMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QiU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0QyMCUyQyUwQSUyMCUyMCUyMCUyMHZlcmJvc2l0eV9sZXZlbCUzRDIlMEEpJTBBJTBBcmVzcG9uc2UlMjAlM0QlMjBhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwRCVDMyVBOWNyaXJlJTIwbGUlMjBjb3N0dW1lJTIwZXQlMjBsZSUyMG1hcXVpbGxhZ2UlMjBxdWUlMjBwb3J0ZSUyMGxlJTIwcGVyc29ubmFnZSUyMGRlJTIwYmFuZGUlMjBkZXNzaW4lQzMlQTllJTIwZmlndXJhbnQlMjBzdXIlMjBjZXMlMjBwaG90b3MlMjBldCUyMHJlbnZveWVyJTIwbGElMjBkZXNjcmlwdGlvbi4lMEElMjAlMjAlMjAlMjBJbmRpcXVlciUyMHNpJTIwbCdpbnZpdCVDMyVBOSUyMGVzdCUyMGxlJTIwSm9rZXIlMjBvdSUyMFdvbmRlciUyMFdvbWFuLiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMGltYWdlcyUzRGltYWdlcyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, OpenAIServerModel

model = OpenAIServerModel(model_id=<span class="hljs-string">&quot;gpt-4o&quot;</span>)

<span class="hljs-comment"># Instancier l&#x27;agent</span>
agent = CodeAgent(
    tools=[],
    model=model,
    max_steps=<span class="hljs-number">20</span>,
    verbosity_level=<span class="hljs-number">2</span>
)

response = agent.run(
    <span class="hljs-string">&quot;&quot;&quot;
    Décrire le costume et le maquillage que porte le personnage de bande dessinée figurant sur ces photos et renvoyer la description.
    Indiquer si l&#x27;invité est le Joker ou Wonder Woman.
    &quot;&quot;&quot;</span>,
    images=images
)`,wrap:!1}}),X=new j({props:{code:"JTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ0Nvc3R1bWUlMjBldCUyMG1hcXVpbGxhZ2UlMjAtJTIwUHJlbWklQzMlQThyZSUyMGltYWdlJyUzQSUyMCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAnTWFudGVhdSUyMHZpb2xldCUyMGV0JTIwdW5lJTIwY3JhdmF0ZSUyMG91JTIwbiVDNSU5M3VkJTIwcGFwaWxsb24lMjBkZSUyMHNvaWUlMjB2aW9sZXR0ZSUyMHN1ciUyMHVuZSUyMGNoZW1pc2UlMjBqYXVuZSUyMG1vdXRhcmRlLiclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAnUGVpbnR1cmUlMjBmYWNpYWxlJTIwYmxhbmNoZSUyMGF2ZWMlMjBkZXMlMjB0cmFpdHMlMjBleGFnJUMzJUE5ciVDMyVBOXMlMkMlMjBzb3VyY2lscyUyMHNvbWJyZXMlMkMlMjBtYXF1aWxsYWdlJTIwZGVzJTIweWV1eCUyMGJsZXUlMkMlMjBsJUMzJUE4dnJlcyUyMHJvdWdlcyUyMGZvcm1hbnQlMjB1biUyMGxhcmdlJTIwc291cmlyZS4nJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdDb3N0dW1lJTIwZXQlMjBtYXF1aWxsYWdlJTIwLSUyMERldXhpJUMzJUE4bWUlMjBpbWFnZSclM0ElMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ0Nvc3R1bWUlMjBzb21icmUlMjBhdmVjJTIwdW5lJTIwZmxldXIlMjBzdXIlMjBsZSUyMHJldmVycyUyQyUyMHRlbmFudCUyMHVuZSUyMGNhcnRlJTIwJUMzJUEwJTIwam91ZXIuJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdQZWF1JTIwcCVDMyVBMmxlJTJDJTIwY2hldmV1eCUyMHZlcnRzJTJDJTIwbCVDMyVBOHZyZXMlMjB0ciVDMyVBOHMlMjByb3VnZXMlMjBhdmVjJTIwdW4lMjBzb3VyaXJlJTIwZXhhZyVDMyVBOXIlQzMlQTkuJyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAnSWRlbnRpdCVDMyVBOSUyMGR1JTIwcGVyc29ubmFnZSclM0ElMjAnQ2UlMjBwZXJzb25uYWdlJTIwcmVzc2VtYmxlJTIwYXV4JTIwcmVwciVDMyVBOXNlbnRhdGlvbnMlMjBjb25udWVzJTIwZHUlMjBKb2tlciUyMGRlcyUyMG0lQzMlQTlkaWFzJTIwZGUlMjBiYW5kZSUyMGRlc3NpbiVDMyVBOWUuJyUwQSUyMCUyMCUyMCUyMCU3RA==",highlighted:`    {
        <span class="hljs-string">&#x27;Costume et maquillage - Première image&#x27;</span>: (
            <span class="hljs-string">&#x27;Manteau violet et une cravate ou nœud papillon de soie violette sur une chemise jaune moutarde.&#x27;</span>,
            <span class="hljs-string">&#x27;Peinture faciale blanche avec des traits exagérés, sourcils sombres, maquillage des yeux bleu, lèvres rouges formant un large sourire.&#x27;</span>
        ),
        <span class="hljs-string">&#x27;Costume et maquillage - Deuxième image&#x27;</span>: (
            <span class="hljs-string">&#x27;Costume sombre avec une fleur sur le revers, tenant une carte à jouer.&#x27;</span>,
            <span class="hljs-string">&#x27;Peau pâle, cheveux verts, lèvres très rouges avec un sourire exagéré.&#x27;</span>
        ),
        <span class="hljs-string">&#x27;Identité du personnage&#x27;</span>: <span class="hljs-string">&#x27;Ce personnage ressemble aux représentations connues du Joker des médias de bande dessinée.&#x27;</span>
    }`,wrap:!1}}),k=new al({props:{title:"Fournir des images avec recherche dynamique",local:"fournir-des-images-avec-recherche-dynamique",headingTag:"h2"}}),Y=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMnNtb2xhZ2VudHMlNUJhbGwlNUQlMjIlMjBoZWxpdW0lMjBzZWxlbml1bSUyMHB5dGhvbi1kb3RlbnY=",highlighted:'pip install <span class="hljs-string">&quot;smolagents[all]&quot;</span> helium selenium python-dotenv',wrap:!1}}),$=new j({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">search_item_ctrl_f</span>(<span class="hljs-params">text: <span class="hljs-built_in">str</span>, nth_result: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Recherche du texte sur la page actuelle via Ctrl + F et saute à la nième occurrence.
    Args:
        text: Le texte à rechercher
        nth_result: Quelle occurrence aller (par défaut: 1)
    &quot;&quot;&quot;</span>
    elements = driver.find_elements(By.XPATH, <span class="hljs-string">f&quot;//*[contains(text(), &#x27;<span class="hljs-subst">{text}</span>&#x27;)]&quot;</span>)
    <span class="hljs-keyword">if</span> nth_result &gt; <span class="hljs-built_in">len</span>(elements):
        <span class="hljs-keyword">raise</span> Exception(<span class="hljs-string">f&quot;Correspondance n°<span class="hljs-subst">{nth_result}</span> non trouvée (seulement <span class="hljs-subst">{<span class="hljs-built_in">len</span>(elements)}</span> correspondances trouvées)&quot;</span>)
    result = <span class="hljs-string">f&quot;Trouvé <span class="hljs-subst">{<span class="hljs-built_in">len</span>(elements)}</span> correspondances pour &#x27;<span class="hljs-subst">{text}</span>&#x27;.&quot;</span>
    elem = elements[nth_result - <span class="hljs-number">1</span>]
    driver.execute_script(<span class="hljs-string">&quot;arguments[0].scrollIntoView(true);&quot;</span>, elem)
    result += <span class="hljs-string">f&quot;Focalisé sur l&#x27;élément <span class="hljs-subst">{nth_result}</span> de <span class="hljs-subst">{<span class="hljs-built_in">len</span>(elements)}</span>&quot;</span>
    <span class="hljs-keyword">return</span> result


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">go_back</span>() -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-string">&quot;&quot;&quot;Retourne à la page précédente.&quot;&quot;&quot;</span>
    driver.back()


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">close_popups</span>() -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Ferme tout modal ou pop-up visible sur la page. Utilise ceci pour fermer les fenêtres pop-up ! Cela ne fonctionne pas sur les bannières de consentement de cookies.
    &quot;&quot;&quot;</span>
    webdriver.ActionChains(driver).send_keys(Keys.ESCAPE).perform()`,wrap:!1}}),L=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">save_screenshot</span>(<span class="hljs-params">step_log: ActionStep, agent: CodeAgent</span>) -&gt; <span class="hljs-literal">None</span>:
    sleep(<span class="hljs-number">1.0</span>)  <span class="hljs-comment"># Laisser les animations JavaScript se produire avant de prendre la capture d&#x27;écran</span>
    driver = helium.get_driver()
    current_step = step_log.step_number
    <span class="hljs-keyword">if</span> driver <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">for</span> step_logs <span class="hljs-keyword">in</span> agent.logs:  <span class="hljs-comment"># Supprimer les captures d&#x27;écran précédentes des logs pour un traitement allégé</span>
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(step_log, ActionStep) <span class="hljs-keyword">and</span> step_log.step_number &lt;= current_step - <span class="hljs-number">2</span>:
                step_logs.observations_images = <span class="hljs-literal">None</span>
        png_bytes = driver.get_screenshot_as_png()
        image = Image.<span class="hljs-built_in">open</span>(BytesIO(png_bytes))
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Capture d&#x27;écran de navigateur capturée : <span class="hljs-subst">{image.size}</span> pixels&quot;</span>)
        step_log.observations_images = [image.copy()]  <span class="hljs-comment"># Créer une copie pour s&#x27;assurer qu&#x27;elle persiste, important !</span>

    <span class="hljs-comment"># Mettre à jour les observations avec l&#x27;URL actuelle</span>
    url_info = <span class="hljs-string">f&quot;URL actuelle : <span class="hljs-subst">{driver.current_url}</span>&quot;</span>
    step_log.observations = url_info <span class="hljs-keyword">if</span> step_logs.observations <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> step_log.observations + <span class="hljs-string">&quot;\\n&quot;</span> + url_info
    <span class="hljs-keyword">return</span>`,wrap:!1}}),K=new j({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBPcGVuQUlTZXJ2ZXJNb2RlbCUyQyUyMER1Y2tEdWNrR29TZWFyY2hUb29sJTBBbW9kZWwlMjAlM0QlMjBPcGVuQUlTZXJ2ZXJNb2RlbChtb2RlbF9pZCUzRCUyMmdwdC00byUyMiklMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QkR1Y2tEdWNrR29TZWFyY2hUb29sKCklMkMlMjBnb19iYWNrJTJDJTIwY2xvc2VfcG9wdXBzJTJDJTIwc2VhcmNoX2l0ZW1fY3RybF9mJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFkZGl0aW9uYWxfYXV0aG9yaXplZF9pbXBvcnRzJTNEJTVCJTIyaGVsaXVtJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc3RlcF9jYWxsYmFja3MlM0QlNUJzYXZlX3NjcmVlbnNob3QlNUQlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0QyMCUyQyUwQSUyMCUyMCUyMCUyMHZlcmJvc2l0eV9sZXZlbCUzRDIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, OpenAIServerModel, DuckDuckGoSearchTool
model = OpenAIServerModel(model_id=<span class="hljs-string">&quot;gpt-4o&quot;</span>)

agent = CodeAgent(
    tools=[DuckDuckGoSearchTool(), go_back, close_popups, search_item_ctrl_f],
    model=model,
    additional_authorized_imports=[<span class="hljs-string">&quot;helium&quot;</span>],
    step_callbacks=[save_screenshot],
    max_steps=<span class="hljs-number">20</span>,
    verbosity_level=<span class="hljs-number">2</span>,
)`,wrap:!1}}),ee=new j({props:{code:"YWdlbnQucnVuKCUyMiUyMiUyMiUwQUplJTIwc3VpcyUyMEFsZnJlZCUyQyUyMGxlJTIwbWFqb3Jkb21lJTIwZHUlMjBtYW5vaXIlMjBXYXluZSUyQyUyMGNoYXJnJUMzJUE5JTIwZGUlMjB2JUMzJUE5cmlmaWVyJTIwbCdpZGVudGl0JUMzJUE5JTIwZGVzJTIwaW52aXQlQzMlQTlzJTIwJUMzJUEwJTIwdW5lJTIwZiVDMyVBQXRlLiUyMFVuZSUyMHN1cGVyLWglQzMlQTlybyVDMyVBRm5lJTIwc2UlMjBwciVDMyVBOXNlbnRlJTIwJUMzJUEwJTIwbCdlbnRyJUMzJUE5ZSUyMGVuJTIwcHIlQzMlQTl0ZW5kYW50JTIwJUMzJUFBdHJlJTIwV29uZGVyJTIwV29tYW4lMkMlMjBtYWlzJTIwamUlMjBkb2lzJTIwdiVDMyVBOXJpZmllciUyMHNpJTIwZWxsZSUyMGVzdCUyMGJpZW4lMjBjZWxsZSUyMHF1J2VsbGUlMjBwciVDMyVBOXRlbmQlMjAlQzMlQUF0cmUuJTBBJTBBVmV1aWxsZXolMjByZWNoZXJjaGVyJTIwZGVzJTIwaW1hZ2VzJTIwZGUlMjBXb25kZXIlMjBXb21hbiUyMGV0JTIwZyVDMyVBOW4lQzMlQTlyZXIlMjB1bmUlMjBkZXNjcmlwdGlvbiUyMHZpc3VlbGxlJTIwZCVDMyVBOXRhaWxsJUMzJUE5ZSUyMCVDMyVBMCUyMHBhcnRpciUyMGRlJTIwY2VzJTIwaW1hZ2VzLiUyMERlJTIwcGx1cyUyQyUyMG5hdmlndWV6JTIwc3VyJTIwV2lraXAlQzMlQTlkaWElMjBwb3VyJTIwcmVjdWVpbGxpciUyMGRlcyUyMGQlQzMlQTl0YWlscyUyMGNsJUMzJUE5cyUyMHN1ciUyMHNvbiUyMGFwcGFyZW5jZS4lMjBHciVDMyVBMmNlJTIwJUMzJUEwJTIwY2VzJTIwaW5mb3JtYXRpb25zJTJDJTIwamUlMjBwb3VycmFpJTIwZCVDMyVBOXRlcm1pbmVyJTIwcydpbCUyMGNvbnZpZW50JTIwZGUlMjBsdWklMjBhY2NvcmRlciUyMGwnYWNjJUMzJUE4cyUyMCVDMyVBMCUyMGwnJUMzJUE5diVDMyVBOW5lbWVudC4lMEElMjIlMjIlMjIlMjAlMkIlMjBoZWxpdW1faW5zdHJ1Y3Rpb25zKQ==",highlighted:`agent.run(<span class="hljs-string">&quot;&quot;&quot;
Je suis Alfred, le majordome du manoir Wayne, chargé de vérifier l&#x27;identité des invités à une fête. Une super-héroïne se présente à l&#x27;entrée en prétendant être Wonder Woman, mais je dois vérifier si elle est bien celle qu&#x27;elle prétend être.

Veuillez rechercher des images de Wonder Woman et générer une description visuelle détaillée à partir de ces images. De plus, naviguez sur Wikipédia pour recueillir des détails clés sur son apparence. Grâce à ces informations, je pourrai déterminer s&#x27;il convient de lui accorder l&#x27;accès à l&#x27;événement.
&quot;&quot;&quot;</span> + helium_instructions)`,wrap:!1}}),ne=new j({props:{code:"UiVDMyVBOXBvbnNlJTIwZmluYWxlJTIwJTNBJTIwV29uZGVyJTIwV29tYW4lMjBlc3QlMjB0eXBpcXVlbWVudCUyMHJlcHIlQzMlQTlzZW50JUMzJUE5ZSUyMHBvcnRhbnQlMjB1biUyMGJ1c3RpZXIlMjByb3VnZSUyMGV0JTIwb3IlMkMlMjB1biUyMHNob3J0JTIwb3UlMjB1bmUlMjBqdXBlJTIwYmxldSUyMGF2ZWMlMjBkZXMlMjAlQzMlQTl0b2lsZXMlMjBibGFuY2hlcyUyQyUyMHVuJTIwdGlhcmUlMjBkb3IlQzMlQTklMkMlMjBkZXMlMjBicmFjZWxldHMlMjBhcmdlbnQlQzMlQTlzJTIwZXQlMjB1biUyMGxhc3NvJTIwZGUlMjB2JUMzJUE5cml0JUMzJUE5JTIwZG9yJUMzJUE5LiUyMEVsbGUlMjBlc3QlMjBsYSUyMFByaW5jZXNzZSUyMERpYW5hJTIwZGUlMjBUaGVteXNjaXJhJTJDJTIwY29ubnVlJTIwc291cyUyMGxlJTIwbm9tJTIwZGUlMjBEaWFuYSUyMFByaW5jZSUyMGRhbnMlMjBsZSUyMG1vbmRlJTIwZGVzJTIwaG9tbWVzLg==",highlighted:'Réponse finale : Wonder Woman est typiquement <span class="hljs-built_in">repr</span>ésentée portant un bustier rouge et <span class="hljs-keyword">or</span>, un short ou une jupe bleu avec des étoiles blanches, un tiare doré, des bracelets argentés et un lasso de vérité doré. Elle est la Princesse Diana de Themyscira, connue sous le nom de Diana Prince dans le monde des hommes.',wrap:!1}}),Me=new al({props:{title:"Lectures complémentaires",local:"lectures-complémentaires",headingTag:"h2"}}),re=new $l({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit2/smolagents/vision_agents.mdx"}}),{c(){J=M("meta"),pe=n(),oe=M("p"),ce=n(),o(I.$$.fragment),ye=n(),o(C.$$.fragment),de=n(),o(v.$$.fragment),me=n(),w=M("blockquote"),w.innerHTML=rl,Ue=n(),g=M("p"),g.innerHTML=ol,Je=n(),h=M("p"),h.textContent=ul,je=n(),o(B.$$.fragment),we=n(),T=M("blockquote"),T.innerHTML=pl,Te=n(),Z=M("p"),Z.innerHTML=cl,be=n(),f=M("p"),f.textContent=yl,Ie=n(),V=M("p"),V.textContent=dl,Ce=n(),G=M("p"),G.textContent=ml,ve=n(),o(W.$$.fragment),ge=n(),x=M("p"),x.textContent=Ul,he=n(),o(z.$$.fragment),Be=n(),Q=M("p"),Q.textContent=Jl,Ze=n(),o(X.$$.fragment),fe=n(),A=M("p"),A.textContent=jl,Ve=n(),o(k.$$.fragment),Ge=n(),b=M("blockquote"),b.innerHTML=wl,We=n(),S=M("p"),S.textContent=Tl,xe=n(),E=M("p"),E.innerHTML=bl,ze=n(),_=M("ol"),_.innerHTML=Il,Qe=n(),N=M("p"),N.innerHTML=Cl,Xe=n(),H=M("p"),H.innerHTML=vl,Ae=n(),R=M("p"),R.textContent=gl,ke=n(),o(Y.$$.fragment),Se=n(),q=M("p"),q.innerHTML=hl,Ee=n(),o($.$$.fragment),_e=n(),F=M("p"),F.innerHTML=Bl,Ne=n(),o(L.$$.fragment),He=n(),D=M("p"),D.innerHTML=Zl,Re=n(),P=M("p"),P.innerHTML=fl,Ye=n(),o(K.$$.fragment),qe=n(),O=M("p"),O.textContent=Vl,$e=n(),o(ee.$$.fragment),Fe=n(),le=M("p"),le.innerHTML=Gl,Le=n(),se=M("p"),se.textContent=Wl,De=n(),m=M("iframe"),Pe=n(),te=M("p"),te.textContent=zl,Ke=n(),o(ne.$$.fragment),Oe=n(),ae=M("p"),ae.textContent=Ql,el=n(),o(Me.$$.fragment),ll=n(),ie=M("ul"),ie.innerHTML=Xl,sl=n(),o(re.$$.fragment),tl=n(),ue=M("p"),this.h()},l(e){const l=Hl("svelte-u9bgzb",document.head);J=i(l,"META",{name:!0,content:!0}),l.forEach(s),pe=a(e),oe=i(e,"P",{}),Ml(oe).forEach(s),ce=a(e),u(I.$$.fragment,e),ye=a(e),u(C.$$.fragment,e),de=a(e),u(v.$$.fragment,e),me=a(e),w=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-3jwbu0"&&(w.innerHTML=rl),Ue=a(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-6ztx2x"&&(g.innerHTML=ol),Je=a(e),h=i(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-1qmyj0j"&&(h.textContent=ul),je=a(e),u(B.$$.fragment,e),we=a(e),T=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-ywjpbd"&&(T.innerHTML=pl),Te=a(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1v2ce0k"&&(Z.innerHTML=cl),be=a(e),f=i(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1ml1e3g"&&(f.textContent=yl),Ie=a(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1j4px62"&&(V.textContent=dl),Ce=a(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1tlleim"&&(G.textContent=ml),ve=a(e),u(W.$$.fragment,e),ge=a(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-5d68zl"&&(x.textContent=Ul),he=a(e),u(z.$$.fragment,e),Be=a(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1d2iywa"&&(Q.textContent=Jl),Ze=a(e),u(X.$$.fragment,e),fe=a(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-10d4pve"&&(A.textContent=jl),Ve=a(e),u(k.$$.fragment,e),Ge=a(e),b=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-fa1g1b"&&(b.innerHTML=wl),We=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1lsv9ne"&&(S.textContent=Tl),xe=a(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-7jwfsh"&&(E.innerHTML=bl),ze=a(e),_=i(e,"OL",{"data-svelte-h":!0}),r(_)!=="svelte-1qamk6w"&&(_.innerHTML=Il),Qe=a(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-13nyfrj"&&(N.innerHTML=Cl),Xe=a(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1olvmjw"&&(H.innerHTML=vl),Ae=a(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-141s716"&&(R.textContent=gl),ke=a(e),u(Y.$$.fragment,e),Se=a(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-16i4hzt"&&(q.innerHTML=hl),Ee=a(e),u($.$$.fragment,e),_e=a(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-m6zvtq"&&(F.innerHTML=Bl),Ne=a(e),u(L.$$.fragment,e),He=a(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1tuvpwc"&&(D.innerHTML=Zl),Re=a(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1kgw3hl"&&(P.innerHTML=fl),Ye=a(e),u(K.$$.fragment,e),qe=a(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-13g24z9"&&(O.textContent=Vl),$e=a(e),u(ee.$$.fragment,e),Fe=a(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1fkw4tj"&&(le.innerHTML=Gl),Le=a(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-15omz2c"&&(se.textContent=Wl),De=a(e),m=i(e,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0,referrerpolicy:!0}),Ml(m).forEach(s),Pe=a(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1mmt364"&&(te.textContent=zl),Ke=a(e),u(ne.$$.fragment,e),Oe=a(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-9i1zlk"&&(ae.textContent=Ql),el=a(e),u(Me.$$.fragment,e),ll=a(e),ie=i(e,"UL",{"data-svelte-h":!0}),r(ie)!=="svelte-zzkck9"&&(ie.innerHTML=Xl),sl=a(e),u(re.$$.fragment,e),tl=a(e),ue=i(e,"P",{}),Ml(ue).forEach(s),this.h()},h(){U(J,"name","hf:doc:metadata"),U(J,"content",Ll),U(w,"class","warning"),U(T,"class","tip"),U(b,"class","tip"),U(m,"width","560"),U(m,"height","315"),kl(m.src,xl="https://www.youtube.com/embed/rObJel7-OLc?si=TnNwQ8rqXqun_pqE")||U(m,"src",xl),U(m,"title","YouTube video player"),U(m,"frameborder","0"),U(m,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"),U(m,"referrerpolicy","strict-origin-when-cross-origin"),m.allowFullscreen=""},m(e,l){Rl(document.head,J),t(e,pe,l),t(e,oe,l),t(e,ce,l),p(I,e,l),t(e,ye,l),p(C,e,l),t(e,de,l),p(v,e,l),t(e,me,l),t(e,w,l),t(e,Ue,l),t(e,g,l),t(e,Je,l),t(e,h,l),t(e,je,l),p(B,e,l),t(e,we,l),t(e,T,l),t(e,Te,l),t(e,Z,l),t(e,be,l),t(e,f,l),t(e,Ie,l),t(e,V,l),t(e,Ce,l),t(e,G,l),t(e,ve,l),p(W,e,l),t(e,ge,l),t(e,x,l),t(e,he,l),p(z,e,l),t(e,Be,l),t(e,Q,l),t(e,Ze,l),p(X,e,l),t(e,fe,l),t(e,A,l),t(e,Ve,l),p(k,e,l),t(e,Ge,l),t(e,b,l),t(e,We,l),t(e,S,l),t(e,xe,l),t(e,E,l),t(e,ze,l),t(e,_,l),t(e,Qe,l),t(e,N,l),t(e,Xe,l),t(e,H,l),t(e,Ae,l),t(e,R,l),t(e,ke,l),p(Y,e,l),t(e,Se,l),t(e,q,l),t(e,Ee,l),p($,e,l),t(e,_e,l),t(e,F,l),t(e,Ne,l),p(L,e,l),t(e,He,l),t(e,D,l),t(e,Re,l),t(e,P,l),t(e,Ye,l),p(K,e,l),t(e,qe,l),t(e,O,l),t(e,$e,l),p(ee,e,l),t(e,Fe,l),t(e,le,l),t(e,Le,l),t(e,se,l),t(e,De,l),t(e,m,l),t(e,Pe,l),t(e,te,l),t(e,Ke,l),p(ne,e,l),t(e,Oe,l),t(e,ae,l),t(e,el,l),p(Me,e,l),t(e,ll,l),t(e,ie,l),t(e,sl,l),p(re,e,l),t(e,tl,l),t(e,ue,l),nl=!0},p:Sl,i(e){nl||(c(I.$$.fragment,e),c(C.$$.fragment,e),c(v.$$.fragment,e),c(B.$$.fragment,e),c(W.$$.fragment,e),c(z.$$.fragment,e),c(X.$$.fragment,e),c(k.$$.fragment,e),c(Y.$$.fragment,e),c($.$$.fragment,e),c(L.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(ne.$$.fragment,e),c(Me.$$.fragment,e),c(re.$$.fragment,e),nl=!0)},o(e){y(I.$$.fragment,e),y(C.$$.fragment,e),y(v.$$.fragment,e),y(B.$$.fragment,e),y(W.$$.fragment,e),y(z.$$.fragment,e),y(X.$$.fragment,e),y(k.$$.fragment,e),y(Y.$$.fragment,e),y($.$$.fragment,e),y(L.$$.fragment,e),y(K.$$.fragment,e),y(ee.$$.fragment,e),y(ne.$$.fragment,e),y(Me.$$.fragment,e),y(re.$$.fragment,e),nl=!1},d(e){e&&(s(pe),s(oe),s(ce),s(ye),s(de),s(me),s(w),s(Ue),s(g),s(Je),s(h),s(je),s(we),s(T),s(Te),s(Z),s(be),s(f),s(Ie),s(V),s(Ce),s(G),s(ve),s(ge),s(x),s(he),s(Be),s(Q),s(Ze),s(fe),s(A),s(Ve),s(Ge),s(b),s(We),s(S),s(xe),s(E),s(ze),s(_),s(Qe),s(N),s(Xe),s(H),s(Ae),s(R),s(ke),s(Se),s(q),s(Ee),s(_e),s(F),s(Ne),s(He),s(D),s(Re),s(P),s(Ye),s(qe),s(O),s($e),s(Fe),s(le),s(Le),s(se),s(De),s(m),s(Pe),s(te),s(Ke),s(Oe),s(ae),s(el),s(ll),s(ie),s(sl),s(tl),s(ue)),s(J),d(I,e),d(C,e),d(v,e),d(B,e),d(W,e),d(z,e),d(X,e),d(k,e),d(Y,e),d($,e),d(L,e),d(K,e),d(ee,e),d(ne,e),d(Me,e),d(re,e)}}}const Ll='{"title":"Agents visuel avec smolagents","local":"agents-visuel-avec-smolagents","sections":[{"title":"Fournir des images au début de l’exécution de l’agent","local":"fournir-des-images-au-début-de-lexécution-de-lagent","sections":[],"depth":2},{"title":"Fournir des images avec recherche dynamique","local":"fournir-des-images-avec-recherche-dynamique","sections":[],"depth":2},{"title":"Lectures complémentaires","local":"lectures-complémentaires","sections":[],"depth":2}],"depth":1}';function Dl(il){return El(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ts extends _l{constructor(J){super(),Nl(this,J,Dl,Fl,Al,{})}}export{ts as component};
