import{s as In,n as Cn,o as vn}from"../chunks/scheduler.505acc25.js";import{S as hn,i as Zn,e as i,s as n,c as r,h as Gn,a as u,d as l,b as a,f as fn,g as M,j as o,k as rs,l as Bn,m as s,n as p,t as m,o as c,p as d}from"../chunks/index.b1175496.js";import{C as Vn,H as J}from"../chunks/Heading.988e52fa.js";import{C as y}from"../chunks/CodeBlock.ed64aebc.js";import{C as xn}from"../chunks/CourseFloatingBanner.79ef6243.js";import{E as Wn}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.3d47a398.js";function $n(Ms){let T,ct,pt,dt,w,Jt,j,yt,b,Tt,U,ps='<p>Vous pouvez suivre le code dans <a href="https://colab.research.google.com/#fileId=https%3A//huggingface.co/agents-course/notebooks/blob/main/fr/bonus-unit2/monitoring-and-evaluating-agents.ipynb" target="_blank">ce <i>notebook</i></a> que vous pouvez exécuter avec Google Colab.</p>',Ut,g,ms="Dans ce <em>notebook</em>, nous apprendrons comment <strong>surveiller les étapes internes (traces) de notre agent</strong> et <strong>évaluer ses performances</strong> en utilisant des outils d’observabilité <em>open source</em>.",wt,f,cs="La capacité d’observer et d’évaluer le comportement d’un agent est essentielle pour :",jt,I,ds="<li>Déboguer les problèmes lorsque les tâches échouent ou produisent des résultats sous-optimaux</li> <li>Contrôler les coûts et les performances en temps réel</li> <li>Améliorer la fiabilité et la sécurité grâce à un retour d’information continu</li>",bt,C,gt,v,Js="Avant d’exécuter ce <em>notebook</em>, assurez-vous d’avoir :",ft,h,ys='🔲 📚 <strong>Etudier la section <a href="https://huggingface.co/learn/agents-course/fr/unit1/introduction" rel="nofollow">Introduction aux agents</a></strong>',It,Z,Ts='🔲 📚 <strong>Etudier la section <a href="https://huggingface.co/learn/agents-course/fr/unit2/smolagents/introduction" rel="nofollow">le <em>framework</em> smolagents</a></strong>',Ct,G,vt,B,Us="Nous aurons besoin de quelques bibliothèques qui nous permettront d’exécuter, de contrôler et d’évaluer nos agents :",ht,V,Zt,x,Gt,W,ws='Dans ce <em>notebook</em>, nous utiliserons <a href="https://langfuse.com/" rel="nofollow">Langfuse</a> comme outil d’observabilité, mais vous pouvez utiliser <strong>n’importe quel autre service compatible avec OpenTelemetry</strong>. Le code ci-dessous montre comment définir les variables d’environnement pour Langfuse (ou n’importe quel <em>endpoint OTel</em>) et comment instrumenter votre smolagent.',Bt,$,js='<strong>Note :</strong> Si vous utilisez LlamaIndex ou LangGraph, vous pouvez trouver de la documentation sur leur instrumentation <a href="https://langfuse.com/docs/integrations/llama-index/workflows" rel="nofollow">ici</a> et <a href="https://langfuse.com/docs/integrations/langchain/example-python-langgraph" rel="nofollow">ici</a>.',Vt,E,bs='D’abord, configurons les credentials <em>Langfuse</em> comme variables d’environnement. Obtenez vos clés API <em>Langfuse</em> en vous inscrivant sur <a href="https://cloud.langfuse.com" rel="nofollow">Langfuse Cloud</a> ou en <a href="https://langfuse.com/self-hosting" rel="nofollow">auto-hébergeant Langfuse</a>.',xt,z,Wt,k,gs="Nous devons aussi configurer notre token <em>Hugging Face</em> pour les appels d’inférence.",$t,R,Et,Q,fs="Avec les variables d’environnement définies, nous pouvons maintenant initialiser le client <em>Langfuse</em>. <code>get_client()</code> initialise le client <em>Langfuse</em> en utilisant les credentials fournis dans les variables d’environnement.",zt,N,kt,L,Is="Ensuite, nous pouvons configurer le <code>SmolagentsInstrumentor()</code> pour instrumenter notre <em>smolagent</em> et envoyer des traces à <em>Langfuse</em>.",Rt,A,Qt,S,Nt,q,Cs="Voici un simple <em>CodeAgent</em> de smolagents qui calcule <code>1+1</code>. Nous l’exécutons pour confirmer que l’instrumentation fonctionne correctement. Si tout est configuré correctement, vous verrez des logs/spans dans votre tableau de bord d’observabilité.",Lt,X,At,H,vs='Consultez votre <a href="https://cloud.langfuse.com/traces" rel="nofollow">Langfuse Traces Dashboard</a> (ou l’outil d’observabilité de votre choix) pour confirmer que les portées et les logs ont été enregistrés.',St,Y,hs="Exemple de capture d’écran de Langfuse :",qt,_,Zs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/first-example-trace.png" alt="Example trace in Langfuse"/>',Xt,F,Gs='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1b94d6888258e0998329cdb72a371155?timestamp=2025-03-10T11%3A59%3A41.743Z" rel="nofollow">Lien vers la trace</a></em>',Ht,D,Yt,P,Bs="Maintenant que vous avez confirmé que votre instrumentation fonctionne, essayons une requête plus complexe afin de voir comment les mesures avancées (utilisation des <em>tokens</em>, latence, coûts, etc.) sont suivies.",_t,K,Ft,O,Dt,ee,Vs="La plupart des outils d’observabilité enregistrent une <strong>trace</strong> qui contient des <strong>spans</strong>, qui représentent chaque étape de la logique de votre agent. Ici, la trace contient l’exécution globale de l’agent et les sous-périodes pour :",Pt,te,xs="<li>les appels à l’outil (DuckDuckGoSearchTool)</li> <li>Les appels LLM (InferenceClientModel)</li>",Kt,le,Ws="Vous pouvez les inspecter pour voir précisément où le temps est passé, combien de <em>tokens</em> sont utilisés, etc. :",Ot,se,$s='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/trace-tree.png" alt="Trace tree in Langfuse"/>',el,ne,Es='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">Lien vers la trace</a></em>',tl,ae,ll,ie,zs="Dans la section précédente, nous avons appris la différence entre l’évaluation en ligne et hors ligne. Nous allons maintenant voir comment surveiller votre agent en production et l’évaluer en direct.",sl,ue,nl,oe,ks="<li><strong>Coûts</strong> - L’instrumentation smolagents capture l’utilisation des <em>tokens</em>, que vous pouvez transformer en coûts approximatifs en assignant un prix par <em>token</em>.</li> <li><strong>Latence</strong> - Observez le temps nécessaire à la réalisation de chaque étape ou de l’ensemble de l’exécution.</li> <li><strong>Retour utilisateur</strong> - Les utilisateurs peuvent fournir un retour direct (pouce vers le haut/vers le bas) pour aider à affiner ou à corriger l’agent.</li> <li><strong><em>LLM-as-a-Judge</em></strong> - Utilisez un autre LLM pour évaluer les résultats de votre agent en quasi temps réel (par exemple, vérification de la toxicité ou de l’exactitude des résultats).</li>",al,re,Rs="Ci-dessous, nous montrons des exemples de ces métriques.",il,Me,ul,pe,Qs="Vous trouverez ci-dessous une capture d’écran montrant l’utilisation des appels <code>Qwen2.5-Coder-32B-Instruct</code>. Ceci est utile pour voir les étapes coûteuses et optimiser votre agent.",ol,me,Ns='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-costs.png" alt="Costs"/>',rl,ce,Ls='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">Lien vers la trace</a></em>',Ml,de,pl,Je,As="Nous pouvons également voir combien de temps a duré chaque étape. Dans l’exemple ci-dessous, l’ensemble de la conversation a duré 32 secondes, que vous pouvez répartir par étape. Cela vous permet d’identifier les goulets d’étranglement et d’optimiser votre agent.",ml,ye,Ss='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-latency.png" alt="Latency"/>',cl,Te,qs='_<a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">Lien vers la trace</a>_blank',dl,Ue,Jl,we,Xs="Vous pouvez également passer des attributs supplémentaires à vos spans. Ceux-ci peuvent inclure <code>user_id</code>, <code>tags</code>, <code>session_id</code>, et des métadonnées personnalisées. Enrichir les traces avec ces détails est important pour l’analyse, le débogage et la surveillance du comportement de votre application à travers différents utilisateurs ou sessions.",yl,je,Tl,be,Hs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-attributes.png" alt="Enhancing agent runs with additional metrics"/>',Ul,ge,wl,fe,Ys='Si votre agent est intégré dans une interface utilisateur, vous pouvez enregistrer les réactions directes de l’utilisateur (comme un pouce levé ou baissé dans une interface de discussion). Vous trouverez ci-dessous un exemple utilisant <a href="https://gradio.app/" rel="nofollow">Gradio</a> pour intégrer un chat avec un mécanisme de retour d’information simple.',jl,Ie,_s="Dans l’extrait de code ci-dessous, lorsqu’un utilisateur envoie un message de chat, nous capturons la trace dans Langfuse. Si l’utilisateur aime ou n’aime pas la dernière réponse, nous attribuons un score à la trace.",bl,Ce,gl,ve,Fs="Les retours des utilisateurs sont ensuite saisis dans votre outil d’observabilité :",fl,he,Ds='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/user-feedback-gradio.png" alt="User feedback is being captured in Langfuse"/>',Il,Ze,Cl,Ge,Ps="<em>LLM-as-a-Judge</em> est une autre façon d’évaluer automatiquement les résultats de votre agent. Vous pouvez configurer l’appel d’un autre LLM pour évaluer l’exactitude, la toxicité, le style ou tout autre critère qui vous intéresse.",vl,Be,Ks="<strong>Fonctionnement</strong> :",hl,Ve,Os="<li>Vous définissez un <strong>Modèle d’évaluation</strong>, par exemple, « Vérifier si le texte est toxique ».</li> <li>Chaque fois que votre agent génère un résultat, vous transmettez ce résultat à votre LLM juge avec le gabarit.</li> <li>Le LLM juge répond avec un score ou une étiquette que vous enregistrez dans votre outil d’observabilité.</li>",Zl,xe,en="Exemple de Langfuse :",Gl,We,tn='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/evaluator-template.png" alt="LLM-as-a-Judge Evaluation Template"/> <img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/evaluator.png" alt="LLM-as-a-Judge Evaluator"/>',Bl,$e,Vl,Ee,ln="Vous pouvez voir que la réponse de cet exemple est jugée « non toxique ».",xl,ze,sn='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/llm-as-a-judge-score.png" alt="LLM-as-a-Judge Evaluation Score"/>',Wl,ke,$l,Re,nn="Toutes ces métriques peuvent être visualisées ensemble dans des tableaux de bord. Cela vous permet de voir rapidement les performances de votre agent sur plusieurs sessions et vous aide à suivre les mesures de qualité au fil du temps.",El,Qe,an='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/langfuse-dashboard.png" alt="Observability metrics overview"/>',zl,Ne,kl,Le,un="L’évaluation en ligne est essentielle pour obtenir un retour d’information en temps réel, mais vous avez également besoin d’une <strong>évaluation hors ligne</strong>, c’est-à-dire de vérifications systématiques avant ou pendant le développement. Cela permet de maintenir la qualité et la fiabilité avant de mettre les changements en production.",Rl,Ae,Ql,Se,on="Lors d’une évaluation hors ligne, vous devez généralement",Nl,qe,rn="<li>Disposer d’un jeu de données de référence (avec des paires de <em>prompts</em> et de résultats attendus)</li> <li>Exécuter votre agent sur ce jeu de données</li> <li>Comparer les résultats aux résultats attendus ou utiliser un mécanisme de notation supplémentaire.</li>",Ll,Xe,Mn='Ci-dessous, nous démontrons cette approche avec le jeu de données <a href="https://huggingface.co/datasets/gsm8k" rel="nofollow">GSM8K</a>, qui contient des questions et des solutions mathématiques.',Al,He,Sl,Ye,pn=`Ensuite, nous créons un jeu de données dans Langfuse pour suivre les exécutions. Nous ajoutons ensuite chaque élément du jeu de données au système.<br/>
(Si vous n’utilisez pas Langfuse, vous pouvez simplement les stocker dans votre propre base de données ou dans un fichier local à des fins d’analyse).`,ql,_e,Xl,Fe,Hl,De,mn='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/example-dataset.png" alt="Dataset items in Langfuse"/>',Yl,Pe,_l,Ke,cn="Nous définissons une fonction d’aide <code>run_smolagent()</code> qui :",Fl,Oe,dn="<li>Démarre un span Langfuse</li> <li>Exécute notre agent sur le <em>prompt</em></li> <li>Enregistre l’ID de la trace dans Langfuse</li>",Dl,et,Jn="Ensuite, nous parcourons en boucle chaque élément de l’ensemble de données, nous exécutons l’agent et nous lions la trace à l’élément de l’ensemble de données. Nous pouvons également joindre une note d’évaluation rapide si vous le souhaitez.",Pl,tt,Kl,lt,yn="Vous pouvez répéter ce processus avec différents :",Ol,st,Tn="<li>Modèles (OpenAI GPT, LLM local, etc.)</li> <li>Outils (recherche ou pas recherche)</li> <li>Prompts (différents messages du système)</li>",es,nt,Un="Ensuite, comparez-les côte à côte dans votre outil d’observabilité :",ts,at,wn='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/dataset_runs.png" alt="Dataset run overview"/> <img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/dataset-run-comparison.png" alt="Dataset run comparison"/>',ls,it,ss,ut,jn="Dans ce <em>notebook</em>, nous avons vu comment :",ns,ot,bn="<li><strong>Mettre en place l’observabilité</strong> en utilisant les exportateurs smolagents + OpenTelemetry</li> <li><strong>Vérifier l’instrumentation</strong> en lançant un agent simple</li> <li><strong>Capturez des métriques détaillées</strong> (coût, latence, etc.) à l’aide d’outils d’observabilité</li> <li><strong>Recueillir les commentaires des utilisateurs</strong> via une interface Gradio</li> <li><strong>Utiliser un LLM-as-a-Judge</strong> pour évaluer automatiquement les résultats</li> <li><strong>Effectuer une évaluation hors ligne</strong> avec un jeu de données de référence</li>",as,rt,gn="🤗 Bon codage !",is,Mt,us,mt,os;return w=new xn({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https%3A//huggingface.co/agents-course/notebooks/blob/main/fr/bonus-unit2/monitoring-and-evaluating-agents.ipynb"}]}}),j=new Vn({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),b=new J({props:{title:"Observer et évaluer des agents",local:"observer-et-évaluer-des-agents",headingTag:"h1"}}),C=new J({props:{title:"Prérequis de l’exercice 🏗️",local:"prérequis-de-lexercice-",headingTag:"h2"}}),G=new J({props:{title:"Étape 0 : Installer les bibliothèques nécessaires",local:"étape-0--installer-les-bibliothèques-nécessaires",headingTag:"h2"}}),V=new y({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdmdXNlJTIwJ3Ntb2xhZ2VudHMlNUJ0ZWxlbWV0cnklNUQnJTIwb3BlbmluZmVyZW5jZS1pbnN0cnVtZW50YXRpb24tc21vbGFnZW50cyUyMGRhdGFzZXRzJTIwJ3Ntb2xhZ2VudHMlNUJncmFkaW8lNUQnJTIwZ3JhZGlvJTIwLS11cGdyYWRl",highlighted:'%pip install langfuse <span class="hljs-string">&#x27;smolagents[telemetry]&#x27;</span> openinference-instrumentation-smolagents datasets <span class="hljs-string">&#x27;smolagents[gradio]&#x27;</span> gradio --upgrade',wrap:!1}}),x=new J({props:{title:"Étape 1 : Instrumenter votre agent",local:"étape-1--instrumenter-votre-agent",headingTag:"h2"}}),z=new y({props:{code:"aW1wb3J0JTIwb3MlMEElMjMlMjBPYnRlbmV6JTIwbGVzJTIwY2wlQzMlQTlzJTIwcG91ciUyMHZvdHJlJTIwcHJvamV0JTIwZGVwdWlzJTIwbGElMjBwYWdlJTIwZGVzJTIwcGFyYW0lQzMlQTh0cmVzJTIwZHUlMjBwcm9qZXQlMjAlM0ElMjBodHRwcyUzQSUyRiUyRmNsb3VkLmxhbmdmdXNlLmNvbSUwQW9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9QVUJMSUNfS0VZJTIyJTVEJTIwJTNEJTIwJTIycGstbGYtLi4uJTIyJTIwJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX1NFQ1JFVF9LRVklMjIlNUQlMjAlM0QlMjAlMjJzay1sZi0uLi4lMjIlMjAlMEFvcy5lbnZpcm9uJTVCJTIyTEFOR0ZVU0VfSE9TVCUyMiU1RCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGY2xvdWQubGFuZ2Z1c2UuY29tJTIyJTIwJTIzJTIwJUYwJTlGJTg3JUFBJUYwJTlGJTg3JUJBJTIwciVDMyVBOWdpb24lMjBFVSUwQSUyMyUyMG9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ1cy5jbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQkElRjAlOUYlODclQjglMjByJUMzJUE5Z2lvbiUyMFVT",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-comment"># Obtenez les clés pour votre projet depuis la page des paramètres du projet : https://cloud.langfuse.com</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_PUBLIC_KEY&quot;</span>] = <span class="hljs-string">&quot;pk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_SECRET_KEY&quot;</span>] = <span class="hljs-string">&quot;sk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>] = <span class="hljs-string">&quot;https://cloud.langfuse.com&quot;</span> <span class="hljs-comment"># 🇪🇺 région EU</span>
<span class="hljs-comment"># os.environ[&quot;LANGFUSE_HOST&quot;] = &quot;https://us.cloud.langfuse.com&quot; # 🇺🇸 région US</span>`,wrap:!1}}),R=new y({props:{code:"JTIzJTIwRCVDMyVBOWZpbmlzc2V6JTIwdm9zJTIwdG9rZW5zJTJGc2VjcmV0cyUyMEh1Z2dpbmclMjBGYWNlJTIwY29tbWUlMjB2YXJpYWJsZSUyMGQnZW52aXJvbm5lbWVudCUwQW9zLmVudmlyb24lNUIlMjJIRl9UT0tFTiUyMiU1RCUyMCUzRCUyMCUyMmhmXy4uLiUyMiUyMA==",highlighted:`<span class="hljs-comment"># Définissez vos tokens/secrets Hugging Face comme variable d&#x27;environnement</span>
os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>] = <span class="hljs-string">&quot;hf_...&quot;</span> `,wrap:!1}}),N=new y({props:{code:"ZnJvbSUyMGxhbmdmdXNlJTIwaW1wb3J0JTIwZ2V0X2NsaWVudCUwQSUyMCUwQWxhbmdmdXNlJTIwJTNEJTIwZ2V0X2NsaWVudCgpJTBBJTIwJTBBJTIzJTIwViVDMyVBOXJpZmllciUyMGxhJTIwY29ubmV4aW9uJTBBaWYlMjBsYW5nZnVzZS5hdXRoX2NoZWNrKCklM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJMZSUyMGNsaWVudCUyMExhbmdmdXNlJTIwZXN0JTIwYXV0aGVudGlmaSVDMyVBOSUyMGV0JTIwcHIlQzMlQUF0JTIwISUyMiklMEFlbHNlJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyTCdhdXRoZW50aWZpY2F0aW9uJTIwYSUyMCVDMyVBOWNob3UlQzMlQTkuJTIwVmV1aWxsZXolMjB2JUMzJUE5cmlmaWVyJTIwdm9zJTIwY3JlZGVudGlhbHMlMjBldCUyMGglQzMlQjR0ZS4lMjIp",highlighted:`<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> get_client
 
langfuse = get_client()
 
<span class="hljs-comment"># Vérifier la connexion</span>
<span class="hljs-keyword">if</span> langfuse.auth_check():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Le client Langfuse est authentifié et prêt !&quot;</span>)
<span class="hljs-keyword">else</span>:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;L&#x27;authentification a échoué. Veuillez vérifier vos credentials et hôte.&quot;</span>)`,wrap:!1}}),A=new y({props:{code:"ZnJvbSUyMG9wZW5pbmZlcmVuY2UuaW5zdHJ1bWVudGF0aW9uLnNtb2xhZ2VudHMlMjBpbXBvcnQlMjBTbW9sYWdlbnRzSW5zdHJ1bWVudG9yJTBBJTIwJTBBU21vbGFnZW50c0luc3RydW1lbnRvcigpLmluc3RydW1lbnQoKQ==",highlighted:`<span class="hljs-keyword">from</span> openinference.instrumentation.smolagents <span class="hljs-keyword">import</span> SmolagentsInstrumentor
 
SmolagentsInstrumentor().instrument()`,wrap:!1}}),S=new J({props:{title:"Étape 2 : Testez votre instrumentation",local:"étape-2--testez-votre-instrumentation",headingTag:"h2"}}),X=new y({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQSUyMyUyMENyJUMzJUE5ZXIlMjB1biUyMGFnZW50JTIwYmFzaXF1ZSUyMHBvdXIlMjB0ZXN0ZXIlMjBsJ2luc3RydW1lbnRhdGlvbiUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTBBKSUwQSUwQWFnZW50LnJ1biglMjIxJTJCMSUzRCUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-comment"># Créer un agent basique pour tester l&#x27;instrumentation</span>
agent = CodeAgent(
    tools=[],
    model=InferenceClientModel()
)

agent.run(<span class="hljs-string">&quot;1+1=&quot;</span>)`,wrap:!1}}),D=new J({props:{title:"Étape 3 : Observer et évaluer un agent plus complexe",local:"étape-3--observer-et-évaluer-un-agent-plus-complexe",headingTag:"h2"}}),K=new y({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCklMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QnNlYXJjaF90b29sJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpKSUwQSUwQWFnZW50LnJ1biglMjJDb21iaWVuJTIwZGUlMjBSdWJpaydzJTIwQ3ViZXMlMjBwb3VycmFpdC1vbiUyMGZhaXJlJTIwdGVuaXIlMjBkYW5zJTIwbGElMjBDYXRoJUMzJUE5ZHJhbGUlMjBOb3RyZS1EYW1lJTIwJTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(tools=[search_tool], model=InferenceClientModel())

agent.run(<span class="hljs-string">&quot;Combien de Rubik&#x27;s Cubes pourrait-on faire tenir dans la Cathédrale Notre-Dame ?&quot;</span>)`,wrap:!1}}),O=new J({props:{title:"Structure de la trace",local:"structure-de-la-trace",headingTag:"h3"}}),ae=new J({props:{title:"Évaluation en ligne",local:"évaluation-en-ligne",headingTag:"h2"}}),ue=new J({props:{title:"Métriques courantes à suivre en production",local:"métriques-courantes-à-suivre-en-production",headingTag:"h3"}}),Me=new J({props:{title:"1. Coûts",local:"1-coûts",headingTag:"h4"}}),de=new J({props:{title:"2. Temps de latence",local:"2-temps-de-latence",headingTag:"h4"}}),Ue=new J({props:{title:"3. Attributs supplémentaires",local:"3-attributs-supplémentaires",headingTag:"h4"}}),je=new y({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCklMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QnNlYXJjaF90b29sJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTBBKSUwQSUwQXdpdGglMjBsYW5nZnVzZS5zdGFydF9hc19jdXJyZW50X3NwYW4oJTBBJTIwJTIwJTIwJTIwbmFtZSUzRCUyMlNtb2xhZ2VudC1UcmFjZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCklMjBhcyUyMHNwYW4lM0ElMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBFeCVDMyVBOWN1dGV6JTIwdm90cmUlMjBhcHBsaWNhdGlvbiUyMGljaSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwYWdlbnQucnVuKCUyMlF1ZWxsZSUyMGVzdCUyMGxhJTIwY2FwaXRhbGUlMjBkZSUyMGwnQWxsZW1hZ25lJTIwJTNGJTIyKSUwQSUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFBhc3NleiUyMGRlcyUyMGF0dHJpYnV0cyUyMHN1cHBsJUMzJUE5bWVudGFpcmVzJTIwYXUlMjBzcGFuJTBBJTIwJTIwJTIwJTIwc3Bhbi51cGRhdGVfdHJhY2UoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXQlM0QlMjJRdWVsbGUlMjBlc3QlMjBsYSUyMGNhcGl0YWxlJTIwZGUlMjBsJ0FsbGVtYWduZSUyMCUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dCUzRHJlc3BvbnNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdXNlcl9pZCUzRCUyMnNtb2xhZ2VudC11c2VyLTEyMyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlc3Npb25faWQlM0QlMjJzbW9sYWdlbnQtc2Vzc2lvbi0xMjM0NTY3ODklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YWdzJTNEJTVCJTIycXVlc3Rpb24tdmlsbGUlMjIlMkMlMjAlMjJ0ZXN0LWFnZW50cyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1ldGFkYXRhJTNEJTdCJTIyZW1haWwlMjIlM0ElMjAlMjJ1c2VyJTQwbGFuZ2Z1c2UuY29tJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUwQSUyMyUyMEZsdXNoZXIlMjBsZXMlMjAlQzMlQTl2JUMzJUE5bmVtZW50cyUyMGRhbnMlMjBsZXMlMjBhcHBsaWNhdGlvbnMlMjBkZSUyMGNvdXJ0ZSUyMGR1ciVDMyVBOWUlMEFsYW5nZnVzZS5mbHVzaCgp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(
    tools=[search_tool],
    model=InferenceClientModel()
)

<span class="hljs-keyword">with</span> langfuse.start_as_current_span(
    name=<span class="hljs-string">&quot;Smolagent-Trace&quot;</span>,
    ) <span class="hljs-keyword">as</span> span:
    
    <span class="hljs-comment"># Exécutez votre application ici</span>
    response = agent.run(<span class="hljs-string">&quot;Quelle est la capitale de l&#x27;Allemagne ?&quot;</span>)
 
    <span class="hljs-comment"># Passez des attributs supplémentaires au span</span>
    span.update_trace(
        <span class="hljs-built_in">input</span>=<span class="hljs-string">&quot;Quelle est la capitale de l&#x27;Allemagne ?&quot;</span>,
        output=response,
        user_id=<span class="hljs-string">&quot;smolagent-user-123&quot;</span>,
        session_id=<span class="hljs-string">&quot;smolagent-session-123456789&quot;</span>,
        tags=[<span class="hljs-string">&quot;question-ville&quot;</span>, <span class="hljs-string">&quot;test-agents&quot;</span>],
        metadata={<span class="hljs-string">&quot;email&quot;</span>: <span class="hljs-string">&quot;user@langfuse.com&quot;</span>},
        )
 
<span class="hljs-comment"># Flusher les événements dans les applications de courte durée</span>
langfuse.flush()`,wrap:!1}}),ge=new J({props:{title:"4. #### 4. Retour utilisateur",local:"4--4-retour-utilisateur",headingTag:"h4"}}),Ce=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, InferenceClientModel)
<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> get_client

langfuse = get_client()

model = InferenceClientModel()
agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)

trace_id = <span class="hljs-literal">None</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">respond</span>(<span class="hljs-params">prompt, history</span>):
    <span class="hljs-keyword">with</span> langfuse.start_as_current_span(
        name=<span class="hljs-string">&quot;Smolagent-Trace&quot;</span>):
        
        <span class="hljs-comment"># Exécutez votre application ici</span>
        output = agent.run(prompt)

        <span class="hljs-keyword">global</span> trace_id
        trace_id = langfuse.get_current_trace_id()

    history.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-built_in">str</span>(output)})
    <span class="hljs-keyword">return</span> history

<span class="hljs-keyword">def</span> <span class="hljs-title function_">handle_like</span>(<span class="hljs-params">data: gr.LikeData</span>):
    <span class="hljs-comment"># Pour la démonstration, nous mappons les retours utilisateur à 1 (j&#x27;aime) ou 0 (je n&#x27;aime pas)</span>
    <span class="hljs-keyword">if</span> data.liked:
        langfuse.create_score(
            value=<span class="hljs-number">1</span>,
            name=<span class="hljs-string">&quot;user-feedback&quot;</span>,
            trace_id=trace_id
        )
    <span class="hljs-keyword">else</span>:
        langfuse.create_score(
            value=<span class="hljs-number">0</span>,
            name=<span class="hljs-string">&quot;user-feedback&quot;</span>,
            trace_id=trace_id
        )

<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    chatbot = gr.Chatbot(label=<span class="hljs-string">&quot;Chat&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>)
    prompt_box = gr.Textbox(placeholder=<span class="hljs-string">&quot;Tapez votre message...&quot;</span>, label=<span class="hljs-string">&quot;Votre message&quot;</span>)

    <span class="hljs-comment"># Lorsque l&#x27;utilisateur appuie sur &quot;Enter&quot;, nous exécutons &#x27;respond&#x27;</span>
    prompt_box.submit(
        fn=respond,
        inputs=[prompt_box, chatbot],
        outputs=chatbot
    )

    <span class="hljs-comment"># Lorsque l&#x27;utilisateur clique sur le bouton &quot;J&#x27;aime&quot; d&#x27;un message, nous exécutons &#x27;handle_like&#x27;</span>
    chatbot.like(handle_like, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>)

demo.launch()`,wrap:!1}}),Ze=new J({props:{title:"5. LLM-as-a-Judge",local:"5-llm-as-a-judge",headingTag:"h4"}}),$e=new y({props:{code:"JTIzJTIwRXhlbXBsZSUyMCUzQSUyMFYlQzMlQTlyaWZpZXIlMjBzaSUyMGxhJTIwc29ydGllJTIwZGUlMjBsJ2FnZW50JTIwZXN0JTIwdG94aXF1ZSUyMG91JTIwbm9uJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCklMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QnNlYXJjaF90b29sJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpKSUwQSUwQWFnZW50LnJ1biglMjJNYW5nZXIlMjBkZXMlMjBjYXJvdHRlcyUyMHBldXQtaWwlMjBhbSVDMyVBOWxpb3JlciUyMHZvdHJlJTIwdmlzaW9uJTIwJTNGJTIyKQ==",highlighted:`<span class="hljs-comment"># Exemple : Vérifier si la sortie de l&#x27;agent est toxique ou non</span>
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(tools=[search_tool], model=InferenceClientModel())

agent.run(<span class="hljs-string">&quot;Manger des carottes peut-il améliorer votre vision ?&quot;</span>)`,wrap:!1}}),ke=new J({props:{title:"6. Aperçu des métriques d’observabilité",local:"6-aperçu-des-métriques-dobservabilité",headingTag:"h4"}}),Ne=new J({props:{title:"Évaluation hors ligne",local:"évaluation-hors-ligne",headingTag:"h2"}}),Ae=new J({props:{title:"Évaluation d’un jeu de données",local:"évaluation-dun-jeu-de-données",headingTag:"h3"}}),He=new y({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQSUyMyUyMFIlQzMlQTljdXAlQzMlQTlyZXIlMjBHU004SyUyMHN1ciUyMEh1Z2dpbmclMjBGYWNlJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJvcGVuYWklMkZnc204ayUyMiUyQyUyMCdtYWluJyUyQyUyMHNwbGl0JTNEJ3RyYWluJyklMEFkZiUyMCUzRCUyMHBkLkRhdGFGcmFtZShkYXRhc2V0KSUwQXByaW50KCUyMlByZW1pJUMzJUE4cmVzJTIwbGlnbmVzJTIwZHUlMjBqZXUlMjBkZSUyMGRvbm4lQzMlQTllcyUyMEdTTThLJTIwJTNBJTIyKSUwQXByaW50KGRmLmhlYWQoKSk=",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Récupérer GSM8K sur Hugging Face</span>
dataset = load_dataset(<span class="hljs-string">&quot;openai/gsm8k&quot;</span>, <span class="hljs-string">&#x27;main&#x27;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>)
df = pd.DataFrame(dataset)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Premières lignes du jeu de données GSM8K :&quot;</span>)
<span class="hljs-built_in">print</span>(df.head())`,wrap:!1}}),_e=new y({props:{code:"ZnJvbSUyMGxhbmdmdXNlJTIwaW1wb3J0JTIwZ2V0X2NsaWVudCUwQWxhbmdmdXNlJTIwJTNEJTIwZ2V0X2NsaWVudCgpJTBBJTBBbGFuZ2Z1c2VfZGF0YXNldF9uYW1lJTIwJTNEJTIwJTIyZ3NtOGtfZGF0YXNldF9odWdnaW5nZmFjZSUyMiUwQSUwQSUyMyUyMENyJUMzJUE5ZXIlMjB1biUyMGpldSUyMGRlJTIwZG9ubiVDMyVBOWVzJTIwZGFucyUyMExhbmdmdXNlJTBBbGFuZ2Z1c2UuY3JlYXRlX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwbmFtZSUzRGxhbmdmdXNlX2RhdGFzZXRfbmFtZSUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIySmV1JTIwZGUlMjBkb25uJUMzJUE5ZXMlMjBkZSUyMHIlQzMlQTlmJUMzJUE5cmVuY2UlMjBHU004SyUyMHQlQzMlQTlsJUMzJUE5Y2hhcmclQzMlQTklMjBkZXB1aXMlMjBIdWdnaW5nZmFjZSUyMiUyQyUwQSUyMCUyMCUyMCUyMG1ldGFkYXRhJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGF0ZSUyMiUzQSUyMCUyMjIwMjUtMDMtMTAlMjIlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyYmVuY2htYXJrJTIyJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> get_client
langfuse = get_client()

langfuse_dataset_name = <span class="hljs-string">&quot;gsm8k_dataset_huggingface&quot;</span>

<span class="hljs-comment"># Créer un jeu de données dans Langfuse</span>
langfuse.create_dataset(
    name=langfuse_dataset_name,
    description=<span class="hljs-string">&quot;Jeu de données de référence GSM8K téléchargé depuis Huggingface&quot;</span>,
    metadata={
        <span class="hljs-string">&quot;date&quot;</span>: <span class="hljs-string">&quot;2025-03-10&quot;</span>, 
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;benchmark&quot;</span>
    }
)`,wrap:!1}}),Fe=new y({props:{code:"Zm9yJTIwaWR4JTJDJTIwcm93JTIwaW4lMjBkZi5pdGVycm93cygpJTNBJTBBJTIwJTIwJTIwJTIwbGFuZ2Z1c2UuY3JlYXRlX2RhdGFzZXRfaXRlbSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhc2V0X25hbWUlM0RsYW5nZnVzZV9kYXRhc2V0X25hbWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dCUzRCU3QiUyMnRleHQlMjIlM0ElMjByb3clNUIlMjJxdWVzdGlvbiUyMiU1RCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4cGVjdGVkX291dHB1dCUzRCU3QiUyMnRleHQlMjIlM0ElMjByb3clNUIlMjJhbnN3ZXIlMjIlNUQlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZV9pbmRleCUyMiUzQSUyMGlkeCU3RCUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBpZiUyMGlkeCUyMCUzRSUzRCUyMDklM0ElMjAlMjMlMjBUJUMzJUE5bCVDMyVBOWNoYXJnZXIlMjBzZXVsZW1lbnQlMjBsZXMlMjAxMCUyMHByZW1pZXJzJTIwJUMzJUE5bCVDMyVBOW1lbnRzJTIwcG91ciUyMGxhJTIwZCVDMyVBOW1vbnN0cmF0aW9uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnJlYWs=",highlighted:`<span class="hljs-keyword">for</span> idx, row <span class="hljs-keyword">in</span> df.iterrows():
    langfuse.create_dataset_item(
        dataset_name=langfuse_dataset_name,
        <span class="hljs-built_in">input</span>={<span class="hljs-string">&quot;text&quot;</span>: row[<span class="hljs-string">&quot;question&quot;</span>]},
        expected_output={<span class="hljs-string">&quot;text&quot;</span>: row[<span class="hljs-string">&quot;answer&quot;</span>]},
        metadata={<span class="hljs-string">&quot;source_index&quot;</span>: idx}
    )
    <span class="hljs-keyword">if</span> idx &gt;= <span class="hljs-number">9</span>: <span class="hljs-comment"># Télécharger seulement les 10 premiers éléments pour la démonstration</span>
        <span class="hljs-keyword">break</span>`,wrap:!1}}),Pe=new J({props:{title:"Exécution de l’agent sur le jeu de données",local:"exécution-de-lagent-sur-le-jeu-de-données",headingTag:"h4"}}),tt=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> opentelemetry.trace <span class="hljs-keyword">import</span> format_trace_id
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, InferenceClientModel, LiteLLMModel)
<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> get_client
 
langfuse = get_client()

<span class="hljs-comment"># Exemple : utiliser InferenceClientModel ou LiteLLMModel pour accéder aux modèles openai, anthropic, gemini, etc. :</span>
model = InferenceClientModel()

agent = CodeAgent(
    tools=[],
    model=model,
    add_base_tools=<span class="hljs-literal">True</span>
)

dataset_name = <span class="hljs-string">&quot;gsm8k_dataset_huggingface&quot;</span>
current_run_name = <span class="hljs-string">&quot;smolagent-notebook-run-01&quot;</span> <span class="hljs-comment"># Identifie cette exécution d&#x27;évaluation spécifique</span>
 
<span class="hljs-comment"># Supposons que &#x27;run_smolagent&#x27; est votre fonction d&#x27;application instrumentée</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_smolagent</span>(<span class="hljs-params">question</span>):
    <span class="hljs-keyword">with</span> langfuse.start_as_current_generation(name=<span class="hljs-string">&quot;qna-llm-call&quot;</span>) <span class="hljs-keyword">as</span> generation:
        <span class="hljs-comment"># Simuler un appel LLM</span>
        result = agent.run(question)
 
        <span class="hljs-comment"># Mettre à jour la trace avec l&#x27;entrée et la sortie</span>
        generation.update_trace(
            <span class="hljs-built_in">input</span>= question,
            output=result,
        )
 
        <span class="hljs-keyword">return</span> result
 
dataset = langfuse.get_dataset(name=dataset_name) <span class="hljs-comment"># Récupérer votre jeu de données pré-peuplé</span>
 
<span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> dataset.items:
 
    <span class="hljs-comment"># Utiliser le gestionnaire de contexte item.run()</span>
    <span class="hljs-keyword">with</span> item.run(
        run_name=current_run_name,
        run_metadata={<span class="hljs-string">&quot;model_provider&quot;</span>: <span class="hljs-string">&quot;Hugging Face&quot;</span>, <span class="hljs-string">&quot;temperature_setting&quot;</span>: <span class="hljs-number">0.7</span>},
        run_description=<span class="hljs-string">&quot;Exécution d&#x27;évaluation pour le jeu de données GSM8K&quot;</span>
    ) <span class="hljs-keyword">as</span> root_span: <span class="hljs-comment"># root_span est le span racine de la nouvelle trace pour cet élément et exécution.</span>
        <span class="hljs-comment"># Toutes les opérations langfuse suivantes dans ce bloc font partie de cette trace.</span>
 
        <span class="hljs-comment"># Appelez votre logique d&#x27;application</span>
        generated_answer = run_smolagent(question=item.<span class="hljs-built_in">input</span>[<span class="hljs-string">&quot;text&quot;</span>])
 
        <span class="hljs-built_in">print</span>(item.<span class="hljs-built_in">input</span>)`,wrap:!1}}),it=new J({props:{title:"Réflexions finales",local:"réflexions-finales",headingTag:"h2"}}),Mt=new Wn({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/bonus-unit2/monitoring-and-evaluating-agents-notebook.mdx"}}),{c(){T=i("meta"),ct=n(),pt=i("p"),dt=n(),r(w.$$.fragment),Jt=n(),r(j.$$.fragment),yt=n(),r(b.$$.fragment),Tt=n(),U=i("blockquote"),U.innerHTML=ps,Ut=n(),g=i("p"),g.innerHTML=ms,wt=n(),f=i("p"),f.textContent=cs,jt=n(),I=i("ul"),I.innerHTML=ds,bt=n(),r(C.$$.fragment),gt=n(),v=i("p"),v.innerHTML=Js,ft=n(),h=i("p"),h.innerHTML=ys,It=n(),Z=i("p"),Z.innerHTML=Ts,Ct=n(),r(G.$$.fragment),vt=n(),B=i("p"),B.textContent=Us,ht=n(),r(V.$$.fragment),Zt=n(),r(x.$$.fragment),Gt=n(),W=i("p"),W.innerHTML=ws,Bt=n(),$=i("p"),$.innerHTML=js,Vt=n(),E=i("p"),E.innerHTML=bs,xt=n(),r(z.$$.fragment),Wt=n(),k=i("p"),k.innerHTML=gs,$t=n(),r(R.$$.fragment),Et=n(),Q=i("p"),Q.innerHTML=fs,zt=n(),r(N.$$.fragment),kt=n(),L=i("p"),L.innerHTML=Is,Rt=n(),r(A.$$.fragment),Qt=n(),r(S.$$.fragment),Nt=n(),q=i("p"),q.innerHTML=Cs,Lt=n(),r(X.$$.fragment),At=n(),H=i("p"),H.innerHTML=vs,St=n(),Y=i("p"),Y.textContent=hs,qt=n(),_=i("p"),_.innerHTML=Zs,Xt=n(),F=i("p"),F.innerHTML=Gs,Ht=n(),r(D.$$.fragment),Yt=n(),P=i("p"),P.innerHTML=Bs,_t=n(),r(K.$$.fragment),Ft=n(),r(O.$$.fragment),Dt=n(),ee=i("p"),ee.innerHTML=Vs,Pt=n(),te=i("ul"),te.innerHTML=xs,Kt=n(),le=i("p"),le.innerHTML=Ws,Ot=n(),se=i("p"),se.innerHTML=$s,el=n(),ne=i("p"),ne.innerHTML=Es,tl=n(),r(ae.$$.fragment),ll=n(),ie=i("p"),ie.textContent=zs,sl=n(),r(ue.$$.fragment),nl=n(),oe=i("ol"),oe.innerHTML=ks,al=n(),re=i("p"),re.textContent=Rs,il=n(),r(Me.$$.fragment),ul=n(),pe=i("p"),pe.innerHTML=Qs,ol=n(),me=i("p"),me.innerHTML=Ns,rl=n(),ce=i("p"),ce.innerHTML=Ls,Ml=n(),r(de.$$.fragment),pl=n(),Je=i("p"),Je.textContent=As,ml=n(),ye=i("p"),ye.innerHTML=Ss,cl=n(),Te=i("p"),Te.innerHTML=qs,dl=n(),r(Ue.$$.fragment),Jl=n(),we=i("p"),we.innerHTML=Xs,yl=n(),r(je.$$.fragment),Tl=n(),be=i("p"),be.innerHTML=Hs,Ul=n(),r(ge.$$.fragment),wl=n(),fe=i("p"),fe.innerHTML=Ys,jl=n(),Ie=i("p"),Ie.textContent=_s,bl=n(),r(Ce.$$.fragment),gl=n(),ve=i("p"),ve.textContent=Fs,fl=n(),he=i("p"),he.innerHTML=Ds,Il=n(),r(Ze.$$.fragment),Cl=n(),Ge=i("p"),Ge.innerHTML=Ps,vl=n(),Be=i("p"),Be.innerHTML=Ks,hl=n(),Ve=i("ol"),Ve.innerHTML=Os,Zl=n(),xe=i("p"),xe.textContent=en,Gl=n(),We=i("p"),We.innerHTML=tn,Bl=n(),r($e.$$.fragment),Vl=n(),Ee=i("p"),Ee.textContent=ln,xl=n(),ze=i("p"),ze.innerHTML=sn,Wl=n(),r(ke.$$.fragment),$l=n(),Re=i("p"),Re.textContent=nn,El=n(),Qe=i("p"),Qe.innerHTML=an,zl=n(),r(Ne.$$.fragment),kl=n(),Le=i("p"),Le.innerHTML=un,Rl=n(),r(Ae.$$.fragment),Ql=n(),Se=i("p"),Se.textContent=on,Nl=n(),qe=i("ol"),qe.innerHTML=rn,Ll=n(),Xe=i("p"),Xe.innerHTML=Mn,Al=n(),r(He.$$.fragment),Sl=n(),Ye=i("p"),Ye.innerHTML=pn,ql=n(),r(_e.$$.fragment),Xl=n(),r(Fe.$$.fragment),Hl=n(),De=i("p"),De.innerHTML=mn,Yl=n(),r(Pe.$$.fragment),_l=n(),Ke=i("p"),Ke.innerHTML=cn,Fl=n(),Oe=i("ol"),Oe.innerHTML=dn,Dl=n(),et=i("p"),et.textContent=Jn,Pl=n(),r(tt.$$.fragment),Kl=n(),lt=i("p"),lt.textContent=yn,Ol=n(),st=i("ul"),st.innerHTML=Tn,es=n(),nt=i("p"),nt.textContent=Un,ts=n(),at=i("p"),at.innerHTML=wn,ls=n(),r(it.$$.fragment),ss=n(),ut=i("p"),ut.innerHTML=jn,ns=n(),ot=i("ol"),ot.innerHTML=bn,as=n(),rt=i("p"),rt.textContent=gn,is=n(),r(Mt.$$.fragment),us=n(),mt=i("p"),this.h()},l(e){const t=Gn("svelte-u9bgzb",document.head);T=u(t,"META",{name:!0,content:!0}),t.forEach(l),ct=a(e),pt=u(e,"P",{}),fn(pt).forEach(l),dt=a(e),M(w.$$.fragment,e),Jt=a(e),M(j.$$.fragment,e),yt=a(e),M(b.$$.fragment,e),Tt=a(e),U=u(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(U)!=="svelte-1svf75u"&&(U.innerHTML=ps),Ut=a(e),g=u(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-lybehf"&&(g.innerHTML=ms),wt=a(e),f=u(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-16qrkpq"&&(f.textContent=cs),jt=a(e),I=u(e,"UL",{"data-svelte-h":!0}),o(I)!=="svelte-1h1arbq"&&(I.innerHTML=ds),bt=a(e),M(C.$$.fragment,e),gt=a(e),v=u(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1fzblhn"&&(v.innerHTML=Js),ft=a(e),h=u(e,"P",{"data-svelte-h":!0}),o(h)!=="svelte-1nlun3v"&&(h.innerHTML=ys),It=a(e),Z=u(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-w3fllb"&&(Z.innerHTML=Ts),Ct=a(e),M(G.$$.fragment,e),vt=a(e),B=u(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-ity0ku"&&(B.textContent=Us),ht=a(e),M(V.$$.fragment,e),Zt=a(e),M(x.$$.fragment,e),Gt=a(e),W=u(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-eowye6"&&(W.innerHTML=ws),Bt=a(e),$=u(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-4n5fuh"&&($.innerHTML=js),Vt=a(e),E=u(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1bg6vsc"&&(E.innerHTML=bs),xt=a(e),M(z.$$.fragment,e),Wt=a(e),k=u(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-170jlvq"&&(k.innerHTML=gs),$t=a(e),M(R.$$.fragment,e),Et=a(e),Q=u(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-beqsvu"&&(Q.innerHTML=fs),zt=a(e),M(N.$$.fragment,e),kt=a(e),L=u(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-madoyk"&&(L.innerHTML=Is),Rt=a(e),M(A.$$.fragment,e),Qt=a(e),M(S.$$.fragment,e),Nt=a(e),q=u(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1qdntcg"&&(q.innerHTML=Cs),Lt=a(e),M(X.$$.fragment,e),At=a(e),H=u(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1efj51z"&&(H.innerHTML=vs),St=a(e),Y=u(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-7kof4j"&&(Y.textContent=hs),qt=a(e),_=u(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1cb993n"&&(_.innerHTML=Zs),Xt=a(e),F=u(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-t25v6l"&&(F.innerHTML=Gs),Ht=a(e),M(D.$$.fragment,e),Yt=a(e),P=u(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1x0qldt"&&(P.innerHTML=Bs),_t=a(e),M(K.$$.fragment,e),Ft=a(e),M(O.$$.fragment,e),Dt=a(e),ee=u(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-f51tlc"&&(ee.innerHTML=Vs),Pt=a(e),te=u(e,"UL",{"data-svelte-h":!0}),o(te)!=="svelte-17u4fl8"&&(te.innerHTML=xs),Kt=a(e),le=u(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-16i9hdh"&&(le.innerHTML=Ws),Ot=a(e),se=u(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-yhkq5w"&&(se.innerHTML=$s),el=a(e),ne=u(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1a5vclt"&&(ne.innerHTML=Es),tl=a(e),M(ae.$$.fragment,e),ll=a(e),ie=u(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-jbtu0t"&&(ie.textContent=zs),sl=a(e),M(ue.$$.fragment,e),nl=a(e),oe=u(e,"OL",{"data-svelte-h":!0}),o(oe)!=="svelte-gqhp1d"&&(oe.innerHTML=ks),al=a(e),re=u(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-1npsh72"&&(re.textContent=Rs),il=a(e),M(Me.$$.fragment,e),ul=a(e),pe=u(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-zi6mnf"&&(pe.innerHTML=Qs),ol=a(e),me=u(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-dard47"&&(me.innerHTML=Ns),rl=a(e),ce=u(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-1a5vclt"&&(ce.innerHTML=Ls),Ml=a(e),M(de.$$.fragment,e),pl=a(e),Je=u(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-1g371w2"&&(Je.textContent=As),ml=a(e),ye=u(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-1org4pj"&&(ye.innerHTML=Ss),cl=a(e),Te=u(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-xazaea"&&(Te.innerHTML=qs),dl=a(e),M(Ue.$$.fragment,e),Jl=a(e),we=u(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-908dc2"&&(we.innerHTML=Xs),yl=a(e),M(je.$$.fragment,e),Tl=a(e),be=u(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-1gx91hu"&&(be.innerHTML=Hs),Ul=a(e),M(ge.$$.fragment,e),wl=a(e),fe=u(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-18xjhr3"&&(fe.innerHTML=Ys),jl=a(e),Ie=u(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1ia0u96"&&(Ie.textContent=_s),bl=a(e),M(Ce.$$.fragment,e),gl=a(e),ve=u(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-ohty0e"&&(ve.textContent=Fs),fl=a(e),he=u(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-e6ive4"&&(he.innerHTML=Ds),Il=a(e),M(Ze.$$.fragment,e),Cl=a(e),Ge=u(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-1590hso"&&(Ge.innerHTML=Ps),vl=a(e),Be=u(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-sdfoo6"&&(Be.innerHTML=Ks),hl=a(e),Ve=u(e,"OL",{"data-svelte-h":!0}),o(Ve)!=="svelte-1d8py7"&&(Ve.innerHTML=Os),Zl=a(e),xe=u(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-ajk1n4"&&(xe.textContent=en),Gl=a(e),We=u(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-1uar592"&&(We.innerHTML=tn),Bl=a(e),M($e.$$.fragment,e),Vl=a(e),Ee=u(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-hyawqv"&&(Ee.textContent=ln),xl=a(e),ze=u(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-zj9pt2"&&(ze.innerHTML=sn),Wl=a(e),M(ke.$$.fragment,e),$l=a(e),Re=u(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-sht47v"&&(Re.textContent=nn),El=a(e),Qe=u(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-1jemoxg"&&(Qe.innerHTML=an),zl=a(e),M(Ne.$$.fragment,e),kl=a(e),Le=u(e,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-1imslsb"&&(Le.innerHTML=un),Rl=a(e),M(Ae.$$.fragment,e),Ql=a(e),Se=u(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-15twuau"&&(Se.textContent=on),Nl=a(e),qe=u(e,"OL",{"data-svelte-h":!0}),o(qe)!=="svelte-16qbv16"&&(qe.innerHTML=rn),Ll=a(e),Xe=u(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-1t95yi7"&&(Xe.innerHTML=Mn),Al=a(e),M(He.$$.fragment,e),Sl=a(e),Ye=u(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-1aqq29z"&&(Ye.innerHTML=pn),ql=a(e),M(_e.$$.fragment,e),Xl=a(e),M(Fe.$$.fragment,e),Hl=a(e),De=u(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-giwu4e"&&(De.innerHTML=mn),Yl=a(e),M(Pe.$$.fragment,e),_l=a(e),Ke=u(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-6lsq77"&&(Ke.innerHTML=cn),Fl=a(e),Oe=u(e,"OL",{"data-svelte-h":!0}),o(Oe)!=="svelte-1q8x5n1"&&(Oe.innerHTML=dn),Dl=a(e),et=u(e,"P",{"data-svelte-h":!0}),o(et)!=="svelte-f6d7w3"&&(et.textContent=Jn),Pl=a(e),M(tt.$$.fragment,e),Kl=a(e),lt=u(e,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-sd79jh"&&(lt.textContent=yn),Ol=a(e),st=u(e,"UL",{"data-svelte-h":!0}),o(st)!=="svelte-ns94uw"&&(st.innerHTML=Tn),es=a(e),nt=u(e,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-3cnt1q"&&(nt.textContent=Un),ts=a(e),at=u(e,"P",{"data-svelte-h":!0}),o(at)!=="svelte-ukc2vx"&&(at.innerHTML=wn),ls=a(e),M(it.$$.fragment,e),ss=a(e),ut=u(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-1r8mqsy"&&(ut.innerHTML=jn),ns=a(e),ot=u(e,"OL",{"data-svelte-h":!0}),o(ot)!=="svelte-9j8n5a"&&(ot.innerHTML=bn),as=a(e),rt=u(e,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-rdnrm6"&&(rt.textContent=gn),is=a(e),M(Mt.$$.fragment,e),us=a(e),mt=u(e,"P",{}),fn(mt).forEach(l),this.h()},h(){rs(T,"name","hf:doc:metadata"),rs(T,"content",En),rs(U,"class","tip")},m(e,t){Bn(document.head,T),s(e,ct,t),s(e,pt,t),s(e,dt,t),p(w,e,t),s(e,Jt,t),p(j,e,t),s(e,yt,t),p(b,e,t),s(e,Tt,t),s(e,U,t),s(e,Ut,t),s(e,g,t),s(e,wt,t),s(e,f,t),s(e,jt,t),s(e,I,t),s(e,bt,t),p(C,e,t),s(e,gt,t),s(e,v,t),s(e,ft,t),s(e,h,t),s(e,It,t),s(e,Z,t),s(e,Ct,t),p(G,e,t),s(e,vt,t),s(e,B,t),s(e,ht,t),p(V,e,t),s(e,Zt,t),p(x,e,t),s(e,Gt,t),s(e,W,t),s(e,Bt,t),s(e,$,t),s(e,Vt,t),s(e,E,t),s(e,xt,t),p(z,e,t),s(e,Wt,t),s(e,k,t),s(e,$t,t),p(R,e,t),s(e,Et,t),s(e,Q,t),s(e,zt,t),p(N,e,t),s(e,kt,t),s(e,L,t),s(e,Rt,t),p(A,e,t),s(e,Qt,t),p(S,e,t),s(e,Nt,t),s(e,q,t),s(e,Lt,t),p(X,e,t),s(e,At,t),s(e,H,t),s(e,St,t),s(e,Y,t),s(e,qt,t),s(e,_,t),s(e,Xt,t),s(e,F,t),s(e,Ht,t),p(D,e,t),s(e,Yt,t),s(e,P,t),s(e,_t,t),p(K,e,t),s(e,Ft,t),p(O,e,t),s(e,Dt,t),s(e,ee,t),s(e,Pt,t),s(e,te,t),s(e,Kt,t),s(e,le,t),s(e,Ot,t),s(e,se,t),s(e,el,t),s(e,ne,t),s(e,tl,t),p(ae,e,t),s(e,ll,t),s(e,ie,t),s(e,sl,t),p(ue,e,t),s(e,nl,t),s(e,oe,t),s(e,al,t),s(e,re,t),s(e,il,t),p(Me,e,t),s(e,ul,t),s(e,pe,t),s(e,ol,t),s(e,me,t),s(e,rl,t),s(e,ce,t),s(e,Ml,t),p(de,e,t),s(e,pl,t),s(e,Je,t),s(e,ml,t),s(e,ye,t),s(e,cl,t),s(e,Te,t),s(e,dl,t),p(Ue,e,t),s(e,Jl,t),s(e,we,t),s(e,yl,t),p(je,e,t),s(e,Tl,t),s(e,be,t),s(e,Ul,t),p(ge,e,t),s(e,wl,t),s(e,fe,t),s(e,jl,t),s(e,Ie,t),s(e,bl,t),p(Ce,e,t),s(e,gl,t),s(e,ve,t),s(e,fl,t),s(e,he,t),s(e,Il,t),p(Ze,e,t),s(e,Cl,t),s(e,Ge,t),s(e,vl,t),s(e,Be,t),s(e,hl,t),s(e,Ve,t),s(e,Zl,t),s(e,xe,t),s(e,Gl,t),s(e,We,t),s(e,Bl,t),p($e,e,t),s(e,Vl,t),s(e,Ee,t),s(e,xl,t),s(e,ze,t),s(e,Wl,t),p(ke,e,t),s(e,$l,t),s(e,Re,t),s(e,El,t),s(e,Qe,t),s(e,zl,t),p(Ne,e,t),s(e,kl,t),s(e,Le,t),s(e,Rl,t),p(Ae,e,t),s(e,Ql,t),s(e,Se,t),s(e,Nl,t),s(e,qe,t),s(e,Ll,t),s(e,Xe,t),s(e,Al,t),p(He,e,t),s(e,Sl,t),s(e,Ye,t),s(e,ql,t),p(_e,e,t),s(e,Xl,t),p(Fe,e,t),s(e,Hl,t),s(e,De,t),s(e,Yl,t),p(Pe,e,t),s(e,_l,t),s(e,Ke,t),s(e,Fl,t),s(e,Oe,t),s(e,Dl,t),s(e,et,t),s(e,Pl,t),p(tt,e,t),s(e,Kl,t),s(e,lt,t),s(e,Ol,t),s(e,st,t),s(e,es,t),s(e,nt,t),s(e,ts,t),s(e,at,t),s(e,ls,t),p(it,e,t),s(e,ss,t),s(e,ut,t),s(e,ns,t),s(e,ot,t),s(e,as,t),s(e,rt,t),s(e,is,t),p(Mt,e,t),s(e,us,t),s(e,mt,t),os=!0},p:Cn,i(e){os||(m(w.$$.fragment,e),m(j.$$.fragment,e),m(b.$$.fragment,e),m(C.$$.fragment,e),m(G.$$.fragment,e),m(V.$$.fragment,e),m(x.$$.fragment,e),m(z.$$.fragment,e),m(R.$$.fragment,e),m(N.$$.fragment,e),m(A.$$.fragment,e),m(S.$$.fragment,e),m(X.$$.fragment,e),m(D.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),m(ae.$$.fragment,e),m(ue.$$.fragment,e),m(Me.$$.fragment,e),m(de.$$.fragment,e),m(Ue.$$.fragment,e),m(je.$$.fragment,e),m(ge.$$.fragment,e),m(Ce.$$.fragment,e),m(Ze.$$.fragment,e),m($e.$$.fragment,e),m(ke.$$.fragment,e),m(Ne.$$.fragment,e),m(Ae.$$.fragment,e),m(He.$$.fragment,e),m(_e.$$.fragment,e),m(Fe.$$.fragment,e),m(Pe.$$.fragment,e),m(tt.$$.fragment,e),m(it.$$.fragment,e),m(Mt.$$.fragment,e),os=!0)},o(e){c(w.$$.fragment,e),c(j.$$.fragment,e),c(b.$$.fragment,e),c(C.$$.fragment,e),c(G.$$.fragment,e),c(V.$$.fragment,e),c(x.$$.fragment,e),c(z.$$.fragment,e),c(R.$$.fragment,e),c(N.$$.fragment,e),c(A.$$.fragment,e),c(S.$$.fragment,e),c(X.$$.fragment,e),c(D.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(ae.$$.fragment,e),c(ue.$$.fragment,e),c(Me.$$.fragment,e),c(de.$$.fragment,e),c(Ue.$$.fragment,e),c(je.$$.fragment,e),c(ge.$$.fragment,e),c(Ce.$$.fragment,e),c(Ze.$$.fragment,e),c($e.$$.fragment,e),c(ke.$$.fragment,e),c(Ne.$$.fragment,e),c(Ae.$$.fragment,e),c(He.$$.fragment,e),c(_e.$$.fragment,e),c(Fe.$$.fragment,e),c(Pe.$$.fragment,e),c(tt.$$.fragment,e),c(it.$$.fragment,e),c(Mt.$$.fragment,e),os=!1},d(e){e&&(l(ct),l(pt),l(dt),l(Jt),l(yt),l(Tt),l(U),l(Ut),l(g),l(wt),l(f),l(jt),l(I),l(bt),l(gt),l(v),l(ft),l(h),l(It),l(Z),l(Ct),l(vt),l(B),l(ht),l(Zt),l(Gt),l(W),l(Bt),l($),l(Vt),l(E),l(xt),l(Wt),l(k),l($t),l(Et),l(Q),l(zt),l(kt),l(L),l(Rt),l(Qt),l(Nt),l(q),l(Lt),l(At),l(H),l(St),l(Y),l(qt),l(_),l(Xt),l(F),l(Ht),l(Yt),l(P),l(_t),l(Ft),l(Dt),l(ee),l(Pt),l(te),l(Kt),l(le),l(Ot),l(se),l(el),l(ne),l(tl),l(ll),l(ie),l(sl),l(nl),l(oe),l(al),l(re),l(il),l(ul),l(pe),l(ol),l(me),l(rl),l(ce),l(Ml),l(pl),l(Je),l(ml),l(ye),l(cl),l(Te),l(dl),l(Jl),l(we),l(yl),l(Tl),l(be),l(Ul),l(wl),l(fe),l(jl),l(Ie),l(bl),l(gl),l(ve),l(fl),l(he),l(Il),l(Cl),l(Ge),l(vl),l(Be),l(hl),l(Ve),l(Zl),l(xe),l(Gl),l(We),l(Bl),l(Vl),l(Ee),l(xl),l(ze),l(Wl),l($l),l(Re),l(El),l(Qe),l(zl),l(kl),l(Le),l(Rl),l(Ql),l(Se),l(Nl),l(qe),l(Ll),l(Xe),l(Al),l(Sl),l(Ye),l(ql),l(Xl),l(Hl),l(De),l(Yl),l(_l),l(Ke),l(Fl),l(Oe),l(Dl),l(et),l(Pl),l(Kl),l(lt),l(Ol),l(st),l(es),l(nt),l(ts),l(at),l(ls),l(ss),l(ut),l(ns),l(ot),l(as),l(rt),l(is),l(us),l(mt)),l(T),d(w,e),d(j,e),d(b,e),d(C,e),d(G,e),d(V,e),d(x,e),d(z,e),d(R,e),d(N,e),d(A,e),d(S,e),d(X,e),d(D,e),d(K,e),d(O,e),d(ae,e),d(ue,e),d(Me,e),d(de,e),d(Ue,e),d(je,e),d(ge,e),d(Ce,e),d(Ze,e),d($e,e),d(ke,e),d(Ne,e),d(Ae,e),d(He,e),d(_e,e),d(Fe,e),d(Pe,e),d(tt,e),d(it,e),d(Mt,e)}}}const En='{"title":"Observer et évaluer des agents","local":"observer-et-évaluer-des-agents","sections":[{"title":"Prérequis de l’exercice 🏗️","local":"prérequis-de-lexercice-","sections":[],"depth":2},{"title":"Étape 0 : Installer les bibliothèques nécessaires","local":"étape-0--installer-les-bibliothèques-nécessaires","sections":[],"depth":2},{"title":"Étape 1 : Instrumenter votre agent","local":"étape-1--instrumenter-votre-agent","sections":[],"depth":2},{"title":"Étape 2 : Testez votre instrumentation","local":"étape-2--testez-votre-instrumentation","sections":[],"depth":2},{"title":"Étape 3 : Observer et évaluer un agent plus complexe","local":"étape-3--observer-et-évaluer-un-agent-plus-complexe","sections":[{"title":"Structure de la trace","local":"structure-de-la-trace","sections":[],"depth":3}],"depth":2},{"title":"Évaluation en ligne","local":"évaluation-en-ligne","sections":[{"title":"Métriques courantes à suivre en production","local":"métriques-courantes-à-suivre-en-production","sections":[{"title":"1. Coûts","local":"1-coûts","sections":[],"depth":4},{"title":"2. Temps de latence","local":"2-temps-de-latence","sections":[],"depth":4},{"title":"3. Attributs supplémentaires","local":"3-attributs-supplémentaires","sections":[],"depth":4},{"title":"4. #### 4. Retour utilisateur","local":"4--4-retour-utilisateur","sections":[],"depth":4},{"title":"5. LLM-as-a-Judge","local":"5-llm-as-a-judge","sections":[],"depth":4},{"title":"6. Aperçu des métriques d’observabilité","local":"6-aperçu-des-métriques-dobservabilité","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Évaluation hors ligne","local":"évaluation-hors-ligne","sections":[{"title":"Évaluation d’un jeu de données","local":"évaluation-dun-jeu-de-données","sections":[{"title":"Exécution de l’agent sur le jeu de données","local":"exécution-de-lagent-sur-le-jeu-de-données","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Réflexions finales","local":"réflexions-finales","sections":[],"depth":2}],"depth":1}';function zn(Ms){return vn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sn extends hn{constructor(T){super(),Zn(this,T,zn,$n,In,{})}}export{Sn as component};
