# 사고: AI 에이전트의 내부 추론과 Re-Act 방식 [[thought-internal-reasoning-and-the-re-act-approach]]

> [!TIP]
> 이 섹션에서는 AI 에이전트의 내면—즉, 추론하고 계획하는 능력을 자세히 살펴봅니다. 에이전트가 내부 대화를 통해 정보를 분석하고, 복잡한 문제를 다루기 쉬운 단계로 나누며, 다음 행동을 결정하는 과정을 탐구합니다. 또한 'Re-Act' 방식이라는 프롬프팅 기법을 소개합니다. 이는 모델이 행동하기 전에 '단계적으로 생각'하도록 유도하는 방법입니다.

사고는 **에이전트가 작업을 해결하기 위해 내부적으로 추론하고 계획하는 과정**을 의미합니다.

이는 에이전트의 대규모 언어 모델(LLM)이 가진 **프롬프트에 제시된 정보를 분석하는 능력**을 활용하는 것입니다.

마치 에이전트의 머릿속 대화라고 생각하면 됩니다. 주어진 과제를 검토하고 어떻게 접근할지 전략을 세우는 과정이죠.

에이전트의 사고 과정은 현재 상황을 관찰하고 다음에 취해야 할 행동을 결정하는 역할을 합니다.

이를 통해 에이전트는 **복잡한 문제를 더 작고 다루기 쉬운 단계로 분해**하고, 이전 경험을 되돌아보며, 새로운 정보를 바탕으로 계획을 지속적으로 조정합니다.

다음은 일반적인 사고 유형의 예시입니다:

| 사고 유형 | 예시 |
|----------------|---------|
| 계획 수립 | "이 작업을 세 단계로 나눠야겠다: 1) 데이터 수집, 2) 트렌드 분석, 3) 보고서 작성" |
| 분석 | "오류 메시지를 보니, 문제는 데이터베이스 연결 설정과 관련이 있는 것 같다" |
| 의사 결정 | "사용자의 예산 제약을 고려하면, 중간 가격대 옵션을 추천하는 것이 좋겠다" |
| 문제 해결 | "이 코드를 최적화하려면, 먼저 어디가 병목인지 프로파일링해봐야 한다" |
| 기억 활용 | "사용자가 앞서 파이썬을 선호한다고 했으니, 파이썬 예제를 제공해야겠다" |
| 자기 성찰 | "이전 접근법이 효과적이지 않았으니, 다른 방식을 시도해봐야겠다" |
| 목표 설정 | "이 작업을 완료하려면, 먼저 성공 기준을 명확히 해야 한다" |
| 우선순위 결정 | "새 기능을 추가하기 전에 보안 취약점부터 해결하는 것이 옳다" |

> **참고:** 함수 호출에 최적화된 LLM의 경우, 사고 과정은 선택적으로 사용할 수 있습니다.
> *함수 호출에 익숙하지 않다면, 행동(Actions) 섹션에서 더 자세한 내용을 확인할 수 있습니다.*

## Re-Act 방식 [[the-re-act-approach]]

핵심 방법론 중 하나는 "추론"(Reasoning)과 "행동"(Acting)을 결합한 **ReAct 방식**입니다.

ReAct는 LLM이 다음 토큰을 생성하기 전에 "단계별로 생각해보자"라는 문구를 추가하는 간단한 프롬프팅 기법입니다.

모델에게 "단계별로 생각"하도록 지시하면, 바로 최종 해답을 내놓기보다 **계획을 세우는 방향**으로 토큰 생성이 유도됩니다. 이는 모델이 문제를 *하위 과제*로 **분해**하도록 장려하기 때문입니다.

이렇게 하면 모델이 각 단계를 더 상세히 고려할 수 있어, 일반적으로 최종 해답을 바로 생성하려 할 때보다 오류가 적게 발생합니다.

<figure>
<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/ReAct.png" alt="ReAct"/>
<figcaption>(d)는 "단계별로 생각해보자"라는 프롬프트를 사용한 Re-Act 방식의 예시입니다
</figcaption>
</figure>

> [!TIP]
> 최근 추론 전략에 대한 관심이 크게 늘고 있습니다. Deepseek R1이나 OpenAI의 o1과 같은 모델들이 바로 이런 흐름을 반영합니다. 이 모델들은 "대답하기 전에 먼저 생각하도록" 특별히 미세 조정되었습니다.
>
> 이런 모델들은 특정 _사고_ 영역(`<think>`와 `</think>` 특수 토큰 사이에 포함)을 항상 생성하도록 훈련되었습니다. 이는 ReAct처럼 단순한 프롬프팅 기법이 아니라, 우리가 원하는 결과물의 수천 가지 예시를 분석한 후 이런 사고 영역을 생성하는 방법을 학습하는 훈련 방식입니다.

--- 
이제 사고 과정에 대해 더 잘 이해했으니, 프로세스의 두 번째 부분인 행동(Act)에 대해 더 자세히 살펴보겠습니다.


<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/ko/unit1/thoughts.mdx" />