# Давайте дообучим вашу модель для вызова функций

Теперь мы готовы к дообучению нашей первой модели для вызова функций 🔥.

## Как обучить нашу модель вызову функций?

> Ответ: Нам нужны **данные**.

Обучение модели можно разделить на 3 шага:

1. **Модель предварительно обучается на большом количестве данных**. Результатом этого шага является **предварительно обученная модель**. Например, [google/gemma-2-2b](https://huggingface.co/google/gemma-2-2b). Это базовая модель, которая умеет только **предсказывать следующий токен, не имеющая хороших способностей к следованию инструкциям**.

2. Затем, чтобы модель была полезна в контексте чата, ее необходимо **дообучить** следовать инструкциям. На этом этапе она может быть обучена создателями модели, сообществом разработчиков, вами или всеми желающими. Например, [google/gemma-2-2b-it](https://huggingface.co/google/gemma-2-2b-it) это инструктивно дообученная модель от Google Tea, созданная в рамках проекта Gemma.

3. Затем модель может быть **выровнена (aligned)** в соответствии с предпочтениями создателя. Например, модель чата службы поддержки, которая никогда не должна быть невежливой с клиентами.

Обычно полноценный продукт вроде Gemini или Mistral **проходит все 3 этапа**, в то время как модели, которые вы можете найти на Hugging Face, прошли один или несколько этапов этого обучения.

В этом руководстве мы создадим модель вызова функций на основе [google/gemma-2-2b-it](https://huggingface.co/google/gemma-2-2b-it). Мы выбрали дообученую модель [google/gemma-2-2b-it](https://huggingface.co/google/gemma-2-2b-it) вместо базовой модели [google/gemma-2-2b](https://huggingface.co/google/gemma-2-2b), потому что дообученная модель лучше подходит для нашего случая использования.

Если начать с предварительно обученной модели, ** потребуется больше тренировок, чтобы научить модель следовать инструкциям, общаться в чате И вызывать функции**.

Начиная с инструктивно дообученной модели, **мы минимизируем количество информации, которое необходимо изучить нашей модели**.

## LoRA (Low-Rank Adaptation of Large Language Models)

LoRA (Low-Rank Adaptation of Large Language Models, Низкоранговая Адаптация Больших Языковых Моделей) это популярная и легковесная техника обучения, которая значительно **сокращает количество обучаемых параметров**.

Она работает путем **вставки меньшего количества новых весов в качестве адаптера в модель для обучения**. Это делает обучение с LoRA намного быстрее, экономит память и создает меньшие веса модели (несколько сотен мегабайт), которые легче хранить и распространять.

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/blog_multi-lora-serving_LoRA.gif" alt="Инференс LoRA" width="50%"/>

LoRA работает путем добавления пар матриц рангового разложения в слои трансформеров, обычно сосредоточенных на линейных слоях. Во время обучения мы "замораживаем" остальную часть модели и обновляем веса только недавно добавленных адаптеров. 

Таким образом, количество параметров, которые нам нужно обучить, значительно уменьшается, поскольку нам нужно обновлять только веса адаптеров.

Во время инференса входные данные передаются в адаптер и базовую модель или эти веса адаптера могут быть объединены с базовой моделью, что не приводит к дополнительным затратам времени. 

LoRA особенно полезна для адаптации **больших** языковых моделей к конкретным задачам или доменам при сохранении управляемых требований к ресурсам. Это помогает сократить объем памяти, требуемый для обучения модели.

Если вы хотите узнать больше о том, как работает LoRA, ознакомьтесь с этим [руководством](https://huggingface.co/learn/nlp-course/chapter11/4?fw=pt).

## Дообучение модели для вызова функций

Вы можете получить доступ к учебному блокноту 👉 [здесь](https://huggingface.co/agents-course/notebooks/blob/main/bonus-unit1/bonus-unit1.ipynb).

Затем нажмите на Open In Colab, чтобы запустить его в Colab Notebook.




<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/ru-RU/bonus-unit1/fine-tuning.mdx" />