# Chào mừng bạn đến với Khóa học AI Agents 🤗 [[introduction]]

<figure>
<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/thumbnail.jpg" alt="Thumbnail khóa học AI Agents" width="100%"/>
<figcaption>Phông nền của hình ảnh được tạo bằng <a href="https://scenario.com/">Scenario.com</a>
</figcaption>
</figure>

Chào mừng bạn đến với chủ đề thú vị nhất trong AI hiện nay: **Agents**!

Khóa học miễn phí này sẽ dẫn dắt bạn từ **người mới bắt đầu trở thành chuyên gia** trong việc hiểu, sử dụng và xây dựng AI Agents.

Chương đầu tiên sẽ giúp bạn làm quen:

- Khám phá **tổng quan khóa học**.
- **Chọn lộ trình** phù hợp (tự học hoặc theo quy trình cấp chứng chỉ).
- **Nhận thông tin chi tiết về quy trình cấp chứng chỉ và deadline**.
- Làm quen với đội ngũ xây dựng khóa học.
- Tạo **tài khoản Hugging Face**.
- **Tham gia Discord server của chúng tôi**, gặp gỡ bạn học và đội ngũ.

Hãy bắt đầu thôi!

## Bạn sẽ học được gì từ khóa học này? [[expect]]

Trong khóa học này, bạn sẽ:

- 📖 Nghiên cứu AI Agents về **lý thuyết, thiết kế và thực hành**
- 🧑‍💻 Học cách **sử dụng các thư viện AI Agent phổ biến** như [smolagents](https://huggingface.co/docs/smolagents/en/index), [LangChain](https://www.langchain.com/) và [LlamaIndex](https://www.llamaindex.ai/)
- 💾 **Chia sẻ Agents của bạn** trên Hugging Face Hub và khám phá Agents từ cộng đồng
- 🏆 Tham gia các thử thách nơi bạn **đánh giá Agents của mình với các học viên khác**
- 🎓 **Nhận chứng chỉ hoàn thành** bằng cách hoàn thành bài tập

Và hơn thế nữa!

Kết thúc khóa học, bạn sẽ hiểu **cách Agents hoạt động và cách xây dựng Agents của riêng bạn bằng các thư viện và công cụ mới nhất**.

Đừng quên **<a href="https://bit.ly/hf-learn-agents">đăng ký khóa học!</a>**

(Chúng tôi tôn trọng quyền riêng tư của bạn. Chúng tôi thu thập email để **gửi bạn link khi mỗi chương được xuất bản và cập nhật thông tin về các thử thách**).

## Cấu trúc khóa học [[course-look-like]]

Khóa học bao gồm:

- *Các chương nền tảng*: nơi bạn học **khái niệm Agents qua lý thuyết**
- *Thực hành*: nơi bạn học **sử dụng các thư viện AI Agent** để huấn luyện Agents trong môi trường độc đáo. Các phần thực hành này sẽ là **Hugging Face Spaces** với môi trường được cấu hình sẵn
- *Bài tập ứng dụng thực tế*: nơi bạn áp dụng kiến thức đã học để giải quyết vấn đề thực tế do bạn lựa chọn
- *Thử thách*: bạn sẽ cho Agent của mình thi đấu với các Agent khác. Sẽ có [bảng xếp hạng](https://huggingface.co/spaces/huggingface-projects/AI-Agents-Leaderboard) (chưa khả dụng) để so sánh hiệu suất

**Khóa học là dự án sống, phát triển cùng phản hồi và đóng góp của bạn!** Hãy thoải mái [mở issues và PRs trên GitHub](https://github.com/huggingface/agents-course), và thảo luận trên Discord server của chúng tôi.

Sau khi hoàn thành khóa học, bạn có thể gửi phản hồi [👉 qua form này](https://docs.google.com/forms/d/e/1FAIpQLSe9VaONn0eglax0uTwi29rIn4tM7H2sYmmybmG5jJNlE5v0xA/viewform?usp=dialog)

## Tổng quan khóa học [[syllabus]]

Đây là **tổng quan khóa học**. Danh sách chi tiết sẽ được cập nhật cùng mỗi chương.

| Chương | Chủ đề | Mô tả |
| :---- | :---- | :---- |
| 0 | Làm quen | Thiết lập công cụ và nền tảng cần dùng |
| 1 | Kiến thức nền tảng về Agent | Giải thích Tools, Thoughts, Actions, Observations và định dạng của chúng. Giới thiệu LLMs, messages, tokens đặc biệt và chat templates. Minh họa các trường hợp (use case) đơn giản sử dụng python functions làm tools |
| 1.5 | Bổ Trợ: Tinh chỉnh (Fine-tune) LLM cho function calling | Sử dụng LoRa và tỉnh chỉnh model để thực hiện function calling trong notebook |
| 2 | Frameworks | Hiểu cách triển khai các nguyên lý trong các thư viện phổ biến: smolagents, LangGraph, LLamaIndex |
| 3 | Use Cases | Xây dựng các use case thực tế (mở cửa cho PRs 🤗 từ các chuyên gia xây dựng Agents) |
| 4 | Bài tập cuối khóa | Xây dựng Agent cho benchmark được chọn và chứng minh hiểu biết của bạn trên bảng xếp hạng học viên 🚀 |

*Chúng tôi cũng dự định phát hành các chương bonus, hãy đón chờ!*

## Yêu cầu đầu vào

Để theo học khóa học này, bạn cần:

- Kiến thức cơ bản về Python
- Hiểu biết cơ bản về LLMs (chúng tôi có phần ôn tập trong chương 1)

## Cần công cụ gì? [[tools]]

Bạn chỉ cần 2 thứ:

- *Máy tính* có kết nối internet
- *Tài khoản Hugging Face*: để đẩy/tải models, agents và tạo Spaces. Nếu chưa có tài khoản, tạo ngay **[tại đây](https://hf.co/join)** (miễn phí)
<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/tools.jpg" alt="Các công cụ cần thiết" width="100%"/>

## Quy trình cấp chứng chỉ [[certification-process]]

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/three-paths.jpg" alt="Hai lộ trình" width="100%"/>

Bạn có thể chọn học *dạng audit* hoặc làm bài tập để *nhận một trong hai loại chứng chỉ*.

Nếu chọn audit, bạn vẫn có thể tham gia mọi thử thách và làm bài tập tùy ý, **không cần thông báo với chúng tôi**.

Quy trình cấp chứng chỉ **hoàn toàn miễn phí**:

- *Chứng chỉ nền tảng*: hoàn thành chương 1. Dành cho học viên muốn cập nhật xu hướng mới về Agents
- *Chứng chỉ hoàn thành khóa học*: hoàn thành chương 1, một bài tập use case bất kỳ và thử thách cuối cùng

Deadline cho quy trình cấp chứng chỉ: tất cả bài tập phải hoàn thành trước **1/5/2025**

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/deadline.jpg" alt="Deadline" width="100%"/>

## Tốc độ học được đề xuất [[recommended-pace]]

Mỗi chương được thiết kế **hoàn thành trong 1 tuần với khoảng 3-4 giờ học/tuần**.

Vì có deadline, chúng tôi đề xuất lộ trình sau:

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/recommended-pace.jpg" alt="Tốc độ được đề xuất" width="100%"/>

## Cách tối ưu hóa trải nghiệm học [[advice]]

Để học hiệu quả nhất, hãy:

1. <a href="https://discord.gg/UrrTSsSyjb">Tham gia nhóm học tập trên Discord</a>: học nhóm luôn dễ hơn. Bạn cần tham gia Discord server và xác minh tài khoản Hugging Face
2. **Làm quiz và bài tập**: cách học tốt nhất là qua thực hành và tự đánh giá
3. **Lập lịch học cố định**: bạn có thể dùng lộ trình đề xuất hoặc tự tạo

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/advice.jpg" alt="Lời khuyên cho khóa học" width="100%"/>

## Về chúng tôi [[who-are-we]]

### Joffrey Thomas

Joffrey là kỹ sư học máy tại Hugging Face, đã xây dựng và triển khai AI Agents trong production. Joffrey sẽ là người hướng dẫn chính của bạn.

- [Follow Joffrey trên Hugging Face](https://huggingface.co/Jofthomas)
- [Follow Joffrey trên X](https://x.com/Jthmas404)
- [Follow Joffrey trên Linkedin](https://www.linkedin.com/in/joffrey-thomas/)

### Ben Burtenshaw

Ben là kỹ sư học máy tại Hugging Face, đã xây dựng nhiều khóa học trên các nền tảng khác nhau. Mục tiêu của Ben là làm khóa học tiếp cận được với mọi người.

- [Follow Ben trên Hugging Face](https://huggingface.co/burtenshaw)
- [Follow Ben trên X](https://x.com/ben_burtenshaw)
- [Follow Ben trên Linkedin](https://www.linkedin.com/in/ben-burtenshaw/)

### Thomas Simonini

Thomas là kỹ sư học máy tại Hugging Face, người xây dựng các khóa học thành công <a href="https://huggingface.co/learn/deep-rl-course/unit0/introduction">Deep RL</a> và <a href="https://huggingface.co/learn/ml-games-course/en/unit0/introduction">ML for games</a>. Thomas là fan cứng của Agents và háo hức xem cộng đồng sẽ xây dựng gì.

- [Follow Thomas trên Hugging Face](https://huggingface.co/ThomasSimonini)
- [Follow Thomas trên X](https://x.com/ThomasSimonini)
- [Follow Thomas trên Linkedin](https://www.linkedin.com/in/simoninithomas/)

## Lời cảm ơn  

Chúng tôi xin gửi lời cảm ơn chân thành đến những cá nhân sau đã đóng góp cho khóa học:  

- **[Pedro Cuenca](https://huggingface.co/pcuenq)** – Vì sự hướng dẫn và chuyên môn trong việc xem xét tài liệu
- **[Aymeric Roucher](https://huggingface.co/m-ric)** – Vì các demo spaces tuyệt vời (decoding và final agent) cùng hỗ trợ về phần smolagents
- **[Joshua Lochner](https://huggingface.co/Xenova)** – Vì demo space xuất sắc về tokenization
- **[Quentin Gallouédec](https://huggingface.co/qgallouedec)** – Vì hỗ trợ nội dung khóa học
- **[David Berenstein](https://huggingface.co/davidberenstein1957)** – Vì hỗ trợ nội dung và điều phối khóa học

## Tôi phát hiện lỗi/muốn cải thiện khóa học [[contribute]]

Đóng góp của bạn luôn **được chào đón** 🤗

- Nếu *phát hiện lỗi 🐛 trong notebook*, vui lòng <a href="https://github.com/huggingface/agents-course/issues">mở issue</a> và **mô tả vấn đề**
- Nếu *muốn cải thiện khóa học*, bạn có thể <a href="https://github.com/huggingface/agents-course/pulls">mở Pull Request</a>
- Nếu *muốn thêm section/chương mới*, tốt nhất hãy <a href="https://github.com/huggingface/agents-course/issues">mở issue</a> và **mô tả nội dung muốn thêm trước khi bắt tay viết**

## Tôi vẫn còn thắc mắc [[questions]]

Hãy đặt câu hỏi trong <a href="https://discord.gg/UrrTSsSyjb">discord server #ai-agents-discussions</a>

Sẵn sàng chưa, hãy cùng lên đường ⛵ 

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit0/time-to-onboard.jpg" alt="Đến lúc làm quen" width="100%"/>

<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/vi/unit0/introduction.mdx" />