import{s as dn,n as bn,o as fn}from"../chunks/scheduler.505acc25.js";import{S as Rn,i as hn,e as U,s as n,c as p,h as Qn,a as M,d as e,b as a,f as In,g as T,j as J,k as ps,l as Bn,m as s,n as i,t as o,o as C,p as y}from"../chunks/index.b1175496.js";import{C as kn,H as m}from"../chunks/Heading.eda51538.js";import{C as r}from"../chunks/CodeBlock.9d480d26.js";import{C as Nn}from"../chunks/CourseFloatingBanner.79ef6243.js";import{E as En}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.ea377ea6.js";function Fn(Ts){let u,Ct,it,yt,c,mt,j,rt,g,ut,w,is='<p>你可以跟随<a href="https://huggingface.co/agents-course/notebooks/blob/main/bonus-unit2/monitoring-and-evaluating-agents-notebook.ipynb" target="_blank">这个 notebook</a> 中的代码进行操作，你可以在 Google Colab 上运行它。</p>',wt,V,os="在这个 notebook 中，我们将学习如何使用开源可观测性工具来<strong>监督我们 AI 智能体的内部步骤（追踪）</strong>并<strong>评估其性能</strong>。",ct,I,Cs="观测和评估智能体行为的能力对于以下方面至关重要：",jt,d,ys="<li>当任务失败或产生次优结果时调试问题</li> <li>实时跟踪成本和性能</li> <li>通过持续反馈提高可靠性和安全性</li>",gt,b,Vt,f,ms="在运行此 notebook 之前，请确保你已经：",It,R,rs='🔲 📚  <strong>学习了</strong> <a href="https://huggingface.co/learn/agents-course/unit1/introduction" rel="nofollow">智能体简介</a>',dt,h,us='🔲 📚  <strong>学习了</strong> <a href="https://huggingface.co/learn/agents-course/unit2/smolagents/introduction" rel="nofollow">smolagents 框架</a>',bt,Q,ft,B,ws="我们将需要一些库，以便我们能够运行、监控和评估我们的智能体：",Rt,k,ht,N,Qt,E,cs='在这个 notebook 中，我们将使用 <a href="https://langfuse.com/" rel="nofollow">Langfuse</a> 作为我们的可观测性工具，但你可以使用<strong>任何其他兼容 OpenTelemetry 的服务</strong>。下面的代码展示了如何为 Langfuse（或任何 OTel 端点）设置环境变量，以及如何检测你的 smolagent。',Bt,F,js='<strong>请注意：</strong> 如果你正在使用 LlamaIndex 或 LangGraph，你可以在<a href="https://langfuse.com/docs/integrations/llama-index/workflows" rel="nofollow">这里</a>和<a href="https://langfuse.com/docs/integrations/langchain/example-python-langgraph" rel="nofollow">这里</a>找到检测它们的文档。',kt,Z,gs="首先，让我们配置正确的环境变量，以设置到 Langfuse OpenTelemetry 端点的连接。",Nt,S,Et,v,Vs="我们还需要配置我们的 Hugging Face token 用于推理调用。",Ft,$,Zt,G,Is="接下来，我们可以为我们配置的 OpenTelemetry 设置一个 tracer-provider。",St,Y,vt,x,$t,_,ds="这里有一个来自 smolagents 的简单 CodeAgent，用于计算 <code>1+1</code>。我们运行它来确认检测是否正常工作。如果一切设置正确，你将在你的可观测性仪表板中看到日志/跨度（spans）。",Gt,W,Yt,A,bs='检查你的 <a href="https://cloud.langfuse.com" rel="nofollow">Langfuse Traces Dashboard</a>（或你选择的可观测性工具）以确认跨度（spans）和日志已被记录。',xt,L,fs="Langfuse 中的示例截图：",_t,O,Rs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/first-example-trace.png" alt="Example trace in Langfuse"/>',Wt,H,hs='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1b94d6888258e0998329cdb72a371155?timestamp=2025-03-10T11%3A59%3A41.743Z" rel="nofollow">追踪链接</a></em>',At,X,Lt,z,Qs="既然你已经确认你的检测工作正常，让我们尝试一个更复杂的查询，这样我们就可以看到高级指标（token 使用量、延迟、成本等）是如何被追踪的。",Ot,q,Ht,D,Xt,P,Bs="大多数可观测性工具会记录一个<strong>追踪（trace）</strong>，其中包含<strong>跨度（spans）</strong>，每个跨度代表你的智能体逻辑的一个步骤。在这里，追踪包含了整体的智能体运行以及用于以下内容的子跨度：",zt,K,ks="<li>工具调用 (DuckDuckGoSearchTool)</li> <li>LLM 调用 (InferenceClientModel)</li>",qt,ll,Ns="你可以检查这些跨度，以精确地了解时间花在哪里、使用了多少 token 等等：",Dt,tl,Es="Langfuse 中的追踪树：",Pt,el,Fs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/trace-tree.png" alt="Trace tree in Langfuse"/>',Kt,sl,Zs='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">前往追踪（trace）的链接</a></em>',le,nl,te,al,Ss="在上一节中，我们了解了在线评估和离线评估的区别。现在，我们将了解如何在生产环境中监控你的智能体并实时评估它。",ee,Ul,se,Ml,vs="<li><strong>成本</strong> — smolagents 检测会捕获 token 使用量，你可以通过为每个 token 分配价格将其转换为近似成本。</li> <li><strong>延迟</strong> — 观察完成每个步骤或整个运行所需的时间。</li> <li><strong>用户反馈</strong> — 用户可以提供直接反馈（点赞/点踩）来帮助优化或纠正智能体。</li> <li><strong>LLM 作为评判者</strong> — 使用一个单独的 LLM 来近乎实时地评估你的智能体的输出（例如，检查毒性或正确性）。</li>",ne,Jl,$s="下面，我们展示这些指标的示例。",ae,pl,Ue,Tl,Gs="下面是一个显示 <code>Qwen2.5-Coder-32B-Instruct</code> 调用使用情况的截图。这对于查看成本高昂的步骤并优化你的智能体很有用。",Me,il,Ys='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-costs.png" alt="Costs"/>',Je,ol,xs='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">前往追踪（trace）的链接</a></em>',pe,Cl,Te,yl,_s="我们还可以看到完成每个步骤所需的时间。在下面的示例中，整个对话花费了 32 秒，你可以按步骤分解。这有助于你识别瓶颈并优化你的智能体。",ie,ml,Ws='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-latency.png" alt="Latency"/>',oe,rl,As='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/1ac33b89ffd5e75d4265b62900c348ed?timestamp=2025-03-07T13%3A45%3A09.149Z&amp;display=preview" rel="nofollow">前往追踪（trace）的链接</a></em>',Ce,ul,ye,wl,Ls="你还可以通过在跨度（spans）上设置附加属性——例如用户 ID、会话 ID 或标签。例如，smolagents 检测使用 OpenTelemetry 来附加诸如 <code>langfuse.user.id</code> 或自定义标签之类的属性。",me,cl,re,jl,Os='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/smolagents-attributes.png" alt="Enhancing agent runs with additional metrics"/>',ue,gl,we,Vl,Hs='如果你的智能体嵌入到用户界面中，你可以记录直接的用户反馈（例如聊天界面中的点赞/点踩）。下面是使用 <a href="https://gradio.app/" rel="nofollow">Gradio</a> 嵌入带有简单反馈机制的聊天示例。',ce,Il,Xs="在下面的代码片段中，当用户发送聊天消息时，我们捕获 OpenTelemetry 追踪 ID。如果用户喜欢/不喜欢上一个答案，我们将评分附加到该追踪上。",je,dl,ge,bl,zs="然后，用户反馈会被捕获到你的可观测性工具中：",Ve,fl,qs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/user-feedback-gradio.png" alt="User feedback is being captured in Langfuse"/>',Ie,Rl,de,hl,Ds="LLM 作为评判者（LLM-as-a-Judge）是另一种自动评估你的智能体输出的方法。你可以设置一个单独的 LLM 调用来衡量输出的正确性、毒性、风格或你关心的任何其他标准。",be,Ql,Ps="<strong>工作流程</strong>：",fe,Bl,Ks="<li>你定义一个<strong>评估模板</strong>，例如，“检查文本是否有毒。”</li> <li>每次你的智能体生成输出时，你将该输出连同模板一起传递给你的“评判者” LLM。</li> <li>评判者 LLM 会返回一个评分或标签，你将其记录到你的可观测性工具中。</li>",Re,kl,ln="来自 Langfuse 的示例：",he,Nl,tn='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/evaluator-template.png" alt="LLM-as-a-Judge Evaluation Template"/> <img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/evaluator.png" alt="LLM-as-a-Judge Evaluator"/>',Qe,El,Be,Fl,en="你可以看到这个例子的答案被判定为“无毒”。",ke,Zl,sn='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/llm-as-a-judge-score.png" alt="LLM-as-a-Judge Evaluation Score"/>',Ne,Sl,Ee,vl,nn="所有这些指标都可以在仪表板中一起可视化。这使你能够快速查看你的智能体在多个会话中的表现，并帮助你随时间追踪质量指标。",Fe,$l,an='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/langfuse-dashboard.png" alt="Observability metrics overview"/>',Ze,Gl,Se,Yl,Un="在线评估对于实时反馈至关重要，但你还需要<strong>离线评估</strong>——在开发之前或期间进行系统性检查。这有助于在将更改推送到生产环境之前维护质量和可靠性。",ve,xl,$e,_l,Mn="在离线评估中，你通常：",Ge,Wl,Jn="<li>拥有一个基准数据集（包含提示和预期输出对）</li> <li>在该数据集上运行你的智能体</li> <li>将输出与预期结果进行比较，或使用额外的评分机制</li>",Ye,Al,pn='下面，我们使用 <a href="https://huggingface.co/datasets/gsm8k" rel="nofollow">GSM8K 数据集</a> 来演示这种方法，该数据集包含数学问题和解决方案。',xe,Ll,_e,Ol,Tn="接下来，我们在 Langfuse 中创建一个数据集实体来追踪运行。然后，我们将数据集中的每个项目添加到系统中。（如果你不使用 Langfuse，你可以简单地将这些存储在你自己的数据库或本地文件中进行分析。）",We,Hl,Ae,Xl,Le,zl,on='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/example-dataset.png" alt="Dataset items in Langfuse"/>',Oe,ql,He,Dl,Cn="我们定义一个辅助函数 <code>run_smolagent()</code>，它：",Xe,Pl,yn="<li>启动一个 OpenTelemetry 跨度（span）</li> <li>在提示上运行我们的智能体</li> <li>在 Langfuse 中记录追踪 ID</li>",ze,Kl,mn="然后，我们遍历每个数据集项目，运行智能体，并将追踪链接到数据集项目。如果需要，我们还可以附加一个快速评估分数。",qe,lt,De,tt,Pe,et,rn="你可以用不同的配置重复这个过程：",Ke,st,un="<li>模型 (OpenAI GPT, 本地 LLM 等)</li> <li>工具 (使用搜索 vs. 不使用搜索)</li> <li>提示 (不同的系统消息)</li>",ls,nt,wn="然后在你的可观测性工具中并排比较它们：",ts,at,cn='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/dataset_runs.png" alt="Dataset run overview"/> <img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit2/dataset-run-comparison.png" alt="Dataset run comparison"/>',es,Ut,ss,Mt,jn="在这个 notebook 中，我们介绍了如何：",ns,Jt,gn="<li><strong>设置可观测性</strong> 使用 smolagents + OpenTelemetry 导出器</li> <li><strong>检查检测</strong> 通过运行一个简单的智能体</li> <li><strong>捕获详细指标</strong> (成本、延迟等) 通过可观测性工具</li> <li><strong>收集用户反馈</strong> 通过 Gradio 界面</li> <li><strong>使用 LLM 作为评判者</strong> 自动评估输出</li> <li><strong>执行离线评估</strong> 使用基准数据集</li>",as,pt,Vn="🤗 编代码愉快！",Us,Tt,Ms,ot,Js;return c=new Nn({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https://huggingface.co/agents-course/notebooks/blob/main/bonus-unit2/monitoring-and-evaluating-agents.ipynb"}]}}),j=new kn({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),g=new m({props:{title:"附加单元 2：AI 智能体(AI Agent)的可观测性与评估",local:"附加单元-2ai-智能体ai-agent的可观测性与评估",headingTag:"h1"}}),b=new m({props:{title:"练习先决条件 🏗️",local:"练习先决条件-",headingTag:"h2"}}),Q=new m({props:{title:"步骤 0：安装所需的库",local:"步骤-0安装所需的库",headingTag:"h2"}}),k=new r({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCdGVsZW1ldHJ5JTVEJyUwQSUyNXBpcCUyMGluc3RhbGwlMjBvcGVudGVsZW1ldHJ5LXNkayUyMG9wZW50ZWxlbWV0cnktZXhwb3J0ZXItb3RscCUyMG9wZW5pbmZlcmVuY2UtaW5zdHJ1bWVudGF0aW9uLXNtb2xhZ2VudHMlMEElMjVwaXAlMjBpbnN0YWxsJTIwbGFuZ2Z1c2UlMjBkYXRhc2V0cyUyMCdzbW9sYWdlbnRzJTVCZ3JhZGlvJTVEJw==",highlighted:`%pip install <span class="hljs-string">&#x27;smolagents[telemetry]&#x27;</span>
%pip install opentelemetry-sdk opentelemetry-exporter-otlp openinference-instrumentation-smolagents
%pip install langfuse datasets <span class="hljs-string">&#x27;smolagents[gradio]&#x27;</span>`,wrap:!1}}),N=new m({props:{title:"步骤 1：检测你的智能体",local:"步骤-1检测你的智能体",headingTag:"h2"}}),S=new r({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjBiYXNlNjQlMEElMEElMjMlMjAlRTQlQkIlOEUlMjBodHRwcyUzQSUyRiUyRmNsb3VkLmxhbmdmdXNlLmNvbSUyMCVFOCU4RSVCNyVFNSU4RiU5NiVFNCVCRCVBMCVFOCU4NyVBQSVFNSVCNyVCMSVFNyU5QSU4NCVFNSVBRiU4NiVFOSU5MiVBNSUwQUxBTkdGVVNFX1BVQkxJQ19LRVklMjAlM0QlMjAlMjJway1sZi0uLi4lMjIlMEFMQU5HRlVTRV9TRUNSRVRfS0VZJTIwJTNEJTIwJTIyc2stbGYtLi4uJTIyJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX1BVQkxJQ19LRVklMjIlNUQlMjAlM0QlMjBMQU5HRlVTRV9QVUJMSUNfS0VZJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX1NFQ1JFVF9LRVklMjIlNUQlMjAlM0QlMjBMQU5HRlVTRV9TRUNSRVRfS0VZJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX0hPU1QlMjIlNUQlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmNsb3VkLmxhbmdmdXNlLmNvbSUyMiUyMCUyMCUyMyUyMCVGMCU5RiU4NyVBQSVGMCU5RiU4NyVCQSUyMCVFNiVBQyVBNyVFNyU5QiU5RiVFNSU4QyVCQSVFNSU5RiU5RiVFNyVBNCVCQSVFNCVCRSU4QiUwQSUyMyUyMG9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ1cy5jbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjAlMjMlMjAlRjAlOUYlODclQkElRjAlOUYlODclQjglMjAlRTclQkUlOEUlRTUlOUIlQkQlRTUlOEMlQkElRTUlOUYlOUYlRTclQTQlQkElRTQlQkUlOEIlMEElMEFMQU5HRlVTRV9BVVRIJTIwJTNEJTIwYmFzZTY0LmI2NGVuY29kZSglMEElMjAlMjAlMjAlMjBmJTIyJTdCTEFOR0ZVU0VfUFVCTElDX0tFWSU3RCUzQSU3QkxBTkdGVVNFX1NFQ1JFVF9LRVklN0QlMjIuZW5jb2RlKCklMEEpLmRlY29kZSgpJTBBJTBBb3MuZW52aXJvbiU1QiUyMk9URUxfRVhQT1JURVJfT1RMUF9FTkRQT0lOVCUyMiU1RCUyMCUzRCUyMG9zLmVudmlyb24uZ2V0KCUyMkxBTkdGVVNFX0hPU1QlMjIpJTIwJTJCJTIwJTIyJTJGYXBpJTJGcHVibGljJTJGb3RlbCUyMiUwQW9zLmVudmlyb24lNUIlMjJPVEVMX0VYUE9SVEVSX09UTFBfSEVBREVSUyUyMiU1RCUyMCUzRCUyMGYlMjJBdXRob3JpemF0aW9uJTNEQmFzaWMlMjAlN0JMQU5HRlVTRV9BVVRIJTdEJTIy",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> base64

<span class="hljs-comment"># 从 https://cloud.langfuse.com 获取你自己的密钥</span>
LANGFUSE_PUBLIC_KEY = <span class="hljs-string">&quot;pk-lf-...&quot;</span>
LANGFUSE_SECRET_KEY = <span class="hljs-string">&quot;sk-lf-...&quot;</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_PUBLIC_KEY&quot;</span>] = LANGFUSE_PUBLIC_KEY
os.environ[<span class="hljs-string">&quot;LANGFUSE_SECRET_KEY&quot;</span>] = LANGFUSE_SECRET_KEY
os.environ[<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>] = <span class="hljs-string">&quot;https://cloud.langfuse.com&quot;</span>  <span class="hljs-comment"># 🇪🇺 欧盟区域示例</span>
<span class="hljs-comment"># os.environ[&quot;LANGFUSE_HOST&quot;] = &quot;https://us.cloud.langfuse.com&quot;  # 🇺🇸 美国区域示例</span>

LANGFUSE_AUTH = base64.b64encode(
    <span class="hljs-string">f&quot;<span class="hljs-subst">{LANGFUSE_PUBLIC_KEY}</span>:<span class="hljs-subst">{LANGFUSE_SECRET_KEY}</span>&quot;</span>.encode()
).decode()

os.environ[<span class="hljs-string">&quot;OTEL_EXPORTER_OTLP_ENDPOINT&quot;</span>] = os.environ.get(<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>) + <span class="hljs-string">&quot;/api/public/otel&quot;</span>
os.environ[<span class="hljs-string">&quot;OTEL_EXPORTER_OTLP_HEADERS&quot;</span>] = <span class="hljs-string">f&quot;Authorization=Basic <span class="hljs-subst">{LANGFUSE_AUTH}</span>&quot;</span>`,wrap:!1}}),$=new r({props:{code:"JTIzJTIwJUU1JUIwJTg2JUU0JUJEJUEwJUU3JTlBJTg0JTIwSHVnZ2luZyUyMEZhY2UlMjAlRTUlOTIlOEMlRTUlODUlQjYlRTQlQkIlOTYlMjB0b2tlbiVFNiU4OCU5NiVFOCU4MCU4NSVFNSVBRiU4NiVFOSU5MiVBNSVFOCVBRSVCRSVFNyVCRCVBRSVFNCVCOCVCQSVFNyU4RSVBRiVFNSVBMiU4MyVFNSU4RiU5OCVFOSU4NyU4RiUwQW9zLmVudmlyb24lNUIlMjJIRl9UT0tFTiUyMiU1RCUyMCUzRCUyMCUyMmhmXy4uLiUyMg==",highlighted:`<span class="hljs-comment"># 将你的 Hugging Face 和其他 token或者密钥设置为环境变量</span>
os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>] = <span class="hljs-string">&quot;hf_...&quot;</span>`,wrap:!1}}),Y=new r({props:{code:"ZnJvbSUyMG9wZW50ZWxlbWV0cnkuc2RrLnRyYWNlJTIwaW1wb3J0JTIwVHJhY2VyUHJvdmlkZXIlMEFmcm9tJTIwb3BlbmluZmVyZW5jZS5pbnN0cnVtZW50YXRpb24uc21vbGFnZW50cyUyMGltcG9ydCUyMFNtb2xhZ2VudHNJbnN0cnVtZW50b3IlMEFmcm9tJTIwb3BlbnRlbGVtZXRyeS5leHBvcnRlci5vdGxwLnByb3RvLmh0dHAudHJhY2VfZXhwb3J0ZXIlMjBpbXBvcnQlMjBPVExQU3BhbkV4cG9ydGVyJTBBZnJvbSUyMG9wZW50ZWxlbWV0cnkuc2RrLnRyYWNlLmV4cG9ydCUyMGltcG9ydCUyMFNpbXBsZVNwYW5Qcm9jZXNzb3IlMEElMEElMjMlMjAlRTQlQjglQkElMjBPcGVuVGVsZW1ldHJ5JTIwJUU1JTg4JTlCJUU1JUJCJUJBJUU0JUI4JTgwJUU0JUI4JUFBJTIwVHJhY2VyUHJvdmlkZXIlMEF0cmFjZV9wcm92aWRlciUyMCUzRCUyMFRyYWNlclByb3ZpZGVyKCklMEElMEElMjMlMjAlRTYlQjclQkIlRTUlOEElQTAlRTQlQjglODAlRTQlQjglQUElRTUlQjglQTYlRTYlOUMlODklMjBPVExQU3BhbkV4cG9ydGVyJTIwJUU3JTlBJTg0JTIwU2ltcGxlU3BhblByb2Nlc3NvciUyMCVFNiU5RCVBNSVFNSU4RiU5MSVFOSU4MCU4MSVFOCVCRiVCRCVFOCVCOCVBQSUwQXRyYWNlX3Byb3ZpZGVyLmFkZF9zcGFuX3Byb2Nlc3NvcihTaW1wbGVTcGFuUHJvY2Vzc29yKE9UTFBTcGFuRXhwb3J0ZXIoKSkpJTBBJTBBJTIzJTIwJUU4JUFFJUJFJUU3JUJEJUFFJUU1JTg1JUE4JUU1JUIxJTgwJUU5JUJCJTk4JUU4JUFFJUE0JTIwdHJhY2VyJTIwcHJvdmlkZXIlMEFmcm9tJTIwb3BlbnRlbGVtZXRyeSUyMGltcG9ydCUyMHRyYWNlJTBBdHJhY2Uuc2V0X3RyYWNlcl9wcm92aWRlcih0cmFjZV9wcm92aWRlciklMEF0cmFjZXIlMjAlM0QlMjB0cmFjZS5nZXRfdHJhY2VyKF9fbmFtZV9fKSUwQSUwQSUyMyUyMCVFNCVCRCVCRiVFNyU5NCVBOCVFOSU4NSU4RCVFNyVCRCVBRSVFNyU5QSU4NCUyMHByb3ZpZGVyJTIwJUU2JUEzJTgwJUU2JUI1JThCJTIwc21vbGFnZW50cyUwQVNtb2xhZ2VudHNJbnN0cnVtZW50b3IoKS5pbnN0cnVtZW50KHRyYWNlcl9wcm92aWRlciUzRHRyYWNlX3Byb3ZpZGVyKSUwQQ==",highlighted:`<span class="hljs-keyword">from</span> opentelemetry.sdk.trace <span class="hljs-keyword">import</span> TracerProvider
<span class="hljs-keyword">from</span> openinference.instrumentation.smolagents <span class="hljs-keyword">import</span> SmolagentsInstrumentor
<span class="hljs-keyword">from</span> opentelemetry.exporter.otlp.proto.http.trace_exporter <span class="hljs-keyword">import</span> OTLPSpanExporter
<span class="hljs-keyword">from</span> opentelemetry.sdk.trace.export <span class="hljs-keyword">import</span> SimpleSpanProcessor

<span class="hljs-comment"># 为 OpenTelemetry 创建一个 TracerProvider</span>
trace_provider = TracerProvider()

<span class="hljs-comment"># 添加一个带有 OTLPSpanExporter 的 SimpleSpanProcessor 来发送追踪</span>
trace_provider.add_span_processor(SimpleSpanProcessor(OTLPSpanExporter()))

<span class="hljs-comment"># 设置全局默认 tracer provider</span>
<span class="hljs-keyword">from</span> opentelemetry <span class="hljs-keyword">import</span> trace
trace.set_tracer_provider(trace_provider)
tracer = trace.get_tracer(__name__)

<span class="hljs-comment"># 使用配置的 provider 检测 smolagents</span>
SmolagentsInstrumentor().instrument(tracer_provider=trace_provider)
`,wrap:!1}}),x=new m({props:{title:"步骤 2：测试你的检测",local:"步骤-2测试你的检测",headingTag:"h2"}}),W=new r({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQSUyMyUyMCVFNSU4OCU5QiVFNSVCQiVCQSVFNCVCOCU4MCVFNCVCOCVBQSVFNyVBRSU4MCVFNSU4RCU5NSVFNyU5QSU4NCVFNiU5OSVCQSVFOCU4MyVCRCVFNCVCRCU5MyVFNiU5RCVBNSVFNiVCNSU4QiVFOCVBRiU5NSVFNiVBMyU4MCVFNiVCNSU4QiUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTBBKSUwQSUwQWFnZW50LnJ1biglMjIxJTJCMSUzRCUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-comment"># 创建一个简单的智能体来测试检测</span>
agent = CodeAgent(
    tools=[],
    model=InferenceClientModel()
)

agent.run(<span class="hljs-string">&quot;1+1=&quot;</span>)`,wrap:!1}}),X=new m({props:{title:"步骤 3：观测和评估更复杂的AI智能体",local:"步骤-3观测和评估更复杂的ai智能体",headingTag:"h2"}}),q=new r({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCklMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QnNlYXJjaF90b29sJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpKSUwQSUwQWFnZW50LnJ1biglMjJIb3clMjBtYW55JTIwUnViaWsncyUyMEN1YmVzJTIwY291bGQlMjB5b3UlMjBmaXQlMjBpbnNpZGUlMjB0aGUlMjBOb3RyZSUyMERhbWUlMjBDYXRoZWRyYWwlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(tools=[search_tool], model=InferenceClientModel())

agent.run(<span class="hljs-string">&quot;How many Rubik&#x27;s Cubes could you fit inside the Notre Dame Cathedral?&quot;</span>)`,wrap:!1}}),D=new m({props:{title:"追踪结构",local:"追踪结构",headingTag:"h3"}}),nl=new m({props:{title:"在线评估",local:"在线评估",headingTag:"h2"}}),Ul=new m({props:{title:"生产环境中要追踪的常见指标",local:"生产环境中要追踪的常见指标",headingTag:"h3"}}),pl=new m({props:{title:"1. 成本",local:"1-成本",headingTag:"h4"}}),Cl=new m({props:{title:"2. 延迟",local:"2-延迟",headingTag:"h4"}}),ul=new m({props:{title:"3. 附加属性",local:"3-附加属性",headingTag:"h4"}}),cl=new r({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCklMEFmcm9tJTIwb3BlbnRlbGVtZXRyeSUyMGltcG9ydCUyMHRyYWNlJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCgpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJzZWFyY2hfdG9vbCU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUwQSklMEElMEF3aXRoJTIwdHJhY2VyLnN0YXJ0X2FzX2N1cnJlbnRfc3BhbiglMjJTbW9sYWdlbnQtVHJhY2UlMjIpJTIwYXMlMjBzcGFuJTNBJTBBJTIwJTIwJTIwJTIwc3Bhbi5zZXRfYXR0cmlidXRlKCUyMmxhbmdmdXNlLnVzZXIuaWQlMjIlMkMlMjAlMjJzbW9sYWdlbnQtdXNlci0xMjMlMjIpJTBBJTIwJTIwJTIwJTIwc3Bhbi5zZXRfYXR0cmlidXRlKCUyMmxhbmdmdXNlLnNlc3Npb24uaWQlMjIlMkMlMjAlMjJzbW9sYWdlbnQtc2Vzc2lvbi0xMjM0NTY3ODklMjIpJTBBJTIwJTIwJTIwJTIwc3Bhbi5zZXRfYXR0cmlidXRlKCUyMmxhbmdmdXNlLnRhZ3MlMjIlMkMlMjAlNUIlMjJjaXR5LXF1ZXN0aW9uJTIyJTJDJTIwJTIydGVzdGluZy1hZ2VudHMlMjIlNUQpJTBBJTBBJTIwJTIwJTIwJTIwYWdlbnQucnVuKCUyMldoYXQlMjBpcyUyMHRoZSUyMGNhcGl0YWwlMjBvZiUyMEdlcm1hbnklM0YlMjIpJTBB",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)
<span class="hljs-keyword">from</span> opentelemetry <span class="hljs-keyword">import</span> trace

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(
    tools=[search_tool],
    model=InferenceClientModel()
)

<span class="hljs-keyword">with</span> tracer.start_as_current_span(<span class="hljs-string">&quot;Smolagent-Trace&quot;</span>) <span class="hljs-keyword">as</span> span:
    span.set_attribute(<span class="hljs-string">&quot;langfuse.user.id&quot;</span>, <span class="hljs-string">&quot;smolagent-user-123&quot;</span>)
    span.set_attribute(<span class="hljs-string">&quot;langfuse.session.id&quot;</span>, <span class="hljs-string">&quot;smolagent-session-123456789&quot;</span>)
    span.set_attribute(<span class="hljs-string">&quot;langfuse.tags&quot;</span>, [<span class="hljs-string">&quot;city-question&quot;</span>, <span class="hljs-string">&quot;testing-agents&quot;</span>])

    agent.run(<span class="hljs-string">&quot;What is the capital of Germany?&quot;</span>)
`,wrap:!1}}),gl=new m({props:{title:"4. 用户反馈",local:"4-用户反馈",headingTag:"h4"}}),dl=new r({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> opentelemetry.trace <span class="hljs-keyword">import</span> format_trace_id
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, InferenceClientModel)
<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> Langfuse

langfuse = Langfuse()
model = InferenceClientModel()
agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)

formatted_trace_id = <span class="hljs-literal">None</span>  <span class="hljs-comment"># 为演示目的，我们将在全局存储当前的 trace_id</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">respond</span>(<span class="hljs-params">prompt, history</span>):
    <span class="hljs-keyword">with</span> trace.get_tracer(__name__).start_as_current_span(<span class="hljs-string">&quot;Smolagent-Trace&quot;</span>) <span class="hljs-keyword">as</span> span:
        output = agent.run(prompt)

        current_span = trace.get_current_span()
        span_context = current_span.get_span_context()
        trace_id = span_context.trace_id
        <span class="hljs-keyword">global</span> formatted_trace_id
        formatted_trace_id = <span class="hljs-built_in">str</span>(format_trace_id(trace_id))
        langfuse.trace(<span class="hljs-built_in">id</span>=formatted_trace_id, <span class="hljs-built_in">input</span>=prompt, output=output)

    history.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-built_in">str</span>(output)})
    <span class="hljs-keyword">return</span> history

<span class="hljs-keyword">def</span> <span class="hljs-title function_">handle_like</span>(<span class="hljs-params">data: gr.LikeData</span>):
    <span class="hljs-comment"># 作为演示，我们将用户反馈映射为 1 (喜欢) 或 0 (不喜欢)</span>
    <span class="hljs-keyword">if</span> data.liked:
        langfuse.score(
            value=<span class="hljs-number">1</span>,
            name=<span class="hljs-string">&quot;user-feedback&quot;</span>,
            trace_id=formatted_trace_id
        )
    <span class="hljs-keyword">else</span>:
        langfuse.score(
            value=<span class="hljs-number">0</span>,
            name=<span class="hljs-string">&quot;user-feedback&quot;</span>,
            trace_id=formatted_trace_id
        )

<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    chatbot = gr.Chatbot(label=<span class="hljs-string">&quot;Chat&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>)
    prompt_box = gr.Textbox(placeholder=<span class="hljs-string">&quot;Type your message...&quot;</span>, label=<span class="hljs-string">&quot;Your message&quot;</span>)

    <span class="hljs-comment"># 当用户在提示框上按 &#x27;Enter&#x27; 时，我们运行 &#x27;respond&#x27;</span>
    prompt_box.submit(
        fn=respond,
        inputs=[prompt_box, chatbot],
        outputs=chatbot
    )

    <span class="hljs-comment"># 当用户点击消息上的 &#x27;喜欢&#x27; 按钮时，我们运行 &#x27;handle_like&#x27;</span>
    chatbot.like(handle_like, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>)

demo.launch()
`,wrap:!1}}),Rl=new m({props:{title:"5. LLM 作为评判者",local:"5-llm-作为评判者",headingTag:"h4"}}),El=new r({props:{code:"JTIzJTIwJUU3JUE0JUJBJUU0JUJFJThCJUVGJUJDJTlBJUU2JUEzJTgwJUU2JTlGJUE1JUU2JTk5JUJBJUU4JTgzJUJEJUU0JUJEJTkzJUU3JTlBJTg0JUU4JUJFJTkzJUU1JTg3JUJBJUU2JTk4JUFGJUU1JTkwJUE2JUU2JTlDJTg5JUU2JUFGJTkyJUUzJTgwJTgyJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoQ29kZUFnZW50JTJDJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2wlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCklMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMER1Y2tEdWNrR29TZWFyY2hUb29sKCklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QnNlYXJjaF90b29sJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpKSUwQSUwQWFnZW50LnJ1biglMjJDYW4lMjBlYXRpbmclMjBjYXJyb3RzJTIwaW1wcm92ZSUyMHlvdXIlMjB2aXNpb24lM0YlMjIpJTBB",highlighted:`<span class="hljs-comment"># 示例：检查智能体的输出是否有毒。</span>
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, DuckDuckGoSearchTool, InferenceClientModel)

search_tool = DuckDuckGoSearchTool()
agent = CodeAgent(tools=[search_tool], model=InferenceClientModel())

agent.run(<span class="hljs-string">&quot;Can eating carrots improve your vision?&quot;</span>)
`,wrap:!1}}),Sl=new m({props:{title:"6. 可观测性指标概览",local:"6-可观测性指标概览",headingTag:"h4"}}),Gl=new m({props:{title:"离线评估",local:"离线评估",headingTag:"h2"}}),xl=new m({props:{title:"数据集评估",local:"数据集评估",headingTag:"h3"}}),Ll=new r({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQSUyMyUyMCVFNCVCQiU4RSUyMEh1Z2dpbmclMjBGYWNlJTIwJUU4JThFJUI3JUU1JThGJTk2JTIwR1NNOEslMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMm9wZW5haSUyRmdzbThrJTIyJTJDJTIwJ21haW4nJTJDJTIwc3BsaXQlM0QndHJhaW4nKSUwQWRmJTIwJTNEJTIwcGQuRGF0YUZyYW1lKGRhdGFzZXQpJTBBcHJpbnQoJTIyR1NNOEslMjAlRTYlOTUlQjAlRTYlOEQlQUUlRTklOUIlODYlRTclOUElODQlRTUlODklOEQlRTUlODclQTAlRTglQTElOEMlRUYlQkMlOUElMjIpJTBBcHJpbnQoZGYuaGVhZCgpKSUwQQ==",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># 从 Hugging Face 获取 GSM8K</span>
dataset = load_dataset(<span class="hljs-string">&quot;openai/gsm8k&quot;</span>, <span class="hljs-string">&#x27;main&#x27;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>)
df = pd.DataFrame(dataset)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;GSM8K 数据集的前几行：&quot;</span>)
<span class="hljs-built_in">print</span>(df.head())
`,wrap:!1}}),Hl=new r({props:{code:"ZnJvbSUyMGxhbmdmdXNlJTIwaW1wb3J0JTIwTGFuZ2Z1c2UlMEFsYW5nZnVzZSUyMCUzRCUyMExhbmdmdXNlKCklMEElMEFsYW5nZnVzZV9kYXRhc2V0X25hbWUlMjAlM0QlMjAlMjJnc204a19kYXRhc2V0X2h1Z2dpbmdmYWNlJTIyJTBBJTBBJTIzJTIwJUU1JTlDJUE4JTIwTGFuZ2Z1c2UlMjAlRTQlQjglQUQlRTUlODglOUIlRTUlQkIlQkElRTYlOTUlQjAlRTYlOEQlQUUlRTklOUIlODYlMEFsYW5nZnVzZS5jcmVhdGVfZGF0YXNldCglMEElMjAlMjAlMjAlMjBuYW1lJTNEbGFuZ2Z1c2VfZGF0YXNldF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjIlRTQlQkIlOEUlMjBIdWdnaW5nZmFjZSUyMCVFNCVCOCU4QSVFNCVCQyVBMCVFNyU5QSU4NCUyMEdTTThLJTIwJUU1JTlGJUJBJUU1JTg3JTg2JUU2JTk1JUIwJUU2JThEJUFFJUU5JTlCJTg2JTIyJTJDJTBBJTIwJTIwJTIwJTIwbWV0YWRhdGElM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkYXRlJTIyJTNBJTIwJTIyMjAyNS0wMy0xMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJiZW5jaG1hcmslMjIlMEElMjAlMjAlMjAlMjAlN0QlMEEpJTBB",highlighted:`<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> Langfuse
langfuse = Langfuse()

langfuse_dataset_name = <span class="hljs-string">&quot;gsm8k_dataset_huggingface&quot;</span>

<span class="hljs-comment"># 在 Langfuse 中创建数据集</span>
langfuse.create_dataset(
    name=langfuse_dataset_name,
    description=<span class="hljs-string">&quot;从 Huggingface 上传的 GSM8K 基准数据集&quot;</span>,
    metadata={
        <span class="hljs-string">&quot;date&quot;</span>: <span class="hljs-string">&quot;2025-03-10&quot;</span>,
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;benchmark&quot;</span>
    }
)
`,wrap:!1}}),Xl=new r({props:{code:"Zm9yJTIwaWR4JTJDJTIwcm93JTIwaW4lMjBkZi5pdGVycm93cygpJTNBJTBBJTIwJTIwJTIwJTIwbGFuZ2Z1c2UuY3JlYXRlX2RhdGFzZXRfaXRlbSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhc2V0X25hbWUlM0RsYW5nZnVzZV9kYXRhc2V0X25hbWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dCUzRCU3QiUyMnRleHQlMjIlM0ElMjByb3clNUIlMjJxdWVzdGlvbiUyMiU1RCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4cGVjdGVkX291dHB1dCUzRCU3QiUyMnRleHQlMjIlM0ElMjByb3clNUIlMjJhbnN3ZXIlMjIlNUQlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZV9pbmRleCUyMiUzQSUyMGlkeCU3RCUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBpZiUyMGlkeCUyMCUzRSUzRCUyMDklM0ElMjAlMjMlMjAlRTQlQkIlODUlRTQlQjglOEElRTQlQkMlQTAlRTUlODklOEQlMjAxMCUyMCVFNCVCOCVBQSVFOSVBMSVCOSVFNyU5QiVBRSVFNyU5NCVBOCVFNCVCQSU4RSVFNiVCQyU5NCVFNyVBNCVCQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBB",highlighted:`<span class="hljs-keyword">for</span> idx, row <span class="hljs-keyword">in</span> df.iterrows():
    langfuse.create_dataset_item(
        dataset_name=langfuse_dataset_name,
        <span class="hljs-built_in">input</span>={<span class="hljs-string">&quot;text&quot;</span>: row[<span class="hljs-string">&quot;question&quot;</span>]},
        expected_output={<span class="hljs-string">&quot;text&quot;</span>: row[<span class="hljs-string">&quot;answer&quot;</span>]},
        metadata={<span class="hljs-string">&quot;source_index&quot;</span>: idx}
    )
    <span class="hljs-keyword">if</span> idx &gt;= <span class="hljs-number">9</span>: <span class="hljs-comment"># 仅上传前 10 个项目用于演示</span>
        <span class="hljs-keyword">break</span>
`,wrap:!1}}),ql=new m({props:{title:"在数据集上运行智能体",local:"在数据集上运行智能体",headingTag:"h4"}}),lt=new r({props:{code:"ZnJvbSUyMG9wZW50ZWxlbWV0cnkudHJhY2UlMjBpbXBvcnQlMjBmb3JtYXRfdHJhY2VfaWQlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMChDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMExpdGVMTE1Nb2RlbCklMEElMEElMjMlMjAlRTclQTQlQkElRTQlQkUlOEIlRUYlQkMlOUElRTQlQkQlQkYlRTclOTQlQTglMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyMCVFNiU4OCU5NiUyMExpdGVMTE1Nb2RlbCUyMCVFOCVBRSVCRiVFOSU5NyVBRSUyMG9wZW5haSVFMyU4MCU4MWFudGhyb3BpYyVFMyU4MCU4MWdlbWluaSUyMCVFNyVBRCU4OSVFNiVBOCVBMSVFNSU5RSU4QiVFRiVCQyU5QSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSUwQSklMEElMEFkZWYlMjBydW5fc21vbGFnZW50KHF1ZXN0aW9uKSUzQSUwQSUyMCUyMCUyMCUyMHdpdGglMjB0cmFjZXIuc3RhcnRfYXNfY3VycmVudF9zcGFuKCUyMlNtb2xhZ2VudC1UcmFjZSUyMiklMjBhcyUyMHNwYW4lM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGFuLnNldF9hdHRyaWJ1dGUoJTIybGFuZ2Z1c2UudGFnJTIyJTJDJTIwJTIyZGF0YXNldC1ydW4lMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwYWdlbnQucnVuKHF1ZXN0aW9uKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGN1cnJlbnRfc3BhbiUyMCUzRCUyMHRyYWNlLmdldF9jdXJyZW50X3NwYW4oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwYW5fY29udGV4dCUyMCUzRCUyMGN1cnJlbnRfc3Bhbi5nZXRfc3Bhbl9jb250ZXh0KCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFjZV9pZCUyMCUzRCUyMHNwYW5fY29udGV4dC50cmFjZV9pZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvcm1hdHRlZF90cmFjZV9pZCUyMCUzRCUyMGZvcm1hdF90cmFjZV9pZCh0cmFjZV9pZCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYW5nZnVzZV90cmFjZSUyMCUzRCUyMGxhbmdmdXNlLnRyYWNlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlkJTNEZm9ybWF0dGVkX3RyYWNlX2lkJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXQlM0RxdWVzdGlvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dCUzRG91dHB1dCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBsYW5nZnVzZV90cmFjZSUyQyUyMG91dHB1dCUwQQ==",highlighted:`<span class="hljs-keyword">from</span> opentelemetry.trace <span class="hljs-keyword">import</span> format_trace_id
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (CodeAgent, InferenceClientModel, LiteLLMModel)

<span class="hljs-comment"># 示例：使用 InferenceClientModel 或 LiteLLMModel 访问 openai、anthropic、gemini 等模型：</span>
model = InferenceClientModel()

agent = CodeAgent(
    tools=[],
    model=model,
    add_base_tools=<span class="hljs-literal">True</span>
)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_smolagent</span>(<span class="hljs-params">question</span>):
    <span class="hljs-keyword">with</span> tracer.start_as_current_span(<span class="hljs-string">&quot;Smolagent-Trace&quot;</span>) <span class="hljs-keyword">as</span> span:
        span.set_attribute(<span class="hljs-string">&quot;langfuse.tag&quot;</span>, <span class="hljs-string">&quot;dataset-run&quot;</span>)
        output = agent.run(question)

        current_span = trace.get_current_span()
        span_context = current_span.get_span_context()
        trace_id = span_context.trace_id
        formatted_trace_id = format_trace_id(trace_id)

        langfuse_trace = langfuse.trace(
            <span class="hljs-built_in">id</span>=formatted_trace_id,
            <span class="hljs-built_in">input</span>=question,
            output=output
        )
    <span class="hljs-keyword">return</span> langfuse_trace, output
`,wrap:!1}}),tt=new r({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxhbmdmdXNlLmdldF9kYXRhc2V0KGxhbmdmdXNlX2RhdGFzZXRfbmFtZSklMEElMEElMjMlMjAlRTklOTIlODglRTUlQUYlQjklRTYlQUYlOEYlRTQlQjglQUElRTYlOTUlQjAlRTYlOEQlQUUlRTklOUIlODYlRTklQTElQjklRTclOUIlQUUlRTglQkYlOTAlRTglQTElOEMlRTYlODglOTElRTQlQkIlQUMlRTclOUElODQlRTYlOTklQkElRTglODMlQkQlRTQlQkQlOTMlRUYlQkMlODglRTQlQjglOEElRTklOUQlQTIlRTklOTklOTAlRTUlODglQjYlRTQlQjglQkElRTUlODklOEQlMjAxMCUyMCVFNCVCOCVBQSVFRiVCQyU4OSUwQWZvciUyMGl0ZW0lMjBpbiUyMGRhdGFzZXQuaXRlbXMlM0ElMEElMjAlMjAlMjAlMjBsYW5nZnVzZV90cmFjZSUyQyUyMG91dHB1dCUyMCUzRCUyMHJ1bl9zbW9sYWdlbnQoaXRlbS5pbnB1dCU1QiUyMnRleHQlMjIlNUQpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwJUU1JUIwJTg2JUU4JUJGJUJEJUU4JUI4JUFBJUU5JTkzJUJFJUU2JThFJUE1JUU1JTg4JUIwJUU2JTk1JUIwJUU2JThEJUFFJUU5JTlCJTg2JUU5JUExJUI5JUU3JTlCJUFFJUU0JUJCJUE1JUU0JUJFJTlCJUU1JTg4JTg2JUU2JTlFJTkwJTBBJTIwJTIwJTIwJTIwaXRlbS5saW5rKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhbmdmdXNlX3RyYWNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcnVuX25hbWUlM0QlMjJzbW9sYWdlbnQtbm90ZWJvb2stcnVuLTAxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcnVuX21ldGFkYXRhJTNEJTdCJTIwJTIybW9kZWwlMjIlM0ElMjBtb2RlbC5tb2RlbF9pZCUyMCU3RCUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjAlRTUlOEYlQUYlRTklODAlODklRTUlOUMlQjAlRUYlQkMlOEMlRTUlQUQlOTglRTUlODIlQTglRTQlQjglODAlRTQlQjglQUElRTUlQkYlQUIlRTklODAlOUYlRTglQUYlODQlRTQlQkMlQjAlRTUlODglODYlRTYlOTUlQjAlRTclOTQlQTglRTQlQkElOEUlRTYlQkMlOTQlRTclQTQlQkElMEElMjAlMjAlMjAlMjBsYW5nZnVzZV90cmFjZS5zY29yZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNEJTIyJTNDZXhhbXBsZV9ldmFsJTNFJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmFsdWUlM0QxJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29tbWVudCUzRCUyMiVFOCVCRiU5OSVFNiU5OCVBRiVFNCVCOCU4MCVFNiU5RCVBMSVFOCVBRiU4NCVFOCVBRSVCQSUyMiUwQSUyMCUyMCUyMCUyMCklMEElMEElMjMlMjAlRTUlODglQjclRTYlOTYlQjAlRTYlOTUlQjAlRTYlOEQlQUUlRTQlQkIlQTUlRTclQTElQUUlRTQlQkYlOUQlRTYlODklODAlRTYlOUMlODklRTklODElQTUlRTYlQjUlOEIlRTYlOTUlQjAlRTYlOEQlQUUlRTklODMlQkQlRTUlQjclQjIlRTUlOEYlOTElRTklODAlODElMEFsYW5nZnVzZS5mbHVzaCgpJTBB",highlighted:`dataset = langfuse.get_dataset(langfuse_dataset_name)

<span class="hljs-comment"># 针对每个数据集项目运行我们的智能体（上面限制为前 10 个）</span>
<span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> dataset.items:
    langfuse_trace, output = run_smolagent(item.<span class="hljs-built_in">input</span>[<span class="hljs-string">&quot;text&quot;</span>])

    <span class="hljs-comment"># 将追踪链接到数据集项目以供分析</span>
    item.link(
        langfuse_trace,
        run_name=<span class="hljs-string">&quot;smolagent-notebook-run-01&quot;</span>,
        run_metadata={ <span class="hljs-string">&quot;model&quot;</span>: model.model_id }
    )

    <span class="hljs-comment"># 可选地，存储一个快速评估分数用于演示</span>
    langfuse_trace.score(
        name=<span class="hljs-string">&quot;&lt;example_eval&gt;&quot;</span>,
        value=<span class="hljs-number">1</span>,
        comment=<span class="hljs-string">&quot;这是一条评论&quot;</span>
    )

<span class="hljs-comment"># 刷新数据以确保所有遥测数据都已发送</span>
langfuse.flush()
`,wrap:!1}}),Ut=new m({props:{title:"结语",local:"结语",headingTag:"h2"}}),Tt=new En({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/zh-CN/bonus_unit2/monitoring-and-evaluating-agents-notebook.mdx"}}),{c(){u=U("meta"),Ct=n(),it=U("p"),yt=n(),p(c.$$.fragment),mt=n(),p(j.$$.fragment),rt=n(),p(g.$$.fragment),ut=n(),w=U("blockquote"),w.innerHTML=is,wt=n(),V=U("p"),V.innerHTML=os,ct=n(),I=U("p"),I.textContent=Cs,jt=n(),d=U("ul"),d.innerHTML=ys,gt=n(),p(b.$$.fragment),Vt=n(),f=U("p"),f.textContent=ms,It=n(),R=U("p"),R.innerHTML=rs,dt=n(),h=U("p"),h.innerHTML=us,bt=n(),p(Q.$$.fragment),ft=n(),B=U("p"),B.textContent=ws,Rt=n(),p(k.$$.fragment),ht=n(),p(N.$$.fragment),Qt=n(),E=U("p"),E.innerHTML=cs,Bt=n(),F=U("p"),F.innerHTML=js,kt=n(),Z=U("p"),Z.textContent=gs,Nt=n(),p(S.$$.fragment),Et=n(),v=U("p"),v.textContent=Vs,Ft=n(),p($.$$.fragment),Zt=n(),G=U("p"),G.textContent=Is,St=n(),p(Y.$$.fragment),vt=n(),p(x.$$.fragment),$t=n(),_=U("p"),_.innerHTML=ds,Gt=n(),p(W.$$.fragment),Yt=n(),A=U("p"),A.innerHTML=bs,xt=n(),L=U("p"),L.textContent=fs,_t=n(),O=U("p"),O.innerHTML=Rs,Wt=n(),H=U("p"),H.innerHTML=hs,At=n(),p(X.$$.fragment),Lt=n(),z=U("p"),z.textContent=Qs,Ot=n(),p(q.$$.fragment),Ht=n(),p(D.$$.fragment),Xt=n(),P=U("p"),P.innerHTML=Bs,zt=n(),K=U("ul"),K.innerHTML=ks,qt=n(),ll=U("p"),ll.textContent=Ns,Dt=n(),tl=U("p"),tl.textContent=Es,Pt=n(),el=U("p"),el.innerHTML=Fs,Kt=n(),sl=U("p"),sl.innerHTML=Zs,le=n(),p(nl.$$.fragment),te=n(),al=U("p"),al.textContent=Ss,ee=n(),p(Ul.$$.fragment),se=n(),Ml=U("ol"),Ml.innerHTML=vs,ne=n(),Jl=U("p"),Jl.textContent=$s,ae=n(),p(pl.$$.fragment),Ue=n(),Tl=U("p"),Tl.innerHTML=Gs,Me=n(),il=U("p"),il.innerHTML=Ys,Je=n(),ol=U("p"),ol.innerHTML=xs,pe=n(),p(Cl.$$.fragment),Te=n(),yl=U("p"),yl.textContent=_s,ie=n(),ml=U("p"),ml.innerHTML=Ws,oe=n(),rl=U("p"),rl.innerHTML=As,Ce=n(),p(ul.$$.fragment),ye=n(),wl=U("p"),wl.innerHTML=Ls,me=n(),p(cl.$$.fragment),re=n(),jl=U("p"),jl.innerHTML=Os,ue=n(),p(gl.$$.fragment),we=n(),Vl=U("p"),Vl.innerHTML=Hs,ce=n(),Il=U("p"),Il.textContent=Xs,je=n(),p(dl.$$.fragment),ge=n(),bl=U("p"),bl.textContent=zs,Ve=n(),fl=U("p"),fl.innerHTML=qs,Ie=n(),p(Rl.$$.fragment),de=n(),hl=U("p"),hl.textContent=Ds,be=n(),Ql=U("p"),Ql.innerHTML=Ps,fe=n(),Bl=U("ol"),Bl.innerHTML=Ks,Re=n(),kl=U("p"),kl.textContent=ln,he=n(),Nl=U("p"),Nl.innerHTML=tn,Qe=n(),p(El.$$.fragment),Be=n(),Fl=U("p"),Fl.textContent=en,ke=n(),Zl=U("p"),Zl.innerHTML=sn,Ne=n(),p(Sl.$$.fragment),Ee=n(),vl=U("p"),vl.textContent=nn,Fe=n(),$l=U("p"),$l.innerHTML=an,Ze=n(),p(Gl.$$.fragment),Se=n(),Yl=U("p"),Yl.innerHTML=Un,ve=n(),p(xl.$$.fragment),$e=n(),_l=U("p"),_l.textContent=Mn,Ge=n(),Wl=U("ol"),Wl.innerHTML=Jn,Ye=n(),Al=U("p"),Al.innerHTML=pn,xe=n(),p(Ll.$$.fragment),_e=n(),Ol=U("p"),Ol.textContent=Tn,We=n(),p(Hl.$$.fragment),Ae=n(),p(Xl.$$.fragment),Le=n(),zl=U("p"),zl.innerHTML=on,Oe=n(),p(ql.$$.fragment),He=n(),Dl=U("p"),Dl.innerHTML=Cn,Xe=n(),Pl=U("ol"),Pl.innerHTML=yn,ze=n(),Kl=U("p"),Kl.textContent=mn,qe=n(),p(lt.$$.fragment),De=n(),p(tt.$$.fragment),Pe=n(),et=U("p"),et.textContent=rn,Ke=n(),st=U("ul"),st.innerHTML=un,ls=n(),nt=U("p"),nt.textContent=wn,ts=n(),at=U("p"),at.innerHTML=cn,es=n(),p(Ut.$$.fragment),ss=n(),Mt=U("p"),Mt.textContent=jn,ns=n(),Jt=U("ol"),Jt.innerHTML=gn,as=n(),pt=U("p"),pt.textContent=Vn,Us=n(),p(Tt.$$.fragment),Ms=n(),ot=U("p"),this.h()},l(l){const t=Qn("svelte-u9bgzb",document.head);u=M(t,"META",{name:!0,content:!0}),t.forEach(e),Ct=a(l),it=M(l,"P",{}),In(it).forEach(e),yt=a(l),T(c.$$.fragment,l),mt=a(l),T(j.$$.fragment,l),rt=a(l),T(g.$$.fragment,l),ut=a(l),w=M(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),J(w)!=="svelte-m8i388"&&(w.innerHTML=is),wt=a(l),V=M(l,"P",{"data-svelte-h":!0}),J(V)!=="svelte-1c30g7l"&&(V.innerHTML=os),ct=a(l),I=M(l,"P",{"data-svelte-h":!0}),J(I)!=="svelte-1uesxvj"&&(I.textContent=Cs),jt=a(l),d=M(l,"UL",{"data-svelte-h":!0}),J(d)!=="svelte-mz9jkh"&&(d.innerHTML=ys),gt=a(l),T(b.$$.fragment,l),Vt=a(l),f=M(l,"P",{"data-svelte-h":!0}),J(f)!=="svelte-1fwgexo"&&(f.textContent=ms),It=a(l),R=M(l,"P",{"data-svelte-h":!0}),J(R)!=="svelte-1vr9vc3"&&(R.innerHTML=rs),dt=a(l),h=M(l,"P",{"data-svelte-h":!0}),J(h)!=="svelte-r9pvtq"&&(h.innerHTML=us),bt=a(l),T(Q.$$.fragment,l),ft=a(l),B=M(l,"P",{"data-svelte-h":!0}),J(B)!=="svelte-zkb5dt"&&(B.textContent=ws),Rt=a(l),T(k.$$.fragment,l),ht=a(l),T(N.$$.fragment,l),Qt=a(l),E=M(l,"P",{"data-svelte-h":!0}),J(E)!=="svelte-p625jc"&&(E.innerHTML=cs),Bt=a(l),F=M(l,"P",{"data-svelte-h":!0}),J(F)!=="svelte-ucz4lr"&&(F.innerHTML=js),kt=a(l),Z=M(l,"P",{"data-svelte-h":!0}),J(Z)!=="svelte-1oy2tpn"&&(Z.textContent=gs),Nt=a(l),T(S.$$.fragment,l),Et=a(l),v=M(l,"P",{"data-svelte-h":!0}),J(v)!=="svelte-11x9hcs"&&(v.textContent=Vs),Ft=a(l),T($.$$.fragment,l),Zt=a(l),G=M(l,"P",{"data-svelte-h":!0}),J(G)!=="svelte-1yxxfzg"&&(G.textContent=Is),St=a(l),T(Y.$$.fragment,l),vt=a(l),T(x.$$.fragment,l),$t=a(l),_=M(l,"P",{"data-svelte-h":!0}),J(_)!=="svelte-n8l4w3"&&(_.innerHTML=ds),Gt=a(l),T(W.$$.fragment,l),Yt=a(l),A=M(l,"P",{"data-svelte-h":!0}),J(A)!=="svelte-1gvxwiu"&&(A.innerHTML=bs),xt=a(l),L=M(l,"P",{"data-svelte-h":!0}),J(L)!=="svelte-19bn6vz"&&(L.textContent=fs),_t=a(l),O=M(l,"P",{"data-svelte-h":!0}),J(O)!=="svelte-1cb993n"&&(O.innerHTML=Rs),Wt=a(l),H=M(l,"P",{"data-svelte-h":!0}),J(H)!=="svelte-ctgz93"&&(H.innerHTML=hs),At=a(l),T(X.$$.fragment,l),Lt=a(l),z=M(l,"P",{"data-svelte-h":!0}),J(z)!=="svelte-1nzh9h2"&&(z.textContent=Qs),Ot=a(l),T(q.$$.fragment,l),Ht=a(l),T(D.$$.fragment,l),Xt=a(l),P=M(l,"P",{"data-svelte-h":!0}),J(P)!=="svelte-qb0ba2"&&(P.innerHTML=Bs),zt=a(l),K=M(l,"UL",{"data-svelte-h":!0}),J(K)!=="svelte-72wkz6"&&(K.innerHTML=ks),qt=a(l),ll=M(l,"P",{"data-svelte-h":!0}),J(ll)!=="svelte-j6apou"&&(ll.textContent=Ns),Dt=a(l),tl=M(l,"P",{"data-svelte-h":!0}),J(tl)!=="svelte-hh28r2"&&(tl.textContent=Es),Pt=a(l),el=M(l,"P",{"data-svelte-h":!0}),J(el)!=="svelte-yhkq5w"&&(el.innerHTML=Fs),Kt=a(l),sl=M(l,"P",{"data-svelte-h":!0}),J(sl)!=="svelte-1ana1zw"&&(sl.innerHTML=Zs),le=a(l),T(nl.$$.fragment,l),te=a(l),al=M(l,"P",{"data-svelte-h":!0}),J(al)!=="svelte-193508y"&&(al.textContent=Ss),ee=a(l),T(Ul.$$.fragment,l),se=a(l),Ml=M(l,"OL",{"data-svelte-h":!0}),J(Ml)!=="svelte-icrnhf"&&(Ml.innerHTML=vs),ne=a(l),Jl=M(l,"P",{"data-svelte-h":!0}),J(Jl)!=="svelte-14tuos8"&&(Jl.textContent=$s),ae=a(l),T(pl.$$.fragment,l),Ue=a(l),Tl=M(l,"P",{"data-svelte-h":!0}),J(Tl)!=="svelte-1fpyo1s"&&(Tl.innerHTML=Gs),Me=a(l),il=M(l,"P",{"data-svelte-h":!0}),J(il)!=="svelte-dard47"&&(il.innerHTML=Ys),Je=a(l),ol=M(l,"P",{"data-svelte-h":!0}),J(ol)!=="svelte-1ana1zw"&&(ol.innerHTML=xs),pe=a(l),T(Cl.$$.fragment,l),Te=a(l),yl=M(l,"P",{"data-svelte-h":!0}),J(yl)!=="svelte-rc014l"&&(yl.textContent=_s),ie=a(l),ml=M(l,"P",{"data-svelte-h":!0}),J(ml)!=="svelte-1org4pj"&&(ml.innerHTML=Ws),oe=a(l),rl=M(l,"P",{"data-svelte-h":!0}),J(rl)!=="svelte-1ana1zw"&&(rl.innerHTML=As),Ce=a(l),T(ul.$$.fragment,l),ye=a(l),wl=M(l,"P",{"data-svelte-h":!0}),J(wl)!=="svelte-1joyolg"&&(wl.innerHTML=Ls),me=a(l),T(cl.$$.fragment,l),re=a(l),jl=M(l,"P",{"data-svelte-h":!0}),J(jl)!=="svelte-1gx91hu"&&(jl.innerHTML=Os),ue=a(l),T(gl.$$.fragment,l),we=a(l),Vl=M(l,"P",{"data-svelte-h":!0}),J(Vl)!=="svelte-12jailm"&&(Vl.innerHTML=Hs),ce=a(l),Il=M(l,"P",{"data-svelte-h":!0}),J(Il)!=="svelte-w7ysmk"&&(Il.textContent=Xs),je=a(l),T(dl.$$.fragment,l),ge=a(l),bl=M(l,"P",{"data-svelte-h":!0}),J(bl)!=="svelte-1fcgnxf"&&(bl.textContent=zs),Ve=a(l),fl=M(l,"P",{"data-svelte-h":!0}),J(fl)!=="svelte-e6ive4"&&(fl.innerHTML=qs),Ie=a(l),T(Rl.$$.fragment,l),de=a(l),hl=M(l,"P",{"data-svelte-h":!0}),J(hl)!=="svelte-voo053"&&(hl.textContent=Ds),be=a(l),Ql=M(l,"P",{"data-svelte-h":!0}),J(Ql)!=="svelte-1k98euk"&&(Ql.innerHTML=Ps),fe=a(l),Bl=M(l,"OL",{"data-svelte-h":!0}),J(Bl)!=="svelte-1kzotuw"&&(Bl.innerHTML=Ks),Re=a(l),kl=M(l,"P",{"data-svelte-h":!0}),J(kl)!=="svelte-xckzqt"&&(kl.textContent=ln),he=a(l),Nl=M(l,"P",{"data-svelte-h":!0}),J(Nl)!=="svelte-1uar592"&&(Nl.innerHTML=tn),Qe=a(l),T(El.$$.fragment,l),Be=a(l),Fl=M(l,"P",{"data-svelte-h":!0}),J(Fl)!=="svelte-kvyv77"&&(Fl.textContent=en),ke=a(l),Zl=M(l,"P",{"data-svelte-h":!0}),J(Zl)!=="svelte-zj9pt2"&&(Zl.innerHTML=sn),Ne=a(l),T(Sl.$$.fragment,l),Ee=a(l),vl=M(l,"P",{"data-svelte-h":!0}),J(vl)!=="svelte-bra8no"&&(vl.textContent=nn),Fe=a(l),$l=M(l,"P",{"data-svelte-h":!0}),J($l)!=="svelte-1jemoxg"&&($l.innerHTML=an),Ze=a(l),T(Gl.$$.fragment,l),Se=a(l),Yl=M(l,"P",{"data-svelte-h":!0}),J(Yl)!=="svelte-fgmb5i"&&(Yl.innerHTML=Un),ve=a(l),T(xl.$$.fragment,l),$e=a(l),_l=M(l,"P",{"data-svelte-h":!0}),J(_l)!=="svelte-2oo2a3"&&(_l.textContent=Mn),Ge=a(l),Wl=M(l,"OL",{"data-svelte-h":!0}),J(Wl)!=="svelte-1laz0b9"&&(Wl.innerHTML=Jn),Ye=a(l),Al=M(l,"P",{"data-svelte-h":!0}),J(Al)!=="svelte-utwpi5"&&(Al.innerHTML=pn),xe=a(l),T(Ll.$$.fragment,l),_e=a(l),Ol=M(l,"P",{"data-svelte-h":!0}),J(Ol)!=="svelte-1jminco"&&(Ol.textContent=Tn),We=a(l),T(Hl.$$.fragment,l),Ae=a(l),T(Xl.$$.fragment,l),Le=a(l),zl=M(l,"P",{"data-svelte-h":!0}),J(zl)!=="svelte-giwu4e"&&(zl.innerHTML=on),Oe=a(l),T(ql.$$.fragment,l),He=a(l),Dl=M(l,"P",{"data-svelte-h":!0}),J(Dl)!=="svelte-1fsq05o"&&(Dl.innerHTML=Cn),Xe=a(l),Pl=M(l,"OL",{"data-svelte-h":!0}),J(Pl)!=="svelte-qvbyzq"&&(Pl.innerHTML=yn),ze=a(l),Kl=M(l,"P",{"data-svelte-h":!0}),J(Kl)!=="svelte-6xg5qt"&&(Kl.textContent=mn),qe=a(l),T(lt.$$.fragment,l),De=a(l),T(tt.$$.fragment,l),Pe=a(l),et=M(l,"P",{"data-svelte-h":!0}),J(et)!=="svelte-qwuhs5"&&(et.textContent=rn),Ke=a(l),st=M(l,"UL",{"data-svelte-h":!0}),J(st)!=="svelte-1ih063h"&&(st.innerHTML=un),ls=a(l),nt=M(l,"P",{"data-svelte-h":!0}),J(nt)!=="svelte-1qr0dda"&&(nt.textContent=wn),ts=a(l),at=M(l,"P",{"data-svelte-h":!0}),J(at)!=="svelte-ukc2vx"&&(at.innerHTML=cn),es=a(l),T(Ut.$$.fragment,l),ss=a(l),Mt=M(l,"P",{"data-svelte-h":!0}),J(Mt)!=="svelte-1q6s2or"&&(Mt.textContent=jn),ns=a(l),Jt=M(l,"OL",{"data-svelte-h":!0}),J(Jt)!=="svelte-1gov4si"&&(Jt.innerHTML=gn),as=a(l),pt=M(l,"P",{"data-svelte-h":!0}),J(pt)!=="svelte-byy2n0"&&(pt.textContent=Vn),Us=a(l),T(Tt.$$.fragment,l),Ms=a(l),ot=M(l,"P",{}),In(ot).forEach(e),this.h()},h(){ps(u,"name","hf:doc:metadata"),ps(u,"content",Zn),ps(w,"class","tip")},m(l,t){Bn(document.head,u),s(l,Ct,t),s(l,it,t),s(l,yt,t),i(c,l,t),s(l,mt,t),i(j,l,t),s(l,rt,t),i(g,l,t),s(l,ut,t),s(l,w,t),s(l,wt,t),s(l,V,t),s(l,ct,t),s(l,I,t),s(l,jt,t),s(l,d,t),s(l,gt,t),i(b,l,t),s(l,Vt,t),s(l,f,t),s(l,It,t),s(l,R,t),s(l,dt,t),s(l,h,t),s(l,bt,t),i(Q,l,t),s(l,ft,t),s(l,B,t),s(l,Rt,t),i(k,l,t),s(l,ht,t),i(N,l,t),s(l,Qt,t),s(l,E,t),s(l,Bt,t),s(l,F,t),s(l,kt,t),s(l,Z,t),s(l,Nt,t),i(S,l,t),s(l,Et,t),s(l,v,t),s(l,Ft,t),i($,l,t),s(l,Zt,t),s(l,G,t),s(l,St,t),i(Y,l,t),s(l,vt,t),i(x,l,t),s(l,$t,t),s(l,_,t),s(l,Gt,t),i(W,l,t),s(l,Yt,t),s(l,A,t),s(l,xt,t),s(l,L,t),s(l,_t,t),s(l,O,t),s(l,Wt,t),s(l,H,t),s(l,At,t),i(X,l,t),s(l,Lt,t),s(l,z,t),s(l,Ot,t),i(q,l,t),s(l,Ht,t),i(D,l,t),s(l,Xt,t),s(l,P,t),s(l,zt,t),s(l,K,t),s(l,qt,t),s(l,ll,t),s(l,Dt,t),s(l,tl,t),s(l,Pt,t),s(l,el,t),s(l,Kt,t),s(l,sl,t),s(l,le,t),i(nl,l,t),s(l,te,t),s(l,al,t),s(l,ee,t),i(Ul,l,t),s(l,se,t),s(l,Ml,t),s(l,ne,t),s(l,Jl,t),s(l,ae,t),i(pl,l,t),s(l,Ue,t),s(l,Tl,t),s(l,Me,t),s(l,il,t),s(l,Je,t),s(l,ol,t),s(l,pe,t),i(Cl,l,t),s(l,Te,t),s(l,yl,t),s(l,ie,t),s(l,ml,t),s(l,oe,t),s(l,rl,t),s(l,Ce,t),i(ul,l,t),s(l,ye,t),s(l,wl,t),s(l,me,t),i(cl,l,t),s(l,re,t),s(l,jl,t),s(l,ue,t),i(gl,l,t),s(l,we,t),s(l,Vl,t),s(l,ce,t),s(l,Il,t),s(l,je,t),i(dl,l,t),s(l,ge,t),s(l,bl,t),s(l,Ve,t),s(l,fl,t),s(l,Ie,t),i(Rl,l,t),s(l,de,t),s(l,hl,t),s(l,be,t),s(l,Ql,t),s(l,fe,t),s(l,Bl,t),s(l,Re,t),s(l,kl,t),s(l,he,t),s(l,Nl,t),s(l,Qe,t),i(El,l,t),s(l,Be,t),s(l,Fl,t),s(l,ke,t),s(l,Zl,t),s(l,Ne,t),i(Sl,l,t),s(l,Ee,t),s(l,vl,t),s(l,Fe,t),s(l,$l,t),s(l,Ze,t),i(Gl,l,t),s(l,Se,t),s(l,Yl,t),s(l,ve,t),i(xl,l,t),s(l,$e,t),s(l,_l,t),s(l,Ge,t),s(l,Wl,t),s(l,Ye,t),s(l,Al,t),s(l,xe,t),i(Ll,l,t),s(l,_e,t),s(l,Ol,t),s(l,We,t),i(Hl,l,t),s(l,Ae,t),i(Xl,l,t),s(l,Le,t),s(l,zl,t),s(l,Oe,t),i(ql,l,t),s(l,He,t),s(l,Dl,t),s(l,Xe,t),s(l,Pl,t),s(l,ze,t),s(l,Kl,t),s(l,qe,t),i(lt,l,t),s(l,De,t),i(tt,l,t),s(l,Pe,t),s(l,et,t),s(l,Ke,t),s(l,st,t),s(l,ls,t),s(l,nt,t),s(l,ts,t),s(l,at,t),s(l,es,t),i(Ut,l,t),s(l,ss,t),s(l,Mt,t),s(l,ns,t),s(l,Jt,t),s(l,as,t),s(l,pt,t),s(l,Us,t),i(Tt,l,t),s(l,Ms,t),s(l,ot,t),Js=!0},p:bn,i(l){Js||(o(c.$$.fragment,l),o(j.$$.fragment,l),o(g.$$.fragment,l),o(b.$$.fragment,l),o(Q.$$.fragment,l),o(k.$$.fragment,l),o(N.$$.fragment,l),o(S.$$.fragment,l),o($.$$.fragment,l),o(Y.$$.fragment,l),o(x.$$.fragment,l),o(W.$$.fragment,l),o(X.$$.fragment,l),o(q.$$.fragment,l),o(D.$$.fragment,l),o(nl.$$.fragment,l),o(Ul.$$.fragment,l),o(pl.$$.fragment,l),o(Cl.$$.fragment,l),o(ul.$$.fragment,l),o(cl.$$.fragment,l),o(gl.$$.fragment,l),o(dl.$$.fragment,l),o(Rl.$$.fragment,l),o(El.$$.fragment,l),o(Sl.$$.fragment,l),o(Gl.$$.fragment,l),o(xl.$$.fragment,l),o(Ll.$$.fragment,l),o(Hl.$$.fragment,l),o(Xl.$$.fragment,l),o(ql.$$.fragment,l),o(lt.$$.fragment,l),o(tt.$$.fragment,l),o(Ut.$$.fragment,l),o(Tt.$$.fragment,l),Js=!0)},o(l){C(c.$$.fragment,l),C(j.$$.fragment,l),C(g.$$.fragment,l),C(b.$$.fragment,l),C(Q.$$.fragment,l),C(k.$$.fragment,l),C(N.$$.fragment,l),C(S.$$.fragment,l),C($.$$.fragment,l),C(Y.$$.fragment,l),C(x.$$.fragment,l),C(W.$$.fragment,l),C(X.$$.fragment,l),C(q.$$.fragment,l),C(D.$$.fragment,l),C(nl.$$.fragment,l),C(Ul.$$.fragment,l),C(pl.$$.fragment,l),C(Cl.$$.fragment,l),C(ul.$$.fragment,l),C(cl.$$.fragment,l),C(gl.$$.fragment,l),C(dl.$$.fragment,l),C(Rl.$$.fragment,l),C(El.$$.fragment,l),C(Sl.$$.fragment,l),C(Gl.$$.fragment,l),C(xl.$$.fragment,l),C(Ll.$$.fragment,l),C(Hl.$$.fragment,l),C(Xl.$$.fragment,l),C(ql.$$.fragment,l),C(lt.$$.fragment,l),C(tt.$$.fragment,l),C(Ut.$$.fragment,l),C(Tt.$$.fragment,l),Js=!1},d(l){l&&(e(Ct),e(it),e(yt),e(mt),e(rt),e(ut),e(w),e(wt),e(V),e(ct),e(I),e(jt),e(d),e(gt),e(Vt),e(f),e(It),e(R),e(dt),e(h),e(bt),e(ft),e(B),e(Rt),e(ht),e(Qt),e(E),e(Bt),e(F),e(kt),e(Z),e(Nt),e(Et),e(v),e(Ft),e(Zt),e(G),e(St),e(vt),e($t),e(_),e(Gt),e(Yt),e(A),e(xt),e(L),e(_t),e(O),e(Wt),e(H),e(At),e(Lt),e(z),e(Ot),e(Ht),e(Xt),e(P),e(zt),e(K),e(qt),e(ll),e(Dt),e(tl),e(Pt),e(el),e(Kt),e(sl),e(le),e(te),e(al),e(ee),e(se),e(Ml),e(ne),e(Jl),e(ae),e(Ue),e(Tl),e(Me),e(il),e(Je),e(ol),e(pe),e(Te),e(yl),e(ie),e(ml),e(oe),e(rl),e(Ce),e(ye),e(wl),e(me),e(re),e(jl),e(ue),e(we),e(Vl),e(ce),e(Il),e(je),e(ge),e(bl),e(Ve),e(fl),e(Ie),e(de),e(hl),e(be),e(Ql),e(fe),e(Bl),e(Re),e(kl),e(he),e(Nl),e(Qe),e(Be),e(Fl),e(ke),e(Zl),e(Ne),e(Ee),e(vl),e(Fe),e($l),e(Ze),e(Se),e(Yl),e(ve),e($e),e(_l),e(Ge),e(Wl),e(Ye),e(Al),e(xe),e(_e),e(Ol),e(We),e(Ae),e(Le),e(zl),e(Oe),e(He),e(Dl),e(Xe),e(Pl),e(ze),e(Kl),e(qe),e(De),e(Pe),e(et),e(Ke),e(st),e(ls),e(nt),e(ts),e(at),e(es),e(ss),e(Mt),e(ns),e(Jt),e(as),e(pt),e(Us),e(Ms),e(ot)),e(u),y(c,l),y(j,l),y(g,l),y(b,l),y(Q,l),y(k,l),y(N,l),y(S,l),y($,l),y(Y,l),y(x,l),y(W,l),y(X,l),y(q,l),y(D,l),y(nl,l),y(Ul,l),y(pl,l),y(Cl,l),y(ul,l),y(cl,l),y(gl,l),y(dl,l),y(Rl,l),y(El,l),y(Sl,l),y(Gl,l),y(xl,l),y(Ll,l),y(Hl,l),y(Xl,l),y(ql,l),y(lt,l),y(tt,l),y(Ut,l),y(Tt,l)}}}const Zn='{"title":"附加单元 2：AI 智能体(AI Agent)的可观测性与评估","local":"附加单元-2ai-智能体ai-agent的可观测性与评估","sections":[{"title":"练习先决条件 🏗️","local":"练习先决条件-","sections":[],"depth":2},{"title":"步骤 0：安装所需的库","local":"步骤-0安装所需的库","sections":[],"depth":2},{"title":"步骤 1：检测你的智能体","local":"步骤-1检测你的智能体","sections":[],"depth":2},{"title":"步骤 2：测试你的检测","local":"步骤-2测试你的检测","sections":[],"depth":2},{"title":"步骤 3：观测和评估更复杂的AI智能体","local":"步骤-3观测和评估更复杂的ai智能体","sections":[{"title":"追踪结构","local":"追踪结构","sections":[],"depth":3}],"depth":2},{"title":"在线评估","local":"在线评估","sections":[{"title":"生产环境中要追踪的常见指标","local":"生产环境中要追踪的常见指标","sections":[{"title":"1. 成本","local":"1-成本","sections":[],"depth":4},{"title":"2. 延迟","local":"2-延迟","sections":[],"depth":4},{"title":"3. 附加属性","local":"3-附加属性","sections":[],"depth":4},{"title":"4. 用户反馈","local":"4-用户反馈","sections":[],"depth":4},{"title":"5. LLM 作为评判者","local":"5-llm-作为评判者","sections":[],"depth":4},{"title":"6. 可观测性指标概览","local":"6-可观测性指标概览","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"离线评估","local":"离线评估","sections":[{"title":"数据集评估","local":"数据集评估","sections":[{"title":"在数据集上运行智能体","local":"在数据集上运行智能体","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"结语","local":"结语","sections":[],"depth":2}],"depth":1}';function Sn(Ts){return fn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wn extends Rn{constructor(u){super(),hn(this,u,Sn,Fn,dn,{})}}export{Wn as component};
