import{s as Js,a as Lt,n as Ts,o as ms}from"../chunks/scheduler.505acc25.js";import{S as gs,i as os,e as p,s as n,c as M,h as us,a as i,d as l,b as a,f as rs,g as y,j as U,k as o,l as hs,m as e,n as r,t as J,o as T,p as m}from"../chunks/index.b1175496.js";import{C as Cs,H as tt}from"../chunks/Heading.eda51538.js";import{C as P}from"../chunks/CodeBlock.9d480d26.js";import{E as ds}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.ea377ea6.js";function fs(qt){let g,et,st,nt,h,at,C,pt,d,Ht="要使用 LangGraph 构建应用程序，需要理解其核心组件。让我们探索构成 LangGraph 应用程序的基础构建模块。",it,u,Ot,Ut,f,Wt="LangGraph 应用程序从 <strong>entrypoint</strong> 开始，根据执行情况，流程可能流向不同的函数直到抵达 END。",Mt,c,Dt,yt,w,rt,j,Yt="<strong>State</strong> 是 LangGraph 中的核心概念，表示流经应用程序的所有信息。",Jt,$,Tt,S,At="状态是 <strong>用户自定义</strong> 的，因此需要仔细设计字段以包含决策过程所需的所有数据！",mt,k,Xt="<p>💡 <strong>提示:</strong> 仔细考虑应用程序需要在步骤之间跟踪哪些信息。</p>",gt,G,ot,_,zt="<strong>Nodes</strong> 是 Python 函数。每个节点：",ut,V,Kt="<li>接收状态作为输入</li> <li>执行某些操作</li> <li>返回状态更新</li>",ht,I,Ct,Q,Pt="举例, 节点可以包含：",dt,b,ts="<li><strong>LLM 调用</strong>: 生成文本或做出决策</li> <li><strong>工具调用</strong>: 与外部系统交互</li> <li><strong>条件逻辑</strong>: 决定后续步骤</li> <li><strong>人工干预</strong>: 获取用户输入</li>",ft,Z,ss="<p>💡 <strong>信息:</strong> 像 START 和 END 这样的必要节点已直接包含在 LangGraph 中。</p>",ct,R,wt,v,ls="<strong>Edges</strong> 连接节点并定义图中的可能路径：",jt,E,$t,x,es="边可以是：",St,B,ns="<li><strong>直接边</strong>: 始终从节点 A 到节点 B</li> <li><strong>条件边</strong>: 根据当前状态选择下一个节点</li>",kt,N,Gt,F,as="<strong>StateGraph</strong> 是包含整个 agent 工作流的容器：",_t,L,Vt,q,ps="可以可视化图表：",It,H,Qt,O,is,bt,W,Us="最重要的是可以调用：",Zt,D,Rt,Y,Ms="output :",vt,A,Et,X,xt,z,ys="下一节我们将通过构建第一个图表来实践这些概念。该图表将让 Alfred 能够处理电子邮件，进行分类，并在邮件真实时起草初步回复。",Bt,K,Nt,lt,Ft;return h=new Cs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),C=new tt({props:{title:"LangGraph 的核心构建模块",local:"langgraph-的核心构建模块",headingTag:"h1"}}),w=new tt({props:{title:"1. 状态（State）",local:"1-状态state",headingTag:"h2"}}),$=new P({props:{code:"ZnJvbSUyMHR5cGluZ19leHRlbnNpb25zJTIwaW1wb3J0JTIwVHlwZWREaWN0JTBBJTBBY2xhc3MlMjBTdGF0ZShUeXBlZERpY3QpJTNBJTBBJTIwJTIwJTIwJTIwZ3JhcGhfc3RhdGUlM0ElMjBzdHI=",highlighted:`<span class="hljs-keyword">from</span> typing_extensions <span class="hljs-keyword">import</span> TypedDict

<span class="hljs-keyword">class</span> <span class="hljs-title class_">State</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    graph_state: <span class="hljs-built_in">str</span>`,wrap:!1}}),G=new tt({props:{title:"2. 节点（Nodes）",local:"2-节点nodes",headingTag:"h2"}}),I=new P({props:{code:"ZGVmJTIwbm9kZV8xKHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMi0tLU5vZGUlMjAxLS0tJTIyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmdyYXBoX3N0YXRlJTIyJTNBJTIwc3RhdGUlNUInZ3JhcGhfc3RhdGUnJTVEJTIwJTJCJTIyJTIwSSUyMGFtJTIyJTdEJTBBJTBBZGVmJTIwbm9kZV8yKHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMi0tLU5vZGUlMjAyLS0tJTIyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmdyYXBoX3N0YXRlJTIyJTNBJTIwc3RhdGUlNUInZ3JhcGhfc3RhdGUnJTVEJTIwJTJCJTIyJTIwaGFwcHkhJTIyJTdEJTBBJTBBZGVmJTIwbm9kZV8zKHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMi0tLU5vZGUlMjAzLS0tJTIyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmdyYXBoX3N0YXRlJTIyJTNBJTIwc3RhdGUlNUInZ3JhcGhfc3RhdGUnJTVEJTIwJTJCJTIyJTIwc2FkISUyMiU3RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">node_1</span>(<span class="hljs-params">state</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;---Node 1---&quot;</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;graph_state&quot;</span>: state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] +<span class="hljs-string">&quot; I am&quot;</span>}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">node_2</span>(<span class="hljs-params">state</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;---Node 2---&quot;</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;graph_state&quot;</span>: state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] +<span class="hljs-string">&quot; happy!&quot;</span>}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">node_3</span>(<span class="hljs-params">state</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;---Node 3---&quot;</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;graph_state&quot;</span>: state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] +<span class="hljs-string">&quot; sad!&quot;</span>}`,wrap:!1}}),R=new tt({props:{title:"3. 边（Edges）",local:"3-边edges",headingTag:"h2"}}),E=new P({props:{code:"aW1wb3J0JTIwcmFuZG9tJTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMExpdGVyYWwlMEElMEFkZWYlMjBkZWNpZGVfbW9vZChzdGF0ZSklMjAtJTNFJTIwTGl0ZXJhbCU1QiUyMm5vZGVfMiUyMiUyQyUyMCUyMm5vZGVfMyUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMCVFOSU4MCU5QSVFNSVCOCVCOCVFNiU4OCU5MSVFNCVCQiVBQyVFNCVCQyU5QSVFNiVBMCVCOSVFNiU4RCVBRSVFNyU4QSVCNiVFNiU4MCU4MSVFNSU4NiVCMyVFNSVBRSU5QSVFNCVCOCU4QiVFNCVCOCU4MCVFNCVCOCVBQSVFOCU4QSU4MiVFNyU4MiVCOSUwQSUyMCUyMCUyMCUyMHVzZXJfaW5wdXQlMjAlM0QlMjBzdGF0ZSU1QidncmFwaF9zdGF0ZSclNUQlMjAlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjAlRTglQkYlOTklRTklODclOEMlRTYlODglOTElRTQlQkIlQUMlRTUlOUMlQTglRTglOEElODIlRTclODIlQjkyJUU1JTkyJThDJUU4JThBJTgyJUU3JTgyJUI5MyVFNCVCOSU4QiVFOSU5NyVCNCVFNyVBRSU4MCVFNSU4RCU5NSVFNSVBRSU5RSVFNyU4RSVCMCUyMDUwJTJGNTAlMjAlRTclOUElODQlRTYlQTYlODIlRTclOEUlODclRTUlODglODYlRTklODUlOEQlMEElMjAlMjAlMjAlMjBpZiUyMHJhbmRvbS5yYW5kb20oKSUyMCUzQyUyMDAuNSUzQSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMDUwJTI1JTIwJUU2JTk3JUI2JUU5JTk3JUI0JUVGJUJDJThDJTIwJUU2JTg4JTkxJUU0JUJCJUFDJUU4JUJGJTk0JUU1JTlCJTlFJUU4JThBJTgyJUU3JTgyJUI5MiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMm5vZGVfMiUyMiUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMDUwJTI1JTIwJUU2JTk3JUI2JUU5JTk3JUI0JUVGJUJDJThDJTIwJUU2JTg4JTkxJUU0JUJCJUFDJUU4JUJGJTk0JUU1JTlCJTlFJUU4JThBJTgyJUU3JTgyJUI5MyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCUyMm5vZGVfMyUyMg==",highlighted:`<span class="hljs-keyword">import</span> random
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Literal</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">decide_mood</span>(<span class="hljs-params">state</span>) -&gt; <span class="hljs-type">Literal</span>[<span class="hljs-string">&quot;node_2&quot;</span>, <span class="hljs-string">&quot;node_3&quot;</span>]:
    
    <span class="hljs-comment"># 通常我们会根据状态决定下一个节点</span>
    user_input = state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] 
    
    <span class="hljs-comment"># 这里我们在节点2和节点3之间简单实现 50/50 的概率分配</span>
    <span class="hljs-keyword">if</span> random.random() &lt; <span class="hljs-number">0.5</span>:

        <span class="hljs-comment"># 50% 时间， 我们返回节点2</span>
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;node_2&quot;</span>
    
    <span class="hljs-comment"># 50% 时间， 我们返回节点3</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;node_3&quot;</span>`,wrap:!1}}),N=new tt({props:{title:"4. 状态图（StateGraph）",local:"4-状态图stategraph",headingTag:"h2"}}),L=new P({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEltYWdlJTJDJTIwZGlzcGxheSUwQWZyb20lMjBsYW5nZ3JhcGguZ3JhcGglMjBpbXBvcnQlMjBTdGF0ZUdyYXBoJTJDJTIwU1RBUlQlMkMlMjBFTkQlMEElMEElMjMlMjAlRTYlOUUlODQlRTUlQkIlQkElRTUlOUIlQkUlRTglQTElQTglMEFidWlsZGVyJTIwJTNEJTIwU3RhdGVHcmFwaChTdGF0ZSklMEFidWlsZGVyLmFkZF9ub2RlKCUyMm5vZGVfMSUyMiUyQyUyMG5vZGVfMSklMEFidWlsZGVyLmFkZF9ub2RlKCUyMm5vZGVfMiUyMiUyQyUyMG5vZGVfMiklMEFidWlsZGVyLmFkZF9ub2RlKCUyMm5vZGVfMyUyMiUyQyUyMG5vZGVfMyklMEElMEElMjMlMjAlRTglQkYlOUUlRTYlOEUlQTUlRTklODAlQkIlRTglQkUlOTElMEFidWlsZGVyLmFkZF9lZGdlKFNUQVJUJTJDJTIwJTIybm9kZV8xJTIyKSUwQWJ1aWxkZXIuYWRkX2NvbmRpdGlvbmFsX2VkZ2VzKCUyMm5vZGVfMSUyMiUyQyUyMGRlY2lkZV9tb29kKSUwQWJ1aWxkZXIuYWRkX2VkZ2UoJTIybm9kZV8yJTIyJTJDJTIwRU5EKSUwQWJ1aWxkZXIuYWRkX2VkZ2UoJTIybm9kZV8zJTIyJTJDJTIwRU5EKSUwQSUwQSUyMyUyMCVFNyVCQyU5NiVFOCVBRiU5MSUwQWdyYXBoJTIwJTNEJTIwYnVpbGRlci5jb21waWxlKCk=",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Image, display
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> StateGraph, START, END

<span class="hljs-comment"># 构建图表</span>
builder = StateGraph(State)
builder.add_node(<span class="hljs-string">&quot;node_1&quot;</span>, node_1)
builder.add_node(<span class="hljs-string">&quot;node_2&quot;</span>, node_2)
builder.add_node(<span class="hljs-string">&quot;node_3&quot;</span>, node_3)

<span class="hljs-comment"># 连接逻辑</span>
builder.add_edge(START, <span class="hljs-string">&quot;node_1&quot;</span>)
builder.add_conditional_edges(<span class="hljs-string">&quot;node_1&quot;</span>, decide_mood)
builder.add_edge(<span class="hljs-string">&quot;node_2&quot;</span>, END)
builder.add_edge(<span class="hljs-string">&quot;node_3&quot;</span>, END)

<span class="hljs-comment"># 编译</span>
graph = builder.<span class="hljs-built_in">compile</span>()`,wrap:!1}}),H=new P({props:{code:"JTIzJTIwJUU1JThGJUFGJUU4JUE3JTg2JUU1JThDJTk2JTBBZGlzcGxheShJbWFnZShncmFwaC5nZXRfZ3JhcGgoKS5kcmF3X21lcm1haWRfcG5nKCkpKQ==",highlighted:`<span class="hljs-comment"># 可视化</span>
display(Image(graph.get_graph().draw_mermaid_png()))`,wrap:!1}}),D=new P({props:{code:"Z3JhcGguaW52b2tlKCU3QiUyMmdyYXBoX3N0YXRlJTIyJTIwJTNBJTIwJTIySGklMkMlMjB0aGlzJTIwaXMlMjBMYW5jZS4lMjIlN0Qp",highlighted:'graph.invoke({<span class="hljs-string">&quot;graph_state&quot;</span> : <span class="hljs-string">&quot;Hi, this is Lance.&quot;</span>})',wrap:!1}}),A=new P({props:{code:"LS0tTm9kZSUyMDEtLS0lMEEtLS1Ob2RlJTIwMy0tLSUwQSU3QidncmFwaF9zdGF0ZSclM0ElMjAnSGklMkMlMjB0aGlzJTIwaXMlMjBMYW5jZS4lMjBJJTIwYW0lMjBzYWQhJyU3RA==",highlighted:`---<span class="hljs-keyword">Node</span> <span class="hljs-title">1---</span>
---<span class="hljs-keyword">Node</span> <span class="hljs-title">3---</span>
{&#x27;graph_state&#x27;: &#x27;Hi, this is Lance. I am sad!&#x27;}`,wrap:!1}}),X=new tt({props:{title:"下一步？",local:"下一步",headingTag:"h2"}}),K=new ds({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/zh-CN/unit2/langgraph/building_blocks.mdx"}}),{c(){g=p("meta"),et=n(),st=p("p"),nt=n(),M(h.$$.fragment),at=n(),M(C.$$.fragment),pt=n(),d=p("p"),d.textContent=Ht,it=n(),u=p("img"),Ut=n(),f=p("p"),f.innerHTML=Wt,Mt=n(),c=p("img"),yt=n(),M(w.$$.fragment),rt=n(),j=p("p"),j.innerHTML=Yt,Jt=n(),M($.$$.fragment),Tt=n(),S=p("p"),S.innerHTML=At,mt=n(),k=p("blockquote"),k.innerHTML=Xt,gt=n(),M(G.$$.fragment),ot=n(),_=p("p"),_.innerHTML=zt,ut=n(),V=p("ul"),V.innerHTML=Kt,ht=n(),M(I.$$.fragment),Ct=n(),Q=p("p"),Q.textContent=Pt,dt=n(),b=p("ul"),b.innerHTML=ts,ft=n(),Z=p("blockquote"),Z.innerHTML=ss,ct=n(),M(R.$$.fragment),wt=n(),v=p("p"),v.innerHTML=ls,jt=n(),M(E.$$.fragment),$t=n(),x=p("p"),x.textContent=es,St=n(),B=p("ul"),B.innerHTML=ns,kt=n(),M(N.$$.fragment),Gt=n(),F=p("p"),F.innerHTML=as,_t=n(),M(L.$$.fragment),Vt=n(),q=p("p"),q.textContent=ps,It=n(),M(H.$$.fragment),Qt=n(),O=p("img"),bt=n(),W=p("p"),W.textContent=Us,Zt=n(),M(D.$$.fragment),Rt=n(),Y=p("p"),Y.textContent=Ms,vt=n(),M(A.$$.fragment),Et=n(),M(X.$$.fragment),xt=n(),z=p("p"),z.textContent=ys,Bt=n(),M(K.$$.fragment),Nt=n(),lt=p("p"),this.h()},l(t){const s=us("svelte-u9bgzb",document.head);g=i(s,"META",{name:!0,content:!0}),s.forEach(l),et=a(t),st=i(t,"P",{}),rs(st).forEach(l),nt=a(t),y(h.$$.fragment,t),at=a(t),y(C.$$.fragment,t),pt=a(t),d=i(t,"P",{"data-svelte-h":!0}),U(d)!=="svelte-1800rwf"&&(d.textContent=Ht),it=a(t),u=i(t,"IMG",{src:!0,alt:!0,width:!0}),Ut=a(t),f=i(t,"P",{"data-svelte-h":!0}),U(f)!=="svelte-ejgf0e"&&(f.innerHTML=Wt),Mt=a(t),c=i(t,"IMG",{src:!0,alt:!0}),yt=a(t),y(w.$$.fragment,t),rt=a(t),j=i(t,"P",{"data-svelte-h":!0}),U(j)!=="svelte-1e4aibb"&&(j.innerHTML=Yt),Jt=a(t),y($.$$.fragment,t),Tt=a(t),S=i(t,"P",{"data-svelte-h":!0}),U(S)!=="svelte-1jtd4jr"&&(S.innerHTML=At),mt=a(t),k=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),U(k)!=="svelte-ajfpr1"&&(k.innerHTML=Xt),gt=a(t),y(G.$$.fragment,t),ot=a(t),_=i(t,"P",{"data-svelte-h":!0}),U(_)!=="svelte-1iisg6m"&&(_.innerHTML=zt),ut=a(t),V=i(t,"UL",{"data-svelte-h":!0}),U(V)!=="svelte-1iub67j"&&(V.innerHTML=Kt),ht=a(t),y(I.$$.fragment,t),Ct=a(t),Q=i(t,"P",{"data-svelte-h":!0}),U(Q)!=="svelte-1sfr10c"&&(Q.textContent=Pt),dt=a(t),b=i(t,"UL",{"data-svelte-h":!0}),U(b)!=="svelte-quo06t"&&(b.innerHTML=ts),ft=a(t),Z=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),U(Z)!=="svelte-11dq7zt"&&(Z.innerHTML=ss),ct=a(t),y(R.$$.fragment,t),wt=a(t),v=i(t,"P",{"data-svelte-h":!0}),U(v)!=="svelte-vdr5dg"&&(v.innerHTML=ls),jt=a(t),y(E.$$.fragment,t),$t=a(t),x=i(t,"P",{"data-svelte-h":!0}),U(x)!=="svelte-3euhzu"&&(x.textContent=es),St=a(t),B=i(t,"UL",{"data-svelte-h":!0}),U(B)!=="svelte-yrpswg"&&(B.innerHTML=ns),kt=a(t),y(N.$$.fragment,t),Gt=a(t),F=i(t,"P",{"data-svelte-h":!0}),U(F)!=="svelte-1riuotf"&&(F.innerHTML=as),_t=a(t),y(L.$$.fragment,t),Vt=a(t),q=i(t,"P",{"data-svelte-h":!0}),U(q)!=="svelte-1gq7r39"&&(q.textContent=ps),It=a(t),y(H.$$.fragment,t),Qt=a(t),O=i(t,"IMG",{src:!0,alt:!0}),bt=a(t),W=i(t,"P",{"data-svelte-h":!0}),U(W)!=="svelte-p075fy"&&(W.textContent=Us),Zt=a(t),y(D.$$.fragment,t),Rt=a(t),Y=i(t,"P",{"data-svelte-h":!0}),U(Y)!=="svelte-1wdnc59"&&(Y.textContent=Ms),vt=a(t),y(A.$$.fragment,t),Et=a(t),y(X.$$.fragment,t),xt=a(t),z=i(t,"P",{"data-svelte-h":!0}),U(z)!=="svelte-mejdbb"&&(z.textContent=ys),Bt=a(t),y(K.$$.fragment,t),Nt=a(t),lt=i(t,"P",{}),rs(lt).forEach(l),this.h()},h(){o(g,"name","hf:doc:metadata"),o(g,"content",cs),Lt(u.src,Ot="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/Building_blocks.png")||o(u,"src",Ot),o(u,"alt","Building Blocks"),o(u,"width","70%"),Lt(c.src,Dt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/application.png")||o(c,"src",Dt),o(c,"alt","Application"),Lt(O.src,is="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/basic_graph.jpeg")||o(O,"src",is),o(O,"alt","图可视化")},m(t,s){hs(document.head,g),e(t,et,s),e(t,st,s),e(t,nt,s),r(h,t,s),e(t,at,s),r(C,t,s),e(t,pt,s),e(t,d,s),e(t,it,s),e(t,u,s),e(t,Ut,s),e(t,f,s),e(t,Mt,s),e(t,c,s),e(t,yt,s),r(w,t,s),e(t,rt,s),e(t,j,s),e(t,Jt,s),r($,t,s),e(t,Tt,s),e(t,S,s),e(t,mt,s),e(t,k,s),e(t,gt,s),r(G,t,s),e(t,ot,s),e(t,_,s),e(t,ut,s),e(t,V,s),e(t,ht,s),r(I,t,s),e(t,Ct,s),e(t,Q,s),e(t,dt,s),e(t,b,s),e(t,ft,s),e(t,Z,s),e(t,ct,s),r(R,t,s),e(t,wt,s),e(t,v,s),e(t,jt,s),r(E,t,s),e(t,$t,s),e(t,x,s),e(t,St,s),e(t,B,s),e(t,kt,s),r(N,t,s),e(t,Gt,s),e(t,F,s),e(t,_t,s),r(L,t,s),e(t,Vt,s),e(t,q,s),e(t,It,s),r(H,t,s),e(t,Qt,s),e(t,O,s),e(t,bt,s),e(t,W,s),e(t,Zt,s),r(D,t,s),e(t,Rt,s),e(t,Y,s),e(t,vt,s),r(A,t,s),e(t,Et,s),r(X,t,s),e(t,xt,s),e(t,z,s),e(t,Bt,s),r(K,t,s),e(t,Nt,s),e(t,lt,s),Ft=!0},p:Ts,i(t){Ft||(J(h.$$.fragment,t),J(C.$$.fragment,t),J(w.$$.fragment,t),J($.$$.fragment,t),J(G.$$.fragment,t),J(I.$$.fragment,t),J(R.$$.fragment,t),J(E.$$.fragment,t),J(N.$$.fragment,t),J(L.$$.fragment,t),J(H.$$.fragment,t),J(D.$$.fragment,t),J(A.$$.fragment,t),J(X.$$.fragment,t),J(K.$$.fragment,t),Ft=!0)},o(t){T(h.$$.fragment,t),T(C.$$.fragment,t),T(w.$$.fragment,t),T($.$$.fragment,t),T(G.$$.fragment,t),T(I.$$.fragment,t),T(R.$$.fragment,t),T(E.$$.fragment,t),T(N.$$.fragment,t),T(L.$$.fragment,t),T(H.$$.fragment,t),T(D.$$.fragment,t),T(A.$$.fragment,t),T(X.$$.fragment,t),T(K.$$.fragment,t),Ft=!1},d(t){t&&(l(et),l(st),l(nt),l(at),l(pt),l(d),l(it),l(u),l(Ut),l(f),l(Mt),l(c),l(yt),l(rt),l(j),l(Jt),l(Tt),l(S),l(mt),l(k),l(gt),l(ot),l(_),l(ut),l(V),l(ht),l(Ct),l(Q),l(dt),l(b),l(ft),l(Z),l(ct),l(wt),l(v),l(jt),l($t),l(x),l(St),l(B),l(kt),l(Gt),l(F),l(_t),l(Vt),l(q),l(It),l(Qt),l(O),l(bt),l(W),l(Zt),l(Rt),l(Y),l(vt),l(Et),l(xt),l(z),l(Bt),l(Nt),l(lt)),l(g),m(h,t),m(C,t),m(w,t),m($,t),m(G,t),m(I,t),m(R,t),m(E,t),m(N,t),m(L,t),m(H,t),m(D,t),m(A,t),m(X,t),m(K,t)}}}const cs='{"title":"LangGraph 的核心构建模块","local":"langgraph-的核心构建模块","sections":[{"title":"1. 状态（State）","local":"1-状态state","sections":[],"depth":2},{"title":"2. 节点（Nodes）","local":"2-节点nodes","sections":[],"depth":2},{"title":"3. 边（Edges）","local":"3-边edges","sections":[],"depth":2},{"title":"4. 状态图（StateGraph）","local":"4-状态图stategraph","sections":[],"depth":2},{"title":"下一步？","local":"下一步","sections":[],"depth":2}],"depth":1}';function ws(qt){return ms(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _s extends gs{constructor(g){super(),os(this,g,ws,fs,Js,{})}}export{_s as component};
