import{s as zl,n as Yl,o as Ll}from"../chunks/scheduler.505acc25.js";import{S as Pl,i as Kl,e as p,s as n,c as U,q as Dl,h as Ol,a as M,d as t,b as a,f as yl,g as o,j as i,r as st,k as wl,l as ul,m as e,n as J,t as w,o as c,p as y}from"../chunks/index.b1175496.js";import{C as lt,H as r}from"../chunks/Heading.eda51538.js";import{C as d}from"../chunks/CodeBlock.9d480d26.js";import{E as tt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.ea377ea6.js";function et(jl){let u,us,cs,js,h,Ts,C,ms,I,Tl="LlamaIndex 中的工作流提供了一种结构化方式来将代码组织成可管理的顺序步骤。",rs,b,ml=`这种工作流通过定义由<code>事件（Events）</code>触发的<code>步骤（Steps）</code>来创建，这些步骤本身也会发出<code>事件</code>来触发后续步骤。
让我们看看 Alfred 展示的用于 RAG 任务的 LlamaIndex 工作流。`,ds,f,rl='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/workflows.png" alt="工作流示意图"/>',hs,B,dl="<strong>工作流具有以下关键优势：</strong>",Cs,k,hl="<li>将代码清晰地组织为离散步骤</li> <li>事件驱动架构实现灵活控制流</li> <li>步骤间类型安全的通信</li> <li>内置状态管理</li> <li>支持简单和复杂的智能体交互</li>",Is,g,Cl="正如您可能猜到的，<strong>工作流在保持对整体流程控制的同时，实现了智能体的自主性之间的完美平衡。</strong>",bs,v,Il="现在让我们学习如何自己创建工作流！",fs,Q,Bs,j,bl='<p>您可以通过 <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/llama-index/workflows.ipynb" target="_blank">这个笔记本</a> 中的代码进行实践，可使用 Google Colab 运行。</p>',ks,E,gs,T,ws,fl="安装工作流包",cl,V,vs,_,Bl=`我们可以通过定义一个继承自 <code>Workflow</code> 的类并用 <code>@step</code> 装饰你的函数来创建一个单步工作流。
我们还需要添加 <code>StartEvent</code> 和 <code>StopEvent</code>，它们是用于指示工作流开始和结束的特殊事件。`,Qs,Z,Es,G,kl="如您所见，我们现在可以通过调用“w.run()”来运行工作流程。",Vs,x,_s,$,gl=`为了连接多个步骤，我们<strong>创建在步骤之间传输数据的自定义事件</strong>。
为此，我们需要添加一个在步骤之间传递的“事件”，并将第一步的输出传输到第二步。`,Zs,S,Gs,F,vl="类型提示在这里很重要，因为它可以确保工作流正确执行。让我们把事情复杂化一点吧！",xs,W,$s,R,Ql="类型提示是工作流中最强大的部分，因为它允许我们创建分支、循环和连接以促进更复杂的工作流。",Ss,A,El=`让我们展示一个使用联合运算符 <code>|</code> <strong>创建循环</strong> 的示例。
在下面的示例中，我们看到 <code>LoopEvent</code> 被作为步骤的输入，也可以作为输出返回。`,Fs,N,Ws,H,Rs,X,Vl="我们还可以绘制工作流程。让我们使用 <code>draw_all_possible_flows</code> 函数来绘制工作流程。这会将工作流程存储在 HTML 文件中。",As,q,Ns,z,_l='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/workflow-draw.png" alt="工作流程图"/>',Hs,Y,Zl="课程中我们将介绍最后一个很酷的技巧，即向工作流添加状态的能力。",Xs,L,qs,P,Gl=`当您想要跟踪工作流的状态时，状态管理非常有用，这样每个步骤都可以访问相同的状态。
我们可以在步骤函数中的参数上使用“上下文”类型提示来实现这一点。`,zs,K,Ys,D,xl="太棒了！现在您知道如何在 LlamaIndex 中创建基本工作流了！",Ls,m,$l='<p>工作流还有一些更复杂的细微差别，您可以在<a href="https://docs.llamaindex.ai/en/stable/understanding/workflows/">LlamaIndex 文档</a>中了解。</p>',Ps,O,Sl="但是，还有另一种创建工作流的方法，它依赖于 <code>AgentWorkflow</code> 类。让我们看看如何使用它来创建多智能体工作流。",Ks,ss,Ds,ls,Fl=`我们可以使用<strong><code>AgentWorkflow</code> 类来创建多智能体工作流</strong>，而无需手动创建工作流。
<code>AgentWorkflow</code> 使用工作流智能体，允许您创建一个或多个智能体的系统，这些智能体可以根据其专门功能进行协作并相互交接任务。
这可以构建复杂的智能体系统，其中不同的智能体处理任务的不同方面。
我们将从<code>llama_index.core.agent.workflow</code> 导入智能体类，而不是从<code>llama_index.core.agent</code> 导入类。
在<code>AgentWorkflow</code> 构造函数中，必须将一个智能体指定为根智能体。
当用户消息传入时，它首先被路由到根智能体。`,Os,ts,Wl="然后每个智能体可以：",sl,es,Rl="<li>使用他们的工具直接处理请求</li> <li>交接给更适合该任务的另一个智能体</li> <li>向用户返回响应</li>",ll,ns,Al="让我们看看如何创建多智能体工作流。",tl,as,el,ps,Nl=`智能体工具还可以修改我们前面提到的工作流状态。在启动工作流之前，我们可以提供一个可供所有智能体使用的初始状态字典。
状态存储在工作流上下文的 state 键中。它将被注入到 state_prompt 中，以增强每个新用户消息。`,nl,Ms,Hl="让我们通过修改前面的示例来注入一个计数器来计数函数调用：",al,is,pl,Us,Xl="恭喜！您现在已经掌握了 LlamaIndex 中 Agent 的基础知识！🎉",Ml,os,ql="让我们继续进行最后一次测验来巩固您的知识！🚀",il,Js,Ul,ys,ol;return h=new lt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),C=new r({props:{title:"在 LlamaIndex 中创建智能工作流",local:"在-llamaindex-中创建智能工作流",headingTag:"h1"}}),Q=new r({props:{title:"创建工作流",local:"创建工作流",headingTag:"h2"}}),E=new r({props:{title:"基础工作流创建",local:"基础工作流创建",headingTag:"h3"}}),V=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxsYW1hLWluZGV4LXV0aWxzLXdvcmtmbG93",highlighted:"pip install llama-index-utils-workflow",wrap:!1}}),Z=new d({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBTdGFydEV2ZW50JTJDJTIwU3RvcEV2ZW50JTJDJTIwV29ya2Zsb3clMkMlMjBzdGVwJTBBJTBBY2xhc3MlMjBNeVdvcmtmbG93KFdvcmtmbG93KSUzQSUwQSUyMCUyMCUyMCUyMCU0MHN0ZXAlMEElMjAlMjAlMjAlMjBhc3luYyUyMGRlZiUyMG15X3N0ZXAoc2VsZiUyQyUyMGV2JTNBJTIwU3RhcnRFdmVudCklMjAtJTNFJTIwU3RvcEV2ZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZG8lMjBzb21ldGhpbmclMjBoZXJlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRCUyMkhlbGxvJTJDJTIwd29ybGQhJTIyKSUwQSUwQSUwQXclMjAlM0QlMjBNeVdvcmtmbG93KHRpbWVvdXQlM0QxMCUyQyUyMHZlcmJvc2UlM0RGYWxzZSklMEFyZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHcucnVuKCk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> StartEvent, StopEvent, Workflow, step

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">my_step</span>(<span class="hljs-params">self, ev: StartEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># do something here</span>
        <span class="hljs-keyword">return</span> StopEvent(result=<span class="hljs-string">&quot;Hello, world!&quot;</span>)


w = MyWorkflow(timeout=<span class="hljs-number">10</span>, verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()`,wrap:!1}}),x=new r({props:{title:"连接多个步骤",local:"连接多个步骤",headingTag:"h3"}}),S=new d({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBFdmVudCUwQSUwQWNsYXNzJTIwUHJvY2Vzc2luZ0V2ZW50KEV2ZW50KSUzQSUwQSUyMCUyMCUyMCUyMGludGVybWVkaWF0ZV9yZXN1bHQlM0ElMjBzdHIlMEElMEFjbGFzcyUyME11bHRpU3RlcFdvcmtmbG93KFdvcmtmbG93KSUzQSUwQSUyMCUyMCUyMCUyMCU0MHN0ZXAlMEElMjAlMjAlMjAlMjBhc3luYyUyMGRlZiUyMHN0ZXBfb25lKHNlbGYlMkMlMjBldiUzQSUyMFN0YXJ0RXZlbnQpJTIwLSUzRSUyMFByb2Nlc3NpbmdFdmVudCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFByb2Nlc3MlMjBpbml0aWFsJTIwZGF0YSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMFByb2Nlc3NpbmdFdmVudChpbnRlcm1lZGlhdGVfcmVzdWx0JTNEJTIyU3RlcCUyMDElMjBjb21wbGV0ZSUyMiklMEElMEElMjAlMjAlMjAlMjAlNDBzdGVwJTBBJTIwJTIwJTIwJTIwYXN5bmMlMjBkZWYlMjBzdGVwX3R3byhzZWxmJTJDJTIwZXYlM0ElMjBQcm9jZXNzaW5nRXZlbnQpJTIwLSUzRSUyMFN0b3BFdmVudCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFVzZSUyMHRoZSUyMGludGVybWVkaWF0ZSUyMHJlc3VsdCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZpbmFsX3Jlc3VsdCUyMCUzRCUyMGYlMjJGaW5pc2hlZCUyMHByb2Nlc3NpbmclM0ElMjAlN0Jldi5pbnRlcm1lZGlhdGVfcmVzdWx0JTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRGZpbmFsX3Jlc3VsdCklMEElMEF3JTIwJTNEJTIwTXVsdGlTdGVwV29ya2Zsb3codGltZW91dCUzRDEwJTJDJTIwdmVyYm9zZSUzREZhbHNlKSUwQXJlc3VsdCUyMCUzRCUyMGF3YWl0JTIwdy5ydW4oKSUwQXJlc3VsdA==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Event

<span class="hljs-keyword">class</span> <span class="hljs-title class_">ProcessingEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    intermediate_result: <span class="hljs-built_in">str</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MultiStepWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_one</span>(<span class="hljs-params">self, ev: StartEvent</span>) -&gt; ProcessingEvent:
        <span class="hljs-comment"># Process initial data</span>
        <span class="hljs-keyword">return</span> ProcessingEvent(intermediate_result=<span class="hljs-string">&quot;Step 1 complete&quot;</span>)

<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_two</span>(<span class="hljs-params">self, ev: ProcessingEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># Use the intermediate result</span>
        final_result = <span class="hljs-string">f&quot;Finished processing: <span class="hljs-subst">{ev.intermediate_result}</span>&quot;</span>
        <span class="hljs-keyword">return</span> StopEvent(result=final_result)

w = MultiStepWorkflow(timeout=<span class="hljs-number">10</span>, verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()
result`,wrap:!1}}),W=new r({props:{title:"循环和分支",local:"循环和分支",headingTag:"h3"}}),N=new d({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBFdmVudCUwQWltcG9ydCUyMHJhbmRvbSUwQSUwQSUwQWNsYXNzJTIwUHJvY2Vzc2luZ0V2ZW50KEV2ZW50KSUzQSUwQSUyMCUyMCUyMCUyMGludGVybWVkaWF0ZV9yZXN1bHQlM0ElMjBzdHIlMEElMEElMEFjbGFzcyUyMExvb3BFdmVudChFdmVudCklM0ElMEElMjAlMjAlMjAlMjBsb29wX291dHB1dCUzQSUyMHN0ciUwQSUwQSUwQWNsYXNzJTIwTXVsdGlTdGVwV29ya2Zsb3coV29ya2Zsb3cpJTNBJTBBJTIwJTIwJTIwJTIwJTQwc3RlcCUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc3RlcF9vbmUoc2VsZiUyQyUyMGV2JTNBJTIwU3RhcnRFdmVudCUyMCU3QyUyMExvb3BFdmVudCklMjAtJTNFJTIwUHJvY2Vzc2luZ0V2ZW50JTIwJTdDJTIwTG9vcEV2ZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjByYW5kb20ucmFuZGludCgwJTJDJTIwMSklMjAlM0QlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyQmFkJTIwdGhpbmclMjBoYXBwZW5lZCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBMb29wRXZlbnQobG9vcF9vdXRwdXQlM0QlMjJCYWNrJTIwdG8lMjBzdGVwJTIwb25lLiUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyR29vZCUyMHRoaW5nJTIwaGFwcGVuZWQlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwUHJvY2Vzc2luZ0V2ZW50KGludGVybWVkaWF0ZV9yZXN1bHQlM0QlMjJGaXJzdCUyMHN0ZXAlMjBjb21wbGV0ZS4lMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTQwc3RlcCUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc3RlcF90d28oc2VsZiUyQyUyMGV2JTNBJTIwUHJvY2Vzc2luZ0V2ZW50KSUyMC0lM0UlMjBTdG9wRXZlbnQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBVc2UlMjB0aGUlMjBpbnRlcm1lZGlhdGUlMjByZXN1bHQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmaW5hbF9yZXN1bHQlMjAlM0QlMjBmJTIyRmluaXNoZWQlMjBwcm9jZXNzaW5nJTNBJTIwJTdCZXYuaW50ZXJtZWRpYXRlX3Jlc3VsdCU3RCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMFN0b3BFdmVudChyZXN1bHQlM0RmaW5hbF9yZXN1bHQpJTBBJTBBJTBBdyUyMCUzRCUyME11bHRpU3RlcFdvcmtmbG93KHZlcmJvc2UlM0RGYWxzZSklMEFyZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHcucnVuKCklMEFyZXN1bHQ=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Event
<span class="hljs-keyword">import</span> random


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ProcessingEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    intermediate_result: <span class="hljs-built_in">str</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">LoopEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    loop_output: <span class="hljs-built_in">str</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MultiStepWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_one</span>(<span class="hljs-params">self, ev: StartEvent | LoopEvent</span>) -&gt; ProcessingEvent | LoopEvent:
        <span class="hljs-keyword">if</span> random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>) == <span class="hljs-number">0</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Bad thing happened&quot;</span>)
            <span class="hljs-keyword">return</span> LoopEvent(loop_output=<span class="hljs-string">&quot;Back to step one.&quot;</span>)
        <span class="hljs-keyword">else</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Good thing happened&quot;</span>)
            <span class="hljs-keyword">return</span> ProcessingEvent(intermediate_result=<span class="hljs-string">&quot;First step complete.&quot;</span>)

<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_two</span>(<span class="hljs-params">self, ev: ProcessingEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># Use the intermediate result</span>
        final_result = <span class="hljs-string">f&quot;Finished processing: <span class="hljs-subst">{ev.intermediate_result}</span>&quot;</span>
        <span class="hljs-keyword">return</span> StopEvent(result=final_result)


w = MultiStepWorkflow(verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()
result`,wrap:!1}}),H=new r({props:{title:"绘制工作流程",local:"绘制工作流程",headingTag:"h3"}}),q=new d({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LnV0aWxzLndvcmtmbG93JTIwaW1wb3J0JTIwZHJhd19hbGxfcG9zc2libGVfZmxvd3MlMEElMEF3JTIwJTNEJTIwLi4uJTIwJTIzJTIwYXMlMjBkZWZpbmVkJTIwaW4lMjB0aGUlMjBwcmV2aW91cyUyMHNlY3Rpb24lMEFkcmF3X2FsbF9wb3NzaWJsZV9mbG93cyh3JTJDJTIwJTIyZmxvdy5odG1sJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.utils.workflow <span class="hljs-keyword">import</span> draw_all_possible_flows

w = ... <span class="hljs-comment"># as defined in the previous section</span>
draw_all_possible_flows(w, <span class="hljs-string">&quot;flow.html&quot;</span>)`,wrap:!1}}),L=new r({props:{title:"状态管理",local:"状态管理",headingTag:"h3"}}),K=new d({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBDb250ZXh0JTJDJTIwU3RhcnRFdmVudCUyQyUyMFN0b3BFdmVudCUwQSUwQSUwQSU0MHN0ZXAlMEFhc3luYyUyMGRlZiUyMHF1ZXJ5KHNlbGYlMkMlMjBjdHglM0ElMjBDb250ZXh0JTJDJTIwZXYlM0ElMjBTdGFydEV2ZW50KSUyMC0lM0UlMjBTdG9wRXZlbnQlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjAlRTUlQUQlOTglRTUlODIlQTglRTUlOUMlQTglRTQlQjglOEElRTQlQjglOEIlRTYlOTYlODclRTQlQjglQUQlMEElMjAlMjAlMjAlMjBhd2FpdCUyMGN0eC5zdG9yZS5zZXQoJTIycXVlcnklMjIlMkMlMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwJUU2JUEwJUI5JUU2JThEJUFFJUU0JUI4JThBJUU0JUI4JThCJUU2JTk2JTg3JUU1JTkyJThDJUU0JUJBJThCJUU0JUJCJUI2JUU1JTgxJTlBJUU2JTlGJTkwJUU0JUJBJThCJTBBJTIwJTIwJTIwJTIwdmFsJTIwJTNEJTIwLi4uJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwJUU0JUJCJThFJUU0JUI4JThBJUU0JUI4JThCJUU2JTk2JTg3JUU0JUI4JUFEJUU2JUEzJTgwJUU3JUI0JUEyJTBBJTIwJTIwJTIwJTIwcXVlcnklMjAlM0QlMjBhd2FpdCUyMGN0eC5zdG9yZS5nZXQoJTIycXVlcnklMjIpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRHJlc3VsdCk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Context, StartEvent, StopEvent


<span class="hljs-meta">@step</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">query</span>(<span class="hljs-params">self, ctx: Context, ev: StartEvent</span>) -&gt; StopEvent:
    <span class="hljs-comment"># 存储在上下文中</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;What is the capital of France?&quot;</span>)

    <span class="hljs-comment"># 根据上下文和事件做某事</span>
    val = ...

    <span class="hljs-comment"># 从上下文中检索</span>
    query = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;query&quot;</span>)

    <span class="hljs-keyword">return</span> StopEvent(result=result)`,wrap:!1}}),ss=new r({props:{title:"使用多智能体工作流自动化工作流",local:"使用多智能体工作流自动化工作流",headingTag:"h2"}}),as=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.agent.workflow <span class="hljs-keyword">import</span> AgentWorkflow, ReActAgent
<span class="hljs-keyword">from</span> llama_index.llms.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI

<span class="hljs-comment"># 定义一些工具</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Add two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a + b

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

<span class="hljs-comment"># 我们可以直接传递函数，而无需 FunctionTool——fn/docstring 会被解析为名称/描述</span>
multiply_agent = ReActAgent(
    name=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Is able to multiply two integers&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;A helpful assistant that can use a tool to multiply numbers.&quot;</span>,
    tools=[multiply],
    llm=llm,
)

addition_agent = ReActAgent(
    name=<span class="hljs-string">&quot;add_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Is able to add two integers&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;A helpful assistant that can use a tool to add numbers.&quot;</span>,
    tools=[add],
    llm=llm,
)

<span class="hljs-comment"># 创建工作流</span>
workflow = AgentWorkflow(
    agents=[multiply_agent, addition_agent],
    root_agent=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
)

<span class="hljs-comment"># 运行系统</span>
response = <span class="hljs-keyword">await</span> workflow.run(user_msg=<span class="hljs-string">&quot;Can you add 5 and 3?&quot;</span>)`,wrap:!1}}),is=new d({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Context

<span class="hljs-comment"># 定义一些工具</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">ctx: Context, a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Add two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># update our count</span>
    cur_state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
    cur_state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>] += <span class="hljs-number">1</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;state&quot;</span>, cur_state)

    <span class="hljs-keyword">return</span> a + b

<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">ctx: Context, a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># update our count</span>
    cur_state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
    cur_state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>] += <span class="hljs-number">1</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;state&quot;</span>, cur_state)

    <span class="hljs-keyword">return</span> a * b

...

workflow = AgentWorkflow(
    agents=[multiply_agent, addition_agent],
    root_agent=<span class="hljs-string">&quot;multiply_agent&quot;</span>
    initial_state={<span class="hljs-string">&quot;num_fn_calls&quot;</span>: <span class="hljs-number">0</span>},
    state_prompt=<span class="hljs-string">&quot;Current state: {state}. User message: {msg}&quot;</span>,
)

<span class="hljs-comment"># 使用上下文运行工作流程</span>
ctx = Context(workflow)
response = <span class="hljs-keyword">await</span> workflow.run(user_msg=<span class="hljs-string">&quot;Can you add 5 and 3?&quot;</span>, ctx=ctx)

<span class="hljs-comment"># 拉出并检查状态</span>
state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
<span class="hljs-built_in">print</span>(state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>])`,wrap:!1}}),Js=new tt({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/zh-CN/unit2/llama-index/workflows.mdx"}}),{c(){u=p("meta"),us=n(),cs=p("p"),js=n(),U(h.$$.fragment),Ts=n(),U(C.$$.fragment),ms=n(),I=p("p"),I.textContent=Tl,rs=n(),b=p("p"),b.innerHTML=ml,ds=n(),f=p("p"),f.innerHTML=rl,hs=n(),B=p("p"),B.innerHTML=dl,Cs=n(),k=p("ul"),k.innerHTML=hl,Is=n(),g=p("p"),g.innerHTML=Cl,bs=n(),v=p("p"),v.textContent=Il,fs=n(),U(Q.$$.fragment),Bs=n(),j=p("blockquote"),j.innerHTML=bl,ks=n(),U(E.$$.fragment),gs=n(),T=p("details"),ws=p("summary"),ws.textContent=fl,cl=Dl(`
如 [LlamaHub 章节](llama-hub) 介绍的，我们可以通过以下命令安装工作流包：

	`),U(V.$$.fragment),vs=n(),_=p("p"),_.innerHTML=Bl,Qs=n(),U(Z.$$.fragment),Es=n(),G=p("p"),G.textContent=kl,Vs=n(),U(x.$$.fragment),_s=n(),$=p("p"),$.innerHTML=gl,Zs=n(),U(S.$$.fragment),Gs=n(),F=p("p"),F.textContent=vl,xs=n(),U(W.$$.fragment),$s=n(),R=p("p"),R.textContent=Ql,Ss=n(),A=p("p"),A.innerHTML=El,Fs=n(),U(N.$$.fragment),Ws=n(),U(H.$$.fragment),Rs=n(),X=p("p"),X.innerHTML=Vl,As=n(),U(q.$$.fragment),Ns=n(),z=p("p"),z.innerHTML=_l,Hs=n(),Y=p("p"),Y.textContent=Zl,Xs=n(),U(L.$$.fragment),qs=n(),P=p("p"),P.textContent=Gl,zs=n(),U(K.$$.fragment),Ys=n(),D=p("p"),D.textContent=xl,Ls=n(),m=p("blockquote"),m.innerHTML=$l,Ps=n(),O=p("p"),O.innerHTML=Sl,Ks=n(),U(ss.$$.fragment),Ds=n(),ls=p("p"),ls.innerHTML=Fl,Os=n(),ts=p("p"),ts.textContent=Wl,sl=n(),es=p("ul"),es.innerHTML=Rl,ll=n(),ns=p("p"),ns.textContent=Al,tl=n(),U(as.$$.fragment),el=n(),ps=p("p"),ps.textContent=Nl,nl=n(),Ms=p("p"),Ms.textContent=Hl,al=n(),U(is.$$.fragment),pl=n(),Us=p("p"),Us.textContent=Xl,Ml=n(),os=p("p"),os.textContent=ql,il=n(),U(Js.$$.fragment),Ul=n(),ys=p("p"),this.h()},l(s){const l=Ol("svelte-u9bgzb",document.head);u=M(l,"META",{name:!0,content:!0}),l.forEach(t),us=a(s),cs=M(s,"P",{}),yl(cs).forEach(t),js=a(s),o(h.$$.fragment,s),Ts=a(s),o(C.$$.fragment,s),ms=a(s),I=M(s,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1zncfn"&&(I.textContent=Tl),rs=a(s),b=M(s,"P",{"data-svelte-h":!0}),i(b)!=="svelte-1phl6o4"&&(b.innerHTML=ml),ds=a(s),f=M(s,"P",{"data-svelte-h":!0}),i(f)!=="svelte-1fdqx1j"&&(f.innerHTML=rl),hs=a(s),B=M(s,"P",{"data-svelte-h":!0}),i(B)!=="svelte-kcsc97"&&(B.innerHTML=dl),Cs=a(s),k=M(s,"UL",{"data-svelte-h":!0}),i(k)!=="svelte-hv8940"&&(k.innerHTML=hl),Is=a(s),g=M(s,"P",{"data-svelte-h":!0}),i(g)!=="svelte-941b0a"&&(g.innerHTML=Cl),bs=a(s),v=M(s,"P",{"data-svelte-h":!0}),i(v)!=="svelte-10dcwra"&&(v.textContent=Il),fs=a(s),o(Q.$$.fragment,s),Bs=a(s),j=M(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(j)!=="svelte-jhglzk"&&(j.innerHTML=bl),ks=a(s),o(E.$$.fragment,s),gs=a(s),T=M(s,"DETAILS",{});var Jl=yl(T);ws=M(Jl,"SUMMARY",{"data-svelte-h":!0}),i(ws)!=="svelte-14m3ggn"&&(ws.textContent=fl),cl=st(Jl,`
如 [LlamaHub 章节](llama-hub) 介绍的，我们可以通过以下命令安装工作流包：

	`),o(V.$$.fragment,Jl),Jl.forEach(t),vs=a(s),_=M(s,"P",{"data-svelte-h":!0}),i(_)!=="svelte-1dxezou"&&(_.innerHTML=Bl),Qs=a(s),o(Z.$$.fragment,s),Es=a(s),G=M(s,"P",{"data-svelte-h":!0}),i(G)!=="svelte-4urpti"&&(G.textContent=kl),Vs=a(s),o(x.$$.fragment,s),_s=a(s),$=M(s,"P",{"data-svelte-h":!0}),i($)!=="svelte-6xydj5"&&($.innerHTML=gl),Zs=a(s),o(S.$$.fragment,s),Gs=a(s),F=M(s,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1aahnbx"&&(F.textContent=vl),xs=a(s),o(W.$$.fragment,s),$s=a(s),R=M(s,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1fzqx5n"&&(R.textContent=Ql),Ss=a(s),A=M(s,"P",{"data-svelte-h":!0}),i(A)!=="svelte-61qf0g"&&(A.innerHTML=El),Fs=a(s),o(N.$$.fragment,s),Ws=a(s),o(H.$$.fragment,s),Rs=a(s),X=M(s,"P",{"data-svelte-h":!0}),i(X)!=="svelte-nsfhj0"&&(X.innerHTML=Vl),As=a(s),o(q.$$.fragment,s),Ns=a(s),z=M(s,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1fejrbj"&&(z.innerHTML=_l),Hs=a(s),Y=M(s,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-1g6o0kz"&&(Y.textContent=Zl),Xs=a(s),o(L.$$.fragment,s),qs=a(s),P=M(s,"P",{"data-svelte-h":!0}),i(P)!=="svelte-18z3r0o"&&(P.textContent=Gl),zs=a(s),o(K.$$.fragment,s),Ys=a(s),D=M(s,"P",{"data-svelte-h":!0}),i(D)!=="svelte-zlhwuy"&&(D.textContent=xl),Ls=a(s),m=M(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(m)!=="svelte-bf8gqx"&&(m.innerHTML=$l),Ps=a(s),O=M(s,"P",{"data-svelte-h":!0}),i(O)!=="svelte-1f7ur07"&&(O.innerHTML=Sl),Ks=a(s),o(ss.$$.fragment,s),Ds=a(s),ls=M(s,"P",{"data-svelte-h":!0}),i(ls)!=="svelte-1q9g7so"&&(ls.innerHTML=Fl),Os=a(s),ts=M(s,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-x6am9b"&&(ts.textContent=Wl),sl=a(s),es=M(s,"UL",{"data-svelte-h":!0}),i(es)!=="svelte-1szl21w"&&(es.innerHTML=Rl),ll=a(s),ns=M(s,"P",{"data-svelte-h":!0}),i(ns)!=="svelte-uyi5am"&&(ns.textContent=Al),tl=a(s),o(as.$$.fragment,s),el=a(s),ps=M(s,"P",{"data-svelte-h":!0}),i(ps)!=="svelte-kjz8yo"&&(ps.textContent=Nl),nl=a(s),Ms=M(s,"P",{"data-svelte-h":!0}),i(Ms)!=="svelte-1kmhjoz"&&(Ms.textContent=Hl),al=a(s),o(is.$$.fragment,s),pl=a(s),Us=M(s,"P",{"data-svelte-h":!0}),i(Us)!=="svelte-65f1le"&&(Us.textContent=Xl),Ml=a(s),os=M(s,"P",{"data-svelte-h":!0}),i(os)!=="svelte-xofn8o"&&(os.textContent=ql),il=a(s),o(Js.$$.fragment,s),Ul=a(s),ys=M(s,"P",{}),yl(ys).forEach(t),this.h()},h(){wl(u,"name","hf:doc:metadata"),wl(u,"content",nt),wl(j,"class","tip"),wl(m,"class","tip")},m(s,l){ul(document.head,u),e(s,us,l),e(s,cs,l),e(s,js,l),J(h,s,l),e(s,Ts,l),J(C,s,l),e(s,ms,l),e(s,I,l),e(s,rs,l),e(s,b,l),e(s,ds,l),e(s,f,l),e(s,hs,l),e(s,B,l),e(s,Cs,l),e(s,k,l),e(s,Is,l),e(s,g,l),e(s,bs,l),e(s,v,l),e(s,fs,l),J(Q,s,l),e(s,Bs,l),e(s,j,l),e(s,ks,l),J(E,s,l),e(s,gs,l),e(s,T,l),ul(T,ws),ul(T,cl),J(V,T,null),e(s,vs,l),e(s,_,l),e(s,Qs,l),J(Z,s,l),e(s,Es,l),e(s,G,l),e(s,Vs,l),J(x,s,l),e(s,_s,l),e(s,$,l),e(s,Zs,l),J(S,s,l),e(s,Gs,l),e(s,F,l),e(s,xs,l),J(W,s,l),e(s,$s,l),e(s,R,l),e(s,Ss,l),e(s,A,l),e(s,Fs,l),J(N,s,l),e(s,Ws,l),J(H,s,l),e(s,Rs,l),e(s,X,l),e(s,As,l),J(q,s,l),e(s,Ns,l),e(s,z,l),e(s,Hs,l),e(s,Y,l),e(s,Xs,l),J(L,s,l),e(s,qs,l),e(s,P,l),e(s,zs,l),J(K,s,l),e(s,Ys,l),e(s,D,l),e(s,Ls,l),e(s,m,l),e(s,Ps,l),e(s,O,l),e(s,Ks,l),J(ss,s,l),e(s,Ds,l),e(s,ls,l),e(s,Os,l),e(s,ts,l),e(s,sl,l),e(s,es,l),e(s,ll,l),e(s,ns,l),e(s,tl,l),J(as,s,l),e(s,el,l),e(s,ps,l),e(s,nl,l),e(s,Ms,l),e(s,al,l),J(is,s,l),e(s,pl,l),e(s,Us,l),e(s,Ml,l),e(s,os,l),e(s,il,l),J(Js,s,l),e(s,Ul,l),e(s,ys,l),ol=!0},p:Yl,i(s){ol||(w(h.$$.fragment,s),w(C.$$.fragment,s),w(Q.$$.fragment,s),w(E.$$.fragment,s),w(V.$$.fragment,s),w(Z.$$.fragment,s),w(x.$$.fragment,s),w(S.$$.fragment,s),w(W.$$.fragment,s),w(N.$$.fragment,s),w(H.$$.fragment,s),w(q.$$.fragment,s),w(L.$$.fragment,s),w(K.$$.fragment,s),w(ss.$$.fragment,s),w(as.$$.fragment,s),w(is.$$.fragment,s),w(Js.$$.fragment,s),ol=!0)},o(s){c(h.$$.fragment,s),c(C.$$.fragment,s),c(Q.$$.fragment,s),c(E.$$.fragment,s),c(V.$$.fragment,s),c(Z.$$.fragment,s),c(x.$$.fragment,s),c(S.$$.fragment,s),c(W.$$.fragment,s),c(N.$$.fragment,s),c(H.$$.fragment,s),c(q.$$.fragment,s),c(L.$$.fragment,s),c(K.$$.fragment,s),c(ss.$$.fragment,s),c(as.$$.fragment,s),c(is.$$.fragment,s),c(Js.$$.fragment,s),ol=!1},d(s){s&&(t(us),t(cs),t(js),t(Ts),t(ms),t(I),t(rs),t(b),t(ds),t(f),t(hs),t(B),t(Cs),t(k),t(Is),t(g),t(bs),t(v),t(fs),t(Bs),t(j),t(ks),t(gs),t(T),t(vs),t(_),t(Qs),t(Es),t(G),t(Vs),t(_s),t($),t(Zs),t(Gs),t(F),t(xs),t($s),t(R),t(Ss),t(A),t(Fs),t(Ws),t(Rs),t(X),t(As),t(Ns),t(z),t(Hs),t(Y),t(Xs),t(qs),t(P),t(zs),t(Ys),t(D),t(Ls),t(m),t(Ps),t(O),t(Ks),t(Ds),t(ls),t(Os),t(ts),t(sl),t(es),t(ll),t(ns),t(tl),t(el),t(ps),t(nl),t(Ms),t(al),t(pl),t(Us),t(Ml),t(os),t(il),t(Ul),t(ys)),t(u),y(h,s),y(C,s),y(Q,s),y(E,s),y(V),y(Z,s),y(x,s),y(S,s),y(W,s),y(N,s),y(H,s),y(q,s),y(L,s),y(K,s),y(ss,s),y(as,s),y(is,s),y(Js,s)}}}const nt='{"title":"在 LlamaIndex 中创建智能工作流","local":"在-llamaindex-中创建智能工作流","sections":[{"title":"创建工作流","local":"创建工作流","sections":[{"title":"基础工作流创建","local":"基础工作流创建","sections":[],"depth":3},{"title":"连接多个步骤","local":"连接多个步骤","sections":[],"depth":3},{"title":"循环和分支","local":"循环和分支","sections":[],"depth":3},{"title":"绘制工作流程","local":"绘制工作流程","sections":[],"depth":3},{"title":"状态管理","local":"状态管理","sections":[],"depth":3}],"depth":2},{"title":"使用多智能体工作流自动化工作流","local":"使用多智能体工作流自动化工作流","sections":[],"depth":2}],"depth":1}';function at(jl){return Ll(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jt extends Pl{constructor(u){super(),Kl(this,u,at,et,zl,{})}}export{Jt as component};
