# 从 LLM 到 AI 智能体

我们在课程的[第一单元](https://huggingface.co/learn/agents-course/unit1/introduction)中学到，AI 智能体能够规划和做决策。
虽然 LLM 已经使与 NPC 的交互更加自然，但智能体 AI 通过允许角色做出决策、规划行动和适应变化的环境，进一步推进了这一点。

为了说明区别，想想一个经典的 RPG NPC：

- 使用 LLM：NPC 可能以更自然、多样的方式回应你的问题。这对对话很好，但 NPC 保持静态，除非你先做什么，否则它不会行动。
- 使用智能体 AI：NPC 可以决定寻找帮助、设置陷阱或完全避开你，即使你没有直接与它交互。

这个小转变改变了一切。我们正在从脚本化响应者转向游戏世界中的自主行动者。

这种转变意味着 NPC 现在可以通过目标导向的行为直接与环境交互，最终导致更动态和不可预测的游戏玩法。

智能体 AI 为 NPC 提供了：

- **自主性**：基于游戏状态做出独立决策。
- **适应性**：响应玩家行动调整策略。
- **持久性**：记住过去的交互来指导未来的行为。

这将 NPC 从反应性实体（对你的输入做出反应）转变为游戏世界中的主动参与者，为创新游戏玩法打开了大门。

## 智能体的重大限制：**它很慢**（目前）

然而，让我们现在不要过于乐观。尽管有其潜力，智能体 AI 目前在实时应用中面临挑战。

推理和规划过程可能引入延迟，使其不太适合像*Doom*或*超级马里奥兄弟*这样的快节奏游戏。

以[_Claude Plays Pokémon_](https://www.twitch.tv/claudeplayspokemon)为例。如果你考虑**思考**所需 token 数量，加上**行动**所需的 token 数量，就会清楚地发现，我们需要完全不同的解码策略来使实时游戏变得可行。

<img
  src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/bonus-unit3/claude-plays-pokemon.png"
  alt="Claude plays Pokémon"
/>

大多数游戏需要以大约 30 FPS 运行，这意味着实时 AI 智能体需要每秒行动 30 次，这在当前的智能体 LLM 中是不可行的。

然而，像*宝可梦*这样的回合制游戏是理想的候选者，因为它们为 AI 提供了足够的时间来深思熟虑并做出战略决策。

这就是为什么在下一节中，你将构建自己的 AI 智能体来进行宝可梦风格的回合制战斗，甚至挑战它。让我们开始吧！


<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/zh-CN/bonus-unit3/from-llm-to-agents.mdx" />