# Overview

🤗 Optimum handles the export of PyTorch models to ONNX in the `exporters.onnx` module. It provides classes, functions, and a command line interface to perform the export easily.

Supported architectures from [🤗 Transformers](https://huggingface.co/docs/transformers/index):

- Arcee
- AST
- Audio Spectrogram Transformer
- Albert
- Bart
- Beit
- Bert
- BlenderBot
- BlenderBotSmall
- Bloom
- Camembert
- ChineseCLIP
- CLIP
- CodeGen
- Cohere
- ConvBert
- ConvNext
- ConvNextV2
- D-FINE
- Data2VecAudio
- Data2VecText
- Data2VecVision
- Deberta
- Deberta-v2
- Decision Transformer
- DeepSeek-V3
- Deit
- Detr
- DINOv2
- DistilBert
- Donut-Swin
- Electra
- Encoder Decoder
- ESM
- Falcon
- Flaubert
- Gemma
- Gemma 2
- GLM
- GPT-2
- GPT-BigCode
- GPT-J
- GPT-Neo
- GPT-NeoX
- OPT
- Granite
- GroupVit
- Helium
- Hiera
- Hubert
- IBert
- InternLM2
- LayoutLM
- LayoutLM-v3
- Lilt
- Levit
- LongT5
- Llama
- M2-M100
- Marian
- MarkupLM
- MaskFormer
- MBart
- MetaClip2
- MGP-STR
- Mistral
- MobileBert
- MobileVit
- MobileNet v1
- MobileNet v2
- ModernBert
- MPNet
- MT5
- Musicgen (text-conditional only)
- Nemotron
- Nystromformer
- OLMo
- OLMo2
- OWL-ViT
- PatchTST
- PatchTSMixer
- Pegasus
- Perceiver
- Phi
- Phi3
- Pix2Struct
- PoolFormer
- PVT
- Qwen2(Qwen1.5)
- Qwen3
- Qwen3-MoE
- RegNet
- RemBERT
- ResNet
- Roberta
- Roformer
- RT-DETR
- RT-DETRv2
- SAM
- Segformer
- SEW
- SEW-D
- Speech2Text
- SigLIP
- SmolLM3
- SpeechT5
- Splinter
- SqueezeBert
- StableLM
- Swin
- SwinV2
- T5
- Table Transformer
- TROCR
- UniSpeech
- UniSpeech SAT
- Vision Encoder Decoder
- VisualBert
- Vit
- VitMAE
- VitMSN
- Wav2Vec2
- Wav2Vec2 Conformer
- WavLM
- Whisper
- XLM
- XLM-Roberta
- Yolos

Supported architectures from [🤗 Diffusers](https://huggingface.co/docs/diffusers/index):
- Stable Diffusion

Supported architectures from [🤗 Timm](https://huggingface.co/docs/timm/index):
- Adversarial Inception v3
- AdvProp (EfficientNet)
- Big Transfer (BiT)
- CSP-DarkNet
- CSP-ResNet
- CSP-ResNeXt
- DenseNet
- Deep Layer Aggregation
- Dual Path Network (DPN)
- ECA-ResNet
- EfficientNet
- EfficientNet (Knapsack Pruned)
- Ensemble Adversarial Inception ResNet v2
- ESE-VoVNet (Partial support with static shapes)
- FBNet
- (Gluon) Inception v3
- (Gluon) ResNet
- (Gluon) ResNeXt
- (Gluon) SENet
- (Gluon) SE-ResNeXt
- (Gluon) Xception
- HRNet
- Instagram ResNeXt WSL
- Inception ResNet v2
- Inception v3
- Inception v4
- (Legacy) SE-ResNet
- (Legacy) SE-ResNeXt
- (Legacy) SENet
- MixNet
- MnasNet
- MobileNet v2
- MobileNet v3
- NASNet
- Noisy Student (EfficientNet)
- PNASNet
- RegNetX
- RegNetY
- Res2Net
- Res2NeXt
- ResNeSt
- ResNet
- ResNet-D
- ResNeXt
- RexNet
- SE-ResNet
- SelecSLS
- SE-ResNeXt
- SK-ResNet
- SK-ResNeXt
- SPNASNet
- SSL ResNet
- SWSL ResNet
- SWSL ResNeXt
- TResNet
- Wide ResNet
- Xception

Supported architectures from [Sentence Transformers](https://github.com/UKPLab/sentence-transformers):
- All Transformer and CLIP-based models.