import{s as El,n as Il,o as xl}from"../chunks/scheduler.78382b47.js";import{S as Gl,i as Al,e as o,s as a,c as p,h as Hl,a as s,d as l,b as i,f as Xl,g as m,j as r,k as Rl,l as Nl,m as n,n as f,t as u,o as d,p as h}from"../chunks/index.6dd35eb6.js";import{C as Vl,H as M,E as Yl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8d7e60c0.js";import{C as c}from"../chunks/CodeBlock.4d4112a9.js";function Pl(el){let b,Ft,Lt,Ut,g,Xt,y,Rt,w,ll="Quantization represents data with fewer bits, making it a useful technique for reducing memory-usage and accelerating inference especially when it comes to large language models (LLMs). There are several ways to quantize a model including:",Et,T,nl='<li>optimizing which model weights are quantized with the <a href="https://hf.co/papers/2306.00978" rel="nofollow">AWQ</a> algorithm</li> <li>independently quantizing each row of a weight matrix with the <a href="https://hf.co/papers/2210.17323" rel="nofollow">GPTQ</a> algorithm</li> <li>quantizing to 8-bit and 4-bit precision with the <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> library</li> <li>quantizing to as low as 2-bit precision with the <a href="https://huggingface.co/papers/2401.06118" rel="nofollow">AQLM</a> algorithm</li>',It,J,al='However, after a model is quantized it isn’t typically further trained for downstream tasks because training can be unstable due to the lower precision of the weights and activations. But since PEFT methods only add <em>extra</em> trainable parameters, this allows you to train a quantized model with a PEFT adapter on top! Combining quantization with PEFT can be a good strategy for training even the largest models on a single GPU. For example, <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> is a method that quantizes a model to 4-bits and then trains it with LoRA. This method allows you to finetune a 65B parameter model on a single 48GB GPU!',xt,$,il="In this guide, you’ll see how to quantize a model to 4-bits and train it with LoRA.",Gt,_,At,q,ol='<a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> is a quantization library with a Transformers integration. With this integration, you can quantize a model to 8 or 4-bits and enable many other options by configuring the <a href="https://huggingface.co/docs/transformers/v4.57.1/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">BitsAndBytesConfig</a> class. For example, you can:',Ht,v,sl="<li>set <code>load_in_4bit=True</code> to quantize the model to 4-bits when you load it</li> <li>set <code>bnb_4bit_quant_type=&quot;nf4&quot;</code> to use a special 4-bit data type for weights initialized from a normal distribution</li> <li>set <code>bnb_4bit_use_double_quant=True</code> to use a nested quantization scheme to quantize the already quantized weights</li> <li>set <code>bnb_4bit_compute_dtype=torch.bfloat16</code> to use bfloat16 for faster computation</li>",Nt,j,Vt,Z,rl='Pass the <code>config</code> to the <a href="https://huggingface.co/docs/transformers/v4.57.1/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> method.',Yt,C,Pt,W,pl='Next, you should call the <a href="/docs/peft/v0.18.0.rc0/en/package_reference/peft_model#peft.prepare_model_for_kbit_training">prepare_model_for_kbit_training()</a> function to preprocess the quantized model for training.',St,z,Dt,k,ml="Now that the quantized model is ready, let’s set up a configuration.",Kt,Q,Ot,L,fl='Create a <a href="/docs/peft/v0.18.0.rc0/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> with the following parameters (or choose your own):',te,B,ee,F,ul='Then use the <a href="/docs/peft/v0.18.0.rc0/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function to create a <a href="/docs/peft/v0.18.0.rc0/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> from the quantized model and configuration.',le,U,ne,X,dl="You’re all set for training with whichever training method you prefer!",ae,R,ie,E,hl='<a href="https://hf.co/papers/2310.08659" rel="nofollow">LoftQ</a> initializes LoRA weights such that the quantization error is minimized, and it can improve performance when training quantized models. To get started, follow <a href="https://github.com/huggingface/peft/tree/main/examples/loftq_finetuning" rel="nofollow">these instructions</a>.',oe,I,cl="In general, for LoftQ to work best, it is recommended to target as many layers with LoRA as possible, since those not targeted cannot have LoftQ applied. This means that passing <code>LoraConfig(..., target_modules=&quot;all-linear&quot;)</code> will most likely give the best results. Also, you should use <code>nf4</code> as quant type in your quantization config when using 4bit quantization, i.e. <code>BitsAndBytesConfig(load_in_4bit=True, bnb_4bit_quant_type=&quot;nf4&quot;)</code>.",se,x,re,G,Ml="QLoRA adds trainable weights to all the linear layers in the transformer architecture. Since the attribute names for these linear layers can vary across architectures, set <code>target_modules</code> to <code>&quot;all-linear&quot;</code> to add LoRA to all the linear layers:",pe,A,me,H,fe,N,bl='You can learn more about gptq based <code>[2, 3, 4, 8]</code> bits quantization at <a href="https://github.com/ModelCloud/GPTQModel" rel="nofollow">GPTQModel</a> and the Transformers <a href="https://huggingface.co/docs/transformers/quantization/gptq" rel="nofollow">GPTQ</a> doc. Post-quant training, PEFT can use both <a href="https://github.com/ModelCloud/GPTQModel" rel="nofollow">GPTQModel</a> or <a href="https://github.com/autogptq/autogptq" rel="nofollow">AutoGPTQ</a> libraries, but we recommend GPTQModel because AutoGPTQ will be deprecated in a future release.',ue,V,de,Y,he,P,gl="Once quantized, you can post-train GPTQ models with PEFT APIs.",ce,S,Me,D,yl='Additive Quantization of Language Models (<a href="https://huggingface.co/papers/2401.06118" rel="nofollow">AQLM</a>) is a Large Language Models compression method. It quantizes multiple weights together and takes advantage of interdependencies between them. AQLM represents groups of 8-16 weights as a sum of multiple vector codes. This allows it to compress models down to as low as 2-bit with considerably low accuracy losses.',be,K,wl='Since the AQLM quantization process is computationally expensive, the use of prequantized models is recommended. A partial list of available models can be found in the official aqlm <a href="https://github.com/Vahe1994/AQLM" rel="nofollow">repository</a>.',ge,O,Tl="The models support LoRA adapter tuning. To tune the quantized model you’ll need to install the <code>aqlm</code> inference library: <code>pip install aqlm&gt;=1.0.2</code>. Finetuned LoRA adapters shall be saved separately, as merging them with AQLM quantized weights is not possible.",ye,tt,we,et,Jl='You can refer to the <a href="https://colab.research.google.com/drive/12GTp1FCj5_0SnnNQH18h_2XFh9vS_guX?usp=sharing" rel="nofollow">Google Colab</a> example for an overview of AQLM+LoRA finetuning.',Te,lt,Je,nt,$l='You can also perform LoRA fine-tuning on EETQ quantized models. <a href="https://github.com/NetEase-FuXi/EETQ" rel="nofollow">EETQ</a> package offers simple and efficient way to perform 8-bit quantization, which is claimed to be faster than the <code>LLM.int8()</code> algorithm. First, make sure that you have a transformers version that is compatible with EETQ (e.g. by installing it from latest pypi or from source).',$e,at,_e,it,_l='Pass the <code>config</code> to the <a href="https://huggingface.co/docs/transformers/v4.57.1/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> method.',qe,ot,ve,st,ql="and create a <code>LoraConfig</code> and pass it to <code>get_peft_model</code>:",je,rt,Ze,pt,Ce,mt,vl='The models that are quantized using Half-Quadratic Quantization of Large Machine Learning Models (<a href="https://mobiusml.github.io/hqq_blog/" rel="nofollow">HQQ</a>) support LoRA adapter tuning. To tune the quantized model, you’ll need to install the <code>hqq</code> library with: <code>pip install hqq</code>.',We,ft,ze,ut,jl="Or using transformers version that is compatible with HQQ (e.g. by installing it from latest pypi or from source).",ke,dt,Qe,ht,Le,ct,Zl='PEFT supports models quantized with <a href="https://github.com/pytorch/ao" rel="nofollow">torchao</a> (“ao”) for int8 quantization.',Be,Mt,Fe,bt,Ue,gt,Cl="<li>Use the most recent versions of torchao (&gt;= v0.4.0) and transformers (&gt; 4.42).</li> <li>Only linear layers are currently supported.</li> <li><code>quant_type = &quot;int4_weight_only&quot;</code> is currently not supported.</li> <li><code>NF4</code> is not implemented in transformers as of yet and is thus also not supported.</li> <li>DoRA only works with <code>quant_type = &quot;int8_weight_only&quot;</code> at the moment.</li> <li>There is explicit support for torchao when used with LoRA. However, when torchao quantizes a layer, its class does not change, only the type of the underlying tensor. For this reason, PEFT methods other than LoRA will generally also work with torchao, even if not explicitly supported. Be aware, however, that <strong>merging only works correctly with LoRA and with <code>quant_type = &quot;int8_weight_only&quot;</code></strong>. If you use a different PEFT method or dtype, merging will likely result in an error, and even it doesn’t, the results will still be incorrect.</li>",Xe,yt,Re,wt,Wl=`Intel Neural Compressor (<a href="https://github.com/intel/neural-compressor" rel="nofollow">INC</a>) enables model quantization for various devices,
including Intel Gaudi accelerators (also known as HPU devices). You can perform LoRA fine-tuning on models that have been
quantized using INC. To use INC with PyTorch models, install the library with: <code>pip install neural-compressor[pt]</code>.
Quantizing a model to FP8 precision for HPU devices can be done with the following single-step quantization workflow:`,Ee,Tt,Ie,Jt,zl=`Pass the config to the <code>prepare</code> method, run inference to gather calibration stats, and call <code>finalize_calibration</code>
and <code>convert</code> methods to quantize model to FP8 precision:`,xe,$t,Ge,_t,kl=`An example demonstrating how to load a PEFT LoRA adapter into an INC-quantized FLUX text-to-image model for HPU
devices is provided <a href="https://github.com/huggingface/peft/blob/main/examples/stable_diffusion/inc_flux_lora_hpu.py" rel="nofollow">here</a>.`,Ae,qt,He,vt,Ql="<li><code>merge()</code> and <code>unmerge()</code> methods are currently not supported for INC-quantized models.</li> <li>Currently, only <strong>Linear</strong> INC-quantized layers are supported when loading PEFT adapters.</li>",Ne,jt,Ve,Zt,Ll="Besides LoRA, the following PEFT methods also support quantization:",Ye,Ct,Bl="<li><strong>VeRA</strong> (supports bitsandbytes quantization)</li> <li><strong>AdaLoRA</strong> (supports both bitsandbytes and GPTQ quantization)</li> <li><strong>(IA)³</strong> (supports bitsandbytes quantization)</li>",Pe,Wt,Se,zt,Fl="If you’re interested in learning more about quantization, the following may be helpful:",De,kt,Ul='<li>Learn more details about QLoRA and check out some benchmarks on its impact in the <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">Making LLMs even more accessible with bitsandbytes, 4-bit quantization and QLoRA</a> blog post.</li> <li>Read more about different quantization schemes in the Transformers <a href="https://hf.co/docs/transformers/main/quantization" rel="nofollow">Quantization</a> guide.</li>',Ke,Qt,Oe,Bt,tl;return g=new Vl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),y=new M({props:{title:"Quantization",local:"quantization",headingTag:"h1"}}),_=new M({props:{title:"Quantize a model",local:"quantize-a-model",headingTag:"h2"}}),j=new c({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
)`,wrap:!1}}),C=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=config)`,wrap:!1}}),z=new c({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nJTBBJTBBbW9kZWwlMjAlM0QlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nKG1vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> prepare_model_for_kbit_training

model = prepare_model_for_kbit_training(model)`,wrap:!1}}),Q=new M({props:{title:"LoraConfig",local:"loraconfig",headingTag:"h2"}}),B=new c({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTJDJTIwJTIyb19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4wNSUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)`,wrap:!1}}),U=new c({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBjb25maWcp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model

model = get_peft_model(model, config)`,wrap:!1}}),R=new M({props:{title:"LoftQ initialization",local:"loftq-initialization",headingTag:"h3"}}),x=new M({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),A=new c({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),H=new M({props:{title:"GPTQ quantization",local:"gptq-quantization",headingTag:"h2"}}),V=new c({props:{code:"JTIzJTIwZ3B0cW1vZGVsJTIwaW5zdGFsbCUwQXBpcCUyMGluc3RhbGwlMjBncHRxbW9kZWwlMjAtLW5vLWJ1aWxkLWlzb2xhdGlvbg==",highlighted:`<span class="hljs-comment"># gptqmodel install</span>
pip install gptqmodel --no-build-isolation`,wrap:!1}}),Y=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMEdQVFFDb25maWclMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMmZhY2Vib29rJTJGb3B0LTEyNW0lMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEFncHRxX2NvbmZpZyUyMCUzRCUyMEdQVFFDb25maWcoYml0cyUzRDQlMkMlMjBncm91cF9zaXplJTNEMTI4JTJDJTIwZGF0YXNldCUzRCUyMndpa2l0ZXh0MiUyMiUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciklMEElMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RncHRxX2NvbmZpZyklMEElMEElMjMlMjBzYXZlJTIwcXVhbnRpemVkJTIwbW9kZWwlMEFxdWFudGl6ZWRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMi4lMkZvcHQtMTI1bS1ncHRxJTIyKSUwQXRva2VuaXplci5zYXZlX3ByZXRyYWluZWQoJTIyLiUyRm9wdC0xMjVtLWdwdHElMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, GPTQConfig

model_id = <span class="hljs-string">&quot;facebook/opt-125m&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)

gptq_config = GPTQConfig(bits=<span class="hljs-number">4</span>, group_size=<span class="hljs-number">128</span>, dataset=<span class="hljs-string">&quot;wikitext2&quot;</span>, tokenizer=tokenizer)

quantized_model = AutoModelForCausalLM.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;auto&quot;</span>, quantization_config=gptq_config)

<span class="hljs-comment"># save quantized model</span>
quantized_model.save_pretrained(<span class="hljs-string">&quot;./opt-125m-gptq&quot;</span>)
tokenizer.save_pretrained(<span class="hljs-string">&quot;./opt-125m-gptq&quot;</span>)`,wrap:!1}}),S=new M({props:{title:"AQLM quantization",local:"aqlm-quantization",headingTag:"h2"}}),tt=new c({props:{code:"cXVhbnRpemVkX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkJsYWNrU2Ftb3JleiUyRk1peHRyYWwtOHg3Yi1BUUxNLTJCaXQtMXgxNi1oZi10ZXN0LWRpc3BhdGNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwZHR5cGUlM0QlMjJhdXRvJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUlMkMlMEEpJTBBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiklMEElMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChxdWFudGl6ZWRfbW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyk=",highlighted:`quantized_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;BlackSamorez/Mixtral-8x7b-AQLM-2Bit-1x16-hf-test-dispatch&quot;</span>,
    dtype=<span class="hljs-string">&quot;auto&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, low_cpu_mem_usage=<span class="hljs-literal">True</span>,
)

peft_config = LoraConfig(...)

quantized_model = get_peft_model(quantized_model, peft_config)`,wrap:!1}}),lt=new M({props:{title:"EETQ quantization",local:"eetq-quantization",headingTag:"h2"}}),at=new c({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwRWV0cUNvbmZpZyUwQSUwQWNvbmZpZyUyMCUzRCUyMEVldHFDb25maWcoJTIyaW50OCUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> EetqConfig

config = EetqConfig(<span class="hljs-string">&quot;int8&quot;</span>)`,wrap:!1}}),ot=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=config)`,wrap:!1}}),rt=new c({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0Q4JTJDJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X21vZHVsZXMlM0QlNUIlMjJxX3Byb2olMjIlMkMlMjAlMjJrX3Byb2olMjIlMkMlMjAlMjJ2X3Byb2olMjIlMkMlMjAlMjJvX3Byb2olMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)

model = get_peft_model(model, config)`,wrap:!1}}),pt=new M({props:{title:"HQQ quantization",local:"hqq-quantization",headingTag:"h2"}}),ft=new c({props:{code:"ZnJvbSUyMGhxcS5lbmdpbmUuaGYlMjBpbXBvcnQlMjBIUVFNb2RlbEZvckNhdXNhbExNJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guYWNjZWxlcmF0b3IuY3VycmVudF9hY2NlbGVyYXRvcigpLnR5cGUlMjBpZiUyMGhhc2F0dHIodG9yY2glMkMlMjAlMjJhY2NlbGVyYXRvciUyMiklMjBlbHNlJTIwJTIyY3VkYSUyMiUwQSUwQXF1YW50aXplZF9tb2RlbCUyMCUzRCUyMEhRUU1vZGVsRm9yQ2F1c2FsTE0uZnJvbV9xdWFudGl6ZWQoc2F2ZV9kaXJfb3JfaGZodWIlMkMlMjBkZXZpY2UlM0RkZXZpY2UpJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiklMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChxdWFudGl6ZWRfbW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> hqq.engine.hf <span class="hljs-keyword">import</span> HQQModelForCausalLM

device = torch.accelerator.current_accelerator().<span class="hljs-built_in">type</span> <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(torch, <span class="hljs-string">&quot;accelerator&quot;</span>) <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cuda&quot;</span>

quantized_model = HQQModelForCausalLM.from_quantized(save_dir_or_hfhub, device=device)
peft_config = LoraConfig(...)
quantized_model = get_peft_model(quantized_model, peft_config)`,wrap:!1}}),dt=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhxcUNvbmZpZyUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwSHFxQ29uZmlnKG5iaXRzJTNENCUyQyUyMGdyb3VwX3NpemUlM0Q2NCklMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoc2F2ZV9kaXJfb3JfaGZodWIlMkMlMjBkZXZpY2VfbWFwJTNEZGV2aWNlX21hcCUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWcpJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiklMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChxdWFudGl6ZWRfbW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HqqConfig, AutoModelForCausalLM

quant_config = HqqConfig(nbits=<span class="hljs-number">4</span>, group_size=<span class="hljs-number">64</span>)
quantized_model = AutoModelForCausalLM.from_pretrained(save_dir_or_hfhub, device_map=device_map, quantization_config=quant_config)
peft_config = LoraConfig(...)
quantized_model = get_peft_model(quantized_model, peft_config)`,wrap:!1}}),ht=new M({props:{title:"torchao (PyTorch Architecture Optimization)",local:"torchao-pytorch-architecture-optimization",headingTag:"h2"}}),Mt=new c({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBUb3JjaEFvQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAuLi4lMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwVG9yY2hBb0NvbmZpZyhxdWFudF90eXBlJTNEJTIyaW50OF93ZWlnaHRfb25seSUyMiklMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWcpJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiklMEFtb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, TorchAoConfig

model_id = ...
quantization_config = TorchAoConfig(quant_type=<span class="hljs-string">&quot;int8_weight_only&quot;</span>)
base_model = AutoModelForCausalLM.from_pretrained(model_id, quantization_config=quantization_config)
peft_config = LoraConfig(...)
model = get_peft_model(base_model, peft_config)`,wrap:!1}}),bt=new M({props:{title:"Caveats:",local:"caveats",headingTag:"h3"}}),yt=new M({props:{title:"INC quantization",local:"inc-quantization",headingTag:"h2"}}),Tt=new c({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwbmV1cmFsX2NvbXByZXNzb3IudG9yY2gucXVhbnRpemF0aW9uJTIwaW1wb3J0JTIwRlA4Q29uZmlnJTJDJTIwY29udmVydCUyQyUyMGZpbmFsaXplX2NhbGlicmF0aW9uJTJDJTIwcHJlcGFyZSUwQXF1YW50X2NvbmZpZ3MlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAuLi4lMEElN0QlMEFjb25maWclMjAlM0QlMjBGUDhDb25maWcoKipxdWFudF9jb25maWdzKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> neural_compressor.torch.quantization <span class="hljs-keyword">import</span> FP8Config, convert, finalize_calibration, prepare
quant_configs = {
    ...
}
config = FP8Config(**quant_configs)`,wrap:!1}}),$t=new c({props:{code:"",highlighted:`model = prepare(model, config)
<span class="hljs-comment"># Run inference to collect calibration statistics</span>
...
<span class="hljs-comment"># Finalize calibration and convert the model to FP8 precision</span>
finalize_calibration(model)
model = convert(model)
<span class="hljs-comment"># Load PEFT LoRA adapter as usual</span>
...`,wrap:!1}}),qt=new M({props:{title:"Caveats:",local:"caveats",headingTag:"h3"}}),jt=new M({props:{title:"Other Supported PEFT Methods",local:"other-supported-peft-methods",headingTag:"h2"}}),Wt=new M({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),Qt=new Yl({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/quantization.md"}}),{c(){b=o("meta"),Ft=a(),Lt=o("p"),Ut=a(),p(g.$$.fragment),Xt=a(),p(y.$$.fragment),Rt=a(),w=o("p"),w.textContent=ll,Et=a(),T=o("ul"),T.innerHTML=nl,It=a(),J=o("p"),J.innerHTML=al,xt=a(),$=o("p"),$.textContent=il,Gt=a(),p(_.$$.fragment),At=a(),q=o("p"),q.innerHTML=ol,Ht=a(),v=o("ul"),v.innerHTML=sl,Nt=a(),p(j.$$.fragment),Vt=a(),Z=o("p"),Z.innerHTML=rl,Yt=a(),p(C.$$.fragment),Pt=a(),W=o("p"),W.innerHTML=pl,St=a(),p(z.$$.fragment),Dt=a(),k=o("p"),k.textContent=ml,Kt=a(),p(Q.$$.fragment),Ot=a(),L=o("p"),L.innerHTML=fl,te=a(),p(B.$$.fragment),ee=a(),F=o("p"),F.innerHTML=ul,le=a(),p(U.$$.fragment),ne=a(),X=o("p"),X.textContent=dl,ae=a(),p(R.$$.fragment),ie=a(),E=o("p"),E.innerHTML=hl,oe=a(),I=o("p"),I.innerHTML=cl,se=a(),p(x.$$.fragment),re=a(),G=o("p"),G.innerHTML=Ml,pe=a(),p(A.$$.fragment),me=a(),p(H.$$.fragment),fe=a(),N=o("p"),N.innerHTML=bl,ue=a(),p(V.$$.fragment),de=a(),p(Y.$$.fragment),he=a(),P=o("p"),P.textContent=gl,ce=a(),p(S.$$.fragment),Me=a(),D=o("p"),D.innerHTML=yl,be=a(),K=o("p"),K.innerHTML=wl,ge=a(),O=o("p"),O.innerHTML=Tl,ye=a(),p(tt.$$.fragment),we=a(),et=o("p"),et.innerHTML=Jl,Te=a(),p(lt.$$.fragment),Je=a(),nt=o("p"),nt.innerHTML=$l,$e=a(),p(at.$$.fragment),_e=a(),it=o("p"),it.innerHTML=_l,qe=a(),p(ot.$$.fragment),ve=a(),st=o("p"),st.innerHTML=ql,je=a(),p(rt.$$.fragment),Ze=a(),p(pt.$$.fragment),Ce=a(),mt=o("p"),mt.innerHTML=vl,We=a(),p(ft.$$.fragment),ze=a(),ut=o("p"),ut.textContent=jl,ke=a(),p(dt.$$.fragment),Qe=a(),p(ht.$$.fragment),Le=a(),ct=o("p"),ct.innerHTML=Zl,Be=a(),p(Mt.$$.fragment),Fe=a(),p(bt.$$.fragment),Ue=a(),gt=o("ul"),gt.innerHTML=Cl,Xe=a(),p(yt.$$.fragment),Re=a(),wt=o("p"),wt.innerHTML=Wl,Ee=a(),p(Tt.$$.fragment),Ie=a(),Jt=o("p"),Jt.innerHTML=zl,xe=a(),p($t.$$.fragment),Ge=a(),_t=o("p"),_t.innerHTML=kl,Ae=a(),p(qt.$$.fragment),He=a(),vt=o("ul"),vt.innerHTML=Ql,Ne=a(),p(jt.$$.fragment),Ve=a(),Zt=o("p"),Zt.textContent=Ll,Ye=a(),Ct=o("ul"),Ct.innerHTML=Bl,Pe=a(),p(Wt.$$.fragment),Se=a(),zt=o("p"),zt.textContent=Fl,De=a(),kt=o("ul"),kt.innerHTML=Ul,Ke=a(),p(Qt.$$.fragment),Oe=a(),Bt=o("p"),this.h()},l(t){const e=Hl("svelte-u9bgzb",document.head);b=s(e,"META",{name:!0,content:!0}),e.forEach(l),Ft=i(t),Lt=s(t,"P",{}),Xl(Lt).forEach(l),Ut=i(t),m(g.$$.fragment,t),Xt=i(t),m(y.$$.fragment,t),Rt=i(t),w=s(t,"P",{"data-svelte-h":!0}),r(w)!=="svelte-famg4s"&&(w.textContent=ll),Et=i(t),T=s(t,"UL",{"data-svelte-h":!0}),r(T)!=="svelte-1hhuofo"&&(T.innerHTML=nl),It=i(t),J=s(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-142xot4"&&(J.innerHTML=al),xt=i(t),$=s(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-1demhiu"&&($.textContent=il),Gt=i(t),m(_.$$.fragment,t),At=i(t),q=s(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1w3vp62"&&(q.innerHTML=ol),Ht=i(t),v=s(t,"UL",{"data-svelte-h":!0}),r(v)!=="svelte-hfynw8"&&(v.innerHTML=sl),Nt=i(t),m(j.$$.fragment,t),Vt=i(t),Z=s(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-13w70lw"&&(Z.innerHTML=rl),Yt=i(t),m(C.$$.fragment,t),Pt=i(t),W=s(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1a2swgr"&&(W.innerHTML=pl),St=i(t),m(z.$$.fragment,t),Dt=i(t),k=s(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-11mx7fc"&&(k.textContent=ml),Kt=i(t),m(Q.$$.fragment,t),Ot=i(t),L=s(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-150tzsp"&&(L.innerHTML=fl),te=i(t),m(B.$$.fragment,t),ee=i(t),F=s(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1lvtk8w"&&(F.innerHTML=ul),le=i(t),m(U.$$.fragment,t),ne=i(t),X=s(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-xd402n"&&(X.textContent=dl),ae=i(t),m(R.$$.fragment,t),ie=i(t),E=s(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-f32n60"&&(E.innerHTML=hl),oe=i(t),I=s(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-7f0aai"&&(I.innerHTML=cl),se=i(t),m(x.$$.fragment,t),re=i(t),G=s(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1c7jiea"&&(G.innerHTML=Ml),pe=i(t),m(A.$$.fragment,t),me=i(t),m(H.$$.fragment,t),fe=i(t),N=s(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-waooev"&&(N.innerHTML=bl),ue=i(t),m(V.$$.fragment,t),de=i(t),m(Y.$$.fragment,t),he=i(t),P=s(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-lqq230"&&(P.textContent=gl),ce=i(t),m(S.$$.fragment,t),Me=i(t),D=s(t,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1myyhap"&&(D.innerHTML=yl),be=i(t),K=s(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1qhybjf"&&(K.innerHTML=wl),ge=i(t),O=s(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-wlm3ol"&&(O.innerHTML=Tl),ye=i(t),m(tt.$$.fragment,t),we=i(t),et=s(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1f1bzer"&&(et.innerHTML=Jl),Te=i(t),m(lt.$$.fragment,t),Je=i(t),nt=s(t,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-16tz5mo"&&(nt.innerHTML=$l),$e=i(t),m(at.$$.fragment,t),_e=i(t),it=s(t,"P",{"data-svelte-h":!0}),r(it)!=="svelte-13w70lw"&&(it.innerHTML=_l),qe=i(t),m(ot.$$.fragment,t),ve=i(t),st=s(t,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1wgonl8"&&(st.innerHTML=ql),je=i(t),m(rt.$$.fragment,t),Ze=i(t),m(pt.$$.fragment,t),Ce=i(t),mt=s(t,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-1yzgecf"&&(mt.innerHTML=vl),We=i(t),m(ft.$$.fragment,t),ze=i(t),ut=s(t,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-p9acs7"&&(ut.textContent=jl),ke=i(t),m(dt.$$.fragment,t),Qe=i(t),m(ht.$$.fragment,t),Le=i(t),ct=s(t,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-gynv46"&&(ct.innerHTML=Zl),Be=i(t),m(Mt.$$.fragment,t),Fe=i(t),m(bt.$$.fragment,t),Ue=i(t),gt=s(t,"UL",{"data-svelte-h":!0}),r(gt)!=="svelte-4si0iy"&&(gt.innerHTML=Cl),Xe=i(t),m(yt.$$.fragment,t),Re=i(t),wt=s(t,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-8d7dps"&&(wt.innerHTML=Wl),Ee=i(t),m(Tt.$$.fragment,t),Ie=i(t),Jt=s(t,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-10yr85u"&&(Jt.innerHTML=zl),xe=i(t),m($t.$$.fragment,t),Ge=i(t),_t=s(t,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-1ugpcug"&&(_t.innerHTML=kl),Ae=i(t),m(qt.$$.fragment,t),He=i(t),vt=s(t,"UL",{"data-svelte-h":!0}),r(vt)!=="svelte-h65blx"&&(vt.innerHTML=Ql),Ne=i(t),m(jt.$$.fragment,t),Ve=i(t),Zt=s(t,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-14evo3v"&&(Zt.textContent=Ll),Ye=i(t),Ct=s(t,"UL",{"data-svelte-h":!0}),r(Ct)!=="svelte-ro48c4"&&(Ct.innerHTML=Bl),Pe=i(t),m(Wt.$$.fragment,t),Se=i(t),zt=s(t,"P",{"data-svelte-h":!0}),r(zt)!=="svelte-agdyn7"&&(zt.textContent=Fl),De=i(t),kt=s(t,"UL",{"data-svelte-h":!0}),r(kt)!=="svelte-10zqaf7"&&(kt.innerHTML=Ul),Ke=i(t),m(Qt.$$.fragment,t),Oe=i(t),Bt=s(t,"P",{}),Xl(Bt).forEach(l),this.h()},h(){Rl(b,"name","hf:doc:metadata"),Rl(b,"content",Sl)},m(t,e){Nl(document.head,b),n(t,Ft,e),n(t,Lt,e),n(t,Ut,e),f(g,t,e),n(t,Xt,e),f(y,t,e),n(t,Rt,e),n(t,w,e),n(t,Et,e),n(t,T,e),n(t,It,e),n(t,J,e),n(t,xt,e),n(t,$,e),n(t,Gt,e),f(_,t,e),n(t,At,e),n(t,q,e),n(t,Ht,e),n(t,v,e),n(t,Nt,e),f(j,t,e),n(t,Vt,e),n(t,Z,e),n(t,Yt,e),f(C,t,e),n(t,Pt,e),n(t,W,e),n(t,St,e),f(z,t,e),n(t,Dt,e),n(t,k,e),n(t,Kt,e),f(Q,t,e),n(t,Ot,e),n(t,L,e),n(t,te,e),f(B,t,e),n(t,ee,e),n(t,F,e),n(t,le,e),f(U,t,e),n(t,ne,e),n(t,X,e),n(t,ae,e),f(R,t,e),n(t,ie,e),n(t,E,e),n(t,oe,e),n(t,I,e),n(t,se,e),f(x,t,e),n(t,re,e),n(t,G,e),n(t,pe,e),f(A,t,e),n(t,me,e),f(H,t,e),n(t,fe,e),n(t,N,e),n(t,ue,e),f(V,t,e),n(t,de,e),f(Y,t,e),n(t,he,e),n(t,P,e),n(t,ce,e),f(S,t,e),n(t,Me,e),n(t,D,e),n(t,be,e),n(t,K,e),n(t,ge,e),n(t,O,e),n(t,ye,e),f(tt,t,e),n(t,we,e),n(t,et,e),n(t,Te,e),f(lt,t,e),n(t,Je,e),n(t,nt,e),n(t,$e,e),f(at,t,e),n(t,_e,e),n(t,it,e),n(t,qe,e),f(ot,t,e),n(t,ve,e),n(t,st,e),n(t,je,e),f(rt,t,e),n(t,Ze,e),f(pt,t,e),n(t,Ce,e),n(t,mt,e),n(t,We,e),f(ft,t,e),n(t,ze,e),n(t,ut,e),n(t,ke,e),f(dt,t,e),n(t,Qe,e),f(ht,t,e),n(t,Le,e),n(t,ct,e),n(t,Be,e),f(Mt,t,e),n(t,Fe,e),f(bt,t,e),n(t,Ue,e),n(t,gt,e),n(t,Xe,e),f(yt,t,e),n(t,Re,e),n(t,wt,e),n(t,Ee,e),f(Tt,t,e),n(t,Ie,e),n(t,Jt,e),n(t,xe,e),f($t,t,e),n(t,Ge,e),n(t,_t,e),n(t,Ae,e),f(qt,t,e),n(t,He,e),n(t,vt,e),n(t,Ne,e),f(jt,t,e),n(t,Ve,e),n(t,Zt,e),n(t,Ye,e),n(t,Ct,e),n(t,Pe,e),f(Wt,t,e),n(t,Se,e),n(t,zt,e),n(t,De,e),n(t,kt,e),n(t,Ke,e),f(Qt,t,e),n(t,Oe,e),n(t,Bt,e),tl=!0},p:Il,i(t){tl||(u(g.$$.fragment,t),u(y.$$.fragment,t),u(_.$$.fragment,t),u(j.$$.fragment,t),u(C.$$.fragment,t),u(z.$$.fragment,t),u(Q.$$.fragment,t),u(B.$$.fragment,t),u(U.$$.fragment,t),u(R.$$.fragment,t),u(x.$$.fragment,t),u(A.$$.fragment,t),u(H.$$.fragment,t),u(V.$$.fragment,t),u(Y.$$.fragment,t),u(S.$$.fragment,t),u(tt.$$.fragment,t),u(lt.$$.fragment,t),u(at.$$.fragment,t),u(ot.$$.fragment,t),u(rt.$$.fragment,t),u(pt.$$.fragment,t),u(ft.$$.fragment,t),u(dt.$$.fragment,t),u(ht.$$.fragment,t),u(Mt.$$.fragment,t),u(bt.$$.fragment,t),u(yt.$$.fragment,t),u(Tt.$$.fragment,t),u($t.$$.fragment,t),u(qt.$$.fragment,t),u(jt.$$.fragment,t),u(Wt.$$.fragment,t),u(Qt.$$.fragment,t),tl=!0)},o(t){d(g.$$.fragment,t),d(y.$$.fragment,t),d(_.$$.fragment,t),d(j.$$.fragment,t),d(C.$$.fragment,t),d(z.$$.fragment,t),d(Q.$$.fragment,t),d(B.$$.fragment,t),d(U.$$.fragment,t),d(R.$$.fragment,t),d(x.$$.fragment,t),d(A.$$.fragment,t),d(H.$$.fragment,t),d(V.$$.fragment,t),d(Y.$$.fragment,t),d(S.$$.fragment,t),d(tt.$$.fragment,t),d(lt.$$.fragment,t),d(at.$$.fragment,t),d(ot.$$.fragment,t),d(rt.$$.fragment,t),d(pt.$$.fragment,t),d(ft.$$.fragment,t),d(dt.$$.fragment,t),d(ht.$$.fragment,t),d(Mt.$$.fragment,t),d(bt.$$.fragment,t),d(yt.$$.fragment,t),d(Tt.$$.fragment,t),d($t.$$.fragment,t),d(qt.$$.fragment,t),d(jt.$$.fragment,t),d(Wt.$$.fragment,t),d(Qt.$$.fragment,t),tl=!1},d(t){t&&(l(Ft),l(Lt),l(Ut),l(Xt),l(Rt),l(w),l(Et),l(T),l(It),l(J),l(xt),l($),l(Gt),l(At),l(q),l(Ht),l(v),l(Nt),l(Vt),l(Z),l(Yt),l(Pt),l(W),l(St),l(Dt),l(k),l(Kt),l(Ot),l(L),l(te),l(ee),l(F),l(le),l(ne),l(X),l(ae),l(ie),l(E),l(oe),l(I),l(se),l(re),l(G),l(pe),l(me),l(fe),l(N),l(ue),l(de),l(he),l(P),l(ce),l(Me),l(D),l(be),l(K),l(ge),l(O),l(ye),l(we),l(et),l(Te),l(Je),l(nt),l($e),l(_e),l(it),l(qe),l(ve),l(st),l(je),l(Ze),l(Ce),l(mt),l(We),l(ze),l(ut),l(ke),l(Qe),l(Le),l(ct),l(Be),l(Fe),l(Ue),l(gt),l(Xe),l(Re),l(wt),l(Ee),l(Ie),l(Jt),l(xe),l(Ge),l(_t),l(Ae),l(He),l(vt),l(Ne),l(Ve),l(Zt),l(Ye),l(Ct),l(Pe),l(Se),l(zt),l(De),l(kt),l(Ke),l(Oe),l(Bt)),l(b),h(g,t),h(y,t),h(_,t),h(j,t),h(C,t),h(z,t),h(Q,t),h(B,t),h(U,t),h(R,t),h(x,t),h(A,t),h(H,t),h(V,t),h(Y,t),h(S,t),h(tt,t),h(lt,t),h(at,t),h(ot,t),h(rt,t),h(pt,t),h(ft,t),h(dt,t),h(ht,t),h(Mt,t),h(bt,t),h(yt,t),h(Tt,t),h($t,t),h(qt,t),h(jt,t),h(Wt,t),h(Qt,t)}}}const Sl='{"title":"Quantization","local":"quantization","sections":[{"title":"Quantize a model","local":"quantize-a-model","sections":[],"depth":2},{"title":"LoraConfig","local":"loraconfig","sections":[{"title":"LoftQ initialization","local":"loftq-initialization","sections":[],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3}],"depth":2},{"title":"GPTQ quantization","local":"gptq-quantization","sections":[],"depth":2},{"title":"AQLM quantization","local":"aqlm-quantization","sections":[],"depth":2},{"title":"EETQ quantization","local":"eetq-quantization","sections":[],"depth":2},{"title":"HQQ quantization","local":"hqq-quantization","sections":[],"depth":2},{"title":"torchao (PyTorch Architecture Optimization)","local":"torchao-pytorch-architecture-optimization","sections":[{"title":"Caveats:","local":"caveats","sections":[],"depth":3}],"depth":2},{"title":"INC quantization","local":"inc-quantization","sections":[{"title":"Caveats:","local":"caveats","sections":[],"depth":3}],"depth":2},{"title":"Other Supported PEFT Methods","local":"other-supported-peft-methods","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Dl(el){return xl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ln extends Gl{constructor(b){super(),Al(this,b,Dl,Pl,El,{})}}export{ln as component};
