import{s as un,n as cn,o as yn}from"../chunks/scheduler.78382b47.js";import{S as gn,i as bn,e as i,s,c as p,h as wn,a as o,d as l,b as n,f as hn,g as d,j as r,k as Ct,l as Mn,m as a,n as m,t as f,o as h,p as u}from"../chunks/index.6dd35eb6.js";import{C as Tn,H as y,E as _n}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8d7e60c0.js";import{C as c}from"../chunks/CodeBlock.4d4112a9.js";function vn(Na){let g,Bt,Ut,Gt,v,Lt,$,Ft,j,Aa="If you encounter any issue when using PEFT, please check the following list of common issues and their solutions.",Rt,k,It,x,Sa="Examples often rely on the most recent package versions, so please ensure they’re up-to-date. In particular, check the following package versions:",Xt,J,Ka="<li><code>peft</code></li> <li><code>transformers</code></li> <li><code>accelerate</code></li> <li><code>torch</code></li>",Vt,Z,Da="In general, you can update the package version by running this command inside your Python environment:",Ht,C,Et,U,Oa="Installing PEFT from source is useful for keeping up with the latest developments:",Yt,W,Pt,B,qt,G,Qt,L,es='This error probably occurred because the model was loaded with <code>dtype=torch.float16</code> and then used in an automatic mixed precision (AMP) context, e.g. by setting <code>fp16=True</code> in the <a href="https://huggingface.co/docs/transformers/v4.57.1/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> class from 🤗 Transformers. The reason is that when using AMP, trainable weights should never use fp16. To make this work without loading the whole model in fp32, add the following to your code:',zt,F,Nt,R,ts='Alternatively, you can use the <a href="/docs/peft/v0.18.0.rc0/en/package_reference/peft_model#peft.cast_mixed_precision_params">cast_mixed_precision_params()</a> function to correctly cast the weights:',At,I,St,b,ls='<p>Starting from PEFT version v0.12.0, PEFT automatically promotes the dtype of adapter weights from <code>torch.float16</code> and <code>torch.bfloat16</code> to <code>torch.float32</code> where appropriate. To <em>prevent</em> this behavior, you can pass <code>autocast_adapter_dtype=False</code> to <a href="/docs/peft/v0.18.0.rc0/en/package_reference/peft_model#peft.get_peft_model">~get_peft_model()</a>, to <a href="/docs/peft/v0.18.0.rc0/en/package_reference/peft_model#peft.PeftModel.from_pretrained">from_pretrained()</a>, and to <a href="/docs/peft/v0.18.0.rc0/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>.</p>',Kt,X,Dt,V,as="Most PEFT methods, like LoRA, work by adding trainable adapter weights. By default, those weights are stored in float32 dtype (fp32), i.e. at a relatively high precision. Therefore, even if the base model is loaded in float16 (fp16) or bfloat16 (bf16), the adapter weights are float32. When the adapter results are calculated during the forward pass, the input will typically be in the dtype of the base model, thus it will be upcast to float32 if necessary, then cast back to the original dtype.",Ot,H,ss='If you prefer to have the adapter weights in the lower precision of the base model, i.e. in float16 or bfloat16, you can pass <code>autocast_adapter_dtype=False</code> when creating the model (<a href="/docs/peft/v0.18.0.rc0/en/package_reference/peft_model#peft.get_peft_model">~get_peft_model()</a>) or loading the model (<a href="/docs/peft/v0.18.0.rc0/en/package_reference/peft_model#peft.PeftModel.from_pretrained">from_pretrained()</a>). There are some advantages and disadvantages to this:',el,E,ns="Advantages of half precision adapter:",tl,Y,is="<li>computation slightly faster</li> <li>slightly less memory</li> <li>smaller file size of checkpoint (half the size)</li>",ll,P,os="Disadvantages of half precision adapter:",al,q,rs="<li>slightly worse loss</li> <li>higher risk of overflow or underflow</li>",sl,Q,ps="Note that for most use cases, overall runtime and memory cost will be determined by the size of the base model and by the dataset, while the dtype of the PEFT adapter will only have a small impact.",nl,z,il,N,ds='There can be several reasons for getting a poor result from a loaded PEFT model which are listed below. If you’re still unable to troubleshoot the problem, see if anyone else had a similar <a href="https://github.com/huggingface/peft/issues" rel="nofollow">issue</a> on GitHub, and if you can’t find any, open a new issue.',ol,A,ms="When opening an issue, it helps a lot if you provide a minimal code example that reproduces the issue. Also, please report if the loaded model performs at the same level as the model did before fine-tuning, if it performs at a random level, or if it is only slightly worse than expected. This information helps us identify the problem more quickly.",rl,S,pl,K,fs="If your model outputs are not exactly the same as previous runs, there could be an issue with random elements. For example:",dl,D,hs='<li>please ensure it is in <code>.eval()</code> mode, which is important, for instance, if the model uses dropout</li> <li>if you use <a href="https://huggingface.co/docs/transformers/v4.57.1/en/main_classes/text_generation#transformers.GenerationMixin.generate" rel="nofollow">generate</a> on a language model, there could be random sampling, so obtaining the same result requires setting a random seed</li> <li>if you used quantization and merged the weights, small deviations are expected due to rounding errors</li>',ml,O,fl,ee,us='Please ensure that you load the model correctly. A common error is trying to load a <em>trained</em> model with <a href="/docs/peft/v0.18.0.rc0/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> which is incorrect. Instead, the loading code should look like this:',hl,te,ul,le,cl,ae,cs="For some tasks, it is important to correctly configure <code>modules_to_save</code> in the config to account for randomly initialized layers.",yl,se,ys="As an example, this is necessary if you use LoRA to fine-tune a language model for sequence classification because 🤗 Transformers adds a randomly initialized classification head on top of the model. If you do not add this layer to <code>modules_to_save</code>, the classification head won’t be saved. The next time you load the model, you’ll get a <em>different</em> randomly initialized classification head, resulting in completely different results.",gl,ne,gs="PEFT tries to correctly guess the <code>modules_to_save</code> if you provide the <code>task_type</code> argument in the config. This should work for transformers models that follow the standard naming scheme. It is always a good idea to double check though because we can’t guarantee all models follow the naming scheme.",bl,ie,bs="When you load a transformers model that has randomly initialized layers, you should see a warning along the lines of:",wl,oe,Ml,re,ws="The mentioned layers should be added to <code>modules_to_save</code> in the config to avoid the described problem.",Tl,w,Ms="<p>As an example, when loading a model that is using the DeBERTa architecture for sequence classification, you’ll see a warning that the following weights are newly initialized: <code>[&#39;classifier.bias&#39;, &#39;classifier.weight&#39;, &#39;pooler.dense.bias&#39;, &#39;pooler.dense.weight&#39;]</code>. From this, it follows that the <code>classifier</code> and <code>pooler</code> layers should be added to: <code>modules_to_save=[&quot;classifier&quot;, &quot;pooler&quot;]</code>.</p>",_l,pe,vl,de,Ts="For many language fine-tuning tasks, extending the model’s vocabulary is necessary since new tokens are being introduced. This requires extending the embedding layer to account for the new tokens and, depending on the fine-tuning method, also storing the embedding layer in addition to the adapter weights when saving the adapter. There are a few ways of achieving this ordered by parameter effectiveness:",$l,me,_s='<li><a href="../package_reference/trainable_tokens">trainable tokens</a>, train only the specified tokens, optionally store only the updated values</li> <li>training an adapter on the embedding matrix, optionally store only the updated values</li> <li>full-finetuning of the embedding layer</li>',jl,fe,kl,he,vs='Let’s start with trainable tokens, in this case its <a href="../developer_guides/lora#efficiently-train-tokens-alongside-lora">LoRA integration</a>.  If you’re interested in only training the new embeddings and nothing else, refer to the <a href="../package_reference/trainable_tokens">standalone documentation</a>.',xl,ue,$s="To enable selective token training of the embedding layer, you’ll need to supply the token ids of your newly added tokens via the <code>trainable_token_indices</code> parameter.  Optionally you can specify which layer to target if there is more than one embedding layer. For a Mistral model this could look like this:",Jl,ce,Zl,ye,js="If your model uses tied weights (such as the <code>lm_head</code>), trainable tokens will try to resolve those and keep them updated as well, so in that case there should be no need for adding <code>modules_to_save=[&quot;lm_head&quot;]</code>. This only works if the model uses the Transformers convention for tying weights.",Cl,ge,ks=`Saving the model with <code>model.save_pretrained</code> may save the full embedding matrix instead of
only the difference as a precaution because the embedding matrix was resized. To save space you can disable this behavior by setting <code>save_embedding_layers=False</code> when calling <code>save_pretrained</code>. This is safe to do as long as you don’t modify the embedding matrix through other means as well, as such changes will be not tracked by trainable tokens.`,Ul,be,Wl,we,xs="Prepare the embedding layer by adding it to the <code>target_modules</code> of your adapter config. For example, the Mistral config could look like this:",Bl,Me,Gl,Te,Js="Once added to <code>target_modules</code>, PEFT automatically stores the embedding layer when saving the adapter if the model has the <code>get_input_embeddings</code> and <code>get_output_embeddings</code>. This is generally the case for Transformers models.",Ll,_e,Zs="If the model’s embedding layer doesn’t follow the Transformer’s naming scheme but nevertheless implements <code>get_input_embeddings</code>, you can still save it by manually passing <code>save_embedding_layers=True</code> when saving the adapter:",Fl,ve,Rl,$e,Cs="For inference, load the base model first and resize it the same way you did before you trained the model. After you’ve resized the base model, you can load the PEFT checkpoint.",Il,je,Us='For a complete example, please check out <a href="https://github.com/huggingface/peft/blob/main/examples/causal_language_modeling/peft_lora_clm_with_additional_tokens.ipynb" rel="nofollow">this notebook</a>.',Xl,ke,Vl,xe,Ws="Full fine-tuning is more costly in terms of VRAM or storage space but if all else fails, you can fall back to this and see if it works for you. Achieve it by adding the name of the embedding layer to <code>modules_to_save</code>. Note that you need to add tied layers as well, e.g. <code>lm_head</code>. Example for a Mistral model with LoRA:",Hl,Je,El,Ze,Yl,Ce,Bs="When you load your PEFT model which has been trained on a task (for example, classification), you may get a warning like:",Pl,Ue,Gs="<p>Some weights of LlamaForSequenceClassification were not initialized from the model checkpoint at meta-llama/Llama-3.2-1B and are newly initialized: [‘score.weight’]. You should probably TRAIN this model on a down-stream task to be able to use it for predictions and inference.</p>",ql,We,Ls="Although this looks scary, it is most likely nothing to worry about. This warning comes from Transformers, and it isn’t a PEFT specific warning. It lets you know that a randomly initialized classification head (<code>score</code>) is attached to the base model, and the head must be trained to produce sensible predictions.",Ql,Be,Fs="When you get this warning <em>before</em> training the model, PEFT automatically takes care of making the classification head trainable if you correctly passed the <code>task_type</code> argument to the PEFT config.",zl,Ge,Nl,Le,Rs="If your classification head does not follow the usual naming conventions from Transformers (which is rare), you have to explicitly tell PEFT the name of the head in <code>modules_to_save</code>.",Al,Fe,Sl,Re,Is="To check the name of the classification head, print the model and it should be the last module.",Kl,Ie,Xs="If you get this warning from your inference code, i.e. <em>after</em> training the model, when you load the PEFT model, you always have to load the Transformers model first. Since Transformers does not know that you will load PEFT weights afterwards, it still gives the warning.",Dl,Xe,Vs="As always, it is best practice to ensure the model works correctly for inference by running some validation on it.",Ol,Ve,ea,He,Hs='Sometimes a PEFT model can end up in a bad state, especially when handling multiple adapters. There can be some confusion around what adapters exist, which one is active, which one is merged, etc. To help investigate this issue, call the <a href="/docs/peft/v0.18.0.rc0/en/package_reference/peft_model#peft.PeftModel.get_layer_status">get_layer_status()</a> and the <a href="/docs/peft/v0.18.0.rc0/en/package_reference/peft_model#peft.PeftModel.get_model_status">get_model_status()</a> methods.',ta,Ee,Es='The <a href="/docs/peft/v0.18.0.rc0/en/package_reference/peft_model#peft.PeftModel.get_layer_status">get_layer_status()</a> method gives you a detailed overview of each targeted layer’s active, merged, and available adapters.',la,Ye,aa,Pe,Ys="In the model state output, you should look out for entries that say <code>&quot;irregular&quot;</code>. This means PEFT detected an inconsistent state in the model. For instance, if <code>merged_adapters=&quot;irregular&quot;</code>, it means that for at least one adapter, it was merged on some target modules but not on others. The inference results will most likely be incorrect as a result.",sa,qe,Ps="The best way to resolve this issue is to reload the whole model and adapter checkpoint(s). Ensure that you don’t perform any incorrect operations on the model, e.g. manually merging adapters on some modules but not others.",na,Qe,qs="Convert the layer status into a pandas <code>DataFrame</code> for an easier visual inspection.",ia,ze,oa,Ne,Qs='It is possible to get this information for non-PEFT models if they are using PEFT layers under the hood, but some information like the <code>base_model_type</code> or the <code>peft_types</code> cannot be determined in that case. As an example, you can call this on a <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">diffusers</a> model like so:',ra,Ae,pa,Se,da,Ke,ma,De,zs='Loading adapters like LoRA weights should generally be fast compared to loading the base model. However, there can be use cases where the adapter weights are quite large or where users need to load a large number of adapters — the loading time can add up in this case. The reason for this is that the adapter weights are first initialized and then overridden by the loaded weights, which is wasteful. To speed up the loading time, you can pass the <code>low_cpu_mem_usage=True</code> argument to <a href="/docs/peft/v0.18.0.rc0/en/package_reference/peft_model#peft.PeftModel.from_pretrained">from_pretrained()</a> and <a href="/docs/peft/v0.18.0.rc0/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>.',fa,M,Ns="<p>If this option works well across different use cases, it may become the default for adapter loading in the future.</p>",ha,Oe,ua,et,ca,tt,As="When loading a trained PEFT model where the base model uses batch norm (e.g. <code>torch.nn.BatchNorm1d</code> or <code>torch.nn.BatchNorm2d</code>), you may find that you cannot reproduce the exact same outputs. This is because the batch norm layers keep track of running stats during training, but these stats are not part of the PEFT checkpoint. Therefore, when you load the PEFT model, the running stats of the base model will be used (i.e. from before training with PEFT).",ya,lt,Ss="Depending on your use case, this may not be a big deal. If, however, you need your outputs to be 100% reproducible, you can achieve this by adding the batch norm layers to <code>modules_to_save</code>. Below is an example of this using resnet and LoRA. Notice that we set <code>modules_to_save=[&quot;classifier&quot;, &quot;normalization&quot;]</code>. We need the <code>&quot;classifier&quot;</code> argument because our task is image classification, and we add the <code>&quot;normalization&quot;</code> argument to ensure that the batch norm layers are saved in the PEFT checkpoint.",ga,at,ba,st,Ks="Depending on the type of model you use, the batch norm layers could have different names than <code>&quot;normalization&quot;</code>, so please ensure that the name matches your model architecture.",wa,nt,Ma,it,Ta,ot,Ds="When you encounter an error like the one shown below, it means the adapter you’re trying to load was trained with a more recent version of PEFT than the version you have installed on your system.",_a,rt,va,pt,Os="The best way to resolve this issue is to install the latest PEFT version:",$a,dt,ja,mt,en="If the adapter was trained from a source install of PEFT (an unreleased version of PEFT), then you also need to install PEFT from source.",ka,ft,xa,ht,tn="If it is not possible for you to upgrade PEFT, there is a workaround you can try.",Ja,ut,ln="Assume the error message says that the unknown keyword argument is named <code>foobar</code>. Search inside the <code>adapter_config.json</code> of this PEFT adapter for the <code>foobar</code> entry and delete it from the file. Then save the file and try loading the model again.",Za,ct,an="This solution works most of the time. As long as it is the default value for <code>foobar</code>, it can be ignored. However, when it is set to some other value, you will get incorrect results. Upgrading PEFT is the recommended solution.",Ca,yt,Ua,gt,Wa,bt,sn="PEFT allows you to create more than one adapter on the same model. This can be useful in many situations. For example, for inference, you may want to serve two fine-tuned models from the same base model instead of loading the base model once for each fine-tuned model, which would cost more memory. However, multiple adapters can be activated at the same time. This way, the model may leverage the learnings from all those adapters at the same time. As an example, if you have a diffusion model, you may want to use one LoRA adapter to change the style and a different one to change the subject.",Ba,wt,nn="Activating multiple adapters at the same time is generally possible on all PEFT methods (LoRA, LoHa, IA³, etc.) except for prompt learning methods (p-tuning, prefix tuning, etc.). The following example illustrates how to achieve this:",Ga,Mt,La,T,on="<p>In the example above, you can see that we need to call <code>model.base_model.set_adapter([&quot;default&quot;, &quot;other&quot;])</code>. Why can we not call <code>model.set_adapter([&quot;default&quot;, &quot;other&quot;])</code>? This is unfortunately not possible because, as explained earlier, some PEFT methods don’t support activating more than one adapter at a time.</p>",Fa,Tt,rn="It is also possible to train two adapters at the same time, but you should be careful to ensure that the weights of both adapters are known to the optimizer. Otherwise, only one adapter will receive updates.",Ra,_t,Ia,vt,pn="If we would now call:",Xa,$t,Va,jt,dn="or",Ha,kt,Ea,xt,mn="then the second LoRA adapter (<code>&quot;other&quot;</code>) would not be trained. This is because it is inactive at this moment, which means the <code>requires_grad</code> attribute on its parameters is set to <code>False</code> and the optimizer will ignore it. Therefore, make sure to activate all adapters that should be trained <em>before</em> initializing the optimizer:",Ya,Jt,Pa,_,fn='<p>This section deals with using multiple adapters <em>of the same type</em> on the same model, for example, using multiple LoRA adapters at the same time. It does not apply to using <em>different types</em> of adapters on the same model, for example one LoRA adapter and one LoHa adapter. For this, please check <a href="https://huggingface.co/docs/peft/developer_guides/mixed_models" rel="nofollow"><code>PeftMixedModel</code></a>.</p>',qa,Zt,Qa,Wt,za;return v=new Tn({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),$=new y({props:{title:"Troubleshooting",local:"troubleshooting",headingTag:"h1"}}),k=new y({props:{title:"Examples don’t work",local:"examples-dont-work",headingTag:"h2"}}),C=new c({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwLVUlMjAlM0NwYWNrYWdlX25hbWUlM0U=",highlighted:"python -m pip install -U &lt;package_name&gt;",wrap:!1}}),W=new c({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwZ2l0JTJCaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZwZWZ0",highlighted:"python -m pip install git+https://github.com/huggingface/peft",wrap:!1}}),B=new y({props:{title:"Dtype-related issues",local:"dtype-related-issues",headingTag:"h2"}}),G=new y({props:{title:"ValueError: Attempting to unscale FP16 gradients",local:"valueerror-attempting-to-unscale-fp16-gradients",headingTag:"h3"}}),F=new c({props:{code:"cGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKC4uLiklMEElMEElMjMlMjBhZGQlMjB0aGlzJTNBJTBBZm9yJTIwcGFyYW0lMjBpbiUyMG1vZGVsLnBhcmFtZXRlcnMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwcGFyYW0ucmVxdWlyZXNfZ3JhZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhcmFtLmRhdGElMjAlM0QlMjBwYXJhbS5kYXRhLmZsb2F0KCklMEElMEElMjMlMjBwcm9jZWVkJTIwYXMlMjB1c3VhbCUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKG1vZGVsJTNEcGVmdF9tb2RlbCUyQyUyMGZwMTYlM0RUcnVlJTJDJTIwLi4uKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`peft_model = get_peft_model(...)

<span class="hljs-comment"># add this:</span>
<span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.parameters():
    <span class="hljs-keyword">if</span> param.requires_grad:
        param.data = param.data.<span class="hljs-built_in">float</span>()

<span class="hljs-comment"># proceed as usual</span>
trainer = Trainer(model=peft_model, fp16=<span class="hljs-literal">True</span>, ...)
trainer.train()`,wrap:!1}}),I=new c({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBjYXN0X21peGVkX3ByZWNpc2lvbl9wYXJhbXMlMEElMEFwZWZ0X21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwoLi4uKSUwQWNhc3RfbWl4ZWRfcHJlY2lzaW9uX3BhcmFtcyhwZWZ0X21vZGVsJTJDJTIwZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQSUyMyUyMHByb2NlZWQlMjBhcyUyMHVzdWFsJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIobW9kZWwlM0RwZWZ0X21vZGVsJTJDJTIwZnAxNiUzRFRydWUlMkMlMjAuLi4pJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> cast_mixed_precision_params

peft_model = get_peft_model(...)
cast_mixed_precision_params(peft_model, dtype=torch.float16)

<span class="hljs-comment"># proceed as usual</span>
trainer = Trainer(model=peft_model, fp16=<span class="hljs-literal">True</span>, ...)
trainer.train()`,wrap:!1}}),X=new y({props:{title:"Selecting the dtype of the adapter",local:"selecting-the-dtype-of-the-adapter",headingTag:"h3"}}),z=new y({props:{title:"Bad results from a loaded PEFT model",local:"bad-results-from-a-loaded-peft-model",headingTag:"h2"}}),S=new y({props:{title:"Random deviations",local:"random-deviations",headingTag:"h3"}}),O=new y({props:{title:"Incorrectly loaded model",local:"incorrectly-loaded-model",headingTag:"h3"}}),te=new c({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMkMlMjBQZWZ0Q29uZmlnJTBBJTBBYmFzZV9tb2RlbCUyMCUzRCUyMC4uLiUyMCUyMCUyMyUyMHRvJTIwbG9hZCUyMHRoZSUyMGJhc2UlMjBtb2RlbCUyQyUyMHVzZSUyMHRoZSUyMHNhbWUlMjBjb2RlJTIwYXMlMjB3aGVuJTIweW91JTIwdHJhaW5lZCUyMGl0JTBBY29uZmlnJTIwJTNEJTIwUGVmdENvbmZpZy5mcm9tX3ByZXRyYWluZWQocGVmdF9tb2RlbF9pZCklMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel, PeftConfig

base_model = ...  <span class="hljs-comment"># to load the base model, use the same code as when you trained it</span>
config = PeftConfig.from_pretrained(peft_model_id)
peft_model = PeftModel.from_pretrained(base_model, peft_model_id)`,wrap:!1}}),le=new y({props:{title:"Randomly initialized layers",local:"randomly-initialized-layers",headingTag:"h3"}}),oe=new c({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMCUzQ01PREVMJTNFJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwJTNDSUQlM0UlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTNBJTIwJTVCJTNDTEFZRVJfTkFNRVMlM0UlNUQuJTBBWW91JTIwc2hvdWxkJTIwcHJvYmFibHklMjBUUkFJTiUyMHRoaXMlMjBtb2RlbCUyMG9uJTIwYSUyMGRvd24tc3RyZWFtJTIwdGFzayUyMHRvJTIwYmUlMjBhYmxlJTIwdG8lMjB1c2UlMjBpdCUyMGZvciUyMHByZWRpY3Rpb25zJTIwYW5kJTIwaW5mZXJlbmNlLg==",highlighted:`<span class="hljs-keyword">Some</span> weights <span class="hljs-keyword">of</span> &lt;MODEL&gt; were <span class="hljs-keyword">not</span> initialized <span class="hljs-keyword">from</span> the model <span class="hljs-keyword">checkpoint</span> at &lt;ID&gt; <span class="hljs-keyword">and</span> are newly initialized: [&lt;LAYER_NAMES&gt;].
You should probably TRAIN this model <span class="hljs-keyword">on</span> a down-stream task <span class="hljs-keyword">to</span> be able <span class="hljs-keyword">to</span> use it <span class="hljs-keyword">for</span> predictions <span class="hljs-keyword">and</span> inference.`,wrap:!1}}),pe=new y({props:{title:"Extending the vocabulary",local:"extending-the-vocabulary",headingTag:"h3"}}),fe=new y({props:{title:"Using trainable tokens",local:"using-trainable-tokens",headingTag:"h4"}}),ce=new c({props:{code:"bmV3X3Rva2VucyUyMCUzRCUyMCU1QiclM0N0aGluayUzRSclMkMlMjAnJTNDJTJGdGhpbmslM0UnJTVEJTBBdG9rZW5pemVyLmFkZF90b2tlbnMobmV3X3Rva2VucyklMEFiYXNlX21vZGVsLnJlc2l6ZV90b2tlbl9lbWJlZGRpbmdzKGxlbih0b2tlbml6ZXIpKSUwQSUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjB0cmFpbmFibGVfdG9rZW5faW5kaWNlcyUzRCU3QidlbWJlZF90b2tlbnMnJTNBJTIwdG9rZW5pemVyLmNvbnZlcnRfdG9rZW5zX3RvX2lkcyhuZXdfdG9rZW5zKSU3RCUyQyUwQSk=",highlighted:`new_tokens = [<span class="hljs-string">&#x27;&lt;think&gt;&#x27;</span>, <span class="hljs-string">&#x27;&lt;/think&gt;&#x27;</span>]
tokenizer.add_tokens(new_tokens)
base_model.resize_token_embeddings(<span class="hljs-built_in">len</span>(tokenizer))

lora_config = LoraConfig(
    ...,
    trainable_token_indices={<span class="hljs-string">&#x27;embed_tokens&#x27;</span>: tokenizer.convert_tokens_to_ids(new_tokens)},
)`,wrap:!1}}),be=new y({props:{title:"Using an adapter, e.g. LoRA",local:"using-an-adapter-eg-lora",headingTag:"h4"}}),Me=new c({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyguLi4lMkMlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMmVtYmVkX3Rva2VucyUyMiUyQyUyMCUyMmxtX2hlYWQlMjIlMkMlMjAlMjJxX3Byb2olMjIlMkMlMjAlMjJ2X3Byb2olMjIlNUQp",highlighted:'config = LoraConfig(..., target_modules=[<span class="hljs-string">&quot;embed_tokens&quot;</span>, <span class="hljs-string">&quot;lm_head&quot;</span>, <span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>])',wrap:!1}}),ve=new c({props:{code:"bW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbCguLi4pJTBBJTIzJTIwdHJhaW4lMjB0aGUlMjBtb2RlbCUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJteV9hZGFwdGVyJTIyJTJDJTIwc2F2ZV9lbWJlZGRpbmdfbGF5ZXJzJTNEVHJ1ZSk=",highlighted:`model = get_peft_model(...)
<span class="hljs-comment"># train the model</span>
model.save_pretrained(<span class="hljs-string">&quot;my_adapter&quot;</span>, save_embedding_layers=<span class="hljs-literal">True</span>)`,wrap:!1}}),ke=new y({props:{title:"Full fine-tuning",local:"full-fine-tuning",headingTag:"h4"}}),Je=new c({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyguLi4lMkMlMjBtb2R1bGVzX3RvX3NhdmUlM0QlNUIlMjJlbWJlZF90b2tlbnMlMjIlMkMlMjAlMjJsbV9oZWFkJTIyJTVEJTJDJTIwdGFyZ2V0X21vZHVsZXMlM0QlNUIlMjJxX3Byb2olMjIlMkMlMjAlMjJ2X3Byb2olMjIlNUQp",highlighted:'config = LoraConfig(..., modules_to_save=[<span class="hljs-string">&quot;embed_tokens&quot;</span>, <span class="hljs-string">&quot;lm_head&quot;</span>], target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>])',wrap:!1}}),Ze=new y({props:{title:"Getting a warning about “weights not being initialized from the model checkpoint”",local:"getting-a-warning-about-weights-not-being-initialized-from-the-model-checkpoint",headingTag:"h3"}}),Ge=new c({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwVGFza1R5cGUlMEElMEFsb3JhX2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoLi4uJTJDJTIwdGFza190eXBlJTNEVGFza1R5cGUuU0VRX0NMUyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, TaskType

lora_config = LoraConfig(..., task_type=TaskType.SEQ_CLS)`,wrap:!1}}),Fe=new c({props:{code:"bG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiUyQyUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMm5hbWUtb2YtY2xhc3NpZmljYXRpb24taGVhZCUyMiU1RCk=",highlighted:'lora_config = LoraConfig(..., modules_to_save=[<span class="hljs-string">&quot;name-of-classification-head&quot;</span>])',wrap:!1}}),Ve=new y({props:{title:"Check layer and model status",local:"check-layer-and-model-status",headingTag:"h3"}}),Ye=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwZ2V0X3BlZnRfbW9kZWwlMkMlMjBMb3JhQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJnb29nbGUlMkZmbGFuLXQ1LXNtYWxsJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBMb3JhQ29uZmlnKCkpJTBBJTBBbW9kZWwuZ2V0X2xheWVyX3N0YXR1cygpJTBBJTBBbW9kZWwuZ2V0X21vZGVsX3N0YXR1cygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model, LoraConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;google/flan-t5-small&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = get_peft_model(model, LoraConfig())

<span class="hljs-meta">&gt;&gt;&gt; </span>model.get_layer_status()
[TunerLayerStatus(name=<span class="hljs-string">&#x27;model.encoder.block.0.layer.0.SelfAttention.q&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-literal">True</span>},
                  available_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>]),
 TunerLayerStatus(name=<span class="hljs-string">&#x27;model.encoder.block.0.layer.0.SelfAttention.v&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-literal">True</span>},
                  available_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>]),
...]

<span class="hljs-meta">&gt;&gt;&gt; </span>model.get_model_status()
TunerModelStatus(
    base_model_type=<span class="hljs-string">&#x27;T5Model&#x27;</span>,
    adapter_model_type=<span class="hljs-string">&#x27;LoraModel&#x27;</span>,
    peft_types={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-string">&#x27;LORA&#x27;</span>},
    trainable_params=<span class="hljs-number">344064</span>,
    total_params=<span class="hljs-number">60855680</span>,
    num_adapter_layers=<span class="hljs-number">48</span>,
    enabled=<span class="hljs-literal">True</span>,
    active_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
    merged_adapters=[],
    requires_grad={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-literal">True</span>},
    available_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
)`,wrap:!1}}),ze=new c({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwYXNkaWN0JTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQWRmJTIwJTNEJTIwcGQuRGF0YUZyYW1lKGFzZGljdChsYXllciklMjBmb3IlMjBsYXllciUyMGluJTIwbW9kZWwuZ2V0X2xheWVyX3N0YXR1cygpKQ==",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> asdict
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

df = pd.DataFrame(asdict(layer) <span class="hljs-keyword">for</span> layer <span class="hljs-keyword">in</span> model.get_layer_status())`,wrap:!1}}),Ae=new c({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMGdldF9tb2RlbF9zdGF0dXMlMkMlMjBnZXRfbGF5ZXJfc3RhdHVzJTBBJTBBcGF0aCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBbG9yYV9pZCUyMCUzRCUyMCUyMnRha3VtYTEwNCUyRmxvcmEtdGVzdC10ZXh0LWVuY29kZXItbG9yYS10YXJnZXQlMjIlMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHBhdGglMkMlMjBkdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZS5sb2FkX2xvcmFfd2VpZ2h0cyhsb3JhX2lkJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlci0xJTIyKSUwQXBpcGUubG9hZF9sb3JhX3dlaWdodHMobG9yYV9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmFkYXB0ZXItMiUyMiklMEFwaXBlLnNldF9sb3JhX2RldmljZSglNUIlMjJhZGFwdGVyLTIlMjIlNUQlMkMlMjAlMjJjdWRhJTIyKSUwQWdldF9sYXllcl9zdGF0dXMocGlwZS50ZXh0X2VuY29kZXIpJTBBJTBBZ2V0X21vZGVsX3N0YXR1cyhwaXBlLnVuZXQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_model_status, get_layer_status

<span class="hljs-meta">&gt;&gt;&gt; </span>path = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>lora_id = <span class="hljs-string">&quot;takuma104/lora-test-text-encoder-lora-target&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(path, dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.load_lora_weights(lora_id, adapter_name=<span class="hljs-string">&quot;adapter-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.load_lora_weights(lora_id, adapter_name=<span class="hljs-string">&quot;adapter-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.set_lora_device([<span class="hljs-string">&quot;adapter-2&quot;</span>], <span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>get_layer_status(pipe.text_encoder)
[TunerLayerStatus(name=<span class="hljs-string">&#x27;text_model.encoder.layers.0.self_attn.k_proj&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;adapter-2&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>: <span class="hljs-literal">True</span>},
                  available_adapters=[<span class="hljs-string">&#x27;adapter-1&#x27;</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>],
                  devices={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: [<span class="hljs-string">&#x27;cpu&#x27;</span>], <span class="hljs-string">&#x27;adapter-2&#x27;</span>: [<span class="hljs-string">&#x27;cuda&#x27;</span>]}),
 TunerLayerStatus(name=<span class="hljs-string">&#x27;text_model.encoder.layers.0.self_attn.v_proj&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;adapter-2&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>: <span class="hljs-literal">True</span>},
                  devices={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: [<span class="hljs-string">&#x27;cpu&#x27;</span>], <span class="hljs-string">&#x27;adapter-2&#x27;</span>: [<span class="hljs-string">&#x27;cuda&#x27;</span>]}),
...]

<span class="hljs-meta">&gt;&gt;&gt; </span>get_model_status(pipe.unet)
TunerModelStatus(
    base_model_type=<span class="hljs-string">&#x27;other&#x27;</span>,
    adapter_model_type=<span class="hljs-string">&#x27;None&#x27;</span>,
    peft_types={},
    trainable_params=<span class="hljs-number">797184</span>,
    total_params=<span class="hljs-number">861115332</span>,
    num_adapter_layers=<span class="hljs-number">128</span>,
    enabled=<span class="hljs-literal">True</span>,
    active_adapters=[<span class="hljs-string">&#x27;adapter-2&#x27;</span>],
    merged_adapters=[],
    requires_grad={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>: <span class="hljs-literal">True</span>},
    available_adapters=[<span class="hljs-string">&#x27;adapter-1&#x27;</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>],
    devices={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: [<span class="hljs-string">&#x27;cpu&#x27;</span>], <span class="hljs-string">&#x27;adapter-2&#x27;</span>: [<span class="hljs-string">&#x27;cuda&#x27;</span>]},
)`,wrap:!1}}),Se=new y({props:{title:"Speed",local:"speed",headingTag:"h2"}}),Ke=new y({props:{title:"Loading adapter weights is slow",local:"loading-adapter-weights-is-slow",headingTag:"h3"}}),Oe=new y({props:{title:"Reproducibility",local:"reproducibility",headingTag:"h2"}}),et=new y({props:{title:"Models using batch norm",local:"models-using-batch-norm",headingTag:"h3"}}),at=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMExvcmFDb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybWljcm9zb2Z0JTJGcmVzbmV0LTE4JTIyJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKHNlbGYubW9kZWxfaWQpJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMmNvbnZvbHV0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kdWxlc190b19zYXZlJTNEJTVCJTIyY2xhc3NpZmllciUyMiUyQyUyMCUyMm5vcm1hbGl6YXRpb24lMjIlNUQlMkMlMEEpJTJD",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

model_id = <span class="hljs-string">&quot;microsoft/resnet-18&quot;</span>
base_model = AutoModelForImageClassification.from_pretrained(self.model_id)
config = LoraConfig(
    target_modules=[<span class="hljs-string">&quot;convolution&quot;</span>],
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>, <span class="hljs-string">&quot;normalization&quot;</span>],
),`,wrap:!1}}),nt=new y({props:{title:"Version mismatch",local:"version-mismatch",headingTag:"h2"}}),it=new y({props:{title:"Error while loading the config because of an unexpected keyword argument",local:"error-while-loading-the-config-because-of-an-unexpected-keyword-argument",headingTag:"h3"}}),rt=new c({props:{code:"VHlwZUVycm9yJTNBJTIwTG9yYUNvbmZpZy5fX2luaXRfXygpJTIwZ290JTIwYW4lMjB1bmV4cGVjdGVkJTIwa2V5d29yZCUyMGFyZ3VtZW50JTIwJTNDYXJndW1lbnQtbmFtZSUzRQ==",highlighted:'TypeError: LoraConfig.__init__() got an unexpected keyword <span class="hljs-variable language_">argument</span> &lt;<span class="hljs-variable language_">argument</span>-name&gt;',wrap:!1}}),dt=new c({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwLVUlMjBQRUZU",highlighted:"python -m pip install -U PEFT",wrap:!1}}),ft=new c({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwLVUlMjBnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRnBlZnQuZ2l0",highlighted:"python -m pip install -U git+https://github.com/huggingface/peft.git",wrap:!1}}),yt=new y({props:{title:"Adapter handling",local:"adapter-handling",headingTag:"h2"}}),gt=new y({props:{title:"Using multiple adapters at the same time",local:"using-multiple-adapters-at-the-same-time",headingTag:"h3"}}),Mt=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFtb2RlbF9pZCUyMCUzRCUyMC4uLiUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBsb3JhX3BhdGhfMCklMjAlMjAlMjMlMjBkZWZhdWx0JTIwYWRhcHRlcl9uYW1lJTIwaXMlMjAnZGVmYXVsdCclMEFtb2RlbC5sb2FkX2FkYXB0ZXIobG9yYV9wYXRoXzElMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJvdGhlciUyMiklMEElMjMlMjB0aGUlMjAnb3RoZXInJTIwYWRhcHRlciUyMHdhcyUyMGxvYWRlZCUyMGJ1dCUyMGl0J3MlMjBub3QlMjBhY3RpdmUlMjB5ZXQlMkMlMjBzbyUyMHRvJTIwYWN0aXZhdGUlMjBib3RoJTIwYWRhcHRlcnMlM0ElMEFtb2RlbC5iYXNlX21vZGVsLnNldF9hZGFwdGVyKCU1QiUyMmRlZmF1bHQlMjIlMkMlMjAlMjJvdGhlciUyMiU1RCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model_id = ...
base_model = AutoModelForCausalLM.from_pretrained(model_id)
model = PeftModel.from_pretrained(base_model, lora_path_0)  <span class="hljs-comment"># default adapter_name is &#x27;default&#x27;</span>
model.load_adapter(lora_path_1, adapter_name=<span class="hljs-string">&quot;other&quot;</span>)
<span class="hljs-comment"># the &#x27;other&#x27; adapter was loaded but it&#x27;s not active yet, so to activate both adapters:</span>
model.base_model.set_adapter([<span class="hljs-string">&quot;default&quot;</span>, <span class="hljs-string">&quot;other&quot;</span>])`,wrap:!1}}),_t=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFtb2RlbF9pZCUyMCUzRCUyMC4uLiUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBbG9yYV9jb25maWdfMCUyMCUzRCUyMExvcmFDb25maWcoLi4uKSUwQWxvcmFfY29uZmlnXzElMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiklMEFtb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKGJhc2VfbW9kZWwlMkMlMjBsb3JhX2NvbmZpZ18wKSUwQW1vZGVsLmFkZF9hZGFwdGVyKGFkYXB0ZXJfbmFtZSUzRCUyMm90aGVyJTIyJTJDJTIwcGVmdF9jb25maWclM0Rsb3JhX2NvbmZpZ18xKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

model_id = ...
base_model = AutoModelForCausalLM.from_pretrained(model_id)
lora_config_0 = LoraConfig(...)
lora_config_1 = LoraConfig(...)
model = get_peft_model(base_model, lora_config_0)
model.add_adapter(adapter_name=<span class="hljs-string">&quot;other&quot;</span>, peft_config=lora_config_1)`,wrap:!1}}),$t=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lcihtb2RlbCUzRG1vZGVsJTJDJTIwJTIwLi4uKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

trainer = Trainer(model=model,  ...)
trainer.train()`,wrap:!1}}),kt=new c({props:{code:"b3B0aW1pemVyJTIwJTNEJTIwdG9yY2gub3B0aW0uQWRhbVcoJTVCcGFyYW0lMjBmb3IlMjBwYXJhbSUyMGluJTIwbW9kZWwucGFyYW1ldGVycygpJTIwaWYlMjBwYXJhbS5yZXF1aXJlc19ncmFkJTVEJTJDJTIwLi4uKQ==",highlighted:'optimizer = torch.optim.AdamW([param <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.parameters() <span class="hljs-keyword">if</span> param.requires_grad], ...)',wrap:!1}}),Jt=new c({props:{code:"JTIzJTIwYWN0aXZhdGUlMjBhbGwlMjBhZGFwdGVycyUwQW1vZGVsLmJhc2VfbW9kZWwuc2V0X2FkYXB0ZXIoJTVCJTIyZGVmYXVsdCUyMiUyQyUyMCUyMm90aGVyJTIyJTVEKSUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKG1vZGVsJTNEbW9kZWwlMkMlMjAlMjAuLi4pJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-comment"># activate all adapters</span>
model.base_model.set_adapter([<span class="hljs-string">&quot;default&quot;</span>, <span class="hljs-string">&quot;other&quot;</span>])
trainer = Trainer(model=model,  ...)
trainer.train()`,wrap:!1}}),Zt=new _n({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/troubleshooting.md"}}),{c(){g=i("meta"),Bt=s(),Ut=i("p"),Gt=s(),p(v.$$.fragment),Lt=s(),p($.$$.fragment),Ft=s(),j=i("p"),j.textContent=Aa,Rt=s(),p(k.$$.fragment),It=s(),x=i("p"),x.textContent=Sa,Xt=s(),J=i("ul"),J.innerHTML=Ka,Vt=s(),Z=i("p"),Z.textContent=Da,Ht=s(),p(C.$$.fragment),Et=s(),U=i("p"),U.textContent=Oa,Yt=s(),p(W.$$.fragment),Pt=s(),p(B.$$.fragment),qt=s(),p(G.$$.fragment),Qt=s(),L=i("p"),L.innerHTML=es,zt=s(),p(F.$$.fragment),Nt=s(),R=i("p"),R.innerHTML=ts,At=s(),p(I.$$.fragment),St=s(),b=i("blockquote"),b.innerHTML=ls,Kt=s(),p(X.$$.fragment),Dt=s(),V=i("p"),V.textContent=as,Ot=s(),H=i("p"),H.innerHTML=ss,el=s(),E=i("p"),E.textContent=ns,tl=s(),Y=i("ul"),Y.innerHTML=is,ll=s(),P=i("p"),P.textContent=os,al=s(),q=i("ul"),q.innerHTML=rs,sl=s(),Q=i("p"),Q.textContent=ps,nl=s(),p(z.$$.fragment),il=s(),N=i("p"),N.innerHTML=ds,ol=s(),A=i("p"),A.textContent=ms,rl=s(),p(S.$$.fragment),pl=s(),K=i("p"),K.textContent=fs,dl=s(),D=i("ol"),D.innerHTML=hs,ml=s(),p(O.$$.fragment),fl=s(),ee=i("p"),ee.innerHTML=us,hl=s(),p(te.$$.fragment),ul=s(),p(le.$$.fragment),cl=s(),ae=i("p"),ae.innerHTML=cs,yl=s(),se=i("p"),se.innerHTML=ys,gl=s(),ne=i("p"),ne.innerHTML=gs,bl=s(),ie=i("p"),ie.textContent=bs,wl=s(),p(oe.$$.fragment),Ml=s(),re=i("p"),re.innerHTML=ws,Tl=s(),w=i("blockquote"),w.innerHTML=Ms,_l=s(),p(pe.$$.fragment),vl=s(),de=i("p"),de.textContent=Ts,$l=s(),me=i("ul"),me.innerHTML=_s,jl=s(),p(fe.$$.fragment),kl=s(),he=i("p"),he.innerHTML=vs,xl=s(),ue=i("p"),ue.innerHTML=$s,Jl=s(),p(ce.$$.fragment),Zl=s(),ye=i("p"),ye.innerHTML=js,Cl=s(),ge=i("p"),ge.innerHTML=ks,Ul=s(),p(be.$$.fragment),Wl=s(),we=i("p"),we.innerHTML=xs,Bl=s(),p(Me.$$.fragment),Gl=s(),Te=i("p"),Te.innerHTML=Js,Ll=s(),_e=i("p"),_e.innerHTML=Zs,Fl=s(),p(ve.$$.fragment),Rl=s(),$e=i("p"),$e.textContent=Cs,Il=s(),je=i("p"),je.innerHTML=Us,Xl=s(),p(ke.$$.fragment),Vl=s(),xe=i("p"),xe.innerHTML=Ws,Hl=s(),p(Je.$$.fragment),El=s(),p(Ze.$$.fragment),Yl=s(),Ce=i("p"),Ce.textContent=Bs,Pl=s(),Ue=i("blockquote"),Ue.innerHTML=Gs,ql=s(),We=i("p"),We.innerHTML=Ls,Ql=s(),Be=i("p"),Be.innerHTML=Fs,zl=s(),p(Ge.$$.fragment),Nl=s(),Le=i("p"),Le.innerHTML=Rs,Al=s(),p(Fe.$$.fragment),Sl=s(),Re=i("p"),Re.textContent=Is,Kl=s(),Ie=i("p"),Ie.innerHTML=Xs,Dl=s(),Xe=i("p"),Xe.textContent=Vs,Ol=s(),p(Ve.$$.fragment),ea=s(),He=i("p"),He.innerHTML=Hs,ta=s(),Ee=i("p"),Ee.innerHTML=Es,la=s(),p(Ye.$$.fragment),aa=s(),Pe=i("p"),Pe.innerHTML=Ys,sa=s(),qe=i("p"),qe.textContent=Ps,na=s(),Qe=i("p"),Qe.innerHTML=qs,ia=s(),p(ze.$$.fragment),oa=s(),Ne=i("p"),Ne.innerHTML=Qs,ra=s(),p(Ae.$$.fragment),pa=s(),p(Se.$$.fragment),da=s(),p(Ke.$$.fragment),ma=s(),De=i("p"),De.innerHTML=zs,fa=s(),M=i("blockquote"),M.innerHTML=Ns,ha=s(),p(Oe.$$.fragment),ua=s(),p(et.$$.fragment),ca=s(),tt=i("p"),tt.innerHTML=As,ya=s(),lt=i("p"),lt.innerHTML=Ss,ga=s(),p(at.$$.fragment),ba=s(),st=i("p"),st.innerHTML=Ks,wa=s(),p(nt.$$.fragment),Ma=s(),p(it.$$.fragment),Ta=s(),ot=i("p"),ot.textContent=Ds,_a=s(),p(rt.$$.fragment),va=s(),pt=i("p"),pt.textContent=Os,$a=s(),p(dt.$$.fragment),ja=s(),mt=i("p"),mt.textContent=en,ka=s(),p(ft.$$.fragment),xa=s(),ht=i("p"),ht.textContent=tn,Ja=s(),ut=i("p"),ut.innerHTML=ln,Za=s(),ct=i("p"),ct.innerHTML=an,Ca=s(),p(yt.$$.fragment),Ua=s(),p(gt.$$.fragment),Wa=s(),bt=i("p"),bt.textContent=sn,Ba=s(),wt=i("p"),wt.textContent=nn,Ga=s(),p(Mt.$$.fragment),La=s(),T=i("blockquote"),T.innerHTML=on,Fa=s(),Tt=i("p"),Tt.textContent=rn,Ra=s(),p(_t.$$.fragment),Ia=s(),vt=i("p"),vt.textContent=pn,Xa=s(),p($t.$$.fragment),Va=s(),jt=i("p"),jt.textContent=dn,Ha=s(),p(kt.$$.fragment),Ea=s(),xt=i("p"),xt.innerHTML=mn,Ya=s(),p(Jt.$$.fragment),Pa=s(),_=i("blockquote"),_.innerHTML=fn,qa=s(),p(Zt.$$.fragment),Qa=s(),Wt=i("p"),this.h()},l(e){const t=wn("svelte-u9bgzb",document.head);g=o(t,"META",{name:!0,content:!0}),t.forEach(l),Bt=n(e),Ut=o(e,"P",{}),hn(Ut).forEach(l),Gt=n(e),d(v.$$.fragment,e),Lt=n(e),d($.$$.fragment,e),Ft=n(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-wwms7a"&&(j.textContent=Aa),Rt=n(e),d(k.$$.fragment,e),It=n(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-18nlz3r"&&(x.textContent=Sa),Xt=n(e),J=o(e,"UL",{"data-svelte-h":!0}),r(J)!=="svelte-ccv654"&&(J.innerHTML=Ka),Vt=n(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1cuqjyb"&&(Z.textContent=Da),Ht=n(e),d(C.$$.fragment,e),Et=n(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-h5ykrw"&&(U.textContent=Oa),Yt=n(e),d(W.$$.fragment,e),Pt=n(e),d(B.$$.fragment,e),qt=n(e),d(G.$$.fragment,e),Qt=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-pp9yjt"&&(L.innerHTML=es),zt=n(e),d(F.$$.fragment,e),Nt=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-10bo3r2"&&(R.innerHTML=ts),At=n(e),d(I.$$.fragment,e),St=n(e),b=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-1ko9eri"&&(b.innerHTML=ls),Kt=n(e),d(X.$$.fragment,e),Dt=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1w3ww7i"&&(V.textContent=as),Ot=n(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-5wohav"&&(H.innerHTML=ss),el=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-3n96y7"&&(E.textContent=ns),tl=n(e),Y=o(e,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-1ghjkcl"&&(Y.innerHTML=is),ll=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1yqgo19"&&(P.textContent=os),al=n(e),q=o(e,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-pdypmd"&&(q.innerHTML=rs),sl=n(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1gmj2pd"&&(Q.textContent=ps),nl=n(e),d(z.$$.fragment,e),il=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-ns8zue"&&(N.innerHTML=ds),ol=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-lfc2ft"&&(A.textContent=ms),rl=n(e),d(S.$$.fragment,e),pl=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-16feh"&&(K.textContent=fs),dl=n(e),D=o(e,"OL",{"data-svelte-h":!0}),r(D)!=="svelte-cqge1k"&&(D.innerHTML=hs),ml=n(e),d(O.$$.fragment,e),fl=n(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1rqqlf8"&&(ee.innerHTML=us),hl=n(e),d(te.$$.fragment,e),ul=n(e),d(le.$$.fragment,e),cl=n(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-5heszj"&&(ae.innerHTML=cs),yl=n(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-c4824l"&&(se.innerHTML=ys),gl=n(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1ou3c35"&&(ne.innerHTML=gs),bl=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1g4txs2"&&(ie.textContent=bs),wl=n(e),d(oe.$$.fragment,e),Ml=n(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1fbeum6"&&(re.innerHTML=ws),Tl=n(e),w=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-lmc43w"&&(w.innerHTML=Ms),_l=n(e),d(pe.$$.fragment,e),vl=n(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1ftgm9w"&&(de.textContent=Ts),$l=n(e),me=o(e,"UL",{"data-svelte-h":!0}),r(me)!=="svelte-1cu50cp"&&(me.innerHTML=_s),jl=n(e),d(fe.$$.fragment,e),kl=n(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-p4bcqv"&&(he.innerHTML=vs),xl=n(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-ffklcx"&&(ue.innerHTML=$s),Jl=n(e),d(ce.$$.fragment,e),Zl=n(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-12n0r5k"&&(ye.innerHTML=js),Cl=n(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1r5fwm9"&&(ge.innerHTML=ks),Ul=n(e),d(be.$$.fragment,e),Wl=n(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1bq6qvj"&&(we.innerHTML=xs),Bl=n(e),d(Me.$$.fragment,e),Gl=n(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1lr155g"&&(Te.innerHTML=Js),Ll=n(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1kaw5hl"&&(_e.innerHTML=Zs),Fl=n(e),d(ve.$$.fragment,e),Rl=n(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-nkv7o7"&&($e.textContent=Cs),Il=n(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-a0ibfa"&&(je.innerHTML=Us),Xl=n(e),d(ke.$$.fragment,e),Vl=n(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-u2918x"&&(xe.innerHTML=Ws),Hl=n(e),d(Je.$$.fragment,e),El=n(e),d(Ze.$$.fragment,e),Yl=n(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-q2uzbp"&&(Ce.textContent=Bs),Pl=n(e),Ue=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(Ue)!=="svelte-ray7nl"&&(Ue.innerHTML=Gs),ql=n(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1cejahg"&&(We.innerHTML=Ls),Ql=n(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-m24cow"&&(Be.innerHTML=Fs),zl=n(e),d(Ge.$$.fragment,e),Nl=n(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1c6v178"&&(Le.innerHTML=Rs),Al=n(e),d(Fe.$$.fragment,e),Sl=n(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-f59lgd"&&(Re.textContent=Is),Kl=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-k7fvy1"&&(Ie.innerHTML=Xs),Dl=n(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-16spx00"&&(Xe.textContent=Vs),Ol=n(e),d(Ve.$$.fragment,e),ea=n(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-s4d7h9"&&(He.innerHTML=Hs),ta=n(e),Ee=o(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-xsmxv2"&&(Ee.innerHTML=Es),la=n(e),d(Ye.$$.fragment,e),aa=n(e),Pe=o(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1gb1r7d"&&(Pe.innerHTML=Ys),sa=n(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-19sfzdf"&&(qe.textContent=Ps),na=n(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-18r4lni"&&(Qe.innerHTML=qs),ia=n(e),d(ze.$$.fragment,e),oa=n(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-17rnlhh"&&(Ne.innerHTML=Qs),ra=n(e),d(Ae.$$.fragment,e),pa=n(e),d(Se.$$.fragment,e),da=n(e),d(Ke.$$.fragment,e),ma=n(e),De=o(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-19iuoxm"&&(De.innerHTML=zs),fa=n(e),M=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(M)!=="svelte-gscfhd"&&(M.innerHTML=Ns),ha=n(e),d(Oe.$$.fragment,e),ua=n(e),d(et.$$.fragment,e),ca=n(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-yt67c7"&&(tt.innerHTML=As),ya=n(e),lt=o(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-wblxho"&&(lt.innerHTML=Ss),ga=n(e),d(at.$$.fragment,e),ba=n(e),st=o(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1e3stb1"&&(st.innerHTML=Ks),wa=n(e),d(nt.$$.fragment,e),Ma=n(e),d(it.$$.fragment,e),Ta=n(e),ot=o(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-5zz36e"&&(ot.textContent=Ds),_a=n(e),d(rt.$$.fragment,e),va=n(e),pt=o(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-1dqw1qx"&&(pt.textContent=Os),$a=n(e),d(dt.$$.fragment,e),ja=n(e),mt=o(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-1k207nl"&&(mt.textContent=en),ka=n(e),d(ft.$$.fragment,e),xa=n(e),ht=o(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-1jt6x31"&&(ht.textContent=tn),Ja=n(e),ut=o(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-1a81pzz"&&(ut.innerHTML=ln),Za=n(e),ct=o(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-1wt4m5g"&&(ct.innerHTML=an),Ca=n(e),d(yt.$$.fragment,e),Ua=n(e),d(gt.$$.fragment,e),Wa=n(e),bt=o(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-11stw7g"&&(bt.textContent=sn),Ba=n(e),wt=o(e,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-a9hnjs"&&(wt.textContent=nn),Ga=n(e),d(Mt.$$.fragment,e),La=n(e),T=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-t4lclb"&&(T.innerHTML=on),Fa=n(e),Tt=o(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-164a5vl"&&(Tt.textContent=rn),Ra=n(e),d(_t.$$.fragment,e),Ia=n(e),vt=o(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-1p5ltyy"&&(vt.textContent=pn),Xa=n(e),d($t.$$.fragment,e),Va=n(e),jt=o(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-93sdsf"&&(jt.textContent=dn),Ha=n(e),d(kt.$$.fragment,e),Ea=n(e),xt=o(e,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-176115b"&&(xt.innerHTML=mn),Ya=n(e),d(Jt.$$.fragment,e),Pa=n(e),_=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(_)!=="svelte-awfkct"&&(_.innerHTML=fn),qa=n(e),d(Zt.$$.fragment,e),Qa=n(e),Wt=o(e,"P",{}),hn(Wt).forEach(l),this.h()},h(){Ct(g,"name","hf:doc:metadata"),Ct(g,"content",$n),Ct(b,"class","tip"),Ct(w,"class","tip"),Ct(M,"class","tip"),Ct(T,"class","tip"),Ct(_,"class","tip")},m(e,t){Mn(document.head,g),a(e,Bt,t),a(e,Ut,t),a(e,Gt,t),m(v,e,t),a(e,Lt,t),m($,e,t),a(e,Ft,t),a(e,j,t),a(e,Rt,t),m(k,e,t),a(e,It,t),a(e,x,t),a(e,Xt,t),a(e,J,t),a(e,Vt,t),a(e,Z,t),a(e,Ht,t),m(C,e,t),a(e,Et,t),a(e,U,t),a(e,Yt,t),m(W,e,t),a(e,Pt,t),m(B,e,t),a(e,qt,t),m(G,e,t),a(e,Qt,t),a(e,L,t),a(e,zt,t),m(F,e,t),a(e,Nt,t),a(e,R,t),a(e,At,t),m(I,e,t),a(e,St,t),a(e,b,t),a(e,Kt,t),m(X,e,t),a(e,Dt,t),a(e,V,t),a(e,Ot,t),a(e,H,t),a(e,el,t),a(e,E,t),a(e,tl,t),a(e,Y,t),a(e,ll,t),a(e,P,t),a(e,al,t),a(e,q,t),a(e,sl,t),a(e,Q,t),a(e,nl,t),m(z,e,t),a(e,il,t),a(e,N,t),a(e,ol,t),a(e,A,t),a(e,rl,t),m(S,e,t),a(e,pl,t),a(e,K,t),a(e,dl,t),a(e,D,t),a(e,ml,t),m(O,e,t),a(e,fl,t),a(e,ee,t),a(e,hl,t),m(te,e,t),a(e,ul,t),m(le,e,t),a(e,cl,t),a(e,ae,t),a(e,yl,t),a(e,se,t),a(e,gl,t),a(e,ne,t),a(e,bl,t),a(e,ie,t),a(e,wl,t),m(oe,e,t),a(e,Ml,t),a(e,re,t),a(e,Tl,t),a(e,w,t),a(e,_l,t),m(pe,e,t),a(e,vl,t),a(e,de,t),a(e,$l,t),a(e,me,t),a(e,jl,t),m(fe,e,t),a(e,kl,t),a(e,he,t),a(e,xl,t),a(e,ue,t),a(e,Jl,t),m(ce,e,t),a(e,Zl,t),a(e,ye,t),a(e,Cl,t),a(e,ge,t),a(e,Ul,t),m(be,e,t),a(e,Wl,t),a(e,we,t),a(e,Bl,t),m(Me,e,t),a(e,Gl,t),a(e,Te,t),a(e,Ll,t),a(e,_e,t),a(e,Fl,t),m(ve,e,t),a(e,Rl,t),a(e,$e,t),a(e,Il,t),a(e,je,t),a(e,Xl,t),m(ke,e,t),a(e,Vl,t),a(e,xe,t),a(e,Hl,t),m(Je,e,t),a(e,El,t),m(Ze,e,t),a(e,Yl,t),a(e,Ce,t),a(e,Pl,t),a(e,Ue,t),a(e,ql,t),a(e,We,t),a(e,Ql,t),a(e,Be,t),a(e,zl,t),m(Ge,e,t),a(e,Nl,t),a(e,Le,t),a(e,Al,t),m(Fe,e,t),a(e,Sl,t),a(e,Re,t),a(e,Kl,t),a(e,Ie,t),a(e,Dl,t),a(e,Xe,t),a(e,Ol,t),m(Ve,e,t),a(e,ea,t),a(e,He,t),a(e,ta,t),a(e,Ee,t),a(e,la,t),m(Ye,e,t),a(e,aa,t),a(e,Pe,t),a(e,sa,t),a(e,qe,t),a(e,na,t),a(e,Qe,t),a(e,ia,t),m(ze,e,t),a(e,oa,t),a(e,Ne,t),a(e,ra,t),m(Ae,e,t),a(e,pa,t),m(Se,e,t),a(e,da,t),m(Ke,e,t),a(e,ma,t),a(e,De,t),a(e,fa,t),a(e,M,t),a(e,ha,t),m(Oe,e,t),a(e,ua,t),m(et,e,t),a(e,ca,t),a(e,tt,t),a(e,ya,t),a(e,lt,t),a(e,ga,t),m(at,e,t),a(e,ba,t),a(e,st,t),a(e,wa,t),m(nt,e,t),a(e,Ma,t),m(it,e,t),a(e,Ta,t),a(e,ot,t),a(e,_a,t),m(rt,e,t),a(e,va,t),a(e,pt,t),a(e,$a,t),m(dt,e,t),a(e,ja,t),a(e,mt,t),a(e,ka,t),m(ft,e,t),a(e,xa,t),a(e,ht,t),a(e,Ja,t),a(e,ut,t),a(e,Za,t),a(e,ct,t),a(e,Ca,t),m(yt,e,t),a(e,Ua,t),m(gt,e,t),a(e,Wa,t),a(e,bt,t),a(e,Ba,t),a(e,wt,t),a(e,Ga,t),m(Mt,e,t),a(e,La,t),a(e,T,t),a(e,Fa,t),a(e,Tt,t),a(e,Ra,t),m(_t,e,t),a(e,Ia,t),a(e,vt,t),a(e,Xa,t),m($t,e,t),a(e,Va,t),a(e,jt,t),a(e,Ha,t),m(kt,e,t),a(e,Ea,t),a(e,xt,t),a(e,Ya,t),m(Jt,e,t),a(e,Pa,t),a(e,_,t),a(e,qa,t),m(Zt,e,t),a(e,Qa,t),a(e,Wt,t),za=!0},p:cn,i(e){za||(f(v.$$.fragment,e),f($.$$.fragment,e),f(k.$$.fragment,e),f(C.$$.fragment,e),f(W.$$.fragment,e),f(B.$$.fragment,e),f(G.$$.fragment,e),f(F.$$.fragment,e),f(I.$$.fragment,e),f(X.$$.fragment,e),f(z.$$.fragment,e),f(S.$$.fragment,e),f(O.$$.fragment,e),f(te.$$.fragment,e),f(le.$$.fragment,e),f(oe.$$.fragment,e),f(pe.$$.fragment,e),f(fe.$$.fragment,e),f(ce.$$.fragment,e),f(be.$$.fragment,e),f(Me.$$.fragment,e),f(ve.$$.fragment,e),f(ke.$$.fragment,e),f(Je.$$.fragment,e),f(Ze.$$.fragment,e),f(Ge.$$.fragment,e),f(Fe.$$.fragment,e),f(Ve.$$.fragment,e),f(Ye.$$.fragment,e),f(ze.$$.fragment,e),f(Ae.$$.fragment,e),f(Se.$$.fragment,e),f(Ke.$$.fragment,e),f(Oe.$$.fragment,e),f(et.$$.fragment,e),f(at.$$.fragment,e),f(nt.$$.fragment,e),f(it.$$.fragment,e),f(rt.$$.fragment,e),f(dt.$$.fragment,e),f(ft.$$.fragment,e),f(yt.$$.fragment,e),f(gt.$$.fragment,e),f(Mt.$$.fragment,e),f(_t.$$.fragment,e),f($t.$$.fragment,e),f(kt.$$.fragment,e),f(Jt.$$.fragment,e),f(Zt.$$.fragment,e),za=!0)},o(e){h(v.$$.fragment,e),h($.$$.fragment,e),h(k.$$.fragment,e),h(C.$$.fragment,e),h(W.$$.fragment,e),h(B.$$.fragment,e),h(G.$$.fragment,e),h(F.$$.fragment,e),h(I.$$.fragment,e),h(X.$$.fragment,e),h(z.$$.fragment,e),h(S.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(le.$$.fragment,e),h(oe.$$.fragment,e),h(pe.$$.fragment,e),h(fe.$$.fragment,e),h(ce.$$.fragment,e),h(be.$$.fragment,e),h(Me.$$.fragment,e),h(ve.$$.fragment,e),h(ke.$$.fragment,e),h(Je.$$.fragment,e),h(Ze.$$.fragment,e),h(Ge.$$.fragment,e),h(Fe.$$.fragment,e),h(Ve.$$.fragment,e),h(Ye.$$.fragment,e),h(ze.$$.fragment,e),h(Ae.$$.fragment,e),h(Se.$$.fragment,e),h(Ke.$$.fragment,e),h(Oe.$$.fragment,e),h(et.$$.fragment,e),h(at.$$.fragment,e),h(nt.$$.fragment,e),h(it.$$.fragment,e),h(rt.$$.fragment,e),h(dt.$$.fragment,e),h(ft.$$.fragment,e),h(yt.$$.fragment,e),h(gt.$$.fragment,e),h(Mt.$$.fragment,e),h(_t.$$.fragment,e),h($t.$$.fragment,e),h(kt.$$.fragment,e),h(Jt.$$.fragment,e),h(Zt.$$.fragment,e),za=!1},d(e){e&&(l(Bt),l(Ut),l(Gt),l(Lt),l(Ft),l(j),l(Rt),l(It),l(x),l(Xt),l(J),l(Vt),l(Z),l(Ht),l(Et),l(U),l(Yt),l(Pt),l(qt),l(Qt),l(L),l(zt),l(Nt),l(R),l(At),l(St),l(b),l(Kt),l(Dt),l(V),l(Ot),l(H),l(el),l(E),l(tl),l(Y),l(ll),l(P),l(al),l(q),l(sl),l(Q),l(nl),l(il),l(N),l(ol),l(A),l(rl),l(pl),l(K),l(dl),l(D),l(ml),l(fl),l(ee),l(hl),l(ul),l(cl),l(ae),l(yl),l(se),l(gl),l(ne),l(bl),l(ie),l(wl),l(Ml),l(re),l(Tl),l(w),l(_l),l(vl),l(de),l($l),l(me),l(jl),l(kl),l(he),l(xl),l(ue),l(Jl),l(Zl),l(ye),l(Cl),l(ge),l(Ul),l(Wl),l(we),l(Bl),l(Gl),l(Te),l(Ll),l(_e),l(Fl),l(Rl),l($e),l(Il),l(je),l(Xl),l(Vl),l(xe),l(Hl),l(El),l(Yl),l(Ce),l(Pl),l(Ue),l(ql),l(We),l(Ql),l(Be),l(zl),l(Nl),l(Le),l(Al),l(Sl),l(Re),l(Kl),l(Ie),l(Dl),l(Xe),l(Ol),l(ea),l(He),l(ta),l(Ee),l(la),l(aa),l(Pe),l(sa),l(qe),l(na),l(Qe),l(ia),l(oa),l(Ne),l(ra),l(pa),l(da),l(ma),l(De),l(fa),l(M),l(ha),l(ua),l(ca),l(tt),l(ya),l(lt),l(ga),l(ba),l(st),l(wa),l(Ma),l(Ta),l(ot),l(_a),l(va),l(pt),l($a),l(ja),l(mt),l(ka),l(xa),l(ht),l(Ja),l(ut),l(Za),l(ct),l(Ca),l(Ua),l(Wa),l(bt),l(Ba),l(wt),l(Ga),l(La),l(T),l(Fa),l(Tt),l(Ra),l(Ia),l(vt),l(Xa),l(Va),l(jt),l(Ha),l(Ea),l(xt),l(Ya),l(Pa),l(_),l(qa),l(Qa),l(Wt)),l(g),u(v,e),u($,e),u(k,e),u(C,e),u(W,e),u(B,e),u(G,e),u(F,e),u(I,e),u(X,e),u(z,e),u(S,e),u(O,e),u(te,e),u(le,e),u(oe,e),u(pe,e),u(fe,e),u(ce,e),u(be,e),u(Me,e),u(ve,e),u(ke,e),u(Je,e),u(Ze,e),u(Ge,e),u(Fe,e),u(Ve,e),u(Ye,e),u(ze,e),u(Ae,e),u(Se,e),u(Ke,e),u(Oe,e),u(et,e),u(at,e),u(nt,e),u(it,e),u(rt,e),u(dt,e),u(ft,e),u(yt,e),u(gt,e),u(Mt,e),u(_t,e),u($t,e),u(kt,e),u(Jt,e),u(Zt,e)}}}const $n='{"title":"Troubleshooting","local":"troubleshooting","sections":[{"title":"Examples don’t work","local":"examples-dont-work","sections":[],"depth":2},{"title":"Dtype-related issues","local":"dtype-related-issues","sections":[{"title":"ValueError: Attempting to unscale FP16 gradients","local":"valueerror-attempting-to-unscale-fp16-gradients","sections":[],"depth":3},{"title":"Selecting the dtype of the adapter","local":"selecting-the-dtype-of-the-adapter","sections":[],"depth":3}],"depth":2},{"title":"Bad results from a loaded PEFT model","local":"bad-results-from-a-loaded-peft-model","sections":[{"title":"Random deviations","local":"random-deviations","sections":[],"depth":3},{"title":"Incorrectly loaded model","local":"incorrectly-loaded-model","sections":[],"depth":3},{"title":"Randomly initialized layers","local":"randomly-initialized-layers","sections":[],"depth":3},{"title":"Extending the vocabulary","local":"extending-the-vocabulary","sections":[{"title":"Using trainable tokens","local":"using-trainable-tokens","sections":[],"depth":4},{"title":"Using an adapter, e.g. LoRA","local":"using-an-adapter-eg-lora","sections":[],"depth":4},{"title":"Full fine-tuning","local":"full-fine-tuning","sections":[],"depth":4}],"depth":3},{"title":"Getting a warning about “weights not being initialized from the model checkpoint”","local":"getting-a-warning-about-weights-not-being-initialized-from-the-model-checkpoint","sections":[],"depth":3},{"title":"Check layer and model status","local":"check-layer-and-model-status","sections":[],"depth":3}],"depth":2},{"title":"Speed","local":"speed","sections":[{"title":"Loading adapter weights is slow","local":"loading-adapter-weights-is-slow","sections":[],"depth":3}],"depth":2},{"title":"Reproducibility","local":"reproducibility","sections":[{"title":"Models using batch norm","local":"models-using-batch-norm","sections":[],"depth":3}],"depth":2},{"title":"Version mismatch","local":"version-mismatch","sections":[{"title":"Error while loading the config because of an unexpected keyword argument","local":"error-while-loading-the-config-because-of-an-unexpected-keyword-argument","sections":[],"depth":3}],"depth":2},{"title":"Adapter handling","local":"adapter-handling","sections":[{"title":"Using multiple adapters at the same time","local":"using-multiple-adapters-at-the-same-time","sections":[],"depth":3}],"depth":2}],"depth":1}';function jn(Na){return yn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Cn extends gn{constructor(g){super(),bn(this,g,jn,vn,un,{})}}export{Cn as component};
