# Context-aware Prompt Tuning: Advancing In-Context Learning with Adversarial Methods

[CPT](https://huggingface.co/papers/2410.17222) combines In-Context Learning (ICL), Prompt Tuning (PT), and adversarial optimization to improve few-shot learning by refining context embeddings. CPT updates the context tokens by optimizing both the context and the training examples, encapsulating them into a novel loss design that minimizes overfitting, enables more effective optimization, and drives significant improvements in classification tasks.

[//]: # ([CPT]&#40;https://huggingface.co/papers/2410.17222&#41; for the paper)

The abstract from the paper is:

> Large Language Models (LLMs) can perform few-shot learning using either optimization-based approaches or In-Context Learning (ICL). Optimization-based methods often suffer from overfitting, as they require updating a large number of parameters with limited data. In contrast, ICL avoids overfitting but typically underperforms compared to optimization-based methods and is highly sensitive to the selection, order, and format of demonstration examples. To overcome these challenges, we introduce Context-aware Prompt Tuning (CPT), a method inspired by ICL, Prompt Tuning (PT), and adversarial attacks. CPT builds on the ICL strategy of concatenating examples before the input, extending it by incorporating PT-like learning to refine the context embedding through iterative optimization, extracting deeper insights from the training examples. Our approach carefully modifies specific context tokens, considering the unique structure of the examples within the context. In addition to updating the context with PT-like optimization, CPT draws inspiration from adversarial attacks, adjusting the input based on the labels present in the context while preserving the inherent value of the user-provided data. To ensure robustness and stability during optimization, we employ a projected gradient descent algorithm, constraining token embeddings to remain close to their original values and safeguarding the quality of the context. Our method has demonstrated superior accuracy across multiple classification tasks using various LLM models, outperforming existing baselines and effectively addressing the overfitting challenge in few-shot learning.


Take a look at [Example](https://github.com/huggingface/peft/blob/main/examples/cpt_finetuning/README.md) for a step-by-step guide on how to train a model with CPT.


## CPTConfig[[peft.CPTConfig]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class peft.CPTConfig</name><anchor>peft.CPTConfig</anchor><source>https://github.com/huggingface/peft/blob/v0.18.0.rc0/src/peft/tuners/cpt/config.py#L23</source><parameters>[{"name": "task_type", "val": ": Optional[Union[str, TaskType]] = None"}, {"name": "peft_type", "val": ": Optional[Union[str, PeftType]] = None"}, {"name": "auto_mapping", "val": ": Optional[dict] = None"}, {"name": "peft_version", "val": ": Optional[str] = None"}, {"name": "base_model_name_or_path", "val": ": Optional[str] = None"}, {"name": "revision", "val": ": Optional[str] = None"}, {"name": "inference_mode", "val": ": bool = False"}, {"name": "num_virtual_tokens", "val": ": int = None"}, {"name": "token_dim", "val": ": int = None"}, {"name": "num_transformer_submodules", "val": ": Optional[int] = None"}, {"name": "num_attention_heads", "val": ": Optional[int] = None"}, {"name": "num_layers", "val": ": Optional[int] = None"}, {"name": "modules_to_save", "val": ": Optional[list[str]] = None"}, {"name": "cpt_token_ids", "val": ": typing.Optional[list[int]] = None"}, {"name": "cpt_mask", "val": ": typing.Optional[list[int]] = None"}, {"name": "cpt_tokens_type_mask", "val": ": typing.Optional[list[int]] = None"}, {"name": "opt_weighted_loss_type", "val": ": typing.Optional[typing.Literal['none', 'decay']] = 'none'"}, {"name": "opt_loss_decay_factor", "val": ": typing.Optional[float] = 1.0"}, {"name": "opt_projection_epsilon", "val": ": typing.Optional[float] = 0.1"}, {"name": "opt_projection_format_epsilon", "val": ": typing.Optional[float] = 0.1"}, {"name": "tokenizer_name_or_path", "val": ": typing.Optional[str] = None"}]</parameters></docstring>

CPT Configuration class extending PeftConfig for Context-aware Prompt Tuning (CPT).

This class introduces additional parameters required for CPT, such as:
- Token type masks
- Prompt tuning initialization
- Loss weighting
- Projection settings

For more details, see the paper: https://huggingface.co/papers/2410.17222


</div>

## CPTEmbedding[[peft.CPTEmbedding]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class peft.CPTEmbedding</name><anchor>peft.CPTEmbedding</anchor><source>https://github.com/huggingface/peft/blob/v0.18.0.rc0/src/peft/tuners/cpt/model.py#L23</source><parameters>[{"name": "config", "val": ""}, {"name": "word_embeddings", "val": ""}]</parameters></docstring>

CPTEmbedding is a custom embedding layer designed for Context-aware Prompt Tuning (CPT) in PEFT. It initializes
embeddings, applies prompt-specific projections, and computes loss using label masks.



<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>calculate_loss</name><anchor>peft.CPTEmbedding.calculate_loss</anchor><source>https://github.com/huggingface/peft/blob/v0.18.0.rc0/src/peft/tuners/cpt/model.py#L141</source><parameters>[{"name": "base_model_output", "val": ""}, {"name": "labels", "val": ""}, {"name": "cpt_type_mask", "val": ""}, {"name": "config", "val": ""}]</parameters><paramsdesc>- **base_model_output** (ModelOutput) --
  Output from the base model containing logits.
- **labels** (torch.Tensor) --
  Ground-truth labels for the input tokens.
- **cpt_type_mask** (torch.Tensor) --
  Token type mask used for filtering valid loss terms.
- **config** (Namespace) --
  Configuration object containing loss-related hyperparameters.</paramsdesc><paramgroups>0</paramgroups><rettype>ModelOutput</rettype><retdesc>The base model output with computed loss.</retdesc></docstring>

Computes the loss for CPT models with optional exponential decay.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>forward</name><anchor>peft.CPTEmbedding.forward</anchor><source>https://github.com/huggingface/peft/blob/v0.18.0.rc0/src/peft/tuners/cpt/model.py#L63</source><parameters>[{"name": "indices", "val": ""}]</parameters><paramsdesc>- **indices** (torch.Tensor) --
  Indices of the tokens to be embedded.</paramsdesc><paramgroups>0</paramgroups><rettype>torch.Tensor</rettype><retdesc>Sum of prompt embeddings and delta embeddings.</retdesc></docstring>

Computes the prompt embeddings and applies delta adjustments.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>get_projection</name><anchor>peft.CPTEmbedding.get_projection</anchor><source>https://github.com/huggingface/peft/blob/v0.18.0.rc0/src/peft/tuners/cpt/model.py#L123</source><parameters>[]</parameters></docstring>

Applies epsilon-based projection to the delta embeddings to control their norm.


</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>set_updated_tokens</name><anchor>peft.CPTEmbedding.set_updated_tokens</anchor><source>https://github.com/huggingface/peft/blob/v0.18.0.rc0/src/peft/tuners/cpt/model.py#L84</source><parameters>[]</parameters></docstring>

Sets up a backward hook to selectively update token gradients based on the CPT token type mask.


</div></div>

<EditOnGithub source="https://github.com/huggingface/peft/blob/main/docs/source/package_reference/cpt.md" />