import{S as yl,i as wl,s as jl,e as o,k as h,w as c,t as i,M as Jl,c as n,d as t,m as u,a as r,x as m,h as p,b as d,N as Tl,G as a,g as l,y as f,q as M,o as y,B as w,v as gl}from"../../chunks/vendor-hf-doc-builder.js";import{T as bl}from"../../chunks/Tip-hf-doc-builder.js";import{I as oa}from"../../chunks/IconCopyLink-hf-doc-builder.js";import{C as T}from"../../chunks/CodeBlock-hf-doc-builder.js";function Ul(tt){let j;return{c(){j=i(`\u{1F4A1} Some background on resampling: If an audio signal has been sampled at 8 kHz, so that it has 8000 sample readings per
second, we know that the audio does not contain any frequencies over 4 kHz. This is guaranteed by the Nyquist sampling
theorem. Because of this, we can be certain that in between the sampling points the original continuous signal always
makes a smooth curve. Upsampling to a higher sampling rate is then a matter of calculating additional sample values that go in between
the existing ones, by approximating this curve. Downsampling, however, requires that we first filter out any frequencies
that would be higher than the new Nyquist limit, before estimating the new sample points. In other words, you can't
downsample by a factor 2x by simply throwing away every other sample \u2014 this will create distortions in the signal called
aliases. Doing resampling correctly is tricky and best left to well-tested libraries such as librosa or \u{1F917} Datasets.`)},l(b){j=p(b,`\u{1F4A1} Some background on resampling: If an audio signal has been sampled at 8 kHz, so that it has 8000 sample readings per
second, we know that the audio does not contain any frequencies over 4 kHz. This is guaranteed by the Nyquist sampling
theorem. Because of this, we can be certain that in between the sampling points the original continuous signal always
makes a smooth curve. Upsampling to a higher sampling rate is then a matter of calculating additional sample values that go in between
the existing ones, by approximating this curve. Downsampling, however, requires that we first filter out any frequencies
that would be higher than the new Nyquist limit, before estimating the new sample points. In other words, you can't
downsample by a factor 2x by simply throwing away every other sample \u2014 this will create distortions in the signal called
aliases. Doing resampling correctly is tricky and best left to well-tested libraries such as librosa or \u{1F917} Datasets.`)},m(b,g){l(b,j,g)},d(b){b&&t(j)}}}function vl(tt){let j,b,g,E,ke,S,na,Ee,ra,at,ue,ia,st,U,$e,pa,ha,xe,ua,da,Ce,ca,lt,A,$,Be,V,ma,Re,fa,ot,x,Ma,We,ya,wa,nt,de,ja,rt,C,Ja,Ze,Ta,ga,it,F,pt,B,ba,Ne,Ua,va,ht,H,ut,ce,Ge,Ia,dt,Q,ct,me,Aa,mt,R,ft,_,W,qe,D,_a,Xe,ka,Mt,fe,Ea,yt,J,$a,Ye,xa,Ca,ze,Ba,Ra,Se,Wa,Za,Ve,Na,Ga,wt,P,jt,Me,qa,Jt,O,Tt,ye,Fe,Xa,gt,L,bt,we,Ya,Ut,k,Z,He,K,za,Qe,Sa,vt,je,Va,It,N,Fa,ee,Ha,Qa,At,Je,Da,_t,Te,Pa,kt,ge,Oa,Et,te,$t,G,La,De,Ka,es,xt,ae,Ct,be,ts,Bt,se,Rt,Ue,Pe,as,Wt,le,Zt,q,ss,Oe,ls,os,Nt,X,ns,Le,rs,is,Gt,oe,qt,ne,ve,Ts,Xt,Ie,ps,Yt,Y,hs,re,us,ds,zt,z,cs,Ke,ms,fs,St,ie,Vt,v,Ms,et,ys,ws,pe,js,Js,Ft;return S=new oa({}),V=new oa({}),F=new T({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2XzAwMCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

minds = minds.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16_000</span>))`}}),H=new T({props:{code:"bWluZHMlNUIwJTVE",highlighted:'minds[<span class="hljs-number">0</span>]'}}),Q=new T({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAyLjA2MzQyNDNlLTA1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS45NDM3ODM3ZS0wNCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDIuMjQxOTM0MGUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjA5LjM4NTI4NjJlLTA0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS4xMzAyNDUyZS0wMyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDcuMTUzMTQyOWUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDE2MDAwJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSU3RA==",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [
                <span class="hljs-number">2.0634243e-05</span>,
                <span class="hljs-number">1.9437837e-04</span>,
                <span class="hljs-number">2.2419340e-04</span>,
                ...,
                <span class="hljs-number">9.3852862e-04</span>,
                <span class="hljs-number">1.1302452e-03</span>,
                <span class="hljs-number">7.1531429e-04</span>,
            ],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">16000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
}`}}),R=new bl({props:{$$slots:{default:[Ul]},$$scope:{ctx:tt}}}),D=new oa({}),P=new T({props:{code:"TUFYX0RVUkFUSU9OX0lOX1NFQ09ORFMlMjAlM0QlMjAyMC4wJTBBJTBBJTBBZGVmJTIwaXNfYXVkaW9fbGVuZ3RoX2luX3JhbmdlKGlucHV0X2xlbmd0aCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dF9sZW5ndGglMjAlM0MlMjBNQVhfRFVSQVRJT05fSU5fU0VDT05EUw==",highlighted:`MAX_DURATION_IN_SECONDS = <span class="hljs-number">20.0</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_audio_length_in_range</span>(<span class="hljs-params">input_length</span>):
    <span class="hljs-keyword">return</span> input_length &lt; MAX_DURATION_IN_SECONDS`}}),O=new T({props:{code:"JTIzJTIwdXNlJTIwbGlicm9zYSUyMHRvJTIwZ2V0JTIwZXhhbXBsZSdzJTIwZHVyYXRpb24lMjBmcm9tJTIwdGhlJTIwYXVkaW8lMjBmaWxlJTBBbmV3X2NvbHVtbiUyMCUzRCUyMCU1QmxpYnJvc2EuZ2V0X2R1cmF0aW9uKHBhdGglM0R4KSUyMGZvciUyMHglMjBpbiUyMG1pbmRzJTVCJTIycGF0aCUyMiU1RCU1RCUwQW1pbmRzJTIwJTNEJTIwbWluZHMuYWRkX2NvbHVtbiglMjJkdXJhdGlvbiUyMiUyQyUyMG5ld19jb2x1bW4pJTBBJTBBJTIzJTIwdXNlJTIwJUYwJTlGJUE0JTk3JTIwRGF0YXNldHMnJTIwJTYwZmlsdGVyJTYwJTIwbWV0aG9kJTIwdG8lMjBhcHBseSUyMHRoZSUyMGZpbHRlcmluZyUyMGZ1bmN0aW9uJTBBbWluZHMlMjAlM0QlMjBtaW5kcy5maWx0ZXIoaXNfYXVkaW9fbGVuZ3RoX2luX3JhbmdlJTJDJTIwaW5wdXRfY29sdW1ucyUzRCU1QiUyMmR1cmF0aW9uJTIyJTVEKSUwQSUwQSUyMyUyMHJlbW92ZSUyMHRoZSUyMHRlbXBvcmFyeSUyMGhlbHBlciUyMGNvbHVtbiUwQW1pbmRzJTIwJTNEJTIwbWluZHMucmVtb3ZlX2NvbHVtbnMoJTVCJTIyZHVyYXRpb24lMjIlNUQpJTBBbWluZHM=",highlighted:`<span class="hljs-comment"># use librosa to get example&#x27;s duration from the audio file</span>
new_column = [librosa.get_duration(path=x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> minds[<span class="hljs-string">&quot;path&quot;</span>]]
minds = minds.add_column(<span class="hljs-string">&quot;duration&quot;</span>, new_column)

<span class="hljs-comment"># use \u{1F917} Datasets&#x27; \`filter\` method to apply the filtering function</span>
minds = minds.<span class="hljs-built_in">filter</span>(is_audio_length_in_range, input_columns=[<span class="hljs-string">&quot;duration&quot;</span>])

<span class="hljs-comment"># remove the temporary helper column</span>
minds = minds.remove_columns([<span class="hljs-string">&quot;duration&quot;</span>])
minds`}}),L=new T({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDYyNCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 624})</span>'}}),K=new oa({}),te=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdoaXNwZXJGZWF0dXJlRXh0cmFjdG9yJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBXaGlzcGVyRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci1zbWFsbCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WhisperFeatureExtractor

feature_extractor = WhisperFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`}}),ae=new T({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEYXVkaW8lNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTJDJTIwcGFkZGluZyUzRFRydWUlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZmVhdHVyZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    features = feature_extractor(
        audio[<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>], padding=<span class="hljs-literal">True</span>
    )
    <span class="hljs-keyword">return</span> features`}}),se=new T({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy5tYXAocHJlcGFyZV9kYXRhc2V0KSUwQW1pbmRz",highlighted:`minds = minds.<span class="hljs-built_in">map</span>(prepare_dataset)
minds`}}),le=new T({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMjAlMjJpbnB1dF9mZWF0dXJlcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwNjI0JTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>, <span class="hljs-string">&quot;input_features&quot;</span>],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">624</span>,
    <span class="hljs-punctuation">}</span>
)`}}),oe=new T({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWlucHV0X2ZlYXR1cmVzJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmlucHV0X2ZlYXR1cmVzJTIyJTVEJTBBJTBBcGx0LmZpZ3VyZSgpLnNldF9maWd3aWR0aCgxMiklMEFsaWJyb3NhLmRpc3BsYXkuc3BlY3Nob3coJTBBJTIwJTIwJTIwJTIwbnAuYXNhcnJheShpbnB1dF9mZWF0dXJlcyU1QjAlNUQpJTJDJTBBJTIwJTIwJTIwJTIweF9heGlzJTNEJTIydGltZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHlfYXhpcyUzRCUyMm1lbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNyJTNEZmVhdHVyZV9leHRyYWN0b3Iuc2FtcGxpbmdfcmF0ZSUyQyUwQSUyMCUyMCUyMCUyMGhvcF9sZW5ndGglM0RmZWF0dXJlX2V4dHJhY3Rvci5ob3BfbGVuZ3RoJTJDJTBBKSUwQXBsdC5jb2xvcmJhcigp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

example = minds[<span class="hljs-number">0</span>]
input_features = example[<span class="hljs-string">&quot;input_features&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.specshow(
    np.asarray(input_features[<span class="hljs-number">0</span>]),
    x_axis=<span class="hljs-string">&quot;time&quot;</span>,
    y_axis=<span class="hljs-string">&quot;mel&quot;</span>,
    sr=feature_extractor.sampling_rate,
    hop_length=feature_extractor.hop_length,
)
plt.colorbar()`}}),ie=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`}}),{c(){j=o("meta"),b=h(),g=o("h1"),E=o("a"),ke=o("span"),c(S.$$.fragment),na=h(),Ee=o("span"),ra=i("Preprocessing an audio dataset"),at=h(),ue=o("p"),ia=i(`Loading a dataset with \u{1F917} Datasets is just half of the fun. If you plan to use it either for training a model, or for running
inference, you will need to pre-process the data first. In general, this will involve the following steps:`),st=h(),U=o("ul"),$e=o("li"),pa=i("Resampling the audio data"),ha=h(),xe=o("li"),ua=i("Filtering the dataset"),da=h(),Ce=o("li"),ca=i("Converting audio data to model\u2019s expected input"),lt=h(),A=o("h2"),$=o("a"),Be=o("span"),c(V.$$.fragment),ma=h(),Re=o("span"),fa=i("Resampling the audio data"),ot=h(),x=o("p"),Ma=i("The "),We=o("code"),ya=i("load_dataset"),wa=i(` function downloads audio examples with the sampling rate that they were published with. This is not
always the sampling rate expected by a model you plan to train, or use for inference. If there\u2019s a discrepancy between
the sampling rates, you can resample the audio to the model\u2019s expected sampling rate.`),nt=h(),de=o("p"),ja=i(`Most of the available pretrained models have been pretrained on audio datasets at a sampling rate of 16 kHz.
When we explored MINDS-14 dataset, you may have noticed that it is sampled at 8 kHz, which means we will likely need
to upsample it.`),rt=h(),C=o("p"),Ja=i("To do so, use \u{1F917} Datasets\u2019 "),Ze=o("code"),Ta=i("cast_column"),ga=i(` method. This operation does not change the audio in-place, but rather signals
to datasets to resample the audio examples on the fly when they are loaded. The following code will set the sampling
rate to 16kHz:`),it=h(),c(F.$$.fragment),pt=h(),B=o("p"),ba=i("Re-load the first audio example in the MINDS-14 dataset, and check that it has been resampled to the desired "),Ne=o("code"),Ua=i("sampling rate"),va=i(":"),ht=h(),c(H.$$.fragment),ut=h(),ce=o("p"),Ge=o("strong"),Ia=i("Output:"),dt=h(),c(Q.$$.fragment),ct=h(),me=o("p"),Aa=i(`You may notice that the array values are now also different. This is because we\u2019ve now got twice the number of amplitude values for
every one that we had before.`),mt=h(),c(R.$$.fragment),ft=h(),_=o("h2"),W=o("a"),qe=o("span"),c(D.$$.fragment),_a=h(),Xe=o("span"),ka=i("Filtering the dataset"),Mt=h(),fe=o("p"),Ea=i(`You may need to filter the data based on some criteria. One of the common cases involves limiting the audio examples to a
certain duration. For instance, we might want to filter out any examples longer than 20s to prevent out-of-memory errors
when training a model.`),yt=h(),J=o("p"),$a=i("We can do this by using the  \u{1F917} Datasets\u2019 "),Ye=o("code"),xa=i("filter"),Ca=i(` method and passing a function with filtering logic to it. Let\u2019s start by writing a
function that indicates which examples to keep and which to discard. This function, `),ze=o("code"),Ba=i("is_audio_length_in_range"),Ra=i(`,
returns `),Se=o("code"),Wa=i("True"),Za=i(" if a sample is shorter than 20s, and "),Ve=o("code"),Na=i("False"),Ga=i(" if it is longer than 20s."),wt=h(),c(P.$$.fragment),jt=h(),Me=o("p"),qa=i(`The filtering function can be applied to a dataset\u2019s column but we do not have a column with audio track duration in this
dataset. However, we can create one, filter based on the values in that column, and then remove it.`),Jt=h(),c(O.$$.fragment),Tt=h(),ye=o("p"),Fe=o("strong"),Xa=i("Output:"),gt=h(),c(L.$$.fragment),bt=h(),we=o("p"),Ya=i("We can verify that dataset has been filtered down from 654 examples to 624."),Ut=h(),k=o("h2"),Z=o("a"),He=o("span"),c(K.$$.fragment),za=h(),Qe=o("span"),Sa=i("Pre-processing audio data"),vt=h(),je=o("p"),Va=i(`One of the most challenging aspects of working with audio datasets is preparing the data in the right format for model
training. As you saw, the raw audio data comes as an array of sample values. However, pre-trained models, whether you use them
for inference, or want to fine-tune them for your task, expect the raw data to be converted into input features. The
requirements for the input features may vary from one model to another \u2014 they depend on the model\u2019s architecture, and the data it was
pre-trained with. The good news is, for every supported audio model, \u{1F917} Transformers offer a feature extractor class
that can convert raw audio data into the input features the model expects.`),It=h(),N=o("p"),Fa=i("So what does a feature extractor do with the raw audio data? Let\u2019s take a look at "),ee=o("a"),Ha=i("Whisper"),Qa=i(`\u2019s
feature extractor to understand some common feature extraction transformations. Whisper is a pre-trained model for
automatic speech recognition (ASR) published in September 2022 by Alec Radford et al. from OpenAI.`),At=h(),Je=o("p"),Da=i(`First, the Whisper feature extractor pads/truncates a batch of audio examples such that all
examples have an input length of 30s. Examples shorter than this are padded to 30s by appending zeros to the end of the
sequence (zeros in an audio signal correspond to no signal or silence). Examples longer than 30s are truncated to 30s.
Since all elements in the batch are padded/truncated to a maximum length in the input space, there is no need for an attention
mask. Whisper is unique in this regard, most other audio models require an attention mask that details
where sequences have been padded, and thus where they should be ignored in the self-attention mechanism. Whisper is
trained to operate without an attention mask and infer directly from the speech signals where to ignore the inputs.`),_t=h(),Te=o("p"),Pa=i(`The second operation that the Whisper feature extractor performs is converting the padded audio arrays to log-mel spectrograms.
As you recall, these spectrograms describe how the frequencies of a signal change over time, expressed on the mel scale
and measured in decibels (the log part) to make the frequencies and amplitudes more representative of human hearing.`),kt=h(),ge=o("p"),Oa=i(`All these transformations can be applied to your raw audio data with a couple of lines of code. Let\u2019s go ahead and load
the feature extractor from the pre-trained Whisper checkpoint to have ready for our audio data:`),Et=h(),c(te.$$.fragment),$t=h(),G=o("p"),La=i("Next, you can write a function to pre-process a single audio example by passing it through the "),De=o("code"),Ka=i("feature_extractor"),es=i("."),xt=h(),c(ae.$$.fragment),Ct=h(),be=o("p"),ts=i("We can apply the data preparation function to all of our training examples using \u{1F917} Datasets\u2019 map method:"),Bt=h(),c(se.$$.fragment),Rt=h(),Ue=o("p"),Pe=o("strong"),as=i("Output:"),Wt=h(),c(le.$$.fragment),Zt=h(),q=o("p"),ss=i("As easy as that, we now have log-mel spectrograms as "),Oe=o("code"),ls=i("input_features"),os=i(" in the dataset."),Nt=h(),X=o("p"),ns=i("Let\u2019s visualize it for one of the examples in the "),Le=o("code"),rs=i("minds"),is=i(" dataset:"),Gt=h(),c(oe.$$.fragment),qt=h(),ne=o("div"),ve=o("img"),Xt=h(),Ie=o("p"),ps=i("Now you can see what the audio input to the Whisper model looks like after preprocessing."),Yt=h(),Y=o("p"),hs=i(`The model\u2019s feature extractor class takes care of transforming raw audio data to the format that the model expects. However,
many tasks involving audio are multimodal, e.g. speech recognition. In such cases \u{1F917} Transformers also offer model-specific
tokenizers to process the text inputs. For a deep dive into tokenizers, please refer to our `),re=o("a"),us=i("NLP course"),ds=i("."),zt=h(),z=o("p"),cs=i(`You can load the feature extractor and tokenizer for Whisper and other multimodal models separately, or you can load both via
a so-called processor. To make things even simpler, use `),Ke=o("code"),ms=i("AutoProcessor"),fs=i(` to load a model\u2019s feature extractor and processor from a
checkpoint, like this:`),St=h(),c(ie.$$.fragment),Vt=h(),v=o("p"),Ms=i(`Here we have illustrated the fundamental data preparation steps. Of course, custom data may require more complex preprocessing.
In this case, you can extend the function `),et=o("code"),ys=i("prepare_dataset"),ws=i(` to perform any sort of custom data transformations. With \u{1F917} Datasets,
if you can write it as a Python function, you can `),pe=o("a"),js=i("apply it"),Js=i(" to your dataset!"),this.h()},l(e){const s=Jl('[data-svelte="svelte-1phssyn"]',document.head);j=n(s,"META",{name:!0,content:!0}),s.forEach(t),b=u(e),g=n(e,"H1",{class:!0});var he=r(g);E=n(he,"A",{id:!0,class:!0,href:!0});var gs=r(E);ke=n(gs,"SPAN",{});var bs=r(ke);m(S.$$.fragment,bs),bs.forEach(t),gs.forEach(t),na=u(he),Ee=n(he,"SPAN",{});var Us=r(Ee);ra=p(Us,"Preprocessing an audio dataset"),Us.forEach(t),he.forEach(t),at=u(e),ue=n(e,"P",{});var vs=r(ue);ia=p(vs,`Loading a dataset with \u{1F917} Datasets is just half of the fun. If you plan to use it either for training a model, or for running
inference, you will need to pre-process the data first. In general, this will involve the following steps:`),vs.forEach(t),st=u(e),U=n(e,"UL",{});var Ae=r(U);$e=n(Ae,"LI",{});var Is=r($e);pa=p(Is,"Resampling the audio data"),Is.forEach(t),ha=u(Ae),xe=n(Ae,"LI",{});var As=r(xe);ua=p(As,"Filtering the dataset"),As.forEach(t),da=u(Ae),Ce=n(Ae,"LI",{});var _s=r(Ce);ca=p(_s,"Converting audio data to model\u2019s expected input"),_s.forEach(t),Ae.forEach(t),lt=u(e),A=n(e,"H2",{class:!0});var Ht=r(A);$=n(Ht,"A",{id:!0,class:!0,href:!0});var ks=r($);Be=n(ks,"SPAN",{});var Es=r(Be);m(V.$$.fragment,Es),Es.forEach(t),ks.forEach(t),ma=u(Ht),Re=n(Ht,"SPAN",{});var $s=r(Re);fa=p($s,"Resampling the audio data"),$s.forEach(t),Ht.forEach(t),ot=u(e),x=n(e,"P",{});var Qt=r(x);Ma=p(Qt,"The "),We=n(Qt,"CODE",{});var xs=r(We);ya=p(xs,"load_dataset"),xs.forEach(t),wa=p(Qt,` function downloads audio examples with the sampling rate that they were published with. This is not
always the sampling rate expected by a model you plan to train, or use for inference. If there\u2019s a discrepancy between
the sampling rates, you can resample the audio to the model\u2019s expected sampling rate.`),Qt.forEach(t),nt=u(e),de=n(e,"P",{});var Cs=r(de);ja=p(Cs,`Most of the available pretrained models have been pretrained on audio datasets at a sampling rate of 16 kHz.
When we explored MINDS-14 dataset, you may have noticed that it is sampled at 8 kHz, which means we will likely need
to upsample it.`),Cs.forEach(t),rt=u(e),C=n(e,"P",{});var Dt=r(C);Ja=p(Dt,"To do so, use \u{1F917} Datasets\u2019 "),Ze=n(Dt,"CODE",{});var Bs=r(Ze);Ta=p(Bs,"cast_column"),Bs.forEach(t),ga=p(Dt,` method. This operation does not change the audio in-place, but rather signals
to datasets to resample the audio examples on the fly when they are loaded. The following code will set the sampling
rate to 16kHz:`),Dt.forEach(t),it=u(e),m(F.$$.fragment,e),pt=u(e),B=n(e,"P",{});var Pt=r(B);ba=p(Pt,"Re-load the first audio example in the MINDS-14 dataset, and check that it has been resampled to the desired "),Ne=n(Pt,"CODE",{});var Rs=r(Ne);Ua=p(Rs,"sampling rate"),Rs.forEach(t),va=p(Pt,":"),Pt.forEach(t),ht=u(e),m(H.$$.fragment,e),ut=u(e),ce=n(e,"P",{});var Ws=r(ce);Ge=n(Ws,"STRONG",{});var Zs=r(Ge);Ia=p(Zs,"Output:"),Zs.forEach(t),Ws.forEach(t),dt=u(e),m(Q.$$.fragment,e),ct=u(e),me=n(e,"P",{});var Ns=r(me);Aa=p(Ns,`You may notice that the array values are now also different. This is because we\u2019ve now got twice the number of amplitude values for
every one that we had before.`),Ns.forEach(t),mt=u(e),m(R.$$.fragment,e),ft=u(e),_=n(e,"H2",{class:!0});var Ot=r(_);W=n(Ot,"A",{id:!0,class:!0,href:!0});var Gs=r(W);qe=n(Gs,"SPAN",{});var qs=r(qe);m(D.$$.fragment,qs),qs.forEach(t),Gs.forEach(t),_a=u(Ot),Xe=n(Ot,"SPAN",{});var Xs=r(Xe);ka=p(Xs,"Filtering the dataset"),Xs.forEach(t),Ot.forEach(t),Mt=u(e),fe=n(e,"P",{});var Ys=r(fe);Ea=p(Ys,`You may need to filter the data based on some criteria. One of the common cases involves limiting the audio examples to a
certain duration. For instance, we might want to filter out any examples longer than 20s to prevent out-of-memory errors
when training a model.`),Ys.forEach(t),yt=u(e),J=n(e,"P",{});var I=r(J);$a=p(I,"We can do this by using the  \u{1F917} Datasets\u2019 "),Ye=n(I,"CODE",{});var zs=r(Ye);xa=p(zs,"filter"),zs.forEach(t),Ca=p(I,` method and passing a function with filtering logic to it. Let\u2019s start by writing a
function that indicates which examples to keep and which to discard. This function, `),ze=n(I,"CODE",{});var Ss=r(ze);Ba=p(Ss,"is_audio_length_in_range"),Ss.forEach(t),Ra=p(I,`,
returns `),Se=n(I,"CODE",{});var Vs=r(Se);Wa=p(Vs,"True"),Vs.forEach(t),Za=p(I," if a sample is shorter than 20s, and "),Ve=n(I,"CODE",{});var Fs=r(Ve);Na=p(Fs,"False"),Fs.forEach(t),Ga=p(I," if it is longer than 20s."),I.forEach(t),wt=u(e),m(P.$$.fragment,e),jt=u(e),Me=n(e,"P",{});var Hs=r(Me);qa=p(Hs,`The filtering function can be applied to a dataset\u2019s column but we do not have a column with audio track duration in this
dataset. However, we can create one, filter based on the values in that column, and then remove it.`),Hs.forEach(t),Jt=u(e),m(O.$$.fragment,e),Tt=u(e),ye=n(e,"P",{});var Qs=r(ye);Fe=n(Qs,"STRONG",{});var Ds=r(Fe);Xa=p(Ds,"Output:"),Ds.forEach(t),Qs.forEach(t),gt=u(e),m(L.$$.fragment,e),bt=u(e),we=n(e,"P",{});var Ps=r(we);Ya=p(Ps,"We can verify that dataset has been filtered down from 654 examples to 624."),Ps.forEach(t),Ut=u(e),k=n(e,"H2",{class:!0});var Lt=r(k);Z=n(Lt,"A",{id:!0,class:!0,href:!0});var Os=r(Z);He=n(Os,"SPAN",{});var Ls=r(He);m(K.$$.fragment,Ls),Ls.forEach(t),Os.forEach(t),za=u(Lt),Qe=n(Lt,"SPAN",{});var Ks=r(Qe);Sa=p(Ks,"Pre-processing audio data"),Ks.forEach(t),Lt.forEach(t),vt=u(e),je=n(e,"P",{});var el=r(je);Va=p(el,`One of the most challenging aspects of working with audio datasets is preparing the data in the right format for model
training. As you saw, the raw audio data comes as an array of sample values. However, pre-trained models, whether you use them
for inference, or want to fine-tune them for your task, expect the raw data to be converted into input features. The
requirements for the input features may vary from one model to another \u2014 they depend on the model\u2019s architecture, and the data it was
pre-trained with. The good news is, for every supported audio model, \u{1F917} Transformers offer a feature extractor class
that can convert raw audio data into the input features the model expects.`),el.forEach(t),It=u(e),N=n(e,"P",{});var Kt=r(N);Fa=p(Kt,"So what does a feature extractor do with the raw audio data? Let\u2019s take a look at "),ee=n(Kt,"A",{href:!0,rel:!0});var tl=r(ee);Ha=p(tl,"Whisper"),tl.forEach(t),Qa=p(Kt,`\u2019s
feature extractor to understand some common feature extraction transformations. Whisper is a pre-trained model for
automatic speech recognition (ASR) published in September 2022 by Alec Radford et al. from OpenAI.`),Kt.forEach(t),At=u(e),Je=n(e,"P",{});var al=r(Je);Da=p(al,`First, the Whisper feature extractor pads/truncates a batch of audio examples such that all
examples have an input length of 30s. Examples shorter than this are padded to 30s by appending zeros to the end of the
sequence (zeros in an audio signal correspond to no signal or silence). Examples longer than 30s are truncated to 30s.
Since all elements in the batch are padded/truncated to a maximum length in the input space, there is no need for an attention
mask. Whisper is unique in this regard, most other audio models require an attention mask that details
where sequences have been padded, and thus where they should be ignored in the self-attention mechanism. Whisper is
trained to operate without an attention mask and infer directly from the speech signals where to ignore the inputs.`),al.forEach(t),_t=u(e),Te=n(e,"P",{});var sl=r(Te);Pa=p(sl,`The second operation that the Whisper feature extractor performs is converting the padded audio arrays to log-mel spectrograms.
As you recall, these spectrograms describe how the frequencies of a signal change over time, expressed on the mel scale
and measured in decibels (the log part) to make the frequencies and amplitudes more representative of human hearing.`),sl.forEach(t),kt=u(e),ge=n(e,"P",{});var ll=r(ge);Oa=p(ll,`All these transformations can be applied to your raw audio data with a couple of lines of code. Let\u2019s go ahead and load
the feature extractor from the pre-trained Whisper checkpoint to have ready for our audio data:`),ll.forEach(t),Et=u(e),m(te.$$.fragment,e),$t=u(e),G=n(e,"P",{});var ea=r(G);La=p(ea,"Next, you can write a function to pre-process a single audio example by passing it through the "),De=n(ea,"CODE",{});var ol=r(De);Ka=p(ol,"feature_extractor"),ol.forEach(t),es=p(ea,"."),ea.forEach(t),xt=u(e),m(ae.$$.fragment,e),Ct=u(e),be=n(e,"P",{});var nl=r(be);ts=p(nl,"We can apply the data preparation function to all of our training examples using \u{1F917} Datasets\u2019 map method:"),nl.forEach(t),Bt=u(e),m(se.$$.fragment,e),Rt=u(e),Ue=n(e,"P",{});var rl=r(Ue);Pe=n(rl,"STRONG",{});var il=r(Pe);as=p(il,"Output:"),il.forEach(t),rl.forEach(t),Wt=u(e),m(le.$$.fragment,e),Zt=u(e),q=n(e,"P",{});var ta=r(q);ss=p(ta,"As easy as that, we now have log-mel spectrograms as "),Oe=n(ta,"CODE",{});var pl=r(Oe);ls=p(pl,"input_features"),pl.forEach(t),os=p(ta," in the dataset."),ta.forEach(t),Nt=u(e),X=n(e,"P",{});var aa=r(X);ns=p(aa,"Let\u2019s visualize it for one of the examples in the "),Le=n(aa,"CODE",{});var hl=r(Le);rs=p(hl,"minds"),hl.forEach(t),is=p(aa," dataset:"),aa.forEach(t),Gt=u(e),m(oe.$$.fragment,e),qt=u(e),ne=n(e,"DIV",{class:!0});var ul=r(ne);ve=n(ul,"IMG",{src:!0,alt:!0}),ul.forEach(t),Xt=u(e),Ie=n(e,"P",{});var dl=r(Ie);ps=p(dl,"Now you can see what the audio input to the Whisper model looks like after preprocessing."),dl.forEach(t),Yt=u(e),Y=n(e,"P",{});var sa=r(Y);hs=p(sa,`The model\u2019s feature extractor class takes care of transforming raw audio data to the format that the model expects. However,
many tasks involving audio are multimodal, e.g. speech recognition. In such cases \u{1F917} Transformers also offer model-specific
tokenizers to process the text inputs. For a deep dive into tokenizers, please refer to our `),re=n(sa,"A",{href:!0,rel:!0});var cl=r(re);us=p(cl,"NLP course"),cl.forEach(t),ds=p(sa,"."),sa.forEach(t),zt=u(e),z=n(e,"P",{});var la=r(z);cs=p(la,`You can load the feature extractor and tokenizer for Whisper and other multimodal models separately, or you can load both via
a so-called processor. To make things even simpler, use `),Ke=n(la,"CODE",{});var ml=r(Ke);ms=p(ml,"AutoProcessor"),ml.forEach(t),fs=p(la,` to load a model\u2019s feature extractor and processor from a
checkpoint, like this:`),la.forEach(t),St=u(e),m(ie.$$.fragment,e),Vt=u(e),v=n(e,"P",{});var _e=r(v);Ms=p(_e,`Here we have illustrated the fundamental data preparation steps. Of course, custom data may require more complex preprocessing.
In this case, you can extend the function `),et=n(_e,"CODE",{});var fl=r(et);ys=p(fl,"prepare_dataset"),fl.forEach(t),ws=p(_e,` to perform any sort of custom data transformations. With \u{1F917} Datasets,
if you can write it as a Python function, you can `),pe=n(_e,"A",{href:!0,rel:!0});var Ml=r(pe);js=p(Ml,"apply it"),Ml.forEach(t),Js=p(_e," to your dataset!"),_e.forEach(t),this.h()},h(){d(j,"name","hf:doc:metadata"),d(j,"content",JSON.stringify(Il)),d(E,"id","preprocessing-an-audio-dataset"),d(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(E,"href","#preprocessing-an-audio-dataset"),d(g,"class","relative group"),d($,"id","resampling-the-audio-data"),d($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d($,"href","#resampling-the-audio-data"),d(A,"class","relative group"),d(W,"id","filtering-the-dataset"),d(W,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(W,"href","#filtering-the-dataset"),d(_,"class","relative group"),d(Z,"id","preprocessing-audio-data"),d(Z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Z,"href","#preprocessing-audio-data"),d(k,"class","relative group"),d(ee,"href","https://huggingface.co/papers/2212.04356"),d(ee,"rel","nofollow"),Tl(ve.src,Ts="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/log_mel_whisper.png")||d(ve,"src",Ts),d(ve,"alt","Log mel spectrogram plot"),d(ne,"class","flex justify-center"),d(re,"href","https://huggingface.co/course/chapter2/4"),d(re,"rel","nofollow"),d(pe,"href","https://huggingface.co/docs/datasets/audio_process"),d(pe,"rel","nofollow")},m(e,s){a(document.head,j),l(e,b,s),l(e,g,s),a(g,E),a(E,ke),f(S,ke,null),a(g,na),a(g,Ee),a(Ee,ra),l(e,at,s),l(e,ue,s),a(ue,ia),l(e,st,s),l(e,U,s),a(U,$e),a($e,pa),a(U,ha),a(U,xe),a(xe,ua),a(U,da),a(U,Ce),a(Ce,ca),l(e,lt,s),l(e,A,s),a(A,$),a($,Be),f(V,Be,null),a(A,ma),a(A,Re),a(Re,fa),l(e,ot,s),l(e,x,s),a(x,Ma),a(x,We),a(We,ya),a(x,wa),l(e,nt,s),l(e,de,s),a(de,ja),l(e,rt,s),l(e,C,s),a(C,Ja),a(C,Ze),a(Ze,Ta),a(C,ga),l(e,it,s),f(F,e,s),l(e,pt,s),l(e,B,s),a(B,ba),a(B,Ne),a(Ne,Ua),a(B,va),l(e,ht,s),f(H,e,s),l(e,ut,s),l(e,ce,s),a(ce,Ge),a(Ge,Ia),l(e,dt,s),f(Q,e,s),l(e,ct,s),l(e,me,s),a(me,Aa),l(e,mt,s),f(R,e,s),l(e,ft,s),l(e,_,s),a(_,W),a(W,qe),f(D,qe,null),a(_,_a),a(_,Xe),a(Xe,ka),l(e,Mt,s),l(e,fe,s),a(fe,Ea),l(e,yt,s),l(e,J,s),a(J,$a),a(J,Ye),a(Ye,xa),a(J,Ca),a(J,ze),a(ze,Ba),a(J,Ra),a(J,Se),a(Se,Wa),a(J,Za),a(J,Ve),a(Ve,Na),a(J,Ga),l(e,wt,s),f(P,e,s),l(e,jt,s),l(e,Me,s),a(Me,qa),l(e,Jt,s),f(O,e,s),l(e,Tt,s),l(e,ye,s),a(ye,Fe),a(Fe,Xa),l(e,gt,s),f(L,e,s),l(e,bt,s),l(e,we,s),a(we,Ya),l(e,Ut,s),l(e,k,s),a(k,Z),a(Z,He),f(K,He,null),a(k,za),a(k,Qe),a(Qe,Sa),l(e,vt,s),l(e,je,s),a(je,Va),l(e,It,s),l(e,N,s),a(N,Fa),a(N,ee),a(ee,Ha),a(N,Qa),l(e,At,s),l(e,Je,s),a(Je,Da),l(e,_t,s),l(e,Te,s),a(Te,Pa),l(e,kt,s),l(e,ge,s),a(ge,Oa),l(e,Et,s),f(te,e,s),l(e,$t,s),l(e,G,s),a(G,La),a(G,De),a(De,Ka),a(G,es),l(e,xt,s),f(ae,e,s),l(e,Ct,s),l(e,be,s),a(be,ts),l(e,Bt,s),f(se,e,s),l(e,Rt,s),l(e,Ue,s),a(Ue,Pe),a(Pe,as),l(e,Wt,s),f(le,e,s),l(e,Zt,s),l(e,q,s),a(q,ss),a(q,Oe),a(Oe,ls),a(q,os),l(e,Nt,s),l(e,X,s),a(X,ns),a(X,Le),a(Le,rs),a(X,is),l(e,Gt,s),f(oe,e,s),l(e,qt,s),l(e,ne,s),a(ne,ve),l(e,Xt,s),l(e,Ie,s),a(Ie,ps),l(e,Yt,s),l(e,Y,s),a(Y,hs),a(Y,re),a(re,us),a(Y,ds),l(e,zt,s),l(e,z,s),a(z,cs),a(z,Ke),a(Ke,ms),a(z,fs),l(e,St,s),f(ie,e,s),l(e,Vt,s),l(e,v,s),a(v,Ms),a(v,et),a(et,ys),a(v,ws),a(v,pe),a(pe,js),a(v,Js),Ft=!0},p(e,[s]){const he={};s&2&&(he.$$scope={dirty:s,ctx:e}),R.$set(he)},i(e){Ft||(M(S.$$.fragment,e),M(V.$$.fragment,e),M(F.$$.fragment,e),M(H.$$.fragment,e),M(Q.$$.fragment,e),M(R.$$.fragment,e),M(D.$$.fragment,e),M(P.$$.fragment,e),M(O.$$.fragment,e),M(L.$$.fragment,e),M(K.$$.fragment,e),M(te.$$.fragment,e),M(ae.$$.fragment,e),M(se.$$.fragment,e),M(le.$$.fragment,e),M(oe.$$.fragment,e),M(ie.$$.fragment,e),Ft=!0)},o(e){y(S.$$.fragment,e),y(V.$$.fragment,e),y(F.$$.fragment,e),y(H.$$.fragment,e),y(Q.$$.fragment,e),y(R.$$.fragment,e),y(D.$$.fragment,e),y(P.$$.fragment,e),y(O.$$.fragment,e),y(L.$$.fragment,e),y(K.$$.fragment,e),y(te.$$.fragment,e),y(ae.$$.fragment,e),y(se.$$.fragment,e),y(le.$$.fragment,e),y(oe.$$.fragment,e),y(ie.$$.fragment,e),Ft=!1},d(e){t(j),e&&t(b),e&&t(g),w(S),e&&t(at),e&&t(ue),e&&t(st),e&&t(U),e&&t(lt),e&&t(A),w(V),e&&t(ot),e&&t(x),e&&t(nt),e&&t(de),e&&t(rt),e&&t(C),e&&t(it),w(F,e),e&&t(pt),e&&t(B),e&&t(ht),w(H,e),e&&t(ut),e&&t(ce),e&&t(dt),w(Q,e),e&&t(ct),e&&t(me),e&&t(mt),w(R,e),e&&t(ft),e&&t(_),w(D),e&&t(Mt),e&&t(fe),e&&t(yt),e&&t(J),e&&t(wt),w(P,e),e&&t(jt),e&&t(Me),e&&t(Jt),w(O,e),e&&t(Tt),e&&t(ye),e&&t(gt),w(L,e),e&&t(bt),e&&t(we),e&&t(Ut),e&&t(k),w(K),e&&t(vt),e&&t(je),e&&t(It),e&&t(N),e&&t(At),e&&t(Je),e&&t(_t),e&&t(Te),e&&t(kt),e&&t(ge),e&&t(Et),w(te,e),e&&t($t),e&&t(G),e&&t(xt),w(ae,e),e&&t(Ct),e&&t(be),e&&t(Bt),w(se,e),e&&t(Rt),e&&t(Ue),e&&t(Wt),w(le,e),e&&t(Zt),e&&t(q),e&&t(Nt),e&&t(X),e&&t(Gt),w(oe,e),e&&t(qt),e&&t(ne),e&&t(Xt),e&&t(Ie),e&&t(Yt),e&&t(Y),e&&t(zt),e&&t(z),e&&t(St),w(ie,e),e&&t(Vt),e&&t(v)}}}const Il={local:"preprocessing-an-audio-dataset",sections:[{local:"resampling-the-audio-data",title:"Resampling the audio data"},{local:"filtering-the-dataset",title:"Filtering the dataset"},{local:"preprocessing-audio-data",title:"Pre-processing audio data"}],title:"Preprocessing an audio dataset"};function Al(tt){return gl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xl extends yl{constructor(j){super();wl(this,j,Al,vl,jl,{})}}export{xl as default,Il as metadata};
