import{s as xl,n as Nl,o as Al}from"../chunks/scheduler.85c25b89.js";import{S as Ql,i as Bl,g as p,s as e,r as i,A as Rl,h as m,f as t,c as n,j as kl,u as M,x as j,k as Wl,y as El,a,v as o,d as r,t as c,w as h}from"../chunks/index.c9837788.js";import{C as V}from"../chunks/CodeBlock.e573519b.js";import{H as z,E as Gl}from"../chunks/getInferenceSnippets.5d4c70d5.js";function vl(Jl){let y,X,H,S,g,_,J,wl='<strong>DenseNet</strong> is a type of convolutional neural network that utilises dense connections between layers, through <a href="http://www.paperswithcode.com/method/dense-block" rel="nofollow">Dense Blocks</a>, where we connect <em>all layers</em> (with matching feature-map sizes) directly with each other. To preserve the feed-forward nature, each layer obtains additional inputs from all preceding layers and passes on its own feature-maps to all subsequent layers.',F,w,dl='The <strong>DenseNet Blur</strong> variant in this collection by Ross Wightman employs <a href="http://www.paperswithcode.com/method/blur-pooling" rel="nofollow">Blur Pooling</a>',D,d,L,u,ul="To load a pretrained model:",P,T,q,b,Tl="To load and preprocess the image:",K,U,O,f,bl="To get the model predictions:",ll,C,sl,I,Ul="To get the top-5 predictions class names:",tl,Z,al,$,fl="Replace the model name with the variant you want to use, e.g. <code>densenet121</code>. You can find the IDs in the model summaries at the top of this page.",el,k,Cl='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',nl,W,pl,x,Il="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ml,N,il,A,Zl=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,Ml,Q,ol,B,$l='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',rl,R,cl,E,hl,G,jl,v,yl,Y,gl;return g=new z({props:{title:"DenseNet",local:"densenet",headingTag:"h1"}}),d=new z({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new V({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2RlbnNlbmV0MTIxJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;densenet121&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),U=new V({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),C=new V({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new V({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new z({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new V({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZGVuc2VuZXQxMjEnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;densenet121&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),Q=new z({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),R=new z({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new V({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZIdWFuZ0xXMTZhJTJDJTBBJTIwJTIwYXV0aG9yJTIwJTIwJTIwJTIwJTNEJTIwJTdCR2FvJTIwSHVhbmclMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBaaHVhbmclMjBMaXUlMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBLaWxpYW4lMjBRLiUyMFdlaW5iZXJnZXIlN0QlMkMlMEElMjAlMjB0aXRsZSUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3QkRlbnNlbHklMjBDb25uZWN0ZWQlMjBDb252b2x1dGlvbmFsJTIwTmV0d29ya3MlN0QlMkMlMEElMjAlMjBqb3VybmFsJTIwJTIwJTIwJTNEJTIwJTdCQ29SUiU3RCUyQyUwQSUyMCUyMHZvbHVtZSUyMCUyMCUyMCUyMCUzRCUyMCU3QmFicyUyRjE2MDguMDY5OTMlN0QlMkMlMEElMjAlMjB5ZWFyJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCMjAxNiU3RCUyQyUwQSUyMCUyMHVybCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3Qmh0dHAlM0ElMkYlMkZhcnhpdi5vcmclMkZhYnMlMkYxNjA4LjA2OTkzJTdEJTJDJTBBJTIwJTIwYXJjaGl2ZVByZWZpeCUyMCUzRCUyMCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwZXByaW50JTIwJTIwJTIwJTIwJTNEJTIwJTdCMTYwOC4wNjk5MyU3RCUyQyUwQSUyMCUyMHRpbWVzdGFtcCUyMCUzRCUyMCU3Qk1vbiUyQyUyMDEwJTIwU2VwJTIwMjAxOCUyMDE1JTNBNDklM0EzMiUyMCUyQjAyMDAlN0QlMkMlMEElMjAlMjBiaWJ1cmwlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwcyUzQSUyRiUyRmRibHAub3JnJTJGcmVjJTJGam91cm5hbHMlMkZjb3JyJTJGSHVhbmdMVzE2YS5iaWIlN0QlMkMlMEElMjAlMjBiaWJzb3VyY2UlMjAlM0QlMjAlN0JkYmxwJTIwY29tcHV0ZXIlMjBzY2llbmNlJTIwYmlibGlvZ3JhcGh5JTJDJTIwaHR0cHMlM0ElMkYlMkZkYmxwLm9yZyU3RCUwQSU3RA==",highlighted:`@article{DBLP:journals<span class="hljs-regexp">/corr/</span>HuangLW16a,
  author    = {Gao Huang and
               Zhuang Liu and
               Kilian Q. Weinberger},
  title     = {Densely Connected Convolutional Networks},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1608.06993</span>},
  year      = {<span class="hljs-number">2016</span>},
  url       = {http:<span class="hljs-regexp">//</span>arxiv.org<span class="hljs-regexp">/abs/</span><span class="hljs-number">1608.06993</span>},
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1608.06993</span>},
  timestamp = {Mon, <span class="hljs-number">10</span> Sep <span class="hljs-number">2018</span> <span class="hljs-number">15</span>:<span class="hljs-number">49</span>:<span class="hljs-number">32</span> +<span class="hljs-number">0200</span>},
  biburl    = {https:<span class="hljs-regexp">//</span>dblp.org<span class="hljs-regexp">/rec/</span>journals<span class="hljs-regexp">/corr/</span>HuangLW16a.bib},
  bibsource = {dblp computer science bibliography, https:<span class="hljs-regexp">//</span>dblp.org}
}`,wrap:!1}}),G=new V({props:{code:"JTQwbWlzYyU3QnJ3MjAxOXRpbW0lMkMlMEElMjAlMjBhdXRob3IlMjAlM0QlMjAlN0JSb3NzJTIwV2lnaHRtYW4lN0QlMkMlMEElMjAlMjB0aXRsZSUyMCUzRCUyMCU3QlB5VG9yY2glMjBJbWFnZSUyME1vZGVscyU3RCUyQyUwQSUyMCUyMHllYXIlMjAlM0QlMjAlN0IyMDE5JTdEJTJDJTBBJTIwJTIwcHVibGlzaGVyJTIwJTNEJTIwJTdCR2l0SHViJTdEJTJDJTBBJTIwJTIwam91cm5hbCUyMCUzRCUyMCU3QkdpdEh1YiUyMHJlcG9zaXRvcnklN0QlMkMlMEElMjAlMjBkb2klMjAlM0QlMjAlN0IxMC41MjgxJTJGemVub2RvLjQ0MTQ4NjElN0QlMkMlMEElMjAlMjBob3dwdWJsaXNoZWQlMjAlM0QlMjAlN0IlNUN1cmwlN0JodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZyd2lnaHRtYW4lMkZweXRvcmNoLWltYWdlLW1vZGVscyU3RCU3RCUwQSU3RA==",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{rw2019timm,
  author = {Ross Wightman}</span><span class="language-xml">,
  title = </span><span class="hljs-template-variable">{PyTorch Image Models}</span><span class="language-xml">,
  year = </span><span class="hljs-template-variable">{2019}</span><span class="language-xml">,
  publisher = </span><span class="hljs-template-variable">{GitHub}</span><span class="language-xml">,
  journal = </span><span class="hljs-template-variable">{GitHub repository}</span><span class="language-xml">,
  doi = </span><span class="hljs-template-variable">{10.5281/zenodo.4414861}</span><span class="language-xml">,
  howpublished = </span><span class="hljs-template-variable">{\\url{https://github.com/rwightman/pytorch-image-models}</span><span class="language-xml">}
}</span>`,wrap:!1}}),v=new Gl({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/densenet.mdx"}}),{c(){y=p("meta"),X=e(),H=p("p"),S=e(),i(g.$$.fragment),_=e(),J=p("p"),J.innerHTML=wl,F=e(),w=p("p"),w.innerHTML=dl,D=e(),i(d.$$.fragment),L=e(),u=p("p"),u.textContent=ul,P=e(),i(T.$$.fragment),q=e(),b=p("p"),b.textContent=Tl,K=e(),i(U.$$.fragment),O=e(),f=p("p"),f.textContent=bl,ll=e(),i(C.$$.fragment),sl=e(),I=p("p"),I.textContent=Ul,tl=e(),i(Z.$$.fragment),al=e(),$=p("p"),$.innerHTML=fl,el=e(),k=p("p"),k.innerHTML=Cl,nl=e(),i(W.$$.fragment),pl=e(),x=p("p"),x.textContent=Il,ml=e(),i(N.$$.fragment),il=e(),A=p("p"),A.innerHTML=Zl,Ml=e(),i(Q.$$.fragment),ol=e(),B=p("p"),B.innerHTML=$l,rl=e(),i(R.$$.fragment),cl=e(),i(E.$$.fragment),hl=e(),i(G.$$.fragment),jl=e(),i(v.$$.fragment),yl=e(),Y=p("p"),this.h()},l(l){const s=Rl("svelte-u9bgzb",document.head);y=m(s,"META",{name:!0,content:!0}),s.forEach(t),X=n(l),H=m(l,"P",{}),kl(H).forEach(t),S=n(l),M(g.$$.fragment,l),_=n(l),J=m(l,"P",{"data-svelte-h":!0}),j(J)!=="svelte-49zh7b"&&(J.innerHTML=wl),F=n(l),w=m(l,"P",{"data-svelte-h":!0}),j(w)!=="svelte-5gcm94"&&(w.innerHTML=dl),D=n(l),M(d.$$.fragment,l),L=n(l),u=m(l,"P",{"data-svelte-h":!0}),j(u)!=="svelte-18ywhxh"&&(u.textContent=ul),P=n(l),M(T.$$.fragment,l),q=n(l),b=m(l,"P",{"data-svelte-h":!0}),j(b)!=="svelte-1c2ipa8"&&(b.textContent=Tl),K=n(l),M(U.$$.fragment,l),O=n(l),f=m(l,"P",{"data-svelte-h":!0}),j(f)!=="svelte-1n9qsq1"&&(f.textContent=bl),ll=n(l),M(C.$$.fragment,l),sl=n(l),I=m(l,"P",{"data-svelte-h":!0}),j(I)!=="svelte-19cnvx1"&&(I.textContent=Ul),tl=n(l),M(Z.$$.fragment,l),al=n(l),$=m(l,"P",{"data-svelte-h":!0}),j($)!=="svelte-1bbpuw6"&&($.innerHTML=fl),el=n(l),k=m(l,"P",{"data-svelte-h":!0}),j(k)!=="svelte-1wmi3ea"&&(k.innerHTML=Cl),nl=n(l),M(W.$$.fragment,l),pl=n(l),x=m(l,"P",{"data-svelte-h":!0}),j(x)!=="svelte-9sr7nh"&&(x.textContent=Il),ml=n(l),M(N.$$.fragment,l),il=n(l),A=m(l,"P",{"data-svelte-h":!0}),j(A)!=="svelte-1kguc51"&&(A.innerHTML=Zl),Ml=n(l),M(Q.$$.fragment,l),ol=n(l),B=m(l,"P",{"data-svelte-h":!0}),j(B)!=="svelte-xtxxu6"&&(B.innerHTML=$l),rl=n(l),M(R.$$.fragment,l),cl=n(l),M(E.$$.fragment,l),hl=n(l),M(G.$$.fragment,l),jl=n(l),M(v.$$.fragment,l),yl=n(l),Y=m(l,"P",{}),kl(Y).forEach(t),this.h()},h(){Wl(y,"name","hf:doc:metadata"),Wl(y,"content",Vl)},m(l,s){El(document.head,y),a(l,X,s),a(l,H,s),a(l,S,s),o(g,l,s),a(l,_,s),a(l,J,s),a(l,F,s),a(l,w,s),a(l,D,s),o(d,l,s),a(l,L,s),a(l,u,s),a(l,P,s),o(T,l,s),a(l,q,s),a(l,b,s),a(l,K,s),o(U,l,s),a(l,O,s),a(l,f,s),a(l,ll,s),o(C,l,s),a(l,sl,s),a(l,I,s),a(l,tl,s),o(Z,l,s),a(l,al,s),a(l,$,s),a(l,el,s),a(l,k,s),a(l,nl,s),o(W,l,s),a(l,pl,s),a(l,x,s),a(l,ml,s),o(N,l,s),a(l,il,s),a(l,A,s),a(l,Ml,s),o(Q,l,s),a(l,ol,s),a(l,B,s),a(l,rl,s),o(R,l,s),a(l,cl,s),o(E,l,s),a(l,hl,s),o(G,l,s),a(l,jl,s),o(v,l,s),a(l,yl,s),a(l,Y,s),gl=!0},p:Nl,i(l){gl||(r(g.$$.fragment,l),r(d.$$.fragment,l),r(T.$$.fragment,l),r(U.$$.fragment,l),r(C.$$.fragment,l),r(Z.$$.fragment,l),r(W.$$.fragment,l),r(N.$$.fragment,l),r(Q.$$.fragment,l),r(R.$$.fragment,l),r(E.$$.fragment,l),r(G.$$.fragment,l),r(v.$$.fragment,l),gl=!0)},o(l){c(g.$$.fragment,l),c(d.$$.fragment,l),c(T.$$.fragment,l),c(U.$$.fragment,l),c(C.$$.fragment,l),c(Z.$$.fragment,l),c(W.$$.fragment,l),c(N.$$.fragment,l),c(Q.$$.fragment,l),c(R.$$.fragment,l),c(E.$$.fragment,l),c(G.$$.fragment,l),c(v.$$.fragment,l),gl=!1},d(l){l&&(t(X),t(H),t(S),t(_),t(J),t(F),t(w),t(D),t(L),t(u),t(P),t(q),t(b),t(K),t(O),t(f),t(ll),t(sl),t(I),t(tl),t(al),t($),t(el),t(k),t(nl),t(pl),t(x),t(ml),t(il),t(A),t(Ml),t(ol),t(B),t(rl),t(cl),t(hl),t(jl),t(yl),t(Y)),t(y),h(g,l),h(d,l),h(T,l),h(U,l),h(C,l),h(Z,l),h(W,l),h(N,l),h(Q,l),h(R,l),h(E,l),h(G,l),h(v,l)}}}const Vl='{"title":"DenseNet","local":"densenet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Hl(Jl){return Al(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _l extends Ql{constructor(y){super(),Bl(this,y,Hl,vl,xl,{})}}export{_l as component};
