import{s as Bs,n as As,o as Gs}from"../chunks/scheduler.85c25b89.js";import{S as vs,i as Ws,g as p,s as e,r as m,A as Rs,h as i,f as t,c as n,j as $s,u as M,x as o,k as Zs,y as Qs,a,v as r,d as c,t as h,w as y}from"../chunks/index.c9837788.js";import{C as Y}from"../chunks/CodeBlock.e573519b.js";import{H as _,E as Es}from"../chunks/getInferenceSnippets.5d4c70d5.js";function Ys(js){let g,V,X,z,J,F,j,ds='<strong>Residual Networks</strong>, or <strong>ResNets</strong>, learn residual functions with reference to the layer inputs, instead of learning unreferenced functions. Instead of hoping each few stacked layers directly fit a desired underlying mapping, residual nets let these layers fit a residual mapping. They stack <a href="https://paperswithcode.com/method/residual-block" rel="nofollow">residual blocks</a> ontop of each other to form network: e.g. a ResNet-50 has fifty layers using these blocks.',H,d,Us="The model in this collection utilises semi-supervised learning to improve the performance of the model. The approach brings important gains to standard architectures for image, video and fine-grained classification.",L,U,ws="Please note the CC-BY-NC 4.0 license on theses weights, non-commercial use only.",D,w,P,u,us="To load a pretrained model:",q,T,K,b,Ts="To load and preprocess the image:",O,f,ss,C,bs="To get the model predictions:",ls,I,ts,N,fs="To get the top-5 predictions class names:",as,k,es,x,Cs="Replace the model name with the variant you want to use, e.g. <code>ssl_resnet18</code>. You can find the IDs in the model summaries at the top of this page.",ns,$,Is='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ps,Z,is,B,Ns="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ms,A,Ms,G,ks=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,os,v,rs,W,xs='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',cs,R,hs,Q,ys,E,gs,S,Js;return J=new _({props:{title:"SSL ResNet",local:"ssl-resnet",headingTag:"h1"}}),w=new _({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new Y({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3NzbF9yZXNuZXQxOCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;ssl_resnet18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new Y({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),I=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),k=new Y({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),Z=new _({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),A=new Y({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnc3NsX3Jlc25ldDE4JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;ssl_resnet18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),v=new _({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),R=new _({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new Y({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZhYnMtMTkwNS0wMDU0NiUyQyUwQSUyMCUyMGF1dGhvciUyMCUyMCUyMCUyMCUzRCUyMCU3QkkuJTIwWmVraSUyMFlhbG5peiUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEhlcnYlN0IlNUMnJTdCZSU3RCU3RCUyMEolN0IlNUMnJTdCZSU3RCU3RGdvdSUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEthbiUyMENoZW4lMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBNYW5vaGFyJTIwUGFsdXJpJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRGhydXYlMjBNYWhhamFuJTdEJTJDJTBBJTIwJTIwdGl0bGUlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JCaWxsaW9uLXNjYWxlJTIwc2VtaS1zdXBlcnZpc2VkJTIwbGVhcm5pbmclMjBmb3IlMjBpbWFnZSUyMGNsYXNzaWZpY2F0aW9uJTdEJTJDJTBBJTIwJTIwam91cm5hbCUyMCUyMCUyMCUzRCUyMCU3QkNvUlIlN0QlMkMlMEElMjAlMjB2b2x1bWUlMjAlMjAlMjAlMjAlM0QlMjAlN0JhYnMlMkYxOTA1LjAwNTQ2JTdEJTJDJTBBJTIwJTIweWVhciUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3QjIwMTklN0QlMkMlMEElMjAlMjB1cmwlMjAlMjAlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwJTNBJTJGJTJGYXJ4aXYub3JnJTJGYWJzJTJGMTkwNS4wMDU0NiU3RCUyQyUwQSUyMCUyMGFyY2hpdmVQcmVmaXglMjAlM0QlMjAlN0JhclhpdiU3RCUyQyUwQSUyMCUyMGVwcmludCUyMCUyMCUyMCUyMCUzRCUyMCU3QjE5MDUuMDA1NDYlN0QlMkMlMEElMjAlMjB0aW1lc3RhbXAlMjAlM0QlMjAlN0JNb24lMkMlMjAyOCUyMFNlcCUyMDIwMjAlMjAwOCUzQTE5JTNBMzclMjAlMkIwMjAwJTdEJTJDJTBBJTIwJTIwYmlidXJsJTIwJTIwJTIwJTIwJTNEJTIwJTdCaHR0cHMlM0ElMkYlMkZkYmxwLm9yZyUyRnJlYyUyRmpvdXJuYWxzJTJGY29yciUyRmFicy0xOTA1LTAwNTQ2LmJpYiU3RCUyQyUwQSUyMCUyMGJpYnNvdXJjZSUyMCUzRCUyMCU3QmRibHAlMjBjb21wdXRlciUyMHNjaWVuY2UlMjBiaWJsaW9ncmFwaHklMkMlMjBodHRwcyUzQSUyRiUyRmRibHAub3JnJTdEJTBBJTdE",highlighted:`<span class="language-xml">@article</span><span class="hljs-template-variable">{DBLP:journals/corr/abs-1905-00546,
  author    = {I. Zeki Yalniz and
               Herv{\\&#x27;{e}</span><span class="language-xml">} J</span><span class="hljs-template-variable">{\\&#x27;{e}</span><span class="language-xml">}gou and
               Kan Chen and
               Manohar Paluri and
               Dhruv Mahajan},
  title     = </span><span class="hljs-template-variable">{Billion-scale semi-supervised learning for image classification}</span><span class="language-xml">,
  journal   = </span><span class="hljs-template-variable">{CoRR}</span><span class="language-xml">,
  volume    = </span><span class="hljs-template-variable">{abs/1905.00546}</span><span class="language-xml">,
  year      = </span><span class="hljs-template-variable">{2019}</span><span class="language-xml">,
  url       = </span><span class="hljs-template-variable">{http://arxiv.org/abs/1905.00546}</span><span class="language-xml">,
  archivePrefix = </span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
  eprint    = </span><span class="hljs-template-variable">{1905.00546}</span><span class="language-xml">,
  timestamp = </span><span class="hljs-template-variable">{Mon, 28 <span class="hljs-keyword">Sep</span> 2020 08:19:37 +0200}</span><span class="language-xml">,
  biburl    = </span><span class="hljs-template-variable">{https://dblp.org/rec/journals/corr/abs-1905-00546.bib}</span><span class="language-xml">,
  bibsource = </span><span class="hljs-template-variable">{dblp computer science bibliography, https://dblp.org}</span><span class="language-xml">
}</span>`,wrap:!1}}),E=new Es({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/ssl-resnet.mdx"}}),{c(){g=p("meta"),V=e(),X=p("p"),z=e(),m(J.$$.fragment),F=e(),j=p("p"),j.innerHTML=ds,H=e(),d=p("p"),d.textContent=Us,L=e(),U=p("p"),U.textContent=ws,D=e(),m(w.$$.fragment),P=e(),u=p("p"),u.textContent=us,q=e(),m(T.$$.fragment),K=e(),b=p("p"),b.textContent=Ts,O=e(),m(f.$$.fragment),ss=e(),C=p("p"),C.textContent=bs,ls=e(),m(I.$$.fragment),ts=e(),N=p("p"),N.textContent=fs,as=e(),m(k.$$.fragment),es=e(),x=p("p"),x.innerHTML=Cs,ns=e(),$=p("p"),$.innerHTML=Is,ps=e(),m(Z.$$.fragment),is=e(),B=p("p"),B.textContent=Ns,ms=e(),m(A.$$.fragment),Ms=e(),G=p("p"),G.innerHTML=ks,os=e(),m(v.$$.fragment),rs=e(),W=p("p"),W.innerHTML=xs,cs=e(),m(R.$$.fragment),hs=e(),m(Q.$$.fragment),ys=e(),m(E.$$.fragment),gs=e(),S=p("p"),this.h()},l(s){const l=Rs("svelte-u9bgzb",document.head);g=i(l,"META",{name:!0,content:!0}),l.forEach(t),V=n(s),X=i(s,"P",{}),$s(X).forEach(t),z=n(s),M(J.$$.fragment,s),F=n(s),j=i(s,"P",{"data-svelte-h":!0}),o(j)!=="svelte-p6ybkz"&&(j.innerHTML=ds),H=n(s),d=i(s,"P",{"data-svelte-h":!0}),o(d)!=="svelte-l5six6"&&(d.textContent=Us),L=n(s),U=i(s,"P",{"data-svelte-h":!0}),o(U)!=="svelte-ye38bd"&&(U.textContent=ws),D=n(s),M(w.$$.fragment,s),P=n(s),u=i(s,"P",{"data-svelte-h":!0}),o(u)!=="svelte-18ywhxh"&&(u.textContent=us),q=n(s),M(T.$$.fragment,s),K=n(s),b=i(s,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1c2ipa8"&&(b.textContent=Ts),O=n(s),M(f.$$.fragment,s),ss=n(s),C=i(s,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1n9qsq1"&&(C.textContent=bs),ls=n(s),M(I.$$.fragment,s),ts=n(s),N=i(s,"P",{"data-svelte-h":!0}),o(N)!=="svelte-19cnvx1"&&(N.textContent=fs),as=n(s),M(k.$$.fragment,s),es=n(s),x=i(s,"P",{"data-svelte-h":!0}),o(x)!=="svelte-a6rqz1"&&(x.innerHTML=Cs),ns=n(s),$=i(s,"P",{"data-svelte-h":!0}),o($)!=="svelte-1wmi3ea"&&($.innerHTML=Is),ps=n(s),M(Z.$$.fragment,s),is=n(s),B=i(s,"P",{"data-svelte-h":!0}),o(B)!=="svelte-9sr7nh"&&(B.textContent=Ns),ms=n(s),M(A.$$.fragment,s),Ms=n(s),G=i(s,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1kguc51"&&(G.innerHTML=ks),os=n(s),M(v.$$.fragment,s),rs=n(s),W=i(s,"P",{"data-svelte-h":!0}),o(W)!=="svelte-xtxxu6"&&(W.innerHTML=xs),cs=n(s),M(R.$$.fragment,s),hs=n(s),M(Q.$$.fragment,s),ys=n(s),M(E.$$.fragment,s),gs=n(s),S=i(s,"P",{}),$s(S).forEach(t),this.h()},h(){Zs(g,"name","hf:doc:metadata"),Zs(g,"content",Xs)},m(s,l){Qs(document.head,g),a(s,V,l),a(s,X,l),a(s,z,l),r(J,s,l),a(s,F,l),a(s,j,l),a(s,H,l),a(s,d,l),a(s,L,l),a(s,U,l),a(s,D,l),r(w,s,l),a(s,P,l),a(s,u,l),a(s,q,l),r(T,s,l),a(s,K,l),a(s,b,l),a(s,O,l),r(f,s,l),a(s,ss,l),a(s,C,l),a(s,ls,l),r(I,s,l),a(s,ts,l),a(s,N,l),a(s,as,l),r(k,s,l),a(s,es,l),a(s,x,l),a(s,ns,l),a(s,$,l),a(s,ps,l),r(Z,s,l),a(s,is,l),a(s,B,l),a(s,ms,l),r(A,s,l),a(s,Ms,l),a(s,G,l),a(s,os,l),r(v,s,l),a(s,rs,l),a(s,W,l),a(s,cs,l),r(R,s,l),a(s,hs,l),r(Q,s,l),a(s,ys,l),r(E,s,l),a(s,gs,l),a(s,S,l),Js=!0},p:As,i(s){Js||(c(J.$$.fragment,s),c(w.$$.fragment,s),c(T.$$.fragment,s),c(f.$$.fragment,s),c(I.$$.fragment,s),c(k.$$.fragment,s),c(Z.$$.fragment,s),c(A.$$.fragment,s),c(v.$$.fragment,s),c(R.$$.fragment,s),c(Q.$$.fragment,s),c(E.$$.fragment,s),Js=!0)},o(s){h(J.$$.fragment,s),h(w.$$.fragment,s),h(T.$$.fragment,s),h(f.$$.fragment,s),h(I.$$.fragment,s),h(k.$$.fragment,s),h(Z.$$.fragment,s),h(A.$$.fragment,s),h(v.$$.fragment,s),h(R.$$.fragment,s),h(Q.$$.fragment,s),h(E.$$.fragment,s),Js=!1},d(s){s&&(t(V),t(X),t(z),t(F),t(j),t(H),t(d),t(L),t(U),t(D),t(P),t(u),t(q),t(K),t(b),t(O),t(ss),t(C),t(ls),t(ts),t(N),t(as),t(es),t(x),t(ns),t($),t(ps),t(is),t(B),t(ms),t(Ms),t(G),t(os),t(rs),t(W),t(cs),t(hs),t(ys),t(gs),t(S)),t(g),y(J,s),y(w,s),y(T,s),y(f,s),y(I,s),y(k,s),y(Z,s),y(A,s),y(v,s),y(R,s),y(Q,s),y(E,s)}}}const Xs='{"title":"SSL ResNet","local":"ssl-resnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Ss(js){return Gs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hs extends vs{constructor(g){super(),Ws(this,g,Ss,Ys,Bs,{})}}export{Hs as component};
