import{s as kl,n as Bl,o as $l}from"../chunks/scheduler.85c25b89.js";import{S as Nl,i as Wl,g as M,s as a,r as m,A as Gl,h as p,f as t,c as n,j as Al,u as i,x as h,k as Zl,y as El,a as e,v as o,d as j,t as r,w as y}from"../chunks/index.c9837788.js";import{C as Y}from"../chunks/CodeBlock.e573519b.js";import{H as _,E as Ql}from"../chunks/getInferenceSnippets.5d4c70d5.js";function xl(cl){let c,X,R,S,J,H,w,Jl='<strong>MobileNetV3</strong> is a convolutional neural network that is designed for mobile phone CPUs. The network design includes the use of a <a href="https://paperswithcode.com/method/hard-swish" rel="nofollow">hard swish activation</a> and <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation</a> modules in the <a href="https://paperswithcode.com/method/inverted-residual-block" rel="nofollow">MBConv blocks</a>.',F,d,wl='The weights from this model were ported from <a href="https://github.com/tensorflow/models" rel="nofollow">Tensorflow/Models</a>.',z,T,D,U,dl="To load a pretrained model:",L,g,q,b,Tl="To load and preprocess the image:",P,u,K,C,Ul="To get the model predictions:",O,f,ll,I,gl="To get the top-5 predictions class names:",sl,A,tl,Z,bl="Replace the model name with the variant you want to use, e.g. <code>tf_mobilenetv3_large_075</code>. You can find the IDs in the model summaries at the top of this page.",el,k,ul='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',al,B,nl,$,Cl="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Ml,N,pl,W,fl=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ml,G,il,E,Il='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',ol,Q,jl,x,rl,v,yl,V,hl;return J=new _({props:{title:"(Tensorflow) MobileNet v3",local:"tensorflow-mobilenet-v3",headingTag:"h1"}}),T=new _({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),g=new Y({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3RmX21vYmlsZW5ldHYzX2xhcmdlXzA3NSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_mobilenetv3_large_075&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),u=new Y({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),f=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),A=new Y({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),B=new _({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new Y({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndGZfbW9iaWxlbmV0djNfbGFyZ2VfMDc1JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_mobilenetv3_large_075&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),G=new _({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new _({props:{title:"Citation",local:"citation",headingTag:"h2"}}),x=new Y({props:{code:"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",highlighted:`<span class="hljs-comment">@article{DBLP:journals/corr/abs-1905-02244,</span>
  author    = {Andrew Howard <span class="hljs-keyword">and</span>
               Mark Sandler <span class="hljs-keyword">and</span>
               Grace Chu <span class="hljs-keyword">and</span>
               Liang{-}Chieh Chen <span class="hljs-keyword">and</span>
               Bo Chen <span class="hljs-keyword">and</span>
               Mingxing Tan <span class="hljs-keyword">and</span>
               Weijun Wang <span class="hljs-keyword">and</span>
               Yukun Zhu <span class="hljs-keyword">and</span>
               Ruoming Pang <span class="hljs-keyword">and</span>
               Vijay Vasudevan <span class="hljs-keyword">and</span>
               Quoc V. Le <span class="hljs-keyword">and</span>
               Hartwig Adam},
  title     = {Searching for MobileNetV3},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1905</span>.<span class="hljs-number">02244</span>},
  year      = {<span class="hljs-number">2019</span>},
  url       = {http:<span class="hljs-comment">//arxiv.org/abs/1905.02244},</span>
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1905</span>.<span class="hljs-number">02244</span>},
  timestamp = {Tue, <span class="hljs-number">12</span> Jan <span class="hljs-number">2021</span> <span class="hljs-number">15</span>:<span class="hljs-number">30</span>:<span class="hljs-number">06</span> +<span class="hljs-number">0100</span>},
  biburl    = {https:<span class="hljs-comment">//dblp.org/rec/journals/corr/abs-1905-02244.bib},</span>
  bibsource = {dblp computer science bibliography, https:<span class="hljs-comment">//dblp.org}</span>
}`,wrap:!1}}),v=new Ql({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/tf-mobilenet-v3.mdx"}}),{c(){c=M("meta"),X=a(),R=M("p"),S=a(),m(J.$$.fragment),H=a(),w=M("p"),w.innerHTML=Jl,F=a(),d=M("p"),d.innerHTML=wl,z=a(),m(T.$$.fragment),D=a(),U=M("p"),U.textContent=dl,L=a(),m(g.$$.fragment),q=a(),b=M("p"),b.textContent=Tl,P=a(),m(u.$$.fragment),K=a(),C=M("p"),C.textContent=Ul,O=a(),m(f.$$.fragment),ll=a(),I=M("p"),I.textContent=gl,sl=a(),m(A.$$.fragment),tl=a(),Z=M("p"),Z.innerHTML=bl,el=a(),k=M("p"),k.innerHTML=ul,al=a(),m(B.$$.fragment),nl=a(),$=M("p"),$.textContent=Cl,Ml=a(),m(N.$$.fragment),pl=a(),W=M("p"),W.innerHTML=fl,ml=a(),m(G.$$.fragment),il=a(),E=M("p"),E.innerHTML=Il,ol=a(),m(Q.$$.fragment),jl=a(),m(x.$$.fragment),rl=a(),m(v.$$.fragment),yl=a(),V=M("p"),this.h()},l(l){const s=Gl("svelte-u9bgzb",document.head);c=p(s,"META",{name:!0,content:!0}),s.forEach(t),X=n(l),R=p(l,"P",{}),Al(R).forEach(t),S=n(l),i(J.$$.fragment,l),H=n(l),w=p(l,"P",{"data-svelte-h":!0}),h(w)!=="svelte-1xpy3t9"&&(w.innerHTML=Jl),F=n(l),d=p(l,"P",{"data-svelte-h":!0}),h(d)!=="svelte-1nh6o5x"&&(d.innerHTML=wl),z=n(l),i(T.$$.fragment,l),D=n(l),U=p(l,"P",{"data-svelte-h":!0}),h(U)!=="svelte-18ywhxh"&&(U.textContent=dl),L=n(l),i(g.$$.fragment,l),q=n(l),b=p(l,"P",{"data-svelte-h":!0}),h(b)!=="svelte-1c2ipa8"&&(b.textContent=Tl),P=n(l),i(u.$$.fragment,l),K=n(l),C=p(l,"P",{"data-svelte-h":!0}),h(C)!=="svelte-1n9qsq1"&&(C.textContent=Ul),O=n(l),i(f.$$.fragment,l),ll=n(l),I=p(l,"P",{"data-svelte-h":!0}),h(I)!=="svelte-19cnvx1"&&(I.textContent=gl),sl=n(l),i(A.$$.fragment,l),tl=n(l),Z=p(l,"P",{"data-svelte-h":!0}),h(Z)!=="svelte-1urwpdk"&&(Z.innerHTML=bl),el=n(l),k=p(l,"P",{"data-svelte-h":!0}),h(k)!=="svelte-1wmi3ea"&&(k.innerHTML=ul),al=n(l),i(B.$$.fragment,l),nl=n(l),$=p(l,"P",{"data-svelte-h":!0}),h($)!=="svelte-9sr7nh"&&($.textContent=Cl),Ml=n(l),i(N.$$.fragment,l),pl=n(l),W=p(l,"P",{"data-svelte-h":!0}),h(W)!=="svelte-1kguc51"&&(W.innerHTML=fl),ml=n(l),i(G.$$.fragment,l),il=n(l),E=p(l,"P",{"data-svelte-h":!0}),h(E)!=="svelte-xtxxu6"&&(E.innerHTML=Il),ol=n(l),i(Q.$$.fragment,l),jl=n(l),i(x.$$.fragment,l),rl=n(l),i(v.$$.fragment,l),yl=n(l),V=p(l,"P",{}),Al(V).forEach(t),this.h()},h(){Zl(c,"name","hf:doc:metadata"),Zl(c,"content",vl)},m(l,s){El(document.head,c),e(l,X,s),e(l,R,s),e(l,S,s),o(J,l,s),e(l,H,s),e(l,w,s),e(l,F,s),e(l,d,s),e(l,z,s),o(T,l,s),e(l,D,s),e(l,U,s),e(l,L,s),o(g,l,s),e(l,q,s),e(l,b,s),e(l,P,s),o(u,l,s),e(l,K,s),e(l,C,s),e(l,O,s),o(f,l,s),e(l,ll,s),e(l,I,s),e(l,sl,s),o(A,l,s),e(l,tl,s),e(l,Z,s),e(l,el,s),e(l,k,s),e(l,al,s),o(B,l,s),e(l,nl,s),e(l,$,s),e(l,Ml,s),o(N,l,s),e(l,pl,s),e(l,W,s),e(l,ml,s),o(G,l,s),e(l,il,s),e(l,E,s),e(l,ol,s),o(Q,l,s),e(l,jl,s),o(x,l,s),e(l,rl,s),o(v,l,s),e(l,yl,s),e(l,V,s),hl=!0},p:Bl,i(l){hl||(j(J.$$.fragment,l),j(T.$$.fragment,l),j(g.$$.fragment,l),j(u.$$.fragment,l),j(f.$$.fragment,l),j(A.$$.fragment,l),j(B.$$.fragment,l),j(N.$$.fragment,l),j(G.$$.fragment,l),j(Q.$$.fragment,l),j(x.$$.fragment,l),j(v.$$.fragment,l),hl=!0)},o(l){r(J.$$.fragment,l),r(T.$$.fragment,l),r(g.$$.fragment,l),r(u.$$.fragment,l),r(f.$$.fragment,l),r(A.$$.fragment,l),r(B.$$.fragment,l),r(N.$$.fragment,l),r(G.$$.fragment,l),r(Q.$$.fragment,l),r(x.$$.fragment,l),r(v.$$.fragment,l),hl=!1},d(l){l&&(t(X),t(R),t(S),t(H),t(w),t(F),t(d),t(z),t(D),t(U),t(L),t(q),t(b),t(P),t(K),t(C),t(O),t(ll),t(I),t(sl),t(tl),t(Z),t(el),t(k),t(al),t(nl),t($),t(Ml),t(pl),t(W),t(ml),t(il),t(E),t(ol),t(jl),t(rl),t(yl),t(V)),t(c),y(J,l),y(T,l),y(g,l),y(u,l),y(f,l),y(A,l),y(B,l),y(N,l),y(G,l),y(Q,l),y(x,l),y(v,l)}}}const vl='{"title":"(Tensorflow) MobileNet v3","local":"tensorflow-mobilenet-v3","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Yl(cl){return $l(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sl extends Nl{constructor(c){super(),Wl(this,c,Yl,xl,kl,{})}}export{Sl as component};
