import{s as ht,n as wt,o as bt}from"../chunks/scheduler.a2b4ca8e.js";import{S as gt,i as Mt,g as s,s as i,r as p,A as yt,h as o,f as l,c as n,j as ct,u as r,x as u,k as ut,l as $t,y as Tt,a,v as m,d,t as f,w as c}from"../chunks/index.f6e1d51d.js";import{C as h}from"../chunks/CodeBlock.9607aa3b.js";import{H as b,E as _t}from"../chunks/EditOnGithub.d27dc01b.js";function Zt(Se){let w,ne,ae,se,M,oe,y,Ye=`The notebooks and scripts in this examples show how to use Low Rank Adaptation (LoRA) to fine-tune models in a memory efficient manner. Most of PEFT methods supported in peft library but note that some PEFT methods such as Prompt tuning are not supported.
For more information on LoRA, see the <a href="https://arxiv.org/abs/2106.09685" rel="nofollow">original paper</a>.`,pe,$,ze='Here’s an overview of the <code>peft</code>-enabled notebooks and scripts in the <a href="https://github.com/huggingface/trl/tree/main/examples" rel="nofollow">trl repository</a>:',re,T,De='<thead><tr><th>File</th> <th>Task</th> <th>Description</th></tr></thead> <tbody><tr><td><a href="https://github.com/huggingface/trl/blob/main/examples/research_projects/stack_llama/scripts/rl_training.py" rel="nofollow"><code>stack_llama/rl_training.py</code></a></td> <td>RLHF</td> <td>Distributed fine-tuning of the 7b parameter LLaMA models with a learned reward model and <code>peft</code>.</td></tr> <tr><td><a href="https://github.com/huggingface/trl/blob/main/examples/research_projects/stack_llama/scripts/reward_modeling.py" rel="nofollow"><code>stack_llama/reward_modeling.py</code></a></td> <td>Reward Modeling</td> <td>Distributed training of the 7b parameter LLaMA reward model with <code>peft</code>.</td></tr> <tr><td><a href="https://github.com/huggingface/trl/blob/main/examples/research_projects/stack_llama/scripts/supervised_finetuning.py" rel="nofollow"><code>stack_llama/supervised_finetuning.py</code></a></td> <td>SFT</td> <td>Distributed instruction/supervised fine-tuning of the 7b parameter LLaMA model with <code>peft</code>.</td></tr></tbody>',me,_,de,Z,qe=`Note: peft is in active development, so we install directly from their Github page.
Peft also relies on the latest version of transformers.`,fe,U,ce,J,Ke='Note: if you don’t want to log with <code>wandb</code> remove <code>log_with=&quot;wandb&quot;</code> in the scripts/notebooks. You can also replace it with your favourite experiment tracker that’s <a href="https://huggingface.co/docs/accelerate/usage_guides/tracking" rel="nofollow">supported by <code>accelerate</code></a>.',ue,v,he,C,Oe="Simply declare a <code>PeftConfig</code> object in your script and pass it through <code>.from_pretrained</code> to load the TRL+PEFT model.",we,j,be,x,et="And if you want to load your model in 8bit precision:",ge,L,Me,H,tt="… or in 4bit precision:",ye,k,$e,G,Te,W,lt="The <code>trl</code> library is powered by <code>accelerate</code>. As such it is best to configure and launch trainings with the following commands:",_e,B,Ze,F,Ue,R,at="You can scale up to as many GPUs as you want, as long as you are able to fit the training process in a single device. The only tweak you need to apply is to load the model as follows:",Je,I,ve,N,it="And if you want to load your model in 8bit precision:",Ce,A,je,E,nt="… or in 4bit precision:",xe,P,Le,V,st="Finally, make sure that the rewards are computed on correct device as well, for that you can use <code>ppo_trainer.model.current_device</code>.",He,X,ke,Q,ot=`The <code>trl</code> library also supports naive pipeline parallelism (NPP) for large models (&gt;60B models). This is a simple way to parallelize the model across multiple GPUs.
This paradigm, termed as “Naive Pipeline Parallelism” (NPP) is a simple way to parallelize the model across multiple GPUs. We load the model and the adapters across multiple GPUs and the activations and gradients will be naively communicated across the GPUs. This supports <code>int8</code> models as well as other <code>dtype</code> models.`,Ge,g,pt='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/trl-npp.png"/>',We,S,Be,Y,rt='Simply load your model with a custom <code>device_map</code> argument on the <code>from_pretrained</code> to split your model across multiple devices. Check out this <a href="https://github.com/huggingface/blog/blob/main/accelerate-large-models.md" rel="nofollow">nice tutorial</a> on how to properly create a <code>device_map</code> for your model.',Fe,z,mt="Also make sure to have the <code>lm_head</code> module on the first GPU device as it may throw an error if it is not on the first device. As this time of writing, you need to install the <code>main</code> branch of <code>accelerate</code>: <code>pip install git+https://github.com/huggingface/accelerate.git@main</code> and <code>peft</code>: <code>pip install git+https://github.com/huggingface/peft.git@main</code>.",Re,D,Ie,q,dt="Although <code>trl</code> library is powered by <code>accelerate</code>, you should run your training script in a single process. Note that we do not support Data Parallelism together with NPP yet.",Ne,K,Ae,O,Ee,ee,ft="You can easily fine-tune Llama2 model using <code>SFTTrainer</code> and the official script! For example to fine-tune llama2-7b on the Guanaco dataset, run (tested on a single NVIDIA T4-16GB):",Pe,te,Ve,le,Xe,ie,Qe;return M=new b({props:{title:"Examples of using peft with trl to finetune 8-bit models with Low Rank Adaption (LoRA)",local:"examples-of-using-peft-with-trl-to-finetune-8-bit-models-with-low-rank-adaption-lora",headingTag:"h1"}}),_=new b({props:{title:"Installation",local:"installation",headingTag:"h2"}}),U=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRybCU1QnBlZnQlNUQlMEFwaXAlMjBpbnN0YWxsJTIwYml0c2FuZGJ5dGVzJTIwbG9yYWxpYiUwQXBpcCUyMGluc3RhbGwlMjBnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRnRyYW5zZm9ybWVycy5naXQlNDBtYWluJTBBJTIzb3B0aW9uYWwlM0ElMjB3YW5kYiUwQXBpcCUyMGluc3RhbGwlMjB3YW5kYg==",highlighted:`pip install trl[peft]
pip install bitsandbytes loralib
pip install git+https://github.com/huggingface/transformers.git@main
<span class="hljs-comment">#optional: wandb</span>
pip install wandb`,wrap:!1}}),v=new b({props:{title:"How to use it?",local:"how-to-use-it",headingTag:"h2"}}),j=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyZWRiZWVjaGluZyUyRmdwdC1uZW8tMTI1TS1pbWRiJTIyJTBBbG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QzMiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMDUlMkMlMEElMjAlMjAlMjAlMjBiaWFzJTNEJTIybm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUyQyUwQSklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjAlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRGxvcmFfY29uZmlnJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> AutoModelForCausalLMWithValueHead

model_id = <span class="hljs-string">&quot;edbeeching/gpt-neo-125M-imdb&quot;</span>
lora_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

model = AutoModelForCausalLMWithValueHead.from_pretrained(
    model_id, 
    peft_config=lora_config,
)`,wrap:!1}}),L=new h({props:{code:"cHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwY29uZmlnLm1vZGVsX25hbWUlMkMlMjAlMEElMjAlMjAlMjAlMjBsb2FkX2luXzhiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcGVmdF9jb25maWclM0Rsb3JhX2NvbmZpZyUyQyUwQSk=",highlighted:`pretrained_model = AutoModelForCausalLMWithValueHead.from_pretrained(
    config.model_name, 
    load_in_8bit=<span class="hljs-literal">True</span>,
    peft_config=lora_config,
)`,wrap:!1}}),k=new h({props:{code:"cHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwY29uZmlnLm1vZGVsX25hbWUlMkMlMjAlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRGxvcmFfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSk=",highlighted:`pretrained_model = AutoModelForCausalLMWithValueHead.from_pretrained(
    config.model_name, 
    peft_config=lora_config,
    load_in_4bit=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),G=new b({props:{title:"Launch scripts",local:"launch-scripts",headingTag:"h2"}}),B=new h({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMCUyMyUyMHdpbGwlMjBwcm9tcHQlMjB5b3UlMjB0byUyMGRlZmluZSUyMHRoZSUyMHRyYWluaW5nJTIwY29uZmlndXJhdGlvbiUwQWFjY2VsZXJhdGUlMjBsYXVuY2glMjBleGFtcGxlcyUyRnNjcmlwdHMlMkZwcG8ucHklMjAtLXVzZV9wZWZ0JTIwJTIzJTIwbGF1bmNoJTYwZXMlMjB0cmFpbmluZw==",highlighted:'accelerate config <span class="hljs-comment"># will prompt you to define the training configuration</span>\naccelerate launch examples/scripts/ppo.py --use_peft <span class="hljs-comment"># launch`es training</span>',wrap:!1}}),F=new b({props:{title:"Using trl + peft and Data Parallelism",local:"using-trl--peft-and-data-parallelism",headingTag:"h2"}}),I=new h({props:{code:"JTBB",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
...

lora_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

pretrained_model = AutoModelForCausalLMWithValueHead.from_pretrained(
    config.model_name, 
    peft_config=lora_config,
)`,wrap:!1}}),A=new h({props:{code:"cHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwY29uZmlnLm1vZGVsX25hbWUlMkMlMjAlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRGxvcmFfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUwQSk=",highlighted:`pretrained_model = AutoModelForCausalLMWithValueHead.from_pretrained(
    config.model_name, 
    peft_config=lora_config,
    load_in_8bit=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),P=new h({props:{code:"cHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwY29uZmlnLm1vZGVsX25hbWUlMkMlMjAlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRGxvcmFfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSk=",highlighted:`pretrained_model = AutoModelForCausalLMWithValueHead.from_pretrained(
    config.model_name, 
    peft_config=lora_config,
    load_in_4bit=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),X=new b({props:{title:"Naive pipeline parallelism (NPP) for large models (>60B models)",local:"naive-pipeline-parallelism-npp-for-large-models-60b-models",headingTag:"h2"}}),S=new b({props:{title:"How to use NPP?",local:"how-to-use-npp",headingTag:"h3"}}),D=new b({props:{title:"Launch scripts",local:"launch-scripts",headingTag:"h3"}}),K=new h({props:{code:"cHl0aG9uJTIwUEFUSF9UT19TQ1JJUFQ=",highlighted:"python PATH_TO_SCRIPT",wrap:!1}}),O=new b({props:{title:"Fine-tuning Llama-2 model",local:"fine-tuning-llama-2-model",headingTag:"h2"}}),te=new h({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZzY3JpcHRzJTJGc2Z0LnB5JTIwLS1vdXRwdXRfZGlyJTIwc2Z0X29wZW5hc3Npc3RhbnQtZ3VhbmFjbyUyMCUyMC0tbW9kZWxfbmFtZSUyMG1ldGEtbGxhbWElMkZMbGFtYS0yLTdiLWhmJTIwLS1kYXRhc2V0X25hbWUlMjB0aW1kZXR0bWVycyUyRm9wZW5hc3Npc3RhbnQtZ3VhbmFjbyUyMC0tbG9hZF9pbl80Yml0JTIwLS11c2VfcGVmdCUyMC0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwNCUyMC0tZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTIwMg==",highlighted:"python examples/scripts/sft.py --output_dir sft_openassistant-guanaco  --model_name meta-llama/Llama-2-7b-hf --dataset_name timdettmers/openassistant-guanaco --load_in_4bit --use_peft --per_device_train_batch_size 4 --gradient_accumulation_steps 2",wrap:!1}}),le=new _t({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/lora_tuning_peft.mdx"}}),{c(){w=s("meta"),ne=i(),ae=s("p"),se=i(),p(M.$$.fragment),oe=i(),y=s("p"),y.innerHTML=Ye,pe=i(),$=s("p"),$.innerHTML=ze,re=i(),T=s("table"),T.innerHTML=De,me=i(),p(_.$$.fragment),de=i(),Z=s("p"),Z.textContent=qe,fe=i(),p(U.$$.fragment),ce=i(),J=s("p"),J.innerHTML=Ke,ue=i(),p(v.$$.fragment),he=i(),C=s("p"),C.innerHTML=Oe,we=i(),p(j.$$.fragment),be=i(),x=s("p"),x.textContent=et,ge=i(),p(L.$$.fragment),Me=i(),H=s("p"),H.textContent=tt,ye=i(),p(k.$$.fragment),$e=i(),p(G.$$.fragment),Te=i(),W=s("p"),W.innerHTML=lt,_e=i(),p(B.$$.fragment),Ze=i(),p(F.$$.fragment),Ue=i(),R=s("p"),R.textContent=at,Je=i(),p(I.$$.fragment),ve=i(),N=s("p"),N.textContent=it,Ce=i(),p(A.$$.fragment),je=i(),E=s("p"),E.textContent=nt,xe=i(),p(P.$$.fragment),Le=i(),V=s("p"),V.innerHTML=st,He=i(),p(X.$$.fragment),ke=i(),Q=s("p"),Q.innerHTML=ot,Ge=i(),g=s("div"),g.innerHTML=pt,We=i(),p(S.$$.fragment),Be=i(),Y=s("p"),Y.innerHTML=rt,Fe=i(),z=s("p"),z.innerHTML=mt,Re=i(),p(D.$$.fragment),Ie=i(),q=s("p"),q.innerHTML=dt,Ne=i(),p(K.$$.fragment),Ae=i(),p(O.$$.fragment),Ee=i(),ee=s("p"),ee.innerHTML=ft,Pe=i(),p(te.$$.fragment),Ve=i(),p(le.$$.fragment),Xe=i(),ie=s("p"),this.h()},l(e){const t=yt("svelte-u9bgzb",document.head);w=o(t,"META",{name:!0,content:!0}),t.forEach(l),ne=n(e),ae=o(e,"P",{}),ct(ae).forEach(l),se=n(e),r(M.$$.fragment,e),oe=n(e),y=o(e,"P",{"data-svelte-h":!0}),u(y)!=="svelte-1z0xkop"&&(y.innerHTML=Ye),pe=n(e),$=o(e,"P",{"data-svelte-h":!0}),u($)!=="svelte-1mehpt8"&&($.innerHTML=ze),re=n(e),T=o(e,"TABLE",{"data-svelte-h":!0}),u(T)!=="svelte-5tx68h"&&(T.innerHTML=De),me=n(e),r(_.$$.fragment,e),de=n(e),Z=o(e,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-1xrpojm"&&(Z.textContent=qe),fe=n(e),r(U.$$.fragment,e),ce=n(e),J=o(e,"P",{"data-svelte-h":!0}),u(J)!=="svelte-vkwr34"&&(J.innerHTML=Ke),ue=n(e),r(v.$$.fragment,e),he=n(e),C=o(e,"P",{"data-svelte-h":!0}),u(C)!=="svelte-hndmna"&&(C.innerHTML=Oe),we=n(e),r(j.$$.fragment,e),be=n(e),x=o(e,"P",{"data-svelte-h":!0}),u(x)!=="svelte-lllysa"&&(x.textContent=et),ge=n(e),r(L.$$.fragment,e),Me=n(e),H=o(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-fsazu1"&&(H.textContent=tt),ye=n(e),r(k.$$.fragment,e),$e=n(e),r(G.$$.fragment,e),Te=n(e),W=o(e,"P",{"data-svelte-h":!0}),u(W)!=="svelte-1dq9zm0"&&(W.innerHTML=lt),_e=n(e),r(B.$$.fragment,e),Ze=n(e),r(F.$$.fragment,e),Ue=n(e),R=o(e,"P",{"data-svelte-h":!0}),u(R)!=="svelte-5gjozh"&&(R.textContent=at),Je=n(e),r(I.$$.fragment,e),ve=n(e),N=o(e,"P",{"data-svelte-h":!0}),u(N)!=="svelte-lllysa"&&(N.textContent=it),Ce=n(e),r(A.$$.fragment,e),je=n(e),E=o(e,"P",{"data-svelte-h":!0}),u(E)!=="svelte-fsazu1"&&(E.textContent=nt),xe=n(e),r(P.$$.fragment,e),Le=n(e),V=o(e,"P",{"data-svelte-h":!0}),u(V)!=="svelte-bxfofv"&&(V.innerHTML=st),He=n(e),r(X.$$.fragment,e),ke=n(e),Q=o(e,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-1wvtyh7"&&(Q.innerHTML=ot),Ge=n(e),g=o(e,"DIV",{style:!0,"data-svelte-h":!0}),u(g)!=="svelte-axlm0o"&&(g.innerHTML=pt),We=n(e),r(S.$$.fragment,e),Be=n(e),Y=o(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-baerbw"&&(Y.innerHTML=rt),Fe=n(e),z=o(e,"P",{"data-svelte-h":!0}),u(z)!=="svelte-pr8lox"&&(z.innerHTML=mt),Re=n(e),r(D.$$.fragment,e),Ie=n(e),q=o(e,"P",{"data-svelte-h":!0}),u(q)!=="svelte-qlesp3"&&(q.innerHTML=dt),Ne=n(e),r(K.$$.fragment,e),Ae=n(e),r(O.$$.fragment,e),Ee=n(e),ee=o(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-98ab3u"&&(ee.innerHTML=ft),Pe=n(e),r(te.$$.fragment,e),Ve=n(e),r(le.$$.fragment,e),Xe=n(e),ie=o(e,"P",{}),ct(ie).forEach(l),this.h()},h(){ut(w,"name","hf:doc:metadata"),ut(w,"content",Ut),$t(g,"text-align","center")},m(e,t){Tt(document.head,w),a(e,ne,t),a(e,ae,t),a(e,se,t),m(M,e,t),a(e,oe,t),a(e,y,t),a(e,pe,t),a(e,$,t),a(e,re,t),a(e,T,t),a(e,me,t),m(_,e,t),a(e,de,t),a(e,Z,t),a(e,fe,t),m(U,e,t),a(e,ce,t),a(e,J,t),a(e,ue,t),m(v,e,t),a(e,he,t),a(e,C,t),a(e,we,t),m(j,e,t),a(e,be,t),a(e,x,t),a(e,ge,t),m(L,e,t),a(e,Me,t),a(e,H,t),a(e,ye,t),m(k,e,t),a(e,$e,t),m(G,e,t),a(e,Te,t),a(e,W,t),a(e,_e,t),m(B,e,t),a(e,Ze,t),m(F,e,t),a(e,Ue,t),a(e,R,t),a(e,Je,t),m(I,e,t),a(e,ve,t),a(e,N,t),a(e,Ce,t),m(A,e,t),a(e,je,t),a(e,E,t),a(e,xe,t),m(P,e,t),a(e,Le,t),a(e,V,t),a(e,He,t),m(X,e,t),a(e,ke,t),a(e,Q,t),a(e,Ge,t),a(e,g,t),a(e,We,t),m(S,e,t),a(e,Be,t),a(e,Y,t),a(e,Fe,t),a(e,z,t),a(e,Re,t),m(D,e,t),a(e,Ie,t),a(e,q,t),a(e,Ne,t),m(K,e,t),a(e,Ae,t),m(O,e,t),a(e,Ee,t),a(e,ee,t),a(e,Pe,t),m(te,e,t),a(e,Ve,t),m(le,e,t),a(e,Xe,t),a(e,ie,t),Qe=!0},p:wt,i(e){Qe||(d(M.$$.fragment,e),d(_.$$.fragment,e),d(U.$$.fragment,e),d(v.$$.fragment,e),d(j.$$.fragment,e),d(L.$$.fragment,e),d(k.$$.fragment,e),d(G.$$.fragment,e),d(B.$$.fragment,e),d(F.$$.fragment,e),d(I.$$.fragment,e),d(A.$$.fragment,e),d(P.$$.fragment,e),d(X.$$.fragment,e),d(S.$$.fragment,e),d(D.$$.fragment,e),d(K.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(le.$$.fragment,e),Qe=!0)},o(e){f(M.$$.fragment,e),f(_.$$.fragment,e),f(U.$$.fragment,e),f(v.$$.fragment,e),f(j.$$.fragment,e),f(L.$$.fragment,e),f(k.$$.fragment,e),f(G.$$.fragment,e),f(B.$$.fragment,e),f(F.$$.fragment,e),f(I.$$.fragment,e),f(A.$$.fragment,e),f(P.$$.fragment,e),f(X.$$.fragment,e),f(S.$$.fragment,e),f(D.$$.fragment,e),f(K.$$.fragment,e),f(O.$$.fragment,e),f(te.$$.fragment,e),f(le.$$.fragment,e),Qe=!1},d(e){e&&(l(ne),l(ae),l(se),l(oe),l(y),l(pe),l($),l(re),l(T),l(me),l(de),l(Z),l(fe),l(ce),l(J),l(ue),l(he),l(C),l(we),l(be),l(x),l(ge),l(Me),l(H),l(ye),l($e),l(Te),l(W),l(_e),l(Ze),l(Ue),l(R),l(Je),l(ve),l(N),l(Ce),l(je),l(E),l(xe),l(Le),l(V),l(He),l(ke),l(Q),l(Ge),l(g),l(We),l(Be),l(Y),l(Fe),l(z),l(Re),l(Ie),l(q),l(Ne),l(Ae),l(Ee),l(ee),l(Pe),l(Ve),l(Xe),l(ie)),l(w),c(M,e),c(_,e),c(U,e),c(v,e),c(j,e),c(L,e),c(k,e),c(G,e),c(B,e),c(F,e),c(I,e),c(A,e),c(P,e),c(X,e),c(S,e),c(D,e),c(K,e),c(O,e),c(te,e),c(le,e)}}}const Ut='{"title":"Examples of using peft with trl to finetune 8-bit models with Low Rank Adaption (LoRA)","local":"examples-of-using-peft-with-trl-to-finetune-8-bit-models-with-low-rank-adaption-lora","sections":[{"title":"Installation","local":"installation","sections":[],"depth":2},{"title":"How to use it?","local":"how-to-use-it","sections":[],"depth":2},{"title":"Launch scripts","local":"launch-scripts","sections":[],"depth":2},{"title":"Using trl + peft and Data Parallelism","local":"using-trl--peft-and-data-parallelism","sections":[],"depth":2},{"title":"Naive pipeline parallelism (NPP) for large models (>60B models)","local":"naive-pipeline-parallelism-npp-for-large-models-60b-models","sections":[{"title":"How to use NPP?","local":"how-to-use-npp","sections":[],"depth":3},{"title":"Launch scripts","local":"launch-scripts","sections":[],"depth":3}],"depth":2},{"title":"Fine-tuning Llama-2 model","local":"fine-tuning-llama-2-model","sections":[],"depth":2}],"depth":1}';function Jt(Se){return bt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Lt extends gt{constructor(w){super(),Mt(this,w,Jt,Zt,ht,{})}}export{Lt as component};
