import{s as Ie,a as Le,n as Ee,o as He}from"../chunks/scheduler.505acc25.js";import{S as Be,i as Se,e as i,s as l,c as m,h as Ze,a as o,d as n,b as a,f as _e,g as d,j as r,k as nt,l as Pe,m as s,n as f,t as g,o as M,p as y}from"../chunks/index.fbb49fb4.js";import{C as Ge}from"../chunks/CopyLLMTxtMenu.564b44fd.js";import{C as $e}from"../chunks/CodeBlock.7f0851b7.js";import{H as Yt}from"../chunks/Heading.511e0027.js";import{E as qe}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8c19e80e.js";function Fe(Ot){let p,at,st,it,w,ot,C,rt,u,Dt="<p>In this section, we explore the concrete steps an AI agent takes to interact with its environment.</p> <p>We’ll cover how actions are represented (using JSON or code), the importance of the stop and parse approach, and introduce different types of agents.</p>",pt,v,Kt="Actions are the concrete steps an <strong>AI agent takes to interact with its environment</strong>.",ut,x,te="Whether it’s browsing the web for information or controlling a physical device, each action is a deliberate operation executed by the agent.",ct,T,ee="For example, an agent assisting with customer service might retrieve customer data, offer support articles, or transfer issues to a human representative.",ht,b,mt,j,ne="There are multiple types of Agents that take actions differently:",dt,U,se="<thead><tr><th>Type of Agent</th> <th>Description</th></tr></thead> <tbody><tr><td>JSON Agent</td> <td>The Action to take is specified in JSON format.</td></tr> <tr><td>Code Agent</td> <td>The Agent writes a code block that is interpreted externally.</td></tr> <tr><td>Function-calling Agent</td> <td>It is a subcategory of the JSON Agent which has been fine-tuned to generate a new message for each action.</td></tr></tbody>",ft,J,le="Actions themselves can serve many purposes:",gt,k,ae="<thead><tr><th>Type of Action</th> <th>Description</th></tr></thead> <tbody><tr><td>Information Gathering</td> <td>Performing web searches, querying databases, or retrieving documents.</td></tr> <tr><td>Tool Usage</td> <td>Making API calls, running calculations, and executing code.</td></tr> <tr><td>Environment Interaction</td> <td>Manipulating digital interfaces or controlling physical devices.</td></tr> <tr><td>Communication</td> <td>Engaging with users via chat or collaborating with other agents.</td></tr></tbody>",Mt,A,ie="The LLM only handles text and uses it to describe the action it wants to take and the parameters to supply to the tool. For an agent to work properly, the LLM must STOP generating new tokens after emitting all the tokens to define a complete Action. This passes control from the LLM back to the agent and ensures the result is parseable - whether the intended format is JSON, code, or function-calling.",yt,_,wt,$,oe="One key method for implementing actions is the <strong>stop and parse approach</strong>. This method ensures that the agent’s output is structured and predictable:",Ct,I,re="<li><strong>Generation in a Structured Format</strong>:</li>",vt,L,pe="The agent outputs its intended action in a clear, predetermined format (JSON or code).",xt,c,ue="<li><strong>Halting Further Generation</strong>:</li>",Tt,E,ce="Once the text defining the action has been emitted, <strong>the LLM stops generating additional tokens</strong>. This prevents extra or erroneous output.",bt,h,he="<li><strong>Parsing the Output</strong>:</li>",jt,H,me="An external parser reads the formatted action, determines which Tool to call, and extracts the required parameters.",Ut,B,de="For example, an agent needing to check the weather might output:",Jt,S,kt,Z,fe="The framework can then easily parse the name of the function to call and the arguments to apply.",At,P,ge="This clear, machine-readable format minimizes errors and enables external tools to accurately process the agent’s command.",_t,G,Me=`Note: Function-calling agents operate similarly by structuring each action so that a designated function is invoked with the correct arguments.
We’ll dive deeper into those types of Agents in a future Unit.`,$t,q,It,F,ye=`An alternative approach is using <em>Code Agents</em>.
The idea is: <strong>instead of outputting a simple JSON object</strong>, a Code Agent generates an <strong>executable code block—typically in a high-level language like Python</strong>.`,Lt,W,we,Et,N,Ce="This approach offers several advantages:",Ht,R,ve="<li><strong>Expressiveness:</strong> Code can naturally represent complex logic, including loops, conditionals, and nested functions, providing greater flexibility than JSON.</li> <li><strong>Modularity and Reusability:</strong> Generated code can include functions and modules that are reusable across different actions or tasks.</li> <li><strong>Enhanced Debuggability:</strong> With a well-defined programming syntax, code errors are often easier to detect and correct.</li> <li><strong>Direct Integration:</strong> Code Agents can integrate directly with external libraries and APIs, enabling more complex operations such as data processing or real-time decision making.</li>",Bt,V,xe=`You must keep in mind that executing LLM-generated code may pose security risks, from prompt injection to the execution of harmful code.
That’s why it’s recommended to use AI agent frameworks like <code>smolagents</code> that integrate default safeguards.
If you want to know more about the risks and how to mitigate them, <a href="https://huggingface.co/docs/smolagents/tutorials/secure_code_execution" rel="nofollow">please have a look at this dedicated section</a>.`,St,X,Te="For example, a Code Agent tasked with fetching the weather might generate the following Python snippet:",Zt,z,Pt,Q,be="In this example, the Code Agent:",Gt,Y,je="<li>Retrieves weather data <strong>via an API call</strong>,</li> <li>Processes the response,</li> <li>And uses the print() function to output a final answer.</li>",qt,O,Ue="This method <strong>also follows the stop and parse approach</strong> by clearly delimiting the code block and signaling when execution is complete (here, by printing the final_answer).",Ft,Wt,Nt,D,Je="We learned that Actions bridge an agent’s internal reasoning and its real-world interactions by executing clear, structured tasks—whether through JSON, code, or function calls.",Rt,K,ke="This deliberate execution ensures that each action is precise and ready for external processing via the stop and parse approach. In the next section, we will explore Observations to see how agents capture and integrate feedback from their environment.",Vt,tt,Ae="After this, we will <strong>finally be ready to build our first Agent!</strong>",Xt,et,zt,lt,Qt;return w=new Ge({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),C=new Yt({props:{title:"Actions:  Enabling the Agent to Engage with Its Environment",local:"actions-enabling-the-agent-to-engage-with-its-environment",headingTag:"h1"}}),b=new Yt({props:{title:"Types of Agent Actions",local:"types-of-agent-actions",headingTag:"h2"}}),_=new Yt({props:{title:"The Stop and Parse Approach",local:"the-stop-and-parse-approach",headingTag:"h2"}}),S=new $e({props:{code:"VGhvdWdodCUzQSUyMEklMjBuZWVkJTIwdG8lMjBjaGVjayUyMHRoZSUyMGN1cnJlbnQlMjB3ZWF0aGVyJTIwZm9yJTIwTmV3JTIwWW9yay4lMEFBY3Rpb24lMjAlM0ElMEElN0IlMEElMjAlMjAlMjJhY3Rpb24lMjIlM0ElMjAlMjJnZXRfd2VhdGhlciUyMiUyQyUwQSUyMCUyMCUyMmFjdGlvbl9pbnB1dCUyMiUzQSUyMCU3QiUyMmxvY2F0aW9uJTIyJTNBJTIwJTIyTmV3JTIwWW9yayUyMiU3RCUwQSU3RA==",highlighted:`Thought<span class="hljs-punctuation">:</span> I need to check the current weather for New York.
Action <span class="hljs-punctuation">:</span>
<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;action&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;get_weather&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;action_input&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;New York&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),q=new Yt({props:{title:"Code Agents",local:"code-agents",headingTag:"h2"}}),z=new $e({props:{code:"JTIzJTIwQ29kZSUyMEFnZW50JTIwRXhhbXBsZSUzQSUyMFJldHJpZXZlJTIwV2VhdGhlciUyMEluZm9ybWF0aW9uJTBBZGVmJTIwZ2V0X3dlYXRoZXIoY2l0eSklM0ElMEElMjAlMjAlMjAlMjBpbXBvcnQlMjByZXF1ZXN0cyUwQSUyMCUyMCUyMCUyMGFwaV91cmwlMjAlM0QlMjBmJTIyaHR0cHMlM0ElMkYlMkZhcGkud2VhdGhlci5jb20lMkZ2MSUyRmxvY2F0aW9uJTJGJTdCY2l0eSU3RCUzRmFwaUtleSUzRFlPVVJfQVBJX0tFWSUyMiUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KGFwaV91cmwpJTBBJTIwJTIwJTIwJTIwaWYlMjByZXNwb25zZS5zdGF0dXNfY29kZSUyMCUzRCUzRCUyMDIwMCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGElMjAlM0QlMjByZXNwb25zZS5qc29uKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBkYXRhLmdldCglMjJ3ZWF0aGVyJTIyJTJDJTIwJTIyTm8lMjB3ZWF0aGVyJTIwaW5mb3JtYXRpb24lMjBhdmFpbGFibGUlMjIpJTBBJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMkVycm9yJTNBJTIwVW5hYmxlJTIwdG8lMjBmZXRjaCUyMHdlYXRoZXIlMjBkYXRhLiUyMiUwQSUwQSUyMyUyMEV4ZWN1dGUlMjB0aGUlMjBmdW5jdGlvbiUyMGFuZCUyMHByZXBhcmUlMjB0aGUlMjBmaW5hbCUyMGFuc3dlciUwQXJlc3VsdCUyMCUzRCUyMGdldF93ZWF0aGVyKCUyMk5ldyUyMFlvcmslMjIpJTBBZmluYWxfYW5zd2VyJTIwJTNEJTIwZiUyMlRoZSUyMGN1cnJlbnQlMjB3ZWF0aGVyJTIwaW4lMjBOZXclMjBZb3JrJTIwaXMlM0ElMjAlN0JyZXN1bHQlN0QlMjIlMEFwcmludChmaW5hbF9hbnN3ZXIp",highlighted:`<span class="hljs-comment"># Code Agent Example: Retrieve Weather Information</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather</span>(<span class="hljs-params">city</span>):
    <span class="hljs-keyword">import</span> requests
    api_url = <span class="hljs-string">f&quot;https://api.weather.com/v1/location/<span class="hljs-subst">{city}</span>?apiKey=YOUR_API_KEY&quot;</span>
    response = requests.get(api_url)
    <span class="hljs-keyword">if</span> response.status_code == <span class="hljs-number">200</span>:
        data = response.json()
        <span class="hljs-keyword">return</span> data.get(<span class="hljs-string">&quot;weather&quot;</span>, <span class="hljs-string">&quot;No weather information available&quot;</span>)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Error: Unable to fetch weather data.&quot;</span>

<span class="hljs-comment"># Execute the function and prepare the final answer</span>
result = get_weather(<span class="hljs-string">&quot;New York&quot;</span>)
final_answer = <span class="hljs-string">f&quot;The current weather in New York is: <span class="hljs-subst">{result}</span>&quot;</span>
<span class="hljs-built_in">print</span>(final_answer)`,wrap:!1}}),et=new qe({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/actions.mdx"}}),{c(){p=i("meta"),at=l(),st=i("p"),it=l(),m(w.$$.fragment),ot=l(),m(C.$$.fragment),rt=l(),u=i("blockquote"),u.innerHTML=Dt,pt=l(),v=i("p"),v.innerHTML=Kt,ut=l(),x=i("p"),x.textContent=te,ct=l(),T=i("p"),T.textContent=ee,ht=l(),m(b.$$.fragment),mt=l(),j=i("p"),j.textContent=ne,dt=l(),U=i("table"),U.innerHTML=se,ft=l(),J=i("p"),J.textContent=le,gt=l(),k=i("table"),k.innerHTML=ae,Mt=l(),A=i("p"),A.textContent=ie,yt=l(),m(_.$$.fragment),wt=l(),$=i("p"),$.innerHTML=oe,Ct=l(),I=i("ol"),I.innerHTML=re,vt=l(),L=i("p"),L.textContent=pe,xt=l(),c=i("ol"),c.innerHTML=ue,Tt=l(),E=i("p"),E.innerHTML=ce,bt=l(),h=i("ol"),h.innerHTML=he,jt=l(),H=i("p"),H.textContent=me,Ut=l(),B=i("p"),B.textContent=de,Jt=l(),m(S.$$.fragment),kt=l(),Z=i("p"),Z.textContent=fe,At=l(),P=i("p"),P.textContent=ge,_t=l(),G=i("p"),G.textContent=Me,$t=l(),m(q.$$.fragment),It=l(),F=i("p"),F.innerHTML=ye,Lt=l(),W=i("img"),Et=l(),N=i("p"),N.textContent=Ce,Ht=l(),R=i("ul"),R.innerHTML=ve,Bt=l(),V=i("p"),V.innerHTML=xe,St=l(),X=i("p"),X.textContent=Te,Zt=l(),m(z.$$.fragment),Pt=l(),Q=i("p"),Q.textContent=be,Gt=l(),Y=i("ul"),Y.innerHTML=je,qt=l(),O=i("p"),O.innerHTML=Ue,Ft=l(),Wt=i("hr"),Nt=l(),D=i("p"),D.textContent=Je,Rt=l(),K=i("p"),K.textContent=ke,Vt=l(),tt=i("p"),tt.innerHTML=Ae,Xt=l(),m(et.$$.fragment),zt=l(),lt=i("p"),this.h()},l(t){const e=Ze("svelte-u9bgzb",document.head);p=o(e,"META",{name:!0,content:!0}),e.forEach(n),at=a(t),st=o(t,"P",{}),_e(st).forEach(n),it=a(t),d(w.$$.fragment,t),ot=a(t),d(C.$$.fragment,t),rt=a(t),u=o(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(u)!=="svelte-z9840f"&&(u.innerHTML=Dt),pt=a(t),v=o(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1d9hktj"&&(v.innerHTML=Kt),ut=a(t),x=o(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1tl5mip"&&(x.textContent=te),ct=a(t),T=o(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1ubetp8"&&(T.textContent=ee),ht=a(t),d(b.$$.fragment,t),mt=a(t),j=o(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1wlcwgd"&&(j.textContent=ne),dt=a(t),U=o(t,"TABLE",{"data-svelte-h":!0}),r(U)!=="svelte-3ls1cj"&&(U.innerHTML=se),ft=a(t),J=o(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1xp7kgk"&&(J.textContent=le),gt=a(t),k=o(t,"TABLE",{"data-svelte-h":!0}),r(k)!=="svelte-4604oy"&&(k.innerHTML=ae),Mt=a(t),A=o(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-172oujm"&&(A.textContent=ie),yt=a(t),d(_.$$.fragment,t),wt=a(t),$=o(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-a9as0m"&&($.innerHTML=oe),Ct=a(t),I=o(t,"OL",{"data-svelte-h":!0}),r(I)!=="svelte-1nmidra"&&(I.innerHTML=re),vt=a(t),L=o(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-l3tk2o"&&(L.textContent=pe),xt=a(t),c=o(t,"OL",{start:!0,"data-svelte-h":!0}),r(c)!=="svelte-j1mwkc"&&(c.innerHTML=ue),Tt=a(t),E=o(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1hxxesc"&&(E.innerHTML=ce),bt=a(t),h=o(t,"OL",{start:!0,"data-svelte-h":!0}),r(h)!=="svelte-w7r926"&&(h.innerHTML=he),jt=a(t),H=o(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-191aaii"&&(H.textContent=me),Ut=a(t),B=o(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1exbnez"&&(B.textContent=de),Jt=a(t),d(S.$$.fragment,t),kt=a(t),Z=o(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1j4o5aq"&&(Z.textContent=fe),At=a(t),P=o(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1so9m39"&&(P.textContent=ge),_t=a(t),G=o(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1k8g2zy"&&(G.textContent=Me),$t=a(t),d(q.$$.fragment,t),It=a(t),F=o(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-19f0lzf"&&(F.innerHTML=ye),Lt=a(t),W=o(t,"IMG",{src:!0,alt:!0}),Et=a(t),N=o(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-rsd8hl"&&(N.textContent=Ce),Ht=a(t),R=o(t,"UL",{"data-svelte-h":!0}),r(R)!=="svelte-1t80mrq"&&(R.innerHTML=ve),Bt=a(t),V=o(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-6v19zm"&&(V.innerHTML=xe),St=a(t),X=o(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-qjq0mw"&&(X.textContent=Te),Zt=a(t),d(z.$$.fragment,t),Pt=a(t),Q=o(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-pfpi4"&&(Q.textContent=be),Gt=a(t),Y=o(t,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-b7upo8"&&(Y.innerHTML=je),qt=a(t),O=o(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1v0y8k3"&&(O.innerHTML=Ue),Ft=a(t),Wt=o(t,"HR",{}),Nt=a(t),D=o(t,"P",{"data-svelte-h":!0}),r(D)!=="svelte-b7m3f6"&&(D.textContent=Je),Rt=a(t),K=o(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-h8bvqv"&&(K.textContent=ke),Vt=a(t),tt=o(t,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-14ocnmz"&&(tt.innerHTML=Ae),Xt=a(t),d(et.$$.fragment,t),zt=a(t),lt=o(t,"P",{}),_e(lt).forEach(n),this.h()},h(){nt(p,"name","hf:doc:metadata"),nt(p,"content",We),nt(u,"class","tip"),nt(c,"start","2"),nt(h,"start","3"),Le(W.src,we="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/code-vs-json-actions.png")||nt(W,"src",we),nt(W,"alt","Code Agents")},m(t,e){Pe(document.head,p),s(t,at,e),s(t,st,e),s(t,it,e),f(w,t,e),s(t,ot,e),f(C,t,e),s(t,rt,e),s(t,u,e),s(t,pt,e),s(t,v,e),s(t,ut,e),s(t,x,e),s(t,ct,e),s(t,T,e),s(t,ht,e),f(b,t,e),s(t,mt,e),s(t,j,e),s(t,dt,e),s(t,U,e),s(t,ft,e),s(t,J,e),s(t,gt,e),s(t,k,e),s(t,Mt,e),s(t,A,e),s(t,yt,e),f(_,t,e),s(t,wt,e),s(t,$,e),s(t,Ct,e),s(t,I,e),s(t,vt,e),s(t,L,e),s(t,xt,e),s(t,c,e),s(t,Tt,e),s(t,E,e),s(t,bt,e),s(t,h,e),s(t,jt,e),s(t,H,e),s(t,Ut,e),s(t,B,e),s(t,Jt,e),f(S,t,e),s(t,kt,e),s(t,Z,e),s(t,At,e),s(t,P,e),s(t,_t,e),s(t,G,e),s(t,$t,e),f(q,t,e),s(t,It,e),s(t,F,e),s(t,Lt,e),s(t,W,e),s(t,Et,e),s(t,N,e),s(t,Ht,e),s(t,R,e),s(t,Bt,e),s(t,V,e),s(t,St,e),s(t,X,e),s(t,Zt,e),f(z,t,e),s(t,Pt,e),s(t,Q,e),s(t,Gt,e),s(t,Y,e),s(t,qt,e),s(t,O,e),s(t,Ft,e),s(t,Wt,e),s(t,Nt,e),s(t,D,e),s(t,Rt,e),s(t,K,e),s(t,Vt,e),s(t,tt,e),s(t,Xt,e),f(et,t,e),s(t,zt,e),s(t,lt,e),Qt=!0},p:Ee,i(t){Qt||(g(w.$$.fragment,t),g(C.$$.fragment,t),g(b.$$.fragment,t),g(_.$$.fragment,t),g(S.$$.fragment,t),g(q.$$.fragment,t),g(z.$$.fragment,t),g(et.$$.fragment,t),Qt=!0)},o(t){M(w.$$.fragment,t),M(C.$$.fragment,t),M(b.$$.fragment,t),M(_.$$.fragment,t),M(S.$$.fragment,t),M(q.$$.fragment,t),M(z.$$.fragment,t),M(et.$$.fragment,t),Qt=!1},d(t){t&&(n(at),n(st),n(it),n(ot),n(rt),n(u),n(pt),n(v),n(ut),n(x),n(ct),n(T),n(ht),n(mt),n(j),n(dt),n(U),n(ft),n(J),n(gt),n(k),n(Mt),n(A),n(yt),n(wt),n($),n(Ct),n(I),n(vt),n(L),n(xt),n(c),n(Tt),n(E),n(bt),n(h),n(jt),n(H),n(Ut),n(B),n(Jt),n(kt),n(Z),n(At),n(P),n(_t),n(G),n($t),n(It),n(F),n(Lt),n(W),n(Et),n(N),n(Ht),n(R),n(Bt),n(V),n(St),n(X),n(Zt),n(Pt),n(Q),n(Gt),n(Y),n(qt),n(O),n(Ft),n(Wt),n(Nt),n(D),n(Rt),n(K),n(Vt),n(tt),n(Xt),n(zt),n(lt)),n(p),y(w,t),y(C,t),y(b,t),y(_,t),y(S,t),y(q,t),y(z,t),y(et,t)}}}const We='{"title":"Actions:  Enabling the Agent to Engage with Its Environment","local":"actions-enabling-the-agent-to-engage-with-its-environment","sections":[{"title":"Types of Agent Actions","local":"types-of-agent-actions","sections":[],"depth":2},{"title":"The Stop and Parse Approach","local":"the-stop-and-parse-approach","sections":[],"depth":2},{"title":"Code Agents","local":"code-agents","sections":[],"depth":2}],"depth":1}';function Ne(Ot){return He(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Oe extends Be{constructor(p){super(),Se(this,p,Ne,Fe,Ie,{})}}export{Oe as component};
