import{s as Cl,a as We,n as Bl,o as vl}from"../chunks/scheduler.505acc25.js";import{S as Zl,i as Al,e as o,s as n,c as m,h as Gl,a as i,d as l,b as a,f as _e,g as y,j as M,k as r,l as Wl,m as s,n as c,t as u,o as w,p as h}from"../chunks/index.fbb49fb4.js";import{C as _l}from"../chunks/CopyLLMTxtMenu.564b44fd.js";import{C as Ge}from"../chunks/CodeBlock.7f0851b7.js";import{H as dt}from"../chunks/Heading.511e0027.js";import{E as xl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8c19e80e.js";function Hl(xe){let T,gt,Ut,ft,j,It,J,Ct,d,He="In the last section, we learned how we can create Agents from scratch using Python code, and we <strong>saw just how tedious that process can be</strong>. Fortunately, many Agent libraries simplify this work by <strong>handling much of the heavy lifting for you</strong>.",Bt,U,Ee="In this tutorial, <strong>you’ll create your very first Agent</strong> capable of performing actions such as image generation, web search, time zone checking and much more!",vt,b,ke="You will also publish your agent <strong>on a Hugging Face Space so you can share it with friends and colleagues</strong>.",Zt,g,Ve="Let’s get started!",At,f,Gt,I,Re,Wt,C,Se="To make this Agent, we’re going to use <code>smolagents</code>, a library that <strong>provides a framework for developing your agents with ease</strong>.",_t,B,Qe="This lightweight library is designed for simplicity, but it abstracts away much of the complexity of building an Agent, allowing you to focus on designing your agent’s behavior.",xt,v,ze='We’re going to get deeper into smolagents in the next Unit. Meanwhile, you can also check this <a href="https://huggingface.co/blog/smolagents" target="_blank">blog post</a> or the library’s <a href="https://github.com/huggingface/smolagents" target="_blank">repo in GitHub</a>.',Ht,Z,Ne="In short, <code>smolagents</code> is a library that focuses on <strong>codeAgent</strong>, a kind of agent that performs <strong>“Actions”</strong> through code blocks, and then <strong>“Observes”</strong> results by executing the code.",Et,A,Xe="Here is an example of what we’ll build!",kt,G,Fe="We provided our agent with an <strong>Image generation tool</strong> and asked it to generate an image of a cat.",Vt,W,$e="The agent inside <code>smolagents</code> is going to have the <strong>same behaviors as the custom one we built previously</strong>: it’s going <strong>to think, act and observe in cycle</strong> until it reaches a final answer:",Rt,p,Le,St,_,Ye="Exciting, right?",Qt,x,zt,H,qe='To start, duplicate this Space: <a href="https://huggingface.co/spaces/agents-course/First_agent_template" target="_blank">https://huggingface.co/spaces/agents-course/First_agent_template</a>',Nt,E,Pe='<p>Thanks to <a href="https://huggingface.co/m-ric" target="_blank">Aymeric</a> for this template! 🙌</p>',Xt,k,De="Duplicating this space means <strong>creating a local copy on your own profile</strong>:",Ft,V,Ke,$t,R,Oe="After duplicating the Space, you’ll need to add your Hugging Face API token so your agent can access the model API:",Lt,S,tl='<li>First, get your Hugging Face token from <a href="https://hf.co/settings/tokens" rel="nofollow">https://hf.co/settings/tokens</a> with permission for inference, if you don’t already have one</li> <li>Go to your duplicated Space and click on the <strong>Settings</strong> tab</li> <li>Scroll down to the <strong>Variables and Secrets</strong> section and click <strong>New Secret</strong></li> <li>Create a secret with the name <code>HF_TOKEN</code> and paste your token as the value</li> <li>Click <strong>Save</strong> to store your token securely</li>',Yt,Q,el='Throughout this lesson, the only file you will need to modify is the (currently incomplete) <strong>“app.py”</strong>. You can see here the <a href="https://huggingface.co/spaces/agents-course/First_agent_template/blob/main/app.py" rel="nofollow">original one in the template</a>. To find yours, go to your copy of the space, then click the <code>Files</code> tab and then on <code>app.py</code> in the directory listing.',qt,z,ll="Let’s break down the code together:",Pt,N,sl="<li>The file begins with some simple but necessary library imports</li>",Dt,X,Kt,F,nl="As outlined earlier, we will directly use the <strong>CodeAgent</strong> class from <strong>smolagents</strong>.",Ot,$,te,L,al='Now let’s get into the tools! If you want a refresher about tools, don’t hesitate to go back to the <a href="tools">Tools</a> section of the course.',ee,Y,le,q,ol="The Tools are what we are encouraging you to build in this section! We give you two examples:",se,P,il="<li>A <strong>non-working dummy Tool</strong> that you can modify to make something useful.</li> <li>An <strong>actually working Tool</strong> that gets the current time somewhere in the world.</li>",ne,D,Ml="To define your tool it is important to:",ae,K,pl="<li>Provide input and output types for your function, like in <code>get_current_time_in_timezone(timezone: str) -&gt; str:</code></li> <li><strong>A well formatted docstring</strong>. <code>smolagents</code> is expecting all the arguments to have a <strong>textual description in the docstring</strong>.</li>",oe,O,ie,tt,rl='It uses <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow"><code>Qwen/Qwen2.5-Coder-32B-Instruct</code></a> as the LLM engine. This is a very capable model that we’ll access via the serverless API.',Me,et,pe,lt,ml="This Agent still uses the <code>InferenceClient</code> we saw in an earlier section behind the <strong>InferenceClientModel</strong> class!",re,st,yl="We will give more in-depth examples when we present the framework in Unit 2. For now, you need to focus on <strong>adding new tools to the list of tools</strong> using the <code>tools</code> parameter of your Agent.",me,nt,cl="For example, you could use the <code>DuckDuckGoSearchTool</code> that was imported in the first line of the code, or you can examine the <code>image_generation_tool</code> that is loaded from the Hub later in the code.",ye,at,ul="<strong>Adding tools will give your agent new capabilities</strong>, try to be creative here!",ce,ot,ue,it,wl="The agent’s system prompt is stored in a separate <code>prompts.yaml</code> file. This file contains predefined instructions that guide the agent’s behavior.",we,Mt,hl="Storing prompts in a YAML file allows for easy customization and reuse across different agents or use cases.",he,pt,Tl='You can check the <a href="https://huggingface.co/spaces/agents-course/First_agent_template/tree/main" rel="nofollow">Space’s file structure</a> to see where the <code>prompts.yaml</code> file is located and how it’s organized within the project.',Te,rt,jl="The complete “app.py”:",je,mt,Je,yt,Jl="Your <strong>Goal</strong> is to get familiar with the Space and the Agent.",de,ct,dl="Currently, the agent in the template <strong>does not use any tools, so try to provide it with some of the pre-made ones or even make some new tools yourself!</strong>",Ue,ut,Ul="We are eagerly waiting for your amazing agents output in the discord channel <strong>#agents-course-showcase</strong>!",be,ge,fe,wt,bl="Congratulations, you’ve built your first Agent! Don’t hesitate to share it with your friends and colleagues.",Ie,ht,gl="Since this is your first try, it’s perfectly normal if it’s a little buggy or slow. In future units, we’ll learn how to build even better Agents.",Ce,Tt,fl="The best way to learn is to try, so don’t hesitate to update it, add more tools, try with another model, etc.",Be,jt,Il="In the next section, you’re going to fill the final Quiz and get your certificate!",ve,Jt,Ze,bt,Ae;return j=new _l({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new dt({props:{title:"Let’s Create Our First Agent Using smolagents",local:"lets-create-our-first-agent-using-smolagents",headingTag:"h1"}}),f=new dt({props:{title:"What is smolagents?",local:"what-is-smolagents",headingTag:"h2"}}),x=new dt({props:{title:"Let’s build our Agent!",local:"lets-build-our-agent",headingTag:"h2"}}),X=new Ge({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEZpbmFsQW5zd2VyVG9vbCUyQyUyMEluZmVyZW5jZUNsaWVudE1vZGVsJTJDJTIwbG9hZF90b29sJTJDJTIwdG9vbCUwQWltcG9ydCUyMGRhdGV0aW1lJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjBweXR6JTBBaW1wb3J0JTIweWFtbA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, FinalAnswerTool, InferenceClientModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml`,wrap:!1}}),$=new dt({props:{title:"The Tools",local:"the-tools",headingTag:"h3"}}),Y=new Ge({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment"># it&#x27;s important to specify the return type</span>
    <span class="hljs-comment"># Keep this format for the tool description / args description but feel free to modify the tool</span>
    <span class="hljs-string">&quot;&quot;&quot;A tool that does nothing yet 
    Args:
        arg1: the first argument
        arg2: the second argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;What magic will you build ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;A tool that fetches the current local time in a specified timezone.
    Args:
        timezone: A string representing a valid timezone (e.g., &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Create timezone object</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Get current time in that timezone</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;The current local time in <span class="hljs-subst">{timezone}</span> is: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching time for timezone &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),O=new dt({props:{title:"The Agent",local:"the-agent",headingTag:"h3"}}),et=new Ge({props:{code:"ZmluYWxfYW5zd2VyJTIwJTNEJTIwRmluYWxBbnN3ZXJUb29sKCklMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKCUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QyMDk2JTJDJTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjUlMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCdRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QnJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3JvbGVfY29udmVyc2lvbnMlM0ROb25lJTJDJTBBKSUwQSUwQXdpdGglMjBvcGVuKCUyMnByb21wdHMueWFtbCUyMiUyQyUyMCdyJyklMjBhcyUyMHN0cmVhbSUzQSUwQSUyMCUyMCUyMCUyMHByb21wdF90ZW1wbGF0ZXMlMjAlM0QlMjB5YW1sLnNhZmVfbG9hZChzdHJlYW0pJTBBJTIwJTIwJTIwJTIwJTBBJTIzJTIwV2UncmUlMjBjcmVhdGluZyUyMG91ciUyMENvZGVBZ2VudCUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QmZpbmFsX2Fuc3dlciU1RCUyQyUyMCUyMyUyMGFkZCUyMHlvdXIlMjB0b29scyUyMGhlcmUlMjAoZG9uJ3QlMjByZW1vdmUlMjBmaW5hbF9hbnN3ZXIpJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNENiUyQyUwQSUyMCUyMCUyMCUyMHZlcmJvc2l0eV9sZXZlbCUzRDElMkMlMEElMjAlMjAlMjAlMjBncmFtbWFyJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHBsYW5uaW5nX2ludGVydmFsJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMG5hbWUlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwcHJvbXB0X3RlbXBsYXRlcyUzRHByb21wdF90ZW1wbGF0ZXMlMEEpJTBBJTBBR3JhZGlvVUkoYWdlbnQpLmxhdW5jaCgp",highlighted:`final_answer = FinalAnswerTool()
model = InferenceClientModel(
    max_tokens=<span class="hljs-number">2096</span>,
    temperature=<span class="hljs-number">0.5</span>,
    model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
    custom_role_conversions=<span class="hljs-literal">None</span>,
)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
<span class="hljs-comment"># We&#x27;re creating our CodeAgent</span>
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment"># add your tools here (don&#x27;t remove final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)

GradioUI(agent).launch()`,wrap:!1}}),ot=new dt({props:{title:"The System Prompt",local:"the-system-prompt",headingTag:"h3"}}),mt=new Ge({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, InferenceClientModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool

<span class="hljs-keyword">from</span> Gradio_UI <span class="hljs-keyword">import</span> GradioUI

<span class="hljs-comment"># Below is an example of a tool that does nothing. Amaze us with your creativity!</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment"># it&#x27;s important to specify the return type</span>
    <span class="hljs-comment"># Keep this format for the tool description / args description but feel free to modify the tool</span>
    <span class="hljs-string">&quot;&quot;&quot;A tool that does nothing yet 
    Args:
        arg1: the first argument
        arg2: the second argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;What magic will you build ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;A tool that fetches the current local time in a specified timezone.
    Args:
        timezone: A string representing a valid timezone (e.g., &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Create timezone object</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Get current time in that timezone</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;The current local time in <span class="hljs-subst">{timezone}</span> is: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching time for timezone &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>


final_answer = FinalAnswerTool()
model = InferenceClientModel(
    max_tokens=<span class="hljs-number">2096</span>,
    temperature=<span class="hljs-number">0.5</span>,
    model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
    custom_role_conversions=<span class="hljs-literal">None</span>,
)


<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;agents-course/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Load system prompt from prompt.yaml file</span>
<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment"># add your tools here (don&#x27;t remove final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates <span class="hljs-comment"># Pass system prompt to CodeAgent</span>
)


GradioUI(agent).launch()`,wrap:!1}}),Jt=new xl({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/tutorial.mdx"}}),{c(){T=o("meta"),gt=n(),Ut=o("p"),ft=n(),m(j.$$.fragment),It=n(),m(J.$$.fragment),Ct=n(),d=o("p"),d.innerHTML=He,Bt=n(),U=o("p"),U.innerHTML=Ee,vt=n(),b=o("p"),b.innerHTML=ke,Zt=n(),g=o("p"),g.textContent=Ve,At=n(),m(f.$$.fragment),Gt=n(),I=o("img"),Wt=n(),C=o("p"),C.innerHTML=Se,_t=n(),B=o("p"),B.textContent=Qe,xt=n(),v=o("p"),v.innerHTML=ze,Ht=n(),Z=o("p"),Z.innerHTML=Ne,Et=n(),A=o("p"),A.textContent=Xe,kt=n(),G=o("p"),G.innerHTML=Fe,Vt=n(),W=o("p"),W.innerHTML=$e,Rt=n(),p=o("iframe"),St=n(),_=o("p"),_.textContent=Ye,Qt=n(),m(x.$$.fragment),zt=n(),H=o("p"),H.innerHTML=qe,Nt=n(),E=o("blockquote"),E.innerHTML=Pe,Xt=n(),k=o("p"),k.innerHTML=De,Ft=n(),V=o("img"),$t=n(),R=o("p"),R.textContent=Oe,Lt=n(),S=o("ol"),S.innerHTML=tl,Yt=n(),Q=o("p"),Q.innerHTML=el,qt=n(),z=o("p"),z.textContent=ll,Pt=n(),N=o("ul"),N.innerHTML=sl,Dt=n(),m(X.$$.fragment),Kt=n(),F=o("p"),F.innerHTML=nl,Ot=n(),m($.$$.fragment),te=n(),L=o("p"),L.innerHTML=al,ee=n(),m(Y.$$.fragment),le=n(),q=o("p"),q.textContent=ol,se=n(),P=o("ol"),P.innerHTML=il,ne=n(),D=o("p"),D.textContent=Ml,ae=n(),K=o("ol"),K.innerHTML=pl,oe=n(),m(O.$$.fragment),ie=n(),tt=o("p"),tt.innerHTML=rl,Me=n(),m(et.$$.fragment),pe=n(),lt=o("p"),lt.innerHTML=ml,re=n(),st=o("p"),st.innerHTML=yl,me=n(),nt=o("p"),nt.innerHTML=cl,ye=n(),at=o("p"),at.innerHTML=ul,ce=n(),m(ot.$$.fragment),ue=n(),it=o("p"),it.innerHTML=wl,we=n(),Mt=o("p"),Mt.textContent=hl,he=n(),pt=o("p"),pt.innerHTML=Tl,Te=n(),rt=o("p"),rt.textContent=jl,je=n(),m(mt.$$.fragment),Je=n(),yt=o("p"),yt.innerHTML=Jl,de=n(),ct=o("p"),ct.innerHTML=dl,Ue=n(),ut=o("p"),ut.innerHTML=Ul,be=n(),ge=o("hr"),fe=n(),wt=o("p"),wt.textContent=bl,Ie=n(),ht=o("p"),ht.textContent=gl,Ce=n(),Tt=o("p"),Tt.textContent=fl,Be=n(),jt=o("p"),jt.textContent=Il,ve=n(),m(Jt.$$.fragment),Ze=n(),bt=o("p"),this.h()},l(t){const e=Gl("svelte-u9bgzb",document.head);T=i(e,"META",{name:!0,content:!0}),e.forEach(l),gt=a(t),Ut=i(t,"P",{}),_e(Ut).forEach(l),ft=a(t),y(j.$$.fragment,t),It=a(t),y(J.$$.fragment,t),Ct=a(t),d=i(t,"P",{"data-svelte-h":!0}),M(d)!=="svelte-gmmoh4"&&(d.innerHTML=He),Bt=a(t),U=i(t,"P",{"data-svelte-h":!0}),M(U)!=="svelte-isl0ka"&&(U.innerHTML=Ee),vt=a(t),b=i(t,"P",{"data-svelte-h":!0}),M(b)!=="svelte-zy1mev"&&(b.innerHTML=ke),Zt=a(t),g=i(t,"P",{"data-svelte-h":!0}),M(g)!=="svelte-4b3xjd"&&(g.textContent=Ve),At=a(t),y(f.$$.fragment,t),Gt=a(t),I=i(t,"IMG",{src:!0,alt:!0}),Wt=a(t),C=i(t,"P",{"data-svelte-h":!0}),M(C)!=="svelte-1bet7no"&&(C.innerHTML=Se),_t=a(t),B=i(t,"P",{"data-svelte-h":!0}),M(B)!=="svelte-oceeap"&&(B.textContent=Qe),xt=a(t),v=i(t,"P",{"data-svelte-h":!0}),M(v)!=="svelte-1wfbi7x"&&(v.innerHTML=ze),Ht=a(t),Z=i(t,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1kxxgvd"&&(Z.innerHTML=Ne),Et=a(t),A=i(t,"P",{"data-svelte-h":!0}),M(A)!=="svelte-1x3dozw"&&(A.textContent=Xe),kt=a(t),G=i(t,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1kwa3nr"&&(G.innerHTML=Fe),Vt=a(t),W=i(t,"P",{"data-svelte-h":!0}),M(W)!=="svelte-4nw0u8"&&(W.innerHTML=$e),Rt=a(t),p=i(t,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0,referrerpolicy:!0}),_e(p).forEach(l),St=a(t),_=i(t,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1riubhm"&&(_.textContent=Ye),Qt=a(t),y(x.$$.fragment,t),zt=a(t),H=i(t,"P",{"data-svelte-h":!0}),M(H)!=="svelte-3pukde"&&(H.innerHTML=qe),Nt=a(t),E=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(E)!=="svelte-1lji2e8"&&(E.innerHTML=Pe),Xt=a(t),k=i(t,"P",{"data-svelte-h":!0}),M(k)!=="svelte-xpoxi8"&&(k.innerHTML=De),Ft=a(t),V=i(t,"IMG",{src:!0,alt:!0}),$t=a(t),R=i(t,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1to4f3l"&&(R.textContent=Oe),Lt=a(t),S=i(t,"OL",{"data-svelte-h":!0}),M(S)!=="svelte-1dpkmu0"&&(S.innerHTML=tl),Yt=a(t),Q=i(t,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-e4oew5"&&(Q.innerHTML=el),qt=a(t),z=i(t,"P",{"data-svelte-h":!0}),M(z)!=="svelte-xgl3rm"&&(z.textContent=ll),Pt=a(t),N=i(t,"UL",{"data-svelte-h":!0}),M(N)!=="svelte-g8ecnx"&&(N.innerHTML=sl),Dt=a(t),y(X.$$.fragment,t),Kt=a(t),F=i(t,"P",{"data-svelte-h":!0}),M(F)!=="svelte-eq9rdr"&&(F.innerHTML=nl),Ot=a(t),y($.$$.fragment,t),te=a(t),L=i(t,"P",{"data-svelte-h":!0}),M(L)!=="svelte-1qrccm5"&&(L.innerHTML=al),ee=a(t),y(Y.$$.fragment,t),le=a(t),q=i(t,"P",{"data-svelte-h":!0}),M(q)!=="svelte-qrpozm"&&(q.textContent=ol),se=a(t),P=i(t,"OL",{"data-svelte-h":!0}),M(P)!=="svelte-12muy28"&&(P.innerHTML=il),ne=a(t),D=i(t,"P",{"data-svelte-h":!0}),M(D)!=="svelte-mmcol7"&&(D.textContent=Ml),ae=a(t),K=i(t,"OL",{"data-svelte-h":!0}),M(K)!=="svelte-p349vr"&&(K.innerHTML=pl),oe=a(t),y(O.$$.fragment,t),ie=a(t),tt=i(t,"P",{"data-svelte-h":!0}),M(tt)!=="svelte-16qafzg"&&(tt.innerHTML=rl),Me=a(t),y(et.$$.fragment,t),pe=a(t),lt=i(t,"P",{"data-svelte-h":!0}),M(lt)!=="svelte-k111f3"&&(lt.innerHTML=ml),re=a(t),st=i(t,"P",{"data-svelte-h":!0}),M(st)!=="svelte-t0wd0t"&&(st.innerHTML=yl),me=a(t),nt=i(t,"P",{"data-svelte-h":!0}),M(nt)!=="svelte-1m08tlu"&&(nt.innerHTML=cl),ye=a(t),at=i(t,"P",{"data-svelte-h":!0}),M(at)!=="svelte-13ckn13"&&(at.innerHTML=ul),ce=a(t),y(ot.$$.fragment,t),ue=a(t),it=i(t,"P",{"data-svelte-h":!0}),M(it)!=="svelte-1wl8y4j"&&(it.innerHTML=wl),we=a(t),Mt=i(t,"P",{"data-svelte-h":!0}),M(Mt)!=="svelte-dchyno"&&(Mt.textContent=hl),he=a(t),pt=i(t,"P",{"data-svelte-h":!0}),M(pt)!=="svelte-1sn4nls"&&(pt.innerHTML=Tl),Te=a(t),rt=i(t,"P",{"data-svelte-h":!0}),M(rt)!=="svelte-11duvvf"&&(rt.textContent=jl),je=a(t),y(mt.$$.fragment,t),Je=a(t),yt=i(t,"P",{"data-svelte-h":!0}),M(yt)!=="svelte-1djj761"&&(yt.innerHTML=Jl),de=a(t),ct=i(t,"P",{"data-svelte-h":!0}),M(ct)!=="svelte-1xqfrp"&&(ct.innerHTML=dl),Ue=a(t),ut=i(t,"P",{"data-svelte-h":!0}),M(ut)!=="svelte-h3h5uq"&&(ut.innerHTML=Ul),be=a(t),ge=i(t,"HR",{}),fe=a(t),wt=i(t,"P",{"data-svelte-h":!0}),M(wt)!=="svelte-1vcdjz4"&&(wt.textContent=bl),Ie=a(t),ht=i(t,"P",{"data-svelte-h":!0}),M(ht)!=="svelte-10mjkny"&&(ht.textContent=gl),Ce=a(t),Tt=i(t,"P",{"data-svelte-h":!0}),M(Tt)!=="svelte-10xgfu5"&&(Tt.textContent=fl),Be=a(t),jt=i(t,"P",{"data-svelte-h":!0}),M(jt)!=="svelte-1s9m3df"&&(jt.textContent=Il),ve=a(t),y(Jt.$$.fragment,t),Ze=a(t),bt=i(t,"P",{}),_e(bt).forEach(l),this.h()},h(){r(T,"name","hf:doc:metadata"),r(T,"content",El),We(I.src,Re="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/smolagents.png")||r(I,"src",Re),r(I,"alt","smolagents"),r(p,"width","560"),r(p,"height","315"),We(p.src,Le="https://www.youtube.com/embed/PQDKcWiuln4?si=ysSTDZoi8y55FVvA")||r(p,"src",Le),r(p,"title","YouTube video player"),r(p,"frameborder","0"),r(p,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"),r(p,"referrerpolicy","strict-origin-when-cross-origin"),p.allowFullscreen="",We(V.src,Ke="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/duplicate-space.gif")||r(V,"src",Ke),r(V,"alt","Duplicate")},m(t,e){Wl(document.head,T),s(t,gt,e),s(t,Ut,e),s(t,ft,e),c(j,t,e),s(t,It,e),c(J,t,e),s(t,Ct,e),s(t,d,e),s(t,Bt,e),s(t,U,e),s(t,vt,e),s(t,b,e),s(t,Zt,e),s(t,g,e),s(t,At,e),c(f,t,e),s(t,Gt,e),s(t,I,e),s(t,Wt,e),s(t,C,e),s(t,_t,e),s(t,B,e),s(t,xt,e),s(t,v,e),s(t,Ht,e),s(t,Z,e),s(t,Et,e),s(t,A,e),s(t,kt,e),s(t,G,e),s(t,Vt,e),s(t,W,e),s(t,Rt,e),s(t,p,e),s(t,St,e),s(t,_,e),s(t,Qt,e),c(x,t,e),s(t,zt,e),s(t,H,e),s(t,Nt,e),s(t,E,e),s(t,Xt,e),s(t,k,e),s(t,Ft,e),s(t,V,e),s(t,$t,e),s(t,R,e),s(t,Lt,e),s(t,S,e),s(t,Yt,e),s(t,Q,e),s(t,qt,e),s(t,z,e),s(t,Pt,e),s(t,N,e),s(t,Dt,e),c(X,t,e),s(t,Kt,e),s(t,F,e),s(t,Ot,e),c($,t,e),s(t,te,e),s(t,L,e),s(t,ee,e),c(Y,t,e),s(t,le,e),s(t,q,e),s(t,se,e),s(t,P,e),s(t,ne,e),s(t,D,e),s(t,ae,e),s(t,K,e),s(t,oe,e),c(O,t,e),s(t,ie,e),s(t,tt,e),s(t,Me,e),c(et,t,e),s(t,pe,e),s(t,lt,e),s(t,re,e),s(t,st,e),s(t,me,e),s(t,nt,e),s(t,ye,e),s(t,at,e),s(t,ce,e),c(ot,t,e),s(t,ue,e),s(t,it,e),s(t,we,e),s(t,Mt,e),s(t,he,e),s(t,pt,e),s(t,Te,e),s(t,rt,e),s(t,je,e),c(mt,t,e),s(t,Je,e),s(t,yt,e),s(t,de,e),s(t,ct,e),s(t,Ue,e),s(t,ut,e),s(t,be,e),s(t,ge,e),s(t,fe,e),s(t,wt,e),s(t,Ie,e),s(t,ht,e),s(t,Ce,e),s(t,Tt,e),s(t,Be,e),s(t,jt,e),s(t,ve,e),c(Jt,t,e),s(t,Ze,e),s(t,bt,e),Ae=!0},p:Bl,i(t){Ae||(u(j.$$.fragment,t),u(J.$$.fragment,t),u(f.$$.fragment,t),u(x.$$.fragment,t),u(X.$$.fragment,t),u($.$$.fragment,t),u(Y.$$.fragment,t),u(O.$$.fragment,t),u(et.$$.fragment,t),u(ot.$$.fragment,t),u(mt.$$.fragment,t),u(Jt.$$.fragment,t),Ae=!0)},o(t){w(j.$$.fragment,t),w(J.$$.fragment,t),w(f.$$.fragment,t),w(x.$$.fragment,t),w(X.$$.fragment,t),w($.$$.fragment,t),w(Y.$$.fragment,t),w(O.$$.fragment,t),w(et.$$.fragment,t),w(ot.$$.fragment,t),w(mt.$$.fragment,t),w(Jt.$$.fragment,t),Ae=!1},d(t){t&&(l(gt),l(Ut),l(ft),l(It),l(Ct),l(d),l(Bt),l(U),l(vt),l(b),l(Zt),l(g),l(At),l(Gt),l(I),l(Wt),l(C),l(_t),l(B),l(xt),l(v),l(Ht),l(Z),l(Et),l(A),l(kt),l(G),l(Vt),l(W),l(Rt),l(p),l(St),l(_),l(Qt),l(zt),l(H),l(Nt),l(E),l(Xt),l(k),l(Ft),l(V),l($t),l(R),l(Lt),l(S),l(Yt),l(Q),l(qt),l(z),l(Pt),l(N),l(Dt),l(Kt),l(F),l(Ot),l(te),l(L),l(ee),l(le),l(q),l(se),l(P),l(ne),l(D),l(ae),l(K),l(oe),l(ie),l(tt),l(Me),l(pe),l(lt),l(re),l(st),l(me),l(nt),l(ye),l(at),l(ce),l(ue),l(it),l(we),l(Mt),l(he),l(pt),l(Te),l(rt),l(je),l(Je),l(yt),l(de),l(ct),l(Ue),l(ut),l(be),l(ge),l(fe),l(wt),l(Ie),l(ht),l(Ce),l(Tt),l(Be),l(jt),l(ve),l(Ze),l(bt)),l(T),h(j,t),h(J,t),h(f,t),h(x,t),h(X,t),h($,t),h(Y,t),h(O,t),h(et,t),h(ot,t),h(mt,t),h(Jt,t)}}}const El='{"title":"Let’s Create Our First Agent Using smolagents","local":"lets-create-our-first-agent-using-smolagents","sections":[{"title":"What is smolagents?","local":"what-is-smolagents","sections":[],"depth":2},{"title":"Let’s build our Agent!","local":"lets-build-our-agent","sections":[{"title":"The Tools","local":"the-tools","sections":[],"depth":3},{"title":"The Agent","local":"the-agent","sections":[],"depth":3},{"title":"The System Prompt","local":"the-system-prompt","sections":[],"depth":3}],"depth":2}],"depth":1}';function kl(xe){return vl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xl extends Zl{constructor(T){super(),Al(this,T,kl,Hl,Cl,{})}}export{Xl as component};
