import{s as Ds,n as Os,o as te}from"../chunks/scheduler.505acc25.js";import{S as se,i as ee,e as o,s as n,c as w,q as Ps,h as le,a as p,d as e,b as a,f as hs,g as c,j as i,r as Ks,k as ht,l as jt,m as l,n as r,t as M,o as u,p as m}from"../chunks/index.fbb49fb4.js";import{C as ne}from"../chunks/CopyLLMTxtMenu.564b44fd.js";import{C as J}from"../chunks/CodeBlock.7f0851b7.js";import{H as T}from"../chunks/Heading.511e0027.js";import{E as ae}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8c19e80e.js";function oe(js){let y,Jt,dt,Tt,f,ft,U,Ut,b,Js="A workflow in LlamaIndex provides a structured way to organize your code into sequential and manageable steps.",bt,C,Ts=`Such a workflow is created by defining <code>Steps</code> which are triggered by <code>Events</code>, and themselves emit <code>Events</code> to trigger further steps.
Let’s take a look at Alfred showing a LlamaIndex workflow for a RAG task.`,Ct,I,fs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/workflows.png" alt="Workflow Schematic"/>',It,g,Us="<strong>Workflows offer several key benefits:</strong>",gt,k,bs="<li>Clear organization of code into discrete steps</li> <li>Event-driven architecture for flexible control flow</li> <li>Type-safe communication between steps</li> <li>Built-in state management</li> <li>Support for both simple and complex agent interactions</li>",kt,B,Cs="As you might have guessed, <strong>workflows strike a great balance between the autonomy of agents while maintaining control over the overall workflow.</strong>",Bt,v,Is="So, let’s learn how to create a workflow ourselves!",vt,Z,Zt,h,gs='<p>You can follow the code in <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/llama-index/workflows.ipynb" target="_blank">this notebook</a> that you can run using Google Colab.</p>',Gt,G,_t,d,ut,ks="Install the Workflow package",ds,_,Bs="section on the LlamaHub",ys,x,xt,E,vs=`We can create a single-step workflow by defining a class that inherits from <code>Workflow</code> and decorating your functions with <code>@step</code>.
We will also need to add <code>StartEvent</code> and <code>StopEvent</code>, which are special events that are used to indicate the start and end of the workflow.`,Et,W,Wt,V,Zs="As you can see, we can now run the workflow by calling <code>w.run()</code>.",Vt,$,$t,Q,Gs=`To connect multiple steps, we <strong>create custom events that carry data between steps.</strong>
To do so, we need to add an <code>Event</code> that is passed between the steps and transfers the output of the first step to the second step.`,Qt,S,St,H,_s="The type hinting is important here, as it ensures that the workflow is executed correctly. Let’s complicate things a bit more!",Ht,A,At,q,xs="The type hinting is the most powerful part of workflows because it allows us to create branches, loops, and joins to facilitate more complex workflows.",qt,F,Es=`Let’s show an example of <strong>creating a loop</strong> by using the union operator <code>|</code>.
In the example below, we see that the <code>LoopEvent</code> is taken as input for the step and can also be returned as output.`,Ft,X,Xt,R,Rt,N,Ws="We can also draw workflows. Let’s use the <code>draw_all_possible_flows</code> function to draw the workflow. This stores the workflow in an HTML file.",Nt,z,zt,L,Vs='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/workflow-draw.png" alt="workflow drawing"/>',Lt,Y,$s="There is one last cool trick that we will cover in the course, which is the ability to add state to the workflow.",Yt,P,Pt,K,Qs=`State management is useful when you want to keep track of the state of the workflow, so that every step has access to the same state.
We can do this by using the <code>Context</code> type hint on top of a parameter in the step function.`,Kt,D,Dt,O,Ss="Great! Now you know how to create basic workflows in LlamaIndex!",Ot,j,Hs='<p>There are some more complex nuances to workflows, which you can learn about in <a href="https://docs.llamaindex.ai/en/stable/understanding/workflows/">the LlamaIndex documentation</a>.</p>',ts,tt,As="However, there is another way to create workflows, which relies on the <code>AgentWorkflow</code> class. Let’s take a look at how we can use this to create a multi-agent workflow.",ss,st,es,et,qs=`Instead of manual workflow creation, we can use the <strong><code>AgentWorkflow</code> class to create a multi-agent workflow</strong>.
The <code>AgentWorkflow</code> uses Workflow Agents to allow you to create a system of one or more agents that can collaborate and hand off tasks to each other based on their specialized capabilities.
This enables building complex agent systems where different agents handle different aspects of a task.
Instead of importing classes from <code>llama_index.core.agent</code>, we will import the agent classes from <code>llama_index.core.agent.workflow</code>.
One agent must be designated as the root agent in the <code>AgentWorkflow</code> constructor.
When a user message comes in, it is first routed to the root agent.`,ls,lt,Fs="Each agent can then:",ns,nt,Xs="<li>Handle the request directly using their tools</li> <li>Handoff to another agent better suited for the task</li> <li>Return a response to the user</li>",as,at,Rs="Let’s see how to create a multi-agent workflow.",os,ot,ps,pt,Ns=`Agent tools can also modify the workflow state we mentioned earlier. Before starting the workflow, we can provide an initial state dict that will be available to all agents.
The state is stored in the state key of the workflow context. It will be injected into the state_prompt which augments each new user message.`,is,it,zs="Let’s inject a counter to count function calls by modifying the previous example:",ws,wt,cs,ct,Ls="Congratulations! You have now mastered the basics of Agents in LlamaIndex! 🎉",rs,rt,Ys="Let’s continue with one final quiz to solidify your knowledge! 🚀",Ms,Mt,us,yt,ms;return f=new ne({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new T({props:{title:"Creating agentic workflows in LlamaIndex",local:"creating-agentic-workflows-in-llamaindex",headingTag:"h1"}}),Z=new T({props:{title:"Creating Workflows",local:"creating-workflows",headingTag:"h2"}}),G=new T({props:{title:"Basic Workflow Creation",local:"basic-workflow-creation",headingTag:"h3"}}),x=new J({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxsYW1hLWluZGV4LXV0aWxzLXdvcmtmbG93",highlighted:"pip install llama-index-utils-workflow",wrap:!1}}),W=new J({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBTdGFydEV2ZW50JTJDJTIwU3RvcEV2ZW50JTJDJTIwV29ya2Zsb3clMkMlMjBzdGVwJTBBJTBBY2xhc3MlMjBNeVdvcmtmbG93KFdvcmtmbG93KSUzQSUwQSUyMCUyMCUyMCUyMCU0MHN0ZXAlMEElMjAlMjAlMjAlMjBhc3luYyUyMGRlZiUyMG15X3N0ZXAoc2VsZiUyQyUyMGV2JTNBJTIwU3RhcnRFdmVudCklMjAtJTNFJTIwU3RvcEV2ZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZG8lMjBzb21ldGhpbmclMjBoZXJlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRCUyMkhlbGxvJTJDJTIwd29ybGQhJTIyKSUwQSUwQSUwQXclMjAlM0QlMjBNeVdvcmtmbG93KHRpbWVvdXQlM0QxMCUyQyUyMHZlcmJvc2UlM0RGYWxzZSklMEFyZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHcucnVuKCk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> StartEvent, StopEvent, Workflow, step

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">my_step</span>(<span class="hljs-params">self, ev: StartEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># do something here</span>
        <span class="hljs-keyword">return</span> StopEvent(result=<span class="hljs-string">&quot;Hello, world!&quot;</span>)


w = MyWorkflow(timeout=<span class="hljs-number">10</span>, verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()`,wrap:!1}}),$=new T({props:{title:"Connecting Multiple Steps",local:"connecting-multiple-steps",headingTag:"h3"}}),S=new J({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBFdmVudCUwQSUwQWNsYXNzJTIwUHJvY2Vzc2luZ0V2ZW50KEV2ZW50KSUzQSUwQSUyMCUyMCUyMCUyMGludGVybWVkaWF0ZV9yZXN1bHQlM0ElMjBzdHIlMEElMEFjbGFzcyUyME11bHRpU3RlcFdvcmtmbG93KFdvcmtmbG93KSUzQSUwQSUyMCUyMCUyMCUyMCU0MHN0ZXAlMEElMjAlMjAlMjAlMjBhc3luYyUyMGRlZiUyMHN0ZXBfb25lKHNlbGYlMkMlMjBldiUzQSUyMFN0YXJ0RXZlbnQpJTIwLSUzRSUyMFByb2Nlc3NpbmdFdmVudCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFByb2Nlc3MlMjBpbml0aWFsJTIwZGF0YSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMFByb2Nlc3NpbmdFdmVudChpbnRlcm1lZGlhdGVfcmVzdWx0JTNEJTIyU3RlcCUyMDElMjBjb21wbGV0ZSUyMiklMEElMEElMjAlMjAlMjAlMjAlNDBzdGVwJTBBJTIwJTIwJTIwJTIwYXN5bmMlMjBkZWYlMjBzdGVwX3R3byhzZWxmJTJDJTIwZXYlM0ElMjBQcm9jZXNzaW5nRXZlbnQpJTIwLSUzRSUyMFN0b3BFdmVudCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFVzZSUyMHRoZSUyMGludGVybWVkaWF0ZSUyMHJlc3VsdCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZpbmFsX3Jlc3VsdCUyMCUzRCUyMGYlMjJGaW5pc2hlZCUyMHByb2Nlc3NpbmclM0ElMjAlN0Jldi5pbnRlcm1lZGlhdGVfcmVzdWx0JTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwU3RvcEV2ZW50KHJlc3VsdCUzRGZpbmFsX3Jlc3VsdCklMEElMEF3JTIwJTNEJTIwTXVsdGlTdGVwV29ya2Zsb3codGltZW91dCUzRDEwJTJDJTIwdmVyYm9zZSUzREZhbHNlKSUwQXJlc3VsdCUyMCUzRCUyMGF3YWl0JTIwdy5ydW4oKSUwQXJlc3VsdA==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Event

<span class="hljs-keyword">class</span> <span class="hljs-title class_">ProcessingEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    intermediate_result: <span class="hljs-built_in">str</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MultiStepWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_one</span>(<span class="hljs-params">self, ev: StartEvent</span>) -&gt; ProcessingEvent:
        <span class="hljs-comment"># Process initial data</span>
        <span class="hljs-keyword">return</span> ProcessingEvent(intermediate_result=<span class="hljs-string">&quot;Step 1 complete&quot;</span>)

<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_two</span>(<span class="hljs-params">self, ev: ProcessingEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># Use the intermediate result</span>
        final_result = <span class="hljs-string">f&quot;Finished processing: <span class="hljs-subst">{ev.intermediate_result}</span>&quot;</span>
        <span class="hljs-keyword">return</span> StopEvent(result=final_result)

w = MultiStepWorkflow(timeout=<span class="hljs-number">10</span>, verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()
result`,wrap:!1}}),A=new T({props:{title:"Loops and Branches",local:"loops-and-branches",headingTag:"h3"}}),X=new J({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBFdmVudCUwQWltcG9ydCUyMHJhbmRvbSUwQSUwQSUwQWNsYXNzJTIwUHJvY2Vzc2luZ0V2ZW50KEV2ZW50KSUzQSUwQSUyMCUyMCUyMCUyMGludGVybWVkaWF0ZV9yZXN1bHQlM0ElMjBzdHIlMEElMEElMEFjbGFzcyUyMExvb3BFdmVudChFdmVudCklM0ElMEElMjAlMjAlMjAlMjBsb29wX291dHB1dCUzQSUyMHN0ciUwQSUwQSUwQWNsYXNzJTIwTXVsdGlTdGVwV29ya2Zsb3coV29ya2Zsb3cpJTNBJTBBJTIwJTIwJTIwJTIwJTQwc3RlcCUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc3RlcF9vbmUoc2VsZiUyQyUyMGV2JTNBJTIwU3RhcnRFdmVudCUyMCU3QyUyMExvb3BFdmVudCklMjAtJTNFJTIwUHJvY2Vzc2luZ0V2ZW50JTIwJTdDJTIwTG9vcEV2ZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjByYW5kb20ucmFuZGludCgwJTJDJTIwMSklMjAlM0QlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyQmFkJTIwdGhpbmclMjBoYXBwZW5lZCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBMb29wRXZlbnQobG9vcF9vdXRwdXQlM0QlMjJCYWNrJTIwdG8lMjBzdGVwJTIwb25lLiUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyR29vZCUyMHRoaW5nJTIwaGFwcGVuZWQlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwUHJvY2Vzc2luZ0V2ZW50KGludGVybWVkaWF0ZV9yZXN1bHQlM0QlMjJGaXJzdCUyMHN0ZXAlMjBjb21wbGV0ZS4lMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTQwc3RlcCUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZGVmJTIwc3RlcF90d28oc2VsZiUyQyUyMGV2JTNBJTIwUHJvY2Vzc2luZ0V2ZW50KSUyMC0lM0UlMjBTdG9wRXZlbnQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBVc2UlMjB0aGUlMjBpbnRlcm1lZGlhdGUlMjByZXN1bHQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmaW5hbF9yZXN1bHQlMjAlM0QlMjBmJTIyRmluaXNoZWQlMjBwcm9jZXNzaW5nJTNBJTIwJTdCZXYuaW50ZXJtZWRpYXRlX3Jlc3VsdCU3RCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMFN0b3BFdmVudChyZXN1bHQlM0RmaW5hbF9yZXN1bHQpJTBBJTBBJTBBdyUyMCUzRCUyME11bHRpU3RlcFdvcmtmbG93KHZlcmJvc2UlM0RGYWxzZSklMEFyZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHcucnVuKCklMEFyZXN1bHQ=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Event
<span class="hljs-keyword">import</span> random


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ProcessingEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    intermediate_result: <span class="hljs-built_in">str</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">LoopEvent</span>(<span class="hljs-title class_ inherited__">Event</span>):
    loop_output: <span class="hljs-built_in">str</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MultiStepWorkflow</span>(<span class="hljs-title class_ inherited__">Workflow</span>):
<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_one</span>(<span class="hljs-params">self, ev: StartEvent | LoopEvent</span>) -&gt; ProcessingEvent | LoopEvent:
        <span class="hljs-keyword">if</span> random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>) == <span class="hljs-number">0</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Bad thing happened&quot;</span>)
            <span class="hljs-keyword">return</span> LoopEvent(loop_output=<span class="hljs-string">&quot;Back to step one.&quot;</span>)
        <span class="hljs-keyword">else</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Good thing happened&quot;</span>)
            <span class="hljs-keyword">return</span> ProcessingEvent(intermediate_result=<span class="hljs-string">&quot;First step complete.&quot;</span>)

<span class="hljs-meta">    @step</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">step_two</span>(<span class="hljs-params">self, ev: ProcessingEvent</span>) -&gt; StopEvent:
        <span class="hljs-comment"># Use the intermediate result</span>
        final_result = <span class="hljs-string">f&quot;Finished processing: <span class="hljs-subst">{ev.intermediate_result}</span>&quot;</span>
        <span class="hljs-keyword">return</span> StopEvent(result=final_result)


w = MultiStepWorkflow(verbose=<span class="hljs-literal">False</span>)
result = <span class="hljs-keyword">await</span> w.run()
result`,wrap:!1}}),R=new T({props:{title:"Drawing Workflows",local:"drawing-workflows",headingTag:"h3"}}),z=new J({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LnV0aWxzLndvcmtmbG93JTIwaW1wb3J0JTIwZHJhd19hbGxfcG9zc2libGVfZmxvd3MlMEElMEF3JTIwJTNEJTIwLi4uJTIwJTIzJTIwYXMlMjBkZWZpbmVkJTIwaW4lMjB0aGUlMjBwcmV2aW91cyUyMHNlY3Rpb24lMEFkcmF3X2FsbF9wb3NzaWJsZV9mbG93cyh3JTJDJTIwJTIyZmxvdy5odG1sJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.utils.workflow <span class="hljs-keyword">import</span> draw_all_possible_flows

w = ... <span class="hljs-comment"># as defined in the previous section</span>
draw_all_possible_flows(w, <span class="hljs-string">&quot;flow.html&quot;</span>)`,wrap:!1}}),P=new T({props:{title:"State Management",local:"state-management",headingTag:"h3"}}),D=new J({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUud29ya2Zsb3clMjBpbXBvcnQlMjBDb250ZXh0JTJDJTIwU3RhcnRFdmVudCUyQyUyMFN0b3BFdmVudCUwQSUwQSUwQSU0MHN0ZXAlMEFhc3luYyUyMGRlZiUyMHF1ZXJ5KHNlbGYlMkMlMjBjdHglM0ElMjBDb250ZXh0JTJDJTIwZXYlM0ElMjBTdGFydEV2ZW50KSUyMC0lM0UlMjBTdG9wRXZlbnQlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBzdG9yZSUyMHF1ZXJ5JTIwaW4lMjB0aGUlMjBjb250ZXh0JTBBJTIwJTIwJTIwJTIwYXdhaXQlMjBjdHguc3RvcmUuc2V0KCUyMnF1ZXJ5JTIyJTJDJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGRvJTIwc29tZXRoaW5nJTIwd2l0aCUyMGNvbnRleHQlMjBhbmQlMjBldmVudCUwQSUyMCUyMCUyMCUyMHZhbCUyMCUzRCUyMC4uLiUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMHJldHJpZXZlJTIwcXVlcnklMjBmcm9tJTIwdGhlJTIwY29udGV4dCUwQSUyMCUyMCUyMCUyMHF1ZXJ5JTIwJTNEJTIwYXdhaXQlMjBjdHguc3RvcmUuZ2V0KCUyMnF1ZXJ5JTIyKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMFN0b3BFdmVudChyZXN1bHQlM0R2YWwp",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Context, StartEvent, StopEvent


<span class="hljs-meta">@step</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">query</span>(<span class="hljs-params">self, ctx: Context, ev: StartEvent</span>) -&gt; StopEvent:
    <span class="hljs-comment"># store query in the context</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;What is the capital of France?&quot;</span>)

    <span class="hljs-comment"># do something with context and event</span>
    val = ...

    <span class="hljs-comment"># retrieve query from the context</span>
    query = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;query&quot;</span>)

    <span class="hljs-keyword">return</span> StopEvent(result=val)`,wrap:!1}}),st=new T({props:{title:"Automating workflows with Multi-Agent Workflows",local:"automating-workflows-with-multi-agent-workflows",headingTag:"h2"}}),ot=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.agent.workflow <span class="hljs-keyword">import</span> AgentWorkflow, ReActAgent
<span class="hljs-keyword">from</span> llama_index.llms.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI

<span class="hljs-comment"># Define some tools</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Add two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a + b

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

<span class="hljs-comment"># we can pass functions directly without FunctionTool -- the fn/docstring are parsed for the name/description</span>
multiply_agent = ReActAgent(
    name=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Is able to multiply two integers&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;A helpful assistant that can use a tool to multiply numbers.&quot;</span>,
    tools=[multiply],
    llm=llm,
)

addition_agent = ReActAgent(
    name=<span class="hljs-string">&quot;add_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Is able to add two integers&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;A helpful assistant that can use a tool to add numbers.&quot;</span>,
    tools=[add],
    llm=llm,
)

<span class="hljs-comment"># Create the workflow</span>
workflow = AgentWorkflow(
    agents=[multiply_agent, addition_agent],
    root_agent=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
)

<span class="hljs-comment"># Run the system</span>
response = <span class="hljs-keyword">await</span> workflow.run(user_msg=<span class="hljs-string">&quot;Can you add 5 and 3?&quot;</span>)`,wrap:!1}}),wt=new J({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Context

<span class="hljs-comment"># Define some tools</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">ctx: Context, a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Add two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># update our count</span>
    cur_state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
    cur_state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>] += <span class="hljs-number">1</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;state&quot;</span>, cur_state)

    <span class="hljs-keyword">return</span> a + b

<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">ctx: Context, a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-comment"># update our count</span>
    cur_state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
    cur_state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>] += <span class="hljs-number">1</span>
    <span class="hljs-keyword">await</span> ctx.store.<span class="hljs-built_in">set</span>(<span class="hljs-string">&quot;state&quot;</span>, cur_state)

    <span class="hljs-keyword">return</span> a * b

...

workflow = AgentWorkflow(
    agents=[multiply_agent, addition_agent],
    root_agent=<span class="hljs-string">&quot;multiply_agent&quot;</span>,
    initial_state={<span class="hljs-string">&quot;num_fn_calls&quot;</span>: <span class="hljs-number">0</span>},
    state_prompt=<span class="hljs-string">&quot;Current state: {state}. User message: {msg}&quot;</span>,
)

<span class="hljs-comment"># run the workflow with context</span>
ctx = Context(workflow)
response = <span class="hljs-keyword">await</span> workflow.run(user_msg=<span class="hljs-string">&quot;Can you add 5 and 3?&quot;</span>, ctx=ctx)

<span class="hljs-comment"># pull out and inspect the state</span>
state = <span class="hljs-keyword">await</span> ctx.store.get(<span class="hljs-string">&quot;state&quot;</span>)
<span class="hljs-built_in">print</span>(state[<span class="hljs-string">&quot;num_fn_calls&quot;</span>])`,wrap:!1}}),Mt=new ae({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/llama-index/workflows.mdx"}}),{c(){y=o("meta"),Jt=n(),dt=o("p"),Tt=n(),w(f.$$.fragment),ft=n(),w(U.$$.fragment),Ut=n(),b=o("p"),b.textContent=Js,bt=n(),C=o("p"),C.innerHTML=Ts,Ct=n(),I=o("p"),I.innerHTML=fs,It=n(),g=o("p"),g.innerHTML=Us,gt=n(),k=o("ul"),k.innerHTML=bs,kt=n(),B=o("p"),B.innerHTML=Cs,Bt=n(),v=o("p"),v.textContent=Is,vt=n(),w(Z.$$.fragment),Zt=n(),h=o("blockquote"),h.innerHTML=gs,Gt=n(),w(G.$$.fragment),_t=n(),d=o("details"),ut=o("summary"),ut.textContent=ks,ds=Ps(`
As introduced in the `),_=o("a"),_.textContent=Bs,ys=Ps(`, we can install the Workflow package with the following command:

	`),w(x.$$.fragment),xt=n(),E=o("p"),E.innerHTML=vs,Et=n(),w(W.$$.fragment),Wt=n(),V=o("p"),V.innerHTML=Zs,Vt=n(),w($.$$.fragment),$t=n(),Q=o("p"),Q.innerHTML=Gs,Qt=n(),w(S.$$.fragment),St=n(),H=o("p"),H.textContent=_s,Ht=n(),w(A.$$.fragment),At=n(),q=o("p"),q.textContent=xs,qt=n(),F=o("p"),F.innerHTML=Es,Ft=n(),w(X.$$.fragment),Xt=n(),w(R.$$.fragment),Rt=n(),N=o("p"),N.innerHTML=Ws,Nt=n(),w(z.$$.fragment),zt=n(),L=o("p"),L.innerHTML=Vs,Lt=n(),Y=o("p"),Y.textContent=$s,Yt=n(),w(P.$$.fragment),Pt=n(),K=o("p"),K.innerHTML=Qs,Kt=n(),w(D.$$.fragment),Dt=n(),O=o("p"),O.textContent=Ss,Ot=n(),j=o("blockquote"),j.innerHTML=Hs,ts=n(),tt=o("p"),tt.innerHTML=As,ss=n(),w(st.$$.fragment),es=n(),et=o("p"),et.innerHTML=qs,ls=n(),lt=o("p"),lt.textContent=Fs,ns=n(),nt=o("ul"),nt.innerHTML=Xs,as=n(),at=o("p"),at.textContent=Rs,os=n(),w(ot.$$.fragment),ps=n(),pt=o("p"),pt.textContent=Ns,is=n(),it=o("p"),it.textContent=zs,ws=n(),w(wt.$$.fragment),cs=n(),ct=o("p"),ct.textContent=Ls,rs=n(),rt=o("p"),rt.textContent=Ys,Ms=n(),w(Mt.$$.fragment),us=n(),yt=o("p"),this.h()},l(t){const s=le("svelte-u9bgzb",document.head);y=p(s,"META",{name:!0,content:!0}),s.forEach(e),Jt=a(t),dt=p(t,"P",{}),hs(dt).forEach(e),Tt=a(t),c(f.$$.fragment,t),ft=a(t),c(U.$$.fragment,t),Ut=a(t),b=p(t,"P",{"data-svelte-h":!0}),i(b)!=="svelte-1kssncf"&&(b.textContent=Js),bt=a(t),C=p(t,"P",{"data-svelte-h":!0}),i(C)!=="svelte-1ogtysv"&&(C.innerHTML=Ts),Ct=a(t),I=p(t,"P",{"data-svelte-h":!0}),i(I)!=="svelte-whmuha"&&(I.innerHTML=fs),It=a(t),g=p(t,"P",{"data-svelte-h":!0}),i(g)!=="svelte-1ff8id8"&&(g.innerHTML=Us),gt=a(t),k=p(t,"UL",{"data-svelte-h":!0}),i(k)!=="svelte-14kaj17"&&(k.innerHTML=bs),kt=a(t),B=p(t,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1cddxrt"&&(B.innerHTML=Cs),Bt=a(t),v=p(t,"P",{"data-svelte-h":!0}),i(v)!=="svelte-i0dazf"&&(v.textContent=Is),vt=a(t),c(Z.$$.fragment,t),Zt=a(t),h=p(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(h)!=="svelte-y2ec6g"&&(h.innerHTML=gs),Gt=a(t),c(G.$$.fragment,t),_t=a(t),d=p(t,"DETAILS",{});var mt=hs(d);ut=p(mt,"SUMMARY",{"data-svelte-h":!0}),i(ut)!=="svelte-1vs5sev"&&(ut.textContent=ks),ds=Ks(mt,`
As introduced in the `),_=p(mt,"A",{href:!0,"data-svelte-h":!0}),i(_)!=="svelte-16phayx"&&(_.textContent=Bs),ys=Ks(mt,`, we can install the Workflow package with the following command:

	`),c(x.$$.fragment,mt),mt.forEach(e),xt=a(t),E=p(t,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1wc9dhn"&&(E.innerHTML=vs),Et=a(t),c(W.$$.fragment,t),Wt=a(t),V=p(t,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1x5qg2q"&&(V.innerHTML=Zs),Vt=a(t),c($.$$.fragment,t),$t=a(t),Q=p(t,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1gl1q10"&&(Q.innerHTML=Gs),Qt=a(t),c(S.$$.fragment,t),St=a(t),H=p(t,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1ssz2vu"&&(H.textContent=_s),Ht=a(t),c(A.$$.fragment,t),At=a(t),q=p(t,"P",{"data-svelte-h":!0}),i(q)!=="svelte-7kgjbz"&&(q.textContent=xs),qt=a(t),F=p(t,"P",{"data-svelte-h":!0}),i(F)!=="svelte-19z56vc"&&(F.innerHTML=Es),Ft=a(t),c(X.$$.fragment,t),Xt=a(t),c(R.$$.fragment,t),Rt=a(t),N=p(t,"P",{"data-svelte-h":!0}),i(N)!=="svelte-gq4idr"&&(N.innerHTML=Ws),Nt=a(t),c(z.$$.fragment,t),zt=a(t),L=p(t,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1j5vf43"&&(L.innerHTML=Vs),Lt=a(t),Y=p(t,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-1nn9pf"&&(Y.textContent=$s),Yt=a(t),c(P.$$.fragment,t),Pt=a(t),K=p(t,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1a42m1e"&&(K.innerHTML=Qs),Kt=a(t),c(D.$$.fragment,t),Dt=a(t),O=p(t,"P",{"data-svelte-h":!0}),i(O)!=="svelte-ayh2hg"&&(O.textContent=Ss),Ot=a(t),j=p(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(j)!=="svelte-q0pq5d"&&(j.innerHTML=Hs),ts=a(t),tt=p(t,"P",{"data-svelte-h":!0}),i(tt)!=="svelte-1f8yr21"&&(tt.innerHTML=As),ss=a(t),c(st.$$.fragment,t),es=a(t),et=p(t,"P",{"data-svelte-h":!0}),i(et)!=="svelte-64dk7s"&&(et.innerHTML=qs),ls=a(t),lt=p(t,"P",{"data-svelte-h":!0}),i(lt)!=="svelte-1b9i7pj"&&(lt.textContent=Fs),ns=a(t),nt=p(t,"UL",{"data-svelte-h":!0}),i(nt)!=="svelte-bg3pcb"&&(nt.innerHTML=Xs),as=a(t),at=p(t,"P",{"data-svelte-h":!0}),i(at)!=="svelte-193z3j0"&&(at.textContent=Rs),os=a(t),c(ot.$$.fragment,t),ps=a(t),pt=p(t,"P",{"data-svelte-h":!0}),i(pt)!=="svelte-y63ydc"&&(pt.textContent=Ns),is=a(t),it=p(t,"P",{"data-svelte-h":!0}),i(it)!=="svelte-k4pfxh"&&(it.textContent=zs),ws=a(t),c(wt.$$.fragment,t),cs=a(t),ct=p(t,"P",{"data-svelte-h":!0}),i(ct)!=="svelte-1rveoqn"&&(ct.textContent=Ls),rs=a(t),rt=p(t,"P",{"data-svelte-h":!0}),i(rt)!=="svelte-u1alm2"&&(rt.textContent=Ys),Ms=a(t),c(Mt.$$.fragment,t),us=a(t),yt=p(t,"P",{}),hs(yt).forEach(e),this.h()},h(){ht(y,"name","hf:doc:metadata"),ht(y,"content",pe),ht(h,"class","tip"),ht(_,"href","./llama-hub"),ht(j,"class","tip")},m(t,s){jt(document.head,y),l(t,Jt,s),l(t,dt,s),l(t,Tt,s),r(f,t,s),l(t,ft,s),r(U,t,s),l(t,Ut,s),l(t,b,s),l(t,bt,s),l(t,C,s),l(t,Ct,s),l(t,I,s),l(t,It,s),l(t,g,s),l(t,gt,s),l(t,k,s),l(t,kt,s),l(t,B,s),l(t,Bt,s),l(t,v,s),l(t,vt,s),r(Z,t,s),l(t,Zt,s),l(t,h,s),l(t,Gt,s),r(G,t,s),l(t,_t,s),l(t,d,s),jt(d,ut),jt(d,ds),jt(d,_),jt(d,ys),r(x,d,null),l(t,xt,s),l(t,E,s),l(t,Et,s),r(W,t,s),l(t,Wt,s),l(t,V,s),l(t,Vt,s),r($,t,s),l(t,$t,s),l(t,Q,s),l(t,Qt,s),r(S,t,s),l(t,St,s),l(t,H,s),l(t,Ht,s),r(A,t,s),l(t,At,s),l(t,q,s),l(t,qt,s),l(t,F,s),l(t,Ft,s),r(X,t,s),l(t,Xt,s),r(R,t,s),l(t,Rt,s),l(t,N,s),l(t,Nt,s),r(z,t,s),l(t,zt,s),l(t,L,s),l(t,Lt,s),l(t,Y,s),l(t,Yt,s),r(P,t,s),l(t,Pt,s),l(t,K,s),l(t,Kt,s),r(D,t,s),l(t,Dt,s),l(t,O,s),l(t,Ot,s),l(t,j,s),l(t,ts,s),l(t,tt,s),l(t,ss,s),r(st,t,s),l(t,es,s),l(t,et,s),l(t,ls,s),l(t,lt,s),l(t,ns,s),l(t,nt,s),l(t,as,s),l(t,at,s),l(t,os,s),r(ot,t,s),l(t,ps,s),l(t,pt,s),l(t,is,s),l(t,it,s),l(t,ws,s),r(wt,t,s),l(t,cs,s),l(t,ct,s),l(t,rs,s),l(t,rt,s),l(t,Ms,s),r(Mt,t,s),l(t,us,s),l(t,yt,s),ms=!0},p:Os,i(t){ms||(M(f.$$.fragment,t),M(U.$$.fragment,t),M(Z.$$.fragment,t),M(G.$$.fragment,t),M(x.$$.fragment,t),M(W.$$.fragment,t),M($.$$.fragment,t),M(S.$$.fragment,t),M(A.$$.fragment,t),M(X.$$.fragment,t),M(R.$$.fragment,t),M(z.$$.fragment,t),M(P.$$.fragment,t),M(D.$$.fragment,t),M(st.$$.fragment,t),M(ot.$$.fragment,t),M(wt.$$.fragment,t),M(Mt.$$.fragment,t),ms=!0)},o(t){u(f.$$.fragment,t),u(U.$$.fragment,t),u(Z.$$.fragment,t),u(G.$$.fragment,t),u(x.$$.fragment,t),u(W.$$.fragment,t),u($.$$.fragment,t),u(S.$$.fragment,t),u(A.$$.fragment,t),u(X.$$.fragment,t),u(R.$$.fragment,t),u(z.$$.fragment,t),u(P.$$.fragment,t),u(D.$$.fragment,t),u(st.$$.fragment,t),u(ot.$$.fragment,t),u(wt.$$.fragment,t),u(Mt.$$.fragment,t),ms=!1},d(t){t&&(e(Jt),e(dt),e(Tt),e(ft),e(Ut),e(b),e(bt),e(C),e(Ct),e(I),e(It),e(g),e(gt),e(k),e(kt),e(B),e(Bt),e(v),e(vt),e(Zt),e(h),e(Gt),e(_t),e(d),e(xt),e(E),e(Et),e(Wt),e(V),e(Vt),e($t),e(Q),e(Qt),e(St),e(H),e(Ht),e(At),e(q),e(qt),e(F),e(Ft),e(Xt),e(Rt),e(N),e(Nt),e(zt),e(L),e(Lt),e(Y),e(Yt),e(Pt),e(K),e(Kt),e(Dt),e(O),e(Ot),e(j),e(ts),e(tt),e(ss),e(es),e(et),e(ls),e(lt),e(ns),e(nt),e(as),e(at),e(os),e(ps),e(pt),e(is),e(it),e(ws),e(cs),e(ct),e(rs),e(rt),e(Ms),e(us),e(yt)),e(y),m(f,t),m(U,t),m(Z,t),m(G,t),m(x),m(W,t),m($,t),m(S,t),m(A,t),m(X,t),m(R,t),m(z,t),m(P,t),m(D,t),m(st,t),m(ot,t),m(wt,t),m(Mt,t)}}}const pe='{"title":"Creating agentic workflows in LlamaIndex","local":"creating-agentic-workflows-in-llamaindex","sections":[{"title":"Creating Workflows","local":"creating-workflows","sections":[{"title":"Basic Workflow Creation","local":"basic-workflow-creation","sections":[],"depth":3},{"title":"Connecting Multiple Steps","local":"connecting-multiple-steps","sections":[],"depth":3},{"title":"Loops and Branches","local":"loops-and-branches","sections":[],"depth":3},{"title":"Drawing Workflows","local":"drawing-workflows","sections":[],"depth":3},{"title":"State Management","local":"state-management","sections":[],"depth":3}],"depth":2},{"title":"Automating workflows with Multi-Agent Workflows","local":"automating-workflows-with-multi-agent-workflows","sections":[],"depth":2}],"depth":1}';function ie(js){return te(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class de extends se{constructor(y){super(),ee(this,y,ie,oe,Ds,{})}}export{de as component};
